#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
/*
 * FlowTests.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Unit tests for the flow language and libraries

#include "flow/Arena.h"
#include "flow/ProtocolVersion.h"
#include "flow/UnitTest.h"
#include "flow/DeterministicRandom.h"
#include "flow/IThreadPool.h"
#include "flow/WriteOnlySet.h"
#include "fdbrpc/fdbrpc.h"
#include "flow/IAsyncFile.h"
#include "flow/TLSConfig.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

void forceLinkFlowTests() {}

constexpr int firstLine = __LINE__;
															#line 39 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase37()
															#line 37 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase37Actor>
															#line 37 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase37ActorState {
															#line 46 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 37 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase37ActorState(UnitTestParameters const& params) 
															#line 37 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 37 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 53 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase37", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase37ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase37", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 38 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			;
															#line 68 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase37ActorState();
		static_cast<FlowTestCase37Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 51 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(__FILE__sr.endsWith("FlowTests.actor.cpp"_sr));
															#line 52 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase37Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase37ActorState(); static_cast<FlowTestCase37Actor*>(this)->destroy(); return 0; }
															#line 93 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase37Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase37ActorState();
		static_cast<FlowTestCase37Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 40 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(__LINE__ == firstLine + 4);
															#line 41 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>(Void());
															#line 41 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase37Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase37Actor*>(this)->actor_wait_state = 1;
															#line 41 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase37Actor, 0, Void >*>(static_cast<FlowTestCase37Actor*>(this)));
															#line 122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 45 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(__LINE__ == firstLine + 9);
															#line 46 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = Future<Void>(Void());
															#line 46 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase37Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase37Actor*>(this)->actor_wait_state = 2;
															#line 46 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase37Actor, 1, Void >*>(static_cast<FlowTestCase37Actor*>(this)));
															#line 166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 42 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(__LINE__ == firstLine + 6);
															#line 43 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		return a_body1loopBody1Catch1(success(), loopDepth);
															#line 183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 42 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(__LINE__ == firstLine + 6);
															#line 43 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		return a_body1loopBody1Catch1(success(), loopDepth);
															#line 193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase37Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase37Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase37Actor*>(this)->ActorCallback< FlowTestCase37Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase37Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase37", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase37Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase37", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase37Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase37", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase37Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase37", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase37Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase37", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase37Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase37", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 47 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(__LINE__ == firstLine + 11);
															#line 276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 47 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(__LINE__ == firstLine + 11);
															#line 285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase37Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase37Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase37Actor*>(this)->ActorCallback< FlowTestCase37Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase37Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase37", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase37Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase37", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase37Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase37", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase37Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase37", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase37Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase37", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase37Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase37", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 37 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase37()
															#line 37 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase37Actor final : public Actor<Void>, public ActorCallback< FlowTestCase37Actor, 0, Void >, public ActorCallback< FlowTestCase37Actor, 1, Void >, public FastAllocated<FlowTestCase37Actor>, public FlowTestCase37ActorState<FlowTestCase37Actor> {
															#line 372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase37Actor>::operator new;
	using FastAllocated<FlowTestCase37Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1027715152444578304UL, 4755240752071000320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase37Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase37Actor, 1, Void >;
															#line 37 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase37Actor(UnitTestParameters const& params) 
															#line 390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase37ActorState<FlowTestCase37Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase37", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15909451985543611648UL, 10979124988721873664UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase37Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase37");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase37", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase37Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase37Actor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 37 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase37( UnitTestParameters const& params ) {
															#line 37 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase37Actor(params));
															#line 424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase37, "/flow/actorcompiler/lineNumbers")

#line 54 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase55()
															#line 55 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase55Actor>
															#line 55 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase55ActorState {
															#line 437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 55 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase55ActorState(UnitTestParameters const& params) 
															#line 55 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 55 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase55", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase55ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase55", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 56 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (FLOW_KNOBS->MAX_BUGGIFIED_DELAY == 0)
															#line 459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 57 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (!static_cast<FlowTestCase55Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase55ActorState(); static_cast<FlowTestCase55Actor*>(this)->destroy(); return 0; }
															#line 463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				new (&static_cast<FlowTestCase55Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase55ActorState();
				static_cast<FlowTestCase55Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 59 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			;
															#line 471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase55ActorState();
		static_cast<FlowTestCase55Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 60 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		x = deterministicRandom()->random01();
															#line 61 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		last = 0;
															#line 62 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		f1 = map(delay(x), [last = &last](const Void&) { *last = 1; return Void(); });
															#line 66 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		f2 = map(delay(x), [last = &last](const Void&) { *last = 2; return Void(); });
															#line 70 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_0 = f1 && f2;
															#line 70 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase55Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FlowTestCase55Actor*>(this)->actor_wait_state = 1;
															#line 70 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase55Actor, 0, Void >*>(static_cast<FlowTestCase55Actor*>(this)));
															#line 516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 71 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (last == 1)
															#line 525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 72 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			CODE_PROBE(true, "Delays can become ready out of order", probe::decoration::rare);
															#line 73 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase55Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase55ActorState(); static_cast<FlowTestCase55Actor*>(this)->destroy(); return 0; }
															#line 531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase55Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase55ActorState();
			static_cast<FlowTestCase55Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 71 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (last == 1)
															#line 545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 72 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			CODE_PROBE(true, "Delays can become ready out of order", probe::decoration::rare);
															#line 73 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase55Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase55ActorState(); static_cast<FlowTestCase55Actor*>(this)->destroy(); return 0; }
															#line 551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase55Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase55ActorState();
			static_cast<FlowTestCase55Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase55Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase55Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase55Actor*>(this)->ActorCallback< FlowTestCase55Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase55Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase55", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase55Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase55", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase55Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase55", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase55Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase55", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase55Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase55", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase55Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase55", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 55 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 60 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	double x;
															#line 61 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int last;
															#line 62 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f1;
															#line 66 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f2;
															#line 646 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase55()
															#line 55 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase55Actor final : public Actor<Void>, public ActorCallback< FlowTestCase55Actor, 0, Void >, public FastAllocated<FlowTestCase55Actor>, public FlowTestCase55ActorState<FlowTestCase55Actor> {
															#line 651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase55Actor>::operator new;
	using FastAllocated<FlowTestCase55Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7097495853416611072UL, 4832491776135826944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase55Actor, 0, Void >;
															#line 55 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase55Actor(UnitTestParameters const& params) 
															#line 668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase55ActorState<FlowTestCase55Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase55", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5304549216287031296UL, 16613188996955929344UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase55Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase55");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase55", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase55Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 55 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase55( UnitTestParameters const& params ) {
															#line 55 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase55Actor(params));
															#line 701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase55, "/flow/buggifiedDelay")

#line 77 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

template <class T, class Func, class ErrFunc, class CallbackType>
class LambdaCallback final : public CallbackType, public FastAllocated<LambdaCallback<T, Func, ErrFunc, CallbackType>> {
	Func func;
	ErrFunc errFunc;

	void fire(T const& t) override {
		CallbackType::remove();
		func(t);
		delete this;
	}
	void fire(T&& t) override {
		CallbackType::remove();
		func(std::move(t));
		delete this;
	}
	void error(Error e) override {
		CallbackType::remove();
		errFunc(e);
		delete this;
	}

public:
	LambdaCallback(Func&& f, ErrFunc&& e) : func(std::move(f)), errFunc(std::move(e)) {}
};

template <class T, class Func, class ErrFunc>
void onReady(Future<T>&& f, Func&& func, ErrFunc&& errFunc) {
	if (f.isReady()) {
		if (f.isError())
			errFunc(f.getError());
		else
			func(f.get());
	} else
		f.addCallbackAndClear(new LambdaCallback<T, Func, ErrFunc, Callback<T>>(std::move(func), std::move(errFunc)));
}

template <class T, class Func, class ErrFunc>
void onReady(FutureStream<T>&& f, Func&& func, ErrFunc&& errFunc) {
	if (f.isReady()) {
		if (f.isError())
			errFunc(f.getError());
		else
			func(f.pop());
	} else
		f.addCallbackAndClear(
		    new LambdaCallback<T, Func, ErrFunc, SingleCallback<T>>(std::move(func), std::move(errFunc)));
}

															#line 755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via emptyVoidActor()
															#line 126 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class EmptyVoidActorActor>
															#line 126 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class EmptyVoidActorActorState {
															#line 762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 126 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	EmptyVoidActorActorState() 
															#line 126 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		fdb_probe_actor_create("emptyVoidActor", reinterpret_cast<unsigned long>(this));

	}
	~EmptyVoidActorActorState() 
	{
		fdb_probe_actor_destroy("emptyVoidActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<EmptyVoidActorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 126 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		delete static_cast<EmptyVoidActorActor*>(this);
															#line 801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		return 0;

		return loopDepth;
	}
};
// This generated class is to be used only via emptyVoidActor()
															#line 126 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class EmptyVoidActorActor final : public Actor<void>, public FastAllocated<EmptyVoidActorActor>, public EmptyVoidActorActorState<EmptyVoidActorActor> {
															#line 810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<EmptyVoidActorActor>::operator new;
	using FastAllocated<EmptyVoidActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7899822234130268160UL, 6784125238288202496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
															#line 126 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	EmptyVoidActorActor() 
															#line 826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<void>(),
		   EmptyVoidActorActorState<EmptyVoidActorActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("emptyVoidActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3992031095763062272UL, 6056561321581212416UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyVoidActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("emptyVoidActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("emptyVoidActor", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 126 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static void emptyVoidActor(  ) {
															#line 126 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	new EmptyVoidActorActor();
															#line 850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 127 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via emptyActor()
															#line 128 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class EmptyActorActor>
															#line 128 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class EmptyActorActorState {
															#line 862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 128 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	EmptyActorActorState() 
															#line 128 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		fdb_probe_actor_create("emptyActor", reinterpret_cast<unsigned long>(this));

	}
	~EmptyActorActorState() 
	{
		fdb_probe_actor_destroy("emptyActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 129 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<EmptyActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EmptyActorActorState(); static_cast<EmptyActorActor*>(this)->destroy(); return 0; }
															#line 882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<EmptyActorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~EmptyActorActorState();
			static_cast<EmptyActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EmptyActorActorState();
		static_cast<EmptyActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
};
// This generated class is to be used only via emptyActor()
															#line 128 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class EmptyActorActor final : public Actor<Void>, public FastAllocated<EmptyActorActor>, public EmptyActorActorState<EmptyActorActor> {
															#line 908 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<EmptyActorActor>::operator new;
	using FastAllocated<EmptyActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2920086819709142528UL, 13531183154542249216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 128 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	EmptyActorActor() 
															#line 924 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   EmptyActorActorState<EmptyActorActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("emptyActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15861535729408492288UL, 4290300210743134720UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("emptyActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("emptyActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 128 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> emptyActor(  ) {
															#line 128 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new EmptyActorActor());
															#line 956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 131 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via oneWaitVoidActor()
															#line 132 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class OneWaitVoidActorActor>
															#line 132 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class OneWaitVoidActorActorState {
															#line 968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 132 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	OneWaitVoidActorActorState(Future<Void> const& f) 
															#line 132 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 132 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : f(f)
															#line 975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("oneWaitVoidActor", reinterpret_cast<unsigned long>(this));

	}
	~OneWaitVoidActorActorState() 
	{
		fdb_probe_actor_destroy("oneWaitVoidActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 133 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = f;
															#line 133 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			static_cast<OneWaitVoidActorActor*>(this)->actor_wait_state = 1;
															#line 133 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OneWaitVoidActorActor, 0, Void >*>(static_cast<OneWaitVoidActorActor*>(this)));
															#line 996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<OneWaitVoidActorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OneWaitVoidActorActor*>(this)->actor_wait_state > 0) static_cast<OneWaitVoidActorActor*>(this)->actor_wait_state = 0;
		static_cast<OneWaitVoidActorActor*>(this)->ActorCallback< OneWaitVoidActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OneWaitVoidActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitVoidActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OneWaitVoidActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitVoidActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OneWaitVoidActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitVoidActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 132 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		delete static_cast<OneWaitVoidActorActor*>(this);
															#line 1105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 132 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f;
															#line 1112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via oneWaitVoidActor()
															#line 132 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class OneWaitVoidActorActor final : public Actor<void>, public ActorCallback< OneWaitVoidActorActor, 0, Void >, public FastAllocated<OneWaitVoidActorActor>, public OneWaitVoidActorActorState<OneWaitVoidActorActor> {
															#line 1117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<OneWaitVoidActorActor>::operator new;
	using FastAllocated<OneWaitVoidActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9617691424128401920UL, 235029873565689344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< OneWaitVoidActorActor, 0, Void >;
															#line 132 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	OneWaitVoidActorActor(Future<Void> const& f) 
															#line 1134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<void>(),
		   OneWaitVoidActorActorState<OneWaitVoidActorActor>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4959834572396190720UL, 15120160138639133440UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitVoidActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("oneWaitVoidActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("oneWaitVoidActor", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 132 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static void oneWaitVoidActor( Future<Void> const& f ) {
															#line 132 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	new OneWaitVoidActorActor(f);
															#line 1158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 135 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 1163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via oneWaitActor()
															#line 136 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class OneWaitActorActor>
															#line 136 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class OneWaitActorActorState {
															#line 1170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 136 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	OneWaitActorActorState(Future<Void> const& f) 
															#line 136 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 136 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : f(f)
															#line 1177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("oneWaitActor", reinterpret_cast<unsigned long>(this));

	}
	~OneWaitActorActorState() 
	{
		fdb_probe_actor_destroy("oneWaitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 137 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = f;
															#line 137 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<OneWaitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<OneWaitActorActor*>(this)->actor_wait_state = 1;
															#line 137 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OneWaitActorActor, 0, Void >*>(static_cast<OneWaitActorActor*>(this)));
															#line 1199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OneWaitActorActorState();
		static_cast<OneWaitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 138 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<OneWaitActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OneWaitActorActorState(); static_cast<OneWaitActorActor*>(this)->destroy(); return 0; }
															#line 1222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<OneWaitActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OneWaitActorActorState();
		static_cast<OneWaitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 138 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<OneWaitActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OneWaitActorActorState(); static_cast<OneWaitActorActor*>(this)->destroy(); return 0; }
															#line 1234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<OneWaitActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OneWaitActorActorState();
		static_cast<OneWaitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OneWaitActorActor*>(this)->actor_wait_state > 0) static_cast<OneWaitActorActor*>(this)->actor_wait_state = 0;
		static_cast<OneWaitActorActor*>(this)->ActorCallback< OneWaitActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OneWaitActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OneWaitActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OneWaitActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("oneWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 136 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f;
															#line 1319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via oneWaitActor()
															#line 136 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class OneWaitActorActor final : public Actor<Void>, public ActorCallback< OneWaitActorActor, 0, Void >, public FastAllocated<OneWaitActorActor>, public OneWaitActorActorState<OneWaitActorActor> {
															#line 1324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<OneWaitActorActor>::operator new;
	using FastAllocated<OneWaitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(627766393608460288UL, 17589751604159994880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OneWaitActorActor, 0, Void >;
															#line 136 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	OneWaitActorActor(Future<Void> const& f) 
															#line 1341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   OneWaitActorActorState<OneWaitActorActor>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("oneWaitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14706628315667835136UL, 3183390146889395968UL);
		ActorExecutionContextHelper __helper(static_cast<OneWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("oneWaitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("oneWaitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OneWaitActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 136 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> oneWaitActor( Future<Void> const& f ) {
															#line 136 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new OneWaitActorActor(f));
															#line 1374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 140 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

Future<Void> g_cheese;
															#line 1380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via cheeseWaitActor()
															#line 142 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class CheeseWaitActorActor>
															#line 142 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class CheeseWaitActorActorState {
															#line 1387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 142 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	CheeseWaitActorActorState() 
															#line 142 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 1393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		fdb_probe_actor_create("cheeseWaitActor", reinterpret_cast<unsigned long>(this));

	}
	~CheeseWaitActorActorState() 
	{
		fdb_probe_actor_destroy("cheeseWaitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 143 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = g_cheese;
															#line 143 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<CheeseWaitActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheeseWaitActorActor*>(this)->actor_wait_state = 1;
															#line 143 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheeseWaitActorActor, 0, Void >*>(static_cast<CheeseWaitActorActor*>(this)));
															#line 1414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheeseWaitActorActorState();
		static_cast<CheeseWaitActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 144 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<CheeseWaitActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheeseWaitActorActorState(); static_cast<CheeseWaitActorActor*>(this)->destroy(); return 0; }
															#line 1437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<CheeseWaitActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheeseWaitActorActorState();
		static_cast<CheeseWaitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 144 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<CheeseWaitActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheeseWaitActorActorState(); static_cast<CheeseWaitActorActor*>(this)->destroy(); return 0; }
															#line 1449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<CheeseWaitActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheeseWaitActorActorState();
		static_cast<CheeseWaitActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheeseWaitActorActor*>(this)->actor_wait_state > 0) static_cast<CheeseWaitActorActor*>(this)->actor_wait_state = 0;
		static_cast<CheeseWaitActorActor*>(this)->ActorCallback< CheeseWaitActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheeseWaitActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheeseWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheeseWaitActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheeseWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheeseWaitActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheeseWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cheeseWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
};
// This generated class is to be used only via cheeseWaitActor()
															#line 142 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class CheeseWaitActorActor final : public Actor<Void>, public ActorCallback< CheeseWaitActorActor, 0, Void >, public FastAllocated<CheeseWaitActorActor>, public CheeseWaitActorActorState<CheeseWaitActorActor> {
															#line 1536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<CheeseWaitActorActor>::operator new;
	using FastAllocated<CheeseWaitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13659347178487791616UL, 13384145006002885120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheeseWaitActorActor, 0, Void >;
															#line 142 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	CheeseWaitActorActor() 
															#line 1553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   CheeseWaitActorActorState<CheeseWaitActorActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cheeseWaitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11924659823367017728UL, 9190457517789878528UL);
		ActorExecutionContextHelper __helper(static_cast<CheeseWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cheeseWaitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cheeseWaitActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheeseWaitActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 142 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> cheeseWaitActor(  ) {
															#line 142 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new CheeseWaitActorActor());
															#line 1586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 146 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

size_t cheeseWaitActorSize() {
#ifndef OPEN_FOR_IDE
	return sizeof(CheeseWaitActorActor);
#else
	return 0ul;
#endif
}

															#line 1599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via trivialVoidActor()
															#line 155 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class TrivialVoidActorActor>
															#line 155 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TrivialVoidActorActorState {
															#line 1606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 155 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TrivialVoidActorActorState(int* const& result) 
															#line 155 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 155 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : result(result)
															#line 1613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("trivialVoidActor", reinterpret_cast<unsigned long>(this));

	}
	~TrivialVoidActorActorState() 
	{
		fdb_probe_actor_destroy("trivialVoidActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 156 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			*result = 1;
															#line 1628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<TrivialVoidActorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 155 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		delete static_cast<TrivialVoidActorActor*>(this);
															#line 1650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 155 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int* result;
															#line 1657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via trivialVoidActor()
															#line 155 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TrivialVoidActorActor final : public Actor<void>, public FastAllocated<TrivialVoidActorActor>, public TrivialVoidActorActorState<TrivialVoidActorActor> {
															#line 1662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<TrivialVoidActorActor>::operator new;
	using FastAllocated<TrivialVoidActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10918174400160236800UL, 4372888865921593600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
															#line 155 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TrivialVoidActorActor(int* const& result) 
															#line 1678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<void>(),
		   TrivialVoidActorActorState<TrivialVoidActorActor>(result),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trivialVoidActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15340033039238992128UL, 6049743622380387072UL);
		ActorExecutionContextHelper __helper(static_cast<TrivialVoidActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trivialVoidActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trivialVoidActor", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 155 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static void trivialVoidActor( int* const& result ) {
															#line 155 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	new TrivialVoidActorActor(result);
															#line 1702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 158 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 1707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via return42Actor()
															#line 159 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Return42ActorActor>
															#line 159 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Return42ActorActorState {
															#line 1714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 159 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Return42ActorActorState() 
															#line 159 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 1720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		fdb_probe_actor_create("return42Actor", reinterpret_cast<unsigned long>(this));

	}
	~Return42ActorActorState() 
	{
		fdb_probe_actor_destroy("return42Actor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 160 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<Return42ActorActor*>(this)->SAV<int>::futures) { (void)(42); this->~Return42ActorActorState(); static_cast<Return42ActorActor*>(this)->destroy(); return 0; }
															#line 1734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<Return42ActorActor*>(this)->SAV< int >::value()) int(42);
			this->~Return42ActorActorState();
			static_cast<Return42ActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Return42ActorActorState();
		static_cast<Return42ActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
};
// This generated class is to be used only via return42Actor()
															#line 159 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Return42ActorActor final : public Actor<int>, public FastAllocated<Return42ActorActor>, public Return42ActorActorState<Return42ActorActor> {
															#line 1760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<Return42ActorActor>::operator new;
	using FastAllocated<Return42ActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16786633292860737536UL, 13191118910828449792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 159 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Return42ActorActor() 
															#line 1776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   Return42ActorActorState<Return42ActorActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("return42Actor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10940871408049559296UL, 4095833238457056256UL);
		ActorExecutionContextHelper __helper(static_cast<Return42ActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("return42Actor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("return42Actor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 159 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<int> return42Actor(  ) {
															#line 159 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Return42ActorActor());
															#line 1808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 162 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 1813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via voidWaitActor()
															#line 163 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class VoidWaitActorActor>
															#line 163 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class VoidWaitActorActorState {
															#line 1820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 163 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	VoidWaitActorActorState(Future<int> const& in,int* const& result) 
															#line 163 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 163 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : in(in),
															#line 163 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   result(result)
															#line 1829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("voidWaitActor", reinterpret_cast<unsigned long>(this));

	}
	~VoidWaitActorActorState() 
	{
		fdb_probe_actor_destroy("voidWaitActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 164 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<int> __when_expr_0 = in;
															#line 164 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			static_cast<VoidWaitActorActor*>(this)->actor_wait_state = 1;
															#line 164 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VoidWaitActorActor, 0, int >*>(static_cast<VoidWaitActorActor*>(this)));
															#line 1850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<VoidWaitActorActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& i,int loopDepth) 
	{
															#line 165 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		*result = i;
															#line 1872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(int && i,int loopDepth) 
	{
															#line 165 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		*result = i;
															#line 1881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int const& i,int loopDepth) 
	{
		loopDepth = a_body1cont1(i, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && i,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(i), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VoidWaitActorActor*>(this)->actor_wait_state > 0) static_cast<VoidWaitActorActor*>(this)->actor_wait_state = 0;
		static_cast<VoidWaitActorActor*>(this)->ActorCallback< VoidWaitActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< VoidWaitActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VoidWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VoidWaitActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VoidWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VoidWaitActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VoidWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("voidWaitActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 163 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		delete static_cast<VoidWaitActorActor*>(this);
															#line 1965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 163 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<int> in;
															#line 163 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int* result;
															#line 1974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via voidWaitActor()
															#line 163 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class VoidWaitActorActor final : public Actor<void>, public ActorCallback< VoidWaitActorActor, 0, int >, public FastAllocated<VoidWaitActorActor>, public VoidWaitActorActorState<VoidWaitActorActor> {
															#line 1979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<VoidWaitActorActor>::operator new;
	using FastAllocated<VoidWaitActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13273301813934092032UL, 5818713324029087744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< VoidWaitActorActor, 0, int >;
															#line 163 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	VoidWaitActorActor(Future<int> const& in,int* const& result) 
															#line 1996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<void>(),
		   VoidWaitActorActorState<VoidWaitActorActor>(in, result),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("voidWaitActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4523678045317434112UL, 607490058614652416UL);
		ActorExecutionContextHelper __helper(static_cast<VoidWaitActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("voidWaitActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("voidWaitActor", reinterpret_cast<unsigned long>(this), -1);

	}
};
} // namespace
															#line 163 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static void voidWaitActor( Future<int> const& in, int* const& result ) {
															#line 163 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	new VoidWaitActorActor(in, result);
															#line 2020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 167 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 2025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via addOneActor()
															#line 168 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class AddOneActorActor>
															#line 168 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class AddOneActorActorState {
															#line 2032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 168 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	AddOneActorActorState(Future<int> const& in) 
															#line 168 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 168 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : in(in)
															#line 2039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("addOneActor", reinterpret_cast<unsigned long>(this));

	}
	~AddOneActorActorState() 
	{
		fdb_probe_actor_destroy("addOneActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 169 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<int> __when_expr_0 = in;
															#line 169 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<AddOneActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddOneActorActor*>(this)->actor_wait_state = 1;
															#line 169 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddOneActorActor, 0, int >*>(static_cast<AddOneActorActor*>(this)));
															#line 2061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddOneActorActorState();
		static_cast<AddOneActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& i,int loopDepth) 
	{
															#line 170 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<AddOneActorActor*>(this)->SAV<int>::futures) { (void)(i + 1); this->~AddOneActorActorState(); static_cast<AddOneActorActor*>(this)->destroy(); return 0; }
															#line 2084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<AddOneActorActor*>(this)->SAV< int >::value()) int(i + 1);
		this->~AddOneActorActorState();
		static_cast<AddOneActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(int && i,int loopDepth) 
	{
															#line 170 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<AddOneActorActor*>(this)->SAV<int>::futures) { (void)(i + 1); this->~AddOneActorActorState(); static_cast<AddOneActorActor*>(this)->destroy(); return 0; }
															#line 2096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<AddOneActorActor*>(this)->SAV< int >::value()) int(i + 1);
		this->~AddOneActorActorState();
		static_cast<AddOneActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& i,int loopDepth) 
	{
		loopDepth = a_body1cont1(i, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && i,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(i), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddOneActorActor*>(this)->actor_wait_state > 0) static_cast<AddOneActorActor*>(this)->actor_wait_state = 0;
		static_cast<AddOneActorActor*>(this)->ActorCallback< AddOneActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< AddOneActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("addOneActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddOneActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("addOneActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddOneActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("addOneActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 168 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<int> in;
															#line 2181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via addOneActor()
															#line 168 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class AddOneActorActor final : public Actor<int>, public ActorCallback< AddOneActorActor, 0, int >, public FastAllocated<AddOneActorActor>, public AddOneActorActorState<AddOneActorActor> {
															#line 2186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<AddOneActorActor>::operator new;
	using FastAllocated<AddOneActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2345297967852593664UL, 4877880989841303808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddOneActorActor, 0, int >;
															#line 168 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	AddOneActorActor(Future<int> const& in) 
															#line 2203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   AddOneActorActorState<AddOneActorActor>(in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addOneActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16535816285787488512UL, 16973372841591770112UL);
		ActorExecutionContextHelper __helper(static_cast<AddOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addOneActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addOneActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddOneActorActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 168 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<int> addOneActor( Future<int> const& in ) {
															#line 168 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new AddOneActorActor(in));
															#line 2236 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 172 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 2241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via chooseTwoActor()
															#line 173 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class ChooseTwoActorActor>
															#line 173 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ChooseTwoActorActorState {
															#line 2248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 173 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ChooseTwoActorActorState(Future<Void> const& f,Future<Void> const& g) 
															#line 173 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 173 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : f(f),
															#line 173 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   g(g)
															#line 2257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("chooseTwoActor", reinterpret_cast<unsigned long>(this));

	}
	~ChooseTwoActorActorState() 
	{
		fdb_probe_actor_destroy("chooseTwoActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 175 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = f;
															#line 174 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<ChooseTwoActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 176 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = g;
															#line 2278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<ChooseTwoActorActor*>(this)->actor_wait_state = 1;
															#line 175 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChooseTwoActorActor, 0, Void >*>(static_cast<ChooseTwoActorActor*>(this)));
															#line 176 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChooseTwoActorActor, 1, Void >*>(static_cast<ChooseTwoActorActor*>(this)));
															#line 2285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChooseTwoActorActorState();
		static_cast<ChooseTwoActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 178 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<ChooseTwoActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChooseTwoActorActorState(); static_cast<ChooseTwoActorActor*>(this)->destroy(); return 0; }
															#line 2308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<ChooseTwoActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChooseTwoActorActorState();
		static_cast<ChooseTwoActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChooseTwoActorActor*>(this)->actor_wait_state > 0) static_cast<ChooseTwoActorActor*>(this)->actor_wait_state = 0;
		static_cast<ChooseTwoActorActor*>(this)->ActorCallback< ChooseTwoActorActor, 0, Void >::remove();
		static_cast<ChooseTwoActorActor*>(this)->ActorCallback< ChooseTwoActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChooseTwoActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTwoActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChooseTwoActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTwoActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChooseTwoActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTwoActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChooseTwoActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTwoActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChooseTwoActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTwoActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChooseTwoActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTwoActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 173 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f;
															#line 173 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> g;
															#line 2465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via chooseTwoActor()
															#line 173 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ChooseTwoActorActor final : public Actor<Void>, public ActorCallback< ChooseTwoActorActor, 0, Void >, public ActorCallback< ChooseTwoActorActor, 1, Void >, public FastAllocated<ChooseTwoActorActor>, public ChooseTwoActorActorState<ChooseTwoActorActor> {
															#line 2470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<ChooseTwoActorActor>::operator new;
	using FastAllocated<ChooseTwoActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14812904290913201920UL, 6049851348337162240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChooseTwoActorActor, 0, Void >;
friend struct ActorCallback< ChooseTwoActorActor, 1, Void >;
															#line 173 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ChooseTwoActorActor(Future<Void> const& f,Future<Void> const& g) 
															#line 2488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   ChooseTwoActorActorState<ChooseTwoActorActor>(f, g),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("chooseTwoActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1758439379909727232UL, 9229871646340306944UL);
		ActorExecutionContextHelper __helper(static_cast<ChooseTwoActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("chooseTwoActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("chooseTwoActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChooseTwoActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 173 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> chooseTwoActor( Future<Void> const& f, Future<Void> const& g ) {
															#line 173 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new ChooseTwoActorActor(f, g));
															#line 2521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 180 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 2526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via consumeOneActor()
															#line 181 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class ConsumeOneActorActor>
															#line 181 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ConsumeOneActorActorState {
															#line 2533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 181 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ConsumeOneActorActorState(FutureStream<int> const& in) 
															#line 181 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 181 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : in(in)
															#line 2540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("consumeOneActor", reinterpret_cast<unsigned long>(this));

	}
	~ConsumeOneActorActorState() 
	{
		fdb_probe_actor_destroy("consumeOneActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 182 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			FutureStream<int> __when_expr_0 = in;
															#line 182 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<ConsumeOneActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<ConsumeOneActorActor*>(this)->actor_wait_state = 1;
															#line 182 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ConsumeOneActorActor, 0, int >*>(static_cast<ConsumeOneActorActor*>(this)));
															#line 2562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsumeOneActorActorState();
		static_cast<ConsumeOneActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& i,int loopDepth) 
	{
															#line 183 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<ConsumeOneActorActor*>(this)->SAV<int>::futures) { (void)(i); this->~ConsumeOneActorActorState(); static_cast<ConsumeOneActorActor*>(this)->destroy(); return 0; }
															#line 2585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<ConsumeOneActorActor*>(this)->SAV< int >::value()) int(i);
		this->~ConsumeOneActorActorState();
		static_cast<ConsumeOneActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(int && i,int loopDepth) 
	{
															#line 183 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<ConsumeOneActorActor*>(this)->SAV<int>::futures) { (void)(i); this->~ConsumeOneActorActorState(); static_cast<ConsumeOneActorActor*>(this)->destroy(); return 0; }
															#line 2597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<ConsumeOneActorActor*>(this)->SAV< int >::value()) int(i);
		this->~ConsumeOneActorActorState();
		static_cast<ConsumeOneActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& i,int loopDepth) 
	{
		loopDepth = a_body1cont1(i, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && i,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(i), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsumeOneActorActor*>(this)->actor_wait_state > 0) static_cast<ConsumeOneActorActor*>(this)->actor_wait_state = 0;
		static_cast<ConsumeOneActorActor*>(this)->ActorSingleCallback< ConsumeOneActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ConsumeOneActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ConsumeOneActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ConsumeOneActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeOneActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 181 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FutureStream<int> in;
															#line 2682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via consumeOneActor()
															#line 181 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ConsumeOneActorActor final : public Actor<int>, public ActorSingleCallback< ConsumeOneActorActor, 0, int >, public FastAllocated<ConsumeOneActorActor>, public ConsumeOneActorActorState<ConsumeOneActorActor> {
															#line 2687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<ConsumeOneActorActor>::operator new;
	using FastAllocated<ConsumeOneActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16914211488402407936UL, 16183039897237616128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ConsumeOneActorActor, 0, int >;
															#line 181 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ConsumeOneActorActor(FutureStream<int> const& in) 
															#line 2704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   ConsumeOneActorActorState<ConsumeOneActorActor>(in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consumeOneActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15463506707502989568UL, 14609495624834383104UL);
		ActorExecutionContextHelper __helper(static_cast<ConsumeOneActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consumeOneActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consumeOneActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ConsumeOneActorActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 181 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<int> consumeOneActor( FutureStream<int> const& in ) {
															#line 181 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new ConsumeOneActorActor(in));
															#line 2737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 185 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 2742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via sumActor()
															#line 186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class SumActorActor>
															#line 186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class SumActorActorState {
															#line 2749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	SumActorActorState(FutureStream<int> const& in) 
															#line 186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : in(in),
															#line 187 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   total(0)
															#line 2758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("sumActor", reinterpret_cast<unsigned long>(this));

	}
	~SumActorActorState() 
	{
		fdb_probe_actor_destroy("sumActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 189 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				;
															#line 2774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SumActorActorState();
		static_cast<SumActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 197 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<SumActorActor*>(this)->SAV<int>::futures) { (void)(total); this->~SumActorActorState(); static_cast<SumActorActor*>(this)->destroy(); return 0; }
															#line 2803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<SumActorActor*>(this)->SAV< int >::value()) int(std::move(total)); // state_var_RVO
		this->~SumActorActorState();
		static_cast<SumActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 194 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (e.code() != error_code_end_of_stream)
															#line 2816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 195 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		FutureStream<int> __when_expr_0 = in;
															#line 190 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<SumActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<SumActorActor*>(this)->actor_wait_state = 1;
															#line 190 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< SumActorActor, 0, int >*>(static_cast<SumActorActor*>(this)));
															#line 2850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int const& i,int loopDepth) 
	{
															#line 191 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		total += i;
															#line 2859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int && i,int loopDepth) 
	{
															#line 191 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		total += i;
															#line 2868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(int const& i,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(i, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int && i,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(i), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SumActorActor*>(this)->actor_wait_state > 0) static_cast<SumActorActor*>(this)->actor_wait_state = 0;
		static_cast<SumActorActor*>(this)->ActorSingleCallback< SumActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorSingleCallback< SumActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("sumActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SumActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sumActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< SumActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("sumActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SumActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sumActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< SumActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("sumActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SumActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sumActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FutureStream<int> in;
															#line 187 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int total;
															#line 2952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via sumActor()
															#line 186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class SumActorActor final : public Actor<int>, public ActorSingleCallback< SumActorActor, 0, int >, public FastAllocated<SumActorActor>, public SumActorActorState<SumActorActor> {
															#line 2957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<SumActorActor>::operator new;
	using FastAllocated<SumActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12363460548274124032UL, 7129204208257121280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< SumActorActor, 0, int >;
															#line 186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	SumActorActor(FutureStream<int> const& in) 
															#line 2974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   SumActorActorState<SumActorActor>(in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sumActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4376063734086770688UL, 18309943484118422272UL);
		ActorExecutionContextHelper __helper(static_cast<SumActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sumActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sumActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< SumActorActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<int> sumActor( FutureStream<int> const& in ) {
															#line 186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new SumActorActor(in));
															#line 3007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 199 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 3012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via templateActor()
															#line 200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class T, class TemplateActorActor>
															#line 200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TemplateActorActorState {
															#line 3019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TemplateActorActorState(T const& t) 
															#line 200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : t(t)
															#line 3026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("templateActor", reinterpret_cast<unsigned long>(this));

	}
	~TemplateActorActorState() 
	{
		fdb_probe_actor_destroy("templateActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 202 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<TemplateActorActor*>(this)->SAV<T>::futures) { (void)(t); this->~TemplateActorActorState(); static_cast<TemplateActorActor*>(this)->destroy(); return 0; }
															#line 3041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<TemplateActorActor*>(this)->SAV< T >::value()) T(std::move(t)); // state_var_RVO
			this->~TemplateActorActorState();
			static_cast<TemplateActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TemplateActorActorState();
		static_cast<TemplateActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	T t;
															#line 3065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via templateActor()
															#line 200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class T>
															#line 200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TemplateActorActor final : public Actor<T>, public FastAllocated<TemplateActorActor<T>>, public TemplateActorActorState<T, TemplateActorActor<T>> {
															#line 3072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<TemplateActorActor<T>>::operator new;
	using FastAllocated<TemplateActorActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2354903222810621440UL, 11274935265193858816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TemplateActorActor(T const& t) 
															#line 3088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<T>(),
		   TemplateActorActorState<T, TemplateActorActor<T>>(t),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("templateActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7976452068631605760UL, 5885036663855436800UL);
		ActorExecutionContextHelper __helper(static_cast<TemplateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("templateActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("templateActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class T>
															#line 200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<T> templateActor( T const& t ) {
															#line 200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<T>(new TemplateActorActor<T>(t));
															#line 3122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 204 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

static int destroy() {
	return 666;
}
															#line 3130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via testHygeine()
															#line 208 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class TestHygeineActor>
															#line 208 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestHygeineActorState {
															#line 3137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 208 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestHygeineActorState() 
															#line 208 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 3143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		fdb_probe_actor_create("testHygeine", reinterpret_cast<unsigned long>(this));

	}
	~TestHygeineActorState() 
	{
		fdb_probe_actor_destroy("testHygeine", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 209 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(destroy() == 666);
															#line 210 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<TestHygeineActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestHygeineActorState(); static_cast<TestHygeineActor*>(this)->destroy(); return 0; }
															#line 3159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<TestHygeineActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TestHygeineActorState();
			static_cast<TestHygeineActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestHygeineActorState();
		static_cast<TestHygeineActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
};
// This generated class is to be used only via testHygeine()
															#line 208 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestHygeineActor final : public Actor<Void>, public FastAllocated<TestHygeineActor>, public TestHygeineActorState<TestHygeineActor> {
															#line 3185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<TestHygeineActor>::operator new;
	using FastAllocated<TestHygeineActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10056535778361906176UL, 7615204995019008768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 208 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestHygeineActor() 
															#line 3201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestHygeineActorState<TestHygeineActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testHygeine", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1499353059620502784UL, 874173607718983936UL);
		ActorExecutionContextHelper __helper(static_cast<TestHygeineActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testHygeine");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testHygeine", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 208 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> testHygeine(  ) {
															#line 208 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new TestHygeineActor());
															#line 3233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 212 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

// bool expectActorCount(int x) { return actorCount == x; }
bool expectActorCount(int) {
	return true;
}

struct YieldMockNetwork final : INetwork, ReferenceCounted<YieldMockNetwork> {
	int ticks;
	Promise<Void> nextTick;
	int nextYield;
	INetwork* baseNetwork;

	flowGlobalType global(int id) const override { return baseNetwork->global(id); }
	void setGlobal(size_t id, flowGlobalType v) override {
		baseNetwork->setGlobal(id, v);
		return;
	}

	YieldMockNetwork() : ticks(0), nextYield(0) {
		baseNetwork = g_network;
		g_network = this;
	}
	~YieldMockNetwork() { g_network = baseNetwork; }

	void tick() {
		ticks++;
		Promise<Void> t;
		t.swap(nextTick);
		t.send(Void());
	}

	Future<class Void> delay(double seconds, TaskPriority taskID) override { return nextTick.getFuture(); }

	Future<class Void> orderedDelay(double seconds, TaskPriority taskID) override { return nextTick.getFuture(); }

	void _swiftEnqueue(void* task) override { abort(); }

	Future<class Void> yield(TaskPriority taskID) override {
		if (check_yield(taskID))
			return delay(0, taskID);
		return Void();
	}

	bool check_yield(TaskPriority taskID) override {
		if (nextYield > 0)
			--nextYield;
		return nextYield == 0;
	}

	// Delegate everything else.  TODO: Make a base class NetworkWrapper for delegating everything in INetwork
	TaskPriority getCurrentTask() const override { return baseNetwork->getCurrentTask(); }
	void setCurrentTask(TaskPriority taskID) override { baseNetwork->setCurrentTask(taskID); }
	double now() const override { return baseNetwork->now(); }
	double timer() override { return baseNetwork->timer(); }
	double timer_monotonic() override { return baseNetwork->timer_monotonic(); }
	void stop() override { return baseNetwork->stop(); }
	void addStopCallback(std::function<void()> fn) override {
		ASSERT(false);
		return;
	}
	bool isSimulated() const override { return baseNetwork->isSimulated(); }
	void onMainThread(Promise<Void>&& signal, TaskPriority taskID) override {
		return baseNetwork->onMainThread(std::move(signal), taskID);
	}
	bool isOnMainThread() const override { return baseNetwork->isOnMainThread(); }
	THREAD_HANDLE startThread(THREAD_FUNC_RETURN (*func)(void*), void* arg, int stackSize, const char* name) override {
		return baseNetwork->startThread(func, arg, stackSize, name);
	}
	Future<Reference<class IAsyncFile>> open(std::string filename, int64_t flags, int64_t mode) {
		return IAsyncFileSystem::filesystem()->open(filename, flags, mode);
	}
	Future<Void> deleteFile(std::string filename, bool mustBeDurable) {
		return IAsyncFileSystem::filesystem()->deleteFile(filename, mustBeDurable);
	}
	void run() override { return baseNetwork->run(); }
	bool checkRunnable() override { return baseNetwork->checkRunnable(); }
	void getDiskBytes(std::string const& directory, int64_t& free, int64_t& total) override {
		return baseNetwork->getDiskBytes(directory, free, total);
	}
	bool isAddressOnThisHost(NetworkAddress const& addr) const override {
		return baseNetwork->isAddressOnThisHost(addr);
	}
	const TLSConfig& getTLSConfig() const override {
		static TLSConfig emptyConfig;
		return emptyConfig;
	}
#ifdef ENABLE_SAMPLING
	ActorLineageSet& getActorLineageSet() override { throw std::exception(); }
#endif
	ProtocolVersion protocolVersion() const override { return baseNetwork->protocolVersion(); }
};

struct NonserializableThing {};
															#line 3330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via testNonserializableThing()
															#line 305 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class TestNonserializableThingActor>
															#line 305 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestNonserializableThingActorState {
															#line 3337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 305 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestNonserializableThingActorState() 
															#line 305 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	{
															#line 3343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		fdb_probe_actor_create("testNonserializableThing", reinterpret_cast<unsigned long>(this));

	}
	~TestNonserializableThingActorState() 
	{
		fdb_probe_actor_destroy("testNonserializableThing", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 306 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<TestNonserializableThingActor*>(this)->SAV<NonserializableThing>::futures) { (void)(NonserializableThing()); this->~TestNonserializableThingActorState(); static_cast<TestNonserializableThingActor*>(this)->destroy(); return 0; }
															#line 3357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<TestNonserializableThingActor*>(this)->SAV< NonserializableThing >::value()) NonserializableThing(NonserializableThing());
			this->~TestNonserializableThingActorState();
			static_cast<TestNonserializableThingActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestNonserializableThingActorState();
		static_cast<TestNonserializableThingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
};
// This generated class is to be used only via testNonserializableThing()
															#line 305 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestNonserializableThingActor final : public Actor<NonserializableThing>, public FastAllocated<TestNonserializableThingActor>, public TestNonserializableThingActorState<TestNonserializableThingActor> {
															#line 3383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<TestNonserializableThingActor>::operator new;
	using FastAllocated<TestNonserializableThingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1181241920735707392UL, 9135370715208150528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<NonserializableThing>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 305 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestNonserializableThingActor() 
															#line 3399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<NonserializableThing>(),
		   TestNonserializableThingActorState<TestNonserializableThingActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testNonserializableThing", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(149492758402805248UL, 11653784399266102528UL);
		ActorExecutionContextHelper __helper(static_cast<TestNonserializableThingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testNonserializableThing");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testNonserializableThing", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 305 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<NonserializableThing> testNonserializableThing(  ) {
															#line 305 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<NonserializableThing>(new TestNonserializableThingActor());
															#line 3431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 308 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 3436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via testCancelled()
															#line 309 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class TestCancelledActor>
															#line 309 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestCancelledActorState {
															#line 3443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 309 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestCancelledActorState(bool* const& exits,Future<Void> const& f) 
															#line 309 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 309 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : exits(exits),
															#line 309 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   f(f)
															#line 3452 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testCancelled", reinterpret_cast<unsigned long>(this));

	}
	~TestCancelledActorState() 
	{
		fdb_probe_actor_destroy("testCancelled", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 311 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_0 = Future<Void>(Never());
															#line 311 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<TestCancelledActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TestCancelledActor*>(this)->actor_wait_state = 1;
															#line 311 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestCancelledActor, 0, Void >*>(static_cast<TestCancelledActor*>(this)));
															#line 3475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestCancelledActorState();
		static_cast<TestCancelledActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 322 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<TestCancelledActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCancelledActorState(); static_cast<TestCancelledActor*>(this)->destroy(); return 0; }
															#line 3504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<TestCancelledActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCancelledActorState();
		static_cast<TestCancelledActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 313 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			err = e;
															#line 3517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			try {
															#line 315 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_1 = Future<Void>(Never());
															#line 315 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<TestCancelledActor*>(this)->actor_wait_state < 0) return a_body1Catch2Catch1(actor_cancelled(), loopDepth);
															#line 3523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
				static_cast<TestCancelledActor*>(this)->actor_wait_state = 2;
															#line 315 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCancelledActor, 1, Void >*>(static_cast<TestCancelledActor*>(this)));
															#line 3528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestCancelledActor*>(this)->actor_wait_state > 0) static_cast<TestCancelledActor*>(this)->actor_wait_state = 0;
		static_cast<TestCancelledActor*>(this)->ActorCallback< TestCancelledActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCancelledActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCancelledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestCancelledActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCancelledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestCancelledActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCancelledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(int loopDepth) 
	{
															#line 320 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 3649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"

		return loopDepth;
	}
	int a_body1Catch2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 317 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			*exits = true;
															#line 318 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 3660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestCancelledActor*>(this)->actor_wait_state > 0) static_cast<TestCancelledActor*>(this)->actor_wait_state = 0;
		static_cast<TestCancelledActor*>(this)->ActorCallback< TestCancelledActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCancelledActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCancelledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestCancelledActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCancelledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestCancelledActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCancelledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1Catch2cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1Catch2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 309 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool* exits;
															#line 309 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> f;
															#line 313 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Error err;
															#line 3776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via testCancelled()
															#line 309 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class TestCancelledActor final : public Actor<Void>, public ActorCallback< TestCancelledActor, 0, Void >, public ActorCallback< TestCancelledActor, 1, Void >, public FastAllocated<TestCancelledActor>, public TestCancelledActorState<TestCancelledActor> {
															#line 3781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<TestCancelledActor>::operator new;
	using FastAllocated<TestCancelledActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16941488610335849984UL, 13070778474750008576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestCancelledActor, 0, Void >;
friend struct ActorCallback< TestCancelledActor, 1, Void >;
															#line 309 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	TestCancelledActor(bool* const& exits,Future<Void> const& f) 
															#line 3799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestCancelledActorState<TestCancelledActor>(exits, f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testCancelled", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13170310579731969536UL, 17465607942907386624UL);
		ActorExecutionContextHelper __helper(static_cast<TestCancelledActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testCancelled");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testCancelled", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestCancelledActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestCancelledActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 309 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<Void> testCancelled( bool* const& exits, Future<Void> const& f ) {
															#line 309 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new TestCancelledActor(exits, f));
															#line 3833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 324 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 3838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase325()
															#line 325 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase325Actor>
															#line 325 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase325ActorState {
															#line 3845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 325 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase325ActorState(UnitTestParameters const& params) 
															#line 325 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 325 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 3852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase325", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase325ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase325", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 326 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			bool exits = false;
															#line 327 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<Void> p;
															#line 328 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> test = testCancelled(&exits, p.getFuture());
															#line 329 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.getPromiseReferenceCount() == 1 && p.getFutureReferenceCount() == 1);
															#line 330 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			test.cancel();
															#line 331 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(exits);
															#line 332 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(test.getPromiseReferenceCount() == 0 && test.getFutureReferenceCount() == 1 && test.isReady() && test.isError() && test.getError().code() == error_code_actor_cancelled);
															#line 334 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.getPromiseReferenceCount() == 1 && p.getFutureReferenceCount() == 0);
															#line 336 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase325Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase325ActorState(); static_cast<FlowTestCase325Actor*>(this)->destroy(); return 0; }
															#line 3883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase325Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase325ActorState();
			static_cast<FlowTestCase325Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase325ActorState();
		static_cast<FlowTestCase325Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 325 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 3907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase325()
															#line 325 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase325Actor final : public Actor<Void>, public FastAllocated<FlowTestCase325Actor>, public FlowTestCase325ActorState<FlowTestCase325Actor> {
															#line 3912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase325Actor>::operator new;
	using FastAllocated<FlowTestCase325Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13204565611065196288UL, 7399038642068312320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 325 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase325Actor(UnitTestParameters const& params) 
															#line 3928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase325ActorState<FlowTestCase325Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase325", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16815383832306191616UL, 12066985519106116608UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase325Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase325");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase325", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 325 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase325( UnitTestParameters const& params ) {
															#line 325 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase325Actor(params));
															#line 3960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase325, "/flow/flow/cancel1")

#line 338 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 3966 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via noteCancel()
															#line 339 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class NoteCancelActor>
															#line 339 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class NoteCancelActorState {
															#line 3973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 339 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	NoteCancelActorState(int* const& cancelled) 
															#line 339 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 339 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : cancelled(cancelled)
															#line 3980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("noteCancel", reinterpret_cast<unsigned long>(this));

	}
	~NoteCancelActorState() 
	{
		fdb_probe_actor_destroy("noteCancel", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 340 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			*cancelled = 0;
															#line 3995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			try {
															#line 342 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_0 = Future<Void>(Never());
															#line 342 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<NoteCancelActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NoteCancelActor*>(this)->actor_wait_state = 1;
															#line 342 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NoteCancelActor, 0, Void >*>(static_cast<NoteCancelActor*>(this)));
															#line 4006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NoteCancelActorState();
		static_cast<NoteCancelActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 345 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("Cancelled!\n");
															#line 346 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			*cancelled = 1;
															#line 347 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			return a_body1Catch1(__current_error, loopDepth);
															#line 4040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 343 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		return a_body1Catch2(internal_error(), loopDepth);
															#line 4054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 343 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		return a_body1Catch2(internal_error(), loopDepth);
															#line 4062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NoteCancelActor*>(this)->actor_wait_state > 0) static_cast<NoteCancelActor*>(this)->actor_wait_state = 0;
		static_cast<NoteCancelActor*>(this)->ActorCallback< NoteCancelActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NoteCancelActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("noteCancel", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NoteCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noteCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NoteCancelActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("noteCancel", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NoteCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noteCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NoteCancelActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("noteCancel", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NoteCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("noteCancel", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 339 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int* cancelled;
															#line 4143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via noteCancel()
															#line 339 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class NoteCancelActor final : public Actor<Void>, public ActorCallback< NoteCancelActor, 0, Void >, public FastAllocated<NoteCancelActor>, public NoteCancelActorState<NoteCancelActor> {
															#line 4148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<NoteCancelActor>::operator new;
	using FastAllocated<NoteCancelActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(128118414196056832UL, 9512204118426857984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NoteCancelActor, 0, Void >;
															#line 339 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	NoteCancelActor(int* const& cancelled) 
															#line 4165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   NoteCancelActorState<NoteCancelActor>(cancelled),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("noteCancel", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5033296790666848000UL, 8182302322103455744UL);
		ActorExecutionContextHelper __helper(static_cast<NoteCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("noteCancel");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("noteCancel", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NoteCancelActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 339 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> noteCancel( int* const& cancelled ) {
															#line 339 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new NoteCancelActor(cancelled));
															#line 4198 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 350 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase351()
															#line 351 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase351Actor>
															#line 351 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase351ActorState {
															#line 4210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 351 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase351ActorState(UnitTestParameters const& params) 
															#line 351 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 351 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase351", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase351ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase351", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 352 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int c1 = 0, c2 = 0, c3 = 0;
															#line 354 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> cf = noteCancel(&c1);
															#line 355 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(c1 == 0);
															#line 356 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			cf = Future<Void>();
															#line 357 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(c1 == 1);
															#line 359 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			cf = noteCancel(&c2) && noteCancel(&c3);
															#line 360 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(c2 == 0 && c3 == 0);
															#line 361 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			cf = Future<Void>();
															#line 362 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(c2 == 1 && c3 == 1);
															#line 363 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase351Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase351ActorState(); static_cast<FlowTestCase351Actor*>(this)->destroy(); return 0; }
															#line 4250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase351Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase351ActorState();
			static_cast<FlowTestCase351Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase351ActorState();
		static_cast<FlowTestCase351Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 351 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase351()
															#line 351 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase351Actor final : public Actor<Void>, public FastAllocated<FlowTestCase351Actor>, public FlowTestCase351ActorState<FlowTestCase351Actor> {
															#line 4279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase351Actor>::operator new;
	using FastAllocated<FlowTestCase351Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2471138085662653696UL, 8544875974343650816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 351 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase351Actor(UnitTestParameters const& params) 
															#line 4295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase351ActorState<FlowTestCase351Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase351", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3473365524042607616UL, 1702892623266774016UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase351Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase351");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase351", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 351 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase351( UnitTestParameters const& params ) {
															#line 351 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase351Actor(params));
															#line 4327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase351, "/flow/flow/cancel2")

#line 365 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

namespace flow_tests_details {
// Simple message for flatbuffers unittests
struct Int {
	constexpr static FileIdentifier file_identifier = 12345;
	uint32_t value;
	Int() = default;
	Int(uint32_t value) : value(value) {}
	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, value);
	}
};
} // namespace flow_tests_details

															#line 4347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase380()
															#line 380 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase380Actor>
															#line 380 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase380ActorState {
															#line 4354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 380 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase380ActorState(UnitTestParameters const& params) 
															#line 380 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 380 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase380", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase380ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase380", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 383 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<NonserializableThing> f = testNonserializableThing();
															#line 384 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Promise<NonserializableThing> p;
															#line 385 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				p.send(NonserializableThing());
															#line 386 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				f = p.getFuture();
															#line 4383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 394 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ReplyPromise<flow_tests_details::Int> rpInt;
															#line 395 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<flow_tests_details::Int> f = rpInt.getFuture();
															#line 396 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(!f.isReady());
															#line 397 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				rpInt.send(123);
															#line 398 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(f.get().value == 123);
															#line 4396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 402 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				RequestStream<flow_tests_details::Int> rsInt;
															#line 403 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				FutureStream<flow_tests_details::Int> f = rsInt.getFuture();
															#line 404 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				rsInt.send(1);
															#line 405 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				rsInt.send(2);
															#line 406 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(f.pop().value == 1);
															#line 407 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(f.pop().value == 2);
															#line 4411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 410 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase380Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase380ActorState(); static_cast<FlowTestCase380Actor*>(this)->destroy(); return 0; }
															#line 4415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase380Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase380ActorState();
			static_cast<FlowTestCase380Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase380ActorState();
		static_cast<FlowTestCase380Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 380 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase380()
															#line 380 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase380Actor final : public Actor<Void>, public FastAllocated<FlowTestCase380Actor>, public FlowTestCase380ActorState<FlowTestCase380Actor> {
															#line 4444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase380Actor>::operator new;
	using FastAllocated<FlowTestCase380Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7933296413163867648UL, 17893034041225567744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 380 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase380Actor(UnitTestParameters const& params) 
															#line 4460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase380ActorState<FlowTestCase380Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase380", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7595961757575816448UL, 2558490567848035584UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase380Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase380");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase380", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 380 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase380( UnitTestParameters const& params ) {
															#line 380 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase380Actor(params));
															#line 4492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase380, "/flow/flow/nonserializable futures")

#line 412 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase413()
															#line 413 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase413Actor>
															#line 413 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase413ActorState {
															#line 4505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 413 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase413ActorState(UnitTestParameters const& params) 
															#line 413 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 413 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase413", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase413ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase413", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 416 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				RequestStream<flow_tests_details::Int> locInt;
															#line 417 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				BinaryWriter wr(IncludeVersion());
															#line 418 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				wr << locInt;
															#line 420 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(locInt.getEndpoint().isValid() && locInt.getEndpoint().isLocal() && locInt.getEndpoint().getPrimaryAddress() == FlowTransport::transport().getLocalAddress());
															#line 423 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				BinaryReader rd(wr.toValue(), IncludeVersion());
															#line 424 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				RequestStream<flow_tests_details::Int> remoteInt;
															#line 425 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				rd >> remoteInt;
															#line 427 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(remoteInt.getEndpoint() == locInt.getEndpoint());
															#line 4542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 432 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (0)
															#line 4546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 433 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ReplyPromise<flow_tests_details::Int> locInt;
															#line 434 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				BinaryWriter wr(IncludeVersion());
															#line 435 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				wr << locInt;
															#line 437 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(locInt.getEndpoint().isValid() && locInt.getEndpoint().isLocal());
															#line 439 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				BinaryReader rd(wr.toValue(), IncludeVersion());
															#line 440 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ReplyPromise<flow_tests_details::Int> remoteInt;
															#line 441 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				rd >> remoteInt;
															#line 443 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(remoteInt.getEndpoint() == locInt.getEndpoint());
															#line 4564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 446 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase413Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase413ActorState(); static_cast<FlowTestCase413Actor*>(this)->destroy(); return 0; }
															#line 4568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase413Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase413ActorState();
			static_cast<FlowTestCase413Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase413ActorState();
		static_cast<FlowTestCase413Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 413 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase413()
															#line 413 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase413Actor final : public Actor<Void>, public FastAllocated<FlowTestCase413Actor>, public FlowTestCase413ActorState<FlowTestCase413Actor> {
															#line 4597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase413Actor>::operator new;
	using FastAllocated<FlowTestCase413Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7081236260260244736UL, 2803514338679912704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 413 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase413Actor(UnitTestParameters const& params) 
															#line 4613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase413ActorState<FlowTestCase413Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase413", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11849063175884445440UL, 2706633594770728192UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase413Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase413");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase413", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 413 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase413( UnitTestParameters const& params ) {
															#line 413 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase413Actor(params));
															#line 4645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase413, "/flow/flow/networked futures")

#line 448 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase449()
															#line 449 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase449Actor>
															#line 449 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase449ActorState {
															#line 4658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 449 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase449ActorState(UnitTestParameters const& params) 
															#line 449 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 449 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase449", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase449ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase449", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 450 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			std::vector<Promise<int>> ps(5);
															#line 451 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			std::vector<Future<int>> fs;
															#line 452 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			std::vector<Future<Void>> qs;
															#line 453 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for( auto& p : ps ) {
															#line 454 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				fs.push_back(p.getFuture());
															#line 4688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 456 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i <= ps.size();i++) {
															#line 457 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				qs.push_back(quorum(fs, i));
															#line 4694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 459 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < ps.size();i++) {
															#line 460 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(qs[i].isReady());
															#line 461 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(!qs[i + 1].isReady());
															#line 462 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ps[i].send(i);
															#line 4704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 464 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(qs[ps.size()].isReady());
															#line 465 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase449Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase449ActorState(); static_cast<FlowTestCase449Actor*>(this)->destroy(); return 0; }
															#line 4710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase449Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase449ActorState();
			static_cast<FlowTestCase449Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase449ActorState();
		static_cast<FlowTestCase449Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 449 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase449()
															#line 449 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase449Actor final : public Actor<Void>, public FastAllocated<FlowTestCase449Actor>, public FlowTestCase449ActorState<FlowTestCase449Actor> {
															#line 4739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase449Actor>::operator new;
	using FastAllocated<FlowTestCase449Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1118359464488569600UL, 17879756224766813184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 449 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase449Actor(UnitTestParameters const& params) 
															#line 4755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase449ActorState<FlowTestCase449Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase449", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18392570013762144256UL, 13096752133233492736UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase449Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase449");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase449", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 449 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase449( UnitTestParameters const& params ) {
															#line 449 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase449Actor(params));
															#line 4787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase449, "/flow/flow/quorum")

#line 467 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase468()
															#line 468 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase468Actor>
															#line 468 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase468ActorState {
															#line 4800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 468 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase468ActorState(UnitTestParameters const& params) 
															#line 468 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 468 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase468", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase468ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase468", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 469 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> invalid;
															#line 470 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!invalid.isValid());
															#line 472 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> never = Never();
															#line 473 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(never.isValid() && !never.isReady());
															#line 475 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> one = 1;
															#line 476 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(one.isValid() && one.isReady() && !one.isError());
															#line 477 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(one.get() == 1);
															#line 478 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(one.getFutureReferenceCount() == 1);
															#line 479 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase468Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase468ActorState(); static_cast<FlowTestCase468Actor*>(this)->destroy(); return 0; }
															#line 4838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase468Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase468ActorState();
			static_cast<FlowTestCase468Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase468ActorState();
		static_cast<FlowTestCase468Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 468 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 4862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase468()
															#line 468 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase468Actor final : public Actor<Void>, public FastAllocated<FlowTestCase468Actor>, public FlowTestCase468ActorState<FlowTestCase468Actor> {
															#line 4867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase468Actor>::operator new;
	using FastAllocated<FlowTestCase468Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16838777026844790016UL, 1078078521341527808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 468 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase468Actor(UnitTestParameters const& params) 
															#line 4883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase468ActorState<FlowTestCase468Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase468", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1761098721256587008UL, 7523031450748841472UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase468Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase468");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase468", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 468 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase468( UnitTestParameters const& params ) {
															#line 468 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase468Actor(params));
															#line 4915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase468, "/flow/flow/trivial futures")

#line 481 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 4921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase482()
															#line 482 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase482Actor>
															#line 482 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase482ActorState {
															#line 4928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 482 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase482ActorState(UnitTestParameters const& params) 
															#line 482 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 482 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 4935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase482", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase482ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase482", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 483 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> f;
															#line 485 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p;
															#line 486 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isValid());
															#line 487 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!p.isSet());
															#line 488 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(1);
															#line 489 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isSet());
															#line 490 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.getFuture().get() == 1);
															#line 492 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p2;
															#line 493 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p2.getFuture();
															#line 494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && !f.isReady());
															#line 495 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p2.send(2);
															#line 496 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && f.isReady() && !f.isError());
															#line 497 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.get() == 2);
															#line 499 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p3;
															#line 500 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p3.getFuture();
															#line 501 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p3.sendError(end_of_stream());
															#line 502 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && f.isReady() && f.isError());
															#line 503 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.getError().code() == error_code_end_of_stream);
															#line 505 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p4;
															#line 506 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p4.getFuture();
															#line 507 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p4 = Promise<int>();
															#line 508 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p4.isValid() && !p4.isSet());
															#line 509 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && f.isReady() && f.isError());
															#line 510 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.getError().code() == error_code_broken_promise);
															#line 511 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase482Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase482ActorState(); static_cast<FlowTestCase482Actor*>(this)->destroy(); return 0; }
															#line 4998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase482Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase482ActorState();
			static_cast<FlowTestCase482Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase482ActorState();
		static_cast<FlowTestCase482Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 482 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase482()
															#line 482 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase482Actor final : public Actor<Void>, public FastAllocated<FlowTestCase482Actor>, public FlowTestCase482ActorState<FlowTestCase482Actor> {
															#line 5027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase482Actor>::operator new;
	using FastAllocated<FlowTestCase482Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14481545709650996992UL, 13848449838436407808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 482 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase482Actor(UnitTestParameters const& params) 
															#line 5043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase482ActorState<FlowTestCase482Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase482", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12778150663482071552UL, 9640007613459756800UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase482Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase482");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase482", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 482 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase482( UnitTestParameters const& params ) {
															#line 482 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase482Actor(params));
															#line 5075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase482, "/flow/flow/trivial promises")

#line 513 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 5081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase514()
															#line 514 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase514Actor>
															#line 514 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase514ActorState {
															#line 5088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 514 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase514ActorState(UnitTestParameters const& params) 
															#line 514 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 514 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase514", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase514ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase514", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 515 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			FutureStream<int> f;
															#line 517 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> p;
															#line 518 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(1);
															#line 519 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.getFuture().isReady());
															#line 520 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.getFuture().pop() == 1);
															#line 522 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> p2;
															#line 523 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p2.getFuture();
															#line 524 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && !f.isReady());
															#line 525 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p2.send(2);
															#line 526 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p2.send(3);
															#line 527 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && f.isReady() && !f.isError());
															#line 528 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.pop() == 2);
															#line 529 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.pop() == 3);
															#line 531 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> p3;
															#line 532 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p3.getFuture();
															#line 533 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p3.send(4);
															#line 534 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p3.sendError(end_of_stream());
															#line 535 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isReady() && !f.isError());
															#line 536 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.pop() == 4);
															#line 537 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isError());
															#line 538 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.getError().code() == error_code_end_of_stream);
															#line 540 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> p4;
															#line 541 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p4.getFuture();
															#line 542 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p4 = PromiseStream<int>();
															#line 543 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isValid() && f.isReady() && f.isError());
															#line 544 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.getError().code() == error_code_broken_promise);
															#line 545 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase514Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase514ActorState(); static_cast<FlowTestCase514Actor*>(this)->destroy(); return 0; }
															#line 5162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase514Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase514ActorState();
			static_cast<FlowTestCase514Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase514ActorState();
		static_cast<FlowTestCase514Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 514 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase514()
															#line 514 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase514Actor final : public Actor<Void>, public FastAllocated<FlowTestCase514Actor>, public FlowTestCase514ActorState<FlowTestCase514Actor> {
															#line 5191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase514Actor>::operator new;
	using FastAllocated<FlowTestCase514Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(874504369064972544UL, 13960237576317194496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 514 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase514Actor(UnitTestParameters const& params) 
															#line 5207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase514ActorState<FlowTestCase514Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase514", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2330430084250982400UL, 3641041401737385728UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase514Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase514");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase514", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 514 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase514( UnitTestParameters const& params ) {
															#line 514 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase514Actor(params));
															#line 5239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase514, "/flow/flow/trivial promisestreams")

#line 547 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 5245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase548()
															#line 548 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase548Actor>
															#line 548 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase548ActorState {
															#line 5252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 548 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase548ActorState(UnitTestParameters const& params) 
															#line 548 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 548 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase548", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase548ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase548", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 549 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p;
															#line 550 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> f = p.getFuture();
															#line 551 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int result = 0;
															#line 552 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			bool happened = false;
															#line 554 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(std::move(f), [&result](int x) { result = x; }, [&result](Error e) { result = -1; });
															#line 555 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(p.getFuture(), [&happened](int) { happened = true; }, [&happened](Error) { happened = true; });
															#line 556 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!f.isValid());
															#line 557 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isValid() && !p.isSet() && p.getFutureReferenceCount() == 1);
															#line 558 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 0 && !happened);
															#line 560 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(123);
															#line 561 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 123 && happened);
															#line 562 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isValid() && p.isSet() && p.getFutureReferenceCount() == 0 && p.getFuture().get() == 123);
															#line 564 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			result = 0;
															#line 565 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e) { result = -1; });
															#line 566 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 123);
															#line 567 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isValid() && p.isSet() && p.getFutureReferenceCount() == 0 && p.getFuture().get() == 123);
															#line 569 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p = Promise<int>();
															#line 570 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p.getFuture();
															#line 571 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			result = 0;
															#line 572 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(std::move(f), [&result](int x) { result = x; }, [&result](Error e) { result = -e.code(); });
															#line 573 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!f.isValid());
															#line 574 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(p.isValid() && !p.isSet() && p.getFutureReferenceCount() == 1);
															#line 575 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 0);
															#line 577 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p = Promise<int>();
															#line 578 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == -error_code_broken_promise);
															#line 579 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase548Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase548ActorState(); static_cast<FlowTestCase548Actor*>(this)->destroy(); return 0; }
															#line 5324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase548Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase548ActorState();
			static_cast<FlowTestCase548Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase548ActorState();
		static_cast<FlowTestCase548Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 548 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase548()
															#line 548 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase548Actor final : public Actor<Void>, public FastAllocated<FlowTestCase548Actor>, public FlowTestCase548ActorState<FlowTestCase548Actor> {
															#line 5353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase548Actor>::operator new;
	using FastAllocated<FlowTestCase548Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10305726154487280896UL, 9753895400965989120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 548 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase548Actor(UnitTestParameters const& params) 
															#line 5369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase548ActorState<FlowTestCase548Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase548", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7767097439180653056UL, 16162204894937820416UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase548Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase548");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase548", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 548 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase548( UnitTestParameters const& params ) {
															#line 548 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase548Actor(params));
															#line 5401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase548, "/flow/flow/callbacks")

#line 581 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 5407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase582()
															#line 582 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase582Actor>
															#line 582 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase582ActorState {
															#line 5414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 582 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase582ActorState(UnitTestParameters const& params) 
															#line 582 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 582 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase582", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase582ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase582", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 583 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> p;
															#line 585 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int result = 0;
															#line 587 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e) { result = -1; });
															#line 589 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 0);
															#line 591 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(123);
															#line 592 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(456);
															#line 594 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 123);
															#line 595 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			result = 0;
															#line 597 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e) { result = -1; });
															#line 599 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 456);
															#line 600 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			result = 0;
															#line 602 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e) { result = -1; });
															#line 604 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 0);
															#line 606 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p = PromiseStream<int>();
															#line 608 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == -1);
															#line 609 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase582Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase582ActorState(); static_cast<FlowTestCase582Actor*>(this)->destroy(); return 0; }
															#line 5466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase582Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase582ActorState();
			static_cast<FlowTestCase582Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase582ActorState();
		static_cast<FlowTestCase582Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 582 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase582()
															#line 582 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase582Actor final : public Actor<Void>, public FastAllocated<FlowTestCase582Actor>, public FlowTestCase582ActorState<FlowTestCase582Actor> {
															#line 5495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase582Actor>::operator new;
	using FastAllocated<FlowTestCase582Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4782585593927188480UL, 4192942481523631104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 582 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase582Actor(UnitTestParameters const& params) 
															#line 5511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase582ActorState<FlowTestCase582Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase582", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18210211107080498176UL, 2220877536194922752UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase582Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase582");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase582", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 582 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase582( UnitTestParameters const& params ) {
															#line 582 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase582Actor(params));
															#line 5543 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase582, "/flow/flow/promisestream callbacks")

#line 611 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

// Incompatible with --crash, so we are commenting it out for now
/*
TEST_CASE("/flow/flow/promisestream multiple wait error")
{
    state int result = 0;
    state PromiseStream<int> p;
    try {
        onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e){ result = -1; });
        result = 100;
        onReady(p.getFuture(), [&result](int x) { result = x; }, [&result](Error e){ result = -1; });
        ASSERT(false);
    }
    catch (Error& e) {
        ASSERT(e.code() == error_code_internal_error);
    }
    ASSERT(result == 100);
    p = PromiseStream<int>();
    ASSERT(result == -1);
    return Void();
}
*/

															#line 5571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase634()
															#line 634 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase634Actor>
															#line 634 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase634ActorState {
															#line 5578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 634 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase634ActorState(UnitTestParameters const& params) 
															#line 634 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 634 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase634", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase634ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase634", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 635 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 637 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int result = 0;
															#line 638 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			trivialVoidActor(&result);
															#line 639 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 1);
															#line 640 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 642 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<int> f = return42Actor();
															#line 643 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isReady() && !f.isError() && f.get() == 42 && f.getFutureReferenceCount() == 1 && f.getPromiseReferenceCount() == 0);
															#line 645 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(1));
															#line 646 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = Future<int>();
															#line 647 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 649 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = templateActor(24);
															#line 650 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isReady() && !f.isError() && f.get() == 24 && f.getFutureReferenceCount() == 1 && f.getPromiseReferenceCount() == 0);
															#line 652 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(1));
															#line 653 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = Future<int>();
															#line 654 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 656 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			result = 0;
															#line 657 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			voidWaitActor(2, &result);
															#line 658 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(result == 2 && expectActorCount(0));
															#line 660 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<int> p;
															#line 661 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = addOneActor(p.getFuture());
															#line 662 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!f.isReady() && expectActorCount(1));
															#line 663 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(100);
															#line 664 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.isReady() && f.get() == 101);
															#line 665 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(1));
															#line 666 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = Future<int>();
															#line 667 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 669 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<int> ps;
															#line 670 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = consumeOneActor(ps.getFuture());
															#line 671 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!f.isReady() && expectActorCount(1));
															#line 672 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.send(101);
															#line 673 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.get() == 101 && ps.isEmpty());
															#line 674 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.send(102);
															#line 675 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!ps.isEmpty());
															#line 676 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = consumeOneActor(ps.getFuture());
															#line 677 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.get() == 102 && ps.isEmpty());
															#line 679 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = sumActor(ps.getFuture());
															#line 680 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.send(1);
															#line 681 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.send(10);
															#line 682 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.send(100);
															#line 683 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ps.sendError(end_of_stream());
															#line 684 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(f.get() == 111);
															#line 686 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(testHygeine().isReady());
															#line 687 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase634Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase634ActorState(); static_cast<FlowTestCase634Actor*>(this)->destroy(); return 0; }
															#line 5684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase634Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase634ActorState();
			static_cast<FlowTestCase634Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase634ActorState();
		static_cast<FlowTestCase634Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 634 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase634()
															#line 634 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase634Actor final : public Actor<Void>, public FastAllocated<FlowTestCase634Actor>, public FlowTestCase634ActorState<FlowTestCase634Actor> {
															#line 5713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase634Actor>::operator new;
	using FastAllocated<FlowTestCase634Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15633162750850426368UL, 17550885109976126464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 634 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase634Actor(UnitTestParameters const& params) 
															#line 5729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase634ActorState<FlowTestCase634Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase634", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16158073088913297920UL, 13746511540220512512UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase634Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase634");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase634", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 634 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase634( UnitTestParameters const& params ) {
															#line 634 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase634Actor(params));
															#line 5761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase634, "/flow/flow/trivial actors")

#line 689 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 5767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase690()
															#line 690 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase690Actor>
															#line 690 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase690ActorState {
															#line 5774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 690 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase690ActorState(UnitTestParameters const& params) 
															#line 690 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 690 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase690", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase690ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase690", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 694 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto yn = makeReference<YieldMockNetwork>();
															#line 696 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			yn->nextYield = 0;
															#line 698 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<Void> p;
															#line 699 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> u = p.getFuture();
															#line 700 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> i = success(u);
															#line 702 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			std::vector<Future<Void>> v;
															#line 703 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < 5;i++) {
															#line 704 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				v.push_back(yieldedFuture(u));
															#line 5810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 705 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto numReady = [&v]() { return std::count_if(v.begin(), v.end(), [](Future<Void> v) { return v.isReady(); }); };
															#line 707 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(numReady() == 0);
															#line 708 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(Void());
															#line 709 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(u.isReady() && i.isReady() && numReady() == 0);
															#line 711 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < 5;i++) {
															#line 712 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				yn->tick();
															#line 713 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(numReady() == i + 1);
															#line 5826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 716 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < 5;i++) {
															#line 717 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(v[i].getPromiseReferenceCount() == 0 && v[i].getFutureReferenceCount() == 1);
															#line 5832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 720 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase690Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase690ActorState(); static_cast<FlowTestCase690Actor*>(this)->destroy(); return 0; }
															#line 5836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase690Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase690ActorState();
			static_cast<FlowTestCase690Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase690ActorState();
		static_cast<FlowTestCase690Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 690 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 5860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase690()
															#line 690 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase690Actor final : public Actor<Void>, public FastAllocated<FlowTestCase690Actor>, public FlowTestCase690ActorState<FlowTestCase690Actor> {
															#line 5865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase690Actor>::operator new;
	using FastAllocated<FlowTestCase690Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11040158475883779840UL, 6956860728150936832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 690 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase690Actor(UnitTestParameters const& params) 
															#line 5881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase690ActorState<FlowTestCase690Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase690", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14163071466332653312UL, 1733957118408024576UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase690Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase690");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase690", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 690 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase690( UnitTestParameters const& params ) {
															#line 690 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase690Actor(params));
															#line 5913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase690, "/flow/flow/yieldedFuture/progress")

#line 722 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 5919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase723()
															#line 723 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase723Actor>
															#line 723 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase723ActorState {
															#line 5926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 723 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase723ActorState(UnitTestParameters const& params) 
															#line 723 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 723 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 5933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase723", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase723ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase723", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 726 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto yn = makeReference<YieldMockNetwork>();
															#line 728 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int r = 0;r < 100;r++) {
															#line 729 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Promise<Void> p;
															#line 730 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<Void> u = p.getFuture();
															#line 731 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<Void> i = success(u);
															#line 733 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> v;
															#line 734 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < 25;i++) {
															#line 735 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					v.push_back(yieldedFuture(u));
															#line 5962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 736 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				auto numReady = [&v]() { return std::count_if(v.begin(), v.end(), [](Future<Void> v) { return v.isReady(); }); };
															#line 740 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<Void> j = success(u);
															#line 742 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(numReady() == 0);
															#line 744 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				int expectYield = deterministicRandom()->randomInt(0, 4);
															#line 745 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				int expectReady = expectYield;
															#line 746 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				yn->nextYield = 1 + expectYield;
															#line 748 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				p.send(Void());
															#line 749 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(u.isReady() && i.isReady() && j.isReady() && numReady() == expectReady);
															#line 751 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(;numReady() != v.size();) {
															#line 752 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					expectYield = deterministicRandom()->randomInt(0, 4);
															#line 753 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					yn->nextYield = 1 + expectYield;
															#line 754 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					expectReady += 1 + expectYield;
															#line 755 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					yn->tick();
															#line 758 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(numReady() == std::min<int>(expectReady, v.size()));
															#line 5992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 761 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < v.size();i++) {
															#line 762 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(v[i].getPromiseReferenceCount() == 0 && v[i].getFutureReferenceCount() == 1);
															#line 5998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
			}
															#line 766 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase723Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase723ActorState(); static_cast<FlowTestCase723Actor*>(this)->destroy(); return 0; }
															#line 6003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase723Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase723ActorState();
			static_cast<FlowTestCase723Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase723ActorState();
		static_cast<FlowTestCase723Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 723 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 6027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase723()
															#line 723 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase723Actor final : public Actor<Void>, public FastAllocated<FlowTestCase723Actor>, public FlowTestCase723ActorState<FlowTestCase723Actor> {
															#line 6032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase723Actor>::operator new;
	using FastAllocated<FlowTestCase723Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17321382966237120768UL, 6347560325691460608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 723 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase723Actor(UnitTestParameters const& params) 
															#line 6048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase723ActorState<FlowTestCase723Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase723", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7924626676723581440UL, 2193516560803552000UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase723Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase723");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase723", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 723 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase723( UnitTestParameters const& params ) {
															#line 723 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase723Actor(params));
															#line 6080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase723, "/flow/flow/yieldedFuture/random")

#line 768 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 6086 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase769()
															#line 769 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase769Actor>
															#line 769 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase769ActorState {
															#line 6093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 769 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase769ActorState(UnitTestParameters const& params) 
															#line 769 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 769 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 6100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase769", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase769ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase769", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 770 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			double start;
															#line 771 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int N = 1000000;
															#line 773 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto yn = makeReference<YieldMockNetwork>();
															#line 775 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			yn->nextYield = 2 * N + 100;
															#line 777 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<Void> p;
															#line 778 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> f = p.getFuture();
															#line 779 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			std::vector<Future<Void>> ys;
															#line 781 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			start = timer();
															#line 782 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < N;i++) {
															#line 783 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ys.push_back(yieldedFuture(f));
															#line 6133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 784 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("yieldedFuture(f) create: %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 785 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p.send(Void());
															#line 786 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("yieldedFuture(f) total: %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 788 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for( auto& y : ys ) {
															#line 789 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(y.isReady());
															#line 6145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 791 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			p = Promise<Void>();
															#line 792 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f = p.getFuture();
															#line 794 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			start = timer();
															#line 795 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < N;i++) {
															#line 796 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				yieldedFuture(f);
															#line 6157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 797 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("yieldedFuture(f) cancel: %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 799 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase769Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase769ActorState(); static_cast<FlowTestCase769Actor*>(this)->destroy(); return 0; }
															#line 6163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase769Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase769ActorState();
			static_cast<FlowTestCase769Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase769ActorState();
		static_cast<FlowTestCase769Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 769 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 6187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase769()
															#line 769 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase769Actor final : public Actor<Void>, public FastAllocated<FlowTestCase769Actor>, public FlowTestCase769ActorState<FlowTestCase769Actor> {
															#line 6192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase769Actor>::operator new;
	using FastAllocated<FlowTestCase769Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3191208765424029952UL, 12378216227355635968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 769 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase769Actor(UnitTestParameters const& params) 
															#line 6208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase769ActorState<FlowTestCase769Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase769", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10515145315543764480UL, 4019529408049027584UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase769Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase769");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase769", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 769 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase769( UnitTestParameters const& params ) {
															#line 769 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase769Actor(params));
															#line 6240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase769, "/flow/perf/yieldedFuture")

#line 801 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 6246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase802()
															#line 802 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase802Actor>
															#line 802 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase802ActorState {
															#line 6253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 802 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase802ActorState(UnitTestParameters const& params) 
															#line 802 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 802 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 6260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase802", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase802ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase802", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 803 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 805 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<Void> a, b;
															#line 806 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> c = chooseTwoActor(a.getFuture(), b.getFuture());
															#line 807 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(a.getFutureReferenceCount() == 2 && b.getFutureReferenceCount() == 2 && !c.isReady());
															#line 808 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			b.send(Void());
															#line 809 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(a.getFutureReferenceCount() == 0 && b.getFutureReferenceCount() == 0 && c.isReady() && !c.isError() && expectActorCount(1));
															#line 811 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			c = Future<Void>();
															#line 812 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(a.getFutureReferenceCount() == 0 && b.getFutureReferenceCount() == 0 && expectActorCount(0));
															#line 813 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase802Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase802ActorState(); static_cast<FlowTestCase802Actor*>(this)->destroy(); return 0; }
															#line 6291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase802Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase802ActorState();
			static_cast<FlowTestCase802Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase802ActorState();
		static_cast<FlowTestCase802Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 802 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 6315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase802()
															#line 802 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase802Actor final : public Actor<Void>, public FastAllocated<FlowTestCase802Actor>, public FlowTestCase802ActorState<FlowTestCase802Actor> {
															#line 6320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase802Actor>::operator new;
	using FastAllocated<FlowTestCase802Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9049187332144595200UL, 9060479340126895616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 802 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase802Actor(UnitTestParameters const& params) 
															#line 6336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase802ActorState<FlowTestCase802Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase802", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12347407534623437056UL, 4158036503052635136UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase802Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase802");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase802", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 802 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase802( UnitTestParameters const& params ) {
															#line 802 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase802Actor(params));
															#line 6368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase802, "/flow/flow/chooseTwoActor")

#line 815 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 6374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase816()
															#line 816 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase816Actor>
															#line 816 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase816ActorState {
															#line 6381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 816 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase816ActorState(UnitTestParameters const& params) 
															#line 816 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 816 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 6388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase816", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase816ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase816", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 817 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			double start;
															#line 818 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int N = 1000000;
															#line 820 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 822 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			start = timer();
															#line 823 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < N;i++) {
															#line 824 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				emptyVoidActor();
															#line 6413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 825 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("emptyVoidActor(): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 827 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 829 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			start = timer();
															#line 830 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < N;i++) {
															#line 831 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				emptyActor();
															#line 6425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 833 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("emptyActor(): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 835 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 837 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Promise<Void> neverSet;
															#line 838 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> never = neverSet.getFuture();
															#line 839 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> already = Void();
															#line 841 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			start = timer();
															#line 842 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < N;i++) {
															#line 843 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				oneWaitVoidActor(already);
															#line 6443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 844 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("oneWaitVoidActor(already): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 846 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(expectActorCount(0));
															#line 6449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 854 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 855 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 856 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = oneWaitActor(already);
															#line 857 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 859 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(already): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 863 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 864 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 865 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = oneWaitActor(never);
															#line 866 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(!f.isReady());
															#line 6474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 868 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("(cancelled) oneWaitActor(never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 869 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(expectActorCount(0));
															#line 6480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 873 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 874 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 875 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Promise<Void> p;
															#line 876 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = oneWaitActor(p.getFuture());
															#line 877 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					p.send(Void());
															#line 878 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 880 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(after): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 884 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 885 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 886 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 887 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 888 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = oneWaitActor(pipe[i].getFuture());
															#line 6512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 890 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 891 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 892 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 894 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(fifo): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 898 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 899 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 900 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 901 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 902 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = oneWaitActor(pipe[i].getFuture());
															#line 6537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 904 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = N - 1;i >= 0;i--) {
															#line 905 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 906 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 908 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(lifo): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 912 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 913 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 914 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(already, already);
															#line 915 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 917 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(already, already): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 921 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 922 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 923 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(already, never);
															#line 924 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 926 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(already, never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 930 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 931 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 932 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(never, already);
															#line 933 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 935 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(never, already): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 939 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 940 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 941 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(never, never);
															#line 942 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(!f.isReady());
															#line 6605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 945 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("(cancelled) chooseTwoActor(never, never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 949 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 950 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 951 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Promise<Void> p;
															#line 952 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(p.getFuture(), never);
															#line 953 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					p.send(Void());
															#line 954 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 956 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(after, never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 960 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 961 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 962 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 963 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 964 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = chooseTwoActor(pipe[i].getFuture(), never);
															#line 6641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 966 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 967 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 968 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 970 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(fifo, never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 974 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 975 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 976 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 977 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 978 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = chooseTwoActor(pipe[i].getFuture(), pipe[i].getFuture());
															#line 6666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 980 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 981 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 982 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 984 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor(fifo, fifo): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 988 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 989 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 990 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 991 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 992 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = chooseTwoActor(chooseTwoActor(pipe[i].getFuture(), never), never);
															#line 6691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 994 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 995 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 996 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 998 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("chooseTwoActor^2((fifo, never), never): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1002 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1003 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1004 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Promise<Void> p;
															#line 1005 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = oneWaitActor(chooseTwoActor(p.getFuture(), never));
															#line 1006 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					p.send(Void());
															#line 1007 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1009 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(chooseTwoActor(after, never)): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1013 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 1014 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out(N);
															#line 1015 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1016 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1017 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out[i] = oneWaitActor(chooseTwoActor(pipe[i].getFuture(), never));
															#line 6735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1019 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1020 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 1021 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out[i].isReady());
															#line 6743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1023 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("oneWaitActor(chooseTwoActor(fifo, never)): %0.1f M/sec\n", N / 1e6 / (timer() - start));
															#line 6747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1027 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1028 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1029 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Promise<Void> p;
															#line 1030 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(p.getFuture(), never);
															#line 1031 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> a = oneWaitActor(f);
															#line 1032 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> b = oneWaitActor(f);
															#line 1033 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					p.send(Void());
															#line 1034 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(f.isReady());
															#line 6766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1036 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("2xoneWaitActor(chooseTwoActor(after, never)): %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 6770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1040 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 1041 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out1(N);
															#line 1042 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out2(N);
															#line 1043 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1044 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1045 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(pipe[i].getFuture(), never);
															#line 1046 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out1[i] = oneWaitActor(f);
															#line 1047 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out2[i] = oneWaitActor(f);
															#line 6789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1049 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1050 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 1051 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out2[i].isReady());
															#line 6797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1053 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("2xoneWaitActor(chooseTwoActor(fifo, never)): %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 6801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1057 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 1058 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out1(N);
															#line 1059 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out2(N);
															#line 1060 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1061 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1062 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(oneWaitActor(pipe[i].getFuture()), never);
															#line 1063 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out1[i] = oneWaitActor(f);
															#line 1064 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out2[i] = oneWaitActor(f);
															#line 6820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1066 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1067 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 1068 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out2[i].isReady());
															#line 6828 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1070 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("2xoneWaitActor(chooseTwoActor(oneWaitActor(fifo), never)): %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 6832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1074 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> pipe(N);
															#line 1075 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out1(N);
															#line 1076 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> out2(N);
															#line 1077 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1078 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1079 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					g_cheese = pipe[i].getFuture();
															#line 1080 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> f = chooseTwoActor(cheeseWaitActor(), never);
															#line 1081 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					g_cheese = f;
															#line 1082 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out1[i] = cheeseWaitActor();
															#line 1083 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					out2[i] = cheeseWaitActor();
															#line 6855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1085 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1086 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					pipe[i].send(Void());
															#line 1087 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ASSERT(out2[i].isReady());
															#line 6863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1089 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("2xcheeseActor(chooseTwoActor(cheeseActor(fifo), never)): %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 1090 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("sizeof(CheeseWaitActorActor) == %zu\n", cheeseWaitActorSize());
															#line 6869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1094 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				PromiseStream<int> data;
															#line 1095 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1096 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				Future<int> sum = sumActor(data.getFuture());
															#line 1097 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1098 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					data.send(1);
															#line 6882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1099 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				data.sendError(end_of_stream());
															#line 1100 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				ASSERT(sum.get() == N);
															#line 1101 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("sumActor: %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 6890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			{
															#line 1105 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				start = timer();
															#line 1106 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Promise<Void>> ps(3);
															#line 1107 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				std::vector<Future<Void>> fs(3);
															#line 1109 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				for(int i = 0;i < N;i++) {
															#line 1110 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ps.clear();
															#line 1111 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					ps.resize(3);
															#line 1112 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					for(int j = 0;j < ps.size();j++) {
															#line 1113 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
						fs[j] = ps[j].getFuture();
															#line 6909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
					}
															#line 1115 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					Future<Void> q = quorum(fs, 2);
															#line 1116 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					for( auto& p : ps ) {
															#line 1117 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
						p.send(Void());
															#line 6917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
					}
				}
															#line 1119 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("quorum(2/3): %0.2f M/sec\n", N / 1e6 / (timer() - start));
															#line 6922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1122 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase816Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase816ActorState(); static_cast<FlowTestCase816Actor*>(this)->destroy(); return 0; }
															#line 6926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase816Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase816ActorState();
			static_cast<FlowTestCase816Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase816ActorState();
		static_cast<FlowTestCase816Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 816 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 6950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase816()
															#line 816 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase816Actor final : public Actor<Void>, public FastAllocated<FlowTestCase816Actor>, public FlowTestCase816ActorState<FlowTestCase816Actor> {
															#line 6955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase816Actor>::operator new;
	using FastAllocated<FlowTestCase816Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(929145079096651776UL, 8502459510526085120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 816 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase816Actor(UnitTestParameters const& params) 
															#line 6971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase816ActorState<FlowTestCase816Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase816", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9142938843537595136UL, 9074228770382408960UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase816Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase816");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase816", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 816 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase816( UnitTestParameters const& params ) {
															#line 816 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase816Actor(params));
															#line 7003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase816, "#flow/flow/perf/actor patterns")

#line 1124 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

template <class YAM>
struct YAMRandom {
	YAM yam;
	std::vector<Future<Void>> onchanges;
	int kmax;

	YAMRandom() : kmax(3) {}

	void randomOp() {
		if (deterministicRandom()->random01() < 0.01)
			while (!check_yield())
				;

		int k = deterministicRandom()->randomInt(0, kmax);
		int op = deterministicRandom()->randomInt(0, 7);
		// printf("%d",op);
		if (op == 0) {
			onchanges.push_back(yam.onChange(k));
		} else if (op == 1) {
			onchanges.push_back(trigger([this]() { this->randomOp(); }, yam.onChange(k)));
		} else if (op == 2) {
			if (onchanges.size()) {
				int i = deterministicRandom()->randomInt(0, onchanges.size());
				onchanges[i] = onchanges.back();
				onchanges.pop_back();
			}
		} else if (op == 3) {
			onchanges.clear();
		} else if (op == 4) {
			int v = deterministicRandom()->randomInt(0, 3);
			yam.set(k, v);
		} else if (op == 5) {
			yam.trigger(k);
		} else if (op == 6) {
			int a = deterministicRandom()->randomInt(0, kmax);
			int b = deterministicRandom()->randomInt(0, kmax);
			yam.triggerRange(std::min(a, b), std::max(a, b) + 1);
		}
	}
};

															#line 7050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1166()
															#line 1166 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1166Actor>
															#line 1166 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1166ActorState {
															#line 7057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1166 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1166ActorState(UnitTestParameters const& params) 
															#line 1166 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1166 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1167 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   yamr(),
															#line 1168 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   it()
															#line 7068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1166", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1166ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1166", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1169 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			it = 0;
															#line 7083 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1166ActorState();
		static_cast<FlowTestCase1166Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1173 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1166Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1166ActorState(); static_cast<FlowTestCase1166Actor*>(this)->destroy(); return 0; }
															#line 7106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1166Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1166ActorState();
		static_cast<FlowTestCase1166Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1169 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!(it < 100000))
															#line 7125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1170 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		yamr.randomOp();
															#line 1171 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 1171 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1166Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FlowTestCase1166Actor*>(this)->actor_wait_state = 1;
															#line 1171 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1166Actor, 0, Void >*>(static_cast<FlowTestCase1166Actor*>(this)));
															#line 7140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1169 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		it++;
															#line 7162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1169 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		it++;
															#line 7171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1166Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1166Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1166Actor*>(this)->ActorCallback< FlowTestCase1166Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1166Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1166", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1166Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1166", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1166Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1166", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1166Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1166", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1166Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1166", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1166Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1166", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1166 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1167 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	YAMRandom<YieldedAsyncMap<int, int>> yamr;
															#line 1168 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int it;
															#line 7257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1166()
															#line 1166 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1166Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1166Actor, 0, Void >, public FastAllocated<FlowTestCase1166Actor>, public FlowTestCase1166ActorState<FlowTestCase1166Actor> {
															#line 7262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1166Actor>::operator new;
	using FastAllocated<FlowTestCase1166Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11730245525641459712UL, 16623565334035206400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1166Actor, 0, Void >;
															#line 1166 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1166Actor(UnitTestParameters const& params) 
															#line 7279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1166ActorState<FlowTestCase1166Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1166", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18127639452445671168UL, 5262454231370465536UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1166Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1166");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1166", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1166Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1166 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1166( UnitTestParameters const& params ) {
															#line 1166 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1166Actor(params));
															#line 7312 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1166, "/flow/flow/YieldedAsyncMap/randomized")

#line 1175 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 7318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1176()
															#line 1176 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1176Actor>
															#line 1176 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1176ActorState {
															#line 7325 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1176 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1176ActorState(UnitTestParameters const& params) 
															#line 1176 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1176 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1177 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   yamr(),
															#line 1178 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   it()
															#line 7336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1176", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1176ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1176", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1179 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			it = 0;
															#line 7351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1176ActorState();
		static_cast<FlowTestCase1176Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1183 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1176Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1176ActorState(); static_cast<FlowTestCase1176Actor*>(this)->destroy(); return 0; }
															#line 7374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1176Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1176ActorState();
		static_cast<FlowTestCase1176Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1179 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!(it < 100000))
															#line 7393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1180 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		yamr.randomOp();
															#line 1181 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 1181 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1176Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FlowTestCase1176Actor*>(this)->actor_wait_state = 1;
															#line 1181 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1176Actor, 0, Void >*>(static_cast<FlowTestCase1176Actor*>(this)));
															#line 7408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1179 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		it++;
															#line 7430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1179 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		it++;
															#line 7439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1176Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1176Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1176Actor*>(this)->ActorCallback< FlowTestCase1176Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1176Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1176", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1176Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1176", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1176Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1176", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1176Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1176", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1176Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1176", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1176Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1176", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1176 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1177 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	YAMRandom<AsyncMap<int, int>> yamr;
															#line 1178 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int it;
															#line 7525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1176()
															#line 1176 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1176Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1176Actor, 0, Void >, public FastAllocated<FlowTestCase1176Actor>, public FlowTestCase1176ActorState<FlowTestCase1176Actor> {
															#line 7530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1176Actor>::operator new;
	using FastAllocated<FlowTestCase1176Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1762995064263474688UL, 7006980903125544448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1176Actor, 0, Void >;
															#line 1176 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1176Actor(UnitTestParameters const& params) 
															#line 7547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1176ActorState<FlowTestCase1176Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1176", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14456749515191257856UL, 10552004588775603456UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1176Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1176");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1176", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1176Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1176 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1176( UnitTestParameters const& params ) {
															#line 1176 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1176Actor(params));
															#line 7580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1176, "/flow/flow/AsyncMap/randomized")

#line 1185 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 7586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1186()
															#line 1186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1186Actor>
															#line 1186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1186ActorState {
															#line 7593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1186ActorState(UnitTestParameters const& params) 
															#line 1186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1187 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   yam(),
															#line 1188 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   y0(yam.onChange(1))
															#line 7604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1186", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1186ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1186", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1189 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			yam.setUnconditional(1, 0);
															#line 1190 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1 = yam.onChange(1);
															#line 1191 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1a = yam.onChange(1);
															#line 1192 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1b = yam.onChange(1);
															#line 1193 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			yam.set(1, 1);
															#line 1197 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y2 = yam.onChange(1);
															#line 1198 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = reportErrors(y0, "Y0");
															#line 1198 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state = 1;
															#line 1198 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1186Actor, 0, Void >*>(static_cast<FlowTestCase1186Actor*>(this)));
															#line 7638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1186ActorState();
		static_cast<FlowTestCase1186Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1199 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = reportErrors(y1, "Y1");
															#line 1199 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state = 2;
															#line 1199 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1186Actor, 1, Void >*>(static_cast<FlowTestCase1186Actor*>(this)));
															#line 7668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1199 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = reportErrors(y1, "Y1");
															#line 1199 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state = 2;
															#line 1199 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1186Actor, 1, Void >*>(static_cast<FlowTestCase1186Actor*>(this)));
															#line 7684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1186Actor*>(this)->ActorCallback< FlowTestCase1186Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1186Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1186Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1186Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = reportErrors(y1a, "Y1a");
															#line 1200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state = 3;
															#line 1200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1186Actor, 2, Void >*>(static_cast<FlowTestCase1186Actor*>(this)));
															#line 7775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = reportErrors(y1a, "Y1a");
															#line 1200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state = 3;
															#line 1200 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1186Actor, 2, Void >*>(static_cast<FlowTestCase1186Actor*>(this)));
															#line 7791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1186Actor*>(this)->ActorCallback< FlowTestCase1186Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1186Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1186Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase1186Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1201 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = reportErrors(y1b, "Y1b");
															#line 1201 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state = 4;
															#line 1201 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1186Actor, 3, Void >*>(static_cast<FlowTestCase1186Actor*>(this)));
															#line 7882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1201 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = reportErrors(y1b, "Y1b");
															#line 1201 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state = 4;
															#line 1201 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1186Actor, 3, Void >*>(static_cast<FlowTestCase1186Actor*>(this)));
															#line 7898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1186Actor*>(this)->ActorCallback< FlowTestCase1186Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1186Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1186Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase1186Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1202 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = reportErrors(timeout(y2, 5, Void()), "Y2");
															#line 1202 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state = 5;
															#line 1202 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1186Actor, 4, Void >*>(static_cast<FlowTestCase1186Actor*>(this)));
															#line 7989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1202 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = reportErrors(timeout(y2, 5, Void()), "Y2");
															#line 1202 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state = 5;
															#line 1202 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1186Actor, 4, Void >*>(static_cast<FlowTestCase1186Actor*>(this)));
															#line 8005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1186Actor*>(this)->ActorCallback< FlowTestCase1186Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1186Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1186Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase1186Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1204 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1186Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1186ActorState(); static_cast<FlowTestCase1186Actor*>(this)->destroy(); return 0; }
															#line 8089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1186Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1186ActorState();
		static_cast<FlowTestCase1186Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1204 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1186Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1186ActorState(); static_cast<FlowTestCase1186Actor*>(this)->destroy(); return 0; }
															#line 8101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1186Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1186ActorState();
		static_cast<FlowTestCase1186Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1186Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1186Actor*>(this)->ActorCallback< FlowTestCase1186Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1186Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1186Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase1186Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1187 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	YieldedAsyncMap<int, int> yam;
															#line 1188 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y0;
															#line 1190 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1;
															#line 1191 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1a;
															#line 1192 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1b;
															#line 1197 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y2;
															#line 8198 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1186()
															#line 1186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1186Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1186Actor, 0, Void >, public ActorCallback< FlowTestCase1186Actor, 1, Void >, public ActorCallback< FlowTestCase1186Actor, 2, Void >, public ActorCallback< FlowTestCase1186Actor, 3, Void >, public ActorCallback< FlowTestCase1186Actor, 4, Void >, public FastAllocated<FlowTestCase1186Actor>, public FlowTestCase1186ActorState<FlowTestCase1186Actor> {
															#line 8203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1186Actor>::operator new;
	using FastAllocated<FlowTestCase1186Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(852675921800110848UL, 2063326767368357632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1186Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase1186Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase1186Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase1186Actor, 3, Void >;
friend struct ActorCallback< FlowTestCase1186Actor, 4, Void >;
															#line 1186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1186Actor(UnitTestParameters const& params) 
															#line 8224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1186ActorState<FlowTestCase1186Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1186", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1738286934467440896UL, 8933937299544204288UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1186Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1186");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1186", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1186Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase1186Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase1186Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase1186Actor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase1186Actor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1186( UnitTestParameters const& params ) {
															#line 1186 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1186Actor(params));
															#line 8261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1186, "/flow/flow/YieldedAsyncMap/basic")

#line 1206 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 8267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1207()
															#line 1207 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1207Actor>
															#line 1207 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1207ActorState {
															#line 8274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1207 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1207ActorState(UnitTestParameters const& params) 
															#line 1207 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1207 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1208 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   yam()
															#line 8283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1207", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1207ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1207", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1214 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(yam.count(1) == 0);
															#line 1215 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1 = yam.onChange(1);
															#line 1216 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1a = yam.onChange(1);
															#line 1217 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1b = yam.onChange(1);
															#line 1218 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(yam.count(1) == 1);
															#line 1219 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1.cancel();
															#line 1220 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!y1a.isReady());
															#line 1221 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1a.cancel();
															#line 1222 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!y1b.isReady());
															#line 1223 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(yam.count(1) == 1);
															#line 1224 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			y1b.cancel();
															#line 1225 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(y1b.getError().code() == error_code_actor_cancelled);
															#line 1226 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(yam.count(1) == 0);
															#line 1228 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase1207Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1207ActorState(); static_cast<FlowTestCase1207Actor*>(this)->destroy(); return 0; }
															#line 8324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase1207Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1207ActorState();
			static_cast<FlowTestCase1207Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1207ActorState();
		static_cast<FlowTestCase1207Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1207 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1208 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	YieldedAsyncMap<int, int> yam;
															#line 1215 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1;
															#line 1216 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1a;
															#line 1217 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1b;
															#line 8356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1207()
															#line 1207 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1207Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1207Actor>, public FlowTestCase1207ActorState<FlowTestCase1207Actor> {
															#line 8361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1207Actor>::operator new;
	using FastAllocated<FlowTestCase1207Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16407836094227128832UL, 6216269694776621312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1207 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1207Actor(UnitTestParameters const& params) 
															#line 8377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1207ActorState<FlowTestCase1207Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1207", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14607670732684446208UL, 16302466078286692352UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1207Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1207");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1207", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1207 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1207( UnitTestParameters const& params ) {
															#line 1207 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1207Actor(params));
															#line 8409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1207, "/flow/flow/YieldedAsyncMap/cancel")

#line 1230 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 8415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1231()
															#line 1231 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1231Actor>
															#line 1231 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1231ActorState {
															#line 8422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1231 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1231ActorState(UnitTestParameters const& params) 
															#line 1231 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1231 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1232 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   yam(),
															#line 1234 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   y1(yam.onChange(1)),
															#line 1235 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   y2(yam.onChange(2))
															#line 8435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1231", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1231ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1231", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1237 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			auto* pyam = &yam;
															#line 1238 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			uncancellable(trigger( [pyam]() { printf("Triggered\n"); pyam->triggerAll(); }, delay(1)));
															#line 1245 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = y1;
															#line 1245 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1231Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase1231Actor*>(this)->actor_wait_state = 1;
															#line 1245 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1231Actor, 0, Void >*>(static_cast<FlowTestCase1231Actor*>(this)));
															#line 8461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1231ActorState();
		static_cast<FlowTestCase1231Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1246 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		printf("Got y1\n");
															#line 1247 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		y2.cancel();
															#line 1249 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1231Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1231ActorState(); static_cast<FlowTestCase1231Actor*>(this)->destroy(); return 0; }
															#line 8488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1231Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1231ActorState();
		static_cast<FlowTestCase1231Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1246 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		printf("Got y1\n");
															#line 1247 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		y2.cancel();
															#line 1249 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1231Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1231ActorState(); static_cast<FlowTestCase1231Actor*>(this)->destroy(); return 0; }
															#line 8504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1231Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1231ActorState();
		static_cast<FlowTestCase1231Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1231Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1231Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1231Actor*>(this)->ActorCallback< FlowTestCase1231Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1231Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1231", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1231Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1231", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1231Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1231", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1231Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1231", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1231Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1231", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1231Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1231", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1231 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1232 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	YieldedAsyncMap<int, int> yam;
															#line 1234 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y1;
															#line 1235 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> y2;
															#line 8595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1231()
															#line 1231 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1231Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1231Actor, 0, Void >, public FastAllocated<FlowTestCase1231Actor>, public FlowTestCase1231ActorState<FlowTestCase1231Actor> {
															#line 8600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1231Actor>::operator new;
	using FastAllocated<FlowTestCase1231Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11922229023001729536UL, 2329481196031997184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1231Actor, 0, Void >;
															#line 1231 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1231Actor(UnitTestParameters const& params) 
															#line 8617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1231ActorState<FlowTestCase1231Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1231", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17967236156097063936UL, 3908181541628337152UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1231Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1231");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1231", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1231Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1231 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1231( UnitTestParameters const& params ) {
															#line 1231 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1231Actor(params));
															#line 8650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1231, "/flow/flow/YieldedAsyncMap/cancel2")

#line 1251 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 8656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1252()
															#line 1252 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1252Actor>
															#line 1252 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1252ActorState {
															#line 8663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1252 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1252ActorState(UnitTestParameters const& params) 
															#line 1252 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1252 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 8670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1252", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1252ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1252", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1253 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			AsyncVar<int> av;
															#line 1254 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> ch = av.onChange();
															#line 1255 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!ch.isReady());
															#line 1256 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			av.set(5);
															#line 1257 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(ch.isReady());
															#line 1258 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(av.get() == 5);
															#line 1260 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ch = av.onChange();
															#line 1261 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(!ch.isReady());
															#line 1262 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			av.set(6);
															#line 1263 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(ch.isReady());
															#line 1264 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(av.get() == 6);
															#line 1266 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase1252Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1252ActorState(); static_cast<FlowTestCase1252Actor*>(this)->destroy(); return 0; }
															#line 8707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase1252Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1252ActorState();
			static_cast<FlowTestCase1252Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1252ActorState();
		static_cast<FlowTestCase1252Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1252 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 8731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1252()
															#line 1252 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1252Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1252Actor>, public FlowTestCase1252ActorState<FlowTestCase1252Actor> {
															#line 8736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1252Actor>::operator new;
	using FastAllocated<FlowTestCase1252Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12755178624352399360UL, 4146910505090493440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1252 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1252Actor(UnitTestParameters const& params) 
															#line 8752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1252ActorState<FlowTestCase1252Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1252", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2689630791879058944UL, 14654883308312933888UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1252Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1252");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1252", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1252 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1252( UnitTestParameters const& params ) {
															#line 1252 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1252Actor(params));
															#line 8784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1252, "/flow/flow/AsyncVar/basic")

#line 1268 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 8790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via waitAfterCancel()
															#line 1269 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class WaitAfterCancelActor>
															#line 1269 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class WaitAfterCancelActorState {
															#line 8797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1269 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	WaitAfterCancelActorState(int* const& output) 
															#line 1269 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1269 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : output(output)
															#line 8804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("waitAfterCancel", reinterpret_cast<unsigned long>(this));

	}
	~WaitAfterCancelActorState() 
	{
		fdb_probe_actor_destroy("waitAfterCancel", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1270 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			*output = 0;
															#line 8819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			try {
															#line 1272 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_0 = Never();
															#line 1272 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<WaitAfterCancelActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitAfterCancelActor*>(this)->actor_wait_state = 1;
															#line 1272 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitAfterCancelActor, 0, Void >*>(static_cast<WaitAfterCancelActor*>(this)));
															#line 8830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitAfterCancelActorState();
		static_cast<WaitAfterCancelActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1276 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(false);
															#line 1277 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<WaitAfterCancelActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitAfterCancelActorState(); static_cast<WaitAfterCancelActor*>(this)->destroy(); return 0; }
															#line 8861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<WaitAfterCancelActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitAfterCancelActorState();
		static_cast<WaitAfterCancelActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 1274 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = (*output = 1, Future<Void>(Void()));
															#line 1274 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<WaitAfterCancelActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitAfterCancelActor*>(this)->actor_wait_state = 2;
															#line 1274 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitAfterCancelActor, 1, Void >*>(static_cast<WaitAfterCancelActor*>(this)));
															#line 8881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitAfterCancelActor*>(this)->actor_wait_state > 0) static_cast<WaitAfterCancelActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAfterCancelActor*>(this)->ActorCallback< WaitAfterCancelActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAfterCancelActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAfterCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitAfterCancelActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAfterCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitAfterCancelActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAfterCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitAfterCancelActor*>(this)->actor_wait_state > 0) static_cast<WaitAfterCancelActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAfterCancelActor*>(this)->ActorCallback< WaitAfterCancelActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAfterCancelActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAfterCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitAfterCancelActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAfterCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitAfterCancelActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAfterCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1269 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int* output;
															#line 9081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via waitAfterCancel()
															#line 1269 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class WaitAfterCancelActor final : public Actor<Void>, public ActorCallback< WaitAfterCancelActor, 0, Void >, public ActorCallback< WaitAfterCancelActor, 1, Void >, public FastAllocated<WaitAfterCancelActor>, public WaitAfterCancelActorState<WaitAfterCancelActor> {
															#line 9086 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<WaitAfterCancelActor>::operator new;
	using FastAllocated<WaitAfterCancelActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7258997630097297664UL, 8361933243873820672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitAfterCancelActor, 0, Void >;
friend struct ActorCallback< WaitAfterCancelActor, 1, Void >;
															#line 1269 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	WaitAfterCancelActor(int* const& output) 
															#line 9104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   WaitAfterCancelActorState<WaitAfterCancelActor>(output),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitAfterCancel", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8552318013271824384UL, 8060922132594515456UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAfterCancelActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitAfterCancel");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitAfterCancel", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitAfterCancelActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitAfterCancelActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1269 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> waitAfterCancel( int* const& output ) {
															#line 1269 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new WaitAfterCancelActor(output));
															#line 9138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1279 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 9143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1280()
															#line 1280 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1280Actor>
															#line 1280 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1280ActorState {
															#line 9150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1280 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1280ActorState(UnitTestParameters const& params) 
															#line 1280 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1280 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 9157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1280", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1280ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1280", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1281 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			int a = -1;
															#line 1282 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Future<Void> f = waitAfterCancel(&a);
															#line 1283 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(a == 0);
															#line 1284 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			f.cancel();
															#line 1285 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(a == 1);
															#line 1286 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase1280Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1280ActorState(); static_cast<FlowTestCase1280Actor*>(this)->destroy(); return 0; }
															#line 9182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase1280Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1280ActorState();
			static_cast<FlowTestCase1280Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1280ActorState();
		static_cast<FlowTestCase1280Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1280 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 9206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1280()
															#line 1280 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1280Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1280Actor>, public FlowTestCase1280ActorState<FlowTestCase1280Actor> {
															#line 9211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1280Actor>::operator new;
	using FastAllocated<FlowTestCase1280Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3063121240513781248UL, 15599334166507688448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1280 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1280Actor(UnitTestParameters const& params) 
															#line 9227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1280ActorState<FlowTestCase1280Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1280", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13551065953393990400UL, 10825675489703680512UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1280Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1280");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1280", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1280 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1280( UnitTestParameters const& params ) {
															#line 1280 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1280Actor(params));
															#line 9259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1280, "/fdbrpc/flow/wait_expression_after_cancel_flow")

#line 1288 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

// Tests for https://github.com/apple/foundationdb/issues/1226

template <class>
struct ShouldNotGoIntoClassContextStack;

class Foo1 {
public:
	explicit Foo1(int x) : x(x) {}
	Future<int> foo() { return fooActor(this); }
																#line 9274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
static Future<int> fooActor( Foo1* const& self );
template <class> friend class Foo1_FooActorActorState;

#line 1299 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

private:
	int x;
};
															#line 9283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
// This generated class is to be used only via fooActor()
															#line 1303 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Foo1_FooActorActor>
															#line 1303 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo1_FooActorActorState {
															#line 9289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1303 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo1_FooActorActorState(Foo1* const& self) 
															#line 1303 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1303 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : self(self)
															#line 9296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("fooActor", reinterpret_cast<unsigned long>(this));

	}
	~Foo1_FooActorActorState() 
	{
		fdb_probe_actor_destroy("fooActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1304 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>();
															#line 1304 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<Foo1_FooActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Foo1_FooActorActor*>(this)->actor_wait_state = 1;
															#line 1304 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Foo1_FooActorActor, 0, Void >*>(static_cast<Foo1_FooActorActor*>(this)));
															#line 9318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Foo1_FooActorActorState();
		static_cast<Foo1_FooActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1305 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo1_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo1_FooActorActorState(); static_cast<Foo1_FooActorActor*>(this)->destroy(); return 0; }
															#line 9341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo1_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo1_FooActorActorState();
		static_cast<Foo1_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1305 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo1_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo1_FooActorActorState(); static_cast<Foo1_FooActorActor*>(this)->destroy(); return 0; }
															#line 9353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo1_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo1_FooActorActorState();
		static_cast<Foo1_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Foo1_FooActorActor*>(this)->actor_wait_state > 0) static_cast<Foo1_FooActorActor*>(this)->actor_wait_state = 0;
		static_cast<Foo1_FooActorActor*>(this)->ActorCallback< Foo1_FooActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Foo1_FooActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo1_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Foo1_FooActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo1_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Foo1_FooActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Foo1_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1303 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo1* self;
															#line 9438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via fooActor()
															#line 1303 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo1_FooActorActor final : public Actor<int>, public ActorCallback< Foo1_FooActorActor, 0, Void >, public FastAllocated<Foo1_FooActorActor>, public Foo1_FooActorActorState<Foo1_FooActorActor> {
															#line 9443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<Foo1_FooActorActor>::operator new;
	using FastAllocated<Foo1_FooActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11846124074999377920UL, 12556913620182957824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Foo1_FooActorActor, 0, Void >;
															#line 1303 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo1_FooActorActor(Foo1* const& self) 
															#line 9460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   Foo1_FooActorActorState<Foo1_FooActorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14379396290541012992UL, 3095081568235468032UL);
		ActorExecutionContextHelper __helper(static_cast<Foo1_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fooActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Foo1_FooActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1303 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<int> Foo1::fooActor( Foo1* const& self ) {
															#line 1303 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Foo1_FooActorActor(self));
															#line 9492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1307 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

class [[nodiscard]] Foo2 {
public:
	explicit Foo2(int x) : x(x) {}
	Future<int> foo() { return fooActor(this); }
																#line 9501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
static Future<int> fooActor( Foo2* const& self );
template <class> friend class Foo2_FooActorActorState;

#line 1313 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

private:
	int x;
};
															#line 9510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
// This generated class is to be used only via fooActor()
															#line 1317 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Foo2_FooActorActor>
															#line 1317 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo2_FooActorActorState {
															#line 9516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1317 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo2_FooActorActorState(Foo2* const& self) 
															#line 1317 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1317 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : self(self)
															#line 9523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("fooActor", reinterpret_cast<unsigned long>(this));

	}
	~Foo2_FooActorActorState() 
	{
		fdb_probe_actor_destroy("fooActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1318 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>();
															#line 1318 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<Foo2_FooActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Foo2_FooActorActor*>(this)->actor_wait_state = 1;
															#line 1318 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Foo2_FooActorActor, 0, Void >*>(static_cast<Foo2_FooActorActor*>(this)));
															#line 9545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Foo2_FooActorActorState();
		static_cast<Foo2_FooActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1319 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo2_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo2_FooActorActorState(); static_cast<Foo2_FooActorActor*>(this)->destroy(); return 0; }
															#line 9568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo2_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo2_FooActorActorState();
		static_cast<Foo2_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1319 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo2_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo2_FooActorActorState(); static_cast<Foo2_FooActorActor*>(this)->destroy(); return 0; }
															#line 9580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo2_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo2_FooActorActorState();
		static_cast<Foo2_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Foo2_FooActorActor*>(this)->actor_wait_state > 0) static_cast<Foo2_FooActorActor*>(this)->actor_wait_state = 0;
		static_cast<Foo2_FooActorActor*>(this)->ActorCallback< Foo2_FooActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Foo2_FooActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo2_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Foo2_FooActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo2_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Foo2_FooActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Foo2_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1317 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo2* self;
															#line 9665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via fooActor()
															#line 1317 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo2_FooActorActor final : public Actor<int>, public ActorCallback< Foo2_FooActorActor, 0, Void >, public FastAllocated<Foo2_FooActorActor>, public Foo2_FooActorActorState<Foo2_FooActorActor> {
															#line 9670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<Foo2_FooActorActor>::operator new;
	using FastAllocated<Foo2_FooActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11846124074999377920UL, 12556913620182957824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Foo2_FooActorActor, 0, Void >;
															#line 1317 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo2_FooActorActor(Foo2* const& self) 
															#line 9687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   Foo2_FooActorActorState<Foo2_FooActorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5980048447256649728UL, 16289667340815723008UL);
		ActorExecutionContextHelper __helper(static_cast<Foo2_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fooActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Foo2_FooActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1317 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<int> Foo2::fooActor( Foo2* const& self ) {
															#line 1317 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Foo2_FooActorActor(self));
															#line 9719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1321 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

class alignas(4) Foo3 {
public:
	explicit Foo3(int x) : x(x) {}
	Future<int> foo() { return fooActor(this); }
																#line 9728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
static Future<int> fooActor( Foo3* const& self );
template <class> friend class Foo3_FooActorActorState;

#line 1327 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

private:
	int x;
};
															#line 9737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
// This generated class is to be used only via fooActor()
															#line 1331 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Foo3_FooActorActor>
															#line 1331 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo3_FooActorActorState {
															#line 9743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1331 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo3_FooActorActorState(Foo3* const& self) 
															#line 1331 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1331 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : self(self)
															#line 9750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("fooActor", reinterpret_cast<unsigned long>(this));

	}
	~Foo3_FooActorActorState() 
	{
		fdb_probe_actor_destroy("fooActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1332 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>();
															#line 1332 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<Foo3_FooActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Foo3_FooActorActor*>(this)->actor_wait_state = 1;
															#line 1332 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Foo3_FooActorActor, 0, Void >*>(static_cast<Foo3_FooActorActor*>(this)));
															#line 9772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Foo3_FooActorActorState();
		static_cast<Foo3_FooActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1333 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo3_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo3_FooActorActorState(); static_cast<Foo3_FooActorActor*>(this)->destroy(); return 0; }
															#line 9795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo3_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo3_FooActorActorState();
		static_cast<Foo3_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1333 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo3_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo3_FooActorActorState(); static_cast<Foo3_FooActorActor*>(this)->destroy(); return 0; }
															#line 9807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo3_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo3_FooActorActorState();
		static_cast<Foo3_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Foo3_FooActorActor*>(this)->actor_wait_state > 0) static_cast<Foo3_FooActorActor*>(this)->actor_wait_state = 0;
		static_cast<Foo3_FooActorActor*>(this)->ActorCallback< Foo3_FooActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Foo3_FooActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo3_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Foo3_FooActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo3_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Foo3_FooActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Foo3_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1331 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo3* self;
															#line 9892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via fooActor()
															#line 1331 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo3_FooActorActor final : public Actor<int>, public ActorCallback< Foo3_FooActorActor, 0, Void >, public FastAllocated<Foo3_FooActorActor>, public Foo3_FooActorActorState<Foo3_FooActorActor> {
															#line 9897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<Foo3_FooActorActor>::operator new;
	using FastAllocated<Foo3_FooActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11846124074999377920UL, 12556913620182957824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Foo3_FooActorActor, 0, Void >;
															#line 1331 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo3_FooActorActor(Foo3* const& self) 
															#line 9914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   Foo3_FooActorActorState<Foo3_FooActorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(836691685770628608UL, 3656172371739853056UL);
		ActorExecutionContextHelper __helper(static_cast<Foo3_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fooActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Foo3_FooActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1331 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<int> Foo3::fooActor( Foo3* const& self ) {
															#line 1331 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Foo3_FooActorActor(self));
															#line 9946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1335 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

struct Super {};

class Foo4 : Super {
public:
	explicit Foo4(int x) : x(x) {}
	Future<int> foo() { return fooActor(this); }
																#line 9957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
static Future<int> fooActor( Foo4* const& self );
template <class> friend class Foo4_FooActorActorState;

#line 1343 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

private:
	int x;
};
															#line 9966 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
// This generated class is to be used only via fooActor()
															#line 1347 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Foo4_FooActorActor>
															#line 1347 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo4_FooActorActorState {
															#line 9972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1347 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo4_FooActorActorState(Foo4* const& self) 
															#line 1347 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1347 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : self(self)
															#line 9979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("fooActor", reinterpret_cast<unsigned long>(this));

	}
	~Foo4_FooActorActorState() 
	{
		fdb_probe_actor_destroy("fooActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1348 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>();
															#line 1348 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<Foo4_FooActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Foo4_FooActorActor*>(this)->actor_wait_state = 1;
															#line 1348 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Foo4_FooActorActor, 0, Void >*>(static_cast<Foo4_FooActorActor*>(this)));
															#line 10001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Foo4_FooActorActorState();
		static_cast<Foo4_FooActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1349 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo4_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo4_FooActorActorState(); static_cast<Foo4_FooActorActor*>(this)->destroy(); return 0; }
															#line 10024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo4_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo4_FooActorActorState();
		static_cast<Foo4_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1349 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Foo4_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Foo4_FooActorActorState(); static_cast<Foo4_FooActorActor*>(this)->destroy(); return 0; }
															#line 10036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Foo4_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Foo4_FooActorActorState();
		static_cast<Foo4_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Foo4_FooActorActor*>(this)->actor_wait_state > 0) static_cast<Foo4_FooActorActor*>(this)->actor_wait_state = 0;
		static_cast<Foo4_FooActorActor*>(this)->ActorCallback< Foo4_FooActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Foo4_FooActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo4_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Foo4_FooActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Foo4_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Foo4_FooActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Foo4_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1347 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo4* self;
															#line 10121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via fooActor()
															#line 1347 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Foo4_FooActorActor final : public Actor<int>, public ActorCallback< Foo4_FooActorActor, 0, Void >, public FastAllocated<Foo4_FooActorActor>, public Foo4_FooActorActorState<Foo4_FooActorActor> {
															#line 10126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<Foo4_FooActorActor>::operator new;
	using FastAllocated<Foo4_FooActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11846124074999377920UL, 12556913620182957824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Foo4_FooActorActor, 0, Void >;
															#line 1347 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Foo4_FooActorActor(Foo4* const& self) 
															#line 10143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   Foo4_FooActorActorState<Foo4_FooActorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10335068724183540736UL, 10041851579328590592UL);
		ActorExecutionContextHelper __helper(static_cast<Foo4_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fooActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Foo4_FooActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1347 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<int> Foo4::fooActor( Foo4* const& self ) {
															#line 1347 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Foo4_FooActorActor(self));
															#line 10175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1351 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

struct Outer {
	class Foo5 : Super {
	public:
		explicit Foo5(int x) : x(x) {}
		Future<int> foo() { return fooActor(this); }
																	#line 10185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
static Future<int> fooActor( Foo5* const& self );
template <class> friend class Outer_Foo5_FooActorActorState;

#line 1358 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

	private:
		int x;
	};
};
															#line 10195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
// This generated class is to be used only via fooActor()
															#line 1363 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class Outer_Foo5_FooActorActor>
															#line 1363 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Outer_Foo5_FooActorActorState {
															#line 10201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1363 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Outer_Foo5_FooActorActorState(Outer::Foo5* const& self) 
															#line 1363 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1363 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : self(self)
															#line 10208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("fooActor", reinterpret_cast<unsigned long>(this));

	}
	~Outer_Foo5_FooActorActorState() 
	{
		fdb_probe_actor_destroy("fooActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1364 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>();
															#line 1364 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<Outer_Foo5_FooActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Outer_Foo5_FooActorActor*>(this)->actor_wait_state = 1;
															#line 1364 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Outer_Foo5_FooActorActor, 0, Void >*>(static_cast<Outer_Foo5_FooActorActor*>(this)));
															#line 10230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Outer_Foo5_FooActorActorState();
		static_cast<Outer_Foo5_FooActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1365 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Outer_Foo5_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Outer_Foo5_FooActorActorState(); static_cast<Outer_Foo5_FooActorActor*>(this)->destroy(); return 0; }
															#line 10253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Outer_Foo5_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Outer_Foo5_FooActorActorState();
		static_cast<Outer_Foo5_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1365 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<Outer_Foo5_FooActorActor*>(this)->SAV<int>::futures) { (void)(self->x); this->~Outer_Foo5_FooActorActorState(); static_cast<Outer_Foo5_FooActorActor*>(this)->destroy(); return 0; }
															#line 10265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<Outer_Foo5_FooActorActor*>(this)->SAV< int >::value()) int(self->x);
		this->~Outer_Foo5_FooActorActorState();
		static_cast<Outer_Foo5_FooActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Outer_Foo5_FooActorActor*>(this)->actor_wait_state > 0) static_cast<Outer_Foo5_FooActorActor*>(this)->actor_wait_state = 0;
		static_cast<Outer_Foo5_FooActorActor*>(this)->ActorCallback< Outer_Foo5_FooActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Outer_Foo5_FooActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Outer_Foo5_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Outer_Foo5_FooActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Outer_Foo5_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Outer_Foo5_FooActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Outer_Foo5_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1363 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Outer::Foo5* self;
															#line 10350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via fooActor()
															#line 1363 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class Outer_Foo5_FooActorActor final : public Actor<int>, public ActorCallback< Outer_Foo5_FooActorActor, 0, Void >, public FastAllocated<Outer_Foo5_FooActorActor>, public Outer_Foo5_FooActorActorState<Outer_Foo5_FooActorActor> {
															#line 10355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<Outer_Foo5_FooActorActor>::operator new;
	using FastAllocated<Outer_Foo5_FooActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11846124074999377920UL, 12556913620182957824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Outer_Foo5_FooActorActor, 0, Void >;
															#line 1363 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Outer_Foo5_FooActorActor(Outer::Foo5* const& self) 
															#line 10372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<int>(),
		   Outer_Foo5_FooActorActorState<Outer_Foo5_FooActorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fooActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3544515340740103424UL, 6737337361604354048UL);
		ActorExecutionContextHelper __helper(static_cast<Outer_Foo5_FooActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fooActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fooActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Outer_Foo5_FooActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1363 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<int> Outer::Foo5::fooActor( Outer::Foo5* const& self ) {
															#line 1363 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<int>(new Outer_Foo5_FooActorActor(self));
															#line 10404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1367 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

// Meant to be run with -fsanitize=undefined
															#line 10410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1369()
															#line 1369 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1369Actor>
															#line 1369 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1369ActorState {
															#line 10417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1369 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1369ActorState(UnitTestParameters const& params) 
															#line 1369 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1369 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 10424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1369", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1369ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1369", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1370 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt(std::numeric_limits<int>::min(), 0);
															#line 1371 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt(0, std::numeric_limits<int>::max());
															#line 1372 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt(std::numeric_limits<int>::min(), std::numeric_limits<int>::max());
															#line 1373 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(deterministicRandom()->randomInt(std::numeric_limits<int>::min(), std::numeric_limits<int>::min() + 1) == std::numeric_limits<int>::min());
															#line 1375 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(deterministicRandom()->randomInt(std::numeric_limits<int>::max() - 1, std::numeric_limits<int>::max()) == std::numeric_limits<int>::max() - 1);
															#line 1378 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt64(std::numeric_limits<int64_t>::min(), 0);
															#line 1379 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt64(0, std::numeric_limits<int64_t>::max());
															#line 1380 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			deterministicRandom()->randomInt64(std::numeric_limits<int64_t>::min(), std::numeric_limits<int64_t>::max());
															#line 1381 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(deterministicRandom()->randomInt64(std::numeric_limits<int64_t>::min(), std::numeric_limits<int64_t>::min() + 1) == std::numeric_limits<int64_t>::min());
															#line 1384 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(deterministicRandom()->randomInt64(std::numeric_limits<int64_t>::max() - 1, std::numeric_limits<int64_t>::max()) == std::numeric_limits<int64_t>::max() - 1);
															#line 1387 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (!static_cast<FlowTestCase1369Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1369ActorState(); static_cast<FlowTestCase1369Actor*>(this)->destroy(); return 0; }
															#line 10459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			new (&static_cast<FlowTestCase1369Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1369ActorState();
			static_cast<FlowTestCase1369Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1369ActorState();
		static_cast<FlowTestCase1369Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1369 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 10483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1369()
															#line 1369 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1369Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1369Actor>, public FlowTestCase1369ActorState<FlowTestCase1369Actor> {
															#line 10488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1369Actor>::operator new;
	using FastAllocated<FlowTestCase1369Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1341414054801042432UL, 6397194934623433216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1369 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1369Actor(UnitTestParameters const& params) 
															#line 10504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1369ActorState<FlowTestCase1369Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1369", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9718179561515472640UL, 6683504548597062656UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1369Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1369");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1369", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 1369 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1369( UnitTestParameters const& params ) {
															#line 1369 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1369Actor(params));
															#line 10536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1369, "/flow/DeterministicRandom/SignedOverflow")

#line 1389 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

struct Tracker {
	int copied;
	bool moved;
	Tracker(int copied = 0) : copied(copied), moved(false) {}
	Tracker(Tracker&& other) : Tracker(other.copied) {
		ASSERT(!other.moved);
		other.moved = true;
	}
	Tracker& operator=(Tracker&& other) {
		ASSERT(!other.moved);
		other.moved = true;
		this->moved = false;
		this->copied = other.copied;
		return *this;
	}
	Tracker(const Tracker& other) : Tracker(other.copied + 1) { ASSERT(!other.moved); }
	Tracker& operator=(const Tracker& other) {
		ASSERT(!other.moved);
		this->moved = false;
		this->copied = other.copied + 1;
		return *this;
	}
	~Tracker() = default;

																#line 10566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
// This generated class is to be used only via listen()
															#line 1414 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class ListenActor>
															#line 1414 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ListenActorState {
															#line 10572 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1414 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ListenActorState(FutureStream<Tracker> const& stream) 
															#line 1414 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1414 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : stream(stream)
															#line 10579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("listen", reinterpret_cast<unsigned long>(this));

	}
	~ListenActorState() 
	{
		fdb_probe_actor_destroy("listen", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1415 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			FutureStream<Tracker> __when_expr_0 = stream;
															#line 1415 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<ListenActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<ListenActor*>(this)->actor_wait_state = 1;
															#line 1415 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ListenActor, 0, Tracker >*>(static_cast<ListenActor*>(this)));
															#line 10601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListenActorState();
		static_cast<ListenActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tracker const& movedTracker,int loopDepth) 
	{
															#line 1416 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1417 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 1418 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<ListenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListenActorState(); static_cast<ListenActor*>(this)->destroy(); return 0; }
															#line 10628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<ListenActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListenActorState();
		static_cast<ListenActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Tracker && movedTracker,int loopDepth) 
	{
															#line 1416 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1417 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 1418 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<ListenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListenActorState(); static_cast<ListenActor*>(this)->destroy(); return 0; }
															#line 10644 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<ListenActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListenActorState();
		static_cast<ListenActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Tracker const& movedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont1(movedTracker, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tracker && movedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(movedTracker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListenActor*>(this)->actor_wait_state > 0) static_cast<ListenActor*>(this)->actor_wait_state = 0;
		static_cast<ListenActor*>(this)->ActorSingleCallback< ListenActor, 0, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ListenActor, 0, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("listen", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listen", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ListenActor, 0, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("listen", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listen", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ListenActor, 0, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("listen", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listen", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1414 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FutureStream<Tracker> stream;
															#line 10729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via listen()
															#line 1414 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class ListenActor final : public Actor<Void>, public ActorSingleCallback< ListenActor, 0, Tracker >, public FastAllocated<ListenActor>, public ListenActorState<ListenActor> {
															#line 10734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<ListenActor>::operator new;
	using FastAllocated<ListenActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8070856756647013376UL, 4963681315490206720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ListenActor, 0, Tracker >;
															#line 1414 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	ListenActor(FutureStream<Tracker> const& stream) 
															#line 10751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   ListenActorState<ListenActor>(stream),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listen", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9989528927518907392UL, 7817939837473479168UL);
		ActorExecutionContextHelper __helper(static_cast<ListenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listen");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listen", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ListenActor, 0, Tracker >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1414 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> listen( FutureStream<Tracker> const& stream ) {
															#line 1414 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new ListenActor(stream));
															#line 10783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1420 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
};

															#line 10789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1422()
															#line 1422 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1422Actor>
															#line 1422 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1422ActorState {
															#line 10796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1422 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1422ActorState(UnitTestParameters const& params) 
															#line 1422 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1422 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1423 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   stream(),
															#line 1424 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   listener()
															#line 10807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1422", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1422ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1422", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			{
															#line 1428 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				listener = Tracker::listen(stream.getFuture());
															#line 1429 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				stream.send(Tracker{});
															#line 1430 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				StrictFuture<Void> __when_expr_0 = listener;
															#line 1430 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state = 1;
															#line 1430 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1422Actor, 0, Void >*>(static_cast<FlowTestCase1422Actor*>(this)));
															#line 10834 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1422ActorState();
		static_cast<FlowTestCase1422Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 1436 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			listener = Tracker::listen(stream.getFuture());
															#line 1437 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Tracker namedTracker;
															#line 1438 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(namedTracker);
															#line 1439 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = listener;
															#line 1439 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state = 2;
															#line 1439 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1422Actor, 1, Void >*>(static_cast<FlowTestCase1422Actor*>(this)));
															#line 10872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1422Actor*>(this)->ActorCallback< FlowTestCase1422Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1422Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1422Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1422Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		{
															#line 1444 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(Tracker{});
															#line 1445 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(Tracker{});
															#line 10972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1447 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				FutureStream<Tracker> __when_expr_2 = stream.getFuture();
															#line 1447 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.pop(), loopDepth); };
				static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state = 3;
															#line 1447 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1422Actor, 2, Tracker >*>(static_cast<FlowTestCase1422Actor*>(this)));
															#line 10983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1422Actor*>(this)->ActorCallback< FlowTestCase1422Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1422Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1422Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase1422Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		{
															#line 1460 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Tracker namedTracker1;
															#line 1461 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			Tracker namedTracker2;
															#line 1462 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(namedTracker1);
															#line 1463 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(namedTracker2);
															#line 11088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1465 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				FutureStream<Tracker> __when_expr_4 = stream.getFuture();
															#line 1465 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.pop(), loopDepth); };
				static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state = 5;
															#line 1465 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1422Actor, 4, Tracker >*>(static_cast<FlowTestCase1422Actor*>(this)));
															#line 11099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
		{
															#line 1452 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			FutureStream<Tracker> __when_expr_3 = stream.getFuture();
															#line 1452 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.pop(), loopDepth); };
			static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state = 4;
															#line 1452 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1422Actor, 3, Tracker >*>(static_cast<FlowTestCase1422Actor*>(this)));
															#line 11118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1448 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1449 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 11130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Tracker const& __movedTracker,int loopDepth) 
	{
															#line 1447 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		movedTracker = __movedTracker;
															#line 11139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Tracker && __movedTracker,int loopDepth) 
	{
		movedTracker = std::move(__movedTracker);
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1422Actor*>(this)->ActorSingleCallback< FlowTestCase1422Actor, 2, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1422Actor, 2, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1422Actor, 2, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1422Actor, 2, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Tracker const& movedTracker,int loopDepth) 
	{
															#line 1453 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1454 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 11226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Tracker && movedTracker,int loopDepth) 
	{
															#line 1453 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1454 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 11237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Tracker const& movedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont10(movedTracker, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Tracker && movedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(movedTracker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1422Actor*>(this)->ActorSingleCallback< FlowTestCase1422Actor, 3, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1422Actor, 3, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1422Actor, 3, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1422Actor, 3, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 1478 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1422Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1422ActorState(); static_cast<FlowTestCase1422Actor*>(this)->destroy(); return 0; }
															#line 11321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1422Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1422ActorState();
		static_cast<FlowTestCase1422Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
		{
															#line 1471 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			FutureStream<Tracker> __when_expr_5 = stream.getFuture();
															#line 1471 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12when1(__when_expr_5.pop(), loopDepth); };
			static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state = 6;
															#line 1471 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1422Actor, 5, Tracker >*>(static_cast<FlowTestCase1422Actor*>(this)));
															#line 11341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
															#line 1466 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!copiedTracker.moved);
															#line 1468 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(copiedTracker.copied == 1);
															#line 11353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Tracker const& __copiedTracker,int loopDepth) 
	{
															#line 1465 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		copiedTracker = __copiedTracker;
															#line 11362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Tracker && __copiedTracker,int loopDepth) 
	{
		copiedTracker = std::move(__copiedTracker);
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1422Actor*>(this)->ActorSingleCallback< FlowTestCase1422Actor, 4, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1422Actor, 4, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1422Actor, 4, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1422Actor, 4, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2(Tracker const& copiedTracker,int loopDepth) 
	{
															#line 1472 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!copiedTracker.moved);
															#line 1474 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(copiedTracker.copied == 1);
															#line 11449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2(Tracker && copiedTracker,int loopDepth) 
	{
															#line 1472 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!copiedTracker.moved);
															#line 1474 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(copiedTracker.copied == 1);
															#line 11460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Tracker const& copiedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(copiedTracker, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Tracker && copiedTracker,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(std::move(copiedTracker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1422Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1422Actor*>(this)->ActorSingleCallback< FlowTestCase1422Actor, 5, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1422Actor, 5, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1422Actor, 5, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1422Actor, 5, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1422 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1423 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	PromiseStream<Tracker> stream;
															#line 1424 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Future<Void> listener;
															#line 1447 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Tracker movedTracker;
															#line 1465 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Tracker copiedTracker;
															#line 11550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1422()
															#line 1422 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1422Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1422Actor, 0, Void >, public ActorCallback< FlowTestCase1422Actor, 1, Void >, public ActorSingleCallback< FlowTestCase1422Actor, 2, Tracker >, public ActorSingleCallback< FlowTestCase1422Actor, 3, Tracker >, public ActorSingleCallback< FlowTestCase1422Actor, 4, Tracker >, public ActorSingleCallback< FlowTestCase1422Actor, 5, Tracker >, public FastAllocated<FlowTestCase1422Actor>, public FlowTestCase1422ActorState<FlowTestCase1422Actor> {
															#line 11555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1422Actor>::operator new;
	using FastAllocated<FlowTestCase1422Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12573469777688413952UL, 6645002612959974400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1422Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase1422Actor, 1, Void >;
friend struct ActorSingleCallback< FlowTestCase1422Actor, 2, Tracker >;
friend struct ActorSingleCallback< FlowTestCase1422Actor, 3, Tracker >;
friend struct ActorSingleCallback< FlowTestCase1422Actor, 4, Tracker >;
friend struct ActorSingleCallback< FlowTestCase1422Actor, 5, Tracker >;
															#line 1422 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1422Actor(UnitTestParameters const& params) 
															#line 11577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1422ActorState<FlowTestCase1422Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1422", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16643454032856909312UL, 12848179780549830400UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1422Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1422");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1422", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1422Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase1422Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorSingleCallback< FlowTestCase1422Actor, 2, Tracker >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorSingleCallback< FlowTestCase1422Actor, 3, Tracker >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorSingleCallback< FlowTestCase1422Actor, 4, Tracker >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorSingleCallback< FlowTestCase1422Actor, 5, Tracker >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1422 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1422( UnitTestParameters const& params ) {
															#line 1422 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1422Actor(params));
															#line 11615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1422, "/flow/flow/PromiseStream/move")

#line 1480 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 11621 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1481()
															#line 1481 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1481Actor>
															#line 1481 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1481ActorState {
															#line 11628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1481 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1481ActorState(UnitTestParameters const& params) 
															#line 1481 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1481 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params)
															#line 11635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1481", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1481ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1481", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1482 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			PromiseStream<Tracker> stream;
															#line 1483 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			stream.send(Tracker{});
															#line 1484 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			FutureStream<Tracker> __when_expr_0 = stream.getFuture();
															#line 1484 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1481Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<FlowTestCase1481Actor*>(this)->actor_wait_state = 1;
															#line 1484 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< FlowTestCase1481Actor, 0, Tracker >*>(static_cast<FlowTestCase1481Actor*>(this)));
															#line 11661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1481ActorState();
		static_cast<FlowTestCase1481Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Tracker const& tracker,int loopDepth) 
	{
															#line 1485 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		Tracker movedTracker = std::move(tracker);
															#line 1486 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(tracker.moved);
															#line 1487 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1488 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 1489 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1481Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1481ActorState(); static_cast<FlowTestCase1481Actor*>(this)->destroy(); return 0; }
															#line 11692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1481Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1481ActorState();
		static_cast<FlowTestCase1481Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Tracker && tracker,int loopDepth) 
	{
															#line 1485 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		Tracker movedTracker = std::move(tracker);
															#line 1486 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(tracker.moved);
															#line 1487 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(!movedTracker.moved);
															#line 1488 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(movedTracker.copied == 0);
															#line 1489 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1481Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1481ActorState(); static_cast<FlowTestCase1481Actor*>(this)->destroy(); return 0; }
															#line 11712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1481Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1481ActorState();
		static_cast<FlowTestCase1481Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Tracker const& tracker,int loopDepth) 
	{
		loopDepth = a_body1cont1(tracker, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Tracker && tracker,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tracker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1481Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1481Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1481Actor*>(this)->ActorSingleCallback< FlowTestCase1481Actor, 0, Tracker >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1481Actor, 0, Tracker >*,Tracker const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1481", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1481Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1481", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< FlowTestCase1481Actor, 0, Tracker >*,Tracker && value) 
	{
		fdb_probe_actor_enter("flowTestCase1481", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1481Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1481", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< FlowTestCase1481Actor, 0, Tracker >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1481", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1481Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1481", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1481 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 11797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1481()
															#line 1481 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1481Actor final : public Actor<Void>, public ActorSingleCallback< FlowTestCase1481Actor, 0, Tracker >, public FastAllocated<FlowTestCase1481Actor>, public FlowTestCase1481ActorState<FlowTestCase1481Actor> {
															#line 11802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1481Actor>::operator new;
	using FastAllocated<FlowTestCase1481Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(268981558425403136UL, 6276531314146671104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< FlowTestCase1481Actor, 0, Tracker >;
															#line 1481 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1481Actor(UnitTestParameters const& params) 
															#line 11819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1481ActorState<FlowTestCase1481Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1481", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17885741520709295872UL, 260216317027384832UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1481Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1481");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1481", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< FlowTestCase1481Actor, 0, Tracker >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1481 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1481( UnitTestParameters const& params ) {
															#line 1481 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1481Actor(params));
															#line 11852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1481, "/flow/flow/PromiseStream/move2")

#line 1491 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

constexpr double mutexTestDelay = 0.00001;

															#line 11860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via mutexTest()
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class MutexTestActor>
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class MutexTestActorState {
															#line 11867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	MutexTestActorState(int const& id,FlowMutex* const& mutex,int const& n,bool const& allowError,bool* const& verbose) 
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : id(id),
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   mutex(mutex),
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   n(n),
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   allowError(allowError),
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   verbose(verbose)
															#line 11882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("mutexTest", reinterpret_cast<unsigned long>(this));

	}
	~MutexTestActorState() 
	{
		fdb_probe_actor_destroy("mutexTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1495 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			;
															#line 11897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MutexTestActorState();
		static_cast<MutexTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1538 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 11920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1539 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d Returning\n", id);
															#line 11924 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1541 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<MutexTestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MutexTestActorState(); static_cast<MutexTestActor*>(this)->destroy(); return 0; }
															#line 11928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<MutexTestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MutexTestActorState();
		static_cast<MutexTestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1495 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!(n-- > 0))
															#line 11947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1496 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		d = deterministicRandom()->random01() * mutexTestDelay;
															#line 1497 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 11955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1498 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d:%d wait %f while unlocked\n", id, n, d);
															#line 11959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1500 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(d);
															#line 1500 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<MutexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MutexTestActor*>(this)->actor_wait_state = 1;
															#line 1500 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MutexTestActor, 0, Void >*>(static_cast<MutexTestActor*>(this)));
															#line 11970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1502 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 11992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1503 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d:%d locking\n", id, n);
															#line 11996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1505 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<FlowMutex::Lock> __when_expr_1 = mutex->take();
															#line 1505 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<MutexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12002 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MutexTestActor*>(this)->actor_wait_state = 2;
															#line 1505 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*>(static_cast<MutexTestActor*>(this)));
															#line 12007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1502 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 12016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1503 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d:%d locking\n", id, n);
															#line 12020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1505 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<FlowMutex::Lock> __when_expr_1 = mutex->take();
															#line 1505 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<MutexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MutexTestActor*>(this)->actor_wait_state = 2;
															#line 1505 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*>(static_cast<MutexTestActor*>(this)));
															#line 12031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MutexTestActor*>(this)->actor_wait_state > 0) static_cast<MutexTestActor*>(this)->actor_wait_state = 0;
		static_cast<MutexTestActor*>(this)->ActorCallback< MutexTestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MutexTestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 1506 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 12115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1507 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d:%d locked\n", id, n);
															#line 12119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1510 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		d = deterministicRandom()->random01() * mutexTestDelay;
															#line 1511 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (*verbose)
															#line 12125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1512 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d:%d wait %f while locked\n", id, n, d);
															#line 12129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1514 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(d);
															#line 1514 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<MutexTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<MutexTestActor*>(this)->actor_wait_state = 3;
															#line 1514 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MutexTestActor, 2, Void >*>(static_cast<MutexTestActor*>(this)));
															#line 12140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(FlowMutex::Lock const& __lock,int loopDepth) 
	{
															#line 1505 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		lock = __lock;
															#line 12149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(FlowMutex::Lock && __lock,int loopDepth) 
	{
		lock = std::move(__lock);
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MutexTestActor*>(this)->actor_wait_state > 0) static_cast<MutexTestActor*>(this)->actor_wait_state = 0;
		static_cast<MutexTestActor*>(this)->ActorCallback< MutexTestActor, 1, FlowMutex::Lock >::remove();

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*,FlowMutex::Lock const& value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*,FlowMutex::Lock && value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*,Error err) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 1517 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (n == 0 && allowError)
															#line 12228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1518 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 12232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1520 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (*verbose)
															#line 12236 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				{
															#line 1521 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					printf("%d:%d sending error\n", id, n);
															#line 12240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1523 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				lock.error(end_of_stream());
															#line 12244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			else
			{
															#line 1526 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (*verbose)
															#line 12250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				{
															#line 1527 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					printf("%d:%d dropping promise, returning without unlock\n", id, n);
															#line 12254 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 1531 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (*verbose)
															#line 12262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1532 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("%d:%d unlocking\n", id, n);
															#line 12266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1534 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			lock.release();
															#line 12270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 1517 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (n == 0 && allowError)
															#line 12280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1518 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 12284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1520 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (*verbose)
															#line 12288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				{
															#line 1521 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					printf("%d:%d sending error\n", id, n);
															#line 12292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
															#line 1523 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				lock.error(end_of_stream());
															#line 12296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
			else
			{
															#line 1526 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				if (*verbose)
															#line 12302 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				{
															#line 1527 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
					printf("%d:%d dropping promise, returning without unlock\n", id, n);
															#line 12306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 1531 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (*verbose)
															#line 12314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1532 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("%d:%d unlocking\n", id, n);
															#line 12318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1534 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			lock.release();
															#line 12322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MutexTestActor*>(this)->actor_wait_state > 0) static_cast<MutexTestActor*>(this)->actor_wait_state = 0;
		static_cast<MutexTestActor*>(this)->ActorCallback< MutexTestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MutexTestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MutexTestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int id;
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowMutex* mutex;
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int n;
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool allowError;
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool* verbose;
															#line 1496 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	double d;
															#line 1505 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowMutex::Lock lock;
															#line 12417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via mutexTest()
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class MutexTestActor final : public Actor<Void>, public ActorCallback< MutexTestActor, 0, Void >, public ActorCallback< MutexTestActor, 1, FlowMutex::Lock >, public ActorCallback< MutexTestActor, 2, Void >, public FastAllocated<MutexTestActor>, public MutexTestActorState<MutexTestActor> {
															#line 12422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<MutexTestActor>::operator new;
	using FastAllocated<MutexTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3410550076216667904UL, 4520187146348999168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MutexTestActor, 0, Void >;
friend struct ActorCallback< MutexTestActor, 1, FlowMutex::Lock >;
friend struct ActorCallback< MutexTestActor, 2, Void >;
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	MutexTestActor(int const& id,FlowMutex* const& mutex,int const& n,bool const& allowError,bool* const& verbose) 
															#line 12441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   MutexTestActorState<MutexTestActor>(id, mutex, n, allowError, verbose),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("mutexTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12647773376049955584UL, 1562998753292856064UL);
		ActorExecutionContextHelper __helper(static_cast<MutexTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("mutexTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("mutexTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MutexTestActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MutexTestActor, 1, FlowMutex::Lock >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MutexTestActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
Future<Void> mutexTest( int const& id, FlowMutex* const& mutex, int const& n, bool const& allowError, bool* const& verbose ) {
															#line 1494 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new MutexTestActor(id, mutex, n, allowError, verbose));
															#line 12476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}

#line 1543 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"

															#line 12481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1544()
															#line 1544 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
template <class FlowTestCase1544Actor>
															#line 1544 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1544ActorState {
															#line 12488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
															#line 1544 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1544ActorState(UnitTestParameters const& params) 
															#line 1544 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
															#line 1544 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		 : params(params),
															#line 1545 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   count(100000),
															#line 1548 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   verboseSetting(false),
															#line 1550 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		   verboseTestIteration(-1)
															#line 12501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1544", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1544ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1544", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1553 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				verbose = verboseSetting || count == verboseTestIteration;
															#line 1555 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				;
															#line 12519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1544ActorState();
		static_cast<FlowTestCase1544Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1611 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!static_cast<FlowTestCase1544Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1544ActorState(); static_cast<FlowTestCase1544Actor*>(this)->destroy(); return 0; }
															#line 12548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		new (&static_cast<FlowTestCase1544Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1544ActorState();
		static_cast<FlowTestCase1544Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1607 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("Error at count=%d\n", count + 1);
															#line 1608 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			ASSERT(false);
															#line 12563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1555 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!(--count > 0))
															#line 12591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1556 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (count % 1000 == 0)
															#line 12597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1557 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("%d tests left\n", count);
															#line 12601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1560 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		mutex = FlowMutex();
															#line 1561 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		tests = std::vector<Future<Void>>();
															#line 1563 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		allowErrors = deterministicRandom()->coinflip();
															#line 1564 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (verbose)
															#line 12611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1565 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("\nTesting allowErrors=%d\n", allowErrors);
															#line 12615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1568 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		error = Optional<Error>();
															#line 12619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		try {
															#line 1571 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			for(int i = 0;i < 10;++i) {
															#line 1572 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				tests.push_back(mutexTest(i, &mutex, 10, allowErrors, &verbose));
															#line 12625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1574 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(tests);
															#line 1574 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1544Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase1544Actor*>(this)->actor_wait_state = 1;
															#line 1574 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1544Actor, 0, Void >*>(static_cast<FlowTestCase1544Actor*>(this)));
															#line 12636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1604 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		ASSERT(error.present() == allowErrors);
															#line 12664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1583 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (verbose)
															#line 12674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1584 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("Caught error %s\n", e.what());
															#line 12678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1586 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			error = e;
															#line 1590 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			i = int();
															#line 1591 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (verbose)
															#line 12686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1592 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("Waiting for completions.  Future end states:\n");
															#line 12690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1594 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			i = 0;
															#line 12694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = a_body1loopBody1Catch1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1576 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (allowErrors)
															#line 12709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1577 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (verbose)
															#line 12713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1578 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("Final wait in case error was injected by the last actor to finish\n");
															#line 12717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1580 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(mutex.take());
															#line 1580 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1544Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase1544Actor*>(this)->actor_wait_state = 2;
															#line 1580 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1544Actor, 1, Void >*>(static_cast<FlowTestCase1544Actor*>(this)));
															#line 12728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1576 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (allowErrors)
															#line 12742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1577 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (verbose)
															#line 12746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			{
															#line 1578 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
				printf("Final wait in case error was injected by the last actor to finish\n");
															#line 12750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			}
															#line 1580 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(mutex.take());
															#line 1580 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			if (static_cast<FlowTestCase1544Actor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase1544Actor*>(this)->actor_wait_state = 2;
															#line 1580 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1544Actor, 1, Void >*>(static_cast<FlowTestCase1544Actor*>(this)));
															#line 12761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1544Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1544Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1544Actor*>(this)->ActorCallback< FlowTestCase1544Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1544Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1544", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1544Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1544", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1544Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1544", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1544Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1544", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1544Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1544", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1544Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1544", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase1544Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1544Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1544Actor*>(this)->ActorCallback< FlowTestCase1544Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1544Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1544", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1544Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1544", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1544Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1544", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1544Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1544", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase1544Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1544", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1544Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1544", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1Catch1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1(int loopDepth) 
	{
															#line 1594 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (!(i < tests.size()))
															#line 12969 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
			return a_body1loopBody1Catch1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1595 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		StrictFuture<ErrorOr<Void>> __when_expr_2 = errorOr(tests[i]);
															#line 1595 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (static_cast<FlowTestCase1544Actor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 12977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1Catch1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase1544Actor*>(this)->actor_wait_state = 3;
															#line 1595 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1544Actor, 2, ErrorOr<Void> >*>(static_cast<FlowTestCase1544Actor*>(this)));
															#line 12982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(ErrorOr<Void> const& f,int loopDepth) 
	{
															#line 1596 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (verbose)
															#line 13004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1597 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("  %d: %s\n", i, f.isError() ? f.getError().what() : "done");
															#line 13008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1594 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		++i;
															#line 13012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1cont1(ErrorOr<Void> && f,int loopDepth) 
	{
															#line 1596 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		if (verbose)
															#line 13021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		{
															#line 1597 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
			printf("  %d: %s\n", i, f.isError() ? f.getError().what() : "done");
															#line 13025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		}
															#line 1594 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
		++i;
															#line 13029 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1Catch1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(ErrorOr<Void> const& f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(f, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1loopBody1when1(ErrorOr<Void> && f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1loopBody1cont1(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase1544Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1544Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1544Actor*>(this)->ActorCallback< FlowTestCase1544Actor, 2, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1544Actor, 2, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1544", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1544Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1544", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1544Actor, 2, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("flowTestCase1544", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1544Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1544", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase1544Actor, 2, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1544", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1544Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1544", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1544 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	UnitTestParameters params;
															#line 1545 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int count;
															#line 1548 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool verboseSetting;
															#line 1550 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int verboseTestIteration;
															#line 1553 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool verbose;
															#line 1560 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowMutex mutex;
															#line 1561 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	std::vector<Future<Void>> tests;
															#line 1563 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	bool allowErrors;
															#line 1568 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	Optional<Error> error;
															#line 1590 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	int i;
															#line 13142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1544()
															#line 1544 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
class FlowTestCase1544Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1544Actor, 0, Void >, public ActorCallback< FlowTestCase1544Actor, 1, Void >, public ActorCallback< FlowTestCase1544Actor, 2, ErrorOr<Void> >, public FastAllocated<FlowTestCase1544Actor>, public FlowTestCase1544ActorState<FlowTestCase1544Actor> {
															#line 13147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1544Actor>::operator new;
	using FastAllocated<FlowTestCase1544Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2550258543850509568UL, 3172923864231116800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1544Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase1544Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase1544Actor, 2, ErrorOr<Void> >;
															#line 1544 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	FlowTestCase1544Actor(UnitTestParameters const& params) 
															#line 13166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1544ActorState<FlowTestCase1544Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1544", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10967335952439595520UL, 2003649519829015040UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1544Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1544");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1544", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1544Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase1544Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase1544Actor, 2, ErrorOr<Void> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1544 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
static Future<Void> flowTestCase1544( UnitTestParameters const& params ) {
															#line 1544 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
	return Future<Void>(new FlowTestCase1544Actor(params));
															#line 13201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbrpc/FlowTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1544, "/flow/flow/FlowMutex")

#line 1613 "/Users/ec2-user/foundationdb/fdbrpc/FlowTests.actor.cpp"
