#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
/*
 * RESTUtils.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/RESTUtils.h"
#include "fdbclient/Knobs.h"

#include "flow/flat_buffers.h"
#include "flow/UnitTest.h"
#include "flow/IConnection.h"

#include <boost/algorithm/string.hpp>
#include <queue>

#include "flow/actorcompiler.h" // always the last include

const std::unordered_map<std::string, RESTConnectionType> RESTConnectionType::supportedConnTypes = {
	{ "http", RESTConnectionType("http", RESTConnectionType::NOT_SECURE_CONNECTION) },
	{ "https", RESTConnectionType("https", RESTConnectionType::SECURE_CONNECTION) }
};

RESTConnectionType RESTConnectionType::getConnectionType(const std::string& protocol) {
	auto itr = RESTConnectionType::supportedConnTypes.find(protocol);
	if (itr == RESTConnectionType::supportedConnTypes.end()) {
		TraceEvent("RESTConnectionTypeUnsupportedPrototocol").detail("Protocol", protocol);
		CODE_PROBE(true, "REST URI unsupported protocol");
		throw rest_unsupported_protocol();
	}
	return itr->second;
}

bool RESTConnectionType::isProtocolSupported(const std::string& protocol) {
	auto itr = RESTConnectionType::supportedConnTypes.find(protocol);
	return itr != RESTConnectionType::supportedConnTypes.end();
}

bool RESTConnectionType::isSecure(const std::string& protocol) {
	auto itr = RESTConnectionType::supportedConnTypes.find(protocol);
	if (itr == RESTConnectionType::supportedConnTypes.end()) {
		TraceEvent("RESTConnectionTypeUnsupportedPrototocol").detail("Protocol", protocol);
		throw rest_unsupported_protocol();
	}
	return itr->second.secure == RESTConnectionType::SECURE_CONNECTION;
}

RESTClientKnobs::RESTClientKnobs() {
	connection_pool_size = FLOW_KNOBS->RESTCLIENT_MAX_CONNECTIONPOOL_SIZE;
	connect_tries = FLOW_KNOBS->RESTCLIENT_CONNECT_TRIES;
	connect_timeout = FLOW_KNOBS->RESTCLIENT_CONNECT_TIMEOUT;
	max_connection_life = FLOW_KNOBS->RESTCLIENT_MAX_CONNECTION_LIFE;
	request_tries = FLOW_KNOBS->RESTCLIENT_REQUEST_TRIES;
	request_timeout_secs = FLOW_KNOBS->RESTCLIENT_REQUEST_TIMEOUT_SEC;

	knobMap["connection_pool_size"] = std::addressof(connection_pool_size);
	knobMap["pz"] = std::addressof(connection_pool_size);
	knobMap["connect_tries"] = std::addressof(connect_tries);
	knobMap["ct"] = std::addressof(connect_tries);
	knobMap["connect_timeout"] = std::addressof(connect_timeout);
	knobMap["cto"] = std::addressof(connect_timeout);
	knobMap["max_connection_life"] = std::addressof(max_connection_life);
	knobMap["mcl"] = std::addressof(max_connection_life);
	knobMap["request_tries"] = std::addressof(request_tries);
	knobMap["rt"] = std::addressof(request_tries);
	knobMap["request_timeout_secs"] = std::addressof(request_timeout_secs);
	knobMap["rtom"] = std::addressof(request_timeout_secs);
}

void RESTClientKnobs::set(const std::unordered_map<std::string, int>& knobSettings) {

	for (const auto& itr : knobSettings) {
		const auto& kItr = RESTClientKnobs::knobMap.find(itr.first);
		if (kItr == RESTClientKnobs::knobMap.end()) {
			TraceEvent("RESTClientInvalidKnobName").detail("KnobName", itr.first);
			throw rest_invalid_rest_client_knob();
		}
		ASSERT_EQ(itr.first.compare(kItr->first), 0);
		*(kItr->second) = itr.second;
	}
}

std::unordered_map<std::string, int> RESTClientKnobs::get() const {
	std::unordered_map<std::string, int> details = {
		{ "connection_pool_size", connection_pool_size },
		{ "connect_tries", connect_tries },
		{ "connect_timeout", connect_timeout },
		{ "max_connection_life", max_connection_life },
		{ "request_tries", request_tries },
		{ "request_timeout_secs", request_timeout_secs },
	};

	return details;
}

															#line 112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
namespace {
// This generated class is to be used only via connect_impl()
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class Connect_implActor>
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class Connect_implActorState {
															#line 119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	Connect_implActorState(Reference<RESTConnectionPool> const& connectionPool,RESTConnectionPoolKey const& connectKey,bool const& isSecure,int const& maxConnLife) 
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : connectionPool(connectionPool),
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		   connectKey(connectKey),
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		   isSecure(isSecure),
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		   maxConnLife(maxConnLife)
															#line 132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("connect_impl", reinterpret_cast<unsigned long>(this));

	}
	~Connect_implActorState() 
	{
		fdb_probe_actor_destroy("connect_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 115 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (FLOW_KNOBS->REST_LOG_LEVEL >= RESTLogSeverity::VERBOSE)
															#line 147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
			{
															#line 116 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
				TraceEvent("RESTUtilConnectStart") .detail("Host", connectKey.first) .detail("Service", connectKey.second) .detail("IsSecure", isSecure) .detail("ConnectPoolNumKeys", connectionPool->connectionPoolMap.size());
															#line 151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
			}
															#line 123 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			auto poolItr = connectionPool->connectionPoolMap.find(connectKey);
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			for(;poolItr != connectionPool->connectionPoolMap.end() && !poolItr->second.empty();) {
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
				RESTConnectionPool::ReusableConnection rconn = poolItr->second.front();
															#line 126 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
				poolItr->second.pop();
															#line 128 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
				if (rconn.expirationTime > now())
															#line 163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
				{
															#line 129 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
					if (FLOW_KNOBS->REST_LOG_LEVEL >= RESTLogSeverity::DEBUG)
															#line 167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
					{
															#line 130 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
						TraceEvent("RESTUtilReuseConn") .detail("Host", connectKey.first) .detail("Service", connectKey.second) .detail("RemoteEndpoint", rconn.conn->getPeerAddress()) .detail("ExpireIn", rconn.expirationTime - now()) .detail("NumConnsInPool", poolItr->second.size());
															#line 171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
					}
															#line 137 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
					if (!static_cast<Connect_implActor*>(this)->SAV<RESTConnectionPool::ReusableConnection>::futures) { (void)(rconn); this->~Connect_implActorState(); static_cast<Connect_implActor*>(this)->destroy(); return 0; }
															#line 175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
					new (&static_cast<Connect_implActor*>(this)->SAV< RESTConnectionPool::ReusableConnection >::value()) RESTConnectionPool::ReusableConnection(rconn);
					this->~Connect_implActorState();
					static_cast<Connect_implActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 141 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT(poolItr == connectionPool->connectionPoolMap.end() || poolItr->second.empty());
															#line 144 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			StrictFuture<Reference<IConnection>> __when_expr_0 = INetworkConnections::net()->connect(connectKey.first, connectKey.second, isSecure);
															#line 144 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (static_cast<Connect_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<Connect_implActor*>(this)->actor_wait_state = 1;
															#line 144 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Connect_implActor, 0, Reference<IConnection> >*>(static_cast<Connect_implActor*>(this)));
															#line 193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Connect_implActorState();
		static_cast<Connect_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 146 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = conn->connectHandshake();
															#line 146 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		if (static_cast<Connect_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<Connect_implActor*>(this)->actor_wait_state = 2;
															#line 146 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Connect_implActor, 1, Void >*>(static_cast<Connect_implActor*>(this)));
															#line 223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IConnection> const& __conn,int loopDepth) 
	{
															#line 144 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		conn = __conn;
															#line 232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IConnection> && __conn,int loopDepth) 
	{
		conn = std::move(__conn);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Connect_implActor*>(this)->actor_wait_state > 0) static_cast<Connect_implActor*>(this)->actor_wait_state = 0;
		static_cast<Connect_implActor*>(this)->ActorCallback< Connect_implActor, 0, Reference<IConnection> >::remove();

	}
	void a_callback_fire(ActorCallback< Connect_implActor, 0, Reference<IConnection> >*,Reference<IConnection> const& value) 
	{
		fdb_probe_actor_enter("connect_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Connect_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Connect_implActor, 0, Reference<IConnection> >*,Reference<IConnection> && value) 
	{
		fdb_probe_actor_enter("connect_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Connect_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Connect_implActor, 0, Reference<IConnection> >*,Error err) 
	{
		fdb_probe_actor_enter("connect_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Connect_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		TraceEvent("RESTTUilCreateNewConn") .suppressFor(60) .detail("Host", connectKey.first) .detail("Service", connectKey.second) .detail("RemoteEndpoint", conn->getPeerAddress()) .detail("ConnPoolSize", connectionPool->connectionPoolMap.size());
															#line 155 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		if (!static_cast<Connect_implActor*>(this)->SAV<RESTConnectionPool::ReusableConnection>::futures) { (void)(RESTConnectionPool::ReusableConnection({ conn, now() + maxConnLife })); this->~Connect_implActorState(); static_cast<Connect_implActor*>(this)->destroy(); return 0; }
															#line 313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		new (&static_cast<Connect_implActor*>(this)->SAV< RESTConnectionPool::ReusableConnection >::value()) RESTConnectionPool::ReusableConnection(RESTConnectionPool::ReusableConnection({ conn, now() + maxConnLife }));
		this->~Connect_implActorState();
		static_cast<Connect_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		TraceEvent("RESTTUilCreateNewConn") .suppressFor(60) .detail("Host", connectKey.first) .detail("Service", connectKey.second) .detail("RemoteEndpoint", conn->getPeerAddress()) .detail("ConnPoolSize", connectionPool->connectionPoolMap.size());
															#line 155 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		if (!static_cast<Connect_implActor*>(this)->SAV<RESTConnectionPool::ReusableConnection>::futures) { (void)(RESTConnectionPool::ReusableConnection({ conn, now() + maxConnLife })); this->~Connect_implActorState(); static_cast<Connect_implActor*>(this)->destroy(); return 0; }
															#line 327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		new (&static_cast<Connect_implActor*>(this)->SAV< RESTConnectionPool::ReusableConnection >::value()) RESTConnectionPool::ReusableConnection(RESTConnectionPool::ReusableConnection({ conn, now() + maxConnLife }));
		this->~Connect_implActorState();
		static_cast<Connect_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Connect_implActor*>(this)->actor_wait_state > 0) static_cast<Connect_implActor*>(this)->actor_wait_state = 0;
		static_cast<Connect_implActor*>(this)->ActorCallback< Connect_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Connect_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("connect_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Connect_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Connect_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("connect_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Connect_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Connect_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("connect_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Connect_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	Reference<RESTConnectionPool> connectionPool;
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	RESTConnectionPoolKey connectKey;
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	bool isSecure;
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	int maxConnLife;
															#line 144 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	Reference<IConnection> conn;
															#line 420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
};
// This generated class is to be used only via connect_impl()
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class Connect_implActor final : public Actor<RESTConnectionPool::ReusableConnection>, public ActorCallback< Connect_implActor, 0, Reference<IConnection> >, public ActorCallback< Connect_implActor, 1, Void >, public FastAllocated<Connect_implActor>, public Connect_implActorState<Connect_implActor> {
															#line 425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
	using FastAllocated<Connect_implActor>::operator new;
	using FastAllocated<Connect_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7193658812118870784UL, 8522018774875170048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RESTConnectionPool::ReusableConnection>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Connect_implActor, 0, Reference<IConnection> >;
friend struct ActorCallback< Connect_implActor, 1, Void >;
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	Connect_implActor(Reference<RESTConnectionPool> const& connectionPool,RESTConnectionPoolKey const& connectKey,bool const& isSecure,int const& maxConnLife) 
															#line 443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		 : Actor<RESTConnectionPool::ReusableConnection>(),
		   Connect_implActorState<Connect_implActor>(connectionPool, connectKey, isSecure, maxConnLife),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("connect_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7092978256320716288UL, 13901349198287939840UL);
		ActorExecutionContextHelper __helper(static_cast<Connect_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("connect_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("connect_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Connect_implActor, 0, Reference<IConnection> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Connect_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
[[nodiscard]] Future<RESTConnectionPool::ReusableConnection> connect_impl( Reference<RESTConnectionPool> const& connectionPool, RESTConnectionPoolKey const& connectKey, bool const& isSecure, int const& maxConnLife ) {
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<RESTConnectionPool::ReusableConnection>(new Connect_implActor(connectionPool, connectKey, isSecure, maxConnLife));
															#line 477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
}

#line 157 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"

Future<RESTConnectionPool::ReusableConnection> RESTConnectionPool::connect(RESTConnectionPoolKey connectKey,
                                                                           const bool isSecure,
                                                                           const int maxConnLife) {
	return connect_impl(Reference<RESTConnectionPool>::addRef(this), connectKey, isSecure, maxConnLife);
}

void RESTConnectionPool::returnConnection(RESTConnectionPoolKey connectKey,
                                          ReusableConnection& rconn,
                                          const int maxConnections) {
	if (FLOW_KNOBS->REST_LOG_LEVEL >= RESTLogSeverity::VERBOSE) {
		TraceEvent("RESTUtilReturnConnStart")
		    .detail("Host", connectKey.first)
		    .detail("Service", connectKey.second)
		    .detail("ConnectPoolNumKeys", connectionPoolMap.size());
	}

	auto poolItr = connectionPoolMap.find(connectKey);
	// If it expires in the future then add it to the pool in the front iff connection pool size is not maxed
	if (rconn.expirationTime > now()) {
		bool returned = true;
		if (poolItr == connectionPoolMap.end()) {
			connectionPoolMap.insert({ connectKey, std::queue<RESTConnectionPool::ReusableConnection>({ rconn }) });
		} else if (poolItr->second.size() < maxConnections) {
			poolItr->second.push(rconn);
		} else {
			// Connection pool at its capacity; do nothing
			returned = false;
		}

		if (FLOW_KNOBS->REST_LOG_LEVEL >= RESTLogSeverity::DEBUG && returned) {
			poolItr = connectionPoolMap.find(connectKey);
			TraceEvent("RESTUtilReturnConnToPool")
			    .detail("Host", connectKey.first)
			    .detail("Service", connectKey.second)
			    .detail("ConnPoolSize", connectionPoolMap.size())
			    .detail("CachedConns", poolItr->second.size())
			    .detail("TimeToExpire", rconn.expirationTime - now());
		}
	}
	rconn.conn = Reference<IConnection>();
}

RESTUrl::RESTUrl(const std::string& fUrl) {
	parseUrl(fUrl);
}

RESTUrl::RESTUrl(const std::string& fullUrl, const std::string& b) : body(b) {
	parseUrl(fullUrl);
}

void RESTUrl::parseUrl(const std::string& fullUrl) {
	// Sample valid URIs
	// 1. With 'host' & 'resource' := '<protocol>://<host>/<resource>'
	// 2. With 'host', 'service' & 'resource' := '<protocol>://<host>:port/<resource>'
	// 3. With 'host', 'service', 'resource' & 'reqParameters' := '<protocol>://<host>:port/<resource>?<parameter-list>'

	if (FLOW_KNOBS->REST_LOG_LEVEL >= RESTLogSeverity::VERBOSE) {
		TraceEvent("RESTParseURI").detail("URI", fullUrl);
	}

	try {
		StringRef t(fullUrl);
		StringRef p = t.eat("://");
		std::string protocol = p.toString();
		boost::algorithm::to_lower(protocol);
		this->connType = RESTConnectionType::getConnectionType(protocol);
		if (!this->connType.secure && !CLIENT_KNOBS->REST_KMS_ALLOW_NOT_SECURE_CONNECTION) {
			TraceEvent(SevWarnAlways, "RESTUtilsUnSupportedNotSecureConn").detail("Protocol", protocol);
			CODE_PROBE(true, "REST URI not-secure connection not supported");
			throw rest_unsupported_protocol();
		}

		// extract 'resource' and optional 'parameter list' if supplied in the URL
		uint8_t foundSeparator = 0;
		StringRef hostPort = t.eatAny("/?", &foundSeparator);
		this->resource = "/";
		if (foundSeparator == '/') {
			this->resource += t.eat("?").toString();
			this->reqParameters = t.eat().toString();
		}

		// hostPort is at least a host or IP address, optionally followed by :portNumber or :serviceName
		StringRef hRef(hostPort);
		StringRef h = hRef.eat(":");
		if (h.size() == 0) {
			CODE_PROBE(true, "REST URI empty host");
			throw std::string("host cannot be empty");
		}
		this->host = h.toString();
		this->service = hRef.eat().toString();

		if (FLOW_KNOBS->REST_LOG_LEVEL >= RESTLogSeverity::DEBUG) {
			TraceEvent("RESTUtilParseURI")
			    .detail("URI", fullUrl)
			    .detail("Host", this->host)
			    .detail("Service", this->service)
			    .detail("Resource", this->resource)
			    .detail("ReqParameters", this->reqParameters)
			    .detail("ConnectionType", this->connType.toString());
		}
	} catch (std::string& err) {
		TraceEvent(SevWarnAlways, "RESTUtilParseError").detail("URI", fullUrl).detail("Error", err);
		throw rest_invalid_uri();
	}
}

double continuousTimeDecay(double initialValue, double decayRate, double time) {
	return initialValue * exp(-decayRate * time);
}

// Only used to link unit tests
void forceLinkRESTUtilsTests() {}

															#line 595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase271()
															#line 271 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class FlowTestCase271Actor>
															#line 271 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase271ActorState {
															#line 602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
															#line 271 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase271ActorState(UnitTestParameters const& params) 
															#line 271 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 271 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : params(params)
															#line 609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase271", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase271ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase271", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 273 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
				std::string uri("httpx://foo/bar");
															#line 274 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
				RESTUrl r(uri);
															#line 275 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
				ASSERT(false);
															#line 629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
				loopDepth = a_body1cont3(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase271ActorState();
		static_cast<FlowTestCase271Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 281 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		if (!static_cast<FlowTestCase271Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase271ActorState(); static_cast<FlowTestCase271Actor*>(this)->destroy(); return 0; }
															#line 658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		new (&static_cast<FlowTestCase271Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase271ActorState();
		static_cast<FlowTestCase271Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 277 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (e.code() != error_code_rest_unsupported_protocol)
															#line 671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
			{
															#line 278 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 271 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	UnitTestParameters params;
															#line 702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase271()
															#line 271 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase271Actor final : public Actor<Void>, public FastAllocated<FlowTestCase271Actor>, public FlowTestCase271ActorState<FlowTestCase271Actor> {
															#line 707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase271Actor>::operator new;
	using FastAllocated<FlowTestCase271Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5068400424268544UL, 13061603829319724544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 271 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase271Actor(UnitTestParameters const& params) 
															#line 723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase271ActorState<FlowTestCase271Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase271", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13078403614227094784UL, 11782801354250731264UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase271Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase271");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase271", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 271 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
static Future<Void> flowTestCase271( UnitTestParameters const& params ) {
															#line 271 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<Void>(new FlowTestCase271Actor(params));
															#line 755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase271, "/RESTUtils/InvalidProtocol")

#line 283 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"

															#line 761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase284()
															#line 284 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class FlowTestCase284Actor>
															#line 284 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase284ActorState {
															#line 768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
															#line 284 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase284ActorState(UnitTestParameters const& params) 
															#line 284 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 284 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : params(params)
															#line 775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase284", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase284ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase284", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 286 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
				std::string uri("https://:/bar");
															#line 287 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
				RESTUrl r(uri);
															#line 288 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
				ASSERT(false);
															#line 795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
				loopDepth = a_body1cont3(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase284ActorState();
		static_cast<FlowTestCase284Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 294 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		if (!static_cast<FlowTestCase284Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase284ActorState(); static_cast<FlowTestCase284Actor*>(this)->destroy(); return 0; }
															#line 824 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		new (&static_cast<FlowTestCase284Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase284ActorState();
		static_cast<FlowTestCase284Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 290 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (e.code() != error_code_rest_invalid_uri)
															#line 837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
			{
															#line 291 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 284 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	UnitTestParameters params;
															#line 868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase284()
															#line 284 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase284Actor final : public Actor<Void>, public FastAllocated<FlowTestCase284Actor>, public FlowTestCase284ActorState<FlowTestCase284Actor> {
															#line 873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase284Actor>::operator new;
	using FastAllocated<FlowTestCase284Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16317854940509847296UL, 3995491547383186176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 284 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase284Actor(UnitTestParameters const& params) 
															#line 889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase284ActorState<FlowTestCase284Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase284", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2641975664356649216UL, 6303879041471052032UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase284Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase284");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase284", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 284 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
static Future<Void> flowTestCase284( UnitTestParameters const& params ) {
															#line 284 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<Void>(new FlowTestCase284Actor(params));
															#line 921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase284, "/RESTUtils/MissingHost")

#line 296 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"

															#line 927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase297()
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class FlowTestCase297Actor>
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase297ActorState {
															#line 934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase297ActorState(UnitTestParameters const& params) 
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : params(params)
															#line 941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase297", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase297ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase297", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 298 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			std::string uri("https://host:80/foo/bar");
															#line 299 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			RESTUrl r(uri);
															#line 300 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.connType.secure, RESTConnectionType::SECURE_CONNECTION);
															#line 301 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.host.compare("host"), 0);
															#line 302 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.service.compare("80"), 0);
															#line 303 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.resource.compare("/foo/bar"), 0);
															#line 304 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (!static_cast<FlowTestCase297Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase297ActorState(); static_cast<FlowTestCase297Actor*>(this)->destroy(); return 0; }
															#line 968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
			new (&static_cast<FlowTestCase297Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase297ActorState();
			static_cast<FlowTestCase297Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase297ActorState();
		static_cast<FlowTestCase297Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	UnitTestParameters params;
															#line 992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase297()
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase297Actor final : public Actor<Void>, public FastAllocated<FlowTestCase297Actor>, public FlowTestCase297ActorState<FlowTestCase297Actor> {
															#line 997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase297Actor>::operator new;
	using FastAllocated<FlowTestCase297Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18167883680150226688UL, 7706822370132343552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase297Actor(UnitTestParameters const& params) 
															#line 1013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase297ActorState<FlowTestCase297Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase297", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(606424212171168512UL, 684362954269675776UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase297Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase297");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase297", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
static Future<Void> flowTestCase297( UnitTestParameters const& params ) {
															#line 297 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<Void>(new FlowTestCase297Actor(params));
															#line 1045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase297, "/RESTUtils/ValidURIWithService")

#line 306 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"

															#line 1051 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase307()
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class FlowTestCase307Actor>
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase307ActorState {
															#line 1058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase307ActorState(UnitTestParameters const& params) 
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : params(params)
															#line 1065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase307", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase307ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase307", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 308 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			std::string uri("https://host/foo/bar");
															#line 309 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			RESTUrl r(uri);
															#line 310 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.connType.secure, RESTConnectionType::SECURE_CONNECTION);
															#line 311 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.host.compare("host"), 0);
															#line 312 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT(r.service.empty());
															#line 313 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.resource.compare("/foo/bar"), 0);
															#line 314 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (!static_cast<FlowTestCase307Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase307ActorState(); static_cast<FlowTestCase307Actor*>(this)->destroy(); return 0; }
															#line 1092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
			new (&static_cast<FlowTestCase307Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase307ActorState();
			static_cast<FlowTestCase307Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase307ActorState();
		static_cast<FlowTestCase307Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	UnitTestParameters params;
															#line 1116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase307()
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase307Actor final : public Actor<Void>, public FastAllocated<FlowTestCase307Actor>, public FlowTestCase307ActorState<FlowTestCase307Actor> {
															#line 1121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase307Actor>::operator new;
	using FastAllocated<FlowTestCase307Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10057793264198591488UL, 3625167270591083776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase307Actor(UnitTestParameters const& params) 
															#line 1137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase307ActorState<FlowTestCase307Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase307", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13974969871336917760UL, 10985866580059137536UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase307Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase307");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase307", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
static Future<Void> flowTestCase307( UnitTestParameters const& params ) {
															#line 307 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<Void>(new FlowTestCase307Actor(params));
															#line 1169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase307, "/RESTUtils/ValidURIWithoutService")

#line 316 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"

															#line 1175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase317()
															#line 317 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class FlowTestCase317Actor>
															#line 317 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase317ActorState {
															#line 1182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
															#line 317 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase317ActorState(UnitTestParameters const& params) 
															#line 317 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 317 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : params(params)
															#line 1189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase317", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase317ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase317", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 318 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			std::string uri("https://host//foo/bar");
															#line 319 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			RESTUrl r(uri);
															#line 320 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.connType.secure, RESTConnectionType::SECURE_CONNECTION);
															#line 321 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.host.compare("host"), 0);
															#line 322 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT(r.service.empty());
															#line 323 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.resource.compare("//foo/bar"), 0);
															#line 324 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (!static_cast<FlowTestCase317Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase317ActorState(); static_cast<FlowTestCase317Actor*>(this)->destroy(); return 0; }
															#line 1216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
			new (&static_cast<FlowTestCase317Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase317ActorState();
			static_cast<FlowTestCase317Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase317ActorState();
		static_cast<FlowTestCase317Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 317 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	UnitTestParameters params;
															#line 1240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase317()
															#line 317 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase317Actor final : public Actor<Void>, public FastAllocated<FlowTestCase317Actor>, public FlowTestCase317ActorState<FlowTestCase317Actor> {
															#line 1245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase317Actor>::operator new;
	using FastAllocated<FlowTestCase317Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14475418137312920576UL, 3130289949017972480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 317 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase317Actor(UnitTestParameters const& params) 
															#line 1261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase317ActorState<FlowTestCase317Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase317", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1768293060365289216UL, 6793425752851553024UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase317Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase317");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase317", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 317 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
static Future<Void> flowTestCase317( UnitTestParameters const& params ) {
															#line 317 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<Void>(new FlowTestCase317Actor(params));
															#line 1293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase317, "/RESTUtils/ValidURIWithExtraForwardSlash")

#line 326 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"

															#line 1299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase327()
															#line 327 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class FlowTestCase327Actor>
															#line 327 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase327ActorState {
															#line 1306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
															#line 327 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase327ActorState(UnitTestParameters const& params) 
															#line 327 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 327 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : params(params)
															#line 1313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase327", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase327ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase327", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 328 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			std::string uri("https://host/foo/bar?param1,param2");
															#line 329 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			RESTUrl r(uri);
															#line 330 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.connType.secure, RESTConnectionType::SECURE_CONNECTION);
															#line 331 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.host.compare("host"), 0);
															#line 332 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT(r.service.empty());
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.resource.compare("/foo/bar"), 0);
															#line 334 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.reqParameters.compare("param1,param2"), 0);
															#line 335 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (!static_cast<FlowTestCase327Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase327ActorState(); static_cast<FlowTestCase327Actor*>(this)->destroy(); return 0; }
															#line 1342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
			new (&static_cast<FlowTestCase327Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase327ActorState();
			static_cast<FlowTestCase327Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase327ActorState();
		static_cast<FlowTestCase327Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 327 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	UnitTestParameters params;
															#line 1366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase327()
															#line 327 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase327Actor final : public Actor<Void>, public FastAllocated<FlowTestCase327Actor>, public FlowTestCase327ActorState<FlowTestCase327Actor> {
															#line 1371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase327Actor>::operator new;
	using FastAllocated<FlowTestCase327Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8043697456365360384UL, 7608541069665468928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 327 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase327Actor(UnitTestParameters const& params) 
															#line 1387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase327ActorState<FlowTestCase327Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase327", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18330963947280861696UL, 1501750348643472640UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase327Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase327");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase327", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 327 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
static Future<Void> flowTestCase327( UnitTestParameters const& params ) {
															#line 327 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<Void>(new FlowTestCase327Actor(params));
															#line 1419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase327, "/RESTUtils/ValidURIWithParamsSecure")

#line 337 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"

															#line 1425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase338()
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class FlowTestCase338Actor>
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase338ActorState {
															#line 1432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase338ActorState(UnitTestParameters const& params) 
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : params(params)
															#line 1439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase338", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase338ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase338", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 339 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			auto& g_knobs = IKnobCollection::getMutableGlobalKnobCollection();
															#line 340 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			g_knobs.setKnob("rest_kms_allow_not_secure_connection", KnobValueRef::create(bool{ false }));
															#line 341 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			std::string uri("http://host/foo/bar?param1,param2");
															#line 1458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
			try {
															#line 343 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
				RESTUrl r(uri);
															#line 344 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
				ASSERT(false);
															#line 1464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
				loopDepth = a_body1cont3(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase338ActorState();
		static_cast<FlowTestCase338Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 348 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		if (!static_cast<FlowTestCase338Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase338ActorState(); static_cast<FlowTestCase338Actor*>(this)->destroy(); return 0; }
															#line 1493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		new (&static_cast<FlowTestCase338Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase338ActorState();
		static_cast<FlowTestCase338Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 346 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(e.code(), error_code_rest_unsupported_protocol);
															#line 1506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	UnitTestParameters params;
															#line 1532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase338()
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase338Actor final : public Actor<Void>, public FastAllocated<FlowTestCase338Actor>, public FlowTestCase338ActorState<FlowTestCase338Actor> {
															#line 1537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase338Actor>::operator new;
	using FastAllocated<FlowTestCase338Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13542204627957106944UL, 16223556637085552896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase338Actor(UnitTestParameters const& params) 
															#line 1553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase338ActorState<FlowTestCase338Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase338", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1809594065150059264UL, 15497843150704983808UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase338Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase338");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase338", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
static Future<Void> flowTestCase338( UnitTestParameters const& params ) {
															#line 338 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<Void>(new FlowTestCase338Actor(params));
															#line 1585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase338, "/RESTUtils/ValidURIWithParamsKnobNotEnabled")

#line 350 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"

															#line 1591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase351()
															#line 351 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
template <class FlowTestCase351Actor>
															#line 351 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase351ActorState {
															#line 1598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
															#line 351 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase351ActorState(UnitTestParameters const& params) 
															#line 351 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
															#line 351 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
		 : params(params)
															#line 1605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase351", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase351ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase351", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 352 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			auto& g_knobs = IKnobCollection::getMutableGlobalKnobCollection();
															#line 353 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			g_knobs.setKnob("rest_kms_allow_not_secure_connection", KnobValueRef::create(bool{ true }));
															#line 354 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			std::string uri("http://host/foo/bar?param1,param2");
															#line 355 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			RESTUrl r(uri);
															#line 356 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.connType.secure, RESTConnectionType::NOT_SECURE_CONNECTION);
															#line 357 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.host.compare("host"), 0);
															#line 358 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT(r.service.empty());
															#line 359 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.resource.compare("/foo/bar"), 0);
															#line 360 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			ASSERT_EQ(r.reqParameters.compare("param1,param2"), 0);
															#line 361 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
			if (!static_cast<FlowTestCase351Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase351ActorState(); static_cast<FlowTestCase351Actor*>(this)->destroy(); return 0; }
															#line 1638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
			new (&static_cast<FlowTestCase351Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase351ActorState();
			static_cast<FlowTestCase351Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase351ActorState();
		static_cast<FlowTestCase351Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 351 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	UnitTestParameters params;
															#line 1662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase351()
															#line 351 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
class FlowTestCase351Actor final : public Actor<Void>, public FastAllocated<FlowTestCase351Actor>, public FlowTestCase351ActorState<FlowTestCase351Actor> {
															#line 1667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase351Actor>::operator new;
	using FastAllocated<FlowTestCase351Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13246892863697518848UL, 1997438029458143744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 351 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	FlowTestCase351Actor(UnitTestParameters const& params) 
															#line 1683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase351ActorState<FlowTestCase351Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase351", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3473365524042607616UL, 1702892623266774016UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase351Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase351");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase351", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 351 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
static Future<Void> flowTestCase351( UnitTestParameters const& params ) {
															#line 351 "/Users/ec2-user/foundationdb/fdbclient/RESTUtils.actor.cpp"
	return Future<Void>(new FlowTestCase351Actor(params));
															#line 1715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTUtils.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase351, "/RESTUtils/ValidURIWithParams")

