#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
/*
 * RESTClient.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/RESTClient.h"

#include "fdbrpc/HTTP.h"
#include "flow/IRateControl.h"
#include "fdbclient/RESTUtils.h"
#include "flow/Arena.h"
#include "flow/Error.h"
#include "flow/FastRef.h"
#include "flow/Knobs.h"
#include "flow/Net2Packet.h"
#include "flow/flow.h"
#include "flow/network.h"
#include "flow/serialize.h"
#include "flow/Trace.h"
#include "flow/UnitTest.h"
#include "flow/IConnection.h"

#include <memory>
#include <unordered_map>

#include "flow/actorcompiler.h" // always the last include

#define TRACE_REST_OP(opName, url)                                                                                     \
	do {                                                                                                               \
		if (FLOW_KNOBS->REST_LOG_LEVEL >= RESTLogSeverity::DEBUG) {                                                    \
			const std::string urlStr = url.toString();                                                                 \
			TraceEvent("RESTClientOp")                                                                                 \
			    .detail("Op", #opName)                                                                                 \
			    .detail("Url", urlStr)                                                                                 \
			    .detail("IsSecure", url.connType.secure);                                                              \
		}                                                                                                              \
	} while (0);

json_spirit::mObject RESTClient::Stats::getJSON() {
	json_spirit::mObject o;

	o["host_service"] = host_service;
	o["requests_failed"] = requests_failed;
	o["requests_successful"] = requests_successful;
	o["bytes_sent"] = bytes_sent;

	return o;
}

RESTClient::Stats RESTClient::Stats::operator-(const Stats& rhs) {
	Stats r(host_service);

	r.requests_failed = requests_failed - rhs.requests_failed;
	r.requests_successful = requests_successful - rhs.requests_successful;
	r.bytes_sent = bytes_sent - rhs.bytes_sent;

	return r;
}

RESTClient::RESTClient() : conectionPool(makeReference<RESTConnectionPool>(knobs.connection_pool_size)) {}

RESTClient::RESTClient(std::unordered_map<std::string, int>& knobSettings)
  : conectionPool(makeReference<RESTConnectionPool>(knobs.connection_pool_size)) {
	knobs.set(knobSettings);
}

void RESTClient::setKnobs(const std::unordered_map<std::string, int>& knobSettings) {
	knobs.set(knobSettings);
}

std::unordered_map<std::string, int> RESTClient::getKnobs() const {
	return knobs.get();
}

bool isErrorRetryable(const Error& e) {
	// Server if unreachable or timing out requests, bubble the error to the caller to decide continue using the same
	// server OR attempt connecting to a different server instance

	return e.code() != error_code_timed_out && e.code() != error_code_connection_failed;
}

															#line 99 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
namespace {
// This generated class is to be used only via doRequest_impl()
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
template <class DoRequest_implActor>
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
class DoRequest_implActorState {
															#line 106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
public:
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	DoRequest_implActorState(Reference<RESTClient> const& client,std::string const& verb,HTTP::Headers const& headers,RESTUrl const& url,std::set<unsigned int> const& successCodes) 
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		 : client(client),
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		   verb(verb),
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		   headers(headers),
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		   url(url),
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		   successCodes(successCodes),
															#line 103 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		   req(makeReference<HTTP::OutgoingRequest>()),
															#line 104 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		   content()
															#line 125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
	{
		fdb_probe_actor_create("doRequest_impl", reinterpret_cast<unsigned long>(this));

	}
	~DoRequest_implActorState() 
	{
		fdb_probe_actor_destroy("doRequest_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 105 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			req->data.content = &content;
															#line 106 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			req->data.contentLen = url.body.size();
															#line 107 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			req->data.headers = headers;
															#line 108 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			req->data.headers["Host"] = url.host;
															#line 109 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			req->verb = verb;
															#line 110 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			req->resource = url.resource;
															#line 112 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			if (FLOW_KNOBS->REST_LOG_LEVEL >= RESTLogSeverity::VERBOSE)
															#line 152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			{
															#line 113 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				TraceEvent("RESTDoRequestImpl").detail("Url", url.toString());
															#line 156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			}
															#line 116 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			if (url.body.size() > 0)
															#line 160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			{
															#line 117 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				PacketWriter pw(req->data.content->getWriteBuffer(url.body.size()), nullptr, Unversioned());
															#line 118 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				pw.serializeBytes(url.body);
															#line 166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			}
															#line 121 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			std::string statsKey = RESTClient::getStatsKey(url.host, url.service);
															#line 122 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			auto sItr = client->statsMap.find(statsKey);
															#line 123 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			if (sItr == client->statsMap.end())
															#line 174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			{
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				client->statsMap.emplace(statsKey, std::make_unique<RESTClient::Stats>(statsKey));
															#line 178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			}
															#line 127 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			maxTries = std::min(client->knobs.request_tries, client->knobs.connect_tries);
															#line 128 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			thisTry = 1;
															#line 129 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			nextRetryDelay = 2.0;
															#line 130 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			sendReceiveRate = makeReference<Unlimited>();
															#line 131 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			reqTimeout = (client->knobs.request_timeout_secs * 1.0);
															#line 132 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			connectPoolKey = RESTConnectionPool::getConnectionPoolKey(url.host, url.service);
															#line 133 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			statsPtr = client->statsMap[statsKey].get();
															#line 135 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			;
															#line 196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoRequest_implActorState();
		static_cast<DoRequest_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 136 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		err = Optional<Error>();
															#line 137 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		remoteAddress = Optional<NetworkAddress>();
															#line 138 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		connectionEstablished = false;
															#line 140 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		r = Reference<HTTP::IncomingResponse>();
															#line 232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		try {
															#line 144 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			Future<RESTConnectionPool::ReusableConnection> frconn = client->conectionPool->connect(connectPoolKey, url.connType.secure, client->knobs.max_connection_life);
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			StrictFuture<RESTConnectionPool::ReusableConnection> __when_expr_0 = timeoutError(frconn, client->knobs.connect_timeout);
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			if (static_cast<DoRequest_implActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoRequest_implActor*>(this)->actor_wait_state = 1;
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoRequest_implActor, 0, RESTConnectionPool::ReusableConnection >*>(static_cast<DoRequest_implActor*>(this)));
															#line 245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 172 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		if (!err.present() && successCodes.count(r->code) != 0)
															#line 260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		{
															#line 173 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			statsPtr->requests_successful++;
															#line 174 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			if (!static_cast<DoRequest_implActor*>(this)->SAV<Reference<HTTP::IncomingResponse>>::futures) { (void)(r); this->~DoRequest_implActorState(); static_cast<DoRequest_implActor*>(this)->destroy(); return 0; }
															#line 266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			new (&static_cast<DoRequest_implActor*>(this)->SAV< Reference<HTTP::IncomingResponse> >::value()) Reference<HTTP::IncomingResponse>(std::move(r)); // state_var_RVO
			this->~DoRequest_implActorState();
			static_cast<DoRequest_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 178 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		statsPtr->requests_failed++;
															#line 182 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		bool retryable = (err.present() && isErrorRetryable(err.get())) || (r.isValid() && (r->code == HTTP::HTTP_STATUS_CODE_INTERNAL_SERVER_ERROR || r->code == HTTP::HTTP_STATUS_CODE_BAD_GATEWAY || r->code == HTTP::HTTP_STATUS_CODE_BAD_GATEWAY || r->code == HTTP::HTTP_STATUS_CODE_SERVICE_UNAVAILABLE || r->code == HTTP::HTTP_STATUS_CODE_TOO_MANY_REQUESTS || r->code == HTTP::HTTP_STATUS_CODE_TIMEOUT));
															#line 191 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		retryable = retryable && (thisTry < maxTries);
															#line 193 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		TraceEvent event(SevWarn, retryable ? "RESTClientFailedRetryable" : "RESTClientRequestFailed");
															#line 196 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		if (err.present())
															#line 282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		{
															#line 197 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			event.errorUnsuppressed(err.get());
															#line 286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		}
															#line 199 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		event.suppressFor(60);
															#line 200 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		if (!err.present())
															#line 292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		{
															#line 201 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			event.detail("ResponseCode", r->code);
															#line 296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		}
															#line 204 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		event.detail("ConnectionEstablished", connectionEstablished);
															#line 206 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		if (remoteAddress.present())
															#line 302 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		{
															#line 207 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			event.detail("RemoteEndpoint", remoteAddress.get());
															#line 306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		}
		else
		{
															#line 209 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			event.detail("RemoteHost", url.host);
															#line 312 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		}
															#line 211 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		event.detail("Verb", verb).detail("Resource", url.resource).detail("ThisTry", thisTry);
															#line 215 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		if (!r || r->code != HTTP::HTTP_STATUS_CODE_TOO_MANY_REQUESTS)
															#line 318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		{
															#line 216 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			++thisTry;
															#line 322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		}
															#line 220 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		double delay = nextRetryDelay;
															#line 222 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		nextRetryDelay = std::min(nextRetryDelay * 2, 60.0);
															#line 224 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		if (retryable)
															#line 330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		{
															#line 226 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			if (r)
															#line 334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			{
															#line 227 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				auto iRetryAfter = r->data.headers.find("Retry-After");
															#line 228 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				if (iRetryAfter != r->data.headers.end())
															#line 340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
				{
															#line 229 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
					event.detail("RetryAfterHeader", iRetryAfter->second);
															#line 230 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
					char* pEnd;
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
					double retryAfter = strtod(iRetryAfter->second.c_str(), &pEnd);
															#line 232 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
					if (*pEnd)
															#line 350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
					{
															#line 234 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
						retryAfter = HTTP::HTTP_RETRYAFTER_DELAY_SECS;
															#line 354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
					}
															#line 237 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
					delay = std::max(delay, retryAfter);
															#line 358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
				}
			}
															#line 242 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			event.detail("RetryDelay", delay);
															#line 243 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			StrictFuture<Void> __when_expr_2 = ::delay(delay);
															#line 243 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			if (static_cast<DoRequest_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DoRequest_implActor*>(this)->actor_wait_state = 3;
															#line 243 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoRequest_implActor, 2, Void >*>(static_cast<DoRequest_implActor*>(this)));
															#line 372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 248 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			if (r && r->code == HTTP::HTTP_STATUS_CODE_NOT_ACCEPTABLE)
															#line 379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			{
															#line 249 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				return a_body1Catch1(http_not_accepted(), std::max(0, loopDepth - 1));
															#line 383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			}
															#line 252 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			if (r && r->code == HTTP::HTTP_STATUS_CODE_UNAUTHORIZED)
															#line 387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			{
															#line 253 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				return a_body1Catch1(http_auth_failed(), std::max(0, loopDepth - 1));
															#line 391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			}
															#line 257 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			if (err.present())
															#line 395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			{
															#line 258 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				int code = err.get().code();
															#line 265 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				if (code == error_code_timed_out && !connectionEstablished)
															#line 401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
				{
															#line 266 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
					return a_body1Catch1(connection_failed(), std::max(0, loopDepth - 1));
															#line 405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
				}
															#line 269 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				if (code == error_code_timed_out || code == error_code_connection_failed || code == error_code_lookup_failed)
															#line 409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
				{
															#line 271 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
					return a_body1Catch1(err.get(), std::max(0, loopDepth - 1));
															#line 413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
				}
			}
															#line 275 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			return a_body1Catch1(http_request_failed(), std::max(0, loopDepth - 1));
															#line 418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			{
															#line 165 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			}
															#line 167 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			err = e;
															#line 436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 150 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		connectionEstablished = true;
															#line 152 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		remoteAddress = rconn.conn->getPeerAddress();
															#line 153 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_1 = timeoutError( HTTP::doRequest(rconn.conn, req, sendReceiveRate, &statsPtr->bytes_sent, sendReceiveRate), reqTimeout);
															#line 153 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		if (static_cast<DoRequest_implActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoRequest_implActor*>(this)->actor_wait_state = 2;
															#line 153 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoRequest_implActor, 1, Reference<HTTP::IncomingResponse> >*>(static_cast<DoRequest_implActor*>(this)));
															#line 462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RESTConnectionPool::ReusableConnection const& __rconn,int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		rconn = __rconn;
															#line 471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RESTConnectionPool::ReusableConnection && __rconn,int loopDepth) 
	{
		rconn = std::move(__rconn);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoRequest_implActor*>(this)->actor_wait_state > 0) static_cast<DoRequest_implActor*>(this)->actor_wait_state = 0;
		static_cast<DoRequest_implActor*>(this)->ActorCallback< DoRequest_implActor, 0, RESTConnectionPool::ReusableConnection >::remove();

	}
	void a_callback_fire(ActorCallback< DoRequest_implActor, 0, RESTConnectionPool::ReusableConnection >*,RESTConnectionPool::ReusableConnection const& value) 
	{
		fdb_probe_actor_enter("doRequest_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequest_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequest_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoRequest_implActor, 0, RESTConnectionPool::ReusableConnection >*,RESTConnectionPool::ReusableConnection && value) 
	{
		fdb_probe_actor_enter("doRequest_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequest_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequest_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoRequest_implActor, 0, RESTConnectionPool::ReusableConnection >*,Error err) 
	{
		fdb_probe_actor_enter("doRequest_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequest_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequest_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Reference<HTTP::IncomingResponse> const& _r,int loopDepth) 
	{
															#line 155 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		r = _r;
															#line 159 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		if (r->data.headers["Connection"] != "close")
															#line 552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		{
															#line 160 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			client->conectionPool->returnConnection(connectPoolKey, rconn, client->knobs.connection_pool_size);
															#line 556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		}
															#line 162 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		rconn.conn.clear();
															#line 560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Reference<HTTP::IncomingResponse> && _r,int loopDepth) 
	{
															#line 155 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		r = _r;
															#line 159 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		if (r->data.headers["Connection"] != "close")
															#line 571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		{
															#line 160 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			client->conectionPool->returnConnection(connectPoolKey, rconn, client->knobs.connection_pool_size);
															#line 575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		}
															#line 162 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		rconn.conn.clear();
															#line 579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<HTTP::IncomingResponse> const& _r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_r, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<HTTP::IncomingResponse> && _r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoRequest_implActor*>(this)->actor_wait_state > 0) static_cast<DoRequest_implActor*>(this)->actor_wait_state = 0;
		static_cast<DoRequest_implActor*>(this)->ActorCallback< DoRequest_implActor, 1, Reference<HTTP::IncomingResponse> >::remove();

	}
	void a_callback_fire(ActorCallback< DoRequest_implActor, 1, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> const& value) 
	{
		fdb_probe_actor_enter("doRequest_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequest_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequest_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoRequest_implActor, 1, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> && value) 
	{
		fdb_probe_actor_enter("doRequest_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequest_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequest_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoRequest_implActor, 1, Reference<HTTP::IncomingResponse> >*,Error err) 
	{
		fdb_probe_actor_enter("doRequest_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequest_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequest_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoRequest_implActor*>(this)->actor_wait_state > 0) static_cast<DoRequest_implActor*>(this)->actor_wait_state = 0;
		static_cast<DoRequest_implActor*>(this)->ActorCallback< DoRequest_implActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoRequest_implActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doRequest_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequest_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequest_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoRequest_implActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doRequest_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequest_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequest_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoRequest_implActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doRequest_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequest_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doRequest_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	Reference<RESTClient> client;
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	std::string verb;
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	HTTP::Headers headers;
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	RESTUrl url;
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	std::set<unsigned int> successCodes;
															#line 103 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	Reference<HTTP::OutgoingRequest> req;
															#line 104 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	UnsentPacketQueue content;
															#line 127 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	int maxTries;
															#line 128 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	int thisTry;
															#line 129 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	double nextRetryDelay;
															#line 130 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	Reference<IRateControl> sendReceiveRate;
															#line 131 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	double reqTimeout;
															#line 132 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	RESTConnectionPoolKey connectPoolKey;
															#line 133 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	RESTClient::Stats* statsPtr;
															#line 136 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	Optional<Error> err;
															#line 137 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	Optional<NetworkAddress> remoteAddress;
															#line 138 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	bool connectionEstablished;
															#line 140 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	Reference<HTTP::IncomingResponse> r;
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	RESTConnectionPool::ReusableConnection rconn;
															#line 803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
};
// This generated class is to be used only via doRequest_impl()
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
class DoRequest_implActor final : public Actor<Reference<HTTP::IncomingResponse>>, public ActorCallback< DoRequest_implActor, 0, RESTConnectionPool::ReusableConnection >, public ActorCallback< DoRequest_implActor, 1, Reference<HTTP::IncomingResponse> >, public ActorCallback< DoRequest_implActor, 2, Void >, public FastAllocated<DoRequest_implActor>, public DoRequest_implActorState<DoRequest_implActor> {
															#line 808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
public:
	using FastAllocated<DoRequest_implActor>::operator new;
	using FastAllocated<DoRequest_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8613131799267567872UL, 1180654806000772608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<HTTP::IncomingResponse>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoRequest_implActor, 0, RESTConnectionPool::ReusableConnection >;
friend struct ActorCallback< DoRequest_implActor, 1, Reference<HTTP::IncomingResponse> >;
friend struct ActorCallback< DoRequest_implActor, 2, Void >;
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	DoRequest_implActor(Reference<RESTClient> const& client,std::string const& verb,HTTP::Headers const& headers,RESTUrl const& url,std::set<unsigned int> const& successCodes) 
															#line 827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		 : Actor<Reference<HTTP::IncomingResponse>>(),
		   DoRequest_implActorState<DoRequest_implActor>(client, verb, headers, url, successCodes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doRequest_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8762720438240590848UL, 16675552070853705472UL);
		ActorExecutionContextHelper __helper(static_cast<DoRequest_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doRequest_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doRequest_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoRequest_implActor, 0, RESTConnectionPool::ReusableConnection >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoRequest_implActor, 1, Reference<HTTP::IncomingResponse> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoRequest_implActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
[[nodiscard]] Future<Reference<HTTP::IncomingResponse>> doRequest_impl( Reference<RESTClient> const& client, std::string const& verb, HTTP::Headers const& headers, RESTUrl const& url, std::set<unsigned int> const& successCodes ) {
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	return Future<Reference<HTTP::IncomingResponse>>(new DoRequest_implActor(client, verb, headers, url, successCodes));
															#line 862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
}

#line 279 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"

Future<Reference<HTTP::IncomingResponse>> RESTClient::doPutOrPost(const std::string& verb,
                                                                  Optional<HTTP::Headers> optHeaders,
                                                                  RESTUrl& url,
                                                                  std::set<unsigned int> successCodes) {
	HTTP::Headers headers;
	if (optHeaders.present()) {
		headers = optHeaders.get();
	}

	return doRequest_impl(Reference<RESTClient>::addRef(this), verb, headers, url, successCodes);
}

Future<Reference<HTTP::IncomingResponse>> RESTClient::doPost(const std::string& fullUrl,
                                                             const std::string& requestBody,
                                                             Optional<HTTP::Headers> optHeaders) {
	RESTUrl url(fullUrl, requestBody);
	TRACE_REST_OP("DoPost", url);
	return doPutOrPost(HTTP::HTTP_VERB_POST, optHeaders, url, { HTTP::HTTP_STATUS_CODE_OK });
}

Future<Reference<HTTP::IncomingResponse>> RESTClient::doPut(const std::string& fullUrl,
                                                            const std::string& requestBody,
                                                            Optional<HTTP::Headers> optHeaders) {
	RESTUrl url(fullUrl, requestBody);
	TRACE_REST_OP("DoPut", url);
	return doPutOrPost(
	    HTTP::HTTP_VERB_PUT,
	    optHeaders,
	    url,
	    // 201 - on successful resource create
	    // 200 / 204 - if target resource representation was successfully modified with the desired state
	    { HTTP::HTTP_STATUS_CODE_OK, HTTP::HTTP_STATUS_CODE_CREATED, HTTP::HTTP_STATUS_CODE_NO_CONTENT });
}

Future<Reference<HTTP::IncomingResponse>> RESTClient::doGetHeadDeleteOrTrace(const std::string& verb,
                                                                             Optional<HTTP::Headers> optHeaders,
                                                                             RESTUrl& url,
                                                                             std::set<unsigned int> successCodes) {
	HTTP::Headers headers;
	if (optHeaders.present()) {
		headers = optHeaders.get();
	}

	return doRequest_impl(Reference<RESTClient>::addRef(this), HTTP::HTTP_VERB_GET, headers, url, successCodes);
}

Future<Reference<HTTP::IncomingResponse>> RESTClient::doGet(const std::string& fullUrl,
                                                            Optional<HTTP::Headers> optHeaders) {
	RESTUrl url(fullUrl);
	TRACE_REST_OP("DoGet", url);
	return doGetHeadDeleteOrTrace(HTTP::HTTP_VERB_GET, optHeaders, url, { HTTP::HTTP_STATUS_CODE_OK });
}

Future<Reference<HTTP::IncomingResponse>> RESTClient::doHead(const std::string& fullUrl,
                                                             Optional<HTTP::Headers> optHeaders) {
	RESTUrl url(fullUrl);
	TRACE_REST_OP("DoHead", url);
	return doGetHeadDeleteOrTrace(HTTP::HTTP_VERB_HEAD, optHeaders, url, { HTTP::HTTP_STATUS_CODE_OK });
}

Future<Reference<HTTP::IncomingResponse>> RESTClient::doDelete(const std::string& fullUrl,
                                                               Optional<HTTP::Headers> optHeaders) {
	RESTUrl url(fullUrl);
	TRACE_REST_OP("DoDelete", url);
	return doGetHeadDeleteOrTrace(
	    HTTP::HTTP_VERB_DELETE,
	    optHeaders,
	    url,
	    // 200 - action has been enacted.
	    // 202 - action will likely succeed, but, has not yet been enacted.
	    // 204 - action has been enated, no further information is to supplied.
	    { HTTP::HTTP_STATUS_CODE_OK, HTTP::HTTP_STATUS_CODE_NO_CONTENT, HTTP::HTTP_STATUS_CODE_ACCEPTED });
}

Future<Reference<HTTP::IncomingResponse>> RESTClient::doTrace(const std::string& fullUrl,
                                                              Optional<HTTP::Headers> optHeaders) {
	RESTUrl url(fullUrl);
	TRACE_REST_OP("DoTrace", url);
	return doGetHeadDeleteOrTrace(HTTP::HTTP_VERB_TRACE, optHeaders, url, { HTTP::HTTP_STATUS_CODE_OK });
}

// Only used to link unit tests
void forceLinkRESTClientTests() {}

															#line 951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase364()
															#line 364 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
template <class FlowTestCase364Actor>
															#line 364 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
class FlowTestCase364ActorState {
															#line 958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
public:
															#line 364 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	FlowTestCase364ActorState(UnitTestParameters const& params) 
															#line 364 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
															#line 364 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		 : params(params)
															#line 965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase364", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase364ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase364", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 365 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			RESTClient r;
															#line 366 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			std::unordered_map<std::string, int> knobs = r.getKnobs();
															#line 367 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			ASSERT_EQ(knobs["connection_pool_size"], FLOW_KNOBS->RESTCLIENT_MAX_CONNECTIONPOOL_SIZE);
															#line 368 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			ASSERT_EQ(knobs["connect_tries"], FLOW_KNOBS->RESTCLIENT_CONNECT_TRIES);
															#line 369 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			ASSERT_EQ(knobs["connect_timeout"], FLOW_KNOBS->RESTCLIENT_CONNECT_TIMEOUT);
															#line 370 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			ASSERT_EQ(knobs["max_connection_life"], FLOW_KNOBS->RESTCLIENT_MAX_CONNECTION_LIFE);
															#line 371 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			ASSERT_EQ(knobs["request_tries"], FLOW_KNOBS->RESTCLIENT_REQUEST_TRIES);
															#line 372 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			ASSERT_EQ(knobs["request_timeout_secs"], FLOW_KNOBS->RESTCLIENT_REQUEST_TIMEOUT_SEC);
															#line 374 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			for( auto& itr : knobs ) {
															#line 375 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				itr.second++;
															#line 998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			}
															#line 377 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			r.setKnobs(knobs);
															#line 379 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			std::unordered_map<std::string, int> updated = r.getKnobs();
															#line 380 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			for( auto& itr : updated ) {
															#line 381 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				ASSERT_EQ(knobs[itr.first], itr.second);
															#line 1008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			}
															#line 385 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			knobs["foo"] = 100;
															#line 1012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			try {
															#line 387 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				r.setKnobs(knobs);
															#line 388 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				ASSERT(false);
															#line 1018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
				loopDepth = a_body1cont5(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase364ActorState();
		static_cast<FlowTestCase364Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 395 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
		if (!static_cast<FlowTestCase364Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase364ActorState(); static_cast<FlowTestCase364Actor*>(this)->destroy(); return 0; }
															#line 1047 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		new (&static_cast<FlowTestCase364Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase364ActorState();
		static_cast<FlowTestCase364Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 390 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
			if (e.code() != error_code_rest_invalid_rest_client_knob)
															#line 1060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			{
															#line 391 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 364 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	UnitTestParameters params;
															#line 1091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase364()
															#line 364 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
class FlowTestCase364Actor final : public Actor<Void>, public FastAllocated<FlowTestCase364Actor>, public FlowTestCase364ActorState<FlowTestCase364Actor> {
															#line 1096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase364Actor>::operator new;
	using FastAllocated<FlowTestCase364Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5198960418789091584UL, 2090623825128016128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 364 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	FlowTestCase364Actor(UnitTestParameters const& params) 
															#line 1112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase364ActorState<FlowTestCase364Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase364", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17055161600167105536UL, 8627064282048381696UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase364Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase364");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase364", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 364 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
static Future<Void> flowTestCase364( UnitTestParameters const& params ) {
															#line 364 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
	return Future<Void>(new FlowTestCase364Actor(params));
															#line 1144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/RESTClient.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase364, "fdbrpc/RESTClient")

#line 397 "/Users/ec2-user/foundationdb/fdbclient/RESTClient.actor.cpp"
