#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
/*
 * FileBackupAgent.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BlobGranuleCommon.h"
#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/TenantEntryCache.actor.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbclient/BlobRestoreCommon.h"
#include "fdbrpc/TenantInfo.h"
#include "fdbrpc/simulator.h"
#include "flow/EncryptUtils.h"
#include "flow/FastRef.h"
#include "flow/flow.h"
#include "fmt/format.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BlobCipher.h"
#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/GetEncryptCipherKeys.h"
#include "fdbclient/JsonBuilder.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/KeyRangeMap.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/PartitionedLogIterator.h"
#include "fdbclient/RestoreInterface.h"
#include "fdbclient/Status.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/TaskBucket.h"
#include "fdbclient/Tenant.h"
#include "flow/network.h"
#include "flow/Trace.h"

#include <cinttypes>
#include <cstdint>
#include <ctime>
#include <climits>
#include "flow/IAsyncFile.h"
#include "flow/genericactors.actor.h"
#include "flow/Hash3.h"
#include "flow/xxhash.h"

#include <memory>
#include <numeric>
#include <boost/algorithm/string/split.hpp>
#include <boost/algorithm/string/classification.hpp>
#include <algorithm>
#include <unordered_map>
#include <utility>

#include "flow/actorcompiler.h" // This must be the last #include.

Optional<std::string> fileBackupAgentProxy = Optional<std::string>();

#define SevFRTestInfo SevVerbose
// #define SevFRTestInfo SevInfo

static std::string boolToYesOrNo(bool val) {
	return val ? std::string("Yes") : std::string("No");
}

static std::string versionToString(Optional<Version> version) {
	if (version.present())
		return std::to_string(version.get());
	else
		return "N/A";
}

static std::string timeStampToString(Optional<int64_t> epochs) {
	if (!epochs.present())
		return "N/A";
	return BackupAgentBase::formatTime(epochs.get());
}

static Future<Optional<int64_t>> getTimestampFromVersion(Optional<Version> ver,
                                                         Reference<ReadYourWritesTransaction> tr) {
	if (!ver.present())
		return Optional<int64_t>();

	return timeKeeperEpochsFromVersion(ver.get(), tr);
}

// Time format :
// <= 59 seconds
// <= 59.99 minutes
// <= 23.99 hours
// N.NN days
std::string secondsToTimeFormat(int64_t seconds) {
	if (seconds >= 86400)
		return format("%.2f day(s)", seconds / 86400.0);
	else if (seconds >= 3600)
		return format("%.2f hour(s)", seconds / 3600.0);
	else if (seconds >= 60)
		return format("%.2f minute(s)", seconds / 60.0);
	else
		return format("%lld second(s)", seconds);
}

const Key FileBackupAgent::keyLastRestorable = "last_restorable"_sr;

// For convenience
typedef FileBackupAgent::ERestoreState ERestoreState;

StringRef FileBackupAgent::restoreStateText(ERestoreState id) {
	switch (id) {
	case ERestoreState::UNINITIALIZED:
		return "uninitialized"_sr;
	case ERestoreState::QUEUED:
		return "queued"_sr;
	case ERestoreState::STARTING:
		return "starting"_sr;
	case ERestoreState::RUNNING:
		return "running"_sr;
	case ERestoreState::COMPLETED:
		return "completed"_sr;
	case ERestoreState::ABORTED:
		return "aborted"_sr;
	default:
		return "Unknown"_sr;
	}
}

Key FileBackupAgent::getPauseKey() {
	FileBackupAgent backupAgent;
	return backupAgent.taskBucket->getPauseKey();
}

															#line 150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via getAll_impl()
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class TagUidMap_GetAll_implActor>
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TagUidMap_GetAll_implActorState {
															#line 156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TagUidMap_GetAll_implActorState(TagUidMap* const& tagsMap,Reference<ReadYourWritesTransaction> const& tr,Snapshot const& snapshot) 
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tagsMap(tagsMap),
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   snapshot(snapshot),
															#line 151 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   prefix(tagsMap->prefix)
															#line 169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("getAll_impl", reinterpret_cast<unsigned long>(this));

	}
	~TagUidMap_GetAll_implActorState() 
	{
		fdb_probe_actor_destroy("getAll_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 152 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<TagMap::RangeResultType> __when_expr_0 = tagsMap->getRange(tr, std::string(), {}, 1e6, snapshot);
															#line 152 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state = 1;
															#line 152 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*>(static_cast<TagUidMap_GetAll_implActor*>(this)));
															#line 191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagUidMap_GetAll_implActorState();
		static_cast<TagUidMap_GetAll_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TagMap::RangeResultType const& tagPairs,int loopDepth) 
	{
															#line 153 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<KeyBackedTag> results;
															#line 154 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& p : tagPairs.results ) {
															#line 155 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back(KeyBackedTag(p.first, prefix));
															#line 218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 156 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TagUidMap_GetAll_implActor*>(this)->SAV<std::vector<KeyBackedTag>>::futures) { (void)(results); this->~TagUidMap_GetAll_implActorState(); static_cast<TagUidMap_GetAll_implActor*>(this)->destroy(); return 0; }
															#line 222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<TagUidMap_GetAll_implActor*>(this)->SAV< std::vector<KeyBackedTag> >::value()) std::vector<KeyBackedTag>(results);
		this->~TagUidMap_GetAll_implActorState();
		static_cast<TagUidMap_GetAll_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(TagMap::RangeResultType && tagPairs,int loopDepth) 
	{
															#line 153 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<KeyBackedTag> results;
															#line 154 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& p : tagPairs.results ) {
															#line 155 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back(KeyBackedTag(p.first, prefix));
															#line 238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 156 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TagUidMap_GetAll_implActor*>(this)->SAV<std::vector<KeyBackedTag>>::futures) { (void)(results); this->~TagUidMap_GetAll_implActorState(); static_cast<TagUidMap_GetAll_implActor*>(this)->destroy(); return 0; }
															#line 242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<TagUidMap_GetAll_implActor*>(this)->SAV< std::vector<KeyBackedTag> >::value()) std::vector<KeyBackedTag>(results);
		this->~TagUidMap_GetAll_implActorState();
		static_cast<TagUidMap_GetAll_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TagMap::RangeResultType const& tagPairs,int loopDepth) 
	{
		loopDepth = a_body1cont1(tagPairs, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TagMap::RangeResultType && tagPairs,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tagPairs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state > 0) static_cast<TagUidMap_GetAll_implActor*>(this)->actor_wait_state = 0;
		static_cast<TagUidMap_GetAll_implActor*>(this)->ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*,TagMap::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*,TagMap::RangeResultType && value) 
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TagUidMap* tagsMap;
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Snapshot snapshot;
															#line 151 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key prefix;
															#line 333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via getAll_impl()
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TagUidMap_GetAll_implActor final : public Actor<std::vector<KeyBackedTag>>, public ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >, public FastAllocated<TagUidMap_GetAll_implActor>, public TagUidMap_GetAll_implActorState<TagUidMap_GetAll_implActor> {
															#line 338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<TagUidMap_GetAll_implActor>::operator new;
	using FastAllocated<TagUidMap_GetAll_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3691672905545970944UL, 12766289290525048576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyBackedTag>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >;
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TagUidMap_GetAll_implActor(TagUidMap* const& tagsMap,Reference<ReadYourWritesTransaction> const& tr,Snapshot const& snapshot) 
															#line 355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<std::vector<KeyBackedTag>>(),
		   TagUidMap_GetAll_implActorState<TagUidMap_GetAll_implActor>(tagsMap, tr, snapshot),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAll_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4531936230553832704UL, 10523325084301780224UL);
		ActorExecutionContextHelper __helper(static_cast<TagUidMap_GetAll_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAll_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAll_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagUidMap_GetAll_implActor, 0, TagMap::RangeResultType >*)0, actor_cancelled()); break;
		}

	}
};
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<std::vector<KeyBackedTag>> TagUidMap::getAll_impl( TagUidMap* const& tagsMap, Reference<ReadYourWritesTransaction> const& tr, Snapshot const& snapshot ) {
															#line 148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::vector<KeyBackedTag>>(new TagUidMap_GetAll_implActor(tagsMap, tr, snapshot));
															#line 387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 158 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

KeyBackedTag::KeyBackedTag(std::string tagName, StringRef tagMapPrefix)
  : KeyBackedProperty<UidAndAbortedFlagT>(TagUidMap(tagMapPrefix).getProperty(tagName)), tagName(tagName),
    tagMapPrefix(tagMapPrefix) {}

// Lists all backups and find if any partitioned backup is running.
															#line 397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
namespace {
// This generated class is to be used only via anyPartitionedBackupRunning()
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AnyPartitionedBackupRunningActor>
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AnyPartitionedBackupRunningActorState {
															#line 404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AnyPartitionedBackupRunningActorState(Reference<ReadYourWritesTransaction> const& tr) 
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr)
															#line 411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this));

	}
	~AnyPartitionedBackupRunningActorState() 
	{
		fdb_probe_actor_destroy("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 165 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 167 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<std::vector<KeyBackedTag>> __when_expr_0 = getAllBackupTags(tr);
															#line 167 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 1;
															#line 167 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AnyPartitionedBackupRunningActorState();
		static_cast<AnyPartitionedBackupRunningActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<KeyBackedTag> const& tags,int loopDepth) 
	{
															#line 169 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		futures = std::vector<Future<Optional<UidAndAbortedFlagT>>>();
															#line 170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const auto& tag : tags ) {
															#line 171 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			futures.push_back(tag.get(tr));
															#line 464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 174 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(futures);
															#line 174 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 2;
															#line 174 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<KeyBackedTag> && tags,int loopDepth) 
	{
															#line 169 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		futures = std::vector<Future<Optional<UidAndAbortedFlagT>>>();
															#line 170 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const auto& tag : tags ) {
															#line 171 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			futures.push_back(tag.get(tr));
															#line 488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 174 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(futures);
															#line 174 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 2;
															#line 174 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<KeyBackedTag> const& tags,int loopDepth) 
	{
		loopDepth = a_body1cont1(tags, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<KeyBackedTag> && tags,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tags), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state > 0) static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 0;
		static_cast<AnyPartitionedBackupRunningActor*>(this)->ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >::remove();

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*,std::vector<KeyBackedTag> const& value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*,std::vector<KeyBackedTag> && value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*,Error err) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 175 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 176 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 175 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 176 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i = 0;
															#line 596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state > 0) static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 0;
		static_cast<AnyPartitionedBackupRunningActor*>(this)->ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 189 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV<bool>::futures) { (void)(false); this->~AnyPartitionedBackupRunningActorState(); static_cast<AnyPartitionedBackupRunningActor*>(this)->destroy(); return 0; }
															#line 680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV< bool >::value()) bool(false);
		this->~AnyPartitionedBackupRunningActorState();
		static_cast<AnyPartitionedBackupRunningActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 176 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(i < futures.size()))
															#line 699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 177 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (futures[i].get().present())
															#line 705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 178 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			partitionedLog = Optional<bool>();
															#line 179 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			state = EBackupState();
															#line 180 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			BackupConfig config(futures[i].get().get().first);
															#line 182 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store(state, config.stateEnum().getD(tr, Snapshot::False, EBackupState::STATE_NEVERRAN)) && store(partitionedLog, config.partitionedLogEnabled().get(tr));
															#line 182 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 3;
															#line 182 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*>(static_cast<AnyPartitionedBackupRunningActor*>(this)));
															#line 722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 176 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		i++;
															#line 749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 184 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (FileBackupAgent::isRunnable(state) && partitionedLog.present() && partitionedLog.get())
															#line 758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 185 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV<bool>::futures) { (void)(true); this->~AnyPartitionedBackupRunningActorState(); static_cast<AnyPartitionedBackupRunningActor*>(this)->destroy(); return 0; }
															#line 762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV< bool >::value()) bool(true);
			this->~AnyPartitionedBackupRunningActorState();
			static_cast<AnyPartitionedBackupRunningActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 184 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (FileBackupAgent::isRunnable(state) && partitionedLog.present() && partitionedLog.get())
															#line 776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 185 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV<bool>::futures) { (void)(true); this->~AnyPartitionedBackupRunningActorState(); static_cast<AnyPartitionedBackupRunningActor*>(this)->destroy(); return 0; }
															#line 780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<AnyPartitionedBackupRunningActor*>(this)->SAV< bool >::value()) bool(true);
			this->~AnyPartitionedBackupRunningActorState();
			static_cast<AnyPartitionedBackupRunningActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state > 0) static_cast<AnyPartitionedBackupRunningActor*>(this)->actor_wait_state = 0;
		static_cast<AnyPartitionedBackupRunningActor*>(this)->ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 169 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::vector<Future<Optional<UidAndAbortedFlagT>>> futures;
															#line 175 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int i;
															#line 178 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Optional<bool> partitionedLog;
															#line 179 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EBackupState state;
															#line 875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via anyPartitionedBackupRunning()
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AnyPartitionedBackupRunningActor final : public Actor<bool>, public ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >, public ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >, public ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >, public FastAllocated<AnyPartitionedBackupRunningActor>, public AnyPartitionedBackupRunningActorState<AnyPartitionedBackupRunningActor> {
															#line 880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<AnyPartitionedBackupRunningActor>::operator new;
	using FastAllocated<AnyPartitionedBackupRunningActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15477895209598467072UL, 13270053974605213184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >;
friend struct ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >;
friend struct ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >;
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AnyPartitionedBackupRunningActor(Reference<ReadYourWritesTransaction> const& tr) 
															#line 899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<bool>(),
		   AnyPartitionedBackupRunningActorState<AnyPartitionedBackupRunningActor>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(587540076039375616UL, 15683259992114904576UL);
		ActorExecutionContextHelper __helper(static_cast<AnyPartitionedBackupRunningActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("anyPartitionedBackupRunning");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("anyPartitionedBackupRunning", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AnyPartitionedBackupRunningActor, 0, std::vector<KeyBackedTag> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AnyPartitionedBackupRunningActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AnyPartitionedBackupRunningActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<bool> anyPartitionedBackupRunning( Reference<ReadYourWritesTransaction> const& tr ) {
															#line 164 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<bool>(new AnyPartitionedBackupRunningActor(tr));
															#line 934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 191 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

class RestoreConfig : public KeyBackedTaskConfig {
public:
	RestoreConfig(UID uid = UID()) : KeyBackedTaskConfig(fileRestorePrefixRange.begin, uid) {}
	RestoreConfig(Reference<Task> task) : KeyBackedTaskConfig(fileRestorePrefixRange.begin, task) {}

	KeyBackedProperty<ERestoreState> stateEnum() { return configSpace.pack(__FUNCTION__sr); }
	Future<StringRef> stateText(Reference<ReadYourWritesTransaction> tr) {
		return map(stateEnum().getD(tr),
		           [](ERestoreState s) -> StringRef { return FileBackupAgent::restoreStateText(s); });
	}
	KeyBackedProperty<Key> addPrefix() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Key> removePrefix() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> onlyApplyMutationLogs() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> inconsistentSnapshotOnly() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> unlockDBAfterRestore() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<bool> transformPartitionedLog() { return configSpace.pack(__FUNCTION__sr); }
	// XXX: Remove restoreRange() once it is safe to remove. It has been changed to restoreRanges
	KeyBackedProperty<KeyRange> restoreRange() { return configSpace.pack(__FUNCTION__sr); }
	// XXX: Changed to restoreRangeSet. It can be removed.
	KeyBackedProperty<std::vector<KeyRange>> restoreRanges() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedSet<KeyRange> restoreRangeSet() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Key> batchFuture() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Version> beginVersion() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Version> restoreVersion() { return configSpace.pack(__FUNCTION__sr); }
	KeyBackedProperty<Version> firstConsistentVersion() { return configSpace.pack(__FUNCTION__sr); }

	KeyBackedProperty<Reference<IBackupContainer>> sourceContainer() { return configSpace.pack(__FUNCTION__sr); }
	// Get the source container as a bare URL, without creating a container instance
	KeyBackedProperty<Value> sourceContainerURL() { return configSpace.pack("sourceContainer"_sr); }

	// Total bytes written by all log and range restore tasks.
	KeyBackedBinaryValue<int64_t> bytesWritten() { return configSpace.pack(__FUNCTION__sr); }
	// File blocks that have had tasks created for them by the Dispatch task
	KeyBackedBinaryValue<int64_t> filesBlocksDispatched() { return configSpace.pack(__FUNCTION__sr); }
	// File blocks whose tasks have finished
	KeyBackedBinaryValue<int64_t> fileBlocksFinished() { return configSpace.pack(__FUNCTION__sr); }
	// Total number of files in the fileMap
	KeyBackedBinaryValue<int64_t> fileCount() { return configSpace.pack(__FUNCTION__sr); }
	// Total number of file blocks in the fileMap
	KeyBackedBinaryValue<int64_t> fileBlockCount() { return configSpace.pack(__FUNCTION__sr); }

	// True for blob granule restore
	KeyBackedBinaryValue<bool> isBlobGranuleRestore() { return configSpace.pack(__FUNCTION__sr); }

	Future<std::vector<KeyRange>> getRestoreRangesOrDefault(Reference<ReadYourWritesTransaction> tr) {
		return getRestoreRangesOrDefault_impl(this, tr);
	}

																#line 987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via getRestoreRangesOrDefault_impl()
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetRestoreRangesOrDefault_implActor>
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetRestoreRangesOrDefault_implActorState {
															#line 993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetRestoreRangesOrDefault_implActorState(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 242 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   ranges(),
															#line 243 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   batchSize(BUGGIFY ? 1 : CLIENT_KNOBS->RESTORE_RANGES_READ_BATCH),
															#line 244 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   begin(),
															#line 245 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   arena()
															#line 1010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetRestoreRangesOrDefault_implActorState() 
	{
		fdb_probe_actor_destroy("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 246 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			;
															#line 1025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRestoreRangesOrDefault_implActorState();
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 258 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ranges.empty())
															#line 1048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 259 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<std::vector<KeyRange>> __when_expr_1 = self->restoreRanges().getD(tr);
															#line 259 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 2;
															#line 259 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 1059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 247 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<KeyBackedSet<KeyRange>::RangeResultType> __when_expr_0 = self->restoreRangeSet().getRange(tr, begin, {}, batchSize);
															#line 247 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 1;
															#line 247 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 1087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(KeyBackedSet<KeyRange>::RangeResultType const& rangeResult,int loopDepth) 
	{
															#line 249 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.insert(ranges.end(), rangeResult.results.begin(), rangeResult.results.end());
															#line 250 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!rangeResult.more)
															#line 1111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 253 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(!rangeResult.results.empty());
															#line 254 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		begin = KeyRangeRef(KeyRef(arena, ranges.back().begin), keyAfter(ranges.back().end, arena));
															#line 1119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(KeyBackedSet<KeyRange>::RangeResultType && rangeResult,int loopDepth) 
	{
															#line 249 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.insert(ranges.end(), rangeResult.results.begin(), rangeResult.results.end());
															#line 250 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!rangeResult.more)
															#line 1130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 253 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(!rangeResult.results.empty());
															#line 254 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		begin = KeyRangeRef(KeyRef(arena, ranges.back().begin), keyAfter(ranges.back().end, arena));
															#line 1138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedSet<KeyRange>::RangeResultType const& rangeResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(rangeResult, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedSet<KeyRange>::RangeResultType && rangeResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(rangeResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*,KeyBackedSet<KeyRange>::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*,KeyBackedSet<KeyRange>::RangeResultType && value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetRestoreRangesOrDefault_implActor*>(this)->SAV<std::vector<KeyRange>>::futures) { (void)(ranges); this->~GetRestoreRangesOrDefault_implActorState(); static_cast<GetRestoreRangesOrDefault_implActor*>(this)->destroy(); return 0; }
															#line 1222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<GetRestoreRangesOrDefault_implActor*>(this)->SAV< std::vector<KeyRange> >::value()) std::vector<KeyRange>(std::move(ranges)); // state_var_RVO
		this->~GetRestoreRangesOrDefault_implActorState();
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(std::vector<KeyRange> const& _ranges,int loopDepth) 
	{
															#line 260 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges = _ranges;
															#line 261 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ranges.empty())
															#line 1236 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 262 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<KeyRange> __when_expr_2 = self->restoreRange().getD(tr);
															#line 262 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 3;
															#line 262 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 1247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(std::vector<KeyRange> && _ranges,int loopDepth) 
	{
															#line 260 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges = _ranges;
															#line 261 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ranges.empty())
															#line 1263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 262 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<KeyRange> __when_expr_2 = self->restoreRange().getD(tr);
															#line 262 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 3;
															#line 262 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*>(static_cast<GetRestoreRangesOrDefault_implActor*>(this)));
															#line 1274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<KeyRange> const& _ranges,int loopDepth) 
	{
		loopDepth = a_body1cont3(_ranges, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<KeyRange> && _ranges,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_ranges), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*,std::vector<KeyRange> const& value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*,std::vector<KeyRange> && value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(KeyRange const& range,int loopDepth) 
	{
															#line 263 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.push_back(range);
															#line 1369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(KeyRange && range,int loopDepth) 
	{
															#line 263 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ranges.push_back(range);
															#line 1378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(KeyRange const& range,int loopDepth) 
	{
		loopDepth = a_body1cont5(range, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(KeyRange && range,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreRangesOrDefault_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreRangesOrDefault_implActor*>(this)->ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*,KeyRange const& value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*,KeyRange && value) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig* self;
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 242 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::vector<KeyRange> ranges;
															#line 243 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int batchSize;
															#line 244 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Optional<KeyRange> begin;
															#line 245 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Arena arena;
															#line 1470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via getRestoreRangesOrDefault_impl()
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetRestoreRangesOrDefault_implActor final : public Actor<std::vector<KeyRange>>, public ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >, public ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >, public ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >, public FastAllocated<GetRestoreRangesOrDefault_implActor>, public GetRestoreRangesOrDefault_implActorState<GetRestoreRangesOrDefault_implActor> {
															#line 1475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<GetRestoreRangesOrDefault_implActor>::operator new;
	using FastAllocated<GetRestoreRangesOrDefault_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5163176831890278912UL, 9111048753632441088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyRange>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >;
friend struct ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >;
friend struct ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >;
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetRestoreRangesOrDefault_implActor(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 1494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<std::vector<KeyRange>>(),
		   GetRestoreRangesOrDefault_implActorState<GetRestoreRangesOrDefault_implActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7781314247607341824UL, 4200768842030992896UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreRangesOrDefault_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRestoreRangesOrDefault_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRestoreRangesOrDefault_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRestoreRangesOrDefault_implActor, 0, KeyBackedSet<KeyRange>::RangeResultType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRestoreRangesOrDefault_implActor, 1, std::vector<KeyRange> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRestoreRangesOrDefault_implActor, 2, KeyRange >*)0, actor_cancelled()); break;
		}

	}
};
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<std::vector<KeyRange>> getRestoreRangesOrDefault_impl( RestoreConfig* const& self, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 240 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::vector<KeyRange>>(new GetRestoreRangesOrDefault_implActor(self, tr));
															#line 1528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 268 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// Describes a file to load blocks from during restore.  Ordered by version and then fileName to enable
	// incrementally advancing through the map, saving the version and path of the next starting point.
	struct RestoreFile {
		Version version; // this is beginVersion, not endVersion
		std::string fileName;
		bool isRange{ false }; // false for log file
		int64_t blockSize{ 0 };
		int64_t fileSize{ 0 };
		Version endVersion{ ::invalidVersion }; // not meaningful for range files
		int64_t tagId = -1; // only meaningful to log files, Log router tag. Non-negative for new backup format.
		int64_t totalTags = -1; // only meaningful to log files, Total number of log router tags.

		Tuple pack() const {
			return Tuple::makeTuple(
			    version, fileName, (int64_t)isRange, fileSize, blockSize, endVersion, tagId, totalTags);
		}
		static RestoreFile unpack(Tuple const& t) {
			RestoreFile r;
			int i = 0;
			r.version = t.getInt(i++);
			r.fileName = t.getString(i++).toString();
			r.isRange = t.getInt(i++) != 0;
			r.fileSize = t.getInt(i++);
			r.blockSize = t.getInt(i++);
			r.endVersion = t.getInt(i++);
			r.tagId = t.getInt(i++);
			r.totalTags = t.getInt(i++);
			return r;
		}
	};

	typedef KeyBackedSet<RestoreFile> FileSetT;
	FileSetT fileSet() { return configSpace.pack(__FUNCTION__sr); }

	FileSetT logFileSet() { return configSpace.pack(__FUNCTION__sr); }
	FileSetT rangeFileSet() { return configSpace.pack(__FUNCTION__sr); }

	Future<bool> isRunnable(Reference<ReadYourWritesTransaction> tr) {
		return map(stateEnum().getD(tr), [](ERestoreState s) -> bool {
			return s != ERestoreState::ABORTED && s != ERestoreState::COMPLETED && s != ERestoreState::UNINITIALIZED;
		});
	}

	Future<Void> logError(Database cx, Error e, std::string const& details, void* taskInstance = nullptr) {
		if (!uid.isValid()) {
			TraceEvent(SevError, "FileRestoreErrorNoUID").error(e).detail("Description", details);
			return Void();
		}
		TraceEvent t(SevWarn, "FileRestoreError");
		t.error(e)
		    .detail("RestoreUID", uid)
		    .detail("Description", details)
		    .detail("TaskInstance", (uint64_t)taskInstance);
		// key_not_found could happen
		if (e.code() == error_code_key_not_found)
			t.backtrace();

		return updateErrorInfo(cx, e, details);
	}

	Key mutationLogPrefix() { return uidPrefixKey(applyLogKeys.begin, uid); }

	Key applyMutationsMapPrefix() { return uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid); }

																#line 1597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via getApplyVersionLag_impl()
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetApplyVersionLag_implActor>
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetApplyVersionLag_implActorState {
															#line 1603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetApplyVersionLag_implActorState(Reference<ReadYourWritesTransaction> const& tr,UID const& uid) 
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   uid(uid),
															#line 334 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   beginVal(tr->get(uidPrefixKey(applyMutationsBeginRange.begin, uid), Snapshot::True)),
															#line 336 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   endVal(tr->get(uidPrefixKey(applyMutationsEndRange.begin, uid), Snapshot::True))
															#line 1616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetApplyVersionLag_implActorState() 
	{
		fdb_probe_actor_destroy("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 337 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(beginVal) && success(endVal);
															#line 337 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state = 1;
															#line 337 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetApplyVersionLag_implActor, 0, Void >*>(static_cast<GetApplyVersionLag_implActor*>(this)));
															#line 1638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetApplyVersionLag_implActorState();
		static_cast<GetApplyVersionLag_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 339 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!beginVal.get().present() || !endVal.get().present())
															#line 1661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 340 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 1665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~GetApplyVersionLag_implActorState();
			static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version beginVersion = BinaryReader::fromStringRef<Version>(beginVal.get().get(), Unversioned());
															#line 343 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version endVersion = BinaryReader::fromStringRef<Version>(endVal.get().get(), Unversioned());
															#line 344 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(endVersion - beginVersion); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 1677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(endVersion - beginVersion);
		this->~GetApplyVersionLag_implActorState();
		static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 339 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!beginVal.get().present() || !endVal.get().present())
															#line 1689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 340 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 1693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~GetApplyVersionLag_implActorState();
			static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version beginVersion = BinaryReader::fromStringRef<Version>(beginVal.get().get(), Unversioned());
															#line 343 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Version endVersion = BinaryReader::fromStringRef<Version>(endVal.get().get(), Unversioned());
															#line 344 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetApplyVersionLag_implActor*>(this)->SAV<int64_t>::futures) { (void)(endVersion - beginVersion); this->~GetApplyVersionLag_implActorState(); static_cast<GetApplyVersionLag_implActor*>(this)->destroy(); return 0; }
															#line 1705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<GetApplyVersionLag_implActor*>(this)->SAV< int64_t >::value()) int64_t(endVersion - beginVersion);
		this->~GetApplyVersionLag_implActorState();
		static_cast<GetApplyVersionLag_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state > 0) static_cast<GetApplyVersionLag_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetApplyVersionLag_implActor*>(this)->ActorCallback< GetApplyVersionLag_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetApplyVersionLag_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetApplyVersionLag_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetApplyVersionLag_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID uid;
															#line 334 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Optional<Value>> beginVal;
															#line 336 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Optional<Value>> endVal;
															#line 1796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via getApplyVersionLag_impl()
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetApplyVersionLag_implActor final : public Actor<int64_t>, public ActorCallback< GetApplyVersionLag_implActor, 0, Void >, public FastAllocated<GetApplyVersionLag_implActor>, public GetApplyVersionLag_implActorState<GetApplyVersionLag_implActor> {
															#line 1801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<GetApplyVersionLag_implActor>::operator new;
	using FastAllocated<GetApplyVersionLag_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17068909949096035840UL, 3583144671835928064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetApplyVersionLag_implActor, 0, Void >;
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetApplyVersionLag_implActor(Reference<ReadYourWritesTransaction> const& tr,UID const& uid) 
															#line 1818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetApplyVersionLag_implActorState<GetApplyVersionLag_implActor>(tr, uid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9614200584100791808UL, 10485171078912906496UL);
		ActorExecutionContextHelper __helper(static_cast<GetApplyVersionLag_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getApplyVersionLag_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getApplyVersionLag_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetApplyVersionLag_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<int64_t> getApplyVersionLag_impl( Reference<ReadYourWritesTransaction> const& tr, UID const& uid ) {
															#line 333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<int64_t>(new GetApplyVersionLag_implActor(tr, uid));
															#line 1850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 346 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<int64_t> getApplyVersionLag(Reference<ReadYourWritesTransaction> tr) {
		return getApplyVersionLag_impl(tr, uid);
	}

	void initApplyMutations(Reference<ReadYourWritesTransaction> tr,
	                        Key addPrefix,
	                        Key removePrefix,
	                        OnlyApplyMutationLogs onlyApplyMutationLogs) {
		// Set these because they have to match the applyMutations values.
		this->addPrefix().set(tr, addPrefix);
		this->removePrefix().set(tr, removePrefix);

		clearApplyMutationsKeys(tr);

		// Initialize add/remove prefix, range version map count and set the map's start key to InvalidVersion
		tr->set(uidPrefixKey(applyMutationsAddPrefixRange.begin, uid), addPrefix);
		tr->set(uidPrefixKey(applyMutationsRemovePrefixRange.begin, uid), removePrefix);

		int64_t startCount = 0;
		tr->set(uidPrefixKey(applyMutationsKeyVersionCountRange.begin, uid), StringRef((uint8_t*)&startCount, 8));
		Key mapStart = uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
		tr->set(mapStart, BinaryWriter::toValue<Version>(invalidVersion, Unversioned()));
	}

	void clearApplyMutationsKeys(Reference<ReadYourWritesTransaction> tr) {
		tr->setOption(FDBTransactionOptions::COMMIT_ON_FIRST_PROXY);

		// Clear add/remove prefix keys
		tr->clear(uidPrefixKey(applyMutationsAddPrefixRange.begin, uid));
		tr->clear(uidPrefixKey(applyMutationsRemovePrefixRange.begin, uid));

		// Clear range version map and count key
		tr->clear(uidPrefixKey(applyMutationsKeyVersionCountRange.begin, uid));
		Key mapStart = uidPrefixKey(applyMutationsKeyVersionMapRange.begin, uid);
		tr->clear(KeyRangeRef(mapStart, strinc(mapStart)));

		// Clear any loaded mutations that have not yet been applied
		Key mutationPrefix = mutationLogPrefix();
		tr->clear(KeyRangeRef(mutationPrefix, strinc(mutationPrefix)));

		// Clear end and begin versions (intentionally in this order)
		tr->clear(uidPrefixKey(applyMutationsEndRange.begin, uid));
		tr->clear(uidPrefixKey(applyMutationsBeginRange.begin, uid));
	}

	void setApplyBeginVersion(Reference<ReadYourWritesTransaction> tr, Version ver) {
		tr->set(uidPrefixKey(applyMutationsBeginRange.begin, uid), BinaryWriter::toValue(ver, Unversioned()));
	}

	Future<Version> getApplyBeginVersion(Reference<ReadYourWritesTransaction> tr) {
		return map(tr->get(uidPrefixKey(applyMutationsBeginRange.begin, uid)),
		           [=](Optional<Value> const& value) -> Version {
			           return value.present() ? BinaryReader::fromStringRef<Version>(value.get(), Unversioned()) : 0;
		           });
	}

	void setApplyEndVersion(Reference<ReadYourWritesTransaction> tr, Version ver) {
		tr->set(uidPrefixKey(applyMutationsEndRange.begin, uid), BinaryWriter::toValue(ver, Unversioned()));
	}

	Future<Version> getApplyEndVersion(Reference<ReadYourWritesTransaction> tr) {
		return map(tr->get(uidPrefixKey(applyMutationsEndRange.begin, uid)),
		           [=](Optional<Value> const& value) -> Version {
			           return value.present() ? BinaryReader::fromStringRef<Version>(value.get(), Unversioned()) : 0;
		           });
	}

																#line 1922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via getCurrentVersion_impl()
															#line 414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetCurrentVersion_implActor>
															#line 414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetCurrentVersion_implActorState {
															#line 1928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetCurrentVersion_implActorState(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr)
															#line 1937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetCurrentVersion_implActorState() 
	{
		fdb_probe_actor_destroy("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 415 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<ERestoreState> __when_expr_0 = self->stateEnum().getD(tr);
															#line 415 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 1;
															#line 415 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*>(static_cast<GetCurrentVersion_implActor*>(this)));
															#line 1959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCurrentVersion_implActorState();
		static_cast<GetCurrentVersion_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 416 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = -1;
															#line 417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (status == ERestoreState::RUNNING)
															#line 1984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 418 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(version, self->getApplyBeginVersion(tr));
															#line 418 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 2;
															#line 418 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetCurrentVersion_implActor, 1, Void >*>(static_cast<GetCurrentVersion_implActor*>(this)));
															#line 1995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 419 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (status == ERestoreState::COMPLETED)
															#line 2002 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 420 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_2 = store(version, self->restoreVersion().getD(tr));
															#line 420 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
				static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 3;
															#line 420 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetCurrentVersion_implActor, 2, Void >*>(static_cast<GetCurrentVersion_implActor*>(this)));
															#line 2013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont4(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1when1(ERestoreState const& __status,int loopDepth) 
	{
															#line 415 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		status = __status;
															#line 2028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ERestoreState && __status,int loopDepth) 
	{
		status = std::move(__status);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state > 0) static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetCurrentVersion_implActor*>(this)->ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >::remove();

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*,ERestoreState const& value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*,ERestoreState && value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*,Error err) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 422 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetCurrentVersion_implActor*>(this)->SAV<Version>::futures) { (void)(version); this->~GetCurrentVersion_implActorState(); static_cast<GetCurrentVersion_implActor*>(this)->destroy(); return 0; }
															#line 2107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<GetCurrentVersion_implActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~GetCurrentVersion_implActorState();
		static_cast<GetCurrentVersion_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state > 0) static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetCurrentVersion_implActor*>(this)->ActorCallback< GetCurrentVersion_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetCurrentVersion_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state > 0) static_cast<GetCurrentVersion_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetCurrentVersion_implActor*>(this)->ActorCallback< GetCurrentVersion_implActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetCurrentVersion_implActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetCurrentVersion_implActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig* self;
															#line 414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 415 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	ERestoreState status;
															#line 416 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version version;
															#line 2303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via getCurrentVersion_impl()
															#line 414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetCurrentVersion_implActor final : public Actor<Version>, public ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >, public ActorCallback< GetCurrentVersion_implActor, 1, Void >, public ActorCallback< GetCurrentVersion_implActor, 2, Void >, public FastAllocated<GetCurrentVersion_implActor>, public GetCurrentVersion_implActorState<GetCurrentVersion_implActor> {
															#line 2308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<GetCurrentVersion_implActor>::operator new;
	using FastAllocated<GetCurrentVersion_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2017144230918679808UL, 15560255543215443968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >;
friend struct ActorCallback< GetCurrentVersion_implActor, 1, Void >;
friend struct ActorCallback< GetCurrentVersion_implActor, 2, Void >;
															#line 414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetCurrentVersion_implActor(RestoreConfig* const& self,Reference<ReadYourWritesTransaction> const& tr) 
															#line 2327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Version>(),
		   GetCurrentVersion_implActorState<GetCurrentVersion_implActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6492461230199787776UL, 8628143503146865408UL);
		ActorExecutionContextHelper __helper(static_cast<GetCurrentVersion_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCurrentVersion_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCurrentVersion_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCurrentVersion_implActor, 0, ERestoreState >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetCurrentVersion_implActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetCurrentVersion_implActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Version> getCurrentVersion_impl( RestoreConfig* const& self, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Version>(new GetCurrentVersion_implActor(self, tr));
															#line 2361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 424 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Version> getCurrentVersion(Reference<ReadYourWritesTransaction> tr) {
		return getCurrentVersion_impl(this, tr);
	}

																#line 2370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
[[nodiscard]] static Future<std::string> getProgress_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr );
template <class> friend class RestoreConfig_GetProgress_implActorState;

#line 430 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> getProgress(Reference<ReadYourWritesTransaction> tr) { return getProgress_impl(*this, tr); }

																#line 2377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
[[nodiscard]] static Future<std::string> getFullStatus_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr );
template <class> friend class RestoreConfig_GetFullStatus_implActorState;

#line 433 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> getFullStatus(Reference<ReadYourWritesTransaction> tr) { return getFullStatus_impl(*this, tr); }
};

typedef RestoreConfig::RestoreFile RestoreFile;

															#line 2387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via getProgress_impl()
															#line 438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class RestoreConfig_GetProgress_implActor>
															#line 438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetProgress_implActorState {
															#line 2393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetProgress_implActorState(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : restore(restore),
															#line 438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr)
															#line 2402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("getProgress_impl", reinterpret_cast<unsigned long>(this));

	}
	~RestoreConfig_GetProgress_implActorState() 
	{
		fdb_probe_actor_destroy("getProgress_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 440 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 441 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 443 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileCount = restore.fileCount().getD(tr);
															#line 444 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileBlockCount = restore.fileBlockCount().getD(tr);
															#line 445 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileBlocksDispatched = restore.filesBlocksDispatched().getD(tr);
															#line 446 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			fileBlocksFinished = restore.fileBlocksFinished().getD(tr);
															#line 447 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			bytesWritten = restore.bytesWritten().getD(tr);
															#line 448 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			status = restore.stateText(tr);
															#line 449 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			currentVersion = restore.getCurrentVersion(tr);
															#line 450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			lag = restore.getApplyVersionLag(tr);
															#line 451 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			firstConsistentVersion = restore.firstConsistentVersion().getD(tr);
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tag = restore.tag().getD(tr);
															#line 453 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			lastError = restore.lastError().getD(tr);
															#line 456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			uid = restore.getUid();
															#line 457 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(fileCount) && success(fileBlockCount) && success(fileBlocksDispatched) && success(fileBlocksFinished) && success(bytesWritten) && success(status) && success(currentVersion) && success(lag) && success(firstConsistentVersion) && success(tag) && success(lastError);
															#line 457 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state = 1;
															#line 457 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*>(static_cast<RestoreConfig_GetProgress_implActor*>(this)));
															#line 2452 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreConfig_GetProgress_implActorState();
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 461 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string errstr = "None";
															#line 462 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (lastError.get().second != 0)
															#line 2477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 463 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			errstr = format("'%s' %" PRId64 "s ago.\n", lastError.get().first.c_str(), (tr->getReadVersion().get() - lastError.get().second) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND);
															#line 2481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 467 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileRestoreProgress") .detail("RestoreUID", uid) .detail("Tag", tag.get()) .detail("State", status.get().toString()) .detail("FileCount", fileCount.get()) .detail("FileBlocksFinished", fileBlocksFinished.get()) .detail("FileBlocksTotal", fileBlockCount.get()) .detail("FileBlocksInProgress", fileBlocksDispatched.get() - fileBlocksFinished.get()) .detail("BytesWritten", bytesWritten.get()) .detail("CurrentVersion", currentVersion.get()) .detail("FirstConsistentVersion", firstConsistentVersion.get()) .detail("ApplyLag", lag.get()) .detail("TaskInstance", THIS_ADDR);
															#line 481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV<std::string>::futures) { (void)(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str())); this->~RestoreConfig_GetProgress_implActorState(); static_cast<RestoreConfig_GetProgress_implActor*>(this)->destroy(); return 0; }
															#line 2487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV< std::string >::value()) std::string(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str()));
		this->~RestoreConfig_GetProgress_implActorState();
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 461 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string errstr = "None";
															#line 462 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (lastError.get().second != 0)
															#line 2501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 463 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			errstr = format("'%s' %" PRId64 "s ago.\n", lastError.get().first.c_str(), (tr->getReadVersion().get() - lastError.get().second) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND);
															#line 2505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 467 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileRestoreProgress") .detail("RestoreUID", uid) .detail("Tag", tag.get()) .detail("State", status.get().toString()) .detail("FileCount", fileCount.get()) .detail("FileBlocksFinished", fileBlocksFinished.get()) .detail("FileBlocksTotal", fileBlockCount.get()) .detail("FileBlocksInProgress", fileBlocksDispatched.get() - fileBlocksFinished.get()) .detail("BytesWritten", bytesWritten.get()) .detail("CurrentVersion", currentVersion.get()) .detail("FirstConsistentVersion", firstConsistentVersion.get()) .detail("ApplyLag", lag.get()) .detail("TaskInstance", THIS_ADDR);
															#line 481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV<std::string>::futures) { (void)(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str())); this->~RestoreConfig_GetProgress_implActorState(); static_cast<RestoreConfig_GetProgress_implActor*>(this)->destroy(); return 0; }
															#line 2511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<RestoreConfig_GetProgress_implActor*>(this)->SAV< std::string >::value()) std::string(format("Tag: %s  UID: %s  State: %s  Blocks: %lld/%lld  BlocksInProgress: %lld  Files: %lld  BytesWritten: " "%lld  ApplyVersionLag: %lld  LastError: %s", tag.get().c_str(), uid.toString().c_str(), status.get().toString().c_str(), fileBlocksFinished.get(), fileBlockCount.get(), fileBlocksDispatched.get() - fileBlocksFinished.get(), fileCount.get(), bytesWritten.get(), lag.get(), errstr.c_str()));
		this->~RestoreConfig_GetProgress_implActorState();
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state > 0) static_cast<RestoreConfig_GetProgress_implActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreConfig_GetProgress_implActor*>(this)->ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig restore;
															#line 438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 443 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileCount;
															#line 444 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileBlockCount;
															#line 445 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileBlocksDispatched;
															#line 446 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> fileBlocksFinished;
															#line 447 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<int64_t> bytesWritten;
															#line 448 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<StringRef> status;
															#line 449 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> currentVersion;
															#line 450 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> lag;
															#line 451 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> firstConsistentVersion;
															#line 452 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> tag;
															#line 453 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::pair<std::string, Version>> lastError;
															#line 456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID uid;
															#line 2622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via getProgress_impl()
															#line 438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetProgress_implActor final : public Actor<std::string>, public ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >, public FastAllocated<RestoreConfig_GetProgress_implActor>, public RestoreConfig_GetProgress_implActorState<RestoreConfig_GetProgress_implActor> {
															#line 2627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<RestoreConfig_GetProgress_implActor>::operator new;
	using FastAllocated<RestoreConfig_GetProgress_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5289633511042658560UL, 6534957720108800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >;
															#line 438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetProgress_implActor(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 2644 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<std::string>(),
		   RestoreConfig_GetProgress_implActorState<RestoreConfig_GetProgress_implActor>(restore, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getProgress_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18275805459408915200UL, 825561359449413632UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetProgress_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getProgress_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getProgress_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreConfig_GetProgress_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<std::string> RestoreConfig::getProgress_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::string>(new RestoreConfig_GetProgress_implActor(restore, tr));
															#line 2676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 494 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 2681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via getFullStatus_impl()
															#line 495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class RestoreConfig_GetFullStatus_implActor>
															#line 495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetFullStatus_implActorState {
															#line 2687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetFullStatus_implActorState(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : restore(restore),
															#line 495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr)
															#line 2696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("getFullStatus_impl", reinterpret_cast<unsigned long>(this));

	}
	~RestoreConfig_GetFullStatus_implActorState() 
	{
		fdb_probe_actor_destroy("getFullStatus_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 497 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 498 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 500 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ranges = restore.getRestoreRangesOrDefault(tr);
															#line 501 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			addPrefix = restore.addPrefix().getD(tr);
															#line 502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			removePrefix = restore.removePrefix().getD(tr);
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			url = restore.sourceContainerURL().getD(tr);
															#line 504 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			restoreVersion = restore.restoreVersion().getD(tr);
															#line 505 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			progress = restore.getProgress(tr);
															#line 508 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(ranges) && success(addPrefix) && success(removePrefix) && success(url) && success(restoreVersion) && success(progress);
															#line 508 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state = 1;
															#line 508 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*>(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)));
															#line 2734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreConfig_GetFullStatus_implActorState();
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 511 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string returnStr;
															#line 512 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr = format("%s  URL: %s", progress.get().c_str(), url.get().toString().c_str());
															#line 513 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& range : ranges.get() ) {
															#line 514 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			returnStr += format("  Range: '%s'-'%s'", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 2763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 516 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr += format("  AddPrefix: '%s'  RemovePrefix: '%s'  Version: %lld", printable(addPrefix.get()).c_str(), printable(removePrefix.get()).c_str(), restoreVersion.get());
															#line 520 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV<std::string>::futures) { (void)(returnStr); this->~RestoreConfig_GetFullStatus_implActorState(); static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->destroy(); return 0; }
															#line 2769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV< std::string >::value()) std::string(returnStr);
		this->~RestoreConfig_GetFullStatus_implActorState();
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 511 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::string returnStr;
															#line 512 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr = format("%s  URL: %s", progress.get().c_str(), url.get().toString().c_str());
															#line 513 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& range : ranges.get() ) {
															#line 514 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			returnStr += format("  Range: '%s'-'%s'", printable(range.begin).c_str(), printable(range.end).c_str());
															#line 2787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 516 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		returnStr += format("  AddPrefix: '%s'  RemovePrefix: '%s'  Version: %lld", printable(addPrefix.get()).c_str(), printable(removePrefix.get()).c_str(), restoreVersion.get());
															#line 520 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV<std::string>::futures) { (void)(returnStr); this->~RestoreConfig_GetFullStatus_implActorState(); static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->destroy(); return 0; }
															#line 2793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->SAV< std::string >::value()) std::string(returnStr);
		this->~RestoreConfig_GetFullStatus_implActorState();
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state > 0) static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig restore;
															#line 495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 500 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::vector<KeyRange>> ranges;
															#line 501 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Key> addPrefix;
															#line 502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Key> removePrefix;
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Key> url;
															#line 504 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<Version> restoreVersion;
															#line 505 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Future<std::string> progress;
															#line 2892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via getFullStatus_impl()
															#line 495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RestoreConfig_GetFullStatus_implActor final : public Actor<std::string>, public ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >, public FastAllocated<RestoreConfig_GetFullStatus_implActor>, public RestoreConfig_GetFullStatus_implActorState<RestoreConfig_GetFullStatus_implActor> {
															#line 2897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<RestoreConfig_GetFullStatus_implActor>::operator new;
	using FastAllocated<RestoreConfig_GetFullStatus_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12244393272683164672UL, 16535945411014203648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >;
															#line 495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RestoreConfig_GetFullStatus_implActor(RestoreConfig const& restore,Reference<ReadYourWritesTransaction> const& tr) 
															#line 2914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<std::string>(),
		   RestoreConfig_GetFullStatus_implActorState<RestoreConfig_GetFullStatus_implActor>(restore, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getFullStatus_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1316626605627362304UL, 15365334437446535168UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreConfig_GetFullStatus_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getFullStatus_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getFullStatus_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreConfig_GetFullStatus_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<std::string> RestoreConfig::getFullStatus_impl( RestoreConfig const& restore, Reference<ReadYourWritesTransaction> const& tr ) {
															#line 495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<std::string>(new RestoreConfig_GetFullStatus_implActor(restore, tr));
															#line 2946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 522 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// two buffers are alternatively serving data and reading data from file
// thus when one buffer is serving data through peek()
// the other buffer is reading data from file to provide pipelining.
class TwoBuffers : public ReferenceCounted<TwoBuffers>, NonCopyable {
public:
	class IteratorBuffer : public ReferenceCounted<IteratorBuffer> {
	public:
		std::shared_ptr<char[]> data;
		// has_value means there is data, otherwise it means there is no data being fetched or ready
		// is_valid means data is being fetched, is_ready means data is ready
		std::optional<Future<Void>> fetchingData;
		size_t size;
		int index;
		int capacity;
		IteratorBuffer(int _capacity) {
			capacity = _capacity;
			data = std::shared_ptr<char[]>(new char[capacity]());
			fetchingData.reset();
			size = 0;
		}
		bool is_valid() { return fetchingData.has_value(); }
		void reset() {
			size = 0;
			index = 0;
			fetchingData.reset();
		}
	};
	TwoBuffers(int capacity, Reference<IBackupContainer> _bc, std::vector<RestoreConfig::RestoreFile>& _files, int tag);
	// ready need to be called first before calling peek
	// because a shared_ptr cannot be wrapped by a Future
	// this method ensures the current buffer has available data
	Future<Void> ready();
																#line 2983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
[[nodiscard]] static Future<Void> ready( Reference<TwoBuffers> const& self );
template <class> friend class TwoBuffers_ReadyActorState;

#line 556 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	// fill buffer[index] with the next block of file
	// it has side effects to change currentFileIndex and currentFilePosition
																#line 2990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
[[nodiscard]] static Future<Void> readNextBlock( Reference<TwoBuffers> const& self, int const& index );
template <class> friend class TwoBuffers_ReadNextBlockActorState;

#line 559 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	// peek can only be called after ready is called
	// it returns the pointer to the active buffer
	std::shared_ptr<char[]> peek();

	int getFileIndex();
	void setFileIndex(int);

	bool hasNext();

	void reset();

	// discard the current buffer and swap to the next one
	void discardAndSwap();

	// try to fill the buffer[index]
	// but no-op if the buffer have valid data or it is actively being filled
	void fillBufferIfAbsent(int index);

	size_t getBufferSize();

private:
	Reference<IteratorBuffer> buffers[2]; // Two buffers for alternating
	size_t bufferCapacity; // Size of each buffer in bytes
	Reference<IBackupContainer> bc;
	std::vector<RestoreConfig::RestoreFile> files;
	int tag;

	int cur; // Index of the current active buffer (0 or 1)
	size_t currentFileIndex; // Index of the current file being read
	size_t currentFilePosition; // Current read position in the current file
};

TwoBuffers::TwoBuffers(int capacity,
                       Reference<IBackupContainer> _bc,
                       std::vector<RestoreConfig::RestoreFile>& _files,
                       int _tag)
  : currentFileIndex(0), currentFilePosition(0), cur(0), bufferCapacity(capacity), files(_files), bc(_bc), tag(_tag) {
	buffers[0] = makeReference<IteratorBuffer>(capacity);
	buffers[1] = makeReference<IteratorBuffer>(capacity);
}

bool TwoBuffers::hasNext() {
	// if it is being load (valid but not ready, what would be the size?)
	while (currentFileIndex < files.size() && currentFilePosition >= files[currentFileIndex].fileSize) {
		currentFileIndex++;
		currentFilePosition = 0;
	}

	if (buffers[0]->is_valid() || buffers[1]->is_valid()) {
		return true;
	}

	return currentFileIndex != files.size();
}

Future<Void> TwoBuffers::ready() {
	return ready(Reference<TwoBuffers>::addRef(this));
}

															#line 3054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via ready()
															#line 618 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class TwoBuffers_ReadyActor>
															#line 618 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadyActorState {
															#line 3060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 618 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadyActorState(Reference<TwoBuffers> const& self) 
															#line 618 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 618 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 3067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("ready", reinterpret_cast<unsigned long>(this));

	}
	~TwoBuffers_ReadyActorState() 
	{
		fdb_probe_actor_destroy("ready", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 620 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 3082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 621 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<TwoBuffers_ReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadyActorState(); static_cast<TwoBuffers_ReadyActor*>(this)->destroy(); return 0; }
															#line 3086 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				new (&static_cast<TwoBuffers_ReadyActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TwoBuffers_ReadyActorState();
				static_cast<TwoBuffers_ReadyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 624 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			self->fillBufferIfAbsent(self->cur);
															#line 625 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->buffers[self->cur]->fetchingData.value();
															#line 625 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state = 1;
															#line 625 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadyActor, 0, Void >*>(static_cast<TwoBuffers_ReadyActor*>(this)));
															#line 3103 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TwoBuffers_ReadyActorState();
		static_cast<TwoBuffers_ReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 627 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->hasNext())
															#line 3126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 628 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			self->fillBufferIfAbsent(1 - self->cur);
															#line 3130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 630 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TwoBuffers_ReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadyActorState(); static_cast<TwoBuffers_ReadyActor*>(this)->destroy(); return 0; }
															#line 3134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<TwoBuffers_ReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TwoBuffers_ReadyActorState();
		static_cast<TwoBuffers_ReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 627 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->hasNext())
															#line 3146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 628 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			self->fillBufferIfAbsent(1 - self->cur);
															#line 3150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 630 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TwoBuffers_ReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadyActorState(); static_cast<TwoBuffers_ReadyActor*>(this)->destroy(); return 0; }
															#line 3154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<TwoBuffers_ReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TwoBuffers_ReadyActorState();
		static_cast<TwoBuffers_ReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state > 0) static_cast<TwoBuffers_ReadyActor*>(this)->actor_wait_state = 0;
		static_cast<TwoBuffers_ReadyActor*>(this)->ActorCallback< TwoBuffers_ReadyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TwoBuffers_ReadyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 618 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TwoBuffers> self;
															#line 3239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via ready()
															#line 618 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadyActor final : public Actor<Void>, public ActorCallback< TwoBuffers_ReadyActor, 0, Void >, public FastAllocated<TwoBuffers_ReadyActor>, public TwoBuffers_ReadyActorState<TwoBuffers_ReadyActor> {
															#line 3244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<TwoBuffers_ReadyActor>::operator new;
	using FastAllocated<TwoBuffers_ReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11177078989683447040UL, 17358110757508174080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TwoBuffers_ReadyActor, 0, Void >;
															#line 618 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadyActor(Reference<TwoBuffers> const& self) 
															#line 3261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   TwoBuffers_ReadyActorState<TwoBuffers_ReadyActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ready", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14937009140389269760UL, 8193691466251763968UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ready");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ready", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TwoBuffers_ReadyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 618 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> TwoBuffers::ready( Reference<TwoBuffers> const& self ) {
															#line 618 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new TwoBuffers_ReadyActor(self));
															#line 3293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 632 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

std::shared_ptr<char[]> TwoBuffers::peek() {
	return buffers[cur]->data;
}

int TwoBuffers::getFileIndex() {
	return buffers[cur]->index;
}

void TwoBuffers::setFileIndex(int newIndex) {
	if (newIndex < 0 || newIndex >= files.size()) {
		TraceEvent(SevError, "TwoBuffersFileIndexOutOfBound")
		    .detail("FilesSize", files.size())
		    .detail("NewIndex", newIndex)
		    .log();
	}
	currentFileIndex = newIndex;
}

void TwoBuffers::discardAndSwap() {
	// invalidate cur and change cur to next
	buffers[cur]->fetchingData.reset();
	cur = 1 - cur;
}

void TwoBuffers::reset() {
	// invalidate cur and change cur to next
	buffers[0]->reset();
	buffers[1]->reset();
	cur = 0;
	currentFileIndex = 0;
	currentFilePosition = 0;
}

size_t TwoBuffers::getBufferSize() {
	return buffers[cur]->size;
}

static double testKeyToDouble(const KeyRef& p) {
	uint64_t x = 0;
	sscanf(p.toString().c_str(), "%" SCNx64, &x);
	return *(double*)&x;
}

// only one readNextBlock can be run at a single time, otherwie the same block might be loaded twice
															#line 3342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via readNextBlock()
															#line 677 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class TwoBuffers_ReadNextBlockActor>
															#line 677 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadNextBlockActorState {
															#line 3348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 677 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadNextBlockActorState(Reference<TwoBuffers> const& self,int const& index) 
															#line 677 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 677 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 677 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   index(index),
															#line 678 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   asyncFile()
															#line 3359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("readNextBlock", reinterpret_cast<unsigned long>(this));

	}
	~TwoBuffers_ReadNextBlockActorState() 
	{
		fdb_probe_actor_destroy("readNextBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 679 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->currentFileIndex >= self->files.size())
															#line 3374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 680 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevError, "ReadNextBlockOutOfBound") .detail("FileIndex", self->currentFileIndex) .detail("Tag", self->tag) .detail("Position", self->currentFilePosition) .detail("FileSize", self->files[self->currentFileIndex].fileSize) .detail("FilesCount", self->files.size()) .log();
															#line 687 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadNextBlockActorState(); static_cast<TwoBuffers_ReadNextBlockActor*>(this)->destroy(); return 0; }
															#line 3380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				new (&static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TwoBuffers_ReadNextBlockActorState();
				static_cast<TwoBuffers_ReadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 689 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = self->bc->readFile(self->files[self->currentFileIndex].fileName);
															#line 689 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 1;
															#line 689 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*>(static_cast<TwoBuffers_ReadNextBlockActor*>(this)));
															#line 3395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TwoBuffers_ReadNextBlockActorState();
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
															#line 690 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->currentFileIndex].fileSize;
															#line 692 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->currentFilePosition;
															#line 693 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 694 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>(self->buffers[index]->data.get()), bytesToRead, self->currentFilePosition);
															#line 694 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 694 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*>(static_cast<TwoBuffers_ReadNextBlockActor*>(this)));
															#line 3433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
															#line 690 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->currentFileIndex].fileSize;
															#line 692 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->currentFilePosition;
															#line 693 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 694 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>(self->buffers[index]->data.get()), bytesToRead, self->currentFilePosition);
															#line 694 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3452 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 694 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*>(static_cast<TwoBuffers_ReadNextBlockActor*>(this)));
															#line 3457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(asyncFileTmp, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(asyncFileTmp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 696 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (bytesRead != bytesToRead)
															#line 3541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 697 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 3545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 698 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->buffers[index]->index = self->currentFileIndex;
															#line 699 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->buffers[index]->size = bytesRead;
															#line 700 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->currentFilePosition += bytesRead;
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TwoBuffers_ReadNextBlockActorState(); static_cast<TwoBuffers_ReadNextBlockActor*>(this)->destroy(); return 0; }
															#line 3555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<TwoBuffers_ReadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TwoBuffers_ReadNextBlockActorState();
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int const& __bytesRead,int loopDepth) 
	{
															#line 694 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesRead = __bytesRead;
															#line 3567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && __bytesRead,int loopDepth) 
	{
		bytesRead = std::move(__bytesRead);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<TwoBuffers_ReadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<TwoBuffers_ReadNextBlockActor*>(this)->ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 677 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TwoBuffers> self;
															#line 677 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int index;
															#line 678 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> asyncFile;
															#line 691 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t fileSize;
															#line 693 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t bytesToRead;
															#line 694 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesRead;
															#line 3654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via readNextBlock()
															#line 677 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class TwoBuffers_ReadNextBlockActor final : public Actor<Void>, public ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >, public ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >, public FastAllocated<TwoBuffers_ReadNextBlockActor>, public TwoBuffers_ReadNextBlockActorState<TwoBuffers_ReadNextBlockActor> {
															#line 3659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<TwoBuffers_ReadNextBlockActor>::operator new;
	using FastAllocated<TwoBuffers_ReadNextBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15115538906052437760UL, 5654601977280840704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >;
															#line 677 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TwoBuffers_ReadNextBlockActor(Reference<TwoBuffers> const& self,int const& index) 
															#line 3677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   TwoBuffers_ReadNextBlockActorState<TwoBuffers_ReadNextBlockActor>(self, index),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readNextBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1542594355812348416UL, 14195273269523580672UL);
		ActorExecutionContextHelper __helper(static_cast<TwoBuffers_ReadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readNextBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readNextBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TwoBuffers_ReadNextBlockActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TwoBuffers_ReadNextBlockActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 677 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> TwoBuffers::readNextBlock( Reference<TwoBuffers> const& self, int const& index ) {
															#line 677 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new TwoBuffers_ReadNextBlockActor(self, index));
															#line 3710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 704 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

void TwoBuffers::fillBufferIfAbsent(int index) {
	if (buffers[index]->is_valid()) {
		// if this buffer is valid, then do not overwrite it
		return;
	}
	if (currentFileIndex == files.size()) {
		// quit if no more contents
		return;
	}
	auto self = Reference<TwoBuffers>::addRef(this);
	self->buffers[index]->fetchingData = readNextBlock(self, index);
	return;
}

bool endOfBlock(char* start, int offset) {
	const unsigned char paddingChar = '\xff';
	return (unsigned char)*(start + offset) == paddingChar;
}

class PartitionedLogIteratorSimple : public PartitionedLogIterator {
public:
	const int BATCH_READ_BLOCK_COUNT = 1;
	const int BLOCK_SIZE = CLIENT_KNOBS->BACKUP_LOGFILE_BLOCK_SIZE;
	const int mutationHeaderBytes = sizeof(int64_t) + sizeof(int32_t) + sizeof(int32_t);
	Reference<IBackupContainer> bc;
	size_t bufferCapacity;
	int tag;
	std::vector<RestoreConfig::RestoreFile> files;
	size_t bufferOffset; // Current read offset
	int bufferSize;
	int fileOffset;
	int fileIndex;
	std::shared_ptr<char[]> buffer;
	std::vector<Version> endVersions;

	PartitionedLogIteratorSimple(Reference<IBackupContainer> _bc,
	                             int _tag,
	                             std::vector<RestoreConfig::RestoreFile> _files,
	                             std::vector<Version> _endVersions);

	bool hasNext();
	Future<Void> loadNextBlock();
																#line 3757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
[[nodiscard]] static Future<Void> loadNextBlock( Reference<PartitionedLogIteratorSimple> const& self );
template <class> friend class PartitionedLogIteratorSimple_LoadNextBlockActorState;

#line 748 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	void removeBlockHeader();

	Standalone<VectorRef<VersionedMutation>> consumeData(Version firstVersion);

	// find the next version without advanding the iterator
	Future<Version> peekNextVersion();
																#line 3768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
[[nodiscard]] static Future<Version> peekNextVersion( Reference<PartitionedLogIteratorSimple> const& iterator );
template <class> friend class PartitionedLogIteratorSimple_PeekNextVersionActorState;

#line 755 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// get all the mutations of next version and advance the iterator
	// this might issue multiple consumeData() if the data of a version cross buffer boundary
	Future<Standalone<VectorRef<VersionedMutation>>> getNext();
																#line 3777 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<VersionedMutation>>> getNext( Reference<PartitionedLogIteratorSimple> const& iterator );
template <class> friend class PartitionedLogIteratorSimple_GetNextActorState;

#line 761 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
};

PartitionedLogIteratorSimple::PartitionedLogIteratorSimple(Reference<IBackupContainer> _bc,
                                                           int _tag,
                                                           std::vector<RestoreConfig::RestoreFile> _files,
                                                           std::vector<Version> _endVersions)
  : bc(_bc), tag(_tag), endVersions(_endVersions), files(std::move(_files)), bufferOffset(0) {
	bufferCapacity = BATCH_READ_BLOCK_COUNT * BLOCK_SIZE;
	buffer = std::shared_ptr<char[]>(new char[bufferCapacity]());
	fileOffset = 0;
	fileIndex = 0;
	bufferSize = 0;
}

// it will set fileOffset and fileIndex
bool PartitionedLogIteratorSimple::hasNext() {
	if (bufferOffset < bufferSize) {
		return true;
	}
	while (fileIndex < files.size() && fileOffset >= files[fileIndex].fileSize) {
		TraceEvent("ReachEndOfLogFiles")
		    .detail("BufferOffset", bufferOffset)
		    .detail("BufferSize", bufferSize)
		    .detail("FileOffset", fileOffset)
		    .detail("FileSize", files[fileIndex].fileSize)
		    .detail("FileName", files[fileIndex].fileName)
		    .detail("Tag", tag)
		    .detail("Index", fileIndex)
		    .log();
		fileOffset = 0;
		fileIndex++;
	}
	return fileIndex < files.size() && fileOffset < files[fileIndex].fileSize;
}

void PartitionedLogIteratorSimple::removeBlockHeader() {
	if (bufferOffset % BLOCK_SIZE == 0) {
		bufferOffset += sizeof(uint32_t);
	}
}

Standalone<VectorRef<VersionedMutation>> PartitionedLogIteratorSimple::consumeData(Version firstVersion) {
	Standalone<VectorRef<VersionedMutation>> mutations = Standalone<VectorRef<VersionedMutation>>();
	char* start = buffer.get();
	bool foundNewVersion = false;
	while (bufferOffset < bufferSize) {
		while (bufferOffset < bufferSize && !endOfBlock(start, bufferOffset)) {
			// for each block
			removeBlockHeader();

			// encoding format:
			// wr << bigEndian64(message.version.version) << bigEndian32(message.version.sub) <<
			// bigEndian32(mutation.size());
			Version version;
			std::memcpy(&version, start + bufferOffset, sizeof(Version));
			version = bigEndian64(version);
			if (version != firstVersion) {
				foundNewVersion = true;
				break; // Different version, stop here
			}

			int32_t subsequence;
			std::memcpy(&subsequence, start + bufferOffset + sizeof(Version), sizeof(int32_t));
			subsequence = bigEndian32(subsequence);

			int32_t mutationSize;
			std::memcpy(&mutationSize, start + bufferOffset + sizeof(Version) + sizeof(int32_t), sizeof(int32_t));
			mutationSize = bigEndian32(mutationSize);

			// assumption: the entire mutation is within the buffer
			size_t mutationTotalSize = mutationHeaderBytes + mutationSize;
			ASSERT(bufferOffset + mutationTotalSize <= bufferSize);

			// transform from stringref to mutationref here
			Standalone<StringRef> mutationData = makeString(mutationSize);
			std::memcpy(mutateString(mutationData), start + bufferOffset + mutationHeaderBytes, mutationSize);
			ArenaReader reader(mutationData.arena(), mutationData, AssumeVersion(g_network->protocolVersion()));
			MutationRef mutation;
			reader >> mutation;

			VersionedMutation vm;
			vm.version = version;
			vm.subsequence = subsequence;
			vm.mutation = mutation;
			mutations.push_back_deep(mutations.arena(), vm);
			// Move the bufferOffset to include this mutation
			bufferOffset += mutationTotalSize;
		}

		if (bufferOffset < bufferSize && endOfBlock(start, bufferOffset)) {
			// there are paddings
			int remain = BLOCK_SIZE - (bufferOffset % BLOCK_SIZE);
			bufferOffset += remain;
		}
		if (foundNewVersion) {
			break;
		}
	}

	return mutations;
}

Future<Void> PartitionedLogIteratorSimple::loadNextBlock() {
	return loadNextBlock(Reference<PartitionedLogIteratorSimple>::addRef(this));
}

															#line 3888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via loadNextBlock()
															#line 867 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorSimple_LoadNextBlockActor>
															#line 867 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_LoadNextBlockActorState {
															#line 3894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 867 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_LoadNextBlockActorState(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 867 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 867 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 3901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("loadNextBlock", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorSimple_LoadNextBlockActorState() 
	{
		fdb_probe_actor_destroy("loadNextBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 868 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->bufferOffset < self->bufferSize)
															#line 3916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 870 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PartitionedLogIteratorSimple_LoadNextBlockActorState(); static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->destroy(); return 0; }
															#line 3920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				new (&static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
				static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 3928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 873 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PartitionedLogIteratorSimple_LoadNextBlockActorState(); static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->destroy(); return 0; }
															#line 3932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				new (&static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
				static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 875 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			asyncFile = Reference<IAsyncFile>();
															#line 876 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = self->bc->readFile(self->files[self->fileIndex].fileName);
															#line 876 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 1;
															#line 876 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*>(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)));
															#line 3949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
															#line 877 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 878 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->fileIndex].fileSize;
															#line 879 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->fileOffset;
															#line 880 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 881 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>((self->buffer.get())), bytesToRead, self->fileOffset);
															#line 881 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 881 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*>(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)));
															#line 3987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
															#line 877 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		asyncFile = asyncFileTmp;
															#line 878 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileSize = self->files[self->fileIndex].fileSize;
															#line 879 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		size_t remaining = fileSize - self->fileOffset;
															#line 880 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesToRead = std::min(self->bufferCapacity, remaining);
															#line 881 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<int> __when_expr_1 = asyncFile->read(static_cast<void*>((self->buffer.get())), bytesToRead, self->fileOffset);
															#line 881 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 2;
															#line 881 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*>(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)));
															#line 4011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(asyncFileTmp, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && asyncFileTmp,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(asyncFileTmp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 883 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (bytesRead != bytesToRead)
															#line 4095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 884 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 4099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 885 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferSize = bytesRead;
															#line 886 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 887 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->fileOffset += bytesRead;
															#line 888 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PartitionedLogIteratorSimple_LoadNextBlockActorState(); static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->destroy(); return 0; }
															#line 4109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PartitionedLogIteratorSimple_LoadNextBlockActorState();
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int const& __bytesRead,int loopDepth) 
	{
															#line 881 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bytesRead = __bytesRead;
															#line 4121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && __bytesRead,int loopDepth) 
	{
		bytesRead = std::move(__bytesRead);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 867 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorSimple> self;
															#line 875 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> asyncFile;
															#line 878 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t fileSize;
															#line 880 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	size_t bytesToRead;
															#line 881 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesRead;
															#line 4206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via loadNextBlock()
															#line 867 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_LoadNextBlockActor final : public Actor<Void>, public ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >, public ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >, public FastAllocated<PartitionedLogIteratorSimple_LoadNextBlockActor>, public PartitionedLogIteratorSimple_LoadNextBlockActorState<PartitionedLogIteratorSimple_LoadNextBlockActor> {
															#line 4211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<PartitionedLogIteratorSimple_LoadNextBlockActor>::operator new;
	using FastAllocated<PartitionedLogIteratorSimple_LoadNextBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5368276622827784704UL, 15184711332510193152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >;
															#line 867 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_LoadNextBlockActor(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 4229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   PartitionedLogIteratorSimple_LoadNextBlockActorState<PartitionedLogIteratorSimple_LoadNextBlockActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadNextBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9541533795093038848UL, 7792905219334807296UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_LoadNextBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadNextBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadNextBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_LoadNextBlockActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 867 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> PartitionedLogIteratorSimple::loadNextBlock( Reference<PartitionedLogIteratorSimple> const& self ) {
															#line 867 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new PartitionedLogIteratorSimple_LoadNextBlockActor(self));
															#line 4262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 890 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

Future<Version> PartitionedLogIteratorSimple::peekNextVersion() {
	return peekNextVersion(Reference<PartitionedLogIteratorSimple>::addRef(this));
}

															#line 4271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via peekNextVersion()
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorSimple_PeekNextVersionActor>
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_PeekNextVersionActorState {
															#line 4277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_PeekNextVersionActorState(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 4284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorSimple_PeekNextVersionActorState() 
	{
		fdb_probe_actor_destroy("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 897 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 4299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 898 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(Version(0)); this->~PartitionedLogIteratorSimple_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 4303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				new (&static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(Version(0));
				this->~PartitionedLogIteratorSimple_PeekNextVersionActorState();
				static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 900 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->loadNextBlock();
															#line 900 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 1;
															#line 900 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*>(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)));
															#line 4318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorSimple_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 901 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 902 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = Version();
															#line 903 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 904 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 906 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 4349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 901 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 902 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = Version();
															#line 903 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 904 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 906 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 4366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 920 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~PartitionedLogIteratorSimple_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 4450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~PartitionedLogIteratorSimple_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 906 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(self->fileIndex < self->endVersions.size() - 1 && version >= self->endVersions[self->fileIndex]))
															#line 4469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("SimpleIteratorFindOverlapAndSkip") .detail("Version", version) .detail("FileIndex", self->fileIndex) .log();
															#line 911 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 912 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferSize = 0;
															#line 913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->fileOffset = 0;
															#line 914 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->fileIndex += 1;
															#line 915 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->loadNextBlock();
															#line 915 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 2;
															#line 915 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*>(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)));
															#line 4492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 916 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 917 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 918 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 4518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 916 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 917 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, self->buffer.get() + self->bufferOffset, sizeof(Version));
															#line 918 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 4531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorSimple> self;
															#line 902 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version version;
															#line 4615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via peekNextVersion()
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_PeekNextVersionActor final : public Actor<Version>, public ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >, public ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >, public FastAllocated<PartitionedLogIteratorSimple_PeekNextVersionActor>, public PartitionedLogIteratorSimple_PeekNextVersionActorState<PartitionedLogIteratorSimple_PeekNextVersionActor> {
															#line 4620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<PartitionedLogIteratorSimple_PeekNextVersionActor>::operator new;
	using FastAllocated<PartitionedLogIteratorSimple_PeekNextVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9812875994556151808UL, 13803557353212135168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >;
friend struct ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >;
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_PeekNextVersionActor(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 4638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Version>(),
		   PartitionedLogIteratorSimple_PeekNextVersionActorState<PartitionedLogIteratorSimple_PeekNextVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3510092154139981056UL, 14174065679173900288UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("peekNextVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_PeekNextVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Version> PartitionedLogIteratorSimple::peekNextVersion( Reference<PartitionedLogIteratorSimple> const& self ) {
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Version>(new PartitionedLogIteratorSimple_PeekNextVersionActor(self));
															#line 4671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 922 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 4676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via getNext()
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorSimple_GetNextActor>
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_GetNextActorState {
															#line 4682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_GetNextActorState(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 925 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   mutations()
															#line 4691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("getNext", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorSimple_GetNextActorState() 
	{
		fdb_probe_actor_destroy("getNext", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 926 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 4706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 927 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarn, "SimpleIteratorExhausted") .detail("BufferOffset", self->bufferOffset) .detail("BufferSize", self->bufferSize) .detail("Tag", self->tag) .log();
															#line 932 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorSimple_GetNextActorState(); static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->destroy(); return 0; }
															#line 4712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				new (&static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
				this->~PartitionedLogIteratorSimple_GetNextActorState();
				static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 934 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_0 = self->peekNextVersion();
															#line 934 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 1;
															#line 934 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*>(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)));
															#line 4727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorSimple_GetNextActorState();
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 935 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Standalone<VectorRef<VersionedMutation>> firstBatch = self->consumeData(firstVersion);
															#line 936 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		mutations = firstBatch;
															#line 940 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 4754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version const& __firstVersion,int loopDepth) 
	{
															#line 934 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		firstVersion = __firstVersion;
															#line 4763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __firstVersion,int loopDepth) 
	{
		firstVersion = std::move(__firstVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 955 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorSimple_GetNextActorState(); static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->destroy(); return 0; }
															#line 4842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorSimple_GetNextActorState();
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 940 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(self->bufferOffset >= self->bufferSize))
															#line 4861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 943 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->hasNext())
															#line 4867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 946 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->loadNextBlock();
															#line 946 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 2;
															#line 946 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*>(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)));
															#line 4878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 947 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Standalone<VectorRef<VersionedMutation>> batch = self->consumeData(firstVersion);
															#line 948 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 949 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 4915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 947 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Standalone<VectorRef<VersionedMutation>> batch = self->consumeData(firstVersion);
															#line 948 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 949 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 4929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorSimple> self;
															#line 925 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<VersionedMutation>> mutations;
															#line 934 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version firstVersion;
															#line 5016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via getNext()
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorSimple_GetNextActor final : public Actor<Standalone<VectorRef<VersionedMutation>>>, public ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >, public ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >, public FastAllocated<PartitionedLogIteratorSimple_GetNextActor>, public PartitionedLogIteratorSimple_GetNextActorState<PartitionedLogIteratorSimple_GetNextActor> {
															#line 5021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<PartitionedLogIteratorSimple_GetNextActor>::operator new;
	using FastAllocated<PartitionedLogIteratorSimple_GetNextActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17871811441875109120UL, 17891032668415749888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<VersionedMutation>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >;
friend struct ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >;
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorSimple_GetNextActor(Reference<PartitionedLogIteratorSimple> const& self) 
															#line 5039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Standalone<VectorRef<VersionedMutation>>>(),
		   PartitionedLogIteratorSimple_GetNextActorState<PartitionedLogIteratorSimple_GetNextActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17700238840770020608UL, 1654640055383343616UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorSimple_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNext");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorSimple_GetNextActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorSimple::getNext( Reference<PartitionedLogIteratorSimple> const& self ) {
															#line 923 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<VersionedMutation>>>(new PartitionedLogIteratorSimple_GetNextActor(self));
															#line 5072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 957 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorSimple::getNext() {
	return getNext(Reference<PartitionedLogIteratorSimple>::addRef(this));
}

class PartitionedLogIteratorTwoBuffers : public PartitionedLogIterator {
private:
	Reference<TwoBuffers> twobuffer;

	// consume single version data upto the end of the current batch
	// stop if seeing a different version from the parameter.
	// it has side effects to update bufferOffset after reading the data
	Future<Standalone<VectorRef<VersionedMutation>>> consumeData(Version firstVersion);
																#line 5089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<VersionedMutation>>> consumeData( Reference<PartitionedLogIteratorTwoBuffers> const& self, Version const& v );
template <class> friend class PartitionedLogIteratorTwoBuffers_ConsumeDataActorState;

#line 973 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// each block has a format of {<header>[mutations]<padding>}, need to skip the header to read mutations
	// this method check if bufferOffset is at the boundary and advance it if necessary
	void removeBlockHeader();

public:
	// read up to a fixed number of block count
	// noted that each version has to be contained within 2 blocks
	const int BATCH_READ_BLOCK_COUNT = 1;
	const int BLOCK_SIZE = CLIENT_KNOBS->BACKUP_LOGFILE_BLOCK_SIZE;
	const int mutationHeaderBytes = sizeof(int64_t) + sizeof(int32_t) + sizeof(int32_t);
	Reference<IBackupContainer> bc;
	int tag;
	std::vector<RestoreConfig::RestoreFile> files;
	std::vector<Version> endVersions;
	bool hasMoreData; // Flag indicating if more data is available
	size_t bufferOffset; // Current read offset
	// empty means no data, future is valid but not ready means being fetched
	// future is ready means it currently holds data

	PartitionedLogIteratorTwoBuffers(Reference<IBackupContainer> _bc,
	                                 int _tag,
	                                 std::vector<RestoreConfig::RestoreFile> _files,
	                                 std::vector<Version> _endVersions);

	// whether there are more contents for this tag in all files specified
	bool hasNext();

	// find the next version without advanding the iterator
	Future<Version> peekNextVersion();
																#line 5124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
[[nodiscard]] static Future<Version> peekNextVersion( Reference<PartitionedLogIteratorTwoBuffers> const& iterator );
template <class> friend class PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState;

#line 1004 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// get all the mutations of next version and advance the iterator
	// this might issue multiple consumeData() if the data of a version cross buffer boundary
	Future<Standalone<VectorRef<VersionedMutation>>> getNext();
																#line 5133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<VersionedMutation>>> getNext( Reference<PartitionedLogIteratorTwoBuffers> const& iterator );
template <class> friend class PartitionedLogIteratorTwoBuffers_GetNextActorState;

#line 1010 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
};

Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::consumeData(Version firstVersion) {
	return consumeData(Reference<PartitionedLogIteratorTwoBuffers>::addRef(this), firstVersion);
}

															#line 5144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via consumeData()
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorTwoBuffers_ConsumeDataActor>
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_ConsumeDataActorState {
															#line 5150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_ConsumeDataActorState(Reference<PartitionedLogIteratorTwoBuffers> const& self,Version const& firstVersion) 
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   firstVersion(firstVersion),
															#line 1019 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   mutations(Standalone<VectorRef<VersionedMutation>>())
															#line 5161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("consumeData", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState() 
	{
		fdb_probe_actor_destroy("consumeData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1020 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->twobuffer->ready();
															#line 1020 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state = 1;
															#line 1020 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*>(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)));
															#line 5183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1021 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::shared_ptr<char[]> start = self->twobuffer->peek();
															#line 1022 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int size = self->twobuffer->getBufferSize();
															#line 1023 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool foundNewVersion = false;
															#line 1024 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for(;self->bufferOffset < size;) {
															#line 1025 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			for(;self->bufferOffset < size && !endOfBlock(start.get(), self->bufferOffset);) {
															#line 1027 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->removeBlockHeader();
															#line 1032 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Version version;
															#line 1033 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1034 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				version = bigEndian64(version);
															#line 1035 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (version != firstVersion)
															#line 5224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				{
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					foundNewVersion = true;
															#line 5228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
					break;
				}
															#line 1040 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t subsequence;
															#line 1041 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&subsequence, start.get() + self->bufferOffset + sizeof(Version), sizeof(int32_t));
															#line 1042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				subsequence = bigEndian32(subsequence);
															#line 1044 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t mutationSize;
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( &mutationSize, start.get() + self->bufferOffset + sizeof(Version) + sizeof(int32_t), sizeof(int32_t));
															#line 1047 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutationSize = bigEndian32(mutationSize);
															#line 1050 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				size_t mutationTotalSize = self->mutationHeaderBytes + mutationSize;
															#line 1051 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ASSERT(self->bufferOffset + mutationTotalSize <= size);
															#line 1053 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Standalone<StringRef> mutationData = makeString(mutationSize);
															#line 1054 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( mutateString(mutationData), start.get() + self->bufferOffset + self->mutationHeaderBytes, mutationSize);
															#line 1057 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ArenaReader reader(mutationData.arena(), mutationData, AssumeVersion(g_network->protocolVersion()));
															#line 1058 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				MutationRef mutation;
															#line 1059 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				reader >> mutation;
															#line 1061 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				VersionedMutation vm;
															#line 1062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.version = version;
															#line 1063 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.subsequence = subsequence;
															#line 1064 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.mutation = mutation;
															#line 1065 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutations.push_back_deep(mutations.arena(), vm);
															#line 1067 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += mutationTotalSize;
															#line 5269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			}
															#line 1070 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->bufferOffset < size && endOfBlock(start.get(), self->bufferOffset))
															#line 5273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1072 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int remain = self->BLOCK_SIZE - (self->bufferOffset % self->BLOCK_SIZE);
															#line 1073 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += remain;
															#line 5279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			}
															#line 1075 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (foundNewVersion)
															#line 5283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
				break;
			}
		}
															#line 1079 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState(); static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->destroy(); return 0; }
															#line 5290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1021 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::shared_ptr<char[]> start = self->twobuffer->peek();
															#line 1022 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int size = self->twobuffer->getBufferSize();
															#line 1023 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		bool foundNewVersion = false;
															#line 1024 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for(;self->bufferOffset < size;) {
															#line 1025 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			for(;self->bufferOffset < size && !endOfBlock(start.get(), self->bufferOffset);) {
															#line 1027 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->removeBlockHeader();
															#line 1032 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Version version;
															#line 1033 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1034 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				version = bigEndian64(version);
															#line 1035 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (version != firstVersion)
															#line 5320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				{
															#line 1036 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					foundNewVersion = true;
															#line 5324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
					break;
				}
															#line 1040 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t subsequence;
															#line 1041 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy(&subsequence, start.get() + self->bufferOffset + sizeof(Version), sizeof(int32_t));
															#line 1042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				subsequence = bigEndian32(subsequence);
															#line 1044 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int32_t mutationSize;
															#line 1045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( &mutationSize, start.get() + self->bufferOffset + sizeof(Version) + sizeof(int32_t), sizeof(int32_t));
															#line 1047 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutationSize = bigEndian32(mutationSize);
															#line 1050 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				size_t mutationTotalSize = self->mutationHeaderBytes + mutationSize;
															#line 1051 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ASSERT(self->bufferOffset + mutationTotalSize <= size);
															#line 1053 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				Standalone<StringRef> mutationData = makeString(mutationSize);
															#line 1054 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				std::memcpy( mutateString(mutationData), start.get() + self->bufferOffset + self->mutationHeaderBytes, mutationSize);
															#line 1057 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ArenaReader reader(mutationData.arena(), mutationData, AssumeVersion(g_network->protocolVersion()));
															#line 1058 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				MutationRef mutation;
															#line 1059 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				reader >> mutation;
															#line 1061 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				VersionedMutation vm;
															#line 1062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.version = version;
															#line 1063 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.subsequence = subsequence;
															#line 1064 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				vm.mutation = mutation;
															#line 1065 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				mutations.push_back_deep(mutations.arena(), vm);
															#line 1067 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += mutationTotalSize;
															#line 5365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			}
															#line 1070 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->bufferOffset < size && endOfBlock(start.get(), self->bufferOffset))
															#line 5369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1072 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int remain = self->BLOCK_SIZE - (self->bufferOffset % self->BLOCK_SIZE);
															#line 1073 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				self->bufferOffset += remain;
															#line 5375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			}
															#line 1075 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (foundNewVersion)
															#line 5379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
				break;
			}
		}
															#line 1079 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState(); static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->destroy(); return 0; }
															#line 5386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_ConsumeDataActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorTwoBuffers> self;
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version firstVersion;
															#line 1019 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<VersionedMutation>> mutations;
															#line 5475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via consumeData()
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_ConsumeDataActor final : public Actor<Standalone<VectorRef<VersionedMutation>>>, public ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >, public FastAllocated<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>, public PartitionedLogIteratorTwoBuffers_ConsumeDataActorState<PartitionedLogIteratorTwoBuffers_ConsumeDataActor> {
															#line 5480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>::operator new;
	using FastAllocated<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13202813324244315392UL, 5242898864605605888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<VersionedMutation>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >;
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_ConsumeDataActor(Reference<PartitionedLogIteratorTwoBuffers> const& self,Version const& firstVersion) 
															#line 5497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Standalone<VectorRef<VersionedMutation>>>(),
		   PartitionedLogIteratorTwoBuffers_ConsumeDataActorState<PartitionedLogIteratorTwoBuffers_ConsumeDataActor>(self, firstVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consumeData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6208903078462509824UL, 13390363306797634560UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_ConsumeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consumeData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consumeData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_ConsumeDataActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::consumeData( Reference<PartitionedLogIteratorTwoBuffers> const& self, Version const& firstVersion ) {
															#line 1016 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<VersionedMutation>>>(new PartitionedLogIteratorTwoBuffers_ConsumeDataActor(self, firstVersion));
															#line 5529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1081 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

void PartitionedLogIteratorTwoBuffers::removeBlockHeader() {
	if (bufferOffset % BLOCK_SIZE == 0) {
		bufferOffset += sizeof(uint32_t);
	}
}

PartitionedLogIteratorTwoBuffers::PartitionedLogIteratorTwoBuffers(Reference<IBackupContainer> _bc,
                                                                   int _tag,
                                                                   std::vector<RestoreConfig::RestoreFile> _files,
                                                                   std::vector<Version> _endVersions)
  : bc(_bc), tag(_tag), files(std::move(_files)), endVersions(_endVersions), bufferOffset(0) {
	int bufferCapacity = BATCH_READ_BLOCK_COUNT * BLOCK_SIZE;
	twobuffer = makeReference<TwoBuffers>(bufferCapacity, _bc, files, tag);
}

bool PartitionedLogIteratorTwoBuffers::hasNext() {
	return twobuffer->hasNext();
}

Future<Version> PartitionedLogIteratorTwoBuffers::peekNextVersion() {
	return peekNextVersion(Reference<PartitionedLogIteratorTwoBuffers>::addRef(this));
}
															#line 5556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via peekNextVersion()
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState {
															#line 5562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1107 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   start(),
															#line 1108 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(),
															#line 1109 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   fileIndex()
															#line 5575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState() 
	{
		fdb_probe_actor_destroy("peekNextVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1110 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 5590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1111 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(Version(0)); this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 5594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				new (&static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(Version(0));
				this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState();
				static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1113 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->twobuffer->ready();
															#line 1113 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 1;
															#line 1113 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*>(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)));
															#line 5609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1114 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1115 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1116 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1117 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1118 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 1119 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 5642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1114 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1115 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1116 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1117 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1118 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 1119 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 5661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1135 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState(); static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->destroy(); return 0; }
															#line 5745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->SAV< Version >::value()) Version(std::move(version)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1119 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(fileIndex < self->endVersions.size() - 1 && version >= self->endVersions[fileIndex]))
															#line 5764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1120 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("RestoreLogFilesFoundOverlapAndSkip") .detail("Version", version) .detail("FileIndex", fileIndex) .log();
															#line 1125 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->twobuffer->reset();
															#line 1126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 1127 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->twobuffer->setFileIndex(fileIndex + 1);
															#line 1128 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->twobuffer->ready();
															#line 1128 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 2;
															#line 1128 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*>(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)));
															#line 5785 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1130 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1131 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1132 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1133 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 5815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		start = self->twobuffer->peek();
															#line 1130 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->removeBlockHeader();
															#line 1131 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(&version, start.get() + self->bufferOffset, sizeof(Version));
															#line 1132 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		version = bigEndian64(version);
															#line 1133 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		fileIndex = self->twobuffer->getFileIndex();
															#line 5832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorTwoBuffers> self;
															#line 1107 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::shared_ptr<char[]> start;
															#line 1108 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version version;
															#line 1109 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int fileIndex;
															#line 5920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via peekNextVersion()
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_PeekNextVersionActor final : public Actor<Version>, public ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >, public ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >, public FastAllocated<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>, public PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor> {
															#line 5925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>::operator new;
	using FastAllocated<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9812875994556151808UL, 13803557353212135168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >;
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_PeekNextVersionActor(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 5943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Version>(),
		   PartitionedLogIteratorTwoBuffers_PeekNextVersionActorState<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(868233047335415808UL, 8756626667062018304UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_PeekNextVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("peekNextVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("peekNextVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_PeekNextVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Version> PartitionedLogIteratorTwoBuffers::peekNextVersion( Reference<PartitionedLogIteratorTwoBuffers> const& self ) {
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Version>(new PartitionedLogIteratorTwoBuffers_PeekNextVersionActor(self));
															#line 5976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1137 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 5981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via getNext()
															#line 1138 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class PartitionedLogIteratorTwoBuffers_GetNextActor>
															#line 1138 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_GetNextActorState {
															#line 5987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1138 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_GetNextActorState(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 1138 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1138 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1140 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   mutations()
															#line 5996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("getNext", reinterpret_cast<unsigned long>(this));

	}
	~PartitionedLogIteratorTwoBuffers_GetNextActorState() 
	{
		fdb_probe_actor_destroy("getNext", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1141 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->hasNext())
															#line 6011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1142 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarn, "IteratorExhausted").log();
															#line 1143 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_GetNextActorState(); static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->destroy(); return 0; }
															#line 6017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				new (&static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
				this->~PartitionedLogIteratorTwoBuffers_GetNextActorState();
				static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1145 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_0 = self->peekNextVersion();
															#line 1145 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 1;
															#line 1145 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 6032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PartitionedLogIteratorTwoBuffers_GetNextActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1147 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedMutation>>> __when_expr_1 = self->consumeData(firstVersion);
															#line 1147 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 2;
															#line 1147 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 6062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Version const& __firstVersion,int loopDepth) 
	{
															#line 1145 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		firstVersion = __firstVersion;
															#line 6071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __firstVersion,int loopDepth) 
	{
		firstVersion = std::move(__firstVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Standalone<VectorRef<VersionedMutation>> const& firstBatch,int loopDepth) 
	{
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		mutations = firstBatch;
															#line 1151 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 6152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Standalone<VectorRef<VersionedMutation>> && firstBatch,int loopDepth) 
	{
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		mutations = firstBatch;
															#line 1151 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 6163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<VersionedMutation>> const& firstBatch,int loopDepth) 
	{
		loopDepth = a_body1cont3(firstBatch, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<VersionedMutation>> && firstBatch,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(firstBatch), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1171 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV<Standalone<VectorRef<VersionedMutation>>>::futures) { (void)(mutations); this->~PartitionedLogIteratorTwoBuffers_GetNextActorState(); static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->destroy(); return 0; }
															#line 6247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->SAV< Standalone<VectorRef<VersionedMutation>> >::value()) Standalone<VectorRef<VersionedMutation>>(std::move(mutations)); // state_var_RVO
		this->~PartitionedLogIteratorTwoBuffers_GetNextActorState();
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 1151 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!(self->bufferOffset >= self->twobuffer->getBufferSize()))
															#line 6266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1152 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->twobuffer->discardAndSwap();
															#line 1153 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->bufferOffset = 0;
															#line 1156 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->twobuffer->hasNext())
															#line 6276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1159 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_2 = self->peekNextVersion();
															#line 1159 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 3;
															#line 1159 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 6287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Version const& nextVersion,int loopDepth) 
	{
															#line 1160 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (nextVersion != firstVersion)
															#line 6320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1163 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedMutation>>> __when_expr_3 = self->consumeData(firstVersion);
															#line 1163 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 4;
															#line 1163 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 6333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3(Version && nextVersion,int loopDepth) 
	{
															#line 1160 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (nextVersion != firstVersion)
															#line 6342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1163 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<VersionedMutation>>> __when_expr_3 = self->consumeData(firstVersion);
															#line 1163 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 4;
															#line 1163 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*>(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)));
															#line 6355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Version const& nextVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(nextVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Version && nextVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont3(std::move(nextVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3loopBody1cont4(Standalone<VectorRef<VersionedMutation>> const& batch,int loopDepth) 
	{
															#line 1164 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 1165 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 6441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont4(Standalone<VectorRef<VersionedMutation>> && batch,int loopDepth) 
	{
															#line 1164 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( const VersionedMutation& vm : batch ) {
															#line 1165 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			mutations.push_back_deep(mutations.arena(), vm);
															#line 6453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		loopDepth = a_body1cont3loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(Standalone<VectorRef<VersionedMutation>> const& batch,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont4(batch, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont3when1(Standalone<VectorRef<VersionedMutation>> && batch,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont4(std::move(batch), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state > 0) static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->actor_wait_state = 0;
		static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >::remove();

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> const& value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*,Standalone<VectorRef<VersionedMutation>> && value) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*,Error err) 
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1138 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<PartitionedLogIteratorTwoBuffers> self;
															#line 1140 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<VersionedMutation>> mutations;
															#line 1145 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version firstVersion;
															#line 6540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via getNext()
															#line 1138 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class PartitionedLogIteratorTwoBuffers_GetNextActor final : public Actor<Standalone<VectorRef<VersionedMutation>>>, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >, public ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >, public FastAllocated<PartitionedLogIteratorTwoBuffers_GetNextActor>, public PartitionedLogIteratorTwoBuffers_GetNextActorState<PartitionedLogIteratorTwoBuffers_GetNextActor> {
															#line 6545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<PartitionedLogIteratorTwoBuffers_GetNextActor>::operator new;
	using FastAllocated<PartitionedLogIteratorTwoBuffers_GetNextActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17871811441875109120UL, 17891032668415749888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<VersionedMutation>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >;
friend struct ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >;
															#line 1138 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	PartitionedLogIteratorTwoBuffers_GetNextActor(Reference<PartitionedLogIteratorTwoBuffers> const& self) 
															#line 6565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Standalone<VectorRef<VersionedMutation>>>(),
		   PartitionedLogIteratorTwoBuffers_GetNextActorState<PartitionedLogIteratorTwoBuffers_GetNextActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNext", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10518556646101966592UL, 11765083271327665664UL);
		ActorExecutionContextHelper __helper(static_cast<PartitionedLogIteratorTwoBuffers_GetNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNext");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNext", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 1, Standalone<VectorRef<VersionedMutation>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PartitionedLogIteratorTwoBuffers_GetNextActor, 3, Standalone<VectorRef<VersionedMutation>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1138 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::getNext( Reference<PartitionedLogIteratorTwoBuffers> const& self ) {
															#line 1138 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<VersionedMutation>>>(new PartitionedLogIteratorTwoBuffers_GetNextActor(self));
															#line 6600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1173 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

Future<Standalone<VectorRef<VersionedMutation>>> PartitionedLogIteratorTwoBuffers::getNext() {
	return getNext(Reference<PartitionedLogIteratorTwoBuffers>::addRef(this));
}

FileBackupAgent::FileBackupAgent()
  : subspace(Subspace(fileBackupPrefixRange.begin))
    // The other subspaces have logUID -> value
    ,
    config(subspace.get(BackupAgentBase::keyConfig)), lastRestorable(subspace.get(FileBackupAgent::keyLastRestorable)),
    taskBucket(new TaskBucket(subspace.get(BackupAgentBase::keyTasks),
                              AccessSystemKeys::True,
                              PriorityBatch::False,
                              LockAware::True)),
    futureBucket(new FutureBucket(subspace.get(BackupAgentBase::keyFutures), AccessSystemKeys::True, LockAware::True)) {
}

namespace fileBackup {

// Return a block of contiguous padding bytes, growing if needed.
Value makePadding(int size) {
	static Value pad;
	if (pad.size() < size) {
		pad = makeString(size);
		memset(mutateString(pad), '\xff', pad.size());
	}

	return pad.substr(0, size);
}

struct IRangeFileWriter {
public:
	virtual Future<Void> padEnd(bool final) = 0;

	virtual Future<Void> writeKV(Key k, Value v) = 0;

	virtual Future<Void> writeKey(Key k) = 0;

	virtual Future<Void> finish() = 0;

	virtual ~IRangeFileWriter() {}
};

struct SnapshotFileBackupEncryptionKeys {
	Reference<BlobCipherKey> textCipherKey;
	Optional<Reference<BlobCipherKey>> headerCipherKey;
	StringRef ivRef;
};

// File Format handlers.
// Both Range and Log formats are designed to be readable starting at any BACKUP_RANGEFILE_BLOCK_SIZE boundary
// so they can be read in parallel.
//
// Writer instances must be kept alive while any member actors are in progress.
//
// EncryptedRangeFileWriter must be used as follows:
//   1 - writeKey(key) the queried key range begin
//   2 - writeKV(k, v) each kv pair to restore
//   3 - writeKey(key) the queried key range end
//   4 - finish()
//
// EncryptedRangeFileWriter will insert the required padding, header, and extra
// end/begin keys around the 1MB boundaries as needed.
//
// Example:
//   The range a-z is queries and returns c-j which covers 3 blocks across 2 tenants.
//   The client code writes keys in this sequence:
//             t1a t1c t1d t1e t1f t1g t2h t2i t2j t2z
//
//   H = header   P = padding   a...z = keys  v = value | = block boundary
//
//   Encoded file:  H t1a t1cv t1dv t1ev P | H t1e t1ev t1fv t1gv t2 P | H t2 t2hv t2iv t2jv t2z
//   Decoded in blocks yields:
//           Block 1: range [t1a, t1e) with kv pairs t1cv, t1dv
//           Block 2: range [t1e, t2) with kv pairs t1ev, t1fv, t1gv
//           Block 3: range [t2, t2z) with kv pairs t2hv, t2iv, t2jv
//
//   NOTE: All blocks except for the final block will have one last
//   value which will not be used.  This isn't actually a waste since
//   if the next KV pair wouldn't fit within the block after the value
//   then the space after the final key to the next 1MB boundary would
//   just be padding anyway.
//
//   NOTE: For the EncryptedRangeFileWriter blocks will be split either on the BACKUP_RANGEFILE_BLOCK_SIZE boundary or
//   when a new tenant id is encountered. If a block is split for crossing tenant boundaries then the last key will be
//   truncated to just the tenant prefix and the value will be empty (to avoid having sensitive data of one tenant be
//   encrypted with a key for a different tenant)
struct EncryptedRangeFileWriter : public IRangeFileWriter {
	EncryptedRangeFileWriter(Database cx,
	                         Arena* arena,
	                         EncryptionAtRestMode encryptMode,
	                         Optional<Reference<TenantEntryCache<Void>>> tenantCache,
	                         Reference<IBackupFile> file = Reference<IBackupFile>(),
	                         int blockSize = 0)
	  : cx(cx), arena(arena), file(file), encryptMode(encryptMode), tenantCache(tenantCache), blockSize(blockSize),
	    blockEnd(0), fileVersion(BACKUP_AGENT_ENCRYPTED_SNAPSHOT_FILE_VERSION) {
		buffer = makeString(blockSize);
		wPtr = mutateString(buffer);
	}

																#line 6704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via decryptImpl()
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class DecryptImplActor>
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecryptImplActorState {
															#line 6710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecryptImplActorState(Database const& cx,BlobCipherEncryptHeaderRef const& header,const uint8_t* const& dataP,int64_t const& dataLen,Arena* const& arena) 
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : cx(cx),
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   header(header),
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   dataP(dataP),
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   dataLen(dataLen),
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   arena(arena)
															#line 6725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("decryptImpl", reinterpret_cast<unsigned long>(this));

	}
	~DecryptImplActorState() 
	{
		fdb_probe_actor_destroy("decryptImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1278 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			Reference<AsyncVar<ClientDBInfo> const> dbInfo = cx->clientInfo;
															#line 1279 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			headerRef = header;
															#line 1280 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<TextAndHeaderCipherKeys> __when_expr_0 = GetEncryptCipherKeys<ClientDBInfo>::getEncryptCipherKeys(dbInfo, headerRef, BlobCipherMetrics::RESTORE);
															#line 1280 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<DecryptImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DecryptImplActor*>(this)->actor_wait_state = 1;
															#line 1280 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >*>(static_cast<DecryptImplActor*>(this)));
															#line 6751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DecryptImplActorState();
		static_cast<DecryptImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
															#line 1282 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		EncryptHeaderCipherDetails cipherDetails = headerRef.getCipherDetails();
															#line 1283 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		cipherDetails.textCipherDetails.validateCipherDetailsWithCipherKey(cipherKeys.cipherTextKey);
															#line 1284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (cipherDetails.headerCipherDetails.present())
															#line 6778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1285 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			cipherDetails.headerCipherDetails.get().validateCipherDetailsWithCipherKey(cipherKeys.cipherHeaderKey);
															#line 6782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 1287 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		DecryptBlobCipherAes256Ctr decryptor( cipherKeys.cipherTextKey, cipherKeys.cipherHeaderKey, headerRef.getIV(), BlobCipherMetrics::RESTORE);
															#line 1289 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<DecryptImplActor*>(this)->SAV<StringRef>::futures) { (void)(decryptor.decrypt(dataP, dataLen, headerRef, *arena)); this->~DecryptImplActorState(); static_cast<DecryptImplActor*>(this)->destroy(); return 0; }
															#line 6788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<DecryptImplActor*>(this)->SAV< StringRef >::value()) StringRef(decryptor.decrypt(dataP, dataLen, headerRef, *arena));
		this->~DecryptImplActorState();
		static_cast<DecryptImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
															#line 1282 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		EncryptHeaderCipherDetails cipherDetails = headerRef.getCipherDetails();
															#line 1283 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		cipherDetails.textCipherDetails.validateCipherDetailsWithCipherKey(cipherKeys.cipherTextKey);
															#line 1284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (cipherDetails.headerCipherDetails.present())
															#line 6804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1285 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			cipherDetails.headerCipherDetails.get().validateCipherDetailsWithCipherKey(cipherKeys.cipherHeaderKey);
															#line 6808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 1287 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		DecryptBlobCipherAes256Ctr decryptor( cipherKeys.cipherTextKey, cipherKeys.cipherHeaderKey, headerRef.getIV(), BlobCipherMetrics::RESTORE);
															#line 1289 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<DecryptImplActor*>(this)->SAV<StringRef>::futures) { (void)(decryptor.decrypt(dataP, dataLen, headerRef, *arena)); this->~DecryptImplActorState(); static_cast<DecryptImplActor*>(this)->destroy(); return 0; }
															#line 6814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<DecryptImplActor*>(this)->SAV< StringRef >::value()) StringRef(decryptor.decrypt(dataP, dataLen, headerRef, *arena));
		this->~DecryptImplActorState();
		static_cast<DecryptImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(cipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DecryptImplActor*>(this)->actor_wait_state > 0) static_cast<DecryptImplActor*>(this)->actor_wait_state = 0;
		static_cast<DecryptImplActor*>(this)->ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >::remove();

	}
	void a_callback_fire(ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys const& value) 
	{
		fdb_probe_actor_enter("decryptImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecryptImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decryptImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys && value) 
	{
		fdb_probe_actor_enter("decryptImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecryptImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decryptImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >*,Error err) 
	{
		fdb_probe_actor_enter("decryptImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecryptImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decryptImpl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BlobCipherEncryptHeaderRef header;
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	const uint8_t* dataP;
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t dataLen;
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Arena* arena;
															#line 1279 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BlobCipherEncryptHeaderRef headerRef;
															#line 6909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via decryptImpl()
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecryptImplActor final : public Actor<StringRef>, public ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >, public FastAllocated<DecryptImplActor>, public DecryptImplActorState<DecryptImplActor> {
															#line 6914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<DecryptImplActor>::operator new;
	using FastAllocated<DecryptImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5850092322112574208UL, 2955275695472099328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<StringRef>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >;
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecryptImplActor(Database const& cx,BlobCipherEncryptHeaderRef const& header,const uint8_t* const& dataP,int64_t const& dataLen,Arena* const& arena) 
															#line 6931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<StringRef>(),
		   DecryptImplActorState<DecryptImplActor>(cx, header, dataP, dataLen, arena),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("decryptImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4960209422272274432UL, 16507631506561169664UL);
		ActorExecutionContextHelper __helper(static_cast<DecryptImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("decryptImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("decryptImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DecryptImplActor, 0, TextAndHeaderCipherKeys >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<StringRef> decryptImpl( Database const& cx, BlobCipherEncryptHeaderRef const& header, const uint8_t* const& dataP, int64_t const& dataLen, Arena* const& arena ) {
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<StringRef>(new DecryptImplActor(cx, header, dataP, dataLen, arena));
															#line 6963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1291 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	static Future<StringRef> decrypt(Database cx,
	                                 BlobCipherEncryptHeaderRef header,
	                                 const uint8_t* dataP,
	                                 int64_t dataLen,
	                                 Arena* arena) {
		return decryptImpl(cx, header, dataP, dataLen, arena);
	}

																#line 6976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via refreshKey()
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class RefreshKeyActor>
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RefreshKeyActorState {
															#line 6982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RefreshKeyActorState(EncryptedRangeFileWriter* const& self,EncryptCipherDomainId const& domainId) 
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   domainId(domainId)
															#line 6991 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("refreshKey", reinterpret_cast<unsigned long>(this));

	}
	~RefreshKeyActorState() 
	{
		fdb_probe_actor_destroy("refreshKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1302 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			Reference<AsyncVar<ClientDBInfo> const> dbInfo = self->cx->clientInfo;
															#line 1303 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<TextAndHeaderCipherKeys> __when_expr_0 = GetEncryptCipherKeys<ClientDBInfo>::getLatestEncryptCipherKeysForDomain( dbInfo, domainId, BlobCipherMetrics::BACKUP);
															#line 1303 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<RefreshKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RefreshKeyActor*>(this)->actor_wait_state = 1;
															#line 1303 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >*>(static_cast<RefreshKeyActor*>(this)));
															#line 7015 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RefreshKeyActorState();
		static_cast<RefreshKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
															#line 1306 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RefreshKeyActor*>(this)->SAV<Reference<BlobCipherKey>>::futures) { (void)(cipherKeys.cipherTextKey); this->~RefreshKeyActorState(); static_cast<RefreshKeyActor*>(this)->destroy(); return 0; }
															#line 7038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<RefreshKeyActor*>(this)->SAV< Reference<BlobCipherKey> >::value()) Reference<BlobCipherKey>(cipherKeys.cipherTextKey);
		this->~RefreshKeyActorState();
		static_cast<RefreshKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
															#line 1306 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<RefreshKeyActor*>(this)->SAV<Reference<BlobCipherKey>>::futures) { (void)(cipherKeys.cipherTextKey); this->~RefreshKeyActorState(); static_cast<RefreshKeyActor*>(this)->destroy(); return 0; }
															#line 7050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<RefreshKeyActor*>(this)->SAV< Reference<BlobCipherKey> >::value()) Reference<BlobCipherKey>(cipherKeys.cipherTextKey);
		this->~RefreshKeyActorState();
		static_cast<RefreshKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(cipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(cipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RefreshKeyActor*>(this)->actor_wait_state > 0) static_cast<RefreshKeyActor*>(this)->actor_wait_state = 0;
		static_cast<RefreshKeyActor*>(this)->ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >::remove();

	}
	void a_callback_fire(ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys const& value) 
	{
		fdb_probe_actor_enter("refreshKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys && value) 
	{
		fdb_probe_actor_enter("refreshKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >*,Error err) 
	{
		fdb_probe_actor_enter("refreshKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("refreshKey", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptCipherDomainId domainId;
															#line 7137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via refreshKey()
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class RefreshKeyActor final : public Actor<Reference<BlobCipherKey>>, public ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >, public FastAllocated<RefreshKeyActor>, public RefreshKeyActorState<RefreshKeyActor> {
															#line 7142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<RefreshKeyActor>::operator new;
	using FastAllocated<RefreshKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11547663432401662720UL, 7006796426255594240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<BlobCipherKey>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >;
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RefreshKeyActor(EncryptedRangeFileWriter* const& self,EncryptCipherDomainId const& domainId) 
															#line 7159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Reference<BlobCipherKey>>(),
		   RefreshKeyActorState<RefreshKeyActor>(self, domainId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("refreshKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2600401531761827840UL, 1234727541164897536UL);
		ActorExecutionContextHelper __helper(static_cast<RefreshKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("refreshKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("refreshKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RefreshKeyActor, 0, TextAndHeaderCipherKeys >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Reference<BlobCipherKey>> refreshKey( EncryptedRangeFileWriter* const& self, EncryptCipherDomainId const& domainId ) {
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Reference<BlobCipherKey>>(new RefreshKeyActor(self, domainId));
															#line 7191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1308 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 7196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via encrypt()
															#line 1309 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class EncryptActor>
															#line 1309 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class EncryptActorState {
															#line 7202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1309 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptActorState(EncryptedRangeFileWriter* const& self) 
															#line 1309 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1309 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 7209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("encrypt", reinterpret_cast<unsigned long>(this));

	}
	~EncryptActorState() 
	{
		fdb_probe_actor_destroy("encrypt", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1311 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(self->cipherKeys.headerCipherKey.present() && self->cipherKeys.headerCipherKey.get().isValid() && self->cipherKeys.textCipherKey.isValid());
															#line 1314 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->cipherKeys.headerCipherKey.get()->isExpired() || self->cipherKeys.headerCipherKey.get()->needsRefresh())
															#line 7226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1316 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Reference<BlobCipherKey>> __when_expr_0 = refreshKey(self, self->cipherKeys.headerCipherKey.get()->getDomainId());
															#line 1316 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<EncryptActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<EncryptActor*>(this)->actor_wait_state = 1;
															#line 1316 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >*>(static_cast<EncryptActor*>(this)));
															#line 7237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EncryptActorState();
		static_cast<EncryptActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1320 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->cipherKeys.textCipherKey->isExpired() || self->cipherKeys.textCipherKey->needsRefresh())
															#line 7265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1321 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Reference<BlobCipherKey>> __when_expr_1 = refreshKey(self, self->cipherKeys.textCipherKey->getDomainId());
															#line 1321 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<EncryptActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<EncryptActor*>(this)->actor_wait_state = 2;
															#line 1321 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >*>(static_cast<EncryptActor*>(this)));
															#line 7276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Reference<BlobCipherKey> const& cipherKey,int loopDepth) 
	{
															#line 1318 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.headerCipherKey = cipherKey;
															#line 7290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Reference<BlobCipherKey> && cipherKey,int loopDepth) 
	{
															#line 1318 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.headerCipherKey = cipherKey;
															#line 7299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<BlobCipherKey> const& cipherKey,int loopDepth) 
	{
		loopDepth = a_body1cont2(cipherKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<BlobCipherKey> && cipherKey,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(cipherKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EncryptActor*>(this)->actor_wait_state > 0) static_cast<EncryptActor*>(this)->actor_wait_state = 0;
		static_cast<EncryptActor*>(this)->ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >::remove();

	}
	void a_callback_fire(ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >*,Reference<BlobCipherKey> const& value) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >*,Reference<BlobCipherKey> && value) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >*,Error err) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1324 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		EncryptBlobCipherAes265Ctr encryptor( self->cipherKeys.textCipherKey, self->cipherKeys.headerCipherKey, self->cipherKeys.ivRef.begin(), AES_256_IV_LENGTH, getEncryptAuthTokenMode(EncryptAuthTokenMode::ENCRYPT_HEADER_AUTH_TOKEN_MODE_SINGLE), BlobCipherMetrics::BACKUP);
															#line 1331 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int64_t payloadSize = self->wPtr - self->dataPayloadStart;
															#line 1332 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StringRef encryptedData;
															#line 1333 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		BlobCipherEncryptHeaderRef headerRef;
															#line 1334 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		encryptedData = encryptor.encrypt(self->dataPayloadStart, payloadSize, &headerRef, *self->arena);
															#line 1335 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Standalone<StringRef> serialized = BlobCipherEncryptHeaderRef::toStringRef(headerRef);
															#line 1336 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->arena->dependsOn(serialized.arena());
															#line 1337 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(serialized.size() == self->encryptHeader.size());
															#line 1338 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(mutateString(self->encryptHeader), serialized.begin(), self->encryptHeader.size());
															#line 1341 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::memcpy(self->dataPayloadStart, encryptedData.begin(), payloadSize);
															#line 1342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<EncryptActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EncryptActorState(); static_cast<EncryptActor*>(this)->destroy(); return 0; }
															#line 7403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<EncryptActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EncryptActorState();
		static_cast<EncryptActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Reference<BlobCipherKey> const& cipherKey,int loopDepth) 
	{
															#line 1322 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.textCipherKey = cipherKey;
															#line 7415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Reference<BlobCipherKey> && cipherKey,int loopDepth) 
	{
															#line 1322 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.textCipherKey = cipherKey;
															#line 7424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<BlobCipherKey> const& cipherKey,int loopDepth) 
	{
		loopDepth = a_body1cont5(cipherKey, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<BlobCipherKey> && cipherKey,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(cipherKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<EncryptActor*>(this)->actor_wait_state > 0) static_cast<EncryptActor*>(this)->actor_wait_state = 0;
		static_cast<EncryptActor*>(this)->ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >::remove();

	}
	void a_callback_fire(ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >*,Reference<BlobCipherKey> const& value) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >*,Reference<BlobCipherKey> && value) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >*,Error err) 
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1309 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 7506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via encrypt()
															#line 1309 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class EncryptActor final : public Actor<Void>, public ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >, public ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >, public FastAllocated<EncryptActor>, public EncryptActorState<EncryptActor> {
															#line 7511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<EncryptActor>::operator new;
	using FastAllocated<EncryptActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4639768229114438912UL, 10464376182239072768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >;
friend struct ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >;
															#line 1309 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptActor(EncryptedRangeFileWriter* const& self) 
															#line 7529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   EncryptActorState<EncryptActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("encrypt", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11460608645555408640UL, 117169993392551936UL);
		ActorExecutionContextHelper __helper(static_cast<EncryptActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("encrypt");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("encrypt", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EncryptActor, 0, Reference<BlobCipherKey> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< EncryptActor, 1, Reference<BlobCipherKey> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1309 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> encrypt( EncryptedRangeFileWriter* const& self ) {
															#line 1309 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new EncryptActor(self));
															#line 7562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1344 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 7567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via updateEncryptionKeysCtx()
															#line 1345 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class UpdateEncryptionKeysCtxActor>
															#line 1345 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class UpdateEncryptionKeysCtxActorState {
															#line 7573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1345 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UpdateEncryptionKeysCtxActorState(EncryptedRangeFileWriter* const& self,KeyRef const& key,SnapshotBackupUseTenantCache const& checkTenantCache) 
															#line 1345 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1345 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1345 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   key(key),
															#line 1345 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   checkTenantCache(checkTenantCache)
															#line 7584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this));

	}
	~UpdateEncryptionKeysCtxActorState() 
	{
		fdb_probe_actor_destroy("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1348 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<EncryptCipherDomainId> __when_expr_0 = getEncryptionDomainDetails(key, self->encryptMode, self->tenantCache, checkTenantCache);
															#line 1348 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state = 1;
															#line 1348 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >*>(static_cast<UpdateEncryptionKeysCtxActor*>(this)));
															#line 7606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateEncryptionKeysCtxActorState();
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1350 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		dbInfo = self->cx->clientInfo;
															#line 1353 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<TextAndHeaderCipherKeys> __when_expr_1 = GetEncryptCipherKeys<ClientDBInfo>::getLatestEncryptCipherKeysForDomain( dbInfo, curDomainId, BlobCipherMetrics::BACKUP);
															#line 1353 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state = 2;
															#line 1353 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >*>(static_cast<UpdateEncryptionKeysCtxActor*>(this)));
															#line 7638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(EncryptCipherDomainId const& __curDomainId,int loopDepth) 
	{
															#line 1348 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		curDomainId = __curDomainId;
															#line 7647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(EncryptCipherDomainId && __curDomainId,int loopDepth) 
	{
		curDomainId = std::move(__curDomainId);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state > 0) static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >*,EncryptCipherDomainId const& value) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >*,EncryptCipherDomainId && value) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >*,Error err) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(TextAndHeaderCipherKeys const& textAndHeaderCipherKeys,int loopDepth) 
	{
															#line 1356 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.textCipherKey = textAndHeaderCipherKeys.cipherTextKey;
															#line 1357 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.headerCipherKey = textAndHeaderCipherKeys.cipherHeaderKey;
															#line 1360 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.ivRef = makeString(AES_256_IV_LENGTH, *self->arena);
															#line 1361 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		deterministicRandom()->randomBytes(mutateString(self->cipherKeys.ivRef), AES_256_IV_LENGTH);
															#line 1362 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<UpdateEncryptionKeysCtxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateEncryptionKeysCtxActorState(); static_cast<UpdateEncryptionKeysCtxActor*>(this)->destroy(); return 0; }
															#line 7734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<UpdateEncryptionKeysCtxActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateEncryptionKeysCtxActorState();
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(TextAndHeaderCipherKeys && textAndHeaderCipherKeys,int loopDepth) 
	{
															#line 1356 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.textCipherKey = textAndHeaderCipherKeys.cipherTextKey;
															#line 1357 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.headerCipherKey = textAndHeaderCipherKeys.cipherHeaderKey;
															#line 1360 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->cipherKeys.ivRef = makeString(AES_256_IV_LENGTH, *self->arena);
															#line 1361 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		deterministicRandom()->randomBytes(mutateString(self->cipherKeys.ivRef), AES_256_IV_LENGTH);
															#line 1362 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<UpdateEncryptionKeysCtxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateEncryptionKeysCtxActorState(); static_cast<UpdateEncryptionKeysCtxActor*>(this)->destroy(); return 0; }
															#line 7754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<UpdateEncryptionKeysCtxActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateEncryptionKeysCtxActorState();
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(TextAndHeaderCipherKeys const& textAndHeaderCipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont2(textAndHeaderCipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(TextAndHeaderCipherKeys && textAndHeaderCipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(textAndHeaderCipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state > 0) static_cast<UpdateEncryptionKeysCtxActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateEncryptionKeysCtxActor*>(this)->ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys const& value) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys && value) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >*,Error err) 
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1345 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1345 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyRef key;
															#line 1345 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	SnapshotBackupUseTenantCache checkTenantCache;
															#line 1348 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptCipherDomainId curDomainId;
															#line 1350 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<AsyncVar<ClientDBInfo> const> dbInfo;
															#line 7847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via updateEncryptionKeysCtx()
															#line 1345 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class UpdateEncryptionKeysCtxActor final : public Actor<Void>, public ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >, public ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >, public FastAllocated<UpdateEncryptionKeysCtxActor>, public UpdateEncryptionKeysCtxActorState<UpdateEncryptionKeysCtxActor> {
															#line 7852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<UpdateEncryptionKeysCtxActor>::operator new;
	using FastAllocated<UpdateEncryptionKeysCtxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14081072231798593280UL, 5350323461652516864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >;
friend struct ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >;
															#line 1345 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UpdateEncryptionKeysCtxActor(EncryptedRangeFileWriter* const& self,KeyRef const& key,SnapshotBackupUseTenantCache const& checkTenantCache) 
															#line 7870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateEncryptionKeysCtxActorState<UpdateEncryptionKeysCtxActor>(self, key, checkTenantCache),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2045108966394790400UL, 17453403112709583616UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateEncryptionKeysCtxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateEncryptionKeysCtx");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateEncryptionKeysCtx", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateEncryptionKeysCtxActor, 0, EncryptCipherDomainId >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateEncryptionKeysCtxActor, 1, TextAndHeaderCipherKeys >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1345 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> updateEncryptionKeysCtx( EncryptedRangeFileWriter* const& self, KeyRef const& key, SnapshotBackupUseTenantCache const& checkTenantCache ) {
															#line 1345 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new UpdateEncryptionKeysCtxActor(self, key, checkTenantCache));
															#line 7903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1364 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// Returns the number of bytes that have been written to the buffer
	static int64_t currentBufferSize(EncryptedRangeFileWriter* self) { return self->wPtr - self->buffer.begin(); }

	static int64_t expectedFileSize(EncryptedRangeFileWriter* self) {
		// Return what has already been written to file plus the size of the current buffer
		// which indicates how many bytes the file will contain once the buffer is written
		return self->file->size() + currentBufferSize(self);
	}

	static void copyToBuffer(EncryptedRangeFileWriter* self, const void* src, size_t size) {
		if (size > 0) {
			std::memcpy(self->wPtr, src, size);
			self->wPtr += size;
			ASSERT(currentBufferSize(self) <= self->blockSize);
		}
	}

	static void appendStringRefWithLenToBuffer(EncryptedRangeFileWriter* self, StringRef* s) {
		// Append the string length followed by the string to the buffer
		uint32_t lenBuf = bigEndian32((uint32_t)s->size());
		copyToBuffer(self, &lenBuf, sizeof(lenBuf));
		copyToBuffer(self, s->begin(), s->size());
	}

																#line 7932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via getEncryptionDomainDetails()
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetEncryptionDomainDetailsActor>
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetEncryptionDomainDetailsActorState {
															#line 7938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetEncryptionDomainDetailsActorState(KeyRef const& key,EncryptionAtRestMode const& encryptMode,Optional<Reference<TenantEntryCache<Void>>> const& tenantCache,SnapshotBackupUseTenantCache const& checkTenantCache) 
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : key(key),
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   encryptMode(encryptMode),
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tenantCache(tenantCache),
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   checkTenantCache(checkTenantCache)
															#line 7951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("getEncryptionDomainDetails", reinterpret_cast<unsigned long>(this));

	}
	~GetEncryptionDomainDetailsActorState() 
	{
		fdb_probe_actor_destroy("getEncryptionDomainDetails", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1394 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (isSystemKey(key))
															#line 7966 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1395 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<GetEncryptionDomainDetailsActor*>(this)->SAV<EncryptCipherDomainId>::futures) { (void)(SYSTEM_KEYSPACE_ENCRYPT_DOMAIN_ID); this->~GetEncryptionDomainDetailsActorState(); static_cast<GetEncryptionDomainDetailsActor*>(this)->destroy(); return 0; }
															#line 7970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				new (&static_cast<GetEncryptionDomainDetailsActor*>(this)->SAV< EncryptCipherDomainId >::value()) EncryptCipherDomainId(SYSTEM_KEYSPACE_ENCRYPT_DOMAIN_ID);
				this->~GetEncryptionDomainDetailsActorState();
				static_cast<GetEncryptionDomainDetailsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1397 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (key.size() < TenantAPI::PREFIX_SIZE || encryptMode.mode == EncryptionAtRestMode::CLUSTER_AWARE)
															#line 7978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1398 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<GetEncryptionDomainDetailsActor*>(this)->SAV<EncryptCipherDomainId>::futures) { (void)(FDB_DEFAULT_ENCRYPT_DOMAIN_ID); this->~GetEncryptionDomainDetailsActorState(); static_cast<GetEncryptionDomainDetailsActor*>(this)->destroy(); return 0; }
															#line 7982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				new (&static_cast<GetEncryptionDomainDetailsActor*>(this)->SAV< EncryptCipherDomainId >::value()) EncryptCipherDomainId(FDB_DEFAULT_ENCRYPT_DOMAIN_ID);
				this->~GetEncryptionDomainDetailsActorState();
				static_cast<GetEncryptionDomainDetailsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1401 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			KeyRef tenantPrefix = KeyRef(key.begin(), TenantAPI::PREFIX_SIZE);
															#line 1402 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tenantId = TenantAPI::prefixToId(tenantPrefix);
															#line 1406 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (checkTenantCache && tenantCache.present())
															#line 7994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1407 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Optional<TenantEntryCachePayload<Void>>> __when_expr_0 = tenantCache.get()->getById(tenantId);
															#line 1407 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<GetEncryptionDomainDetailsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetEncryptionDomainDetailsActor*>(this)->actor_wait_state = 1;
															#line 1407 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetEncryptionDomainDetailsActor, 0, Optional<TenantEntryCachePayload<Void>> >*>(static_cast<GetEncryptionDomainDetailsActor*>(this)));
															#line 8005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetEncryptionDomainDetailsActorState();
		static_cast<GetEncryptionDomainDetailsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1412 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetEncryptionDomainDetailsActor*>(this)->SAV<EncryptCipherDomainId>::futures) { (void)(tenantId); this->~GetEncryptionDomainDetailsActorState(); static_cast<GetEncryptionDomainDetailsActor*>(this)->destroy(); return 0; }
															#line 8033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<GetEncryptionDomainDetailsActor*>(this)->SAV< EncryptCipherDomainId >::value()) EncryptCipherDomainId(std::move(tenantId)); // state_var_RVO
		this->~GetEncryptionDomainDetailsActorState();
		static_cast<GetEncryptionDomainDetailsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Optional<TenantEntryCachePayload<Void>> const& payload,int loopDepth) 
	{
															#line 1408 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!payload.present())
															#line 8045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1409 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<GetEncryptionDomainDetailsActor*>(this)->SAV<EncryptCipherDomainId>::futures) { (void)(FDB_DEFAULT_ENCRYPT_DOMAIN_ID); this->~GetEncryptionDomainDetailsActorState(); static_cast<GetEncryptionDomainDetailsActor*>(this)->destroy(); return 0; }
															#line 8049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<GetEncryptionDomainDetailsActor*>(this)->SAV< EncryptCipherDomainId >::value()) EncryptCipherDomainId(FDB_DEFAULT_ENCRYPT_DOMAIN_ID);
			this->~GetEncryptionDomainDetailsActorState();
			static_cast<GetEncryptionDomainDetailsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Optional<TenantEntryCachePayload<Void>> && payload,int loopDepth) 
	{
															#line 1408 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!payload.present())
															#line 8063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1409 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<GetEncryptionDomainDetailsActor*>(this)->SAV<EncryptCipherDomainId>::futures) { (void)(FDB_DEFAULT_ENCRYPT_DOMAIN_ID); this->~GetEncryptionDomainDetailsActorState(); static_cast<GetEncryptionDomainDetailsActor*>(this)->destroy(); return 0; }
															#line 8067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<GetEncryptionDomainDetailsActor*>(this)->SAV< EncryptCipherDomainId >::value()) EncryptCipherDomainId(FDB_DEFAULT_ENCRYPT_DOMAIN_ID);
			this->~GetEncryptionDomainDetailsActorState();
			static_cast<GetEncryptionDomainDetailsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantEntryCachePayload<Void>> const& payload,int loopDepth) 
	{
		loopDepth = a_body1cont4(payload, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantEntryCachePayload<Void>> && payload,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(payload), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetEncryptionDomainDetailsActor*>(this)->actor_wait_state > 0) static_cast<GetEncryptionDomainDetailsActor*>(this)->actor_wait_state = 0;
		static_cast<GetEncryptionDomainDetailsActor*>(this)->ActorCallback< GetEncryptionDomainDetailsActor, 0, Optional<TenantEntryCachePayload<Void>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetEncryptionDomainDetailsActor, 0, Optional<TenantEntryCachePayload<Void>> >*,Optional<TenantEntryCachePayload<Void>> const& value) 
	{
		fdb_probe_actor_enter("getEncryptionDomainDetails", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetEncryptionDomainDetailsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getEncryptionDomainDetails", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetEncryptionDomainDetailsActor, 0, Optional<TenantEntryCachePayload<Void>> >*,Optional<TenantEntryCachePayload<Void>> && value) 
	{
		fdb_probe_actor_enter("getEncryptionDomainDetails", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetEncryptionDomainDetailsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getEncryptionDomainDetails", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetEncryptionDomainDetailsActor, 0, Optional<TenantEntryCachePayload<Void>> >*,Error err) 
	{
		fdb_probe_actor_enter("getEncryptionDomainDetails", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetEncryptionDomainDetailsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getEncryptionDomainDetails", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyRef key;
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptionAtRestMode encryptMode;
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Optional<Reference<TenantEntryCache<Void>>> tenantCache;
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	SnapshotBackupUseTenantCache checkTenantCache;
															#line 1402 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t tenantId;
															#line 8162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via getEncryptionDomainDetails()
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetEncryptionDomainDetailsActor final : public Actor<EncryptCipherDomainId>, public ActorCallback< GetEncryptionDomainDetailsActor, 0, Optional<TenantEntryCachePayload<Void>> >, public FastAllocated<GetEncryptionDomainDetailsActor>, public GetEncryptionDomainDetailsActorState<GetEncryptionDomainDetailsActor> {
															#line 8167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<GetEncryptionDomainDetailsActor>::operator new;
	using FastAllocated<GetEncryptionDomainDetailsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5458121259526913024UL, 11870525080217049088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<EncryptCipherDomainId>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetEncryptionDomainDetailsActor, 0, Optional<TenantEntryCachePayload<Void>> >;
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetEncryptionDomainDetailsActor(KeyRef const& key,EncryptionAtRestMode const& encryptMode,Optional<Reference<TenantEntryCache<Void>>> const& tenantCache,SnapshotBackupUseTenantCache const& checkTenantCache) 
															#line 8184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<EncryptCipherDomainId>(),
		   GetEncryptionDomainDetailsActorState<GetEncryptionDomainDetailsActor>(key, encryptMode, tenantCache, checkTenantCache),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getEncryptionDomainDetails", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1075093242434710272UL, 4870538999557482240UL);
		ActorExecutionContextHelper __helper(static_cast<GetEncryptionDomainDetailsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getEncryptionDomainDetails");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getEncryptionDomainDetails", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetEncryptionDomainDetailsActor, 0, Optional<TenantEntryCachePayload<Void>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<EncryptCipherDomainId> getEncryptionDomainDetails( KeyRef const& key, EncryptionAtRestMode const& encryptMode, Optional<Reference<TenantEntryCache<Void>>> const& tenantCache, SnapshotBackupUseTenantCache const& checkTenantCache ) {
															#line 1389 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<EncryptCipherDomainId>(new GetEncryptionDomainDetailsActor(key, encryptMode, tenantCache, checkTenantCache));
															#line 8216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// Handles the first block and internal blocks.  Ends current block if needed.
	// The final flag is used in simulation to pad the file's final block to a whole block size
																#line 8223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via newBlock()
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class NewBlockActor>
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockActorState {
															#line 8229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockActorState(EncryptedRangeFileWriter* const& self,int const& bytesNeeded,KeyRef const& lastKey,bool const& writeValue,bool const& final = false) 
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   bytesNeeded(bytesNeeded),
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   lastKey(lastKey),
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   writeValue(writeValue),
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   final(final)
															#line 8244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("newBlock", reinterpret_cast<unsigned long>(this));

	}
	~NewBlockActorState() 
	{
		fdb_probe_actor_destroy("newBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1423 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int bytesLeft = self->blockEnd - expectedFileSize(self);
															#line 1424 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(bytesLeft >= 0);
															#line 1425 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (bytesLeft > 0)
															#line 8263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1426 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				paddingFFs = makePadding(bytesLeft);
															#line 1427 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				copyToBuffer(self, paddingFFs.begin(), bytesLeft);
															#line 8269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			}
															#line 1430 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (expectedFileSize(self) > 0)
															#line 8273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1432 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ASSERT(currentBufferSize(self) == self->blockSize);
															#line 1433 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = encrypt(self);
															#line 1433 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NewBlockActor*>(this)->actor_wait_state = 1;
															#line 1433 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 0, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 8286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewBlockActorState();
		static_cast<NewBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1440 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (final)
															#line 8314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1441 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 1442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<NewBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockActorState(); static_cast<NewBlockActor*>(this)->destroy(); return 0; }
															#line 8320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<NewBlockActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~NewBlockActorState();
			static_cast<NewBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1446 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->blockEnd += self->blockSize;
															#line 1449 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		copyToBuffer(self, (uint8_t*)&self->fileVersion, sizeof(self->fileVersion));
															#line 1452 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		uint32_t headerSize = 0;
															#line 1453 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		EncryptAuthTokenMode authTokenMode = getEncryptAuthTokenMode(EncryptAuthTokenMode::ENCRYPT_HEADER_AUTH_TOKEN_MODE_SINGLE);
															#line 1455 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		EncryptAuthTokenAlgo authTokenAlgo = getAuthTokenAlgoFromMode(authTokenMode);
															#line 1456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		headerSize = BlobCipherEncryptHeaderRef::getHeaderSize(CLIENT_KNOBS->ENCRYPT_HEADER_FLAGS_VERSION, getEncryptCurrentAlgoHeaderVersion(authTokenMode, authTokenAlgo), ENCRYPT_CIPHER_MODE_AES_256_CTR, authTokenMode, authTokenAlgo);
															#line 1462 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(headerSize > 0);
															#line 1464 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		copyToBuffer(self, (uint8_t*)&headerSize, sizeof(headerSize));
															#line 1466 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->encryptHeader = StringRef(self->wPtr, headerSize);
															#line 1467 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->wPtr += headerSize;
															#line 1468 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->dataPayloadStart = self->wPtr;
															#line 1471 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->blockEnd > self->blockSize)
															#line 8350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1472 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			appendStringRefWithLenToBuffer(self, &lastKey);
															#line 1473 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			appendStringRefWithLenToBuffer(self, &self->lastKey);
															#line 1474 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (writeValue)
															#line 8358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1475 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				appendStringRefWithLenToBuffer(self, &self->lastValue);
															#line 8362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			}
		}
															#line 1480 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (expectedFileSize(self) + bytesNeeded > self->blockEnd)
															#line 8367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_bad_block_size(), loopDepth);
															#line 8371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 1484 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<NewBlockActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockActorState(); static_cast<NewBlockActor*>(this)->destroy(); return 0; }
															#line 8375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<NewBlockActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewBlockActorState();
		static_cast<NewBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1434 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append(self->buffer.begin(), self->blockSize);
															#line 1434 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<NewBlockActor*>(this)->actor_wait_state = 2;
															#line 1434 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 1, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 8394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1434 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append(self->buffer.begin(), self->blockSize);
															#line 1434 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<NewBlockActor*>(this)->actor_wait_state = 2;
															#line 1434 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor, 1, Void >*>(static_cast<NewBlockActor*>(this)));
															#line 8410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewBlockActor*>(this)->actor_wait_state > 0) static_cast<NewBlockActor*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor*>(this)->ActorCallback< NewBlockActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewBlockActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1437 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->wPtr = mutateString(self->buffer);
															#line 8494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1437 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->wPtr = mutateString(self->buffer);
															#line 8503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<NewBlockActor*>(this)->actor_wait_state > 0) static_cast<NewBlockActor*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor*>(this)->ActorCallback< NewBlockActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NewBlockActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NewBlockActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesNeeded;
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyRef lastKey;
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool writeValue;
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool final;
															#line 1426 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value paddingFFs;
															#line 8595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via newBlock()
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockActor final : public Actor<Void>, public ActorCallback< NewBlockActor, 0, Void >, public ActorCallback< NewBlockActor, 1, Void >, public FastAllocated<NewBlockActor>, public NewBlockActorState<NewBlockActor> {
															#line 8600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<NewBlockActor>::operator new;
	using FastAllocated<NewBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14757043000591768064UL, 8064978558596008192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewBlockActor, 0, Void >;
friend struct ActorCallback< NewBlockActor, 1, Void >;
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockActor(EncryptedRangeFileWriter* const& self,int const& bytesNeeded,KeyRef const& lastKey,bool const& writeValue,bool const& final = false) 
															#line 8618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   NewBlockActorState<NewBlockActor>(self, bytesNeeded, lastKey, writeValue, final),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11473969930622856192UL, 2275173024393763072UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewBlockActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< NewBlockActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> newBlock( EncryptedRangeFileWriter* const& self, int const& bytesNeeded, KeyRef const& lastKey, bool const& writeValue, bool const& final = false ) {
															#line 1417 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new NewBlockActor(self, bytesNeeded, lastKey, writeValue, final));
															#line 8651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1486 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> padEnd(bool final) {
		if (expectedFileSize(this) > 0) {
			return newBlock(this, 0, StringRef(), true, final);
		}
		return Void();
	}

	// Ends the current block if necessary based on bytesNeeded.
																#line 8664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via newBlockIfNeeded()
															#line 1495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class NewBlockIfNeededActor>
															#line 1495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockIfNeededActorState {
															#line 8670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockIfNeededActorState(EncryptedRangeFileWriter* const& self,int const& bytesNeeded) 
															#line 1495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   bytesNeeded(bytesNeeded)
															#line 8679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("newBlockIfNeeded", reinterpret_cast<unsigned long>(this));

	}
	~NewBlockIfNeededActorState() 
	{
		fdb_probe_actor_destroy("newBlockIfNeeded", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1496 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (expectedFileSize(self) + bytesNeeded > self->blockEnd)
															#line 8694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1497 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = newBlock(self, bytesNeeded, self->lastKey, true);
															#line 1497 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<NewBlockIfNeededActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NewBlockIfNeededActor*>(this)->actor_wait_state = 1;
															#line 1497 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewBlockIfNeededActor, 0, Void >*>(static_cast<NewBlockIfNeededActor*>(this)));
															#line 8705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewBlockIfNeededActorState();
		static_cast<NewBlockIfNeededActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1499 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<NewBlockIfNeededActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockIfNeededActorState(); static_cast<NewBlockIfNeededActor*>(this)->destroy(); return 0; }
															#line 8733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<NewBlockIfNeededActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewBlockIfNeededActorState();
		static_cast<NewBlockIfNeededActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewBlockIfNeededActor*>(this)->actor_wait_state > 0) static_cast<NewBlockIfNeededActor*>(this)->actor_wait_state = 0;
		static_cast<NewBlockIfNeededActor*>(this)->ActorCallback< NewBlockIfNeededActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockIfNeededActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewBlockIfNeededActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewBlockIfNeededActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesNeeded;
															#line 8832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via newBlockIfNeeded()
															#line 1495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockIfNeededActor final : public Actor<Void>, public ActorCallback< NewBlockIfNeededActor, 0, Void >, public FastAllocated<NewBlockIfNeededActor>, public NewBlockIfNeededActorState<NewBlockIfNeededActor> {
															#line 8837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<NewBlockIfNeededActor>::operator new;
	using FastAllocated<NewBlockIfNeededActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12166782325876442368UL, 17066884821197171200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewBlockIfNeededActor, 0, Void >;
															#line 1495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockIfNeededActor(EncryptedRangeFileWriter* const& self,int const& bytesNeeded) 
															#line 8854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   NewBlockIfNeededActorState<NewBlockIfNeededActor>(self, bytesNeeded),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2008971701599870208UL, 8353149633524734464UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newBlockIfNeeded");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newBlockIfNeeded", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewBlockIfNeededActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> newBlockIfNeeded( EncryptedRangeFileWriter* const& self, int const& bytesNeeded ) {
															#line 1495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new NewBlockIfNeededActor(self, bytesNeeded));
															#line 8886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1501 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 8891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via handleTenantBondary()
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class HandleTenantBondaryActor>
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class HandleTenantBondaryActorState {
															#line 8897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	HandleTenantBondaryActorState(EncryptedRangeFileWriter* const& self,Key const& k,Value const& v,bool const& writeValue,EncryptCipherDomainId const& curKeyDomainId,SnapshotBackupUseTenantCache const& checkTenantCache) 
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k),
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   v(v),
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   writeValue(writeValue),
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   curKeyDomainId(curKeyDomainId),
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   checkTenantCache(checkTenantCache),
															#line 1508 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   endKey(k)
															#line 8916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("handleTenantBondary", reinterpret_cast<unsigned long>(this));

	}
	~HandleTenantBondaryActorState() 
	{
		fdb_probe_actor_destroy("handleTenantBondary", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1510 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (curKeyDomainId != SYSTEM_KEYSPACE_ENCRYPT_DOMAIN_ID && curKeyDomainId != FDB_DEFAULT_ENCRYPT_DOMAIN_ID)
															#line 8931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1511 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				endKey = StringRef(k.begin(), TenantAPI::PREFIX_SIZE);
															#line 8935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			}
															#line 1514 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			newValue = StringRef();
															#line 1515 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			self->lastKey = k;
															#line 1516 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			self->lastValue = v;
															#line 1517 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			appendStringRefWithLenToBuffer(self, &endKey);
															#line 1518 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			appendStringRefWithLenToBuffer(self, &newValue);
															#line 1519 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = newBlock(self, 0, endKey, writeValue);
															#line 1519 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<HandleTenantBondaryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HandleTenantBondaryActor*>(this)->actor_wait_state = 1;
															#line 1519 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandleTenantBondaryActor, 0, Void >*>(static_cast<HandleTenantBondaryActor*>(this)));
															#line 8956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleTenantBondaryActorState();
		static_cast<HandleTenantBondaryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1520 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = updateEncryptionKeysCtx(self, self->lastKey, checkTenantCache);
															#line 1520 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<HandleTenantBondaryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HandleTenantBondaryActor*>(this)->actor_wait_state = 2;
															#line 1520 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleTenantBondaryActor, 1, Void >*>(static_cast<HandleTenantBondaryActor*>(this)));
															#line 8986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1520 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = updateEncryptionKeysCtx(self, self->lastKey, checkTenantCache);
															#line 1520 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<HandleTenantBondaryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HandleTenantBondaryActor*>(this)->actor_wait_state = 2;
															#line 1520 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleTenantBondaryActor, 1, Void >*>(static_cast<HandleTenantBondaryActor*>(this)));
															#line 9002 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleTenantBondaryActor*>(this)->actor_wait_state > 0) static_cast<HandleTenantBondaryActor*>(this)->actor_wait_state = 0;
		static_cast<HandleTenantBondaryActor*>(this)->ActorCallback< HandleTenantBondaryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleTenantBondaryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleTenantBondary", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTenantBondaryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTenantBondary", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleTenantBondaryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleTenantBondary", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTenantBondaryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTenantBondary", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandleTenantBondaryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleTenantBondary", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTenantBondaryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTenantBondary", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1521 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<HandleTenantBondaryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleTenantBondaryActorState(); static_cast<HandleTenantBondaryActor*>(this)->destroy(); return 0; }
															#line 9086 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<HandleTenantBondaryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleTenantBondaryActorState();
		static_cast<HandleTenantBondaryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1521 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<HandleTenantBondaryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleTenantBondaryActorState(); static_cast<HandleTenantBondaryActor*>(this)->destroy(); return 0; }
															#line 9098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<HandleTenantBondaryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HandleTenantBondaryActorState();
		static_cast<HandleTenantBondaryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleTenantBondaryActor*>(this)->actor_wait_state > 0) static_cast<HandleTenantBondaryActor*>(this)->actor_wait_state = 0;
		static_cast<HandleTenantBondaryActor*>(this)->ActorCallback< HandleTenantBondaryActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleTenantBondaryActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleTenantBondary", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTenantBondaryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTenantBondary", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleTenantBondaryActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleTenantBondary", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTenantBondaryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTenantBondary", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleTenantBondaryActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleTenantBondary", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTenantBondaryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleTenantBondary", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value v;
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool writeValue;
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptCipherDomainId curKeyDomainId;
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	SnapshotBackupUseTenantCache checkTenantCache;
															#line 1508 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyRef endKey;
															#line 1514 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	ValueRef newValue;
															#line 9197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via handleTenantBondary()
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class HandleTenantBondaryActor final : public Actor<Void>, public ActorCallback< HandleTenantBondaryActor, 0, Void >, public ActorCallback< HandleTenantBondaryActor, 1, Void >, public FastAllocated<HandleTenantBondaryActor>, public HandleTenantBondaryActorState<HandleTenantBondaryActor> {
															#line 9202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<HandleTenantBondaryActor>::operator new;
	using FastAllocated<HandleTenantBondaryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1846079432627250176UL, 7847315157245231616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandleTenantBondaryActor, 0, Void >;
friend struct ActorCallback< HandleTenantBondaryActor, 1, Void >;
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	HandleTenantBondaryActor(EncryptedRangeFileWriter* const& self,Key const& k,Value const& v,bool const& writeValue,EncryptCipherDomainId const& curKeyDomainId,SnapshotBackupUseTenantCache const& checkTenantCache) 
															#line 9220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   HandleTenantBondaryActorState<HandleTenantBondaryActor>(self, k, v, writeValue, curKeyDomainId, checkTenantCache),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleTenantBondary", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15081182201927232512UL, 7497709050727614720UL);
		ActorExecutionContextHelper __helper(static_cast<HandleTenantBondaryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleTenantBondary");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleTenantBondary", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandleTenantBondaryActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleTenantBondaryActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> handleTenantBondary( EncryptedRangeFileWriter* const& self, Key const& k, Value const& v, bool const& writeValue, EncryptCipherDomainId const& curKeyDomainId, SnapshotBackupUseTenantCache const& checkTenantCache ) {
															#line 1502 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new HandleTenantBondaryActor(self, k, v, writeValue, curKeyDomainId, checkTenantCache));
															#line 9253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1523 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 9258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via finishCurTenantBlockStartNewIfNeeded()
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class FinishCurTenantBlockStartNewIfNeededActor>
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class FinishCurTenantBlockStartNewIfNeededActorState {
															#line 9264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FinishCurTenantBlockStartNewIfNeededActorState(EncryptedRangeFileWriter* const& self,Key const& k,Value const& v,bool const& writeValue,SnapshotBackupUseTenantCache const& checkTenantCache) 
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k),
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   v(v),
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   writeValue(writeValue),
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   checkTenantCache(checkTenantCache)
															#line 9279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this));

	}
	~FinishCurTenantBlockStartNewIfNeededActorState() 
	{
		fdb_probe_actor_destroy("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1530 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->lastKey.size() == 0 || k.size() == 0)
															#line 9294 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1531 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (!static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FinishCurTenantBlockStartNewIfNeededActorState(); static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->destroy(); return 0; }
															#line 9298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				new (&static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->SAV< bool >::value()) bool(false);
				this->~FinishCurTenantBlockStartNewIfNeededActorState();
				static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1533 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<EncryptCipherDomainId> __when_expr_0 = getEncryptionDomainDetails(k, self->encryptMode, self->tenantCache, checkTenantCache);
															#line 1533 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->actor_wait_state = 1;
															#line 1533 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 0, EncryptCipherDomainId >*>(static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)));
															#line 9313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FinishCurTenantBlockStartNewIfNeededActorState();
		static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1535 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<EncryptCipherDomainId> __when_expr_1 = getEncryptionDomainDetails(self->lastKey, self->encryptMode, self->tenantCache, checkTenantCache);
															#line 1535 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->actor_wait_state = 2;
															#line 1535 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 1, EncryptCipherDomainId >*>(static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)));
															#line 9343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(EncryptCipherDomainId const& __curKeyDomainId,int loopDepth) 
	{
															#line 1533 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		curKeyDomainId = __curKeyDomainId;
															#line 9352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(EncryptCipherDomainId && __curKeyDomainId,int loopDepth) 
	{
		curKeyDomainId = std::move(__curKeyDomainId);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->actor_wait_state > 0) static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->actor_wait_state = 0;
		static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 0, EncryptCipherDomainId >::remove();

	}
	void a_callback_fire(ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 0, EncryptCipherDomainId >*,EncryptCipherDomainId const& value) 
	{
		fdb_probe_actor_enter("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 0, EncryptCipherDomainId >*,EncryptCipherDomainId && value) 
	{
		fdb_probe_actor_enter("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 0, EncryptCipherDomainId >*,Error err) 
	{
		fdb_probe_actor_enter("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1537 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (curKeyDomainId != prevKeyDomainId)
															#line 9431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1538 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			CODE_PROBE(true, "crossed tenant boundaries");
															#line 1539 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = handleTenantBondary(self, k, v, writeValue, curKeyDomainId, checkTenantCache);
															#line 1539 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->actor_wait_state = 3;
															#line 1539 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 2, Void >*>(static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)));
															#line 9444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(EncryptCipherDomainId const& __prevKeyDomainId,int loopDepth) 
	{
															#line 1535 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		prevKeyDomainId = __prevKeyDomainId;
															#line 9458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(EncryptCipherDomainId && __prevKeyDomainId,int loopDepth) 
	{
		prevKeyDomainId = std::move(__prevKeyDomainId);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->actor_wait_state > 0) static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->actor_wait_state = 0;
		static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 1, EncryptCipherDomainId >::remove();

	}
	void a_callback_fire(ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 1, EncryptCipherDomainId >*,EncryptCipherDomainId const& value) 
	{
		fdb_probe_actor_enter("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 1, EncryptCipherDomainId >*,EncryptCipherDomainId && value) 
	{
		fdb_probe_actor_enter("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 1, EncryptCipherDomainId >*,Error err) 
	{
		fdb_probe_actor_enter("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1542 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FinishCurTenantBlockStartNewIfNeededActorState(); static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->destroy(); return 0; }
															#line 9537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->SAV< bool >::value()) bool(false);
		this->~FinishCurTenantBlockStartNewIfNeededActorState();
		static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1540 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->SAV<bool>::futures) { (void)(true); this->~FinishCurTenantBlockStartNewIfNeededActorState(); static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->destroy(); return 0; }
															#line 9549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->SAV< bool >::value()) bool(true);
		this->~FinishCurTenantBlockStartNewIfNeededActorState();
		static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1540 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->SAV<bool>::futures) { (void)(true); this->~FinishCurTenantBlockStartNewIfNeededActorState(); static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->destroy(); return 0; }
															#line 9561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->SAV< bool >::value()) bool(true);
		this->~FinishCurTenantBlockStartNewIfNeededActorState();
		static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->actor_wait_state > 0) static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->actor_wait_state = 0;
		static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value v;
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool writeValue;
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	SnapshotBackupUseTenantCache checkTenantCache;
															#line 1533 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptCipherDomainId curKeyDomainId;
															#line 1535 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptCipherDomainId prevKeyDomainId;
															#line 9658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via finishCurTenantBlockStartNewIfNeeded()
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class FinishCurTenantBlockStartNewIfNeededActor final : public Actor<bool>, public ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 0, EncryptCipherDomainId >, public ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 1, EncryptCipherDomainId >, public ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 2, Void >, public FastAllocated<FinishCurTenantBlockStartNewIfNeededActor>, public FinishCurTenantBlockStartNewIfNeededActorState<FinishCurTenantBlockStartNewIfNeededActor> {
															#line 9663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<FinishCurTenantBlockStartNewIfNeededActor>::operator new;
	using FastAllocated<FinishCurTenantBlockStartNewIfNeededActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13203170406491457280UL, 9289612711858734592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 0, EncryptCipherDomainId >;
friend struct ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 1, EncryptCipherDomainId >;
friend struct ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 2, Void >;
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FinishCurTenantBlockStartNewIfNeededActor(EncryptedRangeFileWriter* const& self,Key const& k,Value const& v,bool const& writeValue,SnapshotBackupUseTenantCache const& checkTenantCache) 
															#line 9682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<bool>(),
		   FinishCurTenantBlockStartNewIfNeededActorState<FinishCurTenantBlockStartNewIfNeededActor>(self, k, v, writeValue, checkTenantCache),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13465396440329956608UL, 16781070320261181440UL);
		ActorExecutionContextHelper __helper(static_cast<FinishCurTenantBlockStartNewIfNeededActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finishCurTenantBlockStartNewIfNeeded");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finishCurTenantBlockStartNewIfNeeded", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 0, EncryptCipherDomainId >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 1, EncryptCipherDomainId >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FinishCurTenantBlockStartNewIfNeededActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<bool> finishCurTenantBlockStartNewIfNeeded( EncryptedRangeFileWriter* const& self, Key const& k, Value const& v, bool const& writeValue, SnapshotBackupUseTenantCache const& checkTenantCache ) {
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<bool>(new FinishCurTenantBlockStartNewIfNeededActor(self, k, v, writeValue, checkTenantCache));
															#line 9716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1544 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// Start a new block if needed, then write the key and value
																#line 9722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via writeKV_impl()
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKV_implActor>
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActorState {
															#line 9728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActorState(EncryptedRangeFileWriter* const& self,Key const& k,Value const& v) 
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k),
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   v(v)
															#line 9739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKV_implActorState() 
	{
		fdb_probe_actor_destroy("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1547 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!self->cipherKeys.headerCipherKey.present() || !self->cipherKeys.headerCipherKey.get().isValid() || !self->cipherKeys.textCipherKey.isValid())
															#line 9754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1549 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = updateEncryptionKeysCtx(self, k, SnapshotBackupUseTenantCache::False);
															#line 1549 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<WriteKV_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WriteKV_implActor*>(this)->actor_wait_state = 1;
															#line 1549 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor, 0, Void >*>(static_cast<WriteKV_implActor*>(this)));
															#line 9765 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKV_implActorState();
		static_cast<WriteKV_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1551 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		toWrite = sizeof(int32_t) + k.size() + sizeof(int32_t) + v.size();
															#line 1552 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = newBlockIfNeeded(self, toWrite);
															#line 1552 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKV_implActor*>(this)->actor_wait_state = 2;
															#line 1552 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor, 1, Void >*>(static_cast<WriteKV_implActor*>(this)));
															#line 9802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor*>(this)->ActorCallback< WriteKV_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<bool> __when_expr_2 = finishCurTenantBlockStartNewIfNeeded(self, k, v, true, SnapshotBackupUseTenantCache::False);
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKV_implActor*>(this)->actor_wait_state = 3;
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor, 2, bool >*>(static_cast<WriteKV_implActor*>(this)));
															#line 9905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<bool> __when_expr_2 = finishCurTenantBlockStartNewIfNeeded(self, k, v, true, SnapshotBackupUseTenantCache::False);
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKV_implActor*>(this)->actor_wait_state = 3;
															#line 1553 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor, 2, bool >*>(static_cast<WriteKV_implActor*>(this)));
															#line 9921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor*>(this)->ActorCallback< WriteKV_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(bool const& createdNewBlock,int loopDepth) 
	{
															#line 1555 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (createdNewBlock)
															#line 10005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1556 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<WriteKV_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActorState(); static_cast<WriteKV_implActor*>(this)->destroy(); return 0; }
															#line 10009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<WriteKV_implActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WriteKV_implActorState();
			static_cast<WriteKV_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1558 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &k);
															#line 1559 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &v);
															#line 1560 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1561 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastValue = v;
															#line 1562 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActorState(); static_cast<WriteKV_implActor*>(this)->destroy(); return 0; }
															#line 10025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<WriteKV_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActorState();
		static_cast<WriteKV_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(bool && createdNewBlock,int loopDepth) 
	{
															#line 1555 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (createdNewBlock)
															#line 10037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1556 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<WriteKV_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActorState(); static_cast<WriteKV_implActor*>(this)->destroy(); return 0; }
															#line 10041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<WriteKV_implActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WriteKV_implActorState();
			static_cast<WriteKV_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1558 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &k);
															#line 1559 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &v);
															#line 1560 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1561 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastValue = v;
															#line 1562 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActorState(); static_cast<WriteKV_implActor*>(this)->destroy(); return 0; }
															#line 10057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<WriteKV_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActorState();
		static_cast<WriteKV_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(bool const& createdNewBlock,int loopDepth) 
	{
		loopDepth = a_body1cont4(createdNewBlock, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(bool && createdNewBlock,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(createdNewBlock), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteKV_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor*>(this)->ActorCallback< WriteKV_implActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value v;
															#line 1551 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int toWrite;
															#line 10148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via writeKV_impl()
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor final : public Actor<Void>, public ActorCallback< WriteKV_implActor, 0, Void >, public ActorCallback< WriteKV_implActor, 1, Void >, public ActorCallback< WriteKV_implActor, 2, bool >, public FastAllocated<WriteKV_implActor>, public WriteKV_implActorState<WriteKV_implActor> {
															#line 10153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<WriteKV_implActor>::operator new;
	using FastAllocated<WriteKV_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6315819753271108352UL, 6682033703558460416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKV_implActor, 0, Void >;
friend struct ActorCallback< WriteKV_implActor, 1, Void >;
friend struct ActorCallback< WriteKV_implActor, 2, bool >;
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor(EncryptedRangeFileWriter* const& self,Key const& k,Value const& v) 
															#line 10172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   WriteKV_implActorState<WriteKV_implActor>(self, k, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12331643623674153728UL, 17746951694630343424UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKV_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKV_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKV_implActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteKV_implActor, 2, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKV_impl( EncryptedRangeFileWriter* const& self, Key const& k, Value const& v ) {
															#line 1546 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKV_implActor(self, k, v));
															#line 10206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1564 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKV(Key k, Value v) { return writeKV_impl(this, k, v); }

	// Write begin key or end key.
																#line 10214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via writeKey_impl()
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKey_implActor>
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKey_implActorState {
															#line 10220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKey_implActorState(EncryptedRangeFileWriter* const& self,Key const& k) 
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k)
															#line 10229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("writeKey_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKey_implActorState() 
	{
		fdb_probe_actor_destroy("writeKey_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1570 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (k.size() > 0 && (!self->cipherKeys.headerCipherKey.present() || !self->cipherKeys.headerCipherKey.get().isValid() || !self->cipherKeys.textCipherKey.isValid()))
															#line 10244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1573 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = updateEncryptionKeysCtx(self, k, SnapshotBackupUseTenantCache::True);
															#line 1573 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<WriteKey_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WriteKey_implActor*>(this)->actor_wait_state = 1;
															#line 1573 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor, 0, Void >*>(static_cast<WriteKey_implActor*>(this)));
															#line 10255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKey_implActorState();
		static_cast<WriteKey_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1576 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int toWrite = sizeof(uint32_t) + k.size() + sizeof(uint32_t);
															#line 1577 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = newBlockIfNeeded(self, toWrite);
															#line 1577 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKey_implActor*>(this)->actor_wait_state = 2;
															#line 1577 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor, 1, Void >*>(static_cast<WriteKey_implActor*>(this)));
															#line 10292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKey_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKey_implActor*>(this)->ActorCallback< WriteKey_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKey_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1580 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<bool> __when_expr_2 = finishCurTenantBlockStartNewIfNeeded(self, k, StringRef(), false, SnapshotBackupUseTenantCache::True);
															#line 1580 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKey_implActor*>(this)->actor_wait_state = 3;
															#line 1580 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor, 2, bool >*>(static_cast<WriteKey_implActor*>(this)));
															#line 10395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1580 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<bool> __when_expr_2 = finishCurTenantBlockStartNewIfNeeded(self, k, StringRef(), false, SnapshotBackupUseTenantCache::True);
															#line 1580 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKey_implActor*>(this)->actor_wait_state = 3;
															#line 1580 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor, 2, bool >*>(static_cast<WriteKey_implActor*>(this)));
															#line 10411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKey_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKey_implActor*>(this)->ActorCallback< WriteKey_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKey_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(bool const& createdNewBlock,int loopDepth) 
	{
															#line 1582 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (createdNewBlock)
															#line 10495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1583 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<WriteKey_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActorState(); static_cast<WriteKey_implActor*>(this)->destroy(); return 0; }
															#line 10499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<WriteKey_implActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WriteKey_implActorState();
			static_cast<WriteKey_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1585 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &k);
															#line 1586 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1587 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKey_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActorState(); static_cast<WriteKey_implActor*>(this)->destroy(); return 0; }
															#line 10511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<WriteKey_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKey_implActorState();
		static_cast<WriteKey_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(bool && createdNewBlock,int loopDepth) 
	{
															#line 1582 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (createdNewBlock)
															#line 10523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1583 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<WriteKey_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActorState(); static_cast<WriteKey_implActor*>(this)->destroy(); return 0; }
															#line 10527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<WriteKey_implActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~WriteKey_implActorState();
			static_cast<WriteKey_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1585 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		appendStringRefWithLenToBuffer(self, &k);
															#line 1586 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1587 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKey_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActorState(); static_cast<WriteKey_implActor*>(this)->destroy(); return 0; }
															#line 10539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<WriteKey_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKey_implActorState();
		static_cast<WriteKey_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(bool const& createdNewBlock,int loopDepth) 
	{
		loopDepth = a_body1cont4(createdNewBlock, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(bool && createdNewBlock,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(createdNewBlock), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteKey_implActor*>(this)->actor_wait_state > 0) static_cast<WriteKey_implActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKey_implActor*>(this)->ActorCallback< WriteKey_implActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteKey_implActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 10626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via writeKey_impl()
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKey_implActor final : public Actor<Void>, public ActorCallback< WriteKey_implActor, 0, Void >, public ActorCallback< WriteKey_implActor, 1, Void >, public ActorCallback< WriteKey_implActor, 2, bool >, public FastAllocated<WriteKey_implActor>, public WriteKey_implActorState<WriteKey_implActor> {
															#line 10631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<WriteKey_implActor>::operator new;
	using FastAllocated<WriteKey_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11821968909654055424UL, 11922910546924800768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKey_implActor, 0, Void >;
friend struct ActorCallback< WriteKey_implActor, 1, Void >;
friend struct ActorCallback< WriteKey_implActor, 2, bool >;
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKey_implActor(EncryptedRangeFileWriter* const& self,Key const& k) 
															#line 10650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   WriteKey_implActorState<WriteKey_implActor>(self, k),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(551483992183075584UL, 8902642963360461568UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKey_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKey_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKey_implActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteKey_implActor, 2, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKey_impl( EncryptedRangeFileWriter* const& self, Key const& k ) {
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKey_implActor(self, k));
															#line 10684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1589 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKey(Key k) { return writeKey_impl(this, k); }

																#line 10691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via finish_impl()
															#line 1592 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class Finish_implActor>
															#line 1592 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class Finish_implActorState {
															#line 10697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1592 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Finish_implActorState(EncryptedRangeFileWriter* const& self) 
															#line 1592 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1592 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self)
															#line 10704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("finish_impl", reinterpret_cast<unsigned long>(this));

	}
	~Finish_implActorState() 
	{
		fdb_probe_actor_destroy("finish_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1594 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (currentBufferSize(self) > 0)
															#line 10719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1595 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = encrypt(self);
															#line 1595 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<Finish_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<Finish_implActor*>(this)->actor_wait_state = 1;
															#line 1595 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Finish_implActor, 0, Void >*>(static_cast<Finish_implActor*>(this)));
															#line 10730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Finish_implActorState();
		static_cast<Finish_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1598 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<Finish_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Finish_implActorState(); static_cast<Finish_implActor*>(this)->destroy(); return 0; }
															#line 10758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<Finish_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Finish_implActorState();
		static_cast<Finish_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1596 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append(self->buffer.begin(), currentBufferSize(self));
															#line 1596 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<Finish_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Finish_implActor*>(this)->actor_wait_state = 2;
															#line 1596 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Finish_implActor, 1, Void >*>(static_cast<Finish_implActor*>(this)));
															#line 10777 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1596 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append(self->buffer.begin(), currentBufferSize(self));
															#line 1596 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<Finish_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<Finish_implActor*>(this)->actor_wait_state = 2;
															#line 1596 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< Finish_implActor, 1, Void >*>(static_cast<Finish_implActor*>(this)));
															#line 10793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Finish_implActor*>(this)->actor_wait_state > 0) static_cast<Finish_implActor*>(this)->actor_wait_state = 0;
		static_cast<Finish_implActor*>(this)->ActorCallback< Finish_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Finish_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Finish_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Finish_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<Finish_implActor*>(this)->actor_wait_state > 0) static_cast<Finish_implActor*>(this)->actor_wait_state = 0;
		static_cast<Finish_implActor*>(this)->ActorCallback< Finish_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Finish_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< Finish_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< Finish_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1592 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptedRangeFileWriter* self;
															#line 10962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via finish_impl()
															#line 1592 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class Finish_implActor final : public Actor<Void>, public ActorCallback< Finish_implActor, 0, Void >, public ActorCallback< Finish_implActor, 1, Void >, public FastAllocated<Finish_implActor>, public Finish_implActorState<Finish_implActor> {
															#line 10967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<Finish_implActor>::operator new;
	using FastAllocated<Finish_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9445833433915780096UL, 2556072249770995456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Finish_implActor, 0, Void >;
friend struct ActorCallback< Finish_implActor, 1, Void >;
															#line 1592 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Finish_implActor(EncryptedRangeFileWriter* const& self) 
															#line 10985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   Finish_implActorState<Finish_implActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finish_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6941044748667588864UL, 17414012196556178688UL);
		ActorExecutionContextHelper __helper(static_cast<Finish_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finish_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finish_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Finish_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< Finish_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1592 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> finish_impl( EncryptedRangeFileWriter* const& self ) {
															#line 1592 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new Finish_implActor(self));
															#line 11018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1600 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> finish() { return finish_impl(this); }

	Database cx;
	Arena* arena;
	EncryptionAtRestMode encryptMode;
	Reference<IBackupFile> file;
	Optional<Reference<TenantEntryCache<Void>>> tenantCache;
	int blockSize;

private:
	Standalone<StringRef> buffer;
	uint8_t* wPtr;
	StringRef encryptHeader;
	uint8_t* dataPayloadStart;
	int64_t blockEnd;
	uint32_t fileVersion;
	Key lastKey;
	Key lastValue;
	SnapshotFileBackupEncryptionKeys cipherKeys;
};

// File Format handlers.
// Both Range and Log formats are designed to be readable starting at any BACKUP_RANGEFILE_BLOCK_SIZE boundary
// so they can be read in parallel.
//
// Writer instances must be kept alive while any member actors are in progress.
//
// RangeFileWriter must be used as follows:
//   1 - writeKey(key) the queried key range begin
//   2 - writeKV(k, v) each kv pair to restore
//   3 - writeKey(key) the queried key range end
//	 4 - finish()
//
// RangeFileWriter will insert the required padding, header, and extra
// end/begin keys around the 1MB boundaries as needed.
//
// Example:
//   The range a-z is queries and returns c-j which covers 3 blocks.
//   The client code writes keys in this sequence:
//             a c d e f g h i j z
//
//   H = header   P = padding   a...z = keys  v = value | = block boundary
//
//   Encoded file:  H a cv dv ev P | H e ev fv gv hv P | H h hv iv jv z
//   Decoded in blocks yields:
//           Block 1: range [a, e) with kv pairs cv, dv
//           Block 2: range [e, h) with kv pairs ev, fv, gv
//           Block 3: range [h, z) with kv pairs hv, iv, jv
//
//   NOTE: All blocks except for the final block will have one last
//   value which will not be used.  This isn't actually a waste since
//   if the next KV pair wouldn't fit within the block after the value
//   then the space after the final key to the next 1MB boundary would
//   just be padding anyway.
struct RangeFileWriter : public IRangeFileWriter {
	RangeFileWriter(Reference<IBackupFile> file = Reference<IBackupFile>(), int blockSize = 0)
	  : file(file), blockSize(blockSize), blockEnd(0), fileVersion(BACKUP_AGENT_SNAPSHOT_FILE_VERSION) {}

	// Handles the first block and internal blocks.  Ends current block if needed.
	// The final flag is used in simulation to pad the file's final block to a whole block size
																#line 11083 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via newBlock()
															#line 1661 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class NewBlockActor1>
															#line 1661 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockActor1State {
															#line 11089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1661 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockActor1State(RangeFileWriter* const& self,int const& bytesNeeded,bool const& final = false) 
															#line 1661 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1661 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1661 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   bytesNeeded(bytesNeeded),
															#line 1661 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   final(final)
															#line 11100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("newBlock", reinterpret_cast<unsigned long>(this));

	}
	~NewBlockActor1State() 
	{
		fdb_probe_actor_destroy("newBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1663 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int bytesLeft = self->blockEnd - self->file->size();
															#line 1664 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (bytesLeft > 0)
															#line 11117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1665 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				paddingFFs = makePadding(bytesLeft);
															#line 1666 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->file->append(paddingFFs.begin(), bytesLeft);
															#line 1666 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NewBlockActor1*>(this)->actor_wait_state = 1;
															#line 1666 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 0, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NewBlockActor1State();
		static_cast<NewBlockActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1669 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (final)
															#line 11158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1670 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 1671 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<NewBlockActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockActor1State(); static_cast<NewBlockActor1*>(this)->destroy(); return 0; }
															#line 11164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<NewBlockActor1*>(this)->SAV< Void >::value()) Void(Void());
			this->~NewBlockActor1State();
			static_cast<NewBlockActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1675 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->blockEnd += self->blockSize;
															#line 1678 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append((uint8_t*)&self->fileVersion, sizeof(self->fileVersion));
															#line 1678 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<NewBlockActor1*>(this)->actor_wait_state = 2;
															#line 1678 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 1, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state > 0) static_cast<NewBlockActor1*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor1*>(this)->ActorCallback< NewBlockActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NewBlockActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1681 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->blockEnd > self->blockSize)
															#line 11277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1682 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1682 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<NewBlockActor1*>(this)->actor_wait_state = 3;
															#line 1682 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 2, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1681 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->blockEnd > self->blockSize)
															#line 11302 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1682 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1682 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<NewBlockActor1*>(this)->actor_wait_state = 3;
															#line 1682 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 2, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state > 0) static_cast<NewBlockActor1*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor1*>(this)->ActorCallback< NewBlockActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NewBlockActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1688 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->file->size() + bytesNeeded > self->blockEnd)
															#line 11402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1689 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_bad_block_size(), loopDepth);
															#line 11406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 1691 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<NewBlockActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NewBlockActor1State(); static_cast<NewBlockActor1*>(this)->destroy(); return 0; }
															#line 11410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<NewBlockActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~NewBlockActor1State();
		static_cast<NewBlockActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1683 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1683 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<NewBlockActor1*>(this)->actor_wait_state = 4;
															#line 1683 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 3, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1683 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(self->lastKey);
															#line 1683 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<NewBlockActor1*>(this)->actor_wait_state = 4;
															#line 1683 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 3, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state > 0) static_cast<NewBlockActor1*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor1*>(this)->ActorCallback< NewBlockActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< NewBlockActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 1684 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->file->appendStringRefWithLen(self->lastValue);
															#line 1684 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<NewBlockActor1*>(this)->actor_wait_state = 5;
															#line 1684 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 4, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 1684 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->file->appendStringRefWithLen(self->lastValue);
															#line 1684 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<NewBlockActor1*>(this)->actor_wait_state = 5;
															#line 1684 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< NewBlockActor1, 4, Void >*>(static_cast<NewBlockActor1*>(this)));
															#line 11552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state > 0) static_cast<NewBlockActor1*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor1*>(this)->ActorCallback< NewBlockActor1, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< NewBlockActor1, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<NewBlockActor1*>(this)->actor_wait_state > 0) static_cast<NewBlockActor1*>(this)->actor_wait_state = 0;
		static_cast<NewBlockActor1*>(this)->ActorCallback< NewBlockActor1, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< NewBlockActor1, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< NewBlockActor1, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1661 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RangeFileWriter* self;
															#line 1661 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int bytesNeeded;
															#line 1661 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool final;
															#line 1665 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value paddingFFs;
															#line 11727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via newBlock()
															#line 1661 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class NewBlockActor1 final : public Actor<Void>, public ActorCallback< NewBlockActor1, 0, Void >, public ActorCallback< NewBlockActor1, 1, Void >, public ActorCallback< NewBlockActor1, 2, Void >, public ActorCallback< NewBlockActor1, 3, Void >, public ActorCallback< NewBlockActor1, 4, Void >, public FastAllocated<NewBlockActor1>, public NewBlockActor1State<NewBlockActor1> {
															#line 11732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<NewBlockActor1>::operator new;
	using FastAllocated<NewBlockActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14757043000591768064UL, 8064978558596008192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NewBlockActor1, 0, Void >;
friend struct ActorCallback< NewBlockActor1, 1, Void >;
friend struct ActorCallback< NewBlockActor1, 2, Void >;
friend struct ActorCallback< NewBlockActor1, 3, Void >;
friend struct ActorCallback< NewBlockActor1, 4, Void >;
															#line 1661 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	NewBlockActor1(RangeFileWriter* const& self,int const& bytesNeeded,bool const& final = false) 
															#line 11753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   NewBlockActor1State<NewBlockActor1>(self, bytesNeeded, final),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2007484470230468096UL, 2771688764731692544UL);
		ActorExecutionContextHelper __helper(static_cast<NewBlockActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NewBlockActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< NewBlockActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< NewBlockActor1, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< NewBlockActor1, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< NewBlockActor1, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1661 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> newBlock( RangeFileWriter* const& self, int const& bytesNeeded, bool const& final = false ) {
															#line 1661 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new NewBlockActor1(self, bytesNeeded, final));
															#line 11789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1693 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	// Used in simulation only to create backup file sizes which are an integer multiple of the block size
	Future<Void> padEnd(bool final) {
		ASSERT(g_network->isSimulated());
		if (file->size() > 0) {
			return newBlock(this, 0, final);
		}
		return Void();
	}

	// Ends the current block if necessary based on bytesNeeded.
	Future<Void> newBlockIfNeeded(int bytesNeeded) {
		if (file->size() + bytesNeeded > blockEnd)
			return newBlock(this, bytesNeeded);
		return Void();
	}

	// Start a new block if needed, then write the key and value
																#line 11811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via writeKV_impl()
															#line 1711 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKV_implActor1>
															#line 1711 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor1State {
															#line 11817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1711 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor1State(RangeFileWriter* const& self,Key const& k,Value const& v) 
															#line 1711 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1711 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1711 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k),
															#line 1711 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   v(v)
															#line 11828 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKV_implActor1State() 
	{
		fdb_probe_actor_destroy("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1712 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int toWrite = sizeof(int32_t) + k.size() + sizeof(int32_t) + v.size();
															#line 1713 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->newBlockIfNeeded(toWrite);
															#line 1713 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 1;
															#line 1713 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 0, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 11852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKV_implActor1State();
		static_cast<WriteKV_implActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1714 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1714 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 2;
															#line 1714 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 1, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 11882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1714 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1714 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 2;
															#line 1714 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 1, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 11898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor1*>(this)->ActorCallback< WriteKV_implActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1715 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(v);
															#line 1715 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 3;
															#line 1715 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 2, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 11989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1715 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(v);
															#line 1715 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 3;
															#line 1715 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor1, 2, Void >*>(static_cast<WriteKV_implActor1*>(this)));
															#line 12005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor1*>(this)->ActorCallback< WriteKV_implActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1716 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1717 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastValue = v;
															#line 1718 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActor1State(); static_cast<WriteKV_implActor1*>(this)->destroy(); return 0; }
															#line 12093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<WriteKV_implActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActor1State();
		static_cast<WriteKV_implActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1716 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastKey = k;
															#line 1717 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->lastValue = v;
															#line 1718 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActor1State(); static_cast<WriteKV_implActor1*>(this)->destroy(); return 0; }
															#line 12109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<WriteKV_implActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActor1State();
		static_cast<WriteKV_implActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteKV_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor1*>(this)->ActorCallback< WriteKV_implActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1711 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RangeFileWriter* self;
															#line 1711 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 1711 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value v;
															#line 12198 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via writeKV_impl()
															#line 1711 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor1 final : public Actor<Void>, public ActorCallback< WriteKV_implActor1, 0, Void >, public ActorCallback< WriteKV_implActor1, 1, Void >, public ActorCallback< WriteKV_implActor1, 2, Void >, public FastAllocated<WriteKV_implActor1>, public WriteKV_implActor1State<WriteKV_implActor1> {
															#line 12203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<WriteKV_implActor1>::operator new;
	using FastAllocated<WriteKV_implActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6315819753271108352UL, 6682033703558460416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKV_implActor1, 0, Void >;
friend struct ActorCallback< WriteKV_implActor1, 1, Void >;
friend struct ActorCallback< WriteKV_implActor1, 2, Void >;
															#line 1711 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor1(RangeFileWriter* const& self,Key const& k,Value const& v) 
															#line 12222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   WriteKV_implActor1State<WriteKV_implActor1>(self, k, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16217267337946238464UL, 13255526101699148288UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKV_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKV_implActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKV_implActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteKV_implActor1, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1711 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKV_impl( RangeFileWriter* const& self, Key const& k, Value const& v ) {
															#line 1711 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKV_implActor1(self, k, v));
															#line 12256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1720 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKV(Key k, Value v) { return writeKV_impl(this, k, v); }

	// Write begin key or end key.
																#line 12264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via writeKey_impl()
															#line 1724 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKey_implActor1>
															#line 1724 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKey_implActor1State {
															#line 12270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1724 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKey_implActor1State(RangeFileWriter* const& self,Key const& k) 
															#line 1724 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1724 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1724 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k)
															#line 12279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("writeKey_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKey_implActor1State() 
	{
		fdb_probe_actor_destroy("writeKey_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1725 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int toWrite = sizeof(uint32_t) + k.size();
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->newBlockIfNeeded(toWrite);
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<WriteKey_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteKey_implActor1*>(this)->actor_wait_state = 1;
															#line 1726 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor1, 0, Void >*>(static_cast<WriteKey_implActor1*>(this)));
															#line 12303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKey_implActor1State();
		static_cast<WriteKey_implActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1727 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1727 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKey_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKey_implActor1*>(this)->actor_wait_state = 2;
															#line 1727 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor1, 1, Void >*>(static_cast<WriteKey_implActor1*>(this)));
															#line 12333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1727 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->appendStringRefWithLen(k);
															#line 1727 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKey_implActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKey_implActor1*>(this)->actor_wait_state = 2;
															#line 1727 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKey_implActor1, 1, Void >*>(static_cast<WriteKey_implActor1*>(this)));
															#line 12349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKey_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKey_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKey_implActor1*>(this)->ActorCallback< WriteKey_implActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKey_implActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1728 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKey_implActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActor1State(); static_cast<WriteKey_implActor1*>(this)->destroy(); return 0; }
															#line 12433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<WriteKey_implActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKey_implActor1State();
		static_cast<WriteKey_implActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1728 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKey_implActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKey_implActor1State(); static_cast<WriteKey_implActor1*>(this)->destroy(); return 0; }
															#line 12445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<WriteKey_implActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKey_implActor1State();
		static_cast<WriteKey_implActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKey_implActor1*>(this)->actor_wait_state > 0) static_cast<WriteKey_implActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteKey_implActor1*>(this)->ActorCallback< WriteKey_implActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKey_implActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKey_implActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1724 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	RangeFileWriter* self;
															#line 1724 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 12532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via writeKey_impl()
															#line 1724 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKey_implActor1 final : public Actor<Void>, public ActorCallback< WriteKey_implActor1, 0, Void >, public ActorCallback< WriteKey_implActor1, 1, Void >, public FastAllocated<WriteKey_implActor1>, public WriteKey_implActor1State<WriteKey_implActor1> {
															#line 12537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<WriteKey_implActor1>::operator new;
	using FastAllocated<WriteKey_implActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11821968909654055424UL, 11922910546924800768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKey_implActor1, 0, Void >;
friend struct ActorCallback< WriteKey_implActor1, 1, Void >;
															#line 1724 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKey_implActor1(RangeFileWriter* const& self,Key const& k) 
															#line 12555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   WriteKey_implActor1State<WriteKey_implActor1>(self, k),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKey_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3399269857036320000UL, 6984076183881784832UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKey_implActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKey_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKey_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKey_implActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKey_implActor1, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1724 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKey_impl( RangeFileWriter* const& self, Key const& k ) {
															#line 1724 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKey_implActor1(self, k));
															#line 12588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1730 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKey(Key k) { return writeKey_impl(this, k); }

	Future<Void> finish() { return Void(); }

	Reference<IBackupFile> file;
	int blockSize;

private:
	int64_t blockEnd;
	uint32_t fileVersion;
	Key lastKey;
	Key lastValue;
};

															#line 12607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via decodeKVPairs()
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class DecodeKVPairsActor>
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeKVPairsActorState {
															#line 12613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeKVPairsActorState(StringRefReader* const& reader,Standalone<VectorRef<KeyValueRef>>* const& results,bool const& encryptedBlock,EncryptionAtRestMode const& encryptMode,Optional<int64_t> const& blockDomainId,Optional<Reference<TenantEntryCache<Void>>> const& tenantCache) 
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : reader(reader),
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   results(results),
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   encryptedBlock(encryptedBlock),
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   encryptMode(encryptMode),
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   blockDomainId(blockDomainId),
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tenantCache(tenantCache),
															#line 1752 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   kLen(reader->consumeNetworkUInt32()),
															#line 1753 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(reader->consume(kLen))
															#line 12634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("decodeKVPairs", reinterpret_cast<unsigned long>(this));

	}
	~DecodeKVPairsActorState() 
	{
		fdb_probe_actor_destroy("decodeKVPairs", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1754 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results->push_back(results->arena(), KeyValueRef(KeyRef(k, kLen), ValueRef()));
															#line 1755 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			prevKey = KeyRef(k, kLen);
															#line 1756 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			done = false;
															#line 1757 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			prevDomainId = Optional<EncryptCipherDomainId>();
															#line 1759 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			;
															#line 12657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DecodeKVPairsActorState();
		static_cast<DecodeKVPairsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1825 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto b : reader->remainder() ) {
															#line 1826 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (b != 0xFF)
															#line 12682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1827 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				return a_body1Catch1(restore_corrupted_data_padding(), loopDepth);
															#line 12686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			}
		}
															#line 1829 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<DecodeKVPairsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DecodeKVPairsActorState(); static_cast<DecodeKVPairsActor*>(this)->destroy(); return 0; }
															#line 12691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<DecodeKVPairsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DecodeKVPairsActorState();
		static_cast<DecodeKVPairsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1761 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		kLen = reader->consumeNetworkUInt32();
															#line 1762 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		k = reader->consume(kLen);
															#line 1766 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (encryptedBlock && g_network && g_network->isSimulated())
															#line 12714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1767 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(blockDomainId.present());
															#line 1768 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			curKey = KeyRef(k, kLen);
															#line 1769 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!prevDomainId.present())
															#line 12722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1770 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<EncryptCipherDomainId> __when_expr_0 = EncryptedRangeFileWriter::getEncryptionDomainDetails( prevKey, encryptMode, tenantCache, SnapshotBackupUseTenantCache::False);
															#line 1770 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<DecodeKVPairsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DecodeKVPairsActor*>(this)->actor_wait_state = 1;
															#line 1770 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DecodeKVPairsActor, 0, EncryptCipherDomainId >*>(static_cast<DecodeKVPairsActor*>(this)));
															#line 12733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1796 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (reader->eof() || *reader->rptr == 0xFF)
															#line 12765 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1797 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results->push_back(results->arena(), KeyValueRef(KeyRef(k, kLen), ValueRef()));
															#line 12769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1802 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		vLen = reader->consumeNetworkUInt32();
															#line 1803 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		v = reader->consume(vLen);
															#line 1804 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (tenantCache.present() && !isSystemKey(KeyRef(k, kLen)))
															#line 12778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1805 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tenantId = TenantAPI::extractTenantIdFromKeyRef(StringRef(k, kLen));
															#line 1806 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Optional<TenantEntryCachePayload<Void>>> __when_expr_3 = tenantCache.get()->getById(tenantId);
															#line 1806 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<DecodeKVPairsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<DecodeKVPairsActor*>(this)->actor_wait_state = 4;
															#line 1806 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DecodeKVPairsActor, 3, Optional<TenantEntryCachePayload<Void>> >*>(static_cast<DecodeKVPairsActor*>(this)));
															#line 12791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1816 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results->push_back(results->arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));
															#line 12798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = a_body1loopBody1cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1774 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<EncryptCipherDomainId> __when_expr_1 = EncryptedRangeFileWriter::getEncryptionDomainDetails( curKey, encryptMode, tenantCache, SnapshotBackupUseTenantCache::False);
															#line 1774 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<DecodeKVPairsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DecodeKVPairsActor*>(this)->actor_wait_state = 2;
															#line 1774 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DecodeKVPairsActor, 1, EncryptCipherDomainId >*>(static_cast<DecodeKVPairsActor*>(this)));
															#line 12815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(EncryptCipherDomainId const& domainId,int loopDepth) 
	{
															#line 1772 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		prevDomainId = domainId;
															#line 12824 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(EncryptCipherDomainId && domainId,int loopDepth) 
	{
															#line 1772 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		prevDomainId = domainId;
															#line 12833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(EncryptCipherDomainId const& domainId,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(domainId, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(EncryptCipherDomainId && domainId,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(domainId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DecodeKVPairsActor*>(this)->actor_wait_state > 0) static_cast<DecodeKVPairsActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeKVPairsActor*>(this)->ActorCallback< DecodeKVPairsActor, 0, EncryptCipherDomainId >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeKVPairsActor, 0, EncryptCipherDomainId >*,EncryptCipherDomainId const& value) 
	{
		fdb_probe_actor_enter("decodeKVPairs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeKVPairsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeKVPairs", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DecodeKVPairsActor, 0, EncryptCipherDomainId >*,EncryptCipherDomainId && value) 
	{
		fdb_probe_actor_enter("decodeKVPairs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeKVPairsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeKVPairs", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DecodeKVPairsActor, 0, EncryptCipherDomainId >*,Error err) 
	{
		fdb_probe_actor_enter("decodeKVPairs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeKVPairsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeKVPairs", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 1776 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!curKey.empty() && !prevKey.empty() && prevDomainId.get() != curDomainId)
															#line 12917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1777 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(!done);
															#line 1779 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (curDomainId != SYSTEM_KEYSPACE_ENCRYPT_DOMAIN_ID && curDomainId != FDB_DEFAULT_ENCRYPT_DOMAIN_ID && curKey.size() != TenantAPI::PREFIX_SIZE)
															#line 12923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1781 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ASSERT(tenantCache.present());
															#line 1782 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Optional<TenantEntryCachePayload<Void>>> __when_expr_2 = tenantCache.get()->getById(curDomainId);
															#line 1782 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<DecodeKVPairsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont5when1(__when_expr_2.get(), loopDepth); };
				static_cast<DecodeKVPairsActor*>(this)->actor_wait_state = 3;
															#line 1782 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DecodeKVPairsActor, 2, Optional<TenantEntryCachePayload<Void>> >*>(static_cast<DecodeKVPairsActor*>(this)));
															#line 12936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont7(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(EncryptCipherDomainId const& __curDomainId,int loopDepth) 
	{
															#line 1774 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		curDomainId = __curDomainId;
															#line 12955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(EncryptCipherDomainId && __curDomainId,int loopDepth) 
	{
		curDomainId = std::move(__curDomainId);
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DecodeKVPairsActor*>(this)->actor_wait_state > 0) static_cast<DecodeKVPairsActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeKVPairsActor*>(this)->ActorCallback< DecodeKVPairsActor, 1, EncryptCipherDomainId >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeKVPairsActor, 1, EncryptCipherDomainId >*,EncryptCipherDomainId const& value) 
	{
		fdb_probe_actor_enter("decodeKVPairs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeKVPairsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeKVPairs", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DecodeKVPairsActor, 1, EncryptCipherDomainId >*,EncryptCipherDomainId && value) 
	{
		fdb_probe_actor_enter("decodeKVPairs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeKVPairsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeKVPairs", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DecodeKVPairsActor, 1, EncryptCipherDomainId >*,Error err) 
	{
		fdb_probe_actor_enter("decodeKVPairs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeKVPairsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeKVPairs", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 1788 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (blockDomainId.get() != FDB_DEFAULT_ENCRYPT_DOMAIN_ID && !prevKey.empty())
															#line 13034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1789 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT_EQ(prevDomainId.get(), blockDomainId.get());
															#line 13038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 1791 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		prevKey = curKey;
															#line 1792 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		prevDomainId = curDomainId;
															#line 13044 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
															#line 1785 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		done = true;
															#line 13053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Optional<TenantEntryCachePayload<Void>> const& payload,int loopDepth) 
	{
															#line 1783 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(!payload.present());
															#line 13062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Optional<TenantEntryCachePayload<Void>> && payload,int loopDepth) 
	{
															#line 1783 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		ASSERT(!payload.present());
															#line 13071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Optional<TenantEntryCachePayload<Void>> const& payload,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(payload, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Optional<TenantEntryCachePayload<Void>> && payload,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(payload), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DecodeKVPairsActor*>(this)->actor_wait_state > 0) static_cast<DecodeKVPairsActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeKVPairsActor*>(this)->ActorCallback< DecodeKVPairsActor, 2, Optional<TenantEntryCachePayload<Void>> >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeKVPairsActor, 2, Optional<TenantEntryCachePayload<Void>> >*,Optional<TenantEntryCachePayload<Void>> const& value) 
	{
		fdb_probe_actor_enter("decodeKVPairs", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeKVPairsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeKVPairs", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DecodeKVPairsActor, 2, Optional<TenantEntryCachePayload<Void>> >*,Optional<TenantEntryCachePayload<Void>> && value) 
	{
		fdb_probe_actor_enter("decodeKVPairs", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeKVPairsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeKVPairs", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DecodeKVPairsActor, 2, Optional<TenantEntryCachePayload<Void>> >*,Error err) 
	{
		fdb_probe_actor_enter("decodeKVPairs", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeKVPairsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeKVPairs", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont13(int loopDepth) 
	{
															#line 1820 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (reader->eof() || *reader->rptr == 0xFF)
															#line 13155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont15(Optional<TenantEntryCachePayload<Void>> const& payload,int loopDepth) 
	{
															#line 1809 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!payload.present() && !(reader->eof() || *reader->rptr == 0xFF))
															#line 13167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1810 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarnAlways, "SnapshotRestoreTenantNotFound").detail("TenantId", tenantId);
															#line 1811 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			CODE_PROBE(true, "Snapshot restore tenant not found");
															#line 13173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		else
		{
															#line 1813 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results->push_back(results->arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));
															#line 13179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont15(Optional<TenantEntryCachePayload<Void>> && payload,int loopDepth) 
	{
															#line 1809 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!payload.present() && !(reader->eof() || *reader->rptr == 0xFF))
															#line 13189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1810 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarnAlways, "SnapshotRestoreTenantNotFound").detail("TenantId", tenantId);
															#line 1811 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			CODE_PROBE(true, "Snapshot restore tenant not found");
															#line 13195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		else
		{
															#line 1813 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results->push_back(results->arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));
															#line 13201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Optional<TenantEntryCachePayload<Void>> const& payload,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(payload, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Optional<TenantEntryCachePayload<Void>> && payload,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(std::move(payload), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DecodeKVPairsActor*>(this)->actor_wait_state > 0) static_cast<DecodeKVPairsActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeKVPairsActor*>(this)->ActorCallback< DecodeKVPairsActor, 3, Optional<TenantEntryCachePayload<Void>> >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeKVPairsActor, 3, Optional<TenantEntryCachePayload<Void>> >*,Optional<TenantEntryCachePayload<Void>> const& value) 
	{
		fdb_probe_actor_enter("decodeKVPairs", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeKVPairsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeKVPairs", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DecodeKVPairsActor, 3, Optional<TenantEntryCachePayload<Void>> >*,Optional<TenantEntryCachePayload<Void>> && value) 
	{
		fdb_probe_actor_enter("decodeKVPairs", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeKVPairsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeKVPairs", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DecodeKVPairsActor, 3, Optional<TenantEntryCachePayload<Void>> >*,Error err) 
	{
		fdb_probe_actor_enter("decodeKVPairs", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeKVPairsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeKVPairs", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StringRefReader* reader;
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<KeyValueRef>>* results;
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool encryptedBlock;
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptionAtRestMode encryptMode;
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Optional<int64_t> blockDomainId;
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Optional<Reference<TenantEntryCache<Void>>> tenantCache;
															#line 1752 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	uint32_t kLen;
															#line 1753 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	const uint8_t* k;
															#line 1755 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyRef prevKey;
															#line 1756 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool done;
															#line 1757 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Optional<EncryptCipherDomainId> prevDomainId;
															#line 1768 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyRef curKey;
															#line 1774 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptCipherDomainId curDomainId;
															#line 1802 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	uint32_t vLen;
															#line 1803 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	const uint8_t* v;
															#line 1805 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t tenantId;
															#line 13314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via decodeKVPairs()
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeKVPairsActor final : public Actor<Void>, public ActorCallback< DecodeKVPairsActor, 0, EncryptCipherDomainId >, public ActorCallback< DecodeKVPairsActor, 1, EncryptCipherDomainId >, public ActorCallback< DecodeKVPairsActor, 2, Optional<TenantEntryCachePayload<Void>> >, public ActorCallback< DecodeKVPairsActor, 3, Optional<TenantEntryCachePayload<Void>> >, public FastAllocated<DecodeKVPairsActor>, public DecodeKVPairsActorState<DecodeKVPairsActor> {
															#line 13319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<DecodeKVPairsActor>::operator new;
	using FastAllocated<DecodeKVPairsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10542104386308599296UL, 4861266351553323776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DecodeKVPairsActor, 0, EncryptCipherDomainId >;
friend struct ActorCallback< DecodeKVPairsActor, 1, EncryptCipherDomainId >;
friend struct ActorCallback< DecodeKVPairsActor, 2, Optional<TenantEntryCachePayload<Void>> >;
friend struct ActorCallback< DecodeKVPairsActor, 3, Optional<TenantEntryCachePayload<Void>> >;
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeKVPairsActor(StringRefReader* const& reader,Standalone<VectorRef<KeyValueRef>>* const& results,bool const& encryptedBlock,EncryptionAtRestMode const& encryptMode,Optional<int64_t> const& blockDomainId,Optional<Reference<TenantEntryCache<Void>>> const& tenantCache) 
															#line 13339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   DecodeKVPairsActorState<DecodeKVPairsActor>(reader, results, encryptedBlock, encryptMode, blockDomainId, tenantCache),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("decodeKVPairs", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12078064224861891072UL, 14148054253523386880UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeKVPairsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("decodeKVPairs");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("decodeKVPairs", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DecodeKVPairsActor, 0, EncryptCipherDomainId >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DecodeKVPairsActor, 1, EncryptCipherDomainId >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DecodeKVPairsActor, 2, Optional<TenantEntryCachePayload<Void>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DecodeKVPairsActor, 3, Optional<TenantEntryCachePayload<Void>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> decodeKVPairs( StringRefReader* const& reader, Standalone<VectorRef<KeyValueRef>>* const& results, bool const& encryptedBlock, EncryptionAtRestMode const& encryptMode, Optional<int64_t> const& blockDomainId, Optional<Reference<TenantEntryCache<Void>>> const& tenantCache ) {
															#line 1745 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new DecodeKVPairsActor(reader, results, encryptedBlock, encryptMode, blockDomainId, tenantCache));
															#line 13374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1831 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

static Reference<IBackupContainer> getBackupContainerWithProxy(Reference<IBackupContainer> _bc) {
	Reference<IBackupContainer> bc = IBackupContainer::openContainer(_bc->getURL(), fileBackupAgentProxy, {});
	return bc;
}

Standalone<VectorRef<KeyValueRef>> decodeRangeFileBlock(const Standalone<StringRef>& buf) {
	Standalone<VectorRef<KeyValueRef>> results({}, buf.arena());
	StringRefReader reader(buf, restore_corrupted_data());

	// Read header, currently only decoding BACKUP_AGENT_SNAPSHOT_FILE_VERSION
	if (reader.consume<int32_t>() != BACKUP_AGENT_SNAPSHOT_FILE_VERSION)
		throw restore_unsupported_file_version();

	// Read begin key, if this fails then block was invalid.
	uint32_t beginKeyLen = reader.consumeNetworkUInt32();
	const uint8_t* beginKey = reader.consume(beginKeyLen);
	results.push_back(results.arena(), KeyValueRef(KeyRef(beginKey, beginKeyLen), ValueRef()));

	// Read kv pairs and end key
	while (1) {
		// If eof reached or first value len byte is 0xFF then a valid block end was reached.
		if (reader.eof() || *reader.rptr == 0xFF) {
			break;
		}

		// Read a key, which must exist or the block is invalid
		uint32_t kLen = reader.consumeNetworkUInt32();
		const uint8_t* k = reader.consume(kLen);

		// If eof reached or first value len byte is 0xFF then a valid block end was reached.
		if (reader.eof() || *reader.rptr == 0xFF) {
			// The last block in the file, will have Read End key.
			results.push_back(results.arena(), KeyValueRef(KeyRef(k, kLen), ValueRef()));
			break;
		}

		// Read a value, which must exist or the block is invalid
		uint32_t vLen = reader.consumeNetworkUInt32();
		const uint8_t* v = reader.consume(vLen);
		results.push_back(results.arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));
	}

	// Make sure any remaining bytes in the block are 0xFF
	for (auto b : reader.remainder())
		if (b != 0xFF)
			throw restore_corrupted_data_padding();

	return results;
}

															#line 13429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via decodeRangeFileBlock()
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class DecodeRangeFileBlockActor>
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeRangeFileBlockActorState {
															#line 13435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeRangeFileBlockActorState(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len,Database const& cx) 
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : file(file),
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   offset(offset),
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   len(len),
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   cx(cx),
															#line 1886 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   buf(makeString(len))
															#line 13450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this));

	}
	~DecodeRangeFileBlockActorState() 
	{
		fdb_probe_actor_destroy("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1887 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<int> __when_expr_0 = uncancellable(holdWhile(buf, file->read(mutateString(buf), len, offset)));
															#line 1887 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 1;
															#line 1887 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 0, int >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 13472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DecodeRangeFileBlockActorState();
		static_cast<DecodeRangeFileBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& rLen,int loopDepth) 
	{
															#line 1888 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 13495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1889 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 13499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 1891 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		simulateBlobFailure();
															#line 1893 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		results = Standalone<VectorRef<KeyValueRef>>({}, buf.arena());
															#line 1894 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		reader = StringRefReader(buf, restore_corrupted_data());
															#line 1895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		arena = Arena();
															#line 1896 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<DatabaseConfiguration> __when_expr_1 = getDatabaseConfiguration(cx);
															#line 1896 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 2;
															#line 1896 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 13518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int && rLen,int loopDepth) 
	{
															#line 1888 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 13527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1889 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 13531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 1891 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		simulateBlobFailure();
															#line 1893 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		results = Standalone<VectorRef<KeyValueRef>>({}, buf.arena());
															#line 1894 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		reader = StringRefReader(buf, restore_corrupted_data());
															#line 1895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		arena = Arena();
															#line 1896 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<DatabaseConfiguration> __when_expr_1 = getDatabaseConfiguration(cx);
															#line 1896 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 2;
															#line 1896 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 13550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(int const& rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(rLen, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(rLen), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeRangeFileBlockActor*>(this)->ActorCallback< DecodeRangeFileBlockActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DecodeRangeFileBlockActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1897 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tenantCache = Optional<Reference<TenantEntryCache<Void>>>();
															#line 1898 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (config.tenantMode == TenantMode::REQUIRED)
															#line 13636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1899 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tenantCache = makeReference<TenantEntryCache<Void>>(cx, TenantEntryCacheRefreshMode::WATCH);
															#line 1900 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tenantCache.get()->init();
															#line 1900 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13644 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 3;
															#line 1900 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 2, Void >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 13649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 1896 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		config = __config;
															#line 13663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeRangeFileBlockActor*>(this)->ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1902 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		encryptMode = config.encryptionAtRestMode;
															#line 1903 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		blockDomainId = TenantInfo::INVALID_TENANT;
															#line 13744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		try {
															#line 1908 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int32_t file_version = reader.consume<int32_t>();
															#line 1909 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ASSERT(!encryptMode.isEncryptionEnabled() || file_version == BACKUP_AGENT_ENCRYPTED_SNAPSHOT_FILE_VERSION);
															#line 1910 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (file_version == BACKUP_AGENT_SNAPSHOT_FILE_VERSION)
															#line 13752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1911 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				StrictFuture<Void> __when_expr_3 = decodeKVPairs(&reader, &results, false, encryptMode, Optional<int64_t>(), tenantCache);
															#line 1911 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1cont4Catch1(actor_cancelled(), loopDepth);
															#line 13758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont4Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
				static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 4;
															#line 1911 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 3, Void >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 13763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1912 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (file_version == BACKUP_AGENT_ENCRYPTED_SNAPSHOT_FILE_VERSION)
															#line 13770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				{
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					CODE_PROBE(true, "decoding encrypted block", probe::decoration::rare);
															#line 1915 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					headerLen = reader.consume<uint32_t>();
															#line 1917 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					headerStart = reader.consume(headerLen);
															#line 1918 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					StringRef headerS = StringRef(headerStart, headerLen);
															#line 1919 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					encryptHeader = BlobCipherEncryptHeaderRef();
															#line 1921 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					encryptHeader = BlobCipherEncryptHeaderRef::fromStringRef(headerS);
															#line 1922 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					blockDomainId = encryptHeader.getCipherDetails().textCipherDetails.encryptDomainId;
															#line 1924 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					if (config.tenantMode == TenantMode::REQUIRED && !isReservedEncryptDomain(blockDomainId))
															#line 13788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
					{
															#line 1925 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
						ASSERT(tenantCache.present());
															#line 1926 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
						StrictFuture<Optional<TenantEntryCachePayload<Void>>> __when_expr_4 = tenantCache.get()->getById(blockDomainId);
															#line 1926 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
						if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1cont4Catch1(actor_cancelled(), loopDepth);
															#line 13796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
						if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont4Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when2(__when_expr_4.get(), loopDepth); };
						static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 5;
															#line 1926 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
						__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 4, Optional<TenantEntryCachePayload<Void>> >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 13801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont10(loopDepth);
					}
				}
				else
				{
															#line 1941 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					return a_body1cont4Catch1(restore_unsupported_file_version(), loopDepth);
															#line 13813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeRangeFileBlockActor*>(this)->ActorCallback< DecodeRangeFileBlockActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DecodeRangeFileBlockActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1945 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (e.code() == error_code_encrypt_keys_fetch_failed || e.code() == error_code_encrypt_key_not_found)
															#line 13917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1946 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				ASSERT(!isReservedEncryptDomain(blockDomainId));
															#line 1947 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarnAlways, "SnapshotRestoreEncryptKeyFetchFailed").detail("TenantId", blockDomainId);
															#line 1948 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				CODE_PROBE(true, "Snapshot restore encrypt keys not found", probe::decoration::rare);
															#line 13925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			}
			else
			{
															#line 1949 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (e.code() == error_code_tenant_not_found)
															#line 13931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				{
															#line 1950 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					ASSERT(!isReservedEncryptDomain(blockDomainId));
															#line 1951 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					TraceEvent(SevWarnAlways, "EncryptedSnapshotRestoreTenantNotFound").detail("TenantId", blockDomainId);
															#line 1952 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					CODE_PROBE(true, "Encrypted Snapshot restore tenant not found", probe::decoration::rare);
															#line 13939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				}
			}
															#line 1954 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileRestoreDecodeRangeFileBlockFailed") .error(e) .detail("Filename", file->getFilename()) .detail("BlockOffset", offset) .detail("BlockLen", len) .detail("ErrorRelativeOffset", reader.rptr - buf.begin()) .detail("ErrorAbsoluteOffset", reader.rptr - buf.begin() + offset);
															#line 1961 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 13946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1943 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<DecodeRangeFileBlockActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(results); this->~DecodeRangeFileBlockActorState(); static_cast<DecodeRangeFileBlockActor*>(this)->destroy(); return 0; }
															#line 13960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<DecodeRangeFileBlockActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(std::move(results)); // state_var_RVO
		this->~DecodeRangeFileBlockActorState();
		static_cast<DecodeRangeFileBlockActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeRangeFileBlockActor*>(this)->ActorCallback< DecodeRangeFileBlockActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DecodeRangeFileBlockActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
															#line 1931 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		const uint8_t* dataPayloadStart = headerStart + headerLen;
															#line 1933 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int64_t bytesRead = sizeof(int32_t) + sizeof(uint32_t) + headerLen;
															#line 1935 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		int64_t dataLen = len - bytesRead;
															#line 1936 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<StringRef> __when_expr_5 = EncryptedRangeFileWriter::decrypt(cx, encryptHeader, dataPayloadStart, dataLen, &results.arena());
															#line 1936 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1cont4Catch1(actor_cancelled(), loopDepth);
															#line 14073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont4Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont10when1(__when_expr_5.get(), loopDepth); };
		static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 6;
															#line 1936 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 5, StringRef >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 14078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11(Optional<TenantEntryCachePayload<Void>> const& payload,int loopDepth) 
	{
															#line 1927 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!payload.present())
															#line 14087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1928 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1cont4Catch1(tenant_not_found(), loopDepth);
															#line 14091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Optional<TenantEntryCachePayload<Void>> && payload,int loopDepth) 
	{
															#line 1927 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!payload.present())
															#line 14101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1928 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1cont4Catch1(tenant_not_found(), loopDepth);
															#line 14105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when2(Optional<TenantEntryCachePayload<Void>> const& payload,int loopDepth) 
	{
		loopDepth = a_body1cont11(payload, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when2(Optional<TenantEntryCachePayload<Void>> && payload,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(payload), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeRangeFileBlockActor*>(this)->ActorCallback< DecodeRangeFileBlockActor, 4, Optional<TenantEntryCachePayload<Void>> >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 4, Optional<TenantEntryCachePayload<Void>> >*,Optional<TenantEntryCachePayload<Void>> const& value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 4, Optional<TenantEntryCachePayload<Void>> >*,Optional<TenantEntryCachePayload<Void>> && value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DecodeRangeFileBlockActor, 4, Optional<TenantEntryCachePayload<Void>> >*,Error err) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10cont1(StringRef const& decryptedData,int loopDepth) 
	{
															#line 1938 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		reader = StringRefReader(decryptedData, restore_corrupted_data());
															#line 1939 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_6 = decodeKVPairs(&reader, &results, true, encryptMode, blockDomainId, tenantCache);
															#line 1939 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1cont4Catch1(actor_cancelled(), loopDepth);
															#line 14194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont4Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 7;
															#line 1939 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 6, Void >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 14199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1(StringRef && decryptedData,int loopDepth) 
	{
															#line 1938 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		reader = StringRefReader(decryptedData, restore_corrupted_data());
															#line 1939 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_6 = decodeKVPairs(&reader, &results, true, encryptMode, blockDomainId, tenantCache);
															#line 1939 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state < 0) return a_body1cont4Catch1(actor_cancelled(), loopDepth);
															#line 14212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont4Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 7;
															#line 1939 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DecodeRangeFileBlockActor, 6, Void >*>(static_cast<DecodeRangeFileBlockActor*>(this)));
															#line 14217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(StringRef const& decryptedData,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(decryptedData, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(StringRef && decryptedData,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(decryptedData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeRangeFileBlockActor*>(this)->ActorCallback< DecodeRangeFileBlockActor, 5, StringRef >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 5, StringRef >*,StringRef const& value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 5, StringRef >*,StringRef && value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DecodeRangeFileBlockActor, 5, StringRef >*,Error err) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeRangeFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeRangeFileBlockActor*>(this)->ActorCallback< DecodeRangeFileBlockActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DecodeRangeFileBlockActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DecodeRangeFileBlockActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> file;
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t offset;
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int len;
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 1886 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<StringRef> buf;
															#line 1893 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> results;
															#line 1894 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StringRefReader reader;
															#line 1895 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Arena arena;
															#line 1896 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DatabaseConfiguration config;
															#line 1897 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Optional<Reference<TenantEntryCache<Void>>> tenantCache;
															#line 1902 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EncryptionAtRestMode encryptMode;
															#line 1903 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t blockDomainId;
															#line 1915 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	uint32_t headerLen;
															#line 1917 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	const uint8_t* headerStart;
															#line 1919 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BlobCipherEncryptHeaderRef encryptHeader;
															#line 14414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via decodeRangeFileBlock()
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeRangeFileBlockActor final : public Actor<Standalone<VectorRef<KeyValueRef>>>, public ActorCallback< DecodeRangeFileBlockActor, 0, int >, public ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >, public ActorCallback< DecodeRangeFileBlockActor, 2, Void >, public ActorCallback< DecodeRangeFileBlockActor, 3, Void >, public ActorCallback< DecodeRangeFileBlockActor, 4, Optional<TenantEntryCachePayload<Void>> >, public ActorCallback< DecodeRangeFileBlockActor, 5, StringRef >, public ActorCallback< DecodeRangeFileBlockActor, 6, Void >, public FastAllocated<DecodeRangeFileBlockActor>, public DecodeRangeFileBlockActorState<DecodeRangeFileBlockActor> {
															#line 14419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<DecodeRangeFileBlockActor>::operator new;
	using FastAllocated<DecodeRangeFileBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(699330945016901120UL, 1625256662520518656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyValueRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DecodeRangeFileBlockActor, 0, int >;
friend struct ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >;
friend struct ActorCallback< DecodeRangeFileBlockActor, 2, Void >;
friend struct ActorCallback< DecodeRangeFileBlockActor, 3, Void >;
friend struct ActorCallback< DecodeRangeFileBlockActor, 4, Optional<TenantEntryCachePayload<Void>> >;
friend struct ActorCallback< DecodeRangeFileBlockActor, 5, StringRef >;
friend struct ActorCallback< DecodeRangeFileBlockActor, 6, Void >;
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeRangeFileBlockActor(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len,Database const& cx) 
															#line 14442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Standalone<VectorRef<KeyValueRef>>>(),
		   DecodeRangeFileBlockActorState<DecodeRangeFileBlockActor>(file, offset, len, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16131528145190661120UL, 4810314581124466176UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeRangeFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("decodeRangeFileBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("decodeRangeFileBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DecodeRangeFileBlockActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DecodeRangeFileBlockActor, 1, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DecodeRangeFileBlockActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DecodeRangeFileBlockActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DecodeRangeFileBlockActor, 4, Optional<TenantEntryCachePayload<Void>> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DecodeRangeFileBlockActor, 5, StringRef >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DecodeRangeFileBlockActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<KeyValueRef>>> decodeRangeFileBlock( Reference<IAsyncFile> const& file, int64_t const& offset, int const& len, Database const& cx ) {
															#line 1882 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<KeyValueRef>>>(new DecodeRangeFileBlockActor(file, offset, len, cx));
															#line 14480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1964 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Very simple format compared to KeyRange files.
// Header, [Key, Value]... Key len
struct LogFileWriter {
	LogFileWriter(Reference<IBackupFile> file = Reference<IBackupFile>(), int blockSize = 0)
	  : file(file), blockSize(blockSize), blockEnd(0) {}

	// Start a new block if needed, then write the key and value
																#line 14492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via writeKV_impl()
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class WriteKV_implActor2>
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor2State {
															#line 14498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor2State(LogFileWriter* const& self,Key const& k,Value const& v) 
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : self(self),
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   k(k),
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   v(v)
															#line 14509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	~WriteKV_implActor2State() 
	{
		fdb_probe_actor_destroy("writeKV_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1974 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			int toWrite = sizeof(int32_t) + k.size() + sizeof(int32_t) + v.size();
															#line 1975 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (self->file->size() + toWrite > self->blockEnd)
															#line 14526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 1977 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				int bytesLeft = self->blockEnd - self->file->size();
															#line 1978 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (bytesLeft > 0)
															#line 14532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				{
															#line 1979 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					paddingFFs = makePadding(bytesLeft);
															#line 1980 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					StrictFuture<Void> __when_expr_0 = self->file->append(paddingFFs.begin(), bytesLeft);
															#line 1980 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 1;
															#line 1980 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor2, 0, Void >*>(static_cast<WriteKV_implActor2*>(this)));
															#line 14545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKV_implActor2State();
		static_cast<WriteKV_implActor2*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1990 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->file->appendStringRefWithLen(k);
															#line 1990 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 3;
															#line 1990 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor2, 2, Void >*>(static_cast<WriteKV_implActor2*>(this)));
															#line 14585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1984 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		self->blockEnd += self->blockSize;
															#line 1987 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->append((uint8_t*)&BACKUP_AGENT_MLOG_VERSION, sizeof(BACKUP_AGENT_MLOG_VERSION));
															#line 1987 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 2;
															#line 1987 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor2, 1, Void >*>(static_cast<WriteKV_implActor2*>(this)));
															#line 14603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor2*>(this)->ActorCallback< WriteKV_implActor2, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor2, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor2*>(this)->ActorCallback< WriteKV_implActor2, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor2, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1991 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(v);
															#line 1991 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 4;
															#line 1991 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor2, 3, Void >*>(static_cast<WriteKV_implActor2*>(this)));
															#line 14793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1991 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->file->appendStringRefWithLen(v);
															#line 1991 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 4;
															#line 1991 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteKV_implActor2, 3, Void >*>(static_cast<WriteKV_implActor2*>(this)));
															#line 14809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor2*>(this)->ActorCallback< WriteKV_implActor2, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor2, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->file->size() > self->blockEnd)
															#line 14893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1995 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_bad_block_size(), loopDepth);
															#line 14897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 1997 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActor2State(); static_cast<WriteKV_implActor2*>(this)->destroy(); return 0; }
															#line 14901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<WriteKV_implActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActor2State();
		static_cast<WriteKV_implActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (self->file->size() > self->blockEnd)
															#line 14913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 1995 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_bad_block_size(), loopDepth);
															#line 14917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 1997 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<WriteKV_implActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKV_implActor2State(); static_cast<WriteKV_implActor2*>(this)->destroy(); return 0; }
															#line 14921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<WriteKV_implActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKV_implActor2State();
		static_cast<WriteKV_implActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WriteKV_implActor2*>(this)->actor_wait_state > 0) static_cast<WriteKV_implActor2*>(this)->actor_wait_state = 0;
		static_cast<WriteKV_implActor2*>(this)->ActorCallback< WriteKV_implActor2, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WriteKV_implActor2, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WriteKV_implActor2, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	LogFileWriter* self;
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key k;
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value v;
															#line 1979 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Value paddingFFs;
															#line 15012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via writeKV_impl()
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class WriteKV_implActor2 final : public Actor<Void>, public ActorCallback< WriteKV_implActor2, 0, Void >, public ActorCallback< WriteKV_implActor2, 1, Void >, public ActorCallback< WriteKV_implActor2, 2, Void >, public ActorCallback< WriteKV_implActor2, 3, Void >, public FastAllocated<WriteKV_implActor2>, public WriteKV_implActor2State<WriteKV_implActor2> {
															#line 15017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<WriteKV_implActor2>::operator new;
	using FastAllocated<WriteKV_implActor2>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6315819753271108352UL, 6682033703558460416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKV_implActor2, 0, Void >;
friend struct ActorCallback< WriteKV_implActor2, 1, Void >;
friend struct ActorCallback< WriteKV_implActor2, 2, Void >;
friend struct ActorCallback< WriteKV_implActor2, 3, Void >;
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	WriteKV_implActor2(LogFileWriter* const& self,Key const& k,Value const& v) 
															#line 15037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   WriteKV_implActor2State<WriteKV_implActor2>(self, k, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1459114523673046528UL, 17997660117777869824UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKV_implActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKV_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKV_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKV_implActor2, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKV_implActor2, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteKV_implActor2, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WriteKV_implActor2, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> writeKV_impl( LogFileWriter* const& self, Key const& k, Value const& v ) {
															#line 1972 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new WriteKV_implActor2(self, k, v));
															#line 15072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 1999 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	Future<Void> writeKV(Key k, Value v) { return writeKV_impl(this, k, v); }

	Reference<IBackupFile> file;
	int blockSize;

private:
	int64_t blockEnd;
};

// input: a string of [param1, param2], [param1, param2] ..., [param1, param2]
// output: a vector of [param1, param2] after removing the length info
Standalone<VectorRef<KeyValueRef>> decodeMutationLogFileBlock(const Standalone<StringRef>& buf) {
	Standalone<VectorRef<KeyValueRef>> results({}, buf.arena());
	StringRefReader reader(buf, restore_corrupted_data());

	// Read header, currently only decoding version BACKUP_AGENT_MLOG_VERSION
	if (reader.consume<int32_t>() != BACKUP_AGENT_MLOG_VERSION)
		throw restore_unsupported_file_version();

	// Read k/v pairs.  Block ends either at end of last value exactly or with 0xFF as first key len byte.
	while (1) {
		// If eof reached or first key len bytes is 0xFF then end of block was reached.
		if (reader.eof() || *reader.rptr == 0xFF)
			break;

		// Read key and value.  If anything throws then there is a problem.
		uint32_t kLen = reader.consumeNetworkUInt32();
		const uint8_t* k = reader.consume(kLen);
		uint32_t vLen = reader.consumeNetworkUInt32();
		const uint8_t* v = reader.consume(vLen);

		results.push_back(results.arena(), KeyValueRef(KeyRef(k, kLen), ValueRef(v, vLen)));
	}

	// Make sure any remaining bytes in the block are 0xFF
	for (auto b : reader.remainder())
		if (b != 0xFF)
			throw restore_corrupted_data_padding();

	return results;
}

															#line 15119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via decodeMutationLogFileBlock()
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class DecodeMutationLogFileBlockActor>
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeMutationLogFileBlockActorState {
															#line 15125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeMutationLogFileBlockActorState(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len) 
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : file(file),
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   offset(offset),
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   len(len),
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   buf(makeString(len))
															#line 15138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this));

	}
	~DecodeMutationLogFileBlockActorState() 
	{
		fdb_probe_actor_destroy("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2046 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<int> __when_expr_0 = file->read(mutateString(buf), len, offset);
															#line 2046 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state = 1;
															#line 2046 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*>(static_cast<DecodeMutationLogFileBlockActor*>(this)));
															#line 15160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DecodeMutationLogFileBlockActorState();
		static_cast<DecodeMutationLogFileBlockActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& rLen,int loopDepth) 
	{
															#line 2047 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 15183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2048 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 15187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		try {
															#line 2051 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(decodeMutationLogFileBlock(buf)); this->~DecodeMutationLogFileBlockActorState(); static_cast<DecodeMutationLogFileBlockActor*>(this)->destroy(); return 0; }
															#line 15192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(decodeMutationLogFileBlock(buf));
			this->~DecodeMutationLogFileBlockActorState();
			static_cast<DecodeMutationLogFileBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(int && rLen,int loopDepth) 
	{
															#line 2047 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (rLen != len)
															#line 15210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2048 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(restore_bad_read(), loopDepth);
															#line 15214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		try {
															#line 2051 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(decodeMutationLogFileBlock(buf)); this->~DecodeMutationLogFileBlockActorState(); static_cast<DecodeMutationLogFileBlockActor*>(this)->destroy(); return 0; }
															#line 15219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<DecodeMutationLogFileBlockActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(decodeMutationLogFileBlock(buf));
			this->~DecodeMutationLogFileBlockActorState();
			static_cast<DecodeMutationLogFileBlockActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(int const& rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(rLen, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && rLen,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(rLen), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state > 0) static_cast<DecodeMutationLogFileBlockActor*>(this)->actor_wait_state = 0;
		static_cast<DecodeMutationLogFileBlockActor*>(this)->ActorCallback< DecodeMutationLogFileBlockActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2053 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileRestoreCorruptLogFileBlock") .error(e) .detail("Filename", file->getFilename()) .detail("BlockOffset", offset) .detail("BlockLen", len);
															#line 2058 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 15315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IAsyncFile> file;
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int64_t offset;
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int len;
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<StringRef> buf;
															#line 15333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via decodeMutationLogFileBlock()
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class DecodeMutationLogFileBlockActor final : public Actor<Standalone<VectorRef<KeyValueRef>>>, public ActorCallback< DecodeMutationLogFileBlockActor, 0, int >, public FastAllocated<DecodeMutationLogFileBlockActor>, public DecodeMutationLogFileBlockActorState<DecodeMutationLogFileBlockActor> {
															#line 15338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<DecodeMutationLogFileBlockActor>::operator new;
	using FastAllocated<DecodeMutationLogFileBlockActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10216492602818170368UL, 12205138114487918336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyValueRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DecodeMutationLogFileBlockActor, 0, int >;
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	DecodeMutationLogFileBlockActor(Reference<IAsyncFile> const& file,int64_t const& offset,int const& len) 
															#line 15355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Standalone<VectorRef<KeyValueRef>>>(),
		   DecodeMutationLogFileBlockActorState<DecodeMutationLogFileBlockActor>(file, offset, len),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10553348071887031296UL, 14129820410599961600UL);
		ActorExecutionContextHelper __helper(static_cast<DecodeMutationLogFileBlockActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("decodeMutationLogFileBlock");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("decodeMutationLogFileBlock", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DecodeMutationLogFileBlockActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<KeyValueRef>>> decodeMutationLogFileBlock( Reference<IAsyncFile> const& file, int64_t const& offset, int const& len ) {
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<KeyValueRef>>>(new DecodeMutationLogFileBlockActor(file, offset, len));
															#line 15387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 2061 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 15392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via checkTaskVersion()
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class CheckTaskVersionActor>
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class CheckTaskVersionActorState {
															#line 15398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	CheckTaskVersionActorState(Database const& cx,Reference<Task> const& task,StringRef const& name,uint32_t const& version) 
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : cx(cx),
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   name(name),
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(version)
															#line 15411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("checkTaskVersion", reinterpret_cast<unsigned long>(this));

	}
	~CheckTaskVersionActorState() 
	{
		fdb_probe_actor_destroy("checkTaskVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2063 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			uint32_t taskVersion = task->getVersion();
															#line 2064 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (taskVersion > version)
															#line 15428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			{
															#line 2065 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				err = task_invalid_version();
															#line 2067 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				TraceEvent(SevWarn, "BA_BackupRangeTaskFuncExecute") .detail("TaskVersion", taskVersion) .detail("Name", name) .detail("Version", version);
															#line 2071 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
				if (KeyBackedTaskConfig::TaskParams.uid().exists(task))
															#line 15436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
				{
															#line 2072 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					std::string msg = format("%s task version `%lu' is greater than supported version `%lu'", task->params[Task::reservedTaskParamKeyType].toString().c_str(), (unsigned long)taskVersion, (unsigned long)version);
															#line 2076 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					StrictFuture<Void> __when_expr_0 = BackupConfig(task).logError(cx, err, msg);
															#line 2076 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					if (static_cast<CheckTaskVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<CheckTaskVersionActor*>(this)->actor_wait_state = 1;
															#line 2076 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckTaskVersionActor, 0, Void >*>(static_cast<CheckTaskVersionActor*>(this)));
															#line 15449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckTaskVersionActorState();
		static_cast<CheckTaskVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2082 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<CheckTaskVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckTaskVersionActorState(); static_cast<CheckTaskVersionActor*>(this)->destroy(); return 0; }
															#line 15482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<CheckTaskVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckTaskVersionActorState();
		static_cast<CheckTaskVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2079 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 15494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckTaskVersionActor*>(this)->actor_wait_state > 0) static_cast<CheckTaskVersionActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTaskVersionActor*>(this)->ActorCallback< CheckTaskVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTaskVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckTaskVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckTaskVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StringRef name;
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	uint32_t version;
															#line 2065 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Error err;
															#line 15595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via checkTaskVersion()
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class CheckTaskVersionActor final : public Actor<Void>, public ActorCallback< CheckTaskVersionActor, 0, Void >, public FastAllocated<CheckTaskVersionActor>, public CheckTaskVersionActorState<CheckTaskVersionActor> {
															#line 15600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<CheckTaskVersionActor>::operator new;
	using FastAllocated<CheckTaskVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(36509703108321280UL, 4852697748895835392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckTaskVersionActor, 0, Void >;
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	CheckTaskVersionActor(Database const& cx,Reference<Task> const& task,StringRef const& name,uint32_t const& version) 
															#line 15617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   CheckTaskVersionActorState<CheckTaskVersionActor>(cx, task, name, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkTaskVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3362756845853264896UL, 17854206522136534528UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTaskVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkTaskVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkTaskVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckTaskVersionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] Future<Void> checkTaskVersion( Database const& cx, Reference<Task> const& task, StringRef const& name, uint32_t const& version ) {
															#line 2062 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new CheckTaskVersionActor(cx, task, name, version));
															#line 15649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 2084 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

															#line 15654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via abortFiveZeroBackup()
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AbortFiveZeroBackupActor>
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveZeroBackupActorState {
															#line 15660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveZeroBackupActorState(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : backupAgent(backupAgent),
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tagName(tagName)
															#line 15671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this));

	}
	~AbortFiveZeroBackupActorState() 
	{
		fdb_probe_actor_destroy("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2088 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2089 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2091 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tagNames = backupAgent->subspace.get(BackupAgentBase::keyTagName);
															#line 2092 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(tagNames.pack(Key(tagName)));
															#line 2092 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 1;
															#line 2092 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*>(static_cast<AbortFiveZeroBackupActor*>(this)));
															#line 15699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AbortFiveZeroBackupActorState();
		static_cast<AbortFiveZeroBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& uidStr,int loopDepth) 
	{
															#line 2093 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!uidStr.present())
															#line 15722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileBackupAbortIncompatibleBackup_TagNotFound").detail("TagName", tagName.c_str());
															#line 2095 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 15728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AbortFiveZeroBackupActorState();
			static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2097 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		uid = BinaryReader::fromStringRef<UID>(uidStr.get(), Unversioned());
															#line 2099 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		statusSpace = backupAgent->subspace.get(BackupAgentBase::keyStates).get(uid.toString());
															#line 2100 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		globalConfig = backupAgent->subspace.get(BackupAgentBase::keyConfig).get(uid.toString());
															#line 2101 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		newConfigSpace = uidPrefixKey("uid->config/"_sr.withPrefix(fileBackupPrefixRange.begin), uid);
															#line 2103 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr->get(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 2103 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 2;
															#line 2103 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*>(static_cast<AbortFiveZeroBackupActor*>(this)));
															#line 15751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && uidStr,int loopDepth) 
	{
															#line 2093 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!uidStr.present())
															#line 15760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevWarn, "FileBackupAbortIncompatibleBackup_TagNotFound").detail("TagName", tagName.c_str());
															#line 2095 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 15766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~AbortFiveZeroBackupActorState();
			static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2097 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		uid = BinaryReader::fromStringRef<UID>(uidStr.get(), Unversioned());
															#line 2099 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		statusSpace = backupAgent->subspace.get(BackupAgentBase::keyStates).get(uid.toString());
															#line 2100 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		globalConfig = backupAgent->subspace.get(BackupAgentBase::keyConfig).get(uid.toString());
															#line 2101 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		newConfigSpace = uidPrefixKey("uid->config/"_sr.withPrefix(fileBackupPrefixRange.begin), uid);
															#line 2103 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr->get(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 2103 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 2;
															#line 2103 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*>(static_cast<AbortFiveZeroBackupActor*>(this)));
															#line 15789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& uidStr,int loopDepth) 
	{
		loopDepth = a_body1cont1(uidStr, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && uidStr,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(uidStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveZeroBackupActor*>(this)->ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<Value> const& statusStr,int loopDepth) 
	{
															#line 2104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		status = !statusStr.present() ? EBackupState::STATE_NEVERRAN : BackupAgentBase::getState(statusStr.get().toString());
															#line 2107 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FileBackupAbortIncompatibleBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 2112 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(singleKeyRange(StringRef(globalConfig.pack(FileBackupAgent::keyFolderId))));
															#line 2115 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, uid);
															#line 2116 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, uid);
															#line 2117 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 2118 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 2121 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(newConfigSpace.range());
															#line 2123 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key statusKey = StringRef(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 2126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (backupAgent->isRunnable(status))
															#line 15891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2127 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(statusKey, StringRef(FileBackupAgent::getStateText(EBackupState::STATE_ABORTED)));
															#line 15895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 2129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 15899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveZeroBackupActorState();
		static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && statusStr,int loopDepth) 
	{
															#line 2104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		status = !statusStr.present() ? EBackupState::STATE_NEVERRAN : BackupAgentBase::getState(statusStr.get().toString());
															#line 2107 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FileBackupAbortIncompatibleBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 2112 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(singleKeyRange(StringRef(globalConfig.pack(FileBackupAgent::keyFolderId))));
															#line 2115 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, uid);
															#line 2116 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, uid);
															#line 2117 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 2118 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 2121 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(newConfigSpace.range());
															#line 2123 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key statusKey = StringRef(statusSpace.pack(FileBackupAgent::keyStateStatus));
															#line 2126 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (backupAgent->isRunnable(status))
															#line 15929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2127 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(statusKey, StringRef(FileBackupAgent::getStateText(EBackupState::STATE_ABORTED)));
															#line 15933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 2129 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveZeroBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveZeroBackupActorState(); static_cast<AbortFiveZeroBackupActor*>(this)->destroy(); return 0; }
															#line 15937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<AbortFiveZeroBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveZeroBackupActorState();
		static_cast<AbortFiveZeroBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& statusStr,int loopDepth) 
	{
		loopDepth = a_body1cont2(statusStr, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && statusStr,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(statusStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveZeroBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveZeroBackupActor*>(this)->ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 2091 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace tagNames;
															#line 2097 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID uid;
															#line 2099 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace statusSpace;
															#line 2100 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace globalConfig;
															#line 2101 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Subspace newConfigSpace;
															#line 2104 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	EBackupState status;
															#line 16038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via abortFiveZeroBackup()
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveZeroBackupActor final : public Actor<Void>, public ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >, public ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >, public FastAllocated<AbortFiveZeroBackupActor>, public AbortFiveZeroBackupActorState<AbortFiveZeroBackupActor> {
															#line 16043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<AbortFiveZeroBackupActor>::operator new;
	using FastAllocated<AbortFiveZeroBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5967588458762748928UL, 13561255542284915200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >;
friend struct ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >;
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveZeroBackupActor(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 16061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   AbortFiveZeroBackupActorState<AbortFiveZeroBackupActor>(backupAgent, tr, tagName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9684559041468978176UL, 9313393515895828736UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveZeroBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("abortFiveZeroBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("abortFiveZeroBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AbortFiveZeroBackupActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AbortFiveZeroBackupActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> abortFiveZeroBackup( FileBackupAgent* const& backupAgent, Reference<ReadYourWritesTransaction> const& tr, std::string const& tagName ) {
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new AbortFiveZeroBackupActor(backupAgent, tr, tagName));
															#line 16094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 2131 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

struct AbortFiveZeroBackupTask : TaskFuncBase {
	static StringRef name;
																#line 16101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via _finish()
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class _finishActor>
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActorState {
															#line 16107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2138 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   backupAgent(),
															#line 2139 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tagName(task->params[BackupAgentBase::keyConfigBackupTag].toString())
															#line 16124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActorState() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2141 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent(SevInfo, "FileBackupCancelOldTask") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("TagName", tagName);
															#line 2144 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = abortFiveZeroBackup(&backupAgent, tr, tagName);
															#line 2144 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor*>(this)->actor_wait_state = 1;
															#line 2144 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 0, Void >*>(static_cast<_finishActor*>(this)));
															#line 16148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2146 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = taskBucket->finish(tr, task);
															#line 2146 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor*>(this)->actor_wait_state = 2;
															#line 2146 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 1, Void >*>(static_cast<_finishActor*>(this)));
															#line 16178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2146 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = taskBucket->finish(tr, task);
															#line 2146 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor*>(this)->actor_wait_state = 2;
															#line 2146 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor, 1, Void >*>(static_cast<_finishActor*>(this)));
															#line 16194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2147 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActorState(); static_cast<_finishActor*>(this)->destroy(); return 0; }
															#line 16278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2147 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActorState(); static_cast<_finishActor*>(this)->destroy(); return 0; }
															#line 16290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActorState();
		static_cast<_finishActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor*>(this)->actor_wait_state > 0) static_cast<_finishActor*>(this)->actor_wait_state = 0;
		static_cast<_finishActor*>(this)->ActorCallback< _finishActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 2138 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent backupAgent;
															#line 2139 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 16385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _finish()
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActor final : public Actor<Void>, public ActorCallback< _finishActor, 0, Void >, public ActorCallback< _finishActor, 1, Void >, public FastAllocated<_finishActor>, public _finishActorState<_finishActor> {
															#line 16390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_finishActor>::operator new;
	using FastAllocated<_finishActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14554670902827185152UL, 13564214212088420608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor, 0, Void >;
friend struct ActorCallback< _finishActor, 1, Void >;
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 16408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _finishActorState<_finishActor>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5805366160711900928UL, 534046083987129088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor(tr, taskBucket, futureBucket, task));
															#line 16441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 2149 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	StringRef getName() const override {
		TraceEvent(SevError, "FileBackupError")
		    .detail("Cause", "AbortFiveZeroBackupTaskFunc::name() should never be called");
		ASSERT(false);
		return StringRef();
	}

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Future<Void>(Void());
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};
};
StringRef AbortFiveZeroBackupTask::name = "abort_legacy_backup"_sr;
REGISTER_TASKFUNC(AbortFiveZeroBackupTask);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_diff_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_log_range);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_range);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_backup_restorable);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_finish_full_backup);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_finished_full_backup);
REGISTER_TASKFUNC_ALIAS(AbortFiveZeroBackupTask, file_start_full_backup);

															#line 16477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via abortFiveOneBackup()
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AbortFiveOneBackupActor>
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveOneBackupActorState {
															#line 16483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveOneBackupActorState(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : backupAgent(backupAgent),
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tagName(tagName)
															#line 16494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("abortFiveOneBackup", reinterpret_cast<unsigned long>(this));

	}
	~AbortFiveOneBackupActorState() 
	{
		fdb_probe_actor_destroy("abortFiveOneBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2184 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2185 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2187 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tag = makeBackupTag(tagName);
															#line 2188 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<UidAndAbortedFlagT> __when_expr_0 = tag.getOrThrow(tr, Snapshot::False, backup_unneeded());
															#line 2188 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 1;
															#line 2188 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 16522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AbortFiveOneBackupActorState();
		static_cast<AbortFiveOneBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2190 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		config = BackupConfig(current.first);
															#line 2191 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<EBackupState> __when_expr_1 = config.stateEnum().getD(tr, Snapshot::False, EBackupState::STATE_NEVERRAN);
															#line 2191 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 2;
															#line 2191 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 16554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(UidAndAbortedFlagT const& __current,int loopDepth) 
	{
															#line 2188 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		current = __current;
															#line 16563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(UidAndAbortedFlagT && __current,int loopDepth) 
	{
		current = std::move(__current);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveOneBackupActor*>(this)->ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*,UidAndAbortedFlagT const& value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*,UidAndAbortedFlagT && value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(EBackupState const& status,int loopDepth) 
	{
															#line 2193 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!backupAgent->isRunnable(status))
															#line 16642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2194 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_unneeded(), loopDepth);
															#line 16646 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 2197 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FBA_AbortFileOneBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 2202 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tag.cancel(tr);
															#line 2202 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 3;
															#line 2202 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 2, Void >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 16659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(EBackupState && status,int loopDepth) 
	{
															#line 2193 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!backupAgent->isRunnable(status))
															#line 16668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2194 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			return a_body1Catch1(backup_unneeded(), loopDepth);
															#line 16672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 2197 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FBA_AbortFileOneBackup") .detail("TagName", tagName.c_str()) .detail("Status", BackupAgentBase::getStateText(status));
															#line 2202 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tag.cancel(tr);
															#line 2202 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 3;
															#line 2202 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AbortFiveOneBackupActor, 2, Void >*>(static_cast<AbortFiveOneBackupActor*>(this)));
															#line 16685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(EBackupState const& status,int loopDepth) 
	{
		loopDepth = a_body1cont2(status, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(EBackupState && status,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveOneBackupActor*>(this)->ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2204 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, config.getUid());
															#line 2205 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, config.getUid());
															#line 2207 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 2208 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 2210 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		config.stateEnum().set(tr, EBackupState::STATE_ABORTED);
															#line 2212 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveOneBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveOneBackupActorState(); static_cast<AbortFiveOneBackupActor*>(this)->destroy(); return 0; }
															#line 16779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<AbortFiveOneBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveOneBackupActorState();
		static_cast<AbortFiveOneBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2204 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key configPath = uidPrefixKey(logRangesRange.begin, config.getUid());
															#line 2205 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		Key logsPath = uidPrefixKey(backupLogKeys.begin, config.getUid());
															#line 2207 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(configPath, strinc(configPath)));
															#line 2208 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr->clear(KeyRangeRef(logsPath, strinc(logsPath)));
															#line 2210 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		config.stateEnum().set(tr, EBackupState::STATE_ABORTED);
															#line 2212 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AbortFiveOneBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortFiveOneBackupActorState(); static_cast<AbortFiveOneBackupActor*>(this)->destroy(); return 0; }
															#line 16801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<AbortFiveOneBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortFiveOneBackupActorState();
		static_cast<AbortFiveOneBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortFiveOneBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortFiveOneBackupActor*>(this)->ActorCallback< AbortFiveOneBackupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AbortFiveOneBackupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AbortFiveOneBackupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent* backupAgent;
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 2187 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyBackedTag tag;
															#line 2188 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UidAndAbortedFlagT current;
															#line 2190 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig config;
															#line 16896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via abortFiveOneBackup()
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AbortFiveOneBackupActor final : public Actor<Void>, public ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >, public ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >, public ActorCallback< AbortFiveOneBackupActor, 2, Void >, public FastAllocated<AbortFiveOneBackupActor>, public AbortFiveOneBackupActorState<AbortFiveOneBackupActor> {
															#line 16901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<AbortFiveOneBackupActor>::operator new;
	using FastAllocated<AbortFiveOneBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7393185656240019456UL, 6699738610628394496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >;
friend struct ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >;
friend struct ActorCallback< AbortFiveOneBackupActor, 2, Void >;
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AbortFiveOneBackupActor(FileBackupAgent* const& backupAgent,Reference<ReadYourWritesTransaction> const& tr,std::string const& tagName) 
															#line 16920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   AbortFiveOneBackupActorState<AbortFiveOneBackupActor>(backupAgent, tr, tagName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12508330983096255488UL, 5977812422500027136UL);
		ActorExecutionContextHelper __helper(static_cast<AbortFiveOneBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("abortFiveOneBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("abortFiveOneBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AbortFiveOneBackupActor, 0, UidAndAbortedFlagT >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AbortFiveOneBackupActor, 1, EBackupState >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AbortFiveOneBackupActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> abortFiveOneBackup( FileBackupAgent* const& backupAgent, Reference<ReadYourWritesTransaction> const& tr, std::string const& tagName ) {
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new AbortFiveOneBackupActor(backupAgent, tr, tagName));
															#line 16954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 2214 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

struct AbortFiveOneBackupTask : TaskFuncBase {
	static StringRef name;
																#line 16961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via _finish()
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class _finishActor1>
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActor1State {
															#line 16967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActor1State(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2221 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   backupAgent(),
															#line 2222 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   config(task)
															#line 16984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_finish", reinterpret_cast<unsigned long>(this));

	}
	~_finishActor1State() 
	{
		fdb_probe_actor_destroy("_finish", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2223 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<std::string> __when_expr_0 = config.tag().getOrThrow(tr);
															#line 2223 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_finishActor1*>(this)->actor_wait_state = 1;
															#line 2223 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 0, std::string >*>(static_cast<_finishActor1*>(this)));
															#line 17006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2225 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent(SevInfo, "FileBackupCancelFiveOneTask") .detail("Task", task->params[Task::reservedTaskParamKeyType]) .detail("TagName", tagName);
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = abortFiveOneBackup(&backupAgent, tr, tagName);
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 2;
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 1, Void >*>(static_cast<_finishActor1*>(this)));
															#line 17038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::string const& __tagName,int loopDepth) 
	{
															#line 2223 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tagName = __tagName;
															#line 17047 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::string && __tagName,int loopDepth) 
	{
		tagName = std::move(__tagName);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 0, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 0, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 0, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _finishActor1, 0, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2230 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 2230 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 3;
															#line 2230 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 2, Void >*>(static_cast<_finishActor1*>(this)));
															#line 17133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2230 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = taskBucket->finish(tr, task);
															#line 2230 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_finishActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_finishActor1*>(this)->actor_wait_state = 3;
															#line 2230 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _finishActor1, 2, Void >*>(static_cast<_finishActor1*>(this)));
															#line 17149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _finishActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2231 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor1State(); static_cast<_finishActor1*>(this)->destroy(); return 0; }
															#line 17233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2231 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<_finishActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_finishActor1State(); static_cast<_finishActor1*>(this)->destroy(); return 0; }
															#line 17245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<_finishActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~_finishActor1State();
		static_cast<_finishActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_finishActor1*>(this)->actor_wait_state > 0) static_cast<_finishActor1*>(this)->actor_wait_state = 0;
		static_cast<_finishActor1*>(this)->ActorCallback< _finishActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _finishActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _finishActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _finishActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<FutureBucket> futureBucket;
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 2221 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FileBackupAgent backupAgent;
															#line 2222 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig config;
															#line 2223 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::string tagName;
															#line 17342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via _finish()
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _finishActor1 final : public Actor<Void>, public ActorCallback< _finishActor1, 0, std::string >, public ActorCallback< _finishActor1, 1, Void >, public ActorCallback< _finishActor1, 2, Void >, public FastAllocated<_finishActor1>, public _finishActor1State<_finishActor1> {
															#line 17347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<_finishActor1>::operator new;
	using FastAllocated<_finishActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14554670902827185152UL, 13564214212088420608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _finishActor1, 0, std::string >;
friend struct ActorCallback< _finishActor1, 1, Void >;
friend struct ActorCallback< _finishActor1, 2, Void >;
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_finishActor1(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 17366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   _finishActor1State<_finishActor1>(tr, taskBucket, futureBucket, task),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_finish", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9581808447337778176UL, 9167718057927325696UL);
		ActorExecutionContextHelper __helper(static_cast<_finishActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_finish");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_finish", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _finishActor1, 0, std::string >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _finishActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _finishActor1, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> _finish( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<FutureBucket> const& futureBucket, Reference<Task> const& task ) {
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new _finishActor1(tr, taskBucket, futureBucket, task));
															#line 17400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 2233 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

	StringRef getName() const override {
		TraceEvent(SevError, "FileBackupError")
		    .detail("Cause", "AbortFiveOneBackupTaskFunc::name() should never be called");
		ASSERT(false);
		return StringRef();
	}

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return Future<Void>(Void());
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};
};
StringRef AbortFiveOneBackupTask::name = "abort_legacy_backup_5.2"_sr;
REGISTER_TASKFUNC(AbortFiveOneBackupTask);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_write_range);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_dispatch_ranges);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_write_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_erase_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_dispatch_logs);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_finished);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_write_snapshot_manifest);
REGISTER_TASKFUNC_ALIAS(AbortFiveOneBackupTask, file_backup_start);

std::function<void(Reference<Task>)> NOP_SETUP_TASK_FN = [](Reference<Task> task) { /* NOP */ };
															#line 17437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via addBackupTask()
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AddBackupTaskActor>
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AddBackupTaskActorState {
															#line 17443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AddBackupTaskActorState(StringRef const& name,uint32_t const& version,Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,TaskCompletionKey const& completionKey,BackupConfig const& config,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(),std::function<void(Reference<Task>)> const& setupTaskFn = NOP_SETUP_TASK_FN,int const& priority = 0,SetValidation const& setValidation = SetValidation::True) 
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : name(name),
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(version),
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   tr(tr),
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   config(config),
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   waitFor(waitFor),
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   setupTaskFn(setupTaskFn),
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   priority(priority),
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   setValidation(setValidation)
															#line 17468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("addBackupTask", reinterpret_cast<unsigned long>(this));

	}
	~AddBackupTaskActorState() 
	{
		fdb_probe_actor_destroy("addBackupTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2276 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2277 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2279 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = completionKey.get(tr, taskBucket);
															#line 2279 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 1;
															#line 2279 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 0, Key >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 17494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddBackupTaskActorState();
		static_cast<AddBackupTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& doneKey,int loopDepth) 
	{
															#line 2280 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		task = Reference<Task>(new Task(name, version, doneKey, priority));
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = config.toTask(tr, task, setValidation);
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 2;
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 1, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 17526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key && doneKey,int loopDepth) 
	{
															#line 2280 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		task = Reference<Task>(new Task(name, version, doneKey, priority));
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = config.toTask(tr, task, setValidation);
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 2;
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 1, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 17544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Key const& doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(doneKey, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && doneKey,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(doneKey), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state > 0) static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddBackupTaskActor*>(this)->ActorCallback< AddBackupTaskActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddBackupTaskActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2287 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		setupTaskFn(task);
															#line 2289 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!waitFor)
															#line 17630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2290 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task)); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 17634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task));
			this->~AddBackupTaskActorState();
			static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2292 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitFor->onSetAddTask(tr, taskBucket, task);
															#line 2292 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17644 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 3;
															#line 2292 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 2, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 17649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2287 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		setupTaskFn(task);
															#line 2289 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!waitFor)
															#line 17660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2290 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)(taskBucket->addTask(tr, task)); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 17664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key(taskBucket->addTask(tr, task));
			this->~AddBackupTaskActorState();
			static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2292 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitFor->onSetAddTask(tr, taskBucket, task);
															#line 2292 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 3;
															#line 2292 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AddBackupTaskActor, 2, Void >*>(static_cast<AddBackupTaskActor*>(this)));
															#line 17679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state > 0) static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddBackupTaskActor*>(this)->ActorCallback< AddBackupTaskActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddBackupTaskActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2294 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 17763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddBackupTaskActorState();
		static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2294 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AddBackupTaskActor*>(this)->SAV<Key>::futures) { (void)("OnSetAddTask"_sr); this->~AddBackupTaskActorState(); static_cast<AddBackupTaskActor*>(this)->destroy(); return 0; }
															#line 17775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<AddBackupTaskActor*>(this)->SAV< Key >::value()) Key("OnSetAddTask"_sr);
		this->~AddBackupTaskActorState();
		static_cast<AddBackupTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AddBackupTaskActor*>(this)->actor_wait_state > 0) static_cast<AddBackupTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddBackupTaskActor*>(this)->ActorCallback< AddBackupTaskActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AddBackupTaskActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AddBackupTaskActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	StringRef name;
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	uint32_t version;
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig config;
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	std::function<void(Reference<Task>)> setupTaskFn;
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int priority;
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	SetValidation setValidation;
															#line 2280 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 17880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via addBackupTask()
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AddBackupTaskActor final : public Actor<Key>, public ActorCallback< AddBackupTaskActor, 0, Key >, public ActorCallback< AddBackupTaskActor, 1, Void >, public ActorCallback< AddBackupTaskActor, 2, Void >, public FastAllocated<AddBackupTaskActor>, public AddBackupTaskActorState<AddBackupTaskActor> {
															#line 17885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<AddBackupTaskActor>::operator new;
	using FastAllocated<AddBackupTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17523684487253014528UL, 4656232579477564160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddBackupTaskActor, 0, Key >;
friend struct ActorCallback< AddBackupTaskActor, 1, Void >;
friend struct ActorCallback< AddBackupTaskActor, 2, Void >;
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AddBackupTaskActor(StringRef const& name,uint32_t const& version,Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,TaskCompletionKey const& completionKey,BackupConfig const& config,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(),std::function<void(Reference<Task>)> const& setupTaskFn = NOP_SETUP_TASK_FN,int const& priority = 0,SetValidation const& setValidation = SetValidation::True) 
															#line 17904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Key>(),
		   AddBackupTaskActorState<AddBackupTaskActor>(name, version, tr, taskBucket, completionKey, config, waitFor, setupTaskFn, priority, setValidation),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addBackupTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9042814576718378240UL, 18087378901118404352UL);
		ActorExecutionContextHelper __helper(static_cast<AddBackupTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addBackupTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addBackupTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddBackupTaskActor, 0, Key >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddBackupTaskActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AddBackupTaskActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addBackupTask( StringRef const& name, uint32_t const& version, Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, TaskCompletionKey const& completionKey, BackupConfig const& config, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(), std::function<void(Reference<Task>)> const& setupTaskFn = NOP_SETUP_TASK_FN, int const& priority = 0, SetValidation const& setValidation = SetValidation::True ) {
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Key>(new AddBackupTaskActor(name, version, tr, taskBucket, completionKey, config, waitFor, setupTaskFn, priority, setValidation));
															#line 17938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 2296 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Clears the backup ID from "backupStartedKey" to pause backup workers.
															#line 17944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via clearBackupStartID()
															#line 2298 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class ClearBackupStartIDActor>
															#line 2298 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class ClearBackupStartIDActorState {
															#line 17950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 2298 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	ClearBackupStartIDActorState(Reference<ReadYourWritesTransaction> const& tr,UID const& backupUid) 
															#line 2298 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2298 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2298 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   backupUid(backupUid)
															#line 17959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("clearBackupStartID", reinterpret_cast<unsigned long>(this));

	}
	~ClearBackupStartIDActorState() 
	{
		fdb_probe_actor_destroy("clearBackupStartID", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(backupStartedKey);
															#line 2300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state = 1;
															#line 2300 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*>(static_cast<ClearBackupStartIDActor*>(this)));
															#line 17981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearBackupStartIDActorState();
		static_cast<ClearBackupStartIDActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& started,int loopDepth) 
	{
															#line 2301 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<std::pair<UID, Version>> ids;
															#line 2302 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (started.present())
															#line 18006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2303 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids = decodeBackupStartedValue(started.get());
															#line 18010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 2305 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		auto it = std::find_if(ids.begin(), ids.end(), [=](const std::pair<UID, Version>& p) { return p.first == backupUid; });
															#line 2307 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (it != ids.end())
															#line 18016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2308 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids.erase(it);
															#line 18020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 2311 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ids.empty())
															#line 18024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent("ClearBackup").detail("BackupID", backupUid);
															#line 2313 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->clear(backupStartedKey);
															#line 18030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		else
		{
															#line 2315 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(backupStartedKey, encodeBackupStartedValue(ids));
															#line 18036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 2317 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<ClearBackupStartIDActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearBackupStartIDActorState(); static_cast<ClearBackupStartIDActor*>(this)->destroy(); return 0; }
															#line 18040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<ClearBackupStartIDActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearBackupStartIDActorState();
		static_cast<ClearBackupStartIDActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && started,int loopDepth) 
	{
															#line 2301 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		std::vector<std::pair<UID, Version>> ids;
															#line 2302 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (started.present())
															#line 18054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2303 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids = decodeBackupStartedValue(started.get());
															#line 18058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 2305 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		auto it = std::find_if(ids.begin(), ids.end(), [=](const std::pair<UID, Version>& p) { return p.first == backupUid; });
															#line 2307 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (it != ids.end())
															#line 18064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2308 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			ids.erase(it);
															#line 18068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 2311 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (ids.empty())
															#line 18072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			TraceEvent("ClearBackup").detail("BackupID", backupUid);
															#line 2313 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->clear(backupStartedKey);
															#line 18078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
		else
		{
															#line 2315 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->set(backupStartedKey, encodeBackupStartedValue(ids));
															#line 18084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 2317 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<ClearBackupStartIDActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearBackupStartIDActorState(); static_cast<ClearBackupStartIDActor*>(this)->destroy(); return 0; }
															#line 18088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<ClearBackupStartIDActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearBackupStartIDActorState();
		static_cast<ClearBackupStartIDActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& started,int loopDepth) 
	{
		loopDepth = a_body1cont1(started, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && started,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(started), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state > 0) static_cast<ClearBackupStartIDActor*>(this)->actor_wait_state = 0;
		static_cast<ClearBackupStartIDActor*>(this)->ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2298 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2298 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	UID backupUid;
															#line 18175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via clearBackupStartID()
															#line 2298 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class ClearBackupStartIDActor final : public Actor<Void>, public ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >, public FastAllocated<ClearBackupStartIDActor>, public ClearBackupStartIDActorState<ClearBackupStartIDActor> {
															#line 18180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<ClearBackupStartIDActor>::operator new;
	using FastAllocated<ClearBackupStartIDActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4562551689386902784UL, 6271950889658115072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >;
															#line 2298 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	ClearBackupStartIDActor(Reference<ReadYourWritesTransaction> const& tr,UID const& backupUid) 
															#line 18197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Void>(),
		   ClearBackupStartIDActorState<ClearBackupStartIDActor>(tr, backupUid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearBackupStartID", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2638382467860152832UL, 17874567724139410688UL);
		ActorExecutionContextHelper __helper(static_cast<ClearBackupStartIDActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearBackupStartID");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearBackupStartID", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearBackupStartIDActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2298 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Void> clearBackupStartID( Reference<ReadYourWritesTransaction> const& tr, UID const& backupUid ) {
															#line 2298 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Void>(new ClearBackupStartIDActor(tr, backupUid));
															#line 18229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 2319 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

// Backup and Restore taskFunc definitions will inherit from one of the following classes which
// servers to catch and log to the appropriate config any error that execute/finish didn't catch and log.
struct RestoreTaskFuncBase : TaskFuncBase {
	Future<Void> handleError(Database cx, Reference<Task> task, Error const& error) final {
		return RestoreConfig(task).logError(
		    cx,
		    error,
		    format("'%s' on '%s'", error.what(), task->params[Task::reservedTaskParamKeyType].printable().c_str()));
	}
	virtual std::string toString(Reference<Task> task) const { return ""; }
};

struct BackupTaskFuncBase : TaskFuncBase {
	Future<Void> handleError(Database cx, Reference<Task> task, Error const& error) final {
		return BackupConfig(task).logError(
		    cx,
		    error,
		    format("'%s' on '%s'", error.what(), task->params[Task::reservedTaskParamKeyType].printable().c_str()));
	}
	virtual std::string toString(Reference<Task> task) const { return ""; }
};

															#line 18256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via getBlockOfShards()
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class GetBlockOfShardsActor>
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetBlockOfShardsActorState {
															#line 18262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetBlockOfShardsActorState(Reference<ReadYourWritesTransaction> const& tr,Key const& beginKey,Key const& endKey,int const& limit) 
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   beginKey(beginKey),
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   endKey(endKey),
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   limit(limit)
															#line 18275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("getBlockOfShards", reinterpret_cast<unsigned long>(this));

	}
	~GetBlockOfShardsActorState() 
	{
		fdb_probe_actor_destroy("getBlockOfShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2347 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2348 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2349 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results = Standalone<VectorRef<KeyRef>>();
															#line 2350 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange( KeyRangeRef(keyAfter(beginKey.withPrefix(keyServersPrefix)), endKey.withPrefix(keyServersPrefix)), limit);
															#line 2350 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state = 1;
															#line 2350 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*>(static_cast<GetBlockOfShardsActor*>(this)));
															#line 18303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBlockOfShardsActorState();
		static_cast<GetBlockOfShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& values,int loopDepth) 
	{
															#line 2353 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& s : values ) {
															#line 2354 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			KeyRef k = s.key.removePrefix(keyServersPrefix);
															#line 2355 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back_deep(results.arena(), k);
															#line 18330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 2358 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetBlockOfShardsActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(results); this->~GetBlockOfShardsActorState(); static_cast<GetBlockOfShardsActor*>(this)->destroy(); return 0; }
															#line 18334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<GetBlockOfShardsActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(std::move(results)); // state_var_RVO
		this->~GetBlockOfShardsActorState();
		static_cast<GetBlockOfShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && values,int loopDepth) 
	{
															#line 2353 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		for( auto& s : values ) {
															#line 2354 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			KeyRef k = s.key.removePrefix(keyServersPrefix);
															#line 2355 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			results.push_back_deep(results.arena(), k);
															#line 18350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 2358 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<GetBlockOfShardsActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(results); this->~GetBlockOfShardsActorState(); static_cast<GetBlockOfShardsActor*>(this)->destroy(); return 0; }
															#line 18354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<GetBlockOfShardsActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(std::move(results)); // state_var_RVO
		this->~GetBlockOfShardsActorState();
		static_cast<GetBlockOfShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& values,int loopDepth) 
	{
		loopDepth = a_body1cont1(values, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && values,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(values), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state > 0) static_cast<GetBlockOfShardsActor*>(this)->actor_wait_state = 0;
		static_cast<GetBlockOfShardsActor*>(this)->ActorCallback< GetBlockOfShardsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key beginKey;
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key endKey;
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int limit;
															#line 2349 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Standalone<VectorRef<KeyRef>> results;
															#line 18447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via getBlockOfShards()
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class GetBlockOfShardsActor final : public Actor<Standalone<VectorRef<KeyRef>>>, public ActorCallback< GetBlockOfShardsActor, 0, RangeResult >, public FastAllocated<GetBlockOfShardsActor>, public GetBlockOfShardsActorState<GetBlockOfShardsActor> {
															#line 18452 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<GetBlockOfShardsActor>::operator new;
	using FastAllocated<GetBlockOfShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3221537923208926208UL, 12628436866250756608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBlockOfShardsActor, 0, RangeResult >;
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	GetBlockOfShardsActor(Reference<ReadYourWritesTransaction> const& tr,Key const& beginKey,Key const& endKey,int const& limit) 
															#line 18469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Standalone<VectorRef<KeyRef>>>(),
		   GetBlockOfShardsActorState<GetBlockOfShardsActor>(tr, beginKey, endKey, limit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBlockOfShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13286161151181671680UL, 17379547947322064896UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlockOfShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBlockOfShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBlockOfShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBlockOfShardsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<KeyRef>>> getBlockOfShards( Reference<ReadYourWritesTransaction> const& tr, Key const& beginKey, Key const& endKey, int const& limit ) {
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Standalone<VectorRef<KeyRef>>>(new GetBlockOfShardsActor(tr, beginKey, endKey, limit));
															#line 18501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 2360 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

struct BackupRangeTaskFunc : BackupTaskFuncBase {
	static StringRef name;
	static constexpr uint32_t version = 1;

	static struct {
		static TaskParam<Key> beginKey() { return __FUNCTION__sr; }
		static TaskParam<Key> endKey() { return __FUNCTION__sr; }
		static TaskParam<bool> addBackupRangeTasks() { return __FUNCTION__sr; }
	} Params;

	std::string toString(Reference<Task> task) const override {
		return format("beginKey '%s' endKey '%s' addTasks %d",
		              Params.beginKey().get(task).printable().c_str(),
		              Params.endKey().get(task).printable().c_str(),
		              Params.addBackupRangeTasks().get(task));
	}

	StringRef getName() const override { return name; };

	Future<Void> execute(Database cx,
	                     Reference<TaskBucket> tb,
	                     Reference<FutureBucket> fb,
	                     Reference<Task> task) override {
		return _execute(cx, tb, fb, task);
	};
	Future<Void> finish(Reference<ReadYourWritesTransaction> tr,
	                    Reference<TaskBucket> tb,
	                    Reference<FutureBucket> fb,
	                    Reference<Task> task) override {
		return _finish(tr, tb, fb, task);
	};

	// Finish (which flushes/syncs) the file, and then in a single transaction, make some range backup progress
	// durable. This means:
	//  - increment the backup config's range bytes written
	//  - update the range file map
	//  - update the task begin key
	//  - save/extend the task with the new params
	// Returns whether or not the caller should continue executing the task.
																#line 18545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via finishRangeFile()
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class FinishRangeFileActor>
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class FinishRangeFileActorState {
															#line 18551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FinishRangeFileActorState(Reference<IBackupFile> const& file,Database const& cx,Reference<Task> const& task,Reference<TaskBucket> const& taskBucket,KeyRange const& range,Version const& version) 
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : file(file),
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   cx(cx),
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   range(range),
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   version(version)
															#line 18568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("finishRangeFile", reinterpret_cast<unsigned long>(this));

	}
	~FinishRangeFileActorState() 
	{
		fdb_probe_actor_destroy("finishRangeFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2406 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = file->finish();
															#line 2406 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 1;
															#line 2406 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 0, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 18590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FinishRangeFileActorState();
		static_cast<FinishRangeFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2409 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (range.empty())
															#line 18613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2410 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<FinishRangeFileActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FinishRangeFileActorState(); static_cast<FinishRangeFileActor*>(this)->destroy(); return 0; }
															#line 18617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<FinishRangeFileActor*>(this)->SAV< bool >::value()) bool(false);
			this->~FinishRangeFileActorState();
			static_cast<FinishRangeFileActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2412 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 2413 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup = BackupConfig(task);
															#line 2414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		usedFile = false;
															#line 2418 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = task->extendMutex.take();
															#line 2418 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 2;
															#line 2418 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 1, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 18638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2409 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (range.empty())
															#line 18647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2410 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<FinishRangeFileActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FinishRangeFileActorState(); static_cast<FinishRangeFileActor*>(this)->destroy(); return 0; }
															#line 18651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<FinishRangeFileActor*>(this)->SAV< bool >::value()) bool(false);
			this->~FinishRangeFileActorState();
			static_cast<FinishRangeFileActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2412 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 2413 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup = BackupConfig(task);
															#line 2414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		usedFile = false;
															#line 2418 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_1 = task->extendMutex.take();
															#line 2418 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 2;
															#line 2418 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 1, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 18672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2419 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		releaser = FlowLock::Releaser(task->extendMutex, 1);
															#line 2421 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 18758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2419 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		releaser = FlowLock::Releaser(task->extendMutex, 1);
															#line 2421 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		;
															#line 18769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 2453 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<FinishRangeFileActor*>(this)->SAV<bool>::futures) { (void)(usedFile); this->~FinishRangeFileActorState(); static_cast<FinishRangeFileActor*>(this)->destroy(); return 0; }
															#line 18853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<FinishRangeFileActor*>(this)->SAV< bool >::value()) bool(std::move(usedFile)); // state_var_RVO
		this->~FinishRangeFileActorState();
		static_cast<FinishRangeFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 2423 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2424 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2428 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			Params.beginKey().set(task, range.end);
															#line 2431 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Version> __when_expr_2 = taskBucket->extendTimeout(tr, task, UpdateParams::True);
															#line 2431 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 18881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 3;
															#line 2431 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 2, Version >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 18886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2449 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr->onError(e);
															#line 2449 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 6;
															#line 2449 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 5, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 18928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(int loopDepth) 
	{
															#line 2434 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup.rangeBytesWritten().atomicOp(tr, file->size(), MutationRef::AddValue);
															#line 2435 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		backup.snapshotRangeFileCount().atomicOp(tr, 1, MutationRef::AddValue);
															#line 2438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Optional<BackupConfig::RangeSlice>> __when_expr_3 = backup.snapshotRangeFileMap().get(tr, range.end);
															#line 2438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 18949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 4;
															#line 2438 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 18954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Version const& __newTimeout,int loopDepth) 
	{
															#line 2431 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		newTimeout = __newTimeout;
															#line 18963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Version && __newTimeout,int loopDepth) 
	{
		newTimeout = std::move(__newTimeout);
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont3(Optional<BackupConfig::RangeSlice> const& s,int loopDepth) 
	{
															#line 2439 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!s.present() || s.get().begin >= range.begin)
															#line 19042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			backup.snapshotRangeFileMap().set( tr, range.end, { range.begin, version, file->getFileName(), file->size() });
															#line 2442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			usedFile = true;
															#line 19048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 2445 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 2445 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 19054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 5;
															#line 2445 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 4, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 19059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Optional<BackupConfig::RangeSlice> && s,int loopDepth) 
	{
															#line 2439 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!s.present() || s.get().begin >= range.begin)
															#line 19068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			backup.snapshotRangeFileMap().set( tr, range.end, { range.begin, version, file->getFileName(), file->size() });
															#line 2442 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			usedFile = true;
															#line 19074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		}
															#line 2445 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 2445 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 19080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 5;
															#line 2445 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FinishRangeFileActor, 4, Void >*>(static_cast<FinishRangeFileActor*>(this)));
															#line 19085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Optional<BackupConfig::RangeSlice> const& s,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(s, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Optional<BackupConfig::RangeSlice> && s,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*,Optional<BackupConfig::RangeSlice> const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*,Optional<BackupConfig::RangeSlice> && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 2446 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		task->timeoutVersion = newTimeout;
															#line 19169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 2446 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		task->timeoutVersion = newTimeout;
															#line 19178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FinishRangeFileActor*>(this)->actor_wait_state > 0) static_cast<FinishRangeFileActor*>(this)->actor_wait_state = 0;
		static_cast<FinishRangeFileActor*>(this)->ActorCallback< FinishRangeFileActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FinishRangeFileActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FinishRangeFileActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<IBackupFile> file;
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Database cx;
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> task;
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	KeyRange range;
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version version;
															#line 2412 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2413 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	BackupConfig backup;
															#line 2414 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	bool usedFile;
															#line 2419 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FlowLock::Releaser releaser;
															#line 2431 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version newTimeout;
															#line 19367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via finishRangeFile()
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class FinishRangeFileActor final : public Actor<bool>, public ActorCallback< FinishRangeFileActor, 0, Void >, public ActorCallback< FinishRangeFileActor, 1, Void >, public ActorCallback< FinishRangeFileActor, 2, Version >, public ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >, public ActorCallback< FinishRangeFileActor, 4, Void >, public ActorCallback< FinishRangeFileActor, 5, Void >, public FastAllocated<FinishRangeFileActor>, public FinishRangeFileActorState<FinishRangeFileActor> {
															#line 19372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<FinishRangeFileActor>::operator new;
	using FastAllocated<FinishRangeFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4196185886229707264UL, 11102443552844668416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FinishRangeFileActor, 0, Void >;
friend struct ActorCallback< FinishRangeFileActor, 1, Void >;
friend struct ActorCallback< FinishRangeFileActor, 2, Version >;
friend struct ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >;
friend struct ActorCallback< FinishRangeFileActor, 4, Void >;
friend struct ActorCallback< FinishRangeFileActor, 5, Void >;
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	FinishRangeFileActor(Reference<IBackupFile> const& file,Database const& cx,Reference<Task> const& task,Reference<TaskBucket> const& taskBucket,KeyRange const& range,Version const& version) 
															#line 19394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<bool>(),
		   FinishRangeFileActorState<FinishRangeFileActor>(file, cx, task, taskBucket, range, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("finishRangeFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3667902104148193536UL, 8200535100199061504UL);
		ActorExecutionContextHelper __helper(static_cast<FinishRangeFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("finishRangeFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("finishRangeFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FinishRangeFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FinishRangeFileActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FinishRangeFileActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FinishRangeFileActor, 3, Optional<BackupConfig::RangeSlice> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FinishRangeFileActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FinishRangeFileActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<bool> finishRangeFile( Reference<IBackupFile> const& file, Database const& cx, Reference<Task> const& task, Reference<TaskBucket> const& taskBucket, KeyRange const& range, Version const& version ) {
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<bool>(new FinishRangeFileActor(file, cx, task, taskBucket, range, version));
															#line 19431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 2455 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 19436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via addTask()
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class AddTaskActor>
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AddTaskActorState {
															#line 19442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AddTaskActorState(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,int const& priority,Key const& begin,Key const& end,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(),Version const& scheduledVersion = invalidVersion) 
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : tr(tr),
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   parentTask(parentTask),
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   priority(priority),
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   begin(begin),
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   end(end),
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   completionKey(completionKey),
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   waitFor(waitFor),
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   scheduledVersion(scheduledVersion)
															#line 19465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("addTask", reinterpret_cast<unsigned long>(this));

	}
	~AddTaskActorState() 
	{
		fdb_probe_actor_destroy("addTask", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2465 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Key> __when_expr_0 = addBackupTask( BackupRangeTaskFunc::name, BackupRangeTaskFunc::version, tr, taskBucket, completionKey, BackupConfig(parentTask), waitFor, [=](Reference<Task> task) { Params.beginKey().set(task, begin); Params.endKey().set(task, end); Params.addBackupRangeTasks().set(task, false); if (scheduledVersion != invalidVersion) ReservedTaskParams::scheduledVersion().set(task, scheduledVersion); }, priority);
															#line 2465 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<AddTaskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AddTaskActor*>(this)->actor_wait_state = 1;
															#line 2465 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddTaskActor, 0, Key >*>(static_cast<AddTaskActor*>(this)));
															#line 19487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddTaskActorState();
		static_cast<AddTaskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Key const& key,int loopDepth) 
	{
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor*>(this)->SAV<Key>::futures) { (void)(key); this->~AddTaskActorState(); static_cast<AddTaskActor*>(this)->destroy(); return 0; }
															#line 19510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor*>(this)->SAV< Key >::value()) Key(key);
		this->~AddTaskActorState();
		static_cast<AddTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Key && key,int loopDepth) 
	{
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (!static_cast<AddTaskActor*>(this)->SAV<Key>::futures) { (void)(key); this->~AddTaskActorState(); static_cast<AddTaskActor*>(this)->destroy(); return 0; }
															#line 19522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		new (&static_cast<AddTaskActor*>(this)->SAV< Key >::value()) Key(key);
		this->~AddTaskActorState();
		static_cast<AddTaskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Key const& key,int loopDepth) 
	{
		loopDepth = a_body1cont1(key, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && key,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(key), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddTaskActor*>(this)->actor_wait_state > 0) static_cast<AddTaskActor*>(this)->actor_wait_state = 0;
		static_cast<AddTaskActor*>(this)->ActorCallback< AddTaskActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< AddTaskActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddTaskActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddTaskActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskBucket> taskBucket;
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<Task> parentTask;
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	int priority;
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key begin;
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Key end;
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	TaskCompletionKey completionKey;
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Reference<TaskFuture> waitFor;
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	Version scheduledVersion;
															#line 19623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
};
// This generated class is to be used only via addTask()
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class AddTaskActor final : public Actor<Key>, public ActorCallback< AddTaskActor, 0, Key >, public FastAllocated<AddTaskActor>, public AddTaskActorState<AddTaskActor> {
															#line 19628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
	using FastAllocated<AddTaskActor>::operator new;
	using FastAllocated<AddTaskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8268218191229936384UL, 13182618089533065728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddTaskActor, 0, Key >;
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	AddTaskActor(Reference<ReadYourWritesTransaction> const& tr,Reference<TaskBucket> const& taskBucket,Reference<Task> const& parentTask,int const& priority,Key const& begin,Key const& end,TaskCompletionKey const& completionKey,Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(),Version const& scheduledVersion = invalidVersion) 
															#line 19645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		 : Actor<Key>(),
		   AddTaskActorState<AddTaskActor>(tr, taskBucket, parentTask, priority, begin, end, completionKey, waitFor, scheduledVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addTask", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6060296532077720576UL, 16456885635641163264UL);
		ActorExecutionContextHelper __helper(static_cast<AddTaskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addTask");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addTask", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddTaskActor, 0, Key >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
[[nodiscard]] static Future<Key> addTask( Reference<ReadYourWritesTransaction> const& tr, Reference<TaskBucket> const& taskBucket, Reference<Task> const& parentTask, int const& priority, Key const& begin, Key const& end, TaskCompletionKey const& completionKey, Reference<TaskFuture> const& waitFor = Reference<TaskFuture>(), Version const& scheduledVersion = invalidVersion ) {
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	return Future<Key>(new AddTaskActor(tr, taskBucket, parentTask, priority, begin, end, completionKey, waitFor, scheduledVersion));
															#line 19677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
}

#line 2483 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"

																#line 19682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
// This generated class is to be used only via _execute()
															#line 2484 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
template <class _executeActor>
															#line 2484 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
class _executeActorState {
															#line 19688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
public:
															#line 2484 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
	_executeActorState(Database const& cx,Reference<TaskBucket> const& taskBucket,Reference<FutureBucket> const& futureBucket,Reference<Task> const& task) 
															#line 2484 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
															#line 2484 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		 : cx(cx),
															#line 2484 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   taskBucket(taskBucket),
															#line 2484 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   futureBucket(futureBucket),
															#line 2484 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   task(task),
															#line 2488 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		   lock(new FlowLock(CLIENT_KNOBS->BACKUP_LOCK_BYTES))
															#line 19703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
	{
		fdb_probe_actor_create("_execute", reinterpret_cast<unsigned long>(this));

	}
	~_executeActorState() 
	{
		fdb_probe_actor_destroy("_execute", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2490 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkTaskVersion(cx, task, BackupRangeTaskFunc::name, BackupRangeTaskFunc::version);
															#line 2490 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_executeActor*>(this)->actor_wait_state = 1;
															#line 2490 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 0, Void >*>(static_cast<_executeActor*>(this)));
															#line 19725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_executeActorState();
		static_cast<_executeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2492 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		beginKey = Params.beginKey().get(task);
															#line 2493 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		endKey = Params.endKey().get(task);
															#line 2495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileBackupRangeStart") .suppressFor(60) .detail("BackupUID", BackupConfig(task).getUid()) .detail("BeginKey", Params.beginKey().get(task).printable()) .detail("EndKey", Params.endKey().get(task).printable()) .detail("TaskKey", task->key.printable());
															#line 2504 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (beginKey == endKey)
															#line 19754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2505 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 19758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2508 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_1 = runRYWTransaction( cx, [=](Reference<ReadYourWritesTransaction> tr) { return getBlockOfShards(tr, beginKey, endKey, 1); });
															#line 2508 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 2;
															#line 2508 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*>(static_cast<_executeActor*>(this)));
															#line 19773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2492 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		beginKey = Params.beginKey().get(task);
															#line 2493 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		endKey = Params.endKey().get(task);
															#line 2495 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		TraceEvent("FileBackupRangeStart") .suppressFor(60) .detail("BackupUID", BackupConfig(task).getUid()) .detail("BeginKey", Params.beginKey().get(task).printable()) .detail("EndKey", Params.endKey().get(task).printable()) .detail("TaskKey", task->key.printable());
															#line 2504 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (beginKey == endKey)
															#line 19788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		{
															#line 2505 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
			if (!static_cast<_executeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_executeActorState(); static_cast<_executeActor*>(this)->destroy(); return 0; }
															#line 19792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
			new (&static_cast<_executeActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_executeActorState();
			static_cast<_executeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2508 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_1 = runRYWTransaction( cx, [=](Reference<ReadYourWritesTransaction> tr) { return getBlockOfShards(tr, beginKey, endKey, 1); });
															#line 2508 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		if (static_cast<_executeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_executeActor*>(this)->actor_wait_state = 2;
															#line 2508 "/Users/ec2-user/foundationdb/fdbclient/FileBackupAgent.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _executeActor, 1, Standalone<VectorRef<KeyRef>> >*>(static_cast<_executeActor*>(this)));
															#line 19807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/FileBackupAgent.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_executeActor*>(this)->actor_wait_state > 0) static_cast<_executeActor*>(this)->actor_wait_state = 0;
		static_cast<_executeActor*>(this)->ActorCallback< _executeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _executeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _executeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_executeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Ca