#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
/*
 * BackupContainerFileSystem.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "flow/BooleanParam.h"
#ifdef BUILD_AZURE_BACKUP
#include "fdbclient/BackupContainerAzureBlobStore.h"
#endif
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbclient/BackupContainerLocalDirectory.h"
#include "fdbclient/BackupContainerS3BlobStore.h"
#include "fdbclient/JsonBuilder.h"
#include "flow/StreamCipher.h"
#include "flow/UnitTest.h"

#include <algorithm>
#include <cinttypes>

#include "flow/actorcompiler.h" // This must be the last #include.

class BackupContainerFileSystemImpl {
public:
	// TODO:  Do this more efficiently, as the range file list for a snapshot could potentially be hundreds of
	// megabytes.
																#line 45 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via readKeyspaceSnapshot()
															#line 43 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class ReadKeyspaceSnapshotActor>
															#line 43 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ReadKeyspaceSnapshotActorState {
															#line 51 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 43 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ReadKeyspaceSnapshotActorState(Reference<BackupContainerFileSystem> const& bc,KeyspaceSnapshotFile const& snapshot) 
															#line 43 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 43 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 43 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   snapshot(snapshot)
															#line 60 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this));

	}
	~ReadKeyspaceSnapshotActorState() 
	{
		fdb_probe_actor_destroy("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 49 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<std::vector<RangeFile>> __when_expr_0 = bc->listRangeFiles(snapshot.beginVersion, snapshot.endVersion);
															#line 49 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 77 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 1;
															#line 49 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >*>(static_cast<ReadKeyspaceSnapshotActor*>(this)));
															#line 82 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadKeyspaceSnapshotActorState();
		static_cast<ReadKeyspaceSnapshotActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<RangeFile> const& files,int loopDepth) 
	{
															#line 50 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		rangeIndex = std::map<std::string, RangeFile>();
															#line 51 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto& f : files ) {
															#line 52 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			rangeIndex[f.fileName] = std::move(f);
															#line 109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 56 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_1 = bc->readFile(snapshot.fileName);
															#line 56 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 2;
															#line 56 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >*>(static_cast<ReadKeyspaceSnapshotActor*>(this)));
															#line 120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<RangeFile> && files,int loopDepth) 
	{
															#line 50 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		rangeIndex = std::map<std::string, RangeFile>();
															#line 51 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto& f : files ) {
															#line 52 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			rangeIndex[f.fileName] = std::move(f);
															#line 133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 56 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_1 = bc->readFile(snapshot.fileName);
															#line 56 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 2;
															#line 56 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >*>(static_cast<ReadKeyspaceSnapshotActor*>(this)));
															#line 144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<RangeFile> const& files,int loopDepth) 
	{
		loopDepth = a_body1cont1(files, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<RangeFile> && files,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(files), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state > 0) static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 0;
		static_cast<ReadKeyspaceSnapshotActor*>(this)->ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >*,std::vector<RangeFile> const& value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >*,std::vector<RangeFile> && value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 57 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<int64_t> __when_expr_2 = f->size();
															#line 57 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 3;
															#line 57 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >*>(static_cast<ReadKeyspaceSnapshotActor*>(this)));
															#line 235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Reference<IAsyncFile> const& __f,int loopDepth) 
	{
															#line 56 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		f = __f;
															#line 244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<IAsyncFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state > 0) static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 0;
		static_cast<ReadKeyspaceSnapshotActor*>(this)->ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int64_t const& size,int loopDepth) 
	{
															#line 58 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		buf = makeString(size);
															#line 59 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(f->read(mutateString(buf), buf.size(), 0));
															#line 59 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 4;
															#line 59 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >*>(static_cast<ReadKeyspaceSnapshotActor*>(this)));
															#line 332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(int64_t && size,int loopDepth) 
	{
															#line 58 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		buf = makeString(size);
															#line 59 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(f->read(mutateString(buf), buf.size(), 0));
															#line 59 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 4;
															#line 59 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >*>(static_cast<ReadKeyspaceSnapshotActor*>(this)));
															#line 350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(int64_t const& size,int loopDepth) 
	{
		loopDepth = a_body1cont4(size, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t && size,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(size), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state > 0) static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 0;
		static_cast<ReadKeyspaceSnapshotActor*>(this)->ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 60 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		json_spirit::mValue json;
															#line 61 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!json_spirit::read_string(buf.toString(), json))
															#line 436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 62 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			fprintf(stderr, "ERROR: Failed to read data. Verify that backup and restore encryption keys match (if provided) or " "the data is corrupted.\n");
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_error(), loopDepth);
															#line 442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 68 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		JSONDoc doc(json);
															#line 69 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		Version v;
															#line 70 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!doc.tryGet("beginVersion", v) || v != snapshot.beginVersion)
															#line 450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 71 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 72 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!doc.tryGet("endVersion", v) || v != snapshot.endVersion)
															#line 458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 73 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 75 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		json_spirit::mValue& filesArray = doc.create("files");
															#line 76 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (filesArray.type() != json_spirit::array_type)
															#line 468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 77 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 79 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::vector<RangeFile> results;
															#line 80 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int missing = 0;
															#line 82 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& fileValue : filesArray.get_array() ) {
															#line 83 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (fileValue.type() != json_spirit::str_type)
															#line 482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 84 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
															#line 87 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			auto i = rangeIndex.find(fileValue.get_str());
															#line 88 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (i == rangeIndex.end())
															#line 492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 89 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent(SevError, "FileRestoreMissingRangeFile") .detail("URL", bc->getURL()) .detail("File", fileValue.get_str());
															#line 93 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				++missing;
															#line 498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (missing == 0)
															#line 502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 98 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				results.push_back(i->second);
															#line 506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 102 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (missing > 0)
															#line 511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 103 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevError, "FileRestoreMissingRangeFileSummary") .detail("URL", bc->getURL()) .detail("Count", missing);
															#line 107 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_missing_data(), loopDepth);
															#line 517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 111 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::map<std::string, KeyRange> fileKeyRanges;
															#line 112 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		JSONDoc ranges = doc.subDoc("keyRanges");
															#line 113 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto i : ranges.obj() ) {
															#line 114 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			const std::string& filename = i.first;
															#line 115 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			JSONDoc fields(i.second);
															#line 116 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::string begin, end;
															#line 117 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (fields.tryGet("beginKey", begin) && fields.tryGet("endKey", end))
															#line 533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 118 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent("ManifestFields") .detail("File", filename) .detail("Begin", printable(StringRef(begin))) .detail("End", printable(StringRef(end)));
															#line 122 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				fileKeyRanges.emplace(filename, KeyRange(KeyRangeRef(StringRef(begin), StringRef(end))));
															#line 539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
			else
			{
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent("MalFormattedManifest").detail("Key", filename);
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 129 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<ReadKeyspaceSnapshotActor*>(this)->SAV<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>>::futures) { (void)(std::make_pair(results, fileKeyRanges)); this->~ReadKeyspaceSnapshotActorState(); static_cast<ReadKeyspaceSnapshotActor*>(this)->destroy(); return 0; }
															#line 552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<ReadKeyspaceSnapshotActor*>(this)->SAV< std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >::value()) std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>(std::make_pair(results, fileKeyRanges));
		this->~ReadKeyspaceSnapshotActorState();
		static_cast<ReadKeyspaceSnapshotActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 60 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		json_spirit::mValue json;
															#line 61 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!json_spirit::read_string(buf.toString(), json))
															#line 566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 62 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			fprintf(stderr, "ERROR: Failed to read data. Verify that backup and restore encryption keys match (if provided) or " "the data is corrupted.\n");
															#line 65 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_error(), loopDepth);
															#line 572 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 68 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		JSONDoc doc(json);
															#line 69 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		Version v;
															#line 70 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!doc.tryGet("beginVersion", v) || v != snapshot.beginVersion)
															#line 580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 71 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 72 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!doc.tryGet("endVersion", v) || v != snapshot.endVersion)
															#line 588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 73 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 75 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		json_spirit::mValue& filesArray = doc.create("files");
															#line 76 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (filesArray.type() != json_spirit::array_type)
															#line 598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 77 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 79 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::vector<RangeFile> results;
															#line 80 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int missing = 0;
															#line 82 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& fileValue : filesArray.get_array() ) {
															#line 83 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (fileValue.type() != json_spirit::str_type)
															#line 612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 84 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
															#line 87 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			auto i = rangeIndex.find(fileValue.get_str());
															#line 88 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (i == rangeIndex.end())
															#line 622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 89 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent(SevError, "FileRestoreMissingRangeFile") .detail("URL", bc->getURL()) .detail("File", fileValue.get_str());
															#line 93 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				++missing;
															#line 628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
															#line 97 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (missing == 0)
															#line 632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 98 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				results.push_back(i->second);
															#line 636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 102 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (missing > 0)
															#line 641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 103 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevError, "FileRestoreMissingRangeFileSummary") .detail("URL", bc->getURL()) .detail("Count", missing);
															#line 107 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(restore_missing_data(), loopDepth);
															#line 647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 111 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::map<std::string, KeyRange> fileKeyRanges;
															#line 112 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		JSONDoc ranges = doc.subDoc("keyRanges");
															#line 113 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto i : ranges.obj() ) {
															#line 114 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			const std::string& filename = i.first;
															#line 115 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			JSONDoc fields(i.second);
															#line 116 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::string begin, end;
															#line 117 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (fields.tryGet("beginKey", begin) && fields.tryGet("endKey", end))
															#line 663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 118 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent("ManifestFields") .detail("File", filename) .detail("Begin", printable(StringRef(begin))) .detail("End", printable(StringRef(end)));
															#line 122 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				fileKeyRanges.emplace(filename, KeyRange(KeyRangeRef(StringRef(begin), StringRef(end))));
															#line 669 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
			else
			{
															#line 124 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent("MalFormattedManifest").detail("Key", filename);
															#line 125 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(restore_corrupted_data(), loopDepth);
															#line 677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 129 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<ReadKeyspaceSnapshotActor*>(this)->SAV<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>>::futures) { (void)(std::make_pair(results, fileKeyRanges)); this->~ReadKeyspaceSnapshotActorState(); static_cast<ReadKeyspaceSnapshotActor*>(this)->destroy(); return 0; }
															#line 682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<ReadKeyspaceSnapshotActor*>(this)->SAV< std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >::value()) std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>(std::make_pair(results, fileKeyRanges));
		this->~ReadKeyspaceSnapshotActorState();
		static_cast<ReadKeyspaceSnapshotActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state > 0) static_cast<ReadKeyspaceSnapshotActor*>(this)->actor_wait_state = 0;
		static_cast<ReadKeyspaceSnapshotActor*>(this)->ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 43 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 43 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	KeyspaceSnapshotFile snapshot;
															#line 50 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::map<std::string, RangeFile> rangeIndex;
															#line 56 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IAsyncFile> f;
															#line 58 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Standalone<StringRef> buf;
															#line 775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via readKeyspaceSnapshot()
															#line 43 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ReadKeyspaceSnapshotActor final : public Actor<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>>, public ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >, public ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >, public ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >, public ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >, public FastAllocated<ReadKeyspaceSnapshotActor>, public ReadKeyspaceSnapshotActorState<ReadKeyspaceSnapshotActor> {
															#line 780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<ReadKeyspaceSnapshotActor>::operator new;
	using FastAllocated<ReadKeyspaceSnapshotActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6383653971577274368UL, 15810367460102174720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >;
friend struct ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >;
friend struct ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >;
friend struct ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >;
															#line 43 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ReadKeyspaceSnapshotActor(Reference<BackupContainerFileSystem> const& bc,KeyspaceSnapshotFile const& snapshot) 
															#line 800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>>(),
		   ReadKeyspaceSnapshotActorState<ReadKeyspaceSnapshotActor>(bc, snapshot),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10202581819243385856UL, 520466022394986240UL);
		ActorExecutionContextHelper __helper(static_cast<ReadKeyspaceSnapshotActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readKeyspaceSnapshot");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readKeyspaceSnapshot", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadKeyspaceSnapshotActor, 0, std::vector<RangeFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadKeyspaceSnapshotActor, 1, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadKeyspaceSnapshotActor, 2, int64_t >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ReadKeyspaceSnapshotActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 43 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>> readKeyspaceSnapshot( Reference<BackupContainerFileSystem> const& bc, KeyspaceSnapshotFile const& snapshot ) {
															#line 43 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>>(new ReadKeyspaceSnapshotActor(bc, snapshot));
															#line 835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 131 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

	// Backup log types
	static constexpr Version NON_PARTITIONED_MUTATION_LOG = 0;
	static constexpr Version PARTITIONED_MUTATION_LOG = 1;

	// Find what should be the filename of a path by finding whatever is after the last forward or backward slash, or
	// failing to find those, the whole string.
	static std::string fileNameOnly(const std::string& path) {
		// Find the last forward slash position, defaulting to 0 if not found
		int pos = path.find_last_of('/');
		if (pos == std::string::npos) {
			pos = 0;
		}
		// Find the last backward slash position after pos, and update pos if found
		int b = path.find_last_of('\\', pos);
		if (b != std::string::npos) {
			pos = b;
		}
		return path.substr(pos + 1);
	}

	static bool pathToRangeFile(RangeFile& out, const std::string& path, int64_t size) {
		std::string name = fileNameOnly(path);
		RangeFile f;
		f.fileName = path;
		f.fileSize = size;
		int len;
		if (sscanf(name.c_str(), "range,%" SCNd64 ",%*[^,],%u%n", &f.version, &f.blockSize, &len) == 2 &&
		    len == name.size()) {
			out = f;
			return true;
		}
		return false;
	}

																#line 874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via writeKeyspaceSnapshotFile()
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class WriteKeyspaceSnapshotFileActor>
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteKeyspaceSnapshotFileActorState {
															#line 880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteKeyspaceSnapshotFileActorState(Reference<BackupContainerFileSystem> const& bc,std::vector<std::string> const& fileNames,std::vector<std::pair<Key, Key>> const& beginEndKeys,int64_t const& totalBytes,IncludeKeyRangeMap const& includeKeyRangeMap) 
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   fileNames(fileNames),
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   beginEndKeys(beginEndKeys),
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   totalBytes(totalBytes),
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   includeKeyRangeMap(includeKeyRangeMap)
															#line 895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this));

	}
	~WriteKeyspaceSnapshotFileActorState() 
	{
		fdb_probe_actor_destroy("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 171 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!fileNames.empty() && fileNames.size() == beginEndKeys.size());
															#line 173 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			minVer = std::numeric_limits<Version>::max();
															#line 174 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			maxVer = 0;
															#line 175 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			rf = RangeFile();
															#line 176 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			fileArray = json_spirit::mArray();
															#line 179 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			RangeForbody1Iterator0 = std::begin(fileNames);
															#line 920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKeyspaceSnapshotFileActorState();
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 191 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		json = json_spirit::mValue();
															#line 192 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		doc = JSONDoc(json);
															#line 194 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		doc.create("files") = std::move(fileArray);
															#line 195 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		doc.create("totalBytes") = totalBytes;
															#line 196 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		doc.create("beginVersion") = minVer;
															#line 197 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		doc.create("endVersion") = maxVer;
															#line 199 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (includeKeyRangeMap)
															#line 955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 200 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			auto ranges = doc.subDoc("keyRanges");
															#line 201 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			for(int i = 0;i < beginEndKeys.size();i++) {
															#line 202 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				auto fileDoc = ranges.subDoc(fileNames[i], false);
															#line 203 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				fileDoc.create("beginKey") = beginEndKeys[i].first.toString();
															#line 204 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				fileDoc.create("endKey") = beginEndKeys[i].second.toString();
															#line 967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield();
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 2;
															#line 208 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >*>(static_cast<WriteKeyspaceSnapshotFileActor*>(this)));
															#line 979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 179 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(RangeForbody1Iterator0 != std::end(fileNames)))
															#line 995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 179 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		const auto& f = *RangeForbody1Iterator0;
															#line 1001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 180 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (pathToRangeFile(rf, f, 0))
															#line 1005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 181 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				fileArray.push_back(f);
															#line 182 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (rf.version < minVer)
															#line 1011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 183 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					minVer = rf.version;
															#line 1015 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
															#line 184 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (rf.version > maxVer)
															#line 1019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 185 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					maxVer = rf.version;
															#line 1023 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
			}
			else
			{
															#line 187 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(restore_unknown_file_type(), std::max(0, loopDepth - 1));
															#line 1030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = yield();
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 1;
															#line 188 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >*>(static_cast<WriteKeyspaceSnapshotFileActor*>(this)));
															#line 1041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 179 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++RangeForbody1Iterator0;
															#line 1064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 209 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		docString = json_spirit::write_string(json);
															#line 211 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IBackupFile>> __when_expr_2 = bc->writeFile(format("snapshots/snapshot,%lld,%lld,%lld", minVer, maxVer, totalBytes));
															#line 211 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 3;
															#line 211 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >*>(static_cast<WriteKeyspaceSnapshotFileActor*>(this)));
															#line 1169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 209 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		docString = json_spirit::write_string(json);
															#line 211 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IBackupFile>> __when_expr_2 = bc->writeFile(format("snapshots/snapshot,%lld,%lld,%lld", minVer, maxVer, totalBytes));
															#line 211 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 3;
															#line 211 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >*>(static_cast<WriteKeyspaceSnapshotFileActor*>(this)));
															#line 1187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_3 = f->append(docString.data(), docString.size());
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 4;
															#line 213 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >*>(static_cast<WriteKeyspaceSnapshotFileActor*>(this)));
															#line 1278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Reference<IBackupFile> const& __f,int loopDepth) 
	{
															#line 211 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		f = __f;
															#line 1287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Reference<IBackupFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 214 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_4 = f->finish();
															#line 214 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 5;
															#line 214 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >*>(static_cast<WriteKeyspaceSnapshotFileActor*>(this)));
															#line 1373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 214 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_4 = f->finish();
															#line 214 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 5;
															#line 214 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >*>(static_cast<WriteKeyspaceSnapshotFileActor*>(this)));
															#line 1389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 216 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteKeyspaceSnapshotFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKeyspaceSnapshotFileActorState(); static_cast<WriteKeyspaceSnapshotFileActor*>(this)->destroy(); return 0; }
															#line 1473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<WriteKeyspaceSnapshotFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKeyspaceSnapshotFileActorState();
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 216 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteKeyspaceSnapshotFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteKeyspaceSnapshotFileActorState(); static_cast<WriteKeyspaceSnapshotFileActor*>(this)->destroy(); return 0; }
															#line 1485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<WriteKeyspaceSnapshotFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteKeyspaceSnapshotFileActorState();
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<WriteKeyspaceSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKeyspaceSnapshotFileActor*>(this)->ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<std::string> fileNames;
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<std::pair<Key, Key>> beginEndKeys;
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int64_t totalBytes;
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	IncludeKeyRangeMap includeKeyRangeMap;
															#line 173 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version minVer;
															#line 174 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version maxVer;
															#line 175 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	RangeFile rf;
															#line 176 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	json_spirit::mArray fileArray;
															#line 179 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	decltype(std::begin(std::declval<std::vector<std::string>>())) RangeForbody1Iterator0;
															#line 191 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	json_spirit::mValue json;
															#line 192 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	JSONDoc doc;
															#line 209 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string docString;
															#line 211 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> f;
															#line 1596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via writeKeyspaceSnapshotFile()
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteKeyspaceSnapshotFileActor final : public Actor<Void>, public ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >, public ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >, public ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >, public ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >, public ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >, public FastAllocated<WriteKeyspaceSnapshotFileActor>, public WriteKeyspaceSnapshotFileActorState<WriteKeyspaceSnapshotFileActor> {
															#line 1601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<WriteKeyspaceSnapshotFileActor>::operator new;
	using FastAllocated<WriteKeyspaceSnapshotFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10494263748123348480UL, 16457965713743283968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >;
friend struct ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >;
friend struct ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >;
friend struct ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >;
friend struct ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >;
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteKeyspaceSnapshotFileActor(Reference<BackupContainerFileSystem> const& bc,std::vector<std::string> const& fileNames,std::vector<std::pair<Key, Key>> const& beginEndKeys,int64_t const& totalBytes,IncludeKeyRangeMap const& includeKeyRangeMap) 
															#line 1622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   WriteKeyspaceSnapshotFileActorState<WriteKeyspaceSnapshotFileActor>(bc, fileNames, beginEndKeys, totalBytes, includeKeyRangeMap),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15578544106502796800UL, 7743257832792106496UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeyspaceSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKeyspaceSnapshotFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKeyspaceSnapshotFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKeyspaceSnapshotFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKeyspaceSnapshotFileActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteKeyspaceSnapshotFileActor, 2, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WriteKeyspaceSnapshotFileActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WriteKeyspaceSnapshotFileActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> writeKeyspaceSnapshotFile( Reference<BackupContainerFileSystem> const& bc, std::vector<std::string> const& fileNames, std::vector<std::pair<Key, Key>> const& beginEndKeys, int64_t const& totalBytes, IncludeKeyRangeMap const& includeKeyRangeMap ) {
															#line 166 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new WriteKeyspaceSnapshotFileActor(bc, fileNames, beginEndKeys, totalBytes, includeKeyRangeMap));
															#line 1658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 218 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

																#line 1663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via dumpFileList()
															#line 219 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class DumpFileListActor>
															#line 219 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class DumpFileListActorState {
															#line 1669 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 219 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	DumpFileListActorState(Reference<BackupContainerFileSystem> const& bc,Version const& begin,Version const& end) 
															#line 219 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 219 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 219 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   begin(begin),
															#line 219 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   end(end),
															#line 222 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   fRanges(bc->listRangeFiles(begin, end)),
															#line 223 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   fSnapshots(bc->listKeyspaceSnapshots(begin, end)),
															#line 224 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   logs(),
															#line 225 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   pLogs()
															#line 1688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("dumpFileList", reinterpret_cast<unsigned long>(this));

	}
	~DumpFileListActorState() 
	{
		fdb_probe_actor_destroy("dumpFileList", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 227 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(fRanges) && success(fSnapshots) && store(logs, bc->listLogFiles(begin, end, false)) && store(pLogs, bc->listLogFiles(begin, end, true));
															#line 227 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<DumpFileListActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DumpFileListActor*>(this)->actor_wait_state = 1;
															#line 227 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DumpFileListActor, 0, Void >*>(static_cast<DumpFileListActor*>(this)));
															#line 1710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpFileListActorState();
		static_cast<DumpFileListActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 229 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs.insert(logs.end(), std::make_move_iterator(pLogs.begin()), std::make_move_iterator(pLogs.end()));
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<DumpFileListActor*>(this)->SAV<BackupFileList>::futures) { (void)(BackupFileList({ fRanges.get(), std::move(logs), fSnapshots.get() })); this->~DumpFileListActorState(); static_cast<DumpFileListActor*>(this)->destroy(); return 0; }
															#line 1735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<DumpFileListActor*>(this)->SAV< BackupFileList >::value()) BackupFileList(BackupFileList({ fRanges.get(), std::move(logs), fSnapshots.get() }));
		this->~DumpFileListActorState();
		static_cast<DumpFileListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 229 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs.insert(logs.end(), std::make_move_iterator(pLogs.begin()), std::make_move_iterator(pLogs.end()));
															#line 231 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<DumpFileListActor*>(this)->SAV<BackupFileList>::futures) { (void)(BackupFileList({ fRanges.get(), std::move(logs), fSnapshots.get() })); this->~DumpFileListActorState(); static_cast<DumpFileListActor*>(this)->destroy(); return 0; }
															#line 1749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<DumpFileListActor*>(this)->SAV< BackupFileList >::value()) BackupFileList(BackupFileList({ fRanges.get(), std::move(logs), fSnapshots.get() }));
		this->~DumpFileListActorState();
		static_cast<DumpFileListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpFileListActor*>(this)->actor_wait_state > 0) static_cast<DumpFileListActor*>(this)->actor_wait_state = 0;
		static_cast<DumpFileListActor*>(this)->ActorCallback< DumpFileListActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpFileListActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpFileList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpFileListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpFileList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DumpFileListActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpFileList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpFileListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpFileList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DumpFileListActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpFileList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpFileListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpFileList", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 219 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 219 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version begin;
															#line 219 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version end;
															#line 222 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Future<std::vector<RangeFile>> fRanges;
															#line 223 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Future<std::vector<KeyspaceSnapshotFile>> fSnapshots;
															#line 224 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> logs;
															#line 225 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> pLogs;
															#line 1846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via dumpFileList()
															#line 219 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class DumpFileListActor final : public Actor<BackupFileList>, public ActorCallback< DumpFileListActor, 0, Void >, public FastAllocated<DumpFileListActor>, public DumpFileListActorState<DumpFileListActor> {
															#line 1851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<DumpFileListActor>::operator new;
	using FastAllocated<DumpFileListActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18220320023280394752UL, 730029376571279616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<BackupFileList>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DumpFileListActor, 0, Void >;
															#line 219 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	DumpFileListActor(Reference<BackupContainerFileSystem> const& bc,Version const& begin,Version const& end) 
															#line 1868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<BackupFileList>(),
		   DumpFileListActorState<DumpFileListActor>(bc, begin, end),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dumpFileList", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18146546089268790784UL, 16053391606809997568UL);
		ActorExecutionContextHelper __helper(static_cast<DumpFileListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dumpFileList");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dumpFileList", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DumpFileListActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 219 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<BackupFileList> dumpFileList( Reference<BackupContainerFileSystem> const& bc, Version const& begin, Version const& end ) {
															#line 219 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<BackupFileList>(new DumpFileListActor(bc, begin, end));
															#line 1900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 233 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

	static Version resolveRelativeVersion(Optional<Version> max, Version v, const char* name, Error e) {
		if (v == invalidVersion) {
			TraceEvent(SevError, "BackupExpireInvalidVersion").detail(name, v);
			throw e;
		}
		if (v < 0) {
			if (!max.present()) {
				TraceEvent(SevError, "BackupExpireCannotResolveRelativeVersion").detail(name, v);
				throw e;
			}
			v += max.get();
		}
		return v;
	}

	// For a list of log files specified by their indices (of the same tag),
	// returns if they are continuous in the range [begin, end]. If "tags" is not
	// nullptr, then it will be populated with [begin, end] -> tags, where next
	// pair's begin <= previous pair's end + 1. On return, the last pair's end
	// version (inclusive) gives the continuous range from begin.
	static bool isContinuous(const std::vector<LogFile>& files,
	                         const std::vector<int>& indices,
	                         Version begin,
	                         Version end,
	                         std::map<std::pair<Version, Version>, int>* tags) {
		Version lastBegin = invalidVersion;
		Version lastEnd = invalidVersion;
		int lastTags = -1;

		ASSERT(tags == nullptr || tags->empty());
		for (int idx : indices) {
			const LogFile& file = files[idx];
			if (lastEnd == invalidVersion) {
				if (file.beginVersion > begin) {
					// the first version of the first file must be smaller or equal to the desired beginVersion
					return false;
				}
				if (file.endVersion > begin) {
					lastBegin = begin;
					lastTags = file.totalTags;
				} else {
					// if endVerison of file is smaller than desired beginVersion, then do not include this file
					continue;
				}
			} else if (lastEnd < file.beginVersion) {
				if (tags != nullptr) {
					tags->emplace(std::make_pair(lastBegin, lastEnd - 1), lastTags);
				}
				return false;
			}

			if (lastTags != file.totalTags) {
				if (tags != nullptr) {
					tags->emplace(std::make_pair(lastBegin, file.beginVersion - 1), lastTags);
				}
				lastBegin = file.beginVersion;
				lastTags = file.totalTags;
			}
			lastEnd = file.endVersion;
			if (lastEnd > end)
				break;
		}
		if (tags != nullptr && lastBegin != invalidVersion) {
			tags->emplace(std::make_pair(lastBegin, std::min(end, lastEnd - 1)), lastTags);
		}
		return lastBegin != invalidVersion && lastEnd > end;
	}

	// Returns the end version such that [begin, end] is continuous.
	// "logs" should be already sorted.
	static Version getPartitionedLogsContinuousEndVersion(const std::vector<LogFile>& logs, Version begin) {
		Version end = 0;

		std::map<int, std::vector<int>> tagIndices; // tagId -> indices in files
		for (int i = 0; i < logs.size(); i++) {
			ASSERT_GE(logs[i].tagId, 0);
			ASSERT_LT(logs[i].tagId, logs[i].totalTags);
			auto& indices = tagIndices[logs[i].tagId];
			// filter out if indices.back() is subset of files[i] or vice versa
			if (!indices.empty()) {
				if (logs[indices.back()].isSubset(logs[i])) {
					ASSERT_LE(logs[indices.back()].fileSize, logs[i].fileSize);
					indices.back() = i;
				} else if (!logs[i].isSubset(logs[indices.back()])) {
					indices.push_back(i);
				}
			} else {
				indices.push_back(i);
			}
			end = std::max(end, logs[i].endVersion - 1);
		}
		TraceEvent("ContinuousLogEnd").detail("Begin", begin).detail("InitVersion", end);

		// check partition 0 is continuous in [begin, end] and create a map of ranges to partitions
		std::map<std::pair<Version, Version>, int> tags; // range [start, end] -> partitions
		isContinuous(logs, tagIndices[0], begin, end, &tags);
		if (tags.empty() || end <= begin)
			return 0;
		end = std::min(end, tags.rbegin()->first.second);
		TraceEvent("ContinuousLogEnd").detail("Partition", 0).detail("EndVersion", end).detail("Begin", begin);

		// for each range in tags, check all partitions from 1 are continuous
		Version lastEnd = begin;
		for (const auto& [beginEnd, count] : tags) {
			Version tagEnd = beginEnd.second; // This range's minimum continuous partition version
			for (int i = 1; i < count; i++) {
				std::map<std::pair<Version, Version>, int> rangeTags;
				isContinuous(logs, tagIndices[i], beginEnd.first, beginEnd.second, &rangeTags);
				tagEnd = rangeTags.empty() ? 0 : std::min(tagEnd, rangeTags.rbegin()->first.second);
				TraceEvent("ContinuousLogEnd")
				    .detail("Partition", i)
				    .detail("EndVersion", tagEnd)
				    .detail("RangeBegin", beginEnd.first)
				    .detail("RangeEnd", beginEnd.second);
				if (tagEnd == 0)
					return lastEnd == begin ? 0 : lastEnd;
			}
			if (tagEnd < beginEnd.second) {
				return tagEnd;
			}
			lastEnd = beginEnd.second;
		}

		return end;
	}

	// Analyze partitioned logs and set contiguousLogEnd for "desc" if larger
	// than the "scanBegin" version.
	static void updatePartitionedLogsContinuousEnd(BackupDescription* desc,
	                                               const std::vector<LogFile>& logs,
	                                               const Version scanBegin,
	                                               const Version scanEnd) {
		if (logs.empty())
			return;

		Version snapshotBeginVersion = desc->snapshots.size() > 0 ? desc->snapshots[0].beginVersion : invalidVersion;
		Version begin = std::max(scanBegin, desc->minLogBegin.get());
		TraceEvent("ContinuousLogEnd")
		    .detail("ScanBegin", scanBegin)
		    .detail("ScanEnd", scanEnd)
		    .detail("Begin", begin)
		    .detail("ContiguousLogEnd", desc->contiguousLogEnd.get());
		for (const auto& file : logs) {
			if (file.beginVersion > begin) {
				if (scanBegin > 0)
					return;

				// scanBegin is 0
				desc->minLogBegin = file.beginVersion;
				begin = file.beginVersion;
			}

			Version ver = getPartitionedLogsContinuousEndVersion(logs, begin);
			if (ver >= desc->contiguousLogEnd.get()) {
				// contiguousLogEnd is not inclusive, so +1 here.
				desc->contiguousLogEnd.get() = ver + 1;
				TraceEvent("UpdateContinuousLogEnd").detail("Version", ver + 1);
				if (ver > snapshotBeginVersion)
					return;
			}
		}
	}

	// Computes the continuous end version for non-partitioned mutation logs up to
	// the "targetVersion". If "outLogs" is not nullptr, it will be updated with
	// continuous log files. "*end" is updated with the continuous end version.
	static void computeRestoreEndVersion(const std::vector<LogFile>& logs,
	                                     std::vector<LogFile>* outLogs,
	                                     Version* end,
	                                     Version targetVersion) {
		auto i = logs.begin();

		// Add logs to restorable logs set until continuity is broken OR we reach targetVersion
		while (i != logs.end()) {
			if (i->beginVersion > *end || i->beginVersion > targetVersion)
				break;

			// If the next link in the log chain is found, update the end
			if (i->beginVersion == *end) {
				if (outLogs != nullptr)
					outLogs->push_back(*i);
				*end = i->endVersion;
			}
			++i;
		}
	}

	// Checks if list of sorted logfiles have the logs from snapshotBeginVersion to snapshotEndversion.
	// Which means the sorted log files(have beginVersion and endVersion) should cover
	// all the versions between snapshotBegingVersion and snapshotEndversion.
	// Note: logs should be pre-sorted according to version order.
	static bool hasContinuousLogsForSnapshot(const std::vector<LogFile>& logs,
	                                         Version snapshotBeginVersion,
	                                         Version snapshotEndVersion) {
		auto it = logs.begin();

		// find the first mutation log file that covers snapshotBeginVersion
		while (it != logs.end()) {
			if (it->beginVersion <= snapshotBeginVersion && it->endVersion > snapshotBeginVersion)
				break;
			++it;
		}

		// no log find found covering snaphostBeginVersion, return false
		if (it == logs.end())
			return false;

		// If current log entry(it), covers the entire snapshot, return true
		if (it->endVersion > snapshotEndVersion)
			return true;

		// Iterate over the next logs, check if they are continuous and if
		// the log file is covering the snapshot.
		Version prevEnd = it->endVersion;
		++it;

		while (it != logs.end()) {
			if (it->beginVersion == prevEnd &&
			    it->endVersion > snapshotEndVersion) // continuous logs until snapshot is covered
				return true;
			else if (it->beginVersion != prevEnd) // not continuous logs
				return false;

			prevEnd = it->endVersion;
			++it;
		} // comes out if the logs are not found until snapshotEndVersion.

		return prevEnd > snapshotEndVersion;
	}

	// Find the continuous log end version starting from beginVersion in the
	// given list of sorted logfiles.
	// Note: logs should be pre-sorted according to version order.
	static Version findContinuousLogEnd(const std::vector<LogFile>& logs, Version beginVersion) {
		auto it = logs.begin();

		// find the first mutation log file that covers beginVersion
		while (it != logs.end()) {
			if (it->beginVersion <= beginVersion && it->endVersion > beginVersion)
				break;
			++it;
		}

		// no log find found covering beginVersion, return invalidVersion
		if (it == logs.end())
			return invalidVersion;

		// Iterate over the next logs, check if they are continuous
		Version prevEnd = it->endVersion;
		++it;

		while (it != logs.end()) {
			if (it->beginVersion != prevEnd) // not continuous logs
				return prevEnd;

			prevEnd = it->endVersion;
			++it;
		} // out of logs.

		return prevEnd;
	}

																#line 2167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via describeBackup()
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class DescribeBackupActor>
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class DescribeBackupActorState {
															#line 2173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	DescribeBackupActorState(Reference<BackupContainerFileSystem> const& bc,bool const& deepScan,Version const& logStartVersionOverride) 
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   deepScan(deepScan),
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   logStartVersionOverride(logStartVersionOverride),
															#line 499 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   desc()
															#line 2186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("describeBackup", reinterpret_cast<unsigned long>(this));

	}
	~DescribeBackupActorState() 
	{
		fdb_probe_actor_destroy("describeBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 500 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.url = bc->getURL();
															#line 501 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.proxy = bc->getProxy();
															#line 503 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent("BackupContainerDescribe1") .detail("URL", bc->getURL()) .detail("LogStartVersionOverride", logStartVersionOverride) .detail("DeepScan", deepScan);
															#line 508 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<bool> __when_expr_0 = bc->exists();
															#line 508 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DescribeBackupActor*>(this)->actor_wait_state = 1;
															#line 508 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 0, bool >*>(static_cast<DescribeBackupActor*>(this)));
															#line 2214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DescribeBackupActorState();
		static_cast<DescribeBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& e,int loopDepth) 
	{
															#line 509 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!e)
															#line 2237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 510 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "BackupContainerDoesNotExist").detail("URL", bc->getURL());
															#line 511 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(backup_does_not_exist(), loopDepth);
															#line 2243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 517 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (logStartVersionOverride != invalidVersion && logStartVersionOverride < 0)
															#line 2247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 518 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<BackupDescription> __when_expr_1 = bc->describeBackup(false, invalidVersion);
															#line 518 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DescribeBackupActor*>(this)->actor_wait_state = 2;
															#line 518 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 1, BackupDescription >*>(static_cast<DescribeBackupActor*>(this)));
															#line 2258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(bool && e,int loopDepth) 
	{
															#line 509 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!e)
															#line 2272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 510 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "BackupContainerDoesNotExist").detail("URL", bc->getURL());
															#line 511 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(backup_does_not_exist(), loopDepth);
															#line 2278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 517 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (logStartVersionOverride != invalidVersion && logStartVersionOverride < 0)
															#line 2282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 518 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<BackupDescription> __when_expr_1 = bc->describeBackup(false, invalidVersion);
															#line 518 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DescribeBackupActor*>(this)->actor_wait_state = 2;
															#line 518 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 1, BackupDescription >*>(static_cast<DescribeBackupActor*>(this)));
															#line 2293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(bool const& e,int loopDepth) 
	{
		loopDepth = a_body1cont1(e, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && e,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(e), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state > 0) static_cast<DescribeBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DescribeBackupActor*>(this)->ActorCallback< DescribeBackupActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DescribeBackupActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaLogBegin = Optional<Version>();
															#line 525 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaLogEnd = Optional<Version>();
															#line 526 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaExpiredEnd = Optional<Version>();
															#line 527 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaUnreliableEnd = Optional<Version>();
															#line 528 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaLogType = Optional<Version>();
															#line 529 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		fileLevelEncryption = Optional<Version>();
															#line 531 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::vector<Future<Void>> metaReads;
															#line 532 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaReads.push_back(store(metaExpiredEnd, bc->expiredEndVersion().get()));
															#line 533 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaReads.push_back(store(metaUnreliableEnd, bc->unreliableEndVersion().get()));
															#line 534 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaReads.push_back(store(metaLogType, bc->logType().get()));
															#line 535 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		metaReads.push_back(store(fileLevelEncryption, bc->fileLevelEncryption().get()));
															#line 538 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!deepScan)
															#line 2404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 539 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaReads.push_back(store(metaLogBegin, bc->logBeginVersion().get()));
															#line 540 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaReads.push_back(store(metaLogEnd, bc->logEndVersion().get()));
															#line 2410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 543 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(metaReads);
															#line 543 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DescribeBackupActor*>(this)->actor_wait_state = 3;
															#line 543 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 2, Void >*>(static_cast<DescribeBackupActor*>(this)));
															#line 2421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(BackupDescription const& tmp,int loopDepth) 
	{
															#line 519 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logStartVersionOverride = resolveRelativeVersion( tmp.maxLogEnd, logStartVersionOverride, "LogStartVersionOverride", invalid_option_value());
															#line 2430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(BackupDescription && tmp,int loopDepth) 
	{
															#line 519 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logStartVersionOverride = resolveRelativeVersion( tmp.maxLogEnd, logStartVersionOverride, "LogStartVersionOverride", invalid_option_value());
															#line 2439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(BackupDescription const& tmp,int loopDepth) 
	{
		loopDepth = a_body1cont4(tmp, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(BackupDescription && tmp,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(tmp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state > 0) static_cast<DescribeBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DescribeBackupActor*>(this)->ActorCallback< DescribeBackupActor, 1, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 1, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 1, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DescribeBackupActor, 1, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 545 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent("BackupContainerDescribe2") .detail("URL", bc->getURL()) .detail("LogStartVersionOverride", logStartVersionOverride) .detail("ExpiredEndVersion", metaExpiredEnd.orDefault(invalidVersion)) .detail("UnreliableEndVersion", metaUnreliableEnd.orDefault(invalidVersion)) .detail("LogBeginVersion", metaLogBegin.orDefault(invalidVersion)) .detail("LogEndVersion", metaLogEnd.orDefault(invalidVersion)) .detail("LogType", metaLogType.orDefault(-1));
															#line 556 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (logStartVersionOverride != invalidVersion && metaUnreliableEnd.orDefault(invalidVersion) < logStartVersionOverride)
															#line 2525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 558 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaUnreliableEnd = logStartVersionOverride;
															#line 2529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 567 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!metaLogBegin.present() || !metaLogEnd.present() || metaLogEnd.get() <= metaLogBegin.get() || metaLogEnd.get() < metaExpiredEnd.orDefault(invalidVersion) || metaLogEnd.get() < metaUnreliableEnd.orDefault(invalidVersion))
															#line 2533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 570 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "BackupContainerMetadataInvalid") .detail("URL", bc->getURL()) .detail("ExpiredEndVersion", metaExpiredEnd.orDefault(invalidVersion)) .detail("UnreliableEndVersion", metaUnreliableEnd.orDefault(invalidVersion)) .detail("LogBeginVersion", metaLogBegin.orDefault(invalidVersion)) .detail("LogEndVersion", metaLogEnd.orDefault(invalidVersion));
															#line 577 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaLogBegin = Optional<Version>();
															#line 578 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaLogEnd = Optional<Version>();
															#line 2541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 584 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!metaUnreliableEnd.present() || metaUnreliableEnd.get() < metaExpiredEnd.orDefault(0))
															#line 2545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 585 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaUnreliableEnd = metaExpiredEnd;
															#line 2549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 587 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc.unreliableEndVersion = metaUnreliableEnd;
															#line 588 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc.expiredEndVersion = metaExpiredEnd;
															#line 592 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		scanBegin = desc.unreliableEndVersion.orDefault(0);
															#line 593 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		scanEnd = std::numeric_limits<Version>::max();
															#line 597 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (metaLogBegin.present() && metaLogEnd.present())
															#line 2561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 600 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.minLogBegin = std::max(metaLogBegin.get(), desc.unreliableEndVersion.orDefault(0));
															#line 604 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.maxLogEnd = metaLogEnd.get();
															#line 605 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.contiguousLogEnd = desc.maxLogEnd;
															#line 608 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			scanBegin = desc.contiguousLogEnd.get();
															#line 2571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 611 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs = std::vector<LogFile>();
															#line 612 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		plogs = std::vector<LogFile>();
															#line 613 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent("BackupContainerListFiles").detail("URL", bc->getURL());
															#line 615 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(logs, bc->listLogFiles(scanBegin, scanEnd, false)) && store(plogs, bc->listLogFiles(scanBegin, scanEnd, true)) && store(desc.snapshots, bc->listKeyspaceSnapshots());
															#line 615 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<DescribeBackupActor*>(this)->actor_wait_state = 4;
															#line 615 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 3, Void >*>(static_cast<DescribeBackupActor*>(this)));
															#line 2588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 545 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent("BackupContainerDescribe2") .detail("URL", bc->getURL()) .detail("LogStartVersionOverride", logStartVersionOverride) .detail("ExpiredEndVersion", metaExpiredEnd.orDefault(invalidVersion)) .detail("UnreliableEndVersion", metaUnreliableEnd.orDefault(invalidVersion)) .detail("LogBeginVersion", metaLogBegin.orDefault(invalidVersion)) .detail("LogEndVersion", metaLogEnd.orDefault(invalidVersion)) .detail("LogType", metaLogType.orDefault(-1));
															#line 556 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (logStartVersionOverride != invalidVersion && metaUnreliableEnd.orDefault(invalidVersion) < logStartVersionOverride)
															#line 2599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 558 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaUnreliableEnd = logStartVersionOverride;
															#line 2603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 567 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!metaLogBegin.present() || !metaLogEnd.present() || metaLogEnd.get() <= metaLogBegin.get() || metaLogEnd.get() < metaExpiredEnd.orDefault(invalidVersion) || metaLogEnd.get() < metaUnreliableEnd.orDefault(invalidVersion))
															#line 2607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 570 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "BackupContainerMetadataInvalid") .detail("URL", bc->getURL()) .detail("ExpiredEndVersion", metaExpiredEnd.orDefault(invalidVersion)) .detail("UnreliableEndVersion", metaUnreliableEnd.orDefault(invalidVersion)) .detail("LogBeginVersion", metaLogBegin.orDefault(invalidVersion)) .detail("LogEndVersion", metaLogEnd.orDefault(invalidVersion));
															#line 577 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaLogBegin = Optional<Version>();
															#line 578 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaLogEnd = Optional<Version>();
															#line 2615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 584 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!metaUnreliableEnd.present() || metaUnreliableEnd.get() < metaExpiredEnd.orDefault(0))
															#line 2619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 585 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			metaUnreliableEnd = metaExpiredEnd;
															#line 2623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 587 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc.unreliableEndVersion = metaUnreliableEnd;
															#line 588 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc.expiredEndVersion = metaExpiredEnd;
															#line 592 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		scanBegin = desc.unreliableEndVersion.orDefault(0);
															#line 593 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		scanEnd = std::numeric_limits<Version>::max();
															#line 597 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (metaLogBegin.present() && metaLogEnd.present())
															#line 2635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 600 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.minLogBegin = std::max(metaLogBegin.get(), desc.unreliableEndVersion.orDefault(0));
															#line 604 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.maxLogEnd = metaLogEnd.get();
															#line 605 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.contiguousLogEnd = desc.maxLogEnd;
															#line 608 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			scanBegin = desc.contiguousLogEnd.get();
															#line 2645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 611 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs = std::vector<LogFile>();
															#line 612 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		plogs = std::vector<LogFile>();
															#line 613 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent("BackupContainerListFiles").detail("URL", bc->getURL());
															#line 615 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(logs, bc->listLogFiles(scanBegin, scanEnd, false)) && store(plogs, bc->listLogFiles(scanBegin, scanEnd, true)) && store(desc.snapshots, bc->listKeyspaceSnapshots());
															#line 615 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<DescribeBackupActor*>(this)->actor_wait_state = 4;
															#line 615 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 3, Void >*>(static_cast<DescribeBackupActor*>(this)));
															#line 2662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state > 0) static_cast<DescribeBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DescribeBackupActor*>(this)->ActorCallback< DescribeBackupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DescribeBackupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 619 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent("BackupContainerListFiles") .detail("URL", bc->getURL()) .detail("LogFiles", logs.size()) .detail("PLogsFiles", plogs.size()) .detail("Snapshots", desc.snapshots.size());
															#line 625 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (plogs.size() > 0)
															#line 2748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 626 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.partitioned = true;
															#line 627 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			logs.swap(plogs);
															#line 2754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
		else
		{
															#line 629 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.partitioned = metaLogType.present() && metaLogType.get() == BackupContainerFileSystemImpl::PARTITIONED_MUTATION_LOG;
															#line 2760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 633 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (fileLevelEncryption.present() && fileLevelEncryption.get() != 0)
															#line 2764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 634 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.fileLevelEncryption = true;
															#line 2768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
		else
		{
															#line 636 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.fileLevelEncryption = false;
															#line 2774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 640 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::sort(logs.begin(), logs.end());
															#line 643 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logs.empty())
															#line 2780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 644 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.maxLogEnd = logs.rbegin()->endVersion;
															#line 646 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!desc.contiguousLogEnd.present())
															#line 2786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 647 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				desc.minLogBegin = logs.begin()->beginVersion;
															#line 648 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.partitioned)
															#line 2792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 651 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.contiguousLogEnd = logs.begin()->beginVersion;
															#line 2796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
				else
				{
															#line 653 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.contiguousLogEnd = logs.begin()->beginVersion;
															#line 2802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
			}
															#line 657 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (desc.partitioned)
															#line 2807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 658 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				updatePartitionedLogsContinuousEnd(&desc, logs, scanBegin, scanEnd);
															#line 2811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
			else
			{
															#line 660 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				Version& end = desc.contiguousLogEnd.get();
															#line 661 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				computeRestoreEndVersion(logs, nullptr, &end, std::numeric_limits<Version>::max());
															#line 2819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 667 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (logStartVersionOverride == invalidVersion)
															#line 2824 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			try {
															#line 673 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				updates = Void();
															#line 675 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.minLogBegin.present() && metaLogBegin != desc.minLogBegin)
															#line 2831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 676 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					updates = updates && bc->logBeginVersion().set(desc.minLogBegin.get());
															#line 2835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
															#line 679 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.contiguousLogEnd.present() && metaLogEnd != desc.contiguousLogEnd)
															#line 2839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 680 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					updates = updates && bc->logEndVersion().set(desc.contiguousLogEnd.get());
															#line 2843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
															#line 683 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!metaLogType.present())
															#line 2847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 684 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					updates = updates && bc->logType().set(desc.partitioned ? BackupContainerFileSystemImpl::PARTITIONED_MUTATION_LOG : BackupContainerFileSystemImpl::NON_PARTITIONED_MUTATION_LOG);
															#line 2851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
															#line 690 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Void> __when_expr_4 = updates;
															#line 690 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 2857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont8Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
				static_cast<DescribeBackupActor*>(this)->actor_wait_state = 5;
															#line 690 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 4, Void >*>(static_cast<DescribeBackupActor*>(this)));
															#line 2862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont8Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 619 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent("BackupContainerListFiles") .detail("URL", bc->getURL()) .detail("LogFiles", logs.size()) .detail("PLogsFiles", plogs.size()) .detail("Snapshots", desc.snapshots.size());
															#line 625 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (plogs.size() > 0)
															#line 2884 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 626 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.partitioned = true;
															#line 627 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			logs.swap(plogs);
															#line 2890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
		else
		{
															#line 629 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.partitioned = metaLogType.present() && metaLogType.get() == BackupContainerFileSystemImpl::PARTITIONED_MUTATION_LOG;
															#line 2896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 633 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (fileLevelEncryption.present() && fileLevelEncryption.get() != 0)
															#line 2900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 634 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.fileLevelEncryption = true;
															#line 2904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
		else
		{
															#line 636 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.fileLevelEncryption = false;
															#line 2910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 640 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::sort(logs.begin(), logs.end());
															#line 643 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logs.empty())
															#line 2916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 644 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.maxLogEnd = logs.rbegin()->endVersion;
															#line 646 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!desc.contiguousLogEnd.present())
															#line 2922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 647 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				desc.minLogBegin = logs.begin()->beginVersion;
															#line 648 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.partitioned)
															#line 2928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 651 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.contiguousLogEnd = logs.begin()->beginVersion;
															#line 2932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
				else
				{
															#line 653 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.contiguousLogEnd = logs.begin()->beginVersion;
															#line 2938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
			}
															#line 657 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (desc.partitioned)
															#line 2943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 658 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				updatePartitionedLogsContinuousEnd(&desc, logs, scanBegin, scanEnd);
															#line 2947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
			else
			{
															#line 660 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				Version& end = desc.contiguousLogEnd.get();
															#line 661 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				computeRestoreEndVersion(logs, nullptr, &end, std::numeric_limits<Version>::max());
															#line 2955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 667 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (logStartVersionOverride == invalidVersion)
															#line 2960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			try {
															#line 673 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				updates = Void();
															#line 675 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.minLogBegin.present() && metaLogBegin != desc.minLogBegin)
															#line 2967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 676 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					updates = updates && bc->logBeginVersion().set(desc.minLogBegin.get());
															#line 2971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
															#line 679 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.contiguousLogEnd.present() && metaLogEnd != desc.contiguousLogEnd)
															#line 2975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 680 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					updates = updates && bc->logEndVersion().set(desc.contiguousLogEnd.get());
															#line 2979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
															#line 683 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!metaLogType.present())
															#line 2983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 684 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					updates = updates && bc->logType().set(desc.partitioned ? BackupContainerFileSystemImpl::PARTITIONED_MUTATION_LOG : BackupContainerFileSystemImpl::NON_PARTITIONED_MUTATION_LOG);
															#line 2987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
															#line 690 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Void> __when_expr_4 = updates;
															#line 690 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 2993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont8Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
				static_cast<DescribeBackupActor*>(this)->actor_wait_state = 5;
															#line 690 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 4, Void >*>(static_cast<DescribeBackupActor*>(this)));
															#line 2998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont8Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont13(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state > 0) static_cast<DescribeBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DescribeBackupActor*>(this)->ActorCallback< DescribeBackupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DescribeBackupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont13(int loopDepth) 
	{
															#line 698 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto& s : desc.snapshots ) {
															#line 700 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			s.restorable = true;
															#line 702 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (s.beginVersion != s.endVersion)
															#line 3097 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 703 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!desc.minLogBegin.present() || desc.minLogBegin.get() > s.beginVersion)
															#line 3101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 704 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					s.restorable = false;
															#line 3105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
															#line 705 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!desc.contiguousLogEnd.present() || desc.contiguousLogEnd.get() <= s.endVersion)
															#line 3109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 706 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					s.restorable = false;
															#line 3113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
															#line 709 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.contiguousLogEnd.present() && desc.contiguousLogEnd.get() <= s.beginVersion)
															#line 3117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 710 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					if (desc.partitioned)
															#line 3121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
					{
															#line 711 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
						s.restorable = isPartitionedLogsContinuous(logs, s.beginVersion, s.endVersion);
															#line 3125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
					}
					else
					{
															#line 713 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
						s.restorable = hasContinuousLogsForSnapshot(logs, s.beginVersion, s.endVersion);
															#line 3131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
					}
				}
			}
															#line 717 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			desc.snapshotBytes += s.totalSize;
															#line 721 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (s.beginVersion == s.endVersion && (!desc.contiguousLogEnd.present() || (desc.contiguousLogEnd.present() && desc.contiguousLogEnd.get() >= s.beginVersion)))
															#line 3139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 726 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!desc.minRestorableVersion.present() || s.endVersion < desc.minRestorableVersion.get())
															#line 3143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 727 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.minRestorableVersion = s.endVersion;
															#line 3147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
															#line 729 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!desc.maxRestorableVersion.present() || s.endVersion > desc.maxRestorableVersion.get())
															#line 3151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 730 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.maxRestorableVersion = s.endVersion;
															#line 3155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
			}
															#line 734 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (desc.minLogBegin.present() && s.beginVersion >= desc.minLogBegin.get() && s.endVersion < desc.contiguousLogEnd.get())
															#line 3160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 736 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!desc.minRestorableVersion.present() || s.endVersion < desc.minRestorableVersion.get())
															#line 3164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 737 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.minRestorableVersion = s.endVersion;
															#line 3168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
															#line 739 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!desc.maxRestorableVersion.present() || (desc.contiguousLogEnd.get() - 1) > desc.maxRestorableVersion.get())
															#line 3172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 741 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.maxRestorableVersion = desc.contiguousLogEnd.get() - 1;
															#line 3176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
			}
															#line 745 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (desc.contiguousLogEnd.present() && ((desc.contiguousLogEnd.get() < s.beginVersion) || (desc.contiguousLogEnd.get() == s.beginVersion && s.beginVersion != s.endVersion)) && s.restorable.get())
															#line 3181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 751 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.minRestorableVersion.present() && desc.maxRestorableVersion.present())
															#line 3185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 752 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					ASSERT(desc.minRestorableVersion.get() < s.beginVersion);
															#line 755 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					bool contiguousLogs = false;
															#line 756 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					if (desc.partitioned)
															#line 3193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
					{
															#line 757 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
						contiguousLogs = isPartitionedLogsContinuous(logs, desc.minRestorableVersion.get(), s.endVersion);
															#line 3197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
					}
					else
					{
															#line 760 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
						contiguousLogs = hasContinuousLogsForSnapshot(logs, desc.minRestorableVersion.get(), s.endVersion);
															#line 3203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
					}
															#line 763 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					if (contiguousLogs)
															#line 3207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
					{
															#line 766 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
						desc.maxRestorableVersion = s.endVersion;
															#line 3211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
					}
					else
					{
															#line 771 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
						desc.minRestorableVersion = s.endVersion;
															#line 3217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
					}
				}
				else
				{
															#line 776 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.minRestorableVersion = s.endVersion;
															#line 3224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
															#line 781 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (desc.partitioned)
															#line 3228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 783 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.maxRestorableVersion = s.endVersion;
															#line 3232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
				else
				{
															#line 785 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					Version maxContinuousLogEnd = findContinuousLogEnd(logs, s.endVersion);
															#line 786 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					desc.maxRestorableVersion = (maxContinuousLogEnd == invalidVersion) ? s.endVersion : maxContinuousLogEnd - 1;
															#line 3240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
			}
		}
															#line 792 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<DescribeBackupActor*>(this)->SAV<BackupDescription>::futures) { (void)(desc); this->~DescribeBackupActorState(); static_cast<DescribeBackupActor*>(this)->destroy(); return 0; }
															#line 3246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<DescribeBackupActor*>(this)->SAV< BackupDescription >::value()) BackupDescription(std::move(desc)); // state_var_RVO
		this->~DescribeBackupActorState();
		static_cast<DescribeBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont24(int loopDepth) 
	{
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont8Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 692 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 3265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 693 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 3269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
															#line 694 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarn, "BackupContainerMetadataUpdateFailure").error(e).detail("URL", bc->getURL());
															#line 3273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = a_body1cont24(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont25(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont25cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont25(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont25cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont25(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont25(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state > 0) static_cast<DescribeBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DescribeBackupActor*>(this)->ActorCallback< DescribeBackupActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DescribeBackupActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont25cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont24(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	bool deepScan;
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version logStartVersionOverride;
															#line 499 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupDescription desc;
															#line 524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<Version> metaLogBegin;
															#line 525 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<Version> metaLogEnd;
															#line 526 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<Version> metaExpiredEnd;
															#line 527 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<Version> metaUnreliableEnd;
															#line 528 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<Version> metaLogType;
															#line 529 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<Version> fileLevelEncryption;
															#line 592 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version scanBegin;
															#line 593 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version scanEnd;
															#line 611 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> logs;
															#line 612 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> plogs;
															#line 673 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Future<Void> updates;
															#line 3414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via describeBackup()
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class DescribeBackupActor final : public Actor<BackupDescription>, public ActorCallback< DescribeBackupActor, 0, bool >, public ActorCallback< DescribeBackupActor, 1, BackupDescription >, public ActorCallback< DescribeBackupActor, 2, Void >, public ActorCallback< DescribeBackupActor, 3, Void >, public ActorCallback< DescribeBackupActor, 4, Void >, public FastAllocated<DescribeBackupActor>, public DescribeBackupActorState<DescribeBackupActor> {
															#line 3419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<DescribeBackupActor>::operator new;
	using FastAllocated<DescribeBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7650567517331116544UL, 14111115065615192064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<BackupDescription>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DescribeBackupActor, 0, bool >;
friend struct ActorCallback< DescribeBackupActor, 1, BackupDescription >;
friend struct ActorCallback< DescribeBackupActor, 2, Void >;
friend struct ActorCallback< DescribeBackupActor, 3, Void >;
friend struct ActorCallback< DescribeBackupActor, 4, Void >;
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	DescribeBackupActor(Reference<BackupContainerFileSystem> const& bc,bool const& deepScan,Version const& logStartVersionOverride) 
															#line 3440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<BackupDescription>(),
		   DescribeBackupActorState<DescribeBackupActor>(bc, deepScan, logStartVersionOverride),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10658787011351424256UL, 7417613107694102528UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("describeBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DescribeBackupActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DescribeBackupActor, 1, BackupDescription >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DescribeBackupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DescribeBackupActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DescribeBackupActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<BackupDescription> describeBackup( Reference<BackupContainerFileSystem> const& bc, bool const& deepScan, Version const& logStartVersionOverride ) {
															#line 496 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<BackupDescription>(new DescribeBackupActor(bc, deepScan, logStartVersionOverride));
															#line 3476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 794 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

																#line 3481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via expireData()
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class ExpireDataActor>
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ExpireDataActorState {
															#line 3487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ExpireDataActorState(Reference<BackupContainerFileSystem> const& bc,Version const& expireEndVersion,bool const& force,IBackupContainer::ExpireProgress* const& progress,Version const& restorableBeginVersion) 
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   expireEndVersion(expireEndVersion),
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   force(force),
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   progress(progress),
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   restorableBeginVersion(restorableBeginVersion)
															#line 3502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("expireData", reinterpret_cast<unsigned long>(this));

	}
	~ExpireDataActorState() 
	{
		fdb_probe_actor_destroy("expireData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 800 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (progress != nullptr)
															#line 3517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 801 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				progress->step = "Describing backup";
															#line 802 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				progress->total = 0;
															#line 3523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
															#line 805 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent("BackupContainerFileSystemExpire1") .detail("URL", bc->getURL()) .detail("ExpireEndVersion", expireEndVersion) .detail("RestorableBeginVersion", restorableBeginVersion);
															#line 811 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<BackupDescription> __when_expr_0 = bc->describeBackup(false, expireEndVersion);
															#line 811 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ExpireDataActor*>(this)->actor_wait_state = 1;
															#line 811 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 0, BackupDescription >*>(static_cast<ExpireDataActor*>(this)));
															#line 3536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExpireDataActorState();
		static_cast<ExpireDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 814 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		expireEndVersion = resolveRelativeVersion(desc.maxLogEnd, expireEndVersion, "ExpireEndVersion", invalid_option_value());
															#line 816 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		restorableBeginVersion = resolveRelativeVersion( desc.maxLogEnd, restorableBeginVersion, "RestorableBeginVersion", invalid_option_value());
															#line 820 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (restorableBeginVersion < expireEndVersion)
															#line 3563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 821 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(backup_cannot_expire(), loopDepth);
															#line 3567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 825 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (expireEndVersion <= desc.expiredEndVersion.orDefault(invalidVersion))
															#line 3571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 826 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<ExpireDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ExpireDataActorState(); static_cast<ExpireDataActor*>(this)->destroy(); return 0; }
															#line 3575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			new (&static_cast<ExpireDataActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ExpireDataActorState();
			static_cast<ExpireDataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 833 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		forceNeeded = true;
															#line 834 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( KeyspaceSnapshotFile& s : desc.snapshots ) {
															#line 835 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (s.restorable.orDefault(false) && s.beginVersion >= expireEndVersion && s.endVersion <= restorableBeginVersion)
															#line 3587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 837 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				forceNeeded = false;
															#line 3591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				break;
			}
		}
															#line 846 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (forceNeeded && !force)
															#line 3597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 847 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(backup_cannot_expire(), loopDepth);
															#line 3601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 850 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		scanBegin = desc.expiredEndVersion.orDefault(0);
															#line 852 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent("BackupContainerFileSystemExpire2") .detail("URL", bc->getURL()) .detail("ExpireEndVersion", expireEndVersion) .detail("RestorableBeginVersion", restorableBeginVersion) .detail("ScanBeginVersion", scanBegin);
															#line 858 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs = std::vector<LogFile>();
															#line 859 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		pLogs = std::vector<LogFile>();
															#line 860 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ranges = std::vector<RangeFile>();
															#line 862 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (progress != nullptr)
															#line 3615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 863 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->step = "Listing files";
															#line 3619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 866 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(logs, bc->listLogFiles(scanBegin, expireEndVersion - 1, false)) && store(pLogs, bc->listLogFiles(scanBegin, expireEndVersion - 1, true)) && store(ranges, bc->listRangeFiles(scanBegin, expireEndVersion - 1));
															#line 866 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExpireDataActor*>(this)->actor_wait_state = 2;
															#line 866 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 1, Void >*>(static_cast<ExpireDataActor*>(this)));
															#line 3630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(BackupDescription const& __desc,int loopDepth) 
	{
															#line 811 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc = __desc;
															#line 3639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(BackupDescription && __desc,int loopDepth) 
	{
		desc = std::move(__desc);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireDataActor*>(this)->ActorCallback< ExpireDataActor, 0, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 0, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 0, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExpireDataActor, 0, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 869 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs.insert(logs.end(), std::make_move_iterator(pLogs.begin()), std::make_move_iterator(pLogs.end()));
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		newLogBeginVersion = Optional<Version>();
															#line 873 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logs.empty())
															#line 3722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 875 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			LogFile& last = *std::max_element(logs.begin(), logs.end());
															#line 878 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (last.endVersion == expireEndVersion)
															#line 3728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 879 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				newLogBeginVersion = expireEndVersion;
															#line 3732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
			else
			{
															#line 883 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (last.endVersion > expireEndVersion)
															#line 3738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 884 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					newLogBeginVersion = last.beginVersion;
															#line 887 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					last = LogFile();
															#line 889 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					expireEndVersion = newLogBeginVersion.get();
															#line 3746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
			}
		}
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		toDelete = std::vector<std::string>();
															#line 898 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& f : logs ) {
															#line 900 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!f.fileName.empty())
															#line 3756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 901 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				toDelete.push_back(std::move(f.fileName));
															#line 3760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 904 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs.clear();
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& f : ranges ) {
															#line 912 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (f.version < expireEndVersion)
															#line 3769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 913 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				toDelete.push_back(std::move(f.fileName));
															#line 3773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 916 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ranges.clear();
															#line 918 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& f : desc.snapshots ) {
															#line 919 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (f.endVersion < expireEndVersion)
															#line 3782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 920 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				toDelete.push_back(std::move(f.fileName));
															#line 3786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 922 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc = BackupDescription();
															#line 927 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (progress != nullptr)
															#line 3793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 928 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->step = "Initial metadata update";
															#line 3797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 930 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Optional<Version>> __when_expr_2 = bc->unreliableEndVersion().get();
															#line 930 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ExpireDataActor*>(this)->actor_wait_state = 3;
															#line 930 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 2, Optional<Version> >*>(static_cast<ExpireDataActor*>(this)));
															#line 3808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 869 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs.insert(logs.end(), std::make_move_iterator(pLogs.begin()), std::make_move_iterator(pLogs.end()));
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		newLogBeginVersion = Optional<Version>();
															#line 873 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logs.empty())
															#line 3821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 875 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			LogFile& last = *std::max_element(logs.begin(), logs.end());
															#line 878 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (last.endVersion == expireEndVersion)
															#line 3827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 879 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				newLogBeginVersion = expireEndVersion;
															#line 3831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
			else
			{
															#line 883 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (last.endVersion > expireEndVersion)
															#line 3837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 884 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					newLogBeginVersion = last.beginVersion;
															#line 887 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					last = LogFile();
															#line 889 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					expireEndVersion = newLogBeginVersion.get();
															#line 3845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
			}
		}
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		toDelete = std::vector<std::string>();
															#line 898 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& f : logs ) {
															#line 900 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!f.fileName.empty())
															#line 3855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 901 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				toDelete.push_back(std::move(f.fileName));
															#line 3859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 904 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs.clear();
															#line 907 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& f : ranges ) {
															#line 912 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (f.version < expireEndVersion)
															#line 3868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 913 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				toDelete.push_back(std::move(f.fileName));
															#line 3872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 916 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ranges.clear();
															#line 918 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto const& f : desc.snapshots ) {
															#line 919 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (f.endVersion < expireEndVersion)
															#line 3881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 920 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				toDelete.push_back(std::move(f.fileName));
															#line 3885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 922 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc = BackupDescription();
															#line 927 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (progress != nullptr)
															#line 3892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 928 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->step = "Initial metadata update";
															#line 3896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 930 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Optional<Version>> __when_expr_2 = bc->unreliableEndVersion().get();
															#line 930 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ExpireDataActor*>(this)->actor_wait_state = 3;
															#line 930 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 2, Optional<Version> >*>(static_cast<ExpireDataActor*>(this)));
															#line 3907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireDataActor*>(this)->ActorCallback< ExpireDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExpireDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont10(Optional<Version> const& metaUnreliableEnd,int loopDepth) 
	{
															#line 931 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (metaUnreliableEnd.orDefault(0) < expireEndVersion)
															#line 3991 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 932 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_3 = bc->unreliableEndVersion().set(expireEndVersion);
															#line 932 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont10when1(__when_expr_3.get(), loopDepth); };
			static_cast<ExpireDataActor*>(this)->actor_wait_state = 4;
															#line 932 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 3, Void >*>(static_cast<ExpireDataActor*>(this)));
															#line 4002 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(Optional<Version> && metaUnreliableEnd,int loopDepth) 
	{
															#line 931 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (metaUnreliableEnd.orDefault(0) < expireEndVersion)
															#line 4016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 932 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_3 = bc->unreliableEndVersion().set(expireEndVersion);
															#line 932 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont10when1(__when_expr_3.get(), loopDepth); };
			static_cast<ExpireDataActor*>(this)->actor_wait_state = 4;
															#line 932 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 3, Void >*>(static_cast<ExpireDataActor*>(this)));
															#line 4027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3when1(Optional<Version> const& metaUnreliableEnd,int loopDepth) 
	{
		loopDepth = a_body1cont10(metaUnreliableEnd, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<Version> && metaUnreliableEnd,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(metaUnreliableEnd), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireDataActor*>(this)->ActorCallback< ExpireDataActor, 2, Optional<Version> >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 2, Optional<Version> >*,Optional<Version> const& value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 2, Optional<Version> >*,Optional<Version> && value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ExpireDataActor, 2, Optional<Version> >*,Error err) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 935 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (progress != nullptr)
															#line 4116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 936 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->step = "Deleting files";
															#line 937 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->total = toDelete.size();
															#line 938 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->done = 0;
															#line 4124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 943 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		deleteFutures = std::list<Future<Void>>();
															#line 945 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 4130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireDataActor*>(this)->ActorCallback< ExpireDataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ExpireDataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10cont3(int loopDepth) 
	{
															#line 967 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (progress != nullptr)
															#line 4226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 968 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->step = "Final metadata update";
															#line 969 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			progress->total = 0;
															#line 4232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 973 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Optional<Version>> __when_expr_5 = bc->expiredEndVersion().get();
															#line 973 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<ExpireDataActor*>(this)->actor_wait_state = 6;
															#line 973 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 5, Optional<Version> >*>(static_cast<ExpireDataActor*>(this)));
															#line 4243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1(int loopDepth) 
	{
															#line 945 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(!toDelete.empty() || !deleteFutures.empty()))
															#line 4259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont10cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 948 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for(;!toDelete.empty() && deleteFutures.size() < CLIENT_KNOBS->BACKUP_CONCURRENT_DELETES;) {
															#line 949 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			deleteFutures.push_back(bc->deleteFile(toDelete.back()));
															#line 950 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			toDelete.pop_back();
															#line 4269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 956 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		targetFuturesSize = toDelete.empty() ? 0 : (CLIENT_KNOBS->BACKUP_CONCURRENT_DELETES - 1);
															#line 958 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 4275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont10cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 958 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(deleteFutures.size() > targetFuturesSize))
															#line 4310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont10cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 959 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_4 = deleteFutures.front();
															#line 959 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1cont10cont1loopBody1loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ExpireDataActor*>(this)->actor_wait_state = 5;
															#line 959 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 4, Void >*>(static_cast<ExpireDataActor*>(this)));
															#line 4323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 960 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (progress != nullptr)
															#line 4345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 961 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			++progress->done;
															#line 4349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 963 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		deleteFutures.pop_front();
															#line 4353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont10cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 960 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (progress != nullptr)
															#line 4362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 961 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			++progress->done;
															#line 4366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 963 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		deleteFutures.pop_front();
															#line 4370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont10cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireDataActor*>(this)->ActorCallback< ExpireDataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ExpireDataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10cont5(Optional<Version> const& metaExpiredEnd,int loopDepth) 
	{
															#line 974 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (metaExpiredEnd.orDefault(0) < expireEndVersion)
															#line 4454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 975 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_6 = bc->expiredEndVersion().set(expireEndVersion);
															#line 975 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_6.get(), loopDepth); };
			static_cast<ExpireDataActor*>(this)->actor_wait_state = 7;
															#line 975 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 6, Void >*>(static_cast<ExpireDataActor*>(this)));
															#line 4465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont5(Optional<Version> && metaExpiredEnd,int loopDepth) 
	{
															#line 974 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (metaExpiredEnd.orDefault(0) < expireEndVersion)
															#line 4479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 975 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_6 = bc->expiredEndVersion().set(expireEndVersion);
															#line 975 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<ExpireDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont5when1(__when_expr_6.get(), loopDepth); };
			static_cast<ExpireDataActor*>(this)->actor_wait_state = 7;
															#line 975 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ExpireDataActor, 6, Void >*>(static_cast<ExpireDataActor*>(this)));
															#line 4490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont3when1(Optional<Version> const& metaExpiredEnd,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(metaExpiredEnd, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Optional<Version> && metaExpiredEnd,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(metaExpiredEnd), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireDataActor*>(this)->ActorCallback< ExpireDataActor, 5, Optional<Version> >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 5, Optional<Version> >*,Optional<Version> const& value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 5, Optional<Version> >*,Optional<Version> && value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ExpireDataActor, 5, Optional<Version> >*,Error err) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10cont7(int loopDepth) 
	{
															#line 978 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<ExpireDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ExpireDataActorState(); static_cast<ExpireDataActor*>(this)->destroy(); return 0; }
															#line 4579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<ExpireDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ExpireDataActorState();
		static_cast<ExpireDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ExpireDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireDataActor*>(this)->ActorCallback< ExpireDataActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ExpireDataActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ExpireDataActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version expireEndVersion;
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	bool force;
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	IBackupContainer::ExpireProgress* progress;
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version restorableBeginVersion;
															#line 811 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupDescription desc;
															#line 833 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	bool forceNeeded;
															#line 850 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version scanBegin;
															#line 858 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> logs;
															#line 859 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> pLogs;
															#line 860 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<RangeFile> ranges;
															#line 872 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<Version> newLogBeginVersion;
															#line 895 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<std::string> toDelete;
															#line 943 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::list<Future<Void>> deleteFutures;
															#line 956 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int targetFuturesSize;
															#line 4704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via expireData()
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ExpireDataActor final : public Actor<Void>, public ActorCallback< ExpireDataActor, 0, BackupDescription >, public ActorCallback< ExpireDataActor, 1, Void >, public ActorCallback< ExpireDataActor, 2, Optional<Version> >, public ActorCallback< ExpireDataActor, 3, Void >, public ActorCallback< ExpireDataActor, 4, Void >, public ActorCallback< ExpireDataActor, 5, Optional<Version> >, public ActorCallback< ExpireDataActor, 6, Void >, public FastAllocated<ExpireDataActor>, public ExpireDataActorState<ExpireDataActor> {
															#line 4709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<ExpireDataActor>::operator new;
	using FastAllocated<ExpireDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17076613683263572992UL, 9321478983527251712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExpireDataActor, 0, BackupDescription >;
friend struct ActorCallback< ExpireDataActor, 1, Void >;
friend struct ActorCallback< ExpireDataActor, 2, Optional<Version> >;
friend struct ActorCallback< ExpireDataActor, 3, Void >;
friend struct ActorCallback< ExpireDataActor, 4, Void >;
friend struct ActorCallback< ExpireDataActor, 5, Optional<Version> >;
friend struct ActorCallback< ExpireDataActor, 6, Void >;
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ExpireDataActor(Reference<BackupContainerFileSystem> const& bc,Version const& expireEndVersion,bool const& force,IBackupContainer::ExpireProgress* const& progress,Version const& restorableBeginVersion) 
															#line 4732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   ExpireDataActorState<ExpireDataActor>(bc, expireEndVersion, force, progress, restorableBeginVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("expireData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8075419445270113024UL, 7939239822766582016UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("expireData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("expireData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExpireDataActor, 0, BackupDescription >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExpireDataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ExpireDataActor, 2, Optional<Version> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ExpireDataActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ExpireDataActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ExpireDataActor, 5, Optional<Version> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ExpireDataActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> expireData( Reference<BackupContainerFileSystem> const& bc, Version const& expireEndVersion, bool const& force, IBackupContainer::ExpireProgress* const& progress, Version const& restorableBeginVersion ) {
															#line 795 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new ExpireDataActor(bc, expireEndVersion, force, progress, restorableBeginVersion));
															#line 4770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 980 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

	// Returns true if logs are continuous in the range [begin, end].
	// "files" should be pre-sorted according to version order.
	static bool isPartitionedLogsContinuous(const std::vector<LogFile>& files, Version begin, Version end) {
		std::map<int, std::vector<int>> tagIndices; // tagId -> indices in files
		for (int i = 0; i < files.size(); i++) {
			ASSERT(files[i].tagId >= 0 && files[i].tagId < files[i].totalTags);
			auto& indices = tagIndices[files[i].tagId];
			indices.push_back(i);
		}

		// check partition 0 is continuous and create a map of ranges to tags
		std::map<std::pair<Version, Version>, int> tags; // range [begin, end] -> tags
		if (!isContinuous(files, tagIndices[0], begin, end, &tags)) {
			TraceEvent(SevWarn, "BackupFileNotContinuous")
			    .detail("Partition", 0)
			    .detail("RangeBegin", begin)
			    .detail("RangeEnd", end);
			return false;
		}

		// for each range in tags, check all tags from 1 are continouous
		for (const auto& [beginEnd, count] : tags) {
			for (int i = 1; i < count; i++) {
				if (!isContinuous(files, tagIndices[i], beginEnd.first, std::min(beginEnd.second - 1, end), nullptr)) {
					TraceEvent(SevWarn, "BackupFileNotContinuous")
					    .detail("Partition", i)
					    .detail("RangeBegin", beginEnd.first)
					    .detail("RangeEnd", beginEnd.second);
					return false;
				}
			}
		}
		return true;
	}

	// Returns log files that are not duplicated, or subset of another log.
	// If a log file's progress is not saved, a new log file will be generated
	// with the same begin version. So we can have a file that contains a subset
	// of contents in another log file.
	// PRE-CONDITION: logs are already sorted by (tagId, beginVersion, endVersion).
	static std::vector<LogFile> filterDuplicates(const std::vector<LogFile>& logs) {
		std::vector<LogFile> filtered;
		int i = 0;
		for (int j = 1; j < logs.size(); j++) {
			if (logs[j].isSubset(logs[i])) {
				ASSERT_LE(logs[j].fileSize, logs[i].fileSize);
				continue;
			}

			if (!logs[i].isSubset(logs[j])) {
				filtered.push_back(logs[i]);
			}
			i = j;
		}
		if (i < logs.size())
			filtered.push_back(logs[i]);
		return filtered;
	}

	static Optional<RestorableFileSet> getRestoreSetFromLogs(const std::vector<LogFile>& logs,
	                                                         Version targetVersion,
	                                                         RestorableFileSet restorable) {
		Version end = logs.begin()->beginVersion;
		computeRestoreEndVersion(logs, &restorable.logs, &end, targetVersion);
		if (end >= targetVersion) {
			restorable.continuousBeginVersion = logs.begin()->beginVersion;
			restorable.continuousEndVersion = end;
			return Optional<RestorableFileSet>(restorable);
		}
		return Optional<RestorableFileSet>();
	}

	// Get a set of files that can restore the given "keyRangesFilter" to the "targetVersion".
	// If "keyRangesFilter" is empty, the file set will cover all key ranges present in the backup.
	// It's generally a good idea to specify "keyRangesFilter" to reduce the number of files for
	// restore times.
	// If "logsOnly" is true, then only log files are returned and "keyRangesFilter" is ignored,
	// because the log can contain mutations of the whole key space, unlike range files that each
	// is limited to a smaller key range.
																#line 4854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via getRestoreSet()
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class GetRestoreSetActor>
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class GetRestoreSetActorState {
															#line 4860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	GetRestoreSetActorState(Reference<BackupContainerFileSystem> const& bc,Version const& targetVersion,VectorRef<KeyRangeRef> const& keyRangesFilter,bool const& logsOnly = false,Version const& beginVersion = invalidVersion) 
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   targetVersion(targetVersion),
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   keyRangesFilter(keyRangesFilter),
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   logsOnly(logsOnly),
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   beginVersion(beginVersion)
															#line 4875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("getRestoreSet", reinterpret_cast<unsigned long>(this));

	}
	~GetRestoreSetActorState() 
	{
		fdb_probe_actor_destroy("getRestoreSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1065 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			for( const auto& range : keyRangesFilter ) {
															#line 1066 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent("BackupContainerGetRestoreSet").detail("RangeFilter", printable(range));
															#line 4892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
															#line 1069 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (logsOnly)
															#line 4896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 1070 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				restorableSet = RestorableFileSet();
															#line 1071 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				restorableSet.targetVersion = targetVersion;
															#line 1072 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				logFiles = std::vector<LogFile>();
															#line 1073 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				Version begin = beginVersion == invalidVersion ? 0 : beginVersion;
															#line 1074 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(logFiles, bc->listLogFiles(begin, targetVersion, false));
															#line 1074 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 1;
															#line 1074 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRestoreSetActor, 0, Void >*>(static_cast<GetRestoreSetActor*>(this)));
															#line 4915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRestoreSetActorState();
		static_cast<GetRestoreSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1083 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<std::vector<KeyspaceSnapshotFile>> __when_expr_1 = bc->listKeyspaceSnapshots();
															#line 1083 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 2;
															#line 1083 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >*>(static_cast<GetRestoreSetActor*>(this)));
															#line 4950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1076 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::sort(logFiles.begin(), logFiles.end());
															#line 1077 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logFiles.empty())
															#line 4961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1078 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(getRestoreSetFromLogs(logFiles, targetVersion, restorableSet)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 4965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(getRestoreSetFromLogs(logFiles, targetVersion, restorableSet));
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1076 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::sort(logFiles.begin(), logFiles.end());
															#line 1077 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logFiles.empty())
															#line 4981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1078 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(getRestoreSetFromLogs(logFiles, targetVersion, restorableSet)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 4985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(getRestoreSetFromLogs(logFiles, targetVersion, restorableSet));
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreSetActor*>(this)->ActorCallback< GetRestoreSetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRestoreSetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 1084 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		i = snapshots.size() - 1;
															#line 1085 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 5076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<KeyspaceSnapshotFile> const& __snapshots,int loopDepth) 
	{
															#line 1083 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshots = __snapshots;
															#line 5085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<KeyspaceSnapshotFile> && __snapshots,int loopDepth) 
	{
		snapshots = std::move(__snapshots);
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreSetActor*>(this)->ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >*,std::vector<KeyspaceSnapshotFile> const& value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >*,std::vector<KeyspaceSnapshotFile> && value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1174 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(Optional<RestorableFileSet>()); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(Optional<RestorableFileSet>());
		this->~GetRestoreSetActorState();
		static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 1085 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(i >= 0))
															#line 5183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1087 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (targetVersion >= 0 && snapshots[i].beginVersion > targetVersion)
															#line 5189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont6continue1(loopDepth); // continue
		}
															#line 1091 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		restorable = RestorableFileSet();
															#line 1092 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		minKeyRangeVersion = MAX_VERSION;
															#line 1093 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		maxKeyRangeVersion = -1;
															#line 1095 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>> __when_expr_2 = bc->readKeyspaceSnapshot(snapshots[i]);
															#line 1095 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 3;
															#line 1095 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >*>(static_cast<GetRestoreSetActor*>(this)));
															#line 5208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6continue1(int loopDepth) 
	{
															#line 1085 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		i--;
															#line 5230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> const& results,int loopDepth) 
	{
															#line 1100 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (keyRangesFilter.empty() || results.second.empty())
															#line 5239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1101 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.ranges = std::move(results.first);
															#line 1102 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.keyRanges = std::move(results.second);
															#line 1103 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			minKeyRangeVersion = snapshots[i].beginVersion;
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			maxKeyRangeVersion = snapshots[i].endVersion;
															#line 5249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
		else
		{
															#line 1106 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			for( const auto& rangeFile : results.first ) {
															#line 1107 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				const auto& keyRange = results.second.at(rangeFile.fileName);
															#line 1108 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (keyRange.intersects(keyRangesFilter))
															#line 5259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 1109 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					restorable.ranges.push_back(rangeFile);
															#line 1110 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					restorable.keyRanges[rangeFile.fileName] = keyRange;
															#line 1111 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					minKeyRangeVersion = std::min(minKeyRangeVersion, rangeFile.version);
															#line 1112 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					maxKeyRangeVersion = std::max(maxKeyRangeVersion, rangeFile.version);
															#line 5269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
			}
															#line 1116 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (restorable.ranges.empty())
															#line 5274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 1117 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(backup_not_overlapped_with_keys_filter(), std::max(0, loopDepth - 1));
															#line 5278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 1121 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		restorable.targetVersion = targetVersion == latestVersion ? maxKeyRangeVersion : targetVersion;
															#line 1123 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (restorable.targetVersion < maxKeyRangeVersion)
															#line 5285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont6continue1(loopDepth); // continue
		}
															#line 1127 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		restorable.snapshot = snapshots[i];
															#line 1130 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (minKeyRangeVersion == maxKeyRangeVersion && maxKeyRangeVersion == restorable.targetVersion)
															#line 5293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1131 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.continuousBeginVersion = restorable.continuousEndVersion = invalidVersion;
															#line 1132 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent("BackupContainerGetRestorableFilesWithoutLogs") .detail("KeyRangeVersion", restorable.targetVersion) .detail("NumberOfRangeFiles", restorable.ranges.size()) .detail("KeyRangesFilter", printable(keyRangesFilter));
															#line 1136 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(Optional<RestorableFileSet>(restorable)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(Optional<RestorableFileSet>(restorable));
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1140 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs = std::vector<LogFile>();
															#line 1141 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		plogs = std::vector<LogFile>();
															#line 1142 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(logs, bc->listLogFiles(minKeyRangeVersion, restorable.targetVersion, false)) && store(plogs, bc->listLogFiles(minKeyRangeVersion, restorable.targetVersion, true));
															#line 1142 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 4;
															#line 1142 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRestoreSetActor, 3, Void >*>(static_cast<GetRestoreSetActor*>(this)));
															#line 5320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> && results,int loopDepth) 
	{
															#line 1100 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (keyRangesFilter.empty() || results.second.empty())
															#line 5329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1101 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.ranges = std::move(results.first);
															#line 1102 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.keyRanges = std::move(results.second);
															#line 1103 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			minKeyRangeVersion = snapshots[i].beginVersion;
															#line 1104 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			maxKeyRangeVersion = snapshots[i].endVersion;
															#line 5339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
		else
		{
															#line 1106 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			for( const auto& rangeFile : results.first ) {
															#line 1107 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				const auto& keyRange = results.second.at(rangeFile.fileName);
															#line 1108 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (keyRange.intersects(keyRangesFilter))
															#line 5349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 1109 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					restorable.ranges.push_back(rangeFile);
															#line 1110 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					restorable.keyRanges[rangeFile.fileName] = keyRange;
															#line 1111 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					minKeyRangeVersion = std::min(minKeyRangeVersion, rangeFile.version);
															#line 1112 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					maxKeyRangeVersion = std::max(maxKeyRangeVersion, rangeFile.version);
															#line 5359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
			}
															#line 1116 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (restorable.ranges.empty())
															#line 5364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 1117 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(backup_not_overlapped_with_keys_filter(), std::max(0, loopDepth - 1));
															#line 5368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 1121 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		restorable.targetVersion = targetVersion == latestVersion ? maxKeyRangeVersion : targetVersion;
															#line 1123 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (restorable.targetVersion < maxKeyRangeVersion)
															#line 5375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont6continue1(loopDepth); // continue
		}
															#line 1127 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		restorable.snapshot = snapshots[i];
															#line 1130 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (minKeyRangeVersion == maxKeyRangeVersion && maxKeyRangeVersion == restorable.targetVersion)
															#line 5383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1131 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.continuousBeginVersion = restorable.continuousEndVersion = invalidVersion;
															#line 1132 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent("BackupContainerGetRestorableFilesWithoutLogs") .detail("KeyRangeVersion", restorable.targetVersion) .detail("NumberOfRangeFiles", restorable.ranges.size()) .detail("KeyRangesFilter", printable(keyRangesFilter));
															#line 1136 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(Optional<RestorableFileSet>(restorable)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(Optional<RestorableFileSet>(restorable));
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1140 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs = std::vector<LogFile>();
															#line 1141 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		plogs = std::vector<LogFile>();
															#line 1142 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(logs, bc->listLogFiles(minKeyRangeVersion, restorable.targetVersion, false)) && store(plogs, bc->listLogFiles(minKeyRangeVersion, restorable.targetVersion, true));
															#line 1142 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 4;
															#line 1142 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRestoreSetActor, 3, Void >*>(static_cast<GetRestoreSetActor*>(this)));
															#line 5410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreSetActor*>(this)->ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >*,std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> const& value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >*,std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> && value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 1145 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (plogs.size() > 0)
															#line 5494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1146 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			logs.swap(plogs);
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(logs.begin(), logs.end(), [](const LogFile& a, const LogFile& b) { return std::tie(a.tagId, a.beginVersion, a.endVersion) < std::tie(b.tagId, b.beginVersion, b.endVersion); });
															#line 1154 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::vector<LogFile> filtered = filterDuplicates(logs);
															#line 1155 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.logs.swap(filtered);
															#line 1157 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(restorable.logs.begin(), restorable.logs.end());
															#line 1158 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (isPartitionedLogsContinuous(restorable.logs, minKeyRangeVersion, restorable.targetVersion))
															#line 5508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 1159 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				restorable.continuousBeginVersion = minKeyRangeVersion;
															#line 1160 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				restorable.continuousEndVersion = restorable.targetVersion + 1;
															#line 1161 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(Optional<RestorableFileSet>(restorable)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(Optional<RestorableFileSet>(restorable));
				this->~GetRestoreSetActorState();
				static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1163 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(Optional<RestorableFileSet>()); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(Optional<RestorableFileSet>());
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1167 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::sort(logs.begin(), logs.end());
															#line 1170 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logs.empty() && logs.front().beginVersion <= minKeyRangeVersion)
															#line 5534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1171 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(getRestoreSetFromLogs(logs, targetVersion, restorable)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(getRestoreSetFromLogs(logs, targetVersion, restorable));
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1085 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		i--;
															#line 5546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 1145 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (plogs.size() > 0)
															#line 5555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1146 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			logs.swap(plogs);
															#line 1148 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(logs.begin(), logs.end(), [](const LogFile& a, const LogFile& b) { return std::tie(a.tagId, a.beginVersion, a.endVersion) < std::tie(b.tagId, b.beginVersion, b.endVersion); });
															#line 1154 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::vector<LogFile> filtered = filterDuplicates(logs);
															#line 1155 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			restorable.logs.swap(filtered);
															#line 1157 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(restorable.logs.begin(), restorable.logs.end());
															#line 1158 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (isPartitionedLogsContinuous(restorable.logs, minKeyRangeVersion, restorable.targetVersion))
															#line 5569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 1159 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				restorable.continuousBeginVersion = minKeyRangeVersion;
															#line 1160 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				restorable.continuousEndVersion = restorable.targetVersion + 1;
															#line 1161 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(Optional<RestorableFileSet>(restorable)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(Optional<RestorableFileSet>(restorable));
				this->~GetRestoreSetActorState();
				static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1163 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(Optional<RestorableFileSet>()); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(Optional<RestorableFileSet>());
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1167 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::sort(logs.begin(), logs.end());
															#line 1170 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!logs.empty() && logs.front().beginVersion <= minKeyRangeVersion)
															#line 5595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1171 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<GetRestoreSetActor*>(this)->SAV<Optional<RestorableFileSet>>::futures) { (void)(getRestoreSetFromLogs(logs, targetVersion, restorable)); this->~GetRestoreSetActorState(); static_cast<GetRestoreSetActor*>(this)->destroy(); return 0; }
															#line 5599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			new (&static_cast<GetRestoreSetActor*>(this)->SAV< Optional<RestorableFileSet> >::value()) Optional<RestorableFileSet>(getRestoreSetFromLogs(logs, targetVersion, restorable));
			this->~GetRestoreSetActorState();
			static_cast<GetRestoreSetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1085 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		i--;
															#line 5607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetRestoreSetActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreSetActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreSetActor*>(this)->ActorCallback< GetRestoreSetActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetRestoreSetActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetRestoreSetActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version targetVersion;
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	VectorRef<KeyRangeRef> keyRangesFilter;
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	bool logsOnly;
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version beginVersion;
															#line 1070 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	RestorableFileSet restorableSet;
															#line 1072 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> logFiles;
															#line 1083 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<KeyspaceSnapshotFile> snapshots;
															#line 1084 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int i;
															#line 1091 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	RestorableFileSet restorable;
															#line 1092 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version minKeyRangeVersion;
															#line 1093 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version maxKeyRangeVersion;
															#line 1140 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> logs;
															#line 1141 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<LogFile> plogs;
															#line 5715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via getRestoreSet()
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class GetRestoreSetActor final : public Actor<Optional<RestorableFileSet>>, public ActorCallback< GetRestoreSetActor, 0, Void >, public ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >, public ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >, public ActorCallback< GetRestoreSetActor, 3, Void >, public FastAllocated<GetRestoreSetActor>, public GetRestoreSetActorState<GetRestoreSetActor> {
															#line 5720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<GetRestoreSetActor>::operator new;
	using FastAllocated<GetRestoreSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12832350240223871744UL, 5234625102498671872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<RestorableFileSet>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRestoreSetActor, 0, Void >;
friend struct ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >;
friend struct ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >;
friend struct ActorCallback< GetRestoreSetActor, 3, Void >;
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	GetRestoreSetActor(Reference<BackupContainerFileSystem> const& bc,Version const& targetVersion,VectorRef<KeyRangeRef> const& keyRangesFilter,bool const& logsOnly = false,Version const& beginVersion = invalidVersion) 
															#line 5740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Optional<RestorableFileSet>>(),
		   GetRestoreSetActorState<GetRestoreSetActor>(bc, targetVersion, keyRangesFilter, logsOnly, beginVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRestoreSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12008909710218968832UL, 11005026045665115392UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRestoreSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRestoreSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRestoreSetActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRestoreSetActor, 1, std::vector<KeyspaceSnapshotFile> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRestoreSetActor, 2, std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetRestoreSetActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Optional<RestorableFileSet>> getRestoreSet( Reference<BackupContainerFileSystem> const& bc, Version const& targetVersion, VectorRef<KeyRangeRef> const& keyRangesFilter, bool const& logsOnly = false, Version const& beginVersion = invalidVersion ) {
															#line 1060 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Optional<RestorableFileSet>>(new GetRestoreSetActor(bc, targetVersion, keyRangesFilter, logsOnly, beginVersion));
															#line 5775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 1176 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

	static std::string versionFolderString(Version v, int smallestBucket) {
		ASSERT_LT(smallestBucket, 14);
		// Get a 0-padded fixed size representation of v
		std::string vFixedPrecision = format("%019lld", v);
		ASSERT_EQ(vFixedPrecision.size(), 19);
		// Truncate smallestBucket from the fixed length representation
		vFixedPrecision.resize(vFixedPrecision.size() - smallestBucket);

		// Split the remaining digits with a '/' 4 places from the right
		vFixedPrecision.insert(vFixedPrecision.size() - 4, 1, '/');

		return vFixedPrecision;
	}

	// This useful for comparing version folder strings regardless of where their "/" dividers are, as it is possible
	// that division points would change in the future.
	static std::string cleanFolderString(std::string f) {
		f.erase(std::remove(f.begin(), f.end(), '/'), f.end());
		return f;
	}

	// The innermost folder covers 100 seconds (1e8 versions) During a full speed backup it is possible though very
	// unlikely write about 10,000 snapshot range files during that time.
	static std::string old_rangeVersionFolderString(Version v) {
		return format("ranges/%s/", versionFolderString(v, 8).c_str());
	}

	// Get the root folder for a snapshot's data based on its begin version
	static std::string snapshotFolderString(Version snapshotBeginVersion) {
		return format("kvranges/snapshot.%018" PRId64, snapshotBeginVersion);
	}

	// Extract the snapshot begin version from a path
	static Version extractSnapshotBeginVersion(const std::string& path) {
		Version snapshotBeginVersion;
		if (sscanf(path.c_str(), "kvranges/snapshot.%018" SCNd64, &snapshotBeginVersion) == 1) {
			return snapshotBeginVersion;
		}
		return invalidVersion;
	}

	// The innermost folder covers 100,000 seconds (1e11 versions) which is 5,000 mutation log files at current
	// settings.
	static std::string logVersionFolderString(Version v, bool partitioned) {
		return format("%s/%s/", (partitioned ? "plogs" : "logs"), versionFolderString(v, 11).c_str());
	}

	static bool pathToLogFile(LogFile& out, const std::string& path, int64_t size) {
		std::string name = fileNameOnly(path);
		LogFile f;
		f.fileName = path;
		f.fileSize = size;
		int len;
		if (sscanf(name.c_str(),
		           "log,%" SCNd64 ",%" SCNd64 ",%*[^,],%u%n",
		           &f.beginVersion,
		           &f.endVersion,
		           &f.blockSize,
		           &len) == 3 &&
		    len == name.size()) {
			out = f;
			return true;
		} else if (sscanf(name.c_str(),
		                  "log,%" SCNd64 ",%" SCNd64 ",%*[^,],%d-of-%d,%u%n",
		                  &f.beginVersion,
		                  &f.endVersion,
		                  &f.tagId,
		                  &f.totalTags,
		                  &f.blockSize,
		                  &len) == 5 &&
		           len == name.size() && f.tagId >= 0) {
			out = f;
			return true;
		}
		return false;
	}

	static bool pathToKeyspaceSnapshotFile(KeyspaceSnapshotFile& out, const std::string& path) {
		std::string name = fileNameOnly(path);
		KeyspaceSnapshotFile f;
		f.fileName = path;
		int len;
		if (sscanf(name.c_str(),
		           "snapshot,%" SCNd64 ",%" SCNd64 ",%" SCNd64 "%n",
		           &f.beginVersion,
		           &f.endVersion,
		           &f.totalSize,
		           &len) == 3 &&
		    len == name.size()) {
			out = f;
			return true;
		}
		return false;
	}

	// fallback for using existing write api if the underlying blob store doesn't support efficient writeEntireFile
																#line 5876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via writeEntireFileFallback()
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class WriteEntireFileFallbackActor>
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteEntireFileFallbackActorState {
															#line 5882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteEntireFileFallbackActorState(Reference<BackupContainerFileSystem> const& bc,std::string const& fileName,std::string const& fileContents) 
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   fileName(fileName),
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   fileContents(fileContents)
															#line 5893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("writeEntireFileFallback", reinterpret_cast<unsigned long>(this));

	}
	~WriteEntireFileFallbackActorState() 
	{
		fdb_probe_actor_destroy("writeEntireFileFallback", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Reference<IBackupFile>> __when_expr_0 = bc->writeFile(fileName);
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state = 1;
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >*>(static_cast<WriteEntireFileFallbackActor*>(this)));
															#line 5915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteEntireFileFallbackActorState();
		static_cast<WriteEntireFileFallbackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1277 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = objectFile->append(&fileContents[0], fileContents.size());
															#line 1277 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state = 2;
															#line 1277 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteEntireFileFallbackActor, 1, Void >*>(static_cast<WriteEntireFileFallbackActor*>(this)));
															#line 5945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IBackupFile> const& __objectFile,int loopDepth) 
	{
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		objectFile = __objectFile;
															#line 5954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IBackupFile> && __objectFile,int loopDepth) 
	{
		objectFile = std::move(__objectFile);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state > 0) static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<WriteEntireFileFallbackActor*>(this)->ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1278 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = objectFile->finish();
															#line 1278 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state = 3;
															#line 1278 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteEntireFileFallbackActor, 2, Void >*>(static_cast<WriteEntireFileFallbackActor*>(this)));
															#line 6040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1278 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = objectFile->finish();
															#line 1278 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6051 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state = 3;
															#line 1278 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteEntireFileFallbackActor, 2, Void >*>(static_cast<WriteEntireFileFallbackActor*>(this)));
															#line 6056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state > 0) static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<WriteEntireFileFallbackActor*>(this)->ActorCallback< WriteEntireFileFallbackActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteEntireFileFallbackActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteEntireFileFallbackActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteEntireFileFallbackActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1279 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteEntireFileFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteEntireFileFallbackActorState(); static_cast<WriteEntireFileFallbackActor*>(this)->destroy(); return 0; }
															#line 6140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<WriteEntireFileFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteEntireFileFallbackActorState();
		static_cast<WriteEntireFileFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1279 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteEntireFileFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteEntireFileFallbackActorState(); static_cast<WriteEntireFileFallbackActor*>(this)->destroy(); return 0; }
															#line 6152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<WriteEntireFileFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteEntireFileFallbackActorState();
		static_cast<WriteEntireFileFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state > 0) static_cast<WriteEntireFileFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<WriteEntireFileFallbackActor*>(this)->ActorCallback< WriteEntireFileFallbackActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteEntireFileFallbackActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteEntireFileFallbackActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteEntireFileFallbackActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string fileName;
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string fileContents;
															#line 1276 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> objectFile;
															#line 6243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via writeEntireFileFallback()
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteEntireFileFallbackActor final : public Actor<Void>, public ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >, public ActorCallback< WriteEntireFileFallbackActor, 1, Void >, public ActorCallback< WriteEntireFileFallbackActor, 2, Void >, public FastAllocated<WriteEntireFileFallbackActor>, public WriteEntireFileFallbackActorState<WriteEntireFileFallbackActor> {
															#line 6248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<WriteEntireFileFallbackActor>::operator new;
	using FastAllocated<WriteEntireFileFallbackActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16631062808997078272UL, 15816171864284055040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >;
friend struct ActorCallback< WriteEntireFileFallbackActor, 1, Void >;
friend struct ActorCallback< WriteEntireFileFallbackActor, 2, Void >;
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteEntireFileFallbackActor(Reference<BackupContainerFileSystem> const& bc,std::string const& fileName,std::string const& fileContents) 
															#line 6267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   WriteEntireFileFallbackActorState<WriteEntireFileFallbackActor>(bc, fileName, fileContents),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1619473515880821760UL, 4362335262871378176UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEntireFileFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeEntireFileFallback");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeEntireFileFallback", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteEntireFileFallbackActor, 0, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteEntireFileFallbackActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteEntireFileFallbackActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> writeEntireFileFallback( Reference<BackupContainerFileSystem> const& bc, std::string const& fileName, std::string const& fileContents ) {
															#line 1273 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new WriteEntireFileFallbackActor(bc, fileName, fileContents));
															#line 6301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 1281 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

																#line 6306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via createTestEncryptionKeyFile()
															#line 1282 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class CreateTestEncryptionKeyFileActor>
															#line 1282 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class CreateTestEncryptionKeyFileActorState {
															#line 6312 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 1282 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	CreateTestEncryptionKeyFileActorState(std::string const& filename) 
															#line 1282 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1282 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : filename(filename)
															#line 6319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this));

	}
	~CreateTestEncryptionKeyFileActorState() 
	{
		fdb_probe_actor_destroy("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1283 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (fileExists(filename))
															#line 6334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 1286 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent("EncryptionKeyFileExists").detail("FileName", filename);
															#line 1287 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!static_cast<CreateTestEncryptionKeyFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTestEncryptionKeyFileActorState(); static_cast<CreateTestEncryptionKeyFileActor*>(this)->destroy(); return 0; }
															#line 6340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				new (&static_cast<CreateTestEncryptionKeyFileActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CreateTestEncryptionKeyFileActorState();
				static_cast<CreateTestEncryptionKeyFileActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1289 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( filename, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_CREATE, 0600);
															#line 1289 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state = 1;
															#line 1289 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >*>(static_cast<CreateTestEncryptionKeyFileActor*>(this)));
															#line 6355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateTestEncryptionKeyFileActorState();
		static_cast<CreateTestEncryptionKeyFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1293 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StreamCipherKey testKey(AES_256_KEY_LENGTH);
															#line 1294 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		testKey.initializeRandomTestKey();
															#line 1295 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		keyFile->write(testKey.data(), testKey.size(), 0);
															#line 1296 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = keyFile->sync();
															#line 1296 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state = 2;
															#line 1296 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >*>(static_cast<CreateTestEncryptionKeyFileActor*>(this)));
															#line 6391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __keyFile,int loopDepth) 
	{
															#line 1289 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		keyFile = __keyFile;
															#line 6400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __keyFile,int loopDepth) 
	{
		keyFile = std::move(__keyFile);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state > 0) static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTestEncryptionKeyFileActor*>(this)->ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTestEncryptionKeyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTestEncryptionKeyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTestEncryptionKeyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1297 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<CreateTestEncryptionKeyFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTestEncryptionKeyFileActorState(); static_cast<CreateTestEncryptionKeyFileActor*>(this)->destroy(); return 0; }
															#line 6479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<CreateTestEncryptionKeyFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateTestEncryptionKeyFileActorState();
		static_cast<CreateTestEncryptionKeyFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1297 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<CreateTestEncryptionKeyFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTestEncryptionKeyFileActorState(); static_cast<CreateTestEncryptionKeyFileActor*>(this)->destroy(); return 0; }
															#line 6491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<CreateTestEncryptionKeyFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateTestEncryptionKeyFileActorState();
		static_cast<CreateTestEncryptionKeyFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state > 0) static_cast<CreateTestEncryptionKeyFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTestEncryptionKeyFileActor*>(this)->ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTestEncryptionKeyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTestEncryptionKeyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTestEncryptionKeyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1282 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string filename;
															#line 1289 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IAsyncFile> keyFile;
															#line 6578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via createTestEncryptionKeyFile()
															#line 1282 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class CreateTestEncryptionKeyFileActor final : public Actor<Void>, public ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >, public ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >, public FastAllocated<CreateTestEncryptionKeyFileActor>, public CreateTestEncryptionKeyFileActorState<CreateTestEncryptionKeyFileActor> {
															#line 6583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<CreateTestEncryptionKeyFileActor>::operator new;
	using FastAllocated<CreateTestEncryptionKeyFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17882773505303394560UL, 16330686064907044352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >;
															#line 1282 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	CreateTestEncryptionKeyFileActor(std::string const& filename) 
															#line 6601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   CreateTestEncryptionKeyFileActorState<CreateTestEncryptionKeyFileActor>(filename),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7353405283783222784UL, 17494758805968910080UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTestEncryptionKeyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createTestEncryptionKeyFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createTestEncryptionKeyFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateTestEncryptionKeyFileActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateTestEncryptionKeyFileActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1282 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> createTestEncryptionKeyFile( std::string const& filename ) {
															#line 1282 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new CreateTestEncryptionKeyFileActor(filename));
															#line 6634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 1299 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

																#line 6639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via readEncryptionKey()
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class ReadEncryptionKeyActor>
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ReadEncryptionKeyActorState {
															#line 6645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ReadEncryptionKeyActorState(std::string const& encryptionKeyFileName) 
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : encryptionKeyFileName(encryptionKeyFileName),
															#line 1301 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   keyFile(),
															#line 1302 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   cipherKey(StreamCipherKey::getGlobalCipherKey())
															#line 6656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("readEncryptionKey", reinterpret_cast<unsigned long>(this));

	}
	~ReadEncryptionKeyActorState() 
	{
		fdb_probe_actor_destroy("readEncryptionKey", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1304 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( encryptionKeyFileName, IAsyncFile::OPEN_NO_AIO | IAsyncFile::OPEN_READONLY | IAsyncFile::OPEN_UNCACHED, 0400);
															#line 1304 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state = 1;
															#line 1304 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >*>(static_cast<ReadEncryptionKeyActor*>(this)));
															#line 6679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadEncryptionKeyActorState();
		static_cast<ReadEncryptionKeyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1315 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<int> __when_expr_1 = keyFile->read(cipherKey->data(), cipherKey->size(), 0);
															#line 1315 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state = 2;
															#line 1315 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadEncryptionKeyActor, 1, int >*>(static_cast<ReadEncryptionKeyActor*>(this)));
															#line 6715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1310 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "FailedToOpenEncryptionKeyFile") .error(e) .detail("FileName", encryptionKeyFileName);
															#line 1313 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 6727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Reference<IAsyncFile> const& _keyFile,int loopDepth) 
	{
															#line 1308 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		keyFile = _keyFile;
															#line 6741 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Reference<IAsyncFile> && _keyFile,int loopDepth) 
	{
															#line 1308 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		keyFile = _keyFile;
															#line 6750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& _keyFile,int loopDepth) 
	{
		loopDepth = a_body1cont2(_keyFile, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && _keyFile,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_keyFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state > 0) static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadEncryptionKeyActor*>(this)->ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("readEncryptionKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadEncryptionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readEncryptionKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("readEncryptionKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadEncryptionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readEncryptionKey", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readEncryptionKey", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadEncryptionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readEncryptionKey", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int const& bytesRead,int loopDepth) 
	{
															#line 1316 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (bytesRead != cipherKey->size())
															#line 6847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1317 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "InvalidEncryptionKeyFileSize") .detail("ExpectedSize", cipherKey->size()) .detail("ActualSize", bytesRead);
															#line 1320 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(invalid_encryption_key_file(), loopDepth);
															#line 6853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 1322 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(bytesRead, cipherKey->size());
															#line 1323 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<ReadEncryptionKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadEncryptionKeyActorState(); static_cast<ReadEncryptionKeyActor*>(this)->destroy(); return 0; }
															#line 6859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<ReadEncryptionKeyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadEncryptionKeyActorState();
		static_cast<ReadEncryptionKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(int && bytesRead,int loopDepth) 
	{
															#line 1316 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (bytesRead != cipherKey->size())
															#line 6871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1317 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "InvalidEncryptionKeyFileSize") .detail("ExpectedSize", cipherKey->size()) .detail("ActualSize", bytesRead);
															#line 1320 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(invalid_encryption_key_file(), loopDepth);
															#line 6877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 1322 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(bytesRead, cipherKey->size());
															#line 1323 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<ReadEncryptionKeyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadEncryptionKeyActorState(); static_cast<ReadEncryptionKeyActor*>(this)->destroy(); return 0; }
															#line 6883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<ReadEncryptionKeyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadEncryptionKeyActorState();
		static_cast<ReadEncryptionKeyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont5(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state > 0) static_cast<ReadEncryptionKeyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadEncryptionKeyActor*>(this)->ActorCallback< ReadEncryptionKeyActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< ReadEncryptionKeyActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readEncryptionKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadEncryptionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readEncryptionKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadEncryptionKeyActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("readEncryptionKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadEncryptionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readEncryptionKey", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadEncryptionKeyActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("readEncryptionKey", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadEncryptionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readEncryptionKey", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string encryptionKeyFileName;
															#line 1301 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IAsyncFile> keyFile;
															#line 1302 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	StreamCipherKey const* cipherKey;
															#line 6972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via readEncryptionKey()
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ReadEncryptionKeyActor final : public Actor<Void>, public ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >, public ActorCallback< ReadEncryptionKeyActor, 1, int >, public FastAllocated<ReadEncryptionKeyActor>, public ReadEncryptionKeyActorState<ReadEncryptionKeyActor> {
															#line 6977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<ReadEncryptionKeyActor>::operator new;
	using FastAllocated<ReadEncryptionKeyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4679093036791656192UL, 1616992747534130944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< ReadEncryptionKeyActor, 1, int >;
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ReadEncryptionKeyActor(std::string const& encryptionKeyFileName) 
															#line 6995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   ReadEncryptionKeyActorState<ReadEncryptionKeyActor>(encryptionKeyFileName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readEncryptionKey", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10298366554447832320UL, 8112828672925133056UL);
		ActorExecutionContextHelper __helper(static_cast<ReadEncryptionKeyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readEncryptionKey");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readEncryptionKey", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadEncryptionKeyActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadEncryptionKeyActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> readEncryptionKey( std::string const& encryptionKeyFileName ) {
															#line 1300 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new ReadEncryptionKeyActor(encryptionKeyFileName));
															#line 7028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 1325 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

																#line 7033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via writeEncryptionMetadataIfNotExists()
															#line 1326 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class WriteEncryptionMetadataIfNotExistsActor>
															#line 1326 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteEncryptionMetadataIfNotExistsActorState {
															#line 7039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 1326 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteEncryptionMetadataIfNotExistsActorState(Reference<BackupContainerFileSystem> const& bc) 
															#line 1326 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1326 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc)
															#line 7046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this));

	}
	~WriteEncryptionMetadataIfNotExistsActorState() 
	{
		fdb_probe_actor_destroy("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1327 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Optional<Version>> __when_expr_0 = bc->fileLevelEncryption().get();
															#line 1327 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state = 1;
															#line 1327 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >*>(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)));
															#line 7068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteEncryptionMetadataIfNotExistsActorState();
		static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Version> const& existingEncryptionMetadata,int loopDepth) 
	{
															#line 1329 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!existingEncryptionMetadata.present())
															#line 7091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1330 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_1 = bc->fileLevelEncryption().set(bc->encryptionKeyFileName.present() ? 1 : 0);
															#line 1330 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7097 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state = 2;
															#line 1330 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, Void >*>(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)));
															#line 7102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<Version> && existingEncryptionMetadata,int loopDepth) 
	{
															#line 1329 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!existingEncryptionMetadata.present())
															#line 7116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1330 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_1 = bc->fileLevelEncryption().set(bc->encryptionKeyFileName.present() ? 1 : 0);
															#line 1330 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state = 2;
															#line 1330 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, Void >*>(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)));
															#line 7127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Optional<Version> const& existingEncryptionMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont1(existingEncryptionMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Version> && existingEncryptionMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(existingEncryptionMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state > 0) static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state = 0;
		static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >*,Optional<Version> const& value) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >*,Optional<Version> && value) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >*,Error err) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1332 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteEncryptionMetadataIfNotExistsActorState(); static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->destroy(); return 0; }
															#line 7216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteEncryptionMetadataIfNotExistsActorState();
		static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state > 0) static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->actor_wait_state = 0;
		static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1326 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 7313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via writeEncryptionMetadataIfNotExists()
															#line 1326 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteEncryptionMetadataIfNotExistsActor final : public Actor<Void>, public ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >, public ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, Void >, public FastAllocated<WriteEncryptionMetadataIfNotExistsActor>, public WriteEncryptionMetadataIfNotExistsActorState<WriteEncryptionMetadataIfNotExistsActor> {
															#line 7318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<WriteEncryptionMetadataIfNotExistsActor>::operator new;
	using FastAllocated<WriteEncryptionMetadataIfNotExistsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8177466465538391552UL, 4933866840625045760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >;
friend struct ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, Void >;
															#line 1326 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteEncryptionMetadataIfNotExistsActor(Reference<BackupContainerFileSystem> const& bc) 
															#line 7336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   WriteEncryptionMetadataIfNotExistsActorState<WriteEncryptionMetadataIfNotExistsActor>(bc),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9737599539893382656UL, 3476537158842691328UL);
		ActorExecutionContextHelper __helper(static_cast<WriteEncryptionMetadataIfNotExistsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeEncryptionMetadataIfNotExists");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeEncryptionMetadataIfNotExists", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 0, Optional<Version> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteEncryptionMetadataIfNotExistsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1326 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> writeEncryptionMetadataIfNotExists( Reference<BackupContainerFileSystem> const& bc ) {
															#line 1326 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new WriteEncryptionMetadataIfNotExistsActor(bc));
															#line 7369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 1334 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

}; // class BackupContainerFileSystemImpl

Future<Reference<IBackupFile>> BackupContainerFileSystem::writeLogFile(Version beginVersion,
                                                                       Version endVersion,
                                                                       int blockSize) {
	return writeFile(BackupContainerFileSystemImpl::logVersionFolderString(beginVersion, false) +
	                 format("log,%lld,%lld,%s,%d",
	                        beginVersion,
	                        endVersion,
	                        deterministicRandom()->randomUniqueID().toString().c_str(),
	                        blockSize));
}

Future<Reference<IBackupFile>> BackupContainerFileSystem::writeTaggedLogFile(Version beginVersion,
                                                                             Version endVersion,
                                                                             int blockSize,
                                                                             uint16_t tagId,
                                                                             int totalTags) {
	return writeFile(BackupContainerFileSystemImpl::logVersionFolderString(beginVersion, true) +
	                 format("log,%lld,%lld,%s,%d-of-%d,%d",
	                        beginVersion,
	                        endVersion,
	                        deterministicRandom()->randomUniqueID().toString().c_str(),
	                        tagId,
	                        totalTags,
	                        blockSize));
}

Future<Reference<IBackupFile>> BackupContainerFileSystem::writeRangeFile(Version snapshotBeginVersion,
                                                                         int snapshotFileCount,
                                                                         Version fileVersion,
                                                                         int blockSize) {
	std::string fileName = format(
	    "range,%" PRId64 ",%s,%d", fileVersion, deterministicRandom()->randomUniqueID().toString().c_str(), blockSize);

	// In order to test backward compatibility in simulation, sometimes write to the old path format
	if (g_network->isSimulated() && deterministicRandom()->coinflip()) {
		return writeFile(BackupContainerFileSystemImpl::old_rangeVersionFolderString(fileVersion) + fileName);
	}

	return writeFile(BackupContainerFileSystemImpl::snapshotFolderString(snapshotBeginVersion) +
	                 format("/%d/", snapshotFileCount / (BUGGIFY ? 1 : 5000)) + fileName);
}

Future<std::pair<std::vector<RangeFile>, std::map<std::string, KeyRange>>>
BackupContainerFileSystem::readKeyspaceSnapshot(KeyspaceSnapshotFile snapshot) {
	return BackupContainerFileSystemImpl::readKeyspaceSnapshot(Reference<BackupContainerFileSystem>::addRef(this),
	                                                           snapshot);
}

Future<Void> BackupContainerFileSystem::writeKeyspaceSnapshotFile(const std::vector<std::string>& fileNames,
                                                                  const std::vector<std::pair<Key, Key>>& beginEndKeys,
                                                                  int64_t totalBytes,
                                                                  IncludeKeyRangeMap includeKeyRangeMap) {
	return BackupContainerFileSystemImpl::writeKeyspaceSnapshotFile(
	    Reference<BackupContainerFileSystem>::addRef(this), fileNames, beginEndKeys, totalBytes, includeKeyRangeMap);
};

Future<std::vector<LogFile>> BackupContainerFileSystem::listLogFiles(Version beginVersion,
                                                                     Version targetVersion,
                                                                     bool partitioned) {
	// The first relevant log file could have a begin version less than beginVersion based on the knobs which
	// determine log file range size, so start at an earlier version adjusted by how many versions a file could
	// contain.
	//
	// Get the cleaned (without slashes) first and last folders that could contain relevant results.
	std::string firstPath =
	    BackupContainerFileSystemImpl::cleanFolderString(BackupContainerFileSystemImpl::logVersionFolderString(
	        std::max<Version>(0,
	                          beginVersion - CLIENT_KNOBS->BACKUP_MAX_LOG_RANGES * CLIENT_KNOBS->LOG_RANGE_BLOCK_SIZE),
	        partitioned));
	std::string lastPath = BackupContainerFileSystemImpl::cleanFolderString(
	    BackupContainerFileSystemImpl::logVersionFolderString(targetVersion, partitioned));

	std::function<bool(std::string const&)> pathFilter = [=](const std::string& folderPath) {
		// Remove slashes in the given folder path so that the '/' positions in the version folder string do not
		// matter

		std::string cleaned = BackupContainerFileSystemImpl::cleanFolderString(folderPath);
		return StringRef(firstPath).startsWith(cleaned) || StringRef(lastPath).startsWith(cleaned) ||
		       (cleaned > firstPath && cleaned < lastPath);
	};

	return map(listFiles((partitioned ? "plogs/" : "logs/"), pathFilter), [=](const FilesAndSizesT& files) {
		std::vector<LogFile> results;
		LogFile lf;
		for (auto& f : files) {
			if (BackupContainerFileSystemImpl::pathToLogFile(lf, f.first, f.second) && lf.endVersion > beginVersion &&
			    lf.beginVersion <= targetVersion)
				results.push_back(lf);
		}
		return results;
	});
}

Future<std::vector<RangeFile>> BackupContainerFileSystem::old_listRangeFiles(Version beginVersion, Version endVersion) {
	// Get the cleaned (without slashes) first and last folders that could contain relevant results.
	std::string firstPath = BackupContainerFileSystemImpl::cleanFolderString(
	    BackupContainerFileSystemImpl::old_rangeVersionFolderString(beginVersion));
	std::string lastPath = BackupContainerFileSystemImpl::cleanFolderString(
	    BackupContainerFileSystemImpl::old_rangeVersionFolderString(endVersion));

	std::function<bool(std::string const&)> pathFilter = [=](const std::string& folderPath) {
		// Remove slashes in the given folder path so that the '/' positions in the version folder string do not
		// matter
		std::string cleaned = BackupContainerFileSystemImpl::cleanFolderString(folderPath);

		return StringRef(firstPath).startsWith(cleaned) || StringRef(lastPath).startsWith(cleaned) ||
		       (cleaned > firstPath && cleaned < lastPath);
	};

	return map(listFiles("ranges/", pathFilter), [=](const FilesAndSizesT& files) {
		std::vector<RangeFile> results;
		RangeFile rf;
		for (auto& f : files) {
			if (BackupContainerFileSystemImpl::pathToRangeFile(rf, f.first, f.second) && rf.version >= beginVersion &&
			    rf.version <= endVersion)
				results.push_back(rf);
		}
		return results;
	});
}

Future<std::vector<RangeFile>> BackupContainerFileSystem::listRangeFiles(Version beginVersion, Version endVersion) {
	// Until the old folder scheme is no longer supported, read files stored using old folder scheme
	Future<std::vector<RangeFile>> oldFiles = old_listRangeFiles(beginVersion, endVersion);

	// Define filter function (for listFiles() implementations that use it) to reject any folder
	// starting after endVersion
	std::function<bool(std::string const&)> pathFilter = [=](std::string const& path) {
		return BackupContainerFileSystemImpl::extractSnapshotBeginVersion(path) <= endVersion;
	};

	Future<std::vector<RangeFile>> newFiles = map(listFiles("kvranges/", pathFilter), [=](const FilesAndSizesT& files) {
		std::vector<RangeFile> results;
		RangeFile rf;
		for (auto& f : files) {
			if (BackupContainerFileSystemImpl::pathToRangeFile(rf, f.first, f.second) && rf.version >= beginVersion &&
			    rf.version <= endVersion)
				results.push_back(rf);
		}
		return results;
	});

	return map(success(oldFiles) && success(newFiles), [=](Void _) {
		std::vector<RangeFile> results = std::move(newFiles.get());
		std::vector<RangeFile> oldResults = std::move(oldFiles.get());
		results.insert(
		    results.end(), std::make_move_iterator(oldResults.begin()), std::make_move_iterator(oldResults.end()));
		return results;
	});
}

Future<std::vector<KeyspaceSnapshotFile>> BackupContainerFileSystem::listKeyspaceSnapshots(Version begin, Version end) {
	return map(listFiles("snapshots/"), [=](const FilesAndSizesT& files) {
		std::vector<KeyspaceSnapshotFile> results;
		KeyspaceSnapshotFile sf;
		for (auto& f : files) {
			if (BackupContainerFileSystemImpl::pathToKeyspaceSnapshotFile(sf, f.first) && sf.beginVersion < end &&
			    sf.endVersion >= begin)
				results.push_back(sf);
		}
		std::sort(results.begin(), results.end());
		return results;
	});
}

Future<BackupFileList> BackupContainerFileSystem::dumpFileList(Version begin, Version end) {
	return BackupContainerFileSystemImpl::dumpFileList(Reference<BackupContainerFileSystem>::addRef(this), begin, end);
}

Future<BackupDescription> BackupContainerFileSystem::describeBackup(bool deepScan, Version logStartVersionOverride) {
	return BackupContainerFileSystemImpl::describeBackup(
	    Reference<BackupContainerFileSystem>::addRef(this), deepScan, logStartVersionOverride);
}

Future<Void> BackupContainerFileSystem::expireData(Version expireEndVersion,
                                                   bool force,
                                                   ExpireProgress* progress,
                                                   Version restorableBeginVersion) {
	return BackupContainerFileSystemImpl::expireData(
	    Reference<BackupContainerFileSystem>::addRef(this), expireEndVersion, force, progress, restorableBeginVersion);
}

Future<Void> BackupContainerFileSystem::writeEncryptionMetadata() {
	return BackupContainerFileSystemImpl::writeEncryptionMetadataIfNotExists(
	    Reference<BackupContainerFileSystem>::addRef(this));
}

															#line 7563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
namespace {
// This generated class is to be used only via getSnapshotFileKeyRange_impl()
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class GetSnapshotFileKeyRange_implActor>
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class GetSnapshotFileKeyRange_implActorState {
															#line 7570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	GetSnapshotFileKeyRange_implActorState(Reference<BackupContainerFileSystem> const& bc,RangeFile const& file,Database const& cx) 
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   file(file),
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   cx(cx),
															#line 1527 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   readFileRetries(0),
															#line 1528 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   beginKeySet(false),
															#line 1529 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   beginKey(),
															#line 1530 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   endKey()
															#line 7589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetSnapshotFileKeyRange_implActorState() 
	{
		fdb_probe_actor_destroy("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1531 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			;
															#line 7604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetSnapshotFileKeyRange_implActorState();
		static_cast<GetSnapshotFileKeyRange_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1565 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<GetSnapshotFileKeyRange_implActor*>(this)->SAV<KeyRange>::futures) { (void)(KeyRange(KeyRangeRef(beginKey, endKey))); this->~GetSnapshotFileKeyRange_implActorState(); static_cast<GetSnapshotFileKeyRange_implActor*>(this)->destroy(); return 0; }
															#line 7627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<GetSnapshotFileKeyRange_implActor*>(this)->SAV< KeyRange >::value()) KeyRange(KeyRange(KeyRangeRef(beginKey, endKey)));
		this->~GetSnapshotFileKeyRange_implActorState();
		static_cast<GetSnapshotFileKeyRange_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1533 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = bc->readFile(file.fileName);
															#line 1533 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state = 1;
															#line 1533 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >*>(static_cast<GetSnapshotFileKeyRange_implActor*>(this)));
															#line 7654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1548 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (e.code() == error_code_restore_bad_read || e.code() == error_code_restore_unsupported_file_version || e.code() == error_code_restore_corrupted_data_padding)
															#line 7689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 1550 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				TraceEvent(SevError, "BackupContainerGetSnapshotFileKeyRange").error(e);
															#line 1551 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
			else
			{
															#line 1552 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (e.code() == error_code_http_request_failed || e.code() == error_code_connection_failed || e.code() == error_code_timed_out || e.code() == error_code_lookup_failed)
															#line 7701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 1555 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					TraceEvent(SevWarnAlways, "BackupContainerGetSnapshotFileKeyRangeConnectionFailure") .error(e) .detail("Retries", ++readFileRetries);
															#line 1558 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					StrictFuture<Void> __when_expr_2 = delayJittered(0.1);
															#line 1558 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					if (static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
					static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state = 3;
															#line 1558 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >*>(static_cast<GetSnapshotFileKeyRange_implActor*>(this)));
															#line 7714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 1560 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					TraceEvent(SevError, "BackupContainerGetSnapshotFileKeyRangeUnexpectedError").error(e);
															#line 1561 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1534 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		beginKeySet = false;
															#line 1535 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		j = 0;
															#line 1536 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 7743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<IAsyncFile> const& __inFile,int loopDepth) 
	{
															#line 1533 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		inFile = __inFile;
															#line 7752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<IAsyncFile> && __inFile,int loopDepth) 
	{
		inFile = std::move(__inFile);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotFileKeyRange_implActor*>(this)->ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 1536 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(j < file.fileSize))
															#line 7844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1537 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int64_t len = std::min<int64_t>(file.blockSize, file.fileSize - j);
															#line 1538 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyValueRef>>> __when_expr_1 = fileBackup::decodeRangeFileBlock(inFile, j, len, cx);
															#line 1538 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state = 2;
															#line 1538 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >*>(static_cast<GetSnapshotFileKeyRange_implActor*>(this)));
															#line 7859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Standalone<VectorRef<KeyValueRef>> const& blockData,int loopDepth) 
	{
															#line 1540 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!beginKeySet)
															#line 7881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1541 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			beginKey = blockData.front().key;
															#line 1542 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			beginKeySet = true;
															#line 7887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 1544 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		endKey = blockData.back().key;
															#line 1536 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		j += file.blockSize;
															#line 7893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Standalone<VectorRef<KeyValueRef>> && blockData,int loopDepth) 
	{
															#line 1540 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!beginKeySet)
															#line 7902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1541 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			beginKey = blockData.front().key;
															#line 1542 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			beginKeySet = true;
															#line 7908 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 1544 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		endKey = blockData.back().key;
															#line 1536 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		j += file.blockSize;
															#line 7914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Standalone<VectorRef<KeyValueRef>> const& blockData,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(blockData, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Standalone<VectorRef<KeyValueRef>> && blockData,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(blockData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotFileKeyRange_implActor*>(this)->ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >*,Standalone<VectorRef<KeyValueRef>> const& value) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >*,Standalone<VectorRef<KeyValueRef>> && value) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state > 0) static_cast<GetSnapshotFileKeyRange_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetSnapshotFileKeyRange_implActor*>(this)->ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	RangeFile file;
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Database cx;
															#line 1527 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int readFileRetries;
															#line 1528 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	bool beginKeySet;
															#line 1529 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key beginKey;
															#line 1530 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key endKey;
															#line 1533 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IAsyncFile> inFile;
															#line 1535 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int64_t j;
															#line 8111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via getSnapshotFileKeyRange_impl()
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class GetSnapshotFileKeyRange_implActor final : public Actor<KeyRange>, public ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >, public ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >, public ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >, public FastAllocated<GetSnapshotFileKeyRange_implActor>, public GetSnapshotFileKeyRange_implActorState<GetSnapshotFileKeyRange_implActor> {
															#line 8116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<GetSnapshotFileKeyRange_implActor>::operator new;
	using FastAllocated<GetSnapshotFileKeyRange_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2202827566990564352UL, 17434628119594191104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<KeyRange>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >;
friend struct ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >;
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	GetSnapshotFileKeyRange_implActor(Reference<BackupContainerFileSystem> const& bc,RangeFile const& file,Database const& cx) 
															#line 8135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<KeyRange>(),
		   GetSnapshotFileKeyRange_implActorState<GetSnapshotFileKeyRange_implActor>(bc, file, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7397033236399725056UL, 9079865723238831872UL);
		ActorExecutionContextHelper __helper(static_cast<GetSnapshotFileKeyRange_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getSnapshotFileKeyRange_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getSnapshotFileKeyRange_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetSnapshotFileKeyRange_implActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetSnapshotFileKeyRange_implActor, 1, Standalone<VectorRef<KeyValueRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetSnapshotFileKeyRange_implActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<KeyRange> getSnapshotFileKeyRange_impl( Reference<BackupContainerFileSystem> const& bc, RangeFile const& file, Database const& cx ) {
															#line 1524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<KeyRange>(new GetSnapshotFileKeyRange_implActor(bc, file, cx));
															#line 8170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 1567 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 8175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
namespace {
// This generated class is to be used only via writeVersionProperty()
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class WriteVersionPropertyActor>
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteVersionPropertyActorState {
															#line 8182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteVersionPropertyActorState(Reference<BackupContainerFileSystem> const& bc,std::string const& path,Version const& v) 
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   path(path),
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   v(v)
															#line 8193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("writeVersionProperty", reinterpret_cast<unsigned long>(this));

	}
	~WriteVersionPropertyActorState() 
	{
		fdb_probe_actor_destroy("writeVersionProperty", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1570 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Reference<IBackupFile>> __when_expr_0 = bc->writeFile(path);
															#line 1570 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state = 1;
															#line 1570 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >*>(static_cast<WriteVersionPropertyActor*>(this)));
															#line 8216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteVersionPropertyActorState();
		static_cast<WriteVersionPropertyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1576 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarn, "BackupContainerWritePropertyFailed") .error(e) .detail("URL", bc->getURL()) .detail("Path", path);
															#line 1580 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 8248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1571 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		std::string s = format("%lld", v);
															#line 1572 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f->append(s.data(), s.size());
															#line 1572 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state = 2;
															#line 1572 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteVersionPropertyActor, 1, Void >*>(static_cast<WriteVersionPropertyActor*>(this)));
															#line 8271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IBackupFile> const& __f,int loopDepth) 
	{
															#line 1570 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		f = __f;
															#line 8280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IBackupFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state > 0) static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state = 0;
		static_cast<WriteVersionPropertyActor*>(this)->ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1573 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->finish();
															#line 1573 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state = 3;
															#line 1573 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteVersionPropertyActor, 2, Void >*>(static_cast<WriteVersionPropertyActor*>(this)));
															#line 8366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1573 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->finish();
															#line 1573 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state = 3;
															#line 1573 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteVersionPropertyActor, 2, Void >*>(static_cast<WriteVersionPropertyActor*>(this)));
															#line 8382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state > 0) static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state = 0;
		static_cast<WriteVersionPropertyActor*>(this)->ActorCallback< WriteVersionPropertyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteVersionPropertyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteVersionPropertyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteVersionPropertyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1574 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteVersionPropertyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteVersionPropertyActorState(); static_cast<WriteVersionPropertyActor*>(this)->destroy(); return 0; }
															#line 8466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<WriteVersionPropertyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteVersionPropertyActorState();
		static_cast<WriteVersionPropertyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1574 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteVersionPropertyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteVersionPropertyActorState(); static_cast<WriteVersionPropertyActor*>(this)->destroy(); return 0; }
															#line 8478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<WriteVersionPropertyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteVersionPropertyActorState();
		static_cast<WriteVersionPropertyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state > 0) static_cast<WriteVersionPropertyActor*>(this)->actor_wait_state = 0;
		static_cast<WriteVersionPropertyActor*>(this)->ActorCallback< WriteVersionPropertyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteVersionPropertyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteVersionPropertyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteVersionPropertyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string path;
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version v;
															#line 1570 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> f;
															#line 8569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via writeVersionProperty()
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteVersionPropertyActor final : public Actor<Void>, public ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >, public ActorCallback< WriteVersionPropertyActor, 1, Void >, public ActorCallback< WriteVersionPropertyActor, 2, Void >, public FastAllocated<WriteVersionPropertyActor>, public WriteVersionPropertyActorState<WriteVersionPropertyActor> {
															#line 8574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<WriteVersionPropertyActor>::operator new;
	using FastAllocated<WriteVersionPropertyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7290515207418056704UL, 7531764504271518208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >;
friend struct ActorCallback< WriteVersionPropertyActor, 1, Void >;
friend struct ActorCallback< WriteVersionPropertyActor, 2, Void >;
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteVersionPropertyActor(Reference<BackupContainerFileSystem> const& bc,std::string const& path,Version const& v) 
															#line 8593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   WriteVersionPropertyActorState<WriteVersionPropertyActor>(bc, path, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeVersionProperty", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3950136920544534016UL, 12704436107426719232UL);
		ActorExecutionContextHelper __helper(static_cast<WriteVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeVersionProperty");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeVersionProperty", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteVersionPropertyActor, 0, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteVersionPropertyActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteVersionPropertyActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> writeVersionProperty( Reference<BackupContainerFileSystem> const& bc, std::string const& path, Version const& v ) {
															#line 1568 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new WriteVersionPropertyActor(bc, path, v));
															#line 8628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 1583 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 8633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
namespace {
// This generated class is to be used only via readVersionProperty()
															#line 1584 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class ReadVersionPropertyActor>
															#line 1584 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ReadVersionPropertyActorState {
															#line 8640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 1584 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ReadVersionPropertyActorState(Reference<BackupContainerFileSystem> const& bc,std::string const& path) 
															#line 1584 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1584 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : bc(bc),
															#line 1584 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   path(path)
															#line 8649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("readVersionProperty", reinterpret_cast<unsigned long>(this));

	}
	~ReadVersionPropertyActorState() 
	{
		fdb_probe_actor_destroy("readVersionProperty", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1586 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Reference<IAsyncFile>> __when_expr_0 = bc->readFile(path);
															#line 1586 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state = 1;
															#line 1586 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >*>(static_cast<ReadVersionPropertyActor*>(this)));
															#line 8672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadVersionPropertyActorState();
		static_cast<ReadVersionPropertyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1600 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (e.code() == error_code_file_not_found)
															#line 8702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 1601 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (!static_cast<ReadVersionPropertyActor*>(this)->SAV<Optional<Version>>::futures) { (void)(Optional<Version>()); this->~ReadVersionPropertyActorState(); static_cast<ReadVersionPropertyActor*>(this)->destroy(); return 0; }
															#line 8706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				new (&static_cast<ReadVersionPropertyActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(Optional<Version>());
				this->~ReadVersionPropertyActorState();
				static_cast<ReadVersionPropertyActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1603 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			TraceEvent(SevWarn, "BackupContainerReadPropertyFailed") .error(e) .detail("URL", bc->getURL()) .detail("Path", path);
															#line 1608 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 8716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1587 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = f->size();
															#line 1587 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state = 2;
															#line 1587 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadVersionPropertyActor, 1, int64_t >*>(static_cast<ReadVersionPropertyActor*>(this)));
															#line 8737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __f,int loopDepth) 
	{
															#line 1586 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		f = __f;
															#line 8746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __f,int loopDepth) 
	{
		f = std::move(__f);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state > 0) static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadVersionPropertyActor*>(this)->ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1588 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		s = std::string();
															#line 1589 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		s.resize(size);
															#line 1590 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<int> __when_expr_2 = f->read((uint8_t*)s.data(), size, 0);
															#line 1590 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state = 3;
															#line 1590 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadVersionPropertyActor, 2, int >*>(static_cast<ReadVersionPropertyActor*>(this)));
															#line 8836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(int64_t const& __size,int loopDepth) 
	{
															#line 1587 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		size = __size;
															#line 8845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t && __size,int loopDepth) 
	{
		size = std::move(__size);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state > 0) static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadVersionPropertyActor*>(this)->ActorCallback< ReadVersionPropertyActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< ReadVersionPropertyActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadVersionPropertyActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadVersionPropertyActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int const& rs,int loopDepth) 
	{
															#line 1591 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		Version v;
															#line 1592 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int len;
															#line 1593 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (rs == size && sscanf(s.c_str(), "%" SCNd64 "%n", &v, &len) == 1 && len == size)
															#line 8928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1594 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<ReadVersionPropertyActor*>(this)->SAV<Optional<Version>>::futures) { (void)(v); this->~ReadVersionPropertyActorState(); static_cast<ReadVersionPropertyActor*>(this)->destroy(); return 0; }
															#line 8932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			new (&static_cast<ReadVersionPropertyActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(v);
			this->~ReadVersionPropertyActorState();
			static_cast<ReadVersionPropertyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1596 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent(SevWarn, "BackupContainerInvalidProperty").detail("URL", bc->getURL()).detail("Path", path);
															#line 1598 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		return a_body1Catch2(backup_invalid_info(), loopDepth);
															#line 8942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont4(int && rs,int loopDepth) 
	{
															#line 1591 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		Version v;
															#line 1592 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int len;
															#line 1593 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (rs == size && sscanf(s.c_str(), "%" SCNd64 "%n", &v, &len) == 1 && len == size)
															#line 8954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1594 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<ReadVersionPropertyActor*>(this)->SAV<Optional<Version>>::futures) { (void)(v); this->~ReadVersionPropertyActorState(); static_cast<ReadVersionPropertyActor*>(this)->destroy(); return 0; }
															#line 8958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			new (&static_cast<ReadVersionPropertyActor*>(this)->SAV< Optional<Version> >::value()) Optional<Version>(v);
			this->~ReadVersionPropertyActorState();
			static_cast<ReadVersionPropertyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1596 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		TraceEvent(SevWarn, "BackupContainerInvalidProperty").detail("URL", bc->getURL()).detail("Path", path);
															#line 1598 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		return a_body1Catch2(backup_invalid_info(), loopDepth);
															#line 8968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont3when1(int const& rs,int loopDepth) 
	{
		loopDepth = a_body1cont4(rs, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(int && rs,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(rs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state > 0) static_cast<ReadVersionPropertyActor*>(this)->actor_wait_state = 0;
		static_cast<ReadVersionPropertyActor*>(this)->ActorCallback< ReadVersionPropertyActor, 2, int >::remove();

	}
	void a_callback_fire(ActorCallback< ReadVersionPropertyActor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadVersionPropertyActor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadVersionPropertyActor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1584 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<BackupContainerFileSystem> bc;
															#line 1584 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string path;
															#line 1586 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IAsyncFile> f;
															#line 1587 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int64_t size;
															#line 1588 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string s;
															#line 9057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via readVersionProperty()
															#line 1584 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class ReadVersionPropertyActor final : public Actor<Optional<Version>>, public ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >, public ActorCallback< ReadVersionPropertyActor, 1, int64_t >, public ActorCallback< ReadVersionPropertyActor, 2, int >, public FastAllocated<ReadVersionPropertyActor>, public ReadVersionPropertyActorState<ReadVersionPropertyActor> {
															#line 9062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<ReadVersionPropertyActor>::operator new;
	using FastAllocated<ReadVersionPropertyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3410449569035384064UL, 17778091977309780736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Version>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< ReadVersionPropertyActor, 1, int64_t >;
friend struct ActorCallback< ReadVersionPropertyActor, 2, int >;
															#line 1584 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	ReadVersionPropertyActor(Reference<BackupContainerFileSystem> const& bc,std::string const& path) 
															#line 9081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Optional<Version>>(),
		   ReadVersionPropertyActorState<ReadVersionPropertyActor>(bc, path),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readVersionProperty", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10522111719328892928UL, 9104695102772332288UL);
		ActorExecutionContextHelper __helper(static_cast<ReadVersionPropertyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readVersionProperty");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readVersionProperty", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadVersionPropertyActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadVersionPropertyActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadVersionPropertyActor, 2, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1584 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Optional<Version>> readVersionProperty( Reference<BackupContainerFileSystem> const& bc, std::string const& path ) {
															#line 1584 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Optional<Version>>(new ReadVersionPropertyActor(bc, path));
															#line 9116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 1611 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

Future<KeyRange> BackupContainerFileSystem::getSnapshotFileKeyRange(const RangeFile& file, Database cx) {
	ASSERT(g_network->isSimulated());
	return getSnapshotFileKeyRange_impl(Reference<BackupContainerFileSystem>::addRef(this), file, cx);
}

Future<Optional<RestorableFileSet>> BackupContainerFileSystem::getRestoreSet(Version targetVersion,
                                                                             VectorRef<KeyRangeRef> keyRangesFilter,
                                                                             bool logsOnly,
                                                                             Version beginVersion) {
	return BackupContainerFileSystemImpl::getRestoreSet(
	    Reference<BackupContainerFileSystem>::addRef(this), targetVersion, keyRangesFilter, logsOnly, beginVersion);
}

Future<Optional<Version>> BackupContainerFileSystem::VersionProperty::get() {
	return readVersionProperty(bc, path);
}
Future<Void> BackupContainerFileSystem::VersionProperty::set(Version v) {
	return writeVersionProperty(bc, path, v);
}
Future<Void> BackupContainerFileSystem::VersionProperty::clear() {
	return bc->deleteFile(path);
}

BackupContainerFileSystem::VersionProperty BackupContainerFileSystem::logBeginVersion() {
	return { Reference<BackupContainerFileSystem>::addRef(this), "log_begin_version" };
}
BackupContainerFileSystem::VersionProperty BackupContainerFileSystem::logEndVersion() {
	return { Reference<BackupContainerFileSystem>::addRef(this), "log_end_version" };
}
BackupContainerFileSystem::VersionProperty BackupContainerFileSystem::expiredEndVersion() {
	return { Reference<BackupContainerFileSystem>::addRef(this), "expired_end_version" };
}
BackupContainerFileSystem::VersionProperty BackupContainerFileSystem::unreliableEndVersion() {
	return { Reference<BackupContainerFileSystem>::addRef(this), "unreliable_end_version" };
}
BackupContainerFileSystem::VersionProperty BackupContainerFileSystem::logType() {
	return { Reference<BackupContainerFileSystem>::addRef(this), "mutation_log_type" };
}
BackupContainerFileSystem::VersionProperty BackupContainerFileSystem::fileLevelEncryption() {
	return { Reference<BackupContainerFileSystem>::addRef(this), "file_level_encryption" };
}

bool BackupContainerFileSystem::usesEncryption() const {
	return encryptionSetupFuture.isValid();
}
Future<Void> BackupContainerFileSystem::encryptionSetupComplete() const {
	return encryptionSetupFuture;
}

Future<Void> BackupContainerFileSystem::writeEntireFileFallback(const std::string& fileName,
                                                                const std::string& fileContents) {
	return BackupContainerFileSystemImpl::writeEntireFileFallback(
	    Reference<BackupContainerFileSystem>::addRef(this), fileName, fileContents);
}

void BackupContainerFileSystem::setEncryptionKey(Optional<std::string> const& encryptionKeyFileName) {
	if (encryptionKeyFileName.present()) {
		encryptionSetupFuture = BackupContainerFileSystemImpl::readEncryptionKey(encryptionKeyFileName.get());
	}
}
Future<Void> BackupContainerFileSystem::createTestEncryptionKeyFile(std::string const& filename) {
	return BackupContainerFileSystemImpl::createTestEncryptionKeyFile(filename);
}

// Get a BackupContainerFileSystem based on a container URL string
// TODO: refactor to not duplicate IBackupContainer::openContainer. It's the exact same
// code but returning a different template type because you can't cast between them
Reference<BackupContainerFileSystem> BackupContainerFileSystem::openContainerFS(
    const std::string& url,
    const Optional<std::string>& proxy,
    const Optional<std::string>& encryptionKeyFileName,
    bool isBackup) {
	static std::map<std::string, Reference<BackupContainerFileSystem>> m_cache;

	Reference<BackupContainerFileSystem>& r = m_cache[url];
	if (r)
		return r;

	try {
		StringRef u(url);
		if (u.startsWith("file://"_sr)) {
			r = makeReference<BackupContainerLocalDirectory>(url, encryptionKeyFileName);
		} else if (u.startsWith("blobstore://"_sr)) {
			std::string resource;
			Optional<std::string> blobstoreProxy;

			// If no proxy is passed down to the openContainer method, try to fallback to the
			// fileBackupAgentProxy which is a global variable and will be set for the backup_agent.
			if (proxy.present()) {
				blobstoreProxy = proxy.get();
			} else if (fileBackupAgentProxy.present()) {
				blobstoreProxy = fileBackupAgentProxy.get();
			}

			// The URL parameters contain blobstore endpoint tunables as well as possible backup-specific options.
			S3BlobStoreEndpoint::ParametersT backupParams;
			Reference<S3BlobStoreEndpoint> bstore =
			    S3BlobStoreEndpoint::fromString(url, blobstoreProxy, &resource, &lastOpenError, &backupParams);

			if (resource.empty())
				throw backup_invalid_url();
			for (auto c : resource)
				if (!isalnum(c) && c != '_' && c != '-' && c != '.' && c != '/')
					throw backup_invalid_url();
			r = makeReference<BackupContainerS3BlobStore>(
			    bstore, resource, backupParams, encryptionKeyFileName, isBackup);
		}
#ifdef BUILD_AZURE_BACKUP
		else if (u.startsWith("azure://"_sr)) {
			u.eat("azure://"_sr);
			auto address = u.eat("/"_sr);
			if (address.endsWith(std::string(azure::storage_lite::constants::default_endpoint_suffix))) {
				CODE_PROBE(true, "Azure backup url with standard azure storage account endpoint");
				// <account>.<service>.core.windows.net/<resource_path>
				auto endPoint = address.toString();
				auto accountName = address.eat("."_sr).toString();
				auto containerName = u.eat("/"_sr).toString();
				r = makeReference<BackupContainerAzureBlobStore>(
				    endPoint, accountName, containerName, encryptionKeyFileName);
			} else {
				// resolve the network address if necessary
				std::string endpoint(address.toString());
				Optional<NetworkAddress> parsedAddress = NetworkAddress::parseOptional(endpoint);
				if (!parsedAddress.present()) {
					try {
						auto hostname = Hostname::parse(endpoint);
						auto resolvedAddress = hostname.resolveBlocking();
						if (resolvedAddress.present()) {
							CODE_PROBE(true, "Azure backup url with hostname in the endpoint");
							parsedAddress = resolvedAddress.get();
						}
					} catch (Error& e) {
						TraceEvent(SevError, "InvalidAzureBackupUrl").error(e).detail("Endpoint", endpoint);
						throw backup_invalid_url();
					}
				}
				if (!parsedAddress.present()) {
					TraceEvent(SevError, "InvalidAzureBackupUrl").detail("Endpoint", endpoint);
					throw backup_invalid_url();
				}
				auto accountName = u.eat("/"_sr).toString();
				// Avoid including ":tls" and "(fromHostname)"
				// note: the endpoint needs to contain the account name
				// so either "<account_name>.blob.core.windows.net" or "<ip>:<port>/<account_name>"
				endpoint =
				    fmt::format("{}/{}", formatIpPort(parsedAddress.get().ip, parsedAddress.get().port), accountName);
				auto containerName = u.eat("/"_sr).toString();
				r = makeReference<BackupContainerAzureBlobStore>(
				    endpoint, accountName, containerName, encryptionKeyFileName);
			}
		}
#endif
		else {
			lastOpenError = "invalid URL prefix";
			throw backup_invalid_url();
		}

		r->encryptionKeyFileName = encryptionKeyFileName;
		r->URL = url;
		return r;
	} catch (Error& e) {
		if (e.code() == error_code_actor_cancelled)
			throw;

		TraceEvent m(SevWarn, "BackupContainer");
		m.error(e);
		m.detail("Description", "Invalid container specification.  See help.");
		m.detail("URL", url);
		if (e.code() == error_code_backup_invalid_url)
			m.detail("LastOpenError", lastOpenError);

		throw;
	}
}

namespace backup_test {

int chooseFileSize(std::vector<int>& sizes) {
	if (!sizes.empty()) {
		int size = sizes.back();
		sizes.pop_back();
		return size;
	}
	return deterministicRandom()->randomInt(0, 2e6);
}

															#line 9307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via writeAndVerifyFile()
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class WriteAndVerifyFileActor>
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteAndVerifyFileActorState {
															#line 9313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteAndVerifyFileActorState(Reference<IBackupContainer> const& c,Reference<IBackupFile> const& f,int const& size,FlowLock* const& lock) 
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : c(c),
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   f(f),
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   size(size),
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   lock(lock),
															#line 1802 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   content()
															#line 9328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("writeAndVerifyFile", reinterpret_cast<unsigned long>(this));

	}
	~WriteAndVerifyFileActorState() 
	{
		fdb_probe_actor_destroy("writeAndVerifyFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1804 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = lock->take(TaskPriority::DefaultYield, size);
															#line 1804 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 1;
															#line 1804 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 0, Void >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 9350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteAndVerifyFileActorState();
		static_cast<WriteAndVerifyFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1805 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		releaser = FlowLock::Releaser(*lock, size);
															#line 1807 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("writeAndVerify size=%d file=%s\n", size, f->getFileName().c_str());
															#line 1808 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		content.resize(content.arena(), size);
															#line 1809 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for(int i = 0;i < content.size();++i) {
															#line 1810 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			content[i] = (uint8_t)deterministicRandom()->randomInt(0, 256);
															#line 9381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 1813 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		sendBuf = content;
															#line 1814 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 9387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1805 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		releaser = FlowLock::Releaser(*lock, size);
															#line 1807 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("writeAndVerify size=%d file=%s\n", size, f->getFileName().c_str());
															#line 1808 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		content.resize(content.arena(), size);
															#line 1809 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for(int i = 0;i < content.size();++i) {
															#line 1810 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			content[i] = (uint8_t)deterministicRandom()->randomInt(0, 256);
															#line 9404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 1813 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		sendBuf = content;
															#line 1814 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 9410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyFileActor*>(this)->ActorCallback< WriteAndVerifyFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1819 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = f->finish();
															#line 1819 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 3;
															#line 1819 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 2, Void >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 9501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1814 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(sendBuf.size() > 0))
															#line 9517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1815 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		n = std::min(sendBuf.size(), deterministicRandom()->randomInt(1, 16384));
															#line 1816 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f->append(sendBuf.begin(), n);
															#line 1816 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 2;
															#line 1816 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 1, Void >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 9532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1817 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		sendBuf.pop_front(n);
															#line 9554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1817 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		sendBuf.pop_front(n);
															#line 9563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyFileActor*>(this)->ActorCallback< WriteAndVerifyFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1821 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_3 = c->readFile(f->getFileName());
															#line 1821 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 4;
															#line 1821 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 9654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1821 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_3 = c->readFile(f->getFileName());
															#line 1821 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 4;
															#line 1821 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 9670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyFileActor*>(this)->ActorCallback< WriteAndVerifyFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1822 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<int64_t> __when_expr_4 = inputFile->size();
															#line 1822 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 5;
															#line 1822 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 4, int64_t >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 9761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Reference<IAsyncFile> const& __inputFile,int loopDepth) 
	{
															#line 1821 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		inputFile = __inputFile;
															#line 9770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Reference<IAsyncFile> && __inputFile,int loopDepth) 
	{
		inputFile = std::move(__inputFile);
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyFileActor*>(this)->ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(int64_t const& fileSize,int loopDepth) 
	{
															#line 1823 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(size, fileSize);
															#line 1824 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (size > 0)
															#line 9851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1825 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			buf = Standalone<VectorRef<uint8_t>>();
															#line 1826 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			buf.resize(buf.arena(), fileSize);
															#line 1827 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<int> __when_expr_5 = inputFile->read(buf.begin(), buf.size(), 0);
															#line 1827 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
			static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 6;
															#line 1827 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 5, int >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 9866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(int64_t && fileSize,int loopDepth) 
	{
															#line 1823 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(size, fileSize);
															#line 1824 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (size > 0)
															#line 9882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1825 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			buf = Standalone<VectorRef<uint8_t>>();
															#line 1826 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			buf.resize(buf.arena(), fileSize);
															#line 1827 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<int> __when_expr_5 = inputFile->read(buf.begin(), buf.size(), 0);
															#line 1827 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
			static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 6;
															#line 1827 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< WriteAndVerifyFileActor, 5, int >*>(static_cast<WriteAndVerifyFileActor*>(this)));
															#line 9897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5when1(int64_t const& fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont6(fileSize, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(int64_t && fileSize,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(fileSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyFileActor*>(this)->ActorCallback< WriteAndVerifyFileActor, 4, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 4, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 4, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyFileActor, 4, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1831 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<WriteAndVerifyFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteAndVerifyFileActorState(); static_cast<WriteAndVerifyFileActor*>(this)->destroy(); return 0; }
															#line 9986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<WriteAndVerifyFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteAndVerifyFileActorState();
		static_cast<WriteAndVerifyFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(int const& b,int loopDepth) 
	{
															#line 1828 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(b, buf.size());
															#line 1829 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(buf == content);
															#line 10000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(int && b,int loopDepth) 
	{
															#line 1828 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(b, buf.size());
															#line 1829 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(buf == content);
															#line 10011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(int const& b,int loopDepth) 
	{
		loopDepth = a_body1cont8(b, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(int && b,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(b), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state > 0) static_cast<WriteAndVerifyFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteAndVerifyFileActor*>(this)->ActorCallback< WriteAndVerifyFileActor, 5, int >::remove();

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 5, int >*,int const& value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< WriteAndVerifyFileActor, 5, int >*,int && value) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< WriteAndVerifyFileActor, 5, int >*,Error err) 
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupContainer> c;
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> f;
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int size;
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowLock* lock;
															#line 1802 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Standalone<VectorRef<uint8_t>> content;
															#line 1805 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowLock::Releaser releaser;
															#line 1813 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	VectorRef<uint8_t> sendBuf;
															#line 1815 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int n;
															#line 1821 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IAsyncFile> inputFile;
															#line 1825 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Standalone<VectorRef<uint8_t>> buf;
															#line 10111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via writeAndVerifyFile()
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class WriteAndVerifyFileActor final : public Actor<Void>, public ActorCallback< WriteAndVerifyFileActor, 0, Void >, public ActorCallback< WriteAndVerifyFileActor, 1, Void >, public ActorCallback< WriteAndVerifyFileActor, 2, Void >, public ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >, public ActorCallback< WriteAndVerifyFileActor, 4, int64_t >, public ActorCallback< WriteAndVerifyFileActor, 5, int >, public FastAllocated<WriteAndVerifyFileActor>, public WriteAndVerifyFileActorState<WriteAndVerifyFileActor> {
															#line 10116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<WriteAndVerifyFileActor>::operator new;
	using FastAllocated<WriteAndVerifyFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2062479714935869952UL, 11188483605169027584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteAndVerifyFileActor, 0, Void >;
friend struct ActorCallback< WriteAndVerifyFileActor, 1, Void >;
friend struct ActorCallback< WriteAndVerifyFileActor, 2, Void >;
friend struct ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >;
friend struct ActorCallback< WriteAndVerifyFileActor, 4, int64_t >;
friend struct ActorCallback< WriteAndVerifyFileActor, 5, int >;
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	WriteAndVerifyFileActor(Reference<IBackupContainer> const& c,Reference<IBackupFile> const& f,int const& size,FlowLock* const& lock) 
															#line 10138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   WriteAndVerifyFileActorState<WriteAndVerifyFileActor>(c, f, size, lock),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10679368928020552448UL, 15202424407061132288UL);
		ActorExecutionContextHelper __helper(static_cast<WriteAndVerifyFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeAndVerifyFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeAndVerifyFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteAndVerifyFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteAndVerifyFileActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteAndVerifyFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WriteAndVerifyFileActor, 3, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WriteAndVerifyFileActor, 4, int64_t >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< WriteAndVerifyFileActor, 5, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] Future<Void> writeAndVerifyFile( Reference<IBackupContainer> const& c, Reference<IBackupFile> const& f, int const& size, FlowLock* const& lock ) {
															#line 1798 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new WriteAndVerifyFileActor(c, f, size, lock));
															#line 10175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 1833 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

// Randomly advance version by up to 1 second of versions
Version nextVersion(Version v) {
	int64_t increment = deterministicRandom()->randomInt64(1, CLIENT_KNOBS->CORE_VERSIONSPERSECOND);
	return v + increment;
}

// Write a snapshot file with only begin & end key
															#line 10187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via testWriteSnapshotFile()
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class TestWriteSnapshotFileActor>
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class TestWriteSnapshotFileActorState {
															#line 10193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	TestWriteSnapshotFileActorState(Reference<IBackupFile> const& file,Key const& begin,Key const& end,uint32_t const& blockSize) 
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : file(file),
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   begin(begin),
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   end(end),
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   blockSize(blockSize)
															#line 10206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this));

	}
	~TestWriteSnapshotFileActorState() 
	{
		fdb_probe_actor_destroy("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1842 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT_GT(blockSize, 3 * sizeof(uint32_t) + begin.size() + end.size());
															#line 1844 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			uint32_t fileVersion = BACKUP_AGENT_SNAPSHOT_FILE_VERSION;
															#line 1846 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = file->append((uint8_t*)&fileVersion, sizeof(fileVersion));
															#line 1846 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 1;
															#line 1846 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 0, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestWriteSnapshotFileActorState();
		static_cast<TestWriteSnapshotFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1849 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = file->appendStringRefWithLen(begin);
															#line 1849 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 2;
															#line 1849 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 1, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1849 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = file->appendStringRefWithLen(begin);
															#line 1849 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 2;
															#line 1849 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 1, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<TestWriteSnapshotFileActor*>(this)->ActorCallback< TestWriteSnapshotFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestWriteSnapshotFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1852 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->appendStringRefWithLen(end);
															#line 1852 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 3;
															#line 1852 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 2, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1852 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->appendStringRefWithLen(end);
															#line 1852 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 3;
															#line 1852 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 2, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<TestWriteSnapshotFileActor*>(this)->ActorCallback< TestWriteSnapshotFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestWriteSnapshotFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1854 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int bytesLeft = blockSize - file->size();
															#line 1855 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (bytesLeft > 0)
															#line 10471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1856 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			Value paddings = fileBackup::makePadding(bytesLeft);
															#line 1857 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_3 = file->append(paddings.begin(), bytesLeft);
															#line 1857 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 4;
															#line 1857 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 3, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1854 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int bytesLeft = blockSize - file->size();
															#line 1855 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (bytesLeft > 0)
															#line 10500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1856 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			Value paddings = fileBackup::makePadding(bytesLeft);
															#line 1857 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_3 = file->append(paddings.begin(), bytesLeft);
															#line 1857 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 4;
															#line 1857 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 3, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<TestWriteSnapshotFileActor*>(this)->ActorCallback< TestWriteSnapshotFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestWriteSnapshotFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1859 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_4 = file->finish();
															#line 1859 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 5;
															#line 1859 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestWriteSnapshotFileActor, 4, Void >*>(static_cast<TestWriteSnapshotFileActor*>(this)));
															#line 10609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<TestWriteSnapshotFileActor*>(this)->ActorCallback< TestWriteSnapshotFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestWriteSnapshotFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1860 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<TestWriteSnapshotFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestWriteSnapshotFileActorState(); static_cast<TestWriteSnapshotFileActor*>(this)->destroy(); return 0; }
															#line 10705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<TestWriteSnapshotFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestWriteSnapshotFileActorState();
		static_cast<TestWriteSnapshotFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1860 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<TestWriteSnapshotFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestWriteSnapshotFileActorState(); static_cast<TestWriteSnapshotFileActor*>(this)->destroy(); return 0; }
															#line 10717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<TestWriteSnapshotFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestWriteSnapshotFileActorState();
		static_cast<TestWriteSnapshotFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state > 0) static_cast<TestWriteSnapshotFileActor*>(this)->actor_wait_state = 0;
		static_cast<TestWriteSnapshotFileActor*>(this)->ActorCallback< TestWriteSnapshotFileActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestWriteSnapshotFileActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestWriteSnapshotFileActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> file;
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key begin;
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key end;
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	uint32_t blockSize;
															#line 10808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via testWriteSnapshotFile()
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class TestWriteSnapshotFileActor final : public Actor<Void>, public ActorCallback< TestWriteSnapshotFileActor, 0, Void >, public ActorCallback< TestWriteSnapshotFileActor, 1, Void >, public ActorCallback< TestWriteSnapshotFileActor, 2, Void >, public ActorCallback< TestWriteSnapshotFileActor, 3, Void >, public ActorCallback< TestWriteSnapshotFileActor, 4, Void >, public FastAllocated<TestWriteSnapshotFileActor>, public TestWriteSnapshotFileActorState<TestWriteSnapshotFileActor> {
															#line 10813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<TestWriteSnapshotFileActor>::operator new;
	using FastAllocated<TestWriteSnapshotFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10796566480690716672UL, 6449124422834456576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestWriteSnapshotFileActor, 0, Void >;
friend struct ActorCallback< TestWriteSnapshotFileActor, 1, Void >;
friend struct ActorCallback< TestWriteSnapshotFileActor, 2, Void >;
friend struct ActorCallback< TestWriteSnapshotFileActor, 3, Void >;
friend struct ActorCallback< TestWriteSnapshotFileActor, 4, Void >;
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	TestWriteSnapshotFileActor(Reference<IBackupFile> const& file,Key const& begin,Key const& end,uint32_t const& blockSize) 
															#line 10834 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   TestWriteSnapshotFileActorState<TestWriteSnapshotFileActor>(file, begin, end, blockSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5978292015299530752UL, 7007095461914833152UL);
		ActorExecutionContextHelper __helper(static_cast<TestWriteSnapshotFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testWriteSnapshotFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testWriteSnapshotFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestWriteSnapshotFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestWriteSnapshotFileActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestWriteSnapshotFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestWriteSnapshotFileActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestWriteSnapshotFileActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] static Future<Void> testWriteSnapshotFile( Reference<IBackupFile> const& file, Key const& begin, Key const& end, uint32_t const& blockSize ) {
															#line 1841 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new TestWriteSnapshotFileActor(file, begin, end, blockSize));
															#line 10870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 1862 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 10875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via testBackupContainer()
															#line 1863 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class TestBackupContainerActor>
															#line 1863 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class TestBackupContainerActorState {
															#line 10881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 1863 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	TestBackupContainerActorState(std::string const& url,Optional<std::string> const& proxy,Optional<std::string> const& encryptionKeyFileName) 
															#line 1863 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 1863 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : url(url),
															#line 1863 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   proxy(proxy),
															#line 1863 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   encryptionKeyFileName(encryptionKeyFileName),
															#line 1866 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   lock(100e6)
															#line 10894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("testBackupContainer", reinterpret_cast<unsigned long>(this));

	}
	~TestBackupContainerActorState() 
	{
		fdb_probe_actor_destroy("testBackupContainer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1868 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (encryptionKeyFileName.present())
															#line 10909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 1869 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Void> __when_expr_0 = BackupContainerFileSystem::createTestEncryptionKeyFile(encryptionKeyFileName.get());
															#line 1869 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 1;
															#line 1869 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 0, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 10920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestBackupContainerActorState();
		static_cast<TestBackupContainerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1872 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("BackupContainerTest URL %s\n", url.c_str());
															#line 1874 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		c = IBackupContainer::openContainer(url, proxy, encryptionKeyFileName);
															#line 10950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		try {
															#line 1878 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_1 = c->deleteContainer();
															#line 1878 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 10956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 2;
															#line 1878 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 1, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 10961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1884 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = c->create();
															#line 1884 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 3;
															#line 1884 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 2, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1880 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (e.code() != error_code_backup_invalid_url && e.code() != error_code_backup_does_not_exist)
															#line 11080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 1881 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 11084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1886 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes = std::vector<Future<Void>>();
															#line 1887 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshots = std::map<Version, std::vector<std::string>>();
															#line 1888 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotSizes = std::map<Version, int64_t>();
															#line 1889 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginEndKeys = std::map<Version, std::vector<std::pair<Key, Key>>>();
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		nRangeFiles = 0;
															#line 1891 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs = std::map<Version, std::string>();
															#line 1892 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = deterministicRandom()->randomInt64(0, std::numeric_limits<Version>::max() / 2);
															#line 1895 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		fileSizes = { 0 };
															#line 1896 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (StringRef(url).startsWith("blob"_sr))
															#line 11216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1897 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			fileSizes.push_back(CLIENT_KNOBS->BLOBSTORE_MULTIPART_MIN_PART_SIZE);
															#line 1898 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			fileSizes.push_back(CLIENT_KNOBS->BLOBSTORE_MULTIPART_MIN_PART_SIZE + 10);
															#line 11222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 1901 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 11226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1886 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes = std::vector<Future<Void>>();
															#line 1887 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshots = std::map<Version, std::vector<std::string>>();
															#line 1888 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotSizes = std::map<Version, int64_t>();
															#line 1889 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginEndKeys = std::map<Version, std::vector<std::pair<Key, Key>>>();
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		nRangeFiles = 0;
															#line 1891 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs = std::map<Version, std::string>();
															#line 1892 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = deterministicRandom()->randomInt64(0, std::numeric_limits<Version>::max() / 2);
															#line 1895 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		fileSizes = { 0 };
															#line 1896 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (StringRef(url).startsWith("blob"_sr))
															#line 11251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1897 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			fileSizes.push_back(CLIENT_KNOBS->BLOBSTORE_MULTIPART_MIN_PART_SIZE);
															#line 1898 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			fileSizes.push_back(CLIENT_KNOBS->BLOBSTORE_MULTIPART_MIN_PART_SIZE + 10);
															#line 11257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 1901 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 11261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1959 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_6 = waitForAll(writes);
															#line 1959 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 7;
															#line 1959 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 6, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 1902 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logStart = v;
															#line 1903 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		kvfiles = deterministicRandom()->randomInt(0, 3);
															#line 1904 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		begin = ""_sr;
															#line 1905 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		end = ""_sr;
															#line 1906 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		blockSize = 3 * sizeof(uint32_t) + begin.size() + end.size() + 8;
															#line 1908 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 11378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont6loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(int loopDepth) 
	{
															#line 1943 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (logStart == v || deterministicRandom()->coinflip())
															#line 11400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1944 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			v = nextVersion(v);
															#line 11404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 1946 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IBackupFile>> __when_expr_5 = c->writeLogFile(logStart, v, 10);
															#line 1946 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 6;
															#line 1946 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1(int loopDepth) 
	{
															#line 1908 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(kvfiles > 0))
															#line 11431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont6loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1909 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (snapshots.empty())
															#line 11437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1910 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshots[v] = {};
															#line 1911 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshotBeginEndKeys[v] = {};
															#line 1912 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshotSizes[v] = 0;
															#line 1913 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 11447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 1914 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				v = nextVersion(v);
															#line 11451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
		}
															#line 1917 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IBackupFile>> __when_expr_3 = c->writeRangeFile(snapshots.rbegin()->first, 0, v, blockSize);
															#line 1917 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont6loopBody1loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 4;
															#line 1917 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont6loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont1(Reference<IBackupFile> const& range,int loopDepth) 
	{
															#line 1918 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++nRangeFiles;
															#line 1919 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = nextVersion(v);
															#line 1920 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshots.rbegin()->second.push_back(range->getFileName());
															#line 1921 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginEndKeys.rbegin()->second.emplace_back(begin, end);
															#line 1923 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int size = chooseFileSize(fileSizes);
															#line 1924 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotSizes.rbegin()->second += size;
															#line 1927 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_4 = testWriteSnapshotFile(range, begin, end, blockSize);
															#line 1927 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1cont6loopBody1loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 5;
															#line 1927 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 4, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont1(Reference<IBackupFile> && range,int loopDepth) 
	{
															#line 1918 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++nRangeFiles;
															#line 1919 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = nextVersion(v);
															#line 1920 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshots.rbegin()->second.push_back(range->getFileName());
															#line 1921 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginEndKeys.rbegin()->second.emplace_back(begin, end);
															#line 1923 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int size = chooseFileSize(fileSizes);
															#line 1924 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotSizes.rbegin()->second += size;
															#line 1927 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_4 = testWriteSnapshotFile(range, begin, end, blockSize);
															#line 1927 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1cont6loopBody1loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 5;
															#line 1927 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 4, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1when1(Reference<IBackupFile> const& range,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1loopBody1cont1(range, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1when1(Reference<IBackupFile> && range,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1loopBody1cont1(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6loopBody1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1929 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (deterministicRandom()->random01() < .2)
															#line 11616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1930 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			writes.push_back(c->writeKeyspaceSnapshotFile(snapshots.rbegin()->second, snapshotBeginEndKeys.rbegin()->second, snapshotSizes.rbegin()->second, IncludeKeyRangeMap(BUGGIFY)));
															#line 1934 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshots[v] = {};
															#line 1935 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshotBeginEndKeys[v] = {};
															#line 1936 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshotSizes[v] = 0;
															#line 11626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			return a_body1cont6loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1940 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		--kvfiles;
															#line 11631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont6loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1929 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (deterministicRandom()->random01() < .2)
															#line 11640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1930 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			writes.push_back(c->writeKeyspaceSnapshotFile(snapshots.rbegin()->second, snapshotBeginEndKeys.rbegin()->second, snapshotSizes.rbegin()->second, IncludeKeyRangeMap(BUGGIFY)));
															#line 1934 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshots[v] = {};
															#line 1935 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshotBeginEndKeys[v] = {};
															#line 1936 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshotSizes[v] = 0;
															#line 11650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			return a_body1cont6loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1940 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		--kvfiles;
															#line 11655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont6loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6loopBody1cont2(int loopDepth) 
	{
															#line 1947 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logs[logStart] = log->getFileName();
															#line 1948 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		int size = chooseFileSize(fileSizes);
															#line 1949 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes.push_back(writeAndVerifyFile(c, log, size, &lock));
															#line 1952 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (fileSizes.empty() && !snapshots.empty() && snapshots.rbegin()->second.empty() && deterministicRandom()->random01() < .2)
															#line 11745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1954 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			snapshots.erase(snapshots.rbegin()->first);
															#line 11749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Reference<IBackupFile> const& __log,int loopDepth) 
	{
															#line 1946 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		log = __log;
															#line 11760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont6loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Reference<IBackupFile> && __log,int loopDepth) 
	{
		log = std::move(__log);
		loopDepth = a_body1cont6loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 1961 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_7 = c->dumpFileList();
															#line 1961 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 8;
															#line 1961 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 7, BackupFileList >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 1961 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_7 = c->dumpFileList();
															#line 1961 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 8;
															#line 1961 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 7, BackupFileList >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 1962 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(listing.ranges.size(), nRangeFiles);
															#line 1963 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(listing.logs.size(), logs.size());
															#line 1964 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(listing.snapshots.size(), snapshots.size());
															#line 1966 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_8 = c->describeBackup();
															#line 1966 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 9;
															#line 1966 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 8, BackupDescription >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 11959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(BackupFileList const& __listing,int loopDepth) 
	{
															#line 1961 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		listing = __listing;
															#line 11968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(BackupFileList && __listing,int loopDepth) 
	{
		listing = std::move(__listing);
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 7, BackupFileList >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 7, BackupFileList >*,BackupFileList const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 7, BackupFileList >*,BackupFileList && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 7, BackupFileList >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 1967 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("\n%s\n", desc.toString().c_str());
															#line 1970 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		i = 0;
															#line 1971 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 12051 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(BackupDescription const& __desc,int loopDepth) 
	{
															#line 1966 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc = __desc;
															#line 12060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(BackupDescription && __desc,int loopDepth) 
	{
		desc = std::move(__desc);
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 8, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 8, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 8, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 8, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont2(int loopDepth) 
	{
															#line 2003 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("DELETING\n");
															#line 2004 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_14 = c->deleteContainer();
															#line 2004 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_14.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 15;
															#line 2004 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 14, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1(int loopDepth) 
	{
															#line 1971 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(i < listing.snapshots.size()))
															#line 12164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont10cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		{
															#line 1974 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Optional<RestorableFileSet>> __when_expr_9 = c->getRestoreSet(desc.maxRestorableVersion.get());
															#line 1974 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1when1(__when_expr_9.get(), loopDepth); };
			static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 10;
															#line 1974 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1(int loopDepth) 
	{
		{
															#line 1980 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Optional<RestorableFileSet>> __when_expr_10 = c->getRestoreSet(listing.snapshots[i].endVersion);
															#line 1980 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont1when1(__when_expr_10.get(), loopDepth); };
			static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 11;
															#line 1980 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont3(Optional<RestorableFileSet> const& rest,int loopDepth) 
	{
															#line 1975 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(rest.present());
															#line 12219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont3(Optional<RestorableFileSet> && rest,int loopDepth) 
	{
															#line 1975 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(rest.present());
															#line 12228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1when1(Optional<RestorableFileSet> const& rest,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont3(rest, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1when1(Optional<RestorableFileSet> && rest,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont3(std::move(rest), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont1loopBody1cont5(int loopDepth) 
	{
															#line 1985 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		expireVersion = listing.snapshots[i].endVersion;
															#line 1988 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		fmt::print("EXPIRE TO {}\n", expireVersion);
															#line 1989 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		f = c->expireData(expireVersion);
															#line 1990 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_11 = ready(f);
															#line 1990 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont5when1(__when_expr_11.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 12;
															#line 1990 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 11, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12325 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont6(Optional<RestorableFileSet> const& rest,int loopDepth) 
	{
															#line 1981 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(rest.present());
															#line 12334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont6(Optional<RestorableFileSet> && rest,int loopDepth) 
	{
															#line 1981 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(rest.present());
															#line 12343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont10cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1when1(Optional<RestorableFileSet> const& rest,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont6(rest, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont1when1(Optional<RestorableFileSet> && rest,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont6(std::move(rest), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10cont1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 1993 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (f.isError())
															#line 12427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT_EQ(f.getError().code(), error_code_backup_cannot_expire);
															#line 1995 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT_EQ(i, listing.snapshots.size() - 1);
															#line 1996 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_12 = c->expireData(expireVersion, true);
															#line 1996 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont8when1(__when_expr_12.get(), loopDepth); };
			static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 13;
															#line 1996 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 12, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont1loopBody1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 1993 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (f.isError())
															#line 12456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 1994 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT_EQ(f.getError().code(), error_code_backup_cannot_expire);
															#line 1995 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT_EQ(i, listing.snapshots.size() - 1);
															#line 1996 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_12 = c->expireData(expireVersion, true);
															#line 1996 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont8when1(__when_expr_12.get(), loopDepth); };
			static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 13;
															#line 1996 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 12, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont1loopBody1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont10cont1loopBody1cont9(int loopDepth) 
	{
															#line 1999 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_13 = c->describeBackup();
															#line 1999 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10cont1loopBody1cont9when1(__when_expr_13.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 14;
															#line 1999 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 13, BackupDescription >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont10cont1loopBody1cont11(BackupDescription const& d,int loopDepth) 
	{
															#line 2000 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("\n%s\n", d.toString().c_str());
															#line 1971 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++i;
															#line 12665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont10cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont11(BackupDescription && d,int loopDepth) 
	{
															#line 2000 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("\n%s\n", d.toString().c_str());
															#line 1971 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++i;
															#line 12676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont10cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont9when1(BackupDescription const& d,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont11(d, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1loopBody1cont9when1(BackupDescription && d,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1loopBody1cont11(std::move(d), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 13, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 13, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 13, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 13, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont10cont3(Void const& _,int loopDepth) 
	{
															#line 2006 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		d = c->describeBackup();
															#line 2007 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_15 = ready(d);
															#line 2007 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 16;
															#line 2007 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 15, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3(Void && _,int loopDepth) 
	{
															#line 2006 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		d = c->describeBackup();
															#line 2007 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_15 = ready(d);
															#line 2007 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_15.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 16;
															#line 2007 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 15, Void >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont10cont4(Void const& _,int loopDepth) 
	{
															#line 2008 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(d.isError() && d.getError().code() == error_code_backup_does_not_exist);
															#line 2010 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_16 = c->dumpFileList();
															#line 2010 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_16.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 17;
															#line 2010 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 16, BackupFileList >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont4(Void && _,int loopDepth) 
	{
															#line 2008 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(d.isError() && d.getError().code() == error_code_backup_does_not_exist);
															#line 2010 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_16 = c->dumpFileList();
															#line 2010 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont4when1(__when_expr_16.get(), loopDepth); };
		static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 17;
															#line 2010 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerActor, 16, BackupFileList >*>(static_cast<TestBackupContainerActor*>(this)));
															#line 12898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont10cont5(BackupFileList const& empty,int loopDepth) 
	{
															#line 2011 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.ranges.size(), 0);
															#line 2012 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.logs.size(), 0);
															#line 2013 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.snapshots.size(), 0);
															#line 2015 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("BackupContainerTest URL=%s PASSED.\n", url.c_str());
															#line 2017 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<TestBackupContainerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestBackupContainerActorState(); static_cast<TestBackupContainerActor*>(this)->destroy(); return 0; }
															#line 12990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<TestBackupContainerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestBackupContainerActorState();
		static_cast<TestBackupContainerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont5(BackupFileList && empty,int loopDepth) 
	{
															#line 2011 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.ranges.size(), 0);
															#line 2012 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.logs.size(), 0);
															#line 2013 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.snapshots.size(), 0);
															#line 2015 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("BackupContainerTest URL=%s PASSED.\n", url.c_str());
															#line 2017 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<TestBackupContainerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestBackupContainerActorState(); static_cast<TestBackupContainerActor*>(this)->destroy(); return 0; }
															#line 13010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<TestBackupContainerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestBackupContainerActorState();
		static_cast<TestBackupContainerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont4when1(BackupFileList const& empty,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(empty, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont4when1(BackupFileList && empty,int loopDepth) 
	{
		loopDepth = a_body1cont10cont5(std::move(empty), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<TestBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerActor*>(this)->ActorCallback< TestBackupContainerActor, 16, BackupFileList >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 16, BackupFileList >*,BackupFileList const& value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerActor, 16, BackupFileList >*,BackupFileList && value) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< TestBackupContainerActor, 16, BackupFileList >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), 16);

	}
															#line 1863 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string url;
															#line 1863 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<std::string> proxy;
															#line 1863 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<std::string> encryptionKeyFileName;
															#line 1866 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowLock lock;
															#line 1874 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupContainer> c;
															#line 1886 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<Future<Void>> writes;
															#line 1887 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::map<Version, std::vector<std::string>> snapshots;
															#line 1888 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::map<Version, int64_t> snapshotSizes;
															#line 1889 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::map<Version, std::vector<std::pair<Key, Key>>> snapshotBeginEndKeys;
															#line 1890 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int nRangeFiles;
															#line 1891 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::map<Version, std::string> logs;
															#line 1892 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version v;
															#line 1895 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<int> fileSizes;
															#line 1902 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version logStart;
															#line 1903 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int kvfiles;
															#line 1904 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key begin;
															#line 1905 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key end;
															#line 1906 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int blockSize;
															#line 1946 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> log;
															#line 1961 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupFileList listing;
															#line 1966 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupDescription desc;
															#line 1970 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int i;
															#line 1985 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version expireVersion;
															#line 1989 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Future<Void> f;
															#line 2006 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Future<BackupDescription> d;
															#line 13143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via testBackupContainer()
															#line 1863 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class TestBackupContainerActor final : public Actor<Void>, public ActorCallback< TestBackupContainerActor, 0, Void >, public ActorCallback< TestBackupContainerActor, 1, Void >, public ActorCallback< TestBackupContainerActor, 2, Void >, public ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >, public ActorCallback< TestBackupContainerActor, 4, Void >, public ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >, public ActorCallback< TestBackupContainerActor, 6, Void >, public ActorCallback< TestBackupContainerActor, 7, BackupFileList >, public ActorCallback< TestBackupContainerActor, 8, BackupDescription >, public ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >, public ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >, public ActorCallback< TestBackupContainerActor, 11, Void >, public ActorCallback< TestBackupContainerActor, 12, Void >, public ActorCallback< TestBackupContainerActor, 13, BackupDescription >, public ActorCallback< TestBackupContainerActor, 14, Void >, public ActorCallback< TestBackupContainerActor, 15, Void >, public ActorCallback< TestBackupContainerActor, 16, BackupFileList >, public FastAllocated<TestBackupContainerActor>, public TestBackupContainerActorState<TestBackupContainerActor> {
															#line 13148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<TestBackupContainerActor>::operator new;
	using FastAllocated<TestBackupContainerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5092544381966237696UL, 1902908417631404288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestBackupContainerActor, 0, Void >;
friend struct ActorCallback< TestBackupContainerActor, 1, Void >;
friend struct ActorCallback< TestBackupContainerActor, 2, Void >;
friend struct ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >;
friend struct ActorCallback< TestBackupContainerActor, 4, Void >;
friend struct ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >;
friend struct ActorCallback< TestBackupContainerActor, 6, Void >;
friend struct ActorCallback< TestBackupContainerActor, 7, BackupFileList >;
friend struct ActorCallback< TestBackupContainerActor, 8, BackupDescription >;
friend struct ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >;
friend struct ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >;
friend struct ActorCallback< TestBackupContainerActor, 11, Void >;
friend struct ActorCallback< TestBackupContainerActor, 12, Void >;
friend struct ActorCallback< TestBackupContainerActor, 13, BackupDescription >;
friend struct ActorCallback< TestBackupContainerActor, 14, Void >;
friend struct ActorCallback< TestBackupContainerActor, 15, Void >;
friend struct ActorCallback< TestBackupContainerActor, 16, BackupFileList >;
															#line 1863 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	TestBackupContainerActor(std::string const& url,Optional<std::string> const& proxy,Optional<std::string> const& encryptionKeyFileName) 
															#line 13181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   TestBackupContainerActorState<TestBackupContainerActor>(url, proxy, encryptionKeyFileName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testBackupContainer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(264860235252261888UL, 13065414093191862528UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testBackupContainer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testBackupContainer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestBackupContainerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestBackupContainerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestBackupContainerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestBackupContainerActor, 3, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestBackupContainerActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestBackupContainerActor, 5, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TestBackupContainerActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< TestBackupContainerActor, 7, BackupFileList >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< TestBackupContainerActor, 8, BackupDescription >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< TestBackupContainerActor, 9, Optional<RestorableFileSet> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< TestBackupContainerActor, 10, Optional<RestorableFileSet> >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< TestBackupContainerActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< TestBackupContainerActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< TestBackupContainerActor, 13, BackupDescription >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< TestBackupContainerActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< TestBackupContainerActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< TestBackupContainerActor, 16, BackupFileList >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1863 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] Future<Void> testBackupContainer( std::string const& url, Optional<std::string> const& proxy, Optional<std::string> const& encryptionKeyFileName ) {
															#line 1863 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new TestBackupContainerActor(url, proxy, encryptionKeyFileName));
															#line 13229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 2019 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 13234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via flowTestCase2020()
															#line 2020 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2020Actor>
															#line 2020 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2020ActorState {
															#line 13240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 2020 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2020ActorState(UnitTestParameters const& params) 
															#line 2020 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2020 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 13247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase2020", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2020ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2020", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2021 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testBackupContainer(format("file://%s/fdb_backups/%llx", params.getDataDir().c_str(), timer_int()), {}, {});
															#line 2021 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<FlowTestCase2020Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase2020Actor*>(this)->actor_wait_state = 1;
															#line 2021 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase2020Actor, 0, Void >*>(static_cast<FlowTestCase2020Actor*>(this)));
															#line 13269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2020ActorState();
		static_cast<FlowTestCase2020Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2022 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2020Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2020ActorState(); static_cast<FlowTestCase2020Actor*>(this)->destroy(); return 0; }
															#line 13292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<FlowTestCase2020Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2020ActorState();
		static_cast<FlowTestCase2020Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2022 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2020Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2020ActorState(); static_cast<FlowTestCase2020Actor*>(this)->destroy(); return 0; }
															#line 13304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<FlowTestCase2020Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2020ActorState();
		static_cast<FlowTestCase2020Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase2020Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase2020Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase2020Actor*>(this)->ActorCallback< FlowTestCase2020Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase2020Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase2020", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2020Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2020", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase2020Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase2020", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2020Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2020", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase2020Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase2020", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2020Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2020", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2020 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 13389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase2020()
															#line 2020 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2020Actor final : public Actor<Void>, public ActorCallback< FlowTestCase2020Actor, 0, Void >, public FastAllocated<FlowTestCase2020Actor>, public FlowTestCase2020ActorState<FlowTestCase2020Actor> {
															#line 13394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase2020Actor>::operator new;
	using FastAllocated<FlowTestCase2020Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9251699782792779264UL, 3718587287456941824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase2020Actor, 0, Void >;
															#line 2020 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2020Actor(UnitTestParameters const& params) 
															#line 13411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase2020ActorState<FlowTestCase2020Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2020", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17337883412881757440UL, 16813064531799584000UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2020Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2020");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2020", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase2020Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2020 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2020( UnitTestParameters const& params ) {
															#line 2020 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2020Actor(params));
															#line 13443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase2020, "/backup/containers/localdir/unencrypted")

#line 2024 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 13449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via flowTestCase2025()
															#line 2025 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2025Actor>
															#line 2025 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2025ActorState {
															#line 13455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 2025 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2025ActorState(UnitTestParameters const& params) 
															#line 2025 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2025 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 13462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase2025", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2025ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2025", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2026 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testBackupContainer(format("file://%s/fdb_backups/%llx", params.getDataDir().c_str(), timer_int()), {}, format("%s/test_encryption_key", params.getDataDir().c_str()));
															#line 2026 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<FlowTestCase2025Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase2025Actor*>(this)->actor_wait_state = 1;
															#line 2026 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase2025Actor, 0, Void >*>(static_cast<FlowTestCase2025Actor*>(this)));
															#line 13484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2025ActorState();
		static_cast<FlowTestCase2025Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2029 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2025Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2025ActorState(); static_cast<FlowTestCase2025Actor*>(this)->destroy(); return 0; }
															#line 13507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<FlowTestCase2025Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2025ActorState();
		static_cast<FlowTestCase2025Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2029 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2025Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2025ActorState(); static_cast<FlowTestCase2025Actor*>(this)->destroy(); return 0; }
															#line 13519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<FlowTestCase2025Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2025ActorState();
		static_cast<FlowTestCase2025Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase2025Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase2025Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase2025Actor*>(this)->ActorCallback< FlowTestCase2025Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase2025Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase2025", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2025Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2025", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase2025Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase2025", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2025Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2025", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase2025Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase2025", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2025Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2025", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2025 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 13604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase2025()
															#line 2025 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2025Actor final : public Actor<Void>, public ActorCallback< FlowTestCase2025Actor, 0, Void >, public FastAllocated<FlowTestCase2025Actor>, public FlowTestCase2025ActorState<FlowTestCase2025Actor> {
															#line 13609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase2025Actor>::operator new;
	using FastAllocated<FlowTestCase2025Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9159498263396769792UL, 8119854625004482560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase2025Actor, 0, Void >;
															#line 2025 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2025Actor(UnitTestParameters const& params) 
															#line 13626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase2025ActorState<FlowTestCase2025Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2025", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17302727946664022016UL, 8525006939992433408UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2025Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2025");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2025", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase2025Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2025 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2025( UnitTestParameters const& params ) {
															#line 2025 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2025Actor(params));
															#line 13658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase2025, "/backup/containers/localdir/encrypted")

#line 2031 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 13664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via flowTestCase2032()
															#line 2032 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2032Actor>
															#line 2032 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2032ActorState {
															#line 13670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 2032 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2032ActorState(UnitTestParameters const& params) 
															#line 2032 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2032 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 13677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase2032", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2032ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2032", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2033 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!g_network->isSimulated())
															#line 13692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 2034 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				const char* url = getenv("FDB_TEST_BACKUP_URL");
															#line 2035 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				ASSERT(url != nullptr);
															#line 2036 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Void> __when_expr_0 = testBackupContainer(url, {}, {});
															#line 2036 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<FlowTestCase2032Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FlowTestCase2032Actor*>(this)->actor_wait_state = 1;
															#line 2036 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase2032Actor, 0, Void >*>(static_cast<FlowTestCase2032Actor*>(this)));
															#line 13707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2032ActorState();
		static_cast<FlowTestCase2032Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2038 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2032Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2032ActorState(); static_cast<FlowTestCase2032Actor*>(this)->destroy(); return 0; }
															#line 13735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<FlowTestCase2032Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2032ActorState();
		static_cast<FlowTestCase2032Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase2032Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase2032Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase2032Actor*>(this)->ActorCallback< FlowTestCase2032Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase2032Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase2032", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2032Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2032", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase2032Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase2032", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2032Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2032", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase2032Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase2032", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2032Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2032", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2032 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 13832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase2032()
															#line 2032 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2032Actor final : public Actor<Void>, public ActorCallback< FlowTestCase2032Actor, 0, Void >, public FastAllocated<FlowTestCase2032Actor>, public FlowTestCase2032ActorState<FlowTestCase2032Actor> {
															#line 13837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase2032Actor>::operator new;
	using FastAllocated<FlowTestCase2032Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6316649694501663744UL, 16540096426207549184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase2032Actor, 0, Void >;
															#line 2032 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2032Actor(UnitTestParameters const& params) 
															#line 13854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase2032ActorState<FlowTestCase2032Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2032", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8975558713436433920UL, 2986609695073531392UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2032Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2032");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2032", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase2032Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2032 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2032( UnitTestParameters const& params ) {
															#line 2032 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2032Actor(params));
															#line 13886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase2032, "/backup/containers/url")

#line 2040 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 13892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via flowTestCase2041()
															#line 2041 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2041Actor>
															#line 2041 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2041ActorState {
															#line 13898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 2041 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2041ActorState(UnitTestParameters const& params) 
															#line 2041 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2041 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 13905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase2041", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2041ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2041", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2042 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!g_network->isSimulated())
															#line 13920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 2043 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				url = getenv("FDB_TEST_BACKUP_URL");
															#line 2044 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				ASSERT(url != nullptr);
															#line 2045 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				printf("Listing %s\n", url);
															#line 2046 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<std::vector<std::string>> __when_expr_0 = IBackupContainer::listContainers(url, {});
															#line 2046 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<FlowTestCase2041Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<FlowTestCase2041Actor*>(this)->actor_wait_state = 1;
															#line 2046 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase2041Actor, 0, std::vector<std::string> >*>(static_cast<FlowTestCase2041Actor*>(this)));
															#line 13937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2041ActorState();
		static_cast<FlowTestCase2041Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2051 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2041Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2041ActorState(); static_cast<FlowTestCase2041Actor*>(this)->destroy(); return 0; }
															#line 13965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<FlowTestCase2041Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2041ActorState();
		static_cast<FlowTestCase2041Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(std::vector<std::string> const& urls,int loopDepth) 
	{
															#line 2047 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto& u : urls ) {
															#line 2048 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			printf("%s\n", u.c_str());
															#line 13979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::vector<std::string> && urls,int loopDepth) 
	{
															#line 2047 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for( auto& u : urls ) {
															#line 2048 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			printf("%s\n", u.c_str());
															#line 13991 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::string> const& urls,int loopDepth) 
	{
		loopDepth = a_body1cont2(urls, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::string> && urls,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(urls), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase2041Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase2041Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase2041Actor*>(this)->ActorCallback< FlowTestCase2041Actor, 0, std::vector<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase2041Actor, 0, std::vector<std::string> >*,std::vector<std::string> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase2041", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2041Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2041", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase2041Actor, 0, std::vector<std::string> >*,std::vector<std::string> && value) 
	{
		fdb_probe_actor_enter("flowTestCase2041", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2041Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2041", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase2041Actor, 0, std::vector<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase2041", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2041Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2041", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2041 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 2043 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	const char* url;
															#line 14076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase2041()
															#line 2041 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2041Actor final : public Actor<Void>, public ActorCallback< FlowTestCase2041Actor, 0, std::vector<std::string> >, public FastAllocated<FlowTestCase2041Actor>, public FlowTestCase2041ActorState<FlowTestCase2041Actor> {
															#line 14081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase2041Actor>::operator new;
	using FastAllocated<FlowTestCase2041Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13447646348273130496UL, 15113440481709643520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase2041Actor, 0, std::vector<std::string> >;
															#line 2041 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2041Actor(UnitTestParameters const& params) 
															#line 14098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase2041ActorState<FlowTestCase2041Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2041", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17417462349685157120UL, 16743617727154502144UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2041Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2041");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2041", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase2041Actor, 0, std::vector<std::string> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2041 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2041( UnitTestParameters const& params ) {
															#line 2041 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2041Actor(params));
															#line 14130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase2041, "/backup/containers_list")

#line 2053 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 14136 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via flowTestCase2054()
															#line 2054 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2054Actor>
															#line 2054 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2054ActorState {
															#line 14142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 2054 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2054ActorState(UnitTestParameters const& params) 
															#line 2054 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2054 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 14149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase2054", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2054ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2054", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2056 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			for(int i = 0;i < 1000;++i) {
															#line 2057 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				int64_t ts = deterministicRandom()->randomInt64(0, std::numeric_limits<int32_t>::max());
															#line 2058 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				ASSERT(BackupAgentBase::parseTime(BackupAgentBase::formatTime(ts)) == ts);
															#line 14168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
															#line 2061 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupAgentBase::parseTime("2019/03/18.17:51:11-0600") == BackupAgentBase::parseTime("2019/03/18.16:51:11-0700"));
															#line 2063 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupAgentBase::parseTime("2019/03/31.22:45:07-0700") == BackupAgentBase::parseTime("2019/04/01.03:45:07-0200"));
															#line 2065 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupAgentBase::parseTime("2019/03/31.22:45:07+0000") == BackupAgentBase::parseTime("2019/04/01.03:45:07+0500"));
															#line 2067 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupAgentBase::parseTime("2019/03/31.22:45:07+0030") == BackupAgentBase::parseTime("2019/04/01.03:45:07+0530"));
															#line 2069 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupAgentBase::parseTime("2019/03/31.22:45:07+0030") == BackupAgentBase::parseTime("2019/04/01.04:00:07+0545"));
															#line 2072 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<FlowTestCase2054Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2054ActorState(); static_cast<FlowTestCase2054Actor*>(this)->destroy(); return 0; }
															#line 14182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			new (&static_cast<FlowTestCase2054Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase2054ActorState();
			static_cast<FlowTestCase2054Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2054ActorState();
		static_cast<FlowTestCase2054Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 2054 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 14206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase2054()
															#line 2054 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2054Actor final : public Actor<Void>, public FastAllocated<FlowTestCase2054Actor>, public FlowTestCase2054ActorState<FlowTestCase2054Actor> {
															#line 14211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase2054Actor>::operator new;
	using FastAllocated<FlowTestCase2054Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12288335841447600128UL, 1164898847001383168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 2054 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2054Actor(UnitTestParameters const& params) 
															#line 14227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase2054ActorState<FlowTestCase2054Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2054", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7800166945460923392UL, 6352403899928126976UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2054Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2054");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2054", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 2054 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2054( UnitTestParameters const& params ) {
															#line 2054 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2054Actor(params));
															#line 14258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase2054, "/backup/time")

#line 2074 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 14264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via flowTestCase2075()
															#line 2075 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2075Actor>
															#line 2075 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2075ActorState {
															#line 14270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 2075 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2075ActorState(UnitTestParameters const& params) 
															#line 2075 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2075 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 14277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase2075", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2075ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2075", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2076 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::vector<LogFile> files;
															#line 2079 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 0, 100, 10, "file1", 100, 0, 2 });
															#line 2080 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 0, 99));
															#line 2081 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 0) == 0);
															#line 2083 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 0, 100, 10, "file2", 200, 1, 2 });
															#line 2084 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2085 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 0, 99));
															#line 2086 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 0, 100));
															#line 2087 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 0) == 99);
															#line 2090 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 100, 200, 10, "file3", 200, 0, 3 });
															#line 2091 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 100, 250, 10, "file4", 200, 1, 3 });
															#line 2092 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2093 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 0, 99));
															#line 2094 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 0, 100));
															#line 2095 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 50, 150));
															#line 2096 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 0) == 99);
															#line 2098 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 100, 300, 10, "file5", 200, 2, 3 });
															#line 2099 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2100 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 50, 150));
															#line 2101 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 50, 200));
															#line 2102 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 10, 199));
															#line 2103 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 0) == 199);
															#line 2104 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 100) == 199);
															#line 2106 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 250, 300, 10, "file6", 200, 0, 3 });
															#line 2107 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2108 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 50, 240));
															#line 2109 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 100, 280));
															#line 2110 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 99) == 199);
															#line 2112 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 250, 300, 10, "file7", 200, 1, 3 });
															#line 2113 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2114 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 100, 280));
															#line 2116 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 200, 250, 10, "file8", 200, 0, 3 });
															#line 2117 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2118 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 0, 299));
															#line 2119 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 100, 280));
															#line 2120 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 150) == 299);
															#line 2124 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 300, 400, 10, "file10", 200, 0, 1 });
															#line 2125 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2126 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 0, 399));
															#line 2127 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 100, 399));
															#line 2128 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 150, 399));
															#line 2129 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::isPartitionedLogsContinuous(files, 250, 399));
															#line 2130 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 0) == 399);
															#line 2131 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 99) == 399);
															#line 2132 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::getPartitionedLogsContinuousEndVersion(files, 250) == 399);
															#line 2134 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<FlowTestCase2075Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2075ActorState(); static_cast<FlowTestCase2075Actor*>(this)->destroy(); return 0; }
															#line 14382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			new (&static_cast<FlowTestCase2075Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase2075ActorState();
			static_cast<FlowTestCase2075Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2075ActorState();
		static_cast<FlowTestCase2075Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 2075 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 14406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase2075()
															#line 2075 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2075Actor final : public Actor<Void>, public FastAllocated<FlowTestCase2075Actor>, public FlowTestCase2075ActorState<FlowTestCase2075Actor> {
															#line 14411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase2075Actor>::operator new;
	using FastAllocated<FlowTestCase2075Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17008739392144953344UL, 1852575412000670208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 2075 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2075Actor(UnitTestParameters const& params) 
															#line 14427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase2075ActorState<FlowTestCase2075Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2075", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5426311760030648064UL, 2913837497981331712UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2075Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2075");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2075", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 2075 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2075( UnitTestParameters const& params ) {
															#line 2075 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2075Actor(params));
															#line 14458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase2075, "/backup/continuous")

#line 2136 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 14464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via flowTestCase2137()
															#line 2137 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2137Actor>
															#line 2137 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2137ActorState {
															#line 14470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 2137 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2137ActorState(UnitTestParameters const& params) 
															#line 2137 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2137 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 14477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase2137", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2137ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2137", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2138 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::vector<LogFile> files;
															#line 2141 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 10, 100, 10, "file1", 100 });
															#line 2142 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 0, 5));
															#line 2143 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 50));
															#line 2144 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 105));
															#line 2145 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 100, 101));
															#line 2146 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 101, 150));
															#line 2147 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 99));
															#line 2148 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 100));
															#line 2149 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 101));
															#line 2150 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 150));
															#line 2151 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 70));
															#line 2152 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 99));
															#line 2153 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 100));
															#line 2154 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 11));
															#line 2155 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 98, 99));
															#line 2156 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 99, 100));
															#line 2157 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 99, 99));
															#line 2158 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 100, 100));
															#line 2159 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 0) == invalidVersion);
															#line 2160 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 5) == invalidVersion);
															#line 2161 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 10) == 100);
															#line 2162 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 50) == 100);
															#line 2163 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 99) == 100);
															#line 2164 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 100) == invalidVersion);
															#line 2165 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 101) == invalidVersion);
															#line 2168 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 100, 200, 10, "file2", 100 });
															#line 2169 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2170 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 0, 5));
															#line 2171 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 50));
															#line 2172 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 105));
															#line 2173 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 100, 101));
															#line 2174 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 101, 150));
															#line 2175 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 99));
															#line 2176 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 100));
															#line 2177 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 101));
															#line 2178 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 150));
															#line 2179 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 70));
															#line 2180 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 99));
															#line 2181 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 100));
															#line 2182 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 11));
															#line 2183 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 98, 99));
															#line 2184 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 99, 100));
															#line 2185 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 99, 99));
															#line 2186 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 100, 100));
															#line 2188 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 150));
															#line 2189 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 205));
															#line 2190 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 200, 201));
															#line 2191 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 201, 250));
															#line 2192 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 199));
															#line 2193 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 200));
															#line 2194 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 201));
															#line 2195 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 70, 170));
															#line 2196 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 70, 200));
															#line 2197 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 199, 200));
															#line 2198 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 199, 199));
															#line 2199 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 200, 200));
															#line 2201 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 0) == invalidVersion);
															#line 2202 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 5) == invalidVersion);
															#line 2203 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 10) == 200);
															#line 2204 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 50) == 200);
															#line 2205 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 99) == 200);
															#line 2206 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 100) == 200);
															#line 2207 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 101) == 200);
															#line 2208 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 199) == 200);
															#line 2209 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 200) == invalidVersion);
															#line 2210 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 201) == invalidVersion);
															#line 2213 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			files.push_back({ 300, 400, 10, "file3", 100 });
															#line 2214 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			std::sort(files.begin(), files.end());
															#line 2215 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 0, 5));
															#line 2216 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 50));
															#line 2217 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 105));
															#line 2218 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 100, 101));
															#line 2219 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 101, 150));
															#line 2220 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 99));
															#line 2221 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 100));
															#line 2222 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 101));
															#line 2223 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 150));
															#line 2224 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 70));
															#line 2225 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 99));
															#line 2226 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 50, 100));
															#line 2227 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 11));
															#line 2228 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 98, 99));
															#line 2229 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 99, 100));
															#line 2230 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 99, 99));
															#line 2231 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 100, 100));
															#line 2233 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 150));
															#line 2234 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 5, 205));
															#line 2235 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 200, 201));
															#line 2236 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 201, 250));
															#line 2237 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 199));
															#line 2238 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 200));
															#line 2239 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 201));
															#line 2240 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 70, 170));
															#line 2241 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 70, 200));
															#line 2242 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 199, 200));
															#line 2243 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 199, 199));
															#line 2244 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 200, 200));
															#line 2246 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 250, 260));
															#line 2247 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 250, 310));
															#line 2248 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 250, 405));
															#line 2249 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 400, 401));
															#line 2250 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 401, 450));
															#line 2251 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 300, 399));
															#line 2252 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 300, 400));
															#line 2253 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 300, 401));
															#line 2254 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 300, 350));
															#line 2255 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 350, 370));
															#line 2256 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 350, 400));
															#line 2257 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 10, 400));
															#line 2258 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 100, 400));
															#line 2259 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 200, 400));
															#line 2260 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 299, 400));
															#line 2261 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 399, 400));
															#line 2262 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 399, 399));
															#line 2263 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot(files, 400, 400));
															#line 2265 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 0) == invalidVersion);
															#line 2266 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 5) == invalidVersion);
															#line 2267 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 10) == 200);
															#line 2268 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 50) == 200);
															#line 2269 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 99) == 200);
															#line 2270 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 100) == 200);
															#line 2271 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 101) == 200);
															#line 2272 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 199) == 200);
															#line 2273 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 200) == invalidVersion);
															#line 2274 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 201) == invalidVersion);
															#line 2275 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 250) == invalidVersion);
															#line 2276 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 299) == invalidVersion);
															#line 2277 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 300) == 400);
															#line 2278 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 301) == 400);
															#line 2279 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 399) == 400);
															#line 2280 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 400) == invalidVersion);
															#line 2281 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 401) == invalidVersion);
															#line 2282 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(BackupContainerFileSystemImpl::findContinuousLogEnd(files, 450) == invalidVersion);
															#line 2284 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!static_cast<FlowTestCase2137Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2137ActorState(); static_cast<FlowTestCase2137Actor*>(this)->destroy(); return 0; }
															#line 14760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			new (&static_cast<FlowTestCase2137Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase2137ActorState();
			static_cast<FlowTestCase2137Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2137ActorState();
		static_cast<FlowTestCase2137Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 2137 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 14784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase2137()
															#line 2137 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2137Actor final : public Actor<Void>, public FastAllocated<FlowTestCase2137Actor>, public FlowTestCase2137ActorState<FlowTestCase2137Actor> {
															#line 14789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase2137Actor>::operator new;
	using FastAllocated<FlowTestCase2137Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15980129885579925248UL, 7532656844266191616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 2137 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2137Actor(UnitTestParameters const& params) 
															#line 14805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase2137ActorState<FlowTestCase2137Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2137", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9840728032639550464UL, 11688054029283066368UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2137Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2137");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2137", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 2137 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2137( UnitTestParameters const& params ) {
															#line 2137 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2137Actor(params));
															#line 14836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase2137, "/backup/logs_continuous")

#line 2286 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

void printFileList(BackupFileList& backupFileList) {
	printf("\nRangeFiles count:%lu", backupFileList.ranges.size());
	for (auto r : backupFileList.ranges)
		printf("\n%s", r.toString().c_str());

	printf("\nLogFiles count:%lu", backupFileList.logs.size());
	for (auto l : backupFileList.logs)
		printf("\n%s", l.toString().c_str());

	printf("\nSnapshotFiles count:%lu", backupFileList.snapshots.size());
	for (auto s : backupFileList.snapshots)
		printf("\n%lld, %lld, %s, %lld\n", s.beginVersion, s.endVersion, s.fileName.c_str(), s.totalSize);
}

// Intentionally missing some log range files and checking if the snapshot can be restored.
															#line 14857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via testBackupContainerWithMissingLogRanges()
															#line 2302 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class TestBackupContainerWithMissingLogRangesActor>
															#line 2302 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class TestBackupContainerWithMissingLogRangesActorState {
															#line 14863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 2302 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	TestBackupContainerWithMissingLogRangesActorState(std::string const& url,Optional<std::string> const& proxy) 
															#line 2302 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2302 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : url(url),
															#line 2302 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   proxy(proxy),
															#line 2303 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   lock(100e6)
															#line 14874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this));

	}
	~TestBackupContainerWithMissingLogRangesActorState() 
	{
		fdb_probe_actor_destroy("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2304 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			printf("BackupContainerTest URL %s\n", url.c_str());
															#line 2306 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			c = IBackupContainer::openContainer(url, proxy, {});
															#line 14891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			try {
															#line 2309 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Void> __when_expr_0 = c->deleteContainer();
															#line 2309 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 14897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 1;
															#line 2309 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 14902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestBackupContainerWithMissingLogRangesActorState();
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2314 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = c->create();
															#line 2314 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 2;
															#line 2314 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 14938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2311 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (e.code() != error_code_backup_invalid_url && e.code() != error_code_backup_does_not_exist)
															#line 14948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 2312 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 14952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 2316 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		begin = randomKeyBetween(normalKeys);
															#line 2317 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		end = randomKeyBetween(KeyRangeRef(begin, normalKeys.end));
															#line 2318 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		blockSize = 3 * sizeof(uint32_t) + begin.size() + end.size() + 8;
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes = std::vector<Future<Void>>();
															#line 2320 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		beginEndKeys = std::make_pair(begin, end);
															#line 2321 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotsMissingLogs = std::vector<bool>();
															#line 2322 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = deterministicRandom()->randomInt64(0, std::numeric_limits<Version>::max() / 2);
															#line 2323 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		tempLogEnd = 0;
															#line 2324 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logStart = v;
															#line 2325 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logEnd = v;
															#line 2326 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginVersion = v;
															#line 2327 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotEndVersion = v;
															#line 2328 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		lastMissedLogFileEnd = 0;
															#line 2331 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		numSnapshots = deterministicRandom()->randomInt(1, 10);
															#line 2332 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 15096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 2316 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		begin = randomKeyBetween(normalKeys);
															#line 2317 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		end = randomKeyBetween(KeyRangeRef(begin, normalKeys.end));
															#line 2318 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		blockSize = 3 * sizeof(uint32_t) + begin.size() + end.size() + 8;
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes = std::vector<Future<Void>>();
															#line 2320 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		beginEndKeys = std::make_pair(begin, end);
															#line 2321 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotsMissingLogs = std::vector<bool>();
															#line 2322 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = deterministicRandom()->randomInt64(0, std::numeric_limits<Version>::max() / 2);
															#line 2323 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		tempLogEnd = 0;
															#line 2324 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logStart = v;
															#line 2325 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logEnd = v;
															#line 2326 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginVersion = v;
															#line 2327 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotEndVersion = v;
															#line 2328 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		lastMissedLogFileEnd = 0;
															#line 2331 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		numSnapshots = deterministicRandom()->randomInt(1, 10);
															#line 2332 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 15133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 2379 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_4 = waitForAll(writes);
															#line 2379 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 5;
															#line 2379 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 15224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 2332 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(numSnapshots))
															#line 15240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2333 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		rangeFileNames = std::vector<std::string>();
															#line 2334 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginEndKeys = std::vector<std::pair<Key, Key>>();
															#line 2337 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		numRangeFiles = deterministicRandom()->randomInt(2, 5);
															#line 2338 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginVersion = v;
															#line 2339 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 15254 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
															#line 2349 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotEndVersion = logEnd;
															#line 2352 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes.push_back(c->writeKeyspaceSnapshotFile(rangeFileNames, snapshotBeginEndKeys, deterministicRandom()->randomInt(0, 2e6), IncludeKeyRangeMap(BUGGIFY)));
															#line 2359 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotsMissingLogs.push_back(lastMissedLogFileEnd > snapshotBeginVersion);
															#line 2362 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 15282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1(int loopDepth) 
	{
															#line 2339 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(numRangeFiles))
															#line 15298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont4loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2340 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IBackupFile>> __when_expr_2 = c->writeRangeFile(v, 0, v, blockSize);
															#line 2340 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 15306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1cont4loopBody1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 3;
															#line 2340 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 15311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont4loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 2341 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes.push_back(writeAndVerifyFile(c, range, deterministicRandom()->randomInt(0, 2e6), &lock));
															#line 2342 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		rangeFileNames.push_back(range->getFileName());
															#line 2343 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginEndKeys.push_back(beginEndKeys);
															#line 2345 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logEnd = v;
															#line 2346 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = nextVersion(v);
															#line 2347 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		--numRangeFiles;
															#line 15343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1when1(Reference<IBackupFile> const& __range,int loopDepth) 
	{
															#line 2340 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		range = __range;
															#line 15352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1when1(Reference<IBackupFile> && __range,int loopDepth) 
	{
		range = std::move(__range);
		loopDepth = a_body1cont4loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4loopBody1cont3(int loopDepth) 
	{
															#line 2376 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		--numSnapshots;
															#line 15431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 2362 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(logStart < logEnd))
															#line 15447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont4loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2363 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		tempLogEnd = nextVersion(logStart);
															#line 2364 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (deterministicRandom()->random01() < 0.5)
															#line 15455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 2365 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Reference<IBackupFile>> __when_expr_3 = c->writeLogFile(logStart, tempLogEnd, blockSize);
															#line 2365 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 15461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont4loopBody1cont1loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 4;
															#line 2365 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 15466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2369 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!(tempLogEnd < snapshotBeginVersion || snapshotEndVersion < logStart))
															#line 15473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 2370 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				snapshotsMissingLogs.back() = true;
															#line 15477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
															#line 2371 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			lastMissedLogFileEnd = tempLogEnd;
															#line 15481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = a_body1cont4loopBody1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont4loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2373 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logStart = tempLogEnd;
															#line 15504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1loopBody1cont3(int loopDepth) 
	{
															#line 2366 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes.push_back(writeAndVerifyFile(c, log, deterministicRandom()->randomInt(0, 2e6), &lock));
															#line 15513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1loopBody1when1(Reference<IBackupFile> const& __log,int loopDepth) 
	{
															#line 2365 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		log = __log;
															#line 15522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1loopBody1when1(Reference<IBackupFile> && __log,int loopDepth) 
	{
		log = std::move(__log);
		loopDepth = a_body1cont4loopBody1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 2380 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_5 = c->dumpFileList();
															#line 2380 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 6;
															#line 2380 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 15608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 2380 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_5 = c->dumpFileList();
															#line 2380 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 6;
															#line 2380 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 15624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 2381 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printFileList(listing);
															#line 2383 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("\n\nSnapshots missing logs:");
															#line 2384 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		i = 0;
															#line 2385 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for(;i < snapshotsMissingLogs.size();++i) {
															#line 2386 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			printf("\nSnapshot%d: %s", i, snapshotsMissingLogs[i] ? "true" : "false");
															#line 15716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 2388 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_6 = c->describeBackup();
															#line 2388 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 7;
															#line 2388 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 15727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(BackupFileList const& __listing,int loopDepth) 
	{
															#line 2380 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		listing = __listing;
															#line 15736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(BackupFileList && __listing,int loopDepth) 
	{
		listing = std::move(__listing);
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >*,BackupFileList const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >*,BackupFileList && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 2389 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("\n\n%s\n", desc.toString().c_str());
															#line 2391 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		i = 0;
															#line 15817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont8loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(BackupDescription const& __desc,int loopDepth) 
	{
															#line 2388 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc = __desc;
															#line 15826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(BackupDescription && __desc,int loopDepth) 
	{
		desc = std::move(__desc);
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 2400 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		for(i = snapshotsMissingLogs.size() - 1;i >= 0;--i) {
															#line 2401 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (!snapshotsMissingLogs[i])
															#line 15907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 2402 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				int j = i - 1;
															#line 2403 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				for(;j >= 0;--j) {
															#line 2404 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					if (snapshotsMissingLogs[j] || !BackupContainerFileSystemImpl::hasContinuousLogsForSnapshot( listing.logs, listing.snapshots[j].endVersion, listing.snapshots[j + 1].beginVersion))
															#line 15915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
					{
						break;
					}
				}
															#line 2409 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				ASSERT(desc.minRestorableVersion.get() == listing.snapshots[j + 1].endVersion);
															#line 2410 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				ASSERT(desc.maxRestorableVersion.get() >= listing.snapshots[i].endVersion);
															#line 2411 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (i + 1 < snapshotsMissingLogs.size())
															#line 15926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				{
															#line 2412 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
					ASSERT(desc.maxRestorableVersion.get() < listing.snapshots[i + 1].endVersion);
															#line 15930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				}
				break;
			}
		}
															#line 2417 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("DELETING\n");
															#line 2418 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_8 = c->deleteContainer();
															#line 2418 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 9;
															#line 2418 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 15946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont8loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1(int loopDepth) 
	{
															#line 2391 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(i < listing.snapshots.size()))
															#line 15962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont8break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2393 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Optional<RestorableFileSet>> __when_expr_7 = c->getRestoreSet(listing.snapshots[i].endVersion);
															#line 2393 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont8loopBody1when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 8;
															#line 2393 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 15975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8break1(int loopDepth) 
	{
		try {
			return a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8loopBody1cont1(Optional<RestorableFileSet> const& rest,int loopDepth) 
	{
															#line 2394 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (snapshotsMissingLogs[i])
															#line 15997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 2395 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!rest.present());
															#line 16001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
		else
		{
															#line 2397 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(rest.present());
															#line 16007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 2391 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++i;
															#line 16011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont8loopHead1(0);

		return loopDepth;
	}
	int a_body1cont8loopBody1cont1(Optional<RestorableFileSet> && rest,int loopDepth) 
	{
															#line 2394 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (snapshotsMissingLogs[i])
															#line 16020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
															#line 2395 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(!rest.present());
															#line 16024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
		else
		{
															#line 2397 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			ASSERT(rest.present());
															#line 16030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		}
															#line 2391 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++i;
															#line 16034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont8loopHead1(0);

		return loopDepth;
	}
	int a_body1cont8loopBody1when1(Optional<RestorableFileSet> const& rest,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody1cont1(rest, loopDepth);

		return loopDepth;
	}
	int a_body1cont8loopBody1when1(Optional<RestorableFileSet> && rest,int loopDepth) 
	{
		loopDepth = a_body1cont8loopBody1cont1(std::move(rest), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 2420 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		d = c->describeBackup();
															#line 2421 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_9 = ready(d);
															#line 2421 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 10;
															#line 2421 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 16127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 2420 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		d = c->describeBackup();
															#line 2421 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_9 = ready(d);
															#line 2421 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 10;
															#line 2421 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 16145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont7(Void const& _,int loopDepth) 
	{
															#line 2422 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(d.isError() && d.getError().code() == error_code_backup_does_not_exist);
															#line 2424 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_10 = c->dumpFileList();
															#line 2424 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont7when1(__when_expr_10.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 11;
															#line 2424 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 16238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont7(Void && _,int loopDepth) 
	{
															#line 2422 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT(d.isError() && d.getError().code() == error_code_backup_does_not_exist);
															#line 2424 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_10 = c->dumpFileList();
															#line 2424 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont7when1(__when_expr_10.get(), loopDepth); };
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 11;
															#line 2424 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >*>(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)));
															#line 16256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont8(BackupFileList const& empty,int loopDepth) 
	{
															#line 2425 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.ranges.size(), 0);
															#line 2426 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.logs.size(), 0);
															#line 2427 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.snapshots.size(), 0);
															#line 2429 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("BackupContainerTest URL=%s PASSED.\n", url.c_str());
															#line 2431 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestBackupContainerWithMissingLogRangesActorState(); static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->destroy(); return 0; }
															#line 16348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestBackupContainerWithMissingLogRangesActorState();
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont8(BackupFileList && empty,int loopDepth) 
	{
															#line 2425 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.ranges.size(), 0);
															#line 2426 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.logs.size(), 0);
															#line 2427 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(empty.snapshots.size(), 0);
															#line 2429 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("BackupContainerTest URL=%s PASSED.\n", url.c_str());
															#line 2431 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestBackupContainerWithMissingLogRangesActorState(); static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->destroy(); return 0; }
															#line 16368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestBackupContainerWithMissingLogRangesActorState();
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont7when1(BackupFileList const& empty,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(empty, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont7when1(BackupFileList && empty,int loopDepth) 
	{
		loopDepth = a_body1cont10cont8(std::move(empty), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >*,BackupFileList const& value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >*,BackupFileList && value) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), 10);

	}
															#line 2302 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string url;
															#line 2302 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<std::string> proxy;
															#line 2303 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowLock lock;
															#line 2306 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupContainer> c;
															#line 2316 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key begin;
															#line 2317 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key end;
															#line 2318 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int blockSize;
															#line 2319 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<Future<Void>> writes;
															#line 2320 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::pair<Key, Key> beginEndKeys;
															#line 2321 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<bool> snapshotsMissingLogs;
															#line 2322 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version v;
															#line 2323 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version tempLogEnd;
															#line 2324 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version logStart;
															#line 2325 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version logEnd;
															#line 2326 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version snapshotBeginVersion;
															#line 2327 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version snapshotEndVersion;
															#line 2328 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version lastMissedLogFileEnd;
															#line 2331 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int numSnapshots;
															#line 2333 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<std::string> rangeFileNames;
															#line 2334 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<std::pair<Key, Key>> snapshotBeginEndKeys;
															#line 2337 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int numRangeFiles;
															#line 2340 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> range;
															#line 2365 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> log;
															#line 2380 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupFileList listing;
															#line 2384 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int i;
															#line 2388 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupDescription desc;
															#line 2420 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Future<BackupDescription> d;
															#line 16505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via testBackupContainerWithMissingLogRanges()
															#line 2302 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class TestBackupContainerWithMissingLogRangesActor final : public Actor<Void>, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >, public ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >, public FastAllocated<TestBackupContainerWithMissingLogRangesActor>, public TestBackupContainerWithMissingLogRangesActorState<TestBackupContainerWithMissingLogRangesActor> {
															#line 16510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<TestBackupContainerWithMissingLogRangesActor>::operator new;
	using FastAllocated<TestBackupContainerWithMissingLogRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10974888835960000768UL, 10632013519134969856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >;
friend struct ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >;
															#line 2302 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	TestBackupContainerWithMissingLogRangesActor(std::string const& url,Optional<std::string> const& proxy) 
															#line 16537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   TestBackupContainerWithMissingLogRangesActorState<TestBackupContainerWithMissingLogRangesActor>(url, proxy),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12217765069977313536UL, 13268377201974446080UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContainerWithMissingLogRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testBackupContainerWithMissingLogRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testBackupContainerWithMissingLogRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 2, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 3, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 5, BackupFileList >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 6, BackupDescription >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 7, Optional<RestorableFileSet> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< TestBackupContainerWithMissingLogRangesActor, 10, BackupFileList >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2302 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] Future<Void> testBackupContainerWithMissingLogRanges( std::string const& url, Optional<std::string> const& proxy ) {
															#line 2302 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new TestBackupContainerWithMissingLogRangesActor(url, proxy));
															#line 16579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 2433 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 16584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via flowTestCase2434()
															#line 2434 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2434Actor>
															#line 2434 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2434ActorState {
															#line 16590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 2434 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2434ActorState(UnitTestParameters const& params) 
															#line 2434 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2434 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 16597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase2434", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2434ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2434", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2435 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testBackupContainerWithMissingLogRanges( format("file://%s/fdb_backups/%llx", params.getDataDir().c_str(), timer_int()), {});
															#line 2435 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<FlowTestCase2434Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase2434Actor*>(this)->actor_wait_state = 1;
															#line 2435 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase2434Actor, 0, Void >*>(static_cast<FlowTestCase2434Actor*>(this)));
															#line 16619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2434ActorState();
		static_cast<FlowTestCase2434Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2437 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2434Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2434ActorState(); static_cast<FlowTestCase2434Actor*>(this)->destroy(); return 0; }
															#line 16642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<FlowTestCase2434Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2434ActorState();
		static_cast<FlowTestCase2434Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2437 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2434Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2434ActorState(); static_cast<FlowTestCase2434Actor*>(this)->destroy(); return 0; }
															#line 16654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<FlowTestCase2434Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2434ActorState();
		static_cast<FlowTestCase2434Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase2434Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase2434Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase2434Actor*>(this)->ActorCallback< FlowTestCase2434Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase2434Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase2434", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2434Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2434", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase2434Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase2434", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2434Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2434", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase2434Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase2434", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2434Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2434", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2434 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 16739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase2434()
															#line 2434 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2434Actor final : public Actor<Void>, public ActorCallback< FlowTestCase2434Actor, 0, Void >, public FastAllocated<FlowTestCase2434Actor>, public FlowTestCase2434ActorState<FlowTestCase2434Actor> {
															#line 16744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase2434Actor>::operator new;
	using FastAllocated<FlowTestCase2434Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5907460143898818048UL, 12730555835251919616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase2434Actor, 0, Void >;
															#line 2434 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2434Actor(UnitTestParameters const& params) 
															#line 16761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase2434ActorState<FlowTestCase2434Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2434", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9640348673461838592UL, 15618399057742510080UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2434Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2434");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2434", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase2434Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2434 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2434( UnitTestParameters const& params ) {
															#line 2434 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2434Actor(params));
															#line 16793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase2434, "/backup/containers/localdir/missingLogRangesRestorability")

#line 2439 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 16799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via testBackupContinuousLogEndVer()
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class TestBackupContinuousLogEndVerActor>
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class TestBackupContinuousLogEndVerActorState {
															#line 16805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	TestBackupContinuousLogEndVerActorState(std::string const& url,Optional<std::string> const& proxy) 
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : url(url),
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   proxy(proxy),
															#line 2441 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		   lock(100e6)
															#line 16816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this));

	}
	~TestBackupContinuousLogEndVerActorState() 
	{
		fdb_probe_actor_destroy("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2442 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			printf("BackupContainerTest URL %s\n", url.c_str());
															#line 2443 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			c = IBackupContainer::openContainer(url, proxy, {});
															#line 16833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			try {
															#line 2447 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				StrictFuture<Void> __when_expr_0 = c->deleteContainer();
															#line 2447 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 1;
															#line 2447 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestBackupContinuousLogEndVerActor, 0, Void >*>(static_cast<TestBackupContinuousLogEndVerActor*>(this)));
															#line 16844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestBackupContinuousLogEndVerActorState();
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2453 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = c->create();
															#line 2453 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 2;
															#line 2453 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestBackupContinuousLogEndVerActor, 1, Void >*>(static_cast<TestBackupContinuousLogEndVerActor*>(this)));
															#line 16880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2449 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (e.code() != error_code_backup_invalid_url && e.code() != error_code_backup_does_not_exist)
															#line 16890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			{
															#line 2450 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 16894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->ActorCallback< TestBackupContinuousLogEndVerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestBackupContinuousLogEndVerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 2455 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		blockSize = 1024;
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		rangeFileNames = std::vector<std::string>();
															#line 2457 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		begin = randomKeyBetween(normalKeys);
															#line 2458 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		end = randomKeyBetween(KeyRangeRef(begin, normalKeys.end));
															#line 2459 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		beginEndKeys = std::make_pair(begin, end);
															#line 2460 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginEndKeys = std::vector<std::pair<Key, Key>>();
															#line 2463 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes = std::vector<Future<Void>>();
															#line 2464 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginVersion = 10;
															#line 2465 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotEndVersion = deterministicRandom()->randomInt(500, 1000);
															#line 2466 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		rangeSize = 100;
															#line 2467 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = snapshotBeginVersion;
															#line 2468 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		numRangeFiles = 0;
															#line 2469 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 17034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 2455 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		blockSize = 1024;
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		rangeFileNames = std::vector<std::string>();
															#line 2457 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		begin = randomKeyBetween(normalKeys);
															#line 2458 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		end = randomKeyBetween(KeyRangeRef(begin, normalKeys.end));
															#line 2459 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		beginEndKeys = std::make_pair(begin, end);
															#line 2460 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginEndKeys = std::vector<std::pair<Key, Key>>();
															#line 2463 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes = std::vector<Future<Void>>();
															#line 2464 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginVersion = 10;
															#line 2465 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotEndVersion = deterministicRandom()->randomInt(500, 1000);
															#line 2466 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		rangeSize = 100;
															#line 2467 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = snapshotBeginVersion;
															#line 2468 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		numRangeFiles = 0;
															#line 2469 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 17067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->ActorCallback< TestBackupContinuousLogEndVerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestBackupContinuousLogEndVerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 2477 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotEndVersion = v - rangeSize;
															#line 2480 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		logSize = 70;
															#line 2481 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v = snapshotBeginVersion;
															#line 2482 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		numLogFiles = 0;
															#line 2483 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 17159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 2469 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(v <= snapshotEndVersion))
															#line 17175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2470 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IBackupFile>> __when_expr_2 = c->writeRangeFile(v, 0, v, blockSize);
															#line 2470 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 3;
															#line 2470 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestBackupContinuousLogEndVerActor, 2, Reference<IBackupFile> >*>(static_cast<TestBackupContinuousLogEndVerActor*>(this)));
															#line 17188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
															#line 2471 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes.push_back(writeAndVerifyFile(c, range, 100, &lock));
															#line 2472 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		rangeFileNames.push_back(range->getFileName());
															#line 2473 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		snapshotBeginEndKeys.push_back(beginEndKeys);
															#line 2474 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v += rangeSize;
															#line 2475 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++numRangeFiles;
															#line 17218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Reference<IBackupFile> const& __range,int loopDepth) 
	{
															#line 2470 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		range = __range;
															#line 17227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Reference<IBackupFile> && __range,int loopDepth) 
	{
		range = std::move(__range);
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->ActorCallback< TestBackupContinuousLogEndVerActor, 2, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 2, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 2, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestBackupContinuousLogEndVerActor, 2, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 2491 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes.push_back(c->writeKeyspaceSnapshotFile( rangeFileNames, snapshotBeginEndKeys, deterministicRandom()->randomInt(0, 2e6), IncludeKeyRangeMap(BUGGIFY)));
															#line 2493 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_4 = waitForAll(writes);
															#line 2493 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 5;
															#line 2493 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestBackupContinuousLogEndVerActor, 4, Void >*>(static_cast<TestBackupContinuousLogEndVerActor*>(this)));
															#line 17315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1(int loopDepth) 
	{
															#line 2483 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(v <= snapshotEndVersion))
															#line 17331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2484 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IBackupFile>> __when_expr_3 = c->writeLogFile(v, v + logSize, blockSize);
															#line 2484 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 4;
															#line 2484 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestBackupContinuousLogEndVerActor, 3, Reference<IBackupFile> >*>(static_cast<TestBackupContinuousLogEndVerActor*>(this)));
															#line 17344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5break1(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1(Reference<IBackupFile> const& log,int loopDepth) 
	{
															#line 2485 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes.push_back(writeAndVerifyFile(c, log, 100, &lock));
															#line 2486 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++numLogFiles;
															#line 2487 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v += logSize;
															#line 17370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1(Reference<IBackupFile> && log,int loopDepth) 
	{
															#line 2485 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes.push_back(writeAndVerifyFile(c, log, 100, &lock));
															#line 2486 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		++numLogFiles;
															#line 2487 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v += logSize;
															#line 17383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(Reference<IBackupFile> const& log,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(log, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(Reference<IBackupFile> && log,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(std::move(log), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->ActorCallback< TestBackupContinuousLogEndVerActor, 3, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 3, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 3, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestBackupContinuousLogEndVerActor, 3, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 2495 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_5 = c->dumpFileList();
															#line 2495 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 6;
															#line 2495 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestBackupContinuousLogEndVerActor, 5, BackupFileList >*>(static_cast<TestBackupContinuousLogEndVerActor*>(this)));
															#line 17474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 2495 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_5 = c->dumpFileList();
															#line 2495 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 6;
															#line 2495 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestBackupContinuousLogEndVerActor, 5, BackupFileList >*>(static_cast<TestBackupContinuousLogEndVerActor*>(this)));
															#line 17490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->ActorCallback< TestBackupContinuousLogEndVerActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestBackupContinuousLogEndVerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 2496 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printFileList(fileList);
															#line 2497 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(fileList.ranges.size(), numRangeFiles);
															#line 2498 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(fileList.logs.size(), numLogFiles);
															#line 2499 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(fileList.snapshots.size(), 1);
															#line 2501 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_6 = c->describeBackup();
															#line 2501 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 7;
															#line 2501 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestBackupContinuousLogEndVerActor, 6, BackupDescription >*>(static_cast<TestBackupContinuousLogEndVerActor*>(this)));
															#line 17589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(BackupFileList const& __fileList,int loopDepth) 
	{
															#line 2495 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		fileList = __fileList;
															#line 17598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(BackupFileList && __fileList,int loopDepth) 
	{
		fileList = std::move(__fileList);
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->ActorCallback< TestBackupContinuousLogEndVerActor, 5, BackupFileList >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 5, BackupFileList >*,BackupFileList const& value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 5, BackupFileList >*,BackupFileList && value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestBackupContinuousLogEndVerActor, 5, BackupFileList >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 2502 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("\n%s\n", desc.toString().c_str());
															#line 2503 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(desc.minLogBegin, snapshotBeginVersion);
															#line 2504 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(desc.maxLogEnd, v);
															#line 2505 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(desc.minRestorableVersion, snapshotEndVersion);
															#line 2506 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(desc.maxRestorableVersion, v - 1);
															#line 2507 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(desc.snapshots[0].restorable, true);
															#line 2508 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(desc.contiguousLogEnd, v);
															#line 2511 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		newNumLogFiles = deterministicRandom()->randomInt(2, 8);
															#line 2512 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		numLogFiles += newNumLogFiles;
															#line 2513 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes.clear();
															#line 2514 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		;
															#line 17697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont9loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(BackupDescription const& __desc,int loopDepth) 
	{
															#line 2501 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc = __desc;
															#line 17706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(BackupDescription && __desc,int loopDepth) 
	{
		desc = std::move(__desc);
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->ActorCallback< TestBackupContinuousLogEndVerActor, 6, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 6, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 6, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TestBackupContinuousLogEndVerActor, 6, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 2520 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Void> __when_expr_8 = waitForAll(writes);
															#line 2520 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10when1(__when_expr_8.get(), loopDepth); };
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 9;
															#line 2520 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< TestBackupContinuousLogEndVerActor, 8, Void >*>(static_cast<TestBackupContinuousLogEndVerActor*>(this)));
															#line 17792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont9loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1(int loopDepth) 
	{
															#line 2514 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!(newNumLogFiles))
															#line 17808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		{
			return a_body1cont9break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2515 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<Reference<IBackupFile>> __when_expr_7 = c->writeLogFile(v, v + logSize, blockSize);
															#line 2515 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont9loopBody1when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 8;
															#line 2515 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestBackupContinuousLogEndVerActor, 7, Reference<IBackupFile> >*>(static_cast<TestBackupContinuousLogEndVerActor*>(this)));
															#line 17821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9break1(int loopDepth) 
	{
		try {
			return a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9loopBody1cont1(Reference<IBackupFile> const& log,int loopDepth) 
	{
															#line 2516 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes.push_back(writeAndVerifyFile(c, log, 100, &lock));
															#line 2517 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		--newNumLogFiles;
															#line 2518 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v += logSize;
															#line 17847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont9loopHead1(0);

		return loopDepth;
	}
	int a_body1cont9loopBody1cont1(Reference<IBackupFile> && log,int loopDepth) 
	{
															#line 2516 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		writes.push_back(writeAndVerifyFile(c, log, 100, &lock));
															#line 2517 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		--newNumLogFiles;
															#line 2518 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		v += logSize;
															#line 17860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont9loopHead1(0);

		return loopDepth;
	}
	int a_body1cont9loopBody1when1(Reference<IBackupFile> const& log,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont1(log, loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1when1(Reference<IBackupFile> && log,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont1(std::move(log), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->ActorCallback< TestBackupContinuousLogEndVerActor, 7, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 7, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 7, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< TestBackupContinuousLogEndVerActor, 7, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 2522 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_9 = c->dumpFileList();
															#line 2522 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 10;
															#line 2522 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< TestBackupContinuousLogEndVerActor, 9, BackupFileList >*>(static_cast<TestBackupContinuousLogEndVerActor*>(this)));
															#line 17951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 2522 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_9 = c->dumpFileList();
															#line 2522 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 10;
															#line 2522 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< TestBackupContinuousLogEndVerActor, 9, BackupFileList >*>(static_cast<TestBackupContinuousLogEndVerActor*>(this)));
															#line 17967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->ActorCallback< TestBackupContinuousLogEndVerActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< TestBackupContinuousLogEndVerActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont2(int loopDepth) 
	{
															#line 2523 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printFileList(fileList1);
															#line 2524 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(fileList1.ranges.size(), numRangeFiles);
															#line 2525 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(fileList1.logs.size(), numLogFiles);
															#line 2526 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(fileList1.snapshots.size(), 1);
															#line 2528 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_10 = c->describeBackup();
															#line 2528 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_10.get(), loopDepth); };
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 11;
															#line 2528 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< TestBackupContinuousLogEndVerActor, 10, BackupDescription >*>(static_cast<TestBackupContinuousLogEndVerActor*>(this)));
															#line 18066 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(BackupFileList const& __fileList1,int loopDepth) 
	{
															#line 2522 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		fileList1 = __fileList1;
															#line 18075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(BackupFileList && __fileList1,int loopDepth) 
	{
		fileList1 = std::move(__fileList1);
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->ActorCallback< TestBackupContinuousLogEndVerActor, 9, BackupFileList >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 9, BackupFileList >*,BackupFileList const& value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 9, BackupFileList >*,BackupFileList && value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< TestBackupContinuousLogEndVerActor, 9, BackupFileList >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont3(int loopDepth) 
	{
															#line 2529 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		printf("\n%s\n", desc1.toString().c_str());
															#line 2530 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(desc1.minLogBegin, snapshotBeginVersion);
															#line 2531 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(desc1.maxLogEnd, v);
															#line 2532 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(desc1.minRestorableVersion, snapshotEndVersion);
															#line 2533 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(desc1.maxRestorableVersion, v - 1);
															#line 2534 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(desc1.snapshots[0].restorable, true);
															#line 2535 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		ASSERT_EQ(desc1.contiguousLogEnd, v);
															#line 2537 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<TestBackupContinuousLogEndVerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestBackupContinuousLogEndVerActorState(); static_cast<TestBackupContinuousLogEndVerActor*>(this)->destroy(); return 0; }
															#line 18168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<TestBackupContinuousLogEndVerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestBackupContinuousLogEndVerActorState();
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont2when1(BackupDescription const& __desc1,int loopDepth) 
	{
															#line 2528 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		desc1 = __desc1;
															#line 18180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2when1(BackupDescription && __desc1,int loopDepth) 
	{
		desc1 = std::move(__desc1);
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state > 0) static_cast<TestBackupContinuousLogEndVerActor*>(this)->actor_wait_state = 0;
		static_cast<TestBackupContinuousLogEndVerActor*>(this)->ActorCallback< TestBackupContinuousLogEndVerActor, 10, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 10, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< TestBackupContinuousLogEndVerActor, 10, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< TestBackupContinuousLogEndVerActor, 10, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), 10);

	}
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::string url;
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Optional<std::string> proxy;
															#line 2441 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowLock lock;
															#line 2443 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupContainer> c;
															#line 2455 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int blockSize;
															#line 2456 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<std::string> rangeFileNames;
															#line 2457 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key begin;
															#line 2458 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Key end;
															#line 2459 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::pair<Key, Key> beginEndKeys;
															#line 2460 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<std::pair<Key, Key>> snapshotBeginEndKeys;
															#line 2463 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	std::vector<Future<Void>> writes;
															#line 2464 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version snapshotBeginVersion;
															#line 2465 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version snapshotEndVersion;
															#line 2466 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version rangeSize;
															#line 2467 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version v;
															#line 2468 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int numRangeFiles;
															#line 2470 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Reference<IBackupFile> range;
															#line 2480 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	Version logSize;
															#line 2482 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int numLogFiles;
															#line 2495 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupFileList fileList;
															#line 2501 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupDescription desc;
															#line 2511 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	int newNumLogFiles;
															#line 2522 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupFileList fileList1;
															#line 2528 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	BackupDescription desc1;
															#line 18303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via testBackupContinuousLogEndVer()
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class TestBackupContinuousLogEndVerActor final : public Actor<Void>, public ActorCallback< TestBackupContinuousLogEndVerActor, 0, Void >, public ActorCallback< TestBackupContinuousLogEndVerActor, 1, Void >, public ActorCallback< TestBackupContinuousLogEndVerActor, 2, Reference<IBackupFile> >, public ActorCallback< TestBackupContinuousLogEndVerActor, 3, Reference<IBackupFile> >, public ActorCallback< TestBackupContinuousLogEndVerActor, 4, Void >, public ActorCallback< TestBackupContinuousLogEndVerActor, 5, BackupFileList >, public ActorCallback< TestBackupContinuousLogEndVerActor, 6, BackupDescription >, public ActorCallback< TestBackupContinuousLogEndVerActor, 7, Reference<IBackupFile> >, public ActorCallback< TestBackupContinuousLogEndVerActor, 8, Void >, public ActorCallback< TestBackupContinuousLogEndVerActor, 9, BackupFileList >, public ActorCallback< TestBackupContinuousLogEndVerActor, 10, BackupDescription >, public FastAllocated<TestBackupContinuousLogEndVerActor>, public TestBackupContinuousLogEndVerActorState<TestBackupContinuousLogEndVerActor> {
															#line 18308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<TestBackupContinuousLogEndVerActor>::operator new;
	using FastAllocated<TestBackupContinuousLogEndVerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4272987399140815616UL, 13846121179193457152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestBackupContinuousLogEndVerActor, 0, Void >;
friend struct ActorCallback< TestBackupContinuousLogEndVerActor, 1, Void >;
friend struct ActorCallback< TestBackupContinuousLogEndVerActor, 2, Reference<IBackupFile> >;
friend struct ActorCallback< TestBackupContinuousLogEndVerActor, 3, Reference<IBackupFile> >;
friend struct ActorCallback< TestBackupContinuousLogEndVerActor, 4, Void >;
friend struct ActorCallback< TestBackupContinuousLogEndVerActor, 5, BackupFileList >;
friend struct ActorCallback< TestBackupContinuousLogEndVerActor, 6, BackupDescription >;
friend struct ActorCallback< TestBackupContinuousLogEndVerActor, 7, Reference<IBackupFile> >;
friend struct ActorCallback< TestBackupContinuousLogEndVerActor, 8, Void >;
friend struct ActorCallback< TestBackupContinuousLogEndVerActor, 9, BackupFileList >;
friend struct ActorCallback< TestBackupContinuousLogEndVerActor, 10, BackupDescription >;
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	TestBackupContinuousLogEndVerActor(std::string const& url,Optional<std::string> const& proxy) 
															#line 18335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   TestBackupContinuousLogEndVerActorState<TestBackupContinuousLogEndVerActor>(url, proxy),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16372233049803320320UL, 17951973849680216320UL);
		ActorExecutionContextHelper __helper(static_cast<TestBackupContinuousLogEndVerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testBackupContinuousLogEndVer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testBackupContinuousLogEndVer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestBackupContinuousLogEndVerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestBackupContinuousLogEndVerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestBackupContinuousLogEndVerActor, 2, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestBackupContinuousLogEndVerActor, 3, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestBackupContinuousLogEndVerActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestBackupContinuousLogEndVerActor, 5, BackupFileList >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TestBackupContinuousLogEndVerActor, 6, BackupDescription >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< TestBackupContinuousLogEndVerActor, 7, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< TestBackupContinuousLogEndVerActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< TestBackupContinuousLogEndVerActor, 9, BackupFileList >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< TestBackupContinuousLogEndVerActor, 10, BackupDescription >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
[[nodiscard]] Future<Void> testBackupContinuousLogEndVer( std::string const& url, Optional<std::string> const& proxy ) {
															#line 2440 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new TestBackupContinuousLogEndVerActor(url, proxy));
															#line 18377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}

#line 2539 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

															#line 18382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
// This generated class is to be used only via flowTestCase2540()
															#line 2540 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
template <class FlowTestCase2540Actor>
															#line 2540 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2540ActorState {
															#line 18388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
															#line 2540 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2540ActorState(UnitTestParameters const& params) 
															#line 2540 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
															#line 2540 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		 : params(params)
															#line 18395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase2540", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2540ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2540", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2541 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testBackupContinuousLogEndVer(format("file://%s/fdb_backups/%llx", params.getDataDir().c_str(), timer_int()), {});
															#line 2541 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			if (static_cast<FlowTestCase2540Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase2540Actor*>(this)->actor_wait_state = 1;
															#line 2541 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase2540Actor, 0, Void >*>(static_cast<FlowTestCase2540Actor*>(this)));
															#line 18417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2540ActorState();
		static_cast<FlowTestCase2540Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2543 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2540Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2540ActorState(); static_cast<FlowTestCase2540Actor*>(this)->destroy(); return 0; }
															#line 18440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<FlowTestCase2540Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2540ActorState();
		static_cast<FlowTestCase2540Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2543 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
		if (!static_cast<FlowTestCase2540Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2540ActorState(); static_cast<FlowTestCase2540Actor*>(this)->destroy(); return 0; }
															#line 18452 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		new (&static_cast<FlowTestCase2540Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2540ActorState();
		static_cast<FlowTestCase2540Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase2540Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase2540Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase2540Actor*>(this)->ActorCallback< FlowTestCase2540Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase2540Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase2540", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2540Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2540", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase2540Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase2540", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2540Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2540", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase2540Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase2540", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2540Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2540", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2540 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	UnitTestParameters params;
															#line 18537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase2540()
															#line 2540 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
class FlowTestCase2540Actor final : public Actor<Void>, public ActorCallback< FlowTestCase2540Actor, 0, Void >, public FastAllocated<FlowTestCase2540Actor>, public FlowTestCase2540ActorState<FlowTestCase2540Actor> {
															#line 18542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase2540Actor>::operator new;
	using FastAllocated<FlowTestCase2540Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10633779885268262144UL, 10417877180316081920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase2540Actor, 0, Void >;
															#line 2540 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	FlowTestCase2540Actor(UnitTestParameters const& params) 
															#line 18559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase2540ActorState<FlowTestCase2540Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2540", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13080435985420846336UL, 15111784351849761280UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2540Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2540");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2540", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase2540Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2540 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
static Future<Void> flowTestCase2540( UnitTestParameters const& params ) {
															#line 2540 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"
	return Future<Void>(new FlowTestCase2540Actor(params));
															#line 18591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbclient/BackupContainerFileSystem.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase2540, "/backup/containers/localdir/continuousLogEndVersion")

#line 2545 "/Users/ec2-user/foundationdb/fdbclient/BackupContainerFileSystem.actor.cpp"

} // namespace backup_test
