#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
/*
 * QuotaCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/TagThrottle.actor.h"
#include "flow/actorcompiler.h" // This must be the last include

namespace {

enum class QuotaType { RESERVED, TOTAL, STORAGE };

Optional<TransactionTag> parseTag(StringRef token) {
	if (token.size() > CLIENT_KNOBS->MAX_TRANSACTION_TAG_LENGTH) {
		return {};
	} else {
		return token;
	}
}

Optional<QuotaType> parseQuotaType(StringRef token) {
	if (token == "reserved_throughput"_sr) {
		return QuotaType::RESERVED;
	} else if (token == "total_throughput"_sr) {
		return QuotaType::TOTAL;
	} else if (token == "storage"_sr) {
		return QuotaType::STORAGE;
	} else {
		return {};
	}
}

Optional<int64_t> parseQuotaValue(StringRef token) {
	try {
		return std::stol(token.toString());
	} catch (...) {
		return {};
	}
}

															#line 61 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
// This generated class is to be used only via getQuota()
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
template <class GetQuotaActor>
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
class GetQuotaActorState {
															#line 67 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
public:
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	GetQuotaActorState(Reference<IDatabase> const& db,TransactionTag const& tag,QuotaType const& quotaType) 
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		 : db(db),
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		   tag(tag),
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		   quotaType(quotaType),
															#line 60 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 80 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("getQuota", reinterpret_cast<unsigned long>(this));

	}
	~GetQuotaActorState() 
	{
		fdb_probe_actor_destroy("getQuota", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 61 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			;
															#line 95 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetQuotaActorState();
		static_cast<GetQuotaActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		try {
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			if (quotaType == QuotaType::STORAGE)
															#line 129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			{
															#line 65 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				StrictFuture<Optional<int64_t>> __when_expr_0 = TenantMetadata::storageQuota().get(tr, tag);
															#line 65 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				if (static_cast<GetQuotaActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetQuotaActor*>(this)->actor_wait_state = 1;
															#line 65 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetQuotaActor, 0, Optional<int64_t> >*>(static_cast<GetQuotaActor*>(this)));
															#line 140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 72 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				resultFuture = tr->get(ThrottleApi::getTagQuotaKey(tag));
															#line 73 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_1 = safeThreadFutureToFuture(resultFuture);
															#line 73 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				if (static_cast<GetQuotaActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<GetQuotaActor*>(this)->actor_wait_state = 2;
															#line 73 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetQuotaActor, 1, Optional<Value> >*>(static_cast<GetQuotaActor*>(this)));
															#line 156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 87 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 87 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			if (static_cast<GetQuotaActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetQuotaActor*>(this)->actor_wait_state = 3;
															#line 87 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetQuotaActor, 2, Void >*>(static_cast<GetQuotaActor*>(this)));
															#line 186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 85 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (!static_cast<GetQuotaActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetQuotaActorState(); static_cast<GetQuotaActor*>(this)->destroy(); return 0; }
															#line 201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		new (&static_cast<GetQuotaActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetQuotaActorState();
		static_cast<GetQuotaActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<int64_t> const& value,int loopDepth) 
	{
															#line 66 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (value.present())
															#line 213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		{
															#line 67 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			fmt::print("{}\n", value.get());
															#line 217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		}
		else
		{
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			fmt::print("<empty>\n");
															#line 223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<int64_t> && value,int loopDepth) 
	{
															#line 66 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (value.present())
															#line 233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		{
															#line 67 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			fmt::print("{}\n", value.get());
															#line 237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		}
		else
		{
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			fmt::print("<empty>\n");
															#line 243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<int64_t> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<int64_t> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetQuotaActor*>(this)->actor_wait_state > 0) static_cast<GetQuotaActor*>(this)->actor_wait_state = 0;
		static_cast<GetQuotaActor*>(this)->ActorCallback< GetQuotaActor, 0, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< GetQuotaActor, 0, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("getQuota", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getQuota", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetQuotaActor, 0, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("getQuota", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getQuota", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetQuotaActor, 0, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("getQuota", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getQuota", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont7(Optional<Value> const& v,int loopDepth) 
	{
															#line 74 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		Optional<ThrottleApi::TagQuotaValue> quota = v.map([](Value val) { return ThrottleApi::TagQuotaValue::fromValue(val); });
															#line 77 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (!quota.present())
															#line 330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		{
															#line 78 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			fmt::print("<empty>\n");
															#line 334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		}
		else
		{
															#line 79 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			if (quotaType == QuotaType::TOTAL)
															#line 340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			{
															#line 80 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				fmt::print("{}\n", quota.get().totalQuota);
															#line 344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			}
			else
			{
															#line 81 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				if (quotaType == QuotaType::RESERVED)
															#line 350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
				{
															#line 82 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
					fmt::print("{}\n", quota.get().reservedQuota);
															#line 354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
				}
			}
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Optional<Value> && v,int loopDepth) 
	{
															#line 74 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		Optional<ThrottleApi::TagQuotaValue> quota = v.map([](Value val) { return ThrottleApi::TagQuotaValue::fromValue(val); });
															#line 77 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (!quota.present())
															#line 368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		{
															#line 78 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			fmt::print("<empty>\n");
															#line 372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		}
		else
		{
															#line 79 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			if (quotaType == QuotaType::TOTAL)
															#line 378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			{
															#line 80 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				fmt::print("{}\n", quota.get().totalQuota);
															#line 382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			}
			else
			{
															#line 81 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				if (quotaType == QuotaType::RESERVED)
															#line 388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
				{
															#line 82 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
					fmt::print("{}\n", quota.get().reservedQuota);
															#line 392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
				}
			}
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetQuotaActor*>(this)->actor_wait_state > 0) static_cast<GetQuotaActor*>(this)->actor_wait_state = 0;
		static_cast<GetQuotaActor*>(this)->ActorCallback< GetQuotaActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetQuotaActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getQuota", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getQuota", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetQuotaActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getQuota", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getQuota", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetQuotaActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getQuota", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getQuota", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetQuotaActor*>(this)->actor_wait_state > 0) static_cast<GetQuotaActor*>(this)->actor_wait_state = 0;
		static_cast<GetQuotaActor*>(this)->ActorCallback< GetQuotaActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetQuotaActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getQuota", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getQuota", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetQuotaActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getQuota", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getQuota", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetQuotaActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getQuota", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getQuota", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	TransactionTag tag;
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	QuotaType quotaType;
															#line 60 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 72 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	ThreadFuture<Optional<Value>> resultFuture;
															#line 572 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
};
// This generated class is to be used only via getQuota()
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
class GetQuotaActor final : public Actor<Void>, public ActorCallback< GetQuotaActor, 0, Optional<int64_t> >, public ActorCallback< GetQuotaActor, 1, Optional<Value> >, public ActorCallback< GetQuotaActor, 2, Void >, public FastAllocated<GetQuotaActor>, public GetQuotaActorState<GetQuotaActor> {
															#line 577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
public:
	using FastAllocated<GetQuotaActor>::operator new;
	using FastAllocated<GetQuotaActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11064537874788025856UL, 12515952139516766464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetQuotaActor, 0, Optional<int64_t> >;
friend struct ActorCallback< GetQuotaActor, 1, Optional<Value> >;
friend struct ActorCallback< GetQuotaActor, 2, Void >;
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	GetQuotaActor(Reference<IDatabase> const& db,TransactionTag const& tag,QuotaType const& quotaType) 
															#line 596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		 : Actor<Void>(),
		   GetQuotaActorState<GetQuotaActor>(db, tag, quotaType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getQuota", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4123330058291780608UL, 11212127160798344960UL);
		ActorExecutionContextHelper __helper(static_cast<GetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getQuota");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getQuota", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetQuotaActor, 0, Optional<int64_t> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetQuotaActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetQuotaActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
[[nodiscard]] Future<Void> getQuota( Reference<IDatabase> const& db, TransactionTag const& tag, QuotaType const& quotaType ) {
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	return Future<Void>(new GetQuotaActor(db, tag, quotaType));
															#line 630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
}

#line 91 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"

															#line 635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
// This generated class is to be used only via setQuota()
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
template <class SetQuotaActor>
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
class SetQuotaActorState {
															#line 641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
public:
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	SetQuotaActorState(Reference<IDatabase> const& db,TransactionTag const& tag,QuotaType const& quotaType,int64_t const& value) 
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		 : db(db),
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		   tag(tag),
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		   quotaType(quotaType),
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		   value(value),
															#line 93 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("setQuota", reinterpret_cast<unsigned long>(this));

	}
	~SetQuotaActorState() 
	{
		fdb_probe_actor_destroy("setQuota", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 94 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			;
															#line 671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetQuotaActorState();
		static_cast<SetQuotaActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 95 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		try {
															#line 97 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			if (quotaType == QuotaType::STORAGE)
															#line 705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			{
															#line 98 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				TenantMetadata::storageQuota().set(tr, tag, value);
															#line 709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
			else
			{
															#line 100 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				resultFuture = tr->get(ThrottleApi::getTagQuotaKey(tag));
															#line 101 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_0 = safeThreadFutureToFuture(resultFuture);
															#line 101 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				if (static_cast<SetQuotaActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SetQuotaActor*>(this)->actor_wait_state = 1;
															#line 101 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetQuotaActor, 0, Optional<Value> >*>(static_cast<SetQuotaActor*>(this)));
															#line 725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 126 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 126 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			if (static_cast<SetQuotaActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SetQuotaActor*>(this)->actor_wait_state = 3;
															#line 126 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SetQuotaActor, 2, Void >*>(static_cast<SetQuotaActor*>(this)));
															#line 755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 122 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 122 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (static_cast<SetQuotaActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetQuotaActor*>(this)->actor_wait_state = 2;
															#line 122 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetQuotaActor, 1, Void >*>(static_cast<SetQuotaActor*>(this)));
															#line 777 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Optional<Value> const& v,int loopDepth) 
	{
															#line 102 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		ThrottleApi::TagQuotaValue quota;
															#line 103 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (v.present())
															#line 788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		{
															#line 104 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			quota = ThrottleApi::TagQuotaValue::fromValue(v.get());
															#line 792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		}
															#line 108 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (quotaType == QuotaType::TOTAL)
															#line 796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		{
															#line 110 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			quota.totalQuota = ((value - 1) / CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE + 1) * CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE;
															#line 800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		}
		else
		{
															#line 112 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			if (quotaType == QuotaType::RESERVED)
															#line 806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			{
															#line 114 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				quota.reservedQuota = ((value - 1) / CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE + 1) * CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE;
															#line 810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			}
		}
															#line 117 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (!quota.isValid())
															#line 815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		{
															#line 118 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			return a_body1loopBody1Catch1(invalid_throttle_quota_value(), loopDepth);
															#line 819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		}
															#line 120 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		ThrottleApi::setTagQuota(tr, tag, quota.reservedQuota, quota.totalQuota);
															#line 823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Optional<Value> && v,int loopDepth) 
	{
															#line 102 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		ThrottleApi::TagQuotaValue quota;
															#line 103 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (v.present())
															#line 834 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		{
															#line 104 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			quota = ThrottleApi::TagQuotaValue::fromValue(v.get());
															#line 838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		}
															#line 108 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (quotaType == QuotaType::TOTAL)
															#line 842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		{
															#line 110 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			quota.totalQuota = ((value - 1) / CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE + 1) * CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE;
															#line 846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		}
		else
		{
															#line 112 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			if (quotaType == QuotaType::RESERVED)
															#line 852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			{
															#line 114 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				quota.reservedQuota = ((value - 1) / CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE + 1) * CLIENT_KNOBS->TAG_THROTTLING_PAGE_SIZE;
															#line 856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			}
		}
															#line 117 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (!quota.isValid())
															#line 861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		{
															#line 118 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			return a_body1loopBody1Catch1(invalid_throttle_quota_value(), loopDepth);
															#line 865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		}
															#line 120 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		ThrottleApi::setTagQuota(tr, tag, quota.reservedQuota, quota.totalQuota);
															#line 869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetQuotaActor*>(this)->actor_wait_state > 0) static_cast<SetQuotaActor*>(this)->actor_wait_state = 0;
		static_cast<SetQuotaActor*>(this)->ActorCallback< SetQuotaActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< SetQuotaActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("setQuota", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setQuota", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetQuotaActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("setQuota", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setQuota", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetQuotaActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("setQuota", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setQuota", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 123 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		fmt::print("Successfully updated quota.\n");
															#line 124 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (!static_cast<SetQuotaActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetQuotaActorState(); static_cast<SetQuotaActor*>(this)->destroy(); return 0; }
															#line 955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		new (&static_cast<SetQuotaActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetQuotaActorState();
		static_cast<SetQuotaActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 123 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		fmt::print("Successfully updated quota.\n");
															#line 124 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (!static_cast<SetQuotaActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetQuotaActorState(); static_cast<SetQuotaActor*>(this)->destroy(); return 0; }
															#line 969 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		new (&static_cast<SetQuotaActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetQuotaActorState();
		static_cast<SetQuotaActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetQuotaActor*>(this)->actor_wait_state > 0) static_cast<SetQuotaActor*>(this)->actor_wait_state = 0;
		static_cast<SetQuotaActor*>(this)->ActorCallback< SetQuotaActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetQuotaActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setQuota", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setQuota", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetQuotaActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setQuota", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setQuota", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetQuotaActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setQuota", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setQuota", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SetQuotaActor*>(this)->actor_wait_state > 0) static_cast<SetQuotaActor*>(this)->actor_wait_state = 0;
		static_cast<SetQuotaActor*>(this)->ActorCallback< SetQuotaActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetQuotaActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setQuota", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setQuota", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SetQuotaActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setQuota", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setQuota", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SetQuotaActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setQuota", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setQuota", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	TransactionTag tag;
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	QuotaType quotaType;
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	int64_t value;
															#line 93 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 100 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	ThreadFuture<Optional<Value>> resultFuture;
															#line 1151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
};
// This generated class is to be used only via setQuota()
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
class SetQuotaActor final : public Actor<Void>, public ActorCallback< SetQuotaActor, 0, Optional<Value> >, public ActorCallback< SetQuotaActor, 1, Void >, public ActorCallback< SetQuotaActor, 2, Void >, public FastAllocated<SetQuotaActor>, public SetQuotaActorState<SetQuotaActor> {
															#line 1156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
public:
	using FastAllocated<SetQuotaActor>::operator new;
	using FastAllocated<SetQuotaActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11368502282243718656UL, 6910152089415062272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetQuotaActor, 0, Optional<Value> >;
friend struct ActorCallback< SetQuotaActor, 1, Void >;
friend struct ActorCallback< SetQuotaActor, 2, Void >;
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	SetQuotaActor(Reference<IDatabase> const& db,TransactionTag const& tag,QuotaType const& quotaType,int64_t const& value) 
															#line 1175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		 : Actor<Void>(),
		   SetQuotaActorState<SetQuotaActor>(db, tag, quotaType, value),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setQuota", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16988050191632167424UL, 14693009109390644992UL);
		ActorExecutionContextHelper __helper(static_cast<SetQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setQuota");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setQuota", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetQuotaActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetQuotaActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SetQuotaActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
[[nodiscard]] Future<Void> setQuota( Reference<IDatabase> const& db, TransactionTag const& tag, QuotaType const& quotaType, int64_t const& value ) {
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	return Future<Void>(new SetQuotaActor(db, tag, quotaType, value));
															#line 1209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
}

#line 130 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"

															#line 1214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
// This generated class is to be used only via clearQuota()
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
template <class ClearQuotaActor>
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
class ClearQuotaActorState {
															#line 1220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
public:
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	ClearQuotaActorState(Reference<IDatabase> const& db,TransactionTag const& tag) 
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		 : db(db),
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		   tag(tag),
															#line 132 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 1231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("clearQuota", reinterpret_cast<unsigned long>(this));

	}
	~ClearQuotaActorState() 
	{
		fdb_probe_actor_destroy("clearQuota", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 133 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			;
															#line 1246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearQuotaActorState();
		static_cast<ClearQuotaActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 134 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		try {
															#line 136 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			TenantMetadata::storageQuota().erase(tr, tag);
															#line 137 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			tr->clear(ThrottleApi::getTagQuotaKey(tag));
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			StrictFuture<Void> __when_expr_0 = safeThreadFutureToFuture(tr->commit());
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			if (static_cast<ClearQuotaActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearQuotaActor*>(this)->actor_wait_state = 1;
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearQuotaActor, 0, Void >*>(static_cast<ClearQuotaActor*>(this)));
															#line 1291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 142 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 142 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			if (static_cast<ClearQuotaActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClearQuotaActor*>(this)->actor_wait_state = 2;
															#line 142 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearQuotaActor, 1, Void >*>(static_cast<ClearQuotaActor*>(this)));
															#line 1320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 139 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		fmt::print("Successfully cleared quota.\n");
															#line 140 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (!static_cast<ClearQuotaActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearQuotaActorState(); static_cast<ClearQuotaActor*>(this)->destroy(); return 0; }
															#line 1337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		new (&static_cast<ClearQuotaActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearQuotaActorState();
		static_cast<ClearQuotaActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 139 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		fmt::print("Successfully cleared quota.\n");
															#line 140 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (!static_cast<ClearQuotaActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearQuotaActorState(); static_cast<ClearQuotaActor*>(this)->destroy(); return 0; }
															#line 1351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		new (&static_cast<ClearQuotaActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearQuotaActorState();
		static_cast<ClearQuotaActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearQuotaActor*>(this)->actor_wait_state > 0) static_cast<ClearQuotaActor*>(this)->actor_wait_state = 0;
		static_cast<ClearQuotaActor*>(this)->ActorCallback< ClearQuotaActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearQuotaActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearQuota", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearQuota", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearQuotaActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearQuota", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearQuota", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearQuotaActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearQuota", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearQuota", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearQuotaActor*>(this)->actor_wait_state > 0) static_cast<ClearQuotaActor*>(this)->actor_wait_state = 0;
		static_cast<ClearQuotaActor*>(this)->ActorCallback< ClearQuotaActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearQuotaActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearQuota", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearQuota", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearQuotaActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearQuota", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearQuota", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearQuotaActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearQuota", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearQuota", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	TransactionTag tag;
															#line 132 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 1527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
};
// This generated class is to be used only via clearQuota()
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
class ClearQuotaActor final : public Actor<Void>, public ActorCallback< ClearQuotaActor, 0, Void >, public ActorCallback< ClearQuotaActor, 1, Void >, public FastAllocated<ClearQuotaActor>, public ClearQuotaActorState<ClearQuotaActor> {
															#line 1532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
public:
	using FastAllocated<ClearQuotaActor>::operator new;
	using FastAllocated<ClearQuotaActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3567897769317553408UL, 13498097235836842496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearQuotaActor, 0, Void >;
friend struct ActorCallback< ClearQuotaActor, 1, Void >;
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	ClearQuotaActor(Reference<IDatabase> const& db,TransactionTag const& tag) 
															#line 1550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		 : Actor<Void>(),
		   ClearQuotaActorState<ClearQuotaActor>(db, tag),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearQuota", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1041556282015405056UL, 1595216993884609024UL);
		ActorExecutionContextHelper __helper(static_cast<ClearQuotaActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearQuota");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearQuota", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearQuotaActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearQuotaActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
[[nodiscard]] Future<Void> clearQuota( Reference<IDatabase> const& db, TransactionTag const& tag ) {
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	return Future<Void>(new ClearQuotaActor(db, tag));
															#line 1583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
}

#line 146 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"

constexpr auto usage = "quota [get <tag> [reserved_throughput|total_throughput|storage] | set <tag> "
                       "[reserved_throughput|total_throughput|storage] <value> | clear <tag>]";

bool exitFailure() {
	fmt::print(usage);
	return false;
}

} // namespace

namespace fdb_cli {

															#line 1600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
// This generated class is to be used only via quotaCommandActor()
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
template <class QuotaCommandActorActor>
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
class QuotaCommandActorActorState {
															#line 1606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
public:
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	QuotaCommandActorActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		 : db(db),
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		   tokens(tokens)
															#line 1615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("quotaCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~QuotaCommandActorActorState() 
	{
		fdb_probe_actor_destroy("quotaCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 160 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
			if (tokens.size() < 3 || tokens.size() > 5)
															#line 1630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
			{
															#line 161 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				if (!static_cast<QuotaCommandActorActor*>(this)->SAV<bool>::futures) { (void)(exitFailure()); this->~QuotaCommandActorActorState(); static_cast<QuotaCommandActorActor*>(this)->destroy(); return 0; }
															#line 1634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
				new (&static_cast<QuotaCommandActorActor*>(this)->SAV< bool >::value()) bool(exitFailure());
				this->~QuotaCommandActorActorState();
				static_cast<QuotaCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 163 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				auto const tag = parseTag(tokens[2]);
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				if (!tag.present())
															#line 1646 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
				{
															#line 165 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
					if (!static_cast<QuotaCommandActorActor*>(this)->SAV<bool>::futures) { (void)(exitFailure()); this->~QuotaCommandActorActorState(); static_cast<QuotaCommandActorActor*>(this)->destroy(); return 0; }
															#line 1650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
					new (&static_cast<QuotaCommandActorActor*>(this)->SAV< bool >::value()) bool(exitFailure());
					this->~QuotaCommandActorActorState();
					static_cast<QuotaCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 167 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
				if (tokens[1] == "get"_sr)
															#line 1658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
				{
															#line 168 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
					if (tokens.size() != 4)
															#line 1662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
					{
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
						if (!static_cast<QuotaCommandActorActor*>(this)->SAV<bool>::futures) { (void)(exitFailure()); this->~QuotaCommandActorActorState(); static_cast<QuotaCommandActorActor*>(this)->destroy(); return 0; }
															#line 1666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
						new (&static_cast<QuotaCommandActorActor*>(this)->SAV< bool >::value()) bool(exitFailure());
						this->~QuotaCommandActorActorState();
						static_cast<QuotaCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 171 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
					auto const quotaType = parseQuotaType(tokens[3]);
															#line 172 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
					if (!quotaType.present())
															#line 1676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
					{
															#line 173 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
						if (!static_cast<QuotaCommandActorActor*>(this)->SAV<bool>::futures) { (void)(exitFailure()); this->~QuotaCommandActorActorState(); static_cast<QuotaCommandActorActor*>(this)->destroy(); return 0; }
															#line 1680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
						new (&static_cast<QuotaCommandActorActor*>(this)->SAV< bool >::value()) bool(exitFailure());
						this->~QuotaCommandActorActorState();
						static_cast<QuotaCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 175 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
					StrictFuture<Void> __when_expr_0 = getQuota(db, tag.get(), quotaType.get());
															#line 175 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
					if (static_cast<QuotaCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<QuotaCommandActorActor*>(this)->actor_wait_state = 1;
															#line 175 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< QuotaCommandActorActor, 0, Void >*>(static_cast<QuotaCommandActorActor*>(this)));
															#line 1695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 177 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
					if (tokens[1] == "set"_sr)
															#line 1702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
					{
															#line 178 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
						if (tokens.size() != 5)
															#line 1706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
						{
															#line 179 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
							if (!static_cast<QuotaCommandActorActor*>(this)->SAV<bool>::futures) { (void)(exitFailure()); this->~QuotaCommandActorActorState(); static_cast<QuotaCommandActorActor*>(this)->destroy(); return 0; }
															#line 1710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
							new (&static_cast<QuotaCommandActorActor*>(this)->SAV< bool >::value()) bool(exitFailure());
							this->~QuotaCommandActorActorState();
							static_cast<QuotaCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 181 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
						auto const quotaType = parseQuotaType(tokens[3]);
															#line 182 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
						auto const quotaValue = parseQuotaValue(tokens[4]);
															#line 183 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
						if (!quotaType.present() || !quotaValue.present())
															#line 1722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
						{
															#line 184 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
							if (!static_cast<QuotaCommandActorActor*>(this)->SAV<bool>::futures) { (void)(exitFailure()); this->~QuotaCommandActorActorState(); static_cast<QuotaCommandActorActor*>(this)->destroy(); return 0; }
															#line 1726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
							new (&static_cast<QuotaCommandActorActor*>(this)->SAV< bool >::value()) bool(exitFailure());
							this->~QuotaCommandActorActorState();
							static_cast<QuotaCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 186 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
						StrictFuture<Void> __when_expr_1 = setQuota(db, tag.get(), quotaType.get(), quotaValue.get());
															#line 186 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
						if (static_cast<QuotaCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
						static_cast<QuotaCommandActorActor*>(this)->actor_wait_state = 2;
															#line 186 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< QuotaCommandActorActor, 1, Void >*>(static_cast<QuotaCommandActorActor*>(this)));
															#line 1741 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 188 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
						if (tokens[1] == "clear"_sr)
															#line 1748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
						{
															#line 189 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
							if (tokens.size() != 3)
															#line 1752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
							{
															#line 190 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
								if (!static_cast<QuotaCommandActorActor*>(this)->SAV<bool>::futures) { (void)(exitFailure()); this->~QuotaCommandActorActorState(); static_cast<QuotaCommandActorActor*>(this)->destroy(); return 0; }
															#line 1756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
								new (&static_cast<QuotaCommandActorActor*>(this)->SAV< bool >::value()) bool(exitFailure());
								this->~QuotaCommandActorActorState();
								static_cast<QuotaCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
															#line 192 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
							StrictFuture<Void> __when_expr_2 = clearQuota(db, tag.get());
															#line 192 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
							if (static_cast<QuotaCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
							if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
							static_cast<QuotaCommandActorActor*>(this)->actor_wait_state = 3;
															#line 192 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
							__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< QuotaCommandActorActor, 2, Void >*>(static_cast<QuotaCommandActorActor*>(this)));
															#line 1771 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 195 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
							if (!static_cast<QuotaCommandActorActor*>(this)->SAV<bool>::futures) { (void)(exitFailure()); this->~QuotaCommandActorActorState(); static_cast<QuotaCommandActorActor*>(this)->destroy(); return 0; }
															#line 1778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
							new (&static_cast<QuotaCommandActorActor*>(this)->SAV< bool >::value()) bool(exitFailure());
							this->~QuotaCommandActorActorState();
							static_cast<QuotaCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~QuotaCommandActorActorState();
		static_cast<QuotaCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 176 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (!static_cast<QuotaCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~QuotaCommandActorActorState(); static_cast<QuotaCommandActorActor*>(this)->destroy(); return 0; }
															#line 1808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		new (&static_cast<QuotaCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~QuotaCommandActorActorState();
		static_cast<QuotaCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 176 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (!static_cast<QuotaCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~QuotaCommandActorActorState(); static_cast<QuotaCommandActorActor*>(this)->destroy(); return 0; }
															#line 1820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		new (&static_cast<QuotaCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~QuotaCommandActorActorState();
		static_cast<QuotaCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<QuotaCommandActorActor*>(this)->actor_wait_state > 0) static_cast<QuotaCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<QuotaCommandActorActor*>(this)->ActorCallback< QuotaCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< QuotaCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("quotaCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuotaCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quotaCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< QuotaCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("quotaCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuotaCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quotaCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< QuotaCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("quotaCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QuotaCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quotaCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 187 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (!static_cast<QuotaCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~QuotaCommandActorActorState(); static_cast<QuotaCommandActorActor*>(this)->destroy(); return 0; }
															#line 1907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		new (&static_cast<QuotaCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~QuotaCommandActorActorState();
		static_cast<QuotaCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 187 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (!static_cast<QuotaCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~QuotaCommandActorActorState(); static_cast<QuotaCommandActorActor*>(this)->destroy(); return 0; }
															#line 1919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		new (&static_cast<QuotaCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~QuotaCommandActorActorState();
		static_cast<QuotaCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<QuotaCommandActorActor*>(this)->actor_wait_state > 0) static_cast<QuotaCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<QuotaCommandActorActor*>(this)->ActorCallback< QuotaCommandActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< QuotaCommandActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("quotaCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuotaCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quotaCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< QuotaCommandActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("quotaCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuotaCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quotaCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< QuotaCommandActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("quotaCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QuotaCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quotaCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
															#line 193 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (!static_cast<QuotaCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~QuotaCommandActorActorState(); static_cast<QuotaCommandActorActor*>(this)->destroy(); return 0; }
															#line 2006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		new (&static_cast<QuotaCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~QuotaCommandActorActorState();
		static_cast<QuotaCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
															#line 193 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
		if (!static_cast<QuotaCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~QuotaCommandActorActorState(); static_cast<QuotaCommandActorActor*>(this)->destroy(); return 0; }
															#line 2018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		new (&static_cast<QuotaCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~QuotaCommandActorActorState();
		static_cast<QuotaCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<QuotaCommandActorActor*>(this)->actor_wait_state > 0) static_cast<QuotaCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<QuotaCommandActorActor*>(this)->ActorCallback< QuotaCommandActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< QuotaCommandActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("quotaCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuotaCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quotaCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< QuotaCommandActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("quotaCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QuotaCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quotaCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< QuotaCommandActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("quotaCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QuotaCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("quotaCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 2105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
};
// This generated class is to be used only via quotaCommandActor()
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
class QuotaCommandActorActor final : public Actor<bool>, public ActorCallback< QuotaCommandActorActor, 0, Void >, public ActorCallback< QuotaCommandActorActor, 1, Void >, public ActorCallback< QuotaCommandActorActor, 2, Void >, public FastAllocated<QuotaCommandActorActor>, public QuotaCommandActorActorState<QuotaCommandActorActor> {
															#line 2110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
public:
	using FastAllocated<QuotaCommandActorActor>::operator new;
	using FastAllocated<QuotaCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16978199833859125248UL, 2690437181402180608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< QuotaCommandActorActor, 0, Void >;
friend struct ActorCallback< QuotaCommandActorActor, 1, Void >;
friend struct ActorCallback< QuotaCommandActorActor, 2, Void >;
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	QuotaCommandActorActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 2129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
		 : Actor<bool>(),
		   QuotaCommandActorActorState<QuotaCommandActorActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("quotaCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15727721650012747264UL, 1615606155069149184UL);
		ActorExecutionContextHelper __helper(static_cast<QuotaCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("quotaCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("quotaCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< QuotaCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< QuotaCommandActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< QuotaCommandActorActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
[[nodiscard]] Future<bool> quotaCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"
	return Future<bool>(new QuotaCommandActorActor(db, tokens));
															#line 2163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/QuotaCommand.actor.g.cpp"
}

#line 199 "/Users/ec2-user/foundationdb/fdbcli/QuotaCommand.actor.cpp"

} // namespace fdb_cli
