#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
/*
 * ForceRecoveryWithDataLossCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/IClientApi.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

															#line 34 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/ForceRecoveryWithDataLossCommand.actor.g.cpp"
// This generated class is to be used only via forceRecoveryWithDataLossCommandActor()
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
template <class ForceRecoveryWithDataLossCommandActorActor>
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
class ForceRecoveryWithDataLossCommandActorActorState {
															#line 40 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/ForceRecoveryWithDataLossCommand.actor.g.cpp"
public:
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
	ForceRecoveryWithDataLossCommandActorActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
		 : db(db),
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
		   tokens(tokens)
															#line 49 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/ForceRecoveryWithDataLossCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("forceRecoveryWithDataLossCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~ForceRecoveryWithDataLossCommandActorActorState() 
	{
		fdb_probe_actor_destroy("forceRecoveryWithDataLossCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 33 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
			if (tokens.size() != 2)
															#line 64 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/ForceRecoveryWithDataLossCommand.actor.g.cpp"
			{
															#line 34 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 35 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
				if (!static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ForceRecoveryWithDataLossCommandActorActorState(); static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->destroy(); return 0; }
															#line 70 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/ForceRecoveryWithDataLossCommand.actor.g.cpp"
				new (&static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~ForceRecoveryWithDataLossCommandActorActorState();
				static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
			StrictFuture<Void> __when_expr_0 = safeThreadFutureToFuture(db->forceRecoveryWithDataLoss(tokens[1]));
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
			if (static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 80 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/ForceRecoveryWithDataLossCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->actor_wait_state = 1;
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForceRecoveryWithDataLossCommandActorActor, 0, Void >*>(static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)));
															#line 85 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/ForceRecoveryWithDataLossCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ForceRecoveryWithDataLossCommandActorActorState();
		static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
		if (!static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ForceRecoveryWithDataLossCommandActorActorState(); static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->destroy(); return 0; }
															#line 108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/ForceRecoveryWithDataLossCommand.actor.g.cpp"
		new (&static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ForceRecoveryWithDataLossCommandActorActorState();
		static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
		if (!static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ForceRecoveryWithDataLossCommandActorActorState(); static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->destroy(); return 0; }
															#line 120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/ForceRecoveryWithDataLossCommand.actor.g.cpp"
		new (&static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ForceRecoveryWithDataLossCommandActorActorState();
		static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->ActorCallback< ForceRecoveryWithDataLossCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ForceRecoveryWithDataLossCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("forceRecoveryWithDataLossCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forceRecoveryWithDataLossCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForceRecoveryWithDataLossCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("forceRecoveryWithDataLossCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forceRecoveryWithDataLossCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForceRecoveryWithDataLossCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("forceRecoveryWithDataLossCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forceRecoveryWithDataLossCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/ForceRecoveryWithDataLossCommand.actor.g.cpp"
};
// This generated class is to be used only via forceRecoveryWithDataLossCommandActor()
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
class ForceRecoveryWithDataLossCommandActorActor final : public Actor<bool>, public ActorCallback< ForceRecoveryWithDataLossCommandActorActor, 0, Void >, public FastAllocated<ForceRecoveryWithDataLossCommandActorActor>, public ForceRecoveryWithDataLossCommandActorActorState<ForceRecoveryWithDataLossCommandActorActor> {
															#line 212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/ForceRecoveryWithDataLossCommand.actor.g.cpp"
public:
	using FastAllocated<ForceRecoveryWithDataLossCommandActorActor>::operator new;
	using FastAllocated<ForceRecoveryWithDataLossCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5474494953577241856UL, 16573392891264008704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ForceRecoveryWithDataLossCommandActorActor, 0, Void >;
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
	ForceRecoveryWithDataLossCommandActorActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/ForceRecoveryWithDataLossCommand.actor.g.cpp"
		 : Actor<bool>(),
		   ForceRecoveryWithDataLossCommandActorActorState<ForceRecoveryWithDataLossCommandActorActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forceRecoveryWithDataLossCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5559127067383444736UL, 828345682074661120UL);
		ActorExecutionContextHelper __helper(static_cast<ForceRecoveryWithDataLossCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forceRecoveryWithDataLossCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forceRecoveryWithDataLossCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ForceRecoveryWithDataLossCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
[[nodiscard]] Future<bool> forceRecoveryWithDataLossCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 32 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"
	return Future<bool>(new ForceRecoveryWithDataLossCommandActorActor(db, tokens));
															#line 261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/ForceRecoveryWithDataLossCommand.actor.g.cpp"
}

#line 40 "/Users/ec2-user/foundationdb/fdbcli/ForceRecoveryWithDataLossCommand.actor.cpp"

CommandFactory forceRecoveryWithDataLossFactory(
    "force_recovery_with_data_loss",
    CommandHelp("force_recovery_with_data_loss <DCID>",
                "Force the database to recover into DCID",
                "A forced recovery will cause the database to lose the most recently committed mutations. The "
                "amount of mutations that will be lost depends on how far behind the remote datacenter is. This "
                "command will change the region configuration to have a positive priority for the chosen DCID, and "
                "a negative priority for all other DCIDs. This command will set usable_regions to 1. If the "
                "database has already recovered, this command does nothing.\n"));
} // namespace fdb_cli
