#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
/*
 * BulkSetup.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ClientKnobs.h"
#include "fdbclient/TenantEntryCache.actor.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbrpc/ContinuousSample.h"
#include "fdbrpc/TenantInfo.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/genericactors.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct BulkSetupWorkload : TestWorkload {
	static constexpr auto NAME = "BulkLoadWithTenants";

	int nodeCount;
	double transactionsPerSecond;
	Key keyPrefix;
	double maxNumTenants;
	double minNumTenants;
	std::vector<Reference<Tenant>> tenants;
	bool deleteTenants;
	double testDuration;
	std::unordered_map<int64_t, std::vector<KeyValueRef>> numKVPairsPerTenant;
	bool enableEKPKeyFetchFailure;
	Arena arena;

	BulkSetupWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		transactionsPerSecond = getOption(options, "transactionsPerSecond"_sr, 5000.0) / clientCount;
		nodeCount = getOption(options, "nodeCount"_sr, transactionsPerSecond * clientCount);
		keyPrefix = unprintable(getOption(options, "keyPrefix"_sr, ""_sr).toString());
		// maximum and minimum number of tenants per client
		maxNumTenants = getOption(options, "maxNumTenants"_sr, 0);
		minNumTenants = getOption(options, "minNumTenants"_sr, 0);
		deleteTenants = getOption(options, "deleteTenants"_sr, false);
		ASSERT(minNumTenants <= maxNumTenants);
		testDuration = getOption(options, "testDuration"_sr, -1);
		enableEKPKeyFetchFailure = getOption(options, "enableEKPKeyFetchFailure"_sr, false);
	}

	void getMetrics(std::vector<PerfMetric>& m) override {}

	Key keyForIndex(int n) { return key(n); }
	Key key(int n) { return doubleToTestKey((double)n / nodeCount, keyPrefix); }
	Value value(int n) { return doubleToTestKey(n, keyPrefix); }

	Standalone<KeyValueRef> operator()(int n) { return KeyValueRef(key(n), value((n + 1) % nodeCount)); }

																#line 71 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
// This generated class is to be used only via getKVPairsForTenant()
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
template <class GetKVPairsForTenantActor>
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
class GetKVPairsForTenantActorState {
															#line 77 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
public:
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	GetKVPairsForTenantActorState(BulkSetupWorkload* const& workload,Reference<Tenant> const& tenant,Database const& cx) 
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		 : workload(workload),
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		   tenant(tenant),
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		   cx(cx),
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		   begin(firstGreaterOrEqual(normalKeys.begin)),
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		   end(firstGreaterOrEqual(normalKeys.end)),
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		   kvPairs(),
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		   tr(ReadYourWritesTransaction(cx, tenant))
															#line 96 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
	{
		fdb_probe_actor_create("getKVPairsForTenant", reinterpret_cast<unsigned long>(this));

	}
	~GetKVPairsForTenantActorState() 
	{
		fdb_probe_actor_destroy("getKVPairsForTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			;
															#line 111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKVPairsForTenantActorState();
		static_cast<GetKVPairsForTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (!static_cast<GetKVPairsForTenantActor*>(this)->SAV<std::vector<KeyValueRef>>::futures) { (void)(kvPairs); this->~GetKVPairsForTenantActorState(); static_cast<GetKVPairsForTenantActor*>(this)->destroy(); return 0; }
															#line 134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		new (&static_cast<GetKVPairsForTenantActor*>(this)->SAV< std::vector<KeyValueRef> >::value()) std::vector<KeyValueRef>(std::move(kvPairs)); // state_var_RVO
		this->~GetKVPairsForTenantActorState();
		static_cast<GetKVPairsForTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(begin, end, 1000);
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			if (static_cast<GetKVPairsForTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKVPairsForTenantActor*>(this)->actor_wait_state = 1;
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKVPairsForTenantActor, 0, RangeResult >*>(static_cast<GetKVPairsForTenantActor*>(this)));
															#line 161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			if (static_cast<GetKVPairsForTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 198 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetKVPairsForTenantActor*>(this)->actor_wait_state = 2;
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKVPairsForTenantActor, 1, Void >*>(static_cast<GetKVPairsForTenantActor*>(this)));
															#line 203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& kvRange,int loopDepth) 
	{
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (!kvRange.more && kvRange.size() == 0)
															#line 218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		for(int i = 0;i < kvRange.size();i++) {
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			kvPairs.push_back(KeyValueRef(workload->arena, KeyValueRef(kvRange[i].key, kvRange[i].value)));
															#line 226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		}
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		begin = firstGreaterThan(kvRange.end()[-1].key);
															#line 230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && kvRange,int loopDepth) 
	{
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (!kvRange.more && kvRange.size() == 0)
															#line 239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		for(int i = 0;i < kvRange.size();i++) {
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			kvPairs.push_back(KeyValueRef(workload->arena, KeyValueRef(kvRange[i].key, kvRange[i].value)));
															#line 247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		}
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		begin = firstGreaterThan(kvRange.end()[-1].key);
															#line 251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& kvRange,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(kvRange, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && kvRange,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(kvRange), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKVPairsForTenantActor*>(this)->actor_wait_state > 0) static_cast<GetKVPairsForTenantActor*>(this)->actor_wait_state = 0;
		static_cast<GetKVPairsForTenantActor*>(this)->ActorCallback< GetKVPairsForTenantActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetKVPairsForTenantActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getKVPairsForTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKVPairsForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKVPairsForTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKVPairsForTenantActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getKVPairsForTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKVPairsForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKVPairsForTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKVPairsForTenantActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getKVPairsForTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKVPairsForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKVPairsForTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKVPairsForTenantActor*>(this)->actor_wait_state > 0) static_cast<GetKVPairsForTenantActor*>(this)->actor_wait_state = 0;
		static_cast<GetKVPairsForTenantActor*>(this)->ActorCallback< GetKVPairsForTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKVPairsForTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKVPairsForTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKVPairsForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKVPairsForTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKVPairsForTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKVPairsForTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKVPairsForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKVPairsForTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKVPairsForTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKVPairsForTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKVPairsForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKVPairsForTenant", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	BulkSetupWorkload* workload;
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	Reference<Tenant> tenant;
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	Database cx;
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	KeySelector begin;
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	KeySelector end;
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	std::vector<KeyValueRef> kvPairs;
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
};
// This generated class is to be used only via getKVPairsForTenant()
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
class GetKVPairsForTenantActor final : public Actor<std::vector<KeyValueRef>>, public ActorCallback< GetKVPairsForTenantActor, 0, RangeResult >, public ActorCallback< GetKVPairsForTenantActor, 1, Void >, public FastAllocated<GetKVPairsForTenantActor>, public GetKVPairsForTenantActorState<GetKVPairsForTenantActor> {
															#line 450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
public:
	using FastAllocated<GetKVPairsForTenantActor>::operator new;
	using FastAllocated<GetKVPairsForTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17611875027001864192UL, 10114156990114713344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<KeyValueRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKVPairsForTenantActor, 0, RangeResult >;
friend struct ActorCallback< GetKVPairsForTenantActor, 1, Void >;
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	GetKVPairsForTenantActor(BulkSetupWorkload* const& workload,Reference<Tenant> const& tenant,Database const& cx) 
															#line 468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		 : Actor<std::vector<KeyValueRef>>(),
		   GetKVPairsForTenantActorState<GetKVPairsForTenantActor>(workload, tenant, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKVPairsForTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(94943294249897216UL, 17953407658672362240UL);
		ActorExecutionContextHelper __helper(static_cast<GetKVPairsForTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKVPairsForTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKVPairsForTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKVPairsForTenantActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKVPairsForTenantActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
[[nodiscard]] static Future<std::vector<KeyValueRef>> getKVPairsForTenant( BulkSetupWorkload* const& workload, Reference<Tenant> const& tenant, Database const& cx ) {
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	return Future<std::vector<KeyValueRef>>(new GetKVPairsForTenantActor(workload, tenant, cx));
															#line 501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
}

#line 92 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"

																#line 506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
template <class _setupActor>
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
class _setupActorState {
															#line 512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
public:
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	_setupActorState(BulkSetupWorkload* const& workload,Database const& cx) 
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		 : workload(workload),
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		   cx(cx),
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		   numTenantsToCreate(deterministicRandom()->randomInt(workload->minNumTenants, workload->maxNumTenants + 1))
															#line 523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			TraceEvent("BulkSetupTenantCreation").detail("NumTenants", numTenantsToCreate);
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			if (numTenantsToCreate > 0)
															#line 540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			{
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				tenantFutures = std::vector<Future<Optional<TenantMapEntry>>>();
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				for(int i = 0;i < numTenantsToCreate;i++) {
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
					TenantName tenantName = TenantNameRef(format("BulkSetupTenant_%04d", i));
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
					tenantFutures.push_back(TenantAPI::createTenant(cx.getReference(), tenantName));
															#line 550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
				}
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(tenantFutures);
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		StrictFuture<Void> __when_expr_1 = bulkSetup(cx, workload, workload->nodeCount, Promise<double>(), false, 0.0, 1e12, std::vector<uint64_t>(), Promise<std::vector<std::pair<uint64_t, double>>>(), 0, 0.1, 0, 0, workload->tenants);
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		for( auto& f : tenantFutures ) {
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			ASSERT(f.get().present());
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			workload->tenants.push_back(makeReference<Tenant>(f.get().get().id, f.get().get().tenantName));
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			TraceEvent("BulkSetupCreatedTenant").detail("Tenant", workload->tenants.back());
															#line 611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		for( auto& f : tenantFutures ) {
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			ASSERT(f.get().present());
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			workload->tenants.push_back(makeReference<Tenant>(f.get().get().id, f.get().get().tenantName));
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			TraceEvent("BulkSetupCreatedTenant").detail("Tenant", workload->tenants.back());
															#line 627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		i = int();
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		added = false;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		i = 0;
															#line 716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		i = int();
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		added = false;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		i = 0;
															#line 729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (!(i < workload->tenants.size()))
															#line 832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		{
			return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		StrictFuture<std::vector<KeyValueRef>> __when_expr_2 = getKVPairsForTenant(workload, workload->tenants[i], cx);
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, std::vector<KeyValueRef> >*>(static_cast<_setupActor*>(this)));
															#line 845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(std::vector<KeyValueRef> const& keysForCurTenant,int loopDepth) 
	{
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (workload->enableEKPKeyFetchFailure && keysForCurTenant.size() > 0 && !added)
															#line 867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		{
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			IKnobCollection::getMutableGlobalKnobCollection().setKnob( "simulation_ekp_tenant_ids_to_drop", KnobValueRef::create(std::to_string(workload->tenants[i]->id())));
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			TraceEvent("BulkSetupTenantForEKPToDrop") .detail("Tenant", CLIENT_KNOBS->SIMULATION_EKP_TENANT_IDS_TO_DROP);
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			added = true;
															#line 875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		}
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		workload->numKVPairsPerTenant[workload->tenants[i]->id()] = keysForCurTenant;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		i++;
															#line 881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(std::vector<KeyValueRef> && keysForCurTenant,int loopDepth) 
	{
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (workload->enableEKPKeyFetchFailure && keysForCurTenant.size() > 0 && !added)
															#line 890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		{
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			IKnobCollection::getMutableGlobalKnobCollection().setKnob( "simulation_ekp_tenant_ids_to_drop", KnobValueRef::create(std::to_string(workload->tenants[i]->id())));
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			TraceEvent("BulkSetupTenantForEKPToDrop") .detail("Tenant", CLIENT_KNOBS->SIMULATION_EKP_TENANT_IDS_TO_DROP);
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			added = true;
															#line 898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		}
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		workload->numKVPairsPerTenant[workload->tenants[i]->id()] = keysForCurTenant;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		i++;
															#line 904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(std::vector<KeyValueRef> const& keysForCurTenant,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(keysForCurTenant, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(std::vector<KeyValueRef> && keysForCurTenant,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(std::move(keysForCurTenant), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 2, std::vector<KeyValueRef> >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, std::vector<KeyValueRef> >*,std::vector<KeyValueRef> const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, std::vector<KeyValueRef> >*,std::vector<KeyValueRef> && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _setupActor, 2, std::vector<KeyValueRef> >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	BulkSetupWorkload* workload;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	Database cx;
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	int numTenantsToCreate;
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	std::vector<Future<Optional<TenantMapEntry>>> tenantFutures;
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	int i;
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	bool added;
															#line 996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public ActorCallback< _setupActor, 2, std::vector<KeyValueRef> >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 1001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13374097211617198080UL, 14088587050315159808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
friend struct ActorCallback< _setupActor, 2, std::vector<KeyValueRef> >;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	_setupActor(BulkSetupWorkload* const& workload,Database const& cx) 
															#line 1020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(workload, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _setupActor, 2, std::vector<KeyValueRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
[[nodiscard]] static Future<Void> _setup( BulkSetupWorkload* const& workload, Database const& cx ) {
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	return Future<Void>(new _setupActor(workload, cx));
															#line 1054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
}

#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"

																#line 1059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
template <class _checkActor>
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
class _checkActorState {
															#line 1065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
public:
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	_checkActorState(BulkSetupWorkload* const& workload,Database const& cx) 
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		 : workload(workload),
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		   cx(cx),
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		   i(),
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		   tenantIdsToDrop(parseStringToUnorderedSet<int64_t>(CLIENT_KNOBS->SIMULATION_EKP_TENANT_IDS_TO_DROP, ','))
															#line 1078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			i = 0;
															#line 1093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (!(i < workload->tenants.size()))
															#line 1135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		tenant = workload->tenants[i];
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		StrictFuture<std::vector<KeyValueRef>> __when_expr_0 = getKVPairsForTenant(workload, tenant, cx);
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, std::vector<KeyValueRef> >*>(static_cast<_checkActor*>(this)));
															#line 1150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1continue1(int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		i++;
															#line 1172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(std::vector<KeyValueRef> const& keysForCurTenant,int loopDepth) 
	{
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (tenantIdsToDrop.contains(tenant->id()))
															#line 1181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		{
			return a_body1continue1(loopDepth); // continue
		}
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		std::vector<KeyValueRef> expectedKeysForCurTenant = workload->numKVPairsPerTenant[tenant->id()];
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (keysForCurTenant.size() != expectedKeysForCurTenant.size())
															#line 1189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		{
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			TraceEvent(SevError, "BulkSetupNumKeysMismatch") .detail("TenantName", tenant) .detail("ActualCount", keysForCurTenant.size()) .detail("ExpectedCount", expectedKeysForCurTenant.size());
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_checkActorState();
			static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			TraceEvent("BulkSetupNumKeys") .detail("TenantName", tenant) .detail("ActualCount", keysForCurTenant.size());
															#line 1205 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		}
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		for(int j = 0;j < expectedKeysForCurTenant.size();j++) {
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			if (expectedKeysForCurTenant[j].key != keysForCurTenant[j].key)
															#line 1211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			{
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				TraceEvent(SevError, "BulkSetupNumKeyMismatch") .detail("TenantName", tenant) .detail("ActualKey", keysForCurTenant[j].key) .detail("ExpectedKey", expectedKeysForCurTenant[j].key);
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
				new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
				this->~_checkActorState();
				static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			if (expectedKeysForCurTenant[j].value != keysForCurTenant[j].value)
															#line 1225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			{
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				TraceEvent(SevError, "BulkSetupNumValueMismatch") .detail("TenantName", tenant) .detail("ActualValue", keysForCurTenant[j].value) .detail("ExpectedValue", expectedKeysForCurTenant[j].value);
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
				new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
				this->~_checkActorState();
				static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		i++;
															#line 1240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(std::vector<KeyValueRef> && keysForCurTenant,int loopDepth) 
	{
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (tenantIdsToDrop.contains(tenant->id()))
															#line 1249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		{
			return a_body1continue1(loopDepth); // continue
		}
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		std::vector<KeyValueRef> expectedKeysForCurTenant = workload->numKVPairsPerTenant[tenant->id()];
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (keysForCurTenant.size() != expectedKeysForCurTenant.size())
															#line 1257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		{
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			TraceEvent(SevError, "BulkSetupNumKeysMismatch") .detail("TenantName", tenant) .detail("ActualCount", keysForCurTenant.size()) .detail("ExpectedCount", expectedKeysForCurTenant.size());
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_checkActorState();
			static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			TraceEvent("BulkSetupNumKeys") .detail("TenantName", tenant) .detail("ActualCount", keysForCurTenant.size());
															#line 1273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		}
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		for(int j = 0;j < expectedKeysForCurTenant.size();j++) {
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			if (expectedKeysForCurTenant[j].key != keysForCurTenant[j].key)
															#line 1279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			{
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				TraceEvent(SevError, "BulkSetupNumKeyMismatch") .detail("TenantName", tenant) .detail("ActualKey", keysForCurTenant[j].key) .detail("ExpectedKey", expectedKeysForCurTenant[j].key);
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
				new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
				this->~_checkActorState();
				static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			if (expectedKeysForCurTenant[j].value != keysForCurTenant[j].value)
															#line 1293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			{
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				TraceEvent(SevError, "BulkSetupNumValueMismatch") .detail("TenantName", tenant) .detail("ActualValue", keysForCurTenant[j].value) .detail("ExpectedValue", expectedKeysForCurTenant[j].value);
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
				new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
				this->~_checkActorState();
				static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		i++;
															#line 1308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyValueRef> const& keysForCurTenant,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(keysForCurTenant, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyValueRef> && keysForCurTenant,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(keysForCurTenant), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, std::vector<KeyValueRef> >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, std::vector<KeyValueRef> >*,std::vector<KeyValueRef> const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, std::vector<KeyValueRef> >*,std::vector<KeyValueRef> && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, std::vector<KeyValueRef> >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	BulkSetupWorkload* workload;
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	Database cx;
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	int i;
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	std::unordered_set<int64_t> tenantIdsToDrop;
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	Reference<Tenant> tenant;
															#line 1398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, std::vector<KeyValueRef> >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 1403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8608619746853960448UL, 11590365126873900800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, std::vector<KeyValueRef> >;
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	_checkActor(BulkSetupWorkload* const& workload,Database const& cx) 
															#line 1420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(workload, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, std::vector<KeyValueRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
[[nodiscard]] static Future<bool> _check( BulkSetupWorkload* const& workload, Database const& cx ) {
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	return Future<bool>(new _checkActor(workload, cx));
															#line 1452 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
}

#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"

																#line 1457 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
template <class _startActor>
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
class _startActorState {
															#line 1463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
public:
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	_startActorState(BulkSetupWorkload* const& workload,Database const& cx) 
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		 : workload(workload),
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		   cx(cx)
															#line 1472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			if (workload->deleteTenants && workload->tenants.size() > 1)
															#line 1487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			{
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				tenantCache = makeReference<TenantEntryCache<Void>>(cx, TenantEntryCacheRefreshMode::WATCH);
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				StrictFuture<Void> __when_expr_0 = tenantCache->init();
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		numTenantsToDelete = deterministicRandom()->randomInt(0, workload->tenants.size());
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		TraceEvent("BulkSetupTenantDeletion").detail("NumTenants", numTenantsToDelete);
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (numTenantsToDelete > 0)
															#line 1544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		{
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			i = int();
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			i = 0;
															#line 1550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		numTenantsToDelete = deterministicRandom()->randomInt(0, workload->tenants.size());
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		TraceEvent("BulkSetupTenantDeletion").detail("NumTenants", numTenantsToDelete);
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (numTenantsToDelete > 0)
															#line 1568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		{
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			i = int();
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			i = 0;
															#line 1574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (!(i < numTenantsToDelete))
															#line 1682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		tenantIndex = deterministicRandom()->randomInt(0, workload->tenants.size());
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		tenant = workload->tenants[tenantIndex];
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		workload->tenants.erase(workload->tenants.begin() + tenantIndex);
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		TraceEvent("BulkSetupTenantDeletionClearing") .detail("Tenant", tenant) .detail("TotalNumTenants", workload->tenants.size());
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		tr = ReadYourWritesTransaction(cx, tenant);
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		;
															#line 1698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(TenantAPI::deleteTenant(cx.getReference(), tenant->name.get(), tenant->id()));
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			tr.clear(normalKeys);
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1cont2loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont2loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont2loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		i++;
															#line 1984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
		i++;
															#line 1993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	BulkSetupWorkload* workload;
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	Database cx;
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	Reference<TenantEntryCache<Void>> tenantCache;
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	int numTenantsToDelete;
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	int i;
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	int tenantIndex;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	Reference<Tenant> tenant;
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 2089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 2094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14334892276595113728UL, 1464277024761564928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	_startActor(BulkSetupWorkload* const& workload,Database const& cx) 
															#line 2114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(workload, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
[[nodiscard]] static Future<Void> _start( BulkSetupWorkload* const& workload, Database const& cx ) {
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"
	return Future<Void>(new _startActor(workload, cx));
															#line 2149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/BulkLoadWithTenants.actor.g.cpp"
}

#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/BulkLoadWithTenants.actor.cpp"

	Future<Void> setup(Database const& cx) override {
		if (clientId == 0) {
			return _setup(this, cx);
		}
		return Void();
	}

	Future<Void> start(Database const& cx) override {
		if (clientId == 0) {
			if (testDuration > 0) {
				return timeout(_start(this, cx), testDuration, Void());
			}
			return _start(this, cx);
		}
		return Void();
	}

	Future<bool> check(Database const& cx) override {
		if (clientId == 0) {
			return _check(this, cx);
		}
		return true;
	}
};

WorkloadFactory<BulkSetupWorkload> BulkSetupWorkloadFactory;
