#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
/*
 * worker.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdlib>
#include <tuple>
#include <boost/lexical_cast.hpp>
#include <unordered_map>

#include "fdbclient/FDBTypes.h"
#include "flow/ApiVersion.h"
#include "flow/Buggify.h"
#include "flow/CodeProbe.h"
#include "flow/IAsyncFile.h"
#include "fdbrpc/Locality.h"
#include "fdbclient/GetEncryptCipherKeys_impl.actor.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbclient/ProcessInterface.h"
#include "fdbclient/StorageServerInterface.h"
#include "fdbclient/versions.h"
#include "fdbserver/Knobs.h"
#include "flow/ActorCollection.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/Knobs.h"
#include "flow/NetworkAddress.h"
#include "fdbrpc/FlowGrpc.h"
#include "flow/ObjectSerializer.h"
#include "flow/Platform.h"
#include "flow/ProtocolVersion.h"
#include "flow/SystemMonitor.h"
#include "flow/TDMetric.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/MetricLogger.actor.h"
#include "fdbserver/BackupInterface.h"
#include "fdbclient/EncryptKeyProxyInterface.h"
#include "fdbserver/RoleLineage.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/TesterInterface.actor.h" // for poisson()
#include "fdbserver/IDiskQueue.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbserver/DataDistributorInterface.h"
#include "fdbserver/FDBExecHelper.actor.h"
#include "fdbserver/CoordinationInterface.h"
#include "fdbserver/ConfigNode.h"
#include "fdbserver/LocalConfiguration.h"
#include "fdbserver/RemoteIKeyValueStore.actor.h"
#include "fdbclient/MonitorLeader.h"
#include "fdbclient/ClientWorkerInterface.h"
#include "flow/Profiler.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/Trace.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"
#include "flow/network.h"
#include "flow/serialize.h"
#include "flow/ChaosMetrics.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "fdbclient/ThreadSafeTransaction.h"
#include "flow/ApiVersion.h"
#include "fdbctl/ControlService.h"

#ifdef __linux__
#include <fcntl.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#endif
#if defined(__linux__) || defined(__FreeBSD__)
#ifdef USE_GPERFTOOLS
#include "gperftools/profiler.h"
#include "gperftools/heap-profiler.h"
#endif
#include <unistd.h>
#include <execinfo.h>
#endif
#include "flow/actorcompiler.h" // This must be the last #include.

#if CENABLED(0, NOT_IN_CLEAN)
extern IKeyValueStore* keyValueStoreCompressTestData(IKeyValueStore* store);
#define KV_STORE(filename, uid) keyValueStoreCompressTestData(keyValueStoreSQLite(filename, uid))
#elif CENABLED(0, NOT_IN_CLEAN)
#define KV_STORE(filename, uid) keyValueStoreSQLite(filename, uid)
#else
#define KV_STORE(filename, uid) keyValueStoreMemory(filename, uid)
#endif

template class RequestStream<RecruitMasterRequest, false>;
template struct NetNotifiedQueue<RecruitMasterRequest, false>;

template class RequestStream<InitializeCommitProxyRequest, false>;
template struct NetNotifiedQueue<InitializeCommitProxyRequest, false>;

template class RequestStream<InitializeGrvProxyRequest, false>;
template struct NetNotifiedQueue<InitializeGrvProxyRequest, false>;

template class RequestStream<GetServerDBInfoRequest, false>;
template struct NetNotifiedQueue<GetServerDBInfoRequest, false>;
template class GetEncryptCipherKeys<ServerDBInfo>;

namespace {
RoleLineageCollector roleLineageCollector;
}

															#line 127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via tryDBInfoBroadcast()
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class TryDBInfoBroadcastActor>
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class TryDBInfoBroadcastActorState {
															#line 134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	TryDBInfoBroadcastActorState(RequestStream<UpdateServerDBInfoRequest> const& stream,UpdateServerDBInfoRequest const& req) 
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : stream(stream),
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   req(req)
															#line 143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this));

	}
	~TryDBInfoBroadcastActorState() 
	{
		fdb_probe_actor_destroy("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<std::vector<Endpoint>>> __when_expr_0 = stream.getReplyUnlessFailedFor(req, SERVER_KNOBS->DBINFO_FAILED_DELAY, 0);
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state = 1;
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*>(static_cast<TryDBInfoBroadcastActor*>(this)));
															#line 165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryDBInfoBroadcastActorState();
		static_cast<TryDBInfoBroadcastActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<std::vector<Endpoint>> const& rep,int loopDepth) 
	{
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (rep.present())
															#line 188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(rep.get()); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(rep.get());
			this->~TryDBInfoBroadcastActorState();
			static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.broadcastInfo.push_back(stream.getEndpoint());
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(req.broadcastInfo); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(req.broadcastInfo);
		this->~TryDBInfoBroadcastActorState();
		static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<std::vector<Endpoint>> && rep,int loopDepth) 
	{
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (rep.present())
															#line 214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(rep.get()); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(rep.get());
			this->~TryDBInfoBroadcastActorState();
			static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.broadcastInfo.push_back(stream.getEndpoint());
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(req.broadcastInfo); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(req.broadcastInfo);
		this->~TryDBInfoBroadcastActorState();
		static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<std::vector<Endpoint>> const& rep,int loopDepth) 
	{
		loopDepth = a_body1cont1(rep, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<std::vector<Endpoint>> && rep,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state > 0) static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state = 0;
		static_cast<TryDBInfoBroadcastActor*>(this)->ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >::remove();

	}
	void a_callback_fire(ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*,ErrorOr<std::vector<Endpoint>> const& value) 
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*,ErrorOr<std::vector<Endpoint>> && value) 
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*,Error err) 
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	RequestStream<UpdateServerDBInfoRequest> stream;
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UpdateServerDBInfoRequest req;
															#line 315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via tryDBInfoBroadcast()
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class TryDBInfoBroadcastActor final : public Actor<std::vector<Endpoint>>, public ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >, public FastAllocated<TryDBInfoBroadcastActor>, public TryDBInfoBroadcastActorState<TryDBInfoBroadcastActor> {
															#line 320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<TryDBInfoBroadcastActor>::operator new;
	using FastAllocated<TryDBInfoBroadcastActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8708202195936239104UL, 8478222946157044736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<Endpoint>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >;
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	TryDBInfoBroadcastActor(RequestStream<UpdateServerDBInfoRequest> const& stream,UpdateServerDBInfoRequest const& req) 
															#line 337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<std::vector<Endpoint>>(),
		   TryDBInfoBroadcastActorState<TryDBInfoBroadcastActor>(stream, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4829059694717746176UL, 12815649290741346816UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryDBInfoBroadcast");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<std::vector<Endpoint>> tryDBInfoBroadcast( RequestStream<UpdateServerDBInfoRequest> const& stream, UpdateServerDBInfoRequest const& req ) {
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<std::vector<Endpoint>>(new TryDBInfoBroadcastActor(stream, req));
															#line 370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 135 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

															#line 375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via broadcastDBInfoRequest()
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class BroadcastDBInfoRequestActor>
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class BroadcastDBInfoRequestActorState {
															#line 382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	BroadcastDBInfoRequestActorState(UpdateServerDBInfoRequest const& req,int const& sendAmount,Optional<Endpoint> const& sender,bool const& sendReply) 
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : req(req),
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   sendAmount(sendAmount),
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   sender(sender),
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   sendReply(sendReply),
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   replies(),
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   reply(req.reply)
															#line 399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this));

	}
	~BroadcastDBInfoRequestActorState() 
	{
		fdb_probe_actor_destroy("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			resetReply(req);
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			int currentStream = 0;
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::vector<Endpoint> broadcastEndpoints = req.broadcastInfo;
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			for(int i = 0;i < sendAmount && currentStream < broadcastEndpoints.size();i++) {
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				std::vector<Endpoint> endpoints;
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				RequestStream<UpdateServerDBInfoRequest> cur(broadcastEndpoints[currentStream++]);
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				for(;currentStream < broadcastEndpoints.size() * (i + 1) / sendAmount;) {
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					endpoints.push_back(broadcastEndpoints[currentStream++]);
															#line 428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				req.broadcastInfo = endpoints;
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				replies.push_back(tryDBInfoBroadcast(cur, req));
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				resetReply(req);
															#line 436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(replies);
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state = 1;
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*>(static_cast<BroadcastDBInfoRequestActor*>(this)));
															#line 447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BroadcastDBInfoRequestActorState();
		static_cast<BroadcastDBInfoRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::vector<Endpoint> notUpdated;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (sender.present())
															#line 472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.push_back(sender.get());
															#line 476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& it : replies ) {
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.insert(notUpdated.end(), it.get().begin(), it.get().end());
															#line 482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (sendReply)
															#line 486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			reply.send(notUpdated);
															#line 490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<BroadcastDBInfoRequestActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(notUpdated); this->~BroadcastDBInfoRequestActorState(); static_cast<BroadcastDBInfoRequestActor*>(this)->destroy(); return 0; }
															#line 494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<BroadcastDBInfoRequestActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(notUpdated);
		this->~BroadcastDBInfoRequestActorState();
		static_cast<BroadcastDBInfoRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::vector<Endpoint> notUpdated;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (sender.present())
															#line 508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.push_back(sender.get());
															#line 512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& it : replies ) {
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.insert(notUpdated.end(), it.get().begin(), it.get().end());
															#line 518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (sendReply)
															#line 522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			reply.send(notUpdated);
															#line 526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<BroadcastDBInfoRequestActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(notUpdated); this->~BroadcastDBInfoRequestActorState(); static_cast<BroadcastDBInfoRequestActor*>(this)->destroy(); return 0; }
															#line 530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<BroadcastDBInfoRequestActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(notUpdated);
		this->~BroadcastDBInfoRequestActorState();
		static_cast<BroadcastDBInfoRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state > 0) static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state = 0;
		static_cast<BroadcastDBInfoRequestActor*>(this)->ActorCallback< BroadcastDBInfoRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UpdateServerDBInfoRequest req;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	int sendAmount;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Optional<Endpoint> sender;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	bool sendReply;
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<Future<std::vector<Endpoint>>> replies;
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ReplyPromise<std::vector<Endpoint>> reply;
															#line 625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via broadcastDBInfoRequest()
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class BroadcastDBInfoRequestActor final : public Actor<std::vector<Endpoint>>, public ActorCallback< BroadcastDBInfoRequestActor, 0, Void >, public FastAllocated<BroadcastDBInfoRequestActor>, public BroadcastDBInfoRequestActorState<BroadcastDBInfoRequestActor> {
															#line 630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<BroadcastDBInfoRequestActor>::operator new;
	using FastAllocated<BroadcastDBInfoRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16432942446221001984UL, 2736125387540138240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<Endpoint>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BroadcastDBInfoRequestActor, 0, Void >;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	BroadcastDBInfoRequestActor(UpdateServerDBInfoRequest const& req,int const& sendAmount,Optional<Endpoint> const& sender,bool const& sendReply) 
															#line 647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<std::vector<Endpoint>>(),
		   BroadcastDBInfoRequestActorState<BroadcastDBInfoRequestActor>(req, sendAmount, sender, sendReply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7360236551166211584UL, 3807311166382409728UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("broadcastDBInfoRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<std::vector<Endpoint>> broadcastDBInfoRequest( UpdateServerDBInfoRequest const& req, int const& sendAmount, Optional<Endpoint> const& sender, bool const& sendReply ) {
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<std::vector<Endpoint>>(new BroadcastDBInfoRequestActor(req, sendAmount, sender, sendReply));
															#line 680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 168 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

															#line 685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via extractClientInfo()
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class ExtractClientInfoActor>
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class ExtractClientInfoActorState {
															#line 692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ExtractClientInfoActorState(Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<ClientDBInfo>> const& info) 
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : db(db),
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   info(info),
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   lastCommitProxyUIDs(),
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   lastCommitProxies(),
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   lastGrvProxyUIDs(),
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   lastGrvProxies()
															#line 709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("extractClientInfo", reinterpret_cast<unsigned long>(this));

	}
	~ExtractClientInfoActorState() 
	{
		fdb_probe_actor_destroy("extractClientInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExtractClientInfoActorState();
		static_cast<ExtractClientInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		ClientDBInfo ni = db->get().client;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		shrinkProxyList(ni, lastCommitProxyUIDs, lastCommitProxies, lastGrvProxyUIDs, lastGrvProxies);
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		info->setUnconditional(ni);
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<ExtractClientInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ExtractClientInfoActor*>(this)->actor_wait_state = 1;
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExtractClientInfoActor, 0, Void >*>(static_cast<ExtractClientInfoActor*>(this)));
															#line 767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExtractClientInfoActor*>(this)->actor_wait_state > 0) static_cast<ExtractClientInfoActor*>(this)->actor_wait_state = 0;
		static_cast<ExtractClientInfoActor*>(this)->ActorCallback< ExtractClientInfoActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExtractClientInfoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExtractClientInfoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExtractClientInfoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ClientDBInfo>> info;
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<UID> lastCommitProxyUIDs;
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<CommitProxyInterface> lastCommitProxies;
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<UID> lastGrvProxyUIDs;
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<GrvProxyInterface> lastGrvProxies;
															#line 871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via extractClientInfo()
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class ExtractClientInfoActor final : public Actor<Void>, public ActorCallback< ExtractClientInfoActor, 0, Void >, public FastAllocated<ExtractClientInfoActor>, public ExtractClientInfoActorState<ExtractClientInfoActor> {
															#line 876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<ExtractClientInfoActor>::operator new;
	using FastAllocated<ExtractClientInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10227962490980594688UL, 10593191714652420608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExtractClientInfoActor, 0, Void >;
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ExtractClientInfoActor(Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<ClientDBInfo>> const& info) 
															#line 893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   ExtractClientInfoActorState<ExtractClientInfoActor>(db, info),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(936284430390917120UL, 5465665005456452352UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("extractClientInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExtractClientInfoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] static Future<Void> extractClientInfo( Reference<AsyncVar<ServerDBInfo> const> const& db, Reference<AsyncVar<ClientDBInfo>> const& info ) {
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ExtractClientInfoActor(db, info));
															#line 926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 182 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

Database openDBOnServer(Reference<AsyncVar<ServerDBInfo> const> const& db,
                        TaskPriority taskID,
                        LockAware lockAware,
                        EnableLocalityLoadBalance enableLocalityLoadBalance) {
	auto info = makeReference<AsyncVar<ClientDBInfo>>();
	auto cx = DatabaseContext::create(info,
	                                  extractClientInfo(db, info),
	                                  enableLocalityLoadBalance ? db->get().myLocality : LocalityData(),
	                                  enableLocalityLoadBalance,
	                                  taskID,
	                                  lockAware);
	cx->globalConfig->init(db, std::addressof(db->get().client));
	cx->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
	cx->globalConfig->trigger(samplingWindow, samplingProfilerUpdateWindow);
	return cx;
}

struct ErrorInfo {
	Error error;
	const Role& role;
	UID id;
	ErrorInfo(Error e, const Role& role, UID id) : error(e), role(role), id(id) {}
	template <class Ar>
	void serialize(Ar&) {
		ASSERT(false);
	}
};

Error checkIOTimeout(Error const& e) {
	// Convert all_errors to io_timeout if global timeout bool was set
	bool timeoutOccurred = (bool)g_network->global(INetwork::enASIOTimedOut);
	// In simulation, have to check global timed out flag for both this process and the machine process on which IO is
	// done
	if (g_network->isSimulated() && !timeoutOccurred)
		timeoutOccurred = g_simulator->getCurrentProcess()->machine->machineProcess->global(INetwork::enASIOTimedOut);

	if (timeoutOccurred) {
		CODE_PROBE(true, "Timeout occurred");
		Error timeout = io_timeout();
		// Preserve injectedness of error
		if (e.isInjectedFault())
			timeout = timeout.asInjectedFault();
		return timeout;
	}
	return e;
}

															#line 978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via forwardError()
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class ForwardErrorActor>
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class ForwardErrorActorState {
															#line 985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ForwardErrorActorState(PromiseStream<ErrorInfo> const& errors,Role const& role,UID const& id,Future<Void> const& process) 
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : errors(errors),
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   role(role),
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   id(id),
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   process(process)
															#line 998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("forwardError", reinterpret_cast<unsigned long>(this));

	}
	~ForwardErrorActorState() 
	{
		fdb_probe_actor_destroy("forwardError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = process;
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<ForwardErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ForwardErrorActor*>(this)->actor_wait_state = 1;
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardErrorActor, 0, Void >*>(static_cast<ForwardErrorActor*>(this)));
															#line 1021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ForwardErrorActorState();
		static_cast<ForwardErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errors.send(ErrorInfo(e, role, id));
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<ForwardErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ForwardErrorActorState(); static_cast<ForwardErrorActor*>(this)->destroy(); return 0; }
															#line 1053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			new (&static_cast<ForwardErrorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ForwardErrorActorState();
			static_cast<ForwardErrorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errors.send(ErrorInfo(success(), role, id));
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<ForwardErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ForwardErrorActorState(); static_cast<ForwardErrorActor*>(this)->destroy(); return 0; }
															#line 1073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<ForwardErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ForwardErrorActorState();
		static_cast<ForwardErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errors.send(ErrorInfo(success(), role, id));
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<ForwardErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ForwardErrorActorState(); static_cast<ForwardErrorActor*>(this)->destroy(); return 0; }
															#line 1087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<ForwardErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ForwardErrorActorState();
		static_cast<ForwardErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardErrorActor*>(this)->actor_wait_state > 0) static_cast<ForwardErrorActor*>(this)->actor_wait_state = 0;
		static_cast<ForwardErrorActor*>(this)->ActorCallback< ForwardErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	PromiseStream<ErrorInfo> errors;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Role role;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> process;
															#line 1178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via forwardError()
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class ForwardErrorActor final : public Actor<Void>, public ActorCallback< ForwardErrorActor, 0, Void >, public FastAllocated<ForwardErrorActor>, public ForwardErrorActorState<ForwardErrorActor> {
															#line 1183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<ForwardErrorActor>::operator new;
	using FastAllocated<ForwardErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17482685409193372416UL, 1985274814640530176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardErrorActor, 0, Void >;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ForwardErrorActor(PromiseStream<ErrorInfo> const& errors,Role const& role,UID const& id,Future<Void> const& process) 
															#line 1200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   ForwardErrorActorState<ForwardErrorActor>(errors, role, id, process),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1301226801814355968UL, 15803518444079550976UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ForwardErrorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> forwardError( PromiseStream<ErrorInfo> const& errors, Role const& role, UID const& id, Future<Void> const& process ) {
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ForwardErrorActor(errors, role, id, process));
															#line 1233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 240 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

															#line 1238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via handleIOErrors()
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class HandleIOErrorsActor>
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class HandleIOErrorsActorState {
															#line 1245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	HandleIOErrorsActorState(Future<Void> const& actor,Future<ErrorOr<Void>> const& storeError,UID const& id,Future<Void> const& onClosed = Void()) 
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : actor(actor),
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   storeError(storeError),
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   id(id),
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   onClosed(onClosed)
															#line 1258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("handleIOErrors", reinterpret_cast<unsigned long>(this));

	}
	~HandleIOErrorsActorState() 
	{
		fdb_probe_actor_destroy("handleIOErrors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<Void>> __when_expr_0 = errorOr(actor);
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<Void>> __when_expr_1 = storeError;
															#line 1279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 1;
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleIOErrorsActorState();
		static_cast<HandleIOErrorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<Void> const& __e,int loopDepth) 
	{
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e = __e;
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError() && e.getError().code() == error_code_please_reboot)
															#line 1311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
			loopDepth = a_body1when1cont1(loopDepth);
		}
		else
		{
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = onClosed;
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when1when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 2;
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 2, Void >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(ErrorOr<Void> && __e,int loopDepth) 
	{
		e = std::move(__e);
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError() && e.getError().code() == error_code_please_reboot)
															#line 1337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
			loopDepth = a_body1when1cont1(loopDepth);
		}
		else
		{
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = onClosed;
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when1when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 2;
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 2, Void >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when2(ErrorOr<Void> const& e,int loopDepth) 
	{
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerTerminatingByIOError", id).errorUnsuppressed(e.getError());
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		actor.cancel();
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_file_not_found)
															#line 1366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker terminated with file_not_found error");
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<HandleIOErrorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleIOErrorsActorState(); static_cast<HandleIOErrorsActor*>(this)->destroy(); return 0; }
															#line 1372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			new (&static_cast<HandleIOErrorsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~HandleIOErrorsActorState();
			static_cast<HandleIOErrorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() == error_code_lock_file_failure)
															#line 1382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Unable to lock file", probe::context::net2, probe::assert::noSim);
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(please_reboot_kv_store(), loopDepth);
															#line 1388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		return a_body1Catch1(e.getError(), loopDepth);
															#line 1393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"

		return loopDepth;
	}
	int a_body1when2(ErrorOr<Void> && e,int loopDepth) 
	{
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerTerminatingByIOError", id).errorUnsuppressed(e.getError());
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		actor.cancel();
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_file_not_found)
															#line 1405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker terminated with file_not_found error");
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<HandleIOErrorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleIOErrorsActorState(); static_cast<HandleIOErrorsActor*>(this)->destroy(); return 0; }
															#line 1411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			new (&static_cast<HandleIOErrorsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~HandleIOErrorsActorState();
			static_cast<HandleIOErrorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() == error_code_lock_file_failure)
															#line 1421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Unable to lock file", probe::context::net2, probe::assert::noSim);
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(please_reboot_kv_store(), loopDepth);
															#line 1427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		return a_body1Catch1(e.getError(), loopDepth);
															#line 1432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state > 0) static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >::remove();
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >::remove();

	}
	int a_body1when1cont1(int loopDepth) 
	{
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError() && e.getError().code() == error_code_broken_promise && !storeError.isReady())
															#line 1447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(0.00001 + FLOW_KNOBS->MAX_BUGGIFIED_DELAY);
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when1cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 3;
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 3, Void >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1when1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state > 0) static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1when1cont3(int loopDepth) 
	{
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (storeError.isReady() && storeError.isError() && storeError.getError().code() != error_code_file_not_found)
															#line 1559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(storeError.get().getError(), loopDepth);
															#line 1563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError())
															#line 1567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(e.getError(), loopDepth);
															#line 1571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<HandleIOErrorsActor*>(this)->SAV<Void>::futures) { (void)(e.get()); this->~HandleIOErrorsActorState(); static_cast<HandleIOErrorsActor*>(this)->destroy(); return 0; }
															#line 1577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			new (&static_cast<HandleIOErrorsActor*>(this)->SAV< Void >::value()) Void(e.get());
			this->~HandleIOErrorsActorState();
			static_cast<HandleIOErrorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state > 0) static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> actor;
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<ErrorOr<Void>> storeError;
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> onClosed;
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ErrorOr<Void> e;
															#line 1797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via handleIOErrors()
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class HandleIOErrorsActor final : public Actor<Void>, public ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >, public ActorCallback< HandleIOErrorsActor, 2, Void >, public ActorCallback< HandleIOErrorsActor, 3, Void >, public ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >, public FastAllocated<HandleIOErrorsActor>, public HandleIOErrorsActorState<HandleIOErrorsActor> {
															#line 1802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<HandleIOErrorsActor>::operator new;
	using FastAllocated<HandleIOErrorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2621537857796014592UL, 8536930481688946432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >;
friend struct ActorCallback< HandleIOErrorsActor, 2, Void >;
friend struct ActorCallback< HandleIOErrorsActor, 3, Void >;
friend struct ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >;
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	HandleIOErrorsActor(Future<Void> const& actor,Future<ErrorOr<Void>> const& storeError,UID const& id,Future<Void> const& onClosed = Void()) 
															#line 1822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   HandleIOErrorsActorState<HandleIOErrorsActor>(actor, storeError, id, onClosed),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6206421713096993792UL, 16845784795105158144UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleIOErrors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleIOErrorsActor, 2, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< HandleIOErrorsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> handleIOErrors( Future<Void> const& actor, Future<ErrorOr<Void>> const& storeError, UID const& id, Future<Void> const& onClosed = Void() ) {
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new HandleIOErrorsActor(actor, storeError, id, onClosed));
															#line 1857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 280 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

Future<Void> handleIOErrors(Future<Void> actor, IClosable* store, UID id, Future<Void> onClosed = Void()) {
	Future<ErrorOr<Void>> storeError = actor.isReady() ? Never() : errorOr(store->getError());
	return handleIOErrors(actor, storeError, id, onClosed);
}

Future<Void> deregisterGrpcService(const UID& id) {
#ifdef FLOW_GRPC_ENABLED
	if (g_network->isSimulated()) {
		return Void();
	}

	if (GrpcServer::instance() != nullptr) {
		return GrpcServer::instance()->deregisterRoleServices(id);
	}
#endif
	return Void();
}

															#line 1880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via workerHandleErrors()
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class WorkerHandleErrorsActor>
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class WorkerHandleErrorsActorState {
															#line 1887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	WorkerHandleErrorsActorState(FutureStream<ErrorInfo> const& errors) 
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : errors(errors)
															#line 1894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("workerHandleErrors", reinterpret_cast<unsigned long>(this));

	}
	~WorkerHandleErrorsActorState() 
	{
		fdb_probe_actor_destroy("workerHandleErrors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 1909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerHandleErrorsActorState();
		static_cast<WorkerHandleErrorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_0 = errors;
															#line 1939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<ErrorInfo>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<ErrorInfo>>::value, "invalid type");
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state = 1;
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*>(static_cast<WorkerHandleErrorsActor*>(this)));
															#line 1948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorInfo const& _err,int loopDepth) 
	{
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		ErrorInfo err = _err;
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		bool ok = err.error.code() == error_code_success || err.error.code() == error_code_please_reboot || err.error.code() == error_code_actor_cancelled || err.error.code() == error_code_remote_kvs_cancelled || err.error.code() == error_code_coordinators_changed || err.error.code() == error_code_shutdown_in_progress;
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!ok)
															#line 1967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			err.error = checkIOTimeout(err.error);
															#line 1971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		endRole(err.role, err.id, "Error", ok, err.error);
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		rethrow = std::nullopt;
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (err.error.code() == error_code_please_reboot || (err.role == Role::SHARED_TRANSACTION_LOG && (err.error.code() == error_code_io_error || err.error.code() == error_code_io_timeout)) || (SERVER_KNOBS->STORAGE_SERVER_REBOOT_ON_IO_TIMEOUT && err.role == Role::STORAGE_SERVER && err.error.code() == error_code_io_timeout))
															#line 1979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			rethrow = err.error;
															#line 1983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (rethrow != std::nullopt)
															#line 1987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(*rethrow, std::max(0, loopDepth - 1));
															#line 1991 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorInfo && _err,int loopDepth) 
	{
															#line 302 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		ErrorInfo err = _err;
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		bool ok = err.error.code() == error_code_success || err.error.code() == error_code_please_reboot || err.error.code() == error_code_actor_cancelled || err.error.code() == error_code_remote_kvs_cancelled || err.error.code() == error_code_coordinators_changed || err.error.code() == error_code_shutdown_in_progress;
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!ok)
															#line 2005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			err.error = checkIOTimeout(err.error);
															#line 2009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		endRole(err.role, err.id, "Error", ok, err.error);
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		rethrow = std::nullopt;
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (err.error.code() == error_code_please_reboot || (err.role == Role::SHARED_TRANSACTION_LOG && (err.error.code() == error_code_io_error || err.error.code() == error_code_io_timeout)) || (SERVER_KNOBS->STORAGE_SERVER_REBOOT_ON_IO_TIMEOUT && err.role == Role::STORAGE_SERVER && err.error.code() == error_code_io_timeout))
															#line 2017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			rethrow = err.error;
															#line 2021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (rethrow != std::nullopt)
															#line 2025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(*rethrow, std::max(0, loopDepth - 1));
															#line 2029 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state > 0) static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerHandleErrorsActor*>(this)->ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >::remove();

	}
	void a_callback_fire(ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*,ErrorInfo const& value) 
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*,ErrorInfo && value) 
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*,Error err) 
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	FutureStream<ErrorInfo> errors;
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::optional<Error> rethrow;
															#line 2102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via workerHandleErrors()
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class WorkerHandleErrorsActor final : public Actor<Void>, public ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >, public FastAllocated<WorkerHandleErrorsActor>, public WorkerHandleErrorsActorState<WorkerHandleErrorsActor> {
															#line 2107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<WorkerHandleErrorsActor>::operator new;
	using FastAllocated<WorkerHandleErrorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4143770223203848960UL, 13614178851380664832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >;
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	WorkerHandleErrorsActor(FutureStream<ErrorInfo> const& errors) 
															#line 2124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   WorkerHandleErrorsActorState<WorkerHandleErrorsActor>(errors),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8795450729902019072UL, 3187225731259694336UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerHandleErrors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> workerHandleErrors( FutureStream<ErrorInfo> const& errors ) {
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new WorkerHandleErrorsActor(errors));
															#line 2157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 330 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

// Improve simulation code coverage by sometimes deferring the destruction of workerInterface (and therefore "endpoint
// not found" responses to clients
//		for an extra second, so that clients are more likely to see broken_promise errors
															#line 2165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via zombie()
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class T, class ZombieActor>
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class ZombieActorState {
															#line 2172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ZombieActorState(T const& workerInterface,Future<Void> const& worker) 
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : workerInterface(workerInterface),
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   worker(worker)
															#line 2181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("zombie", reinterpret_cast<unsigned long>(this));

	}
	~ZombieActorState() 
	{
		fdb_probe_actor_destroy("zombie", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = worker;
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<ZombieActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ZombieActor*>(this)->actor_wait_state = 1;
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ZombieActor, 0, Void >*>(static_cast<ZombieActor*>(this)));
															#line 2204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ZombieActorState();
		static_cast<ZombieActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (BUGGIFY)
															#line 2248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<ZombieActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2254 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ZombieActor*>(this)->actor_wait_state = 2;
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ZombieActor, 1, Void >*>(static_cast<ZombieActor*>(this)));
															#line 2259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (BUGGIFY)
															#line 2273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<ZombieActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ZombieActor*>(this)->actor_wait_state = 2;
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ZombieActor, 1, Void >*>(static_cast<ZombieActor*>(this)));
															#line 2284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ZombieActor*>(this)->actor_wait_state > 0) static_cast<ZombieActor*>(this)->actor_wait_state = 0;
		static_cast<ZombieActor*>(this)->ActorCallback< ZombieActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ZombieActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ZombieActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ZombieActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<ZombieActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ZombieActorState(); static_cast<ZombieActor*>(this)->destroy(); return 0; }
															#line 2373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<ZombieActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ZombieActorState();
		static_cast<ZombieActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ZombieActor*>(this)->actor_wait_state > 0) static_cast<ZombieActor*>(this)->actor_wait_state = 0;
		static_cast<ZombieActor*>(this)->ActorCallback< ZombieActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ZombieActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ZombieActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ZombieActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	T workerInterface;
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> worker;
															#line 2472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via zombie()
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class T>
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class ZombieActor final : public Actor<Void>, public ActorCallback< ZombieActor<T>, 0, Void >, public ActorCallback< ZombieActor<T>, 1, Void >, public FastAllocated<ZombieActor<T>>, public ZombieActorState<T, ZombieActor<T>> {
															#line 2479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<ZombieActor<T>>::operator new;
	using FastAllocated<ZombieActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12085174183648025856UL, 15516143831108862720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ZombieActor<T>, 0, Void >;
friend struct ActorCallback< ZombieActor<T>, 1, Void >;
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ZombieActor(T const& workerInterface,Future<Void> const& worker) 
															#line 2497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   ZombieActorState<T, ZombieActor<T>>(workerInterface, worker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17103515626195448064UL, 1853427329179145472UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("zombie");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ZombieActor<T>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ZombieActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class T>
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> zombie( T const& workerInterface, Future<Void> const& worker ) {
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ZombieActor<T>(workerInterface, worker));
															#line 2533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 345 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

															#line 2538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via loadedPonger()
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class LoadedPongerActor>
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class LoadedPongerActorState {
															#line 2545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	LoadedPongerActorState(FutureStream<LoadedPingRequest> const& pings) 
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : pings(pings),
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   payloadBack(std::string(20480, '.'))
															#line 2554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("loadedPonger", reinterpret_cast<unsigned long>(this));

	}
	~LoadedPongerActorState() 
	{
		fdb_probe_actor_destroy("loadedPonger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 2569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadedPongerActorState();
		static_cast<LoadedPongerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_0 = pings;
															#line 2599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<LoadedPingRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<LoadedPingRequest>>::value, "invalid type");
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<LoadedPongerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<LoadedPongerActor*>(this)->actor_wait_state = 1;
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*>(static_cast<LoadedPongerActor*>(this)));
															#line 2608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(LoadedPingRequest const& pong,int loopDepth) 
	{
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LoadedReply rep;
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		rep.payload = (pong.loadReply ? payloadBack : ""_sr);
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		rep.id = pong.id;
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		pong.reply.send(rep);
															#line 2623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(LoadedPingRequest && pong,int loopDepth) 
	{
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LoadedReply rep;
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		rep.payload = (pong.loadReply ? payloadBack : ""_sr);
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		rep.id = pong.id;
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		pong.reply.send(rep);
															#line 2638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(LoadedPingRequest const& pong,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(pong, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(LoadedPingRequest && pong,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(pong), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadedPongerActor*>(this)->actor_wait_state > 0) static_cast<LoadedPongerActor*>(this)->actor_wait_state = 0;
		static_cast<LoadedPongerActor*>(this)->ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*,LoadedPingRequest const& value) 
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*,LoadedPingRequest && value) 
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*,Error err) 
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	FutureStream<LoadedPingRequest> pings;
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Standalone<StringRef> payloadBack;
															#line 2722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via loadedPonger()
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class LoadedPongerActor final : public Actor<Void>, public ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >, public FastAllocated<LoadedPongerActor>, public LoadedPongerActorState<LoadedPongerActor> {
															#line 2727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<LoadedPongerActor>::operator new;
	using FastAllocated<LoadedPongerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7980341225948807168UL, 3540455611509703168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >;
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	LoadedPongerActor(FutureStream<LoadedPingRequest> const& pings) 
															#line 2744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   LoadedPongerActorState<LoadedPongerActor>(pings),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17672933219176974592UL, 1478809613757852416UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadedPonger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> loadedPonger( FutureStream<LoadedPingRequest> const& pings ) {
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new LoadedPongerActor(pings));
															#line 2777 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 357 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

StringRef fileStoragePrefix = "storage-"_sr;
StringRef testingStoragePrefix = "testingstorage-"_sr;
StringRef fileLogDataPrefix = "log-"_sr;
StringRef fileVersionedLogDataPrefix = "log2-"_sr;
StringRef fileLogQueuePrefix = "logqueue-"_sr;
StringRef tlogQueueExtension = "fdq"_sr;

enum class FilesystemCheck {
	FILES_ONLY,
	DIRECTORIES_ONLY,
	FILES_AND_DIRECTORIES,
};

struct KeyValueStoreSuffix {
	KeyValueStoreType type;
	std::string suffix;
	FilesystemCheck check;
};

KeyValueStoreSuffix bTreeV1Suffix = { KeyValueStoreType::SSD_BTREE_V1, ".fdb", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix bTreeV2Suffix = { KeyValueStoreType::SSD_BTREE_V2, ".sqlite", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix memorySuffix = { KeyValueStoreType::MEMORY, "-0.fdq", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix memoryRTSuffix = { KeyValueStoreType::MEMORY_RADIXTREE, "-0.fdr", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix redwoodSuffix = { KeyValueStoreType::SSD_REDWOOD_V1, ".redwood-v1", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix rocksdbSuffix = { KeyValueStoreType::SSD_ROCKSDB_V1,
	                                  ".rocksdb",
	                                  FilesystemCheck::DIRECTORIES_ONLY };
KeyValueStoreSuffix shardedRocksdbSuffix = { KeyValueStoreType::SSD_SHARDED_ROCKSDB,
	                                         ".shardedrocksdb",
	                                         FilesystemCheck::DIRECTORIES_ONLY };

std::string validationFilename = "_validate";

std::string filenameFromSample(KeyValueStoreType storeType, std::string folder, std::string sample_filename) {
	switch (storeType.storeType()) {
	case KeyValueStoreType::SSD_BTREE_V1:
	case KeyValueStoreType::SSD_BTREE_V2:
	case KeyValueStoreType::SSD_REDWOOD_V1:
	case KeyValueStoreType::SSD_ROCKSDB_V1:
	case KeyValueStoreType::SSD_SHARDED_ROCKSDB:
		return joinPath(folder, sample_filename);

	case KeyValueStoreType::MEMORY:
	case KeyValueStoreType::MEMORY_RADIXTREE:
		return joinPath(folder, sample_filename.substr(0, sample_filename.size() - 5));

	default:
		UNREACHABLE();
	}
}

std::string filenameFromId(KeyValueStoreType storeType, std::string folder, std::string prefix, UID id) {

	if (storeType == KeyValueStoreType::SSD_BTREE_V1)
		return joinPath(folder, prefix + id.toString() + ".fdb");
	else if (storeType == KeyValueStoreType::SSD_BTREE_V2)
		return joinPath(folder, prefix + id.toString() + ".sqlite");
	else if (storeType == KeyValueStoreType::MEMORY || storeType == KeyValueStoreType::MEMORY_RADIXTREE)
		return joinPath(folder, prefix + id.toString() + "-");
	else if (storeType == KeyValueStoreType::SSD_REDWOOD_V1)
		return joinPath(folder, prefix + id.toString() + ".redwood-v1");
	else if (storeType == KeyValueStoreType::SSD_ROCKSDB_V1)
		return joinPath(folder, prefix + id.toString() + ".rocksdb");
	else if (storeType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
		return joinPath(folder, prefix + id.toString() + ".shardedrocksdb");

	TraceEvent(SevError, "UnknownStoreType").detail("StoreType", storeType.toString());
	UNREACHABLE();
}

struct TLogOptions {
	TLogOptions() = default;
	TLogOptions(TLogVersion v, TLogSpillType s) : version(v), spillType(s) {}

	TLogVersion version = TLogVersion::DEFAULT;
	TLogSpillType spillType = TLogSpillType::UNSET;

	static ErrorOr<TLogOptions> FromStringRef(StringRef s) {
		TLogOptions options;
		for (StringRef key = s.eat("_"), value = s.eat("_"); s.size() != 0 || key.size();
		     key = s.eat("_"), value = s.eat("_")) {
			if (key.size() != 0 && value.size() == 0)
				return default_error_or();

			if (key == "V"_sr) {
				ErrorOr<TLogVersion> tLogVersion = TLogVersion::FromStringRef(value);
				if (tLogVersion.isError())
					return tLogVersion.getError();
				options.version = tLogVersion.get();
			} else if (key == "LS"_sr) {
				ErrorOr<TLogSpillType> tLogSpillType = TLogSpillType::FromStringRef(value);
				if (tLogSpillType.isError())
					return tLogSpillType.getError();
				options.spillType = tLogSpillType.get();
			} else {
				return default_error_or();
			}
		}
		return options;
	}

	bool operator==(const TLogOptions& o) {
		return version == o.version && (spillType == o.spillType || version >= TLogVersion::V5);
	}

	std::string toPrefix() const {
		std::string toReturn = "";
		switch (version) {
		case TLogVersion::UNSET:
			ASSERT(false);
		case TLogVersion::V2:
			return "";
		case TLogVersion::V3:
		case TLogVersion::V4:
			toReturn =
			    "V_" + boost::lexical_cast<std::string>(version) + "_LS_" + boost::lexical_cast<std::string>(spillType);
			break;
		case TLogVersion::V5:
		case TLogVersion::V6:
		case TLogVersion::V7:
			toReturn = "V_" + boost::lexical_cast<std::string>(version);
			break;
		}
		ASSERT_WE_THINK(FromStringRef(toReturn).get() == *this);
		return toReturn + "-";
	}

	DiskQueueVersion getDiskQueueVersion() const {
		if (version < TLogVersion::V3) {
			ASSERT(false); // no longer supported
			return DiskQueueVersion::V0;
		}
		if (version < TLogVersion::V7)
			return DiskQueueVersion::V1;
		return DiskQueueVersion::V2;
	}
};

TLogFn tLogFnForOptions(TLogOptions options) {
	switch (options.version) {
	case TLogVersion::V2:
	case TLogVersion::V3:
	case TLogVersion::V4:
		ASSERT(false); // V2 to V4 are no longer supported

	case TLogVersion::V5:
	case TLogVersion::V6:
	case TLogVersion::V7:
		return tLog;
	default:
		ASSERT(false);
	}
	return tLog;
}

struct DiskStore {
	enum COMPONENT { TLogData, Storage, BlobWorker, UNSET };

	UID storeID = UID();
	std::string filename = ""; // For KVStoreMemory just the base filename to be passed to IDiskQueue
	COMPONENT storedComponent = UNSET;
	KeyValueStoreType storeType = KeyValueStoreType::END;
	TLogOptions tLogOptions;
};

std::vector<DiskStore> getDiskStores(std::string folder,
                                     std::string suffix,
                                     KeyValueStoreType type,
                                     FilesystemCheck check) {
	std::vector<DiskStore> result;
	std::vector<std::string> files;

	if (check == FilesystemCheck::FILES_ONLY || check == FilesystemCheck::FILES_AND_DIRECTORIES) {
		files = platform::listFiles(folder, suffix);
	}
	if (check == FilesystemCheck::DIRECTORIES_ONLY || check == FilesystemCheck::FILES_AND_DIRECTORIES) {
		for (const auto& directory : platform::listDirectories(folder)) {
			if (StringRef(directory).endsWith(suffix)) {
				files.push_back(directory);
			}
		}
	}

	for (int idx = 0; idx < files.size(); idx++) {
		DiskStore store;
		store.storeType = type;

		StringRef filename = StringRef(files[idx]);
		Standalone<StringRef> prefix;
		if (filename.startsWith(fileStoragePrefix)) {
			store.storedComponent = DiskStore::Storage;
			prefix = fileStoragePrefix;
		} else if (filename.startsWith(testingStoragePrefix)) {
			store.storedComponent = DiskStore::Storage;
			prefix = testingStoragePrefix;
		} else if (filename.startsWith(fileVersionedLogDataPrefix)) {
			store.storedComponent = DiskStore::TLogData;
			// Use the option string that's in the file rather than tLogOptions.toPrefix(),
			// because they might be different if a new option was introduced in this version.
			StringRef optionsString = filename.removePrefix(fileVersionedLogDataPrefix).eat("-");
			TraceEvent("DiskStoreVersioned").detail("Filename", filename);
			ErrorOr<TLogOptions> tLogOptions = TLogOptions::FromStringRef(optionsString);
			if (tLogOptions.isError()) {
				TraceEvent(SevWarn, "DiskStoreMalformedFilename").detail("Filename", filename);
				continue;
			}
			TraceEvent("DiskStoreVersionedSuccess").detail("Filename", filename);
			store.tLogOptions = tLogOptions.get();
			prefix = filename.substr(0, fileVersionedLogDataPrefix.size() + optionsString.size() + 1);
		} else if (filename.startsWith(fileLogDataPrefix)) {
			TraceEvent("DiskStoreUnversioned").detail("Filename", filename);
			store.storedComponent = DiskStore::TLogData;
			store.tLogOptions.version = TLogVersion::V2;
			store.tLogOptions.spillType = TLogSpillType::VALUE;
			prefix = fileLogDataPrefix;
		} else {
			continue;
		}

		store.storeID = UID::fromString(files[idx].substr(prefix.size(), 32));
		store.filename = filenameFromSample(type, folder, files[idx]);
		result.push_back(store);
	}
	return result;
}

std::vector<DiskStore> getDiskStores(std::string folder) {
	auto result = getDiskStores(folder, bTreeV1Suffix.suffix, bTreeV1Suffix.type, bTreeV1Suffix.check);
	auto result1 = getDiskStores(folder, bTreeV2Suffix.suffix, bTreeV2Suffix.type, bTreeV2Suffix.check);
	result.insert(result.end(), result1.begin(), result1.end());
	auto result2 = getDiskStores(folder, memorySuffix.suffix, memorySuffix.type, memorySuffix.check);
	result.insert(result.end(), result2.begin(), result2.end());
	auto result3 = getDiskStores(folder, redwoodSuffix.suffix, redwoodSuffix.type, redwoodSuffix.check);
	result.insert(result.end(), result3.begin(), result3.end());
	auto result4 = getDiskStores(folder, memoryRTSuffix.suffix, memoryRTSuffix.type, memoryRTSuffix.check);
	result.insert(result.end(), result4.begin(), result4.end());
	auto result5 = getDiskStores(folder, rocksdbSuffix.suffix, rocksdbSuffix.type, rocksdbSuffix.check);
	result.insert(result.end(), result5.begin(), result5.end());
	auto result6 =
	    getDiskStores(folder, shardedRocksdbSuffix.suffix, shardedRocksdbSuffix.type, shardedRocksdbSuffix.check);
	result.insert(result.end(), result6.begin(), result6.end());
	return result;
}

// Register the worker interf to cluster controller (cc) and
// re-register the worker when key roles interface, e.g., cc, dd, ratekeeper, change.
															#line 3028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via registrationClient()
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class RegistrationClientActor>
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class RegistrationClientActorState {
															#line 3035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	RegistrationClientActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo,ProcessClass const& initialClass,Reference<AsyncVar<Optional<DataDistributorInterface>> const> const& ddInterf,Reference<AsyncVar<Optional<RatekeeperInterface>> const> const& rkInterf,Reference<AsyncVar<Optional<EncryptKeyProxyInterface>> const> const& ekpInterf,Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> const& csInterf,Reference<AsyncVar<bool> const> const& degraded,Reference<IClusterConnectionRecord> const& connRecord,Reference<AsyncVar<std::set<std::string>> const> const& issues,Reference<ConfigNode> const& configNode,Reference<LocalConfiguration> const& localConfig,ConfigBroadcastInterface const& configBroadcastInterface,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,Promise<Void> const& recoveredDiskFiles,Reference<AsyncVar<Optional<UID>>> const& clusterId) 
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : ccInterface(ccInterface),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   interf(interf),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   asyncPriorityInfo(asyncPriorityInfo),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   initialClass(initialClass),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   ddInterf(ddInterf),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   rkInterf(rkInterf),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   ekpInterf(ekpInterf),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   csInterf(csInterf),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   degraded(degraded),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   connRecord(connRecord),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   issues(issues),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   configNode(configNode),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   localConfig(localConfig),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   configBroadcastInterface(configBroadcastInterface),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   recoveredDiskFiles(recoveredDiskFiles),
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   requestGeneration(0),
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   processClass(initialClass),
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   scInterf(new AsyncVar<Optional<std::pair<uint16_t, StorageServerInterface>>>()),
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   cacheProcessFuture(),
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   cacheErrorsFuture(),
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   incorrectTime(),
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   firstReg(true)
															#line 3088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("registrationClient", reinterpret_cast<unsigned long>(this));

	}
	~RegistrationClientActorState() 
	{
		fdb_probe_actor_destroy("registrationClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 3103 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegistrationClientActorState();
		static_cast<RegistrationClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		storedConnectionString = ClusterConnectionString();
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		upToDate = true;
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (connRecord)
															#line 3137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<bool> __when_expr_0 = connRecord->upToDate(storedConnectionString);
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<RegistrationClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegistrationClientActor*>(this)->actor_wait_state = 1;
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 0, bool >*>(static_cast<RegistrationClientActor*>(this)));
															#line 3148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 639 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (upToDate)
															#line 3162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 640 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			incorrectTime = Optional<double>();
															#line 3166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		RegisterWorkerRequest request(interf, initialClass, processClass, asyncPriorityInfo->get(), requestGeneration++, ddInterf->get(), rkInterf->get(), ekpInterf->get(), csInterf->get(), degraded->get(), localConfig.isValid() ? localConfig->lastSeenVersion() : Optional<Version>(), localConfig.isValid() ? localConfig->configClassSet() : Optional<ConfigClassSet>(), recoveredDiskFiles.isSet(), configBroadcastInterface, clusterId->get());
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		for( auto const& i : issues->get() ) {
															#line 661 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			request.issues.push_back_deep(request.issues.arena(), i);
															#line 3174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!upToDate)
															#line 3178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			request.issues.push_back_deep(request.issues.arena(), "incorrect_cluster_file_contents"_sr);
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::string connectionString = connRecord->getConnectionString().toString();
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!incorrectTime.present())
															#line 3186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 668 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				incorrectTime = now();
															#line 3190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(now() - incorrectTime.get() > 300 ? SevWarnAlways : SevWarn, "IncorrectClusterFileContents") .detail("ClusterFile", connRecord->toString()) .detail("StoredConnectionString", storedConnectionString.toString()) .detail("CurrentConnectionString", connectionString);
															#line 3194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 678 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto peers = FlowTransport::transport().getIncompatiblePeers();
															#line 679 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		for(auto it = peers->begin();it != peers->end();) {
															#line 680 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (now() - it->second.second > FLOW_KNOBS->INCOMPATIBLE_PEER_DELAY_BEFORE_LOGGING)
															#line 3202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				request.incompatiblePeers.push_back(it->first);
															#line 682 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				it = peers->erase(it);
															#line 3208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 684 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				it++;
															#line 3214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		ccInterfacePresent = ccInterface->get().present();
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (ccInterfacePresent)
															#line 3221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			request.requestDbInfo = (ccInterface->get().get().id() != dbInfo->get().clusterInterface.id());
															#line 691 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (firstReg)
															#line 3227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 692 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				request.requestDbInfo = true;
															#line 693 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				firstReg = false;
															#line 3233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("WorkerRegister") .detail("CCID", ccInterface->get().get().id()) .detail("Generation", requestGeneration) .detail("RecoveredDiskFiles", recoveredDiskFiles.isSet()) .detail("ClusterId", clusterId->get());
															#line 3237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		registrationReply = ccInterfacePresent ? brokenPromiseToNever(ccInterface->get().get().registerWorker.getReply(request)) : Never();
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recovered = recoveredDiskFiles.isSet() ? Never() : recoveredDiskFiles.getFuture();
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		startTime = now();
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		;
															#line 3247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool const& upToDateResult,int loopDepth) 
	{
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		upToDate = upToDateResult;
															#line 3256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool && upToDateResult,int loopDepth) 
	{
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		upToDate = upToDateResult;
															#line 3265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& upToDateResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(upToDateResult, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && upToDateResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(upToDateResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegistrationClientActor*>(this)->actor_wait_state > 0) static_cast<RegistrationClientActor*>(this)->actor_wait_state = 0;
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<RegisterWorkerReply> __when_expr_1 = registrationReply;
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<RegistrationClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->UNKNOWN_CC_TIMEOUT);
															#line 3368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = ccInterface->onChange();
															#line 3372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when3(__when_expr_3.get(), loopDepth); };
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = ddInterf->onChange();
															#line 3376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when4(__when_expr_4.get(), loopDepth); };
															#line 726 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_5 = rkInterf->onChange();
															#line 3380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when5(__when_expr_5.get(), loopDepth); };
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_6 = csInterf->onChange();
															#line 3384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when6(__when_expr_6.get(), loopDepth); };
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_7 = ekpInterf->onChange();
															#line 3388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when7(__when_expr_7.get(), loopDepth); };
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_8 = degraded->onChange();
															#line 3392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when8(__when_expr_8.get(), loopDepth); };
															#line 738 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_9 = FlowTransport::transport().onIncompatibleChanged();
															#line 3396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when9(__when_expr_9.get(), loopDepth); };
															#line 741 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_10 = issues->onChange();
															#line 3400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when10(__when_expr_10.get(), loopDepth); };
															#line 744 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_11 = recovered;
															#line 3404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when11(__when_expr_11.get(), loopDepth); };
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_12 = clusterId->onChange();
															#line 3408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when12(__when_expr_12.get(), loopDepth); };
		static_cast<RegistrationClientActor*>(this)->actor_wait_state = 2;
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*>(static_cast<RegistrationClientActor*>(this)));
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 2, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 3, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 4, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 726 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 5, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 6, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 732 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 7, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 8, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 738 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 9, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 741 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 10, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 744 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 11, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 12, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 3435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(RegisterWorkerReply const& reply,int loopDepth) 
	{
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		processClass = reply.processClass;
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		asyncPriorityInfo->set(reply.priorityInfo);
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerRegisterReply") .detail("CCID", ccInterface->get().get().id()) .detail("ProcessClass", reply.processClass.toString());
															#line 3467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(RegisterWorkerReply && reply,int loopDepth) 
	{
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		processClass = reply.processClass;
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		asyncPriorityInfo->set(reply.priorityInfo);
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerRegisterReply") .detail("CCID", ccInterface->get().get().id()) .detail("ProcessClass", reply.processClass.toString());
															#line 3480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!ccInterfacePresent)
															#line 3489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarn, "WorkerRegisterTimeout").detail("WaitTime", now() - startTime);
															#line 3493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!ccInterfacePresent)
															#line 3503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarn, "WorkerRegisterTimeout").detail("WaitTime", now() - startTime);
															#line 3507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when3(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when4(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when4(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when5(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when5(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when6(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when6(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when7(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when7(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when8(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when8(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when9(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when9(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when10(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when10(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when11(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when11(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when12(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when12(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RegistrationClientActor*>(this)->actor_wait_state > 0) static_cast<RegistrationClientActor*>(this)->actor_wait_state = 0;
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 2, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 3, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 4, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 5, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 6, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 7, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 8, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 9, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 10, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 11, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*,RegisterWorkerReply const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*,RegisterWorkerReply && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when10(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when11(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when11(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when12(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when12(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 12);

	}
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	WorkerInterface interf;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ClusterControllerPriorityInfo>> asyncPriorityInfo;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ProcessClass initialClass;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<DataDistributorInterface>> const> ddInterf;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<RatekeeperInterface>> const> rkInterf;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<EncryptKeyProxyInterface>> const> ekpInterf;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> csInterf;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<bool> const> degraded;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<IClusterConnectionRecord> connRecord;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<std::set<std::string>> const> issues;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<ConfigNode> configNode;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<LocalConfiguration> localConfig;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ConfigBroadcastInterface configBroadcastInterface;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void> recoveredDiskFiles;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<UID>>> clusterId;
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Generation requestGeneration;
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ProcessClass processClass;
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<std::pair<uint16_t, StorageServerInterface>>>> scInterf;
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> cacheProcessFuture;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> cacheErrorsFuture;
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Optional<double> incorrectTime;
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	bool firstReg;
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ClusterConnectionString storedConnectionString;
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	bool upToDate;
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	bool ccInterfacePresent;
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<RegisterWorkerReply> registrationReply;
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> recovered;
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	double startTime;
															#line 4394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via registrationClient()
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class RegistrationClientActor final : public Actor<Void>, public ActorCallback< RegistrationClientActor, 0, bool >, public ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >, public ActorCallback< RegistrationClientActor, 2, Void >, public ActorCallback< RegistrationClientActor, 3, Void >, public ActorCallback< RegistrationClientActor, 4, Void >, public ActorCallback< RegistrationClientActor, 5, Void >, public ActorCallback< RegistrationClientActor, 6, Void >, public ActorCallback< RegistrationClientActor, 7, Void >, public ActorCallback< RegistrationClientActor, 8, Void >, public ActorCallback< RegistrationClientActor, 9, Void >, public ActorCallback< RegistrationClientActor, 10, Void >, public ActorCallback< RegistrationClientActor, 11, Void >, public ActorCallback< RegistrationClientActor, 12, Void >, public FastAllocated<RegistrationClientActor>, public RegistrationClientActorState<RegistrationClientActor> {
															#line 4399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<RegistrationClientActor>::operator new;
	using FastAllocated<RegistrationClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7855119162183649536UL, 4354723396765097728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegistrationClientActor, 0, bool >;
friend struct ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >;
friend struct ActorCallback< RegistrationClientActor, 2, Void >;
friend struct ActorCallback< RegistrationClientActor, 3, Void >;
friend struct ActorCallback< RegistrationClientActor, 4, Void >;
friend struct ActorCallback< RegistrationClientActor, 5, Void >;
friend struct ActorCallback< RegistrationClientActor, 6, Void >;
friend struct ActorCallback< RegistrationClientActor, 7, Void >;
friend struct ActorCallback< RegistrationClientActor, 8, Void >;
friend struct ActorCallback< RegistrationClientActor, 9, Void >;
friend struct ActorCallback< RegistrationClientActor, 10, Void >;
friend struct ActorCallback< RegistrationClientActor, 11, Void >;
friend struct ActorCallback< RegistrationClientActor, 12, Void >;
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	RegistrationClientActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo,ProcessClass const& initialClass,Reference<AsyncVar<Optional<DataDistributorInterface>> const> const& ddInterf,Reference<AsyncVar<Optional<RatekeeperInterface>> const> const& rkInterf,Reference<AsyncVar<Optional<EncryptKeyProxyInterface>> const> const& ekpInterf,Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> const& csInterf,Reference<AsyncVar<bool> const> const& degraded,Reference<IClusterConnectionRecord> const& connRecord,Reference<AsyncVar<std::set<std::string>> const> const& issues,Reference<ConfigNode> const& configNode,Reference<LocalConfiguration> const& localConfig,ConfigBroadcastInterface const& configBroadcastInterface,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,Promise<Void> const& recoveredDiskFiles,Reference<AsyncVar<Optional<UID>>> const& clusterId) 
															#line 4428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   RegistrationClientActorState<RegistrationClientActor>(ccInterface, interf, asyncPriorityInfo, initialClass, ddInterf, rkInterf, ekpInterf, csInterf, degraded, connRecord, issues, configNode, localConfig, configBroadcastInterface, dbInfo, recoveredDiskFiles, clusterId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3853273321946395648UL, 10112439968674810368UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registrationClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegistrationClientActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> registrationClient( Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, WorkerInterface const& interf, Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo, ProcessClass const& initialClass, Reference<AsyncVar<Optional<DataDistributorInterface>> const> const& ddInterf, Reference<AsyncVar<Optional<RatekeeperInterface>> const> const& rkInterf, Reference<AsyncVar<Optional<EncryptKeyProxyInterface>> const> const& ekpInterf, Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> const& csInterf, Reference<AsyncVar<bool> const> const& degraded, Reference<IClusterConnectionRecord> const& connRecord, Reference<AsyncVar<std::set<std::string>> const> const& issues, Reference<ConfigNode> const& configNode, Reference<LocalConfiguration> const& localConfig, ConfigBroadcastInterface const& configBroadcastInterface, Reference<AsyncVar<ServerDBInfo>> const& dbInfo, Promise<Void> const& recoveredDiskFiles, Reference<AsyncVar<Optional<UID>>> const& clusterId ) {
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RegistrationClientActor(ccInterface, interf, asyncPriorityInfo, initialClass, ddInterf, rkInterf, ekpInterf, csInterf, degraded, connRecord, issues, configNode, localConfig, configBroadcastInterface, dbInfo, recoveredDiskFiles, clusterId));
															#line 4462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 753 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

// Returns true if `address` is used in the db (indicated by `dbInfo`) transaction system and in the db's primary DC.
bool addressInDbAndPrimaryDc(
    const NetworkAddress& address,
    Reference<AsyncVar<ServerDBInfo> const> dbInfo,
    Optional<std::vector<NetworkAddress>> storageServers = Optional<std::vector<NetworkAddress>>{}) {
	const auto& dbi = dbInfo->get();

	if (dbi.master.addresses().contains(address)) {
		return true;
	}

	if (dbi.distributor.present() && dbi.distributor.get().address() == address) {
		return true;
	}

	if (dbi.ratekeeper.present() && dbi.ratekeeper.get().address() == address) {
		return true;
	}

	if (dbi.consistencyScan.present() && dbi.consistencyScan.get().address() == address) {
		return true;
	}

	if (dbi.client.encryptKeyProxy.present() && dbi.client.encryptKeyProxy.get().address() == address) {
		return true;
	}

	for (const auto& resolver : dbi.resolvers) {
		if (resolver.address() == address) {
			return true;
		}
	}

	for (const auto& grvProxy : dbi.client.grvProxies) {
		if (grvProxy.addresses().contains(address)) {
			return true;
		}
	}

	for (const auto& commitProxy : dbi.client.commitProxies) {
		if (commitProxy.addresses().contains(address)) {
			return true;
		}
	}

	auto localityIsInPrimaryDc = [&dbInfo](const LocalityData& locality) {
		return locality.dcId() == dbInfo->get().master.locality.dcId();
	};

	for (const auto& logSet : dbi.logSystemConfig.tLogs) {
		for (const auto& tlog : logSet.tLogs) {
			if (!tlog.present()) {
				continue;
			}

			if (!localityIsInPrimaryDc(tlog.interf().filteredLocality)) {
				continue;
			}

			if (tlog.interf().addresses().contains(address)) {
				return true;
			}
		}
	}

	if (storageServers.present() &&
	    (std::find(storageServers.get().begin(), storageServers.get().end(), address) != storageServers.get().end())) {
		return true;
	}

	return false;
}

bool addressesInDbAndPrimaryDc(
    const NetworkAddressList& addresses,
    Reference<AsyncVar<ServerDBInfo> const> dbInfo,
    Optional<std::vector<NetworkAddress>> storageServers = Optional<std::vector<NetworkAddress>>{}) {
	return addressInDbAndPrimaryDc(addresses.address, dbInfo, storageServers) ||
	       (addresses.secondaryAddress.present() &&
	        addressInDbAndPrimaryDc(addresses.secondaryAddress.get(), dbInfo, storageServers));
}

namespace {

															#line 4551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
// This generated class is to be used only via flowTestCase838()
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase838Actor>
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase838ActorState {
															#line 4557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase838ActorState(UnitTestParameters const& params) 
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 4564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase838", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase838ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase838", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 840 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 843 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress testAddress(IPAddress(0x13131313), 1);
															#line 847 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.getCommitVersion = RequestStream<struct GetCommitVersionRequest>(Endpoint({ testAddress }, UID(1, 2)));
															#line 851 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface<TLogInterface>());
															#line 853 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimaryDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 858 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 859 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTlog(fakeRemote);
															#line 860 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			remoteTlog.initEndpoints();
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTlog));
															#line 862 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimaryDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 865 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface localTlog(testLocal);
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			localTlog.initEndpoints();
															#line 867 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(localTlog));
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.clear();
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(testAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 875 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress grvProxyAddress(IPAddress(0x26262626), 1);
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			GrvProxyInterface grvProxyInterf;
															#line 877 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			grvProxyInterf.getConsistentReadVersion = PublicRequestStream<struct GetReadVersionRequest>(Endpoint({ grvProxyAddress }, UID(1, 2)));
															#line 879 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.client.grvProxies.push_back(grvProxyInterf);
															#line 880 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(grvProxyAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 882 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress commitProxyAddress(IPAddress(0x37373737), 1);
															#line 883 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			CommitProxyInterface commitProxyInterf;
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			commitProxyInterf.commit = PublicRequestStream<struct CommitTransactionRequest>(Endpoint({ commitProxyAddress }, UID(1, 2)));
															#line 886 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.client.commitProxies.push_back(commitProxyInterf);
															#line 887 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(commitProxyAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 889 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase838Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase838ActorState(); static_cast<FlowTestCase838Actor*>(this)->destroy(); return 0; }
															#line 4641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			new (&static_cast<FlowTestCase838Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase838ActorState();
			static_cast<FlowTestCase838Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase838ActorState();
		static_cast<FlowTestCase838Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 4665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase838()
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase838Actor final : public Actor<Void>, public FastAllocated<FlowTestCase838Actor>, public FlowTestCase838ActorState<FlowTestCase838Actor> {
															#line 4670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase838Actor>::operator new;
	using FastAllocated<FlowTestCase838Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14723366433471647488UL, 9614957479839794176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase838Actor(UnitTestParameters const& params) 
															#line 4686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase838ActorState<FlowTestCase838Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase838", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16828046494669825536UL, 5343452087977961216UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase838Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase838");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase838", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase838( UnitTestParameters const& params ) {
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase838Actor(params));
															#line 4717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase838, "/fdbserver/worker/addressInDbAndPrimaryDc")

#line 891 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

// Returns true if `address` is used in the db (indicated by `dbInfo`) transaction system and in the db's primary
// satellite DC.
bool addressInDbAndPrimarySatelliteDc(const NetworkAddress& address, Reference<AsyncVar<ServerDBInfo> const> dbInfo) {
	for (const auto& logSet : dbInfo->get().logSystemConfig.tLogs) {
		if (logSet.isLocal && logSet.locality == tagLocalitySatellite) {
			for (const auto& tlog : logSet.tLogs) {
				if (tlog.present() && tlog.interf().addresses().contains(address)) {
					return true;
				}
			}
		}
	}

	return false;
}

bool addressesInDbAndPrimarySatelliteDc(const NetworkAddressList& addresses,
                                        Reference<AsyncVar<ServerDBInfo> const> dbInfo) {
	return addressInDbAndPrimarySatelliteDc(addresses.address, dbInfo) ||
	       (addresses.secondaryAddress.present() &&
	        addressInDbAndPrimarySatelliteDc(addresses.secondaryAddress.get(), dbInfo));
}

namespace {

															#line 4750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
// This generated class is to be used only via flowTestCase919()
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase919Actor>
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase919ActorState {
															#line 4756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase919ActorState(UnitTestParameters const& params) 
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 4763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase919", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase919ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase919", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 923 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 924 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 927 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 928 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().locality = tagLocalitySatellite;
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface<TLogInterface>());
															#line 931 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimarySatelliteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress satelliteTLogAddress(IPAddress(0x13131313), 1);
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface satelliteTLog(testLocal);
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.initEndpoints();
															#line 938 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ satelliteTLogAddress }, UID(1, 2)));
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(satelliteTLog));
															#line 940 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimarySatelliteDc(satelliteTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress primaryTLogAddress(IPAddress(0x26262626), 1);
															#line 944 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 945 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface primaryTLog(testLocal);
															#line 947 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			primaryTLog.initEndpoints();
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			primaryTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ primaryTLogAddress }, UID(1, 2)));
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(primaryTLog));
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimarySatelliteDc(primaryTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress remoteTLogAddress(IPAddress(0x37373737), 1);
															#line 954 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 955 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 956 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTLog(fakeRemote);
															#line 957 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			remoteTLog.initEndpoints();
															#line 958 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			remoteTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ remoteTLogAddress }, UID(1, 2)));
															#line 960 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 961 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = false;
															#line 962 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTLog));
															#line 963 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimarySatelliteDc(remoteTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 965 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase919Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase919ActorState(); static_cast<FlowTestCase919Actor*>(this)->destroy(); return 0; }
															#line 4844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			new (&static_cast<FlowTestCase919Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase919ActorState();
			static_cast<FlowTestCase919Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase919ActorState();
		static_cast<FlowTestCase919Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 4868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase919()
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase919Actor final : public Actor<Void>, public FastAllocated<FlowTestCase919Actor>, public FlowTestCase919ActorState<FlowTestCase919Actor> {
															#line 4873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase919Actor>::operator new;
	using FastAllocated<FlowTestCase919Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3286659757010362368UL, 3698903151129004800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase919Actor(UnitTestParameters const& params) 
															#line 4889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase919ActorState<FlowTestCase919Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase919", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12806150915292879360UL, 8894508289390096128UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase919Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase919");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase919", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase919( UnitTestParameters const& params ) {
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase919Actor(params));
															#line 4920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase919, "/fdbserver/worker/addressInDbAndPrimarySatelliteDc")

#line 967 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

bool addressInDbAndRemoteDc(const NetworkAddress& address,
                            Reference<AsyncVar<ServerDBInfo> const> dbInfo,
                            Optional<std::vector<NetworkAddress>> storageServers) {
	const auto& dbi = dbInfo->get();

	for (const auto& logSet : dbi.logSystemConfig.tLogs) {
		if (logSet.isLocal || logSet.locality == tagLocalitySatellite) {
			continue;
		}
		for (const auto& tlog : logSet.tLogs) {
			if (tlog.present() && tlog.interf().addresses().contains(address)) {
				return true;
			}
		}

		for (const auto& logRouter : logSet.logRouters) {
			if (logRouter.present() && logRouter.interf().addresses().contains(address)) {
				return true;
			}
		}
	}

	if (storageServers.present() &&
	    (std::find(storageServers.get().begin(), storageServers.get().end(), address) != storageServers.get().end())) {
		return true;
	}

	return false;
}

bool addressesInDbAndRemoteDc(
    const NetworkAddressList& addresses,
    Reference<AsyncVar<ServerDBInfo> const> dbInfo,
    Optional<std::vector<NetworkAddress>> storageServers = Optional<std::vector<NetworkAddress>>{}) {
	return addressInDbAndRemoteDc(addresses.address, dbInfo, storageServers) ||
	       (addresses.secondaryAddress.present() &&
	        addressInDbAndRemoteDc(addresses.secondaryAddress.get(), dbInfo, storageServers));
}

namespace {

															#line 4969 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
// This generated class is to be used only via flowTestCase1011()
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase1011Actor>
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1011ActorState {
															#line 4975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1011ActorState(UnitTestParameters const& params) 
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 4982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1011", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1011ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1011", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 1014 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 1016 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 1019 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1020 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 1021 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface<TLogInterface>());
															#line 1022 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndRemoteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1024 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface localTlog(testLocal);
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			localTlog.initEndpoints();
															#line 1026 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(localTlog));
															#line 1027 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndRemoteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1030 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 1031 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 1032 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTlog(fakeRemote);
															#line 1033 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			remoteTlog.initEndpoints();
															#line 1035 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1036 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = false;
															#line 1037 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTlog));
															#line 1038 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndRemoteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1041 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress logRouterAddress(IPAddress(0x26262626), 1);
															#line 1042 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteLogRouter(fakeRemote);
															#line 1043 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.initEndpoints();
															#line 1044 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ logRouterAddress }, UID(1, 2)));
															#line 1045 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface(remoteLogRouter));
															#line 1046 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndRemoteDc(logRouterAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1050 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().locality = tagLocalitySatellite;
															#line 1051 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress satelliteTLogAddress(IPAddress(0x13131313), 1);
															#line 1052 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface satelliteTLog(fakeRemote);
															#line 1053 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.initEndpoints();
															#line 1054 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ satelliteTLogAddress }, UID(1, 2)));
															#line 1055 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(satelliteTLog));
															#line 1056 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndRemoteDc(satelliteTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase1011Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1011ActorState(); static_cast<FlowTestCase1011Actor*>(this)->destroy(); return 0; }
															#line 5065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			new (&static_cast<FlowTestCase1011Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1011ActorState();
			static_cast<FlowTestCase1011Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1011ActorState();
		static_cast<FlowTestCase1011Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 5089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1011()
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1011Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1011Actor>, public FlowTestCase1011ActorState<FlowTestCase1011Actor> {
															#line 5094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1011Actor>::operator new;
	using FastAllocated<FlowTestCase1011Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11260814381469044992UL, 17205747135897862400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1011Actor(UnitTestParameters const& params) 
															#line 5110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1011ActorState<FlowTestCase1011Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1011", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10615698006383478016UL, 14605806578854712064UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1011Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1011");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1011", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase1011( UnitTestParameters const& params ) {
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase1011Actor(params));
															#line 5141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1011, "/fdbserver/worker/addressInDbAndRemoteDc")

#line 1060 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

bool addressIsRemoteLogRouter(const NetworkAddress& address, Reference<AsyncVar<ServerDBInfo> const> dbInfo) {
	const auto& dbi = dbInfo->get();

	for (const auto& logSet : dbi.logSystemConfig.tLogs) {
		if (!logSet.isLocal) {
			for (const auto& logRouter : logSet.logRouters) {
				if (logRouter.present() && logRouter.interf().addresses().contains(address)) {
					return true;
				}
			}
		}
	}

	return false;
}

namespace {

															#line 5167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
// This generated class is to be used only via flowTestCase1081()
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase1081Actor>
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1081ActorState {
															#line 5173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1081ActorState(UnitTestParameters const& params) 
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 5180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1081", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1081ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1081", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1083 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 1084 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 1085 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 1086 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 1089 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1090 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 1091 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface<TLogInterface>());
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressIsRemoteLogRouter(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1095 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface localLogRouter(testLocal);
															#line 1096 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			localLogRouter.initEndpoints();
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface(localLogRouter));
															#line 1098 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressIsRemoteLogRouter(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1101 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 1102 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTlog(fakeRemote);
															#line 1104 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			remoteTlog.initEndpoints();
															#line 1106 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1107 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = false;
															#line 1108 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTlog));
															#line 1109 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressIsRemoteLogRouter(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1112 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress logRouterAddress(IPAddress(0x26262626), 1);
															#line 1113 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteLogRouter(fakeRemote);
															#line 1114 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.initEndpoints();
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ logRouterAddress }, UID(1, 2)));
															#line 1116 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface(remoteLogRouter));
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressIsRemoteLogRouter(logRouterAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1119 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase1081Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1081ActorState(); static_cast<FlowTestCase1081Actor*>(this)->destroy(); return 0; }
															#line 5247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			new (&static_cast<FlowTestCase1081Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1081ActorState();
			static_cast<FlowTestCase1081Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1081ActorState();
		static_cast<FlowTestCase1081Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 5271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1081()
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1081Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1081Actor>, public FlowTestCase1081ActorState<FlowTestCase1081Actor> {
															#line 5276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1081Actor>::operator new;
	using FastAllocated<FlowTestCase1081Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4195830629248472320UL, 15544320384409365760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1081Actor(UnitTestParameters const& params) 
															#line 5292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1081ActorState<FlowTestCase1081Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1081", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7515603536340593664UL, 3485025767169992192UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1081Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1081");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1081", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase1081( UnitTestParameters const& params ) {
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase1081Actor(params));
															#line 5323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1081, "/fdbserver/worker/addressIsRemoteLogRouter")

#line 1121 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

// Returns true if the `peer` has enough measurement samples that should be checked by the health monitor.
bool shouldCheckPeer(Reference<Peer> peer) {
	TraceEvent(SevDebug, "ShouldCheckPeer")
	    .suppressFor(0.1)
	    .detail("ConnectFailedCount", peer->connectFailedCount)
	    .detail("PingLatencyPopulationSize", peer->pingLatencies.getPopulationSize());

	if (peer->connectFailedCount != 0) {
		return true;
	}

	if (peer->pingLatencies.getPopulationSize() >= SERVER_KNOBS->PEER_LATENCY_CHECK_MIN_POPULATION) {
		// Ignore peers that don't have enough samples.
		// TODO(zhewu): Currently, FlowTransport latency monitor clears ping latency samples on a
		// regular basis, which may affect the measurement count. Currently,
		// WORKER_HEALTH_MONITOR_INTERVAL is much smaller than the ping clearance interval, so it may be
		// ok. If this ends to be a problem, we need to consider keep track of last ping latencies
		// logged.
		return true;
	}

	return false;
}

// Returns true if `address` is a degraded/disconnected peer in `lastReq` sent to CC.
bool isDegradedPeer(const UpdateWorkerHealthRequest& lastReq, const NetworkAddress& address) {
	if (std::find(lastReq.degradedPeers.begin(), lastReq.degradedPeers.end(), address) != lastReq.degradedPeers.end()) {
		return true;
	}

	if (std::find(lastReq.disconnectedPeers.begin(), lastReq.disconnectedPeers.end(), address) !=
	    lastReq.disconnectedPeers.end()) {
		return true;
	}

	return false;
}

struct PrimaryAndRemoteAddresses {
	std::vector<NetworkAddress> primary;
	std::vector<NetworkAddress> remote;
};

// Check if the current worker is a transaction worker, and is experiencing degraded or disconnected peers.
UpdateWorkerHealthRequest doPeerHealthCheck(const WorkerInterface& interf,
                                            const LocalityData& locality,
                                            Reference<AsyncVar<ServerDBInfo> const> dbInfo,
                                            const UpdateWorkerHealthRequest& lastReq,
                                            Reference<AsyncVar<bool>> enablePrimaryTxnSystemHealthCheck,
                                            Optional<PrimaryAndRemoteAddresses> storageServers) {
	const auto& allPeers = FlowTransport::transport().getAllPeers();

	// Check remote log router connectivity only when remote TLogs are recruited and in use.
	bool checkRemoteLogRouterConnectivity = dbInfo->get().recoveryState == RecoveryState::ALL_LOGS_RECRUITED ||
	                                        dbInfo->get().recoveryState == RecoveryState::FULLY_RECOVERED;
	UpdateWorkerHealthRequest req;

	enum WorkerLocation { None, Primary, Satellite, Remote };
	WorkerLocation workerLocation = None;
	if (addressesInDbAndPrimaryDc(interf.addresses(),
	                              dbInfo,
	                              storageServers.present() ? storageServers.get().primary
	                                                       : Optional<std::vector<NetworkAddress>>{})) {
		workerLocation = Primary;
	} else if (addressesInDbAndRemoteDc(interf.addresses(),
	                                    dbInfo,
	                                    storageServers.present() ? storageServers.get().remote
	                                                             : Optional<std::vector<NetworkAddress>>{})) {
		workerLocation = Remote;
	} else if (addressesInDbAndPrimarySatelliteDc(interf.addresses(), dbInfo)) {
		workerLocation = Satellite;
	}

	TraceEvent(SevInfo, "DoPeerHealthCheck")
	    .detail("WorkerLocation", workerLocation)
	    .detail("StorageServersPresent", storageServers.present())
	    .detail("StorageServersPrimarySize",
	            storageServers.present() ? std::to_string(storageServers.get().primary.size()) : "NA")
	    .detail("StorageServersRemoteSize",
	            storageServers.present() ? std::to_string(storageServers.get().remote.size()) : "NA");

	if (workerLocation == None && !enablePrimaryTxnSystemHealthCheck->get()) {
		// This worker doesn't need to monitor anything if it is not in transaction system or in remote satellite.
		return req;
	}

	for (const auto& [address, peer] : allPeers) {
		if (!shouldCheckPeer(peer)) {
			continue;
		}

		bool degradedPeer = false;
		bool disconnectedPeer = false;

		// If peer->lastLoggedTime == 0, we just started monitor this peer and haven't logged it once yet.
		double lastLoggedTime = peer->lastLoggedTime <= 0.0 ? peer->lastConnectTime : peer->lastLoggedTime;

		TraceEvent(SevDebug, "PeerHealthMonitor")
		    .suppressFor(5.0)
		    .detail("Peer", address)
		    .detail("PeerAddress", address)
		    .detail("Force", enablePrimaryTxnSystemHealthCheck->get())
		    .detail("Elapsed", now() - lastLoggedTime)
		    .detail("Disconnected", disconnectedPeer)
		    .detail("MinLatency", peer->pingLatencies.min())
		    .detail("MaxLatency", peer->pingLatencies.max())
		    .detail("MeanLatency", peer->pingLatencies.mean())
		    .detail("MedianLatency", peer->pingLatencies.median())
		    .detail("CheckedPercentile", SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE)
		    .detail("CheckedPercentileLatency",
		            peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE))
		    .detail("PingCount", peer->pingLatencies.getPopulationSize())
		    .detail("PingTimeoutCount", peer->timeoutCount)
		    .detail("ConnectionFailureCount", peer->connectFailedCount)
		    .detail("WorkerLocation", workerLocation)
		    .detail("PeerInPrimaryDc", addressInDbAndPrimaryDc(address, dbInfo))
		    .detail("PeerInRemoteDc", addressInDbAndRemoteDc(address, dbInfo))
		    .detail("PeerInPrimarySatelliteDc", addressInDbAndPrimarySatelliteDc(address, dbInfo))
		    .detail("PeerIsRemoteLogRouter", addressIsRemoteLogRouter(address, dbInfo));

		if ((workerLocation == Primary && addressInDbAndPrimaryDc(address, dbInfo)) ||
		    (workerLocation == Remote && addressInDbAndRemoteDc(address, dbInfo))) {
			// Monitors intra DC latencies between servers that in the primary or remote DC's transaction
			// systems. Note that currently we are not monitor storage servers, since lagging in storage
			// servers today already can trigger server exclusion by data distributor.

			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				disconnectedPeer = true;
			} else if (peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE) >
			               SERVER_KNOBS->PEER_LATENCY_DEGRADATION_THRESHOLD ||
			           peer->timeoutCount / (double)(peer->pingLatencies.getPopulationSize()) >
			               SERVER_KNOBS->PEER_TIMEOUT_PERCENTAGE_DEGRADATION_THRESHOLD) {
				degradedPeer = true;
			}
			if (disconnectedPeer || degradedPeer) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", disconnectedPeer)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("CheckedPercentile", SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE)
				    .detail("CheckedPercentileLatency",
				            peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE))
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
			}
		} else if (workerLocation == Primary && addressInDbAndPrimarySatelliteDc(address, dbInfo)) {
			// Monitors inter DC latencies between servers in primary and primary satellite DC. Note that
			// TLog workers in primary satellite DC are on the critical path of serving a commit.
			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				disconnectedPeer = true;
			} else if (peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE_SATELLITE) >
			               SERVER_KNOBS->PEER_LATENCY_DEGRADATION_THRESHOLD_SATELLITE ||
			           peer->timeoutCount / (double)(peer->pingLatencies.getPopulationSize()) >
			               SERVER_KNOBS->PEER_TIMEOUT_PERCENTAGE_DEGRADATION_THRESHOLD) {
				degradedPeer = true;
			}

			if (disconnectedPeer || degradedPeer) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("Satellite", true)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", disconnectedPeer)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("CheckedPercentile", SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE_SATELLITE)
				    .detail("CheckedPercentileLatency",
				            peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE_SATELLITE))
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
			}
		} else if (checkRemoteLogRouterConnectivity && (workerLocation == Primary || workerLocation == Satellite) &&
		           addressIsRemoteLogRouter(address, dbInfo)) {
			// Monitor remote log router's connectivity to the primary DCs' transaction system. We ignore
			// latency based degradation between primary region and remote region due to that remote region
			// may be distant from primary region.
			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("WorkerLocation", workerLocation)
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("RemoteLogRouter", true)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", true)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
				disconnectedPeer = true;
			}
		} else if (enablePrimaryTxnSystemHealthCheck->get() &&
		           (addressInDbAndPrimaryDc(address, dbInfo) || addressInDbAndPrimarySatelliteDc(address, dbInfo))) {
			// For force checking, we only detect connection timeout. Currently this should only be used during recovery
			// and only used in TLogs.
			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("WorkerLocation", workerLocation)
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("ExtensiveConnectivityCheck", true)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", true)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
				disconnectedPeer = true;
			}
		}

		if (disconnectedPeer) {
			req.disconnectedPeers.push_back(address);
		} else if (degradedPeer) {
			req.degradedPeers.push_back(address);
		} else if (isDegradedPeer(lastReq, address)) {
			TraceEvent("HealthMonitorDetectRecoveredPeer").detail("Peer", address).detail("PeerAddress", address);
			req.recoveredPeers.push_back(address);
		}
	}

	if (SERVER_KNOBS->WORKER_HEALTH_REPORT_RECENT_DESTROYED_PEER) {
		// When the worker cannot connect to a remote peer, the peer maybe erased from the list returned
		// from getAllPeers(). Therefore, we also look through all the recent closed peers in the flow
		// transport's health monitor. Note that all the closed peers stored here are caused by connection
		// failure, but not normal connection close. Therefore, we report all such peers if they are also
		// part of the transaction sub system.
		// Note that we don't need to calculate recovered peer in this case since all the recently closed peers are
		// considered permanently closed peers.
		for (const auto& address : FlowTransport::transport().healthMonitor()->getRecentClosedPeers()) {
			if (allPeers.find(address) != allPeers.end()) {
				// We have checked this peer in the above for loop.
				continue;
			}

			if ((workerLocation == Primary && addressInDbAndPrimaryDc(address, dbInfo)) ||
			    (workerLocation == Remote && addressInDbAndRemoteDc(address, dbInfo)) ||
			    (workerLocation == Primary && addressInDbAndPrimarySatelliteDc(address, dbInfo)) ||
			    (checkRemoteLogRouterConnectivity && (workerLocation == Primary || workerLocation == Satellite) &&
			     addressIsRemoteLogRouter(address, dbInfo))) {
				TraceEvent("HealthMonitorDetectRecentClosedPeer")
				    .suppressFor(30)
				    .detail("Peer", address)
				    .detail("PeerAddress", address);
				req.disconnectedPeers.push_back(address);
			}
		}
	}

	if (g_network->isSimulated()) {
		// Invariant check in simulation: for any peers that shouldn't be checked, we won't include it in the
		// UpdateWorkerHealthRequest sent to CC.
		for (const auto& [address, peer] : allPeers) {
			if (!shouldCheckPeer(peer)) {
				for (const auto& disconnectedPeer : req.disconnectedPeers) {
					ASSERT(address != disconnectedPeer);
				}
				for (const auto& degradedPeer : req.degradedPeers) {
					ASSERT(address != degradedPeer);
				}
				for (const auto& recoveredPeer : req.recoveredPeers) {
					ASSERT(address != recoveredPeer);
				}
			}
		}
	}

	return req;
}

static Optional<Standalone<StringRef>> getPrimaryDCId(const ServerDBInfo& dbInfo) {
	return dbInfo.master.locality.dcId();
}

// Makes a "best effort" to return the network addresses of primary and remote storage servers.
// Both primary and secondary (if present) addresses are returned.
// This actor makes a network call, and if that call fails, an empty optional is returned in addition to a
// TraceEvent being logged. Intentionally, this actor does not implement a retry policy, but the client can
// choose to retry by waiting on this actor again.
															#line 5625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via getStorageServers()
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class GetStorageServersActor>
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class GetStorageServersActorState {
															#line 5632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	GetStorageServersActorState(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : db(db),
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 1420 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   ret(),
															#line 1421 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   tr(db)
															#line 5645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageServersActorState() 
	{
		fdb_probe_actor_destroy("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1423 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1424 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1426 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<std::vector<std::pair<StorageServerInterface, ProcessClass>>> __when_expr_0 = NativeAPI::getServerListAndProcessClasses(&tr);
															#line 1426 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<GetStorageServersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5669 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetStorageServersActor*>(this)->actor_wait_state = 1;
															#line 1426 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*>(static_cast<GetStorageServersActor*>(this)));
															#line 5674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<GetStorageServersActor*>(this)->SAV<Optional<PrimaryAndRemoteAddresses>>::futures) { (void)(ret); this->~GetStorageServersActorState(); static_cast<GetStorageServersActor*>(this)->destroy(); return 0; }
															#line 5703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<GetStorageServersActor*>(this)->SAV< Optional<PrimaryAndRemoteAddresses> >::value()) Optional<PrimaryAndRemoteAddresses>(std::move(ret)); // state_var_RVO
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1449 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 5716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 1450 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("GetStorageServersError").error(e);
															#line 5720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
															#line 1428 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		PrimaryAndRemoteAddresses storageServers;
															#line 1429 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		const auto primaryDCId = getPrimaryDCId(dbInfo->get());
															#line 1430 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& [ssi, _] : results ) {
															#line 1431 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			const bool primarySS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() == primaryDCId.get();
															#line 1433 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			const bool remoteSS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() != primaryDCId.get();
															#line 1435 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_PRIMARY_SS_TO_COMPLAIN && primarySS)
															#line 5746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 1436 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				storageServers.primary.push_back(ssi.address());
															#line 1437 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (ssi.secondaryAddress().present())
															#line 5752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 1438 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.primary.push_back(ssi.secondaryAddress().get());
															#line 5756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
			}
			else
			{
															#line 1440 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_REMOTE_SS_TO_COMPLAIN && remoteSS)
															#line 5763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 1441 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.remote.push_back(ssi.address());
															#line 1442 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					if (ssi.secondaryAddress().present())
															#line 5769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
					{
															#line 1443 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
						storageServers.remote.push_back(ssi.secondaryAddress().get());
															#line 5773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
					}
				}
			}
		}
															#line 1447 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		ret = storageServers;
															#line 5780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
															#line 1428 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		PrimaryAndRemoteAddresses storageServers;
															#line 1429 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		const auto primaryDCId = getPrimaryDCId(dbInfo->get());
															#line 1430 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& [ssi, _] : results ) {
															#line 1431 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			const bool primarySS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() == primaryDCId.get();
															#line 1433 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			const bool remoteSS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() != primaryDCId.get();
															#line 1435 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_PRIMARY_SS_TO_COMPLAIN && primarySS)
															#line 5799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 1436 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				storageServers.primary.push_back(ssi.address());
															#line 1437 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (ssi.secondaryAddress().present())
															#line 5805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 1438 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.primary.push_back(ssi.secondaryAddress().get());
															#line 5809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
			}
			else
			{
															#line 1440 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_REMOTE_SS_TO_COMPLAIN && remoteSS)
															#line 5816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 1441 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.remote.push_back(ssi.address());
															#line 1442 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					if (ssi.secondaryAddress().present())
															#line 5822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
					{
															#line 1443 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
						storageServers.remote.push_back(ssi.secondaryAddress().get());
															#line 5826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
					}
				}
			}
		}
															#line 1447 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		ret = storageServers;
															#line 5833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont2(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageServersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServersActor*>(this)->ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> const& value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> && value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Database db;
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1420 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Optional<PrimaryAndRemoteAddresses> ret;
															#line 1421 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Transaction tr;
															#line 5934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via getStorageServers()
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class GetStorageServersActor final : public Actor<Optional<PrimaryAndRemoteAddresses>>, public ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >, public FastAllocated<GetStorageServersActor>, public GetStorageServersActorState<GetStorageServersActor> {
															#line 5939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<GetStorageServersActor>::operator new;
	using FastAllocated<GetStorageServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13263956755171026176UL, 14922744558777005824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<PrimaryAndRemoteAddresses>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >;
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	GetStorageServersActor(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 5956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Optional<PrimaryAndRemoteAddresses>>(),
		   GetStorageServersActorState<GetStorageServersActor>(db, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(503193769027834112UL, 12559137560131112960UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Optional<PrimaryAndRemoteAddresses>> getStorageServers( Database const& db, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Optional<PrimaryAndRemoteAddresses>>(new GetStorageServersActor(db, dbInfo));
															#line 5989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 1455 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

// The actor that actively monitors the health of local and peer servers, and reports anomaly to the cluster controller.
															#line 5995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via healthMonitor()
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class HealthMonitorActor>
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class HealthMonitorActorState {
															#line 6002 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	HealthMonitorActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,LocalityData const& locality,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<AsyncVar<bool>> const& enablePrimaryTxnSystemHealthCheck) 
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : ccInterface(ccInterface),
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   interf(interf),
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   locality(locality),
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   enablePrimaryTxnSystemHealthCheck(enablePrimaryTxnSystemHealthCheck),
															#line 1462 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   req(),
															#line 1463 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   db()
															#line 6021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("healthMonitor", reinterpret_cast<unsigned long>(this));

	}
	~HealthMonitorActorState() 
	{
		fdb_probe_actor_destroy("healthMonitor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1464 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_PRIMARY_SS_TO_COMPLAIN || SERVER_KNOBS->GRAY_FAILURE_ALLOW_REMOTE_SS_TO_COMPLAIN)
															#line 6036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 1466 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				db = openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, LockAware::True);
															#line 6040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
															#line 1468 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 6044 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HealthMonitorActorState();
		static_cast<HealthMonitorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1469 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		nextHealthCheckDelay = Never();
															#line 1470 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		const RecoveryState& recoveryState = dbInfo->get().recoveryState;
															#line 1471 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		const bool primaryTxnSystemHealthCheckEnabled = enablePrimaryTxnSystemHealthCheck->get();
															#line 1472 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		const bool ccInterfacePresent = ccInterface->get().present();
															#line 1473 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent(SevInfo, "WorkerHealthMonitor") .detail("DBInfoRecoveryState", recoveryState) .detail("PrimaryTxnSystemHealthCheckEnabled", primaryTxnSystemHealthCheckEnabled) .detail("CCInterfacePresent", ccInterface->get().present());
															#line 1477 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if ((recoveryState >= RecoveryState::ACCEPTING_COMMITS || primaryTxnSystemHealthCheckEnabled) && ccInterfacePresent)
															#line 6084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 1479 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			nextHealthCheckDelay = delay(SERVER_KNOBS->WORKER_HEALTH_MONITOR_INTERVAL);
															#line 1480 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			storageServers = Optional<PrimaryAndRemoteAddresses>();
															#line 1481 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (db.present())
															#line 6092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 1482 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(storageServers, getStorageServers(db.get(), dbInfo));
															#line 1482 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<HealthMonitorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<HealthMonitorActor*>(this)->actor_wait_state = 1;
															#line 1482 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 0, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 6103 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1508 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = nextHealthCheckDelay;
															#line 1507 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<HealthMonitorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 1509 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = ccInterface->onChange();
															#line 6128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
															#line 1510 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = dbInfo->onChange();
															#line 6132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when3(__when_expr_3.get(), loopDepth); };
															#line 1511 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = enablePrimaryTxnSystemHealthCheck->onChange();
															#line 6136 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when4(__when_expr_4.get(), loopDepth); };
		static_cast<HealthMonitorActor*>(this)->actor_wait_state = 2;
															#line 1508 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 1, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 1509 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 2, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 1510 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 3, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 1511 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 4, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 6147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1484 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req = doPeerHealthCheck(interf, locality, dbInfo, req, enablePrimaryTxnSystemHealthCheck, storageServers);
															#line 1486 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!req.disconnectedPeers.empty() || !req.degradedPeers.empty() || !req.recoveredPeers.empty())
															#line 6158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 1487 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (g_network->isSimulated())
															#line 6162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 1490 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				for( const auto& recoveredPeer : req.recoveredPeers ) {
															#line 1491 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					for( const auto& disconnectedPeer : req.disconnectedPeers ) {
															#line 1492 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
						ASSERT(recoveredPeer != disconnectedPeer);
															#line 6170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
					}
															#line 1494 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					for( const auto& degradedPeer : req.degradedPeers ) {
															#line 1495 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
						ASSERT(recoveredPeer != degradedPeer);
															#line 6176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
					}
				}
			}
															#line 1501 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			req.address = FlowTransport::transport().getLocalAddress();
															#line 1502 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (ccInterface->get().present())
															#line 6184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 1503 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				ccInterface->get().get().updateWorkerHealth.send(req);
															#line 6188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HealthMonitorActor*>(this)->actor_wait_state > 0) static_cast<HealthMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HealthMonitorActor*>(this)->actor_wait_state > 0) static_cast<HealthMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 1, Void >::remove();
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 2, Void >::remove();
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 3, Void >::remove();
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	WorkerInterface interf;
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	LocalityData locality;
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<bool>> enablePrimaryTxnSystemHealthCheck;
															#line 1462 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UpdateWorkerHealthRequest req;
															#line 1463 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Optional<Database> db;
															#line 1469 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> nextHealthCheckDelay;
															#line 1480 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Optional<PrimaryAndRemoteAddresses> storageServers;
															#line 6591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via healthMonitor()
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class HealthMonitorActor final : public Actor<Void>, public ActorCallback< HealthMonitorActor, 0, Void >, public ActorCallback< HealthMonitorActor, 1, Void >, public ActorCallback< HealthMonitorActor, 2, Void >, public ActorCallback< HealthMonitorActor, 3, Void >, public ActorCallback< HealthMonitorActor, 4, Void >, public FastAllocated<HealthMonitorActor>, public HealthMonitorActorState<HealthMonitorActor> {
															#line 6596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<HealthMonitorActor>::operator new;
	using FastAllocated<HealthMonitorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11235525010668288UL, 3903935152745721600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HealthMonitorActor, 0, Void >;
friend struct ActorCallback< HealthMonitorActor, 1, Void >;
friend struct ActorCallback< HealthMonitorActor, 2, Void >;
friend struct ActorCallback< HealthMonitorActor, 3, Void >;
friend struct ActorCallback< HealthMonitorActor, 4, Void >;
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	HealthMonitorActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,LocalityData const& locality,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<AsyncVar<bool>> const& enablePrimaryTxnSystemHealthCheck) 
															#line 6617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   HealthMonitorActorState<HealthMonitorActor>(ccInterface, interf, locality, dbInfo, enablePrimaryTxnSystemHealthCheck),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11146410862898602752UL, 8671132782290732288UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("healthMonitor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HealthMonitorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HealthMonitorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> healthMonitor( Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, WorkerInterface const& interf, LocalityData const& locality, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Reference<AsyncVar<bool>> const& enablePrimaryTxnSystemHealthCheck ) {
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new HealthMonitorActor(ccInterface, interf, locality, dbInfo, enablePrimaryTxnSystemHealthCheck));
															#line 6651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 1515 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

#if (defined(__linux__) || defined(__FreeBSD__)) && defined(USE_GPERFTOOLS)
// A set of threads that should be profiled
std::set<std::thread::id> profiledThreads;

// Returns whether or not a given thread should be profiled
int filter_in_thread(void* arg) {
	return profiledThreads.contains(std::this_thread::get_id()) ? 1 : 0;
}
#endif

// Enables the calling thread to be profiled
void registerThreadForProfiling() {
#if (defined(__linux__) || defined(__FreeBSD__)) && defined(USE_GPERFTOOLS)
	// Not sure if this is actually needed, but a call to backtrace was advised here:
	// http://groups.google.com/group/google-perftools/browse_thread/thread/0dfd74532e038eb8/2686d9f24ac4365f?pli=1
	profiledThreads.insert(std::this_thread::get_id());
	const int num_levels = 100;
	void* pc[num_levels];
	backtrace(pc, num_levels);
#endif
}

// Starts or stops the CPU profiler
void updateCpuProfiler(ProfilerRequest req) {
	switch (req.type) {
	case ProfilerRequest::Type::GPROF:
#if (defined(__linux__) || defined(__FreeBSD__)) && defined(USE_GPERFTOOLS) && !defined(VALGRIND)
		switch (req.action) {
		case ProfilerRequest::Action::ENABLE: {
			const char* path = (const char*)req.outputFile.begin();
			ProfilerOptions* options = new ProfilerOptions();
			options->filter_in_thread = &filter_in_thread;
			options->filter_in_thread_arg = nullptr;
			ProfilerStartWithOptions(path, options);
			break;
		}
		case ProfilerRequest::Action::DISABLE:
			ProfilerStop();
			break;
		case ProfilerRequest::Action::RUN:
			ASSERT(false); // User should have called runProfiler.
			break;
		}
#endif
		break;
	case ProfilerRequest::Type::FLOW:
		switch (req.action) {
		case ProfilerRequest::Action::ENABLE:
			startProfiling(g_network, {}, req.outputFile);
			break;
		case ProfilerRequest::Action::DISABLE:
			stopProfiling();
			break;
		case ProfilerRequest::Action::RUN:
			ASSERT(false); // User should have called runProfiler.
			break;
		}
		break;
	default:
		ASSERT(false);
		break;
	}
}

															#line 6720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via runCpuProfiler()
															#line 1580 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class RunCpuProfilerActor>
															#line 1580 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class RunCpuProfilerActorState {
															#line 6727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 1580 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	RunCpuProfilerActorState(ProfilerRequest const& req) 
															#line 1580 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 1580 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : req(req)
															#line 6734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("runCpuProfiler", reinterpret_cast<unsigned long>(this));

	}
	~RunCpuProfilerActorState() 
	{
		fdb_probe_actor_destroy("runCpuProfiler", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1581 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (req.action == ProfilerRequest::Action::RUN)
															#line 6749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 1582 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				req.action = ProfilerRequest::Action::ENABLE;
															#line 1583 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				updateCpuProfiler(req);
															#line 1584 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(req.duration);
															#line 1584 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<RunCpuProfilerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6759 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunCpuProfilerActor*>(this)->actor_wait_state = 1;
															#line 1584 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunCpuProfilerActor, 0, Void >*>(static_cast<RunCpuProfilerActor*>(this)));
															#line 6764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1589 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				updateCpuProfiler(req);
															#line 1590 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<RunCpuProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCpuProfilerActorState(); static_cast<RunCpuProfilerActor*>(this)->destroy(); return 0; }
															#line 6773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				new (&static_cast<RunCpuProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RunCpuProfilerActorState();
				static_cast<RunCpuProfilerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunCpuProfilerActorState();
		static_cast<RunCpuProfilerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1585 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.action = ProfilerRequest::Action::DISABLE;
															#line 1586 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		updateCpuProfiler(req);
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<RunCpuProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCpuProfilerActorState(); static_cast<RunCpuProfilerActor*>(this)->destroy(); return 0; }
															#line 6804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<RunCpuProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunCpuProfilerActorState();
		static_cast<RunCpuProfilerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1585 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.action = ProfilerRequest::Action::DISABLE;
															#line 1586 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		updateCpuProfiler(req);
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<RunCpuProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCpuProfilerActorState(); static_cast<RunCpuProfilerActor*>(this)->destroy(); return 0; }
															#line 6820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<RunCpuProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunCpuProfilerActorState();
		static_cast<RunCpuProfilerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunCpuProfilerActor*>(this)->actor_wait_state > 0) static_cast<RunCpuProfilerActor*>(this)->actor_wait_state = 0;
		static_cast<RunCpuProfilerActor*>(this)->ActorCallback< RunCpuProfilerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCpuProfilerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunCpuProfilerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunCpuProfilerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1580 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ProfilerRequest req;
															#line 6905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via runCpuProfiler()
															#line 1580 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class RunCpuProfilerActor final : public Actor<Void>, public ActorCallback< RunCpuProfilerActor, 0, Void >, public FastAllocated<RunCpuProfilerActor>, public RunCpuProfilerActorState<RunCpuProfilerActor> {
															#line 6910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<RunCpuProfilerActor>::operator new;
	using FastAllocated<RunCpuProfilerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6383897963630718208UL, 10791161597101516032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunCpuProfilerActor, 0, Void >;
															#line 1580 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	RunCpuProfilerActor(ProfilerRequest const& req) 
															#line 6927 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   RunCpuProfilerActorState<RunCpuProfilerActor>(req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9421576084395799552UL, 13013016949884672512UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runCpuProfiler");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunCpuProfilerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1580 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> runCpuProfiler( ProfilerRequest const& req ) {
															#line 1580 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RunCpuProfilerActor(req));
															#line 6960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 1593 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

void runHeapProfiler(const char* msg) {
#if defined(__linux__) && defined(USE_GPERFTOOLS) && !defined(VALGRIND)
	if (IsHeapProfilerRunning()) {
		HeapProfilerDump(msg);
	} else {
		TraceEvent("ProfilerError").detail("Message", "HeapProfiler not running");
	}
#else
	TraceEvent("ProfilerError").detail("Message", "HeapProfiler Unsupported");
#endif
}

															#line 6977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via runProfiler()
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class RunProfilerActor>
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class RunProfilerActorState {
															#line 6984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	RunProfilerActorState(ProfilerRequest const& req) 
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : req(req)
															#line 6991 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("runProfiler", reinterpret_cast<unsigned long>(this));

	}
	~RunProfilerActorState() 
	{
		fdb_probe_actor_destroy("runProfiler", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1607 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (req.type == ProfilerRequest::Type::GPROF_HEAP)
															#line 7006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 1608 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				runHeapProfiler("User triggered heap dump");
															#line 7010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = a_body1cont1(loopDepth);
			}
			else
			{
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = runCpuProfiler(req);
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<RunProfilerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunProfilerActor*>(this)->actor_wait_state = 1;
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunProfilerActor, 0, Void >*>(static_cast<RunProfilerActor*>(this)));
															#line 7024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunProfilerActorState();
		static_cast<RunProfilerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1613 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<RunProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunProfilerActorState(); static_cast<RunProfilerActor*>(this)->destroy(); return 0; }
															#line 7048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<RunProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunProfilerActorState();
		static_cast<RunProfilerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunProfilerActor*>(this)->actor_wait_state > 0) static_cast<RunProfilerActor*>(this)->actor_wait_state = 0;
		static_cast<RunProfilerActor*>(this)->ActorCallback< RunProfilerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunProfilerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunProfilerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunProfilerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ProfilerRequest req;
															#line 7145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via runProfiler()
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class RunProfilerActor final : public Actor<Void>, public ActorCallback< RunProfilerActor, 0, Void >, public FastAllocated<RunProfilerActor>, public RunProfilerActorState<RunProfilerActor> {
															#line 7150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<RunProfilerActor>::operator new;
	using FastAllocated<RunProfilerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10261619958572082944UL, 7194945268556093696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunProfilerActor, 0, Void >;
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	RunProfilerActor(ProfilerRequest const& req) 
															#line 7167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   RunProfilerActorState<RunProfilerActor>(req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14649713953804097280UL, 18193392918468773120UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runProfiler");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunProfilerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> runProfiler( ProfilerRequest const& req ) {
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RunProfilerActor(req));
															#line 7200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 1615 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

bool checkHighMemory(int64_t threshold, bool* error) {
#if defined(__linux__) && defined(USE_GPERFTOOLS) && !defined(VALGRIND)
	*error = false;
	uint64_t page_size = sysconf(_SC_PAGESIZE);
	int fd = open("/proc/self/statm", O_RDONLY | O_CLOEXEC);
	if (fd < 0) {
		TraceEvent("OpenStatmFileFailure").log();
		*error = true;
		return false;
	}

	const int buf_sz = 256;
	char stat_buf[buf_sz];
	ssize_t stat_nread = read(fd, stat_buf, buf_sz);
	if (stat_nread < 0) {
		TraceEvent("ReadStatmFileFailure").log();
		*error = true;
		return false;
	}

	uint64_t vmsize, rss;
	sscanf(stat_buf, "%lu %lu", &vmsize, &rss);
	rss *= page_size;
	if (rss >= threshold) {
		return true;
	}
#else
	TraceEvent("CheckHighMemoryUnsupported").log();
	*error = true;
#endif
	return false;
}

// Runs heap profiler when RSS memory usage is high.
															#line 7239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorHighMemory()
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class MonitorHighMemoryActor>
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class MonitorHighMemoryActorState {
															#line 7246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	MonitorHighMemoryActorState(int64_t const& threshold) 
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : threshold(threshold)
															#line 7253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorHighMemory", reinterpret_cast<unsigned long>(this));

	}
	~MonitorHighMemoryActorState() 
	{
		fdb_probe_actor_destroy("monitorHighMemory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1651 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (threshold <= 0)
															#line 7268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 1652 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<MonitorHighMemoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorHighMemoryActorState(); static_cast<MonitorHighMemoryActor*>(this)->destroy(); return 0; }
															#line 7272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				new (&static_cast<MonitorHighMemoryActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~MonitorHighMemoryActorState();
				static_cast<MonitorHighMemoryActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1654 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 7280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorHighMemoryActorState();
		static_cast<MonitorHighMemoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1664 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<MonitorHighMemoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorHighMemoryActorState(); static_cast<MonitorHighMemoryActor*>(this)->destroy(); return 0; }
															#line 7303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<MonitorHighMemoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MonitorHighMemoryActorState();
		static_cast<MonitorHighMemoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1655 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		bool err = false;
															#line 1656 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		bool highmem = checkHighMemory(threshold, &err);
															#line 1657 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (err)
															#line 7326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1660 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (highmem)
															#line 7332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 1661 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			runHeapProfiler("Highmem heap dump");
															#line 7336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 1662 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->HEAP_PROFILER_INTERVAL);
															#line 1662 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state = 1;
															#line 1662 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorHighMemoryActor, 0, Void >*>(static_cast<MonitorHighMemoryActor*>(this)));
															#line 7347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state > 0) static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorHighMemoryActor*>(this)->ActorCallback< MonitorHighMemoryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorHighMemoryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorHighMemoryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorHighMemoryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	int64_t threshold;
															#line 7454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via monitorHighMemory()
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class MonitorHighMemoryActor final : public Actor<Void>, public ActorCallback< MonitorHighMemoryActor, 0, Void >, public FastAllocated<MonitorHighMemoryActor>, public MonitorHighMemoryActorState<MonitorHighMemoryActor> {
															#line 7459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<MonitorHighMemoryActor>::operator new;
	using FastAllocated<MonitorHighMemoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4292978907582338048UL, 14403088070901179136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorHighMemoryActor, 0, Void >;
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	MonitorHighMemoryActor(int64_t const& threshold) 
															#line 7476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorHighMemoryActorState<MonitorHighMemoryActor>(threshold),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3552868021743521024UL, 13539544626851908096UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorHighMemory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorHighMemoryActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> monitorHighMemory( int64_t const& threshold ) {
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new MonitorHighMemoryActor(threshold));
															#line 7509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 1666 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

struct StorageDiskCleaner {
	KeyValueStoreType storeType;
	LocalityData locality;
	std::string filename;
	Future<Void> future;
};

struct TrackRunningStorage {
	UID self;
	KeyValueStoreType storeType;
	LocalityData locality;
	std::string filename;
	std::set<std::pair<UID, KeyValueStoreType>>* runningStorages;
	std::unordered_map<UID, StorageDiskCleaner>* storageCleaners;

	TrackRunningStorage(UID self,
	                    KeyValueStoreType storeType,
	                    LocalityData locality,
	                    const std::string& filename,
	                    std::set<std::pair<UID, KeyValueStoreType>>* runningStorages,
	                    std::unordered_map<UID, StorageDiskCleaner>* storageCleaners)
	  : self(self), storeType(storeType), locality(locality), filename(filename), runningStorages(runningStorages),
	    storageCleaners(storageCleaners) {
		TraceEvent("StorageServerAddedToRunningStorage", self);
		runningStorages->emplace(self, storeType);
	}
	~TrackRunningStorage() {
		runningStorages->erase(std::make_pair(self, storeType));
		TraceEvent("StorageServerRemoveFromRunningStorage", self);

		// Start a disk cleaner except for tss data store
		try {
			if (basename(filename).find(testingStoragePrefix.toString()) != 0) {
				if (!storageCleaners->contains(self)) {
					StorageDiskCleaner cleaner;
					cleaner.storeType = storeType;
					cleaner.locality = locality;
					cleaner.filename = filename;
					cleaner.future = Void(); // cleaner task will start later
					storageCleaners->insert({ self, cleaner });
					TraceEvent("AddStorageCleaner", self).detail("Size", storageCleaners->size());
				}
			}
		} catch (Error& e) {
			TraceEvent("SkipStorageCleaner", self).error(e).detail("File", filename);
		}
	};
};

															#line 7563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via storageServerRollbackRebooter()
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class StorageServerRollbackRebooterActor>
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class StorageServerRollbackRebooterActorState {
															#line 7570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	StorageServerRollbackRebooterActorState(std::set<std::pair<UID, KeyValueStoreType>>* const& runningStorages,std::unordered_map<UID, StorageDiskCleaner>* const& storageCleaners,Future<Void> const& prevStorageServer,KeyValueStoreType const& storeType,std::string const& filename,UID const& id,LocalityData const& locality,bool const& isTss,Reference<AsyncVar<ServerDBInfo> const> const& db,std::string const& folder,ActorCollection* const& filesClosed,int64_t const& memoryLimit,IKeyValueStore* const& store,bool const& validateDataFiles,Promise<Void>* const& rebootKVStore,Reference<GetEncryptCipherKeysMonitor> const& encryptionMonitor) 
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : runningStorages(runningStorages),
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   storageCleaners(storageCleaners),
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   prevStorageServer(prevStorageServer),
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   storeType(storeType),
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   filename(filename),
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   id(id),
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   locality(locality),
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   isTss(isTss),
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   db(db),
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   folder(folder),
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   filesClosed(filesClosed),
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   store(store),
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   validateDataFiles(validateDataFiles),
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   rebootKVStore(rebootKVStore),
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   encryptionMonitor(encryptionMonitor),
															#line 1732 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   _(id, storeType, locality, filename, runningStorages, storageCleaners)
															#line 7609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this));

	}
	~StorageServerRollbackRebooterActorState() 
	{
		fdb_probe_actor_destroy("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1733 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 7624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StorageServerRollbackRebooterActorState();
		static_cast<StorageServerRollbackRebooterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1734 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<ErrorOr<Void>> __when_expr_0 = errorOr(prevStorageServer);
															#line 1734 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 1;
															#line 1734 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*>(static_cast<StorageServerRollbackRebooterActor*>(this)));
															#line 7661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<Void> const& e,int loopDepth) 
	{
															#line 1735 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!e.isError())
															#line 7670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 1736 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<StorageServerRollbackRebooterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StorageServerRollbackRebooterActorState(); static_cast<StorageServerRollbackRebooterActor*>(this)->destroy(); return 0; }
															#line 7674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			new (&static_cast<StorageServerRollbackRebooterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StorageServerRollbackRebooterActorState();
			static_cast<StorageServerRollbackRebooterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1737 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() != error_code_please_reboot && e.getError().code() != error_code_please_reboot_kv_store)
															#line 7684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e.getError(), std::max(0, loopDepth - 1));
															#line 7688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 1741 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("StorageServerRequestedReboot", id) .detail("RebootStorageEngine", e.getError().code() == error_code_please_reboot_kv_store) .log();
															#line 1745 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_please_reboot_kv_store)
															#line 7695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 1747 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed->add(rebootKVStore->getFuture());
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->REBOOT_KV_STORE_DELAY);
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 2;
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*>(static_cast<StorageServerRollbackRebooterActor*>(this)));
															#line 7708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<Void> && e,int loopDepth) 
	{
															#line 1735 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!e.isError())
															#line 7722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 1736 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<StorageServerRollbackRebooterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StorageServerRollbackRebooterActorState(); static_cast<StorageServerRollbackRebooterActor*>(this)->destroy(); return 0; }
															#line 7726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			new (&static_cast<StorageServerRollbackRebooterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StorageServerRollbackRebooterActorState();
			static_cast<StorageServerRollbackRebooterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1737 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() != error_code_please_reboot && e.getError().code() != error_code_please_reboot_kv_store)
															#line 7736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 1739 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e.getError(), std::max(0, loopDepth - 1));
															#line 7740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 1741 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("StorageServerRequestedReboot", id) .detail("RebootStorageEngine", e.getError().code() == error_code_please_reboot_kv_store) .log();
															#line 1745 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_please_reboot_kv_store)
															#line 7747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 1747 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed->add(rebootKVStore->getFuture());
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->REBOOT_KV_STORE_DELAY);
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 2;
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*>(static_cast<StorageServerRollbackRebooterActor*>(this)));
															#line 7760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Void> const& e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(e, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Void> && e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(e), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state > 0) static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 0;
		static_cast<StorageServerRollbackRebooterActor*>(this)->ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1772 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StorageServerInterface recruited;
															#line 1773 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.uniqueID = id;
															#line 1774 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 1775 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.tssPairID = isTss ? Optional<UID>(UID()) : Optional<UID>();
															#line 1778 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 1780 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getValue);
															#line 1781 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKey);
															#line 1782 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValues);
															#line 1783 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getMappedKeyValues);
															#line 1784 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getShardState);
															#line 1785 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitMetrics);
															#line 1786 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.splitMetrics);
															#line 1787 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getReadHotRanges);
															#line 1788 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 1789 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageMetrics);
															#line 1790 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 1791 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 1792 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 1793 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.watchValue);
															#line 1794 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValuesStream);
															#line 1795 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedStream);
															#line 1796 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedPop);
															#line 1797 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 1799 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Future<ErrorOr<Void>> storeError = errorOr(store->getError());
															#line 1800 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		prevStorageServer = storageServer(store, recruited, db, folder, Promise<Void>(), Reference<IClusterConnectionRecord>(nullptr), encryptionMonitor);
															#line 1807 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		prevStorageServer = handleIOErrors(prevStorageServer, storeError, id, store->onClosed());
															#line 7899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 1750 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		store = openKVStore( storeType, filename, id, memoryLimit, false, validateDataFiles, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && deterministicRandom()->coinflip()) : true), db);
															#line 1763 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> nextRebootKVStorePromise;
															#line 1764 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed->add(store->onClosed() || nextRebootKVStorePromise .getFuture() );
															#line 1768 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->send(Void());
															#line 1769 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->swap(nextRebootKVStorePromise);
															#line 7916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 1750 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		store = openKVStore( storeType, filename, id, memoryLimit, false, validateDataFiles, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && deterministicRandom()->coinflip()) : true), db);
															#line 1763 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> nextRebootKVStorePromise;
															#line 1764 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed->add(store->onClosed() || nextRebootKVStorePromise .getFuture() );
															#line 1768 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->send(Void());
															#line 1769 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->swap(nextRebootKVStorePromise);
															#line 7933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state > 0) static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 0;
		static_cast<StorageServerRollbackRebooterActor*>(this)->ActorCallback< StorageServerRollbackRebooterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::set<std::pair<UID, KeyValueStoreType>>* runningStorages;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::unordered_map<UID, StorageDiskCleaner>* storageCleaners;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> prevStorageServer;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	KeyValueStoreType storeType;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string filename;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	LocalityData locality;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	bool isTss;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ActorCollection* filesClosed;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryLimit;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	IKeyValueStore* store;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	bool validateDataFiles;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void>* rebootKVStore;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<GetEncryptCipherKeysMonitor> encryptionMonitor;
															#line 1732 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	TrackRunningStorage _;
															#line 8047 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via storageServerRollbackRebooter()
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class StorageServerRollbackRebooterActor final : public Actor<Void>, public ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >, public ActorCallback< StorageServerRollbackRebooterActor, 1, Void >, public FastAllocated<StorageServerRollbackRebooterActor>, public StorageServerRollbackRebooterActorState<StorageServerRollbackRebooterActor> {
															#line 8052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<StorageServerRollbackRebooterActor>::operator new;
	using FastAllocated<StorageServerRollbackRebooterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11528904607349462528UL, 12565978959867284480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >;
friend struct ActorCallback< StorageServerRollbackRebooterActor, 1, Void >;
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	StorageServerRollbackRebooterActor(std::set<std::pair<UID, KeyValueStoreType>>* const& runningStorages,std::unordered_map<UID, StorageDiskCleaner>* const& storageCleaners,Future<Void> const& prevStorageServer,KeyValueStoreType const& storeType,std::string const& filename,UID const& id,LocalityData const& locality,bool const& isTss,Reference<AsyncVar<ServerDBInfo> const> const& db,std::string const& folder,ActorCollection* const& filesClosed,int64_t const& memoryLimit,IKeyValueStore* const& store,bool const& validateDataFiles,Promise<Void>* const& rebootKVStore,Reference<GetEncryptCipherKeysMonitor> const& encryptionMonitor) 
															#line 8070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   StorageServerRollbackRebooterActorState<StorageServerRollbackRebooterActor>(runningStorages, storageCleaners, prevStorageServer, storeType, filename, id, locality, isTss, db, folder, filesClosed, memoryLimit, store, validateDataFiles, rebootKVStore, encryptionMonitor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9711723034093058560UL, 17546821082729568512UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("storageServerRollbackRebooter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> storageServerRollbackRebooter( std::set<std::pair<UID, KeyValueStoreType>>* const& runningStorages, std::unordered_map<UID, StorageDiskCleaner>* const& storageCleaners, Future<Void> const& prevStorageServer, KeyValueStoreType const& storeType, std::string const& filename, UID const& id, LocalityData const& locality, bool const& isTss, Reference<AsyncVar<ServerDBInfo> const> const& db, std::string const& folder, ActorCollection* const& filesClosed, int64_t const& memoryLimit, IKeyValueStore* const& store, bool const& validateDataFiles, Promise<Void>* const& rebootKVStore, Reference<GetEncryptCipherKeysMonitor> const& encryptionMonitor ) {
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new StorageServerRollbackRebooterActor(runningStorages, storageCleaners, prevStorageServer, storeType, filename, id, locality, isTss, db, folder, filesClosed, memoryLimit, store, validateDataFiles, rebootKVStore, encryptionMonitor));
															#line 8104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 1810 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

// FIXME:  This will not work correctly in simulation as all workers would share the same roles map
std::set<std::pair<std::string, std::string>> g_roles;

Standalone<StringRef> roleString(std::set<std::pair<std::string, std::string>> roles, bool with_ids) {
	std::string result;
	for (auto& r : roles) {
		if (!result.empty())
			result.append(",");
		result.append(r.first);
		if (with_ids) {
			result.append(":");
			result.append(r.second);
		}
	}
	return StringRef(result);
}

void startRole(const Role& role,
               UID roleId,
               UID workerId,
               const std::map<std::string, std::string>& details,
               const std::string& origination) {
	if (role.includeInTraceRoles) {
		addTraceRole(role.abbreviation);
	}

	TraceEvent ev("Role", roleId);
	ev.detail("As", role.roleName)
	    .detail("Transition", "Begin")
	    .detail("Origination", origination)
	    .detail("OnWorker", workerId);
	for (auto it = details.begin(); it != details.end(); it++)
		ev.detail(it->first.c_str(), it->second);

	ev.trackLatest(roleId.shortString() + ".Role");

	// Update roles map, log Roles metrics
	g_roles.insert({ role.roleName, roleId.shortString() });
	StringMetricHandle("Roles"_sr) = roleString(g_roles, false);
	StringMetricHandle("RolesWithIDs"_sr) = roleString(g_roles, true);
	if (g_network->isSimulated())
		g_simulator->addRole(g_network->getLocalAddress(), role.roleName);
}

void endRole(const Role& role, UID id, std::string reason, bool ok, Error e) {
	{
		TraceEvent ev("Role", id);
		if (e.code() != invalid_error_code)
			ev.errorUnsuppressed(e);
		ev.detail("Transition", "End").detail("As", role.roleName).detail("Reason", reason);

		ev.trackLatest(id.shortString() + ".Role");
	}

	if (!ok) {
		// Some errors are expected operational events, not actual failures
		// These should not be logged as SevError
		bool isExpectedError = (e.code() == error_code_audit_storage_task_outdated);

		if (isExpectedError) {
			TraceEvent(SevInfo, "ExpectedRoleFailureSuppressed", id)
			    .detail("Role", role.roleName)
			    .detail("ErrorCode", e.code())
			    .detail("ErrorName", e.name())
			    .detail("Reason", reason);
		}

		std::string type = role.roleName + "Failed";

		TraceEvent err(isExpectedError ? SevInfo : SevError, type.c_str(), id);
		if (e.code() != invalid_error_code) {
			err.errorUnsuppressed(e);
		}
		err.detail("Reason", reason);
	}

	latestEventCache.clear(id.shortString());

	// Update roles map, log Roles metrics
	g_roles.erase({ role.roleName, id.shortString() });
	StringMetricHandle("Roles"_sr) = roleString(g_roles, false);
	StringMetricHandle("RolesWithIDs"_sr) = roleString(g_roles, true);
	if (g_network->isSimulated())
		g_simulator->removeRole(g_network->getLocalAddress(), role.roleName);

	if (role.includeInTraceRoles) {
		removeTraceRole(role.abbreviation);
	}
}

															#line 8199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via traceRole()
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class TraceRoleActor>
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class TraceRoleActorState {
															#line 8206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	TraceRoleActorState(Role const& role,UID const& roleId) 
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : role(role),
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   roleId(roleId)
															#line 8215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("traceRole", reinterpret_cast<unsigned long>(this));

	}
	~TraceRoleActorState() 
	{
		fdb_probe_actor_destroy("traceRole", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1902 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 8230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TraceRoleActorState();
		static_cast<TraceRoleActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1903 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->WORKER_LOGGING_INTERVAL);
															#line 1903 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<TraceRoleActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TraceRoleActor*>(this)->actor_wait_state = 1;
															#line 1903 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TraceRoleActor, 0, Void >*>(static_cast<TraceRoleActor*>(this)));
															#line 8267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1904 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Role", roleId).detail("Transition", "Refresh").detail("As", role.roleName);
															#line 8276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1904 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Role", roleId).detail("Transition", "Refresh").detail("As", role.roleName);
															#line 8285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TraceRoleActor*>(this)->actor_wait_state > 0) static_cast<TraceRoleActor*>(this)->actor_wait_state = 0;
		static_cast<TraceRoleActor*>(this)->ActorCallback< TraceRoleActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TraceRoleActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TraceRoleActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TraceRoleActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Role role;
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UID roleId;
															#line 8369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via traceRole()
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class TraceRoleActor final : public Actor<Void>, public ActorCallback< TraceRoleActor, 0, Void >, public FastAllocated<TraceRoleActor>, public TraceRoleActorState<TraceRoleActor> {
															#line 8374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<TraceRoleActor>::operator new;
	using FastAllocated<TraceRoleActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11226672418167644160UL, 17591539090500891136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TraceRoleActor, 0, Void >;
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	TraceRoleActor(Role const& role,UID const& roleId) 
															#line 8391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   TraceRoleActorState<TraceRoleActor>(role, roleId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14398465994869201920UL, 9614722329871585280UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("traceRole");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TraceRoleActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> traceRole( Role const& role, UID const& roleId ) {
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new TraceRoleActor(role, roleId));
															#line 8424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 1907 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

															#line 8429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via workerSnapCreate()
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class WorkerSnapCreateActor>
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class WorkerSnapCreateActorState {
															#line 8436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapCreateActorState(WorkerSnapRequest const& snapReq,std::string const& snapFolder,std::map<std::string, WorkerSnapRequest>* const& snapReqMap,std::map<std::string, ErrorOr<Void>>* const& snapReqResultMap) 
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : snapReq(snapReq),
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   snapFolder(snapFolder),
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqMap(snapReqMap),
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqResultMap(snapReqResultMap),
															#line 1914 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   snapArg(snapReq.snapPayload),
															#line 1915 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqKey(snapReq.snapUID.toString() + snapReq.role.toString())
															#line 8453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("workerSnapCreate", reinterpret_cast<unsigned long>(this));

	}
	~WorkerSnapCreateActorState() 
	{
		fdb_probe_actor_destroy("workerSnapCreate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1917 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<int> __when_expr_0 = execHelper(&snapArg, snapReq.snapUID, snapFolder, snapReq.role.toString());
															#line 1917 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state = 1;
															#line 1917 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerSnapCreateActor, 0, int >*>(static_cast<WorkerSnapCreateActor*>(this)));
															#line 8476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerSnapCreateActorState();
		static_cast<WorkerSnapCreateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1944 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<WorkerSnapCreateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerSnapCreateActorState(); static_cast<WorkerSnapCreateActor*>(this)->destroy(); return 0; }
															#line 8505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<WorkerSnapCreateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerSnapCreateActorState();
		static_cast<WorkerSnapCreateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1935 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("ExecHelperError").errorUnsuppressed(e);
															#line 1936 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() != error_code_operation_cancelled)
															#line 8520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 1937 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap->at(snapReqKey).reply.sendError(e);
															#line 1938 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap->erase(snapReqKey);
															#line 1939 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				(*snapReqResultMap)[snapReqKey] = ErrorOr<Void>(e);
															#line 8528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 1941 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 8534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int const& err,int loopDepth) 
	{
															#line 1918 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::string uidStr = snapReq.snapUID.toString();
															#line 1919 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ExecTraceWorker") .detail("Uid", uidStr) .detail("Status", err) .detail("Role", snapReq.role) .detail("Value", snapFolder) .detail("ExecPayload", snapReq.snapPayload);
															#line 1925 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (err != 0)
															#line 8554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 1926 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch2(operation_failed(), loopDepth);
															#line 8558 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 1928 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReq.role.toString() == "storage")
															#line 8562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 1929 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			printStorageVersionInfo();
															#line 8566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 1931 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->at(snapReqKey).reply.send(Void());
															#line 1932 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->erase(snapReqKey);
															#line 1933 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		(*snapReqResultMap)[snapReqKey] = ErrorOr<Void>(Void());
															#line 8574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(int && err,int loopDepth) 
	{
															#line 1918 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::string uidStr = snapReq.snapUID.toString();
															#line 1919 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ExecTraceWorker") .detail("Uid", uidStr) .detail("Status", err) .detail("Role", snapReq.role) .detail("Value", snapFolder) .detail("ExecPayload", snapReq.snapPayload);
															#line 1925 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (err != 0)
															#line 8587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 1926 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch2(operation_failed(), loopDepth);
															#line 8591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 1928 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReq.role.toString() == "storage")
															#line 8595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 1929 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			printStorageVersionInfo();
															#line 8599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 1931 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->at(snapReqKey).reply.send(Void());
															#line 1932 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->erase(snapReqKey);
															#line 1933 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		(*snapReqResultMap)[snapReqKey] = ErrorOr<Void>(Void());
															#line 8607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int const& err,int loopDepth) 
	{
		loopDepth = a_body1cont2(err, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && err,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(err), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state > 0) static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerSnapCreateActor*>(this)->ActorCallback< WorkerSnapCreateActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerSnapCreateActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerSnapCreateActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerSnapCreateActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapRequest snapReq;
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string snapFolder;
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::map<std::string, WorkerSnapRequest>* snapReqMap;
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::map<std::string, ErrorOr<Void>>* snapReqResultMap;
															#line 1914 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ExecCmdValueString snapArg;
															#line 1915 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string snapReqKey;
															#line 8712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via workerSnapCreate()
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class WorkerSnapCreateActor final : public Actor<Void>, public ActorCallback< WorkerSnapCreateActor, 0, int >, public FastAllocated<WorkerSnapCreateActor>, public WorkerSnapCreateActorState<WorkerSnapCreateActor> {
															#line 8717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<WorkerSnapCreateActor>::operator new;
	using FastAllocated<WorkerSnapCreateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12836688767769981184UL, 8728469350576772608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerSnapCreateActor, 0, int >;
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapCreateActor(WorkerSnapRequest const& snapReq,std::string const& snapFolder,std::map<std::string, WorkerSnapRequest>* const& snapReqMap,std::map<std::string, ErrorOr<Void>>* const& snapReqResultMap) 
															#line 8734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   WorkerSnapCreateActorState<WorkerSnapCreateActor>(snapReq, snapFolder, snapReqMap, snapReqResultMap),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10166740224002249728UL, 13188349297975825664UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerSnapCreate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerSnapCreateActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> workerSnapCreate( WorkerSnapRequest const& snapReq, std::string const& snapFolder, std::map<std::string, WorkerSnapRequest>* const& snapReqMap, std::map<std::string, ErrorOr<Void>>* const& snapReqResultMap ) {
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new WorkerSnapCreateActor(snapReq, snapFolder, snapReqMap, snapReqResultMap));
															#line 8767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 1946 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

// TODO: `issues` is right now only updated by `monitorTraceLogIssues` and thus is being `set` on every update.
// It could be changed to `insert` and `trigger` later if we want to use it as a generic way for the caller of this
// function to report issues to cluster controller.
															#line 8775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorTraceLogIssues()
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class MonitorTraceLogIssuesActor>
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class MonitorTraceLogIssuesActorState {
															#line 8782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	MonitorTraceLogIssuesActorState(Reference<AsyncVar<std::set<std::string>>> const& issues) 
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : issues(issues),
															#line 1951 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   pingTimeout(false)
															#line 8791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this));

	}
	~MonitorTraceLogIssuesActorState() 
	{
		fdb_probe_actor_destroy("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1952 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 8806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorTraceLogIssuesActorState();
		static_cast<MonitorTraceLogIssuesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1953 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->TRACE_LOG_FLUSH_FAILURE_CHECK_INTERVAL_SECONDS);
															#line 1953 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 1;
															#line 1953 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*>(static_cast<MonitorTraceLogIssuesActor*>(this)));
															#line 8843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1954 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> pingAck = pingTraceLogWriterThread();
															#line 8852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		try {
															#line 1956 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = timeoutError(pingAck, SERVER_KNOBS->TRACE_LOG_PING_TIMEOUT_SECONDS);
															#line 1956 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 8858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 2;
															#line 1956 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*>(static_cast<MonitorTraceLogIssuesActor*>(this)));
															#line 8863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1954 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> pingAck = pingTraceLogWriterThread();
															#line 8878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		try {
															#line 1956 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = timeoutError(pingAck, SERVER_KNOBS->TRACE_LOG_PING_TIMEOUT_SECONDS);
															#line 1956 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 8884 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 2;
															#line 1956 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*>(static_cast<MonitorTraceLogIssuesActor*>(this)));
															#line 8889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state > 0) static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorTraceLogIssuesActor*>(this)->ActorCallback< MonitorTraceLogIssuesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1964 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::set<std::string> _issues;
															#line 1965 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		retrieveTraceLogIssues(_issues);
															#line 1966 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (pingTimeout)
															#line 8983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 1968 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			_issues.insert("trace_log_writer_thread_unresponsive");
															#line 1969 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			pingTimeout = false;
															#line 8989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 1971 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		issues->set(_issues);
															#line 8993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1958 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 9003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 1959 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				pingTimeout = true;
															#line 9007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 1961 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state > 0) static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorTraceLogIssuesActor*>(this)->ActorCallback< MonitorTraceLogIssuesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<std::set<std::string>>> issues;
															#line 1951 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	bool pingTimeout;
															#line 9129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via monitorTraceLogIssues()
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class MonitorTraceLogIssuesActor final : public Actor<Void>, public ActorCallback< MonitorTraceLogIssuesActor, 0, Void >, public ActorCallback< MonitorTraceLogIssuesActor, 1, Void >, public FastAllocated<MonitorTraceLogIssuesActor>, public MonitorTraceLogIssuesActorState<MonitorTraceLogIssuesActor> {
															#line 9134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<MonitorTraceLogIssuesActor>::operator new;
	using FastAllocated<MonitorTraceLogIssuesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10577310022409540096UL, 11472380665312968960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorTraceLogIssuesActor, 0, Void >;
friend struct ActorCallback< MonitorTraceLogIssuesActor, 1, Void >;
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	MonitorTraceLogIssuesActor(Reference<AsyncVar<std::set<std::string>>> const& issues) 
															#line 9152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorTraceLogIssuesActorState<MonitorTraceLogIssuesActor>(issues),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17589411279920321024UL, 1269187454341278720UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorTraceLogIssues");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> monitorTraceLogIssues( Reference<AsyncVar<std::set<std::string>>> const& issues ) {
															#line 1950 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new MonitorTraceLogIssuesActor(issues));
															#line 9186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 1974 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

class SharedLogsKey {
	TLogVersion logVersion;
	TLogSpillType spillType;
	KeyValueStoreType storeType;

public:
	SharedLogsKey(const TLogOptions& options, KeyValueStoreType kvst)
	  : logVersion(options.version), spillType(options.spillType), storeType(kvst) {
		if (logVersion >= TLogVersion::V5)
			spillType = TLogSpillType::UNSET;
	}

	bool operator<(const SharedLogsKey& other) const {
		return std::tie(logVersion, spillType, storeType) <
		       std::tie(other.logVersion, other.spillType, other.storeType);
	}
};

struct SharedLogsValue {
	Future<Void> actor = Void();
	UID uid = UID();
	PromiseStream<InitializeTLogRequest> requests;

	SharedLogsValue() = default;
	SharedLogsValue(Future<Void> actor, UID uid, PromiseStream<InitializeTLogRequest> requests)
	  : actor(actor), uid(uid), requests(requests) {}
};

															#line 9219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via chaosMetricsLogger()
															#line 2003 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class ChaosMetricsLoggerActor>
															#line 2003 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class ChaosMetricsLoggerActorState {
															#line 9226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 2003 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ChaosMetricsLoggerActorState() 
															#line 2003 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	{
															#line 9232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		fdb_probe_actor_create("chaosMetricsLogger", reinterpret_cast<unsigned long>(this));

	}
	~ChaosMetricsLoggerActorState() 
	{
		fdb_probe_actor_destroy("chaosMetricsLogger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2005 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			auto res = g_network->global(INetwork::enChaosMetrics);
															#line 2006 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!res)
															#line 9248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2007 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<ChaosMetricsLoggerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChaosMetricsLoggerActorState(); static_cast<ChaosMetricsLoggerActor*>(this)->destroy(); return 0; }
															#line 9252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				new (&static_cast<ChaosMetricsLoggerActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ChaosMetricsLoggerActorState();
				static_cast<ChaosMetricsLoggerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2009 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			chaosMetrics = static_cast<ChaosMetrics*>(res);
															#line 2010 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			chaosMetrics->clear();
															#line 2012 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 9264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChaosMetricsLoggerActorState();
		static_cast<ChaosMetricsLoggerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2013 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(FLOW_KNOBS->CHAOS_LOGGING_INTERVAL);
															#line 2013 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state = 1;
															#line 2013 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChaosMetricsLoggerActor, 0, Void >*>(static_cast<ChaosMetricsLoggerActor*>(this)));
															#line 9301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2015 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("ChaosMetrics");
															#line 2016 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		double elapsed = now() - chaosMetrics->startTime;
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Elapsed", elapsed);
															#line 2018 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->getFields(&e);
															#line 2019 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.trackLatest("ChaosMetrics");
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->clear();
															#line 9320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2015 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("ChaosMetrics");
															#line 2016 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		double elapsed = now() - chaosMetrics->startTime;
															#line 2017 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Elapsed", elapsed);
															#line 2018 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->getFields(&e);
															#line 2019 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.trackLatest("ChaosMetrics");
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->clear();
															#line 9339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state > 0) static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state = 0;
		static_cast<ChaosMetricsLoggerActor*>(this)->ActorCallback< ChaosMetricsLoggerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChaosMetricsLoggerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChaosMetricsLoggerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChaosMetricsLoggerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2009 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ChaosMetrics* chaosMetrics;
															#line 9421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via chaosMetricsLogger()
															#line 2003 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class ChaosMetricsLoggerActor final : public Actor<Void>, public ActorCallback< ChaosMetricsLoggerActor, 0, Void >, public FastAllocated<ChaosMetricsLoggerActor>, public ChaosMetricsLoggerActorState<ChaosMetricsLoggerActor> {
															#line 9426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<ChaosMetricsLoggerActor>::operator new;
	using FastAllocated<ChaosMetricsLoggerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11955980596709373696UL, 71541777721918208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChaosMetricsLoggerActor, 0, Void >;
															#line 2003 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ChaosMetricsLoggerActor() 
															#line 9443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   ChaosMetricsLoggerActorState<ChaosMetricsLoggerActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11301253459754392576UL, 10330861438325872384UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("chaosMetricsLogger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChaosMetricsLoggerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2003 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> chaosMetricsLogger(  ) {
															#line 2003 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ChaosMetricsLoggerActor());
															#line 9476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 2023 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

static const std::string clusterIdFilename = "clusterId";

															#line 9483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via createClusterIdFile()
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class CreateClusterIdFileActor>
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class CreateClusterIdFileActorState {
															#line 9490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	CreateClusterIdFileActorState(std::string const& folder,UID const& clusterId) 
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : folder(folder),
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 2027 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   clusterIdPath(joinPath(folder, clusterIdFilename))
															#line 9501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("createClusterIdFile", reinterpret_cast<unsigned long>(this));

	}
	~CreateClusterIdFileActorState() 
	{
		fdb_probe_actor_destroy("createClusterIdFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2028 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (fileExists(clusterIdPath))
															#line 9516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2029 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<CreateClusterIdFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateClusterIdFileActorState(); static_cast<CreateClusterIdFileActor*>(this)->destroy(); return 0; }
															#line 9520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				new (&static_cast<CreateClusterIdFileActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CreateClusterIdFileActorState();
				static_cast<CreateClusterIdFileActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2031 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 9528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateClusterIdFileActorState();
		static_cast<CreateClusterIdFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2033 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<Reference<IAsyncFile>>> __when_expr_0 = errorOr(IAsyncFileSystem::filesystem(g_network)->open( clusterIdPath, IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_LOCK, 0600));
															#line 2033 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 1;
															#line 2033 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9566 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2054 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 9582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2055 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
															#line 2057 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!e.isInjectedFault())
															#line 9590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2058 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				fprintf(stderr, "ERROR: error creating or opening cluster id file `%s'.\n", joinPath(folder, clusterIdFilename).c_str());
															#line 9594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
															#line 2062 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevError, "OpenClusterIdError").error(e);
															#line 2063 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 2037 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (clusterIdFile.isError() && clusterIdFile.getError().code() == error_code_file_not_found && !fileExists(clusterIdPath))
															#line 9614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2039 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_1 = IAsyncFileSystem::filesystem()->open( clusterIdPath, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_LOCK | IAsyncFile::OPEN_READWRITE, 0600);
															#line 2039 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 2;
															#line 2039 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2051 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1loopBody1Catch1(clusterIdFile.getError(), loopDepth);
															#line 9632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Reference<IAsyncFile>> const& __clusterIdFile,int loopDepth) 
	{
															#line 2033 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		clusterIdFile = __clusterIdFile;
															#line 9641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Reference<IAsyncFile>> && __clusterIdFile,int loopDepth) 
	{
		clusterIdFile = std::move(__clusterIdFile);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*,ErrorOr<Reference<IAsyncFile>> const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*,ErrorOr<Reference<IAsyncFile>> && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Reference<IAsyncFile> const& _clusterIdFile,int loopDepth) 
	{
															#line 2044 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		clusterIdFile = _clusterIdFile;
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		BinaryWriter wr(IncludeVersion());
															#line 2046 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		wr << clusterId;
															#line 2047 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = clusterIdFile.get()->write(wr.getData(), wr.getLength(), 0);
															#line 2047 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 3;
															#line 2047 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 2, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Reference<IAsyncFile> && _clusterIdFile,int loopDepth) 
	{
															#line 2044 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		clusterIdFile = _clusterIdFile;
															#line 2045 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		BinaryWriter wr(IncludeVersion());
															#line 2046 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		wr << clusterId;
															#line 2047 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = clusterIdFile.get()->write(wr.getData(), wr.getLength(), 0);
															#line 2047 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 3;
															#line 2047 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 2, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<IAsyncFile> const& _clusterIdFile,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_clusterIdFile, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<IAsyncFile> && _clusterIdFile,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_clusterIdFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 2048 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = clusterIdFile.get()->sync();
															#line 2048 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 4;
															#line 2048 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 3, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 2048 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = clusterIdFile.get()->sync();
															#line 2048 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 4;
															#line 2048 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 3, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 9862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 2049 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<CreateClusterIdFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateClusterIdFileActorState(); static_cast<CreateClusterIdFileActor*>(this)->destroy(); return 0; }
															#line 9946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<CreateClusterIdFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateClusterIdFileActorState();
		static_cast<CreateClusterIdFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 2049 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<CreateClusterIdFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateClusterIdFileActorState(); static_cast<CreateClusterIdFileActor*>(this)->destroy(); return 0; }
															#line 9958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<CreateClusterIdFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateClusterIdFileActorState();
		static_cast<CreateClusterIdFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UID clusterId;
															#line 2027 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string clusterIdPath;
															#line 2033 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ErrorOr<Reference<IAsyncFile>> clusterIdFile;
															#line 10049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via createClusterIdFile()
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class CreateClusterIdFileActor final : public Actor<Void>, public ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >, public ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >, public ActorCallback< CreateClusterIdFileActor, 2, Void >, public ActorCallback< CreateClusterIdFileActor, 3, Void >, public FastAllocated<CreateClusterIdFileActor>, public CreateClusterIdFileActorState<CreateClusterIdFileActor> {
															#line 10054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<CreateClusterIdFileActor>::operator new;
	using FastAllocated<CreateClusterIdFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5434492089248238592UL, 2187298058653916416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >;
friend struct ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >;
friend struct ActorCallback< CreateClusterIdFileActor, 2, Void >;
friend struct ActorCallback< CreateClusterIdFileActor, 3, Void >;
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	CreateClusterIdFileActor(std::string const& folder,UID const& clusterId) 
															#line 10074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   CreateClusterIdFileActorState<CreateClusterIdFileActor>(folder, clusterId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2623832799678928640UL, 8068581988244134144UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createClusterIdFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> createClusterIdFile( std::string const& folder, UID const& clusterId ) {
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new CreateClusterIdFileActor(folder, clusterId));
															#line 10110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 2067 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

// Updates this processes cluster ID based off the cluster ID received in the
// ServerDBInfo. Persists the cluster ID to disk if it does not already exist.
															#line 10117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via updateClusterId()
															#line 2070 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class UpdateClusterIdActor>
															#line 2070 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class UpdateClusterIdActorState {
															#line 10124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 2070 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UpdateClusterIdActorState(UID const& ccClusterId,Reference<AsyncVar<Optional<UID>>> const& clusterId,std::string const& folder) 
															#line 2070 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 2070 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : ccClusterId(ccClusterId),
															#line 2070 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 2070 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   folder(folder)
															#line 10135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("updateClusterId", reinterpret_cast<unsigned long>(this));

	}
	~UpdateClusterIdActorState() 
	{
		fdb_probe_actor_destroy("updateClusterId", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2071 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!clusterId->get().present() && ccClusterId.isValid())
															#line 10150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2072 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = createClusterIdFile(folder, ccClusterId);
															#line 2072 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<UpdateClusterIdActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UpdateClusterIdActor*>(this)->actor_wait_state = 1;
															#line 2072 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateClusterIdActor, 0, Void >*>(static_cast<UpdateClusterIdActor*>(this)));
															#line 10161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateClusterIdActorState();
		static_cast<UpdateClusterIdActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2075 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<UpdateClusterIdActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateClusterIdActorState(); static_cast<UpdateClusterIdActor*>(this)->destroy(); return 0; }
															#line 10189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<UpdateClusterIdActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateClusterIdActorState();
		static_cast<UpdateClusterIdActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2073 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		clusterId->set(ccClusterId);
															#line 10201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2073 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		clusterId->set(ccClusterId);
															#line 10210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateClusterIdActor*>(this)->actor_wait_state > 0) static_cast<UpdateClusterIdActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateClusterIdActor*>(this)->ActorCallback< UpdateClusterIdActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateClusterIdActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateClusterIdActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateClusterIdActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2070 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UID ccClusterId;
															#line 2070 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<UID>>> clusterId;
															#line 2070 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 10296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via updateClusterId()
															#line 2070 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class UpdateClusterIdActor final : public Actor<Void>, public ActorCallback< UpdateClusterIdActor, 0, Void >, public FastAllocated<UpdateClusterIdActor>, public UpdateClusterIdActorState<UpdateClusterIdActor> {
															#line 10301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<UpdateClusterIdActor>::operator new;
	using FastAllocated<UpdateClusterIdActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7761511802047039232UL, 16573007482182485504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateClusterIdActor, 0, Void >;
															#line 2070 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UpdateClusterIdActor(UID const& ccClusterId,Reference<AsyncVar<Optional<UID>>> const& clusterId,std::string const& folder) 
															#line 10318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateClusterIdActorState<UpdateClusterIdActor>(ccClusterId, clusterId, folder),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10009873598315805184UL, 15517297218935779072UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateClusterId");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateClusterIdActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2070 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> updateClusterId( UID const& ccClusterId, Reference<AsyncVar<Optional<UID>>> const& clusterId, std::string const& folder ) {
															#line 2070 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new UpdateClusterIdActor(ccClusterId, clusterId, folder));
															#line 10351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 2077 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

															#line 10356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via deleteStorageFile()
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class DeleteStorageFileActor>
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class DeleteStorageFileActorState {
															#line 10363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	DeleteStorageFileActorState(KeyValueStoreType const& storeType,std::string const& filename,UID const& storeID,int64_t const& memoryLimit,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : storeType(storeType),
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   filename(filename),
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   storeID(storeID),
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 2083 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   kvs(openKVStore(storeType, filename, storeID, memoryLimit, false, false, false, dbInfo, {}))
															#line 10380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteStorageFile", reinterpret_cast<unsigned long>(this));

	}
	~DeleteStorageFileActorState() 
	{
		fdb_probe_actor_destroy("deleteStorageFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2084 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = ready(kvs->init());
															#line 2084 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<DeleteStorageFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteStorageFileActor*>(this)->actor_wait_state = 1;
															#line 2084 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteStorageFileActor, 0, Void >*>(static_cast<DeleteStorageFileActor*>(this)));
															#line 10402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteStorageFileActorState();
		static_cast<DeleteStorageFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2085 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("KVSRemoved").detail("Reason", "WorkerRemoved");
															#line 2086 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		kvs->dispose();
															#line 2087 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		CODE_PROBE(true, "Removed stale disk file");
															#line 2088 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RemoveStorageDisk").detail("Filename", filename).detail("StoreID", storeID);
															#line 2089 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<DeleteStorageFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteStorageFileActorState(); static_cast<DeleteStorageFileActor*>(this)->destroy(); return 0; }
															#line 10433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<DeleteStorageFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteStorageFileActorState();
		static_cast<DeleteStorageFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2085 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("KVSRemoved").detail("Reason", "WorkerRemoved");
															#line 2086 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		kvs->dispose();
															#line 2087 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		CODE_PROBE(true, "Removed stale disk file");
															#line 2088 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RemoveStorageDisk").detail("Filename", filename).detail("StoreID", storeID);
															#line 2089 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<DeleteStorageFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteStorageFileActorState(); static_cast<DeleteStorageFileActor*>(this)->destroy(); return 0; }
															#line 10453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<DeleteStorageFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteStorageFileActorState();
		static_cast<DeleteStorageFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteStorageFileActor*>(this)->actor_wait_state > 0) static_cast<DeleteStorageFileActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteStorageFileActor*>(this)->ActorCallback< DeleteStorageFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteStorageFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteStorageFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteStorageFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	KeyValueStoreType storeType;
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string filename;
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UID storeID;
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryLimit;
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 2083 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	IKeyValueStore* kvs;
															#line 10548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via deleteStorageFile()
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class DeleteStorageFileActor final : public Actor<Void>, public ActorCallback< DeleteStorageFileActor, 0, Void >, public FastAllocated<DeleteStorageFileActor>, public DeleteStorageFileActorState<DeleteStorageFileActor> {
															#line 10553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<DeleteStorageFileActor>::operator new;
	using FastAllocated<DeleteStorageFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9654114131283400704UL, 1354421258764901632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteStorageFileActor, 0, Void >;
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	DeleteStorageFileActor(KeyValueStoreType const& storeType,std::string const& filename,UID const& storeID,int64_t const& memoryLimit,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 10570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteStorageFileActorState<DeleteStorageFileActor>(storeType, filename, storeID, memoryLimit, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7303347310383014400UL, 15168961707397160448UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteStorageFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteStorageFileActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> deleteStorageFile( KeyValueStoreType const& storeType, std::string const& filename, UID const& storeID, int64_t const& memoryLimit, Reference<AsyncVar<ServerDBInfo>> const& dbInfo ) {
															#line 2078 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new DeleteStorageFileActor(storeType, filename, storeID, memoryLimit, dbInfo));
															#line 10603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 2091 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

															#line 10608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via cleanupStaleStorageDisk()
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class CleanupStaleStorageDiskActor>
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class CleanupStaleStorageDiskActorState {
															#line 10615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	CleanupStaleStorageDiskActorState(Reference<AsyncVar<ServerDBInfo>> const& dbInfo,std::unordered_map<UID, StorageDiskCleaner>* const& cleaners,UID const& storeID,StorageDiskCleaner const& cleaner,int64_t const& memoryLimit) 
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : dbInfo(dbInfo),
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   cleaners(cleaners),
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   storeID(storeID),
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   cleaner(cleaner),
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 2097 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   retries(0)
															#line 10632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this));

	}
	~CleanupStaleStorageDiskActorState() 
	{
		fdb_probe_actor_destroy("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2098 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 10647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CleanupStaleStorageDiskActorState();
		static_cast<CleanupStaleStorageDiskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2100 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (retries > SERVER_KNOBS->STORAGE_DISK_CLEANUP_MAX_RETRIES)
															#line 10678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2101 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("SkipDiskCleanup").detail("Filename", cleaner.filename).detail("StoreID", storeID);
															#line 2102 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<CleanupStaleStorageDiskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupStaleStorageDiskActorState(); static_cast<CleanupStaleStorageDiskActor*>(this)->destroy(); return 0; }
															#line 10684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				new (&static_cast<CleanupStaleStorageDiskActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CleanupStaleStorageDiskActorState();
				static_cast<CleanupStaleStorageDiskActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2105 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerLivenessCheck").detail("StoreID", storeID).detail("Retry", retries);
															#line 2106 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Reference<CommitProxyInfo> commitProxies(new CommitProxyInfo(dbInfo->get().client.commitProxies));
															#line 2107 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (commitProxies->size() == 0)
															#line 10696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2108 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("SkipDiskCleanup").log();
															#line 2109 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<CleanupStaleStorageDiskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupStaleStorageDiskActorState(); static_cast<CleanupStaleStorageDiskActor*>(this)->destroy(); return 0; }
															#line 10702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				new (&static_cast<CleanupStaleStorageDiskActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CleanupStaleStorageDiskActorState();
				static_cast<CleanupStaleStorageDiskActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2111 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			GetStorageServerRejoinInfoRequest request(storeID, cleaner.locality.dcId());
															#line 2112 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<GetStorageServerRejoinInfoReply> __when_expr_0 = basicLoadBalance(commitProxies, &CommitProxyInterface::getStorageServerRejoinInfo, request);
															#line 2112 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 1;
															#line 2112 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*>(static_cast<CleanupStaleStorageDiskActor*>(this)));
															#line 10719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2129 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->STORAGE_DISK_CLEANUP_RETRY_INTERVAL);
															#line 2129 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 3;
															#line 2129 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*>(static_cast<CleanupStaleStorageDiskActor*>(this)));
															#line 10741 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2118 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() == error_code_worker_removed)
															#line 10751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2120 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (fileExists(cleaner.filename))
															#line 10755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 2121 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					StrictFuture<Void> __when_expr_1 = deleteStorageFile(cleaner.storeType, cleaner.filename, storeID, memoryLimit, dbInfo);
															#line 2121 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
					static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 2;
															#line 2121 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*>(static_cast<CleanupStaleStorageDiskActor*>(this)));
															#line 10766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(GetStorageServerRejoinInfoReply const& _rep,int loopDepth) 
	{
															#line 2115 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		retries++;
															#line 10791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(GetStorageServerRejoinInfoReply && _rep,int loopDepth) 
	{
															#line 2115 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		retries++;
															#line 10800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetStorageServerRejoinInfoReply const& _rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_rep, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetStorageServerRejoinInfoReply && _rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state > 0) static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupStaleStorageDiskActor*>(this)->ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*,GetStorageServerRejoinInfoReply const& value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*,GetStorageServerRejoinInfoReply && value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(int loopDepth) 
	{
															#line 2125 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		cleaners->erase(storeID);
															#line 2126 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<CleanupStaleStorageDiskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupStaleStorageDiskActorState(); static_cast<CleanupStaleStorageDiskActor*>(this)->destroy(); return 0; }
															#line 10905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<CleanupStaleStorageDiskActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CleanupStaleStorageDiskActorState();
		static_cast<CleanupStaleStorageDiskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state > 0) static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupStaleStorageDiskActor*>(this)->ActorCallback< CleanupStaleStorageDiskActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state > 0) static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupStaleStorageDiskActor*>(this)->ActorCallback< CleanupStaleStorageDiskActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::unordered_map<UID, StorageDiskCleaner>* cleaners;
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UID storeID;
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	StorageDiskCleaner cleaner;
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryLimit;
															#line 2097 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	int retries;
															#line 11099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via cleanupStaleStorageDisk()
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class CleanupStaleStorageDiskActor final : public Actor<Void>, public ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >, public ActorCallback< CleanupStaleStorageDiskActor, 1, Void >, public ActorCallback< CleanupStaleStorageDiskActor, 2, Void >, public FastAllocated<CleanupStaleStorageDiskActor>, public CleanupStaleStorageDiskActorState<CleanupStaleStorageDiskActor> {
															#line 11104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<CleanupStaleStorageDiskActor>::operator new;
	using FastAllocated<CleanupStaleStorageDiskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18145303012972046336UL, 4056714049249025024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >;
friend struct ActorCallback< CleanupStaleStorageDiskActor, 1, Void >;
friend struct ActorCallback< CleanupStaleStorageDiskActor, 2, Void >;
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	CleanupStaleStorageDiskActor(Reference<AsyncVar<ServerDBInfo>> const& dbInfo,std::unordered_map<UID, StorageDiskCleaner>* const& cleaners,UID const& storeID,StorageDiskCleaner const& cleaner,int64_t const& memoryLimit) 
															#line 11123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   CleanupStaleStorageDiskActorState<CleanupStaleStorageDiskActor>(dbInfo, cleaners, storeID, cleaner, memoryLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10954477009460037888UL, 11591692359139200000UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cleanupStaleStorageDisk");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> cleanupStaleStorageDisk( Reference<AsyncVar<ServerDBInfo>> const& dbInfo, std::unordered_map<UID, StorageDiskCleaner>* const& cleaners, UID const& storeID, StorageDiskCleaner const& cleaner, int64_t const& memoryLimit ) {
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new CleanupStaleStorageDiskActor(dbInfo, cleaners, storeID, cleaner, memoryLimit));
															#line 11158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 2132 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

// Delete storage server data files if it's not alive anymore
void cleanupStorageDisks(Reference<AsyncVar<ServerDBInfo>> dbInfo,
                         std::unordered_map<UID, StorageDiskCleaner>& storageCleaners,
                         int64_t memoryLimit) {
	for (auto& cleaner : storageCleaners) {
		if (cleaner.second.future.isReady()) {
			CODE_PROBE(true, "Cleanup stale disk stores for double recruitment");
			cleaner.second.future =
			    cleanupStaleStorageDisk(dbInfo, &storageCleaners, cleaner.first, cleaner.second, memoryLimit);
		}
	}
}

bool skipInitRspInSim(const UID workerInterfID, const bool allowDropInSim) {
	const bool skip = allowDropInSim && g_network->isSimulated() && BUGGIFY_WITH_PROB(/* 1% */ 0.01);
	if (skip) {
		TraceEvent("SkipInitRspInSimTrue").detail("WorkerInterfID", workerInterfID);
	}
	return skip;
}

#ifdef FLOW_GRPC_ENABLED
															#line 11185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via registerWorkerGrpcServices()
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class RegisterWorkerGrpcServicesActor>
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class RegisterWorkerGrpcServicesActorState {
															#line 11192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	RegisterWorkerGrpcServicesActorState(UID const& id,Reference<IClusterConnectionRecord> const& ccr) 
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : id(id),
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   ccr(ccr)
															#line 11201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this));

	}
	~RegisterWorkerGrpcServicesActorState() 
	{
		fdb_probe_actor_destroy("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2156 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (GrpcServer::instance() == nullptr)
															#line 11216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2157 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				this->~RegisterWorkerGrpcServicesActorState();
															#line 11220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				static_cast<RegisterWorkerGrpcServicesActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
			else
			{
															#line 2158 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated())
															#line 11228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 2159 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					this->~RegisterWorkerGrpcServicesActorState();
															#line 11232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
					static_cast<RegisterWorkerGrpcServicesActor*>(this)->sendAndDelPromiseRef(Never());
					return 0;
				}
			}
															#line 2162 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			auto db = Database::createDatabase(ccr, ApiVersion::LATEST_VERSION);
															#line 2163 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Reference<IDatabase>> __when_expr_0 = safeThreadFutureToFuture(ThreadSafeDatabase::createFromExistingDatabase(db));
															#line 2163 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<RegisterWorkerGrpcServicesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegisterWorkerGrpcServicesActor*>(this)->actor_wait_state = 1;
															#line 2163 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >*>(static_cast<RegisterWorkerGrpcServicesActor*>(this)));
															#line 11248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterWorkerGrpcServicesActorState();
		static_cast<RegisterWorkerGrpcServicesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IDatabase> const& idb,int loopDepth) 
	{
															#line 2164 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto services = GrpcServer::ServiceList{};
															#line 2165 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		GrpcServer::instance()->registerRoleServices(UID(), services);
															#line 2166 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerGrpcServerStart").detail("Address", GrpcServer::instance()->getAddress());
															#line 2167 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		this->~RegisterWorkerGrpcServicesActorState();
															#line 11277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_cast<RegisterWorkerGrpcServicesActor*>(this)->sendAndDelPromiseRef(Never());
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IDatabase> && idb,int loopDepth) 
	{
															#line 2164 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto services = GrpcServer::ServiceList{};
															#line 2165 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		GrpcServer::instance()->registerRoleServices(UID(), services);
															#line 2166 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerGrpcServerStart").detail("Address", GrpcServer::instance()->getAddress());
															#line 2167 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		this->~RegisterWorkerGrpcServicesActorState();
															#line 11293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_cast<RegisterWorkerGrpcServicesActor*>(this)->sendAndDelPromiseRef(Never());
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> const& idb,int loopDepth) 
	{
		loopDepth = a_body1cont1(idb, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> && idb,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(idb), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterWorkerGrpcServicesActor*>(this)->actor_wait_state > 0) static_cast<RegisterWorkerGrpcServicesActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterWorkerGrpcServicesActor*>(this)->ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >*,Reference<IDatabase> const& value) 
	{
		fdb_probe_actor_enter("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerGrpcServicesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >*,Reference<IDatabase> && value) 
	{
		fdb_probe_actor_enter("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerGrpcServicesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >*,Error err) 
	{
		fdb_probe_actor_enter("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerGrpcServicesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 11378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via registerWorkerGrpcServices()
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class RegisterWorkerGrpcServicesActor final : public Actor<Void>, public ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >, public FastAllocated<RegisterWorkerGrpcServicesActor>, public RegisterWorkerGrpcServicesActorState<RegisterWorkerGrpcServicesActor> {
															#line 11383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<RegisterWorkerGrpcServicesActor>::operator new;
	using FastAllocated<RegisterWorkerGrpcServicesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16255351399427963904UL, 4293115193799252480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >;
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	RegisterWorkerGrpcServicesActor(UID const& id,Reference<IClusterConnectionRecord> const& ccr) 
															#line 11400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   RegisterWorkerGrpcServicesActorState<RegisterWorkerGrpcServicesActor>(id, ccr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11091973658458607872UL, 4923644862601870848UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerGrpcServicesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerWorkerGrpcServices");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterWorkerGrpcServicesActor, 0, Reference<IDatabase> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> registerWorkerGrpcServices( UID const& id, Reference<IClusterConnectionRecord> const& ccr ) {
															#line 2155 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RegisterWorkerGrpcServicesActor(id, ccr));
															#line 11433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 2169 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
#else
															#line 11438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via registerWorkerGrpcServices()
															#line 2170 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class RegisterWorkerGrpcServicesActor1>
															#line 2170 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class RegisterWorkerGrpcServicesActor1State {
															#line 11445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 2170 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	RegisterWorkerGrpcServicesActor1State(UID const& id,Reference<IClusterConnectionRecord> const& ccr) 
															#line 2170 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 2170 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : id(id),
															#line 2170 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   ccr(ccr)
															#line 11454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this));

	}
	~RegisterWorkerGrpcServicesActor1State() 
	{
		fdb_probe_actor_destroy("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2171 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			this->~RegisterWorkerGrpcServicesActor1State();
															#line 11469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			static_cast<RegisterWorkerGrpcServicesActor1*>(this)->sendAndDelPromiseRef(Never());
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterWorkerGrpcServicesActor1State();
		static_cast<RegisterWorkerGrpcServicesActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 2170 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 2170 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<IClusterConnectionRecord> ccr;
															#line 11493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via registerWorkerGrpcServices()
															#line 2170 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class RegisterWorkerGrpcServicesActor1 final : public Actor<Void>, public FastAllocated<RegisterWorkerGrpcServicesActor1>, public RegisterWorkerGrpcServicesActor1State<RegisterWorkerGrpcServicesActor1> {
															#line 11498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<RegisterWorkerGrpcServicesActor1>::operator new;
	using FastAllocated<RegisterWorkerGrpcServicesActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16255351399427963904UL, 4293115193799252480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 2170 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	RegisterWorkerGrpcServicesActor1(UID const& id,Reference<IClusterConnectionRecord> const& ccr) 
															#line 11514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   RegisterWorkerGrpcServicesActor1State<RegisterWorkerGrpcServicesActor1>(id, ccr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6368418377314189568UL, 12623130874699170304UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterWorkerGrpcServicesActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerWorkerGrpcServices");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerWorkerGrpcServices", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 2170 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> registerWorkerGrpcServices( UID const& id, Reference<IClusterConnectionRecord> const& ccr ) {
															#line 2170 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RegisterWorkerGrpcServicesActor1(id, ccr));
															#line 11546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 2173 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
#endif

															#line 11552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via workerServer()
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class WorkerServerActor>
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class WorkerServerActorState {
															#line 11559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	WorkerServerActorState(Reference<IClusterConnectionRecord> const& connRecord,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,LocalityData const& locality,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo,ProcessClass const& initialClass,std::string const& folder,int64_t const& memoryLimit,std::string const& metricsConnFile,std::string const& metricsPrefix,int64_t const& memoryProfileThreshold,std::string const& _coordFolder,std::string const& whitelistBinPaths,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,ConfigBroadcastInterface const& configBroadcastInterface,Reference<ConfigNode> const& configNode,Reference<LocalConfiguration> const& localConfig,Reference<AsyncVar<Optional<UID>>> const& clusterId,bool const& consistencyCheckUrgentMode) 
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : connRecord(connRecord),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   ccInterface(ccInterface),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   locality(locality),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   asyncPriorityInfo(asyncPriorityInfo),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   initialClass(initialClass),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   folder(folder),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   metricsConnFile(metricsConnFile),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   metricsPrefix(metricsPrefix),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   memoryProfileThreshold(memoryProfileThreshold),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   _coordFolder(_coordFolder),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   whitelistBinPaths(whitelistBinPaths),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   configBroadcastInterface(configBroadcastInterface),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   configNode(configNode),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   localConfig(localConfig),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   consistencyCheckUrgentMode(consistencyCheckUrgentMode),
															#line 2193 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   errors(),
															#line 2194 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   ddInterf(new AsyncVar<Optional<DataDistributorInterface>>()),
															#line 2196 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   rkInterf(new AsyncVar<Optional<RatekeeperInterface>>()),
															#line 2197 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   ekpInterf(new AsyncVar<Optional<EncryptKeyProxyInterface>>()),
															#line 2199 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   csInterf(new AsyncVar<Optional<ConsistencyScanInterface>>()),
															#line 2201 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   handleErrors(workerHandleErrors(errors.getFuture())),
															#line 2202 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   errorForwarders(false),
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   loggingTrigger(Void()),
															#line 2204 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   loggingDelay(SERVER_KNOBS->WORKER_LOGGING_INTERVAL),
															#line 2206 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   rebootKVSPromise(),
															#line 2207 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   rebootKVSPromise2(),
															#line 2208 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   filesClosed(true),
															#line 2209 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   stopping(),
															#line 2210 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   metricsLogger(),
															#line 2211 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   chaosMetricsActor(),
															#line 2212 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   degraded(FlowTransport::transport().getDegraded()),
															#line 2218 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   sharedLogs(),
															#line 2219 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   activeSharedTLog(new AsyncVar<UID>()),
															#line 2220 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   backupWorkerCache(),
															#line 2221 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   blobWorkerFuture(Void()),
															#line 2223 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   lastSnapReq(),
															#line 2225 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqMap(),
															#line 2226 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqResultMap(),
															#line 2227 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   lastSnapTime(-SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP),
															#line 2228 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   coordFolder(abspath(_coordFolder)),
															#line 2230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   interf(locality),
															#line 2232 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   runningStorages(),
															#line 2237 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   storageCleaners()
															#line 11656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("workerServer", reinterpret_cast<unsigned long>(this));

	}
	~WorkerServerActorState() 
	{
		fdb_probe_actor_destroy("workerServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2239 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			interf.initEndpoints();
															#line 2241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			issues = Reference<AsyncVar<std::set<std::string>>>(new AsyncVar<std::set<std::string>>());
															#line 2243 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			updateClusterIdFuture = Future<Void>();
															#line 2247 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			enablePrimaryTxnSystemHealthCheck = makeReference<AsyncVar<bool>>(false);
															#line 2249 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = yield();
															#line 2249 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WorkerServerActor*>(this)->actor_wait_state = 1;
															#line 2249 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 0, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 11686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerServerActorState();
		static_cast<WorkerServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2250 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		grpc = registerWorkerGrpcServices(interf.id(), connRecord);
															#line 2252 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (FLOW_KNOBS->ENABLE_CHAOS_FEATURES)
															#line 11711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2253 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevInfo, "ChaosFeaturesEnabled");
															#line 2254 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			chaosMetricsActor = chaosMetricsLogger();
															#line 11717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2257 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		folder = abspath(folder);
															#line 2259 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (metricsPrefix.size() > 0)
															#line 11723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2260 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (metricsConnFile.size() > 0)
															#line 11727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
				try {
															#line 2262 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					db = Database::createDatabase(metricsConnFile, ApiVersion::LATEST_VERSION, IsInternal::True, locality);
															#line 2264 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					metricsLogger = runMetrics(db, KeyRef(metricsPrefix));
															#line 2265 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					db->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
															#line 11736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
					loopDepth = a_body1cont7(loopDepth);
				}
				catch (Error& error) {
					loopDepth = a_body1cont1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
															#line 2270 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				auto lockAware = metricsPrefix.size() && metricsPrefix[0] == '\xff' ? LockAware::True : LockAware::False;
															#line 2271 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				auto database = openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, lockAware);
															#line 2272 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				metricsLogger = runMetrics(database, KeyRef(metricsPrefix));
															#line 2273 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				database->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
															#line 11755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = a_body1cont4(loopDepth);
			}
		}
		else
		{
															#line 2276 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			metricsLogger = runMetrics();
															#line 11763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2250 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		grpc = registerWorkerGrpcServices(interf.id(), connRecord);
															#line 2252 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (FLOW_KNOBS->ENABLE_CHAOS_FEATURES)
															#line 11775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2253 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevInfo, "ChaosFeaturesEnabled");
															#line 2254 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			chaosMetricsActor = chaosMetricsLogger();
															#line 11781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2257 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		folder = abspath(folder);
															#line 2259 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (metricsPrefix.size() > 0)
															#line 11787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2260 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (metricsConnFile.size() > 0)
															#line 11791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
				try {
															#line 2262 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					db = Database::createDatabase(metricsConnFile, ApiVersion::LATEST_VERSION, IsInternal::True, locality);
															#line 2264 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					metricsLogger = runMetrics(db, KeyRef(metricsPrefix));
															#line 2265 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					db->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
															#line 11800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
					loopDepth = a_body1cont7(loopDepth);
				}
				catch (Error& error) {
					loopDepth = a_body1cont1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
															#line 2270 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				auto lockAware = metricsPrefix.size() && metricsPrefix[0] == '\xff' ? LockAware::True : LockAware::False;
															#line 2271 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				auto database = openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, lockAware);
															#line 2272 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				metricsLogger = runMetrics(database, KeyRef(metricsPrefix));
															#line 2273 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				database->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
															#line 11819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = a_body1cont4(loopDepth);
			}
		}
		else
		{
															#line 2276 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			metricsLogger = runMetrics();
															#line 11827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2279 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(resetAfter(degraded, SERVER_KNOBS->DEGRADED_RESET_INTERVAL, false, SERVER_KNOBS->DEGRADED_WARNING_LIMIT, SERVER_KNOBS->DEGRADED_WARNING_RESET_DELAY, "DegradedReset"));
															#line 2285 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(loadedPonger(interf.debugPing.getFuture()));
															#line 2286 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(waitFailureServer(interf.waitFailure.getFuture()));
															#line 2287 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(monitorTraceLogIssues(issues));
															#line 2288 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( testerServerCore(interf.testerInterface, connRecord, dbInfo, locality, consistencyCheckUrgentMode ? "ConsistencyCheckUrgent" : Optional<std::string>()));
															#line 2294 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(monitorHighMemory(memoryProfileThreshold));
															#line 2296 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed.add(stopping.getFuture());
															#line 2298 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		initializeSystemMonitorMachineState(SystemMonitorMachineState(folder, locality.dcId(), locality.zoneId(), locality.machineId(), locality.dataHallId(), g_network->getLocalAddress().ip, FDB_VT_VERSION));
															#line 11926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2307 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			auto recruited = interf;
															#line 2308 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.clientInterface.reboot);
															#line 2309 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.clientInterface.profiler);
															#line 2310 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.tLog);
															#line 2311 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.master);
															#line 2312 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.commitProxy);
															#line 2313 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.grvProxy);
															#line 2314 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.resolver);
															#line 2315 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.storage);
															#line 2316 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.debugPing);
															#line 2317 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.coordinationPing);
															#line 2318 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2319 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.setMetricsRate);
															#line 2320 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.eventLogRequest);
															#line 2321 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.traceBatchDumpRequest);
															#line 2322 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.updateServerDBInfo);
															#line 11960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2325 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recoveries = std::vector<Future<Void>>();
															#line 11964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		try {
															#line 2328 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			stores = getDiskStores(folder);
															#line 2329 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			validateDataFiles = deleteFile(joinPath(folder, validationFilename));
															#line 2330 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			index = 0;
															#line 2331 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 11974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2267 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarnAlways, "TDMetricsBadClusterFile").error(e).detail("ConnFile", metricsConnFile);
															#line 12002 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& err,int loopDepth=0) 
	{
		try {
															#line 3262 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			for( auto f : recoveries ) {
															#line 3263 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				f.cancel();
															#line 12033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
															#line 3264 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			e = err;
															#line 3265 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			bool ok = e.code() == error_code_please_reboot || e.code() == error_code_actor_cancelled || e.code() == error_code_please_reboot_delete || e.code() == error_code_local_config_changed || e.code() == error_code_invalid_cluster_id;
															#line 3268 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			endRole(Role::WORKER, interf.id(), "WorkerError", ok, e);
															#line 3269 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.clear(false);
															#line 3270 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			sharedLogs.clear();
															#line 3273 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			blobWorkerFuture.cancel();
															#line 3275 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 12049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 3279 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				stopping.send(Void());
															#line 3280 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_29 = filesClosed.getResult();
															#line 3280 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				if (__when_expr_29.isReady()) { if (__when_expr_29.isError()) return a_body1Catch1(__when_expr_29.getError(), loopDepth); else return a_body1cont2Catch1when1(__when_expr_29.get(), loopDepth); };
				static_cast<WorkerServerActor*>(this)->actor_wait_state = 6;
															#line 3280 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_29.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 29, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 12062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont2Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
															#line 2501 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 2502 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		details["Locality"] = locality.toString();
															#line 2503 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		details["DataFolder"] = folder;
															#line 2504 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		details["StoresPresent"] = format("%d", stores.size());
															#line 2506 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::WORKER, interf.id(), interf.id(), details);
															#line 2507 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(traceRole(Role::WORKER, interf.id()));
															#line 2520 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> recoveredDiskFiles;
															#line 2521 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> recoverDiskFiles = trigger( [=]() { TraceEvent("DiskFileRecoveriesComplete", interf.id()); recoveredDiskFiles.send(Void()); }, waitForAll(recoveries));
															#line 2527 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(recoverDiskFiles);
															#line 2529 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(registrationClient(ccInterface, interf, asyncPriorityInfo, initialClass, ddInterf, rkInterf, ekpInterf, csInterf, degraded, connRecord, issues, configNode, localConfig, configBroadcastInterface, dbInfo, recoveredDiskFiles, clusterId));
															#line 2547 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (configNode.isValid())
															#line 12102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2548 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(brokenPromiseToNever(localConfig->consume(configBroadcastInterface)));
															#line 12106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2551 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (SERVER_KNOBS->ENABLE_WORKER_HEALTH_MONITOR)
															#line 12110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2552 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( healthMonitor(ccInterface, interf, locality, dbInfo, enablePrimaryTxnSystemHealthCheck));
															#line 12114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2556 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		;
															#line 12118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 2331 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!(index < stores.size()))
															#line 12134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2332 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		s = stores[index];
															#line 2336 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (s.storedComponent == DiskStore::Storage)
															#line 12142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2339 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (index >= 2 && SERVER_KNOBS->WORKER_START_STORAGE_DELAY > 0.0)
															#line 12146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2340 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->WORKER_START_STORAGE_DELAY);
															#line 2340 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
				static_cast<WorkerServerActor*>(this)->actor_wait_state = 2;
															#line 2340 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 1, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 12157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont2loopBody1cont3(loopDepth);
			}
		}
		else
		{
															#line 2432 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (s.storedComponent == DiskStore::TLogData)
															#line 12169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2433 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				LocalLineage _;
															#line 2434 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::TLog;
															#line 2435 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				std::string logQueueBasename;
															#line 2436 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				const std::string filename = basename(s.filename);
															#line 2437 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (StringRef(filename).startsWith(fileLogDataPrefix))
															#line 12181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 2438 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					logQueueBasename = fileLogQueuePrefix.toString();
															#line 12185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
				else
				{
															#line 2440 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					StringRef optionsString = StringRef(filename).removePrefix(fileVersionedLogDataPrefix).eat("-");
															#line 2441 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					logQueueBasename = fileLogQueuePrefix.toString() + optionsString.toString() + "-";
															#line 12193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
															#line 2443 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT_WE_THINK(abspath(parentDirectory(s.filename)) == folder);
															#line 2444 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				IKeyValueStore* kv = openKVStore(s.storeType, s.filename, s.storeID, memoryLimit, validateDataFiles, false, false, dbInfo, EncryptionAtRestMode());
															#line 2453 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				const DiskQueueVersion dqv = s.tLogOptions.getDiskQueueVersion();
															#line 2454 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				const int64_t diskQueueWarnSize = s.tLogOptions.spillType == TLogSpillType::VALUE ? 10 * SERVER_KNOBS->TARGET_BYTES_PER_TLOG : -1;
															#line 2456 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				IDiskQueue* queue = openDiskQueue(joinPath(folder, logQueueBasename + s.storeID.toString() + "-"), tlogQueueExtension.toString(), s.storeID, dqv, diskQueueWarnSize);
															#line 2461 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				filesClosed.add(kv->onClosed());
															#line 2462 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				filesClosed.add(queue->onClosed());
															#line 2464 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				std::map<std::string, std::string> details;
															#line 2465 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				details["StorageEngine"] = s.storeType.toString();
															#line 2466 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				startRole(Role::SHARED_TRANSACTION_LOG, s.storeID, interf.id(), details, "Restored");
															#line 2468 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				Promise<Void> oldLog;
															#line 2469 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				Promise<Void> recovery;
															#line 2470 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				TLogFn tLogFn = tLogFnForOptions(s.tLogOptions);
															#line 2471 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				auto& logData = sharedLogs[SharedLogsKey(s.tLogOptions, s.storeType)];
															#line 2472 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				logData.push_back(SharedLogsValue());
															#line 2476 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				Future<Void> tl = tLogFn(kv, queue, dbInfo, locality, logData.back().requests, s.storeID, interf.id(), true, oldLog, recovery, folder, degraded, activeSharedTLog, enablePrimaryTxnSystemHealthCheck);
															#line 2490 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				recoveries.push_back(recovery.getFuture());
															#line 2491 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				activeSharedTLog->set(s.storeID);
															#line 2493 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				tl = handleIOErrors(tl, kv, s.storeID);
															#line 2494 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				tl = handleIOErrors(tl, queue, s.storeID);
															#line 2495 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				logData.back().actor = oldLog.getFuture() || tl;
															#line 2496 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				logData.back().uid = s.storeID;
															#line 2497 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add(forwardError(errors, Role::SHARED_TRANSACTION_LOG, s.storeID, tl));
															#line 12241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 2331 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		++index;
															#line 12265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(int loopDepth) 
	{
															#line 2342 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2343 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Storage;
															#line 2345 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Reference<GetEncryptCipherKeysMonitor> encryptionMonitor = makeReference<GetEncryptCipherKeysMonitor>();
															#line 2346 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		IKeyValueStore* kv = openKVStore( s.storeType, s.filename, s.storeID, memoryLimit, false, validateDataFiles, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( s.storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && s.storeType != KeyValueStoreType::SSD_SHARDED_ROCKSDB && deterministicRandom()->coinflip()) : true), dbInfo, Optional<EncryptionAtRestMode>(), 0, encryptionMonitor);
															#line 2363 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> kvClosed = kv->onClosed() || rebootKVSPromise.getFuture();
															#line 2366 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed.add(kvClosed);
															#line 2369 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::string tssPrefix = testingStoragePrefix.toString();
															#line 2372 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		bool isTss = s.filename.find(tssPrefix) != std::string::npos;
															#line 2373 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Role ssRole = isTss ? Role::TESTING_STORAGE_SERVER : Role::STORAGE_SERVER;
															#line 2375 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StorageServerInterface recruited;
															#line 2376 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.uniqueID = s.storeID;
															#line 2377 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 2378 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.tssPairID = isTss ? Optional<UID>(UID()) : Optional<UID>();
															#line 2382 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2384 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 2385 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		details["StorageEngine"] = s.storeType.toString();
															#line 2386 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		details["IsTSS"] = isTss ? "Yes" : "No";
															#line 2388 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		startRole(ssRole, recruited.id(), interf.id(), details, "Restored");
															#line 2390 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getValue);
															#line 2391 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKey);
															#line 2392 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValues);
															#line 2393 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getMappedKeyValues);
															#line 2394 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getShardState);
															#line 2395 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitMetrics);
															#line 2396 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.splitMetrics);
															#line 2397 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getReadHotRanges);
															#line 2398 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 2399 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageMetrics);
															#line 2400 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2401 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 2402 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 2403 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.watchValue);
															#line 2404 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValuesStream);
															#line 2405 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedStream);
															#line 2406 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedPop);
															#line 2407 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 2409 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Future<ErrorOr<Void>> storeError = errorOr(kv->getError());
															#line 2410 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> recovery;
															#line 2411 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> f = storageServer(kv, recruited, dbInfo, folder, recovery, connRecord, encryptionMonitor);
															#line 2412 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recoveries.push_back(recovery.getFuture());
															#line 2414 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		f = handleIOErrors(f, storeError, s.storeID, kvClosed);
															#line 2415 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		f = storageServerRollbackRebooter(&runningStorages, &storageCleaners, f, s.storeType, s.filename, recruited.id(), recruited.locality, isTss, dbInfo, folder, &filesClosed, memoryLimit, kv, validateDataFiles, &rebootKVSPromise, encryptionMonitor);
															#line 2431 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(forwardError(errors, ssRole, recruited.id(), f));
															#line 12358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont12loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont12loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1(int loopDepth) 
	{
															#line 2557 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_2 = interf.updateServerDBInfo.getFuture();
															#line 12461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<UpdateServerDBInfoRequest>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<UpdateServerDBInfoRequest>>::value, "invalid type");
															#line 2556 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when1(__when_expr_2.pop(), loopDepth); };
															#line 2596 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_3 = interf.clientInterface.reboot.getFuture();
															#line 12469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<RebootRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<RebootRequest>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2(__when_expr_3.pop(), loopDepth); };
															#line 2627 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_4 = interf.clientInterface.setFailureInjection.getFuture();
															#line 12474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<SetFailureInjection>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<SetFailureInjection>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when3(__when_expr_4.pop(), loopDepth); };
															#line 2643 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_5 = interf.clientInterface.profiler.getFuture();
															#line 12479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_5), FutureStream<ProfilerRequest>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<ProfilerRequest>>::value, "invalid type");
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when4(__when_expr_5.pop(), loopDepth); };
															#line 2664 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_6 = interf.master.getFuture();
															#line 12484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_6), FutureStream<RecruitMasterRequest>>::value || std::is_same<decltype(__when_expr_6), ThreadFutureStream<RecruitMasterRequest>>::value, "invalid type");
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont2Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when5(__when_expr_6.pop(), loopDepth); };
															#line 2686 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_7 = interf.dataDistributor.getFuture();
															#line 12489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_7), FutureStream<InitializeDataDistributorRequest>>::value || std::is_same<decltype(__when_expr_7), ThreadFutureStream<InitializeDataDistributorRequest>>::value, "invalid type");
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont2Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when6(__when_expr_7.pop(), loopDepth); };
															#line 2712 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_8 = interf.ratekeeper.getFuture();
															#line 12494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_8), FutureStream<InitializeRatekeeperRequest>>::value || std::is_same<decltype(__when_expr_8), ThreadFutureStream<InitializeRatekeeperRequest>>::value, "invalid type");
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont2Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when7(__when_expr_8.pop(), loopDepth); };
															#line 2739 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_9 = interf.consistencyScan.getFuture();
															#line 12499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_9), FutureStream<InitializeConsistencyScanRequest>>::value || std::is_same<decltype(__when_expr_9), ThreadFutureStream<InitializeConsistencyScanRequest>>::value, "invalid type");
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont2Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when8(__when_expr_9.pop(), loopDepth); };
															#line 2764 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_10 = interf.backup.getFuture();
															#line 12504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_10), FutureStream<InitializeBackupRequest>>::value || std::is_same<decltype(__when_expr_10), ThreadFutureStream<InitializeBackupRequest>>::value, "invalid type");
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont2Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when9(__when_expr_10.pop(), loopDepth); };
															#line 2786 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_11 = interf.encryptKeyProxy.getFuture();
															#line 12509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_11), FutureStream<InitializeEncryptKeyProxyRequest>>::value || std::is_same<decltype(__when_expr_11), ThreadFutureStream<InitializeEncryptKeyProxyRequest>>::value, "invalid type");
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont2Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when10(__when_expr_11.pop(), loopDepth); };
															#line 2815 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_12 = interf.tLog.getFuture();
															#line 12514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_12), FutureStream<InitializeTLogRequest>>::value || std::is_same<decltype(__when_expr_12), ThreadFutureStream<InitializeTLogRequest>>::value, "invalid type");
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont2Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when11(__when_expr_12.pop(), loopDepth); };
															#line 2891 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_13 = interf.storage.getFuture();
															#line 12519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_13), FutureStream<InitializeStorageRequest>>::value || std::is_same<decltype(__when_expr_13), ThreadFutureStream<InitializeStorageRequest>>::value, "invalid type");
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont2Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when12(__when_expr_13.pop(), loopDepth); };
															#line 3036 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_14 = interf.commitProxy.getFuture();
															#line 12524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_14), FutureStream<InitializeCommitProxyRequest>>::value || std::is_same<decltype(__when_expr_14), ThreadFutureStream<InitializeCommitProxyRequest>>::value, "invalid type");
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont2Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when13(__when_expr_14.pop(), loopDepth); };
															#line 3063 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_15 = interf.grvProxy.getFuture();
															#line 12529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_15), FutureStream<InitializeGrvProxyRequest>>::value || std::is_same<decltype(__when_expr_15), ThreadFutureStream<InitializeGrvProxyRequest>>::value, "invalid type");
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont2Catch1(__when_expr_15.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when14(__when_expr_15.pop(), loopDepth); };
															#line 3085 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_16 = interf.resolver.getFuture();
															#line 12534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_16), FutureStream<InitializeResolverRequest>>::value || std::is_same<decltype(__when_expr_16), ThreadFutureStream<InitializeResolverRequest>>::value, "invalid type");
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont2Catch1(__when_expr_16.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when15(__when_expr_16.pop(), loopDepth); };
															#line 3104 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_17 = interf.logRouter.getFuture();
															#line 12539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_17), FutureStream<InitializeLogRouterRequest>>::value || std::is_same<decltype(__when_expr_17), ThreadFutureStream<InitializeLogRouterRequest>>::value, "invalid type");
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont2Catch1(__when_expr_17.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when16(__when_expr_17.pop(), loopDepth); };
															#line 3134 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_18 = interf.coordinationPing.getFuture();
															#line 12544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_18), FutureStream<CoordinationPingMessage>>::value || std::is_same<decltype(__when_expr_18), ThreadFutureStream<CoordinationPingMessage>>::value, "invalid type");
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont2Catch1(__when_expr_18.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when17(__when_expr_18.pop(), loopDepth); };
															#line 3139 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_19 = interf.setMetricsRate.getFuture();
															#line 12549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_19), FutureStream<SetMetricsLogRateRequest>>::value || std::is_same<decltype(__when_expr_19), ThreadFutureStream<SetMetricsLogRateRequest>>::value, "invalid type");
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont2Catch1(__when_expr_19.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when18(__when_expr_19.pop(), loopDepth); };
															#line 3148 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_20 = interf.eventLogRequest.getFuture();
															#line 12554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_20), FutureStream<EventLogRequest>>::value || std::is_same<decltype(__when_expr_20), ThreadFutureStream<EventLogRequest>>::value, "invalid type");
		if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1cont2Catch1(__when_expr_20.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when19(__when_expr_20.pop(), loopDepth); };
															#line 3156 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_21 = interf.traceBatchDumpRequest.getFuture();
															#line 12559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_21), FutureStream<TraceBatchDumpRequest>>::value || std::is_same<decltype(__when_expr_21), ThreadFutureStream<TraceBatchDumpRequest>>::value, "invalid type");
		if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1cont2Catch1(__when_expr_21.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when20(__when_expr_21.pop(), loopDepth); };
															#line 3160 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_22 = interf.diskStoreRequest.getFuture();
															#line 12564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_22), FutureStream<DiskStoreRequest>>::value || std::is_same<decltype(__when_expr_22), ThreadFutureStream<DiskStoreRequest>>::value, "invalid type");
		if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1cont2Catch1(__when_expr_22.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when21(__when_expr_22.pop(), loopDepth); };
															#line 3201 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_23 = loggingTrigger;
															#line 12569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1cont2Catch1(__when_expr_23.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when22(__when_expr_23.get(), loopDepth); };
															#line 3205 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto __when_expr_24 = interf.workerSnapReq.getFuture();
															#line 12573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_24), FutureStream<WorkerSnapRequest>>::value || std::is_same<decltype(__when_expr_24), ThreadFutureStream<WorkerSnapRequest>>::value, "invalid type");
		if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1cont2Catch1(__when_expr_24.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when23(__when_expr_24.pop(), loopDepth); };
															#line 3257 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_25 = errorForwarders.getResult();
															#line 12578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1cont2Catch1(__when_expr_25.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when24(__when_expr_25.get(), loopDepth); };
															#line 3258 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_26 = handleErrors;
															#line 12582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1cont2Catch1(__when_expr_26.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when25(__when_expr_26.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 3;
															#line 2557 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2596 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 3, RebootRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2627 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >*>(static_cast<WorkerServerActor*>(this)));
															#line 2643 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2664 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2686 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2712 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2739 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2764 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2786 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 11, InitializeEncryptKeyProxyRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2815 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 12, InitializeTLogRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2891 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 13, InitializeStorageRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3036 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 14, InitializeCommitProxyRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3063 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 15, InitializeGrvProxyRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3085 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 16, InitializeResolverRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3104 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 17, InitializeLogRouterRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3134 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 18, CoordinationPingMessage >*>(static_cast<WorkerServerActor*>(this)));
															#line 3139 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 19, SetMetricsLogRateRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3148 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_20.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 20, EventLogRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3156 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_21.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 21, TraceBatchDumpRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3160 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_22.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 22, DiskStoreRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3201 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_23.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 23, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 3205 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_24.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 24, WorkerSnapRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3257 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 25, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 3258 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_26.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 26, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 12635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont12loopHead1(0);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(UpdateServerDBInfoRequest const& req,int loopDepth) 
	{
															#line 2558 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		ServerDBInfo localInfo = BinaryReader::fromStringRef<ServerDBInfo>( req.serializedDbInfo, AssumeVersion(g_network->protocolVersion()));
															#line 2560 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		localInfo.myLocality = locality;
															#line 2562 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (localInfo.infoGeneration < dbInfo->get().infoGeneration && localInfo.clusterInterface == dbInfo->get().clusterInterface)
															#line 12654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2564 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::vector<Endpoint> rep = req.broadcastInfo;
															#line 2565 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			rep.push_back(interf.updateServerDBInfo.getEndpoint());
															#line 2566 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(rep);
															#line 12662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2568 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Optional<Endpoint> notUpdated;
															#line 2569 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!ccInterface->get().present() || localInfo.clusterInterface != ccInterface->get().get())
															#line 12670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2570 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				notUpdated = interf.updateServerDBInfo.getEndpoint();
															#line 12674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2571 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (localInfo.infoGeneration > dbInfo->get().infoGeneration || dbInfo->get().clusterInterface != ccInterface->get().get())
															#line 12680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 2573 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent("GotServerDBInfoChange") .detail("ChangeID", localInfo.id) .detail("InfoGeneration", localInfo.infoGeneration) .detail("MasterID", localInfo.master.id()) .detail("RatekeeperID", localInfo.ratekeeper.present() ? localInfo.ratekeeper.get().id() : UID()) .detail("DataDistributorID", localInfo.distributor.present() ? localInfo.distributor.get().id() : UID()) .detail("EncryptKeyProxyID", localInfo.client.encryptKeyProxy.present() ? localInfo.client.encryptKeyProxy.get().id() : UID());
															#line 2585 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					dbInfo->set(localInfo);
															#line 12686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 2587 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( success(broadcastDBInfoRequest(req, SERVER_KNOBS->DBINFO_SEND_AMOUNT, notUpdated, true)));
															#line 2590 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!updateClusterIdFuture.isValid() && !clusterId->get().present() && localInfo.client.clusterId.isValid())
															#line 12693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2592 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				updateClusterIdFuture = updateClusterId(localInfo.client.clusterId, clusterId, folder);
															#line 12697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when1(UpdateServerDBInfoRequest && req,int loopDepth) 
	{
															#line 2558 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		ServerDBInfo localInfo = BinaryReader::fromStringRef<ServerDBInfo>( req.serializedDbInfo, AssumeVersion(g_network->protocolVersion()));
															#line 2560 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		localInfo.myLocality = locality;
															#line 2562 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (localInfo.infoGeneration < dbInfo->get().infoGeneration && localInfo.clusterInterface == dbInfo->get().clusterInterface)
															#line 12712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2564 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::vector<Endpoint> rep = req.broadcastInfo;
															#line 2565 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			rep.push_back(interf.updateServerDBInfo.getEndpoint());
															#line 2566 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(rep);
															#line 12720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2568 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Optional<Endpoint> notUpdated;
															#line 2569 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!ccInterface->get().present() || localInfo.clusterInterface != ccInterface->get().get())
															#line 12728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2570 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				notUpdated = interf.updateServerDBInfo.getEndpoint();
															#line 12732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2571 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (localInfo.infoGeneration > dbInfo->get().infoGeneration || dbInfo->get().clusterInterface != ccInterface->get().get())
															#line 12738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 2573 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent("GotServerDBInfoChange") .detail("ChangeID", localInfo.id) .detail("InfoGeneration", localInfo.infoGeneration) .detail("MasterID", localInfo.master.id()) .detail("RatekeeperID", localInfo.ratekeeper.present() ? localInfo.ratekeeper.get().id() : UID()) .detail("DataDistributorID", localInfo.distributor.present() ? localInfo.distributor.get().id() : UID()) .detail("EncryptKeyProxyID", localInfo.client.encryptKeyProxy.present() ? localInfo.client.encryptKeyProxy.get().id() : UID());
															#line 2585 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					dbInfo->set(localInfo);
															#line 12744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 2587 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( success(broadcastDBInfoRequest(req, SERVER_KNOBS->DBINFO_SEND_AMOUNT, notUpdated, true)));
															#line 2590 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!updateClusterIdFuture.isValid() && !clusterId->get().present() && localInfo.client.clusterId.isValid())
															#line 12751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2592 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				updateClusterIdFuture = updateClusterId(localInfo.client.clusterId, clusterId, folder);
															#line 12755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2(RebootRequest const& req,int loopDepth) 
	{
															#line 2597 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		rebootReq = req;
															#line 2600 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RebootRequestSuspendingProcess").detail("Duration", req.waitForDuration);
															#line 2601 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (req.waitForDuration)
															#line 12770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2602 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			flushTraceFileVoid();
															#line 2603 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			setProfilingEnabled(0);
															#line 2604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			g_network->stop();
															#line 2605 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			threadSleep(req.waitForDuration);
															#line 12780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2607 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (rebootReq.checkData)
															#line 12784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2608 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_27 = IAsyncFileSystem::filesystem()->open(joinPath(folder, validationFilename), IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0600);
															#line 2608 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1cont2Catch1(__when_expr_27.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2when1(__when_expr_27.get(), loopDepth); };
			static_cast<WorkerServerActor*>(this)->actor_wait_state = 4;
															#line 2608 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >*>(static_cast<WorkerServerActor*>(this)));
															#line 12795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when2(RebootRequest && req,int loopDepth) 
	{
															#line 2597 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		rebootReq = req;
															#line 2600 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RebootRequestSuspendingProcess").detail("Duration", req.waitForDuration);
															#line 2601 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (req.waitForDuration)
															#line 12813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2602 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			flushTraceFileVoid();
															#line 2603 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			setProfilingEnabled(0);
															#line 2604 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			g_network->stop();
															#line 2605 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			threadSleep(req.waitForDuration);
															#line 12823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2607 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (rebootReq.checkData)
															#line 12827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2608 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_27 = IAsyncFileSystem::filesystem()->open(joinPath(folder, validationFilename), IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0600);
															#line 2608 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1cont2Catch1(__when_expr_27.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2when1(__when_expr_27.get(), loopDepth); };
			static_cast<WorkerServerActor*>(this)->actor_wait_state = 4;
															#line 2608 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >*>(static_cast<WorkerServerActor*>(this)));
															#line 12838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when3(SetFailureInjection const& req,int loopDepth) 
	{
															#line 2628 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (FLOW_KNOBS->ENABLE_CHAOS_FEATURES)
															#line 12852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2629 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (req.diskFailure.present())
															#line 12856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2630 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				auto diskFailureInjector = DiskFailureInjector::injector();
															#line 2631 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				diskFailureInjector->setDiskFailure(req.diskFailure.get().stallInterval, req.diskFailure.get().stallPeriod, req.diskFailure.get().throttlePeriod);
															#line 12862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2634 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (req.flipBits.present())
															#line 12868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 2635 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					auto bitFlipper = BitFlipper::flipper();
															#line 2636 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					bitFlipper->setBitFlipPercentage(req.flipBits.get().percentBitFlips);
															#line 12874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 2638 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(Void());
															#line 12879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2640 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(client_invalid_operation());
															#line 12885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when3(SetFailureInjection && req,int loopDepth) 
	{
															#line 2628 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (FLOW_KNOBS->ENABLE_CHAOS_FEATURES)
															#line 12895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2629 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (req.diskFailure.present())
															#line 12899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2630 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				auto diskFailureInjector = DiskFailureInjector::injector();
															#line 2631 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				diskFailureInjector->setDiskFailure(req.diskFailure.get().stallInterval, req.diskFailure.get().stallPeriod, req.diskFailure.get().throttlePeriod);
															#line 12905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2634 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (req.flipBits.present())
															#line 12911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 2635 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					auto bitFlipper = BitFlipper::flipper();
															#line 2636 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					bitFlipper->setBitFlipPercentage(req.flipBits.get().percentBitFlips);
															#line 12917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 2638 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(Void());
															#line 12922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2640 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(client_invalid_operation());
															#line 12928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when4(ProfilerRequest const& req,int loopDepth) 
	{
															#line 2644 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		profilerReq = req;
															#line 12938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		try {
															#line 2650 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::string realLogDir = abspath(SERVER_KNOBS->LOG_DIRECTORY);
															#line 2651 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::string realOutPath = abspath(realLogDir + "/" + profilerReq.outputFile.toString());
															#line 2652 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (realLogDir.size() < realOutPath.size() && strncmp(realLogDir.c_str(), realOutPath.c_str(), realLogDir.size()) == 0)
															#line 12946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2654 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.outputFile = realOutPath;
															#line 2655 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				uncancellable(runProfiler(profilerReq));
															#line 2656 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.send(Void());
															#line 12954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2658 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.sendError(client_invalid_operation());
															#line 12960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1cont12loopBody1when4cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont12loopBody1when4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12loopBody1when4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when4(ProfilerRequest && req,int loopDepth) 
	{
															#line 2644 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		profilerReq = req;
															#line 12976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		try {
															#line 2650 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::string realLogDir = abspath(SERVER_KNOBS->LOG_DIRECTORY);
															#line 2651 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::string realOutPath = abspath(realLogDir + "/" + profilerReq.outputFile.toString());
															#line 2652 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (realLogDir.size() < realOutPath.size() && strncmp(realLogDir.c_str(), realOutPath.c_str(), realLogDir.size()) == 0)
															#line 12984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2654 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.outputFile = realOutPath;
															#line 2655 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				uncancellable(runProfiler(profilerReq));
															#line 2656 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.send(Void());
															#line 12992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2658 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.sendError(client_invalid_operation());
															#line 12998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1cont12loopBody1when4cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont12loopBody1when4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12loopBody1when4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when5(RecruitMasterRequest const& req,int loopDepth) 
	{
															#line 2665 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2666 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Master;
															#line 2667 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		MasterInterface recruited;
															#line 2668 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 2669 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2671 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::MASTER, recruited.id(), interf.id());
															#line 2673 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2674 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getCommitVersion);
															#line 2675 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getLiveCommittedVersion);
															#line 2676 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.reportLiveCommittedVersion);
															#line 2677 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.updateRecoveryData);
															#line 2680 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> masterProcess = masterServer( recruited, dbInfo, ccInterface, ServerCoordinators(connRecord), req.lifetime, req.forceRecovery);
															#line 2682 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( zombie(recruited, forwardError(errors, Role::MASTER, recruited.id(), masterProcess)));
															#line 2684 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when5(RecruitMasterRequest && req,int loopDepth) 
	{
															#line 2665 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2666 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Master;
															#line 2667 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		MasterInterface recruited;
															#line 2668 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 2669 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2671 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::MASTER, recruited.id(), interf.id());
															#line 2673 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2674 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getCommitVersion);
															#line 2675 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getLiveCommittedVersion);
															#line 2676 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.reportLiveCommittedVersion);
															#line 2677 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.updateRecoveryData);
															#line 2680 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> masterProcess = masterServer( recruited, dbInfo, ccInterface, ServerCoordinators(connRecord), req.lifetime, req.forceRecovery);
															#line 2682 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( zombie(recruited, forwardError(errors, Role::MASTER, recruited.id(), masterProcess)));
															#line 2684 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when6(InitializeDataDistributorRequest const& req,int loopDepth) 
	{
															#line 2687 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2688 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::DataDistributor;
															#line 2689 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DataDistributorInterface recruited(locality, req.reqId);
															#line 2690 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2692 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (ddInterf->get().present())
															#line 13092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2693 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited = ddInterf->get().get();
															#line 2694 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a data distributor.");
															#line 13098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2696 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::DATA_DISTRIBUTOR, recruited.id(), interf.id());
															#line 2697 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2699 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> dataDistributorProcess = dataDistributor(recruited, dbInfo, folder);
															#line 2700 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::DATA_DISTRIBUTOR, recruited.id(), setWhenDoneOrError(dataDistributorProcess, ddInterf, Optional<DataDistributorInterface>())));
															#line 2705 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ddInterf->set(Optional<DataDistributorInterface>(recruited));
															#line 13112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2707 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("DataDistributorReceived", req.reqId) .detail("DataDistributorId", recruited.id()) .detail("Folder", folder);
															#line 2710 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when6(InitializeDataDistributorRequest && req,int loopDepth) 
	{
															#line 2687 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2688 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::DataDistributor;
															#line 2689 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DataDistributorInterface recruited(locality, req.reqId);
															#line 2690 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2692 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (ddInterf->get().present())
															#line 13135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2693 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited = ddInterf->get().get();
															#line 2694 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a data distributor.");
															#line 13141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2696 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::DATA_DISTRIBUTOR, recruited.id(), interf.id());
															#line 2697 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2699 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> dataDistributorProcess = dataDistributor(recruited, dbInfo, folder);
															#line 2700 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::DATA_DISTRIBUTOR, recruited.id(), setWhenDoneOrError(dataDistributorProcess, ddInterf, Optional<DataDistributorInterface>())));
															#line 2705 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ddInterf->set(Optional<DataDistributorInterface>(recruited));
															#line 13155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2707 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("DataDistributorReceived", req.reqId) .detail("DataDistributorId", recruited.id()) .detail("Folder", folder);
															#line 2710 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when7(InitializeRatekeeperRequest const& req,int loopDepth) 
	{
															#line 2713 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2714 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Ratekeeper;
															#line 2715 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		RatekeeperInterface recruited(locality, req.reqId);
															#line 2716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2718 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (rkInterf->get().present())
															#line 13178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2719 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited = rkInterf->get().get();
															#line 2720 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a ratekeeper.");
															#line 13184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2722 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::RATEKEEPER, recruited.id(), interf.id());
															#line 2723 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2724 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRateInfo);
															#line 2725 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltRatekeeper);
															#line 2726 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.reportCommitCostEstimation);
															#line 2728 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> ratekeeperProcess = ratekeeper(recruited, dbInfo);
															#line 2729 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( forwardError(errors, Role::RATEKEEPER, recruited.id(), setWhenDoneOrError(ratekeeperProcess, rkInterf, Optional<RatekeeperInterface>())));
															#line 2734 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			rkInterf->set(Optional<RatekeeperInterface>(recruited));
															#line 13204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2736 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Ratekeeper_InitRequest", req.reqId).detail("RatekeeperId", recruited.id());
															#line 2737 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when7(InitializeRatekeeperRequest && req,int loopDepth) 
	{
															#line 2713 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2714 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Ratekeeper;
															#line 2715 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		RatekeeperInterface recruited(locality, req.reqId);
															#line 2716 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2718 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (rkInterf->get().present())
															#line 13227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2719 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited = rkInterf->get().get();
															#line 2720 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a ratekeeper.");
															#line 13233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2722 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::RATEKEEPER, recruited.id(), interf.id());
															#line 2723 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2724 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRateInfo);
															#line 2725 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltRatekeeper);
															#line 2726 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.reportCommitCostEstimation);
															#line 2728 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> ratekeeperProcess = ratekeeper(recruited, dbInfo);
															#line 2729 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( forwardError(errors, Role::RATEKEEPER, recruited.id(), setWhenDoneOrError(ratekeeperProcess, rkInterf, Optional<RatekeeperInterface>())));
															#line 2734 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			rkInterf->set(Optional<RatekeeperInterface>(recruited));
															#line 13253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2736 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Ratekeeper_InitRequest", req.reqId).detail("RatekeeperId", recruited.id());
															#line 2737 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when8(InitializeConsistencyScanRequest const& req,int loopDepth) 
	{
															#line 2740 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2741 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::ConsistencyScan;
															#line 2742 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		ConsistencyScanInterface recruited(locality, req.reqId);
															#line 2743 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2745 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (csInterf->get().present())
															#line 13276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2746 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited = csInterf->get().get();
															#line 2747 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recovered while already a consistencyscan");
															#line 13282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2749 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::CONSISTENCYSCAN, recruited.id(), interf.id());
															#line 2750 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2751 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltConsistencyScan);
															#line 2753 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> consistencyScanProcess = consistencyScan(recruited, dbInfo);
															#line 2754 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::CONSISTENCYSCAN, recruited.id(), setWhenDoneOrError(consistencyScanProcess, csInterf, Optional<ConsistencyScanInterface>())));
															#line 2759 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			csInterf->set(Optional<ConsistencyScanInterface>(recruited));
															#line 13298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2761 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ConsistencyScanReceived", req.reqId).detail("ConsistencyScanId", recruited.id());
															#line 2762 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when8(InitializeConsistencyScanRequest && req,int loopDepth) 
	{
															#line 2740 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2741 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::ConsistencyScan;
															#line 2742 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		ConsistencyScanInterface recruited(locality, req.reqId);
															#line 2743 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2745 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (csInterf->get().present())
															#line 13321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2746 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited = csInterf->get().get();
															#line 2747 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recovered while already a consistencyscan");
															#line 13327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2749 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::CONSISTENCYSCAN, recruited.id(), interf.id());
															#line 2750 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2751 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltConsistencyScan);
															#line 2753 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> consistencyScanProcess = consistencyScan(recruited, dbInfo);
															#line 2754 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::CONSISTENCYSCAN, recruited.id(), setWhenDoneOrError(consistencyScanProcess, csInterf, Optional<ConsistencyScanInterface>())));
															#line 2759 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			csInterf->set(Optional<ConsistencyScanInterface>(recruited));
															#line 13343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2761 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ConsistencyScanReceived", req.reqId).detail("ConsistencyScanId", recruited.id());
															#line 2762 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when9(InitializeBackupRequest const& req,int loopDepth) 
	{
															#line 2765 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!backupWorkerCache.exists(req.reqId))
															#line 13358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2766 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 2767 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Backup;
															#line 2768 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			BackupInterface recruited(locality);
															#line 2769 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 2771 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::BACKUP, recruited.id(), interf.id());
															#line 2772 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2774 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeBackupReply> backupReady = req.reply;
															#line 2775 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			backupWorkerCache.set(req.reqId, backupReady.getFuture());
															#line 2776 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> backupProcess = backupWorker(recruited, req, dbInfo);
															#line 2777 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			backupProcess = backupWorkerCache.removeOnReady(req.reqId, backupProcess);
															#line 2778 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::BACKUP, recruited.id(), backupProcess));
															#line 2779 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("BackupInitRequest", req.reqId).detail("BackupId", recruited.id());
															#line 2780 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			InitializeBackupReply reply(recruited, req.backupEpoch);
															#line 2781 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			backupReady.send(reply);
															#line 13388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2783 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			forwardPromise(req.reply, backupWorkerCache.get(req.reqId));
															#line 13394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when9(InitializeBackupRequest && req,int loopDepth) 
	{
															#line 2765 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!backupWorkerCache.exists(req.reqId))
															#line 13404 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2766 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 2767 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Backup;
															#line 2768 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			BackupInterface recruited(locality);
															#line 2769 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 2771 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::BACKUP, recruited.id(), interf.id());
															#line 2772 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2774 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeBackupReply> backupReady = req.reply;
															#line 2775 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			backupWorkerCache.set(req.reqId, backupReady.getFuture());
															#line 2776 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> backupProcess = backupWorker(recruited, req, dbInfo);
															#line 2777 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			backupProcess = backupWorkerCache.removeOnReady(req.reqId, backupProcess);
															#line 2778 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::BACKUP, recruited.id(), backupProcess));
															#line 2779 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("BackupInitRequest", req.reqId).detail("BackupId", recruited.id());
															#line 2780 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			InitializeBackupReply reply(recruited, req.backupEpoch);
															#line 2781 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			backupReady.send(reply);
															#line 13434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2783 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			forwardPromise(req.reply, backupWorkerCache.get(req.reqId));
															#line 13440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when10(InitializeEncryptKeyProxyRequest const& req,int loopDepth) 
	{
															#line 2787 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2788 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::EncryptKeyProxy;
															#line 2789 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		EncryptKeyProxyInterface recruited(locality, req.reqId);
															#line 2790 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2792 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (ekpInterf->get().present())
															#line 13458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2793 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited = ekpInterf->get().get();
															#line 2794 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a encryptKeyProxy server.", probe::decoration::rare);
															#line 13464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2796 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::ENCRYPT_KEY_PROXY, recruited.id(), interf.id());
															#line 2797 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2798 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltEncryptKeyProxy);
															#line 2799 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getBaseCipherKeysByIds);
															#line 2800 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getLatestBaseCipherKeys);
															#line 2801 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getLatestBlobMetadata);
															#line 2802 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getHealthStatus);
															#line 2804 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> encryptKeyProxyProcess = encryptKeyProxyServer(recruited, dbInfo, req.encryptMode);
															#line 2805 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::ENCRYPT_KEY_PROXY, recruited.id(), setWhenDoneOrError(encryptKeyProxyProcess, ekpInterf, Optional<EncryptKeyProxyInterface>())));
															#line 2810 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ekpInterf->set(Optional<EncryptKeyProxyInterface>(recruited));
															#line 13488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2812 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("EncryptKeyProxyReceived", req.reqId).detail("EncryptKeyProxyId", recruited.id());
															#line 2813 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when10(InitializeEncryptKeyProxyRequest && req,int loopDepth) 
	{
															#line 2787 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2788 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::EncryptKeyProxy;
															#line 2789 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		EncryptKeyProxyInterface recruited(locality, req.reqId);
															#line 2790 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2792 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (ekpInterf->get().present())
															#line 13511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2793 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited = ekpInterf->get().get();
															#line 2794 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a encryptKeyProxy server.", probe::decoration::rare);
															#line 13517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2796 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::ENCRYPT_KEY_PROXY, recruited.id(), interf.id());
															#line 2797 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2798 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltEncryptKeyProxy);
															#line 2799 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getBaseCipherKeysByIds);
															#line 2800 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getLatestBaseCipherKeys);
															#line 2801 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getLatestBlobMetadata);
															#line 2802 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getHealthStatus);
															#line 2804 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> encryptKeyProxyProcess = encryptKeyProxyServer(recruited, dbInfo, req.encryptMode);
															#line 2805 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::ENCRYPT_KEY_PROXY, recruited.id(), setWhenDoneOrError(encryptKeyProxyProcess, ekpInterf, Optional<EncryptKeyProxyInterface>())));
															#line 2810 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ekpInterf->set(Optional<EncryptKeyProxyInterface>(recruited));
															#line 13541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2812 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("EncryptKeyProxyReceived", req.reqId).detail("EncryptKeyProxyId", recruited.id());
															#line 2813 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when11(InitializeTLogRequest const& req,int loopDepth) 
	{
															#line 2820 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (req.logVersion < TLogVersion::MIN_RECRUITABLE)
															#line 13556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2821 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevError, "InitializeTLogInvalidLogVersion") .detail("Version", req.logVersion) .detail("MinRecruitable", TLogVersion::MIN_RECRUITABLE);
															#line 2824 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(internal_error());
															#line 13562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2826 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2827 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::TLog;
															#line 2828 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TLogOptions tLogOptions(req.logVersion, req.spillType);
															#line 2829 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TLogFn tLogFn = tLogFnForOptions(tLogOptions);
															#line 2830 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto& logData = sharedLogs[SharedLogsKey(tLogOptions, req.storeType)];
															#line 2831 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		for(;!logData.empty() && (!logData.back().actor.isValid() || logData.back().actor.isReady());) {
															#line 2832 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			logData.pop_back();
															#line 13578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2834 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (logData.empty())
															#line 13582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2835 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			UID logId = deterministicRandom()->randomUniqueID();
															#line 2836 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 2837 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			details["ForMaster"] = req.recruitmentID.shortString();
															#line 2838 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 2842 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::SHARED_TRANSACTION_LOG, logId, interf.id(), details);
															#line 2844 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			const StringRef prefix = req.logVersion > TLogVersion::V2 ? fileVersionedLogDataPrefix : fileLogDataPrefix;
															#line 2846 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, prefix.toString() + tLogOptions.toPrefix(), logId);
															#line 2848 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore(req.storeType, filename, logId, memoryLimit, false, false, false, dbInfo, EncryptionAtRestMode());
															#line 2857 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			const DiskQueueVersion dqv = tLogOptions.getDiskQueueVersion();
															#line 2858 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			IDiskQueue* queue = openDiskQueue( joinPath(folder, fileLogQueuePrefix.toString() + tLogOptions.toPrefix() + logId.toString() + "-"), tlogQueueExtension.toString(), logId, dqv);
															#line 2864 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(data->onClosed());
															#line 2865 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(queue->onClosed());
															#line 2867 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			logData.push_back(SharedLogsValue());
															#line 2868 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> tLogCore = tLogFn(data, queue, dbInfo, locality, logData.back().requests, logId, interf.id(), false, Promise<Void>(), Promise<Void>(), folder, degraded, activeSharedTLog, enablePrimaryTxnSystemHealthCheck);
															#line 2882 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, data, logId);
															#line 2883 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, queue, logId);
															#line 2884 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::SHARED_TRANSACTION_LOG, logId, tLogCore));
															#line 2885 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().actor = tLogCore;
															#line 2886 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().uid = logId;
															#line 13622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2888 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		logData.back().requests.send(req);
															#line 2889 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		activeSharedTLog->set(logData.back().uid);
															#line 13628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when11(InitializeTLogRequest && req,int loopDepth) 
	{
															#line 2820 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (req.logVersion < TLogVersion::MIN_RECRUITABLE)
															#line 13637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2821 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevError, "InitializeTLogInvalidLogVersion") .detail("Version", req.logVersion) .detail("MinRecruitable", TLogVersion::MIN_RECRUITABLE);
															#line 2824 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(internal_error());
															#line 13643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2826 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2827 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::TLog;
															#line 2828 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TLogOptions tLogOptions(req.logVersion, req.spillType);
															#line 2829 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TLogFn tLogFn = tLogFnForOptions(tLogOptions);
															#line 2830 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		auto& logData = sharedLogs[SharedLogsKey(tLogOptions, req.storeType)];
															#line 2831 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		for(;!logData.empty() && (!logData.back().actor.isValid() || logData.back().actor.isReady());) {
															#line 2832 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			logData.pop_back();
															#line 13659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2834 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (logData.empty())
															#line 13663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2835 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			UID logId = deterministicRandom()->randomUniqueID();
															#line 2836 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 2837 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			details["ForMaster"] = req.recruitmentID.shortString();
															#line 2838 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 2842 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::SHARED_TRANSACTION_LOG, logId, interf.id(), details);
															#line 2844 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			const StringRef prefix = req.logVersion > TLogVersion::V2 ? fileVersionedLogDataPrefix : fileLogDataPrefix;
															#line 2846 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, prefix.toString() + tLogOptions.toPrefix(), logId);
															#line 2848 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore(req.storeType, filename, logId, memoryLimit, false, false, false, dbInfo, EncryptionAtRestMode());
															#line 2857 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			const DiskQueueVersion dqv = tLogOptions.getDiskQueueVersion();
															#line 2858 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			IDiskQueue* queue = openDiskQueue( joinPath(folder, fileLogQueuePrefix.toString() + tLogOptions.toPrefix() + logId.toString() + "-"), tlogQueueExtension.toString(), logId, dqv);
															#line 2864 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(data->onClosed());
															#line 2865 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(queue->onClosed());
															#line 2867 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			logData.push_back(SharedLogsValue());
															#line 2868 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> tLogCore = tLogFn(data, queue, dbInfo, locality, logData.back().requests, logId, interf.id(), false, Promise<Void>(), Promise<Void>(), folder, degraded, activeSharedTLog, enablePrimaryTxnSystemHealthCheck);
															#line 2882 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, data, logId);
															#line 2883 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, queue, logId);
															#line 2884 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::SHARED_TRANSACTION_LOG, logId, tLogCore));
															#line 2885 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().actor = tLogCore;
															#line 2886 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().uid = logId;
															#line 13703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2888 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		logData.back().requests.send(req);
															#line 2889 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		activeSharedTLog->set(logData.back().uid);
															#line 13709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when12(InitializeStorageRequest const& req,int loopDepth) 
	{
															#line 2892 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("StorageServerInitProgress", req.interfaceId);
															#line 2893 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Step", "1.RequestReceived");
															#line 2894 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("ReqID", req.reqId);
															#line 2895 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("WorkerID", interf.id());
															#line 2896 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("StorageType", req.storeType.toString());
															#line 2897 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("SeedTag", req.seedTag.toString());
															#line 2898 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("IsTssPair", req.tssPairIDAndVersion.present());
															#line 2899 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (req.tssPairIDAndVersion.present())
															#line 13732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2900 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("TssPairID", req.tssPairIDAndVersion.get().first);
															#line 13736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2902 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		int j = 0;
															#line 2903 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		for( const auto& runningStorage : runningStorages ) {
															#line 2904 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageIDOnSameWorker" + std::to_string(j), runningStorage.first);
															#line 2905 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageEngineOnSameWorker" + std::to_string(j), runningStorage.second);
															#line 2906 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			j++;
															#line 13748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2914 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (std::all_of(runningStorages.begin(), runningStorages.end(), [&req](const auto& p) { return p.second != req.storeType; }) || req.seedTag != invalidTag)
															#line 13752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2918 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(req.initialClusterVersion >= 0);
															#line 2919 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 2920 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Storage;
															#line 2926 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			cleanupStorageDisks(dbInfo, storageCleaners, memoryLimit);
															#line 2928 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			bool isTss = req.tssPairIDAndVersion.present();
															#line 2929 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StorageServerInterface recruited(req.interfaceId);
															#line 2930 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited.locality = locality;
															#line 2931 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited.tssPairID = isTss ? req.tssPairIDAndVersion.get().first : Optional<UID>();
															#line 2932 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 2934 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 2935 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 2936 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			details["IsTSS"] = std::to_string(isTss);
															#line 2937 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Role ssRole = isTss ? Role::TESTING_STORAGE_SERVER : Role::STORAGE_SERVER;
															#line 2938 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			startRole(ssRole, recruited.id(), interf.id(), details);
															#line 2939 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "2.RoleStarted") .detail("WorkerID", interf.id());
															#line 2945 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getValue);
															#line 2946 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKey);
															#line 2947 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValues);
															#line 2948 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getMappedKeyValues);
															#line 2949 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getShardState);
															#line 2950 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitMetrics);
															#line 2951 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.splitMetrics);
															#line 2952 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getReadHotRanges);
															#line 2953 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 2954 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getStorageMetrics);
															#line 2955 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2956 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getQueuingMetrics);
															#line 2957 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 2958 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.watchValue);
															#line 2959 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValuesStream);
															#line 2960 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedStream);
															#line 2961 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedPop);
															#line 2962 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 2964 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, isTss ? testingStoragePrefix.toString() : fileStoragePrefix.toString(), recruited.id());
															#line 2969 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Reference<GetEncryptCipherKeysMonitor> encryptionMonitor = makeReference<GetEncryptCipherKeysMonitor>();
															#line 2971 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore( req.storeType, filename, recruited.id(), memoryLimit, false, false, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( req.storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && req.storeType != KeyValueStoreType::SSD_SHARDED_ROCKSDB && deterministicRandom()->coinflip()) : true), dbInfo, req.encryptMode, 0, encryptionMonitor);
															#line 2988 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "3.KVStoreOpened") .detail("WorkerID", interf.id());
															#line 2994 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> kvClosed = data->onClosed() || rebootKVSPromise2 .getFuture();
															#line 2998 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(kvClosed);
															#line 2999 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeStorageReply> storageReady = req.reply;
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<ErrorOr<Void>> storeError = errorOr(data->getError());
															#line 3001 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> s = storageServer(data, recruited, req.seedTag, req.initialClusterVersion, isTss ? req.tssPairIDAndVersion.get().second : 0, storageReady, dbInfo, folder, encryptionMonitor);
															#line 3010 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			s = handleIOErrors(s, storeError, recruited.id(), kvClosed);
															#line 3011 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			s = storageServerRollbackRebooter(&runningStorages, &storageCleaners, s, req.storeType, filename, recruited.id(), recruited.locality, isTss, dbInfo, folder, &filesClosed, memoryLimit, data, false, &rebootKVSPromise2, encryptionMonitor);
															#line 3027 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, ssRole, recruited.id(), s));
															#line 13844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3029 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("AttemptedDoubleRecruitment", interf.id()).detail("ForRole", "StorageServer");
															#line 3030 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(map(delay(0.5), [reply = req.reply](Void) { reply.sendError(recruitment_failed()); return Void(); }));
															#line 13852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when12(InitializeStorageRequest && req,int loopDepth) 
	{
															#line 2892 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("StorageServerInitProgress", req.interfaceId);
															#line 2893 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Step", "1.RequestReceived");
															#line 2894 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("ReqID", req.reqId);
															#line 2895 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("WorkerID", interf.id());
															#line 2896 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("StorageType", req.storeType.toString());
															#line 2897 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("SeedTag", req.seedTag.toString());
															#line 2898 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("IsTssPair", req.tssPairIDAndVersion.present());
															#line 2899 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (req.tssPairIDAndVersion.present())
															#line 13876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2900 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("TssPairID", req.tssPairIDAndVersion.get().first);
															#line 13880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2902 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		int j = 0;
															#line 2903 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		for( const auto& runningStorage : runningStorages ) {
															#line 2904 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageIDOnSameWorker" + std::to_string(j), runningStorage.first);
															#line 2905 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageEngineOnSameWorker" + std::to_string(j), runningStorage.second);
															#line 2906 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			j++;
															#line 13892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 2914 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (std::all_of(runningStorages.begin(), runningStorages.end(), [&req](const auto& p) { return p.second != req.storeType; }) || req.seedTag != invalidTag)
															#line 13896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2918 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(req.initialClusterVersion >= 0);
															#line 2919 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 2920 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Storage;
															#line 2926 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			cleanupStorageDisks(dbInfo, storageCleaners, memoryLimit);
															#line 2928 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			bool isTss = req.tssPairIDAndVersion.present();
															#line 2929 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StorageServerInterface recruited(req.interfaceId);
															#line 2930 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited.locality = locality;
															#line 2931 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited.tssPairID = isTss ? req.tssPairIDAndVersion.get().first : Optional<UID>();
															#line 2932 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 2934 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 2935 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 2936 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			details["IsTSS"] = std::to_string(isTss);
															#line 2937 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Role ssRole = isTss ? Role::TESTING_STORAGE_SERVER : Role::STORAGE_SERVER;
															#line 2938 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			startRole(ssRole, recruited.id(), interf.id(), details);
															#line 2939 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "2.RoleStarted") .detail("WorkerID", interf.id());
															#line 2945 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getValue);
															#line 2946 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKey);
															#line 2947 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValues);
															#line 2948 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getMappedKeyValues);
															#line 2949 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getShardState);
															#line 2950 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitMetrics);
															#line 2951 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.splitMetrics);
															#line 2952 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getReadHotRanges);
															#line 2953 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 2954 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getStorageMetrics);
															#line 2955 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2956 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getQueuingMetrics);
															#line 2957 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 2958 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.watchValue);
															#line 2959 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValuesStream);
															#line 2960 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedStream);
															#line 2961 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedPop);
															#line 2962 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 2964 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, isTss ? testingStoragePrefix.toString() : fileStoragePrefix.toString(), recruited.id());
															#line 2969 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Reference<GetEncryptCipherKeysMonitor> encryptionMonitor = makeReference<GetEncryptCipherKeysMonitor>();
															#line 2971 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore( req.storeType, filename, recruited.id(), memoryLimit, false, false, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( req.storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && req.storeType != KeyValueStoreType::SSD_SHARDED_ROCKSDB && deterministicRandom()->coinflip()) : true), dbInfo, req.encryptMode, 0, encryptionMonitor);
															#line 2988 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "3.KVStoreOpened") .detail("WorkerID", interf.id());
															#line 2994 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> kvClosed = data->onClosed() || rebootKVSPromise2 .getFuture();
															#line 2998 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(kvClosed);
															#line 2999 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeStorageReply> storageReady = req.reply;
															#line 3000 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<ErrorOr<Void>> storeError = errorOr(data->getError());
															#line 3001 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> s = storageServer(data, recruited, req.seedTag, req.initialClusterVersion, isTss ? req.tssPairIDAndVersion.get().second : 0, storageReady, dbInfo, folder, encryptionMonitor);
															#line 3010 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			s = handleIOErrors(s, storeError, recruited.id(), kvClosed);
															#line 3011 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			s = storageServerRollbackRebooter(&runningStorages, &storageCleaners, s, req.storeType, filename, recruited.id(), recruited.locality, isTss, dbInfo, folder, &filesClosed, memoryLimit, data, false, &rebootKVSPromise2, encryptionMonitor);
															#line 3027 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, ssRole, recruited.id(), s));
															#line 13988 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3029 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("AttemptedDoubleRecruitment", interf.id()).detail("ForRole", "StorageServer");
															#line 3030 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(map(delay(0.5), [reply = req.reply](Void) { reply.sendError(recruitment_failed()); return Void(); }));
															#line 13996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when13(InitializeCommitProxyRequest const& req,int loopDepth) 
	{
															#line 3037 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3038 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::CommitProxy;
															#line 3039 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		CommitProxyInterface recruited;
															#line 3040 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 3041 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 3042 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3044 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3045 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 3046 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::COMMIT_PROXY, recruited.id(), interf.id(), details);
															#line 3048 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.commit);
															#line 3049 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 3050 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyServersLocations);
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageServerRejoinInfo);
															#line 3052 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3053 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.txnState);
															#line 3054 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getTenantId);
															#line 3056 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie(recruited, forwardError(errors, Role::COMMIT_PROXY, recruited.id(), commitProxyServer(recruited, req, dbInfo, whitelistBinPaths))));
															#line 3061 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when13(InitializeCommitProxyRequest && req,int loopDepth) 
	{
															#line 3037 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3038 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::CommitProxy;
															#line 3039 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		CommitProxyInterface recruited;
															#line 3040 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 3041 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 3042 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3044 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3045 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 3046 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::COMMIT_PROXY, recruited.id(), interf.id(), details);
															#line 3048 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.commit);
															#line 3049 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 3050 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyServersLocations);
															#line 3051 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageServerRejoinInfo);
															#line 3052 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3053 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.txnState);
															#line 3054 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getTenantId);
															#line 3056 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie(recruited, forwardError(errors, Role::COMMIT_PROXY, recruited.id(), commitProxyServer(recruited, req, dbInfo, whitelistBinPaths))));
															#line 3061 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14083 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when14(InitializeGrvProxyRequest const& req,int loopDepth) 
	{
															#line 3064 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3065 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::GrvProxy;
															#line 3066 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		GrvProxyInterface recruited;
															#line 3067 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 3068 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 3069 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3071 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3072 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 3073 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::GRV_PROXY, recruited.id(), interf.id(), details);
															#line 3075 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 3076 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3077 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getHealthMetrics);
															#line 3080 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::GRV_PROXY, recruited.id(), grvProxyServer(recruited, req, dbInfo))));
															#line 3083 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when14(InitializeGrvProxyRequest && req,int loopDepth) 
	{
															#line 3064 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3065 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::GrvProxy;
															#line 3066 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		GrvProxyInterface recruited;
															#line 3067 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 3068 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 3069 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3071 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3072 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 3073 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::GRV_PROXY, recruited.id(), interf.id(), details);
															#line 3075 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 3076 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3077 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getHealthMetrics);
															#line 3080 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::GRV_PROXY, recruited.id(), grvProxyServer(recruited, req, dbInfo))));
															#line 3083 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when15(InitializeResolverRequest const& req,int loopDepth) 
	{
															#line 3086 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3087 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Resolver;
															#line 3088 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		ResolverInterface recruited;
															#line 3089 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 3090 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3093 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::RESOLVER, recruited.id(), interf.id(), details);
															#line 3095 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.resolve);
															#line 3096 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.metrics);
															#line 3097 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.split);
															#line 3098 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3100 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::RESOLVER, recruited.id(), resolver(recruited, req, dbInfo))));
															#line 3102 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when15(InitializeResolverRequest && req,int loopDepth) 
	{
															#line 3086 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3087 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Resolver;
															#line 3088 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		ResolverInterface recruited;
															#line 3089 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 3090 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3092 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3093 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::RESOLVER, recruited.id(), interf.id(), details);
															#line 3095 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.resolve);
															#line 3096 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.metrics);
															#line 3097 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.split);
															#line 3098 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3100 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::RESOLVER, recruited.id(), resolver(recruited, req, dbInfo))));
															#line 3102 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when16(InitializeLogRouterRequest const& req,int loopDepth) 
	{
															#line 3105 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3106 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::LogRouter;
															#line 3107 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TLogInterface recruited(locality);
															#line 3108 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3110 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3111 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::LOG_ROUTER, recruited.id(), interf.id(), details);
															#line 3113 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.peekMessages);
															#line 3114 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.peekStreamMessages);
															#line 3115 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.popMessages);
															#line 3116 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.commit);
															#line 3117 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.lock);
															#line 3118 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 3119 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.confirmRunning);
															#line 3120 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3121 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.recoveryFinished);
															#line 3122 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.disablePopRequest);
															#line 3123 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.enablePopRequest);
															#line 3124 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.snapRequest);
															#line 3126 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( zombie(recruited, forwardError(errors, Role::LOG_ROUTER, recruited.id(), logRouter(recruited, req, dbInfo))));
															#line 3130 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!skipInitRspInSim(interf.id(), req.allowDropInSim))
															#line 14266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3131 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(recruited);
															#line 14270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when16(InitializeLogRouterRequest && req,int loopDepth) 
	{
															#line 3105 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3106 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::LogRouter;
															#line 3107 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TLogInterface recruited(locality);
															#line 3108 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3110 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3111 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::LOG_ROUTER, recruited.id(), interf.id(), details);
															#line 3113 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.peekMessages);
															#line 3114 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.peekStreamMessages);
															#line 3115 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.popMessages);
															#line 3116 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.commit);
															#line 3117 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.lock);
															#line 3118 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 3119 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.confirmRunning);
															#line 3120 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3121 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.recoveryFinished);
															#line 3122 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.disablePopRequest);
															#line 3123 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.enablePopRequest);
															#line 3124 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.snapRequest);
															#line 3126 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( zombie(recruited, forwardError(errors, Role::LOG_ROUTER, recruited.id(), logRouter(recruited, req, dbInfo))));
															#line 3130 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!skipInitRspInSim(interf.id(), req.allowDropInSim))
															#line 14318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3131 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(recruited);
															#line 14322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when17(CoordinationPingMessage const& m,int loopDepth) 
	{
															#line 3135 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("CoordinationPing", interf.id()) .detail("CCID", m.clusterControllerId) .detail("TimeStep", m.timeStep);
															#line 14332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when17(CoordinationPingMessage && m,int loopDepth) 
	{
															#line 3135 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("CoordinationPing", interf.id()) .detail("CCID", m.clusterControllerId) .detail("TimeStep", m.timeStep);
															#line 14341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when18(SetMetricsLogRateRequest const& req,int loopDepth) 
	{
															#line 3140 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("LoggingRateChange", interf.id()) .detail("OldDelay", loggingDelay) .detail("NewLogPS", req.metricsLogsPerSecond);
															#line 3143 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (req.metricsLogsPerSecond != 0)
															#line 14352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3144 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			loggingDelay = 1.0 / req.metricsLogsPerSecond;
															#line 3145 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			loggingTrigger = Void();
															#line 14358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when18(SetMetricsLogRateRequest && req,int loopDepth) 
	{
															#line 3140 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("LoggingRateChange", interf.id()) .detail("OldDelay", loggingDelay) .detail("NewLogPS", req.metricsLogsPerSecond);
															#line 3143 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (req.metricsLogsPerSecond != 0)
															#line 14370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3144 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			loggingDelay = 1.0 / req.metricsLogsPerSecond;
															#line 3145 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			loggingTrigger = Void();
															#line 14376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when19(EventLogRequest const& req,int loopDepth) 
	{
															#line 3149 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEventFields e;
															#line 3150 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (req.getLastError)
															#line 14388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3151 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.getLatestError();
															#line 14392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3153 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.get(req.eventName.toString());
															#line 14398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 3154 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(e);
															#line 14402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when19(EventLogRequest && req,int loopDepth) 
	{
															#line 3149 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEventFields e;
															#line 3150 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (req.getLastError)
															#line 14413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3151 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.getLatestError();
															#line 14417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3153 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.get(req.eventName.toString());
															#line 14423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 3154 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(e);
															#line 14427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when20(TraceBatchDumpRequest const& req,int loopDepth) 
	{
															#line 3157 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		g_traceBatch.dump();
															#line 3158 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(Void());
															#line 14438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when20(TraceBatchDumpRequest && req,int loopDepth) 
	{
															#line 3157 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		g_traceBatch.dump();
															#line 3158 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(Void());
															#line 14449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when21(DiskStoreRequest const& req,int loopDepth) 
	{
															#line 3161 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Standalone<VectorRef<UID>> ids;
															#line 3168 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		for( DiskStore d : getDiskStores(folder) ) {
															#line 3169 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			bool included = true;
															#line 3170 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!req.includePartialStores)
															#line 14464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 3171 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storeType == KeyValueStoreType::SSD_BTREE_V1)
															#line 14468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 3172 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					included = fileExists(d.filename + ".fdb-wal");
															#line 14472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
				else
				{
															#line 3173 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					if (d.storeType == KeyValueStoreType::SSD_BTREE_V2)
															#line 14478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
					{
															#line 3174 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
						included = fileExists(d.filename + ".sqlite-wal");
															#line 14482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
					}
					else
					{
															#line 3175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
						if (d.storeType == KeyValueStoreType::SSD_REDWOOD_V1)
															#line 14488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
						{
															#line 3176 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
							included = fileExists(d.filename + "0.pagerlog") && fileExists(d.filename + "1.pagerlog");
															#line 14492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
						}
						else
						{
															#line 3177 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
							if (d.storeType == KeyValueStoreType::SSD_ROCKSDB_V1)
															#line 14498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
							{
															#line 3178 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
								included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 14502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
							}
							else
							{
															#line 3180 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
								if (d.storeType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 14508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
								{
															#line 3181 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
									included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 14512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
								}
								else
								{
															#line 3183 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
									if (d.storeType == KeyValueStoreType::MEMORY)
															#line 14518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
									{
															#line 3184 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdq");
															#line 14522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
									}
									else
									{
															#line 3186 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
										ASSERT(d.storeType == KeyValueStoreType::MEMORY_RADIXTREE);
															#line 3187 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdr");
															#line 14530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
									}
								}
							}
						}
					}
				}
															#line 3189 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storedComponent == DiskStore::COMPONENT::TLogData)
															#line 14539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 3192 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					included = false;
															#line 14543 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 3195 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (included)
															#line 14548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 3196 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				ids.push_back(ids.arena(), d.storeID);
															#line 14552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 3199 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(ids);
															#line 14557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when21(DiskStoreRequest && req,int loopDepth) 
	{
															#line 3161 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Standalone<VectorRef<UID>> ids;
															#line 3168 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		for( DiskStore d : getDiskStores(folder) ) {
															#line 3169 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			bool included = true;
															#line 3170 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (!req.includePartialStores)
															#line 14572 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 3171 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storeType == KeyValueStoreType::SSD_BTREE_V1)
															#line 14576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 3172 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					included = fileExists(d.filename + ".fdb-wal");
															#line 14580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
				else
				{
															#line 3173 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					if (d.storeType == KeyValueStoreType::SSD_BTREE_V2)
															#line 14586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
					{
															#line 3174 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
						included = fileExists(d.filename + ".sqlite-wal");
															#line 14590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
					}
					else
					{
															#line 3175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
						if (d.storeType == KeyValueStoreType::SSD_REDWOOD_V1)
															#line 14596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
						{
															#line 3176 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
							included = fileExists(d.filename + "0.pagerlog") && fileExists(d.filename + "1.pagerlog");
															#line 14600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
						}
						else
						{
															#line 3177 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
							if (d.storeType == KeyValueStoreType::SSD_ROCKSDB_V1)
															#line 14606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
							{
															#line 3178 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
								included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 14610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
							}
							else
							{
															#line 3180 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
								if (d.storeType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 14616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
								{
															#line 3181 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
									included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 14620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
								}
								else
								{
															#line 3183 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
									if (d.storeType == KeyValueStoreType::MEMORY)
															#line 14626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
									{
															#line 3184 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdq");
															#line 14630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
									}
									else
									{
															#line 3186 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
										ASSERT(d.storeType == KeyValueStoreType::MEMORY_RADIXTREE);
															#line 3187 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdr");
															#line 14638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
									}
								}
							}
						}
					}
				}
															#line 3189 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storedComponent == DiskStore::COMPONENT::TLogData)
															#line 14647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 3192 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					included = false;
															#line 14651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 3195 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (included)
															#line 14656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 3196 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				ids.push_back(ids.arena(), d.storeID);
															#line 14660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 3199 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(ids);
															#line 14665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when22(Void const& _,int loopDepth) 
	{
															#line 3202 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		systemMonitor();
															#line 3203 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		loggingTrigger = delay(loggingDelay, TaskPriority::FlushTrace);
															#line 14676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when22(Void && _,int loopDepth) 
	{
															#line 3202 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		systemMonitor();
															#line 3203 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		loggingTrigger = delay(loggingDelay, TaskPriority::FlushTrace);
															#line 14687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when23(WorkerSnapRequest const& __snapReq,int loopDepth) 
	{
															#line 3205 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		snapReq = __snapReq;
															#line 3206 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::string snapReqKey = snapReq.snapUID.toString() + snapReq.role.toString();
															#line 3207 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReqResultMap.contains(snapReqKey))
															#line 14700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3208 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker received a duplicate finished snapshot request", probe::decoration::rare);
															#line 3209 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			auto result = snapReqResultMap[snapReqKey];
															#line 3210 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			result.isError() ? snapReq.reply.sendError(result.getError()) : snapReq.reply.send(result.get());
															#line 3211 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("RetryFinishedWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role) .detail("Result", result.isError() ? result.getError().code() : success().code());
															#line 14710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3215 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (snapReqMap.contains(snapReqKey))
															#line 14716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 3216 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Worker received a duplicate ongoing snapshot request", probe::decoration::rare);
															#line 3217 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("RetryOngoingWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role);
															#line 3220 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.role == snapReqMap[snapReqKey].role);
															#line 3221 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.snapPayload == snapReqMap[snapReqKey].snapPayload);
															#line 3226 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey].reply.sendError(duplicate_snapshot_request());
															#line 3227 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 14730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 3229 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 3230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated() && (now() - lastSnapTime) < SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)
															#line 14738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 3232 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					auto okay = lastSnapReq.snapUID != snapReq.snapUID || lastSnapReq.role != snapReq.role;
															#line 3233 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent(okay ? SevInfo : SevError, "RapidSnapRequestsOnSameProcess") .detail("CurrSnapUID", snapReq.snapUID) .detail("PrevSnapUID", lastSnapReq.snapUID) .detail("CurrRole", snapReq.role) .detail("PrevRole", lastSnapReq.role) .detail("GapTime", now() - lastSnapTime);
															#line 14744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
															#line 3240 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				auto* snapReqResultMapPtr = &snapReqResultMap;
															#line 3241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add(fmap( [snapReqResultMapPtr, snapReqKey](Void _) { snapReqResultMapPtr->erase(snapReqKey); return Void(); }, delayed(workerSnapCreate(snapReq, snapReq.role.toString() == "coord" ? coordFolder : folder, &snapReqMap, &snapReqResultMap), SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)));
															#line 3251 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated())
															#line 14752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 3252 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapReq = snapReq;
															#line 3253 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapTime = now();
															#line 14758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
			}
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when23(WorkerSnapRequest && __snapReq,int loopDepth) 
	{
		snapReq = std::move(__snapReq);
															#line 3206 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::string snapReqKey = snapReq.snapUID.toString() + snapReq.role.toString();
															#line 3207 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReqResultMap.contains(snapReqKey))
															#line 14773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3208 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker received a duplicate finished snapshot request", probe::decoration::rare);
															#line 3209 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			auto result = snapReqResultMap[snapReqKey];
															#line 3210 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			result.isError() ? snapReq.reply.sendError(result.getError()) : snapReq.reply.send(result.get());
															#line 3211 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("RetryFinishedWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role) .detail("Result", result.isError() ? result.getError().code() : success().code());
															#line 14783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3215 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (snapReqMap.contains(snapReqKey))
															#line 14789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 3216 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Worker received a duplicate ongoing snapshot request", probe::decoration::rare);
															#line 3217 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("RetryOngoingWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role);
															#line 3220 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.role == snapReqMap[snapReqKey].role);
															#line 3221 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.snapPayload == snapReqMap[snapReqKey].snapPayload);
															#line 3226 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey].reply.sendError(duplicate_snapshot_request());
															#line 3227 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 14803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 3229 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 3230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated() && (now() - lastSnapTime) < SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)
															#line 14811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 3232 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					auto okay = lastSnapReq.snapUID != snapReq.snapUID || lastSnapReq.role != snapReq.role;
															#line 3233 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent(okay ? SevInfo : SevError, "RapidSnapRequestsOnSameProcess") .detail("CurrSnapUID", snapReq.snapUID) .detail("PrevSnapUID", lastSnapReq.snapUID) .detail("CurrRole", snapReq.role) .detail("PrevRole", lastSnapReq.role) .detail("GapTime", now() - lastSnapTime);
															#line 14817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
															#line 3240 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				auto* snapReqResultMapPtr = &snapReqResultMap;
															#line 3241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add(fmap( [snapReqResultMapPtr, snapReqKey](Void _) { snapReqResultMapPtr->erase(snapReqKey); return Void(); }, delayed(workerSnapCreate(snapReq, snapReq.role.toString() == "coord" ? coordFolder : folder, &snapReqMap, &snapReqResultMap), SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)));
															#line 3251 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated())
															#line 14825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				{
															#line 3252 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapReq = snapReq;
															#line 3253 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapTime = now();
															#line 14831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				}
			}
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when24(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when24(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when25(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when25(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 3, RebootRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 11, InitializeEncryptKeyProxyRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 12, InitializeTLogRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 13, InitializeStorageRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 14, InitializeCommitProxyRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 15, InitializeGrvProxyRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 16, InitializeResolverRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 17, InitializeLogRouterRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 18, CoordinationPingMessage >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 19, SetMetricsLogRateRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 20, EventLogRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 21, TraceBatchDumpRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 22, DiskStoreRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 23, Void >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 24, WorkerSnapRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 25, Void >::remove();
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 26, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >*,UpdateServerDBInfoRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >*,UpdateServerDBInfoRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12loopBody1when2cont1(int loopDepth) 
	{
															#line 2615 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (g_network->isSimulated())
															#line 14954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 2616 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("SimulatedReboot").detail("Deletion", rebootReq.deleteData);
															#line 2617 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (rebootReq.deleteData)
															#line 14960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 2618 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1cont2Catch1(please_reboot_delete(), std::max(0, loopDepth - 1));
															#line 14964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
															#line 2620 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1cont2Catch1(please_reboot(), std::max(0, loopDepth - 1));
															#line 14968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2622 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("ProcessReboot").log();
															#line 2623 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!rebootReq.deleteData);
															#line 2624 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			flushAndExit(0);
															#line 14978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2cont3(Reference<IAsyncFile> const& checkFile,int loopDepth) 
	{
															#line 2612 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_28 = checkFile->sync();
															#line 2612 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1cont2Catch1(__when_expr_28.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2cont3when1(__when_expr_28.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 5;
															#line 2612 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 28, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 14995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12loopBody1when2cont3(Reference<IAsyncFile> && checkFile,int loopDepth) 
	{
															#line 2612 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_28 = checkFile->sync();
															#line 2612 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1cont2Catch1(__when_expr_28.getError(), std::max(0, loopDepth - 1)); else return a_body1cont12loopBody1when2cont3when1(__when_expr_28.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 5;
															#line 2612 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 28, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 15011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12loopBody1when2when1(Reference<IAsyncFile> const& checkFile,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont3(checkFile, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2when1(Reference<IAsyncFile> && checkFile,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont3(std::move(checkFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont12loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont12loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 27);

	}
	int a_body1cont12loopBody1when2cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when2cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1when2cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 28, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 28, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12loopBody1when2cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 28, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont12loopBody1when2cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 28, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 3, RebootRequest >*,RebootRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 3, RebootRequest >*,RebootRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 3, RebootRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >*,SetFailureInjection const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >*,SetFailureInjection && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12loopBody1when4cont1(int loopDepth) 
	{
		loopDepth = a_body1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12loopBody1when4Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2661 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			profilerReq.reply.sendError(e);
															#line 15303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1cont12loopBody1when4cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont12loopBody1when4cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12loopBody1when4cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >*,ProfilerRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >*,ProfilerRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >*,RecruitMasterRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >*,RecruitMasterRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >*,InitializeDataDistributorRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >*,InitializeDataDistributorRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >*,InitializeRatekeeperRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >*,InitializeRatekeeperRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >*,InitializeConsistencyScanRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >*,InitializeConsistencyScanRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >*,InitializeBackupRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >*,InitializeBackupRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 11, InitializeEncryptKeyProxyRequest >*,InitializeEncryptKeyProxyRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when10(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 11, InitializeEncryptKeyProxyRequest >*,InitializeEncryptKeyProxyRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 11, InitializeEncryptKeyProxyRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 12, InitializeTLogRequest >*,InitializeTLogRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when11(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 12, InitializeTLogRequest >*,InitializeTLogRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when11(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 12, InitializeTLogRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 13, InitializeStorageRequest >*,InitializeStorageRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when12(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 13, InitializeStorageRequest >*,InitializeStorageRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when12(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 13, InitializeStorageRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 14, InitializeCommitProxyRequest >*,InitializeCommitProxyRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when13(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 14, InitializeCommitProxyRequest >*,InitializeCommitProxyRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when13(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 14, InitializeCommitProxyRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 15, InitializeGrvProxyRequest >*,InitializeGrvProxyRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when14(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 15, InitializeGrvProxyRequest >*,InitializeGrvProxyRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when14(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 15, InitializeGrvProxyRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 16, InitializeResolverRequest >*,InitializeResolverRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when15(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 16, InitializeResolverRequest >*,InitializeResolverRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when15(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 16, InitializeResolverRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 17, InitializeLogRouterRequest >*,InitializeLogRouterRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when16(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 17, InitializeLogRouterRequest >*,InitializeLogRouterRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when16(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 17, InitializeLogRouterRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 18, CoordinationPingMessage >*,CoordinationPingMessage const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when17(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 18, CoordinationPingMessage >*,CoordinationPingMessage && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when17(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 18, CoordinationPingMessage >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 19, SetMetricsLogRateRequest >*,SetMetricsLogRateRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when18(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 19, SetMetricsLogRateRequest >*,SetMetricsLogRateRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when18(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 19, SetMetricsLogRateRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 20, EventLogRequest >*,EventLogRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when19(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 20, EventLogRequest >*,EventLogRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when19(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 20, EventLogRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 21, TraceBatchDumpRequest >*,TraceBatchDumpRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when20(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 21, TraceBatchDumpRequest >*,TraceBatchDumpRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when20(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 21, TraceBatchDumpRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 22, DiskStoreRequest >*,DiskStoreRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when21(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 22, DiskStoreRequest >*,DiskStoreRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when21(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 22, DiskStoreRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 23, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when22(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 23, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when22(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 23, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 24, WorkerSnapRequest >*,WorkerSnapRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when23(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 24, WorkerSnapRequest >*,WorkerSnapRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when23(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 24, WorkerSnapRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 25, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when24(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 25, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when24(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 25, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 26, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when25(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 26, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12loopBody1when25(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 26, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 26);

	}
	int a_body1cont2Catch1cont1(int loopDepth) 
	{
															#line 3285 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_31 = deregisterGrpcService(interf.id());
															#line 3285 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_31.isReady()) { if (__when_expr_31.isError()) return a_body1Catch1(__when_expr_31.getError(), loopDepth); else return a_body1cont2Catch1cont1when1(__when_expr_31.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 8;
															#line 3285 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_31.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 31, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 16592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1cont3(Void const& _,int loopDepth) 
	{
															#line 3281 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_30 = delay(0.0);
															#line 3281 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_30.isReady()) { if (__when_expr_30.isError()) return a_body1Catch1(__when_expr_30.getError(), loopDepth); else return a_body1cont2Catch1cont3when1(__when_expr_30.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 7;
															#line 3281 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_30.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 30, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 16608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1cont3(Void && _,int loopDepth) 
	{
															#line 3281 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_30 = delay(0.0);
															#line 3281 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_30.isReady()) { if (__when_expr_30.isError()) return a_body1Catch1(__when_expr_30.getError(), loopDepth); else return a_body1cont2Catch1cont3when1(__when_expr_30.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 7;
															#line 3281 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_30.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 30, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 16624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 29, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 29, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 29, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 29, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 29);

	}
	int a_body1cont2Catch1cont4(Void const& _,int loopDepth) 
	{
															#line 3282 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent(SevInfo, "WorkerShutdownComplete", interf.id());
															#line 16708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont2Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1cont4(Void && _,int loopDepth) 
	{
															#line 3282 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent(SevInfo, "WorkerShutdownComplete", interf.id());
															#line 16717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont2Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 30, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 30, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2Catch1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 30, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2Catch1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 30, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 30);

	}
	int a_body1cont2Catch1cont6(Void const& _,int loopDepth) 
	{
															#line 3286 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		return a_body1Catch1(e, loopDepth);
															#line 16801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2Catch1cont6(Void && _,int loopDepth) 
	{
															#line 3286 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		return a_body1Catch1(e, loopDepth);
															#line 16809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 31, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 31, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 31);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 31, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 31);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 31, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 31);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 31);

	}
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<IClusterConnectionRecord> connRecord;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	LocalityData locality;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ClusterControllerPriorityInfo>> asyncPriorityInfo;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ProcessClass initialClass;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryLimit;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string metricsConnFile;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string metricsPrefix;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryProfileThreshold;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string _coordFolder;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string whitelistBinPaths;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ConfigBroadcastInterface configBroadcastInterface;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<ConfigNode> configNode;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<LocalConfiguration> localConfig;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<UID>>> clusterId;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	bool consistencyCheckUrgentMode;
															#line 2193 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	PromiseStream<ErrorInfo> errors;
															#line 2194 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<DataDistributorInterface>>> ddInterf;
															#line 2196 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<RatekeeperInterface>>> rkInterf;
															#line 2197 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<EncryptKeyProxyInterface>>> ekpInterf;
															#line 2199 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ConsistencyScanInterface>>> csInterf;
															#line 2201 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> handleErrors;
															#line 2202 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ActorCollection errorForwarders;
															#line 2203 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> loggingTrigger;
															#line 2204 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	double loggingDelay;
															#line 2206 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void> rebootKVSPromise;
															#line 2207 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void> rebootKVSPromise2;
															#line 2208 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ActorCollection filesClosed;
															#line 2209 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void> stopping;
															#line 2210 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> metricsLogger;
															#line 2211 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> chaosMetricsActor;
															#line 2212 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<bool>> degraded;
															#line 2218 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::map<SharedLogsKey, std::vector<SharedLogsValue>> sharedLogs;
															#line 2219 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<UID>> activeSharedTLog;
															#line 2220 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	WorkerCache<InitializeBackupReply> backupWorkerCache;
															#line 2221 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> blobWorkerFuture;
															#line 2223 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapRequest lastSnapReq;
															#line 2225 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::map<std::string, WorkerSnapRequest> snapReqMap;
															#line 2226 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::map<std::string, ErrorOr<Void>> snapReqResultMap;
															#line 2227 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	double lastSnapTime;
															#line 2228 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string coordFolder;
															#line 2230 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	WorkerInterface interf;
															#line 2232 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::set<std::pair<UID, KeyValueStoreType>> runningStorages;
															#line 2237 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::unordered_map<UID, StorageDiskCleaner> storageCleaners;
															#line 2241 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<std::set<std::string>>> issues;
															#line 2243 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> updateClusterIdFuture;
															#line 2247 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<bool>> enablePrimaryTxnSystemHealthCheck;
															#line 2250 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> grpc;
															#line 2262 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Database db;
															#line 2325 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<Future<Void>> recoveries;
															#line 2328 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<DiskStore> stores;
															#line 2329 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	bool validateDataFiles;
															#line 2330 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	int index;
															#line 2332 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	DiskStore s;
															#line 2597 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	RebootRequest rebootReq;
															#line 2644 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ProfilerRequest profilerReq;
															#line 3205 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapRequest snapReq;
															#line 3264 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Error e;
															#line 17008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via workerServer()
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class WorkerServerActor final : public Actor<Void>, public ActorCallback< WorkerServerActor, 0, Void >, public ActorCallback< WorkerServerActor, 1, Void >, public ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >, public ActorSingleCallback< WorkerServerActor, 3, RebootRequest >, public ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >, public ActorCallback< WorkerServerActor, 28, Void >, public ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >, public ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >, public ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >, public ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >, public ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >, public ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >, public ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >, public ActorSingleCallback< WorkerServerActor, 11, InitializeEncryptKeyProxyRequest >, public ActorSingleCallback< WorkerServerActor, 12, InitializeTLogRequest >, public ActorSingleCallback< WorkerServerActor, 13, InitializeStorageRequest >, public ActorSingleCallback< WorkerServerActor, 14, InitializeCommitProxyRequest >, public ActorSingleCallback< WorkerServerActor, 15, InitializeGrvProxyRequest >, public ActorSingleCallback< WorkerServerActor, 16, InitializeResolverRequest >, public ActorSingleCallback< WorkerServerActor, 17, InitializeLogRouterRequest >, public ActorSingleCallback< WorkerServerActor, 18, CoordinationPingMessage >, public ActorSingleCallback< WorkerServerActor, 19, SetMetricsLogRateRequest >, public ActorSingleCallback< WorkerServerActor, 20, EventLogRequest >, public ActorSingleCallback< WorkerServerActor, 21, TraceBatchDumpRequest >, public ActorSingleCallback< WorkerServerActor, 22, DiskStoreRequest >, public ActorCallback< WorkerServerActor, 23, Void >, public ActorSingleCallback< WorkerServerActor, 24, WorkerSnapRequest >, public ActorCallback< WorkerServerActor, 25, Void >, public ActorCallback< WorkerServerActor, 26, Void >, public ActorCallback< WorkerServerActor, 29, Void >, public ActorCallback< WorkerServerActor, 30, Void >, public ActorCallback< WorkerServerActor, 31, Void >, public FastAllocated<WorkerServerActor>, public WorkerServerActorState<WorkerServerActor> {
															#line 17013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<WorkerServerActor>::operator new;
	using FastAllocated<WorkerServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6465531111770499840UL, 4664876591395077376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerServerActor, 0, Void >;
friend struct ActorCallback< WorkerServerActor, 1, Void >;
friend struct ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 3, RebootRequest >;
friend struct ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >;
friend struct ActorCallback< WorkerServerActor, 28, Void >;
friend struct ActorSingleCallback< WorkerServerActor, 4, SetFailureInjection >;
friend struct ActorSingleCallback< WorkerServerActor, 5, ProfilerRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 6, RecruitMasterRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 7, InitializeDataDistributorRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 8, InitializeRatekeeperRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 9, InitializeConsistencyScanRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 10, InitializeBackupRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 11, InitializeEncryptKeyProxyRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 12, InitializeTLogRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 13, InitializeStorageRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 14, InitializeCommitProxyRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 15, InitializeGrvProxyRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 16, InitializeResolverRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 17, InitializeLogRouterRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 18, CoordinationPingMessage >;
friend struct ActorSingleCallback< WorkerServerActor, 19, SetMetricsLogRateRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 20, EventLogRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 21, TraceBatchDumpRequest >;
friend struct ActorSingleCallback< WorkerServerActor, 22, DiskStoreRequest >;
friend struct ActorCallback< WorkerServerActor, 23, Void >;
friend struct ActorSingleCallback< WorkerServerActor, 24, WorkerSnapRequest >;
friend struct ActorCallback< WorkerServerActor, 25, Void >;
friend struct ActorCallback< WorkerServerActor, 26, Void >;
friend struct ActorCallback< WorkerServerActor, 29, Void >;
friend struct ActorCallback< WorkerServerActor, 30, Void >;
friend struct ActorCallback< WorkerServerActor, 31, Void >;
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	WorkerServerActor(Reference<IClusterConnectionRecord> const& connRecord,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,LocalityData const& locality,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo,ProcessClass const& initialClass,std::string const& folder,int64_t const& memoryLimit,std::string const& metricsConnFile,std::string const& metricsPrefix,int64_t const& memoryProfileThreshold,std::string const& _coordFolder,std::string const& whitelistBinPaths,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,ConfigBroadcastInterface const& configBroadcastInterface,Reference<ConfigNode> const& configNode,Reference<LocalConfiguration> const& localConfig,Reference<AsyncVar<Optional<UID>>> const& clusterId,bool const& consistencyCheckUrgentMode) 
															#line 17061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   WorkerServerActorState<WorkerServerActor>(connRecord, ccInterface, locality, asyncPriorityInfo, initialClass, folder, memoryLimit, metricsConnFile, metricsPrefix, memoryProfileThreshold, _coordFolder, whitelistBinPaths, dbInfo, configBroadcastInterface, configNode, localConfig, clusterId, consistencyCheckUrgentMode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18295874337252228096UL, 18130278596491120640UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerServerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WorkerServerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorSingleCallback< WorkerServerActor, 2, UpdateServerDBInfoRequest >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WorkerServerActor, 27, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WorkerServerActor, 28, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< WorkerServerActor, 29, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< WorkerServerActor, 30, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< WorkerServerActor, 31, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> workerServer( Reference<IClusterConnectionRecord> const& connRecord, Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, LocalityData const& locality, Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo, ProcessClass const& initialClass, std::string const& folder, int64_t const& memoryLimit, std::string const& metricsConnFile, std::string const& metricsPrefix, int64_t const& memoryProfileThreshold, std::string const& _coordFolder, std::string const& whitelistBinPaths, Reference<AsyncVar<ServerDBInfo>> const& dbInfo, ConfigBroadcastInterface const& configBroadcastInterface, Reference<ConfigNode> const& configNode, Reference<LocalConfiguration> const& localConfig, Reference<AsyncVar<Optional<UID>>> const& clusterId, bool const& consistencyCheckUrgentMode ) {
															#line 2175 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new WorkerServerActor(connRecord, ccInterface, locality, asyncPriorityInfo, initialClass, folder, memoryLimit, metricsConnFile, metricsPrefix, memoryProfileThreshold, _coordFolder, whitelistBinPaths, dbInfo, configBroadcastInterface, configNode, localConfig, clusterId, consistencyCheckUrgentMode));
															#line 17101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 3289 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

															#line 17106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via extractClusterInterface()
															#line 3290 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class ExtractClusterInterfaceActor>
															#line 3290 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class ExtractClusterInterfaceActorState {
															#line 17113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 3290 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ExtractClusterInterfaceActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& in,Reference<AsyncVar<Optional<ClusterInterface>>> const& out) 
															#line 3290 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 3290 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : in(in),
															#line 3290 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   out(out)
															#line 17122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("extractClusterInterface", reinterpret_cast<unsigned long>(this));

	}
	~ExtractClusterInterfaceActorState() 
	{
		fdb_probe_actor_destroy("extractClusterInterface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3292 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 17137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExtractClusterInterfaceActorState();
		static_cast<ExtractClusterInterfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3293 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (in->get().present())
															#line 17167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3294 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			out->set(in->get().get().clientInterface);
															#line 17171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3296 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			out->set(Optional<ClusterInterface>());
															#line 17177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 3298 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = in->onChange();
															#line 3298 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<ExtractClusterInterfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ExtractClusterInterfaceActor*>(this)->actor_wait_state = 1;
															#line 3298 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExtractClusterInterfaceActor, 0, Void >*>(static_cast<ExtractClusterInterfaceActor*>(this)));
															#line 17188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExtractClusterInterfaceActor*>(this)->actor_wait_state > 0) static_cast<ExtractClusterInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<ExtractClusterInterfaceActor*>(this)->ActorCallback< ExtractClusterInterfaceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExtractClusterInterfaceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClusterInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExtractClusterInterfaceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClusterInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExtractClusterInterfaceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClusterInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClusterInterface", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3290 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> in;
															#line 3290 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterInterface>>> out;
															#line 17284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via extractClusterInterface()
															#line 3290 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class ExtractClusterInterfaceActor final : public Actor<Void>, public ActorCallback< ExtractClusterInterfaceActor, 0, Void >, public FastAllocated<ExtractClusterInterfaceActor>, public ExtractClusterInterfaceActorState<ExtractClusterInterfaceActor> {
															#line 17289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<ExtractClusterInterfaceActor>::operator new;
	using FastAllocated<ExtractClusterInterfaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3756235310818958080UL, 16879025948277966336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExtractClusterInterfaceActor, 0, Void >;
															#line 3290 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ExtractClusterInterfaceActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& in,Reference<AsyncVar<Optional<ClusterInterface>>> const& out) 
															#line 17306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   ExtractClusterInterfaceActorState<ExtractClusterInterfaceActor>(in, out),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("extractClusterInterface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(557938279338987264UL, 16164323909019904512UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClusterInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("extractClusterInterface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("extractClusterInterface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExtractClusterInterfaceActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3290 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> extractClusterInterface( Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& in, Reference<AsyncVar<Optional<ClusterInterface>>> const& out ) {
															#line 3290 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ExtractClusterInterfaceActor(in, out));
															#line 17339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 3301 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

static std::set<int> const& normalWorkerErrors() {
	static std::set<int> s;
	if (s.empty()) {
		s.insert(error_code_please_reboot);
		s.insert(error_code_please_reboot_delete);
		s.insert(error_code_local_config_changed);
		s.insert(error_code_invalid_cluster_id);
	}
	return s;
}

															#line 17355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via printTimeout()
															#line 3313 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class PrintTimeoutActor>
															#line 3313 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class PrintTimeoutActorState {
															#line 17362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 3313 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	PrintTimeoutActorState() 
															#line 3313 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	{
															#line 17368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		fdb_probe_actor_create("printTimeout", reinterpret_cast<unsigned long>(this));

	}
	~PrintTimeoutActorState() 
	{
		fdb_probe_actor_destroy("printTimeout", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3314 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(5);
															#line 3314 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<PrintTimeoutActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintTimeoutActor*>(this)->actor_wait_state = 1;
															#line 3314 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintTimeoutActor, 0, Void >*>(static_cast<PrintTimeoutActor*>(this)));
															#line 17389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintTimeoutActorState();
		static_cast<PrintTimeoutActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 3315 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!g_network->isSimulated())
															#line 17412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3316 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			fprintf(stderr, "Warning: FDBD has not joined the cluster after 5 seconds.\n");
															#line 3317 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			fprintf(stderr, "  Check configuration and availability using the 'status' command with the fdbcli\n");
															#line 17418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 3319 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<PrintTimeoutActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintTimeoutActorState(); static_cast<PrintTimeoutActor*>(this)->destroy(); return 0; }
															#line 17422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<PrintTimeoutActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintTimeoutActorState();
		static_cast<PrintTimeoutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 3315 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!g_network->isSimulated())
															#line 17434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3316 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			fprintf(stderr, "Warning: FDBD has not joined the cluster after 5 seconds.\n");
															#line 3317 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			fprintf(stderr, "  Check configuration and availability using the 'status' command with the fdbcli\n");
															#line 17440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 3319 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<PrintTimeoutActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintTimeoutActorState(); static_cast<PrintTimeoutActor*>(this)->destroy(); return 0; }
															#line 17444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<PrintTimeoutActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintTimeoutActorState();
		static_cast<PrintTimeoutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintTimeoutActor*>(this)->actor_wait_state > 0) static_cast<PrintTimeoutActor*>(this)->actor_wait_state = 0;
		static_cast<PrintTimeoutActor*>(this)->ActorCallback< PrintTimeoutActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintTimeoutActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintTimeoutActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintTimeoutActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
};
// This generated class is to be used only via printTimeout()
															#line 3313 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class PrintTimeoutActor final : public Actor<Void>, public ActorCallback< PrintTimeoutActor, 0, Void >, public FastAllocated<PrintTimeoutActor>, public PrintTimeoutActorState<PrintTimeoutActor> {
															#line 17531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<PrintTimeoutActor>::operator new;
	using FastAllocated<PrintTimeoutActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2264374810287920896UL, 6213372942710972928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintTimeoutActor, 0, Void >;
															#line 3313 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	PrintTimeoutActor() 
															#line 17548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   PrintTimeoutActorState<PrintTimeoutActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printTimeout", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3981782795374445824UL, 6705174968519855616UL);
		ActorExecutionContextHelper __helper(static_cast<PrintTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printTimeout");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printTimeout", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintTimeoutActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3313 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> printTimeout(  ) {
															#line 3313 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new PrintTimeoutActor());
															#line 17581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 3321 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

															#line 17586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via printOnFirstConnected()
															#line 3322 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class PrintOnFirstConnectedActor>
															#line 3322 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class PrintOnFirstConnectedActorState {
															#line 17593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 3322 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	PrintOnFirstConnectedActorState(Reference<AsyncVar<Optional<ClusterInterface>> const> const& ci) 
															#line 3322 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 3322 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : ci(ci),
															#line 3323 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   timeoutFuture(printTimeout())
															#line 17602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("printOnFirstConnected", reinterpret_cast<unsigned long>(this));

	}
	~PrintOnFirstConnectedActorState() 
	{
		fdb_probe_actor_destroy("printOnFirstConnected", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3324 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 17617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintOnFirstConnectedActorState();
		static_cast<PrintOnFirstConnectedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3326 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = ci->get().present() ? IFailureMonitor::failureMonitor().onStateEqual( ci->get().get().openDatabase.getEndpoint(), FailureStatus(false)) : Never();
															#line 3325 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<PrintOnFirstConnectedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 3333 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = ci->onChange();
															#line 17653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<PrintOnFirstConnectedActor*>(this)->actor_wait_state = 1;
															#line 3326 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintOnFirstConnectedActor, 0, Void >*>(static_cast<PrintOnFirstConnectedActor*>(this)));
															#line 3333 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrintOnFirstConnectedActor, 1, Void >*>(static_cast<PrintOnFirstConnectedActor*>(this)));
															#line 17660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 3329 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		printf("FDBD joined cluster.\n");
															#line 3330 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("FDBDConnected").log();
															#line 3331 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<PrintOnFirstConnectedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintOnFirstConnectedActorState(); static_cast<PrintOnFirstConnectedActor*>(this)->destroy(); return 0; }
															#line 17679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<PrintOnFirstConnectedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintOnFirstConnectedActorState();
		static_cast<PrintOnFirstConnectedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 3329 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		printf("FDBD joined cluster.\n");
															#line 3330 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("FDBDConnected").log();
															#line 3331 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<PrintOnFirstConnectedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintOnFirstConnectedActorState(); static_cast<PrintOnFirstConnectedActor*>(this)->destroy(); return 0; }
															#line 17695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<PrintOnFirstConnectedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintOnFirstConnectedActorState();
		static_cast<PrintOnFirstConnectedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintOnFirstConnectedActor*>(this)->actor_wait_state > 0) static_cast<PrintOnFirstConnectedActor*>(this)->actor_wait_state = 0;
		static_cast<PrintOnFirstConnectedActor*>(this)->ActorCallback< PrintOnFirstConnectedActor, 0, Void >::remove();
		static_cast<PrintOnFirstConnectedActor*>(this)->ActorCallback< PrintOnFirstConnectedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintOnFirstConnectedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintOnFirstConnectedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintOnFirstConnectedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintOnFirstConnectedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintOnFirstConnectedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintOnFirstConnectedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintOnFirstConnectedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintOnFirstConnectedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrintOnFirstConnectedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintOnFirstConnectedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrintOnFirstConnectedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintOnFirstConnectedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printOnFirstConnected", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 3322 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterInterface>> const> ci;
															#line 3323 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> timeoutFuture;
															#line 17840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via printOnFirstConnected()
															#line 3322 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class PrintOnFirstConnectedActor final : public Actor<Void>, public ActorCallback< PrintOnFirstConnectedActor, 0, Void >, public ActorCallback< PrintOnFirstConnectedActor, 1, Void >, public FastAllocated<PrintOnFirstConnectedActor>, public PrintOnFirstConnectedActorState<PrintOnFirstConnectedActor> {
															#line 17845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<PrintOnFirstConnectedActor>::operator new;
	using FastAllocated<PrintOnFirstConnectedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11636614083103101184UL, 1155804758840639232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintOnFirstConnectedActor, 0, Void >;
friend struct ActorCallback< PrintOnFirstConnectedActor, 1, Void >;
															#line 3322 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	PrintOnFirstConnectedActor(Reference<AsyncVar<Optional<ClusterInterface>> const> const& ci) 
															#line 17863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   PrintOnFirstConnectedActorState<PrintOnFirstConnectedActor>(ci),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printOnFirstConnected", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7150920790306724352UL, 17823934316399614976UL);
		ActorExecutionContextHelper __helper(static_cast<PrintOnFirstConnectedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printOnFirstConnected");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printOnFirstConnected", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintOnFirstConnectedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3322 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> printOnFirstConnected( Reference<AsyncVar<Optional<ClusterInterface>> const> const& ci ) {
															#line 3322 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new PrintOnFirstConnectedActor(ci));
															#line 17896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 3337 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

ClusterControllerPriorityInfo getCCPriorityInfo(std::string filePath, ProcessClass processClass) {
	if (!fileExists(filePath))
		return ClusterControllerPriorityInfo(ProcessClass(processClass.classType(), ProcessClass::CommandLineSource)
		                                         .machineClassFitness(ProcessClass::ClusterController),
		                                     false,
		                                     ClusterControllerPriorityInfo::FitnessUnknown);
	std::string contents(readFileBytes(filePath, 1000));
	BinaryReader br(StringRef(contents), IncludeVersion());
	ClusterControllerPriorityInfo priorityInfo(
	    ProcessClass::UnsetFit, false, ClusterControllerPriorityInfo::FitnessUnknown);
	br >> priorityInfo;
	if (!br.empty()) {
		if (g_network->isSimulated()) {
			ASSERT(false);
		} else {
			TraceEvent(SevWarnAlways, "FitnessFileCorrupted").detail("filePath", filePath);
			return ClusterControllerPriorityInfo(ProcessClass(processClass.classType(), ProcessClass::CommandLineSource)
			                                         .machineClassFitness(ProcessClass::ClusterController),
			                                     false,
			                                     ClusterControllerPriorityInfo::FitnessUnknown);
		}
	}
	return priorityInfo;
}

															#line 17926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorAndWriteCCPriorityInfo()
															#line 3363 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class MonitorAndWriteCCPriorityInfoActor>
															#line 3363 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class MonitorAndWriteCCPriorityInfoActorState {
															#line 17933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 3363 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	MonitorAndWriteCCPriorityInfoActorState(std::string const& filePath,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo) 
															#line 3363 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 3363 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : filePath(filePath),
															#line 3363 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   asyncPriorityInfo(asyncPriorityInfo)
															#line 17942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorAndWriteCCPriorityInfo", reinterpret_cast<unsigned long>(this));

	}
	~MonitorAndWriteCCPriorityInfoActorState() 
	{
		fdb_probe_actor_destroy("monitorAndWriteCCPriorityInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3365 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 17957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorAndWriteCCPriorityInfoActorState();
		static_cast<MonitorAndWriteCCPriorityInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3366 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = asyncPriorityInfo->onChange();
															#line 3366 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<MonitorAndWriteCCPriorityInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorAndWriteCCPriorityInfoActor*>(this)->actor_wait_state = 1;
															#line 3366 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorAndWriteCCPriorityInfoActor, 0, Void >*>(static_cast<MonitorAndWriteCCPriorityInfoActor*>(this)));
															#line 17994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 3367 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::string contents(BinaryWriter::toValue(asyncPriorityInfo->get(), IncludeVersion(ProtocolVersion::withClusterControllerPriorityInfo())) .toString());
															#line 3370 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		atomicReplace(filePath, contents, false);
															#line 18005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 3367 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		std::string contents(BinaryWriter::toValue(asyncPriorityInfo->get(), IncludeVersion(ProtocolVersion::withClusterControllerPriorityInfo())) .toString());
															#line 3370 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		atomicReplace(filePath, contents, false);
															#line 18016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorAndWriteCCPriorityInfoActor*>(this)->actor_wait_state > 0) static_cast<MonitorAndWriteCCPriorityInfoActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorAndWriteCCPriorityInfoActor*>(this)->ActorCallback< MonitorAndWriteCCPriorityInfoActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorAndWriteCCPriorityInfoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorAndWriteCCPriorityInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndWriteCCPriorityInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndWriteCCPriorityInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorAndWriteCCPriorityInfoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorAndWriteCCPriorityInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndWriteCCPriorityInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndWriteCCPriorityInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorAndWriteCCPriorityInfoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorAndWriteCCPriorityInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndWriteCCPriorityInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorAndWriteCCPriorityInfo", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3363 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string filePath;
															#line 3363 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ClusterControllerPriorityInfo>> asyncPriorityInfo;
															#line 18100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via monitorAndWriteCCPriorityInfo()
															#line 3363 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class MonitorAndWriteCCPriorityInfoActor final : public Actor<Void>, public ActorCallback< MonitorAndWriteCCPriorityInfoActor, 0, Void >, public FastAllocated<MonitorAndWriteCCPriorityInfoActor>, public MonitorAndWriteCCPriorityInfoActorState<MonitorAndWriteCCPriorityInfoActor> {
															#line 18105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<MonitorAndWriteCCPriorityInfoActor>::operator new;
	using FastAllocated<MonitorAndWriteCCPriorityInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15443262962912554752UL, 7941950218628443648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorAndWriteCCPriorityInfoActor, 0, Void >;
															#line 3363 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	MonitorAndWriteCCPriorityInfoActor(std::string const& filePath,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo) 
															#line 18122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorAndWriteCCPriorityInfoActorState<MonitorAndWriteCCPriorityInfoActor>(filePath, asyncPriorityInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorAndWriteCCPriorityInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14655669072570677760UL, 10856169186635442688UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorAndWriteCCPriorityInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorAndWriteCCPriorityInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorAndWriteCCPriorityInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorAndWriteCCPriorityInfoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3363 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> monitorAndWriteCCPriorityInfo( std::string const& filePath, Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo ) {
															#line 3363 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new MonitorAndWriteCCPriorityInfoActor(filePath, asyncPriorityInfo));
															#line 18155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 3373 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

static const std::string versionFileName = "sw-version";

															#line 18162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via testSoftwareVersionCompatibility()
															#line 3376 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class TestSoftwareVersionCompatibilityActor>
															#line 3376 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class TestSoftwareVersionCompatibilityActorState {
															#line 18169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 3376 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	TestSoftwareVersionCompatibilityActorState(std::string const& folder,ProtocolVersion const& currentVersion) 
															#line 3376 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 3376 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : folder(folder),
															#line 3376 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   currentVersion(currentVersion)
															#line 18178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this));

	}
	~TestSoftwareVersionCompatibilityActorState() 
	{
		fdb_probe_actor_destroy("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 3378 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				versionFilePath = joinPath(folder, versionFileName);
															#line 3379 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<ErrorOr<Reference<IAsyncFile>>> __when_expr_0 = errorOr(IAsyncFileSystem::filesystem(g_network)->open(versionFilePath, IAsyncFile::OPEN_READONLY, 0600));
															#line 3379 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<TestSoftwareVersionCompatibilityActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 18198 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TestSoftwareVersionCompatibilityActor*>(this)->actor_wait_state = 1;
															#line 3379 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestSoftwareVersionCompatibilityActor, 0, ErrorOr<Reference<IAsyncFile>> >*>(static_cast<TestSoftwareVersionCompatibilityActor*>(this)));
															#line 18203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestSoftwareVersionCompatibilityActorState();
		static_cast<TestSoftwareVersionCompatibilityActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3416 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 18233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 3417 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 18237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
															#line 3420 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarnAlways, "OpenReadSWVersionFileError").error(e);
															#line 3421 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 18243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 3382 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (versionFile.isError())
															#line 18257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3383 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (versionFile.getError().code() == error_code_file_not_found && !fileExists(versionFilePath))
															#line 18261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 3387 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent(SevInfo, "NoPreviousSWVersion").log();
															#line 3388 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<TestSoftwareVersionCompatibilityActor*>(this)->SAV<SWVersion>::futures) { (void)(SWVersion()); this->~TestSoftwareVersionCompatibilityActorState(); static_cast<TestSoftwareVersionCompatibilityActor*>(this)->destroy(); return 0; }
															#line 18267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				new (&static_cast<TestSoftwareVersionCompatibilityActor*>(this)->SAV< SWVersion >::value()) SWVersion(SWVersion());
				this->~TestSoftwareVersionCompatibilityActorState();
				static_cast<TestSoftwareVersionCompatibilityActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 3391 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch2(versionFile.getError(), loopDepth);
															#line 18277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
		}
		else
		{
															#line 3396 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<int64_t> __when_expr_1 = versionFile.get()->size();
															#line 3396 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<TestSoftwareVersionCompatibilityActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 18286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestSoftwareVersionCompatibilityActor*>(this)->actor_wait_state = 2;
															#line 3396 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestSoftwareVersionCompatibilityActor, 1, int64_t >*>(static_cast<TestSoftwareVersionCompatibilityActor*>(this)));
															#line 18291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(ErrorOr<Reference<IAsyncFile>> const& __versionFile,int loopDepth) 
	{
															#line 3379 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		versionFile = __versionFile;
															#line 18301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<Reference<IAsyncFile>> && __versionFile,int loopDepth) 
	{
		versionFile = std::move(__versionFile);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestSoftwareVersionCompatibilityActor*>(this)->actor_wait_state > 0) static_cast<TestSoftwareVersionCompatibilityActor*>(this)->actor_wait_state = 0;
		static_cast<TestSoftwareVersionCompatibilityActor*>(this)->ActorCallback< TestSoftwareVersionCompatibilityActor, 0, ErrorOr<Reference<IAsyncFile>> >::remove();

	}
	void a_callback_fire(ActorCallback< TestSoftwareVersionCompatibilityActor, 0, ErrorOr<Reference<IAsyncFile>> >*,ErrorOr<Reference<IAsyncFile>> const& value) 
	{
		fdb_probe_actor_enter("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestSoftwareVersionCompatibilityActor, 0, ErrorOr<Reference<IAsyncFile>> >*,ErrorOr<Reference<IAsyncFile>> && value) 
	{
		fdb_probe_actor_enter("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestSoftwareVersionCompatibilityActor, 0, ErrorOr<Reference<IAsyncFile>> >*,Error err) 
	{
		fdb_probe_actor_enter("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 3397 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		buf = makeString(filesize);
															#line 3398 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<int> __when_expr_2 = versionFile.get()->read(mutateString(buf), filesize, 0);
															#line 3398 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<TestSoftwareVersionCompatibilityActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 18384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont7when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestSoftwareVersionCompatibilityActor*>(this)->actor_wait_state = 3;
															#line 3398 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestSoftwareVersionCompatibilityActor, 2, int >*>(static_cast<TestSoftwareVersionCompatibilityActor*>(this)));
															#line 18389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(int64_t const& __filesize,int loopDepth) 
	{
															#line 3396 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		filesize = __filesize;
															#line 18398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t && __filesize,int loopDepth) 
	{
		filesize = std::move(__filesize);
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestSoftwareVersionCompatibilityActor*>(this)->actor_wait_state > 0) static_cast<TestSoftwareVersionCompatibilityActor*>(this)->actor_wait_state = 0;
		static_cast<TestSoftwareVersionCompatibilityActor*>(this)->ActorCallback< TestSoftwareVersionCompatibilityActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< TestSoftwareVersionCompatibilityActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestSoftwareVersionCompatibilityActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestSoftwareVersionCompatibilityActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int const& readLen,int loopDepth) 
	{
															#line 3399 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (filesize == 0 || readLen != filesize)
															#line 18477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3400 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch2(file_corrupt(), loopDepth);
															#line 18481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		try {
															#line 3404 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			SWVersion swversion = ObjectReader::fromStringRef<SWVersion>(buf, IncludeVersion());
															#line 3405 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ProtocolVersion lowestCompatibleVersion(swversion.lowestCompatibleProtocolVersion());
															#line 3406 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (currentVersion >= lowestCompatibleVersion)
															#line 18490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 3407 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<TestSoftwareVersionCompatibilityActor*>(this)->SAV<SWVersion>::futures) { (void)(swversion); this->~TestSoftwareVersionCompatibilityActorState(); static_cast<TestSoftwareVersionCompatibilityActor*>(this)->destroy(); return 0; }
															#line 18494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				new (&static_cast<TestSoftwareVersionCompatibilityActor*>(this)->SAV< SWVersion >::value()) SWVersion(swversion);
				this->~TestSoftwareVersionCompatibilityActorState();
				static_cast<TestSoftwareVersionCompatibilityActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 3409 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1cont8Catch1(incompatible_software_version(), loopDepth);
															#line 18504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont8Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(int && readLen,int loopDepth) 
	{
															#line 3399 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (filesize == 0 || readLen != filesize)
															#line 18519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3400 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch2(file_corrupt(), loopDepth);
															#line 18523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		try {
															#line 3404 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			SWVersion swversion = ObjectReader::fromStringRef<SWVersion>(buf, IncludeVersion());
															#line 3405 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ProtocolVersion lowestCompatibleVersion(swversion.lowestCompatibleProtocolVersion());
															#line 3406 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (currentVersion >= lowestCompatibleVersion)
															#line 18532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 3407 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<TestSoftwareVersionCompatibilityActor*>(this)->SAV<SWVersion>::futures) { (void)(swversion); this->~TestSoftwareVersionCompatibilityActorState(); static_cast<TestSoftwareVersionCompatibilityActor*>(this)->destroy(); return 0; }
															#line 18536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				new (&static_cast<TestSoftwareVersionCompatibilityActor*>(this)->SAV< SWVersion >::value()) SWVersion(swversion);
				this->~TestSoftwareVersionCompatibilityActorState();
				static_cast<TestSoftwareVersionCompatibilityActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 3409 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1cont8Catch1(incompatible_software_version(), loopDepth);
															#line 18546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont8Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7when1(int const& readLen,int loopDepth) 
	{
		loopDepth = a_body1cont8(readLen, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(int && readLen,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(readLen), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestSoftwareVersionCompatibilityActor*>(this)->actor_wait_state > 0) static_cast<TestSoftwareVersionCompatibilityActor*>(this)->actor_wait_state = 0;
		static_cast<TestSoftwareVersionCompatibilityActor*>(this)->ActorCallback< TestSoftwareVersionCompatibilityActor, 2, int >::remove();

	}
	void a_callback_fire(ActorCallback< TestSoftwareVersionCompatibilityActor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestSoftwareVersionCompatibilityActor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestSoftwareVersionCompatibilityActor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3412 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch2(e, loopDepth);
															#line 18637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 3376 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 3376 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ProtocolVersion currentVersion;
															#line 3378 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string versionFilePath;
															#line 3379 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ErrorOr<Reference<IAsyncFile>> versionFile;
															#line 3396 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	int64_t filesize;
															#line 3397 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Standalone<StringRef> buf;
															#line 18659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via testSoftwareVersionCompatibility()
															#line 3376 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class TestSoftwareVersionCompatibilityActor final : public Actor<SWVersion>, public ActorCallback< TestSoftwareVersionCompatibilityActor, 0, ErrorOr<Reference<IAsyncFile>> >, public ActorCallback< TestSoftwareVersionCompatibilityActor, 1, int64_t >, public ActorCallback< TestSoftwareVersionCompatibilityActor, 2, int >, public FastAllocated<TestSoftwareVersionCompatibilityActor>, public TestSoftwareVersionCompatibilityActorState<TestSoftwareVersionCompatibilityActor> {
															#line 18664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<TestSoftwareVersionCompatibilityActor>::operator new;
	using FastAllocated<TestSoftwareVersionCompatibilityActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17722129272927708928UL, 8220229071790847744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<SWVersion>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestSoftwareVersionCompatibilityActor, 0, ErrorOr<Reference<IAsyncFile>> >;
friend struct ActorCallback< TestSoftwareVersionCompatibilityActor, 1, int64_t >;
friend struct ActorCallback< TestSoftwareVersionCompatibilityActor, 2, int >;
															#line 3376 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	TestSoftwareVersionCompatibilityActor(std::string const& folder,ProtocolVersion const& currentVersion) 
															#line 18683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<SWVersion>(),
		   TestSoftwareVersionCompatibilityActorState<TestSoftwareVersionCompatibilityActor>(folder, currentVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12561302854009297664UL, 3913746750725126400UL);
		ActorExecutionContextHelper __helper(static_cast<TestSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testSoftwareVersionCompatibility");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestSoftwareVersionCompatibilityActor, 0, ErrorOr<Reference<IAsyncFile>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestSoftwareVersionCompatibilityActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestSoftwareVersionCompatibilityActor, 2, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3376 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<SWVersion> testSoftwareVersionCompatibility( std::string const& folder, ProtocolVersion const& currentVersion ) {
															#line 3376 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<SWVersion>(new TestSoftwareVersionCompatibilityActor(folder, currentVersion));
															#line 18718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 3424 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

															#line 18723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via updateNewestSoftwareVersion()
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class UpdateNewestSoftwareVersionActor>
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class UpdateNewestSoftwareVersionActorState {
															#line 18730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UpdateNewestSoftwareVersionActorState(std::string const& folder,ProtocolVersion const& currentVersion,ProtocolVersion const& latestVersion,ProtocolVersion const& minCompatibleVersion) 
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : folder(folder),
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   currentVersion(currentVersion),
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   latestVersion(latestVersion),
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   minCompatibleVersion(minCompatibleVersion)
															#line 18743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this));

	}
	~UpdateNewestSoftwareVersionActorState() 
	{
		fdb_probe_actor_destroy("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3430 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(currentVersion >= minCompatibleVersion);
															#line 18758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			try {
															#line 3433 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				versionFilePath = joinPath(folder, versionFileName);
															#line 3434 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<ErrorOr<Reference<IAsyncFile>>> __when_expr_0 = errorOr(IAsyncFileSystem::filesystem(g_network)->open(versionFilePath, IAsyncFile::OPEN_READONLY, 0600));
															#line 3434 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 18766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state = 1;
															#line 3434 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateNewestSoftwareVersionActor, 0, ErrorOr<Reference<IAsyncFile>> >*>(static_cast<UpdateNewestSoftwareVersionActor*>(this)));
															#line 18771 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateNewestSoftwareVersionActorState();
		static_cast<UpdateNewestSoftwareVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3462 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<UpdateNewestSoftwareVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateNewestSoftwareVersionActorState(); static_cast<UpdateNewestSoftwareVersionActor*>(this)->destroy(); return 0; }
															#line 18800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		new (&static_cast<UpdateNewestSoftwareVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateNewestSoftwareVersionActorState();
		static_cast<UpdateNewestSoftwareVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3455 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 18813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 3456 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 18817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			}
															#line 3458 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarnAlways, "OpenWriteSWVersionFileError").error(e);
															#line 3459 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 18823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(ErrorOr<Reference<IAsyncFile>> const& versionFile,int loopDepth) 
	{
															#line 3437 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (versionFile.isError() && (versionFile.getError().code() != error_code_file_not_found || fileExists(versionFilePath)))
															#line 18837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3439 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch2(versionFile.getError(), loopDepth);
															#line 18841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 3442 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_1 = IAsyncFileSystem::filesystem()->open( versionFilePath, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0600);
															#line 3442 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 18847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state = 2;
															#line 3442 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateNewestSoftwareVersionActor, 1, Reference<IAsyncFile> >*>(static_cast<UpdateNewestSoftwareVersionActor*>(this)));
															#line 18852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(ErrorOr<Reference<IAsyncFile>> && versionFile,int loopDepth) 
	{
															#line 3437 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (versionFile.isError() && (versionFile.getError().code() != error_code_file_not_found || fileExists(versionFilePath)))
															#line 18861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3439 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch2(versionFile.getError(), loopDepth);
															#line 18865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 3442 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_1 = IAsyncFileSystem::filesystem()->open( versionFilePath, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0600);
															#line 3442 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 18871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state = 2;
															#line 3442 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateNewestSoftwareVersionActor, 1, Reference<IAsyncFile> >*>(static_cast<UpdateNewestSoftwareVersionActor*>(this)));
															#line 18876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<Reference<IAsyncFile>> const& versionFile,int loopDepth) 
	{
		loopDepth = a_body1cont2(versionFile, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<Reference<IAsyncFile>> && versionFile,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(versionFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state > 0) static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateNewestSoftwareVersionActor*>(this)->ActorCallback< UpdateNewestSoftwareVersionActor, 0, ErrorOr<Reference<IAsyncFile>> >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateNewestSoftwareVersionActor, 0, ErrorOr<Reference<IAsyncFile>> >*,ErrorOr<Reference<IAsyncFile>> const& value) 
	{
		fdb_probe_actor_enter("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNewestSoftwareVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateNewestSoftwareVersionActor, 0, ErrorOr<Reference<IAsyncFile>> >*,ErrorOr<Reference<IAsyncFile>> && value) 
	{
		fdb_probe_actor_enter("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNewestSoftwareVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateNewestSoftwareVersionActor, 0, ErrorOr<Reference<IAsyncFile>> >*,Error err) 
	{
		fdb_probe_actor_enter("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNewestSoftwareVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 3447 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		SWVersion swVersion(latestVersion, currentVersion, minCompatibleVersion);
															#line 3448 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		Value s = swVersionValue(swVersion);
															#line 3449 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<ErrorOr<Void>> __when_expr_2 = holdWhile(s, errorOr(newVersionFile->write(s.begin(), s.size(), 0)));
															#line 3449 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 18966 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state = 3;
															#line 3449 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateNewestSoftwareVersionActor, 2, ErrorOr<Void> >*>(static_cast<UpdateNewestSoftwareVersionActor*>(this)));
															#line 18971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Reference<IAsyncFile> const& __newVersionFile,int loopDepth) 
	{
															#line 3442 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		newVersionFile = __newVersionFile;
															#line 18980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Reference<IAsyncFile> && __newVersionFile,int loopDepth) 
	{
		newVersionFile = std::move(__newVersionFile);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state > 0) static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateNewestSoftwareVersionActor*>(this)->ActorCallback< UpdateNewestSoftwareVersionActor, 1, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateNewestSoftwareVersionActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNewestSoftwareVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateNewestSoftwareVersionActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNewestSoftwareVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateNewestSoftwareVersionActor, 1, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNewestSoftwareVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(ErrorOr<Void> const& e,int loopDepth) 
	{
															#line 3450 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError())
															#line 19059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3451 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch2(e.getError(), loopDepth);
															#line 19063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 3453 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = newVersionFile->sync();
															#line 3453 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 19069 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state = 4;
															#line 3453 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateNewestSoftwareVersionActor, 3, Void >*>(static_cast<UpdateNewestSoftwareVersionActor*>(this)));
															#line 19074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(ErrorOr<Void> && e,int loopDepth) 
	{
															#line 3450 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError())
															#line 19083 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3451 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch2(e.getError(), loopDepth);
															#line 19087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 3453 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = newVersionFile->sync();
															#line 3453 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 19093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state = 4;
															#line 3453 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateNewestSoftwareVersionActor, 3, Void >*>(static_cast<UpdateNewestSoftwareVersionActor*>(this)));
															#line 19098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(ErrorOr<Void> const& e,int loopDepth) 
	{
		loopDepth = a_body1cont5(e, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(ErrorOr<Void> && e,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(e), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state > 0) static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateNewestSoftwareVersionActor*>(this)->ActorCallback< UpdateNewestSoftwareVersionActor, 2, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateNewestSoftwareVersionActor, 2, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNewestSoftwareVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateNewestSoftwareVersionActor, 2, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNewestSoftwareVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateNewestSoftwareVersionActor, 2, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNewestSoftwareVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state > 0) static_cast<UpdateNewestSoftwareVersionActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateNewestSoftwareVersionActor*>(this)->ActorCallback< UpdateNewestSoftwareVersionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateNewestSoftwareVersionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNewestSoftwareVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UpdateNewestSoftwareVersionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNewestSoftwareVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UpdateNewestSoftwareVersionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNewestSoftwareVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ProtocolVersion currentVersion;
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ProtocolVersion latestVersion;
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	ProtocolVersion minCompatibleVersion;
															#line 3433 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	std::string versionFilePath;
															#line 3442 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	Reference<IAsyncFile> newVersionFile;
															#line 19290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via updateNewestSoftwareVersion()
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class UpdateNewestSoftwareVersionActor final : public Actor<Void>, public ActorCallback< UpdateNewestSoftwareVersionActor, 0, ErrorOr<Reference<IAsyncFile>> >, public ActorCallback< UpdateNewestSoftwareVersionActor, 1, Reference<IAsyncFile> >, public ActorCallback< UpdateNewestSoftwareVersionActor, 2, ErrorOr<Void> >, public ActorCallback< UpdateNewestSoftwareVersionActor, 3, Void >, public FastAllocated<UpdateNewestSoftwareVersionActor>, public UpdateNewestSoftwareVersionActorState<UpdateNewestSoftwareVersionActor> {
															#line 19295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<UpdateNewestSoftwareVersionActor>::operator new;
	using FastAllocated<UpdateNewestSoftwareVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3199910316974669312UL, 7081675223381515520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateNewestSoftwareVersionActor, 0, ErrorOr<Reference<IAsyncFile>> >;
friend struct ActorCallback< UpdateNewestSoftwareVersionActor, 1, Reference<IAsyncFile> >;
friend struct ActorCallback< UpdateNewestSoftwareVersionActor, 2, ErrorOr<Void> >;
friend struct ActorCallback< UpdateNewestSoftwareVersionActor, 3, Void >;
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	UpdateNewestSoftwareVersionActor(std::string const& folder,ProtocolVersion const& currentVersion,ProtocolVersion const& latestVersion,ProtocolVersion const& minCompatibleVersion) 
															#line 19315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateNewestSoftwareVersionActorState<UpdateNewestSoftwareVersionActor>(folder, currentVersion, latestVersion, minCompatibleVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(932286809752801792UL, 6840480129281348352UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateNewestSoftwareVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateNewestSoftwareVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateNewestSoftwareVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateNewestSoftwareVersionActor, 0, ErrorOr<Reference<IAsyncFile>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateNewestSoftwareVersionActor, 1, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateNewestSoftwareVersionActor, 2, ErrorOr<Void> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UpdateNewestSoftwareVersionActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> updateNewestSoftwareVersion( std::string const& folder, ProtocolVersion const& currentVersion, ProtocolVersion const& latestVersion, ProtocolVersion const& minCompatibleVersion ) {
															#line 3425 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new UpdateNewestSoftwareVersionActor(folder, currentVersion, latestVersion, minCompatibleVersion));
															#line 19351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
}

#line 3464 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"

															#line 19356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via testAndUpdateSoftwareVersionCompatibility()
															#line 3465 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
template <class TestAndUpdateSoftwareVersionCompatibilityActor>
															#line 3465 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
class TestAndUpdateSoftwareVersionCompatibilityActorState {
															#line 19363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
public:
															#line 3465 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
	TestAndUpdateSoftwareVersionCompatibilityActorState(std::string const& dataFolder,UID const& processIDUid) 
															#line 3465 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
															#line 3465 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		 : dataFolder(dataFolder),
															#line 3465 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		   processIDUid(processIDUid)
															#line 19372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this));

	}
	~TestAndUpdateSoftwareVersionCompatibilityActorState() 
	{
		fdb_probe_actor_destroy("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3466 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<SWVersion>> __when_expr_0 = errorOr(testSoftwareVersionCompatibility(dataFolder, currentProtocolVersion()));
															#line 3466 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state = 1;
															#line 3466 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 0, ErrorOr<SWVersion> >*>(static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)));
															#line 19394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAndUpdateSoftwareVersionCompatibilityActorState();
		static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<SWVersion> const& swVersion,int loopDepth) 
	{
															#line 3468 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (swVersion.isError())
															#line 19417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3469 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarnAlways, "SWVersionCompatibilityCheckError", processIDUid).error(swVersion.getError());
															#line 3470 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(swVersion.getError(), loopDepth);
															#line 19423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 3473 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent(SevInfo, "SWVersionCompatible", processIDUid).detail("SWVersion", swVersion.get());
															#line 3475 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!swVersion.get().isValid() || currentProtocolVersion() > ProtocolVersion(swVersion.get().newestProtocolVersion()))
															#line 19429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3477 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<Void>> __when_expr_1 = errorOr(updateNewestSoftwareVersion( dataFolder, currentProtocolVersion(), currentProtocolVersion(), minCompatibleProtocolVersion));
															#line 3477 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state = 2;
															#line 3477 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 1, ErrorOr<Void> >*>(static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)));
															#line 19440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 3482 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (currentProtocolVersion() < ProtocolVersion(swVersion.get().newestProtocolVersion()))
															#line 19447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 3483 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<ErrorOr<Void>> __when_expr_2 = errorOr(updateNewestSoftwareVersion(dataFolder, currentProtocolVersion(), ProtocolVersion(swVersion.get().newestProtocolVersion()), ProtocolVersion(swVersion.get().lowestCompatibleProtocolVersion())));
															#line 3483 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
				static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state = 3;
															#line 3483 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 2, ErrorOr<Void> >*>(static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)));
															#line 19458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont7(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<SWVersion> && swVersion,int loopDepth) 
	{
															#line 3468 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (swVersion.isError())
															#line 19473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3469 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarnAlways, "SWVersionCompatibilityCheckError", processIDUid).error(swVersion.getError());
															#line 3470 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(swVersion.getError(), loopDepth);
															#line 19479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 3473 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent(SevInfo, "SWVersionCompatible", processIDUid).detail("SWVersion", swVersion.get());
															#line 3475 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (!swVersion.get().isValid() || currentProtocolVersion() > ProtocolVersion(swVersion.get().newestProtocolVersion()))
															#line 19485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3477 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<Void>> __when_expr_1 = errorOr(updateNewestSoftwareVersion( dataFolder, currentProtocolVersion(), currentProtocolVersion(), minCompatibleProtocolVersion));
															#line 3477 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state = 2;
															#line 3477 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 1, ErrorOr<Void> >*>(static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)));
															#line 19496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 3482 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			if (currentProtocolVersion() < ProtocolVersion(swVersion.get().newestProtocolVersion()))
															#line 19503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
			{
															#line 3483 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<ErrorOr<Void>> __when_expr_2 = errorOr(updateNewestSoftwareVersion(dataFolder, currentProtocolVersion(), ProtocolVersion(swVersion.get().newestProtocolVersion()), ProtocolVersion(swVersion.get().lowestCompatibleProtocolVersion())));
															#line 3483 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
				static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state = 3;
															#line 3483 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 2, ErrorOr<Void> >*>(static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)));
															#line 19514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont7(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1when1(ErrorOr<SWVersion> const& swVersion,int loopDepth) 
	{
		loopDepth = a_body1cont1(swVersion, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<SWVersion> && swVersion,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(swVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state > 0) static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state = 0;
		static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 0, ErrorOr<SWVersion> >::remove();

	}
	void a_callback_fire(ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 0, ErrorOr<SWVersion> >*,ErrorOr<SWVersion> const& value) 
	{
		fdb_probe_actor_enter("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 0, ErrorOr<SWVersion> >*,ErrorOr<SWVersion> && value) 
	{
		fdb_probe_actor_enter("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 0, ErrorOr<SWVersion> >*,Error err) 
	{
		fdb_probe_actor_enter("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 3493 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<ErrorOr<SWVersion>> __when_expr_3 = errorOr(testSoftwareVersionCompatibility(dataFolder, currentProtocolVersion()));
															#line 3493 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state = 4;
															#line 3493 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 3, ErrorOr<SWVersion> >*>(static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)));
															#line 19611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(ErrorOr<Void> const& updatedSWVersion,int loopDepth) 
	{
															#line 3479 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (updatedSWVersion.isError())
															#line 19620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3480 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(updatedSWVersion.getError(), loopDepth);
															#line 19624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(ErrorOr<Void> && updatedSWVersion,int loopDepth) 
	{
															#line 3479 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (updatedSWVersion.isError())
															#line 19634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3480 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(updatedSWVersion.getError(), loopDepth);
															#line 19638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(ErrorOr<Void> const& updatedSWVersion,int loopDepth) 
	{
		loopDepth = a_body1cont4(updatedSWVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(ErrorOr<Void> && updatedSWVersion,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(updatedSWVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state > 0) static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state = 0;
		static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 1, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 1, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 1, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 1, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(ErrorOr<Void> const& updatedSWVersion,int loopDepth) 
	{
															#line 3488 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (updatedSWVersion.isError())
															#line 19729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3489 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(updatedSWVersion.getError(), loopDepth);
															#line 19733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(ErrorOr<Void> && updatedSWVersion,int loopDepth) 
	{
															#line 3488 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (updatedSWVersion.isError())
															#line 19743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3489 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(updatedSWVersion.getError(), loopDepth);
															#line 19747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(ErrorOr<Void> const& updatedSWVersion,int loopDepth) 
	{
		loopDepth = a_body1cont8(updatedSWVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(ErrorOr<Void> && updatedSWVersion,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(updatedSWVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state > 0) static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->actor_wait_state = 0;
		static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 2, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 2, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 2, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAndUpdateSoftwareVersionCompatibilityActor, 2, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAndUpdateSoftwareVersionCompatibilityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAndUpdateSoftwareVersionCompatibility", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(ErrorOr<SWVersion> const& newSWVersion,int loopDepth) 
	{
															#line 3495 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
		if (newSWVersion.isError())
															#line 19832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		{
															#line 3496 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarnAlways, "SWVersionCompatibilityCheckError", processIDUid).error(newSWVersion.getError());
															#line 3497 "/Users/ec2-user/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(newSWVersion.getError(), loopDepth);
															#line 19838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/worker.actor.g.cpp"
		}
															#line 3500 "/Users/ec