#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
/*
 * SimEncryptKmsProxy.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BlobCipher.h"
#include "fdbclient/BlobMetadataUtils.h"
#include "fdbclient/SimKmsVault.h"

#include "fdbrpc/sim_validation.h"
#include "fdbrpc/simulator.h"

#include "fdbserver/KmsConnectorInterface.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/SimKmsConnector.h"

#include "flow/ActorCollection.h"
#include "flow/Arena.h"
#include "flow/CodeProbe.h"
#include "flow/EncryptUtils.h"
#include "flow/Error.h"
#include "flow/FastRef.h"
#include "flow/IRandom.h"
#include "flow/ITrace.h"
#include "flow/Knobs.h"
#include "flow/Trace.h"
#include "flow/flow.h"
#include "flow/network.h"
#include "flow/UnitTest.h"

#include "fmt/format.h"

#include <cstring>
#include <limits>
#include <memory>
#include <unordered_map>
#include <utility>

#include "flow/actorcompiler.h" // This must be the last #include.

#define DEBUG_SIM_KEY_CIPHER DEBUG_ENCRYPT_KEY_CIPHER

namespace {
Optional<int64_t> getRefreshInterval(const int64_t now, const int64_t defaultTtl) {
	if (BUGGIFY) {
		return Optional<int64_t>(now);
	}
	return Optional<int64_t>(now + defaultTtl);
}

Optional<int64_t> getExpireInterval(Optional<int64_t> refTS, const int64_t defaultTtl) {
	ASSERT(refTS.present());

	if (BUGGIFY) {
		return Optional<int64_t>(-1);
	}
	return (refTS.get() + defaultTtl);
}
} // namespace

															#line 78 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
namespace {
// This generated class is to be used only via ekLookupByIds()
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
template <class EkLookupByIdsActor>
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
class EkLookupByIdsActorState {
															#line 85 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
public:
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	EkLookupByIdsActorState(KmsConnectorInterface const& interf,KmsConnLookupEKsByKeyIdsReq const& req) 
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		 : interf(interf),
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		   req(req),
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		   rep(),
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		   success(true),
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		   dbgKIdTrace(req.debugId.present() ? TraceEvent("SimKmsGetByKeyIds", interf.id()) : Optional<TraceEvent>())
															#line 100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
	{
		fdb_probe_actor_create("ekLookupByIds", reinterpret_cast<unsigned long>(this));

	}
	~EkLookupByIdsActorState() 
	{
		fdb_probe_actor_destroy("ekLookupByIds", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			if (dbgKIdTrace.present())
															#line 115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			{
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				dbgKIdTrace.get().setMaxEventLength(100000);
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				dbgKIdTrace.get().detail("DbgId", req.debugId.get());
															#line 121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			}
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			const int64_t currTS = (int64_t)now();
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			const int64_t defaultTtl = FLOW_KNOBS->ENCRYPT_CIPHER_KEY_CACHE_TTL;
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			Optional<int64_t> refAtTS = getRefreshInterval(currTS, defaultTtl);
															#line 92 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			Optional<int64_t> expAtTS = getExpireInterval(refAtTS, defaultTtl);
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			TraceEvent("SimKmsEKLookupById").detail("RefreshAt", refAtTS).detail("ExpireAt", expAtTS);
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			for( const auto& item : req.encryptKeyInfos ) {
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				Reference<SimKmsVaultKeyCtx> keyCtx = SimKmsVault::getByBaseCipherId(item.baseCipherId);
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				if (keyCtx.isValid())
															#line 139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
				{
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
					ASSERT(item.domainId.present());
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
					rep.cipherKeyDetails.emplace_back_deep( rep.arena, item.domainId.get(), keyCtx->id, keyCtx->key, keyCtx->kcv, refAtTS, expAtTS);
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
					if (dbgKIdTrace.present())
															#line 147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
					{
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
						dbgKIdTrace.get().detail( getEncryptDbgTraceKey(ENCRYPT_DBG_TRACE_RESULT_PREFIX, item.domainId.get(), keyCtx->id), "");
															#line 151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
					}
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
					if (DEBUG_SIM_KEY_CIPHER)
															#line 155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
					{
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
						TraceEvent("SimKmsEKLookupByKeyId") .detail("DomId", item.domainId.get()) .detail("BaseCipherId", item.baseCipherId) .detail("BaseCipherKeyLen", keyCtx->keyLen) .detail("BaseCipherKCV", keyCtx->kcv);
															#line 159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
					}
				}
				else
				{
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
					TraceEvent("SimKmsEKLookupByIdsKeyNotFound") .detail("DomId", item.domainId) .detail("BaseCipherId", item.baseCipherId);
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
					success = false;
															#line 168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
					break;
				}
			}
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delayJittered(1.0);
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			if (static_cast<EkLookupByIdsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<EkLookupByIdsActor*>(this)->actor_wait_state = 1;
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EkLookupByIdsActor, 0, Void >*>(static_cast<EkLookupByIdsActor*>(this)));
															#line 181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EkLookupByIdsActorState();
		static_cast<EkLookupByIdsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		success ? req.reply.send(rep) : req.reply.sendError(encrypt_key_not_found());
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		if (!static_cast<EkLookupByIdsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EkLookupByIdsActorState(); static_cast<EkLookupByIdsActor*>(this)->destroy(); return 0; }
															#line 206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		new (&static_cast<EkLookupByIdsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EkLookupByIdsActorState();
		static_cast<EkLookupByIdsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		success ? req.reply.send(rep) : req.reply.sendError(encrypt_key_not_found());
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		if (!static_cast<EkLookupByIdsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EkLookupByIdsActorState(); static_cast<EkLookupByIdsActor*>(this)->destroy(); return 0; }
															#line 220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		new (&static_cast<EkLookupByIdsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EkLookupByIdsActorState();
		static_cast<EkLookupByIdsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EkLookupByIdsActor*>(this)->actor_wait_state > 0) static_cast<EkLookupByIdsActor*>(this)->actor_wait_state = 0;
		static_cast<EkLookupByIdsActor*>(this)->ActorCallback< EkLookupByIdsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EkLookupByIdsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ekLookupByIds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EkLookupByIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ekLookupByIds", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EkLookupByIdsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ekLookupByIds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EkLookupByIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ekLookupByIds", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EkLookupByIdsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ekLookupByIds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EkLookupByIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ekLookupByIds", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	KmsConnectorInterface interf;
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	KmsConnLookupEKsByKeyIdsReq req;
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	KmsConnLookupEKsByKeyIdsRep rep;
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	bool success;
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	Optional<TraceEvent> dbgKIdTrace;
															#line 313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
};
// This generated class is to be used only via ekLookupByIds()
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
class EkLookupByIdsActor final : public Actor<Void>, public ActorCallback< EkLookupByIdsActor, 0, Void >, public FastAllocated<EkLookupByIdsActor>, public EkLookupByIdsActorState<EkLookupByIdsActor> {
															#line 318 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
public:
	using FastAllocated<EkLookupByIdsActor>::operator new;
	using FastAllocated<EkLookupByIdsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16037640353475943936UL, 1659882997886339840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EkLookupByIdsActor, 0, Void >;
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	EkLookupByIdsActor(KmsConnectorInterface const& interf,KmsConnLookupEKsByKeyIdsReq const& req) 
															#line 335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		 : Actor<Void>(),
		   EkLookupByIdsActorState<EkLookupByIdsActor>(interf, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ekLookupByIds", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3754998231604658432UL, 9806669832522148864UL);
		ActorExecutionContextHelper __helper(static_cast<EkLookupByIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ekLookupByIds");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ekLookupByIds", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EkLookupByIdsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
[[nodiscard]] Future<Void> ekLookupByIds( KmsConnectorInterface const& interf, KmsConnLookupEKsByKeyIdsReq const& req ) {
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	return Future<Void>(new EkLookupByIdsActor(interf, req));
															#line 368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
}

#line 128 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"

															#line 373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
namespace {
// This generated class is to be used only via ekLookupByDomainIds()
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
template <class EkLookupByDomainIdsActor>
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
class EkLookupByDomainIdsActorState {
															#line 380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
public:
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	EkLookupByDomainIdsActorState(KmsConnectorInterface const& interf,KmsConnLookupEKsByDomainIdsReq const& req) 
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		 : interf(interf),
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		   req(req),
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		   rep(),
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		   success(true),
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		   dbgDIdTrace(req.debugId.present() ? TraceEvent("SimKmsGetsByDomIds", interf.id()) : Optional<TraceEvent>())
															#line 395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
	{
		fdb_probe_actor_create("ekLookupByDomainIds", reinterpret_cast<unsigned long>(this));

	}
	~EkLookupByDomainIdsActorState() 
	{
		fdb_probe_actor_destroy("ekLookupByDomainIds", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			if (dbgDIdTrace.present())
															#line 410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			{
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				dbgDIdTrace.get().setMaxEventLength(16384).detail("DbgId", req.debugId.get());
															#line 414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			}
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			const int64_t currTS = (int64_t)now();
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			const int64_t defaultTtl = FLOW_KNOBS->ENCRYPT_CIPHER_KEY_CACHE_TTL;
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			Optional<int64_t> refAtTS = getRefreshInterval(currTS, defaultTtl);
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			Optional<int64_t> expAtTS = getExpireInterval(refAtTS, defaultTtl);
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			TraceEvent("SimKmsEKLookupByDomainId").detail("RefreshAt", refAtTS).detail("ExpireAt", expAtTS);
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			for( const auto domainId : req.encryptDomainIds ) {
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				if (domainId < FDB_DEFAULT_ENCRYPT_DOMAIN_ID)
															#line 430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
				{
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
					success = false;
															#line 434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
					break;
				}
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				Reference<SimKmsVaultKeyCtx> keyCtx = SimKmsVault::getByDomainId(domainId);
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				if (keyCtx.isValid())
															#line 441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
				{
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
					rep.cipherKeyDetails.emplace_back_deep( req.arena, domainId, keyCtx->id, keyCtx->key, keyCtx->kcv, refAtTS, expAtTS);
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
					if (dbgDIdTrace.present())
															#line 447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
					{
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
						dbgDIdTrace.get().detail(getEncryptDbgTraceKey(ENCRYPT_DBG_TRACE_RESULT_PREFIX, domainId, keyCtx->id), "");
															#line 451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
					}
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
					if (DEBUG_SIM_KEY_CIPHER)
															#line 455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
					{
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
						TraceEvent("SimKmsEKLookupByDomainId") .detail("DomId", domainId) .detail("BaseCipherId", keyCtx->id) .detail("BaseCipherKeyLen", keyCtx->keyLen) .detail("BaseCipherKCV", keyCtx->kcv);
															#line 459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
					}
				}
				else
				{
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
					TraceEvent("SimKmsEKLookupByDomainIdKeyNotFound").detail("DomId", domainId);
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
					success = false;
															#line 468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
					break;
				}
			}
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delayJittered(1.0);
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			if (static_cast<EkLookupByDomainIdsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<EkLookupByDomainIdsActor*>(this)->actor_wait_state = 1;
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EkLookupByDomainIdsActor, 0, Void >*>(static_cast<EkLookupByDomainIdsActor*>(this)));
															#line 481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EkLookupByDomainIdsActorState();
		static_cast<EkLookupByDomainIdsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		success ? req.reply.send(rep) : req.reply.sendError(encrypt_key_not_found());
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		if (!static_cast<EkLookupByDomainIdsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EkLookupByDomainIdsActorState(); static_cast<EkLookupByDomainIdsActor*>(this)->destroy(); return 0; }
															#line 506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		new (&static_cast<EkLookupByDomainIdsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EkLookupByDomainIdsActorState();
		static_cast<EkLookupByDomainIdsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		success ? req.reply.send(rep) : req.reply.sendError(encrypt_key_not_found());
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		if (!static_cast<EkLookupByDomainIdsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EkLookupByDomainIdsActorState(); static_cast<EkLookupByDomainIdsActor*>(this)->destroy(); return 0; }
															#line 520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		new (&static_cast<EkLookupByDomainIdsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EkLookupByDomainIdsActorState();
		static_cast<EkLookupByDomainIdsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EkLookupByDomainIdsActor*>(this)->actor_wait_state > 0) static_cast<EkLookupByDomainIdsActor*>(this)->actor_wait_state = 0;
		static_cast<EkLookupByDomainIdsActor*>(this)->ActorCallback< EkLookupByDomainIdsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EkLookupByDomainIdsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("ekLookupByDomainIds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EkLookupByDomainIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ekLookupByDomainIds", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EkLookupByDomainIdsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("ekLookupByDomainIds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EkLookupByDomainIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ekLookupByDomainIds", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EkLookupByDomainIdsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("ekLookupByDomainIds", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EkLookupByDomainIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("ekLookupByDomainIds", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	KmsConnectorInterface interf;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	KmsConnLookupEKsByDomainIdsReq req;
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	KmsConnLookupEKsByDomainIdsRep rep;
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	bool success;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	Optional<TraceEvent> dbgDIdTrace;
															#line 613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
};
// This generated class is to be used only via ekLookupByDomainIds()
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
class EkLookupByDomainIdsActor final : public Actor<Void>, public ActorCallback< EkLookupByDomainIdsActor, 0, Void >, public FastAllocated<EkLookupByDomainIdsActor>, public EkLookupByDomainIdsActorState<EkLookupByDomainIdsActor> {
															#line 618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
public:
	using FastAllocated<EkLookupByDomainIdsActor>::operator new;
	using FastAllocated<EkLookupByDomainIdsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9477538775514183936UL, 1253904061617192448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EkLookupByDomainIdsActor, 0, Void >;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	EkLookupByDomainIdsActor(KmsConnectorInterface const& interf,KmsConnLookupEKsByDomainIdsReq const& req) 
															#line 635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		 : Actor<Void>(),
		   EkLookupByDomainIdsActorState<EkLookupByDomainIdsActor>(interf, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("ekLookupByDomainIds", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7170054928698295296UL, 8151699282175763712UL);
		ActorExecutionContextHelper __helper(static_cast<EkLookupByDomainIdsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("ekLookupByDomainIds");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("ekLookupByDomainIds", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EkLookupByDomainIdsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
[[nodiscard]] Future<Void> ekLookupByDomainIds( KmsConnectorInterface const& interf, KmsConnLookupEKsByDomainIdsReq const& req ) {
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	return Future<Void>(new EkLookupByDomainIdsActor(interf, req));
															#line 668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
}

#line 182 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"

															#line 673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
namespace {
// This generated class is to be used only via simconnectorCoreImpl()
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
template <class SimconnectorCoreImplActor>
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
class SimconnectorCoreImplActorState {
															#line 680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
public:
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	SimconnectorCoreImplActorState(KmsConnectorInterface const& interf) 
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		 : interf(interf)
															#line 687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
	{
		fdb_probe_actor_create("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this));

	}
	~SimconnectorCoreImplActorState() 
	{
		fdb_probe_actor_destroy("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			TraceEvent("SimEncryptKmsProxyInit", interf.id()).detail("MaxEncryptKeys", SERVER_KNOBS->SIM_KMS_MAX_KEYS);
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			addActor = PromiseStream<Future<Void>>();
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			collection = actorCollection(addActor.getFuture());
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			;
															#line 708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SimconnectorCoreImplActorState();
		static_cast<SimconnectorCoreImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		auto __when_expr_0 = interf.ekLookupByIds.getFuture();
															#line 738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<KmsConnLookupEKsByKeyIdsReq>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<KmsConnLookupEKsByKeyIdsReq>>::value, "invalid type");
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		if (static_cast<SimconnectorCoreImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		auto __when_expr_1 = interf.ekLookupByDomainIds.getFuture();
															#line 746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<KmsConnLookupEKsByDomainIdsReq>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<KmsConnLookupEKsByDomainIdsReq>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		auto __when_expr_2 = interf.getKMSStateReq.getFuture();
															#line 751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_2), FutureStream<KmsConnGetKMSStateReq>>::value || std::is_same<decltype(__when_expr_2), ThreadFutureStream<KmsConnGetKMSStateReq>>::value, "invalid type");
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		StrictFuture<Void> __when_expr_3 = collection;
															#line 756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
		static_cast<SimconnectorCoreImplActor*>(this)->actor_wait_state = 1;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< SimconnectorCoreImplActor, 0, KmsConnLookupEKsByKeyIdsReq >*>(static_cast<SimconnectorCoreImplActor*>(this)));
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< SimconnectorCoreImplActor, 1, KmsConnLookupEKsByDomainIdsReq >*>(static_cast<SimconnectorCoreImplActor*>(this)));
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< SimconnectorCoreImplActor, 2, KmsConnGetKMSStateReq >*>(static_cast<SimconnectorCoreImplActor*>(this)));
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SimconnectorCoreImplActor, 3, Void >*>(static_cast<SimconnectorCoreImplActor*>(this)));
															#line 767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(KmsConnLookupEKsByKeyIdsReq const& req,int loopDepth) 
	{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		addActor.send(ekLookupByIds(interf, req));
															#line 782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KmsConnLookupEKsByKeyIdsReq && req,int loopDepth) 
	{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		addActor.send(ekLookupByIds(interf, req));
															#line 791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(KmsConnLookupEKsByDomainIdsReq const& req,int loopDepth) 
	{
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		addActor.send(ekLookupByDomainIds(interf, req));
															#line 800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(KmsConnLookupEKsByDomainIdsReq && req,int loopDepth) 
	{
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		addActor.send(ekLookupByDomainIds(interf, req));
															#line 809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(KmsConnGetKMSStateReq const& req,int loopDepth) 
	{
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		req.reply.send(KmsConnGetKMSStateRep());
															#line 818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(KmsConnGetKMSStateReq && req,int loopDepth) 
	{
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		req.reply.send(KmsConnGetKMSStateRep());
															#line 827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void const& _,int loopDepth) 
	{
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		ASSERT(false);
															#line 836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void && _,int loopDepth) 
	{
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		ASSERT(false);
															#line 845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SimconnectorCoreImplActor*>(this)->actor_wait_state > 0) static_cast<SimconnectorCoreImplActor*>(this)->actor_wait_state = 0;
		static_cast<SimconnectorCoreImplActor*>(this)->ActorSingleCallback< SimconnectorCoreImplActor, 0, KmsConnLookupEKsByKeyIdsReq >::remove();
		static_cast<SimconnectorCoreImplActor*>(this)->ActorSingleCallback< SimconnectorCoreImplActor, 1, KmsConnLookupEKsByDomainIdsReq >::remove();
		static_cast<SimconnectorCoreImplActor*>(this)->ActorSingleCallback< SimconnectorCoreImplActor, 2, KmsConnGetKMSStateReq >::remove();
		static_cast<SimconnectorCoreImplActor*>(this)->ActorCallback< SimconnectorCoreImplActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< SimconnectorCoreImplActor, 0, KmsConnLookupEKsByKeyIdsReq >*,KmsConnLookupEKsByKeyIdsReq const& value) 
	{
		fdb_probe_actor_enter("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimconnectorCoreImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< SimconnectorCoreImplActor, 0, KmsConnLookupEKsByKeyIdsReq >*,KmsConnLookupEKsByKeyIdsReq && value) 
	{
		fdb_probe_actor_enter("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimconnectorCoreImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< SimconnectorCoreImplActor, 0, KmsConnLookupEKsByKeyIdsReq >*,Error err) 
	{
		fdb_probe_actor_enter("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimconnectorCoreImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< SimconnectorCoreImplActor, 1, KmsConnLookupEKsByDomainIdsReq >*,KmsConnLookupEKsByDomainIdsReq const& value) 
	{
		fdb_probe_actor_enter("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimconnectorCoreImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< SimconnectorCoreImplActor, 1, KmsConnLookupEKsByDomainIdsReq >*,KmsConnLookupEKsByDomainIdsReq && value) 
	{
		fdb_probe_actor_enter("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimconnectorCoreImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< SimconnectorCoreImplActor, 1, KmsConnLookupEKsByDomainIdsReq >*,Error err) 
	{
		fdb_probe_actor_enter("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimconnectorCoreImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< SimconnectorCoreImplActor, 2, KmsConnGetKMSStateReq >*,KmsConnGetKMSStateReq const& value) 
	{
		fdb_probe_actor_enter("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimconnectorCoreImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< SimconnectorCoreImplActor, 2, KmsConnGetKMSStateReq >*,KmsConnGetKMSStateReq && value) 
	{
		fdb_probe_actor_enter("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimconnectorCoreImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< SimconnectorCoreImplActor, 2, KmsConnGetKMSStateReq >*,Error err) 
	{
		fdb_probe_actor_enter("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimconnectorCoreImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SimconnectorCoreImplActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimconnectorCoreImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SimconnectorCoreImplActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimconnectorCoreImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SimconnectorCoreImplActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimconnectorCoreImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	KmsConnectorInterface interf;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	Future<Void> collection;
															#line 1093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
};
// This generated class is to be used only via simconnectorCoreImpl()
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
class SimconnectorCoreImplActor final : public Actor<Void>, public ActorSingleCallback< SimconnectorCoreImplActor, 0, KmsConnLookupEKsByKeyIdsReq >, public ActorSingleCallback< SimconnectorCoreImplActor, 1, KmsConnLookupEKsByDomainIdsReq >, public ActorSingleCallback< SimconnectorCoreImplActor, 2, KmsConnGetKMSStateReq >, public ActorCallback< SimconnectorCoreImplActor, 3, Void >, public FastAllocated<SimconnectorCoreImplActor>, public SimconnectorCoreImplActorState<SimconnectorCoreImplActor> {
															#line 1098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
public:
	using FastAllocated<SimconnectorCoreImplActor>::operator new;
	using FastAllocated<SimconnectorCoreImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13925694023093030144UL, 15059570323199363584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< SimconnectorCoreImplActor, 0, KmsConnLookupEKsByKeyIdsReq >;
friend struct ActorSingleCallback< SimconnectorCoreImplActor, 1, KmsConnLookupEKsByDomainIdsReq >;
friend struct ActorSingleCallback< SimconnectorCoreImplActor, 2, KmsConnGetKMSStateReq >;
friend struct ActorCallback< SimconnectorCoreImplActor, 3, Void >;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	SimconnectorCoreImplActor(KmsConnectorInterface const& interf) 
															#line 1118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		 : Actor<Void>(),
		   SimconnectorCoreImplActorState<SimconnectorCoreImplActor>(interf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3990582165786149120UL, 10280800795478493184UL);
		ActorExecutionContextHelper __helper(static_cast<SimconnectorCoreImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("simconnectorCoreImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("simconnectorCoreImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< SimconnectorCoreImplActor, 0, KmsConnLookupEKsByKeyIdsReq >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
[[nodiscard]] Future<Void> simconnectorCoreImpl( KmsConnectorInterface const& interf ) {
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	return Future<Void>(new SimconnectorCoreImplActor(interf));
															#line 1151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
}

#line 206 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"

Future<Void> SimKmsConnector::connectorCore(KmsConnectorInterface interf) {
	return simconnectorCoreImpl(interf);
}
void forceLinkSimKmsConnectorTests() {}

namespace {

															#line 1163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
// This generated class is to be used only via testRunWorkload()
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
template <class TestRunWorkloadActor>
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
class TestRunWorkloadActorState {
															#line 1169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
public:
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	TestRunWorkloadActorState(KmsConnectorInterface const& inf) 
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		 : inf(inf),
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		   maxEncryptionKeys(SimKmsVault::maxSimKeys()),
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		   maxDomainIds(deterministicRandom()->randomInt(121, 295)),
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		   maxIterations(deterministicRandom()->randomInt(5, 15)),
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		   i()
															#line 1184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
	{
		fdb_probe_actor_create("testRunWorkload", reinterpret_cast<unsigned long>(this));

	}
	~TestRunWorkloadActorState() 
	{
		fdb_probe_actor_destroy("testRunWorkload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			TraceEvent("RunWorkloadStart").detail("MaxDomainIds", maxDomainIds).detail("MaxIterations", maxIterations);
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			domainIdMap = std::unordered_map<EncryptCipherDomainId, EncryptCipherBaseKeyId>();
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			domainIds = std::vector<EncryptCipherDomainId>();
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			KmsConnLookupEKsByDomainIdsReq domainIdsReq;
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			for(i = 0;i < maxDomainIds;i++) {
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				domainIdsReq.encryptDomainIds.emplace_back(i);
															#line 1209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			}
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			StrictFuture<KmsConnLookupEKsByDomainIdsRep> __when_expr_0 = inf.ekLookupByDomainIds.getReply(domainIdsReq);
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			if (static_cast<TestRunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestRunWorkloadActor*>(this)->actor_wait_state = 1;
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestRunWorkloadActor, 0, KmsConnLookupEKsByDomainIdsRep >*>(static_cast<TestRunWorkloadActor*>(this)));
															#line 1220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestRunWorkloadActorState();
		static_cast<TestRunWorkloadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(KmsConnLookupEKsByDomainIdsRep const& domainIdsRep,int loopDepth) 
	{
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		for( auto& element : domainIdsRep.cipherKeyDetails ) {
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			Reference<SimKmsVaultKeyCtx> keyCtx = SimKmsVault::getByDomainId(element.encryptDomainId);
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT(keyCtx.isValid());
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT_EQ(element.encryptKeyId, keyCtx->id);
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT_EQ(element.encryptKey.compare(keyCtx->key), 0);
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT_EQ(element.encryptKCV, keyCtx->kcv);
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			domainIdMap[element.encryptDomainId] = keyCtx->id;
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			domainIds.push_back(element.encryptDomainId);
															#line 1257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		}
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		i = 0;
															#line 1261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(KmsConnLookupEKsByDomainIdsRep && domainIdsRep,int loopDepth) 
	{
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		for( auto& element : domainIdsRep.cipherKeyDetails ) {
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			Reference<SimKmsVaultKeyCtx> keyCtx = SimKmsVault::getByDomainId(element.encryptDomainId);
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT(keyCtx.isValid());
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT_EQ(element.encryptKeyId, keyCtx->id);
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT_EQ(element.encryptKey.compare(keyCtx->key), 0);
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT_EQ(element.encryptKCV, keyCtx->kcv);
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			domainIdMap[element.encryptDomainId] = keyCtx->id;
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			domainIds.push_back(element.encryptDomainId);
															#line 1284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		}
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		i = 0;
															#line 1288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(KmsConnLookupEKsByDomainIdsRep const& domainIdsRep,int loopDepth) 
	{
		loopDepth = a_body1cont1(domainIdsRep, loopDepth);

		return loopDepth;
	}
	int a_body1when1(KmsConnLookupEKsByDomainIdsRep && domainIdsRep,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(domainIdsRep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestRunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TestRunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TestRunWorkloadActor*>(this)->ActorCallback< TestRunWorkloadActor, 0, KmsConnLookupEKsByDomainIdsRep >::remove();

	}
	void a_callback_fire(ActorCallback< TestRunWorkloadActor, 0, KmsConnLookupEKsByDomainIdsRep >*,KmsConnLookupEKsByDomainIdsRep const& value) 
	{
		fdb_probe_actor_enter("testRunWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRunWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestRunWorkloadActor, 0, KmsConnLookupEKsByDomainIdsRep >*,KmsConnLookupEKsByDomainIdsRep && value) 
	{
		fdb_probe_actor_enter("testRunWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRunWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestRunWorkloadActor, 0, KmsConnLookupEKsByDomainIdsRep >*,Error err) 
	{
		fdb_probe_actor_enter("testRunWorkload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRunWorkload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		{
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			req = KmsConnLookupEKsByKeyIdsReq();
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			req.encryptKeyInfos.emplace_back(1, maxEncryptionKeys + 1);
															#line 1375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			try {
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				StrictFuture<KmsConnLookupEKsByKeyIdsRep> __when_expr_3 = inf.ekLookupByIds.getReply(req);
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				if (static_cast<TestRunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1cont3Catch1(actor_cancelled(), loopDepth);
															#line 1381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont3Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
				static_cast<TestRunWorkloadActor*>(this)->actor_wait_state = 4;
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestRunWorkloadActor, 3, KmsConnLookupEKsByKeyIdsRep >*>(static_cast<TestRunWorkloadActor*>(this)));
															#line 1386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont3Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont3Catch1(unknown_error(), loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		if (!(i < maxIterations))
															#line 1409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		const int batchSize = deterministicRandom()->randomInt(1, maxEncryptionKeys);
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		int domIdx = deterministicRandom()->randomInt(0, domainIds.size() - 1);
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 1419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		{
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			KmsConnLookupEKsByDomainIdsReq domainIdsReq;
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			for(int j = 0;j < batchSize && domIdx < domainIds.size();j++, domIdx++) {
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				domainIdsReq.encryptDomainIds.emplace_back(domIdx);
															#line 1427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			}
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			StrictFuture<KmsConnLookupEKsByDomainIdsRep> __when_expr_1 = inf.ekLookupByDomainIds.getReply(domainIdsReq);
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			if (static_cast<TestRunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestRunWorkloadActor*>(this)->actor_wait_state = 2;
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestRunWorkloadActor, 1, KmsConnLookupEKsByDomainIdsRep >*>(static_cast<TestRunWorkloadActor*>(this)));
															#line 1438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			keyIdsReq = KmsConnLookupEKsByKeyIdsReq();
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			for(int j = 0;j < batchSize && domIdx < domainIds.size();j++, domIdx++) {
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				auto itr = domainIdMap.find(domIdx);
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				ASSERT(itr != domainIdMap.end());
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
				keyIdsReq.encryptKeyInfos.emplace_back(domIdx, itr->second);
															#line 1453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			}
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			StrictFuture<KmsConnLookupEKsByKeyIdsRep> __when_expr_2 = inf.ekLookupByIds.getReply(keyIdsReq);
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			if (static_cast<TestRunWorkloadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
			static_cast<TestRunWorkloadActor*>(this)->actor_wait_state = 3;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestRunWorkloadActor, 2, KmsConnLookupEKsByKeyIdsRep >*>(static_cast<TestRunWorkloadActor*>(this)));
															#line 1464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		i++;
															#line 1487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(KmsConnLookupEKsByDomainIdsRep const& domainIdsRep,int loopDepth) 
	{
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		for( auto& element : domainIdsRep.cipherKeyDetails ) {
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			Reference<SimKmsVaultKeyCtx> keyCtx = SimKmsVault::getByDomainId(element.encryptDomainId);
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT(keyCtx.isValid());
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT_EQ(element.encryptKeyId, keyCtx->id);
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT_EQ(element.encryptKey.compare(keyCtx->key), 0);
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT_EQ(element.encryptKCV, keyCtx->kcv);
															#line 1506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(KmsConnLookupEKsByDomainIdsRep && domainIdsRep,int loopDepth) 
	{
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		for( auto& element : domainIdsRep.cipherKeyDetails ) {
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			Reference<SimKmsVaultKeyCtx> keyCtx = SimKmsVault::getByDomainId(element.encryptDomainId);
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT(keyCtx.isValid());
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT_EQ(element.encryptKeyId, keyCtx->id);
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT_EQ(element.encryptKey.compare(keyCtx->key), 0);
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT_EQ(element.encryptKCV, keyCtx->kcv);
															#line 1526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KmsConnLookupEKsByDomainIdsRep const& domainIdsRep,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(domainIdsRep, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(KmsConnLookupEKsByDomainIdsRep && domainIdsRep,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(domainIdsRep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestRunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TestRunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TestRunWorkloadActor*>(this)->ActorCallback< TestRunWorkloadActor, 1, KmsConnLookupEKsByDomainIdsRep >::remove();

	}
	void a_callback_fire(ActorCallback< TestRunWorkloadActor, 1, KmsConnLookupEKsByDomainIdsRep >*,KmsConnLookupEKsByDomainIdsRep const& value) 
	{
		fdb_probe_actor_enter("testRunWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRunWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestRunWorkloadActor, 1, KmsConnLookupEKsByDomainIdsRep >*,KmsConnLookupEKsByDomainIdsRep && value) 
	{
		fdb_probe_actor_enter("testRunWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRunWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestRunWorkloadActor, 1, KmsConnLookupEKsByDomainIdsRep >*,Error err) 
	{
		fdb_probe_actor_enter("testRunWorkload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRunWorkload", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont7(int loopDepth) 
	{
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		for( auto& element : keyIdsReply.cipherKeyDetails ) {
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			Reference<SimKmsVaultKeyCtx> keyCtx = SimKmsVault::getByBaseCipherId(element.encryptKeyId);
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT(keyCtx.isValid());
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT_EQ(element.encryptKeyId, keyCtx->id);
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT_EQ(element.encryptKey.compare(keyCtx->key), 0);
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT_EQ(element.encryptKCV, keyCtx->kcv);
															#line 1621 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(KmsConnLookupEKsByKeyIdsRep const& __keyIdsReply,int loopDepth) 
	{
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		keyIdsReply = __keyIdsReply;
															#line 1631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(KmsConnLookupEKsByKeyIdsRep && __keyIdsReply,int loopDepth) 
	{
		keyIdsReply = std::move(__keyIdsReply);
		loopDepth = a_body1cont1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestRunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TestRunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TestRunWorkloadActor*>(this)->ActorCallback< TestRunWorkloadActor, 2, KmsConnLookupEKsByKeyIdsRep >::remove();

	}
	void a_callback_fire(ActorCallback< TestRunWorkloadActor, 2, KmsConnLookupEKsByKeyIdsRep >*,KmsConnLookupEKsByKeyIdsRep const& value) 
	{
		fdb_probe_actor_enter("testRunWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRunWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestRunWorkloadActor, 2, KmsConnLookupEKsByKeyIdsRep >*,KmsConnLookupEKsByKeyIdsRep && value) 
	{
		fdb_probe_actor_enter("testRunWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRunWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestRunWorkloadActor, 2, KmsConnLookupEKsByKeyIdsRep >*,Error err) 
	{
		fdb_probe_actor_enter("testRunWorkload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRunWorkload", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		TraceEvent("RunWorkloadDone").log();
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		if (!static_cast<TestRunWorkloadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRunWorkloadActorState(); static_cast<TestRunWorkloadActor*>(this)->destroy(); return 0; }
															#line 1712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		new (&static_cast<TestRunWorkloadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestRunWorkloadActorState();
		static_cast<TestRunWorkloadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			ASSERT(e.code() == error_code_encrypt_key_not_found);
															#line 1731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(KmsConnLookupEKsByKeyIdsRep const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(KmsConnLookupEKsByKeyIdsRep && reply,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(KmsConnLookupEKsByKeyIdsRep const& reply,int loopDepth) 
	{
		loopDepth = a_body1cont7(reply, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(KmsConnLookupEKsByKeyIdsRep && reply,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestRunWorkloadActor*>(this)->actor_wait_state > 0) static_cast<TestRunWorkloadActor*>(this)->actor_wait_state = 0;
		static_cast<TestRunWorkloadActor*>(this)->ActorCallback< TestRunWorkloadActor, 3, KmsConnLookupEKsByKeyIdsRep >::remove();

	}
	void a_callback_fire(ActorCallback< TestRunWorkloadActor, 3, KmsConnLookupEKsByKeyIdsRep >*,KmsConnLookupEKsByKeyIdsRep const& value) 
	{
		fdb_probe_actor_enter("testRunWorkload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRunWorkload", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestRunWorkloadActor, 3, KmsConnLookupEKsByKeyIdsRep >*,KmsConnLookupEKsByKeyIdsRep && value) 
	{
		fdb_probe_actor_enter("testRunWorkload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRunWorkload", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestRunWorkloadActor, 3, KmsConnLookupEKsByKeyIdsRep >*,Error err) 
	{
		fdb_probe_actor_enter("testRunWorkload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRunWorkload", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	KmsConnectorInterface inf;
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	uint32_t maxEncryptionKeys;
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	int maxDomainIds;
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	int maxIterations;
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	int i;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	std::unordered_map<EncryptCipherDomainId, EncryptCipherBaseKeyId> domainIdMap;
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	std::vector<EncryptCipherDomainId> domainIds;
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	KmsConnLookupEKsByKeyIdsReq keyIdsReq;
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	KmsConnLookupEKsByKeyIdsRep keyIdsReply;
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	KmsConnLookupEKsByKeyIdsReq req;
															#line 1862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
};
// This generated class is to be used only via testRunWorkload()
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
class TestRunWorkloadActor final : public Actor<Void>, public ActorCallback< TestRunWorkloadActor, 0, KmsConnLookupEKsByDomainIdsRep >, public ActorCallback< TestRunWorkloadActor, 1, KmsConnLookupEKsByDomainIdsRep >, public ActorCallback< TestRunWorkloadActor, 2, KmsConnLookupEKsByKeyIdsRep >, public ActorCallback< TestRunWorkloadActor, 3, KmsConnLookupEKsByKeyIdsRep >, public FastAllocated<TestRunWorkloadActor>, public TestRunWorkloadActorState<TestRunWorkloadActor> {
															#line 1867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
public:
	using FastAllocated<TestRunWorkloadActor>::operator new;
	using FastAllocated<TestRunWorkloadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9364710189138601472UL, 14801237055004199168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestRunWorkloadActor, 0, KmsConnLookupEKsByDomainIdsRep >;
friend struct ActorCallback< TestRunWorkloadActor, 1, KmsConnLookupEKsByDomainIdsRep >;
friend struct ActorCallback< TestRunWorkloadActor, 2, KmsConnLookupEKsByKeyIdsRep >;
friend struct ActorCallback< TestRunWorkloadActor, 3, KmsConnLookupEKsByKeyIdsRep >;
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	TestRunWorkloadActor(KmsConnectorInterface const& inf) 
															#line 1887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		 : Actor<Void>(),
		   TestRunWorkloadActorState<TestRunWorkloadActor>(inf),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testRunWorkload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18086765046379557376UL, 16895190901573646848UL);
		ActorExecutionContextHelper __helper(static_cast<TestRunWorkloadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testRunWorkload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testRunWorkload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestRunWorkloadActor, 0, KmsConnLookupEKsByDomainIdsRep >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestRunWorkloadActor, 1, KmsConnLookupEKsByDomainIdsRep >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestRunWorkloadActor, 2, KmsConnLookupEKsByKeyIdsRep >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestRunWorkloadActor, 3, KmsConnLookupEKsByKeyIdsRep >*)0, actor_cancelled()); break;
		}

	}
};
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
[[nodiscard]] Future<Void> testRunWorkload( KmsConnectorInterface const& inf ) {
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	return Future<Void>(new TestRunWorkloadActor(inf));
															#line 1922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
}

#line 288 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"

} // namespace

															#line 1929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase291()
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
template <class FlowTestCase291Actor>
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
class FlowTestCase291ActorState {
															#line 1936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
public:
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	FlowTestCase291ActorState(UnitTestParameters const& params) 
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		 : params(params),
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		   inf(),
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		   connector("SimKmsConnector")
															#line 1947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase291", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase291ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase291", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
			;
															#line 1962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase291ActorState();
		static_cast<FlowTestCase291Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		if (!static_cast<FlowTestCase291Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase291ActorState(); static_cast<FlowTestCase291Actor*>(this)->destroy(); return 0; }
															#line 1985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		new (&static_cast<FlowTestCase291Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase291ActorState();
		static_cast<FlowTestCase291Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		StrictFuture<Void> __when_expr_0 = connector.connectorCore(inf);
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		if (static_cast<FlowTestCase291Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		StrictFuture<Void> __when_expr_1 = testRunWorkload(inf);
															#line 2010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase291Actor*>(this)->actor_wait_state = 1;
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase291Actor, 0, Void >*>(static_cast<FlowTestCase291Actor*>(this)));
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase291Actor, 1, Void >*>(static_cast<FlowTestCase291Actor*>(this)));
															#line 2017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 2039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
		return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 2047 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase291Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase291Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase291Actor*>(this)->ActorCallback< FlowTestCase291Actor, 0, Void >::remove();
		static_cast<FlowTestCase291Actor*>(this)->ActorCallback< FlowTestCase291Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase291Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase291", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase291Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase291", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase291Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase291", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase291Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase291", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase291Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase291", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase291Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase291", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase291Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase291", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase291Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase291", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase291Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase291", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase291Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase291", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase291Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase291", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase291Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase291", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	UnitTestParameters params;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	KmsConnectorInterface inf;
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	SimKmsConnector connector;
															#line 2190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase291()
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
class FlowTestCase291Actor final : public Actor<Void>, public ActorCallback< FlowTestCase291Actor, 0, Void >, public ActorCallback< FlowTestCase291Actor, 1, Void >, public FastAllocated<FlowTestCase291Actor>, public FlowTestCase291ActorState<FlowTestCase291Actor> {
															#line 2195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase291Actor>::operator new;
	using FastAllocated<FlowTestCase291Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11959400421908518144UL, 10762725103214309632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase291Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase291Actor, 1, Void >;
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	FlowTestCase291Actor(UnitTestParameters const& params) 
															#line 2213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase291ActorState<FlowTestCase291Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase291", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12718729472587501824UL, 16277383773760288256UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase291Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase291");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase291", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase291Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
static Future<Void> flowTestCase291( UnitTestParameters const& params ) {
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
	return Future<Void>(new FlowTestCase291Actor(params));
															#line 2246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/SimKmsConnector.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase291, "fdbserver/SimKmsConnector")

#line 305 "/Users/ec2-user/foundationdb/fdbserver/SimKmsConnector.actor.cpp"
