#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
/*
 * GrvProxyServer.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ClientKnobs.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/Notified.h"
#include "fdbclient/TransactionLineage.h"
#include "fdbclient/Tuple.h"
#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/GrvProxyInterface.h"
#include "fdbclient/VersionVector.h"
#include "fdbserver/GrvProxyTagThrottler.h"
#include "fdbserver/GrvTransactionRateInfo.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/LogSystemDiskQueueAdapter.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbrpc/sim_validation.h"
#include "flow/Buggify.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/flow.h"
#include "flow/actorcompiler.h" // This must be the last #include.
#include "flow/genericactors.actor.h"

struct GrvProxyStats {
	CounterCollection cc;
	Counter txnRequestIn;
	Counter txnRequestOut;
	Counter txnRequestErrors;
	Counter txnStartIn;
	Counter txnStartOut;
	Counter txnStartBatch;
	Counter txnSystemPriorityStartIn;
	Counter txnSystemPriorityStartOut;
	Counter txnBatchPriorityStartIn;
	Counter txnBatchPriorityStartOut;
	Counter txnDefaultPriorityStartIn;
	Counter txnDefaultPriorityStartOut;
	Counter txnTagThrottlerIn;
	Counter txnTagThrottlerOut;
	Counter txnThrottled;
	Counter updatesFromRatekeeper;
	Counter leaseTimeouts;
	int systemGRVQueueSize;
	int defaultGRVQueueSize;
	int batchGRVQueueSize;
	int tagThrottlerGRVQueueSize;
	double transactionRateAllowed;
	double batchTransactionRateAllowed;
	double transactionLimit;
	double batchTransactionLimit;
	// how much of the GRV requests queue was processed in one attempt to hand out read version.
	double percentageOfDefaultGRVQueueProcessed;
	double percentageOfBatchGRVQueueProcessed;

	bool lastBatchQueueThrottled;
	bool lastDefaultQueueThrottled;
	double batchThrottleStartTime;
	double defaultThrottleStartTime;

	LatencySample defaultTxnGRVTimeInQueue;
	LatencySample batchTxnGRVTimeInQueue;

	// These latency bands and samples ignore latency injected by the GrvProxyTagThrottler
	LatencyBands grvLatencyBands;
	LatencySample grvLatencySample; // GRV latency metric sample of default priority
	LatencySample grvBatchLatencySample; // GRV latency metric sample of batched priority

	Future<Void> logger;

	int recentRequests;
	Deque<int> requestBuckets;
	double lastBucketBegin;
	double bucketInterval;
	Reference<Histogram> grvConfirmEpochLiveDist;
	Reference<Histogram> grvGetCommittedVersionRpcDist;

	void updateRequestBuckets() {
		while (now() - lastBucketBegin > bucketInterval) {
			lastBucketBegin += bucketInterval;
			recentRequests -= requestBuckets.front();
			requestBuckets.pop_front();
			requestBuckets.push_back(0);
		}
	}

	void addRequest(int transactionCount) {
		updateRequestBuckets();
		recentRequests += transactionCount;
		requestBuckets.back() += transactionCount;
	}

	int getRecentRequests() {
		updateRequestBuckets();
		return recentRequests /
		       (FLOW_KNOBS->BASIC_LOAD_BALANCE_UPDATE_RATE - (lastBucketBegin + bucketInterval - now()));
	}

	void update(GrvProxyTagThrottler::ReleaseTransactionsResult const& releaseStats) {
		auto const totalReleasedRequests =
		    releaseStats.batchPriorityRequestsReleased + releaseStats.defaultPriorityRequestsReleased;
		auto const totalReleasedTransactions =
		    releaseStats.batchPriorityTransactionsReleased + releaseStats.defaultPriorityTransactionsReleased;

		txnRequestIn += totalReleasedRequests;
		txnStartIn += totalReleasedTransactions;
		txnBatchPriorityStartIn += releaseStats.batchPriorityTransactionsReleased;
		txnDefaultPriorityStartIn += releaseStats.defaultPriorityTransactionsReleased;
		batchGRVQueueSize += releaseStats.batchPriorityRequestsReleased;
		defaultGRVQueueSize += releaseStats.defaultPriorityRequestsReleased;
		txnRequestErrors += releaseStats.rejectedRequests;
		txnTagThrottlerOut += totalReleasedTransactions;
		tagThrottlerGRVQueueSize -= totalReleasedRequests;
	}

	// Current stats maintained for a given grv proxy server
	explicit GrvProxyStats(UID id)
	  : cc("GrvProxyStats", id.toString()),

	    txnRequestIn("TxnRequestIn", cc), txnRequestOut("TxnRequestOut", cc), txnRequestErrors("TxnRequestErrors", cc),
	    txnStartIn("TxnStartIn", cc), txnStartOut("TxnStartOut", cc), txnStartBatch("TxnStartBatch", cc),
	    txnSystemPriorityStartIn("TxnSystemPriorityStartIn", cc),
	    txnSystemPriorityStartOut("TxnSystemPriorityStartOut", cc),
	    txnBatchPriorityStartIn("TxnBatchPriorityStartIn", cc),
	    txnBatchPriorityStartOut("TxnBatchPriorityStartOut", cc),
	    txnDefaultPriorityStartIn("TxnDefaultPriorityStartIn", cc),
	    txnDefaultPriorityStartOut("TxnDefaultPriorityStartOut", cc), txnTagThrottlerIn("TxnTagThrottlerIn", cc),
	    txnTagThrottlerOut("TxnTagThrottlerOut", cc), txnThrottled("TxnThrottled", cc),
	    updatesFromRatekeeper("UpdatesFromRatekeeper", cc), leaseTimeouts("LeaseTimeouts", cc), systemGRVQueueSize(0),
	    defaultGRVQueueSize(0), batchGRVQueueSize(0), tagThrottlerGRVQueueSize(0), transactionRateAllowed(0),
	    batchTransactionRateAllowed(0), transactionLimit(0), batchTransactionLimit(0),
	    percentageOfDefaultGRVQueueProcessed(0), percentageOfBatchGRVQueueProcessed(0), lastBatchQueueThrottled(false),
	    lastDefaultQueueThrottled(false), batchThrottleStartTime(0.0), defaultThrottleStartTime(0.0),
	    defaultTxnGRVTimeInQueue("DefaultTxnGRVTimeInQueue",
	                             id,
	                             SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
	                             SERVER_KNOBS->LATENCY_SKETCH_ACCURACY),
	    batchTxnGRVTimeInQueue("BatchTxnGRVTimeInQueue",
	                           id,
	                           SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
	                           SERVER_KNOBS->LATENCY_SKETCH_ACCURACY),
	    grvLatencyBands("GRVLatencyBands", id, SERVER_KNOBS->STORAGE_LOGGING_DELAY),
	    grvLatencySample("GRVLatencyMetrics",
	                     id,
	                     SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
	                     SERVER_KNOBS->LATENCY_SKETCH_ACCURACY),
	    grvBatchLatencySample("GRVBatchLatencyMetrics",
	                          id,
	                          SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
	                          SERVER_KNOBS->LATENCY_SKETCH_ACCURACY),
	    recentRequests(0), lastBucketBegin(now()),
	    bucketInterval(FLOW_KNOBS->BASIC_LOAD_BALANCE_UPDATE_RATE / FLOW_KNOBS->BASIC_LOAD_BALANCE_BUCKETS),
	    grvConfirmEpochLiveDist(
	        Histogram::getHistogram("GrvProxy"_sr, "GrvConfirmEpochLive"_sr, Histogram::Unit::milliseconds)),
	    grvGetCommittedVersionRpcDist(
	        Histogram::getHistogram("GrvProxy"_sr, "GrvGetCommittedVersionRpc"_sr, Histogram::Unit::milliseconds)) {
		// The rate at which the limit(budget) is allowed to grow.
		specialCounter(cc, "SystemGRVQueueSize", [this]() { return this->systemGRVQueueSize; });
		specialCounter(cc, "DefaultGRVQueueSize", [this]() { return this->defaultGRVQueueSize; });
		specialCounter(cc, "BatchGRVQueueSize", [this]() { return this->batchGRVQueueSize; });
		specialCounter(cc, "TagThrottlerGRVQueueSize", [this]() { return this->tagThrottlerGRVQueueSize; });
		specialCounter(
		    cc, "SystemAndDefaultTxnRateAllowed", [this]() { return int64_t(this->transactionRateAllowed); });
		specialCounter(
		    cc, "BatchTransactionRateAllowed", [this]() { return int64_t(this->batchTransactionRateAllowed); });
		specialCounter(cc, "SystemAndDefaultTxnLimit", [this]() { return int64_t(this->transactionLimit); });
		specialCounter(cc, "BatchTransactionLimit", [this]() { return int64_t(this->batchTransactionLimit); });
		specialCounter(cc, "PercentageOfDefaultGRVQueueProcessed", [this]() {
			return int64_t(100 * this->percentageOfDefaultGRVQueueProcessed);
		});
		specialCounter(cc, "PercentageOfBatchGRVQueueProcessed", [this]() {
			return int64_t(100 * this->percentageOfBatchGRVQueueProcessed);
		});

		logger = cc.traceCounters("GrvProxyMetrics", id, SERVER_KNOBS->WORKER_LOGGING_INTERVAL, "GrvProxyMetrics");
		for (int i = 0; i < FLOW_KNOBS->BASIC_LOAD_BALANCE_BUCKETS; i++) {
			requestBuckets.push_back(0);
		}
	}
};

struct GrvProxyData {
	GrvProxyInterface proxy;
	UID dbgid;

	GrvProxyStats stats;
	MasterInterface master;
	PublicRequestStream<GetReadVersionRequest> getConsistentReadVersion;
	Reference<ILogSystem> logSystem;

	Database cx;
	Reference<AsyncVar<ServerDBInfo> const> db;

	Optional<LatencyBandConfig> latencyBandConfig;
	double lastStartCommit;
	double lastCommitLatency;
	std::unique_ptr<LatencySample> versionVectorSizeOnGRVReply;
	int updateCommitRequests;
	NotifiedDouble lastCommitTime;

	Version version;
	Version minKnownCommittedVersion; // we should ask master for this version.

	GrvProxyTagThrottler tagThrottler;

	// Cache of the latest commit versions of storage servers.
	VersionVector ssVersionVectorCache;

	void updateLatencyBandConfig(Optional<LatencyBandConfig> newLatencyBandConfig) {
		if (newLatencyBandConfig.present() != latencyBandConfig.present() ||
		    (newLatencyBandConfig.present() &&
		     newLatencyBandConfig.get().grvConfig != latencyBandConfig.get().grvConfig)) {
			TraceEvent("LatencyBandGrvUpdatingConfig").detail("Present", newLatencyBandConfig.present());
			stats.grvLatencyBands.clearBands();
			if (newLatencyBandConfig.present()) {
				for (auto band : newLatencyBandConfig.get().grvConfig.bands) {
					stats.grvLatencyBands.addThreshold(band);
					tagThrottler.addLatencyBandThreshold(band);
				}
			}
		}

		latencyBandConfig = newLatencyBandConfig;
	}

	GrvProxyData(UID dbgid,
	             MasterInterface master,
	             PublicRequestStream<GetReadVersionRequest> getConsistentReadVersion,
	             Reference<AsyncVar<ServerDBInfo> const> db)
	  : dbgid(dbgid), stats(dbgid), master(master), getConsistentReadVersion(getConsistentReadVersion),
	    cx(openDBOnServer(db, TaskPriority::DefaultEndpoint, LockAware::True)), db(db), lastStartCommit(0),
	    lastCommitLatency(SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION), updateCommitRequests(0), lastCommitTime(0),
	    version(0), minKnownCommittedVersion(invalidVersion),
	    tagThrottler(CLIENT_KNOBS->PROXY_MAX_TAG_THROTTLE_DURATION) {
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR) {
			versionVectorSizeOnGRVReply =
			    std::make_unique<LatencySample>("VersionVectorSizeOnGRVReply",
			                                    dbgid,
			                                    SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
			                                    SERVER_KNOBS->LATENCY_SKETCH_ACCURACY);
		}
	}
};

															#line 266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via healthMetricsRequestServer()
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class HealthMetricsRequestServerActor>
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class HealthMetricsRequestServerActorState {
															#line 273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	HealthMetricsRequestServerActorState(GrvProxyInterface const& grvProxy,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply) 
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : grvProxy(grvProxy),
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   healthMetricsReply(healthMetricsReply),
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   detailedHealthMetricsReply(detailedHealthMetricsReply)
															#line 284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this));

	}
	~HealthMetricsRequestServerActorState() 
	{
		fdb_probe_actor_destroy("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HealthMetricsRequestServerActorState();
		static_cast<HealthMetricsRequestServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		auto __when_expr_0 = grvProxy.getHealthMetrics.getFuture();
															#line 329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetHealthMetricsRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetHealthMetricsRequest>>::value, "invalid type");
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<HealthMetricsRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<HealthMetricsRequestServerActor*>(this)->actor_wait_state = 1;
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >*>(static_cast<HealthMetricsRequestServerActor*>(this)));
															#line 338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetHealthMetricsRequest const& req,int loopDepth) 
	{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (req.detailed)
															#line 353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			req.reply.send(*detailedHealthMetricsReply);
															#line 357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			req.reply.send(*healthMetricsReply);
															#line 363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetHealthMetricsRequest && req,int loopDepth) 
	{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (req.detailed)
															#line 373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			req.reply.send(*detailedHealthMetricsReply);
															#line 377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			req.reply.send(*healthMetricsReply);
															#line 383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HealthMetricsRequestServerActor*>(this)->actor_wait_state > 0) static_cast<HealthMetricsRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<HealthMetricsRequestServerActor*>(this)->ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >*,GetHealthMetricsRequest const& value) 
	{
		fdb_probe_actor_enter("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >*,GetHealthMetricsRequest && value) 
	{
		fdb_probe_actor_enter("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface grvProxy;
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* healthMetricsReply;
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* detailedHealthMetricsReply;
															#line 458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via healthMetricsRequestServer()
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class HealthMetricsRequestServerActor final : public Actor<Void>, public ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >, public FastAllocated<HealthMetricsRequestServerActor>, public HealthMetricsRequestServerActorState<HealthMetricsRequestServerActor> {
															#line 463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<HealthMetricsRequestServerActor>::operator new;
	using FastAllocated<HealthMetricsRequestServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1437005913898334976UL, 9685340650771797504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >;
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	HealthMetricsRequestServerActor(GrvProxyInterface const& grvProxy,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply) 
															#line 480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   HealthMetricsRequestServerActorState<HealthMetricsRequestServerActor>(grvProxy, healthMetricsReply, detailedHealthMetricsReply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15006378439154462208UL, 8394861280111908096UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("healthMetricsRequestServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> healthMetricsRequestServer( GrvProxyInterface const& grvProxy, GetHealthMetricsReply* const& healthMetricsReply, GetHealthMetricsReply* const& detailedHealthMetricsReply ) {
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new HealthMetricsRequestServerActor(grvProxy, healthMetricsReply, detailedHealthMetricsReply));
															#line 513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 278 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Older FDB versions used different keys for client profiling data. This
// function performs a one-time migration of data in these keys to the new
// global configuration key space.
															#line 521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via globalConfigMigrate()
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GlobalConfigMigrateActor>
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigMigrateActorState {
															#line 528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigMigrateActorState(GrvProxyData* const& grvProxyData) 
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : grvProxyData(grvProxyData),
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   migratedKey("\xff\x02/fdbClientInfo/migrated/"_sr),
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(grvProxyData->cx))
															#line 539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("globalConfigMigrate", reinterpret_cast<unsigned long>(this));

	}
	~GlobalConfigMigrateActorState() 
	{
		fdb_probe_actor_destroy("globalConfigMigrate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				;
															#line 555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GlobalConfigMigrateActorState();
		static_cast<GlobalConfigMigrateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GlobalConfigMigrateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GlobalConfigMigrateActorState(); static_cast<GlobalConfigMigrateActor*>(this)->destroy(); return 0; }
															#line 584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GlobalConfigMigrateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GlobalConfigMigrateActorState();
		static_cast<GlobalConfigMigrateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "GlobalConfigMigrationError").error(e);
															#line 597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		try {
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(migratedKey);
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 1;
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >*>(static_cast<GlobalConfigMigrateActor*>(this)));
															#line 636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent(SevInfo, "GlobalConfigRetryableMigrationError").errorUnsuppressed(e).suppressFor(1.0);
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 675 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 5;
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigMigrateActor, 4, Void >*>(static_cast<GlobalConfigMigrateActor*>(this)));
															#line 680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (migrated.present())
															#line 695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr->get(Key("\xff\x02/fdbClientInfo/client_txn_sample_rate/"_sr));
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 2;
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >*>(static_cast<GlobalConfigMigrateActor*>(this)));
															#line 708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __migrated,int loopDepth) 
	{
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		migrated = __migrated;
															#line 717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __migrated,int loopDepth) 
	{
		migrated = std::move(__migrated);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigMigrateActor*>(this)->ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr->get(Key("\xff\x02/fdbClientInfo/client_txn_size_limit/"_sr));
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 3;
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >*>(static_cast<GlobalConfigMigrateActor*>(this)));
															#line 803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& __sampleRate,int loopDepth) 
	{
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		sampleRate = __sampleRate;
															#line 812 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && __sampleRate,int loopDepth) 
	{
		sampleRate = std::move(__sampleRate);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigMigrateActor*>(this)->ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 303 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		tr->set(migratedKey.contents(), "1"_sr);
															#line 304 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (sampleRate.present())
															#line 895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			const double sampleRateDbl = BinaryReader::fromStringRef<double>(sampleRate.get().contents(), Unversioned());
															#line 307 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Tuple rate = Tuple::makeTuple(sampleRateDbl);
															#line 308 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			tr->set(GlobalConfig::prefixedKey(fdbClientInfoTxnSampleRate), rate.pack());
															#line 903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (sizeLimit.present())
															#line 907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			const int64_t sizeLimitInt = BinaryReader::fromStringRef<int64_t>(sizeLimit.get().contents(), Unversioned());
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Tuple size = Tuple::makeTuple(sizeLimitInt);
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			tr->set(GlobalConfig::prefixedKey(fdbClientInfoTxnSizeLimit), size.pack());
															#line 915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 4;
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigMigrateActor, 3, Void >*>(static_cast<GlobalConfigMigrateActor*>(this)));
															#line 926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Optional<Value> const& __sizeLimit,int loopDepth) 
	{
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		sizeLimit = __sizeLimit;
															#line 935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Optional<Value> && __sizeLimit,int loopDepth) 
	{
		sizeLimit = std::move(__sizeLimit);
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigMigrateActor*>(this)->ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigMigrateActor*>(this)->ActorCallback< GlobalConfigMigrateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GlobalConfigMigrateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigMigrateActor*>(this)->ActorCallback< GlobalConfigMigrateActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GlobalConfigMigrateActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 283 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Key migratedKey;
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<Value> migrated;
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<Value> sampleRate;
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<Value> sizeLimit;
															#line 1209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via globalConfigMigrate()
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigMigrateActor final : public Actor<Void>, public ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >, public ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >, public ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >, public ActorCallback< GlobalConfigMigrateActor, 3, Void >, public ActorCallback< GlobalConfigMigrateActor, 4, Void >, public FastAllocated<GlobalConfigMigrateActor>, public GlobalConfigMigrateActorState<GlobalConfigMigrateActor> {
															#line 1214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GlobalConfigMigrateActor>::operator new;
	using FastAllocated<GlobalConfigMigrateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14765531529710091008UL, 11366916293124518144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >;
friend struct ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >;
friend struct ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >;
friend struct ActorCallback< GlobalConfigMigrateActor, 3, Void >;
friend struct ActorCallback< GlobalConfigMigrateActor, 4, Void >;
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigMigrateActor(GrvProxyData* const& grvProxyData) 
															#line 1235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GlobalConfigMigrateActorState<GlobalConfigMigrateActor>(grvProxyData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(154511452753742592UL, 13598310903932054784UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("globalConfigMigrate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GlobalConfigMigrateActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GlobalConfigMigrateActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> globalConfigMigrate( GrvProxyData* const& grvProxyData ) {
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GlobalConfigMigrateActor(grvProxyData));
															#line 1272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 332 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Periodically refresh local copy of global configuration.
															#line 1278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via globalConfigRefresh()
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GlobalConfigRefreshActor>
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigRefreshActorState {
															#line 1285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigRefreshActorState(GrvProxyData* const& grvProxyData,Version* const& cachedVersion,RangeResult* const& cachedData) 
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : grvProxyData(grvProxyData),
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   cachedVersion(cachedVersion),
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   cachedData(cachedData),
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(grvProxyData->cx))
															#line 1298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("globalConfigRefresh", reinterpret_cast<unsigned long>(this));

	}
	~GlobalConfigRefreshActorState() 
	{
		fdb_probe_actor_destroy("globalConfigRefresh", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 1313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GlobalConfigRefreshActorState();
		static_cast<GlobalConfigRefreshActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			globalConfigVersionFuture = tr->get(globalConfigVersionKey);
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			tmpCachedDataFuture = tr->getRange(globalConfigDataKeys, CLIENT_KNOBS->TOO_MANY);
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = globalConfigVersionFuture;
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 1;
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >*>(static_cast<GlobalConfigRefreshActor*>(this)));
															#line 1357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 3;
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRefreshActor, 2, Void >*>(static_cast<GlobalConfigRefreshActor*>(this)));
															#line 1386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tmpCachedDataFuture;
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 2;
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >*>(static_cast<GlobalConfigRefreshActor*>(this)));
															#line 1408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __globalConfigVersion,int loopDepth) 
	{
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		globalConfigVersion = __globalConfigVersion;
															#line 1417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __globalConfigVersion,int loopDepth) 
	{
		globalConfigVersion = std::move(__globalConfigVersion);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigRefreshActor*>(this)->ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& tmpCachedData,int loopDepth) 
	{
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*cachedData = tmpCachedData;
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (globalConfigVersion.present())
															#line 1498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Version parsedVersion;
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			memcpy(&parsedVersion, globalConfigVersion.get().begin(), sizeof(Version));
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			*cachedVersion = bigEndian64(parsedVersion);
															#line 1506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GlobalConfigRefreshActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GlobalConfigRefreshActorState(); static_cast<GlobalConfigRefreshActor*>(this)->destroy(); return 0; }
															#line 1510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GlobalConfigRefreshActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GlobalConfigRefreshActorState();
		static_cast<GlobalConfigRefreshActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && tmpCachedData,int loopDepth) 
	{
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*cachedData = tmpCachedData;
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (globalConfigVersion.present())
															#line 1524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Version parsedVersion;
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			memcpy(&parsedVersion, globalConfigVersion.get().begin(), sizeof(Version));
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			*cachedVersion = bigEndian64(parsedVersion);
															#line 1532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GlobalConfigRefreshActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GlobalConfigRefreshActorState(); static_cast<GlobalConfigRefreshActor*>(this)->destroy(); return 0; }
															#line 1536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GlobalConfigRefreshActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GlobalConfigRefreshActorState();
		static_cast<GlobalConfigRefreshActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& tmpCachedData,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(tmpCachedData, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && tmpCachedData,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(tmpCachedData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigRefreshActor*>(this)->ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigRefreshActor*>(this)->ActorCallback< GlobalConfigRefreshActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GlobalConfigRefreshActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Version* cachedVersion;
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	RangeResult* cachedData;
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Optional<Value>> globalConfigVersionFuture;
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<RangeResult> tmpCachedDataFuture;
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<Value> globalConfigVersion;
															#line 1720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via globalConfigRefresh()
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigRefreshActor final : public Actor<Void>, public ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >, public ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >, public ActorCallback< GlobalConfigRefreshActor, 2, Void >, public FastAllocated<GlobalConfigRefreshActor>, public GlobalConfigRefreshActorState<GlobalConfigRefreshActor> {
															#line 1725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GlobalConfigRefreshActor>::operator new;
	using FastAllocated<GlobalConfigRefreshActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9954786865673496576UL, 2880703884710795008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >;
friend struct ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >;
friend struct ActorCallback< GlobalConfigRefreshActor, 2, Void >;
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigRefreshActor(GrvProxyData* const& grvProxyData,Version* const& cachedVersion,RangeResult* const& cachedData) 
															#line 1744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GlobalConfigRefreshActorState<GlobalConfigRefreshActor>(grvProxyData, cachedVersion, cachedData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10827479308140659200UL, 8791014497271066624UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("globalConfigRefresh");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GlobalConfigRefreshActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> globalConfigRefresh( GrvProxyData* const& grvProxyData, Version* const& cachedVersion, RangeResult* const& cachedData ) {
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GlobalConfigRefreshActor(grvProxyData, cachedVersion, cachedData));
															#line 1779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 355 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Handle common GlobalConfig transactions on the server side, because not all
// clients are allowed to read system keys. Eventually, this could become its
// own role.
															#line 1787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via globalConfigRequestServer()
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GlobalConfigRequestServerActor>
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigRequestServerActorState {
															#line 1794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigRequestServerActorState(GrvProxyData* const& grvProxyData,GrvProxyInterface const& grvProxy) 
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : grvProxyData(grvProxyData),
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   grvProxy(grvProxy),
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   actors(false),
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   refreshFuture(),
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   cachedVersion(0),
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   cachedData()
															#line 1811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("globalConfigRequestServer", reinterpret_cast<unsigned long>(this));

	}
	~GlobalConfigRequestServerActorState() 
	{
		fdb_probe_actor_destroy("globalConfigRequestServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			refreshFuture = timeout(globalConfigRefresh(grvProxyData, &cachedVersion, &cachedData), SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_TIMEOUT, Void()) && delay(SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_INTERVAL);
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(timeout(globalConfigMigrate(grvProxyData), SERVER_KNOBS->GLOBAL_CONFIG_MIGRATE_TIMEOUT));
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state = 1;
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRequestServerActor, 0, Void >*>(static_cast<GlobalConfigRequestServerActor*>(this)));
															#line 1835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GlobalConfigRequestServerActorState();
		static_cast<GlobalConfigRequestServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		;
															#line 1858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		;
															#line 1867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigRequestServerActor*>(this)->ActorCallback< GlobalConfigRequestServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GlobalConfigRequestServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		auto __when_expr_1 = grvProxy.refreshGlobalConfig.getFuture();
															#line 1958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<GlobalConfigRefreshRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<GlobalConfigRefreshRequest>>::value, "invalid type");
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.pop(), loopDepth); };
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = refreshFuture;
															#line 1966 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = actors.getResult();
															#line 1970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when3(__when_expr_3.get(), loopDepth); };
		static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state = 2;
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >*>(static_cast<GlobalConfigRequestServerActor*>(this)));
															#line 389 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRequestServerActor, 2, Void >*>(static_cast<GlobalConfigRequestServerActor*>(this)));
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRequestServerActor, 3, Void >*>(static_cast<GlobalConfigRequestServerActor*>(this)));
															#line 1979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GlobalConfigRefreshRequest const& refresh,int loopDepth) 
	{
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (refresh.lastKnown <= cachedVersion)
															#line 1994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			refresh.reply.send(GlobalConfigRefreshReply{ cachedData.arena(), cachedVersion, cachedData });
															#line 1998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			refresh.reply.sendError(future_version());
															#line 2004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GlobalConfigRefreshRequest && refresh,int loopDepth) 
	{
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (refresh.lastKnown <= cachedVersion)
															#line 2014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			refresh.reply.send(GlobalConfigRefreshReply{ cachedData.arena(), cachedVersion, cachedData });
															#line 2018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			refresh.reply.sendError(future_version());
															#line 2024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		refreshFuture = timeout(globalConfigRefresh(grvProxyData, &cachedVersion, &cachedData), SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_TIMEOUT, Void()) && delay(SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_INTERVAL);
															#line 2034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		refreshFuture = timeout(globalConfigRefresh(grvProxyData, &cachedVersion, &cachedData), SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_TIMEOUT, Void()) && delay(SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_INTERVAL);
															#line 2043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		ASSERT(false);
															#line 2052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		ASSERT(false);
															#line 2061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigRequestServerActor*>(this)->ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >::remove();
		static_cast<GlobalConfigRequestServerActor*>(this)->ActorCallback< GlobalConfigRequestServerActor, 2, Void >::remove();
		static_cast<GlobalConfigRequestServerActor*>(this)->ActorCallback< GlobalConfigRequestServerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >*,GlobalConfigRefreshRequest const& value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >*,GlobalConfigRefreshRequest && value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GlobalConfigRequestServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GlobalConfigRequestServerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface grvProxy;
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	ActorCollection actors;
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> refreshFuture;
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Version cachedVersion;
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	RangeResult cachedData;
															#line 2257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via globalConfigRequestServer()
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigRequestServerActor final : public Actor<Void>, public ActorCallback< GlobalConfigRequestServerActor, 0, Void >, public ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >, public ActorCallback< GlobalConfigRequestServerActor, 2, Void >, public ActorCallback< GlobalConfigRequestServerActor, 3, Void >, public FastAllocated<GlobalConfigRequestServerActor>, public GlobalConfigRequestServerActorState<GlobalConfigRequestServerActor> {
															#line 2262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GlobalConfigRequestServerActor>::operator new;
	using FastAllocated<GlobalConfigRequestServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8394424975981324288UL, 13933642361285330176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GlobalConfigRequestServerActor, 0, Void >;
friend struct ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >;
friend struct ActorCallback< GlobalConfigRequestServerActor, 2, Void >;
friend struct ActorCallback< GlobalConfigRequestServerActor, 3, Void >;
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigRequestServerActor(GrvProxyData* const& grvProxyData,GrvProxyInterface const& grvProxy) 
															#line 2282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GlobalConfigRequestServerActorState<GlobalConfigRequestServerActor>(grvProxyData, grvProxy),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15730633037479306240UL, 7934117556835500544UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("globalConfigRequestServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GlobalConfigRequestServerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> globalConfigRequestServer( GrvProxyData* const& grvProxyData, GrvProxyInterface const& grvProxy ) {
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GlobalConfigRequestServerActor(grvProxyData, grvProxy));
															#line 2316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 401 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Get transaction rate info from RateKeeper.
															#line 2322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via getRate()
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GetRateActor>
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GetRateActorState {
															#line 2329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetRateActorState(UID const& myID,Reference<AsyncVar<ServerDBInfo> const> const& db,int64_t* const& inTransactionCount,int64_t* const& inBatchTransactionCount,GrvTransactionRateInfo* const& transactionRateInfo,GrvTransactionRateInfo* const& batchTransactionRateInfo,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply,TransactionTagMap<uint64_t>* const& transactionTagCounter,PrioritizedTransactionTagMap<ClientTagThrottleLimits>* const& clientThrottledTags,GrvProxyStats* const& stats,GrvProxyData* const& proxyData) 
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : myID(myID),
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   db(db),
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   inTransactionCount(inTransactionCount),
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   inBatchTransactionCount(inBatchTransactionCount),
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   transactionRateInfo(transactionRateInfo),
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchTransactionRateInfo(batchTransactionRateInfo),
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   healthMetricsReply(healthMetricsReply),
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   detailedHealthMetricsReply(detailedHealthMetricsReply),
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   transactionTagCounter(transactionTagCounter),
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   clientThrottledTags(clientThrottledTags),
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   stats(stats),
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   proxyData(proxyData),
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   nextRequestTimer(Never()),
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   leaseTimeout(Never()),
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   reply(Never()),
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   lastDetailedReply(0.0),
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   expectingDetailedReply(false)
															#line 2368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("getRate", reinterpret_cast<unsigned long>(this));

	}
	~GetRateActorState() 
	{
		fdb_probe_actor_destroy("getRate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (db->get().ratekeeper.present())
															#line 2383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 423 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				nextRequestTimer = Void();
															#line 2387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 2391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRateActorState();
		static_cast<GetRateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GetRateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = nextRequestTimer;
															#line 2427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<GetRateInfoReply> __when_expr_2 = reply;
															#line 2431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = leaseTimeout;
															#line 2435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
		static_cast<GetRateActor*>(this)->actor_wait_state = 1;
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRateActor, 0, Void >*>(static_cast<GetRateActor*>(this)));
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRateActor, 1, Void >*>(static_cast<GetRateActor*>(this)));
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRateActor, 2, GetRateInfoReply >*>(static_cast<GetRateActor*>(this)));
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRateActor, 3, Void >*>(static_cast<GetRateActor*>(this)));
															#line 2446 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 2461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperChanged", myID).detail("RKID", db->get().ratekeeper.get().id());
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 2467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperDied", myID).log();
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply = Never();
															#line 2477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 2487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperChanged", myID).detail("RKID", db->get().ratekeeper.get().id());
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 2493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperDied", myID).log();
															#line 432 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply = Never();
															#line 2503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		bool detailed = now() - lastDetailedReply > SERVER_KNOBS->DETAILED_METRIC_UPDATE_RATE;
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		reply = brokenPromiseToNever( db->get().ratekeeper.get().getRateInfo.getReply(GetRateInfoRequest(myID, *inTransactionCount, *inBatchTransactionCount, proxyData->version, *transactionTagCounter, detailed)));
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionTagCounter->clear();
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		expectingDetailedReply = detailed;
															#line 2521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		bool detailed = now() - lastDetailedReply > SERVER_KNOBS->DETAILED_METRIC_UPDATE_RATE;
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		reply = brokenPromiseToNever( db->get().ratekeeper.get().getRateInfo.getReply(GetRateInfoRequest(myID, *inTransactionCount, *inBatchTransactionCount, proxyData->version, *transactionTagCounter, detailed)));
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionTagCounter->clear();
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		expectingDetailedReply = detailed;
															#line 2538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetRateInfoReply const& rep,int loopDepth) 
	{
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		reply = Never();
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionRateInfo->setRate(rep.transactionRate);
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionRateInfo->setRate(rep.batchTransactionRate);
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		stats->transactionRateAllowed = rep.transactionRate;
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		stats->batchTransactionRateAllowed = rep.batchTransactionRate;
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		++stats->updatesFromRatekeeper;
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		leaseTimeout = delay(rep.leaseDuration);
															#line 461 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = delayJittered(rep.leaseDuration / 2);
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		healthMetricsReply->update(rep.healthMetrics, expectingDetailedReply, true);
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (expectingDetailedReply)
															#line 2565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 464 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			detailedHealthMetricsReply->update(rep.healthMetrics, true, true);
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			lastDetailedReply = now();
															#line 2571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (rep.clientThrottledTags.present())
															#line 2575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 471 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			*clientThrottledTags = std::move(rep.clientThrottledTags.get());
															#line 2579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (rep.proxyThrottledTags.present())
															#line 2583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			proxyData->tagThrottler.updateRates(rep.proxyThrottledTags.get());
															#line 2587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetRateInfoReply && rep,int loopDepth) 
	{
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		reply = Never();
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionRateInfo->setRate(rep.transactionRate);
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionRateInfo->setRate(rep.batchTransactionRate);
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		stats->transactionRateAllowed = rep.transactionRate;
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		stats->batchTransactionRateAllowed = rep.batchTransactionRate;
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		++stats->updatesFromRatekeeper;
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		leaseTimeout = delay(rep.leaseDuration);
															#line 461 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = delayJittered(rep.leaseDuration / 2);
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		healthMetricsReply->update(rep.healthMetrics, expectingDetailedReply, true);
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (expectingDetailedReply)
															#line 2615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 464 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			detailedHealthMetricsReply->update(rep.healthMetrics, true, true);
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			lastDetailedReply = now();
															#line 2621 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (rep.clientThrottledTags.present())
															#line 2625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 471 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			*clientThrottledTags = std::move(rep.clientThrottledTags.get());
															#line 2629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (rep.proxyThrottledTags.present())
															#line 2633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			proxyData->tagThrottler.updateRates(rep.proxyThrottledTags.get());
															#line 2637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void const& _,int loopDepth) 
	{
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionRateInfo->disable();
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionRateInfo->disable();
															#line 480 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		++stats->leaseTimeouts;
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		TraceEvent(SevWarn, "GrvProxyRateLeaseExpired", myID).suppressFor(5.0);
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		leaseTimeout = Never();
															#line 2655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void && _,int loopDepth) 
	{
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionRateInfo->disable();
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionRateInfo->disable();
															#line 480 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		++stats->leaseTimeouts;
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		TraceEvent(SevWarn, "GrvProxyRateLeaseExpired", myID).suppressFor(5.0);
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		leaseTimeout = Never();
															#line 2672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRateActor*>(this)->actor_wait_state > 0) static_cast<GetRateActor*>(this)->actor_wait_state = 0;
		static_cast<GetRateActor*>(this)->ActorCallback< GetRateActor, 0, Void >::remove();
		static_cast<GetRateActor*>(this)->ActorCallback< GetRateActor, 1, Void >::remove();
		static_cast<GetRateActor*>(this)->ActorCallback< GetRateActor, 2, GetRateInfoReply >::remove();
		static_cast<GetRateActor*>(this)->ActorCallback< GetRateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 2, GetRateInfoReply >*,GetRateInfoReply const& value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 2, GetRateInfoReply >*,GetRateInfoReply && value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRateActor, 2, GetRateInfoReply >*,Error err) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetRateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	UID myID;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t* inTransactionCount;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t* inBatchTransactionCount;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvTransactionRateInfo* transactionRateInfo;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvTransactionRateInfo* batchTransactionRateInfo;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* healthMetricsReply;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* detailedHealthMetricsReply;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	TransactionTagMap<uint64_t>* transactionTagCounter;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PrioritizedTransactionTagMap<ClientTagThrottleLimits>* clientThrottledTags;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyStats* stats;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* proxyData;
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> nextRequestTimer;
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> leaseTimeout;
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<GetRateInfoReply> reply;
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double lastDetailedReply;
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	bool expectingDetailedReply;
															#line 2948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via getRate()
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GetRateActor final : public Actor<Void>, public ActorCallback< GetRateActor, 0, Void >, public ActorCallback< GetRateActor, 1, Void >, public ActorCallback< GetRateActor, 2, GetRateInfoReply >, public ActorCallback< GetRateActor, 3, Void >, public FastAllocated<GetRateActor>, public GetRateActorState<GetRateActor> {
															#line 2953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GetRateActor>::operator new;
	using FastAllocated<GetRateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3323917690499416576UL, 14393102557001045504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRateActor, 0, Void >;
friend struct ActorCallback< GetRateActor, 1, Void >;
friend struct ActorCallback< GetRateActor, 2, GetRateInfoReply >;
friend struct ActorCallback< GetRateActor, 3, Void >;
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetRateActor(UID const& myID,Reference<AsyncVar<ServerDBInfo> const> const& db,int64_t* const& inTransactionCount,int64_t* const& inBatchTransactionCount,GrvTransactionRateInfo* const& transactionRateInfo,GrvTransactionRateInfo* const& batchTransactionRateInfo,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply,TransactionTagMap<uint64_t>* const& transactionTagCounter,PrioritizedTransactionTagMap<ClientTagThrottleLimits>* const& clientThrottledTags,GrvProxyStats* const& stats,GrvProxyData* const& proxyData) 
															#line 2973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GetRateActorState<GetRateActor>(myID, db, inTransactionCount, inBatchTransactionCount, transactionRateInfo, batchTransactionRateInfo, healthMetricsReply, detailedHealthMetricsReply, transactionTagCounter, clientThrottledTags, stats, proxyData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3946064217190820608UL, 8787252396757706496UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRateActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> getRate( UID const& myID, Reference<AsyncVar<ServerDBInfo> const> const& db, int64_t* const& inTransactionCount, int64_t* const& inBatchTransactionCount, GrvTransactionRateInfo* const& transactionRateInfo, GrvTransactionRateInfo* const& batchTransactionRateInfo, GetHealthMetricsReply* const& healthMetricsReply, GetHealthMetricsReply* const& detailedHealthMetricsReply, TransactionTagMap<uint64_t>* const& transactionTagCounter, PrioritizedTransactionTagMap<ClientTagThrottleLimits>* const& clientThrottledTags, GrvProxyStats* const& stats, GrvProxyData* const& proxyData ) {
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GetRateActor(myID, db, inTransactionCount, inBatchTransactionCount, transactionRateInfo, batchTransactionRateInfo, healthMetricsReply, detailedHealthMetricsReply, transactionTagCounter, clientThrottledTags, stats, proxyData));
															#line 3006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 487 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Respond with an error to the GetReadVersion request when the GRV limit is hit.
void proxyGRVThresholdExceeded(const GetReadVersionRequest* req, GrvProxyStats* stats) {
	++stats->txnRequestErrors;
	req->reply.sendError(grv_proxy_memory_limit_exceeded());
	if (req->priority == TransactionPriority::IMMEDIATE) {
		TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "ProxyGRVThresholdExceededSystem")
		    .suppressFor(60);
	} else if (req->priority == TransactionPriority::DEFAULT) {
		TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "ProxyGRVThresholdExceededDefault")
		    .suppressFor(60);
	} else {
		TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "ProxyGRVThresholdExceededBatch")
		    .suppressFor(60);
	}
}

// Drop a GetReadVersion request from a queue, by responding an error to the request.
void dropRequestFromQueue(Deque<GetReadVersionRequest>* queue, GrvProxyStats* stats) {
	proxyGRVThresholdExceeded(&queue->front(), stats);
	++stats->txnRequestOut;
	queue->pop_front();
}

// Put a GetReadVersion request into the queue corresponding to its priority.
															#line 3035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via queueGetReadVersionRequests()
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class QueueGetReadVersionRequestsActor>
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class QueueGetReadVersionRequestsActorState {
															#line 3042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	QueueGetReadVersionRequestsActorState(Reference<AsyncVar<ServerDBInfo> const> const& db,Deque<GetReadVersionRequest>* const& systemQueue,Deque<GetReadVersionRequest>* const& defaultQueue,Deque<GetReadVersionRequest>* const& batchQueue,FutureStream<GetReadVersionRequest> const& readVersionRequests,PromiseStream<Void> const& GRVTimer,double* const& lastGRVTime,double* const& GRVBatchTime,FutureStream<double> const& normalGRVLatency,GrvProxyStats* const& stats,GrvTransactionRateInfo* const& batchRateInfo,GrvProxyTagThrottler* const& tagThrottler) 
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : db(db),
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   systemQueue(systemQueue),
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   defaultQueue(defaultQueue),
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchQueue(batchQueue),
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   readVersionRequests(readVersionRequests),
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   GRVTimer(GRVTimer),
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   lastGRVTime(lastGRVTime),
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   GRVBatchTime(GRVBatchTime),
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   normalGRVLatency(normalGRVLatency),
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   stats(stats),
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchRateInfo(batchRateInfo),
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   tagThrottler(tagThrottler)
															#line 3071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this));

	}
	~QueueGetReadVersionRequestsActorState() 
	{
		fdb_probe_actor_destroy("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 524 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::operation) = TransactionLineage::Operation::GetConsistentReadVersion;
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 3088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~QueueGetReadVersionRequestsActorState();
		static_cast<QueueGetReadVersionRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		auto __when_expr_0 = readVersionRequests;
															#line 3118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetReadVersionRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetReadVersionRequest>>::value, "invalid type");
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<QueueGetReadVersionRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 615 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		auto __when_expr_1 = normalGRVLatency;
															#line 3126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<double>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<double>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
		static_cast<QueueGetReadVersionRequestsActor*>(this)->actor_wait_state = 1;
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >*>(static_cast<QueueGetReadVersionRequestsActor*>(this)));
															#line 615 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >*>(static_cast<QueueGetReadVersionRequestsActor*>(this)));
															#line 3134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetReadVersionRequest const& req,int loopDepth) 
	{
															#line 531 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		bool canBeQueued = true;
															#line 532 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (stats->txnRequestIn.getValue() - stats->txnRequestOut.getValue() > SERVER_KNOBS->START_TRANSACTION_MAX_QUEUE_SIZE || (g_network->isSimulated() && !g_simulator->speedUpSimulation && BUGGIFY_WITH_PROB(0.01)))
															#line 3151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority == TransactionPriority::BATCH)
															#line 3155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				canBeQueued = false;
															#line 3159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority == TransactionPriority::DEFAULT)
															#line 3165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 540 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue->empty())
															#line 3169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 541 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						dropRequestFromQueue(batchQueue, stats);
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						--stats->batchGRVQueueSize;
															#line 3175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						canBeQueued = false;
															#line 3181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
				}
				else
				{
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue->empty())
															#line 3188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						dropRequestFromQueue(batchQueue, stats);
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						--stats->batchGRVQueueSize;
															#line 3194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (!defaultQueue->empty())
															#line 3200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 551 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							dropRequestFromQueue(defaultQueue, stats);
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							--stats->defaultGRVQueueSize;
															#line 3206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
						else
						{
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							canBeQueued = false;
															#line 3212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
		}
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!canBeQueued)
															#line 3220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			proxyGRVThresholdExceeded(&req, stats);
															#line 3224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			stats->addRequest(req.transactionCount);
															#line 563 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.debugID.present())
															#line 3232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", req.debugID.get().first(), "GrvProxyServer.queueTransactionStartRequests.Before");
															#line 3236 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (systemQueue->empty() && defaultQueue->empty() && batchQueue->empty())
															#line 3240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				forwardPromise(GRVTimer, delayJittered(std::max(0.0, *GRVBatchTime - (now() - *lastGRVTime)), TaskPriority::ProxyGRVTimer));
															#line 3244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority >= TransactionPriority::IMMEDIATE)
															#line 3248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				++stats->txnRequestIn;
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->txnStartIn += req.transactionCount;
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->txnSystemPriorityStartIn += req.transactionCount;
															#line 578 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				++stats->systemGRVQueueSize;
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				systemQueue->push_back(req);
															#line 3260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority >= TransactionPriority::DEFAULT)
															#line 3266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (SERVER_KNOBS->ENFORCE_TAG_THROTTLING_ON_PROXIES && req.isTagged())
															#line 3270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->tagThrottlerGRVQueueSize;
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnTagThrottlerIn += req.transactionCount;
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						tagThrottler->addRequest(req);
															#line 3278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->txnRequestIn;
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnStartIn += req.transactionCount;
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnDefaultPriorityStartIn += req.transactionCount;
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->defaultGRVQueueSize;
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						defaultQueue->push_back(req);
															#line 3292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
				}
				else
				{
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					int64_t proxiesCount = std::max((int)db->get().client.grvProxies.size(), 1);
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (batchRateInfo->getRate() <= (1.0 / proxiesCount))
															#line 3301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						req.reply.sendError(batch_transaction_throttled());
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnThrottled += req.transactionCount;
															#line 3307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 599 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (SERVER_KNOBS->ENFORCE_TAG_THROTTLING_ON_PROXIES && req.isTagged())
															#line 3313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->tagThrottlerGRVQueueSize;
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnTagThrottlerIn += req.transactionCount;
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							tagThrottler->addRequest(req);
															#line 3321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
						else
						{
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->txnRequestIn;
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnStartIn += req.transactionCount;
															#line 606 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnBatchPriorityStartIn += req.transactionCount;
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->batchGRVQueueSize;
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							batchQueue->push_back(req);
															#line 3335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetReadVersionRequest && req,int loopDepth) 
	{
															#line 531 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		bool canBeQueued = true;
															#line 532 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (stats->txnRequestIn.getValue() - stats->txnRequestOut.getValue() > SERVER_KNOBS->START_TRANSACTION_MAX_QUEUE_SIZE || (g_network->isSimulated() && !g_simulator->speedUpSimulation && BUGGIFY_WITH_PROB(0.01)))
															#line 3351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority == TransactionPriority::BATCH)
															#line 3355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				canBeQueued = false;
															#line 3359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority == TransactionPriority::DEFAULT)
															#line 3365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 540 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue->empty())
															#line 3369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 541 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						dropRequestFromQueue(batchQueue, stats);
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						--stats->batchGRVQueueSize;
															#line 3375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						canBeQueued = false;
															#line 3381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
				}
				else
				{
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue->empty())
															#line 3388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						dropRequestFromQueue(batchQueue, stats);
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						--stats->batchGRVQueueSize;
															#line 3394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (!defaultQueue->empty())
															#line 3400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 551 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							dropRequestFromQueue(defaultQueue, stats);
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							--stats->defaultGRVQueueSize;
															#line 3406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
						else
						{
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							canBeQueued = false;
															#line 3412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
		}
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!canBeQueued)
															#line 3420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			proxyGRVThresholdExceeded(&req, stats);
															#line 3424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			stats->addRequest(req.transactionCount);
															#line 563 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.debugID.present())
															#line 3432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 564 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", req.debugID.get().first(), "GrvProxyServer.queueTransactionStartRequests.Before");
															#line 3436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (systemQueue->empty() && defaultQueue->empty() && batchQueue->empty())
															#line 3440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				forwardPromise(GRVTimer, delayJittered(std::max(0.0, *GRVBatchTime - (now() - *lastGRVTime)), TaskPriority::ProxyGRVTimer));
															#line 3444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority >= TransactionPriority::IMMEDIATE)
															#line 3448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				++stats->txnRequestIn;
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->txnStartIn += req.transactionCount;
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->txnSystemPriorityStartIn += req.transactionCount;
															#line 578 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				++stats->systemGRVQueueSize;
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				systemQueue->push_back(req);
															#line 3460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority >= TransactionPriority::DEFAULT)
															#line 3466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (SERVER_KNOBS->ENFORCE_TAG_THROTTLING_ON_PROXIES && req.isTagged())
															#line 3470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->tagThrottlerGRVQueueSize;
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnTagThrottlerIn += req.transactionCount;
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						tagThrottler->addRequest(req);
															#line 3478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->txnRequestIn;
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnStartIn += req.transactionCount;
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnDefaultPriorityStartIn += req.transactionCount;
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->defaultGRVQueueSize;
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						defaultQueue->push_back(req);
															#line 3492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
				}
				else
				{
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					int64_t proxiesCount = std::max((int)db->get().client.grvProxies.size(), 1);
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (batchRateInfo->getRate() <= (1.0 / proxiesCount))
															#line 3501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						req.reply.sendError(batch_transaction_throttled());
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnThrottled += req.transactionCount;
															#line 3507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 599 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (SERVER_KNOBS->ENFORCE_TAG_THROTTLING_ON_PROXIES && req.isTagged())
															#line 3513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->tagThrottlerGRVQueueSize;
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnTagThrottlerIn += req.transactionCount;
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							tagThrottler->addRequest(req);
															#line 3521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
						else
						{
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->txnRequestIn;
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnStartIn += req.transactionCount;
															#line 606 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnBatchPriorityStartIn += req.transactionCount;
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->batchGRVQueueSize;
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							batchQueue->push_back(req);
															#line 3535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(double const& reply_latency,int loopDepth) 
	{
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double target_latency = reply_latency * SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_LATENCY_FRACTION;
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*GRVBatchTime = std::max( SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_MIN, std::min(SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_MAX, target_latency * SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA + *GRVBatchTime * (1 - SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA)));
															#line 3551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(double && reply_latency,int loopDepth) 
	{
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double target_latency = reply_latency * SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_LATENCY_FRACTION;
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*GRVBatchTime = std::max( SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_MIN, std::min(SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_MAX, target_latency * SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA + *GRVBatchTime * (1 - SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA)));
															#line 3562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<QueueGetReadVersionRequestsActor*>(this)->actor_wait_state > 0) static_cast<QueueGetReadVersionRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<QueueGetReadVersionRequestsActor*>(this)->ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >::remove();
		static_cast<QueueGetReadVersionRequestsActor*>(this)->ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >::remove();

	}
	void a_callback_fire(ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >*,GetReadVersionRequest const& value) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >*,GetReadVersionRequest && value) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >*,double const& value) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >*,double && value) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >*,Error err) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest>* systemQueue;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest>* defaultQueue;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest>* batchQueue;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	FutureStream<GetReadVersionRequest> readVersionRequests;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<Void> GRVTimer;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double* lastGRVTime;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double* GRVBatchTime;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	FutureStream<double> normalGRVLatency;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyStats* stats;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvTransactionRateInfo* batchRateInfo;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyTagThrottler* tagThrottler;
															#line 3712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via queueGetReadVersionRequests()
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class QueueGetReadVersionRequestsActor final : public Actor<Void>, public ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >, public ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >, public FastAllocated<QueueGetReadVersionRequestsActor>, public QueueGetReadVersionRequestsActorState<QueueGetReadVersionRequestsActor> {
															#line 3717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<QueueGetReadVersionRequestsActor>::operator new;
	using FastAllocated<QueueGetReadVersionRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7826674072398249984UL, 14796349763608442368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >;
friend struct ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >;
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	QueueGetReadVersionRequestsActor(Reference<AsyncVar<ServerDBInfo> const> const& db,Deque<GetReadVersionRequest>* const& systemQueue,Deque<GetReadVersionRequest>* const& defaultQueue,Deque<GetReadVersionRequest>* const& batchQueue,FutureStream<GetReadVersionRequest> const& readVersionRequests,PromiseStream<Void> const& GRVTimer,double* const& lastGRVTime,double* const& GRVBatchTime,FutureStream<double> const& normalGRVLatency,GrvProxyStats* const& stats,GrvTransactionRateInfo* const& batchRateInfo,GrvProxyTagThrottler* const& tagThrottler) 
															#line 3735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   QueueGetReadVersionRequestsActorState<QueueGetReadVersionRequestsActor>(db, systemQueue, defaultQueue, batchQueue, readVersionRequests, GRVTimer, lastGRVTime, GRVBatchTime, normalGRVLatency, stats, batchRateInfo, tagThrottler),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16228072202774818048UL, 4568169853275226880UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("queueGetReadVersionRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> queueGetReadVersionRequests( Reference<AsyncVar<ServerDBInfo> const> const& db, Deque<GetReadVersionRequest>* const& systemQueue, Deque<GetReadVersionRequest>* const& defaultQueue, Deque<GetReadVersionRequest>* const& batchQueue, FutureStream<GetReadVersionRequest> const& readVersionRequests, PromiseStream<Void> const& GRVTimer, double* const& lastGRVTime, double* const& GRVBatchTime, FutureStream<double> const& normalGRVLatency, GrvProxyStats* const& stats, GrvTransactionRateInfo* const& batchRateInfo, GrvProxyTagThrottler* const& tagThrottler ) {
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new QueueGetReadVersionRequestsActor(db, systemQueue, defaultQueue, batchQueue, readVersionRequests, GRVTimer, lastGRVTime, GRVBatchTime, normalGRVLatency, stats, batchRateInfo, tagThrottler));
															#line 3768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 625 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 3773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via updateLastCommit()
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class UpdateLastCommitActor>
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class UpdateLastCommitActorState {
															#line 3780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	UpdateLastCommitActorState(GrvProxyData* const& self,Optional<UID> const& debugID = Optional<UID>()) 
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : self(self),
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   debugID(debugID),
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   confirmStart(now())
															#line 3791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("updateLastCommit", reinterpret_cast<unsigned long>(this));

	}
	~UpdateLastCommitActorState() 
	{
		fdb_probe_actor_destroy("updateLastCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			self->lastStartCommit = confirmStart;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			self->updateCommitRequests++;
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->logSystem->confirmEpochLive(debugID);
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<UpdateLastCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3812 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateLastCommitActor*>(this)->actor_wait_state = 1;
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateLastCommitActor, 0, Void >*>(static_cast<UpdateLastCommitActor*>(this)));
															#line 3817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateLastCommitActorState();
		static_cast<UpdateLastCommitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->updateCommitRequests--;
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->lastCommitLatency = now() - confirmStart;
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->lastCommitTime = std::max(self->lastCommitTime.get(), confirmStart);
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<UpdateLastCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLastCommitActorState(); static_cast<UpdateLastCommitActor*>(this)->destroy(); return 0; }
															#line 3846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<UpdateLastCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLastCommitActorState();
		static_cast<UpdateLastCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->updateCommitRequests--;
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->lastCommitLatency = now() - confirmStart;
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->lastCommitTime = std::max(self->lastCommitTime.get(), confirmStart);
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<UpdateLastCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLastCommitActorState(); static_cast<UpdateLastCommitActor*>(this)->destroy(); return 0; }
															#line 3864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<UpdateLastCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLastCommitActorState();
		static_cast<UpdateLastCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateLastCommitActor*>(this)->actor_wait_state > 0) static_cast<UpdateLastCommitActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLastCommitActor*>(this)->ActorCallback< UpdateLastCommitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLastCommitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateLastCommitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateLastCommitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* self;
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<UID> debugID;
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double confirmStart;
															#line 3953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via updateLastCommit()
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class UpdateLastCommitActor final : public Actor<Void>, public ActorCallback< UpdateLastCommitActor, 0, Void >, public FastAllocated<UpdateLastCommitActor>, public UpdateLastCommitActorState<UpdateLastCommitActor> {
															#line 3958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<UpdateLastCommitActor>::operator new;
	using FastAllocated<UpdateLastCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(914631019227582976UL, 9879438750253223424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateLastCommitActor, 0, Void >;
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	UpdateLastCommitActor(GrvProxyData* const& self,Optional<UID> const& debugID = Optional<UID>()) 
															#line 3975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateLastCommitActorState<UpdateLastCommitActor>(self, debugID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateLastCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6267630262008360960UL, 2835741678179808768UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateLastCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateLastCommit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateLastCommitActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> updateLastCommit( GrvProxyData* const& self, Optional<UID> const& debugID = Optional<UID>() ) {
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new UpdateLastCommitActor(self, debugID));
															#line 4008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 636 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 4013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via lastCommitUpdater()
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class LastCommitUpdaterActor>
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class LastCommitUpdaterActorState {
															#line 4020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	LastCommitUpdaterActorState(GrvProxyData* const& self,PromiseStream<Future<Void>> const& addActor) 
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : self(self),
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   addActor(addActor)
															#line 4029 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("lastCommitUpdater", reinterpret_cast<unsigned long>(this));

	}
	~LastCommitUpdaterActorState() 
	{
		fdb_probe_actor_destroy("lastCommitUpdater", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 4044 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LastCommitUpdaterActorState();
		static_cast<LastCommitUpdaterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 639 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double interval = std::max(SERVER_KNOBS->MIN_CONFIRM_INTERVAL, (SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION - self->lastCommitLatency) / 2.0);
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double elapsed = now() - self->lastStartCommit;
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (elapsed < interval)
															#line 4078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(interval + 0.0001 - elapsed);
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<LastCommitUpdaterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LastCommitUpdaterActor*>(this)->actor_wait_state = 1;
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LastCommitUpdaterActor, 0, Void >*>(static_cast<LastCommitUpdaterActor*>(this)));
															#line 4089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 646 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (self->updateCommitRequests < SERVER_KNOBS->MAX_COMMIT_UPDATES)
															#line 4096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				addActor.send(updateLastCommit(self));
															#line 4100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "TooManyLastCommitUpdates") .suppressFor(1.0);
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				self->lastStartCommit = now();
															#line 4108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LastCommitUpdaterActor*>(this)->actor_wait_state > 0) static_cast<LastCommitUpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<LastCommitUpdaterActor*>(this)->ActorCallback< LastCommitUpdaterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LastCommitUpdaterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LastCommitUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LastCommitUpdaterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LastCommitUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LastCommitUpdaterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LastCommitUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* self;
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 4212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via lastCommitUpdater()
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class LastCommitUpdaterActor final : public Actor<Void>, public ActorCallback< LastCommitUpdaterActor, 0, Void >, public FastAllocated<LastCommitUpdaterActor>, public LastCommitUpdaterActorState<LastCommitUpdaterActor> {
															#line 4217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<LastCommitUpdaterActor>::operator new;
	using FastAllocated<LastCommitUpdaterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16378800620607014400UL, 8450292641765966592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LastCommitUpdaterActor, 0, Void >;
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	LastCommitUpdaterActor(GrvProxyData* const& self,PromiseStream<Future<Void>> const& addActor) 
															#line 4234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   LastCommitUpdaterActorState<LastCommitUpdaterActor>(self, addActor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lastCommitUpdater", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5278625381336097792UL, 45007184844760832UL);
		ActorExecutionContextHelper __helper(static_cast<LastCommitUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lastCommitUpdater");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lastCommitUpdater", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LastCommitUpdaterActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> lastCommitUpdater( GrvProxyData* const& self, PromiseStream<Future<Void>> const& addActor ) {
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new LastCommitUpdaterActor(self, addActor));
															#line 4267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 656 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 4272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via getLiveCommittedVersion()
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GetLiveCommittedVersionActor>
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GetLiveCommittedVersionActorState {
															#line 4279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetLiveCommittedVersionActorState(std::vector<SpanContext> const& spanContexts,GrvProxyData* const& grvProxyData,uint32_t const& flags,Optional<UID> const& debugID,int const& transactionCount,int const& systemTransactionCount,int const& defaultPriTransactionCount,int const& batchPriTransactionCount) 
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : spanContexts(spanContexts),
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   grvProxyData(grvProxyData),
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   flags(flags),
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   debugID(debugID),
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   transactionCount(transactionCount),
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   systemTransactionCount(systemTransactionCount),
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   defaultPriTransactionCount(defaultPriTransactionCount),
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchPriTransactionCount(batchPriTransactionCount),
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   span("GP:getLiveCommittedVersion"_loc)
															#line 4302 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetLiveCommittedVersionActorState() 
	{
		fdb_probe_actor_destroy("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			for( const SpanContext& spanContext : spanContexts ) {
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				span.addLink(spanContext);
															#line 4319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			++grvProxyData->stats.txnStartBatch;
															#line 676 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvStart = now();
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			replyFromMasterFuture = Future<GetRawCommittedVersionReply>();
															#line 678 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			replyFromMasterFuture = grvProxyData->master.getLiveCommittedVersion.getReply( GetRawCommittedVersionRequest(span.context, debugID, grvProxyData->ssVersionVectorCache.getMaxVersion()), TaskPriority::GetLiveCommittedVersionReply);
															#line 682 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!SERVER_KNOBS->ALWAYS_CAUSAL_READ_RISKY && !(flags & GetReadVersionRequest::FLAG_CAUSAL_READ_RISKY))
															#line 4331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = transformError(updateLastCommit(grvProxyData, debugID), broken_promise(), tlog_failed());
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 1;
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLiveCommittedVersionActor, 0, Void >*>(static_cast<GetLiveCommittedVersionActor*>(this)));
															#line 4342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 684 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION > 0 && now() - SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION > grvProxyData->lastCommitTime.get())
															#line 4349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					StrictFuture<Void> __when_expr_1 = grvProxyData->lastCommitTime.whenAtLeast(now() - SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION);
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 2;
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetLiveCommittedVersionActor, 1, Void >*>(static_cast<GetLiveCommittedVersionActor*>(this)));
															#line 4360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont4(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLiveCommittedVersionActorState();
		static_cast<GetLiveCommittedVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvConfirmEpochLive = now();
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.grvConfirmEpochLiveDist->sampleSeconds(grvConfirmEpochLive - grvStart);
															#line 691 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (debugID.present())
															#line 4393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 692 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "GrvProxyServer.getLiveCommittedVersion.confirmEpochLive");
															#line 4397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<GetRawCommittedVersionReply> __when_expr_2 = transformError(replyFromMasterFuture, broken_promise(), master_failed());
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 3;
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >*>(static_cast<GetLiveCommittedVersionActor*>(this)));
															#line 4408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLiveCommittedVersionActor*>(this)->ActorCallback< GetLiveCommittedVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLiveCommittedVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLiveCommittedVersionActor*>(this)->ActorCallback< GetLiveCommittedVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetLiveCommittedVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(GetRawCommittedVersionReply const& repFromMaster,int loopDepth) 
	{
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->version = std::max(grvProxyData->version, repFromMaster.version);
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->minKnownCommittedVersion = std::max(grvProxyData->minKnownCommittedVersion, repFromMaster.minKnownCommittedVersion);
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 4601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->ssVersionVectorCache.applyDelta(repFromMaster.ssVersionVectorDelta);
															#line 4605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.grvGetCommittedVersionRpcDist->sampleSeconds(now() - grvConfirmEpochLive);
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		GetReadVersionReply rep;
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.version = repFromMaster.version;
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.locked = repFromMaster.locked;
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.metadataVersion = repFromMaster.metadataVersion;
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.processBusyTime = FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION * std::min((std::numeric_limits<int>::max() / FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION) - 1, grvProxyData->stats.getRecentRequests());
															#line 714 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.processBusyTime += FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION * (g_network->isSimulated() ? deterministicRandom()->random01() : g_network->networkInfo.metrics.lastRunLoopBusyness);
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (debugID.present())
															#line 4623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "GrvProxyServer.getLiveCommittedVersion.After");
															#line 4627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnStartOut += transactionCount;
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnSystemPriorityStartOut += systemTransactionCount;
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnDefaultPriorityStartOut += defaultPriTransactionCount;
															#line 726 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnBatchPriorityStartOut += batchPriTransactionCount;
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GetLiveCommittedVersionActor*>(this)->SAV<GetReadVersionReply>::futures) { (void)(rep); this->~GetLiveCommittedVersionActorState(); static_cast<GetLiveCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 4639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GetLiveCommittedVersionActor*>(this)->SAV< GetReadVersionReply >::value()) GetReadVersionReply(rep);
		this->~GetLiveCommittedVersionActorState();
		static_cast<GetLiveCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(GetRawCommittedVersionReply && repFromMaster,int loopDepth) 
	{
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->version = std::max(grvProxyData->version, repFromMaster.version);
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->minKnownCommittedVersion = std::max(grvProxyData->minKnownCommittedVersion, repFromMaster.minKnownCommittedVersion);
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 4655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->ssVersionVectorCache.applyDelta(repFromMaster.ssVersionVectorDelta);
															#line 4659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 705 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.grvGetCommittedVersionRpcDist->sampleSeconds(now() - grvConfirmEpochLive);
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		GetReadVersionReply rep;
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.version = repFromMaster.version;
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.locked = repFromMaster.locked;
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.metadataVersion = repFromMaster.metadataVersion;
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.processBusyTime = FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION * std::min((std::numeric_limits<int>::max() / FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION) - 1, grvProxyData->stats.getRecentRequests());
															#line 714 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.processBusyTime += FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION * (g_network->isSimulated() ? deterministicRandom()->random01() : g_network->networkInfo.metrics.lastRunLoopBusyness);
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (debugID.present())
															#line 4677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "GrvProxyServer.getLiveCommittedVersion.After");
															#line 4681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnStartOut += transactionCount;
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnSystemPriorityStartOut += systemTransactionCount;
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnDefaultPriorityStartOut += defaultPriTransactionCount;
															#line 726 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnBatchPriorityStartOut += batchPriTransactionCount;
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GetLiveCommittedVersionActor*>(this)->SAV<GetReadVersionReply>::futures) { (void)(rep); this->~GetLiveCommittedVersionActorState(); static_cast<GetLiveCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 4693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GetLiveCommittedVersionActor*>(this)->SAV< GetReadVersionReply >::value()) GetReadVersionReply(rep);
		this->~GetLiveCommittedVersionActorState();
		static_cast<GetLiveCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(GetRawCommittedVersionReply const& repFromMaster,int loopDepth) 
	{
		loopDepth = a_body1cont6(repFromMaster, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(GetRawCommittedVersionReply && repFromMaster,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(repFromMaster), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLiveCommittedVersionActor*>(this)->ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >*,GetRawCommittedVersionReply const& value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >*,GetRawCommittedVersionReply && value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	std::vector<SpanContext> spanContexts;
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	uint32_t flags;
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<UID> debugID;
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int transactionCount;
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int systemTransactionCount;
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int defaultPriTransactionCount;
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int batchPriTransactionCount;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Span span;
															#line 676 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double grvStart;
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<GetRawCommittedVersionReply> replyFromMasterFuture;
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double grvConfirmEpochLive;
															#line 4800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via getLiveCommittedVersion()
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GetLiveCommittedVersionActor final : public Actor<GetReadVersionReply>, public ActorCallback< GetLiveCommittedVersionActor, 0, Void >, public ActorCallback< GetLiveCommittedVersionActor, 1, Void >, public ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >, public FastAllocated<GetLiveCommittedVersionActor>, public GetLiveCommittedVersionActorState<GetLiveCommittedVersionActor> {
															#line 4805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GetLiveCommittedVersionActor>::operator new;
	using FastAllocated<GetLiveCommittedVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16153205486833141504UL, 5522359295069000960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<GetReadVersionReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLiveCommittedVersionActor, 0, Void >;
friend struct ActorCallback< GetLiveCommittedVersionActor, 1, Void >;
friend struct ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >;
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetLiveCommittedVersionActor(std::vector<SpanContext> const& spanContexts,GrvProxyData* const& grvProxyData,uint32_t const& flags,Optional<UID> const& debugID,int const& transactionCount,int const& systemTransactionCount,int const& defaultPriTransactionCount,int const& batchPriTransactionCount) 
															#line 4824 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<GetReadVersionReply>(),
		   GetLiveCommittedVersionActorState<GetLiveCommittedVersionActor>(spanContexts, grvProxyData, flags, debugID, transactionCount, systemTransactionCount, defaultPriTransactionCount, batchPriTransactionCount),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2565788491578482432UL, 13699237086852491520UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLiveCommittedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLiveCommittedVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetLiveCommittedVersionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<GetReadVersionReply> getLiveCommittedVersion( std::vector<SpanContext> const& spanContexts, GrvProxyData* const& grvProxyData, uint32_t const& flags, Optional<UID> const& debugID, int const& transactionCount, int const& systemTransactionCount, int const& defaultPriTransactionCount, int const& batchPriTransactionCount ) {
															#line 657 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<GetReadVersionReply>(new GetLiveCommittedVersionActor(spanContexts, grvProxyData, flags, debugID, transactionCount, systemTransactionCount, defaultPriTransactionCount, batchPriTransactionCount));
															#line 4859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 730 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Returns the current read version (or minimum known committed version if requested),
// to each request in the provided list. Also check if the request should be throttled.
// Update GRV statistics according to the request's priority.
															#line 4867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via sendGrvReplies()
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class SendGrvRepliesActor>
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class SendGrvRepliesActorState {
															#line 4874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	SendGrvRepliesActorState(Future<GetReadVersionReply> const& replyFuture,std::vector<GetReadVersionRequest> const& requests,GrvProxyData* const& grvProxyData,GrvProxyStats* const& stats,Version const& minKnownCommittedVersion,PrioritizedTransactionTagMap<ClientTagThrottleLimits> const& clientThrottledTags,int64_t const& midShardSize = 0) 
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : replyFuture(replyFuture),
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   requests(requests),
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   grvProxyData(grvProxyData),
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   stats(stats),
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   minKnownCommittedVersion(minKnownCommittedVersion),
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   clientThrottledTags(clientThrottledTags),
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   midShardSize(midShardSize)
															#line 4893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("sendGrvReplies", reinterpret_cast<unsigned long>(this));

	}
	~SendGrvRepliesActorState() 
	{
		fdb_probe_actor_destroy("sendGrvReplies", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 741 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<GetReadVersionReply> __when_expr_0 = replyFuture;
															#line 741 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<SendGrvRepliesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SendGrvRepliesActor*>(this)->actor_wait_state = 1;
															#line 741 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >*>(static_cast<SendGrvRepliesActor*>(this)));
															#line 4915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SendGrvRepliesActorState();
		static_cast<SendGrvRepliesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(GetReadVersionReply const& _reply,int loopDepth) 
	{
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		GetReadVersionReply reply = _reply;
															#line 743 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		Version replyVersion = reply.version;
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double end = g_network->timer();
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for( GetReadVersionRequest const& request : requests ) {
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			double duration = end - request.requestTime() - request.proxyTagThrottledDuration;
															#line 748 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority == TransactionPriority::BATCH)
															#line 4948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvBatchLatencySample.addMeasurement(duration);
															#line 4952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority == TransactionPriority::DEFAULT)
															#line 4956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvLatencySample.addMeasurement(duration);
															#line 4960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority >= TransactionPriority::DEFAULT)
															#line 4964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvLatencyBands.addMeasurement(duration);
															#line 4968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 760 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.flags & GetReadVersionRequest::FLAG_USE_MIN_KNOWN_COMMITTED_VERSION)
															#line 4972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				reply.version = minKnownCommittedVersion;
															#line 4976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				reply.version = replyVersion;
															#line 4982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 766 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.midShardSize = midShardSize;
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.tagThrottleInfo.clear();
															#line 768 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 4990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 769 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->ssVersionVectorCache.getDelta(request.maxVersion, reply.ssVersionVectorDelta);
															#line 770 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->versionVectorSizeOnGRVReply->addMeasurement(reply.ssVersionVectorDelta.size());
															#line 4996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.proxyId = grvProxyData->dbgid;
															#line 773 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.proxyTagThrottledDuration = request.proxyTagThrottledDuration;
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.isTagged())
															#line 5004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 776 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				auto& priorityThrottledTags = clientThrottledTags[request.priority];
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				for( auto tag : request.tags ) {
															#line 778 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					auto tagItr = priorityThrottledTags.find(tag.first);
															#line 779 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (tagItr != priorityThrottledTags.end())
															#line 5014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 780 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (tagItr->second.expiration > now())
															#line 5018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 781 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							if (tagItr->second.tpsRate == std::numeric_limits<double>::max())
															#line 5022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
							{
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								CODE_PROBE(true, "Auto TPS rate is unlimited");
															#line 5026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
							}
							else
							{
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								CODE_PROBE(true, "GRV proxy returning tag throttle");
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								reply.tagThrottleInfo[tag.first] = tagItr->second;
															#line 5034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
							}
						}
						else
						{
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							CODE_PROBE(true, "GRV proxy expiring tag throttle");
															#line 790 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							priorityThrottledTags.erase(tagItr);
															#line 5043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
															#line 796 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (stats->lastBatchQueueThrottled)
															#line 5050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (now() - stats->batchThrottleStartTime > CLIENT_KNOBS->GRV_SUSTAINED_THROTTLING_THRESHOLD)
															#line 5054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkBatchThrottled = true;
															#line 5058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 802 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (stats->lastDefaultQueueThrottled)
															#line 5063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (now() - stats->defaultThrottleStartTime > CLIENT_KNOBS->GRV_SUSTAINED_THROTTLING_THRESHOLD)
															#line 5067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 808 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkBatchThrottled = true;
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkDefaultThrottled = true;
															#line 5073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 812 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			request.reply.send(reply);
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			++stats->txnRequestOut;
															#line 5080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 816 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<SendGrvRepliesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendGrvRepliesActorState(); static_cast<SendGrvRepliesActor*>(this)->destroy(); return 0; }
															#line 5084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<SendGrvRepliesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendGrvRepliesActorState();
		static_cast<SendGrvRepliesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(GetReadVersionReply && _reply,int loopDepth) 
	{
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		GetReadVersionReply reply = _reply;
															#line 743 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		Version replyVersion = reply.version;
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double end = g_network->timer();
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for( GetReadVersionRequest const& request : requests ) {
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			double duration = end - request.requestTime() - request.proxyTagThrottledDuration;
															#line 748 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority == TransactionPriority::BATCH)
															#line 5106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvBatchLatencySample.addMeasurement(duration);
															#line 5110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority == TransactionPriority::DEFAULT)
															#line 5114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvLatencySample.addMeasurement(duration);
															#line 5118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority >= TransactionPriority::DEFAULT)
															#line 5122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvLatencyBands.addMeasurement(duration);
															#line 5126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 760 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.flags & GetReadVersionRequest::FLAG_USE_MIN_KNOWN_COMMITTED_VERSION)
															#line 5130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				reply.version = minKnownCommittedVersion;
															#line 5134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				reply.version = replyVersion;
															#line 5140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 766 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.midShardSize = midShardSize;
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.tagThrottleInfo.clear();
															#line 768 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 5148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 769 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->ssVersionVectorCache.getDelta(request.maxVersion, reply.ssVersionVectorDelta);
															#line 770 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->versionVectorSizeOnGRVReply->addMeasurement(reply.ssVersionVectorDelta.size());
															#line 5154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.proxyId = grvProxyData->dbgid;
															#line 773 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.proxyTagThrottledDuration = request.proxyTagThrottledDuration;
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.isTagged())
															#line 5162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 776 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				auto& priorityThrottledTags = clientThrottledTags[request.priority];
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				for( auto tag : request.tags ) {
															#line 778 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					auto tagItr = priorityThrottledTags.find(tag.first);
															#line 779 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (tagItr != priorityThrottledTags.end())
															#line 5172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 780 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (tagItr->second.expiration > now())
															#line 5176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 781 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							if (tagItr->second.tpsRate == std::numeric_limits<double>::max())
															#line 5180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
							{
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								CODE_PROBE(true, "Auto TPS rate is unlimited");
															#line 5184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
							}
							else
							{
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								CODE_PROBE(true, "GRV proxy returning tag throttle");
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								reply.tagThrottleInfo[tag.first] = tagItr->second;
															#line 5192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
							}
						}
						else
						{
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							CODE_PROBE(true, "GRV proxy expiring tag throttle");
															#line 790 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							priorityThrottledTags.erase(tagItr);
															#line 5201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
															#line 796 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (stats->lastBatchQueueThrottled)
															#line 5208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (now() - stats->batchThrottleStartTime > CLIENT_KNOBS->GRV_SUSTAINED_THROTTLING_THRESHOLD)
															#line 5212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkBatchThrottled = true;
															#line 5216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 802 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (stats->lastDefaultQueueThrottled)
															#line 5221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (now() - stats->defaultThrottleStartTime > CLIENT_KNOBS->GRV_SUSTAINED_THROTTLING_THRESHOLD)
															#line 5225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 808 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkBatchThrottled = true;
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkDefaultThrottled = true;
															#line 5231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 812 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			request.reply.send(reply);
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			++stats->txnRequestOut;
															#line 5238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 816 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<SendGrvRepliesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendGrvRepliesActorState(); static_cast<SendGrvRepliesActor*>(this)->destroy(); return 0; }
															#line 5242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<SendGrvRepliesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendGrvRepliesActorState();
		static_cast<SendGrvRepliesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(GetReadVersionReply const& _reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(_reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(GetReadVersionReply && _reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SendGrvRepliesActor*>(this)->actor_wait_state > 0) static_cast<SendGrvRepliesActor*>(this)->actor_wait_state = 0;
		static_cast<SendGrvRepliesActor*>(this)->ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >*,GetReadVersionReply const& value) 
	{
		fdb_probe_actor_enter("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendGrvRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >*,GetReadVersionReply && value) 
	{
		fdb_probe_actor_enter("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendGrvRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendGrvRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<GetReadVersionReply> replyFuture;
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	std::vector<GetReadVersionRequest> requests;
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyStats* stats;
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Version minKnownCommittedVersion;
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PrioritizedTransactionTagMap<ClientTagThrottleLimits> clientThrottledTags;
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t midShardSize;
															#line 5339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via sendGrvReplies()
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class SendGrvRepliesActor final : public Actor<Void>, public ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >, public FastAllocated<SendGrvRepliesActor>, public SendGrvRepliesActorState<SendGrvRepliesActor> {
															#line 5344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<SendGrvRepliesActor>::operator new;
	using FastAllocated<SendGrvRepliesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3828443350084619008UL, 13159052160542448640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >;
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	SendGrvRepliesActor(Future<GetReadVersionReply> const& replyFuture,std::vector<GetReadVersionRequest> const& requests,GrvProxyData* const& grvProxyData,GrvProxyStats* const& stats,Version const& minKnownCommittedVersion,PrioritizedTransactionTagMap<ClientTagThrottleLimits> const& clientThrottledTags,int64_t const& midShardSize = 0) 
															#line 5361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   SendGrvRepliesActorState<SendGrvRepliesActor>(replyFuture, requests, grvProxyData, stats, minKnownCommittedVersion, clientThrottledTags, midShardSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sendGrvReplies", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6621363967670553088UL, 9891954819986612480UL);
		ActorExecutionContextHelper __helper(static_cast<SendGrvRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sendGrvReplies");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sendGrvReplies", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> sendGrvReplies( Future<GetReadVersionReply> const& replyFuture, std::vector<GetReadVersionRequest> const& requests, GrvProxyData* const& grvProxyData, GrvProxyStats* const& stats, Version const& minKnownCommittedVersion, PrioritizedTransactionTagMap<ClientTagThrottleLimits> const& clientThrottledTags, int64_t const& midShardSize = 0 ) {
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new SendGrvRepliesActor(replyFuture, requests, grvProxyData, stats, minKnownCommittedVersion, clientThrottledTags, midShardSize));
															#line 5394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 818 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 5399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorDDMetricsChanges()
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class MonitorDDMetricsChangesActor>
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class MonitorDDMetricsChangesActorState {
															#line 5406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	MonitorDDMetricsChangesActorState(int64_t* const& midShardSize,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : midShardSize(midShardSize),
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   db(db),
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   nextRequestTimer(Never()),
															#line 821 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   nextReply(Never())
															#line 5419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this));

	}
	~MonitorDDMetricsChangesActorState() 
	{
		fdb_probe_actor_destroy("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 823 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (db->get().distributor.present())
															#line 5434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				nextRequestTimer = Void();
															#line 5438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 826 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 5442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorDDMetricsChangesActorState();
		static_cast<MonitorDDMetricsChangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<MonitorDDMetricsChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 840 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = nextRequestTimer;
															#line 5479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<GetDataDistributorMetricsReply> __when_expr_2 = nextReply;
															#line 5483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorDDMetricsChangesActor*>(this)->actor_wait_state = 1;
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorDDMetricsChangesActor, 0, Void >*>(static_cast<MonitorDDMetricsChangesActor*>(this)));
															#line 840 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorDDMetricsChangesActor, 1, Void >*>(static_cast<MonitorDDMetricsChangesActor*>(this)));
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >*>(static_cast<MonitorDDMetricsChangesActor*>(this)));
															#line 5492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 856 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("DDMidShardSizeUpdateFail").error(e);
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (e.code() != error_code_timed_out && e.code() != error_code_dd_not_found)
															#line 5516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 858 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 860 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = delay(CLIENT_KNOBS->MID_SHARD_SIZE_MAX_STALENESS);
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextReply = Never();
															#line 5526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().distributor.present())
															#line 5547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 831 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("DataDistributorChanged", db->get().id) .detail("DDID", db->get().distributor.get().id());
															#line 833 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 5553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("DataDistributorDied", db->get().id);
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 5561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextReply = Never();
															#line 5565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().distributor.present())
															#line 5574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 831 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("DataDistributorChanged", db->get().id) .detail("DDID", db->get().distributor.get().id());
															#line 833 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 5580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("DataDistributorDied", db->get().id);
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 5588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextReply = Never();
															#line 5592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().distributor.present())
															#line 5603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 843 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextReply = brokenPromiseToNever(db->get().distributor.get().dataDistributorMetrics.getReply( GetDataDistributorMetricsRequest(normalKeys, CLIENT_KNOBS->TOO_MANY, true)));
															#line 5607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextReply = Never();
															#line 5613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().distributor.present())
															#line 5625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 843 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextReply = brokenPromiseToNever(db->get().distributor.get().dataDistributorMetrics.getReply( GetDataDistributorMetricsRequest(normalKeys, CLIENT_KNOBS->TOO_MANY, true)));
															#line 5629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextReply = Never();
															#line 5635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetDataDistributorMetricsReply const& reply,int loopDepth) 
	{
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextReply = Never();
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		ASSERT(reply.midShardSize.present());
															#line 851 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*midShardSize = reply.midShardSize.get();
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = delay(CLIENT_KNOBS->MID_SHARD_SIZE_MAX_STALENESS);
															#line 5651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetDataDistributorMetricsReply && reply,int loopDepth) 
	{
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextReply = Never();
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		ASSERT(reply.midShardSize.present());
															#line 851 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*midShardSize = reply.midShardSize.get();
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = delay(CLIENT_KNOBS->MID_SHARD_SIZE_MAX_STALENESS);
															#line 5666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorDDMetricsChangesActor*>(this)->actor_wait_state > 0) static_cast<MonitorDDMetricsChangesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorDDMetricsChangesActor*>(this)->ActorCallback< MonitorDDMetricsChangesActor, 0, Void >::remove();
		static_cast<MonitorDDMetricsChangesActor*>(this)->ActorCallback< MonitorDDMetricsChangesActor, 1, Void >::remove();
		static_cast<MonitorDDMetricsChangesActor*>(this)->ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorDDMetricsChangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorDDMetricsChangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >*,GetDataDistributorMetricsReply const& value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >*,GetDataDistributorMetricsReply && value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t* midShardSize;
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> nextRequestTimer;
															#line 821 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<GetDataDistributorMetricsReply> nextReply;
															#line 5871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via monitorDDMetricsChanges()
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class MonitorDDMetricsChangesActor final : public Actor<Void>, public ActorCallback< MonitorDDMetricsChangesActor, 0, Void >, public ActorCallback< MonitorDDMetricsChangesActor, 1, Void >, public ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >, public FastAllocated<MonitorDDMetricsChangesActor>, public MonitorDDMetricsChangesActorState<MonitorDDMetricsChangesActor> {
															#line 5876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<MonitorDDMetricsChangesActor>::operator new;
	using FastAllocated<MonitorDDMetricsChangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14609664056956031744UL, 16494487752674409728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorDDMetricsChangesActor, 0, Void >;
friend struct ActorCallback< MonitorDDMetricsChangesActor, 1, Void >;
friend struct ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >;
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	MonitorDDMetricsChangesActor(int64_t* const& midShardSize,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 5895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorDDMetricsChangesActorState<MonitorDDMetricsChangesActor>(midShardSize, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16350006110712773376UL, 12950337145856341760UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorDDMetricsChanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorDDMetricsChangesActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> monitorDDMetricsChanges( int64_t* const& midShardSize, Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new MonitorDDMetricsChangesActor(midShardSize, db));
															#line 5928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 865 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 5933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via transactionStarter()
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class TransactionStarterActor>
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class TransactionStarterActorState {
															#line 5940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	TransactionStarterActorState(GrvProxyInterface const& proxy,Reference<AsyncVar<ServerDBInfo> const> const& db,PromiseStream<Future<Void>> const& addActor,GrvProxyData* const& grvProxyData,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply) 
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   db(db),
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   addActor(addActor),
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   grvProxyData(grvProxyData),
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   healthMetricsReply(healthMetricsReply),
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   detailedHealthMetricsReply(detailedHealthMetricsReply),
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   lastGRVTime(0),
															#line 873 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   GRVTimer(),
															#line 874 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   GRVBatchTime(SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_MIN),
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   transactionCount(0),
															#line 877 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchTransactionCount(0),
															#line 878 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   normalRateInfo(SERVER_KNOBS->START_TRANSACTION_RATE_WINDOW, SERVER_KNOBS->START_TRANSACTION_MAX_EMPTY_QUEUE_BUDGET, 10),
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchRateInfo(SERVER_KNOBS->START_TRANSACTION_RATE_WINDOW, SERVER_KNOBS->START_TRANSACTION_MAX_EMPTY_QUEUE_BUDGET, 0),
															#line 885 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   systemQueue(),
															#line 886 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   defaultQueue(),
															#line 887 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchQueue(),
															#line 889 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   transactionTagCounter(),
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   clientThrottledTags(),
															#line 892 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   normalGRVLatency(),
															#line 894 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   midShardSize(SERVER_KNOBS->MIN_SHARD_BYTES)
															#line 5985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("transactionStarter", reinterpret_cast<unsigned long>(this));

	}
	~TransactionStarterActorState() 
	{
		fdb_probe_actor_destroy("transactionStarter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 895 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::operation) = TransactionLineage::Operation::GetConsistentReadVersion;
															#line 897 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(monitorDDMetricsChanges(&midShardSize, db));
															#line 899 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(getRate(proxy.id(), db, &transactionCount, &batchTransactionCount, &normalRateInfo, &batchRateInfo, healthMetricsReply, detailedHealthMetricsReply, &transactionTagCounter, &clientThrottledTags, &grvProxyData->stats, grvProxyData));
															#line 911 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(queueGetReadVersionRequests(db, &systemQueue, &defaultQueue, &batchQueue, proxy.getConsistentReadVersion.getFuture(), GRVTimer, &lastGRVTime, &GRVBatchTime, normalGRVLatency.getFuture(), &grvProxyData->stats, &batchRateInfo, &grvProxyData->tagThrottler));
															#line 924 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 6008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TransactionStarterActorState();
		static_cast<TransactionStarterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		ASSERT(db->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS);
															#line 931 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		TraceEvent("GrvProxyReadyForTxnStarts", proxy.id());
															#line 933 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		;
															#line 6035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 924 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!(std::find(db->get().client.grvProxies.begin(), db->get().client.grvProxies.end(), proxy) == db->get().client.grvProxies.end()))
															#line 6051 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<TransactionStarterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TransactionStarterActor*>(this)->actor_wait_state = 1;
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TransactionStarterActor, 0, Void >*>(static_cast<TransactionStarterActor*>(this)));
															#line 6064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TransactionStarterActor*>(this)->actor_wait_state > 0) static_cast<TransactionStarterActor*>(this)->actor_wait_state = 0;
		static_cast<TransactionStarterActor*>(this)->ActorCallback< TransactionStarterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TransactionStarterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransactionStarterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TransactionStarterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		auto __when_expr_1 = GRVTimer.getFuture();
															#line 6180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<Void>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<Void>>::value, "invalid type");
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<TransactionStarterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.pop(), loopDepth); };
		static_cast<TransactionStarterActor*>(this)->actor_wait_state = 2;
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< TransactionStarterActor, 1, Void >*>(static_cast<TransactionStarterActor*>(this)));
															#line 6189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double t = now();
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double elapsed = now() - lastGRVTime;
															#line 938 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		lastGRVTime = t;
															#line 941 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (elapsed == 0)
															#line 6204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 942 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			elapsed = 1e-15;
															#line 6208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 945 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.update(grvProxyData->tagThrottler.releaseTransactions(elapsed, batchQueue, defaultQueue));
															#line 947 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		normalRateInfo.startReleaseWindow();
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchRateInfo.startReleaseWindow();
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.transactionLimit = normalRateInfo.getLimit();
															#line 951 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.batchTransactionLimit = batchRateInfo.getLimit();
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int transactionsStarted[2] = { 0, 0 };
															#line 954 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int systemTransactionsStarted[2] = { 0, 0 };
															#line 955 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int defaultPriTransactionsStarted[2] = { 0, 0 };
															#line 956 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchPriTransactionsStarted[2] = { 0, 0 };
															#line 958 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		std::vector<std::vector<GetReadVersionRequest>> start( 2);
															#line 961 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		Optional<UID> debugID;
															#line 963 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int requestsToStart = 0;
															#line 965 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		uint32_t defaultQueueSize = defaultQueue.size();
															#line 966 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		uint32_t batchQueueSize = batchQueue.size();
															#line 967 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for(;requestsToStart < SERVER_KNOBS->START_TRANSACTION_MAX_REQUESTS_TO_START;) {
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Deque<GetReadVersionRequest>* transactionQueue;
															#line 969 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!systemQueue.empty())
															#line 6244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 970 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				transactionQueue = &systemQueue;
															#line 6248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 971 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (!defaultQueue.empty())
															#line 6254 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					transactionQueue = &defaultQueue;
															#line 6258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
				else
				{
															#line 973 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue.empty())
															#line 6264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 974 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						transactionQueue = &batchQueue;
															#line 6268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
						break;
					}
				}
			}
															#line 979 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			auto& req = transactionQueue->front();
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			int tc = req.transactionCount;
															#line 982 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority < TransactionPriority::DEFAULT && !batchRateInfo.canStart(transactionsStarted[0] + transactionsStarted[1], tc))
															#line 6282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
				break;
			}
			else
			{
															#line 985 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority < TransactionPriority::IMMEDIATE && !normalRateInfo.canStart(transactionsStarted[0] + transactionsStarted[1], tc))
															#line 6290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
					break;
				}
			}
															#line 990 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.debugID.present())
															#line 6297 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (!debugID.present())
															#line 6301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 992 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					debugID = nondeterministicRandom()->randomUniqueID();
															#line 6305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 994 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				g_traceBatch.addAttach("TransactionAttachID", req.debugID.get().first(), debugID.get().first());
															#line 6309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			transactionsStarted[req.flags & 1] += tc;
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			double currentTime = g_network->timer();
															#line 999 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority >= TransactionPriority::IMMEDIATE)
															#line 6317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1000 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				systemTransactionsStarted[req.flags & 1] += tc;
															#line 1001 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				--grvProxyData->stats.systemGRVQueueSize;
															#line 6323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 1002 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority >= TransactionPriority::DEFAULT)
															#line 6329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 1003 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					defaultPriTransactionsStarted[req.flags & 1] += tc;
															#line 1004 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					grvProxyData->stats.defaultTxnGRVTimeInQueue.addMeasurement(currentTime - req.requestTime());
															#line 1005 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					--grvProxyData->stats.defaultGRVQueueSize;
															#line 6337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
				else
				{
															#line 1007 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					batchPriTransactionsStarted[req.flags & 1] += tc;
															#line 1008 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					grvProxyData->stats.batchTxnGRVTimeInQueue.addMeasurement(currentTime - req.requestTime());
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					--grvProxyData->stats.batchGRVQueueSize;
															#line 6347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			for( auto tag : req.tags ) {
															#line 1012 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				transactionTagCounter[tag.first] += tag.second;
															#line 6354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 1014 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			start[req.flags & 1].push_back(std::move(req));
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			static_assert(GetReadVersionRequest::FLAG_CAUSAL_READ_RISKY == 1, "Implementation dependent on flag value");
															#line 1016 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			transactionQueue->pop_front();
															#line 1017 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			requestsToStart++;
															#line 6364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1019 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!batchQueue.empty())
															#line 6368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1020 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!grvProxyData->stats.lastBatchQueueThrottled)
															#line 6372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1021 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.lastBatchQueueThrottled = true;
															#line 1022 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.batchThrottleStartTime = now();
															#line 6378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
		else
		{
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->stats.lastBatchQueueThrottled = false;
															#line 6385 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1027 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!defaultQueue.empty())
															#line 6389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!grvProxyData->stats.lastDefaultQueueThrottled)
															#line 6393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1029 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.lastDefaultQueueThrottled = true;
															#line 1030 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.defaultThrottleStartTime = now();
															#line 6399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
		else
		{
															#line 1033 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->stats.lastDefaultQueueThrottled = false;
															#line 6406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1036 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!systemQueue.empty() || !defaultQueue.empty() || !batchQueue.empty())
															#line 6410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1037 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			forwardPromise( GRVTimer, delayJittered(SERVER_KNOBS->START_TRANSACTION_BATCH_QUEUE_CHECK_INTERVAL, TaskPriority::ProxyGRVTimer));
															#line 6414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1054 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int systemTotalStarted = systemTransactionsStarted[0] + systemTransactionsStarted[1];
															#line 1055 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int normalTotalStarted = defaultPriTransactionsStarted[0] + defaultPriTransactionsStarted[1];
															#line 1056 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchTotalStarted = batchPriTransactionsStarted[0] + batchPriTransactionsStarted[1];
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionCount += transactionsStarted[0] + transactionsStarted[1];
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionCount += batchTotalStarted;
															#line 1061 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		normalRateInfo.endReleaseWindow( systemTotalStarted + normalTotalStarted, systemQueue.empty() && defaultQueue.empty(), elapsed);
															#line 1063 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchRateInfo.endReleaseWindow(systemTotalStarted + normalTotalStarted + batchTotalStarted, systemQueue.empty() && defaultQueue.empty() && batchQueue.empty(), elapsed);
															#line 1067 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (debugID.present())
															#line 6432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1068 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", debugID.get().first(), "GrvProxyServer.transactionStarter.AskLiveCommittedVersionFromMaster");
															#line 6436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1073 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int defaultGRVProcessed = 0;
															#line 1074 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchGRVProcessed = 0;
															#line 1075 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for(int i = 0;i < start.size();i++) {
															#line 1076 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (start[i].size())
															#line 6446 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1077 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				std::vector<SpanContext> spanContexts;
															#line 1078 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				spanContexts.reserve(start[i].size());
															#line 1079 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				for( const GetReadVersionRequest& request : start[i] ) {
															#line 1080 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					spanContexts.push_back(request.spanContext);
															#line 6456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 1083 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				Future<GetReadVersionReply> readVersionReply = getLiveCommittedVersion(spanContexts, grvProxyData, i, debugID, transactionsStarted[i], systemTransactionsStarted[i], defaultPriTransactionsStarted[i], batchPriTransactionsStarted[i]);
															#line 1091 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				addActor.send(sendGrvReplies(readVersionReply, start[i], grvProxyData, &grvProxyData->stats, grvProxyData->minKnownCommittedVersion, clientThrottledTags, midShardSize));
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (i == 0)
															#line 6464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 1101 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					addActor.send(timeReply(readVersionReply, normalGRVLatency));
															#line 6468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				defaultGRVProcessed += defaultPriTransactionsStarted[i];
															#line 1104 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				batchGRVProcessed += batchPriTransactionsStarted[i];
															#line 6474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
															#line 1108 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.percentageOfDefaultGRVQueueProcessed = defaultQueueSize ? (double)defaultGRVProcessed / defaultQueueSize : 1;
															#line 1110 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.percentageOfBatchGRVQueueProcessed = batchQueueSize ? (double)batchGRVProcessed / batchQueueSize : 1;
															#line 6481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double t = now();
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double elapsed = now() - lastGRVTime;
															#line 938 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		lastGRVTime = t;
															#line 941 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (elapsed == 0)
															#line 6496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 942 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			elapsed = 1e-15;
															#line 6500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 945 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.update(grvProxyData->tagThrottler.releaseTransactions(elapsed, batchQueue, defaultQueue));
															#line 947 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		normalRateInfo.startReleaseWindow();
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchRateInfo.startReleaseWindow();
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.transactionLimit = normalRateInfo.getLimit();
															#line 951 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.batchTransactionLimit = batchRateInfo.getLimit();
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int transactionsStarted[2] = { 0, 0 };
															#line 954 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int systemTransactionsStarted[2] = { 0, 0 };
															#line 955 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int defaultPriTransactionsStarted[2] = { 0, 0 };
															#line 956 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchPriTransactionsStarted[2] = { 0, 0 };
															#line 958 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		std::vector<std::vector<GetReadVersionRequest>> start( 2);
															#line 961 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		Optional<UID> debugID;
															#line 963 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int requestsToStart = 0;
															#line 965 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		uint32_t defaultQueueSize = defaultQueue.size();
															#line 966 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		uint32_t batchQueueSize = batchQueue.size();
															#line 967 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for(;requestsToStart < SERVER_KNOBS->START_TRANSACTION_MAX_REQUESTS_TO_START;) {
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Deque<GetReadVersionRequest>* transactionQueue;
															#line 969 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!systemQueue.empty())
															#line 6536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 970 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				transactionQueue = &systemQueue;
															#line 6540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 971 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (!defaultQueue.empty())
															#line 6546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					transactionQueue = &defaultQueue;
															#line 6550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
				else
				{
															#line 973 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue.empty())
															#line 6556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 974 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						transactionQueue = &batchQueue;
															#line 6560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
						break;
					}
				}
			}
															#line 979 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			auto& req = transactionQueue->front();
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			int tc = req.transactionCount;
															#line 982 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority < TransactionPriority::DEFAULT && !batchRateInfo.canStart(transactionsStarted[0] + transactionsStarted[1], tc))
															#line 6574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
				break;
			}
			else
			{
															#line 985 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority < TransactionPriority::IMMEDIATE && !normalRateInfo.canStart(transactionsStarted[0] + transactionsStarted[1], tc))
															#line 6582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
					break;
				}
			}
															#line 990 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.debugID.present())
															#line 6589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (!debugID.present())
															#line 6593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 992 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					debugID = nondeterministicRandom()->randomUniqueID();
															#line 6597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 994 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				g_traceBatch.addAttach("TransactionAttachID", req.debugID.get().first(), debugID.get().first());
															#line 6601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			transactionsStarted[req.flags & 1] += tc;
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			double currentTime = g_network->timer();
															#line 999 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority >= TransactionPriority::IMMEDIATE)
															#line 6609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1000 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				systemTransactionsStarted[req.flags & 1] += tc;
															#line 1001 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				--grvProxyData->stats.systemGRVQueueSize;
															#line 6615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 1002 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority >= TransactionPriority::DEFAULT)
															#line 6621 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 1003 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					defaultPriTransactionsStarted[req.flags & 1] += tc;
															#line 1004 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					grvProxyData->stats.defaultTxnGRVTimeInQueue.addMeasurement(currentTime - req.requestTime());
															#line 1005 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					--grvProxyData->stats.defaultGRVQueueSize;
															#line 6629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
				else
				{
															#line 1007 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					batchPriTransactionsStarted[req.flags & 1] += tc;
															#line 1008 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					grvProxyData->stats.batchTxnGRVTimeInQueue.addMeasurement(currentTime - req.requestTime());
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					--grvProxyData->stats.batchGRVQueueSize;
															#line 6639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 1011 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			for( auto tag : req.tags ) {
															#line 1012 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				transactionTagCounter[tag.first] += tag.second;
															#line 6646 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 1014 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			start[req.flags & 1].push_back(std::move(req));
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			static_assert(GetReadVersionRequest::FLAG_CAUSAL_READ_RISKY == 1, "Implementation dependent on flag value");
															#line 1016 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			transactionQueue->pop_front();
															#line 1017 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			requestsToStart++;
															#line 6656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1019 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!batchQueue.empty())
															#line 6660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1020 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!grvProxyData->stats.lastBatchQueueThrottled)
															#line 6664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1021 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.lastBatchQueueThrottled = true;
															#line 1022 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.batchThrottleStartTime = now();
															#line 6670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
		else
		{
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->stats.lastBatchQueueThrottled = false;
															#line 6677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1027 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!defaultQueue.empty())
															#line 6681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1028 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!grvProxyData->stats.lastDefaultQueueThrottled)
															#line 6685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1029 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.lastDefaultQueueThrottled = true;
															#line 1030 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.defaultThrottleStartTime = now();
															#line 6691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
		else
		{
															#line 1033 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->stats.lastDefaultQueueThrottled = false;
															#line 6698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1036 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!systemQueue.empty() || !defaultQueue.empty() || !batchQueue.empty())
															#line 6702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1037 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			forwardPromise( GRVTimer, delayJittered(SERVER_KNOBS->START_TRANSACTION_BATCH_QUEUE_CHECK_INTERVAL, TaskPriority::ProxyGRVTimer));
															#line 6706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1054 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int systemTotalStarted = systemTransactionsStarted[0] + systemTransactionsStarted[1];
															#line 1055 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int normalTotalStarted = defaultPriTransactionsStarted[0] + defaultPriTransactionsStarted[1];
															#line 1056 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchTotalStarted = batchPriTransactionsStarted[0] + batchPriTransactionsStarted[1];
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionCount += transactionsStarted[0] + transactionsStarted[1];
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionCount += batchTotalStarted;
															#line 1061 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		normalRateInfo.endReleaseWindow( systemTotalStarted + normalTotalStarted, systemQueue.empty() && defaultQueue.empty(), elapsed);
															#line 1063 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchRateInfo.endReleaseWindow(systemTotalStarted + normalTotalStarted + batchTotalStarted, systemQueue.empty() && defaultQueue.empty() && batchQueue.empty(), elapsed);
															#line 1067 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (debugID.present())
															#line 6724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1068 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", debugID.get().first(), "GrvProxyServer.transactionStarter.AskLiveCommittedVersionFromMaster");
															#line 6728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1073 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int defaultGRVProcessed = 0;
															#line 1074 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchGRVProcessed = 0;
															#line 1075 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for(int i = 0;i < start.size();i++) {
															#line 1076 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (start[i].size())
															#line 6738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1077 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				std::vector<SpanContext> spanContexts;
															#line 1078 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				spanContexts.reserve(start[i].size());
															#line 1079 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				for( const GetReadVersionRequest& request : start[i] ) {
															#line 1080 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					spanContexts.push_back(request.spanContext);
															#line 6748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 1083 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				Future<GetReadVersionReply> readVersionReply = getLiveCommittedVersion(spanContexts, grvProxyData, i, debugID, transactionsStarted[i], systemTransactionsStarted[i], defaultPriTransactionsStarted[i], batchPriTransactionsStarted[i]);
															#line 1091 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				addActor.send(sendGrvReplies(readVersionReply, start[i], grvProxyData, &grvProxyData->stats, grvProxyData->minKnownCommittedVersion, clientThrottledTags, midShardSize));
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (i == 0)
															#line 6756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 1101 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					addActor.send(timeReply(readVersionReply, normalGRVLatency));
															#line 6760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				defaultGRVProcessed += defaultPriTransactionsStarted[i];
															#line 1104 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				batchGRVProcessed += batchPriTransactionsStarted[i];
															#line 6766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
															#line 1108 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.percentageOfDefaultGRVQueueProcessed = defaultQueueSize ? (double)defaultGRVProcessed / defaultQueueSize : 1;
															#line 1110 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.percentageOfBatchGRVQueueProcessed = batchQueueSize ? (double)batchGRVProcessed / batchQueueSize : 1;
															#line 6773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TransactionStarterActor*>(this)->actor_wait_state > 0) static_cast<TransactionStarterActor*>(this)->actor_wait_state = 0;
		static_cast<TransactionStarterActor*>(this)->ActorSingleCallback< TransactionStarterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< TransactionStarterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< TransactionStarterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< TransactionStarterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface proxy;
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* healthMetricsReply;
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* detailedHealthMetricsReply;
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double lastGRVTime;
															#line 873 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<Void> GRVTimer;
															#line 874 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double GRVBatchTime;
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t transactionCount;
															#line 877 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t batchTransactionCount;
															#line 878 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvTransactionRateInfo normalRateInfo;
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvTransactionRateInfo batchRateInfo;
															#line 885 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest> systemQueue;
															#line 886 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest> defaultQueue;
															#line 887 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest> batchQueue;
															#line 889 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	TransactionTagMap<uint64_t> transactionTagCounter;
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PrioritizedTransactionTagMap<ClientTagThrottleLimits> clientThrottledTags;
															#line 892 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<double> normalGRVLatency;
															#line 894 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t midShardSize;
															#line 6893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via transactionStarter()
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class TransactionStarterActor final : public Actor<Void>, public ActorCallback< TransactionStarterActor, 0, Void >, public ActorSingleCallback< TransactionStarterActor, 1, Void >, public FastAllocated<TransactionStarterActor>, public TransactionStarterActorState<TransactionStarterActor> {
															#line 6898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<TransactionStarterActor>::operator new;
	using FastAllocated<TransactionStarterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8009002988159687936UL, 7128663861221672192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TransactionStarterActor, 0, Void >;
friend struct ActorSingleCallback< TransactionStarterActor, 1, Void >;
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	TransactionStarterActor(GrvProxyInterface const& proxy,Reference<AsyncVar<ServerDBInfo> const> const& db,PromiseStream<Future<Void>> const& addActor,GrvProxyData* const& grvProxyData,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply) 
															#line 6916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   TransactionStarterActorState<TransactionStarterActor>(proxy, db, addActor, grvProxyData, healthMetricsReply, detailedHealthMetricsReply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10700198538979324160UL, 3557432467917975808UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("transactionStarter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TransactionStarterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< TransactionStarterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> transactionStarter( GrvProxyInterface const& proxy, Reference<AsyncVar<ServerDBInfo> const> const& db, PromiseStream<Future<Void>> const& addActor, GrvProxyData* const& grvProxyData, GetHealthMetricsReply* const& healthMetricsReply, GetHealthMetricsReply* const& detailedHealthMetricsReply ) {
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new TransactionStarterActor(proxy, db, addActor, grvProxyData, healthMetricsReply, detailedHealthMetricsReply));
															#line 6950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 1114 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 6955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via grvProxyServerCore()
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GrvProxyServerCoreActor>
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GrvProxyServerCoreActorState {
															#line 6962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyServerCoreActorState(GrvProxyInterface const& proxy,MasterInterface const& master,LifetimeToken const& masterLifetime,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   master(master),
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   masterLifetime(masterLifetime),
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   db(db),
															#line 1119 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   grvProxyData(proxy.id(), master, proxy.getConsistentReadVersion, db),
															#line 1121 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   addActor(),
															#line 1122 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   onError(actorCollection(addActor.getFuture())),
															#line 1124 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   healthMetricsReply(),
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   detailedHealthMetricsReply()
															#line 6985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("grvProxyServerCore", reinterpret_cast<unsigned long>(this));

	}
	~GrvProxyServerCoreActorState() 
	{
		fdb_probe_actor_destroy("grvProxyServerCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1127 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(waitFailureServer(proxy.waitFailure.getFuture()));
															#line 1128 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(traceRole(Role::GRV_PROXY, proxy.id()));
															#line 1130 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("GrvProxyServerCore", proxy.id()) .detail("MasterId", master.id()) .detail("MasterLifetime", masterLifetime.toString()) .detail("RecoveryCount", db->get().recoveryCount);
															#line 1136 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 7006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GrvProxyServerCoreActorState();
		static_cast<GrvProxyServerCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1141 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		dbInfoChange = grvProxyData.db->onChange();
															#line 1142 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData.logSystem = ILogSystem::fromServerDBInfo(proxy.id(), grvProxyData.db->get(), false, addActor);
															#line 1144 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData.updateLatencyBandConfig(grvProxyData.db->get().latencyBandConfig);
															#line 1146 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		addActor.send(transactionStarter( proxy, grvProxyData.db, addActor, &grvProxyData, &healthMetricsReply, &detailedHealthMetricsReply));
															#line 1148 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		addActor.send(healthMetricsRequestServer(proxy, &healthMetricsReply, &detailedHealthMetricsReply));
															#line 1149 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		addActor.send(globalConfigRequestServer(&grvProxyData, proxy));
															#line 1151 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION > 0)
															#line 7041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(lastCommitUpdater(&grvProxyData, addActor));
															#line 7045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1155 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		;
															#line 7049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1136 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!(!(masterLifetime.isEqual(grvProxyData.db->get().masterLifetime) && grvProxyData.db->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS)))
															#line 7065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = grvProxyData.db->onChange();
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state = 1;
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GrvProxyServerCoreActor, 0, Void >*>(static_cast<GrvProxyServerCoreActor*>(this)));
															#line 7078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state > 0) static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state = 0;
		static_cast<GrvProxyServerCoreActor*>(this)->ActorCallback< GrvProxyServerCoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GrvProxyServerCoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1156 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = dbInfoChange;
															#line 1155 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 1166 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = onError;
															#line 7200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
		static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state = 2;
															#line 1156 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GrvProxyServerCoreActor, 1, Void >*>(static_cast<GrvProxyServerCoreActor*>(this)));
															#line 1166 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GrvProxyServerCoreActor, 2, Void >*>(static_cast<GrvProxyServerCoreActor*>(this)));
															#line 7207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1157 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		dbInfoChange = grvProxyData.db->onChange();
															#line 1159 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (masterLifetime.isEqual(grvProxyData.db->get().masterLifetime) && grvProxyData.db->get().recoveryState >= RecoveryState::RECOVERY_TRANSACTION)
															#line 7224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1161 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData.logSystem = ILogSystem::fromServerDBInfo(proxy.id(), grvProxyData.db->get(), false, addActor);
															#line 7228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1164 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData.updateLatencyBandConfig(grvProxyData.db->get().latencyBandConfig);
															#line 7232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1157 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		dbInfoChange = grvProxyData.db->onChange();
															#line 1159 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (masterLifetime.isEqual(grvProxyData.db->get().masterLifetime) && grvProxyData.db->get().recoveryState >= RecoveryState::RECOVERY_TRANSACTION)
															#line 7243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1161 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData.logSystem = ILogSystem::fromServerDBInfo(proxy.id(), grvProxyData.db->get(), false, addActor);
															#line 7247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1164 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData.updateLatencyBandConfig(grvProxyData.db->get().latencyBandConfig);
															#line 7251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state > 0) static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state = 0;
		static_cast<GrvProxyServerCoreActor*>(this)->ActorCallback< GrvProxyServerCoreActor, 1, Void >::remove();
		static_cast<GrvProxyServerCoreActor*>(this)->ActorCallback< GrvProxyServerCoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GrvProxyServerCoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GrvProxyServerCoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface proxy;
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	MasterInterface master;
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	LifetimeToken masterLifetime;
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1119 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData grvProxyData;
															#line 1121 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 1122 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> onError;
															#line 1124 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply healthMetricsReply;
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply detailedHealthMetricsReply;
															#line 1141 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> dbInfoChange;
															#line 7409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via grvProxyServerCore()
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GrvProxyServerCoreActor final : public Actor<Void>, public ActorCallback< GrvProxyServerCoreActor, 0, Void >, public ActorCallback< GrvProxyServerCoreActor, 1, Void >, public ActorCallback< GrvProxyServerCoreActor, 2, Void >, public FastAllocated<GrvProxyServerCoreActor>, public GrvProxyServerCoreActorState<GrvProxyServerCoreActor> {
															#line 7414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GrvProxyServerCoreActor>::operator new;
	using FastAllocated<GrvProxyServerCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9250782908098323456UL, 9712039773009802240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GrvProxyServerCoreActor, 0, Void >;
friend struct ActorCallback< GrvProxyServerCoreActor, 1, Void >;
friend struct ActorCallback< GrvProxyServerCoreActor, 2, Void >;
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyServerCoreActor(GrvProxyInterface const& proxy,MasterInterface const& master,LifetimeToken const& masterLifetime,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 7433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GrvProxyServerCoreActorState<GrvProxyServerCoreActor>(proxy, master, masterLifetime, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6046041477836266752UL, 214675386595290880UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("grvProxyServerCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GrvProxyServerCoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GrvProxyServerCoreActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> grvProxyServerCore( GrvProxyInterface const& proxy, MasterInterface const& master, LifetimeToken const& masterLifetime, Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GrvProxyServerCoreActor(proxy, master, masterLifetime, db));
															#line 7467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 1169 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 7472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via checkRemoved()
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class CheckRemovedActor>
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class CheckRemovedActorState {
															#line 7479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	CheckRemovedActorState(Reference<AsyncVar<ServerDBInfo> const> const& db,uint64_t const& recoveryCount,GrvProxyInterface const& myInterface) 
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : db(db),
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   recoveryCount(recoveryCount),
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   myInterface(myInterface)
															#line 7490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("checkRemoved", reinterpret_cast<unsigned long>(this));

	}
	~CheckRemovedActorState() 
	{
		fdb_probe_actor_destroy("checkRemoved", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1173 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 7505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckRemovedActorState();
		static_cast<CheckRemovedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().recoveryCount >= recoveryCount && std::find(db->get().client.grvProxies.begin(), db->get().client.grvProxies.end(), myInterface) == db->get().client.grvProxies.end())
															#line 7535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1177 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 7539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1179 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 1179 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<CheckRemovedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckRemovedActor*>(this)->actor_wait_state = 1;
															#line 1179 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckRemovedActor, 0, Void >*>(static_cast<CheckRemovedActor*>(this)));
															#line 7550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckRemovedActor*>(this)->actor_wait_state > 0) static_cast<CheckRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRemovedActor*>(this)->ActorCallback< CheckRemovedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRemovedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckRemovedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckRemovedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	uint64_t recoveryCount;
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface myInterface;
															#line 7648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via checkRemoved()
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class CheckRemovedActor final : public Actor<Void>, public ActorCallback< CheckRemovedActor, 0, Void >, public FastAllocated<CheckRemovedActor>, public CheckRemovedActorState<CheckRemovedActor> {
															#line 7653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<CheckRemovedActor>::operator new;
	using FastAllocated<CheckRemovedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1223928105225223936UL, 13007296679825793280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckRemovedActor, 0, Void >;
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	CheckRemovedActor(Reference<AsyncVar<ServerDBInfo> const> const& db,uint64_t const& recoveryCount,GrvProxyInterface const& myInterface) 
															#line 7670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   CheckRemovedActorState<CheckRemovedActor>(db, recoveryCount, myInterface),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15518436168711072512UL, 6662910151609573120UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkRemoved");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckRemovedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> checkRemoved( Reference<AsyncVar<ServerDBInfo> const> const& db, uint64_t const& recoveryCount, GrvProxyInterface const& myInterface ) {
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new CheckRemovedActor(db, recoveryCount, myInterface));
															#line 7703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 1182 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 7708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via grvProxyServer()
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GrvProxyServerActor>
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GrvProxyServerActorState {
															#line 7715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyServerActorState(GrvProxyInterface const& proxy,InitializeGrvProxyRequest const& req,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   req(req),
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   db(db)
															#line 7726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("grvProxyServer", reinterpret_cast<unsigned long>(this));

	}
	~GrvProxyServerActorState() 
	{
		fdb_probe_actor_destroy("grvProxyServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				core = grvProxyServerCore(proxy, req.master, req.masterLifetime, db);
															#line 1188 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = core || checkRemoved(db, req.recoveryCount, proxy);
															#line 1188 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (static_cast<GrvProxyServerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GrvProxyServerActor*>(this)->actor_wait_state = 1;
															#line 1188 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GrvProxyServerActor, 0, Void >*>(static_cast<GrvProxyServerActor*>(this)));
															#line 7751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GrvProxyServerActorState();
		static_cast<GrvProxyServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1202 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GrvProxyServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GrvProxyServerActorState(); static_cast<GrvProxyServerActor*>(this)->destroy(); return 0; }
															#line 7780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GrvProxyServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GrvProxyServerActorState();
		static_cast<GrvProxyServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1190 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("GrvProxyTerminated", proxy.id()).errorUnsuppressed(e);
															#line 1191 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			ASSERT(e.code() != error_code_broken_promise);
															#line 1193 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			CODE_PROBE(e.code() == error_code_master_failed, "GrvProxyServer master failed");
															#line 1194 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			CODE_PROBE(e.code() == error_code_tlog_failed, "GrvProxyServer tlog failed");
															#line 1195 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (e.code() != error_code_worker_removed && e.code() != error_code_tlog_stopped && e.code() != error_code_tlog_failed && e.code() != error_code_coordinators_changed && e.code() != error_code_coordinated_state_conflict && e.code() != error_code_new_coordinators_timed_out && e.code() != error_code_master_failed)
															#line 7801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1199 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 7805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GrvProxyServerActor*>(this)->actor_wait_state > 0) static_cast<GrvProxyServerActor*>(this)->actor_wait_state = 0;
		static_cast<GrvProxyServerActor*>(this)->ActorCallback< GrvProxyServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GrvProxyServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GrvProxyServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GrvProxyServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface proxy;
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	InitializeGrvProxyRequest req;
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> core;
															#line 7925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via grvProxyServer()
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GrvProxyServerActor final : public Actor<Void>, public ActorCallback< GrvProxyServerActor, 0, Void >, public FastAllocated<GrvProxyServerActor>, public GrvProxyServerActorState<GrvProxyServerActor> {
															#line 7930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GrvProxyServerActor>::operator new;
	using FastAllocated<GrvProxyServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17607870031197260800UL, 8472446375332268032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GrvProxyServerActor, 0, Void >;
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyServerActor(GrvProxyInterface const& proxy,InitializeGrvProxyRequest const& req,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 7947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GrvProxyServerActorState<GrvProxyServerActor>(proxy, req, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("grvProxyServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13905335545483414272UL, 8240318245689050112UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("grvProxyServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("grvProxyServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GrvProxyServerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> grvProxyServer( GrvProxyInterface const& proxy, InitializeGrvProxyRequest const& req, Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GrvProxyServerActor(proxy, req, db));
															#line 7980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 1204 "/Users/ec2-user/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
