#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
/*
 * ConsistencyScan.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/JSONDoc.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/json_spirit/json_spirit_value.h"
#include "fdbclient/json_spirit/json_spirit_writer_options.h"
#include "fdbclient/json_spirit/json_spirit_writer_template.h"
#include "fdbrpc/TenantInfo.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "flow/IRandom.h"
#include "flow/IndexedSet.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "fdbrpc/Smoother.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/TagThrottle.actor.h"
#include "fdbclient/DataDistributionConfig.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/StorageMetrics.actor.h"
#include "fdbserver/DataDistribution.actor.h"
#include "fdbserver/RatekeeperInterface.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/TesterInterface.actor.h"
#include "flow/DeterministicRandom.h"
#include "flow/Trace.h"
#include "fdbserver/QuietDatabase.h"
#include "flow/actorcompiler.h" // This must be the last #include.

#define DEBUG_SCAN_PROGRESS false

struct ConsistencyScanStats {
	CounterCollection cc;
	Future<Void> logger;

	Counter logicalBytesScanned;
	Counter replicatedBytesRead;
	Counter requests;
	Counter failedRequests;
	Counter scanLoops;
	Counter inconsistencies;
	Counter databasePollSuccesses;
	Counter databasePollErrors;

	bool waitingBetweenRounds = false;
	int targetRate = 0;

	explicit ConsistencyScanStats(UID id, double interval)
	  : cc("ConsistencyScanStats", id.toString()), logicalBytesScanned("LogicalBytesScanned", cc),
	    replicatedBytesRead("ReplicatedBytesRead", cc), requests("Requests", cc), failedRequests("FailedRequests", cc),
	    scanLoops("ScanLoops", cc), inconsistencies("Inconsistencies", cc),
	    databasePollSuccesses("DatabasePollSuccesses", cc), databasePollErrors("DatabasePollErrors", cc) {
		specialCounter(cc, "WaitingBetweenRounds", [this]() { return this->waitingBetweenRounds; });
		specialCounter(cc, "TargetRate", [this]() { return this->targetRate; });
		logger = cc.traceCounters("ConsistencyScanMetrics", id, interval, "ConsistencyScanMetrics");
	}
};

// State that is explicitly not persisted anywhere for this consistency scan. Includes things like caches of system
// information and stats for trace logs
struct ConsistencyScanMemoryState : public ReferenceCounted<ConsistencyScanMemoryState> {
	UID csId{};
	AsyncVar<int64_t> databaseSize = -1;
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
	ConsistencyScanStats stats;

	explicit ConsistencyScanMemoryState(Reference<AsyncVar<ServerDBInfo> const> dbInfo, UID csId)
	  : dbInfo(dbInfo), csId(csId), stats(csId, SERVER_KNOBS->WORKER_LOGGING_INTERVAL) {}
};

// TODO: test the test and write a canary key that the storage servers intentionally get wrong
// Get database KV bytes size from Status JSON at cluster.data.total_kv_size_bytes
															#line 95 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
namespace {
// This generated class is to be used only via pollDatabaseSize()
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class PollDatabaseSizeActor>
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class PollDatabaseSizeActorState {
															#line 102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	PollDatabaseSizeActorState(Reference<ConsistencyScanMemoryState> const& memState,double const& interval) 
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : memState(memState),
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   interval(interval)
															#line 111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
	{
		fdb_probe_actor_create("pollDatabaseSize", reinterpret_cast<unsigned long>(this));

	}
	~PollDatabaseSizeActorState() 
	{
		fdb_probe_actor_destroy("pollDatabaseSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PollDatabaseSizeActorState();
		static_cast<PollDatabaseSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		try {
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_1 = getWorkers(memState->dbInfo);
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 2;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >*>(static_cast<PollDatabaseSizeActor*>(this)));
															#line 173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (memState->dbInfo->get().distributor.present())
															#line 195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_0 = memState->dbInfo->onChange();
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 1;
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PollDatabaseSizeActor, 0, Void >*>(static_cast<PollDatabaseSizeActor*>(this)));
															#line 208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state > 0) static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 0;
		static_cast<PollDatabaseSizeActor*>(this)->ActorCallback< PollDatabaseSizeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PollDatabaseSizeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(5.0);
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 5;
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PollDatabaseSizeActor, 4, Void >*>(static_cast<PollDatabaseSizeActor*>(this)));
															#line 324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyScan_PollDBSizeError", memState->csId).error(e);
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			++memState->stats.databasePollErrors;
															#line 344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ddWorkerInterf = Optional<WorkerInterface>();
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (memState->dbInfo->get().distributor.present())
															#line 361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int i = 0;i < workers.size();i++) {
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (workers[i].interf.address() == memState->dbInfo->get().distributor.get().address())
															#line 367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					ddWorkerInterf = workers[i].interf;
															#line 371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					break;
				}
			}
		}
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		CODE_PROBE(ddWorkerInterf.present(), "Consistency Scan found DD worker");
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		CODE_PROBE(!ddWorkerInterf.present(), "Consistency Scan couldn't find DD worker");
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (ddWorkerInterf.present())
															#line 382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			++memState->stats.databasePollSuccesses;
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<TraceEventFields> __when_expr_2 = timeoutError( ddWorkerInterf.get().eventLogRequest.getReply(EventLogRequest("DDTrackerStats"_sr)), 5.0);
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 3;
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >*>(static_cast<PollDatabaseSizeActor*>(this)));
															#line 395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ddWorkerInterf = Optional<WorkerInterface>();
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (memState->dbInfo->get().distributor.present())
															#line 411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int i = 0;i < workers.size();i++) {
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (workers[i].interf.address() == memState->dbInfo->get().distributor.get().address())
															#line 417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					ddWorkerInterf = workers[i].interf;
															#line 421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					break;
				}
			}
		}
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		CODE_PROBE(ddWorkerInterf.present(), "Consistency Scan found DD worker");
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		CODE_PROBE(!ddWorkerInterf.present(), "Consistency Scan couldn't find DD worker");
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (ddWorkerInterf.present())
															#line 432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			++memState->stats.databasePollSuccesses;
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<TraceEventFields> __when_expr_2 = timeoutError( ddWorkerInterf.get().eventLogRequest.getReply(EventLogRequest("DDTrackerStats"_sr)), 5.0);
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 3;
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >*>(static_cast<PollDatabaseSizeActor*>(this)));
															#line 445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(workers, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state > 0) static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 0;
		static_cast<PollDatabaseSizeActor*>(this)->ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(TraceEventFields const& md,int loopDepth) 
	{
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->databaseSize.set(md.getInt64("TotalSizeBytes"));
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		CODE_PROBE(true, "Consistency Scan got DB size from DD Worker");
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyScan_DatabaseSize", memState->csId) .detail("EstimatedSize", memState->databaseSize.get());
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(interval);
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 4;
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PollDatabaseSizeActor, 3, Void >*>(static_cast<PollDatabaseSizeActor*>(this)));
															#line 553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(TraceEventFields && md,int loopDepth) 
	{
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->databaseSize.set(md.getInt64("TotalSizeBytes"));
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		CODE_PROBE(true, "Consistency Scan got DB size from DD Worker");
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyScan_DatabaseSize", memState->csId) .detail("EstimatedSize", memState->databaseSize.get());
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(interval);
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 4;
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PollDatabaseSizeActor, 3, Void >*>(static_cast<PollDatabaseSizeActor*>(this)));
															#line 575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(TraceEventFields const& md,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(md, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(TraceEventFields && md,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(md), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state > 0) static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 0;
		static_cast<PollDatabaseSizeActor*>(this)->ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >::remove();

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >*,TraceEventFields const& value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >*,TraceEventFields && value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >*,Error err) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state > 0) static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 0;
		static_cast<PollDatabaseSizeActor*>(this)->ActorCallback< PollDatabaseSizeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PollDatabaseSizeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state > 0) static_cast<PollDatabaseSizeActor*>(this)->actor_wait_state = 0;
		static_cast<PollDatabaseSizeActor*>(this)->ActorCallback< PollDatabaseSizeActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< PollDatabaseSizeActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< PollDatabaseSizeActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ConsistencyScanMemoryState> memState;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double interval;
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<WorkerInterface> ddWorkerInterf;
															#line 848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
};
// This generated class is to be used only via pollDatabaseSize()
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class PollDatabaseSizeActor final : public Actor<Void>, public ActorCallback< PollDatabaseSizeActor, 0, Void >, public ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >, public ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >, public ActorCallback< PollDatabaseSizeActor, 3, Void >, public ActorCallback< PollDatabaseSizeActor, 4, Void >, public FastAllocated<PollDatabaseSizeActor>, public PollDatabaseSizeActorState<PollDatabaseSizeActor> {
															#line 853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
	using FastAllocated<PollDatabaseSizeActor>::operator new;
	using FastAllocated<PollDatabaseSizeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7123857048645157632UL, 9619905028752850432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PollDatabaseSizeActor, 0, Void >;
friend struct ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >;
friend struct ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >;
friend struct ActorCallback< PollDatabaseSizeActor, 3, Void >;
friend struct ActorCallback< PollDatabaseSizeActor, 4, Void >;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	PollDatabaseSizeActor(Reference<ConsistencyScanMemoryState> const& memState,double const& interval) 
															#line 874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		 : Actor<Void>(),
		   PollDatabaseSizeActorState<PollDatabaseSizeActor>(memState, interval),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("pollDatabaseSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17215904904380674304UL, 9843564974192376576UL);
		ActorExecutionContextHelper __helper(static_cast<PollDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("pollDatabaseSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("pollDatabaseSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PollDatabaseSizeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PollDatabaseSizeActor, 1, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PollDatabaseSizeActor, 2, TraceEventFields >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PollDatabaseSizeActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< PollDatabaseSizeActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<Void> pollDatabaseSize( Reference<ConsistencyScanMemoryState> const& memState, double const& interval ) {
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<Void>(new PollDatabaseSizeActor(memState, interval));
															#line 911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
}

#line 142 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

															#line 916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
namespace {
// This generated class is to be used only via loadShardInterfaces()
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class LoadShardInterfacesActor>
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class LoadShardInterfacesActorState {
															#line 923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	LoadShardInterfacesActorState(Reference<ConsistencyScanMemoryState> const& memState,Reference<ReadYourWritesTransaction> const& tr,Future<RangeResult> const& readShardBoundaries,Database const& db) 
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : memState(memState),
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   tr(tr),
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   readShardBoundaries(readShardBoundaries),
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   db(db)
															#line 936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
	{
		fdb_probe_actor_create("loadShardInterfaces", reinterpret_cast<unsigned long>(this));

	}
	~LoadShardInterfacesActorState() 
	{
		fdb_probe_actor_destroy("loadShardInterfaces", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state = 1;
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadShardInterfacesActor, 0, RangeResult >*>(static_cast<LoadShardInterfacesActor*>(this)));
															#line 958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadShardInterfacesActorState();
		static_cast<LoadShardInterfacesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = readShardBoundaries;
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state = 2;
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadShardInterfacesActor, 1, RangeResult >*>(static_cast<LoadShardInterfacesActor*>(this)));
															#line 990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& __UIDtoTagMap,int loopDepth) 
	{
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		UIDtoTagMap = __UIDtoTagMap;
															#line 999 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && __UIDtoTagMap,int loopDepth) 
	{
		UIDtoTagMap = std::move(__UIDtoTagMap);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state > 0) static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state = 0;
		static_cast<LoadShardInterfacesActor*>(this)->ActorCallback< LoadShardInterfacesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LoadShardInterfacesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadShardInterfacesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadShardInterfacesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(shardBoundaries.size() == 2);
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		sourceStorageServers = std::vector<UID>();
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		destStorageServers = std::vector<UID>();
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, shardBoundaries[0].value, sourceStorageServers, destStorageServers, true);
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServerToTagMap = std::unordered_map<UID, Tag>();
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 1088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			storageServerToTagMap.reserve(UIDtoTagMap.size());
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for( auto& it : UIDtoTagMap ) {
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				storageServerToTagMap[decodeServerTagKey(it.key)] = decodeServerTagValue(it.value);
															#line 1096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
		}
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServers = (!destStorageServers.empty()) ? destStorageServers : sourceStorageServers;
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		serverListEntries = std::vector<Future<Optional<Value>>>();
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		serverListEntries.reserve(storageServers.size());
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServerInterfaces = std::vector<StorageServerInterface>();
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServerInterfaces.reserve(storageServers.size());
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for( auto id : storageServers ) {
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			serverListEntries.push_back(tr->get(serverListKeyFor(id)));
															#line 1113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<std::vector<Optional<Value>>> __when_expr_2 = getAll(serverListEntries);
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state = 3;
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >*>(static_cast<LoadShardInterfacesActor*>(this)));
															#line 1124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult const& __shardBoundaries,int loopDepth) 
	{
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shardBoundaries = __shardBoundaries;
															#line 1133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult && __shardBoundaries,int loopDepth) 
	{
		shardBoundaries = std::move(__shardBoundaries);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state > 0) static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state = 0;
		static_cast<LoadShardInterfacesActor*>(this)->ActorCallback< LoadShardInterfacesActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LoadShardInterfacesActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadShardInterfacesActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadShardInterfacesActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for( auto& it : serverListValues ) {
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(it.present());
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			storageServerInterfaces.push_back(decodeServerListValue(it.get()));
															#line 1216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 1220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int j = 0;j < storageServers.size();j++) {
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				auto iter = storageServerToTagMap.find(storageServers[j]);
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT_WE_THINK(iter != storageServerToTagMap.end());
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				db->addSSIdTagMapping(storageServerInterfaces[j].id(), iter->second);
															#line 1230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
		}
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<LoadShardInterfacesActor*>(this)->SAV<std::vector<StorageServerInterface>>::futures) { (void)(storageServerInterfaces); this->~LoadShardInterfacesActorState(); static_cast<LoadShardInterfacesActor*>(this)->destroy(); return 0; }
															#line 1235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		new (&static_cast<LoadShardInterfacesActor*>(this)->SAV< std::vector<StorageServerInterface> >::value()) std::vector<StorageServerInterface>(std::move(storageServerInterfaces)); // state_var_RVO
		this->~LoadShardInterfacesActorState();
		static_cast<LoadShardInterfacesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<Optional<Value>> const& __serverListValues,int loopDepth) 
	{
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		serverListValues = __serverListValues;
															#line 1247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<Optional<Value>> && __serverListValues,int loopDepth) 
	{
		serverListValues = std::move(__serverListValues);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state > 0) static_cast<LoadShardInterfacesActor*>(this)->actor_wait_state = 0;
		static_cast<LoadShardInterfacesActor*>(this)->ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ConsistencyScanMemoryState> memState;
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Future<RangeResult> readShardBoundaries;
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database db;
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	RangeResult shardBoundaries;
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<UID> sourceStorageServers;
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<UID> destStorageServers;
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::unordered_map<UID, Tag> storageServerToTagMap;
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<UID> storageServers;
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Future<Optional<Value>>> serverListEntries;
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<StorageServerInterface> storageServerInterfaces;
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Optional<Value>> serverListValues;
															#line 1348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
};
// This generated class is to be used only via loadShardInterfaces()
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class LoadShardInterfacesActor final : public Actor<std::vector<StorageServerInterface>>, public ActorCallback< LoadShardInterfacesActor, 0, RangeResult >, public ActorCallback< LoadShardInterfacesActor, 1, RangeResult >, public ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >, public FastAllocated<LoadShardInterfacesActor>, public LoadShardInterfacesActorState<LoadShardInterfacesActor> {
															#line 1353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
	using FastAllocated<LoadShardInterfacesActor>::operator new;
	using FastAllocated<LoadShardInterfacesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13212933674002913792UL, 13239717265592067840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<StorageServerInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadShardInterfacesActor, 0, RangeResult >;
friend struct ActorCallback< LoadShardInterfacesActor, 1, RangeResult >;
friend struct ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >;
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	LoadShardInterfacesActor(Reference<ConsistencyScanMemoryState> const& memState,Reference<ReadYourWritesTransaction> const& tr,Future<RangeResult> const& readShardBoundaries,Database const& db) 
															#line 1372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		 : Actor<std::vector<StorageServerInterface>>(),
		   LoadShardInterfacesActorState<LoadShardInterfacesActor>(memState, tr, readShardBoundaries, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadShardInterfaces", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9901703264626988544UL, 15103364680979116288UL);
		ActorExecutionContextHelper __helper(static_cast<LoadShardInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadShardInterfaces");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadShardInterfaces", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadShardInterfacesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadShardInterfacesActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadShardInterfacesActor, 2, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<std::vector<StorageServerInterface>> loadShardInterfaces( Reference<ConsistencyScanMemoryState> const& memState, Reference<ReadYourWritesTransaction> const& tr, Future<RangeResult> const& readShardBoundaries, Database const& db ) {
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<std::vector<StorageServerInterface>>(new LoadShardInterfacesActor(memState, tr, readShardBoundaries, db));
															#line 1407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
}

#line 199 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

// returns error count
															#line 1413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
namespace {
// This generated class is to be used only via consistencyCheckReadData()
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class ConsistencyCheckReadDataActor>
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class ConsistencyCheckReadDataActorState {
															#line 1420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyCheckReadDataActorState(UID const& myId,Database const& cx,KeyRange const& range,Version const& version,std::vector<StorageServerInterface>* const& storageServerInterfaces,std::vector<Future<ErrorOr<GetKeyValuesReply>>>* const& keyValueFutures,Optional<int>* const& firstValidServer,int64_t* const& totalReadAmount,Optional<Version> const& consistencyCheckStartVersion) 
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : myId(myId),
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   cx(cx),
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   range(range),
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   version(version),
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   storageServerInterfaces(storageServerInterfaces),
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   keyValueFutures(keyValueFutures),
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   firstValidServer(firstValidServer),
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   totalReadAmount(totalReadAmount),
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   consistencyCheckStartVersion(consistencyCheckStartVersion)
															#line 1443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
	{
		fdb_probe_actor_create("consistencyCheckReadData", reinterpret_cast<unsigned long>(this));

	}
	~ConsistencyCheckReadDataActorState() 
	{
		fdb_probe_actor_destroy("consistencyCheckReadData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(!range.empty());
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req = GetKeyValuesRequest();
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.begin = firstGreaterOrEqual(range.begin);
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.end = firstGreaterOrEqual(range.end);
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.limit = 1e4;
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.limitBytes = CLIENT_KNOBS->REPLY_BYTE_LIMIT;
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.version = version;
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.tags = TagSet();
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (g_network->isSimulated() && BUGGIFY_WITH_PROB(0.01))
															#line 1474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (deterministicRandom()->coinflip())
															#line 1478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					req.limit = deterministicRandom()->randomInt(2, 10);
															#line 1482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (deterministicRandom()->coinflip())
															#line 1486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					req.limitBytes /= deterministicRandom()->randomInt(2, 100);
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					req.limitBytes = std::max<int>(1, req.limitBytes);
															#line 1492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
			}
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ReadOptions readOptions;
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readOptions.cacheResult = CacheResult::False;
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readOptions.type = ReadType::LOW;
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readOptions.consistencyCheckStartVersion = consistencyCheckStartVersion;
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.options = readOptions;
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			DisabledTraceEvent("ConsistencyCheck_ReadDataStart", myId) .detail("Range", range) .detail("Version", version) .detail("Servers", storageServerInterfaces->size());
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			j = 0;
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(j = 0;j < storageServerInterfaces->size();j++) {
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				resetReply(req);
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 1515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					cx->getLatestCommitVersion((*storageServerInterfaces)[j], req.version, req.ssLatestCommitVersions);
															#line 1519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				keyValueFutures->push_back((*storageServerInterfaces)[j].getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 1523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(*keyValueFutures);
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyCheckReadDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConsistencyCheckReadDataActor*>(this)->actor_wait_state = 1;
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConsistencyCheckReadDataActor, 0, Void >*>(static_cast<ConsistencyCheckReadDataActor*>(this)));
															#line 1534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsistencyCheckReadDataActorState();
		static_cast<ConsistencyCheckReadDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool expectInjected = storageServerInterfaces->size() > 1 && g_network->isSimulated() && consistencyCheckStartVersion.present() && g_simulator->consistencyScanState == ISimulator::SimConsistencyScanState::Enabled_InjectCorruption && g_simulator->consistencyScanCorruptRequestKey.present() && g_simulator->consistencyScanCorruptor.present() && g_simulator->consistencyScanCorruptor.get().first == myId && range.contains(g_simulator->consistencyScanCorruptRequestKey.get());
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (expectInjected)
															#line 1559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevWarnAlways, "ConsistencyScanExpectingInjectedCorruption", myId) .detail("StorageServers", storageServerInterfaces->size()) .detail("ScanState", g_simulator->consistencyScanState) .detail("CorruptKey", g_simulator->consistencyScanCorruptRequestKey.get()) .detail("ReqRange", range) .detail("CCStartVersion", consistencyCheckStartVersion.present() ? consistencyCheckStartVersion.get() : invalidVersion);
															#line 1563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool allSucceeded = true;
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool foundInjected = false;
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(j = 0;j < storageServerInterfaces->size();j++) {
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = (*keyValueFutures)[j].get();
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (rangeResult.present() && !rangeResult.get().error.present())
															#line 1575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				current = rangeResult.get();
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				DisabledTraceEvent("ConsistencyCheck_GetKeyValuesStream", myId) .detail("DataSize", current.data.size()) .detail(format("StorageServer%d", j).c_str(), (*storageServerInterfaces)[j].id());
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				*totalReadAmount += current.data.expectedSize();
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!firstValidServer->present())
															#line 1585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					DisabledTraceEvent("ConsistencyCheck_FirstValidServer", myId).detail("Iter", j);
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					*firstValidServer = j;
															#line 1591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
				else
				{
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					GetKeyValuesReply reference = (*keyValueFutures)[firstValidServer->get()].get().get();
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (current.data != reference.data || current.more != reference.more)
															#line 1599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (g_network->isSimulated())
															#line 1603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						{
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							int invalidIndex = -1;
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							fmt::print("MISMATCH AT VERSION {0}\n", req.version);
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							printf("\n%sSERVER %d (%s); shard = %s - %s:\n", "", j, (*storageServerInterfaces)[j].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							for(int k = 0;k < current.data.size();k++) {
															#line 307 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								printf("%d. %s => %s\n", k, printable(current.data[k].key).c_str(), printable(current.data[k].value).c_str());
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (invalidIndex < 0 && (k >= reference.data.size() || current.data[k].key != reference.data[k].key || current.data[k].value != reference.data[k].value))
															#line 1617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
								{
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									invalidIndex = k;
															#line 1621 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
								}
							}
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							printf("\n%sSERVER %d (%s); shard = %s - %s:\n", "", firstValidServer->get(), (*storageServerInterfaces)[firstValidServer->get()].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							for(int k = 0;k < reference.data.size();k++) {
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								printf("%d. %s => %s\n", k, printable(reference.data[k].key).c_str(), printable(reference.data[k].value).c_str());
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (invalidIndex < 0 && (k >= current.data.size() || reference.data[k].key != current.data[k].key || reference.data[k].value != current.data[k].value))
															#line 1632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
								{
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									invalidIndex = k;
															#line 1636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
								}
							}
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							printf("\nMISMATCH AT %d\n\n", invalidIndex);
															#line 1641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						}
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int currentUniques = 0;
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int referenceUniques = 0;
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int valueMismatches = 0;
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int matchingKVPairs = 0;
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						KeyRef currentUniqueKey;
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						KeyRef referenceUniqueKey;
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						KeyRef valueMismatchKey;
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int currentI = 0;
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int referenceI = 0;
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						for(;currentI < current.data.size() || referenceI < reference.data.size();) {
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							if (currentI >= current.data.size())
															#line 1665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
							{
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								referenceUniqueKey = reference.data[referenceI].key;
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								referenceUniques++;
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								referenceI++;
															#line 1673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
							}
							else
							{
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (referenceI >= reference.data.size())
															#line 1679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
								{
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									currentUniqueKey = current.data[currentI].key;
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									currentUniques++;
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									currentI++;
															#line 1687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
								}
								else
								{
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									KeyValueRef currentKV = current.data[currentI];
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									KeyValueRef referenceKV = reference.data[referenceI];
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									if (currentKV.key == referenceKV.key)
															#line 1697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
									{
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (currentKV.value == referenceKV.value)
															#line 1701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										{
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											matchingKVPairs++;
															#line 1705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										}
										else
										{
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											valueMismatchKey = currentKV.key;
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											valueMismatches++;
															#line 1713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										}
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										currentI++;
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										referenceI++;
															#line 1719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
									}
									else
									{
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (currentKV.key < referenceKV.key)
															#line 1725 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										{
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											currentUniqueKey = currentKV.key;
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											currentUniques++;
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											currentI++;
															#line 1733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										}
										else
										{
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											referenceUniqueKey = referenceKV.key;
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											referenceUniques++;
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											referenceI++;
															#line 1743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										}
									}
								}
							}
						}
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						bool isTss = (*storageServerInterfaces)[j].isTss() || (*storageServerInterfaces)[firstValidServer->get()].isTss();
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						bool isExpectedTSSMismatch = g_network->isSimulated() && g_simulator->tssMode == ISimulator::TSSMode::EnabledDropMutations && isTss;
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						bool isFailed = g_network->isSimulated() && (g_simulator->getProcessByAddress((*storageServerInterfaces)[j].address())->failed || g_simulator->getProcessByAddress((*storageServerInterfaces)[firstValidServer->get()].address()) ->failed) && (g_simulator->getProcessByAddress((*storageServerInterfaces)[j].address())->locality.dcId() != g_simulator->getProcessByAddress((*storageServerInterfaces)[firstValidServer->get()].address()) ->locality.dcId());
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (!isTss && !isFailed && expectInjected)
															#line 1757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						{
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							ASSERT(g_simulator->consistencyScanInjectedCorruptionType.present());
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::FlipMoreFlag)
															#line 1763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
							{
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								expectInjected = (current.more != reference.more && currentUniques == 0 && referenceUniques == 0 && valueMismatches == 0);
															#line 1767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
							}
							else
							{
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::AddToEmpty)
															#line 1773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
								{
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									expectInjected = (current.more == reference.more && current.data.size() + reference.data.size() == 1);
															#line 423 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									if (expectInjected)
															#line 1779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
									{
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										KeyValueRef& kv = current.data.empty() ? reference.data[0] : current.data[0];
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										expectInjected = kv.key == g_simulator->consistencyScanCorruptRequestKey.get() && kv.value == "consistencyCheckCorruptValue"_sr;
															#line 1785 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
									}
								}
								else
								{
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::RemoveLastRow)
															#line 1792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
									{
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										expectInjected = (current.more == reference.more && valueMismatches == 0 && currentUniques + referenceUniques == 1 && std::abs(current.data.size() - reference.data.size()) == 1);
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (expectInjected)
															#line 1798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										{
															#line 435 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											for(int i = 0;i < current.data.size() && i < reference.data.size();i++) {
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												if (current.data[i] != reference.data[i])
															#line 1804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
												{
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
													expectInjected = false;
															#line 1808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
													break;
												}
											}
										}
									}
									else
									{
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::ChangeFirstValue)
															#line 1818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										{
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											expectInjected = (current.more == reference.more && valueMismatches == 1 && currentUniques == 0 && referenceUniques == 0 && valueMismatchKey == current.data[0].key && std::abs(current.data[0].value.size() - reference.data[0].value.size()) == 1);
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											if (expectInjected)
															#line 1824 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
											{
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												Value shorter = current.data[0].value < reference.data[0].value ? current.data[0].value : reference.data[0].value;
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												Value longer = current.data[0].value < reference.data[0].value ? reference.data[0].value : current.data[0].value;
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												expectInjected = (shorter == longer.substr(0, shorter.size()));
															#line 1832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
											}
										}
										else
										{
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											ASSERT(false);
															#line 1839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										}
									}
								}
							}
						}
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						TraceEvent(isExpectedTSSMismatch || isFailed || expectInjected ? SevWarn : SevError, "ConsistencyCheck_DataInconsistent", myId) .detail(format("StorageServer%d", j).c_str(), (*storageServerInterfaces)[j].id()) .detail(format("StorageServer%d", firstValidServer->get()).c_str(), (*storageServerInterfaces)[firstValidServer->get()].id()) .detail("ShardBegin", req.begin.getKey()) .detail("ShardEnd", req.end.getKey()) .detail("VersionNumber", req.version) .detail(format("Server%dUniques", j).c_str(), currentUniques) .detail(format("Server%dUniqueKey", j).c_str(), currentUniqueKey) .detail(format("Server%dUniques", firstValidServer->get()).c_str(), referenceUniques) .detail(format("Server%dUniqueKey", firstValidServer->get()).c_str(), referenceUniqueKey) .detail("ValueMismatches", valueMismatches) .detail("ValueMismatchKey", valueMismatchKey) .detail("MatchingKVPairs", matchingKVPairs) .detail(format("Server%dHasMore", j).c_str(), current.more) .detail(format("Server%dHasMore", firstValidServer->get()).c_str(), reference.more) .detail("IsTSS", isTss) .detail("IsInjected", expectInjected);
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (expectInjected)
															#line 1849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						{
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							foundInjected = true;
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							CODE_PROBE(true, "consistency check detected injected corruption");
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							TraceEvent(SevWarnAlways, "ConsistencyScanFoundInjectedCorruption", myId) .detail("CorruptionType", g_simulator->consistencyScanInjectedCorruptionType.get()) .detail("Version", req.version);
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							g_simulator->updateConsistencyScanState( ISimulator::SimConsistencyScanState::Enabled_InjectCorruption, ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
															#line 1859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						}
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (!isExpectedTSSMismatch)
															#line 1863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						{
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							int issues = currentUniques + referenceUniques + valueMismatches + ((current.more == reference.more) ? 0 : 1);
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							ASSERT(issues > 0);
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							if (!static_cast<ConsistencyCheckReadDataActor*>(this)->SAV<int>::futures) { (void)(issues); this->~ConsistencyCheckReadDataActorState(); static_cast<ConsistencyCheckReadDataActor*>(this)->destroy(); return 0; }
															#line 1871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
							new (&static_cast<ConsistencyCheckReadDataActor*>(this)->SAV< int >::value()) int(issues);
							this->~ConsistencyCheckReadDataActorState();
							static_cast<ConsistencyCheckReadDataActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (isFailed)
															#line 1879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						{
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							return a_body1Catch1(wrong_shard_server(), loopDepth);
															#line 1883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						}
					}
				}
			}
			else
			{
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				allSucceeded = false;
															#line 1892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
		}
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (expectInjected && !foundInjected)
															#line 1897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (allSucceeded)
															#line 1901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevError, "ConsistencyCheck_ShouldHaveFoundInjectedCorruption", myId);
															#line 1905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
			else
			{
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				CODE_PROBE(true, "consistency check potentially missed injected corruption due to failures", probe::decoration::rare);
															#line 520 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheck_MissedCorruptionDueToFailures");
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabled_InjectCorruption, ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
															#line 1915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
		}
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		DisabledTraceEvent("ConsistencyCheck_ReadDataDone", myId) .detail("Range", range) .detail("Version", version) .detail("FirstValidServer", firstValidServer->present() ? firstValidServer->get() : -1);
															#line 531 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<ConsistencyCheckReadDataActor*>(this)->SAV<int>::futures) { (void)(0); this->~ConsistencyCheckReadDataActorState(); static_cast<ConsistencyCheckReadDataActor*>(this)->destroy(); return 0; }
															#line 1922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		new (&static_cast<ConsistencyCheckReadDataActor*>(this)->SAV< int >::value()) int(0);
		this->~ConsistencyCheckReadDataActorState();
		static_cast<ConsistencyCheckReadDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool expectInjected = storageServerInterfaces->size() > 1 && g_network->isSimulated() && consistencyCheckStartVersion.present() && g_simulator->consistencyScanState == ISimulator::SimConsistencyScanState::Enabled_InjectCorruption && g_simulator->consistencyScanCorruptRequestKey.present() && g_simulator->consistencyScanCorruptor.present() && g_simulator->consistencyScanCorruptor.get().first == myId && range.contains(g_simulator->consistencyScanCorruptRequestKey.get());
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (expectInjected)
															#line 1936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevWarnAlways, "ConsistencyScanExpectingInjectedCorruption", myId) .detail("StorageServers", storageServerInterfaces->size()) .detail("ScanState", g_simulator->consistencyScanState) .detail("CorruptKey", g_simulator->consistencyScanCorruptRequestKey.get()) .detail("ReqRange", range) .detail("CCStartVersion", consistencyCheckStartVersion.present() ? consistencyCheckStartVersion.get() : invalidVersion);
															#line 1940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool allSucceeded = true;
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool foundInjected = false;
															#line 276 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(j = 0;j < storageServerInterfaces->size();j++) {
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = (*keyValueFutures)[j].get();
															#line 280 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (rangeResult.present() && !rangeResult.get().error.present())
															#line 1952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				current = rangeResult.get();
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				DisabledTraceEvent("ConsistencyCheck_GetKeyValuesStream", myId) .detail("DataSize", current.data.size()) .detail(format("StorageServer%d", j).c_str(), (*storageServerInterfaces)[j].id());
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				*totalReadAmount += current.data.expectedSize();
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!firstValidServer->present())
															#line 1962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					DisabledTraceEvent("ConsistencyCheck_FirstValidServer", myId).detail("Iter", j);
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					*firstValidServer = j;
															#line 1968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
				else
				{
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					GetKeyValuesReply reference = (*keyValueFutures)[firstValidServer->get()].get().get();
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (current.data != reference.data || current.more != reference.more)
															#line 1976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (g_network->isSimulated())
															#line 1980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						{
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							int invalidIndex = -1;
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							fmt::print("MISMATCH AT VERSION {0}\n", req.version);
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							printf("\n%sSERVER %d (%s); shard = %s - %s:\n", "", j, (*storageServerInterfaces)[j].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							for(int k = 0;k < current.data.size();k++) {
															#line 307 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								printf("%d. %s => %s\n", k, printable(current.data[k].key).c_str(), printable(current.data[k].value).c_str());
															#line 311 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (invalidIndex < 0 && (k >= reference.data.size() || current.data[k].key != reference.data[k].key || current.data[k].value != reference.data[k].value))
															#line 1994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
								{
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									invalidIndex = k;
															#line 1998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
								}
							}
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							printf("\n%sSERVER %d (%s); shard = %s - %s:\n", "", firstValidServer->get(), (*storageServerInterfaces)[firstValidServer->get()].address().toString().c_str(), printable(req.begin.getKey()).c_str(), printable(req.end.getKey()).c_str());
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							for(int k = 0;k < reference.data.size();k++) {
															#line 324 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								printf("%d. %s => %s\n", k, printable(reference.data[k].key).c_str(), printable(reference.data[k].value).c_str());
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (invalidIndex < 0 && (k >= current.data.size() || reference.data[k].key != current.data[k].key || reference.data[k].value != current.data[k].value))
															#line 2009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
								{
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									invalidIndex = k;
															#line 2013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
								}
							}
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							printf("\nMISMATCH AT %d\n\n", invalidIndex);
															#line 2018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						}
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int currentUniques = 0;
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int referenceUniques = 0;
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int valueMismatches = 0;
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int matchingKVPairs = 0;
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						KeyRef currentUniqueKey;
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						KeyRef referenceUniqueKey;
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						KeyRef valueMismatchKey;
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int currentI = 0;
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						int referenceI = 0;
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						for(;currentI < current.data.size() || referenceI < reference.data.size();) {
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							if (currentI >= current.data.size())
															#line 2042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
							{
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								referenceUniqueKey = reference.data[referenceI].key;
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								referenceUniques++;
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								referenceI++;
															#line 2050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
							}
							else
							{
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (referenceI >= reference.data.size())
															#line 2056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
								{
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									currentUniqueKey = current.data[currentI].key;
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									currentUniques++;
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									currentI++;
															#line 2064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
								}
								else
								{
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									KeyValueRef currentKV = current.data[currentI];
															#line 367 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									KeyValueRef referenceKV = reference.data[referenceI];
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									if (currentKV.key == referenceKV.key)
															#line 2074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
									{
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (currentKV.value == referenceKV.value)
															#line 2078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										{
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											matchingKVPairs++;
															#line 2082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										}
										else
										{
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											valueMismatchKey = currentKV.key;
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											valueMismatches++;
															#line 2090 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										}
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										currentI++;
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										referenceI++;
															#line 2096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
									}
									else
									{
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (currentKV.key < referenceKV.key)
															#line 2102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										{
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											currentUniqueKey = currentKV.key;
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											currentUniques++;
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											currentI++;
															#line 2110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										}
										else
										{
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											referenceUniqueKey = referenceKV.key;
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											referenceUniques++;
															#line 386 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											referenceI++;
															#line 2120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										}
									}
								}
							}
						}
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						bool isTss = (*storageServerInterfaces)[j].isTss() || (*storageServerInterfaces)[firstValidServer->get()].isTss();
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						bool isExpectedTSSMismatch = g_network->isSimulated() && g_simulator->tssMode == ISimulator::TSSMode::EnabledDropMutations && isTss;
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						bool isFailed = g_network->isSimulated() && (g_simulator->getProcessByAddress((*storageServerInterfaces)[j].address())->failed || g_simulator->getProcessByAddress((*storageServerInterfaces)[firstValidServer->get()].address()) ->failed) && (g_simulator->getProcessByAddress((*storageServerInterfaces)[j].address())->locality.dcId() != g_simulator->getProcessByAddress((*storageServerInterfaces)[firstValidServer->get()].address()) ->locality.dcId());
															#line 411 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (!isTss && !isFailed && expectInjected)
															#line 2134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						{
															#line 413 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							ASSERT(g_simulator->consistencyScanInjectedCorruptionType.present());
															#line 414 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::FlipMoreFlag)
															#line 2140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
							{
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								expectInjected = (current.more != reference.more && currentUniques == 0 && referenceUniques == 0 && valueMismatches == 0);
															#line 2144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
							}
							else
							{
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
								if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::AddToEmpty)
															#line 2150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
								{
															#line 421 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									expectInjected = (current.more == reference.more && current.data.size() + reference.data.size() == 1);
															#line 423 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									if (expectInjected)
															#line 2156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
									{
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										KeyValueRef& kv = current.data.empty() ? reference.data[0] : current.data[0];
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										expectInjected = kv.key == g_simulator->consistencyScanCorruptRequestKey.get() && kv.value == "consistencyCheckCorruptValue"_sr;
															#line 2162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
									}
								}
								else
								{
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
									if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::RemoveLastRow)
															#line 2169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
									{
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										expectInjected = (current.more == reference.more && valueMismatches == 0 && currentUniques + referenceUniques == 1 && std::abs(current.data.size() - reference.data.size()) == 1);
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (expectInjected)
															#line 2175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										{
															#line 435 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											for(int i = 0;i < current.data.size() && i < reference.data.size();i++) {
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												if (current.data[i] != reference.data[i])
															#line 2181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
												{
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
													expectInjected = false;
															#line 2185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
													break;
												}
											}
										}
									}
									else
									{
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
										if (g_simulator->consistencyScanInjectedCorruptionType.get() == ISimulator::SimConsistencyScanCorruptionType::ChangeFirstValue)
															#line 2195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										{
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											expectInjected = (current.more == reference.more && valueMismatches == 1 && currentUniques == 0 && referenceUniques == 0 && valueMismatchKey == current.data[0].key && std::abs(current.data[0].value.size() - reference.data[0].value.size()) == 1);
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											if (expectInjected)
															#line 2201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
											{
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												Value shorter = current.data[0].value < reference.data[0].value ? current.data[0].value : reference.data[0].value;
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												Value longer = current.data[0].value < reference.data[0].value ? reference.data[0].value : current.data[0].value;
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
												expectInjected = (shorter == longer.substr(0, shorter.size()));
															#line 2209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
											}
										}
										else
										{
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
											ASSERT(false);
															#line 2216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
										}
									}
								}
							}
						}
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						TraceEvent(isExpectedTSSMismatch || isFailed || expectInjected ? SevWarn : SevError, "ConsistencyCheck_DataInconsistent", myId) .detail(format("StorageServer%d", j).c_str(), (*storageServerInterfaces)[j].id()) .detail(format("StorageServer%d", firstValidServer->get()).c_str(), (*storageServerInterfaces)[firstValidServer->get()].id()) .detail("ShardBegin", req.begin.getKey()) .detail("ShardEnd", req.end.getKey()) .detail("VersionNumber", req.version) .detail(format("Server%dUniques", j).c_str(), currentUniques) .detail(format("Server%dUniqueKey", j).c_str(), currentUniqueKey) .detail(format("Server%dUniques", firstValidServer->get()).c_str(), referenceUniques) .detail(format("Server%dUniqueKey", firstValidServer->get()).c_str(), referenceUniqueKey) .detail("ValueMismatches", valueMismatches) .detail("ValueMismatchKey", valueMismatchKey) .detail("MatchingKVPairs", matchingKVPairs) .detail(format("Server%dHasMore", j).c_str(), current.more) .detail(format("Server%dHasMore", firstValidServer->get()).c_str(), reference.more) .detail("IsTSS", isTss) .detail("IsInjected", expectInjected);
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (expectInjected)
															#line 2226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						{
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							foundInjected = true;
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							CODE_PROBE(true, "consistency check detected injected corruption");
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							TraceEvent(SevWarnAlways, "ConsistencyScanFoundInjectedCorruption", myId) .detail("CorruptionType", g_simulator->consistencyScanInjectedCorruptionType.get()) .detail("Version", req.version);
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							g_simulator->updateConsistencyScanState( ISimulator::SimConsistencyScanState::Enabled_InjectCorruption, ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
															#line 2236 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						}
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (!isExpectedTSSMismatch)
															#line 2240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						{
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							int issues = currentUniques + referenceUniques + valueMismatches + ((current.more == reference.more) ? 0 : 1);
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							ASSERT(issues > 0);
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							if (!static_cast<ConsistencyCheckReadDataActor*>(this)->SAV<int>::futures) { (void)(issues); this->~ConsistencyCheckReadDataActorState(); static_cast<ConsistencyCheckReadDataActor*>(this)->destroy(); return 0; }
															#line 2248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
							new (&static_cast<ConsistencyCheckReadDataActor*>(this)->SAV< int >::value()) int(issues);
							this->~ConsistencyCheckReadDataActorState();
							static_cast<ConsistencyCheckReadDataActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (isFailed)
															#line 2256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						{
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							return a_body1Catch1(wrong_shard_server(), loopDepth);
															#line 2260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						}
					}
				}
			}
			else
			{
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				allSucceeded = false;
															#line 2269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
		}
															#line 512 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (expectInjected && !foundInjected)
															#line 2274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 513 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (allSucceeded)
															#line 2278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevError, "ConsistencyCheck_ShouldHaveFoundInjectedCorruption", myId);
															#line 2282 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
			else
			{
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				CODE_PROBE(true, "consistency check potentially missed injected corruption due to failures", probe::decoration::rare);
															#line 520 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevInfo, "ConsistencyCheck_MissedCorruptionDueToFailures");
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabled_InjectCorruption, ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
															#line 2292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
		}
															#line 526 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		DisabledTraceEvent("ConsistencyCheck_ReadDataDone", myId) .detail("Range", range) .detail("Version", version) .detail("FirstValidServer", firstValidServer->present() ? firstValidServer->get() : -1);
															#line 531 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<ConsistencyCheckReadDataActor*>(this)->SAV<int>::futures) { (void)(0); this->~ConsistencyCheckReadDataActorState(); static_cast<ConsistencyCheckReadDataActor*>(this)->destroy(); return 0; }
															#line 2299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		new (&static_cast<ConsistencyCheckReadDataActor*>(this)->SAV< int >::value()) int(0);
		this->~ConsistencyCheckReadDataActorState();
		static_cast<ConsistencyCheckReadDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsistencyCheckReadDataActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyCheckReadDataActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyCheckReadDataActor*>(this)->ActorCallback< ConsistencyCheckReadDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckReadDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckReadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConsistencyCheckReadDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckReadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConsistencyCheckReadDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckReadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	UID myId;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database cx;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	KeyRange range;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Version version;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<StorageServerInterface>* storageServerInterfaces;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyValuesReply>>>* keyValueFutures;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<int>* firstValidServer;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t* totalReadAmount;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<Version> consistencyCheckStartVersion;
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetKeyValuesRequest req;
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int j;
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetKeyValuesReply current;
															#line 2406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
};
// This generated class is to be used only via consistencyCheckReadData()
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class ConsistencyCheckReadDataActor final : public Actor<int>, public ActorCallback< ConsistencyCheckReadDataActor, 0, Void >, public FastAllocated<ConsistencyCheckReadDataActor>, public ConsistencyCheckReadDataActorState<ConsistencyCheckReadDataActor> {
															#line 2411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
	using FastAllocated<ConsistencyCheckReadDataActor>::operator new;
	using FastAllocated<ConsistencyCheckReadDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12445288320119860224UL, 7935511953346129408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConsistencyCheckReadDataActor, 0, Void >;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyCheckReadDataActor(UID const& myId,Database const& cx,KeyRange const& range,Version const& version,std::vector<StorageServerInterface>* const& storageServerInterfaces,std::vector<Future<ErrorOr<GetKeyValuesReply>>>* const& keyValueFutures,Optional<int>* const& firstValidServer,int64_t* const& totalReadAmount,Optional<Version> const& consistencyCheckStartVersion) 
															#line 2428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		 : Actor<int>(),
		   ConsistencyCheckReadDataActorState<ConsistencyCheckReadDataActor>(myId, cx, range, version, storageServerInterfaces, keyValueFutures, firstValidServer, totalReadAmount, consistencyCheckStartVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10588760710414007808UL, 16874555229171532544UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyCheckReadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consistencyCheckReadData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consistencyCheckReadData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConsistencyCheckReadDataActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<int> consistencyCheckReadData( UID const& myId, Database const& cx, KeyRange const& range, Version const& version, std::vector<StorageServerInterface>* const& storageServerInterfaces, std::vector<Future<ErrorOr<GetKeyValuesReply>>>* const& keyValueFutures, Optional<int>* const& firstValidServer, int64_t* const& totalReadAmount, Optional<Version> const& consistencyCheckStartVersion ) {
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<int>(new ConsistencyCheckReadDataActor(myId, cx, range, version, storageServerInterfaces, keyValueFutures, firstValidServer, totalReadAmount, consistencyCheckStartVersion));
															#line 2461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
}

#line 533 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

															#line 2466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
namespace {
// This generated class is to be used only via consistencyScanCore()
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class ConsistencyScanCoreActor>
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class ConsistencyScanCoreActorState {
															#line 2473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanCoreActorState(Database const& db,Reference<ConsistencyScanMemoryState> const& memState,ConsistencyScanState const& cs) 
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : db(db),
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   memState(memState),
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   cs(cs)
															#line 2484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
	{
		fdb_probe_actor_create("consistencyScanCore", reinterpret_cast<unsigned long>(this));

	}
	~ConsistencyScanCoreActorState() 
	{
		fdb_probe_actor_destroy("consistencyScanCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyScanCoreStart").log();
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			tr = makeReference<ReadYourWritesTransaction>(db);
															#line 540 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			systemDB = SystemDBWriteLockedNow(db.getReference());
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			pollSize = pollDatabaseSize(memState, g_network->isSimulated() ? 15 : 900);
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readRateLimit = 0;
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readRateControl = Reference<IRateControl>();
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			CODE_PROBE(true, "Running Consistency Scan");
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 2513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsistencyScanCoreActorState();
		static_cast<ConsistencyScanCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		config = ConsistencyScanState::Config();
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		configVersion = Optional<Versionstamp>();
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsLifetime = ConsistencyScanState::LifetimeStats();
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsCurrentRound = ConsistencyScanState::RoundStats();
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 2551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressLoopStart", memState->csId);
															#line 2555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr->reset();
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 2561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 641 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 2570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressEnabled", memState->csId);
															#line 2574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 646 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (memState->databaseSize.get() < 0)
															#line 2578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_6 = memState->databaseSize.onChange();
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_6.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 7;
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 6, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			systemDB->setOptions(tr);
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(config, cs.config().getD(tr));
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 1;
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 0, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2620 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyScan_MainLoopError", memState->csId).error(e);
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr->onError(e);
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 6;
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 5, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(configVersion, cs.trigger.get(tr));
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 2;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 1, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(configVersion, cs.trigger.get(tr));
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 2;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 1, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 2786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressGotConfig", memState->csId) .detail("Enabled", config.enabled);
															#line 2790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (config.enabled)
															#line 2794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store(statsLifetime, cs.lifetimeStats().getD(tr)) && store(statsCurrentRound, cs.currentRoundStats().getD(tr));
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 3;
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 2, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 2819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressGotConfig", memState->csId) .detail("Enabled", config.enabled);
															#line 2823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (config.enabled)
															#line 2827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store(statsLifetime, cs.lifetimeStats().getD(tr)) && store(statsCurrentRound, cs.currentRoundStats().getD(tr));
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 3;
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 2, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont4(int loopDepth) 
	{
															#line 615 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		cs.roundStatsHistory().erase( tr, 0, std::max<Version>(0, tr->getReadVersion().get() - (CLIENT_KNOBS->CORE_VERSIONSPERSECOND * 60 * 60 * 24 * config.roundHistoryDays)));
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		watch = config.enabled ? Void() : cs.trigger.watch(tr);
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2933 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 4;
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 3, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 2938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (statsCurrentRound.complete || (statsCurrentRound.startVersion != 0 && statsCurrentRound.startVersion < config.minStartVersion))
															#line 2947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!statsCurrentRound.complete)
															#line 2951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.endVersion = tr->getReadVersion().get();
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.endTime = now();
															#line 2957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 599 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			cs.roundStatsHistory().set(tr, statsCurrentRound.startVersion, statsCurrentRound);
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound = ConsistencyScanState::RoundStats();
															#line 2963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (statsCurrentRound.startVersion == 0)
															#line 2967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 606 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.startVersion = tr->getReadVersion().get();
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.startTime = now();
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.lastProgressTime = now();
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			cs.currentRoundStats().set(tr, statsCurrentRound);
															#line 2977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (statsCurrentRound.complete || (statsCurrentRound.startVersion != 0 && statsCurrentRound.startVersion < config.minStartVersion))
															#line 2987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!statsCurrentRound.complete)
															#line 2991 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.endVersion = tr->getReadVersion().get();
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.endTime = now();
															#line 2997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 599 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			cs.roundStatsHistory().set(tr, statsCurrentRound.startVersion, statsCurrentRound);
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound = ConsistencyScanState::RoundStats();
															#line 3003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (statsCurrentRound.startVersion == 0)
															#line 3007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 606 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.startVersion = tr->getReadVersion().get();
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.startTime = now();
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.lastProgressTime = now();
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			cs.currentRoundStats().set(tr, statsCurrentRound);
															#line 3017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (config.enabled)
															#line 3102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 3108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressDisabledWatching", memState->csId);
															#line 3112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_4 = watch;
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1loopBody1cont11when1(__when_expr_4.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 5;
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 4, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 3123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (config.enabled)
															#line 3132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 3138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressDisabledWatching", memState->csId);
															#line 3142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_4 = watch;
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1loopBody1cont11when1(__when_expr_4.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 5;
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 4, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 3153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1cont11cont1(Void const& _,int loopDepth) 
	{
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr->reset();
															#line 3237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont11cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont11cont1(Void && _,int loopDepth) 
	{
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr->reset();
															#line 3246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont11cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1loopBody1cont11cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 650 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 3430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressGotDBSize", memState->csId);
															#line 3434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 654 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		restartMainLoop = false;
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		delayBeforeMainLoopRestart = Void();
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 3442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 659 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 3551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopStart", memState->csId);
															#line 3555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int configuredRate;
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (now() - statsCurrentRound.startTime > config.targetRoundTimeSeconds)
															#line 3561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			CODE_PROBE(true, "Consistency Scan needs to catch up");
															#line 668 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			configuredRate = config.maxReadByteRate;
															#line 3567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		else
		{
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			double replicationFactor = (statsCurrentRound.logicalBytesScanned == 0) ? 3 : ((double)statsCurrentRound.replicatedBytesRead / statsCurrentRound.logicalBytesScanned);
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			double bytesPerSecTarget = memState->databaseSize.get() * replicationFactor / (config.targetRoundTimeSeconds > 0 ? config.targetRoundTimeSeconds : 1);
															#line 680 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			bytesPerSecTarget = std::min(bytesPerSecTarget, 1e8);
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			configuredRate = std::min<int>(config.maxReadByteRate, bytesPerSecTarget);
															#line 3579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 684 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		configuredRate = std::max<int>(100e3, configuredRate);
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (readRateLimit != configuredRate)
															#line 3585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readRateLimit = configuredRate;
															#line 691 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			CODE_PROBE(true, "Consistency Scan changing rate");
															#line 692 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 3593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 693 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyScan_ChangeRate", memState->csId).detail("RateBytes", readRateLimit);
															#line 3597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readRateControl = Reference<IRateControl>(new SpeedLimit(readRateLimit, 1));
															#line 696 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			memState->stats.targetRate = configuredRate;
															#line 3603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		totalReadBytesFromStorageServers = 0;
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		savedCurrentRoundState = statsCurrentRound;
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr->reset();
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 3613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(int loopDepth) 
	{
															#line 1034 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr->reset();
															#line 1035 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (statsCurrentRound.lastEndKey != savedCurrentRoundState.lastEndKey || statsCurrentRound.complete)
															#line 3637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1036 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 3641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1037 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopSaving", memState->csId) .detail("ProgressKey", statsCurrentRound.lastEndKey);
															#line 3645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 1040 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.lastProgressTime = now();
															#line 1041 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 3651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = a_body1loopBody1cont3loopBody1cont1loopHead1(loopDepth);
		}
		else
		{
															#line 1076 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			CODE_PROBE(true, "consistency scan loop no progress");
															#line 1077 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 3660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1078 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopNoProgress", memState->csId) .detail("ProgressKey", statsCurrentRound.lastEndKey);
															#line 3664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont3loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 711 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			++memState->stats.scanLoops;
															#line 712 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound = savedCurrentRoundState;
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			systemDB->setOptions(tr);
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardBoundaries = RangeResult();
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			storageServerInterfaces = std::vector<StorageServerInterface>();
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			csVersion = Optional<Versionstamp>();
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			configRange = Optional<ConsistencyScanState::RangeConfigMap::RangeValue>();
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 3697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopLoadingState", memState->csId);
															#line 3701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			GetRangeLimits limits;
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			limits.minRows = 2;
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			limits.rows = 2;
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			Future<RangeResult> readShardBoundaries = tr->getRange(lastLessOrEqual(statsCurrentRound.lastEndKey.withPrefix(keyServersPrefix)), firstGreaterThan(allKeys.end.withPrefix(keyServersPrefix)), limits, Snapshot::True);
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_7 = store(shardBoundaries, readShardBoundaries) && store(storageServerInterfaces, loadShardInterfaces(memState, tr, readShardBoundaries, db)) && store(csVersion, cs.trigger.get(tr)) && store(configRange, cs.rangeConfig().getRangeForKey(tr, statsCurrentRound.lastEndKey));
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1cont3loopBody1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont3loopBody1loopBody1when1(__when_expr_7.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 8;
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 7, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 3720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyScan_ScanLoopError", memState->csId).errorUnsuppressed(e);
															#line 1016 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (e.code() == error_code_future_version || e.code() == error_code_wrong_shard_server || e.code() == error_code_all_alternatives_failed || e.code() == error_code_process_behind)
															#line 3757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1019 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				totalReadBytesFromStorageServers += 100000;
															#line 3761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				return a_body1loopBody1cont3loopBody1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
				try {
															#line 1023 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					StrictFuture<Void> __when_expr_10 = tr->onError(e);
															#line 1023 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 3771 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1loopBody1cont3loopBody1loopBody1Catch1when1(__when_expr_10.get(), loopDepth); };
					static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 11;
															#line 1023 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 10, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 3776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(unknown_error(), loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 3798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 741 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopLoadedState", memState->csId);
															#line 3802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (csVersion != configVersion)
															#line 3806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 3810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 748 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopVersionMismatch", memState->csId);
															#line 3814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 750 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			restartMainLoop = true;
															#line 3818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			return a_body1loopBody1cont3loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		beginKey = shardBoundaries[0].key.removePrefix(keyServersPrefix);
															#line 755 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (beginKey < statsCurrentRound.lastEndKey)
															#line 3825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			beginKey = statsCurrentRound.lastEndKey;
															#line 3829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		targetRange = KeyRangeRef(beginKey, shardBoundaries[1].key.removePrefix(keyServersPrefix));
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool scanRange = true;
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsCurrentRound.lastProgressVersion = tr->getReadVersion().get();
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (configRange.present())
															#line 3839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 768 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			auto val = configRange->value;
															#line 773 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!val.included.orDefault(true) || val.skip.orDefault(false))
															#line 3845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 779 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (val.skip.orDefault(false))
															#line 3849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 780 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					++statsCurrentRound.skippedRanges;
															#line 3853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = configRange->range.begin;
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				scanRange = false;
															#line 3859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
			else
			{
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (configRange->range.end < targetRange.end)
															#line 3865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					targetRange = KeyRangeRef(targetRange.begin, configRange->range.end);
															#line 3869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
			}
		}
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		noMoreRecords = statsCurrentRound.lastEndKey == allKeys.end;
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		failedRequest = Optional<Error>();
															#line 801 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (scanRange)
															#line 3879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 803 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (g_network->isSimulated() && g_simulator->consistencyScanState == ISimulator::SimConsistencyScanState::Enabled && g_simulator->doInjectConsistencyScanCorruption.present() && g_simulator->doInjectConsistencyScanCorruption.get() && (deterministicRandom()->random01() < 0.1 || targetRange.end == allKeys.end))
															#line 3883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 808 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (storageServerInterfaces.size() > 1)
															#line 3887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 810 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					Key corruptKey = targetRange.begin;
															#line 811 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (deterministicRandom()->coinflip() && targetRange.end.size() > 0)
															#line 3893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 812 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						Key corruptKey2 = targetRange.end.substr(0, targetRange.end.size() - 1);
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (corruptKey2 > corruptKey)
															#line 3899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						{
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							corruptKey = corruptKey2;
															#line 3903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						}
					}
															#line 817 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->consistencyScanCorruptRequestKey = corruptKey;
															#line 818 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					std::pair<UID, NetworkAddress> meCorruptor = { memState->csId, g_network->getLocalAddress() };
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->consistencyScanCorruptor = meCorruptor;
															#line 821 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->updateConsistencyScanState( ISimulator::SimConsistencyScanState::Enabled, ISimulator::SimConsistencyScanState::Enabled_InjectCorruption);
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent( SevWarnAlways, "ConsistencyScanProgressScanRangeInjectCorruption", memState->csId) .detail("StartKey", targetRange.begin) .detail("CorruptKey", corruptKey) .detail("Storages", storageServerInterfaces.size());
															#line 3916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
				else
				{
															#line 831 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					CODE_PROBE(true, "skipping consistency scan corruption check because only 1 replica");
															#line 832 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->updateConsistencyScanState( ISimulator::SimConsistencyScanState::Enabled, ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent(SevWarnAlways, "ConsistencyScanProgressScanRangeSkipInjectCorruption", memState->csId) .detail("StartKey", targetRange.begin);
															#line 3926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
			}
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 3931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanRangeStart", memState->csId) .detail("StartKey", targetRange.begin);
															#line 3935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			replicatedBytesRead = 0;
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			logicalBytesRead = 0;
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			errors = 0;
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 3945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 3959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 741 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopLoadedState", memState->csId);
															#line 3963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (csVersion != configVersion)
															#line 3967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 3971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 748 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopVersionMismatch", memState->csId);
															#line 3975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 750 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			restartMainLoop = true;
															#line 3979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			return a_body1loopBody1cont3loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		beginKey = shardBoundaries[0].key.removePrefix(keyServersPrefix);
															#line 755 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (beginKey < statsCurrentRound.lastEndKey)
															#line 3986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			beginKey = statsCurrentRound.lastEndKey;
															#line 3990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		targetRange = KeyRangeRef(beginKey, shardBoundaries[1].key.removePrefix(keyServersPrefix));
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bool scanRange = true;
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsCurrentRound.lastProgressVersion = tr->getReadVersion().get();
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (configRange.present())
															#line 4000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 768 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			auto val = configRange->value;
															#line 773 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!val.included.orDefault(true) || val.skip.orDefault(false))
															#line 4006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 779 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (val.skip.orDefault(false))
															#line 4010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 780 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					++statsCurrentRound.skippedRanges;
															#line 4014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = configRange->range.begin;
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				scanRange = false;
															#line 4020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
			else
			{
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (configRange->range.end < targetRange.end)
															#line 4026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					targetRange = KeyRangeRef(targetRange.begin, configRange->range.end);
															#line 4030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
			}
		}
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		noMoreRecords = statsCurrentRound.lastEndKey == allKeys.end;
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		failedRequest = Optional<Error>();
															#line 801 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (scanRange)
															#line 4040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 803 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (g_network->isSimulated() && g_simulator->consistencyScanState == ISimulator::SimConsistencyScanState::Enabled && g_simulator->doInjectConsistencyScanCorruption.present() && g_simulator->doInjectConsistencyScanCorruption.get() && (deterministicRandom()->random01() < 0.1 || targetRange.end == allKeys.end))
															#line 4044 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 808 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (storageServerInterfaces.size() > 1)
															#line 4048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 810 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					Key corruptKey = targetRange.begin;
															#line 811 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (deterministicRandom()->coinflip() && targetRange.end.size() > 0)
															#line 4054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 812 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						Key corruptKey2 = targetRange.end.substr(0, targetRange.end.size() - 1);
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (corruptKey2 > corruptKey)
															#line 4060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						{
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							corruptKey = corruptKey2;
															#line 4064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						}
					}
															#line 817 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->consistencyScanCorruptRequestKey = corruptKey;
															#line 818 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					std::pair<UID, NetworkAddress> meCorruptor = { memState->csId, g_network->getLocalAddress() };
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->consistencyScanCorruptor = meCorruptor;
															#line 821 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->updateConsistencyScanState( ISimulator::SimConsistencyScanState::Enabled, ISimulator::SimConsistencyScanState::Enabled_InjectCorruption);
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent( SevWarnAlways, "ConsistencyScanProgressScanRangeInjectCorruption", memState->csId) .detail("StartKey", targetRange.begin) .detail("CorruptKey", corruptKey) .detail("Storages", storageServerInterfaces.size());
															#line 4077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
				else
				{
															#line 831 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					CODE_PROBE(true, "skipping consistency scan corruption check because only 1 replica");
															#line 832 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->updateConsistencyScanState( ISimulator::SimConsistencyScanState::Enabled, ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent(SevWarnAlways, "ConsistencyScanProgressScanRangeSkipInjectCorruption", memState->csId) .detail("StartKey", targetRange.begin);
															#line 4087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
			}
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 4092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanRangeStart", memState->csId) .detail("StartKey", targetRange.begin);
															#line 4096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			replicatedBytesRead = 0;
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			logicalBytesRead = 0;
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			errors = 0;
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 4106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont3loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont3loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont3loopBody1loopBody1cont4(int loopDepth) 
	{
															#line 990 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (noMoreRecords)
															#line 4195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			CODE_PROBE(true, "Consistency Scan completed a round");
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.endVersion = tr->getReadVersion().get();
															#line 994 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.endTime = now();
															#line 995 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.lastEndKey = Key();
															#line 996 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			statsCurrentRound.complete = true;
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 4209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 999 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressRoundComplete", memState->csId) .detail("BytesRead", statsCurrentRound.logicalBytesScanned);
															#line 4213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 1005 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			restartMainLoop = true;
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			delayBeforeMainLoopRestart = delay(std::max<double>( config.minRoundTimeSeconds - (statsCurrentRound.endTime - statsCurrentRound.startTime), 0.0));
															#line 4219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		return a_body1loopBody1cont3loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont14(int loopDepth) 
	{
															#line 970 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsCurrentRound.errorCount += errors;
															#line 971 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsLifetime.errorCount += errors;
															#line 973 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsCurrentRound.logicalBytesScanned += logicalBytesRead;
															#line 974 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsCurrentRound.replicatedBytesRead += replicatedBytesRead;
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsLifetime.logicalBytesScanned += logicalBytesRead;
															#line 977 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		statsLifetime.replicatedBytesRead += replicatedBytesRead;
															#line 979 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->stats.logicalBytesScanned += logicalBytesRead;
															#line 980 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->stats.replicatedBytesRead += replicatedBytesRead;
															#line 982 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 4245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 983 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressScanRangeEnd", memState->csId) .detail("BytesRead", logicalBytesRead) .detail("ProgressKey", statsCurrentRound.lastEndKey);
															#line 4249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 867 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		firstValidServer = Optional<int>();
															#line 869 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->stats.requests += storageServerInterfaces.size();
															#line 870 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		replicatedBytesReadThisLoop = 0;
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<int> __when_expr_8 = consistencyCheckReadData(memState->csId, db, targetRange, tr->getReadVersion().get(), &storageServerInterfaces, &keyValueFutures, &firstValidServer, &replicatedBytesReadThisLoop, statsCurrentRound.startVersion);
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1cont3loopBody1loopBody1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1when1(__when_expr_8.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 9;
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 8, int >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 4281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3loopBody1loopBody1cont14(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1(int const& newErrors,int loopDepth) 
	{
															#line 880 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		errors += newErrors;
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->stats.inconsistencies += newErrors;
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < storageServerInterfaces.size();i++) {
															#line 885 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[i].get();
															#line 886 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!rangeResult.present())
															#line 4311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 887 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				failedRequest = rangeResult.getError();
															#line 4315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				break;
			}
			else
			{
															#line 889 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (rangeResult.get().error.present())
															#line 4322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					failedRequest = rangeResult.get().error.get();
															#line 4326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					break;
				}
			}
		}
															#line 896 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		totalReadBytesFromStorageServers += replicatedBytesReadThisLoop;
															#line 897 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!failedRequest.present() && !newErrors)
															#line 4335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 898 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(firstValidServer.present());
															#line 899 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			GetKeyValuesReply rangeResult = keyValueFutures[firstValidServer.get()].get().get();
															#line 900 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			logicalBytesRead += rangeResult.data.expectedSize();
															#line 901 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			replicatedBytesRead += replicatedBytesReadThisLoop;
															#line 902 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!rangeResult.more)
															#line 4347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 903 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = targetRange.end;
															#line 904 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				noMoreRecords = statsCurrentRound.lastEndKey == allKeys.end;
															#line 4353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 907 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				VectorRef<KeyValueRef> result = keyValueFutures[firstValidServer.get()].get().get().data;
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT(result.size() > 0);
															#line 910 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = keyAfter(result.back().key);
															#line 911 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				targetRange = KeyRangeRef(statsCurrentRound.lastEndKey, targetRange.end);
															#line 912 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (targetRange.empty())
															#line 4368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					noMoreRecords = targetRange.end == allKeys.end;
															#line 4372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
				}
			}
		}
		else
		{
															#line 917 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!failedRequest.present() && newErrors)
															#line 4381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 920 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				Key nextKey = statsCurrentRound.lastEndKey;
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				for(int i = 0;i < storageServerInterfaces.size();i++) {
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					GetKeyValuesReply rangeResult = keyValueFutures[i].get().get();
															#line 923 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (i == firstValidServer.get())
															#line 4391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 924 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						logicalBytesRead += rangeResult.data.expectedSize();
															#line 4395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					}
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					Key storageNextKey = (rangeResult.more && rangeResult.data.size() > 0) ? keyAfter(rangeResult.data.back().key) : targetRange.end;
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (storageNextKey > nextKey)
															#line 4401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						nextKey = storageNextKey;
															#line 4405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					}
				}
															#line 933 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				replicatedBytesRead += replicatedBytesReadThisLoop;
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = nextKey;
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (nextKey == targetRange.end)
															#line 4414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					noMoreRecords = nextKey == allKeys.end;
															#line 4418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
				}
				else
				{
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					targetRange = KeyRangeRef(nextKey, targetRange.end);
															#line 4425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
			}
			else
			{
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				CODE_PROBE(failedRequest.get().code() == error_code_transaction_too_old, "consistency scan loop shard too large for one transaction");
															#line 945 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (failedRequest.get().code() != error_code_transaction_too_old)
															#line 4434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent("ConsistencyScan_FailedRequest", memState->csId) .errorUnsuppressed(failedRequest.get()) .suppressFor(5.0);
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					++memState->stats.failedRequests;
															#line 4440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
															#line 952 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT(failedRequest.get().code() != error_code_operation_cancelled);
															#line 955 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				totalReadBytesFromStorageServers += 100000;
															#line 4446 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
															#line 963 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		double ratio = SERVER_KNOBS->CONSISTENCY_SCAN_ACTIVE_THROTTLE_RATIO;
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ratio = std::max(0.0, std::min(1.0, ratio));
															#line 965 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int sleepBytes = (int)(totalReadBytesFromStorageServers * ratio);
															#line 966 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		totalReadBytesFromStorageServers -= sleepBytes;
															#line 967 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_9 = readRateControl->getAllowance(sleepBytes);
															#line 967 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1cont3loopBody1loopBody1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 10;
															#line 967 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 9, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 4467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1(int && newErrors,int loopDepth) 
	{
															#line 880 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		errors += newErrors;
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->stats.inconsistencies += newErrors;
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < storageServerInterfaces.size();i++) {
															#line 885 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[i].get();
															#line 886 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!rangeResult.present())
															#line 4484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 887 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				failedRequest = rangeResult.getError();
															#line 4488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				break;
			}
			else
			{
															#line 889 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (rangeResult.get().error.present())
															#line 4495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					failedRequest = rangeResult.get().error.get();
															#line 4499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					break;
				}
			}
		}
															#line 896 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		totalReadBytesFromStorageServers += replicatedBytesReadThisLoop;
															#line 897 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!failedRequest.present() && !newErrors)
															#line 4508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 898 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(firstValidServer.present());
															#line 899 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			GetKeyValuesReply rangeResult = keyValueFutures[firstValidServer.get()].get().get();
															#line 900 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			logicalBytesRead += rangeResult.data.expectedSize();
															#line 901 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			replicatedBytesRead += replicatedBytesReadThisLoop;
															#line 902 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!rangeResult.more)
															#line 4520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 903 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = targetRange.end;
															#line 904 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				noMoreRecords = statsCurrentRound.lastEndKey == allKeys.end;
															#line 4526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 907 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				VectorRef<KeyValueRef> result = keyValueFutures[firstValidServer.get()].get().get().data;
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT(result.size() > 0);
															#line 910 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = keyAfter(result.back().key);
															#line 911 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				targetRange = KeyRangeRef(statsCurrentRound.lastEndKey, targetRange.end);
															#line 912 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (targetRange.empty())
															#line 4541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					noMoreRecords = targetRange.end == allKeys.end;
															#line 4545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
				}
			}
		}
		else
		{
															#line 917 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!failedRequest.present() && newErrors)
															#line 4554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 920 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				Key nextKey = statsCurrentRound.lastEndKey;
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				for(int i = 0;i < storageServerInterfaces.size();i++) {
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					GetKeyValuesReply rangeResult = keyValueFutures[i].get().get();
															#line 923 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (i == firstValidServer.get())
															#line 4564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 924 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						logicalBytesRead += rangeResult.data.expectedSize();
															#line 4568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					}
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					Key storageNextKey = (rangeResult.more && rangeResult.data.size() > 0) ? keyAfter(rangeResult.data.back().key) : targetRange.end;
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (storageNextKey > nextKey)
															#line 4574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						nextKey = storageNextKey;
															#line 4578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					}
				}
															#line 933 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				replicatedBytesRead += replicatedBytesReadThisLoop;
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				statsCurrentRound.lastEndKey = nextKey;
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (nextKey == targetRange.end)
															#line 4587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					noMoreRecords = nextKey == allKeys.end;
															#line 4591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
				}
				else
				{
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					targetRange = KeyRangeRef(nextKey, targetRange.end);
															#line 4598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
			}
			else
			{
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				CODE_PROBE(failedRequest.get().code() == error_code_transaction_too_old, "consistency scan loop shard too large for one transaction");
															#line 945 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (failedRequest.get().code() != error_code_transaction_too_old)
															#line 4607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent("ConsistencyScan_FailedRequest", memState->csId) .errorUnsuppressed(failedRequest.get()) .suppressFor(5.0);
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					++memState->stats.failedRequests;
															#line 4613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
															#line 952 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT(failedRequest.get().code() != error_code_operation_cancelled);
															#line 955 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				totalReadBytesFromStorageServers += 100000;
															#line 4619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				return a_body1loopBody1cont3loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
															#line 963 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		double ratio = SERVER_KNOBS->CONSISTENCY_SCAN_ACTIVE_THROTTLE_RATIO;
															#line 964 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ratio = std::max(0.0, std::min(1.0, ratio));
															#line 965 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int sleepBytes = (int)(totalReadBytesFromStorageServers * ratio);
															#line 966 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		totalReadBytesFromStorageServers -= sleepBytes;
															#line 967 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_9 = readRateControl->getAllowance(sleepBytes);
															#line 967 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1cont3loopBody1loopBody1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 10;
															#line 967 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 9, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 4640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1when1(int const& newErrors,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1(newErrors, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1when1(int && newErrors,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1(std::move(newErrors), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 8, int >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 8, int >*,int const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 8, int >*,int && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 8, int >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopBody1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopBody1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont3loopBody1loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(const Error& e2,int loopDepth=0) 
	{
		try {
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevError, "ConsistencyScan_UnexpectedError", memState->csId).error(e2);
															#line 1026 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			return a_body1Catch1(e2, std::max(0, loopDepth - 3));
															#line 4826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont3loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont3loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1loopBody1cont3loopBody1loopBody1Catch1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont3loopBody1loopBody1Catch1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont7(int loopDepth) 
	{
															#line 1084 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_14 = readRateControl->getAllowance(totalReadBytesFromStorageServers);
															#line 1084 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont3loopBody1cont7when1(__when_expr_14.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 15;
															#line 1084 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 14, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 4947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 1042 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 4969 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1043 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopSaveStart", memState->csId) .detail("ProgressKey", statsCurrentRound.lastEndKey);
															#line 4973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		try {
															#line 1047 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			systemDB->setOptions(tr);
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Optional<Versionstamp>> __when_expr_11 = cs.trigger.get(tr);
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1loopBody1cont3loopBody1cont1loopBody1when1(__when_expr_11.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 12;
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 4987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1067 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 5022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1068 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopSaveError", memState->csId) .errorUnsuppressed(e) .detail("ProgressKey", statsCurrentRound.lastEndKey);
															#line 5026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_13 = tr->onError(e);
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 3));
															#line 5032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 3)); else return a_body1loopBody1cont3loopBody1cont1loopBody1Catch1when1(__when_expr_13.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 14;
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 13, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 5037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1cont3(Optional<Versionstamp> const& csVersion2,int loopDepth) 
	{
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (csVersion2 != configVersion)
															#line 5052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1050 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 5056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1051 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopVersionMismatch2", memState->csId);
															#line 5060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 1053 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			restartMainLoop = true;
															#line 5064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			return a_body1loopBody1cont3loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1056 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		cs.currentRoundStats().set(tr, statsCurrentRound);
															#line 1057 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		cs.lifetimeStats().set(tr, statsLifetime);
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_12 = tr->commit();
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1loopBody1cont3loopBody1cont1loopBody1cont3when1(__when_expr_12.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 13;
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 12, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 5080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1cont3(Optional<Versionstamp> && csVersion2,int loopDepth) 
	{
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (csVersion2 != configVersion)
															#line 5089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1050 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 5093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1051 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopVersionMismatch2", memState->csId);
															#line 5097 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 1053 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			restartMainLoop = true;
															#line 5101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			return a_body1loopBody1cont3loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1056 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		cs.currentRoundStats().set(tr, statsCurrentRound);
															#line 1057 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		cs.lifetimeStats().set(tr, statsLifetime);
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_12 = tr->commit();
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1loopBody1cont3loopBody1cont1loopBody1cont3when1(__when_expr_12.get(), loopDepth); };
		static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 13;
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 12, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 5117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1when1(Optional<Versionstamp> const& csVersion2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1cont3(csVersion2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1when1(Optional<Versionstamp> && csVersion2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1cont3(std::move(csVersion2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >*,Optional<Versionstamp> const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >*,Optional<Versionstamp> && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 1060 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 5201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1061 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopDurable", memState->csId) .detail("BytesRead", statsCurrentRound.logicalBytesScanned) .detail("ProgressKey", statsCurrentRound.lastEndKey);
															#line 5205 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		return a_body1loopBody1cont3loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 1060 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 5215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1061 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressScanLoopDurable", memState->csId) .detail("BytesRead", statsCurrentRound.logicalBytesScanned) .detail("ProgressKey", statsCurrentRound.lastEndKey);
															#line 5219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		return a_body1loopBody1cont3loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1loopBody1cont3loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1loopBody1cont3loopBody1cont12(Void const& _,int loopDepth) 
	{
															#line 1086 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 5391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1087 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressRateLimited", memState->csId);
															#line 5395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1090 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (restartMainLoop)
															#line 5399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1091 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 5403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressWait", memState->csId);
															#line 5407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 1094 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			memState->stats.waitingBetweenRounds = true;
															#line 1095 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_15 = delayBeforeMainLoopRestart;
															#line 1095 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont3loopBody1cont12when1(__when_expr_15.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 16;
															#line 1095 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 15, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 5420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3loopBody1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont12(Void && _,int loopDepth) 
	{
															#line 1086 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (DEBUG_SCAN_PROGRESS)
															#line 5434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1087 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevDebug, "ConsistencyScanProgressRateLimited", memState->csId);
															#line 5438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1090 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (restartMainLoop)
															#line 5442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1091 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (DEBUG_SCAN_PROGRESS)
															#line 5446 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent(SevDebug, "ConsistencyScanProgressWait", memState->csId);
															#line 5450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 1094 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			memState->stats.waitingBetweenRounds = true;
															#line 1095 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_15 = delayBeforeMainLoopRestart;
															#line 1095 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 5458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont3loopBody1cont12when1(__when_expr_15.get(), loopDepth); };
			static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 16;
															#line 1095 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanCoreActor, 15, Void >*>(static_cast<ConsistencyScanCoreActor*>(this)));
															#line 5463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3loopBody1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1loopBody1cont3loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1loopBody1cont3loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1loopBody1cont3loopBody1cont12cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont12cont3(Void const& _,int loopDepth) 
	{
															#line 1096 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->stats.waitingBetweenRounds = false;
															#line 5558 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		return a_body1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont12cont3(Void && _,int loopDepth) 
	{
															#line 1096 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		memState->stats.waitingBetweenRounds = false;
															#line 5567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		return a_body1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont12cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont12cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanCoreActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanCoreActor*>(this)->ActorCallback< ConsistencyScanCoreActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1loopBody1cont3loopBody1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanCoreActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1loopBody1cont3loopBody1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< ConsistencyScanCoreActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), 15);

	}
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database db;
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ConsistencyScanMemoryState> memState;
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanState cs;
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 540 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<SystemTransactionGenerator<DatabaseContext>> systemDB;
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Future<Void> pollSize;
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t readRateLimit;
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<IRateControl> readRateControl;
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanState::Config config;
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<Versionstamp> configVersion;
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanState::LifetimeStats statsLifetime;
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanState::RoundStats statsCurrentRound;
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Future<Void> watch;
															#line 654 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool restartMainLoop;
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Future<Void> delayBeforeMainLoopRestart;
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int totalReadBytesFromStorageServers;
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanState::RoundStats savedCurrentRoundState;
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	RangeResult shardBoundaries;
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<StorageServerInterface> storageServerInterfaces;
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<Versionstamp> csVersion;
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<ConsistencyScanState::RangeConfigMap::RangeValue> configRange;
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Key beginKey;
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	KeyRange targetRange;
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool noMoreRecords;
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<Error> failedRequest;
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t replicatedBytesRead;
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t logicalBytesRead;
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int errors;
															#line 867 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyValuesReply>>> keyValueFutures;
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<int> firstValidServer;
															#line 870 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t replicatedBytesReadThisLoop;
															#line 5709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
};
// This generated class is to be used only via consistencyScanCore()
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class ConsistencyScanCoreActor final : public Actor<Void>, public ActorCallback< ConsistencyScanCoreActor, 0, Void >, public ActorCallback< ConsistencyScanCoreActor, 1, Void >, public ActorCallback< ConsistencyScanCoreActor, 2, Void >, public ActorCallback< ConsistencyScanCoreActor, 3, Void >, public ActorCallback< ConsistencyScanCoreActor, 4, Void >, public ActorCallback< ConsistencyScanCoreActor, 5, Void >, public ActorCallback< ConsistencyScanCoreActor, 6, Void >, public ActorCallback< ConsistencyScanCoreActor, 7, Void >, public ActorCallback< ConsistencyScanCoreActor, 8, int >, public ActorCallback< ConsistencyScanCoreActor, 9, Void >, public ActorCallback< ConsistencyScanCoreActor, 10, Void >, public ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >, public ActorCallback< ConsistencyScanCoreActor, 12, Void >, public ActorCallback< ConsistencyScanCoreActor, 13, Void >, public ActorCallback< ConsistencyScanCoreActor, 14, Void >, public ActorCallback< ConsistencyScanCoreActor, 15, Void >, public FastAllocated<ConsistencyScanCoreActor>, public ConsistencyScanCoreActorState<ConsistencyScanCoreActor> {
															#line 5714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
	using FastAllocated<ConsistencyScanCoreActor>::operator new;
	using FastAllocated<ConsistencyScanCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4287465423963601408UL, 3007448864896037632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConsistencyScanCoreActor, 0, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 1, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 2, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 3, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 4, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 5, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 6, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 7, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 8, int >;
friend struct ActorCallback< ConsistencyScanCoreActor, 9, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 10, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >;
friend struct ActorCallback< ConsistencyScanCoreActor, 12, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 13, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 14, Void >;
friend struct ActorCallback< ConsistencyScanCoreActor, 15, Void >;
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanCoreActor(Database const& db,Reference<ConsistencyScanMemoryState> const& memState,ConsistencyScanState const& cs) 
															#line 5746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		 : Actor<Void>(),
		   ConsistencyScanCoreActorState<ConsistencyScanCoreActor>(db, memState, cs),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consistencyScanCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6734742563649243904UL, 7957931058348816896UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consistencyScanCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consistencyScanCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 8, int >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 11, Optional<Versionstamp> >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 14, Void >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< ConsistencyScanCoreActor, 15, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<Void> consistencyScanCore( Database const& db, Reference<ConsistencyScanMemoryState> const& memState, ConsistencyScanState const& cs ) {
															#line 534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<Void>(new ConsistencyScanCoreActor(db, memState, cs));
															#line 5794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
}

#line 1102 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

															#line 5799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
namespace {
// This generated class is to be used only via sometimesRandomlyClearStatsInSim()
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class SometimesRandomlyClearStatsInSimActor>
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class SometimesRandomlyClearStatsInSimActorState {
															#line 5806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	SometimesRandomlyClearStatsInSimActorState(Database const& db,Reference<ConsistencyScanMemoryState> const& memState) 
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : db(db),
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   memState(memState)
															#line 5815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
	{
		fdb_probe_actor_create("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this));

	}
	~SometimesRandomlyClearStatsInSimActorState() 
	{
		fdb_probe_actor_destroy("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1104 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 1106 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			tr = makeReference<ReadYourWritesTransaction>(db);
															#line 1107 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			cs = ConsistencyScanState();
															#line 1109 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (BUGGIFY_WITH_PROB(0.1) && !g_simulator->speedUpSimulation)
															#line 5836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1110 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyScan_RandomStatClearWaiting", memState->csId).log();
															#line 1111 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(deterministicRandom()->randomInt(1, 60));
															#line 1111 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 1;
															#line 1111 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >*>(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)));
															#line 5849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SometimesRandomlyClearStatsInSimActorState();
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1128 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SometimesRandomlyClearStatsInSimActorState(); static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->destroy(); return 0; }
															#line 5877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		new (&static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SometimesRandomlyClearStatsInSimActorState();
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1113 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyScan_RandomStatClearing", memState->csId).log();
															#line 1114 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 5891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1113 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyScan_RandomStatClearing", memState->csId).log();
															#line 1114 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 5902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state > 0) static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 0;
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyScan_RandomStatCleared", memState->csId).log();
															#line 5986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 1116 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			SystemDBWriteLockedNow(db.getReference())->setOptions(tr);
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_1 = cs.clearStats(tr);
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont2loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 2;
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >*>(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)));
															#line 6012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1121 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 1121 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 4;
															#line 1121 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >*>(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)));
															#line 6054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 3;
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >*>(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)));
															#line 6076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 3;
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >*>(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)));
															#line 6092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state > 0) static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 0;
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state > 0) static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 0;
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state > 0) static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->actor_wait_state = 0;
		static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database db;
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ConsistencyScanMemoryState> memState;
															#line 1106 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1107 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanState cs;
															#line 6354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
};
// This generated class is to be used only via sometimesRandomlyClearStatsInSim()
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class SometimesRandomlyClearStatsInSimActor final : public Actor<Void>, public ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >, public ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >, public ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >, public ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >, public FastAllocated<SometimesRandomlyClearStatsInSimActor>, public SometimesRandomlyClearStatsInSimActorState<SometimesRandomlyClearStatsInSimActor> {
															#line 6359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
	using FastAllocated<SometimesRandomlyClearStatsInSimActor>::operator new;
	using FastAllocated<SometimesRandomlyClearStatsInSimActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1302732785826228736UL, 603599269226798592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >;
friend struct ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >;
friend struct ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >;
friend struct ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >;
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	SometimesRandomlyClearStatsInSimActor(Database const& db,Reference<ConsistencyScanMemoryState> const& memState) 
															#line 6379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		 : Actor<Void>(),
		   SometimesRandomlyClearStatsInSimActorState<SometimesRandomlyClearStatsInSimActor>(db, memState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7172944077987118336UL, 10458069167030924544UL);
		ActorExecutionContextHelper __helper(static_cast<SometimesRandomlyClearStatsInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sometimesRandomlyClearStatsInSim");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sometimesRandomlyClearStatsInSim", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SometimesRandomlyClearStatsInSimActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SometimesRandomlyClearStatsInSimActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SometimesRandomlyClearStatsInSimActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SometimesRandomlyClearStatsInSimActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<Void> sometimesRandomlyClearStatsInSim( Database const& db, Reference<ConsistencyScanMemoryState> const& memState ) {
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<Void>(new SometimesRandomlyClearStatsInSimActor(db, memState));
															#line 6415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
}

#line 1130 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

void resetSimCorruptionCheckOnDeath(Reference<ConsistencyScanMemoryState> memState) {
	if (!g_network->isSimulated()) {
		return;
	}
	if (g_simulator->consistencyScanCorruptor.present() &&
	    g_simulator->consistencyScanCorruptor.get().first == memState->csId) {
		TraceEvent("ConsistencyScan_ResetCorruptionOnDeath");
		CODE_PROBE(
		    true, "Consistency Scan skipped corruption check because scan died in the middle", probe::decoration::rare);
		g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabled_InjectCorruption,
		                                        ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
	}
}

															#line 6434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
namespace {
// This generated class is to be used only via consistencyScan()
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class ConsistencyScanActor>
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class ConsistencyScanActorState {
															#line 6441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanActorState(ConsistencyScanInterface const& csInterf,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : csInterf(csInterf),
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   dbInfo(dbInfo),
															#line 1146 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   db(openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, LockAware::True)),
															#line 1147 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   actors(),
															#line 1148 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   memState(makeReference<ConsistencyScanMemoryState>(dbInfo, csInterf.id()))
															#line 6456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
	{
		fdb_probe_actor_create("consistencyScan", reinterpret_cast<unsigned long>(this));

	}
	~ConsistencyScanActorState() 
	{
		fdb_probe_actor_destroy("consistencyScan", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1151 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyScan_Start", csInterf.id()).log();
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			actors.add(traceRole(Role::CONSISTENCYSCAN, csInterf.id()));
															#line 1153 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			actors.add(waitFailureServer(csInterf.waitFailure.getFuture()));
															#line 1154 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			core = consistencyScanCore(db, memState, ConsistencyScanState());
															#line 1156 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (g_network->isSimulated())
															#line 6479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1157 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				actors.add(sometimesRandomlyClearStatsInSim(db, memState));
															#line 1162 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (g_simulator->consistencyScanCorruptor.present() && csInterf.id() != g_simulator->consistencyScanCorruptor.get().first && g_simulator->getProcessByAddress(g_simulator->consistencyScanCorruptor.get().second)->failed && g_simulator->consistencyScanState == ISimulator::SimConsistencyScanState::Enabled_InjectCorruption)
															#line 6485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1166 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent("ConsistencyScan_ResetCorruptionOnPreviousScanDeath");
															#line 1168 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabled_InjectCorruption, ISimulator::SimConsistencyScanState::Enabled_FoundCorruption);
															#line 6491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
			}
															#line 1173 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 6496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConsistencyScanActorState();
		static_cast<ConsistencyScanActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1175 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 6527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& err,int loopDepth=0) 
	{
		try {
															#line 1193 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			resetSimCorruptionCheckOnDeath(memState);
															#line 1194 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyScan_Error", csInterf.id()).errorUnsuppressed(err);
															#line 1195 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 6547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1176 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_0 = core;
															#line 1175 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<ConsistencyScanActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 1180 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		auto __when_expr_1 = csInterf.haltConsistencyScan.getFuture();
															#line 6574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<HaltConsistencyScanRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<HaltConsistencyScanRequest>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_2 = actors.getResult();
															#line 6579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<ConsistencyScanActor*>(this)->actor_wait_state = 1;
															#line 1176 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanActor, 0, Void >*>(static_cast<ConsistencyScanActor*>(this)));
															#line 1180 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ConsistencyScanActor, 1, HaltConsistencyScanRequest >*>(static_cast<ConsistencyScanActor*>(this)));
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConsistencyScanActor, 2, Void >*>(static_cast<ConsistencyScanActor*>(this)));
															#line 6588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1178 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(false);
															#line 6603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1178 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(false);
															#line 6612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(HaltConsistencyScanRequest const& req,int loopDepth) 
	{
															#line 1181 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		resetSimCorruptionCheckOnDeath(memState);
															#line 1182 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.reply.send(Void());
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		core = Void();
															#line 1184 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyScan_Halted", csInterf.id()).detail("ReqID", req.requesterID);
															#line 1185 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<ConsistencyScanActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConsistencyScanActorState(); static_cast<ConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 6629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		new (&static_cast<ConsistencyScanActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConsistencyScanActorState();
		static_cast<ConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(HaltConsistencyScanRequest && req,int loopDepth) 
	{
															#line 1181 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		resetSimCorruptionCheckOnDeath(memState);
															#line 1182 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.reply.send(Void());
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		core = Void();
															#line 1184 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyScan_Halted", csInterf.id()).detail("ReqID", req.requesterID);
															#line 1185 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<ConsistencyScanActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConsistencyScanActorState(); static_cast<ConsistencyScanActor*>(this)->destroy(); return 0; }
															#line 6649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		new (&static_cast<ConsistencyScanActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConsistencyScanActorState();
		static_cast<ConsistencyScanActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 1188 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(false);
															#line 1189 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 6663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 1188 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(false);
															#line 1189 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		return a_body1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 6673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConsistencyScanActor*>(this)->actor_wait_state > 0) static_cast<ConsistencyScanActor*>(this)->actor_wait_state = 0;
		static_cast<ConsistencyScanActor*>(this)->ActorCallback< ConsistencyScanActor, 0, Void >::remove();
		static_cast<ConsistencyScanActor*>(this)->ActorSingleCallback< ConsistencyScanActor, 1, HaltConsistencyScanRequest >::remove();
		static_cast<ConsistencyScanActor*>(this)->ActorCallback< ConsistencyScanActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConsistencyScanActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConsistencyScanActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ConsistencyScanActor, 1, HaltConsistencyScanRequest >*,HaltConsistencyScanRequest const& value) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ConsistencyScanActor, 1, HaltConsistencyScanRequest >*,HaltConsistencyScanRequest && value) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ConsistencyScanActor, 1, HaltConsistencyScanRequest >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConsistencyScanActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConsistencyScanActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanInterface csInterf;
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1146 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database db;
															#line 1147 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ActorCollection actors;
															#line 1148 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<ConsistencyScanMemoryState> memState;
															#line 1154 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Future<Void> core;
															#line 6868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
};
// This generated class is to be used only via consistencyScan()
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class ConsistencyScanActor final : public Actor<Void>, public ActorCallback< ConsistencyScanActor, 0, Void >, public ActorSingleCallback< ConsistencyScanActor, 1, HaltConsistencyScanRequest >, public ActorCallback< ConsistencyScanActor, 2, Void >, public FastAllocated<ConsistencyScanActor>, public ConsistencyScanActorState<ConsistencyScanActor> {
															#line 6873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
	using FastAllocated<ConsistencyScanActor>::operator new;
	using FastAllocated<ConsistencyScanActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14729917382866340352UL, 11982728014934049024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConsistencyScanActor, 0, Void >;
friend struct ActorSingleCallback< ConsistencyScanActor, 1, HaltConsistencyScanRequest >;
friend struct ActorCallback< ConsistencyScanActor, 2, Void >;
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ConsistencyScanActor(ConsistencyScanInterface const& csInterf,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 6892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		 : Actor<Void>(),
		   ConsistencyScanActorState<ConsistencyScanActor>(csInterf, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("consistencyScan", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(866477116270183168UL, 7948926982827793408UL);
		ActorExecutionContextHelper __helper(static_cast<ConsistencyScanActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("consistencyScan");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("consistencyScan", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConsistencyScanActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<Void> consistencyScan( ConsistencyScanInterface const& csInterf, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<Void>(new ConsistencyScanActor(csInterf, dbInfo));
															#line 6925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
}

#line 1199 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

///////////////////////////////////////////////////////
// Everything below this line is not relevant to the ConsistencyScan Role anymore.
// It is only used by workloads/ConsistencyCheck

// Gets a version at which to read from the storage servers
															#line 6935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
namespace {
// This generated class is to be used only via getVersion()
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class GetVersionActor>
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetVersionActorState {
															#line 6942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetVersionActorState(Database const& cx) 
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : cx(cx)
															#line 6949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
	{
		fdb_probe_actor_create("getVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionActorState() 
	{
		fdb_probe_actor_destroy("getVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1206 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 6964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1207 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr = Transaction(cx);
															#line 1208 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 6996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		try {
															#line 1210 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 1210 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<GetVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7002 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionActor*>(this)->actor_wait_state = 1;
															#line 1210 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionActor, 0, Version >*>(static_cast<GetVersionActor*>(this)));
															#line 7007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1213 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1213 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<GetVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetVersionActor*>(this)->actor_wait_state = 2;
															#line 1213 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetVersionActor, 1, Void >*>(static_cast<GetVersionActor*>(this)));
															#line 7036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& version,int loopDepth) 
	{
															#line 1211 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 7051 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		new (&static_cast<GetVersionActor*>(this)->SAV< Version >::value()) Version(version);
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && version,int loopDepth) 
	{
															#line 1211 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 7063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		new (&static_cast<GetVersionActor*>(this)->SAV< Version >::value()) Version(version);
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(version, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionActor*>(this)->actor_wait_state > 0) static_cast<GetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionActor*>(this)->ActorCallback< GetVersionActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetVersionActor*>(this)->actor_wait_state > 0) static_cast<GetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionActor*>(this)->ActorCallback< GetVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database cx;
															#line 1207 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Transaction tr;
															#line 7237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
};
// This generated class is to be used only via getVersion()
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetVersionActor final : public Actor<Version>, public ActorCallback< GetVersionActor, 0, Version >, public ActorCallback< GetVersionActor, 1, Void >, public FastAllocated<GetVersionActor>, public GetVersionActorState<GetVersionActor> {
															#line 7242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
	using FastAllocated<GetVersionActor>::operator new;
	using FastAllocated<GetVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14454928760378547712UL, 6412169495964433920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionActor, 0, Version >;
friend struct ActorCallback< GetVersionActor, 1, Void >;
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetVersionActor(Database const& cx) 
															#line 7260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		 : Actor<Version>(),
		   GetVersionActorState<GetVersionActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4509831120537103360UL, 13615306933804954880UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<Version> getVersion( Database const& cx ) {
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<Version>(new GetVersionActor(cx));
															#line 7294 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
}

#line 1217 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

void testFailure(std::string message, bool performQuiescentChecks, bool* success, bool isError) {
	*success = false;
	TraceEvent failEvent(isError ? SevError : SevWarn, "TestFailure");
	if (performQuiescentChecks)
		failEvent.detail("Workload", "QuiescentCheck");
	else
		failEvent.detail("Workload", "ConsistencyCheck");

	failEvent.detail("Reason", "Consistency check: " + message);
}

// Get a list of storage servers(persisting keys within range "kr") from the master and compares them with the
// TLogs. If this is a quiescent check, then each commit proxy needs to respond, otherwise only one needs to
// respond. Returns false if there is a failure (in this case, keyServersPromise will never be set)
															#line 7313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
namespace {
// This generated class is to be used only via getKeyServers()
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class GetKeyServersActor>
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetKeyServersActorState {
															#line 7320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetKeyServersActorState(Database const& cx,Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> const& keyServersPromise,KeyRangeRef const& kr,bool const& performQuiescentChecks,bool const& failureIsError,bool* const& success) 
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : cx(cx),
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   keyServersPromise(keyServersPromise),
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   kr(kr),
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   performQuiescentChecks(performQuiescentChecks),
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   failureIsError(failureIsError),
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   success(success),
															#line 1239 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   keyServers(),
															#line 1242 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   keyServerLocationFutures(),
															#line 1243 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   begin(kr.begin),
															#line 1244 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   end(kr.end),
															#line 1245 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   limitKeyServers(BUGGIFY ? 1 : 100),
															#line 1246 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   span(SpanContext(deterministicRandom()->randomUniqueID(), deterministicRandom()->randomUInt64()), "WL:ConsistencyCheck"_loc)
															#line 7349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
	{
		fdb_probe_actor_create("getKeyServers", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyServersActorState() 
	{
		fdb_probe_actor_destroy("getKeyServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1249 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 7364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyServersActorState();
		static_cast<GetKeyServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1299 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyServersPromise.send(keyServers);
															#line 1300 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<GetKeyServersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetKeyServersActorState(); static_cast<GetKeyServersActor*>(this)->destroy(); return 0; }
															#line 7389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		new (&static_cast<GetKeyServersActor*>(this)->SAV< bool >::value()) bool(true);
		this->~GetKeyServersActorState();
		static_cast<GetKeyServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1249 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!(begin < end))
															#line 7408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1250 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Reference<CommitProxyInfo>> __when_expr_0 = cx->getCommitProxiesFuture(UseProvisionalProxies::False);
															#line 1250 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<GetKeyServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetKeyServersActor*>(this)->actor_wait_state = 1;
															#line 1250 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >*>(static_cast<GetKeyServersActor*>(this)));
															#line 7421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1252 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyServerLocationFutures.clear();
															#line 1253 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < commitProxyInfo->size();i++) {
															#line 1254 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyServerLocationFutures.push_back( commitProxyInfo->get(i, &CommitProxyInterface::getKeyServersLocations) .getReplyUnlessFailedFor( GetKeyServerLocationsRequest( span.context, TenantInfo(), begin, end, limitKeyServers, false, latestVersion, Arena()), 2, 0));
															#line 7447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1262 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyServersInsertedForThisIteration = false;
															#line 1264 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(keyServerLocationFutures);
															#line 1263 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<GetKeyServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 1291 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_2 = cx->onProxiesChanged();
															#line 7459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
		static_cast<GetKeyServersActor*>(this)->actor_wait_state = 2;
															#line 1264 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyServersActor, 1, Void >*>(static_cast<GetKeyServersActor*>(this)));
															#line 1291 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyServersActor, 2, Void >*>(static_cast<GetKeyServersActor*>(this)));
															#line 7466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<CommitProxyInfo> const& __commitProxyInfo,int loopDepth) 
	{
															#line 1250 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		commitProxyInfo = __commitProxyInfo;
															#line 7475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<CommitProxyInfo> && __commitProxyInfo,int loopDepth) 
	{
		commitProxyInfo = std::move(__commitProxyInfo);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyServersActor*>(this)->actor_wait_state > 0) static_cast<GetKeyServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyServersActor*>(this)->ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >*,Reference<CommitProxyInfo> const& value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >*,Reference<CommitProxyInfo> && value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1294 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!keyServersInsertedForThisIteration)
															#line 7554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1295 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 1295 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<GetKeyServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetKeyServersActor*>(this)->actor_wait_state = 3;
															#line 1295 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetKeyServersActor, 3, Void >*>(static_cast<GetKeyServersActor*>(this)));
															#line 7565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
															#line 1266 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < keyServerLocationFutures.size();i++) {
															#line 1267 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyServerLocationsReply> shards = keyServerLocationFutures[i].get();
															#line 1271 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (performQuiescentChecks && !shards.present())
															#line 7583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1272 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_CommitProxyUnavailable") .error(shards.getError()) .detail("CommitProxyID", commitProxyInfo->getId(i));
															#line 1275 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				testFailure("Commit proxy unavailable", performQuiescentChecks, success, failureIsError);
															#line 1276 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!static_cast<GetKeyServersActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetKeyServersActorState(); static_cast<GetKeyServersActor*>(this)->destroy(); return 0; }
															#line 7591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				new (&static_cast<GetKeyServersActor*>(this)->SAV< bool >::value()) bool(false);
				this->~GetKeyServersActorState();
				static_cast<GetKeyServersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1281 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (shards.present() && !keyServersInsertedForThisIteration)
															#line 7599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1282 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				keyServers.insert(keyServers.end(), shards.get().results.begin(), shards.get().results.end());
															#line 1283 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				keyServersInsertedForThisIteration = true;
															#line 1284 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				begin = shards.get().results.back().first.end;
															#line 1286 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!performQuiescentChecks)
															#line 7609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
					break;
				}
			}
		}
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
															#line 1266 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < keyServerLocationFutures.size();i++) {
															#line 1267 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyServerLocationsReply> shards = keyServerLocationFutures[i].get();
															#line 1271 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (performQuiescentChecks && !shards.present())
															#line 7627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1272 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_CommitProxyUnavailable") .error(shards.getError()) .detail("CommitProxyID", commitProxyInfo->getId(i));
															#line 1275 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				testFailure("Commit proxy unavailable", performQuiescentChecks, success, failureIsError);
															#line 1276 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!static_cast<GetKeyServersActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetKeyServersActorState(); static_cast<GetKeyServersActor*>(this)->destroy(); return 0; }
															#line 7635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				new (&static_cast<GetKeyServersActor*>(this)->SAV< bool >::value()) bool(false);
				this->~GetKeyServersActorState();
				static_cast<GetKeyServersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1281 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (shards.present() && !keyServersInsertedForThisIteration)
															#line 7643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1282 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				keyServers.insert(keyServers.end(), shards.get().results.begin(), shards.get().results.end());
															#line 1283 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				keyServersInsertedForThisIteration = true;
															#line 1284 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				begin = shards.get().results.back().first.end;
															#line 1286 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!performQuiescentChecks)
															#line 7653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
					break;
				}
			}
		}
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyServersActor*>(this)->actor_wait_state > 0) static_cast<GetKeyServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyServersActor*>(this)->ActorCallback< GetKeyServersActor, 1, Void >::remove();
		static_cast<GetKeyServersActor*>(this)->ActorCallback< GetKeyServersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyServersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKeyServersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetKeyServersActor*>(this)->actor_wait_state > 0) static_cast<GetKeyServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyServersActor*>(this)->ActorCallback< GetKeyServersActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetKeyServersActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetKeyServersActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database cx;
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> keyServersPromise;
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	KeyRangeRef kr;
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool performQuiescentChecks;
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool failureIsError;
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool* success;
															#line 1239 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> keyServers;
															#line 1242 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyServerLocationsReply>>> keyServerLocationFutures;
															#line 1243 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Key begin;
															#line 1244 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Key end;
															#line 1245 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int limitKeyServers;
															#line 1246 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Span span;
															#line 1250 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<CommitProxyInfo> commitProxyInfo;
															#line 1262 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool keyServersInsertedForThisIteration;
															#line 7917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
};
// This generated class is to be used only via getKeyServers()
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetKeyServersActor final : public Actor<bool>, public ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >, public ActorCallback< GetKeyServersActor, 1, Void >, public ActorCallback< GetKeyServersActor, 2, Void >, public ActorCallback< GetKeyServersActor, 3, Void >, public FastAllocated<GetKeyServersActor>, public GetKeyServersActorState<GetKeyServersActor> {
															#line 7922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
	using FastAllocated<GetKeyServersActor>::operator new;
	using FastAllocated<GetKeyServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13623395313519737600UL, 4605278741195398912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >;
friend struct ActorCallback< GetKeyServersActor, 1, Void >;
friend struct ActorCallback< GetKeyServersActor, 2, Void >;
friend struct ActorCallback< GetKeyServersActor, 3, Void >;
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetKeyServersActor(Database const& cx,Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> const& keyServersPromise,KeyRangeRef const& kr,bool const& performQuiescentChecks,bool const& failureIsError,bool* const& success) 
															#line 7942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		 : Actor<bool>(),
		   GetKeyServersActorState<GetKeyServersActor>(cx, keyServersPromise, kr, performQuiescentChecks, failureIsError, success),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2154856847302521088UL, 16578737356717173248UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyServersActor, 0, Reference<CommitProxyInfo> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyServersActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetKeyServersActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<bool> getKeyServers( Database const& cx, Promise<std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>>> const& keyServersPromise, KeyRangeRef const& kr, bool const& performQuiescentChecks, bool const& failureIsError, bool* const& success ) {
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<bool>(new GetKeyServersActor(cx, keyServersPromise, kr, performQuiescentChecks, failureIsError, success));
															#line 7977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
}

#line 1302 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

// Retrieves the locations of all shards in the database
// Returns false if there is a failure (in this case, keyLocationPromise will never be set)
															#line 7984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
namespace {
// This generated class is to be used only via getKeyLocations()
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class GetKeyLocationsActor>
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetKeyLocationsActorState {
															#line 7991 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetKeyLocationsActorState(Database const& cx,std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> const& shards,Promise<Standalone<VectorRef<KeyValueRef>>> const& keyLocationPromise,bool const& performQuiescentChecks,bool* const& success) 
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : cx(cx),
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   shards(shards),
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   keyLocationPromise(keyLocationPromise),
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   performQuiescentChecks(performQuiescentChecks),
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   success(success),
															#line 1310 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   keyLocations(),
															#line 1311 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   beginKey(allKeys.begin.withPrefix(keyServersPrefix)),
															#line 1312 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   endKey(allKeys.end.withPrefix(keyServersPrefix)),
															#line 1313 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   i(0),
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   onErrorTr(cx)
															#line 8016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
	{
		fdb_probe_actor_create("getKeyLocations", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyLocationsActorState() 
	{
		fdb_probe_actor_destroy("getKeyLocations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1318 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 8031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyLocationsActorState();
		static_cast<GetKeyLocationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1405 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyLocationPromise.send(keyLocations);
															#line 1406 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<GetKeyLocationsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetKeyLocationsActorState(); static_cast<GetKeyLocationsActor*>(this)->destroy(); return 0; }
															#line 8056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		new (&static_cast<GetKeyLocationsActor*>(this)->SAV< bool >::value()) bool(true);
		this->~GetKeyLocationsActorState();
		static_cast<GetKeyLocationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1318 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!(i < shards.size()))
															#line 8075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 8081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1318 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		i++;
															#line 8103 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!(beginKey < std::min<KeyRef>(shards[i].first.end, endKey)))
															#line 8119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 1321 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Version> __when_expr_0 = getVersion(cx);
															#line 1321 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<GetKeyLocationsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKeyLocationsActor*>(this)->actor_wait_state = 1;
															#line 1321 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocationsActor, 0, Version >*>(static_cast<GetKeyLocationsActor*>(this)));
															#line 8133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1398 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			err = e;
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_2 = onErrorTr.onError(err);
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<GetKeyLocationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetKeyLocationsActor*>(this)->actor_wait_state = 3;
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocationsActor, 2, Void >*>(static_cast<GetKeyLocationsActor*>(this)));
															#line 8177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Version const& version,int loopDepth) 
	{
															#line 1323 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		GetKeyValuesRequest req;
															#line 1324 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.begin = firstGreaterOrEqual(beginKey);
															#line 1325 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.end = firstGreaterOrEqual(std::min<KeyRef>(shards[i].first.end, endKey));
															#line 1326 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.limit = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT;
															#line 1327 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.limitBytes = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES;
															#line 1328 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.version = version;
															#line 1329 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.tags = TagSet();
															#line 1332 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 1333 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for( const auto& kv : shards[i].second ) {
															#line 1334 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			resetReply(req);
															#line 1335 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 8212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1336 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				cx->getLatestCommitVersion(kv, req.version, req.ssLatestCommitVersions);
															#line 8216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 1338 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyValueFutures.push_back(kv.getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 8220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1341 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(keyValueFutures);
															#line 1341 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<GetKeyLocationsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetKeyLocationsActor*>(this)->actor_wait_state = 2;
															#line 1341 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocationsActor, 1, Void >*>(static_cast<GetKeyLocationsActor*>(this)));
															#line 8231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Version && version,int loopDepth) 
	{
															#line 1323 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		GetKeyValuesRequest req;
															#line 1324 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.begin = firstGreaterOrEqual(beginKey);
															#line 1325 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.end = firstGreaterOrEqual(std::min<KeyRef>(shards[i].first.end, endKey));
															#line 1326 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.limit = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT;
															#line 1327 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.limitBytes = SERVER_KNOBS->MOVE_KEYS_KRM_LIMIT_BYTES;
															#line 1328 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.version = version;
															#line 1329 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		req.tags = TagSet();
															#line 1332 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 1333 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for( const auto& kv : shards[i].second ) {
															#line 1334 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			resetReply(req);
															#line 1335 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 8260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1336 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				cx->getLatestCommitVersion(kv, req.version, req.ssLatestCommitVersions);
															#line 8264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 1338 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyValueFutures.push_back(kv.getKeyValues.getReplyUnlessFailedFor(req, 2, 0));
															#line 8268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1341 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(keyValueFutures);
															#line 1341 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<GetKeyLocationsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetKeyLocationsActor*>(this)->actor_wait_state = 2;
															#line 1341 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetKeyLocationsActor, 1, Void >*>(static_cast<GetKeyLocationsActor*>(this)));
															#line 8279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(version, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyLocationsActor*>(this)->actor_wait_state > 0) static_cast<GetKeyLocationsActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyLocationsActor*>(this)->ActorCallback< GetKeyLocationsActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyLocationsActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 1343 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int firstValidStorageServer = -1;
															#line 1346 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int j = 0;j < keyValueFutures.size();j++) {
															#line 1347 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> reply = keyValueFutures[j].get();
															#line 1349 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!reply.present() || reply.get().error.present())
															#line 8369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1351 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (firstValidStorageServer < 0 && j == keyValueFutures.size() - 1)
															#line 8373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1352 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					return a_body1loopBody1loopBody1Catch1(all_alternatives_failed(), loopDepth);
															#line 8377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
			}
			else
			{
															#line 1356 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (firstValidStorageServer < 0)
															#line 8384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1357 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					firstValidStorageServer = j;
															#line 8388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
				else
				{
															#line 1361 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (reply.get().data != keyValueFutures[firstValidStorageServer].get().get().data || reply.get().more != keyValueFutures[firstValidStorageServer].get().get().more)
															#line 8394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						TraceEvent("ConsistencyCheck_InconsistentKeyServers") .detail("StorageServer1", shards[i].second[firstValidStorageServer].id()) .detail("StorageServer2", shards[i].second[j].id());
															#line 1366 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						testFailure("Key servers inconsistent", performQuiescentChecks, success, true);
															#line 1367 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (!static_cast<GetKeyLocationsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetKeyLocationsActorState(); static_cast<GetKeyLocationsActor*>(this)->destroy(); return 0; }
															#line 8402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						new (&static_cast<GetKeyLocationsActor*>(this)->SAV< bool >::value()) bool(false);
						this->~GetKeyLocationsActorState();
						static_cast<GetKeyLocationsActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
															#line 1371 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		auto keyValueResponse = keyValueFutures[firstValidStorageServer].get().get();
															#line 1372 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		RangeResult currentLocations = krmDecodeRanges( keyServersPrefix, KeyRangeRef(beginKey.removePrefix(keyServersPrefix), std::min<KeyRef>(shards[i].first.end, endKey).removePrefix(keyServersPrefix)), RangeResultRef(keyValueResponse.data, keyValueResponse.more));
															#line 1378 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (keyValueResponse.data.size() && beginKey == keyValueResponse.data[0].key)
															#line 8417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1379 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyLocations.push_back_deep(keyLocations.arena(), currentLocations[0]);
															#line 8421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1382 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (currentLocations.size() > 2)
															#line 8425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1383 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyLocations.append_deep(keyLocations.arena(), &currentLocations[1], currentLocations.size() - 2);
															#line 8429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1387 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(currentLocations.size() > 1);
															#line 1388 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!keyValueResponse.more)
															#line 8435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1389 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			beginKey = shards[i].first.end;
															#line 8439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		else
		{
															#line 1391 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			beginKey = keyValueResponse.data.end()[-1].key;
															#line 8445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1395 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (beginKey >= endKey)
															#line 8449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1396 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyLocations.push_back_deep(keyLocations.arena(), currentLocations.end()[-1]);
															#line 8453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 1343 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int firstValidStorageServer = -1;
															#line 1346 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int j = 0;j < keyValueFutures.size();j++) {
															#line 1347 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> reply = keyValueFutures[j].get();
															#line 1349 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!reply.present() || reply.get().error.present())
															#line 8469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1351 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (firstValidStorageServer < 0 && j == keyValueFutures.size() - 1)
															#line 8473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1352 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					return a_body1loopBody1loopBody1Catch1(all_alternatives_failed(), loopDepth);
															#line 8477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
			}
			else
			{
															#line 1356 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (firstValidStorageServer < 0)
															#line 8484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1357 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					firstValidStorageServer = j;
															#line 8488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
				else
				{
															#line 1361 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (reply.get().data != keyValueFutures[firstValidStorageServer].get().get().data || reply.get().more != keyValueFutures[firstValidStorageServer].get().get().more)
															#line 8494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 1363 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						TraceEvent("ConsistencyCheck_InconsistentKeyServers") .detail("StorageServer1", shards[i].second[firstValidStorageServer].id()) .detail("StorageServer2", shards[i].second[j].id());
															#line 1366 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						testFailure("Key servers inconsistent", performQuiescentChecks, success, true);
															#line 1367 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (!static_cast<GetKeyLocationsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetKeyLocationsActorState(); static_cast<GetKeyLocationsActor*>(this)->destroy(); return 0; }
															#line 8502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						new (&static_cast<GetKeyLocationsActor*>(this)->SAV< bool >::value()) bool(false);
						this->~GetKeyLocationsActorState();
						static_cast<GetKeyLocationsActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
															#line 1371 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		auto keyValueResponse = keyValueFutures[firstValidStorageServer].get().get();
															#line 1372 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		RangeResult currentLocations = krmDecodeRanges( keyServersPrefix, KeyRangeRef(beginKey.removePrefix(keyServersPrefix), std::min<KeyRef>(shards[i].first.end, endKey).removePrefix(keyServersPrefix)), RangeResultRef(keyValueResponse.data, keyValueResponse.more));
															#line 1378 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (keyValueResponse.data.size() && beginKey == keyValueResponse.data[0].key)
															#line 8517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1379 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyLocations.push_back_deep(keyLocations.arena(), currentLocations[0]);
															#line 8521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1382 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (currentLocations.size() > 2)
															#line 8525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1383 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyLocations.append_deep(keyLocations.arena(), &currentLocations[1], currentLocations.size() - 2);
															#line 8529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1387 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(currentLocations.size() > 1);
															#line 1388 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!keyValueResponse.more)
															#line 8535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1389 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			beginKey = shards[i].first.end;
															#line 8539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		else
		{
															#line 1391 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			beginKey = keyValueResponse.data.end()[-1].key;
															#line 8545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1395 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (beginKey >= endKey)
															#line 8549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1396 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			keyLocations.push_back_deep(keyLocations.arena(), currentLocations.end()[-1]);
															#line 8553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetKeyLocationsActor*>(this)->actor_wait_state > 0) static_cast<GetKeyLocationsActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyLocationsActor*>(this)->ActorCallback< GetKeyLocationsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetKeyLocationsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont20(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 1400 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_RetryGetKeyLocations").error(err);
															#line 8651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 1400 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_RetryGetKeyLocations").error(err);
															#line 8660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetKeyLocationsActor*>(this)->actor_wait_state > 0) static_cast<GetKeyLocationsActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyLocationsActor*>(this)->ActorCallback< GetKeyLocationsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetKeyLocationsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetKeyLocationsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database cx;
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> shards;
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Promise<Standalone<VectorRef<KeyValueRef>>> keyLocationPromise;
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool performQuiescentChecks;
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool* success;
															#line 1310 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> keyLocations;
															#line 1311 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Key beginKey;
															#line 1312 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Key endKey;
															#line 1313 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int i;
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Transaction onErrorTr;
															#line 1332 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyValuesReply>>> keyValueFutures;
															#line 1398 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Error err;
															#line 8764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
};
// This generated class is to be used only via getKeyLocations()
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetKeyLocationsActor final : public Actor<bool>, public ActorCallback< GetKeyLocationsActor, 0, Version >, public ActorCallback< GetKeyLocationsActor, 1, Void >, public ActorCallback< GetKeyLocationsActor, 2, Void >, public FastAllocated<GetKeyLocationsActor>, public GetKeyLocationsActorState<GetKeyLocationsActor> {
															#line 8769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
	using FastAllocated<GetKeyLocationsActor>::operator new;
	using FastAllocated<GetKeyLocationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3052024210111385088UL, 314707283292581632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyLocationsActor, 0, Version >;
friend struct ActorCallback< GetKeyLocationsActor, 1, Void >;
friend struct ActorCallback< GetKeyLocationsActor, 2, Void >;
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetKeyLocationsActor(Database const& cx,std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> const& shards,Promise<Standalone<VectorRef<KeyValueRef>>> const& keyLocationPromise,bool const& performQuiescentChecks,bool* const& success) 
															#line 8788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		 : Actor<bool>(),
		   GetKeyLocationsActorState<GetKeyLocationsActor>(cx, shards, keyLocationPromise, performQuiescentChecks, success),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyLocations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1792919416808650752UL, 9988447959741147648UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyLocationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyLocations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyLocations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyLocationsActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetKeyLocationsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetKeyLocationsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<bool> getKeyLocations( Database const& cx, std::vector<std::pair<KeyRange, std::vector<StorageServerInterface>>> const& shards, Promise<Standalone<VectorRef<KeyValueRef>>> const& keyLocationPromise, bool const& performQuiescentChecks, bool* const& success ) {
															#line 1305 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<bool>(new GetKeyLocationsActor(cx, shards, keyLocationPromise, performQuiescentChecks, success));
															#line 8823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
}

#line 1408 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

// Retrieves a vector of the storage servers' estimates for the size of a particular shard
// If a storage server can't be reached, its estimate will be -1
// If there is an error, then the returned vector will have 0 size
															#line 8831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
namespace {
// This generated class is to be used only via getStorageSizeEstimate()
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class GetStorageSizeEstimateActor>
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetStorageSizeEstimateActorState {
															#line 8838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetStorageSizeEstimateActorState(std::vector<StorageServerInterface> const& storageServers,KeyRangeRef const& shard) 
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : storageServers(storageServers),
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   shard(shard),
															#line 1415 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   estimatedBytes(),
															#line 1416 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   metrics(),
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   req()
															#line 8853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageSizeEstimateActorState() 
	{
		fdb_probe_actor_destroy("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1419 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.keys = shard;
															#line 1420 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.max.bytes = -1;
															#line 1421 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			req.min.bytes = 0;
															#line 1423 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			metricFutures = std::vector<Future<ErrorOr<StorageMetrics>>>();
															#line 8874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			try {
															#line 1427 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				for(int i = 0;i < storageServers.size();i++) {
															#line 1428 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					resetReply(req);
															#line 1429 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					metricFutures.push_back(storageServers[i].waitMetrics.getReplyUnlessFailedFor(req, 2, 0));
															#line 8882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
															#line 1433 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(metricFutures);
															#line 1433 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (static_cast<GetStorageSizeEstimateActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetStorageSizeEstimateActor*>(this)->actor_wait_state = 1;
															#line 1433 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageSizeEstimateActor, 0, Void >*>(static_cast<GetStorageSizeEstimateActor*>(this)));
															#line 8893 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageSizeEstimateActorState();
		static_cast<GetStorageSizeEstimateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1481 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<GetStorageSizeEstimateActor*>(this)->SAV<std::pair<std::vector<int64_t>, StorageMetrics>>::futures) { (void)(std::make_pair(estimatedBytes, metrics)); this->~GetStorageSizeEstimateActorState(); static_cast<GetStorageSizeEstimateActor*>(this)->destroy(); return 0; }
															#line 8922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		new (&static_cast<GetStorageSizeEstimateActor*>(this)->SAV< std::pair<std::vector<int64_t>, StorageMetrics> >::value()) std::pair<std::vector<int64_t>, StorageMetrics>(std::make_pair(estimatedBytes, metrics));
		this->~GetStorageSizeEstimateActorState();
		static_cast<GetStorageSizeEstimateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_ErrorFetchingMetrics") .error(e) .detail("Begin", printable(shard.begin)) .detail("End", printable(shard.end));
															#line 1478 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			estimatedBytes.clear();
															#line 8937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1435 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int firstValidStorageServer = -1;
															#line 1438 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < storageServers.size();i++) {
															#line 1439 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<StorageMetrics> reply = metricFutures[i].get();
															#line 1442 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!reply.present())
															#line 8958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1443 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_FailedToFetchMetrics") .error(reply.getError()) .detail("Begin", printable(shard.begin)) .detail("End", printable(shard.end)) .detail("StorageServer", storageServers[i].id()) .detail("IsTSS", storageServers[i].isTss() ? "True" : "False");
															#line 1449 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				estimatedBytes.push_back(-1);
															#line 8964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
			else
			{
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (reply.present())
															#line 8970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1454 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					int64_t numBytes = reply.get().bytes;
															#line 1455 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					estimatedBytes.push_back(numBytes);
															#line 1456 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (firstValidStorageServer < 0)
															#line 8978 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						firstValidStorageServer = i;
															#line 1458 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						metrics = reply.get();
															#line 8984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					}
					else
					{
															#line 1459 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (estimatedBytes[firstValidStorageServer] != numBytes)
															#line 8990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						{
															#line 1460 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							TraceEvent("ConsistencyCheck_InconsistentStorageMetrics") .detail("ByteEstimate1", estimatedBytes[firstValidStorageServer]) .detail("ByteEstimate2", numBytes) .detail("Begin", shard.begin) .detail("End", shard.end) .detail("StorageServer1", storageServers[firstValidStorageServer].id()) .detail("StorageServer2", storageServers[i].id()) .detail("IsTSS", storageServers[i].isTss() || storageServers[firstValidStorageServer].isTss() ? "True" : "False");
															#line 8994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						}
					}
				}
			}
		}
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1435 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int firstValidStorageServer = -1;
															#line 1438 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < storageServers.size();i++) {
															#line 1439 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<StorageMetrics> reply = metricFutures[i].get();
															#line 1442 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!reply.present())
															#line 9014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1443 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_FailedToFetchMetrics") .error(reply.getError()) .detail("Begin", printable(shard.begin)) .detail("End", printable(shard.end)) .detail("StorageServer", storageServers[i].id()) .detail("IsTSS", storageServers[i].isTss() ? "True" : "False");
															#line 1449 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				estimatedBytes.push_back(-1);
															#line 9020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
			else
			{
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (reply.present())
															#line 9026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1454 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					int64_t numBytes = reply.get().bytes;
															#line 1455 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					estimatedBytes.push_back(numBytes);
															#line 1456 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (firstValidStorageServer < 0)
															#line 9034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						firstValidStorageServer = i;
															#line 1458 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						metrics = reply.get();
															#line 9040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					}
					else
					{
															#line 1459 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						if (estimatedBytes[firstValidStorageServer] != numBytes)
															#line 9046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						{
															#line 1460 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
							TraceEvent("ConsistencyCheck_InconsistentStorageMetrics") .detail("ByteEstimate1", estimatedBytes[firstValidStorageServer]) .detail("ByteEstimate2", numBytes) .detail("Begin", shard.begin) .detail("End", shard.end) .detail("StorageServer1", storageServers[firstValidStorageServer].id()) .detail("StorageServer2", storageServers[i].id()) .detail("IsTSS", storageServers[i].isTss() || storageServers[firstValidStorageServer].isTss() ? "True" : "False");
															#line 9050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
						}
					}
				}
			}
		}
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageSizeEstimateActor*>(this)->actor_wait_state > 0) static_cast<GetStorageSizeEstimateActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageSizeEstimateActor*>(this)->ActorCallback< GetStorageSizeEstimateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageSizeEstimateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageSizeEstimateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageSizeEstimateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageSizeEstimateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageSizeEstimateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageSizeEstimateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<StorageServerInterface> storageServers;
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	KeyRangeRef shard;
															#line 1415 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<int64_t> estimatedBytes;
															#line 1416 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	StorageMetrics metrics;
															#line 1418 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	WaitMetricsRequest req;
															#line 1423 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Future<ErrorOr<StorageMetrics>>> metricFutures;
															#line 9160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
};
// This generated class is to be used only via getStorageSizeEstimate()
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetStorageSizeEstimateActor final : public Actor<std::pair<std::vector<int64_t>, StorageMetrics>>, public ActorCallback< GetStorageSizeEstimateActor, 0, Void >, public FastAllocated<GetStorageSizeEstimateActor>, public GetStorageSizeEstimateActorState<GetStorageSizeEstimateActor> {
															#line 9165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
	using FastAllocated<GetStorageSizeEstimateActor>::operator new;
	using FastAllocated<GetStorageSizeEstimateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14581447786330898176UL, 1492104619195809536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<std::vector<int64_t>, StorageMetrics>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageSizeEstimateActor, 0, Void >;
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetStorageSizeEstimateActor(std::vector<StorageServerInterface> const& storageServers,KeyRangeRef const& shard) 
															#line 9182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		 : Actor<std::pair<std::vector<int64_t>, StorageMetrics>>(),
		   GetStorageSizeEstimateActorState<GetStorageSizeEstimateActor>(storageServers, shard),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18403363700833208064UL, 9238915563245270528UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageSizeEstimateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageSizeEstimate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageSizeEstimate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageSizeEstimateActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<std::pair<std::vector<int64_t>, StorageMetrics>> getStorageSizeEstimate( std::vector<StorageServerInterface> const& storageServers, KeyRangeRef const& shard ) {
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<std::pair<std::vector<int64_t>, StorageMetrics>>(new GetStorageSizeEstimateActor(storageServers, shard));
															#line 9215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
}

#line 1483 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

															#line 9220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
namespace {
// This generated class is to be used only via getDatabaseSize()
															#line 1484 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class GetDatabaseSizeActor>
															#line 1484 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetDatabaseSizeActorState {
															#line 9227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
															#line 1484 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetDatabaseSizeActorState(Database const& cx) 
															#line 1484 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1484 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : cx(cx)
															#line 9234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
	{
		fdb_probe_actor_create("getDatabaseSize", reinterpret_cast<unsigned long>(this));

	}
	~GetDatabaseSizeActorState() 
	{
		fdb_probe_actor_destroy("getDatabaseSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1486 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 1488 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			tr = Transaction(cx);
															#line 1489 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1490 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 9255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDatabaseSizeActorState();
		static_cast<GetDatabaseSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1492 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<StorageMetrics> __when_expr_0 = tr.getDatabase()->getStorageMetrics(KeyRangeRef(allKeys.begin, keyServersPrefix), 100000);
															#line 1492 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state = 1;
															#line 1492 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >*>(static_cast<GetDatabaseSizeActor*>(this)));
															#line 9293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1496 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1496 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state = 2;
															#line 1496 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetDatabaseSizeActor, 1, Void >*>(static_cast<GetDatabaseSizeActor*>(this)));
															#line 9322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(StorageMetrics const& metrics,int loopDepth) 
	{
															#line 1494 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<GetDatabaseSizeActor*>(this)->SAV<int64_t>::futures) { (void)(metrics.bytes); this->~GetDatabaseSizeActorState(); static_cast<GetDatabaseSizeActor*>(this)->destroy(); return 0; }
															#line 9337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		new (&static_cast<GetDatabaseSizeActor*>(this)->SAV< int64_t >::value()) int64_t(metrics.bytes);
		this->~GetDatabaseSizeActorState();
		static_cast<GetDatabaseSizeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(StorageMetrics && metrics,int loopDepth) 
	{
															#line 1494 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<GetDatabaseSizeActor*>(this)->SAV<int64_t>::futures) { (void)(metrics.bytes); this->~GetDatabaseSizeActorState(); static_cast<GetDatabaseSizeActor*>(this)->destroy(); return 0; }
															#line 9349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		new (&static_cast<GetDatabaseSizeActor*>(this)->SAV< int64_t >::value()) int64_t(metrics.bytes);
		this->~GetDatabaseSizeActorState();
		static_cast<GetDatabaseSizeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(StorageMetrics const& metrics,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(metrics, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(StorageMetrics && metrics,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(metrics), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state > 0) static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetDatabaseSizeActor*>(this)->ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >::remove();

	}
	void a_callback_fire(ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >*,StorageMetrics const& value) 
	{
		fdb_probe_actor_enter("getDatabaseSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatabaseSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >*,StorageMetrics && value) 
	{
		fdb_probe_actor_enter("getDatabaseSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatabaseSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >*,Error err) 
	{
		fdb_probe_actor_enter("getDatabaseSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatabaseSize", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state > 0) static_cast<GetDatabaseSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetDatabaseSizeActor*>(this)->ActorCallback< GetDatabaseSizeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetDatabaseSizeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getDatabaseSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatabaseSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetDatabaseSizeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getDatabaseSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatabaseSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetDatabaseSizeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getDatabaseSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatabaseSize", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1484 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database cx;
															#line 1488 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Transaction tr;
															#line 9523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
};
// This generated class is to be used only via getDatabaseSize()
															#line 1484 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class GetDatabaseSizeActor final : public Actor<int64_t>, public ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >, public ActorCallback< GetDatabaseSizeActor, 1, Void >, public FastAllocated<GetDatabaseSizeActor>, public GetDatabaseSizeActorState<GetDatabaseSizeActor> {
															#line 9528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
	using FastAllocated<GetDatabaseSizeActor>::operator new;
	using FastAllocated<GetDatabaseSizeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6084737480773341184UL, 15390449878372001536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >;
friend struct ActorCallback< GetDatabaseSizeActor, 1, Void >;
															#line 1484 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	GetDatabaseSizeActor(Database const& cx) 
															#line 9546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetDatabaseSizeActorState<GetDatabaseSizeActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDatabaseSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11762275571184728832UL, 3589382968507849216UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDatabaseSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDatabaseSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDatabaseSizeActor, 0, StorageMetrics >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetDatabaseSizeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1484 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<int64_t> getDatabaseSize( Database const& cx ) {
															#line 1484 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<int64_t>(new GetDatabaseSizeActor(cx));
															#line 9580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
}

#line 1500 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"

// Checks that the data in each shard is the same on each storage server that it resides on.  Also performs some
// sanity checks on the sizes of shards and storage servers. Returns false if there is a failure
// TODO: Future optimization: Use streaming reads
															#line 9588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
namespace {
// This generated class is to be used only via checkDataConsistency()
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
template <class CheckDataConsistencyActor>
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class CheckDataConsistencyActorState {
															#line 9595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	CheckDataConsistencyActorState(Database const& cx,VectorRef<KeyValueRef> const& keyLocations,DatabaseConfiguration const& configuration,std::map<UID, StorageServerInterface> const& tssMapping,bool const& performQuiescentChecks,bool const& performTSSCheck,bool const& firstClient,bool const& failureIsError,int const& clientId,int const& clientCount,bool const& distributed,bool const& shuffleShards,int const& shardSampleFactor,int64_t const& sharedRandomNumber,int64_t const& repetitions,int64_t* const& bytesReadInPrevRound,int const& restart,int64_t const& maxRate,int64_t const& targetInterval,bool* const& success) 
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		 : cx(cx),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   keyLocations(keyLocations),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   configuration(configuration),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   tssMapping(tssMapping),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   performQuiescentChecks(performQuiescentChecks),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   performTSSCheck(performTSSCheck),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   firstClient(firstClient),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   failureIsError(failureIsError),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   clientId(clientId),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   clientCount(clientCount),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   distributed(distributed),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   shuffleShards(shuffleShards),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   shardSampleFactor(shardSampleFactor),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   sharedRandomNumber(sharedRandomNumber),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   repetitions(repetitions),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   bytesReadInPrevRound(bytesReadInPrevRound),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   restart(restart),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   maxRate(maxRate),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   targetInterval(targetInterval),
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   success(success),
															#line 1526 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   storageServerSizes(),
															#line 1532 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   effectiveClientCount(distributed ? clientCount : 1),
															#line 1533 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   i(clientId * (shardSampleFactor + 1)),
															#line 1534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		   rateLimitForThisRound(*bytesReadInPrevRound == 0 ? maxRate : std::min(maxRate, static_cast<int64_t>(ceil(*bytesReadInPrevRound / (float)targetInterval))))
															#line 9648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
	{
		fdb_probe_actor_create("checkDataConsistency", reinterpret_cast<unsigned long>(this));

	}
	~CheckDataConsistencyActorState() 
	{
		fdb_probe_actor_destroy("checkDataConsistency", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1538 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_RateLimitForThisRound") .detail("RateLimit", rateLimitForThisRound) .detail("BytesReadInPrevRound", *bytesReadInPrevRound) .detail("TargetInterval", targetInterval) .detail("MaxRate", maxRate);
															#line 1543 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(rateLimitForThisRound >= 0 && rateLimitForThisRound <= maxRate);
															#line 1544 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiter = Reference<IRateControl>(new SpeedLimit(rateLimitForThisRound, 1));
															#line 1545 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiterStartTime = now();
															#line 1546 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			bytesReadInthisRound = 0;
															#line 1547 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiterCumulatedWaitTime = 0;
															#line 1548 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			decideToRunAtMaxRate = false;
															#line 1550 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			dbSize = 100e12;
															#line 1551 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ssCount = 1e6;
															#line 1552 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (g_network->isSimulated())
															#line 9681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1554 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				StrictFuture<int64_t> __when_expr_0 = getDatabaseSize(cx);
															#line 1554 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 1;
															#line 1554 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 0, int64_t >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 9692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckDataConsistencyActorState();
		static_cast<CheckDataConsistencyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1565 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ranges = std::vector<KeyRangeRef>();
															#line 1567 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int k = 0;k < keyLocations.size() - 1;k++) {
															#line 1568 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			KeyRangeRef range(keyLocations[k].key, keyLocations[k + 1].key);
															#line 1569 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ranges.push_back(range);
															#line 9726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1572 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shardOrder = std::vector<int>();
															#line 1573 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shardOrder.reserve(ranges.size());
															#line 1574 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int k = 0;k < ranges.size();k++) {
															#line 1575 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardOrder.push_back(k);
															#line 9736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1576 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (shuffleShards)
															#line 9740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1577 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			DeterministicRandom sharedRandom(sharedRandomNumber + repetitions);
															#line 1578 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			sharedRandom.randomShuffle(shardOrder);
															#line 9746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1581 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<Reference<DDConfiguration::RangeConfigMapSnapshot>> __when_expr_2 = DDConfiguration().userRangeConfig().getSnapshot( SystemDBWriteLockedNow(cx.getReference()), allKeys.begin, allKeys.end);
															#line 1581 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 3;
															#line 1581 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 9757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int64_t const& _dbSize,int loopDepth) 
	{
															#line 1555 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dbSize = _dbSize;
															#line 1556 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 1556 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 2;
															#line 1556 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 9775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int64_t && _dbSize,int loopDepth) 
	{
															#line 1555 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dbSize = _dbSize;
															#line 1556 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<std::vector<StorageServerInterface>> __when_expr_1 = getStorageServers(cx);
															#line 1556 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 2;
															#line 1556 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 9793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(int64_t const& _dbSize,int loopDepth) 
	{
		loopDepth = a_body1cont2(_dbSize, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && _dbSize,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_dbSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(std::vector<StorageServerInterface> const& storageServers,int loopDepth) 
	{
															#line 1557 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ssCount = 0;
															#line 1558 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for( auto& it : storageServers ) {
															#line 1559 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!it.isTss())
															#line 9881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1560 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				++ssCount;
															#line 9885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(std::vector<StorageServerInterface> && storageServers,int loopDepth) 
	{
															#line 1557 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ssCount = 0;
															#line 1558 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for( auto& it : storageServers ) {
															#line 1559 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!it.isTss())
															#line 9900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1560 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				++ssCount;
															#line 9904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<StorageServerInterface> const& storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont3(storageServers, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<StorageServerInterface> && storageServers,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(storageServers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1584 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		customReplicatedShards = 0;
															#line 1585 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		underReplicatedShards = 0;
															#line 1586 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		numCheckedShard = 0;
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		numCheckedReadShard = 0;
															#line 1589 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 9998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<DDConfiguration::RangeConfigMapSnapshot> const& __userRangeConfig,int loopDepth) 
	{
															#line 1581 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		userRangeConfig = __userRangeConfig;
															#line 10007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<DDConfiguration::RangeConfigMapSnapshot> && __userRangeConfig,int loopDepth) 
	{
		userRangeConfig = std::move(__userRangeConfig);
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >*,Reference<DDConfiguration::RangeConfigMapSnapshot> const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >*,Reference<DDConfiguration::RangeConfigMapSnapshot> && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 2092 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (customReplicatedShards > SERVER_KNOBS->DD_MAX_SHARDS_ON_LARGE_TEAMS)
															#line 10086 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 2093 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevWarn, "ConsistencyCheck_TooManyShardsOnLargeTeams") .detail("ShardsOnLargeTeams", customReplicatedShards) .detail("Limit", SERVER_KNOBS->DD_MAX_SHARDS_ON_LARGE_TEAMS);
															#line 2096 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure("Too many shards on large teams", performQuiescentChecks, success, failureIsError);
															#line 2097 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 10094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckDataConsistencyActorState();
			static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2100 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (customReplicatedShards < SERVER_KNOBS->DD_MAX_SHARDS_ON_LARGE_TEAMS && underReplicatedShards > 0)
															#line 10102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 2101 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevWarn, "ConsistencyCheck_TooFewShardsOnLargeTeams") .detail("ShardsOnLargeTeams", customReplicatedShards) .detail("Limit", SERVER_KNOBS->DD_MAX_SHARDS_ON_LARGE_TEAMS) .detail("UnderReplicated", underReplicatedShards);
															#line 2105 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure("Too few shards on large teams", performQuiescentChecks, success, failureIsError);
															#line 2106 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 10110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckDataConsistencyActorState();
			static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2109 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (customReplicatedShards == SERVER_KNOBS->DD_MAX_SHARDS_ON_LARGE_TEAMS && underReplicatedShards > 0)
															#line 10118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 2110 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			CODE_PROBE(true, "Reached max shard on large team limit");
															#line 10122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 2113 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		*bytesReadInPrevRound = bytesReadInthisRound;
															#line 2114 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 10128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckDataConsistencyActorState();
		static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1(int loopDepth) 
	{
															#line 1589 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!(i < ranges.size()))
															#line 10147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
			return a_body1cont7break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1590 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shard = shardOrder[i];
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		range = ranges[shard];
															#line 1593 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		sourceStorageServers = std::vector<UID>();
															#line 1594 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		destStorageServers = std::vector<UID>();
															#line 1595 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr = Transaction(cx);
															#line 1596 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1597 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bytesReadInRange = 0;
															#line 1599 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<RangeResult> __when_expr_3 = tr.getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY);
															#line 1599 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 4;
															#line 1599 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 3, RangeResult >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 10174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7break1(int loopDepth) 
	{
		try {
			return a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(RangeResult const& UIDtoTagMap,int loopDepth) 
	{
															#line 1600 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1601 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, keyLocations[shard].value, sourceStorageServers, destStorageServers, false);
															#line 1604 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		isRelocating = destStorageServers.size() > 0;
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shardCheckStartTime = now();
															#line 1607 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		rateLimiterWaitTimeForThisShard = 0;
															#line 1608 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dataConsistencyCheckTimeForThisShard = 0;
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int desiredReplicas = configuration.storageTeamSize;
															#line 1611 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (ddLargeTeamEnabled())
															#line 10210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1614 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for( auto it : userRangeConfig->intersectingRanges(range.begin, range.end) ) {
															#line 1615 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				KeyRangeRef configuredRange(it->range().begin, it->range().end);
															#line 1617 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				CODE_PROBE(true, "Checked custom replication configuration.");
															#line 1618 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_CheckCustomReplica") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("CustomBegin", configuredRange.begin) .detail("CustomEnd", configuredRange.end) .detail("CustomConfig", it->value()) .detail("UsableRegions", configuration.usableRegions) .detail("First", firstClient) .detail("Perform", performQuiescentChecks);
															#line 1633 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!configuredRange.contains(range))
															#line 10222 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1634 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent(SevWarn, "ConsistencyCheck_BoundaryMissing") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("CustomBegin", configuredRange.begin) .detail("CustomEnd", configuredRange.end);
															#line 1639 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					testFailure("Custom shard boundary violated", performQuiescentChecks, success, failureIsError);
															#line 1640 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 10230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CheckDataConsistencyActorState();
					static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 1643 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				desiredReplicas = std::max(desiredReplicas, it->value().replicationFactor.orDefault(0));
															#line 10238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
		}
															#line 1647 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int expectedReplicas = std::min(desiredReplicas, ssCount);
															#line 1649 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstClient && performQuiescentChecks && configuration.usableRegions == 1 && expectedReplicas > configuration.storageTeamSize)
															#line 10245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1651 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (sourceStorageServers.size() < expectedReplicas)
															#line 10249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1652 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				underReplicatedShards++;
															#line 1653 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_UnderReplicatedTeam") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("DesiredReplicas", desiredReplicas) .detail("UsableRegions", configuration.usableRegions) .detail("SSCount", ssCount);
															#line 10255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 1663 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (sourceStorageServers.size() > configuration.storageTeamSize)
															#line 10259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1664 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				customReplicatedShards++;
															#line 1665 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_CustomReplicatedTeam") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("DesiredReplicas", desiredReplicas) .detail("UsableRegions", configuration.usableRegions) .detail("SSCount", ssCount);
															#line 10265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
		}
															#line 1679 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstClient && performQuiescentChecks && ((configuration.usableRegions == 1 && (sourceStorageServers.size() > expectedReplicas || sourceStorageServers.size() < configuration.storageTeamSize)) || sourceStorageServers.size() < configuration.usableRegions * configuration.storageTeamSize || sourceStorageServers.size() > configuration.usableRegions * expectedReplicas))
															#line 10270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1684 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_InvalidTeamSize") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("DesiredReplicas", desiredReplicas) .detail("UsableRegions", configuration.usableRegions) .detail("SSCount", ssCount);
															#line 1694 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			int k = 0;
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for( auto& id : sourceStorageServers ) {
															#line 1696 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("IncorrectSizeTeamInfo").detail("ServerUID", id).detail("TeamIndex", k++);
															#line 10280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 1698 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure("Invalid team size", performQuiescentChecks, success, failureIsError);
															#line 1699 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 10286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckDataConsistencyActorState();
			static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1702 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServers = (isRelocating) ? destStorageServers : sourceStorageServers;
															#line 1703 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServerInterfaces = std::vector<StorageServerInterface>();
															#line 1705 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 10298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1cont7loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1(RangeResult && UIDtoTagMap,int loopDepth) 
	{
															#line 1600 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		ASSERT(!UIDtoTagMap.more && UIDtoTagMap.size() < CLIENT_KNOBS->TOO_MANY);
															#line 1601 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		decodeKeyServersValue(UIDtoTagMap, keyLocations[shard].value, sourceStorageServers, destStorageServers, false);
															#line 1604 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		isRelocating = destStorageServers.size() > 0;
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shardCheckStartTime = now();
															#line 1607 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		rateLimiterWaitTimeForThisShard = 0;
															#line 1608 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dataConsistencyCheckTimeForThisShard = 0;
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int desiredReplicas = configuration.storageTeamSize;
															#line 1611 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (ddLargeTeamEnabled())
															#line 10321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1614 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for( auto it : userRangeConfig->intersectingRanges(range.begin, range.end) ) {
															#line 1615 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				KeyRangeRef configuredRange(it->range().begin, it->range().end);
															#line 1617 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				CODE_PROBE(true, "Checked custom replication configuration.");
															#line 1618 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_CheckCustomReplica") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("CustomBegin", configuredRange.begin) .detail("CustomEnd", configuredRange.end) .detail("CustomConfig", it->value()) .detail("UsableRegions", configuration.usableRegions) .detail("First", firstClient) .detail("Perform", performQuiescentChecks);
															#line 1633 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (!configuredRange.contains(range))
															#line 10333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1634 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent(SevWarn, "ConsistencyCheck_BoundaryMissing") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("CustomBegin", configuredRange.begin) .detail("CustomEnd", configuredRange.end);
															#line 1639 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					testFailure("Custom shard boundary violated", performQuiescentChecks, success, failureIsError);
															#line 1640 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 10341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CheckDataConsistencyActorState();
					static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 1643 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				desiredReplicas = std::max(desiredReplicas, it->value().replicationFactor.orDefault(0));
															#line 10349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
		}
															#line 1647 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int expectedReplicas = std::min(desiredReplicas, ssCount);
															#line 1649 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstClient && performQuiescentChecks && configuration.usableRegions == 1 && expectedReplicas > configuration.storageTeamSize)
															#line 10356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1651 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (sourceStorageServers.size() < expectedReplicas)
															#line 10360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1652 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				underReplicatedShards++;
															#line 1653 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_UnderReplicatedTeam") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("DesiredReplicas", desiredReplicas) .detail("UsableRegions", configuration.usableRegions) .detail("SSCount", ssCount);
															#line 10366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 1663 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (sourceStorageServers.size() > configuration.storageTeamSize)
															#line 10370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1664 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				customReplicatedShards++;
															#line 1665 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_CustomReplicatedTeam") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("DesiredReplicas", desiredReplicas) .detail("UsableRegions", configuration.usableRegions) .detail("SSCount", ssCount);
															#line 10376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
		}
															#line 1679 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstClient && performQuiescentChecks && ((configuration.usableRegions == 1 && (sourceStorageServers.size() > expectedReplicas || sourceStorageServers.size() < configuration.storageTeamSize)) || sourceStorageServers.size() < configuration.usableRegions * configuration.storageTeamSize || sourceStorageServers.size() > configuration.usableRegions * expectedReplicas))
															#line 10381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1684 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_InvalidTeamSize") .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("SourceTeamSize", sourceStorageServers.size()) .detail("DestServerSize", destStorageServers.size()) .detail("ConfigStorageTeamSize", configuration.storageTeamSize) .detail("DesiredReplicas", desiredReplicas) .detail("UsableRegions", configuration.usableRegions) .detail("SSCount", ssCount);
															#line 1694 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			int k = 0;
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for( auto& id : sourceStorageServers ) {
															#line 1696 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("IncorrectSizeTeamInfo").detail("ServerUID", id).detail("TeamIndex", k++);
															#line 10391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 1698 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure("Invalid team size", performQuiescentChecks, success, failureIsError);
															#line 1699 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 10397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckDataConsistencyActorState();
			static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1702 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServers = (isRelocating) ? destStorageServers : sourceStorageServers;
															#line 1703 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		storageServerInterfaces = std::vector<StorageServerInterface>();
															#line 1705 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		;
															#line 10409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1cont7loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(RangeResult const& UIDtoTagMap,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(UIDtoTagMap, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1when1(RangeResult && UIDtoTagMap,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1(std::move(UIDtoTagMap), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7loopBody1cont3(int loopDepth) 
	{
															#line 1729 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!isRelocating && performTSSCheck)
															#line 10493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1730 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			int initialSize = storageServers.size();
															#line 1731 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int i = 0;i < initialSize;i++) {
															#line 1732 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				auto tssPair = tssMapping.find(storageServers[i]);
															#line 1733 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (tssPair != tssMapping.end())
															#line 10503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1734 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					CODE_PROBE(true, "TSS checked in consistency check");
															#line 1735 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					storageServers.push_back(tssPair->second.id());
															#line 1736 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					storageServerInterfaces.push_back(tssPair->second);
															#line 10511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
			}
		}
															#line 1741 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<std::pair<std::vector<int64_t>, StorageMetrics>> __when_expr_6 = getStorageSizeEstimate(storageServerInterfaces, range);
															#line 1741 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 7;
															#line 1741 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 10524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 1707 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			std::vector<Future<Optional<Value>>> serverListEntries;
															#line 1708 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			serverListEntries.reserve(storageServers.size());
															#line 1709 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int s = 0;s < storageServers.size();s++) {
															#line 1710 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				serverListEntries.push_back(tr.get(serverListKeyFor(storageServers[s])));
															#line 10547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
															#line 1711 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<std::vector<Optional<Value>>> __when_expr_4 = getAll(serverListEntries);
															#line 1711 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont7loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont7loopBody1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7loopBody1cont1loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 5;
															#line 1711 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 10558 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont7loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont7loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1724 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr.onError(e);
															#line 1724 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 10595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1cont7loopBody1cont1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 6;
															#line 1724 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 5, Void >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 10600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1cont2(int loopDepth) 
	{
															#line 1712 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int s = 0;s < serverListValues.size();s++) {
															#line 1713 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (serverListValues[s].present())
															#line 10617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				storageServerInterfaces.push_back(decodeServerListValue(serverListValues[s].get()));
															#line 10621 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
			else
			{
															#line 1715 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (performQuiescentChecks)
															#line 10627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1716 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					testFailure("/FF/serverList changing in a quiescent database", performQuiescentChecks, success, failureIsError);
															#line 10631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				}
			}
		}
		return a_body1cont7loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1when1(std::vector<Optional<Value>> const& __serverListValues,int loopDepth) 
	{
															#line 1711 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		serverListValues = __serverListValues;
															#line 10643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1cont7loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1when1(std::vector<Optional<Value>> && __serverListValues,int loopDepth) 
	{
		serverListValues = std::move(__serverListValues);
		loopDepth = a_body1cont7loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >*,std::vector<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7loopBody1cont12(std::pair<std::vector<int64_t>, StorageMetrics> const& estimatedBytesAndMetrics,int loopDepth) 
	{
															#line 1743 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		estimatedBytes = estimatedBytesAndMetrics.first;
															#line 1744 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		estimated = estimatedBytesAndMetrics.second;
															#line 1747 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int64_t maxShardSize = getMaxShardSize(dbSize);
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shardBounds = getShardSizeBounds(range, maxShardSize);
															#line 1750 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstClient)
															#line 10817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1752 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (performQuiescentChecks && estimatedBytes.size() == 0)
															#line 10821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1753 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				testFailure("Error fetching storage metrics", performQuiescentChecks, success, failureIsError);
															#line 10825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
			else
			{
															#line 1756 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (distributed && firstClient)
															#line 10831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1757 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					for(int j = 0;j < storageServers.size();j++) {
															#line 1758 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						storageServerSizes[storageServers[j]] += std::max(estimatedBytes[j], (int64_t)0);
															#line 10837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					}
				}
			}
		}
															#line 1763 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!firstClient || shard % (effectiveClientCount * shardSampleFactor) == 0)
															#line 10844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1764 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardKeys = 0;
															#line 1765 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardBytes = 0;
															#line 1766 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			sampledBytes = 0;
															#line 1767 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			splitBytes = 0;
															#line 1768 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			firstKeySampledBytes = 0;
															#line 1769 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			sampledKeys = 0;
															#line 1770 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			sampledKeysWithProb = 0;
															#line 1771 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardVariance = 0;
															#line 1772 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			canSplit = false;
															#line 1773 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			lastSampleKey = Key();
															#line 1774 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			lastStartSampleKey = Key();
															#line 1775 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			totalReadAmount = 0;
															#line 1776 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readRange = range;
															#line 1777 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			onErrorTr = Transaction(cx);
															#line 1780 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 10876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = a_body1cont7loopBody1cont12loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont7loopBody1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12(std::pair<std::vector<int64_t>, StorageMetrics> && estimatedBytesAndMetrics,int loopDepth) 
	{
															#line 1743 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		estimatedBytes = estimatedBytesAndMetrics.first;
															#line 1744 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		estimated = estimatedBytesAndMetrics.second;
															#line 1747 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int64_t maxShardSize = getMaxShardSize(dbSize);
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		shardBounds = getShardSizeBounds(range, maxShardSize);
															#line 1750 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstClient)
															#line 10898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1752 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (performQuiescentChecks && estimatedBytes.size() == 0)
															#line 10902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1753 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				testFailure("Error fetching storage metrics", performQuiescentChecks, success, failureIsError);
															#line 10906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
			else
			{
															#line 1756 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (distributed && firstClient)
															#line 10912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1757 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					for(int j = 0;j < storageServers.size();j++) {
															#line 1758 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						storageServerSizes[storageServers[j]] += std::max(estimatedBytes[j], (int64_t)0);
															#line 10918 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					}
				}
			}
		}
															#line 1763 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!firstClient || shard % (effectiveClientCount * shardSampleFactor) == 0)
															#line 10925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1764 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardKeys = 0;
															#line 1765 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardBytes = 0;
															#line 1766 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			sampledBytes = 0;
															#line 1767 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			splitBytes = 0;
															#line 1768 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			firstKeySampledBytes = 0;
															#line 1769 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			sampledKeys = 0;
															#line 1770 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			sampledKeysWithProb = 0;
															#line 1771 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardVariance = 0;
															#line 1772 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			canSplit = false;
															#line 1773 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			lastSampleKey = Key();
															#line 1774 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			lastStartSampleKey = Key();
															#line 1775 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			totalReadAmount = 0;
															#line 1776 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readRange = range;
															#line 1777 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			onErrorTr = Transaction(cx);
															#line 1780 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			;
															#line 10957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = a_body1cont7loopBody1cont12loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont7loopBody1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont3when1(std::pair<std::vector<int64_t>, StorageMetrics> const& estimatedBytesAndMetrics,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12(estimatedBytesAndMetrics, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont3when1(std::pair<std::vector<int64_t>, StorageMetrics> && estimatedBytesAndMetrics,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12(std::move(estimatedBytesAndMetrics), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >*,std::pair<std::vector<int64_t>, StorageMetrics> const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >*,std::pair<std::vector<int64_t>, StorageMetrics> && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont7loopBody1cont12cont1(int loopDepth) 
	{
															#line 2061 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (bytesReadInRange > 0)
															#line 11046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 2062 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			numCheckedReadShard++;
															#line 2063 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_ReadRange") .suppressFor(1.0) .detail("Range", range) .detail("BytesRead", bytesReadInRange);
															#line 11052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 2068 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		numCheckedShard++;
															#line 2070 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_ShardComplete") .suppressFor(1.0) .detail("Index", i) .detail("BytesReadInthisRound", bytesReadInthisRound) .detail("NumCheckedReadShard", numCheckedReadShard) .detail("NumCheckedShard", numCheckedShard) .detail("Range", range) .detail("BytesRead", bytesReadInRange) .detail("ShardCheckTime", now() - shardCheckStartTime) .detail("DataConsistencyCheckTime", dataConsistencyCheckTimeForThisShard) .detail("RateLimitTime", rateLimiterWaitTimeForThisShard) .detail("CumulatedRateLimitTime", rateLimiterCumulatedWaitTime) .detail("DecideToRunAtMaxRate", decideToRunAtMaxRate) .detail("ClientId", clientId) .detail("ClientCount", clientCount) .detail("FirstClient", firstClient) .detail("Distributed", distributed) .detail("PerformTSSCheck", performTSSCheck) .detail("ShardSampleFactor", shardSampleFactor) .detail("EffectiveClientCount", effectiveClientCount);
															#line 1589 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		i++;
															#line 11060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12cont7(int loopDepth) 
	{
															#line 1947 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		canSplit = canSplit && sampledBytes - splitBytes >= shardBounds.min.bytes && sampledBytes > splitBytes;
															#line 1952 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (!distributed)
															#line 11071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1953 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int j = 0;j < storageServers.size();j++) {
															#line 1954 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				storageServerSizes[storageServers[j]] += shardBytes;
															#line 11077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			}
		}
															#line 1957 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (performQuiescentChecks)
															#line 11082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1958 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int j = 0;j < estimatedBytes.size();j++) {
															#line 1959 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (estimatedBytes[j] >= 0 && estimatedBytes[j] != sampledBytes)
															#line 11088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1960 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					TraceEvent("ConsistencyCheck_IncorrectEstimate") .detail("EstimatedBytes", estimatedBytes[j]) .detail("CorrectSampledBytes", sampledBytes) .detail("StorageServer", storageServers[j]) .detail("Range", range) .detail("IsTSS", storageServerInterfaces[j].isTss() ? "True" : "False");
															#line 1967 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!storageServerInterfaces[j].isTss())
															#line 11094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 1968 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						testFailure("Storage servers had incorrect sampled estimate", performQuiescentChecks, success, failureIsError);
															#line 11098 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					}
					break;
				}
				else
				{
															#line 1975 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (estimatedBytes[j] < 0 && ((g_network->isSimulated() && g_simulator->tssMode <= ISimulator::TSSMode::EnabledNormal) || !storageServerInterfaces[j].isTss()))
															#line 11106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
						break;
					}
				}
			}
		}
															#line 1986 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		double stdDev = sqrt(shardVariance);
															#line 1988 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		double failErrorNumStdDev = 7;
															#line 1989 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		int estimateError = abs(shardBytes - sampledBytes);
															#line 1993 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (sampledKeysWithProb > 30 && estimateError > failErrorNumStdDev * stdDev)
															#line 11121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1994 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			double numStdDev = estimateError / sqrt(shardVariance);
															#line 1995 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_InaccurateShardEstimate") .detail("Min", shardBounds.min.bytes) .detail("Max", shardBounds.max.bytes) .detail("Estimate", sampledBytes) .detail("Actual", shardBytes) .detail("NumStdDev", numStdDev) .detail("Variance", shardVariance) .detail("StdDev", stdDev) .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("NumKeys", shardKeys) .detail("NumSampledKeys", sampledKeys) .detail("NumSampledKeysWithProb", sampledKeysWithProb);
															#line 2009 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure(format("Shard size is more than %f std dev from estimate", failErrorNumStdDev), performQuiescentChecks, success, failureIsError);
															#line 11129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 2015 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_CheckSplits").detail("Range", range).detail("CanSplit", canSplit);
															#line 2019 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (canSplit && sampledKeys > 5 && performQuiescentChecks)
															#line 11135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 2020 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StorageMetrics splitMetrics;
															#line 2021 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			splitMetrics.bytes = shardBounds.max.bytes / 2;
															#line 2022 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			splitMetrics.bytesWrittenPerKSecond = range.begin >= keyServersKeys.begin ? splitMetrics.infinity : SERVER_KNOBS->SHARD_SPLIT_BYTES_PER_KSEC;
															#line 2025 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			splitMetrics.iosPerKSecond = splitMetrics.infinity;
															#line 2026 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			splitMetrics.bytesReadPerKSecond = splitMetrics.infinity;
															#line 2028 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_12 = cx->splitStorageMetrics(range, splitMetrics, estimated);
															#line 2028 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont7loopBody1cont12cont7when1(__when_expr_12.get(), loopDepth); };
			static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 13;
															#line 2028 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7loopBody1cont12cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont7loopBody1cont12loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1(int loopDepth) 
	{
		try {
															#line 1782 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			lastSampleKey = lastStartSampleKey;
															#line 1785 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Version> __when_expr_7 = getVersion(cx);
															#line 1785 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont7loopBody1cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont7loopBody1cont12loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7loopBody1cont12loopBody1when1(__when_expr_7.get(), loopDepth); };
			static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 8;
															#line 1785 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 7, Version >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12break1(int loopDepth) 
	{
		try {
			return a_body1cont7loopBody1cont12cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont7loopBody1cont12loopHead1(0);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1936 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			err = e;
															#line 1937 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (e.code() == error_code_wrong_shard_server)
															#line 11224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1939 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				StrictFuture<Void> __when_expr_10 = delay(1.0);
															#line 1939 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 2)); else return a_body1cont7loopBody1cont12loopBody1Catch1when1(__when_expr_10.get(), loopDepth); };
				static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 11;
															#line 1939 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 10, Void >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1941 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				StrictFuture<Void> __when_expr_11 = onErrorTr.onError(err);
															#line 1941 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 2)); else return a_body1cont7loopBody1cont12loopBody1Catch1when2(__when_expr_11.get(), loopDepth); };
				static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 12;
															#line 1941 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 11, Void >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont2(Version const& version,int loopDepth) 
	{
															#line 1787 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 1788 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		firstValidServer = Optional<int>();
															#line 1789 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dataConsistencyCheckBeginTime = now();
															#line 1791 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		totalReadAmount = 0;
															#line 1792 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<int> __when_expr_8 = consistencyCheckReadData(UID(), cx, readRange, version, &storageServerInterfaces, &keyValueFutures, &firstValidServer, &totalReadAmount, {});
															#line 1792 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont7loopBody1cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont7loopBody1cont12loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont7loopBody1cont12loopBody1cont2when1(__when_expr_8.get(), loopDepth); };
		static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 9;
															#line 1792 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 8, int >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11280 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont2(Version && version,int loopDepth) 
	{
															#line 1787 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		keyValueFutures = std::vector<Future<ErrorOr<GetKeyValuesReply>>>();
															#line 1788 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		firstValidServer = Optional<int>();
															#line 1789 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dataConsistencyCheckBeginTime = now();
															#line 1791 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		totalReadAmount = 0;
															#line 1792 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		StrictFuture<int> __when_expr_8 = consistencyCheckReadData(UID(), cx, readRange, version, &storageServerInterfaces, &keyValueFutures, &firstValidServer, &totalReadAmount, {});
															#line 1792 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont7loopBody1cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont7loopBody1cont12loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont7loopBody1cont12loopBody1cont2when1(__when_expr_8.get(), loopDepth); };
		static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 9;
															#line 1792 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 8, int >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont2(version, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont2(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 7, Version >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 7, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7loopBody1cont12loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 7, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7loopBody1cont12loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 7, Version >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7loopBody1cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont7loopBody1cont12loopBody1cont3(int const& failures,int loopDepth) 
	{
															#line 1801 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (failures > 0)
															#line 11388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1802 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure("Data inconsistent", performQuiescentChecks, success, true);
															#line 11392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1804 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dataConsistencyCheckTimeForThisShard += (now() - dataConsistencyCheckBeginTime);
															#line 1807 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < storageServerInterfaces.size();i++) {
															#line 1808 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[i].get();
															#line 1809 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!isRelocating && (!rangeResult.present() || rangeResult.get().error.present()))
															#line 11402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				Error e = rangeResult.isError() ? rangeResult.getError() : rangeResult.get().error.get();
															#line 1812 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_StorageServerUnavailable") .errorUnsuppressed(e) .suppressFor(1.0) .detail("StorageServer", storageServers[i]) .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("ReadBegin", printable(readRange.begin)) .detail("ReadEnd", printable(readRange.end)) .detail("Address", storageServerInterfaces[i].address()) .detail("UID", storageServerInterfaces[i].id()) .detail("Quiesced", performQuiescentChecks) .detail("GetKeyValuesToken", storageServerInterfaces[i].getKeyValues.getEndpoint().token) .detail("IsTSS", storageServerInterfaces[i].isTss() ? "True" : "False");
															#line 1827 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (e.code() == error_code_request_maybe_delivered)
															#line 11410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1829 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					*success = false;
															#line 1830 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 11416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CheckDataConsistencyActorState();
					static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 1833 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (performQuiescentChecks && !storageServerInterfaces[i].isTss())
															#line 11424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1834 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					testFailure( "Storage server unavailable", performQuiescentChecks, success, failureIsError);
															#line 1836 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 11430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CheckDataConsistencyActorState();
					static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 1841 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstValidServer.present())
															#line 11440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1842 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			data = keyValueFutures[firstValidServer.get()].get().get().data;
															#line 1846 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int k = 0;k < data.size();k++) {
															#line 1847 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ByteSampleInfo sampleInfo = isKeyValueInSample(data[k]);
															#line 1848 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				shardBytes += sampleInfo.size;
															#line 1851 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT_GE(sampleInfo.probability, 0);
															#line 1852 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT_LE(sampleInfo.probability, 1);
															#line 1856 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				shardVariance += sampleInfo.probability * (1 - sampleInfo.probability) * pow((double)sampleInfo.sampledSize, 2);
															#line 1859 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (sampleInfo.inSample)
															#line 11458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1860 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					sampledBytes += sampleInfo.sampledSize;
															#line 1861 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!canSplit && sampledBytes >= shardBounds.min.bytes && data[k].key.size() <= CLIENT_KNOBS->SPLIT_KEY_SIZE_LIMIT && sampledBytes <= shardBounds.max.bytes * CLIENT_KNOBS->STORAGE_METRICS_UNFAIR_SPLIT_LIMIT / 2)
															#line 11464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 1865 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						canSplit = true;
															#line 1866 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						splitBytes = sampledBytes;
															#line 11470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					}
															#line 1877 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (k == 0)
															#line 11474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 1878 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						firstKeySampledBytes += sampleInfo.sampledSize;
															#line 11478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					}
															#line 1880 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					sampledKeys++;
															#line 1886 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					ASSERT_GT(sampleInfo.probability, 0);
															#line 1887 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (sampleInfo.probability < 1)
															#line 11486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 1888 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						sampledKeysWithProb++;
															#line 11490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					}
				}
			}
															#line 1894 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardKeys += data.size();
															#line 11496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1897 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (rateLimitForThisRound > 0)
															#line 11500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1898 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_RateLimit") .detail("RateLimitForThisRound", rateLimitForThisRound) .detail("TotalAmountRead", totalReadAmount);
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiterBeforeWaitTime = now();
															#line 1902 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_9 = rateLimiter->getAllowance(totalReadAmount);
															#line 1902 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont7loopBody1cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont7loopBody1cont12loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont7loopBody1cont12loopBody1cont3when1(__when_expr_9.get(), loopDepth); };
			static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 10;
															#line 1902 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 9, Void >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7loopBody1cont12loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont3(int && failures,int loopDepth) 
	{
															#line 1801 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (failures > 0)
															#line 11529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1802 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure("Data inconsistent", performQuiescentChecks, success, true);
															#line 11533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1804 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		dataConsistencyCheckTimeForThisShard += (now() - dataConsistencyCheckBeginTime);
															#line 1807 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		for(int i = 0;i < storageServerInterfaces.size();i++) {
															#line 1808 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ErrorOr<GetKeyValuesReply> rangeResult = keyValueFutures[i].get();
															#line 1809 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!isRelocating && (!rangeResult.present() || rangeResult.get().error.present()))
															#line 11543 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
															#line 1810 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				Error e = rangeResult.isError() ? rangeResult.getError() : rangeResult.get().error.get();
															#line 1812 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				TraceEvent("ConsistencyCheck_StorageServerUnavailable") .errorUnsuppressed(e) .suppressFor(1.0) .detail("StorageServer", storageServers[i]) .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("ReadBegin", printable(readRange.begin)) .detail("ReadEnd", printable(readRange.end)) .detail("Address", storageServerInterfaces[i].address()) .detail("UID", storageServerInterfaces[i].id()) .detail("Quiesced", performQuiescentChecks) .detail("GetKeyValuesToken", storageServerInterfaces[i].getKeyValues.getEndpoint().token) .detail("IsTSS", storageServerInterfaces[i].isTss() ? "True" : "False");
															#line 1827 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (e.code() == error_code_request_maybe_delivered)
															#line 11551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1829 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					*success = false;
															#line 1830 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 11557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CheckDataConsistencyActorState();
					static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 1833 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (performQuiescentChecks && !storageServerInterfaces[i].isTss())
															#line 11565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1834 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					testFailure( "Storage server unavailable", performQuiescentChecks, success, failureIsError);
															#line 1836 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 11571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CheckDataConsistencyActorState();
					static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 1841 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstValidServer.present())
															#line 11581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1842 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			data = keyValueFutures[firstValidServer.get()].get().get().data;
															#line 1846 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			for(int k = 0;k < data.size();k++) {
															#line 1847 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ByteSampleInfo sampleInfo = isKeyValueInSample(data[k]);
															#line 1848 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				shardBytes += sampleInfo.size;
															#line 1851 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT_GE(sampleInfo.probability, 0);
															#line 1852 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				ASSERT_LE(sampleInfo.probability, 1);
															#line 1856 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				shardVariance += sampleInfo.probability * (1 - sampleInfo.probability) * pow((double)sampleInfo.sampledSize, 2);
															#line 1859 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
				if (sampleInfo.inSample)
															#line 11599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
				{
															#line 1860 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					sampledBytes += sampleInfo.sampledSize;
															#line 1861 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (!canSplit && sampledBytes >= shardBounds.min.bytes && data[k].key.size() <= CLIENT_KNOBS->SPLIT_KEY_SIZE_LIMIT && sampledBytes <= shardBounds.max.bytes * CLIENT_KNOBS->STORAGE_METRICS_UNFAIR_SPLIT_LIMIT / 2)
															#line 11605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 1865 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						canSplit = true;
															#line 1866 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						splitBytes = sampledBytes;
															#line 11611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					}
															#line 1877 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (k == 0)
															#line 11615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 1878 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						firstKeySampledBytes += sampleInfo.sampledSize;
															#line 11619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					}
															#line 1880 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					sampledKeys++;
															#line 1886 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					ASSERT_GT(sampleInfo.probability, 0);
															#line 1887 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
					if (sampleInfo.probability < 1)
															#line 11627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					{
															#line 1888 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
						sampledKeysWithProb++;
															#line 11631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
					}
				}
			}
															#line 1894 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			shardKeys += data.size();
															#line 11637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
															#line 1897 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (rateLimitForThisRound > 0)
															#line 11641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1898 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_RateLimit") .detail("RateLimitForThisRound", rateLimitForThisRound) .detail("TotalAmountRead", totalReadAmount);
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiterBeforeWaitTime = now();
															#line 1902 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			StrictFuture<Void> __when_expr_9 = rateLimiter->getAllowance(totalReadAmount);
															#line 1902 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state < 0) return a_body1cont7loopBody1cont12loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont7loopBody1cont12loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont7loopBody1cont12loopBody1cont3when1(__when_expr_9.get(), loopDepth); };
			static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 10;
															#line 1902 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CheckDataConsistencyActor, 9, Void >*>(static_cast<CheckDataConsistencyActor*>(this)));
															#line 11656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7loopBody1cont12loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont2when1(int const& failures,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont3(failures, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont2when1(int && failures,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont3(std::move(failures), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 8, int >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 8, int >*,int const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont7loopBody1cont12loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 8, int >*,int && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont7loopBody1cont12loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 8, int >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont7loopBody1cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont7loopBody1cont12loopBody1cont4(int loopDepth) 
	{
															#line 1917 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bytesReadInRange += totalReadAmount;
															#line 1918 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		bytesReadInthisRound += totalReadAmount;
															#line 1919 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_BytesRead") .detail("BytesReadInRange", bytesReadInRange) .detail("BytesReadInthisRound", bytesReadInthisRound);
															#line 1924 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (firstValidServer.present() && keyValueFutures[firstValidServer.get()].get().get().more)
															#line 11751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1925 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			VectorRef<KeyValueRef> result = keyValueFutures[firstValidServer.get()].get().get().data;
															#line 1926 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(result.size() > 0);
															#line 1927 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			ASSERT(result[result.size() - 1].key != allKeys.end);
															#line 1928 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			readRange = KeyRangeRef(keyAfter(result[result.size() - 1].key), range.end);
															#line 1929 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			lastStartSampleKey = lastSampleKey;
															#line 1930 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (readRange.empty())
															#line 11765 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			{
				return a_body1cont7loopBody1cont12break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
		else
		{
			return a_body1cont7loopBody1cont12break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont16(Void const& _,int loopDepth) 
	{
															#line 1903 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		double rateLimiterCurrentWaitTime = now() - rateLimiterBeforeWaitTime;
															#line 1904 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		rateLimiterWaitTimeForThisShard += rateLimiterCurrentWaitTime;
															#line 1905 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		rateLimiterCumulatedWaitTime += rateLimiterCurrentWaitTime;
															#line 1906 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_AmountRead").detail("TotalAmountRead", totalReadAmount);
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (now() - rateLimiterStartTime > 1.1 * targetInterval && rateLimitForThisRound != maxRate)
															#line 11790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1909 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimitForThisRound = maxRate;
															#line 1910 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiter = Reference<IRateControl>(new SpeedLimit(rateLimitForThisRound, 1));
															#line 1911 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiterStartTime = now();
															#line 1912 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheck_RateLimitSetMaxForThisRound") .detail("RateLimit", rateLimitForThisRound);
															#line 1914 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			decideToRunAtMaxRate = true;
															#line 11802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont16(Void && _,int loopDepth) 
	{
															#line 1903 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		double rateLimiterCurrentWaitTime = now() - rateLimiterBeforeWaitTime;
															#line 1904 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		rateLimiterWaitTimeForThisShard += rateLimiterCurrentWaitTime;
															#line 1905 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		rateLimiterCumulatedWaitTime += rateLimiterCurrentWaitTime;
															#line 1906 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_AmountRead").detail("TotalAmountRead", totalReadAmount);
															#line 1908 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (now() - rateLimiterStartTime > 1.1 * targetInterval && rateLimitForThisRound != maxRate)
															#line 11820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 1909 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimitForThisRound = maxRate;
															#line 1910 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiter = Reference<IRateControl>(new SpeedLimit(rateLimitForThisRound, 1));
															#line 1911 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			rateLimiterStartTime = now();
															#line 1912 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent(SevInfo, "ConsistencyCheck_RateLimitSetMaxForThisRound") .detail("RateLimit", rateLimitForThisRound);
															#line 1914 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			decideToRunAtMaxRate = true;
															#line 11832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont7loopBody1cont12loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont7loopBody1cont12loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont7loopBody1cont12loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7loopBody1cont12loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont7loopBody1cont12loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont7loopBody1cont12loopBody1cont21(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7loopBody1cont12loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1cont1(int loopDepth) 
	{
															#line 1943 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		TraceEvent("ConsistencyCheck_RetryDataConsistency").error(err);
															#line 11930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		loopDepth = a_body1cont7loopBody1cont12loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont7loopBody1cont12loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont7loopBody1cont12loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont7loopBody1cont12loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont7loopBody1cont12loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont7loopBody1cont12loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont7loopBody1cont12cont8(int loopDepth) 
	{
															#line 2040 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (canSplit && sampledKeys > 5 && performQuiescentChecks && !range.begin.startsWith(keyServersPrefix) && (sampledBytes < shardBounds.min.bytes - 3 * shardBounds.permittedError.bytes || sampledBytes - firstKeySampledBytes > shardBounds.max.bytes + 3 * shardBounds.permittedError.bytes))
															#line 12113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 2043 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_InvalidShardSize") .detail("Min", shardBounds.min.bytes) .detail("Max", shardBounds.max.bytes) .detail("Size", shardBytes) .detail("EstimatedSize", sampledBytes) .detail("ShardBegin", printable(range.begin)) .detail("ShardEnd", printable(range.end)) .detail("ShardCount", ranges.size()) .detail("SampledKeys", sampledKeys);
															#line 2052 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			testFailure(format("Shard size in quiescent database is too %s", (sampledBytes < shardBounds.min.bytes) ? "small" : "large"), performQuiescentChecks, success, failureIsError);
															#line 2057 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			if (!static_cast<CheckDataConsistencyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataConsistencyActorState(); static_cast<CheckDataConsistencyActor*>(this)->destroy(); return 0; }
															#line 12121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
			new (&static_cast<CheckDataConsistencyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckDataConsistencyActorState();
			static_cast<CheckDataConsistencyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont7loopBody1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12cont18(Standalone<VectorRef<KeyRef>> const& splits,int loopDepth) 
	{
															#line 2029 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (splits.size() <= 2)
															#line 12135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 2032 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_DiscardSplits").detail("Range", range);
															#line 2033 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			canSplit = false;
															#line 12141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		loopDepth = a_body1cont7loopBody1cont12cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12cont18(Standalone<VectorRef<KeyRef>> && splits,int loopDepth) 
	{
															#line 2029 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
		if (splits.size() <= 2)
															#line 12151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		{
															#line 2032 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			TraceEvent("ConsistencyCheck_DiscardSplits").detail("Range", range);
															#line 2033 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
			canSplit = false;
															#line 12157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		}
		loopDepth = a_body1cont7loopBody1cont12cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12cont7when1(Standalone<VectorRef<KeyRef>> const& splits,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12cont18(splits, loopDepth);

		return loopDepth;
	}
	int a_body1cont7loopBody1cont12cont7when1(Standalone<VectorRef<KeyRef>> && splits,int loopDepth) 
	{
		loopDepth = a_body1cont7loopBody1cont12cont18(std::move(splits), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state > 0) static_cast<CheckDataConsistencyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataConsistencyActor*>(this)->ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont7loopBody1cont12cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont7loopBody1cont12cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), 12);

	}
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Database cx;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	VectorRef<KeyValueRef> keyLocations;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	DatabaseConfiguration configuration;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::map<UID, StorageServerInterface> tssMapping;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool performQuiescentChecks;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool performTSSCheck;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool firstClient;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool failureIsError;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int clientId;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int clientCount;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool distributed;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool shuffleShards;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int shardSampleFactor;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t sharedRandomNumber;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t repetitions;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t* bytesReadInPrevRound;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int restart;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t maxRate;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t targetInterval;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool* success;
															#line 1526 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::map<UID, int64_t> storageServerSizes;
															#line 1532 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int effectiveClientCount;
															#line 1533 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int i;
															#line 1534 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t rateLimitForThisRound;
															#line 1544 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<IRateControl> rateLimiter;
															#line 1545 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double rateLimiterStartTime;
															#line 1546 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t bytesReadInthisRound;
															#line 1547 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double rateLimiterCumulatedWaitTime;
															#line 1548 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool decideToRunAtMaxRate;
															#line 1550 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double dbSize;
															#line 1551 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int ssCount;
															#line 1565 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<KeyRangeRef> ranges;
															#line 1572 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<int> shardOrder;
															#line 1581 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Reference<DDConfiguration::RangeConfigMapSnapshot> userRangeConfig;
															#line 1584 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int customReplicatedShards;
															#line 1585 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int underReplicatedShards;
															#line 1586 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t numCheckedShard;
															#line 1587 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t numCheckedReadShard;
															#line 1590 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int shard;
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	KeyRangeRef range;
															#line 1593 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<UID> sourceStorageServers;
															#line 1594 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<UID> destStorageServers;
															#line 1595 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Transaction tr;
															#line 1597 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int bytesReadInRange;
															#line 1604 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool isRelocating;
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double shardCheckStartTime;
															#line 1607 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double rateLimiterWaitTimeForThisShard;
															#line 1608 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double dataConsistencyCheckTimeForThisShard;
															#line 1702 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<UID> storageServers;
															#line 1703 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<StorageServerInterface> storageServerInterfaces;
															#line 1711 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Optional<Value>> serverListValues;
															#line 1743 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<int64_t> estimatedBytes;
															#line 1744 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	StorageMetrics estimated;
															#line 1748 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	ShardSizeBounds shardBounds;
															#line 1764 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int shardKeys;
															#line 1765 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int shardBytes;
															#line 1766 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int sampledBytes;
															#line 1767 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int splitBytes;
															#line 1768 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int firstKeySampledBytes;
															#line 1769 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int sampledKeys;
															#line 1770 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int sampledKeysWithProb;
															#line 1771 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double shardVariance;
															#line 1772 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	bool canSplit;
															#line 1773 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Key lastSampleKey;
															#line 1774 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Key lastStartSampleKey;
															#line 1775 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	int64_t totalReadAmount;
															#line 1776 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	KeyRange readRange;
															#line 1777 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Transaction onErrorTr;
															#line 1787 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	std::vector<Future<ErrorOr<GetKeyValuesReply>>> keyValueFutures;
															#line 1788 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Optional<int> firstValidServer;
															#line 1789 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double dataConsistencyCheckBeginTime;
															#line 1842 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	VectorRef<KeyValueRef> data;
															#line 1901 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	double rateLimiterBeforeWaitTime;
															#line 1936 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	Error err;
															#line 12386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
};
// This generated class is to be used only via checkDataConsistency()
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
class CheckDataConsistencyActor final : public Actor<Void>, public ActorCallback< CheckDataConsistencyActor, 0, int64_t >, public ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >, public ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >, public ActorCallback< CheckDataConsistencyActor, 3, RangeResult >, public ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >, public ActorCallback< CheckDataConsistencyActor, 5, Void >, public ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >, public ActorCallback< CheckDataConsistencyActor, 7, Version >, public ActorCallback< CheckDataConsistencyActor, 8, int >, public ActorCallback< CheckDataConsistencyActor, 9, Void >, public ActorCallback< CheckDataConsistencyActor, 10, Void >, public ActorCallback< CheckDataConsistencyActor, 11, Void >, public ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >, public FastAllocated<CheckDataConsistencyActor>, public CheckDataConsistencyActorState<CheckDataConsistencyActor> {
															#line 12391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
public:
	using FastAllocated<CheckDataConsistencyActor>::operator new;
	using FastAllocated<CheckDataConsistencyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7154866036362556160UL, 15497484830222075136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckDataConsistencyActor, 0, int64_t >;
friend struct ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >;
friend struct ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >;
friend struct ActorCallback< CheckDataConsistencyActor, 3, RangeResult >;
friend struct ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >;
friend struct ActorCallback< CheckDataConsistencyActor, 5, Void >;
friend struct ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >;
friend struct ActorCallback< CheckDataConsistencyActor, 7, Version >;
friend struct ActorCallback< CheckDataConsistencyActor, 8, int >;
friend struct ActorCallback< CheckDataConsistencyActor, 9, Void >;
friend struct ActorCallback< CheckDataConsistencyActor, 10, Void >;
friend struct ActorCallback< CheckDataConsistencyActor, 11, Void >;
friend struct ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >;
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	CheckDataConsistencyActor(Database const& cx,VectorRef<KeyValueRef> const& keyLocations,DatabaseConfiguration const& configuration,std::map<UID, StorageServerInterface> const& tssMapping,bool const& performQuiescentChecks,bool const& performTSSCheck,bool const& firstClient,bool const& failureIsError,int const& clientId,int const& clientCount,bool const& distributed,bool const& shuffleShards,int const& shardSampleFactor,int64_t const& sharedRandomNumber,int64_t const& repetitions,int64_t* const& bytesReadInPrevRound,int const& restart,int64_t const& maxRate,int64_t const& targetInterval,bool* const& success) 
															#line 12420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
		 : Actor<Void>(),
		   CheckDataConsistencyActorState<CheckDataConsistencyActor>(cx, keyLocations, configuration, tssMapping, performQuiescentChecks, performTSSCheck, firstClient, failureIsError, clientId, clientCount, distributed, shuffleShards, shardSampleFactor, sharedRandomNumber, repetitions, bytesReadInPrevRound, restart, maxRate, targetInterval, success),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkDataConsistency", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16017061053802719488UL, 16942108968284409088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataConsistencyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkDataConsistency");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkDataConsistency", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 1, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 2, Reference<DDConfiguration::RangeConfigMapSnapshot> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 4, std::vector<Optional<Value>> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 6, std::pair<std::vector<int64_t>, StorageMetrics> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 7, Version >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 8, int >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< CheckDataConsistencyActor, 12, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
[[nodiscard]] Future<Void> checkDataConsistency( Database const& cx, VectorRef<KeyValueRef> const& keyLocations, DatabaseConfiguration const& configuration, std::map<UID, StorageServerInterface> const& tssMapping, bool const& performQuiescentChecks, bool const& performTSSCheck, bool const& firstClient, bool const& failureIsError, int const& clientId, int const& clientCount, bool const& distributed, bool const& shuffleShards, int const& shardSampleFactor, int64_t const& sharedRandomNumber, int64_t const& repetitions, int64_t* const& bytesReadInPrevRound, int const& restart, int64_t const& maxRate, int64_t const& targetInterval, bool* const& success ) {
															#line 1504 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
	return Future<Void>(new CheckDataConsistencyActor(cx, keyLocations, configuration, tssMapping, performQuiescentChecks, performTSSCheck, firstClient, failureIsError, clientId, clientCount, distributed, shuffleShards, shardSampleFactor, sharedRandomNumber, repetitions, bytesReadInPrevRound, restart, maxRate, targetInterval, success));
															#line 12465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConsistencyScan.actor.g.cpp"
}

#line 2116 "/Users/ec2-user/foundationdb/fdbserver/ConsistencyScan.actor.cpp"
