#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
/*
 * BackupWorker.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BlobCipher.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/BackupInterface.h"
#include "fdbserver/BackupProgress.actor.h"
#include "fdbclient/GetEncryptCipherKeys.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/LogProtocolMessage.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "flow/Error.h"

#include "flow/IRandom.h"
#include "fdbclient/Tracing.h"
#include "flow/actorcompiler.h" // This must be the last #include.

#define SevDebugMemory SevVerbose

struct VersionedMessage {
	LogMessageVersion version;
	StringRef message;
	VectorRef<Tag> tags;
	Arena arena; // Keep a reference to the memory containing the message
	Arena decryptArena; // Arena used for decrypt buffer.

	VersionedMessage(LogMessageVersion v, StringRef m, const VectorRef<Tag>& t, const Arena& a)
	  : version(v), message(m), tags(t), arena(a) {}
	Version getVersion() const { return version.version; }
	uint32_t getSubVersion() const { return version.sub; }
	// Returns the estimated size of the message in bytes, assuming 6 tags.
	size_t getEstimatedSize() const { return message.size() + TagsAndMessage::getHeaderSize(6); }

	// Returns true if the message is a mutation that could be backed up (normal keys, system key backup ranges, or the
	// metadata version key)
	bool isCandidateBackupMessage(MutationRef* m,
	                              const std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>>& cipherKeys) {
		for (Tag tag : tags) {
			if (tag.locality == tagLocalitySpecial || tag.locality == tagLocalityTxs) {
				return false; // skip Txs mutations
			}
		}

		ArenaReader reader(arena, message, AssumeVersion(g_network->protocolVersion()));

		// Return false for LogProtocolMessage and SpanContextMessage metadata messages.
		if (LogProtocolMessage::isNextIn(reader))
			return false;
		if (reader.protocolVersion().hasSpanContext() && SpanContextMessage::isNextIn(reader))
			return false;
		if (reader.protocolVersion().hasOTELSpanContext() && OTELSpanContextMessage::isNextIn(reader)) {
			CODE_PROBE(true, "Returning false for OTELSpanContextMessage");
			return false;
		}
		reader >> *m;
		if (m->isEncrypted()) {
			// In case the mutation is encrypted, get the decrypted mutation and also update message to point to
			// the decrypted mutation.
			// We use dedicated arena for decrypt buffer, as the other arena is used to count towards backup lock bytes.
			*m = m->decrypt(cipherKeys, decryptArena, BlobCipherMetrics::BACKUP, &message);
		}

		// Return true if the mutation intersects any legal backup ranges
		if (normalKeys.contains(m->param1) || m->param1 == metadataVersionKey) {
			return true;
		} else if (m->type != MutationRef::Type::ClearRange) {
			return systemBackupMutationMask().rangeContaining(m->param1).value();
		} else {
			for (auto& r : systemBackupMutationMask().intersectingRanges(KeyRangeRef(m->param1, m->param2))) {
				if (r->value()) {
					return true;
				}
			}

			return false;
		}
	}

	void collectCipherDetailIfEncrypted(std::unordered_set<BlobCipherDetails>& cipherDetails) {
		ASSERT(!message.empty());
		if (*message.begin() == MutationRef::Encrypted) {
			ArenaReader reader(arena, message, AssumeVersion(ProtocolVersion::withEncryptionAtRest()));
			MutationRef m;
			reader >> m;
			m.updateEncryptCipherDetails(cipherDetails);
		}
	}
};

struct BackupData {
	const UID myId;
	const Tag tag; // LogRouter tag for this worker, i.e., (-2, i)
	const int totalTags; // Total log router tags
	const Version startVersion; // This worker's start version
	const Optional<Version> endVersion; // old epoch's end version (inclusive), or empty for current epoch
	const LogEpoch recruitedEpoch; // current epoch whose tLogs are receiving mutations
	const LogEpoch backupEpoch; // the epoch workers should pull mutations
	LogEpoch oldestBackupEpoch = 0; // oldest epoch that still has data on tLogs for backup to pull
	Version minKnownCommittedVersion;
	Version savedVersion; // Largest version saved to blob storage
	Version popVersion; // Largest version popped in NOOP mode, can be larger than savedVersion.
	Reference<AsyncVar<ServerDBInfo> const> db;
	AsyncVar<Reference<ILogSystem>> logSystem;
	Database cx;
	std::vector<VersionedMessage> messages;
	NotifiedVersion pulledVersion;
	bool pulling = false;
	bool stopped = false;
	bool exitEarly = false; // If the worker is on an old epoch and all backups starts a version >= the endVersion
	AsyncVar<bool> paused; // Track if "backupPausedKey" is set.
	Reference<FlowLock> lock;

	struct PerBackupInfo {
		PerBackupInfo() = default;
		PerBackupInfo(BackupData* data, UID uid, Version v) : self(data), startVersion(v) {
			// Open the container and get key ranges
			BackupConfig config(uid);
			container = config.backupContainer().get(data->cx.getReference());
			ranges = config.backupRanges().get(data->cx.getReference());
			if (self->backupEpoch == self->recruitedEpoch) {
				// Only current epoch's worker update the number of backup workers.
				updateWorker = _updateStartedWorkers(this, data, uid);
			}
			TraceEvent("BackupWorkerAddJob", data->myId).detail("BackupID", uid).detail("Version", v);
		}

		void stop() {
			stopped = true;
			updateWorker = Void(); // cancel actors
		}

		void cancelUpdater() { updateWorker = Void(); }

		bool isReady() const { return stopped || (container.isReady() && ranges.isReady()); }

		Future<Void> waitReady() {
			if (stopped)
				return Void();
			return _waitReady(this);
		}

																	#line 169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
// This generated class is to be used only via _waitReady()
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class _waitReadyActor>
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _waitReadyActorState {
															#line 175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_waitReadyActorState(PerBackupInfo* const& info) 
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : info(info)
															#line 182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("_waitReady", reinterpret_cast<unsigned long>(this));

	}
	~_waitReadyActorState() 
	{
		fdb_probe_actor_destroy("_waitReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(info->container) && success(info->ranges);
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_waitReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_waitReadyActor*>(this)->actor_wait_state = 1;
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _waitReadyActor, 0, Void >*>(static_cast<_waitReadyActor*>(this)));
															#line 204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_waitReadyActorState();
		static_cast<_waitReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_waitReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_waitReadyActorState(); static_cast<_waitReadyActor*>(this)->destroy(); return 0; }
															#line 227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<_waitReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_waitReadyActorState();
		static_cast<_waitReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_waitReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_waitReadyActorState(); static_cast<_waitReadyActor*>(this)->destroy(); return 0; }
															#line 239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<_waitReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_waitReadyActorState();
		static_cast<_waitReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_waitReadyActor*>(this)->actor_wait_state > 0) static_cast<_waitReadyActor*>(this)->actor_wait_state = 0;
		static_cast<_waitReadyActor*>(this)->ActorCallback< _waitReadyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _waitReadyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_waitReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_waitReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_waitReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _waitReadyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_waitReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_waitReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_waitReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _waitReadyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_waitReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_waitReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_waitReady", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	PerBackupInfo* info;
															#line 324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via _waitReady()
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _waitReadyActor final : public Actor<Void>, public ActorCallback< _waitReadyActor, 0, Void >, public FastAllocated<_waitReadyActor>, public _waitReadyActorState<_waitReadyActor> {
															#line 329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<_waitReadyActor>::operator new;
	using FastAllocated<_waitReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17313659492695823872UL, 13625505887567916800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _waitReadyActor, 0, Void >;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_waitReadyActor(PerBackupInfo* const& info) 
															#line 346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   _waitReadyActorState<_waitReadyActor>(info),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_waitReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2841224896791291648UL, 2872305995651855104UL);
		ActorExecutionContextHelper __helper(static_cast<_waitReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_waitReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_waitReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _waitReadyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Void> _waitReady( PerBackupInfo* const& info ) {
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new _waitReadyActor(info));
															#line 378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 171 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

		// Update the number of backup workers in the BackupConfig. Each worker
		// writes (epoch, tag.id) into the key. Worker 0 monitors the key and once
		// all workers have updated the key, this backup is considered as started
		// (i.e., the "submitBackup" call is successful). Worker 0 then sets
		// the "allWorkerStarted" flag, which in turn unblocks
		// StartFullBackupTaskFunc::_execute.
																	#line 389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
// This generated class is to be used only via _updateStartedWorkers()
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class _updateStartedWorkersActor>
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _updateStartedWorkersActorState {
															#line 395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_updateStartedWorkersActorState(PerBackupInfo* const& info,BackupData* const& self,UID const& uid) 
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : info(info),
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   self(self),
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   uid(uid),
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   config(uid),
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   watchFuture(),
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   updated(false),
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   firstWorker(info->self->tag.id == 0),
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   allUpdated(false),
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   workers(),
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tr(new ReadYourWritesTransaction(self->cx))
															#line 420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("_updateStartedWorkers", reinterpret_cast<unsigned long>(this));

	}
	~_updateStartedWorkersActorState() 
	{
		fdb_probe_actor_destroy("_updateStartedWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_updateStartedWorkersActorState();
		static_cast<_updateStartedWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerSetReady", self->myId).detail("BackupID", uid).detail("TagId", self->tag.id);
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_updateStartedWorkersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_updateStartedWorkersActorState(); static_cast<_updateStartedWorkersActor*>(this)->destroy(); return 0; }
															#line 460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<_updateStartedWorkersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_updateStartedWorkersActorState();
		static_cast<_updateStartedWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Optional<std::vector<std::pair<int64_t, int64_t>>>> __when_expr_0 = config.startedBackupWorkers().get(tr);
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 1;
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 5;
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 4, Void >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<std::vector<std::pair<int64_t, int64_t>>> const& tmp,int loopDepth) 
	{
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		workers = tmp;
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!updated)
															#line 552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (workers.present())
															#line 556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				workers.get().emplace_back(self->recruitedEpoch, (int64_t)self->tag.id);
															#line 560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
			else
			{
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				std::vector<std::pair<int64_t, int64_t>> v(1, { self->recruitedEpoch, self->tag.id });
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				workers = Optional<std::vector<std::pair<int64_t, int64_t>>>(v);
															#line 568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
		}
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (firstWorker)
															#line 573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!workers.present())
															#line 577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerDetectAbortedJob", self->myId).detail("BackupID", uid);
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (!static_cast<_updateStartedWorkersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_updateStartedWorkersActorState(); static_cast<_updateStartedWorkersActor*>(this)->destroy(); return 0; }
															#line 583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				new (&static_cast<_updateStartedWorkersActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_updateStartedWorkersActorState();
				static_cast<_updateStartedWorkersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(workers.present() && workers.get().size() > 0);
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			std::vector<std::pair<int64_t, int64_t>>& v = workers.get();
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			v.erase(std::remove_if(v.begin(), v.end(), [epoch = self->recruitedEpoch](const std::pair<int64_t, int64_t>& p) { return p.first != epoch; }), v.end());
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			std::set<int64_t> tags;
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( auto p : v ) {
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				tags.insert(p.second);
															#line 601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (self->totalTags == tags.size())
															#line 605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				config.allWorkerStarted().set(tr, true);
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				allUpdated = true;
															#line 611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
			else
			{
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				watchFuture = tr->watch(config.startedBackupWorkers().key);
															#line 617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(workers.present() && workers.get().size() > 0);
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!updated)
															#line 623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				config.startedBackupWorkers().set(tr, workers.get());
															#line 627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( auto p : workers.get() ) {
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerDebugTag", self->myId) .detail("Epoch", p.first) .detail("TagID", p.second);
															#line 633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 2;
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 1, Void >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 644 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(workers.present() && workers.get().size() > 0);
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			config.startedBackupWorkers().set(tr, workers.get());
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
			static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 4;
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 3, Void >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<std::vector<std::pair<int64_t, int64_t>>> && tmp,int loopDepth) 
	{
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		workers = tmp;
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!updated)
															#line 674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (workers.present())
															#line 678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				workers.get().emplace_back(self->recruitedEpoch, (int64_t)self->tag.id);
															#line 682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
			else
			{
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				std::vector<std::pair<int64_t, int64_t>> v(1, { self->recruitedEpoch, self->tag.id });
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				workers = Optional<std::vector<std::pair<int64_t, int64_t>>>(v);
															#line 690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
		}
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (firstWorker)
															#line 695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!workers.present())
															#line 699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerDetectAbortedJob", self->myId).detail("BackupID", uid);
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (!static_cast<_updateStartedWorkersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_updateStartedWorkersActorState(); static_cast<_updateStartedWorkersActor*>(this)->destroy(); return 0; }
															#line 705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				new (&static_cast<_updateStartedWorkersActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_updateStartedWorkersActorState();
				static_cast<_updateStartedWorkersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(workers.present() && workers.get().size() > 0);
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			std::vector<std::pair<int64_t, int64_t>>& v = workers.get();
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			v.erase(std::remove_if(v.begin(), v.end(), [epoch = self->recruitedEpoch](const std::pair<int64_t, int64_t>& p) { return p.first != epoch; }), v.end());
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			std::set<int64_t> tags;
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( auto p : v ) {
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				tags.insert(p.second);
															#line 723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (self->totalTags == tags.size())
															#line 727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				config.allWorkerStarted().set(tr, true);
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				allUpdated = true;
															#line 733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
			else
			{
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				watchFuture = tr->watch(config.startedBackupWorkers().key);
															#line 739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
															#line 228 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(workers.present() && workers.get().size() > 0);
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!updated)
															#line 745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				config.startedBackupWorkers().set(tr, workers.get());
															#line 749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
															#line 232 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( auto p : workers.get() ) {
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerDebugTag", self->myId) .detail("Epoch", p.first) .detail("TagID", p.second);
															#line 755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 2;
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 1, Void >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(workers.present() && workers.get().size() > 0);
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			config.startedBackupWorkers().set(tr, workers.get());
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_3.get(), loopDepth); };
			static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 4;
															#line 248 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 3, Void >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::vector<std::pair<int64_t, int64_t>>> const& tmp,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(tmp, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<std::vector<std::pair<int64_t, int64_t>>> && tmp,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(tmp), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state > 0) static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<_updateStartedWorkersActor*>(this)->ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >::remove();

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >*,Optional<std::vector<std::pair<int64_t, int64_t>>> const& value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >*,Optional<std::vector<std::pair<int64_t, int64_t>>> && value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >*,Error err) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		updated = true;
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (allUpdated)
															#line 877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_2.get(), loopDepth); };
		static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 3;
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 2, Void >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		updated = true;
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (allUpdated)
															#line 901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_2.get(), loopDepth); };
		static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 3;
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _updateStartedWorkersActor, 2, Void >*>(static_cast<_updateStartedWorkersActor*>(this)));
															#line 914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state > 0) static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<_updateStartedWorkersActor*>(this)->ActorCallback< _updateStartedWorkersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _updateStartedWorkersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tr->reset();
															#line 998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tr->reset();
															#line 1007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state > 0) static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<_updateStartedWorkersActor*>(this)->ActorCallback< _updateStartedWorkersActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _updateStartedWorkersActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont16(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont16(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state > 0) static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<_updateStartedWorkersActor*>(this)->ActorCallback< _updateStartedWorkersActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _updateStartedWorkersActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont17(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		allUpdated = false;
															#line 1191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		allUpdated = false;
															#line 1200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state > 0) static_cast<_updateStartedWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<_updateStartedWorkersActor*>(this)->ActorCallback< _updateStartedWorkersActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _updateStartedWorkersActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _updateStartedWorkersActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	PerBackupInfo* info;
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	UID uid;
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupConfig config;
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> watchFuture;
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	bool updated;
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	bool firstWorker;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	bool allUpdated;
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Optional<std::vector<std::pair<int64_t, int64_t>>> workers;
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via _updateStartedWorkers()
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _updateStartedWorkersActor final : public Actor<Void>, public ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >, public ActorCallback< _updateStartedWorkersActor, 1, Void >, public ActorCallback< _updateStartedWorkersActor, 2, Void >, public ActorCallback< _updateStartedWorkersActor, 3, Void >, public ActorCallback< _updateStartedWorkersActor, 4, Void >, public FastAllocated<_updateStartedWorkersActor>, public _updateStartedWorkersActorState<_updateStartedWorkersActor> {
															#line 1305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<_updateStartedWorkersActor>::operator new;
	using FastAllocated<_updateStartedWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11222724835768155904UL, 2376276701625844480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >;
friend struct ActorCallback< _updateStartedWorkersActor, 1, Void >;
friend struct ActorCallback< _updateStartedWorkersActor, 2, Void >;
friend struct ActorCallback< _updateStartedWorkersActor, 3, Void >;
friend struct ActorCallback< _updateStartedWorkersActor, 4, Void >;
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_updateStartedWorkersActor(PerBackupInfo* const& info,BackupData* const& self,UID const& uid) 
															#line 1326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   _updateStartedWorkersActorState<_updateStartedWorkersActor>(info, self, uid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15701260814676215808UL, 3300621109131050240UL);
		ActorExecutionContextHelper __helper(static_cast<_updateStartedWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_updateStartedWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_updateStartedWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _updateStartedWorkersActor, 0, Optional<std::vector<std::pair<int64_t, int64_t>>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _updateStartedWorkersActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _updateStartedWorkersActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _updateStartedWorkersActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _updateStartedWorkersActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Void> _updateStartedWorkers( PerBackupInfo* const& info, BackupData* const& self, UID const& uid ) {
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new _updateStartedWorkersActor(info, self, uid));
															#line 1362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 259 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

		BackupData* self = nullptr;

		// Backup request's commit version. Mutations are logged at some version after this.
		Version startVersion = invalidVersion;
		// The last mutation log's saved version (not inclusive), i.e., next log's begin version.
		Version lastSavedVersion = invalidVersion;

		Future<Optional<Reference<IBackupContainer>>> container;
		Future<Optional<std::vector<KeyRange>>> ranges; // Key ranges of this backup
		Future<Void> updateWorker;
		bool stopped = false; // Is the backup stopped?
	};

	std::map<UID, PerBackupInfo> backups; // Backup UID to infos
	AsyncTrigger changedTrigger;
	AsyncTrigger doneTrigger;

	CounterCollection cc;
	Future<Void> logger;
	Future<Void> noopPopper; // holds actor to save progress in NOOP mode
	AsyncVar<Version> popTrigger; // trigger to pop version in NOOP mode

	explicit BackupData(UID id, Reference<AsyncVar<ServerDBInfo> const> db, const InitializeBackupRequest& req)
	  : myId(id), tag(req.routerTag), totalTags(req.totalTags), startVersion(req.startVersion),
	    endVersion(req.endVersion), recruitedEpoch(req.recruitedEpoch), backupEpoch(req.backupEpoch),
	    minKnownCommittedVersion(invalidVersion), savedVersion(req.startVersion - 1), popVersion(req.startVersion - 1),
	    db(db), pulledVersion(0), paused(false), lock(new FlowLock(SERVER_KNOBS->BACKUP_WORKER_LOCK_BYTES)),
	    cc("BackupWorker", myId.toString()) {
		cx = openDBOnServer(db, TaskPriority::DefaultEndpoint, LockAware::True);

		specialCounter(cc, "SavedVersion", [this]() { return this->savedVersion; });
		specialCounter(cc, "MinKnownCommittedVersion", [this]() { return this->minKnownCommittedVersion; });
		specialCounter(cc, "MsgQ", [this]() { return this->messages.size(); });
		specialCounter(cc, "BufferedBytes", [this]() { return this->lock->activePermits(); });
		specialCounter(cc, "AvailableBytes", [this]() { return this->lock->available(); });
		logger =
		    cc.traceCounters("BackupWorkerMetrics", myId, SERVER_KNOBS->WORKER_LOGGING_INTERVAL, "BackupWorkerMetrics");
		popTrigger.set(invalidVersion);
		noopPopper = _noopPopper(this);
	}

	bool pullFinished() const { return endVersion.present() && pulledVersion.get() > endVersion.get(); }

	bool allMessageSaved() const {
		return (endVersion.present() && savedVersion >= endVersion.get()) || stopped || exitEarly;
	}

	Version maxPopVersion() const { return endVersion.present() ? endVersion.get() : minKnownCommittedVersion; }

	// Inserts a backup's single range into rangeMap.
	template <class T>
	void insertRange(KeyRangeMap<std::set<T>>& keyRangeMap, KeyRangeRef range, T value) {
		for (auto& logRange : keyRangeMap.modify(range)) {
			logRange->value().insert(value);
		}
		for (auto& logRange : keyRangeMap.modify(singleKeyRange(metadataVersionKey))) {
			logRange->value().insert(value);
		}
		TraceEvent("BackupWorkerInsertRange", myId)
		    .detail("Value", value)
		    .detail("Begin", range.begin)
		    .detail("End", range.end);
	}

	// Inserts a backup's ranges into rangeMap.
	template <class T>
	void insertRanges(KeyRangeMap<std::set<T>>& keyRangeMap, const Optional<std::vector<KeyRange>>& ranges, T value) {
		if (!ranges.present() || ranges.get().empty()) {
			// insert full ranges of normal keys
			return insertRange(keyRangeMap, normalKeys, value);
		}
		for (const auto& range : ranges.get()) {
			insertRange(keyRangeMap, range, value);
		}
	}

	void pop() {
		if (backupEpoch > oldestBackupEpoch || stopped) {
			// Defer pop if old epoch hasn't finished popping yet.
			// If stopped because of displacement, do NOT pop as the progress may
			// not be saved in a timely fashion. As a result, next epoch may still
			// need to read mutations in the version range. Let the next epoch's
			// worker do the pop instead.
			TraceEvent("BackupWorkerPopDeferred", myId)
			    .suppressFor(1.0)
			    .detail("BackupEpoch", backupEpoch)
			    .detail("OldestEpoch", oldestBackupEpoch)
			    .detail("Version", savedVersion);
			return;
		}
		ASSERT_WE_THINK(backupEpoch == oldestBackupEpoch);
		const Tag popTag = logSystem.get()->getPseudoPopTag(tag, ProcessClass::BackupClass);
		DisabledTraceEvent("BackupWorkerPop", myId)
		    .detail("Tag", popTag)
		    .detail("SavedVersion", savedVersion)
		    .detail("PopVersion", popVersion);
		logSystem.get()->pop(std::max(popVersion, savedVersion), popTag);
	}

	void stop() {
		stopped = true;
		for (auto& [uid, info] : backups) {
			// Cancel the actor. Because container is valid, CANNOT set the
			// "stop" flag that will block writing mutation files in
			// saveMutationsToFile().
			info.cancelUpdater();
		}
		doneTrigger.trigger();
	}

	// Erases messages and updates lock with memory released.
	void eraseMessages(int num) {
		ASSERT(num <= messages.size());
		if (num == 0)
			return;

		// Accumulate erased message sizes
		int64_t bytes = 0;
		for (int i = 0; i < num; i++) {
			bytes += messages[i].getEstimatedSize();
		}
		TraceEvent(SevDebugMemory, "BackupWorkerMemory", myId)
		    .detail("Release", bytes)
		    .detail("Total", lock->activePermits());
		lock->release(bytes);
		messages.erase(messages.begin(), messages.begin() + num);
	}

	void eraseMessagesAfterEndVersion() {
		ASSERT(endVersion.present());
		const Version ver = endVersion.get();
		while (!messages.empty()) {
			if (messages.back().getVersion() > ver) {
				size_t bytes = messages.back().getEstimatedSize();
				TraceEvent(SevDebugMemory, "BackupWorkerMemory", myId).detail("Release", bytes);
				lock->release(bytes);
				messages.pop_back();
			} else {
				return;
			}
		}
	}

	// Give a list of current active backups, compare with current list and decide
	// to start new backups and stop ones not in the active state.
	void onBackupChanges(const std::vector<std::pair<UID, Version>>& uidVersions) {
		std::set<UID> stopList;
		for (auto it : backups) {
			stopList.insert(it.first);
		}

		bool modified = false;
		bool minVersionChanged = false;
		Version minVersion = std::numeric_limits<Version>::max();
		for (const auto& [uid, version] : uidVersions) {
			auto it = backups.find(uid);
			if (it == backups.end()) {
				modified = true;
				backups.emplace(uid, BackupData::PerBackupInfo(this, uid, version));
				minVersion = std::min(minVersion, version);
				minVersionChanged = true;
			} else {
				stopList.erase(uid);
			}
		}

		for (UID uid : stopList) {
			auto it = backups.find(uid);
			ASSERT(it != backups.end());
			it->second.stop();
			modified = true;
		}
		if (minVersionChanged && backupEpoch < recruitedEpoch && savedVersion + 1 == startVersion) {
			// Advance savedVersion to minimize version ranges in case backupEpoch's
			// progress is not saved. Master may set a very low startVersion that
			// is already popped. Advance the version is safe because these
			// versions are not popped -- if they are popped, their progress should
			// be already recorded and Master would use a higher version than minVersion.
			savedVersion = std::max(minVersion, savedVersion);
		}
		if (modified)
			changedTrigger.trigger();
	}

	// Update the NOOP popped version so that when backup is started or resumed,
	// the worker can ignore any versions that are already popped.
																#line 1553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
// This generated class is to be used only via _saveNoopVersion()
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class _saveNoopVersionActor>
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _saveNoopVersionActorState {
															#line 1559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_saveNoopVersionActorState(BackupData* const& self,Version const& poppedVersion) 
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   poppedVersion(poppedVersion),
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tr(self->cx)
															#line 1570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("_saveNoopVersion", reinterpret_cast<unsigned long>(this));

	}
	~_saveNoopVersionActorState() 
	{
		fdb_probe_actor_destroy("_saveNoopVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 1585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_saveNoopVersionActorState();
		static_cast<_saveNoopVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 451 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(backupWorkerMaxNoopVersionKey);
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_saveNoopVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_saveNoopVersionActor*>(this)->actor_wait_state = 1;
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >*>(static_cast<_saveNoopVersionActor*>(this)));
															#line 1629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 468 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 468 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_saveNoopVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_saveNoopVersionActor*>(this)->actor_wait_state = 3;
															#line 468 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _saveNoopVersionActor, 2, Void >*>(static_cast<_saveNoopVersionActor*>(this)));
															#line 1658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& noopValue,int loopDepth) 
	{
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (noopValue.present())
															#line 1673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			Version noopVersion = BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned());
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (poppedVersion > noopVersion)
															#line 1679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				tr.set(backupWorkerMaxNoopVersionKey, BinaryWriter::toValue(poppedVersion, Unversioned()));
															#line 1683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
		}
		else
		{
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.set(backupWorkerMaxNoopVersionKey, BinaryWriter::toValue(poppedVersion, Unversioned()));
															#line 1690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<_saveNoopVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_saveNoopVersionActor*>(this)->actor_wait_state = 2;
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _saveNoopVersionActor, 1, Void >*>(static_cast<_saveNoopVersionActor*>(this)));
															#line 1701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && noopValue,int loopDepth) 
	{
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (noopValue.present())
															#line 1710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			Version noopVersion = BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned());
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (poppedVersion > noopVersion)
															#line 1716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				tr.set(backupWorkerMaxNoopVersionKey, BinaryWriter::toValue(poppedVersion, Unversioned()));
															#line 1720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
		}
		else
		{
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.set(backupWorkerMaxNoopVersionKey, BinaryWriter::toValue(poppedVersion, Unversioned()));
															#line 1727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<_saveNoopVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<_saveNoopVersionActor*>(this)->actor_wait_state = 2;
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _saveNoopVersionActor, 1, Void >*>(static_cast<_saveNoopVersionActor*>(this)));
															#line 1738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& noopValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(noopValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && noopValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(noopValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_saveNoopVersionActor*>(this)->actor_wait_state > 0) static_cast<_saveNoopVersionActor*>(this)->actor_wait_state = 0;
		static_cast<_saveNoopVersionActor*>(this)->ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_saveNoopVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_saveNoopVersionActorState(); static_cast<_saveNoopVersionActor*>(this)->destroy(); return 0; }
															#line 1822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<_saveNoopVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_saveNoopVersionActorState();
		static_cast<_saveNoopVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_saveNoopVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_saveNoopVersionActorState(); static_cast<_saveNoopVersionActor*>(this)->destroy(); return 0; }
															#line 1834 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<_saveNoopVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_saveNoopVersionActorState();
		static_cast<_saveNoopVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_saveNoopVersionActor*>(this)->actor_wait_state > 0) static_cast<_saveNoopVersionActor*>(this)->actor_wait_state = 0;
		static_cast<_saveNoopVersionActor*>(this)->ActorCallback< _saveNoopVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _saveNoopVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _saveNoopVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _saveNoopVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_saveNoopVersionActor*>(this)->actor_wait_state > 0) static_cast<_saveNoopVersionActor*>(this)->actor_wait_state = 0;
		static_cast<_saveNoopVersionActor*>(this)->ActorCallback< _saveNoopVersionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _saveNoopVersionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _saveNoopVersionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _saveNoopVersionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Version poppedVersion;
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Transaction tr;
															#line 2010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via _saveNoopVersion()
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _saveNoopVersionActor final : public Actor<Void>, public ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >, public ActorCallback< _saveNoopVersionActor, 1, Void >, public ActorCallback< _saveNoopVersionActor, 2, Void >, public FastAllocated<_saveNoopVersionActor>, public _saveNoopVersionActorState<_saveNoopVersionActor> {
															#line 2015 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<_saveNoopVersionActor>::operator new;
	using FastAllocated<_saveNoopVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5811762074443240704UL, 5783381184150560768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >;
friend struct ActorCallback< _saveNoopVersionActor, 1, Void >;
friend struct ActorCallback< _saveNoopVersionActor, 2, Void >;
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_saveNoopVersionActor(BackupData* const& self,Version const& poppedVersion) 
															#line 2034 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   _saveNoopVersionActorState<_saveNoopVersionActor>(self, poppedVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_saveNoopVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15215348718762738432UL, 14746645298869324800UL);
		ActorExecutionContextHelper __helper(static_cast<_saveNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_saveNoopVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_saveNoopVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _saveNoopVersionActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _saveNoopVersionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _saveNoopVersionActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Void> _saveNoopVersion( BackupData* const& self, Version const& poppedVersion ) {
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new _saveNoopVersionActor(self, poppedVersion));
															#line 2068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 472 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

																#line 2073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
// This generated class is to be used only via _noopPopper()
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class _noopPopperActor>
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _noopPopperActorState {
															#line 2079 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_noopPopperActorState(BackupData* const& self) 
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   onChange(self->popTrigger.onChange())
															#line 2088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("_noopPopper", reinterpret_cast<unsigned long>(this));

	}
	~_noopPopperActorState() 
	{
		fdb_probe_actor_destroy("_noopPopper", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 476 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 2103 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_noopPopperActorState();
		static_cast<_noopPopperActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = onChange;
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<_noopPopperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_noopPopperActor*>(this)->actor_wait_state = 1;
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _noopPopperActor, 0, Void >*>(static_cast<_noopPopperActor*>(this)));
															#line 2140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		onChange = self->popTrigger.onChange();
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!self->pulling)
															#line 2151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 482 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			popVersion = self->popTrigger.get();
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(self->popVersion <= popVersion);
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = _saveNoopVersion(self, popVersion);
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_noopPopperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_noopPopperActor*>(this)->actor_wait_state = 2;
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _noopPopperActor, 1, Void >*>(static_cast<_noopPopperActor*>(this)));
															#line 2166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		onChange = self->popTrigger.onChange();
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!self->pulling)
															#line 2182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 482 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			popVersion = self->popTrigger.get();
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(self->popVersion <= popVersion);
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = _saveNoopVersion(self, popVersion);
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_noopPopperActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_noopPopperActor*>(this)->actor_wait_state = 2;
															#line 484 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _noopPopperActor, 1, Void >*>(static_cast<_noopPopperActor*>(this)));
															#line 2197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_noopPopperActor*>(this)->actor_wait_state > 0) static_cast<_noopPopperActor*>(this)->actor_wait_state = 0;
		static_cast<_noopPopperActor*>(this)->ActorCallback< _noopPopperActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _noopPopperActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_noopPopper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_noopPopperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_noopPopper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _noopPopperActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_noopPopper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_noopPopperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_noopPopper", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _noopPopperActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_noopPopper", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_noopPopperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_noopPopper", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->popVersion = popVersion;
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerNoopPop", self->myId) .detail("Tag", self->tag) .detail("SavedVersion", self->savedVersion) .detail("PopVersion", popVersion);
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->pop();
															#line 2296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->popVersion = popVersion;
															#line 486 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerNoopPop", self->myId) .detail("Tag", self->tag) .detail("SavedVersion", self->savedVersion) .detail("PopVersion", popVersion);
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->pop();
															#line 2309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_noopPopperActor*>(this)->actor_wait_state > 0) static_cast<_noopPopperActor*>(this)->actor_wait_state = 0;
		static_cast<_noopPopperActor*>(this)->ActorCallback< _noopPopperActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _noopPopperActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_noopPopper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_noopPopperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_noopPopper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _noopPopperActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_noopPopper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_noopPopperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_noopPopper", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _noopPopperActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_noopPopper", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_noopPopperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_noopPopper", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> onChange;
															#line 482 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Version popVersion;
															#line 2395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via _noopPopper()
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _noopPopperActor final : public Actor<Void>, public ActorCallback< _noopPopperActor, 0, Void >, public ActorCallback< _noopPopperActor, 1, Void >, public FastAllocated<_noopPopperActor>, public _noopPopperActorState<_noopPopperActor> {
															#line 2400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<_noopPopperActor>::operator new;
	using FastAllocated<_noopPopperActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(303139717679278592UL, 7799625410941830400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _noopPopperActor, 0, Void >;
friend struct ActorCallback< _noopPopperActor, 1, Void >;
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_noopPopperActor(BackupData* const& self) 
															#line 2418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   _noopPopperActorState<_noopPopperActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_noopPopper", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2527352761133654784UL, 7744587887698722304UL);
		ActorExecutionContextHelper __helper(static_cast<_noopPopperActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_noopPopper");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_noopPopper", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _noopPopperActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _noopPopperActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Void> _noopPopper( BackupData* const& self ) {
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new _noopPopperActor(self));
															#line 2451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 494 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

																#line 2456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
// This generated class is to be used only via _waitAllInfoReady()
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class _waitAllInfoReadyActor>
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _waitAllInfoReadyActorState {
															#line 2462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_waitAllInfoReadyActorState(BackupData* const& self) 
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self)
															#line 2469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("_waitAllInfoReady", reinterpret_cast<unsigned long>(this));

	}
	~_waitAllInfoReadyActorState() 
	{
		fdb_probe_actor_destroy("_waitAllInfoReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			std::vector<Future<Void>> all;
															#line 497 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for(auto it = self->backups.begin();it != self->backups.end();) {
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (it->second.stopped)
															#line 2488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				{
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					TraceEvent("BackupWorkerRemoveStoppedContainer", self->myId).detail("BackupId", it->first);
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					it = self->backups.erase(it);
															#line 2494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
					continue;
				}
															#line 504 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				all.push_back(it->second.waitReady());
															#line 505 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				it++;
															#line 2501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(all);
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_waitAllInfoReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_waitAllInfoReadyActor*>(this)->actor_wait_state = 1;
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _waitAllInfoReadyActor, 0, Void >*>(static_cast<_waitAllInfoReadyActor*>(this)));
															#line 2512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_waitAllInfoReadyActorState();
		static_cast<_waitAllInfoReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_waitAllInfoReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_waitAllInfoReadyActorState(); static_cast<_waitAllInfoReadyActor*>(this)->destroy(); return 0; }
															#line 2535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<_waitAllInfoReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_waitAllInfoReadyActorState();
		static_cast<_waitAllInfoReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_waitAllInfoReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_waitAllInfoReadyActorState(); static_cast<_waitAllInfoReadyActor*>(this)->destroy(); return 0; }
															#line 2547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<_waitAllInfoReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_waitAllInfoReadyActorState();
		static_cast<_waitAllInfoReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_waitAllInfoReadyActor*>(this)->actor_wait_state > 0) static_cast<_waitAllInfoReadyActor*>(this)->actor_wait_state = 0;
		static_cast<_waitAllInfoReadyActor*>(this)->ActorCallback< _waitAllInfoReadyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _waitAllInfoReadyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_waitAllInfoReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _waitAllInfoReadyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_waitAllInfoReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _waitAllInfoReadyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_waitAllInfoReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 2632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via _waitAllInfoReady()
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _waitAllInfoReadyActor final : public Actor<Void>, public ActorCallback< _waitAllInfoReadyActor, 0, Void >, public FastAllocated<_waitAllInfoReadyActor>, public _waitAllInfoReadyActorState<_waitAllInfoReadyActor> {
															#line 2637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<_waitAllInfoReadyActor>::operator new;
	using FastAllocated<_waitAllInfoReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10813535175366477824UL, 12440244797860505088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _waitAllInfoReadyActor, 0, Void >;
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_waitAllInfoReadyActor(BackupData* const& self) 
															#line 2654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   _waitAllInfoReadyActorState<_waitAllInfoReadyActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9026822507671870720UL, 9655794640352953088UL);
		ActorExecutionContextHelper __helper(static_cast<_waitAllInfoReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_waitAllInfoReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_waitAllInfoReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _waitAllInfoReadyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Void> _waitAllInfoReady( BackupData* const& self ) {
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new _waitAllInfoReadyActor(self));
															#line 2686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 510 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

	Future<Void> waitAllInfoReady() { return _waitAllInfoReady(this); }

	bool isAllInfoReady() const {
		for (const auto& [uid, info] : backups) {
			if (!info.isReady())
				return false;
		}
		return true;
	}

																#line 2701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
// This generated class is to be used only via _getMinKnownCommittedVersion()
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class _getMinKnownCommittedVersionActor>
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _getMinKnownCommittedVersionActorState {
															#line 2707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_getMinKnownCommittedVersionActorState(BackupData* const& self) 
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   span("BA:GetMinCommittedVersion"_loc)
															#line 2716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	~_getMinKnownCommittedVersionActorState() 
	{
		fdb_probe_actor_destroy("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 523 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 2731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_getMinKnownCommittedVersionActorState();
		static_cast<_getMinKnownCommittedVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 525 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			GetReadVersionRequest request(span.context, 0, TransactionPriority::DEFAULT, invalidVersion, GetReadVersionRequest::FLAG_USE_MIN_KNOWN_COMMITTED_VERSION);
															#line 531 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->cx->onProxiesChanged();
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 532 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<GetReadVersionReply> __when_expr_1 = basicLoadBalance(self->cx->getGrvProxies(UseProvisionalProxies::False), &GrvProxyInterface::getConsistentReadVersion, request, self->cx->taskID);
															#line 2770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state = 1;
															#line 531 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >*>(static_cast<_getMinKnownCommittedVersionActor*>(this)));
															#line 532 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _getMinKnownCommittedVersionActor, 1, GetReadVersionReply >*>(static_cast<_getMinKnownCommittedVersionActor*>(this)));
															#line 2777 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (e.code() == error_code_batch_transaction_throttled || e.code() == error_code_grv_proxy_memory_limit_exceeded)
															#line 2799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				StrictFuture<Void> __when_expr_2 = delayJittered(CLIENT_KNOBS->GRV_ERROR_RETRY_DELAY);
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state = 2;
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >*>(static_cast<_getMinKnownCommittedVersionActor*>(this)));
															#line 2810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply const& reply,int loopDepth) 
	{
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->cx->ssVersionVectorCache.applyDelta(reply.ssVersionVectorDelta);
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_getMinKnownCommittedVersionActor*>(this)->SAV<Version>::futures) { (void)(reply.version); this->~_getMinKnownCommittedVersionActorState(); static_cast<_getMinKnownCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 2852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<_getMinKnownCommittedVersionActor*>(this)->SAV< Version >::value()) Version(reply.version);
		this->~_getMinKnownCommittedVersionActorState();
		static_cast<_getMinKnownCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(GetReadVersionReply && reply,int loopDepth) 
	{
															#line 537 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->cx->ssVersionVectorCache.applyDelta(reply.ssVersionVectorDelta);
															#line 538 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<_getMinKnownCommittedVersionActor*>(this)->SAV<Version>::futures) { (void)(reply.version); this->~_getMinKnownCommittedVersionActorState(); static_cast<_getMinKnownCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 2866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<_getMinKnownCommittedVersionActor*>(this)->SAV< Version >::value()) Version(reply.version);
		this->~_getMinKnownCommittedVersionActorState();
		static_cast<_getMinKnownCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<_getMinKnownCommittedVersionActor*>(this)->ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >::remove();
		static_cast<_getMinKnownCommittedVersionActor*>(this)->ActorCallback< _getMinKnownCommittedVersionActor, 1, GetReadVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _getMinKnownCommittedVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply const& value) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _getMinKnownCommittedVersionActor, 1, GetReadVersionReply >*,GetReadVersionReply && value) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _getMinKnownCommittedVersionActor, 1, GetReadVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<_getMinKnownCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<_getMinKnownCommittedVersionActor*>(this)->ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 522 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Span span;
															#line 3105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via _getMinKnownCommittedVersion()
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class _getMinKnownCommittedVersionActor final : public Actor<Version>, public ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >, public ActorCallback< _getMinKnownCommittedVersionActor, 1, GetReadVersionReply >, public ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >, public FastAllocated<_getMinKnownCommittedVersionActor>, public _getMinKnownCommittedVersionActorState<_getMinKnownCommittedVersionActor> {
															#line 3110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<_getMinKnownCommittedVersionActor>::operator new;
	using FastAllocated<_getMinKnownCommittedVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14254948740565748480UL, 1030382566456811520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >;
friend struct ActorCallback< _getMinKnownCommittedVersionActor, 1, GetReadVersionReply >;
friend struct ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >;
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	_getMinKnownCommittedVersionActor(BackupData* const& self) 
															#line 3129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Version>(),
		   _getMinKnownCommittedVersionActorState<_getMinKnownCommittedVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14087104505730542592UL, 16499376419574723584UL);
		ActorExecutionContextHelper __helper(static_cast<_getMinKnownCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_getMinKnownCommittedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_getMinKnownCommittedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _getMinKnownCommittedVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _getMinKnownCommittedVersionActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Version> _getMinKnownCommittedVersion( BackupData* const& self ) {
															#line 521 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Version>(new _getMinKnownCommittedVersionActor(self));
															#line 3162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 552 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

	Future<Version> getMinKnownCommittedVersion() { return _getMinKnownCommittedVersion(this); }
};

// Monitors "backupStartedKey". If "present" is true, wait until the key is set;
// otherwise, wait until the key is cleared. If "watch" is false, do not perform
// the wait for key set/clear events. Returns if key present.
															#line 3173 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorBackupStartedKeyChanges()
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class MonitorBackupStartedKeyChangesActor>
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorBackupStartedKeyChangesActorState {
															#line 3180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorBackupStartedKeyChangesActorState(BackupData* const& self,bool const& present,bool const& watch) 
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   present(present),
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   watch(watch)
															#line 3191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this));

	}
	~MonitorBackupStartedKeyChangesActorState() 
	{
		fdb_probe_actor_destroy("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 3206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorBackupStartedKeyChangesActorState();
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tr = ReadYourWritesTransaction(self->cx);
															#line 563 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		;
															#line 3238 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(backupStartedKey);
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 1;
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >*>(static_cast<MonitorBackupStartedKeyChangesActor*>(this)));
															#line 3272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 4;
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >*>(static_cast<MonitorBackupStartedKeyChangesActor*>(this)));
															#line 3314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> const& value,int loopDepth) 
	{
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		std::vector<std::pair<UID, Version>> uidVersions;
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		bool shouldExit = self->endVersion.present();
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (value.present())
															#line 3333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			uidVersions = decodeBackupStartedValue(value.get());
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent e("BackupWorkerGotStartKey", self->myId);
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			int i = 1;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( auto [uid, version] : uidVersions ) {
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				e.detail(format("BackupID%d", i), uid).detail(format("Version%d", i), version);
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				i++;
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (shouldExit && version < self->endVersion.get())
															#line 3349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				{
															#line 578 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					shouldExit = false;
															#line 3353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				}
			}
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->exitEarly = shouldExit;
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->onBackupChanges(uidVersions);
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (present || !watch)
															#line 3362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (!static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MonitorBackupStartedKeyChangesActorState(); static_cast<MonitorBackupStartedKeyChangesActor*>(this)->destroy(); return 0; }
															#line 3366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				new (&static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV< bool >::value()) bool(true);
				this->~MonitorBackupStartedKeyChangesActorState();
				static_cast<MonitorBackupStartedKeyChangesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		else
		{
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerEmptyStartKey", self->myId).log();
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->onBackupChanges(uidVersions);
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->exitEarly = shouldExit;
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!present || !watch)
															#line 3383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (!static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MonitorBackupStartedKeyChangesActorState(); static_cast<MonitorBackupStartedKeyChangesActor*>(this)->destroy(); return 0; }
															#line 3387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				new (&static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MonitorBackupStartedKeyChangesActorState();
				static_cast<MonitorBackupStartedKeyChangesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		watchFuture = tr.watch(backupStartedKey);
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 2;
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >*>(static_cast<MonitorBackupStartedKeyChangesActor*>(this)));
															#line 3405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Optional<Value> && value,int loopDepth) 
	{
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		std::vector<std::pair<UID, Version>> uidVersions;
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		bool shouldExit = self->endVersion.present();
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (value.present())
															#line 3418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			uidVersions = decodeBackupStartedValue(value.get());
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent e("BackupWorkerGotStartKey", self->myId);
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			int i = 1;
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( auto [uid, version] : uidVersions ) {
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				e.detail(format("BackupID%d", i), uid).detail(format("Version%d", i), version);
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				i++;
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (shouldExit && version < self->endVersion.get())
															#line 3434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				{
															#line 578 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					shouldExit = false;
															#line 3438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				}
			}
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->exitEarly = shouldExit;
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->onBackupChanges(uidVersions);
															#line 583 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (present || !watch)
															#line 3447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (!static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MonitorBackupStartedKeyChangesActorState(); static_cast<MonitorBackupStartedKeyChangesActor*>(this)->destroy(); return 0; }
															#line 3451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				new (&static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV< bool >::value()) bool(true);
				this->~MonitorBackupStartedKeyChangesActorState();
				static_cast<MonitorBackupStartedKeyChangesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		else
		{
															#line 586 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerEmptyStartKey", self->myId).log();
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->onBackupChanges(uidVersions);
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->exitEarly = shouldExit;
															#line 590 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!present || !watch)
															#line 3468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (!static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MonitorBackupStartedKeyChangesActorState(); static_cast<MonitorBackupStartedKeyChangesActor*>(this)->destroy(); return 0; }
															#line 3472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				new (&static_cast<MonitorBackupStartedKeyChangesActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MonitorBackupStartedKeyChangesActorState();
				static_cast<MonitorBackupStartedKeyChangesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		watchFuture = tr.watch(backupStartedKey);
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 2;
															#line 596 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >*>(static_cast<MonitorBackupStartedKeyChangesActor*>(this)));
															#line 3490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 3;
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >*>(static_cast<MonitorBackupStartedKeyChangesActor*>(this)));
															#line 3581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watchFuture;
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 3;
															#line 597 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >*>(static_cast<MonitorBackupStartedKeyChangesActor*>(this)));
															#line 3597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont10(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont10(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupStartedKeyChangesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupStartedKeyChangesActor*>(this)->ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	bool present;
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	bool watch;
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> watchFuture;
															#line 3861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via monitorBackupStartedKeyChanges()
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorBackupStartedKeyChangesActor final : public Actor<bool>, public ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >, public ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >, public ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >, public ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >, public FastAllocated<MonitorBackupStartedKeyChangesActor>, public MonitorBackupStartedKeyChangesActorState<MonitorBackupStartedKeyChangesActor> {
															#line 3866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<MonitorBackupStartedKeyChangesActor>::operator new;
	using FastAllocated<MonitorBackupStartedKeyChangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14397463827194025728UL, 9054945097555132160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >;
friend struct ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >;
friend struct ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >;
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorBackupStartedKeyChangesActor(BackupData* const& self,bool const& present,bool const& watch) 
															#line 3886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<bool>(),
		   MonitorBackupStartedKeyChangesActorState<MonitorBackupStartedKeyChangesActor>(self, present, watch),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13517279204875337472UL, 5292722468620612864UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupStartedKeyChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorBackupStartedKeyChanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorBackupStartedKeyChanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorBackupStartedKeyChangesActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorBackupStartedKeyChangesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorBackupStartedKeyChangesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorBackupStartedKeyChangesActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<bool> monitorBackupStartedKeyChanges( BackupData* const& self, bool const& present, bool const& watch ) {
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<bool>(new MonitorBackupStartedKeyChangesActor(self, present, watch));
															#line 3922 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 605 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

// Set "latestBackupWorkerSavedVersion" key for backups
															#line 3928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via setBackupKeys()
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class SetBackupKeysActor>
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class SetBackupKeysActorState {
															#line 3935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	SetBackupKeysActorState(BackupData* const& self,std::map<UID, Version> const& savedLogVersions) 
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   savedLogVersions(savedLogVersions),
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tr(new ReadYourWritesTransaction(self->cx))
															#line 3946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("setBackupKeys", reinterpret_cast<unsigned long>(this));

	}
	~SetBackupKeysActorState() 
	{
		fdb_probe_actor_destroy("setBackupKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 3961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetBackupKeysActorState();
		static_cast<SetBackupKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 612 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 614 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			prevVersions = std::vector<Future<Optional<Version>>>();
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			versionConfigs = std::vector<BackupConfig>();
															#line 618 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			allWorkersReady = std::vector<Future<Optional<bool>>>();
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( const auto& [uid, version] : savedLogVersions ) {
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				versionConfigs.emplace_back(uid);
															#line 621 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				prevVersions.push_back(versionConfigs.back().latestBackupWorkerSavedVersion().get(tr));
															#line 622 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				allWorkersReady.push_back(versionConfigs.back().allWorkerStarted().get(tr));
															#line 4010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(prevVersions) && waitForAll(allWorkersReady);
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<SetBackupKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetBackupKeysActor*>(this)->actor_wait_state = 1;
															#line 625 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetBackupKeysActor, 0, Void >*>(static_cast<SetBackupKeysActor*>(this)));
															#line 4021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<SetBackupKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4045 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SetBackupKeysActor*>(this)->actor_wait_state = 3;
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SetBackupKeysActor, 2, Void >*>(static_cast<SetBackupKeysActor*>(this)));
															#line 4050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for(int i = 0;i < prevVersions.size();i++) {
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!allWorkersReady[i].get().present() || !allWorkersReady[i].get().get())
															#line 4067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
				continue;
			}
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			const Version current = savedLogVersions[versionConfigs[i].getUid()];
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (prevVersions[i].get().present())
															#line 4075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				const Version prev = prevVersions[i].get().get();
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (prev > current)
															#line 4081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				{
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					TraceEvent(SevWarn, "BackupWorkerVersionInverse", self->myId) .detail("Prev", prev) .detail("Current", current);
															#line 4085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				}
			}
															#line 640 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (self->backupEpoch == self->oldestBackupEpoch && (!prevVersions[i].get().present() || prevVersions[i].get().get() < current))
															#line 4090 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerSetVersion", self->myId) .detail("BackupID", versionConfigs[i].getUid()) .detail("Version", current);
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				versionConfigs[i].latestBackupWorkerSavedVersion().set(tr, current);
															#line 4096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
		}
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SetBackupKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4103 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetBackupKeysActor*>(this)->actor_wait_state = 2;
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetBackupKeysActor, 1, Void >*>(static_cast<SetBackupKeysActor*>(this)));
															#line 4108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for(int i = 0;i < prevVersions.size();i++) {
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!allWorkersReady[i].get().present() || !allWorkersReady[i].get().get())
															#line 4119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
				continue;
			}
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			const Version current = savedLogVersions[versionConfigs[i].getUid()];
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (prevVersions[i].get().present())
															#line 4127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				const Version prev = prevVersions[i].get().get();
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (prev > current)
															#line 4133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				{
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					TraceEvent(SevWarn, "BackupWorkerVersionInverse", self->myId) .detail("Prev", prev) .detail("Current", current);
															#line 4137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				}
			}
															#line 640 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (self->backupEpoch == self->oldestBackupEpoch && (!prevVersions[i].get().present() || prevVersions[i].get().get() < current))
															#line 4142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerSetVersion", self->myId) .detail("BackupID", versionConfigs[i].getUid()) .detail("Version", current);
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				versionConfigs[i].latestBackupWorkerSavedVersion().set(tr, current);
															#line 4148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
		}
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SetBackupKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetBackupKeysActor*>(this)->actor_wait_state = 2;
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetBackupKeysActor, 1, Void >*>(static_cast<SetBackupKeysActor*>(this)));
															#line 4160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetBackupKeysActor*>(this)->actor_wait_state > 0) static_cast<SetBackupKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetBackupKeysActor*>(this)->ActorCallback< SetBackupKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetBackupKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetBackupKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetBackupKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<SetBackupKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetBackupKeysActorState(); static_cast<SetBackupKeysActor*>(this)->destroy(); return 0; }
															#line 4244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<SetBackupKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetBackupKeysActorState();
		static_cast<SetBackupKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<SetBackupKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetBackupKeysActorState(); static_cast<SetBackupKeysActor*>(this)->destroy(); return 0; }
															#line 4256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<SetBackupKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetBackupKeysActorState();
		static_cast<SetBackupKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetBackupKeysActor*>(this)->actor_wait_state > 0) static_cast<SetBackupKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetBackupKeysActor*>(this)->ActorCallback< SetBackupKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetBackupKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetBackupKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetBackupKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SetBackupKeysActor*>(this)->actor_wait_state > 0) static_cast<SetBackupKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetBackupKeysActor*>(this)->ActorCallback< SetBackupKeysActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetBackupKeysActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SetBackupKeysActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SetBackupKeysActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::map<UID, Version> savedLogVersions;
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<Future<Optional<Version>>> prevVersions;
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<BackupConfig> versionConfigs;
															#line 618 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<Future<Optional<bool>>> allWorkersReady;
															#line 4438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via setBackupKeys()
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class SetBackupKeysActor final : public Actor<Void>, public ActorCallback< SetBackupKeysActor, 0, Void >, public ActorCallback< SetBackupKeysActor, 1, Void >, public ActorCallback< SetBackupKeysActor, 2, Void >, public FastAllocated<SetBackupKeysActor>, public SetBackupKeysActorState<SetBackupKeysActor> {
															#line 4443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<SetBackupKeysActor>::operator new;
	using FastAllocated<SetBackupKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8234559041787091456UL, 9112122830429938688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetBackupKeysActor, 0, Void >;
friend struct ActorCallback< SetBackupKeysActor, 1, Void >;
friend struct ActorCallback< SetBackupKeysActor, 2, Void >;
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	SetBackupKeysActor(BackupData* const& self,std::map<UID, Version> const& savedLogVersions) 
															#line 4462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   SetBackupKeysActorState<SetBackupKeysActor>(self, savedLogVersions),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setBackupKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4250490297819043584UL, 2806497358835527424UL);
		ActorExecutionContextHelper __helper(static_cast<SetBackupKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setBackupKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setBackupKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetBackupKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetBackupKeysActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SetBackupKeysActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> setBackupKeys( BackupData* const& self, std::map<UID, Version> const& savedLogVersions ) {
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new SetBackupKeysActor(self, savedLogVersions));
															#line 4497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 655 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

// Note only worker with Tag (-2,0) runs this actor so that the latest saved
// version key is set by one process, which is stored in each BackupConfig in
// the system space. The client can know if a backup is restorable by checking
// log saved version > snapshot version.
															#line 4506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorBackupProgress()
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class MonitorBackupProgressActor>
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorBackupProgressActorState {
															#line 4513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorBackupProgressActorState(BackupData* const& self) 
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 661 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   interval()
															#line 4522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorBackupProgress", reinterpret_cast<unsigned long>(this));

	}
	~MonitorBackupProgressActorState() 
	{
		fdb_probe_actor_destroy("monitorBackupProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 4537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorBackupProgressActorState();
		static_cast<MonitorBackupProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		interval = delay(SERVER_KNOBS->WORKER_LOGGING_INTERVAL / 2.0);
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		;
															#line 4569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		progress = Reference<BackupProgress>(new BackupProgress(self->myId, {}));
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = getBackupProgress(self->cx, self->myId, progress, false);
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 2;
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupProgressActor, 1, Void >*>(static_cast<MonitorBackupProgressActor*>(this)));
															#line 4587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!(self->backups.empty() || !self->logSystem.get()))
															#line 4603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->changedTrigger.onTrigger() || self->logSystem.onChange();
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 1;
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupProgressActor, 0, Void >*>(static_cast<MonitorBackupProgressActor*>(this)));
															#line 4616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupProgressActor*>(this)->ActorCallback< MonitorBackupProgressActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorBackupProgressActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tagVersions = progress->getEpochStatus(self->recruitedEpoch);
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		savedLogVersions = std::map<UID, Version>();
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (tagVersions.size() != self->totalTags)
															#line 4729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 676 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = interval;
															#line 676 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 3;
															#line 676 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupProgressActor, 2, Void >*>(static_cast<MonitorBackupProgressActor*>(this)));
															#line 4740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tagVersions = progress->getEpochStatus(self->recruitedEpoch);
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		savedLogVersions = std::map<UID, Version>();
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (tagVersions.size() != self->totalTags)
															#line 4758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 676 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = interval;
															#line 676 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 3;
															#line 676 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupProgressActor, 2, Void >*>(static_cast<MonitorBackupProgressActor*>(this)));
															#line 4769 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupProgressActor*>(this)->ActorCallback< MonitorBackupProgressActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorBackupProgressActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for( auto& [uid, info] : self->backups ) {
															#line 682 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (self->recruitedEpoch == self->oldestBackupEpoch)
															#line 4860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 684 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				Version v = std::numeric_limits<Version>::max();
															#line 685 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				for( const auto& [tag, version] : tagVersions ) {
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					v = std::min(v, version);
															#line 4868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				}
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				savedLogVersions.emplace(uid, v);
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerSavedBackupVersion", self->myId).detail("BackupID", uid).detail("Version", v);
															#line 4874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
		}
															#line 692 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		Future<Void> setKeys = savedLogVersions.empty() ? Void() : setBackupKeys(self, savedLogVersions);
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = interval && setKeys;
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 4;
															#line 694 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupProgressActor, 3, Void >*>(static_cast<MonitorBackupProgressActor*>(this)));
															#line 4888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupProgressActor*>(this)->ActorCallback< MonitorBackupProgressActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorBackupProgressActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupProgressActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupProgressActor*>(this)->ActorCallback< MonitorBackupProgressActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorBackupProgressActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorBackupProgressActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 661 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> interval;
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<BackupProgress> progress;
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::map<Tag, Version> tagVersions;
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::map<UID, Version> savedLogVersions;
															#line 5077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via monitorBackupProgress()
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorBackupProgressActor final : public Actor<Void>, public ActorCallback< MonitorBackupProgressActor, 0, Void >, public ActorCallback< MonitorBackupProgressActor, 1, Void >, public ActorCallback< MonitorBackupProgressActor, 2, Void >, public ActorCallback< MonitorBackupProgressActor, 3, Void >, public FastAllocated<MonitorBackupProgressActor>, public MonitorBackupProgressActorState<MonitorBackupProgressActor> {
															#line 5082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<MonitorBackupProgressActor>::operator new;
	using FastAllocated<MonitorBackupProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12689067943948184064UL, 15056227084491495168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorBackupProgressActor, 0, Void >;
friend struct ActorCallback< MonitorBackupProgressActor, 1, Void >;
friend struct ActorCallback< MonitorBackupProgressActor, 2, Void >;
friend struct ActorCallback< MonitorBackupProgressActor, 3, Void >;
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorBackupProgressActor(BackupData* const& self) 
															#line 5102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorBackupProgressActorState<MonitorBackupProgressActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorBackupProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11657820533249259776UL, 1975522792332850688UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorBackupProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorBackupProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorBackupProgressActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorBackupProgressActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorBackupProgressActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorBackupProgressActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> monitorBackupProgress( BackupData* const& self ) {
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new MonitorBackupProgressActor(self));
															#line 5138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 697 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

															#line 5143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via saveProgress()
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class SaveProgressActor>
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class SaveProgressActorState {
															#line 5150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	SaveProgressActorState(BackupData* const& self,Version const& backupVersion) 
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   backupVersion(backupVersion),
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tr(self->cx),
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   key(backupProgressKeyFor(self->myId))
															#line 5163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("saveProgress", reinterpret_cast<unsigned long>(this));

	}
	~SaveProgressActorState() 
	{
		fdb_probe_actor_destroy("saveProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 5178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SaveProgressActorState();
		static_cast<SaveProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 706 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 710 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			WorkerBackupStatus status(self->backupEpoch, backupVersion, self->tag, self->totalTags);
															#line 711 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.set(key, backupProgressValue(status));
															#line 712 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.addReadConflictRange(singleKeyRange(key));
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<SaveProgressActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SaveProgressActor*>(this)->actor_wait_state = 1;
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SaveProgressActor, 0, Void >*>(static_cast<SaveProgressActor*>(this)));
															#line 5228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<SaveProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SaveProgressActor*>(this)->actor_wait_state = 2;
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SaveProgressActor, 1, Void >*>(static_cast<SaveProgressActor*>(this)));
															#line 5257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 714 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<SaveProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SaveProgressActorState(); static_cast<SaveProgressActor*>(this)->destroy(); return 0; }
															#line 5272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<SaveProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SaveProgressActorState();
		static_cast<SaveProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 714 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<SaveProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SaveProgressActorState(); static_cast<SaveProgressActor*>(this)->destroy(); return 0; }
															#line 5284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<SaveProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SaveProgressActorState();
		static_cast<SaveProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SaveProgressActor*>(this)->actor_wait_state > 0) static_cast<SaveProgressActor*>(this)->actor_wait_state = 0;
		static_cast<SaveProgressActor*>(this)->ActorCallback< SaveProgressActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SaveProgressActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("saveProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SaveProgressActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("saveProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SaveProgressActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("saveProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SaveProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SaveProgressActor*>(this)->actor_wait_state > 0) static_cast<SaveProgressActor*>(this)->actor_wait_state = 0;
		static_cast<SaveProgressActor*>(this)->ActorCallback< SaveProgressActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SaveProgressActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("saveProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SaveProgressActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("saveProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SaveProgressActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("saveProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SaveProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveProgress", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Version backupVersion;
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Transaction tr;
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Key key;
															#line 5462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via saveProgress()
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class SaveProgressActor final : public Actor<Void>, public ActorCallback< SaveProgressActor, 0, Void >, public ActorCallback< SaveProgressActor, 1, Void >, public FastAllocated<SaveProgressActor>, public SaveProgressActorState<SaveProgressActor> {
															#line 5467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<SaveProgressActor>::operator new;
	using FastAllocated<SaveProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9211151291073343488UL, 2116964730742297088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SaveProgressActor, 0, Void >;
friend struct ActorCallback< SaveProgressActor, 1, Void >;
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	SaveProgressActor(BackupData* const& self,Version const& backupVersion) 
															#line 5485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   SaveProgressActorState<SaveProgressActor>(self, backupVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("saveProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11181064400611269888UL, 12244176878936082688UL);
		ActorExecutionContextHelper __helper(static_cast<SaveProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("saveProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("saveProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SaveProgressActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SaveProgressActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> saveProgress( BackupData* const& self, Version const& backupVersion ) {
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new SaveProgressActor(self, backupVersion));
															#line 5519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 720 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

// Write a mutation to a log file. Note the mutation can be different from
// message.message for clear mutations.
															#line 5526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via addMutation()
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class AddMutationActor>
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class AddMutationActorState {
															#line 5533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	AddMutationActorState(Reference<IBackupFile> const& logFile,VersionedMessage const& message,StringRef const& mutation,int64_t* const& blockEnd,int const& blockSize) 
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : logFile(logFile),
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   message(message),
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   mutation(mutation),
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   blockEnd(blockEnd),
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   blockSize(blockSize),
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   bytes(sizeof(Version) + sizeof(uint32_t) + sizeof(int) + mutation.size())
															#line 5550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("addMutation", reinterpret_cast<unsigned long>(this));

	}
	~AddMutationActorState() 
	{
		fdb_probe_actor_destroy("addMutation", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			BinaryWriter wr(Unversioned());
															#line 736 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			wr << bigEndian64(message.version.version) << bigEndian32(message.version.sub) << bigEndian32(mutation.size());
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			header = wr.toValue();
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (logFile->size() + bytes > *blockEnd)
															#line 5571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				const int bytesLeft = *blockEnd - logFile->size();
															#line 743 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (bytesLeft > 0)
															#line 5577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				{
															#line 744 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					paddingFFs = fileBackup::makePadding(bytesLeft);
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					StrictFuture<Void> __when_expr_0 = logFile->append(paddingFFs.begin(), bytesLeft);
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					if (static_cast<AddMutationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5585 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<AddMutationActor*>(this)->actor_wait_state = 1;
															#line 745 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AddMutationActor, 0, Void >*>(static_cast<AddMutationActor*>(this)));
															#line 5590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AddMutationActorState();
		static_cast<AddMutationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = logFile->append((void*)header.begin(), header.size());
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<AddMutationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<AddMutationActor*>(this)->actor_wait_state = 3;
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AddMutationActor, 2, Void >*>(static_cast<AddMutationActor*>(this)));
															#line 5630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 748 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		*blockEnd += blockSize;
															#line 750 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = logFile->append((uint8_t*)&PARTITIONED_MLOG_VERSION, sizeof(PARTITIONED_MLOG_VERSION));
															#line 750 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<AddMutationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AddMutationActor*>(this)->actor_wait_state = 2;
															#line 750 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AddMutationActor, 1, Void >*>(static_cast<AddMutationActor*>(this)));
															#line 5648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AddMutationActor*>(this)->actor_wait_state > 0) static_cast<AddMutationActor*>(this)->actor_wait_state = 0;
		static_cast<AddMutationActor*>(this)->ActorCallback< AddMutationActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AddMutationActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AddMutationActor*>(this)->actor_wait_state > 0) static_cast<AddMutationActor*>(this)->actor_wait_state = 0;
		static_cast<AddMutationActor*>(this)->ActorCallback< AddMutationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AddMutationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = logFile->append(mutation.begin(), mutation.size());
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<AddMutationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<AddMutationActor*>(this)->actor_wait_state = 4;
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AddMutationActor, 3, Void >*>(static_cast<AddMutationActor*>(this)));
															#line 5838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = logFile->append(mutation.begin(), mutation.size());
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<AddMutationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<AddMutationActor*>(this)->actor_wait_state = 4;
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< AddMutationActor, 3, Void >*>(static_cast<AddMutationActor*>(this)));
															#line 5854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AddMutationActor*>(this)->actor_wait_state > 0) static_cast<AddMutationActor*>(this)->actor_wait_state = 0;
		static_cast<AddMutationActor*>(this)->ActorCallback< AddMutationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AddMutationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 755 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<AddMutationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AddMutationActorState(); static_cast<AddMutationActor*>(this)->destroy(); return 0; }
															#line 5938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<AddMutationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AddMutationActorState();
		static_cast<AddMutationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 755 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<AddMutationActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AddMutationActorState(); static_cast<AddMutationActor*>(this)->destroy(); return 0; }
															#line 5950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<AddMutationActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AddMutationActorState();
		static_cast<AddMutationActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<AddMutationActor*>(this)->actor_wait_state > 0) static_cast<AddMutationActor*>(this)->actor_wait_state = 0;
		static_cast<AddMutationActor*>(this)->ActorCallback< AddMutationActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< AddMutationActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< AddMutationActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<IBackupFile> logFile;
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	VersionedMessage message;
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	StringRef mutation;
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int64_t* blockEnd;
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int blockSize;
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int bytes;
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Standalone<StringRef> header;
															#line 744 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Value paddingFFs;
															#line 6049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via addMutation()
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class AddMutationActor final : public Actor<Void>, public ActorCallback< AddMutationActor, 0, Void >, public ActorCallback< AddMutationActor, 1, Void >, public ActorCallback< AddMutationActor, 2, Void >, public ActorCallback< AddMutationActor, 3, Void >, public FastAllocated<AddMutationActor>, public AddMutationActorState<AddMutationActor> {
															#line 6054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<AddMutationActor>::operator new;
	using FastAllocated<AddMutationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16912732312810813952UL, 15149469004352551424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AddMutationActor, 0, Void >;
friend struct ActorCallback< AddMutationActor, 1, Void >;
friend struct ActorCallback< AddMutationActor, 2, Void >;
friend struct ActorCallback< AddMutationActor, 3, Void >;
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	AddMutationActor(Reference<IBackupFile> const& logFile,VersionedMessage const& message,StringRef const& mutation,int64_t* const& blockEnd,int const& blockSize) 
															#line 6074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   AddMutationActorState<AddMutationActor>(logFile, message, mutation, blockEnd, blockSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("addMutation", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1351666754517471232UL, 8923191686972481024UL);
		ActorExecutionContextHelper __helper(static_cast<AddMutationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("addMutation");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("addMutation", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AddMutationActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AddMutationActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AddMutationActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< AddMutationActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> addMutation( Reference<IBackupFile> const& logFile, VersionedMessage const& message, StringRef const& mutation, int64_t* const& blockEnd, int const& blockSize ) {
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new AddMutationActor(logFile, message, mutation, blockEnd, blockSize));
															#line 6110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 757 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

															#line 6115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via updateLogBytesWritten()
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class UpdateLogBytesWrittenActor>
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class UpdateLogBytesWrittenActorState {
															#line 6122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	UpdateLogBytesWrittenActorState(BackupData* const& self,std::vector<UID> const& backupUids,std::vector<Reference<IBackupFile>> const& logFiles) 
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   backupUids(backupUids),
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   logFiles(logFiles),
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tr(new ReadYourWritesTransaction(self->cx))
															#line 6135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("updateLogBytesWritten", reinterpret_cast<unsigned long>(this));

	}
	~UpdateLogBytesWrittenActorState() 
	{
		fdb_probe_actor_destroy("updateLogBytesWritten", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(backupUids.size() == logFiles.size());
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 6152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateLogBytesWrittenActorState();
		static_cast<UpdateLogBytesWrittenActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 766 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 768 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 770 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for(int i = 0;i < backupUids.size();i++) {
															#line 771 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				BackupConfig config(backupUids[i]);
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				config.logBytesWritten().atomicOp(tr, logFiles[i]->size(), MutationRef::AddValue);
															#line 6193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
															#line 774 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 774 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state = 1;
															#line 774 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateLogBytesWrittenActor, 0, Void >*>(static_cast<UpdateLogBytesWrittenActor*>(this)));
															#line 6204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state = 2;
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateLogBytesWrittenActor, 1, Void >*>(static_cast<UpdateLogBytesWrittenActor*>(this)));
															#line 6233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<UpdateLogBytesWrittenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLogBytesWrittenActorState(); static_cast<UpdateLogBytesWrittenActor*>(this)->destroy(); return 0; }
															#line 6248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<UpdateLogBytesWrittenActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLogBytesWrittenActorState();
		static_cast<UpdateLogBytesWrittenActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<UpdateLogBytesWrittenActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLogBytesWrittenActorState(); static_cast<UpdateLogBytesWrittenActor*>(this)->destroy(); return 0; }
															#line 6260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<UpdateLogBytesWrittenActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLogBytesWrittenActorState();
		static_cast<UpdateLogBytesWrittenActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state > 0) static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLogBytesWrittenActor*>(this)->ActorCallback< UpdateLogBytesWrittenActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLogBytesWrittenActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogBytesWrittenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateLogBytesWrittenActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogBytesWrittenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateLogBytesWrittenActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogBytesWrittenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state > 0) static_cast<UpdateLogBytesWrittenActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLogBytesWrittenActor*>(this)->ActorCallback< UpdateLogBytesWrittenActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLogBytesWrittenActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogBytesWrittenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateLogBytesWrittenActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogBytesWrittenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateLogBytesWrittenActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogBytesWrittenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<UID> backupUids;
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<Reference<IBackupFile>> logFiles;
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 6438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via updateLogBytesWritten()
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class UpdateLogBytesWrittenActor final : public Actor<Void>, public ActorCallback< UpdateLogBytesWrittenActor, 0, Void >, public ActorCallback< UpdateLogBytesWrittenActor, 1, Void >, public FastAllocated<UpdateLogBytesWrittenActor>, public UpdateLogBytesWrittenActorState<UpdateLogBytesWrittenActor> {
															#line 6443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<UpdateLogBytesWrittenActor>::operator new;
	using FastAllocated<UpdateLogBytesWrittenActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1324563313077977088UL, 4110063544677558272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateLogBytesWrittenActor, 0, Void >;
friend struct ActorCallback< UpdateLogBytesWrittenActor, 1, Void >;
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	UpdateLogBytesWrittenActor(BackupData* const& self,std::vector<UID> const& backupUids,std::vector<Reference<IBackupFile>> const& logFiles) 
															#line 6461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateLogBytesWrittenActorState<UpdateLogBytesWrittenActor>(self, backupUids, logFiles),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2501124557465260800UL, 1735817436001543168UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLogBytesWrittenActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateLogBytesWritten");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateLogBytesWritten", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateLogBytesWrittenActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateLogBytesWrittenActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Void> updateLogBytesWritten( BackupData* const& self, std::vector<UID> const& backupUids, std::vector<Reference<IBackupFile>> const& logFiles ) {
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new UpdateLogBytesWrittenActor(self, backupUids, logFiles));
															#line 6495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 781 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

// Saves messages in the range of [0, numMsg) to a file and then remove these
// messages. The file content format is a sequence of (Version, sub#, msgSize, message).
// Note only ready backups are saved.
															#line 6503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via saveMutationsToFile()
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class SaveMutationsToFileActor>
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class SaveMutationsToFileActorState {
															#line 6510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	SaveMutationsToFileActorState(BackupData* const& self,Version const& popVersion,int const& numMsg,std::unordered_set<BlobCipherDetails> const& cipherDetails) 
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   popVersion(popVersion),
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   numMsg(numMsg),
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   cipherDetails(cipherDetails),
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   blockSize(SERVER_KNOBS->BACKUP_FILE_BLOCK_BYTES),
															#line 790 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   logFileFutures(),
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   logFiles(),
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   blockEnds(),
															#line 793 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   activeUids(),
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   beginVersions(),
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   keyRangeMap(),
															#line 796 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   mutations(),
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   cipherKeys(),
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   idx()
															#line 6543 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("saveMutationsToFile", reinterpret_cast<unsigned long>(this));

	}
	~SaveMutationsToFileActorState() 
	{
		fdb_probe_actor_destroy("saveMutationsToFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 801 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 6558 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SaveMutationsToFileActorState();
		static_cast<SaveMutationsToFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 805 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for(auto it = self->backups.begin();it != self->backups.end();) {
															#line 806 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (it->second.stopped || !it->second.container.get().present())
															#line 6583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 807 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerNoContainer", self->myId).detail("BackupId", it->first);
															#line 808 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				it = self->backups.erase(it);
															#line 6589 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				continue;
			}
															#line 811 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			const int index = logFileFutures.size();
															#line 812 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			activeUids.push_back(it->first);
															#line 813 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->insertRanges(keyRangeMap, it->second.ranges.get(), index);
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (it->second.lastSavedVersion == invalidVersion)
															#line 6600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 816 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (it->second.startVersion > self->startVersion && !self->messages.empty())
															#line 6604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				{
															#line 818 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					it->second.lastSavedVersion = self->messages[0].getVersion();
															#line 6608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				}
				else
				{
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					it->second.lastSavedVersion = std::max({ self->popVersion, self->savedVersion, self->startVersion });
															#line 6614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				}
															#line 822 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				TraceEvent("BackupWorkerTrueUp", self->myId).detail("LastSavedVersion", it->second.lastSavedVersion);
															#line 6618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
															#line 826 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			beginVersions.push_back(it->second.lastSavedVersion);
															#line 828 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			logFileFutures.push_back(it->second.container.get().get()->writeTaggedLogFile( it->second.lastSavedVersion, popVersion + 1, blockSize, self->tag.id, self->totalTags));
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			it++;
															#line 6626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 833 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		keyRangeMap.coalesce(allKeys);
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(logFileFutures);
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 2;
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SaveMutationsToFileActor, 1, Void >*>(static_cast<SaveMutationsToFileActor*>(this)));
															#line 6639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 801 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!(!self->isAllInfoReady()))
															#line 6655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 802 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->waitAllInfoReady();
															#line 802 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6663 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 1;
															#line 802 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SaveMutationsToFileActor, 0, Void >*>(static_cast<SaveMutationsToFileActor*>(this)));
															#line 6668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state > 0) static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 0;
		static_cast<SaveMutationsToFileActor*>(this)->ActorCallback< SaveMutationsToFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SaveMutationsToFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		std::transform(logFileFutures.begin(), logFileFutures.end(), std::back_inserter(logFiles), [](const Future<Reference<IBackupFile>>& f) { return f.get(); });
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		ASSERT(activeUids.size() == logFiles.size() && beginVersions.size() == logFiles.size());
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for(int i = 0;i < logFiles.size();i++) {
															#line 843 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("OpenMutationFile", self->myId) .detail("BackupID", activeUids[i]) .detail("TagId", self->tag.id) .detail("File", logFiles[i]->getFileName());
															#line 6783 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		blockEnds = std::vector<int64_t>(logFiles.size(), 0);
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		idx = 0;
															#line 6789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		std::transform(logFileFutures.begin(), logFileFutures.end(), std::back_inserter(logFiles), [](const Future<Reference<IBackupFile>>& f) { return f.get(); });
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		ASSERT(activeUids.size() == logFiles.size() && beginVersions.size() == logFiles.size());
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for(int i = 0;i < logFiles.size();i++) {
															#line 843 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("OpenMutationFile", self->myId) .detail("BackupID", activeUids[i]) .detail("TagId", self->tag.id) .detail("File", logFiles[i]->getFileName());
															#line 6804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 849 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		blockEnds = std::vector<int64_t>(logFiles.size(), 0);
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		idx = 0;
															#line 6810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state > 0) static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 0;
		static_cast<SaveMutationsToFileActor*>(this)->ActorCallback< SaveMutationsToFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SaveMutationsToFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 892 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		std::vector<Future<Void>> finished;
															#line 893 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		std::transform(logFiles.begin(), logFiles.end(), std::back_inserter(finished), [](const Reference<IBackupFile>& f) { return f->finish(); });
															#line 897 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(finished);
															#line 897 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 4;
															#line 897 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SaveMutationsToFileActor, 3, Void >*>(static_cast<SaveMutationsToFileActor*>(this)));
															#line 6905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!(idx < numMsg))
															#line 6921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 851 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		auto& message = self->messages[idx];
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		MutationRef m;
															#line 853 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!message.isCandidateBackupMessage(&m, cipherKeys))
															#line 6931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
			return a_body1cont2continue1(loopDepth); // continue
		}
															#line 856 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		DEBUG_MUTATION("addMutation", message.version.version, m, self->myId) .detail("KCV", self->minKnownCommittedVersion) .detail("SavedVersion", self->savedVersion);
															#line 860 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		std::vector<Future<Void>> adds;
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (m.type != MutationRef::Type::ClearRange)
															#line 6941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 862 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( int index : keyRangeMap[m.param1] ) {
															#line 863 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (message.getVersion() >= beginVersions[index])
															#line 6947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				{
															#line 864 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					adds.push_back( addMutation(logFiles[index], message, message.message, &blockEnds[index], blockSize));
															#line 6951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				}
			}
		}
		else
		{
															#line 869 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			KeyRangeRef mutationRange(m.param1, m.param2);
															#line 870 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			KeyRangeRef intersectionRange;
															#line 873 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			for( auto range : keyRangeMap.intersectingRanges(mutationRange) ) {
															#line 874 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				const auto& subrange = range.range();
															#line 875 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				intersectionRange = mutationRange & subrange;
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				MutationRef subm(MutationRef::Type::ClearRange, intersectionRange.begin, intersectionRange.end);
															#line 877 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				BinaryWriter wr(AssumeVersion(g_network->protocolVersion()));
															#line 878 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				wr << subm;
															#line 879 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				mutations.push_back(wr.toValue());
															#line 880 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				for( int index : range.value() ) {
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					if (message.getVersion() >= beginVersions[index])
															#line 6979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
					{
															#line 882 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
						adds.push_back( addMutation(logFiles[index], message, mutations.back(), &blockEnds[index], blockSize));
															#line 6983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
					}
				}
			}
		}
															#line 888 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(adds);
															#line 888 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 3;
															#line 888 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SaveMutationsToFileActor, 2, Void >*>(static_cast<SaveMutationsToFileActor*>(this)));
															#line 6997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2continue1(int loopDepth) 
	{
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		idx++;
															#line 7019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 889 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		mutations.clear();
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		idx++;
															#line 7030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 889 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		mutations.clear();
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		idx++;
															#line 7041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state > 0) static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 0;
		static_cast<SaveMutationsToFileActor*>(this)->ActorCallback< SaveMutationsToFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SaveMutationsToFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 899 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for( const auto& file : logFiles ) {
															#line 900 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("CloseMutationFile", self->myId) .detail("FileSize", file->size()) .detail("TagId", self->tag.id) .detail("File", file->getFileName());
															#line 7127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 905 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for( const UID& uid : activeUids ) {
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->backups[uid].lastSavedVersion = popVersion + 1;
															#line 7133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = updateLogBytesWritten(self, activeUids, logFiles);
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10when1(__when_expr_4.get(), loopDepth); };
		static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 5;
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SaveMutationsToFileActor, 4, Void >*>(static_cast<SaveMutationsToFileActor*>(this)));
															#line 7144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 899 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for( const auto& file : logFiles ) {
															#line 900 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("CloseMutationFile", self->myId) .detail("FileSize", file->size()) .detail("TagId", self->tag.id) .detail("File", file->getFileName());
															#line 7155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 905 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for( const UID& uid : activeUids ) {
															#line 906 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->backups[uid].lastSavedVersion = popVersion + 1;
															#line 7161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = updateLogBytesWritten(self, activeUids, logFiles);
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont10when1(__when_expr_4.get(), loopDepth); };
		static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 5;
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SaveMutationsToFileActor, 4, Void >*>(static_cast<SaveMutationsToFileActor*>(this)));
															#line 7172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state > 0) static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 0;
		static_cast<SaveMutationsToFileActor*>(this)->ActorCallback< SaveMutationsToFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SaveMutationsToFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 910 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<SaveMutationsToFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SaveMutationsToFileActorState(); static_cast<SaveMutationsToFileActor*>(this)->destroy(); return 0; }
															#line 7256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<SaveMutationsToFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SaveMutationsToFileActorState();
		static_cast<SaveMutationsToFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 910 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<SaveMutationsToFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SaveMutationsToFileActorState(); static_cast<SaveMutationsToFileActor*>(this)->destroy(); return 0; }
															#line 7268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<SaveMutationsToFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SaveMutationsToFileActorState();
		static_cast<SaveMutationsToFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state > 0) static_cast<SaveMutationsToFileActor*>(this)->actor_wait_state = 0;
		static_cast<SaveMutationsToFileActor*>(this)->ActorCallback< SaveMutationsToFileActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< SaveMutationsToFileActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< SaveMutationsToFileActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Version popVersion;
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int numMsg;
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::unordered_set<BlobCipherDetails> cipherDetails;
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int blockSize;
															#line 790 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<Future<Reference<IBackupFile>>> logFileFutures;
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<Reference<IBackupFile>> logFiles;
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<int64_t> blockEnds;
															#line 793 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<UID> activeUids;
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<Version> beginVersions;
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	KeyRangeMap<std::set<int>> keyRangeMap;
															#line 796 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<Standalone<StringRef>> mutations;
															#line 797 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::unordered_map<BlobCipherDetails, Reference<BlobCipherKey>> cipherKeys;
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int idx;
															#line 7379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via saveMutationsToFile()
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class SaveMutationsToFileActor final : public Actor<Void>, public ActorCallback< SaveMutationsToFileActor, 0, Void >, public ActorCallback< SaveMutationsToFileActor, 1, Void >, public ActorCallback< SaveMutationsToFileActor, 2, Void >, public ActorCallback< SaveMutationsToFileActor, 3, Void >, public ActorCallback< SaveMutationsToFileActor, 4, Void >, public FastAllocated<SaveMutationsToFileActor>, public SaveMutationsToFileActorState<SaveMutationsToFileActor> {
															#line 7384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<SaveMutationsToFileActor>::operator new;
	using FastAllocated<SaveMutationsToFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10399485364573364480UL, 2824930573177713152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SaveMutationsToFileActor, 0, Void >;
friend struct ActorCallback< SaveMutationsToFileActor, 1, Void >;
friend struct ActorCallback< SaveMutationsToFileActor, 2, Void >;
friend struct ActorCallback< SaveMutationsToFileActor, 3, Void >;
friend struct ActorCallback< SaveMutationsToFileActor, 4, Void >;
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	SaveMutationsToFileActor(BackupData* const& self,Version const& popVersion,int const& numMsg,std::unordered_set<BlobCipherDetails> const& cipherDetails) 
															#line 7405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   SaveMutationsToFileActorState<SaveMutationsToFileActor>(self, popVersion, numMsg, cipherDetails),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("saveMutationsToFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18095228256760288256UL, 3679545122714121728UL);
		ActorExecutionContextHelper __helper(static_cast<SaveMutationsToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("saveMutationsToFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("saveMutationsToFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SaveMutationsToFileActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SaveMutationsToFileActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SaveMutationsToFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SaveMutationsToFileActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< SaveMutationsToFileActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> saveMutationsToFile( BackupData* const& self, Version const& popVersion, int const& numMsg, std::unordered_set<BlobCipherDetails> const& cipherDetails ) {
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new SaveMutationsToFileActor(self, popVersion, numMsg, cipherDetails));
															#line 7442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 912 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

// Uploads self->messages to cloud storage and updates savedVersion.
															#line 7448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via uploadData()
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class UploadDataActor>
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class UploadDataActorState {
															#line 7455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	UploadDataActorState(BackupData* const& self) 
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 915 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   popVersion(invalidVersion)
															#line 7464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("uploadData", reinterpret_cast<unsigned long>(this));

	}
	~UploadDataActorState() 
	{
		fdb_probe_actor_destroy("uploadData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 917 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 7479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UploadDataActorState();
		static_cast<UploadDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		uploadDelay = delay(SERVER_KNOBS->BACKUP_UPLOAD_DELAY);
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		numMsg = 0;
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		cipherDetails = std::unordered_set<BlobCipherDetails>();
															#line 923 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		Version lastPopVersion = popVersion;
															#line 925 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		int lastVersionIndex = 0;
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		Version lastVersion = invalidVersion;
															#line 928 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for( auto& message : self->messages ) {
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			const Version version = message.getVersion();
															#line 931 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (version > self->maxPopVersion())
															#line 7525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
				break;
			}
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (version > popVersion)
															#line 7531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				lastVersionIndex = numMsg;
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				lastVersion = popVersion;
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				popVersion = version;
															#line 7539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			message.collectCipherDetailIfEncrypted(cipherDetails);
															#line 940 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			numMsg++;
															#line 7545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 942 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (self->pullFinished())
															#line 7549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			popVersion = self->endVersion.get();
															#line 7553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
		else
		{
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			popVersion = lastVersion;
															#line 947 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			numMsg = lastVersionIndex;
															#line 951 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			ASSERT(numMsg > 0 || self->lock->waiters() == 0);
															#line 7563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (((numMsg > 0 || popVersion > lastPopVersion) && self->pulling) || self->pullFinished())
															#line 7567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 954 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerSave", self->myId) .detail("Version", popVersion) .detail("LastPopVersion", lastPopVersion) .detail("Pulling", self->pulling) .detail("SavedVersion", self->savedVersion) .detail("NumMsg", numMsg) .detail("MsgQ", self->messages.size());
															#line 962 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = saveMutationsToFile(self, popVersion, numMsg, cipherDetails);
															#line 962 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<UploadDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UploadDataActor*>(this)->actor_wait_state = 1;
															#line 962 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UploadDataActor, 0, Void >*>(static_cast<UploadDataActor*>(this)));
															#line 7580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 967 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!self->pulling && self->backupEpoch == self->recruitedEpoch)
															#line 7594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->eraseMessages(self->messages.size());
															#line 7598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 971 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (popVersion > self->savedVersion && popVersion > self->popVersion)
															#line 7602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = saveProgress(self, popVersion);
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<UploadDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UploadDataActor*>(this)->actor_wait_state = 2;
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UploadDataActor, 1, Void >*>(static_cast<UploadDataActor*>(this)));
															#line 7613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 963 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->eraseMessages(numMsg);
															#line 7627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 963 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->eraseMessages(numMsg);
															#line 7636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UploadDataActor*>(this)->actor_wait_state > 0) static_cast<UploadDataActor*>(this)->actor_wait_state = 0;
		static_cast<UploadDataActor*>(this)->ActorCallback< UploadDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UploadDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UploadDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UploadDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
															#line 981 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (self->allMessageSaved())
															#line 7720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 982 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<UploadDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UploadDataActorState(); static_cast<UploadDataActor*>(this)->destroy(); return 0; }
															#line 7724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			new (&static_cast<UploadDataActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~UploadDataActorState();
			static_cast<UploadDataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 985 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!self->pullFinished())
															#line 7732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 986 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = uploadDelay || self->doneTrigger.onTrigger();
															#line 986 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<UploadDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont9when1(__when_expr_2.get(), loopDepth); };
			static_cast<UploadDataActor*>(this)->actor_wait_state = 3;
															#line 986 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UploadDataActor, 2, Void >*>(static_cast<UploadDataActor*>(this)));
															#line 7743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 973 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerSavedProgress", self->myId) .detail("Tag", self->tag.toString()) .detail("Version", popVersion) .detail("MsgQ", self->messages.size());
															#line 977 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->savedVersion = std::max(popVersion, self->savedVersion);
															#line 978 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->pop();
															#line 7761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 973 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerSavedProgress", self->myId) .detail("Tag", self->tag.toString()) .detail("Version", popVersion) .detail("MsgQ", self->messages.size());
															#line 977 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->savedVersion = std::max(popVersion, self->savedVersion);
															#line 978 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->pop();
															#line 7774 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UploadDataActor*>(this)->actor_wait_state > 0) static_cast<UploadDataActor*>(this)->actor_wait_state = 0;
		static_cast<UploadDataActor*>(this)->ActorCallback< UploadDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UploadDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UploadDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UploadDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UploadDataActor*>(this)->actor_wait_state > 0) static_cast<UploadDataActor*>(this)->actor_wait_state = 0;
		static_cast<UploadDataActor*>(this)->ActorCallback< UploadDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UploadDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UploadDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UploadDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 915 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Version popVersion;
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> uploadDelay;
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int numMsg;
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::unordered_set<BlobCipherDetails> cipherDetails;
															#line 7957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via uploadData()
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class UploadDataActor final : public Actor<Void>, public ActorCallback< UploadDataActor, 0, Void >, public ActorCallback< UploadDataActor, 1, Void >, public ActorCallback< UploadDataActor, 2, Void >, public FastAllocated<UploadDataActor>, public UploadDataActorState<UploadDataActor> {
															#line 7962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<UploadDataActor>::operator new;
	using FastAllocated<UploadDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1167060061584166144UL, 12165977227848721152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UploadDataActor, 0, Void >;
friend struct ActorCallback< UploadDataActor, 1, Void >;
friend struct ActorCallback< UploadDataActor, 2, Void >;
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	UploadDataActor(BackupData* const& self) 
															#line 7981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   UploadDataActorState<UploadDataActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("uploadData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15797940681219010048UL, 1723175542107149824UL);
		ActorExecutionContextHelper __helper(static_cast<UploadDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("uploadData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("uploadData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UploadDataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UploadDataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UploadDataActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> uploadData( BackupData* const& self ) {
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new UploadDataActor(self));
															#line 8016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 990 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

															#line 8021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via getNoopVersion()
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class GetNoopVersionActor>
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class GetNoopVersionActorState {
															#line 8028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	GetNoopVersionActorState(BackupData* const& self) 
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 992 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tr(self->cx)
															#line 8037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("getNoopVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetNoopVersionActorState() 
	{
		fdb_probe_actor_destroy("getNoopVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 994 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 8052 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetNoopVersionActorState();
		static_cast<GetNoopVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 996 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 997 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 1000 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(backupWorkerMaxNoopVersionKey);
															#line 1000 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<GetNoopVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetNoopVersionActor*>(this)->actor_wait_state = 1;
															#line 1000 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetNoopVersionActor, 0, Optional<Value> >*>(static_cast<GetNoopVersionActor*>(this)));
															#line 8096 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1007 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1007 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<GetNoopVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetNoopVersionActor*>(this)->actor_wait_state = 2;
															#line 1007 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetNoopVersionActor, 1, Void >*>(static_cast<GetNoopVersionActor*>(this)));
															#line 8125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& noopValue,int loopDepth) 
	{
															#line 1001 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (noopValue.present())
															#line 8140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1002 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<GetNoopVersionActor*>(this)->SAV<Version>::futures) { (void)(BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned())); this->~GetNoopVersionActorState(); static_cast<GetNoopVersionActor*>(this)->destroy(); return 0; }
															#line 8144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			new (&static_cast<GetNoopVersionActor*>(this)->SAV< Version >::value()) Version(BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned()));
			this->~GetNoopVersionActorState();
			static_cast<GetNoopVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1004 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<GetNoopVersionActor*>(this)->SAV<Version>::futures) { (void)(invalidVersion); this->~GetNoopVersionActorState(); static_cast<GetNoopVersionActor*>(this)->destroy(); return 0; }
															#line 8154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			new (&static_cast<GetNoopVersionActor*>(this)->SAV< Version >::value()) Version(invalidVersion);
			this->~GetNoopVersionActorState();
			static_cast<GetNoopVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && noopValue,int loopDepth) 
	{
															#line 1001 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (noopValue.present())
															#line 8167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1002 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<GetNoopVersionActor*>(this)->SAV<Version>::futures) { (void)(BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned())); this->~GetNoopVersionActorState(); static_cast<GetNoopVersionActor*>(this)->destroy(); return 0; }
															#line 8171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			new (&static_cast<GetNoopVersionActor*>(this)->SAV< Version >::value()) Version(BinaryReader::fromStringRef<Version>(noopValue.get(), Unversioned()));
			this->~GetNoopVersionActorState();
			static_cast<GetNoopVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1004 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<GetNoopVersionActor*>(this)->SAV<Version>::futures) { (void)(invalidVersion); this->~GetNoopVersionActorState(); static_cast<GetNoopVersionActor*>(this)->destroy(); return 0; }
															#line 8181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			new (&static_cast<GetNoopVersionActor*>(this)->SAV< Version >::value()) Version(invalidVersion);
			this->~GetNoopVersionActorState();
			static_cast<GetNoopVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& noopValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(noopValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && noopValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(noopValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetNoopVersionActor*>(this)->actor_wait_state > 0) static_cast<GetNoopVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetNoopVersionActor*>(this)->ActorCallback< GetNoopVersionActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetNoopVersionActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getNoopVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNoopVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetNoopVersionActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getNoopVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNoopVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetNoopVersionActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getNoopVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNoopVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetNoopVersionActor*>(this)->actor_wait_state > 0) static_cast<GetNoopVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetNoopVersionActor*>(this)->ActorCallback< GetNoopVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetNoopVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getNoopVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNoopVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetNoopVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getNoopVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNoopVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetNoopVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getNoopVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNoopVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 992 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Transaction tr;
															#line 8356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via getNoopVersion()
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class GetNoopVersionActor final : public Actor<Version>, public ActorCallback< GetNoopVersionActor, 0, Optional<Value> >, public ActorCallback< GetNoopVersionActor, 1, Void >, public FastAllocated<GetNoopVersionActor>, public GetNoopVersionActorState<GetNoopVersionActor> {
															#line 8361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<GetNoopVersionActor>::operator new;
	using FastAllocated<GetNoopVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10282992916740578304UL, 8389993386658114304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetNoopVersionActor, 0, Optional<Value> >;
friend struct ActorCallback< GetNoopVersionActor, 1, Void >;
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	GetNoopVersionActor(BackupData* const& self) 
															#line 8379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Version>(),
		   GetNoopVersionActorState<GetNoopVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNoopVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2594413157595683584UL, 18381032131462800128UL);
		ActorExecutionContextHelper __helper(static_cast<GetNoopVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNoopVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNoopVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetNoopVersionActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetNoopVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Version> getNoopVersion( BackupData* const& self ) {
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Version>(new GetNoopVersionActor(self));
															#line 8413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 1011 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

// Pulls data from TLog servers using LogRouter tag.
															#line 8419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via pullAsyncData()
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class PullAsyncDataActor>
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class PullAsyncDataActorState {
															#line 8426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	PullAsyncDataActorState(BackupData* const& self) 
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 1014 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   logSystemChange(Void()),
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   r(),
															#line 1020 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tagAt(std::max({ self->pulledVersion.get(), self->startVersion, self->savedVersion, self->popVersion, self->popTrigger.get() }))
															#line 8439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("pullAsyncData", reinterpret_cast<unsigned long>(this));

	}
	~PullAsyncDataActorState() 
	{
		fdb_probe_actor_destroy("pullAsyncData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1026 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerPull", self->myId) .detail("Tag", self->tag) .detail("Version", tagAt) .detail("PopVersion", self->popVersion) .detail("TriggerVersion", self->popTrigger.get()) .detail("StartVersion", self->startVersion) .detail("SavedVersion", self->savedVersion);
															#line 1033 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 8456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PullAsyncDataActorState();
		static_cast<PullAsyncDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1034 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		;
															#line 8486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1038 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		;
															#line 8495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1034 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!(self->paused.get()))
															#line 8511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1035 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->paused.onChange();
															#line 1035 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 1;
															#line 1035 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PullAsyncDataActor, 0, Void >*>(static_cast<PullAsyncDataActor*>(this)));
															#line 8524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state > 0) static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 0;
		static_cast<PullAsyncDataActor*>(this)->ActorCallback< PullAsyncDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PullAsyncDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1057 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (r->popped() > 0)
															#line 8633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Version> __when_expr_3 = getNoopVersion(self);
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
			static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 3;
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PullAsyncDataActor, 3, Version >*>(static_cast<PullAsyncDataActor*>(this)));
															#line 8644 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 1039 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = r ? r->getMore(TaskPriority::TLogCommit) : Never();
															#line 1038 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 1045 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = logSystemChange;
															#line 8671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
		static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 2;
															#line 1039 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PullAsyncDataActor, 1, Void >*>(static_cast<PullAsyncDataActor*>(this)));
															#line 1045 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PullAsyncDataActor, 2, Void >*>(static_cast<PullAsyncDataActor*>(this)));
															#line 8678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1040 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		DisabledTraceEvent("BackupWorkerGotMore", self->myId) .detail("Tag", self->tag) .detail("CursorVersion", r->version().version);
															#line 8706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1040 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		DisabledTraceEvent("BackupWorkerGotMore", self->myId) .detail("Tag", self->tag) .detail("CursorVersion", r->version().version);
															#line 8715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1046 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (self->logSystem.get())
															#line 8724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1047 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			r = self->logSystem.get()->peekLogRouter( self->myId, tagAt, self->tag, SERVER_KNOBS->LOG_ROUTER_PEEK_FROM_SATELLITES_PREFERRED);
															#line 8728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
		else
		{
															#line 1050 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			r = Reference<ILogSystem::IPeekCursor>();
															#line 8734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 1052 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		logSystemChange = self->logSystem.onChange();
															#line 8738 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1046 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (self->logSystem.get())
															#line 8747 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1047 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			r = self->logSystem.get()->peekLogRouter( self->myId, tagAt, self->tag, SERVER_KNOBS->LOG_ROUTER_PEEK_FROM_SATELLITES_PREFERRED);
															#line 8751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
		else
		{
															#line 1050 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			r = Reference<ILogSystem::IPeekCursor>();
															#line 8757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 1052 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		logSystemChange = self->logSystem.onChange();
															#line 8761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state > 0) static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 0;
		static_cast<PullAsyncDataActor*>(this)->ActorCallback< PullAsyncDataActor, 1, Void >::remove();
		static_cast<PullAsyncDataActor*>(this)->ActorCallback< PullAsyncDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PullAsyncDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PullAsyncDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1074 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->minKnownCommittedVersion = std::max(self->minKnownCommittedVersion, r->getMinKnownCommittedVersion());
															#line 1078 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		peekedBytes = 0;
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tmpMessages = std::vector<VersionedMessage>();
															#line 1083 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		for(;r->hasMessage();) {
															#line 1084 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tmpMessages.emplace_back(r->version(), r->getMessage(), r->getTags(), r->arena());
															#line 1085 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			peekedBytes += tmpMessages.back().getEstimatedSize();
															#line 1086 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			r->nextMessage();
															#line 8903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 1088 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (peekedBytes > 0)
															#line 8907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1089 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent(SevDebugMemory, "BackupWorkerMemory", self->myId) .detail("Take", peekedBytes) .detail("Current", self->lock->activePermits());
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->lock->take(TaskPriority::DefaultYield, peekedBytes);
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
			static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 4;
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PullAsyncDataActor, 4, Void >*>(static_cast<PullAsyncDataActor*>(this)));
															#line 8920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(Version const& maxNoopVersion,int loopDepth) 
	{
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		Severity sev = maxNoopVersion != invalidVersion && maxNoopVersion < r->popped() ? SevError : SevWarnAlways;
															#line 1060 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent(sev, "BackupWorkerPullMissingMutations", self->myId) .detail("Tag", self->tag) .detail("BackupEpoch", self->backupEpoch) .detail("Popped", r->popped()) .detail("NoopPoppedVersion", maxNoopVersion) .detail("ExpectedPeekVersion", tagAt);
															#line 1066 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		ASSERT(self->backupEpoch < self->recruitedEpoch && maxNoopVersion >= r->popped());
															#line 8938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Version && maxNoopVersion,int loopDepth) 
	{
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		Severity sev = maxNoopVersion != invalidVersion && maxNoopVersion < r->popped() ? SevError : SevWarnAlways;
															#line 1060 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent(sev, "BackupWorkerPullMissingMutations", self->myId) .detail("Tag", self->tag) .detail("BackupEpoch", self->backupEpoch) .detail("Popped", r->popped()) .detail("NoopPoppedVersion", maxNoopVersion) .detail("ExpectedPeekVersion", tagAt);
															#line 1066 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		ASSERT(self->backupEpoch < self->recruitedEpoch && maxNoopVersion >= r->popped());
															#line 8951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Version const& maxNoopVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(maxNoopVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Version && maxNoopVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(maxNoopVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state > 0) static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 0;
		static_cast<PullAsyncDataActor*>(this)->ActorCallback< PullAsyncDataActor, 3, Version >::remove();

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 3, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 3, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PullAsyncDataActor, 3, Version >*,Error err) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 1098 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tagAt = r->version().version;
															#line 1099 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->pulledVersion.set(tagAt);
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerGot", self->myId).suppressFor(1.0).detail("V", tagAt);
															#line 1101 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (self->pullFinished())
															#line 9041 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1102 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->eraseMessagesAfterEndVersion();
															#line 1103 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->doneTrigger.trigger();
															#line 1104 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerFinishPull", self->myId) .detail("Tag", self->tag.toString()) .detail("VersionGot", tagAt) .detail("EndVersion", self->endVersion.get()) .detail("MsgQ", self->messages.size());
															#line 1109 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<PullAsyncDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PullAsyncDataActorState(); static_cast<PullAsyncDataActor*>(this)->destroy(); return 0; }
															#line 9051 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			new (&static_cast<PullAsyncDataActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~PullAsyncDataActorState();
			static_cast<PullAsyncDataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1111 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_5 = yield();
															#line 1111 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 5;
															#line 1111 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< PullAsyncDataActor, 5, Void >*>(static_cast<PullAsyncDataActor*>(this)));
															#line 9066 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 1093 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->messages.insert(self->messages.end(), std::make_move_iterator(tmpMessages.begin()), std::make_move_iterator(tmpMessages.end()));
															#line 9075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 1093 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->messages.insert(self->messages.end(), std::make_move_iterator(tmpMessages.begin()), std::make_move_iterator(tmpMessages.end()));
															#line 9084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state > 0) static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 0;
		static_cast<PullAsyncDataActor*>(this)->ActorCallback< PullAsyncDataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< PullAsyncDataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<PullAsyncDataActor*>(this)->actor_wait_state > 0) static_cast<PullAsyncDataActor*>(this)->actor_wait_state = 0;
		static_cast<PullAsyncDataActor*>(this)->ActorCallback< PullAsyncDataActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< PullAsyncDataActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< PullAsyncDataActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 1014 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> logSystemChange;
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<ILogSystem::IPeekCursor> r;
															#line 1020 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Version tagAt;
															#line 1078 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	int64_t peekedBytes;
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	std::vector<VersionedMessage> tmpMessages;
															#line 9263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via pullAsyncData()
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class PullAsyncDataActor final : public Actor<Void>, public ActorCallback< PullAsyncDataActor, 0, Void >, public ActorCallback< PullAsyncDataActor, 1, Void >, public ActorCallback< PullAsyncDataActor, 2, Void >, public ActorCallback< PullAsyncDataActor, 3, Version >, public ActorCallback< PullAsyncDataActor, 4, Void >, public ActorCallback< PullAsyncDataActor, 5, Void >, public FastAllocated<PullAsyncDataActor>, public PullAsyncDataActorState<PullAsyncDataActor> {
															#line 9268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<PullAsyncDataActor>::operator new;
	using FastAllocated<PullAsyncDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7464618606433169664UL, 4199423984547585280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PullAsyncDataActor, 0, Void >;
friend struct ActorCallback< PullAsyncDataActor, 1, Void >;
friend struct ActorCallback< PullAsyncDataActor, 2, Void >;
friend struct ActorCallback< PullAsyncDataActor, 3, Version >;
friend struct ActorCallback< PullAsyncDataActor, 4, Void >;
friend struct ActorCallback< PullAsyncDataActor, 5, Void >;
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	PullAsyncDataActor(BackupData* const& self) 
															#line 9290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   PullAsyncDataActorState<PullAsyncDataActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("pullAsyncData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8097422354448463360UL, 16625194706777794048UL);
		ActorExecutionContextHelper __helper(static_cast<PullAsyncDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("pullAsyncData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("pullAsyncData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PullAsyncDataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PullAsyncDataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PullAsyncDataActor, 3, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PullAsyncDataActor, 4, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< PullAsyncDataActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> pullAsyncData( BackupData* const& self ) {
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new PullAsyncDataActor(self));
															#line 9327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 1114 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

															#line 9332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorBackupKeyOrPullData()
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class MonitorBackupKeyOrPullDataActor>
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorBackupKeyOrPullDataActorState {
															#line 9339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorBackupKeyOrPullDataActorState(BackupData* const& self,bool const& keyPresent) 
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   keyPresent(keyPresent),
															#line 1116 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   pullFinished(Void())
															#line 9350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this));

	}
	~MonitorBackupKeyOrPullDataActorState() 
	{
		fdb_probe_actor_destroy("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 9365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorBackupKeyOrPullDataActorState();
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1119 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		present = monitorBackupStartedKeyChanges(self, !keyPresent, true);
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (keyPresent)
															#line 9397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1121 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			pullFinished = pullAsyncData(self);
															#line 1122 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->pulling = true;
															#line 1123 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(present) || pullFinished;
															#line 1123 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 1;
															#line 1123 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >*>(static_cast<MonitorBackupKeyOrPullDataActor*>(this)));
															#line 9412 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			committedVersion = self->getMinKnownCommittedVersion();
															#line 1140 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 9421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		ASSERT(!keyPresent == present.get());
															#line 1166 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		keyPresent = !keyPresent;
															#line 9433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1124 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (pullFinished.isReady())
															#line 9442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->pulling = false;
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<MonitorBackupKeyOrPullDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorBackupKeyOrPullDataActorState(); static_cast<MonitorBackupKeyOrPullDataActor*>(this)->destroy(); return 0; }
															#line 9448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			new (&static_cast<MonitorBackupKeyOrPullDataActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MonitorBackupKeyOrPullDataActorState();
			static_cast<MonitorBackupKeyOrPullDataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Version> __when_expr_1 = self->getMinKnownCommittedVersion();
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 2;
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >*>(static_cast<MonitorBackupKeyOrPullDataActor*>(this)));
															#line 9463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1124 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (pullFinished.isReady())
															#line 9472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->pulling = false;
															#line 1126 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (!static_cast<MonitorBackupKeyOrPullDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorBackupKeyOrPullDataActorState(); static_cast<MonitorBackupKeyOrPullDataActor*>(this)->destroy(); return 0; }
															#line 9478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			new (&static_cast<MonitorBackupKeyOrPullDataActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MonitorBackupKeyOrPullDataActorState();
			static_cast<MonitorBackupKeyOrPullDataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Version> __when_expr_1 = self->getMinKnownCommittedVersion();
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 2;
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >*>(static_cast<MonitorBackupKeyOrPullDataActor*>(this)));
															#line 9493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Version const& currentVersion,int loopDepth) 
	{
															#line 1132 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->pulledVersion.whenAtLeast(currentVersion);
															#line 1132 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 3;
															#line 1132 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >*>(static_cast<MonitorBackupKeyOrPullDataActor*>(this)));
															#line 9584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Version && currentVersion,int loopDepth) 
	{
															#line 1132 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->pulledVersion.whenAtLeast(currentVersion);
															#line 1132 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 3;
															#line 1132 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >*>(static_cast<MonitorBackupKeyOrPullDataActor*>(this)));
															#line 9600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Version const& currentVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(currentVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Version && currentVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(currentVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1133 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		pullFinished = Future<Void>();
															#line 1134 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->pulling = false;
															#line 1135 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerPaused", self->myId).detail("Reason", "NoBackup");
															#line 9688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1133 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		pullFinished = Future<Void>();
															#line 1134 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		self->pulling = false;
															#line 1135 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerPaused", self->myId).detail("Reason", "NoBackup");
															#line 9701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1141 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(present);
															#line 1140 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 9800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_3.get(), loopDepth); };
															#line 1144 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(committedVersion) || delay(SERVER_KNOBS->BACKUP_NOOP_POP_DELAY, self->cx->taskID);
															#line 9804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when2(__when_expr_4.get(), loopDepth); };
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 4;
															#line 1141 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >*>(static_cast<MonitorBackupKeyOrPullDataActor*>(this)));
															#line 1144 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorBackupKeyOrPullDataActor, 4, Void >*>(static_cast<MonitorBackupKeyOrPullDataActor*>(this)));
															#line 9811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (committedVersion.isReady())
															#line 9851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1146 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			Version newPopVersion = std::max({ self->popVersion, self->savedVersion, committedVersion.get() });
															#line 1148 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->minKnownCommittedVersion = std::max(committedVersion.get(), self->minKnownCommittedVersion);
															#line 1150 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (newPopVersion < self->popTrigger.get())
															#line 9859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				DisabledTraceEvent("BackupWorkerSkipTrigger", self->myId) .detail("Version", newPopVersion) .detail("OldPop", self->popTrigger.get());
															#line 9863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
			else
			{
															#line 1156 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				self->popTrigger.set(newPopVersion);
															#line 9869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
															#line 1158 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			committedVersion = Never();
															#line 9873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
		else
		{
															#line 1160 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			committedVersion = self->getMinKnownCommittedVersion();
															#line 9879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (committedVersion.isReady())
															#line 9889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1146 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			Version newPopVersion = std::max({ self->popVersion, self->savedVersion, committedVersion.get() });
															#line 1148 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->minKnownCommittedVersion = std::max(committedVersion.get(), self->minKnownCommittedVersion);
															#line 1150 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (newPopVersion < self->popTrigger.get())
															#line 9897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 1152 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				DisabledTraceEvent("BackupWorkerSkipTrigger", self->myId) .detail("Version", newPopVersion) .detail("OldPop", self->popTrigger.get());
															#line 9901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
			else
			{
															#line 1156 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				self->popTrigger.set(newPopVersion);
															#line 9907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			}
															#line 1158 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			committedVersion = Never();
															#line 9911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
		else
		{
															#line 1160 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			committedVersion = self->getMinKnownCommittedVersion();
															#line 9917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state > 0) static_cast<MonitorBackupKeyOrPullDataActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >::remove();
		static_cast<MonitorBackupKeyOrPullDataActor*>(this)->ActorCallback< MonitorBackupKeyOrPullDataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorBackupKeyOrPullDataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorBackupKeyOrPullDataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	bool keyPresent;
															#line 1116 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> pullFinished;
															#line 1119 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<bool> present;
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Version> committedVersion;
															#line 10054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via monitorBackupKeyOrPullData()
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorBackupKeyOrPullDataActor final : public Actor<Void>, public ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >, public ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >, public ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >, public ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >, public ActorCallback< MonitorBackupKeyOrPullDataActor, 4, Void >, public FastAllocated<MonitorBackupKeyOrPullDataActor>, public MonitorBackupKeyOrPullDataActorState<MonitorBackupKeyOrPullDataActor> {
															#line 10059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<MonitorBackupKeyOrPullDataActor>::operator new;
	using FastAllocated<MonitorBackupKeyOrPullDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1102656775705529088UL, 348662278862992896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >;
friend struct ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >;
friend struct ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >;
friend struct ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >;
friend struct ActorCallback< MonitorBackupKeyOrPullDataActor, 4, Void >;
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorBackupKeyOrPullDataActor(BackupData* const& self,bool const& keyPresent) 
															#line 10080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorBackupKeyOrPullDataActorState<MonitorBackupKeyOrPullDataActor>(self, keyPresent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7886700117831388672UL, 1447957588129246976UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorBackupKeyOrPullDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorBackupKeyOrPullData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorBackupKeyOrPullData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorBackupKeyOrPullDataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorBackupKeyOrPullDataActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorBackupKeyOrPullDataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorBackupKeyOrPullDataActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> monitorBackupKeyOrPullData( BackupData* const& self, bool const& keyPresent ) {
															#line 1115 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new MonitorBackupKeyOrPullDataActor(self, keyPresent));
															#line 10116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 1169 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

															#line 10121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via checkRemoved()
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class CheckRemovedActor>
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class CheckRemovedActorState {
															#line 10128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	CheckRemovedActorState(Reference<AsyncVar<ServerDBInfo> const> const& db,LogEpoch const& recoveryCount,BackupData* const& self) 
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : db(db),
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   recoveryCount(recoveryCount),
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   self(self)
															#line 10139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("checkRemoved", reinterpret_cast<unsigned long>(this));

	}
	~CheckRemovedActorState() 
	{
		fdb_probe_actor_destroy("checkRemoved", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1171 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 10154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckRemovedActorState();
		static_cast<CheckRemovedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		bool isDisplaced = db->get().recoveryCount > recoveryCount && db->get().recoveryState != RecoveryState::UNINITIALIZED;
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (isDisplaced)
															#line 10186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1175 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerDisplaced", self->myId) .detail("RecoveryCount", recoveryCount) .detail("SavedVersion", self->savedVersion) .detail("BackupWorkers", describe(db->get().logSystemConfig.tLogs)) .detail("DBRecoveryCount", db->get().recoveryCount) .detail("RecoveryState", (int)db->get().recoveryState);
															#line 1181 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 10192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<CheckRemovedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10198 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckRemovedActor*>(this)->actor_wait_state = 1;
															#line 1183 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckRemovedActor, 0, Void >*>(static_cast<CheckRemovedActor*>(this)));
															#line 10203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckRemovedActor*>(this)->actor_wait_state > 0) static_cast<CheckRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRemovedActor*>(this)->ActorCallback< CheckRemovedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRemovedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckRemovedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckRemovedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	LogEpoch recoveryCount;
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 10301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via checkRemoved()
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class CheckRemovedActor final : public Actor<Void>, public ActorCallback< CheckRemovedActor, 0, Void >, public FastAllocated<CheckRemovedActor>, public CheckRemovedActorState<CheckRemovedActor> {
															#line 10306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<CheckRemovedActor>::operator new;
	using FastAllocated<CheckRemovedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1091699266342694656UL, 3693494237488528384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckRemovedActor, 0, Void >;
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	CheckRemovedActor(Reference<AsyncVar<ServerDBInfo> const> const& db,LogEpoch const& recoveryCount,BackupData* const& self) 
															#line 10323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   CheckRemovedActorState<CheckRemovedActor>(db, recoveryCount, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15518436168711072512UL, 6662910151609573120UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkRemoved");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckRemovedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> checkRemoved( Reference<AsyncVar<ServerDBInfo> const> const& db, LogEpoch const& recoveryCount, BackupData* const& self ) {
															#line 1170 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new CheckRemovedActor(db, recoveryCount, self));
															#line 10356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 1186 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

															#line 10361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorWorkerPause()
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class MonitorWorkerPauseActor>
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorWorkerPauseActorState {
															#line 10368 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorWorkerPauseActorState(BackupData* const& self) 
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : self(self),
															#line 1188 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   tr(new ReadYourWritesTransaction(self->cx)),
															#line 1189 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   watch()
															#line 10379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorWorkerPause", reinterpret_cast<unsigned long>(this));

	}
	~MonitorWorkerPauseActorState() 
	{
		fdb_probe_actor_destroy("monitorWorkerPause", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1191 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			;
															#line 10394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorWorkerPauseActorState();
		static_cast<MonitorWorkerPauseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1193 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1194 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1195 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1197 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(backupPausedKey);
															#line 1197 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 1;
															#line 1197 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >*>(static_cast<MonitorWorkerPauseActor*>(this)));
															#line 10438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1209 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 1209 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 4;
															#line 1209 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerPauseActor, 3, Void >*>(static_cast<MonitorWorkerPauseActor*>(this)));
															#line 10467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& value,int loopDepth) 
	{
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		bool paused = value.present() && value.get() == "1"_sr;
															#line 1199 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (self->paused.get() != paused)
															#line 10484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1200 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent(paused ? "BackupWorkerPaused" : "BackupWorkerResumed", self->myId).log();
															#line 1201 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->paused.set(paused);
															#line 10490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 1204 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		watch = tr->watch(backupPausedKey);
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 2;
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerPauseActor, 1, Void >*>(static_cast<MonitorWorkerPauseActor*>(this)));
															#line 10503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && value,int loopDepth) 
	{
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		bool paused = value.present() && value.get() == "1"_sr;
															#line 1199 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (self->paused.get() != paused)
															#line 10514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1200 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent(paused ? "BackupWorkerPaused" : "BackupWorkerResumed", self->myId).log();
															#line 1201 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self->paused.set(paused);
															#line 10520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 1204 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		watch = tr->watch(backupPausedKey);
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 2;
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerPauseActor, 1, Void >*>(static_cast<MonitorWorkerPauseActor*>(this)));
															#line 10533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state > 0) static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorWorkerPauseActor*>(this)->ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1206 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watch;
															#line 1206 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 3;
															#line 1206 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerPauseActor, 2, Void >*>(static_cast<MonitorWorkerPauseActor*>(this)));
															#line 10624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1206 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = watch;
															#line 1206 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 3;
															#line 1206 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorWorkerPauseActor, 2, Void >*>(static_cast<MonitorWorkerPauseActor*>(this)));
															#line 10640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state > 0) static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorWorkerPauseActor*>(this)->ActorCallback< MonitorWorkerPauseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorWorkerPauseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1207 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tr->reset();
															#line 10724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1207 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		tr->reset();
															#line 10733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state > 0) static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorWorkerPauseActor*>(this)->ActorCallback< MonitorWorkerPauseActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorWorkerPauseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state > 0) static_cast<MonitorWorkerPauseActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorWorkerPauseActor*>(this)->ActorCallback< MonitorWorkerPauseActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorWorkerPauseActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorWorkerPauseActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData* self;
															#line 1188 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1189 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> watch;
															#line 10919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via monitorWorkerPause()
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class MonitorWorkerPauseActor final : public Actor<Void>, public ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >, public ActorCallback< MonitorWorkerPauseActor, 1, Void >, public ActorCallback< MonitorWorkerPauseActor, 2, Void >, public ActorCallback< MonitorWorkerPauseActor, 3, Void >, public FastAllocated<MonitorWorkerPauseActor>, public MonitorWorkerPauseActorState<MonitorWorkerPauseActor> {
															#line 10924 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<MonitorWorkerPauseActor>::operator new;
	using FastAllocated<MonitorWorkerPauseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16971929451122595072UL, 9823178609332382720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >;
friend struct ActorCallback< MonitorWorkerPauseActor, 1, Void >;
friend struct ActorCallback< MonitorWorkerPauseActor, 2, Void >;
friend struct ActorCallback< MonitorWorkerPauseActor, 3, Void >;
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	MonitorWorkerPauseActor(BackupData* const& self) 
															#line 10944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorWorkerPauseActorState<MonitorWorkerPauseActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorWorkerPause", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7188464638591516160UL, 18010931341658145792UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorWorkerPauseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorWorkerPause");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorWorkerPause", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorWorkerPauseActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorWorkerPauseActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorWorkerPauseActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorWorkerPauseActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] static Future<Void> monitorWorkerPause( BackupData* const& self ) {
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new MonitorWorkerPauseActor(self));
															#line 10980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 1213 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"

															#line 10985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
namespace {
// This generated class is to be used only via backupWorker()
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
template <class BackupWorkerActor>
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class BackupWorkerActorState {
															#line 10992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupWorkerActorState(BackupInterface const& interf,InitializeBackupRequest const& req,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		 : interf(interf),
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   req(req),
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   db(db),
															#line 1217 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   self(interf.id(), db, req),
															#line 1218 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   addActor(),
															#line 1219 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   error(actorCollection(addActor.getFuture())),
															#line 1220 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   dbInfoChange(Void()),
															#line 1221 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   pull(),
															#line 1222 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		   done()
															#line 11015 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
	{
		fdb_probe_actor_create("backupWorker", reinterpret_cast<unsigned long>(this));

	}
	~BackupWorkerActorState() 
	{
		fdb_probe_actor_destroy("backupWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1224 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerStart", self.myId) .detail("Tag", req.routerTag.toString()) .detail("TotalTags", req.totalTags) .detail("StartVersion", req.startVersion) .detail("EndVersion", req.endVersion.present() ? req.endVersion.get() : -1) .detail("LogEpoch", req.recruitedEpoch) .detail("BackupEpoch", req.backupEpoch);
															#line 11030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			try {
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				addActor.send(checkRemoved(db, req.recruitedEpoch, &self));
															#line 1233 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				addActor.send(waitFailureServer(interf.waitFailure.getFuture()));
															#line 1234 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (req.recruitedEpoch == req.backupEpoch && req.routerTag.id == 0)
															#line 11038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				{
															#line 1235 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					addActor.send(monitorBackupProgress(&self));
															#line 11042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				}
															#line 1237 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				addActor.send(monitorWorkerPause(&self));
															#line 1242 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				StrictFuture<bool> __when_expr_0 = monitorBackupStartedKeyChanges(&self, true, false);
															#line 1242 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				if (static_cast<BackupWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 11050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BackupWorkerActor*>(this)->actor_wait_state = 1;
															#line 1242 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BackupWorkerActor, 0, bool >*>(static_cast<BackupWorkerActor*>(this)));
															#line 11055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BackupWorkerActorState();
		static_cast<BackupWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1289 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (!static_cast<BackupWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BackupWorkerActorState(); static_cast<BackupWorkerActor*>(this)->destroy(); return 0; }
															#line 11084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		new (&static_cast<BackupWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BackupWorkerActorState();
		static_cast<BackupWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1274 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			err = e;
															#line 1275 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			if (e.code() == error_code_worker_removed)
															#line 11099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			{
															#line 1276 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				pull = Void();
															#line 1277 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
				self.stop();
															#line 11105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
				try {
															#line 1279 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					StrictFuture<Void> __when_expr_5 = done;
															#line 1279 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					if (static_cast<BackupWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch2Catch1(actor_cancelled(), loopDepth);
															#line 11111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
					if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2Catch1(__when_expr_5.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_5.get(), loopDepth); };
					static_cast<BackupWorkerActor*>(this)->actor_wait_state = 4;
															#line 1279 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
					__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< BackupWorkerActor, 5, Void >*>(static_cast<BackupWorkerActor*>(this)));
															#line 11116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1Catch2Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch2Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1Catch2cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(bool const& present,int loopDepth) 
	{
															#line 1243 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerWaitKey", self.myId).detail("Present", present).detail("ExitEarly", self.exitEarly);
															#line 1245 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		pull = self.exitEarly ? Void() : monitorBackupKeyOrPullData(&self, present);
															#line 1246 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		addActor.send(pull);
															#line 1247 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		done = self.exitEarly ? Void() : uploadData(&self);
															#line 1249 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		;
															#line 11150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(bool && present,int loopDepth) 
	{
															#line 1243 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerWaitKey", self.myId).detail("Present", present).detail("ExitEarly", self.exitEarly);
															#line 1245 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		pull = self.exitEarly ? Void() : monitorBackupKeyOrPullData(&self, present);
															#line 1246 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		addActor.send(pull);
															#line 1247 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		done = self.exitEarly ? Void() : uploadData(&self);
															#line 1249 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		;
															#line 11167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool const& present,int loopDepth) 
	{
		loopDepth = a_body1cont2(present, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && present,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(present), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BackupWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackupWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackupWorkerActor*>(this)->ActorCallback< BackupWorkerActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BackupWorkerActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 1250 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = dbInfoChange;
															#line 1249 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<BackupWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 1263 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = done;
															#line 11270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 1271 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = error;
															#line 11274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when3(__when_expr_3.get(), loopDepth); };
		static_cast<BackupWorkerActor*>(this)->actor_wait_state = 2;
															#line 1250 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BackupWorkerActor, 1, Void >*>(static_cast<BackupWorkerActor*>(this)));
															#line 1263 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BackupWorkerActor, 2, Void >*>(static_cast<BackupWorkerActor*>(this)));
															#line 1271 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BackupWorkerActor, 3, Void >*>(static_cast<BackupWorkerActor*>(this)));
															#line 11283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1251 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		dbInfoChange = db->onChange();
															#line 1252 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		Reference<ILogSystem> ls = ILogSystem::fromServerDBInfo(self.myId, db->get(), true);
															#line 1253 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		bool hasPseudoLocality = ls.isValid() && ls->hasPseudoLocality(tagLocalityBackup);
															#line 1254 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (hasPseudoLocality)
															#line 11317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1255 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self.logSystem.set(ls);
															#line 1256 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self.oldestBackupEpoch = std::max(self.oldestBackupEpoch, ls->getOldestBackupEpoch());
															#line 11323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 1258 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerLogSystem", self.myId) .detail("HasBackupLocality", hasPseudoLocality) .detail("OldestBackupEpoch", self.oldestBackupEpoch) .detail("Tag", self.tag.toString());
															#line 11327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1251 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		dbInfoChange = db->onChange();
															#line 1252 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		Reference<ILogSystem> ls = ILogSystem::fromServerDBInfo(self.myId, db->get(), true);
															#line 1253 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		bool hasPseudoLocality = ls.isValid() && ls->hasPseudoLocality(tagLocalityBackup);
															#line 1254 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (hasPseudoLocality)
															#line 11342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1255 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self.logSystem.set(ls);
															#line 1256 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			self.oldestBackupEpoch = std::max(self.oldestBackupEpoch, ls->getOldestBackupEpoch());
															#line 11348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
															#line 1258 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerLogSystem", self.myId) .detail("HasBackupLocality", hasPseudoLocality) .detail("OldestBackupEpoch", self.oldestBackupEpoch) .detail("Tag", self.tag.toString());
															#line 11352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1264 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerDone", self.myId).detail("BackupEpoch", self.backupEpoch);
															#line 1267 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = brokenPromiseToNever(db->get().clusterInterface.notifyBackupWorkerDone.getReply( BackupWorkerDoneRequest(self.myId, self.backupEpoch)));
															#line 1267 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<BackupWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when2when1(__when_expr_4.get(), loopDepth); };
		static_cast<BackupWorkerActor*>(this)->actor_wait_state = 3;
															#line 1267 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BackupWorkerActor, 4, Void >*>(static_cast<BackupWorkerActor*>(this)));
															#line 11370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1264 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerDone", self.myId).detail("BackupEpoch", self.backupEpoch);
															#line 1267 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = brokenPromiseToNever(db->get().clusterInterface.notifyBackupWorkerDone.getReply( BackupWorkerDoneRequest(self.myId, self.backupEpoch)));
															#line 1267 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (static_cast<BackupWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when2when1(__when_expr_4.get(), loopDepth); };
		static_cast<BackupWorkerActor*>(this)->actor_wait_state = 3;
															#line 1267 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BackupWorkerActor, 4, Void >*>(static_cast<BackupWorkerActor*>(this)));
															#line 11388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BackupWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackupWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackupWorkerActor*>(this)->ActorCallback< BackupWorkerActor, 1, Void >::remove();
		static_cast<BackupWorkerActor*>(this)->ActorCallback< BackupWorkerActor, 2, Void >::remove();
		static_cast<BackupWorkerActor*>(this)->ActorCallback< BackupWorkerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BackupWorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2loopBody1when2cont1(Void const& _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1when2cont1(Void && _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1when2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1when2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BackupWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackupWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackupWorkerActor*>(this)->ActorCallback< BackupWorkerActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BackupWorkerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BackupWorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BackupWorkerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(int loopDepth) 
	{
															#line 1284 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		TraceEvent("BackupWorkerTerminated", self.myId).errorUnsuppressed(err);
															#line 1285 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
		if (err.code() != error_code_actor_cancelled && err.code() != error_code_worker_removed)
															#line 11690 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		{
															#line 1286 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			return a_body1Catch1(err, loopDepth);
															#line 11694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont2(int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1281 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
			TraceEvent("BackupWorkerShutdownError", self.myId).errorUnsuppressed(e);
															#line 11711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
			loopDepth = a_body1Catch2cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont4(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont4(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BackupWorkerActor*>(this)->actor_wait_state > 0) static_cast<BackupWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<BackupWorkerActor*>(this)->ActorCallback< BackupWorkerActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< BackupWorkerActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< BackupWorkerActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1Catch2cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1Catch2cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupInterface interf;
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	InitializeBackupRequest req;
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1217 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupData self;
															#line 1218 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 1219 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> error;
															#line 1220 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> dbInfoChange;
															#line 1221 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> pull;
															#line 1222 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Future<Void> done;
															#line 1274 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	Error err;
															#line 11842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
};
// This generated class is to be used only via backupWorker()
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
class BackupWorkerActor final : public Actor<Void>, public ActorCallback< BackupWorkerActor, 0, bool >, public ActorCallback< BackupWorkerActor, 1, Void >, public ActorCallback< BackupWorkerActor, 2, Void >, public ActorCallback< BackupWorkerActor, 4, Void >, public ActorCallback< BackupWorkerActor, 3, Void >, public ActorCallback< BackupWorkerActor, 5, Void >, public FastAllocated<BackupWorkerActor>, public BackupWorkerActorState<BackupWorkerActor> {
															#line 11847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
public:
	using FastAllocated<BackupWorkerActor>::operator new;
	using FastAllocated<BackupWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15555338737105859840UL, 6674424420740158208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BackupWorkerActor, 0, bool >;
friend struct ActorCallback< BackupWorkerActor, 1, Void >;
friend struct ActorCallback< BackupWorkerActor, 2, Void >;
friend struct ActorCallback< BackupWorkerActor, 4, Void >;
friend struct ActorCallback< BackupWorkerActor, 3, Void >;
friend struct ActorCallback< BackupWorkerActor, 5, Void >;
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	BackupWorkerActor(BackupInterface const& interf,InitializeBackupRequest const& req,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 11869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
		 : Actor<Void>(),
		   BackupWorkerActorState<BackupWorkerActor>(interf, req, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("backupWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1836670724661246976UL, 17551872501433186048UL);
		ActorExecutionContextHelper __helper(static_cast<BackupWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("backupWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("backupWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BackupWorkerActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BackupWorkerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BackupWorkerActor, 4, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BackupWorkerActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
[[nodiscard]] Future<Void> backupWorker( BackupInterface const& interf, InitializeBackupRequest const& req, Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 1214 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
	return Future<Void>(new BackupWorkerActor(interf, req, db));
															#line 11905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/BackupWorker.actor.g.cpp"
}

#line 1291 "/Users/ec2-user/foundationdb/fdbserver/BackupWorker.actor.cpp"
