#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
/*
 * MetaclusterCommands.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/RunTransaction.actor.h"
#include "fdbclient/Schemas.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"

#include "metacluster/Metacluster.h"
#include "metacluster/MetaclusterUtil.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.
#include <string>

namespace fdb_cli {

Optional<std::pair<Optional<ClusterConnectionString>, Optional<metacluster::DataClusterEntry>>>
parseClusterConfiguration(std::vector<StringRef> const& tokens,
                          metacluster::DataClusterEntry const& defaults,
                          int startIndex,
                          int endIndex) {
	Optional<metacluster::DataClusterEntry> entry;
	Optional<ClusterConnectionString> connectionString;

	std::set<std::string> usedParams;
	for (int tokenNum = startIndex; tokenNum < endIndex; ++tokenNum) {
		StringRef token = tokens[tokenNum];
		bool foundEquals;
		StringRef param = token.eat("=", &foundEquals);
		if (!foundEquals) {
			fmt::print(stderr,
			           "ERROR: invalid configuration string `{}'. String must specify a value using `='.\n",
			           param.toString().c_str());
			return {};
		}
		std::string value = token.toString();
		if (!usedParams.insert(value).second) {
			fmt::print(
			    stderr, "ERROR: configuration parameter `{}' specified more than once.\n", param.toString().c_str());
			return {};
		}
		if (tokencmp(param, "max_tenant_groups")) {
			if (!entry.present()) {
				entry = defaults;
			}

			int n;
			if (sscanf(value.c_str(), "%d%n", &entry.get().capacity.numTenantGroups, &n) != 1 || n != value.size() ||
			    entry.get().capacity.numTenantGroups < 0) {
				fmt::print(stderr, "ERROR: invalid number of tenant groups `{}'.\n", value.c_str());
				return {};
			}
		} else if (tokencmp(param, "connection_string")) {
			connectionString = ClusterConnectionString(value);
		} else if (tokencmp(param, "auto_tenant_assignment")) {
			std::transform(
			    value.begin(), value.end(), value.begin(), [](unsigned char ch) { return std::tolower(ch); });
			if (!entry.present()) {
				entry = defaults;
			}
			if (value == "disabled") {
				entry.get().autoTenantAssignment = metacluster::AutoTenantAssignment::DISABLED;
			} else if (value == "enabled") {
				entry.get().autoTenantAssignment = metacluster::AutoTenantAssignment::ENABLED;
			} else {
				fmt::print(stderr, "ERROR: invalid configuration `{}' for `auto_tenant_assignment'.\n", value.c_str());
				return {};
			}
		} else {
			fmt::print(stderr, "ERROR: unrecognized configuration parameter `{}'.\n", param.toString().c_str());
			return {};
		}
	}

	return std::make_pair(connectionString, entry);
}

void printMetaclusterConfigureOptionsUsage() {
	fmt::print("max_tenant_groups sets the maximum number of tenant groups that can be assigned\n"
	           "to the named data cluster.\n");
	fmt::print("connection_string sets the connection string for the named data cluster.\n");
	fmt::print("auto_tenant_assignment determines whether this data cluster is added to the auto-assignment pool, i.e. "
	           "whether tenants may be automatically assigned to this data cluster.\n");
}

// metacluster create command
															#line 113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
// This generated class is to be used only via metaclusterCreateCommand()
															#line 111 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
template <class MetaclusterCreateCommandActor>
															#line 111 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterCreateCommandActorState {
															#line 119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
															#line 111 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterCreateCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 111 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
															#line 111 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		 : db(db),
															#line 111 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		   tokens(tokens)
															#line 128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("metaclusterCreateCommand", reinterpret_cast<unsigned long>(this));

	}
	~MetaclusterCreateCommandActorState() 
	{
		fdb_probe_actor_destroy("metaclusterCreateCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 112 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (tokens.size() != 4)
															#line 143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 113 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Usage: metacluster create_experimental <NAME> <TENANT_ID_PREFIX>\n\n");
															#line 114 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Configures the cluster to be a management cluster in a metacluster.\n");
															#line 115 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("NAME is an identifier used to distinguish this metacluster from other metaclusters.\n");
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("TENANT_ID_PREFIX is an integer in the range [0,32767] inclusive which is prepended to all tenant " "ids in the metacluster.\n");
															#line 118 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterCreateCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterCreateCommandActorState(); static_cast<MetaclusterCreateCommandActor*>(this)->destroy(); return 0; }
															#line 155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterCreateCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MetaclusterCreateCommandActorState();
				static_cast<MetaclusterCreateCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 121 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			int64_t tenantIdPrefix = std::stoi(tokens[3].toString());
															#line 122 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (tenantIdPrefix < TenantAPI::TENANT_ID_PREFIX_MIN_VALUE || tenantIdPrefix > TenantAPI::TENANT_ID_PREFIX_MAX_VALUE)
															#line 165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 124 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("TENANT_ID_PREFIX must be in the range [0,32767] inclusive\n");
															#line 125 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterCreateCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterCreateCommandActorState(); static_cast<MetaclusterCreateCommandActor*>(this)->destroy(); return 0; }
															#line 171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterCreateCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MetaclusterCreateCommandActorState();
				static_cast<MetaclusterCreateCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 128 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			StrictFuture<Optional<std::string>> __when_expr_0 = metacluster::createMetacluster(db, tokens[2], tenantIdPrefix, true);
															#line 128 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (static_cast<MetaclusterCreateCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MetaclusterCreateCommandActor*>(this)->actor_wait_state = 1;
															#line 128 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MetaclusterCreateCommandActor, 0, Optional<std::string> >*>(static_cast<MetaclusterCreateCommandActor*>(this)));
															#line 186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MetaclusterCreateCommandActorState();
		static_cast<MetaclusterCreateCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<std::string> const& errorStr,int loopDepth) 
	{
															#line 129 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (errorStr.present())
															#line 209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 130 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("ERROR: {}.\n", errorStr.get());
															#line 213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
		else
		{
															#line 132 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("The cluster has been configured as a metacluster.\n");
															#line 219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
															#line 134 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!static_cast<MetaclusterCreateCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterCreateCommandActorState(); static_cast<MetaclusterCreateCommandActor*>(this)->destroy(); return 0; }
															#line 223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		new (&static_cast<MetaclusterCreateCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~MetaclusterCreateCommandActorState();
		static_cast<MetaclusterCreateCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<std::string> && errorStr,int loopDepth) 
	{
															#line 129 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (errorStr.present())
															#line 235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 130 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("ERROR: {}.\n", errorStr.get());
															#line 239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
		else
		{
															#line 132 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("The cluster has been configured as a metacluster.\n");
															#line 245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
															#line 134 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!static_cast<MetaclusterCreateCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterCreateCommandActorState(); static_cast<MetaclusterCreateCommandActor*>(this)->destroy(); return 0; }
															#line 249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		new (&static_cast<MetaclusterCreateCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~MetaclusterCreateCommandActorState();
		static_cast<MetaclusterCreateCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<std::string> const& errorStr,int loopDepth) 
	{
		loopDepth = a_body1cont1(errorStr, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<std::string> && errorStr,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(errorStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MetaclusterCreateCommandActor*>(this)->actor_wait_state > 0) static_cast<MetaclusterCreateCommandActor*>(this)->actor_wait_state = 0;
		static_cast<MetaclusterCreateCommandActor*>(this)->ActorCallback< MetaclusterCreateCommandActor, 0, Optional<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< MetaclusterCreateCommandActor, 0, Optional<std::string> >*,Optional<std::string> const& value) 
	{
		fdb_probe_actor_enter("metaclusterCreateCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterCreateCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MetaclusterCreateCommandActor, 0, Optional<std::string> >*,Optional<std::string> && value) 
	{
		fdb_probe_actor_enter("metaclusterCreateCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterCreateCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MetaclusterCreateCommandActor, 0, Optional<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("metaclusterCreateCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterCreateCommand", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 111 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 111 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
};
// This generated class is to be used only via metaclusterCreateCommand()
															#line 111 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterCreateCommandActor final : public Actor<bool>, public ActorCallback< MetaclusterCreateCommandActor, 0, Optional<std::string> >, public FastAllocated<MetaclusterCreateCommandActor>, public MetaclusterCreateCommandActorState<MetaclusterCreateCommandActor> {
															#line 341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
	using FastAllocated<MetaclusterCreateCommandActor>::operator new;
	using FastAllocated<MetaclusterCreateCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(333698214567655168UL, 7975712436824061952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MetaclusterCreateCommandActor, 0, Optional<std::string> >;
															#line 111 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterCreateCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		 : Actor<bool>(),
		   MetaclusterCreateCommandActorState<MetaclusterCreateCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("metaclusterCreateCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7197931427406501376UL, 11454949247721721088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterCreateCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("metaclusterCreateCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("metaclusterCreateCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MetaclusterCreateCommandActor, 0, Optional<std::string> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 111 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
[[nodiscard]] Future<bool> metaclusterCreateCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 111 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	return Future<bool>(new MetaclusterCreateCommandActor(db, tokens));
															#line 390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
}

#line 136 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"

// metacluster decommission command
															#line 396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
// This generated class is to be used only via metaclusterDecommissionCommand()
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
template <class MetaclusterDecommissionCommandActor>
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterDecommissionCommandActorState {
															#line 402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterDecommissionCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		 : db(db),
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		   tokens(tokens)
															#line 411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("metaclusterDecommissionCommand", reinterpret_cast<unsigned long>(this));

	}
	~MetaclusterDecommissionCommandActorState() 
	{
		fdb_probe_actor_destroy("metaclusterDecommissionCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 139 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (tokens.size() != 2)
															#line 426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 140 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Usage: metacluster decommission\n\n");
															#line 141 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Converts the current cluster from a metacluster management cluster back into an\n");
															#line 142 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("ordinary cluster. It must be called on a cluster with no registered data clusters.\n");
															#line 143 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterDecommissionCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterDecommissionCommandActorState(); static_cast<MetaclusterDecommissionCommandActor*>(this)->destroy(); return 0; }
															#line 436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterDecommissionCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MetaclusterDecommissionCommandActorState();
				static_cast<MetaclusterDecommissionCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			StrictFuture<Void> __when_expr_0 = metacluster::decommissionMetacluster(db);
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (static_cast<MetaclusterDecommissionCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 446 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MetaclusterDecommissionCommandActor*>(this)->actor_wait_state = 1;
															#line 146 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MetaclusterDecommissionCommandActor, 0, Void >*>(static_cast<MetaclusterDecommissionCommandActor*>(this)));
															#line 451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MetaclusterDecommissionCommandActorState();
		static_cast<MetaclusterDecommissionCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		fmt::print("The cluster is no longer a metacluster.\n");
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!static_cast<MetaclusterDecommissionCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterDecommissionCommandActorState(); static_cast<MetaclusterDecommissionCommandActor*>(this)->destroy(); return 0; }
															#line 476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		new (&static_cast<MetaclusterDecommissionCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~MetaclusterDecommissionCommandActorState();
		static_cast<MetaclusterDecommissionCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		fmt::print("The cluster is no longer a metacluster.\n");
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!static_cast<MetaclusterDecommissionCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterDecommissionCommandActorState(); static_cast<MetaclusterDecommissionCommandActor*>(this)->destroy(); return 0; }
															#line 490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		new (&static_cast<MetaclusterDecommissionCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~MetaclusterDecommissionCommandActorState();
		static_cast<MetaclusterDecommissionCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MetaclusterDecommissionCommandActor*>(this)->actor_wait_state > 0) static_cast<MetaclusterDecommissionCommandActor*>(this)->actor_wait_state = 0;
		static_cast<MetaclusterDecommissionCommandActor*>(this)->ActorCallback< MetaclusterDecommissionCommandActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MetaclusterDecommissionCommandActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("metaclusterDecommissionCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterDecommissionCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterDecommissionCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MetaclusterDecommissionCommandActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("metaclusterDecommissionCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterDecommissionCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterDecommissionCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MetaclusterDecommissionCommandActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("metaclusterDecommissionCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterDecommissionCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterDecommissionCommand", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
};
// This generated class is to be used only via metaclusterDecommissionCommand()
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterDecommissionCommandActor final : public Actor<bool>, public ActorCallback< MetaclusterDecommissionCommandActor, 0, Void >, public FastAllocated<MetaclusterDecommissionCommandActor>, public MetaclusterDecommissionCommandActorState<MetaclusterDecommissionCommandActor> {
															#line 582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
	using FastAllocated<MetaclusterDecommissionCommandActor>::operator new;
	using FastAllocated<MetaclusterDecommissionCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(50368460410413568UL, 13472713164430479104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MetaclusterDecommissionCommandActor, 0, Void >;
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterDecommissionCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		 : Actor<bool>(),
		   MetaclusterDecommissionCommandActorState<MetaclusterDecommissionCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("metaclusterDecommissionCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4514739372312900096UL, 5961389315594209536UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterDecommissionCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("metaclusterDecommissionCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("metaclusterDecommissionCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MetaclusterDecommissionCommandActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
[[nodiscard]] Future<bool> metaclusterDecommissionCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 138 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	return Future<bool>(new MetaclusterDecommissionCommandActor(db, tokens));
															#line 631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
}

#line 151 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"

// metacluster register command
															#line 637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
// This generated class is to be used only via metaclusterRegisterCommand()
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
template <class MetaclusterRegisterCommandActor>
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterRegisterCommandActorState {
															#line 643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterRegisterCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		 : db(db),
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		   tokens(tokens)
															#line 652 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("metaclusterRegisterCommand", reinterpret_cast<unsigned long>(this));

	}
	~MetaclusterRegisterCommandActorState() 
	{
		fdb_probe_actor_destroy("metaclusterRegisterCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 154 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (tokens.size() < 4)
															#line 667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 155 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Usage: metacluster register <NAME> connection_string=<CONNECTION_STRING>\n" "[max_tenant_groups=<NUM_GROUPS> | auto_tenant_assignment=<enabled|disabled>] ...\n\n");
															#line 157 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Adds a data cluster to a metacluster.\n");
															#line 158 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("NAME is used to identify the cluster in future commands.\n");
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				printMetaclusterConfigureOptionsUsage();
															#line 160 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterRegisterCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterRegisterCommandActorState(); static_cast<MetaclusterRegisterCommandActor*>(this)->destroy(); return 0; }
															#line 679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterRegisterCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MetaclusterRegisterCommandActorState();
				static_cast<MetaclusterRegisterCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 163 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			metacluster::DataClusterEntry defaultEntry;
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			auto config = parseClusterConfiguration(tokens, defaultEntry, 3, tokens.size());
															#line 165 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (!config.present())
															#line 691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 166 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterRegisterCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterRegisterCommandActorState(); static_cast<MetaclusterRegisterCommandActor*>(this)->destroy(); return 0; }
															#line 695 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterRegisterCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MetaclusterRegisterCommandActorState();
				static_cast<MetaclusterRegisterCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 167 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!config.get().first.present())
															#line 705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				{
															#line 168 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					fmt::print(stderr, "ERROR: connection_string must be configured when registering a cluster.\n");
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					if (!static_cast<MetaclusterRegisterCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterRegisterCommandActorState(); static_cast<MetaclusterRegisterCommandActor*>(this)->destroy(); return 0; }
															#line 711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
					new (&static_cast<MetaclusterRegisterCommandActor*>(this)->SAV< bool >::value()) bool(false);
					this->~MetaclusterRegisterCommandActorState();
					static_cast<MetaclusterRegisterCommandActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 172 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			StrictFuture<Void> __when_expr_0 = metacluster::registerCluster( db, tokens[2], config.get().first.get(), config.get().second.orDefault(defaultEntry));
															#line 172 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (static_cast<MetaclusterRegisterCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MetaclusterRegisterCommandActor*>(this)->actor_wait_state = 1;
															#line 172 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MetaclusterRegisterCommandActor, 0, Void >*>(static_cast<MetaclusterRegisterCommandActor*>(this)));
															#line 727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MetaclusterRegisterCommandActorState();
		static_cast<MetaclusterRegisterCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 175 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		fmt::print("The cluster `{}' has been added\n", printable(tokens[2]).c_str());
															#line 176 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!static_cast<MetaclusterRegisterCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterRegisterCommandActorState(); static_cast<MetaclusterRegisterCommandActor*>(this)->destroy(); return 0; }
															#line 752 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		new (&static_cast<MetaclusterRegisterCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~MetaclusterRegisterCommandActorState();
		static_cast<MetaclusterRegisterCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 175 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		fmt::print("The cluster `{}' has been added\n", printable(tokens[2]).c_str());
															#line 176 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!static_cast<MetaclusterRegisterCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterRegisterCommandActorState(); static_cast<MetaclusterRegisterCommandActor*>(this)->destroy(); return 0; }
															#line 766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		new (&static_cast<MetaclusterRegisterCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~MetaclusterRegisterCommandActorState();
		static_cast<MetaclusterRegisterCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MetaclusterRegisterCommandActor*>(this)->actor_wait_state > 0) static_cast<MetaclusterRegisterCommandActor*>(this)->actor_wait_state = 0;
		static_cast<MetaclusterRegisterCommandActor*>(this)->ActorCallback< MetaclusterRegisterCommandActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MetaclusterRegisterCommandActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("metaclusterRegisterCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRegisterCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterRegisterCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MetaclusterRegisterCommandActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("metaclusterRegisterCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRegisterCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterRegisterCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MetaclusterRegisterCommandActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("metaclusterRegisterCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRegisterCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterRegisterCommand", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
};
// This generated class is to be used only via metaclusterRegisterCommand()
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterRegisterCommandActor final : public Actor<bool>, public ActorCallback< MetaclusterRegisterCommandActor, 0, Void >, public FastAllocated<MetaclusterRegisterCommandActor>, public MetaclusterRegisterCommandActorState<MetaclusterRegisterCommandActor> {
															#line 858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
	using FastAllocated<MetaclusterRegisterCommandActor>::operator new;
	using FastAllocated<MetaclusterRegisterCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7370530837832389632UL, 12755765580840213248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MetaclusterRegisterCommandActor, 0, Void >;
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterRegisterCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		 : Actor<bool>(),
		   MetaclusterRegisterCommandActorState<MetaclusterRegisterCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("metaclusterRegisterCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16765594928818401280UL, 12806487116004418816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRegisterCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("metaclusterRegisterCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("metaclusterRegisterCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MetaclusterRegisterCommandActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
[[nodiscard]] Future<bool> metaclusterRegisterCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 153 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	return Future<bool>(new MetaclusterRegisterCommandActor(db, tokens));
															#line 907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
}

#line 178 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"

// metacluster remove command
															#line 913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
// This generated class is to be used only via metaclusterRemoveCommand()
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
template <class MetaclusterRemoveCommandActor>
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterRemoveCommandActorState {
															#line 919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterRemoveCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		 : db(db),
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		   tokens(tokens)
															#line 928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this));

	}
	~MetaclusterRemoveCommandActorState() 
	{
		fdb_probe_actor_destroy("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 181 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (tokens.size() < 3 || tokens.size() > 4 || (tokens.size() == 4 && tokens[2] != "FORCE"_sr))
															#line 943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 182 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Usage: metacluster remove [FORCE] <NAME> \n\n");
															#line 183 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Removes the specified data cluster from a metacluster.\n");
															#line 184 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("If FORCE is specified, then the cluster will be detached even if it has\n" "tenants assigned to it.\n");
															#line 186 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("If run on a data cluster, the data cluster will remove its association\n" "with the metacluster without modifying the management cluster. Doing so\n" "requires the FORCE option to be set. Use of this mode is required to\n" "repopulate a management cluster from a data cluster using the\n" "`metacluster restore' command.\n");
															#line 191 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterRemoveCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterRemoveCommandActorState(); static_cast<MetaclusterRemoveCommandActor*>(this)->destroy(); return 0; }
															#line 955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterRemoveCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MetaclusterRemoveCommandActorState();
				static_cast<MetaclusterRemoveCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			clusterName = tokens[tokens.size() - 1];
															#line 196 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			StrictFuture<ClusterType> __when_expr_0 = runTransaction(db, [](Reference<ITransaction> tr) { tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS); return TenantAPI::getClusterType(tr); });
															#line 196 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (static_cast<MetaclusterRemoveCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MetaclusterRemoveCommandActor*>(this)->actor_wait_state = 1;
															#line 196 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MetaclusterRemoveCommandActor, 0, ClusterType >*>(static_cast<MetaclusterRemoveCommandActor*>(this)));
															#line 972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MetaclusterRemoveCommandActorState();
		static_cast<MetaclusterRemoveCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 201 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		metacluster::ForceRemove forceRemove(tokens.size() == 4);
															#line 202 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (clusterType == ClusterType::METACLUSTER_DATA && !forceRemove)
															#line 997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 203 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (tokens[2] == "FORCE"_sr)
															#line 1001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 204 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("ERROR: a cluster name must be specified.\n");
															#line 1005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
			else
			{
															#line 206 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("ERROR: cannot remove a data cluster directly. To remove a data cluster,\n" "use the `remove' command on the management cluster. To force a data cluster\n" "to forget its metacluster association without fully removing it, use FORCE.\n");
															#line 1011 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
															#line 211 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (!static_cast<MetaclusterRemoveCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterRemoveCommandActorState(); static_cast<MetaclusterRemoveCommandActor*>(this)->destroy(); return 0; }
															#line 1015 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			new (&static_cast<MetaclusterRemoveCommandActor*>(this)->SAV< bool >::value()) bool(false);
			this->~MetaclusterRemoveCommandActorState();
			static_cast<MetaclusterRemoveCommandActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 214 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		StrictFuture<bool> __when_expr_1 = metacluster::removeCluster(db, clusterName, clusterType, forceRemove, 15.0);
															#line 214 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (static_cast<MetaclusterRemoveCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MetaclusterRemoveCommandActor*>(this)->actor_wait_state = 2;
															#line 214 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MetaclusterRemoveCommandActor, 1, bool >*>(static_cast<MetaclusterRemoveCommandActor*>(this)));
															#line 1030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(ClusterType const& __clusterType,int loopDepth) 
	{
															#line 196 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		clusterType = __clusterType;
															#line 1039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ClusterType && __clusterType,int loopDepth) 
	{
		clusterType = std::move(__clusterType);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MetaclusterRemoveCommandActor*>(this)->actor_wait_state > 0) static_cast<MetaclusterRemoveCommandActor*>(this)->actor_wait_state = 0;
		static_cast<MetaclusterRemoveCommandActor*>(this)->ActorCallback< MetaclusterRemoveCommandActor, 0, ClusterType >::remove();

	}
	void a_callback_fire(ActorCallback< MetaclusterRemoveCommandActor, 0, ClusterType >*,ClusterType const& value) 
	{
		fdb_probe_actor_enter("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRemoveCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MetaclusterRemoveCommandActor, 0, ClusterType >*,ClusterType && value) 
	{
		fdb_probe_actor_enter("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRemoveCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MetaclusterRemoveCommandActor, 0, ClusterType >*,Error err) 
	{
		fdb_probe_actor_enter("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRemoveCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(bool const& updatedDataCluster,int loopDepth) 
	{
															#line 216 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (clusterType == ClusterType::METACLUSTER_MANAGEMENT)
															#line 1118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 217 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("The cluster `{}' has been removed\n", printable(clusterName).c_str());
															#line 218 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (!updatedDataCluster)
															#line 1124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 219 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("WARNING: the data cluster could not be updated and may still contains its\n" "metacluster registration info. To finish removing it, FORCE remove the\n" "data cluster directly.\n");
															#line 1128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
		}
		else
		{
															#line 224 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			ASSERT(updatedDataCluster);
															#line 225 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("The cluster `{}' has removed its association with its metacluster.\n" "The metacluster has not been modified.\n", printable(clusterName).c_str());
															#line 1137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
															#line 229 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!static_cast<MetaclusterRemoveCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterRemoveCommandActorState(); static_cast<MetaclusterRemoveCommandActor*>(this)->destroy(); return 0; }
															#line 1141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		new (&static_cast<MetaclusterRemoveCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~MetaclusterRemoveCommandActorState();
		static_cast<MetaclusterRemoveCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(bool && updatedDataCluster,int loopDepth) 
	{
															#line 216 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (clusterType == ClusterType::METACLUSTER_MANAGEMENT)
															#line 1153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 217 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("The cluster `{}' has been removed\n", printable(clusterName).c_str());
															#line 218 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (!updatedDataCluster)
															#line 1159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 219 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("WARNING: the data cluster could not be updated and may still contains its\n" "metacluster registration info. To finish removing it, FORCE remove the\n" "data cluster directly.\n");
															#line 1163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
		}
		else
		{
															#line 224 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			ASSERT(updatedDataCluster);
															#line 225 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("The cluster `{}' has removed its association with its metacluster.\n" "The metacluster has not been modified.\n", printable(clusterName).c_str());
															#line 1172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
															#line 229 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!static_cast<MetaclusterRemoveCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterRemoveCommandActorState(); static_cast<MetaclusterRemoveCommandActor*>(this)->destroy(); return 0; }
															#line 1176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		new (&static_cast<MetaclusterRemoveCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~MetaclusterRemoveCommandActorState();
		static_cast<MetaclusterRemoveCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& updatedDataCluster,int loopDepth) 
	{
		loopDepth = a_body1cont3(updatedDataCluster, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && updatedDataCluster,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(updatedDataCluster), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MetaclusterRemoveCommandActor*>(this)->actor_wait_state > 0) static_cast<MetaclusterRemoveCommandActor*>(this)->actor_wait_state = 0;
		static_cast<MetaclusterRemoveCommandActor*>(this)->ActorCallback< MetaclusterRemoveCommandActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< MetaclusterRemoveCommandActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRemoveCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MetaclusterRemoveCommandActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRemoveCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MetaclusterRemoveCommandActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRemoveCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	ClusterNameRef clusterName;
															#line 196 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	ClusterType clusterType;
															#line 1267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
};
// This generated class is to be used only via metaclusterRemoveCommand()
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterRemoveCommandActor final : public Actor<bool>, public ActorCallback< MetaclusterRemoveCommandActor, 0, ClusterType >, public ActorCallback< MetaclusterRemoveCommandActor, 1, bool >, public FastAllocated<MetaclusterRemoveCommandActor>, public MetaclusterRemoveCommandActorState<MetaclusterRemoveCommandActor> {
															#line 1272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
	using FastAllocated<MetaclusterRemoveCommandActor>::operator new;
	using FastAllocated<MetaclusterRemoveCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12170005481277655040UL, 11141840402192583424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MetaclusterRemoveCommandActor, 0, ClusterType >;
friend struct ActorCallback< MetaclusterRemoveCommandActor, 1, bool >;
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterRemoveCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 1290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		 : Actor<bool>(),
		   MetaclusterRemoveCommandActorState<MetaclusterRemoveCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17041724310181688064UL, 12837865934428630016UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRemoveCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("metaclusterRemoveCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("metaclusterRemoveCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MetaclusterRemoveCommandActor, 0, ClusterType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MetaclusterRemoveCommandActor, 1, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
[[nodiscard]] Future<bool> metaclusterRemoveCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	return Future<bool>(new MetaclusterRemoveCommandActor(db, tokens));
															#line 1323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
}

#line 231 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"

void printRestoreUsage() {
	fmt::print(
	    "Usage: metacluster restore <NAME> [dryrun] connection_string=<CONNECTION_STRING>\n"
	    "<restore_known_data_cluster|repopulate_from_data_cluster> [force_join|force_reuse_tenant_id_prefix] ...\n\n");

	fmt::print("Add a restored data cluster back to a metacluster.\n\n");

	fmt::print("Use `dryrun' to report what changes a restore would make and whether any\n");
	fmt::print("failures would occur. Without `dryrun', the restore will modify the metacluster\n");
	fmt::print("with the changes required to perform the restore.\n\n");

	fmt::print("Use `restore_known_data_cluster' to add back a restored copy of a data cluster\n");
	fmt::print("that the metacluster is already tracking. This mode should be used if only data\n");
	fmt::print("clusters are being restored, and any discrepancies between the management and\n");
	fmt::print("data clusters will be resolved using the management cluster metadata.\n");
	fmt::print("If `force_join' is specified, the cluster will try to restore to a different\n");
	fmt::print("metacluster than it was originally registered to or with a different ID than\n");
	fmt::print("is associated with the given cluster name.\n\n");

	fmt::print("Use `repopulate_from_data_cluster' to rebuild a lost management cluster from the\n");
	fmt::print("data clusters in a metacluster. This mode should be used if the management\n");
	fmt::print("cluster is being restored. If any data clusters are also being restored, the\n");
	fmt::print("oldest data clusters should be added first before any non-recovered data\n");
	fmt::print("clusters. Any conflicts arising between the added data cluster and existing data\n");
	fmt::print("will cause the restore to fail. Before repopulating a metacluster from a data\n");
	fmt::print("cluster, that data cluster needs to be detached from its prior metacluster using\n");
	fmt::print("the `metacluster remove' command.\n\n");

	fmt::print("When repopulating a management cluster, it is expected that the new metacluster\n");
	fmt::print("will be configured with a different tenant ID prefix. By default, reusing the same\n");
	fmt::print("prefix will result in an error during the restore process. To override this behavior,\n");
	fmt::print("use `force_reuse_tenant_id_prefix'.\n");
}

// metacluster restore command
															#line 1363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
// This generated class is to be used only via metaclusterRestoreCommand()
															#line 267 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
template <class MetaclusterRestoreCommandActor>
															#line 267 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterRestoreCommandActorState {
															#line 1369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
															#line 267 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterRestoreCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 267 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
															#line 267 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		 : db(db),
															#line 267 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		   tokens(tokens)
															#line 1378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this));

	}
	~MetaclusterRestoreCommandActorState() 
	{
		fdb_probe_actor_destroy("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 268 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (tokens.size() < 5 || tokens.size() > 8)
															#line 1393 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 269 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				printRestoreUsage();
															#line 270 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterRestoreCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterRestoreCommandActorState(); static_cast<MetaclusterRestoreCommandActor*>(this)->destroy(); return 0; }
															#line 1399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterRestoreCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MetaclusterRestoreCommandActorState();
				static_cast<MetaclusterRestoreCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 273 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			dryRun = tokens[3] == "dryrun"_sr;
															#line 274 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			forceJoin = false;
															#line 275 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			forceReuseTenantIdPrefix = false;
															#line 277 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			for(;;) {
															#line 278 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (tokens.back() == "force_join"_sr)
															#line 1415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				{
															#line 279 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					forceJoin = true;
															#line 1419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				}
				else
				{
															#line 280 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					if (tokens.back() == "force_reuse_tenant_id_prefix"_sr)
															#line 1425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
					{
															#line 281 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
						forceReuseTenantIdPrefix = true;
															#line 1429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
					}
					else
					{
						break;
					}
				}
															#line 286 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				tokens.pop_back();
															#line 1438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
															#line 289 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			int expectedTokens = 5 + (dryRun ? 1 : 0);
															#line 290 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (tokens.size() != expectedTokens)
															#line 1444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 291 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				printRestoreUsage();
															#line 292 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterRestoreCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterRestoreCommandActorState(); static_cast<MetaclusterRestoreCommandActor*>(this)->destroy(); return 0; }
															#line 1450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterRestoreCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MetaclusterRestoreCommandActorState();
				static_cast<MetaclusterRestoreCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 295 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			clusterName = tokens[2];
															#line 296 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			restoreType = tokens.back();
															#line 299 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			metacluster::DataClusterEntry defaultEntry;
															#line 300 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			auto config = parseClusterConfiguration(tokens, defaultEntry, expectedTokens - 2, expectedTokens - 1);
															#line 301 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (!config.present())
															#line 1466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 302 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterRestoreCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterRestoreCommandActorState(); static_cast<MetaclusterRestoreCommandActor*>(this)->destroy(); return 0; }
															#line 1470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterRestoreCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MetaclusterRestoreCommandActorState();
				static_cast<MetaclusterRestoreCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 303 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!config.get().first.present())
															#line 1480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				{
															#line 304 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					fmt::print(stderr, "ERROR: connection_string must be configured when registering a cluster.\n");
															#line 305 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					if (!static_cast<MetaclusterRestoreCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterRestoreCommandActorState(); static_cast<MetaclusterRestoreCommandActor*>(this)->destroy(); return 0; }
															#line 1486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
					new (&static_cast<MetaclusterRestoreCommandActor*>(this)->SAV< bool >::value()) bool(false);
					this->~MetaclusterRestoreCommandActorState();
					static_cast<MetaclusterRestoreCommandActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 308 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			messages = std::vector<std::string>();
															#line 309 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			success = true;
															#line 1497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			try {
															#line 312 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (restoreType == "restore_known_data_cluster"_sr)
															#line 1501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				{
															#line 313 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					StrictFuture<Void> __when_expr_0 = metacluster::restoreCluster(db, clusterName, config.get().first.get(), metacluster::ApplyManagementClusterUpdates::True, metacluster::RestoreDryRun(dryRun), metacluster::ForceJoin(forceJoin), metacluster::ForceReuseTenantIdPrefix(forceReuseTenantIdPrefix), &messages);
															#line 313 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					if (static_cast<MetaclusterRestoreCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<MetaclusterRestoreCommandActor*>(this)->actor_wait_state = 1;
															#line 313 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MetaclusterRestoreCommandActor, 0, Void >*>(static_cast<MetaclusterRestoreCommandActor*>(this)));
															#line 1512 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 321 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					if (restoreType == "repopulate_from_data_cluster"_sr)
															#line 1519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
					{
															#line 322 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
						StrictFuture<Void> __when_expr_1 = metacluster::restoreCluster(db, clusterName, config.get().first.get(), metacluster::ApplyManagementClusterUpdates::False, metacluster::RestoreDryRun(dryRun), metacluster::ForceJoin(forceJoin), metacluster::ForceReuseTenantIdPrefix(forceReuseTenantIdPrefix), &messages);
															#line 322 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
						if (static_cast<MetaclusterRestoreCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
						if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
						static_cast<MetaclusterRestoreCommandActor*>(this)->actor_wait_state = 2;
															#line 322 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
						__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MetaclusterRestoreCommandActor, 1, Void >*>(static_cast<MetaclusterRestoreCommandActor*>(this)));
															#line 1530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 331 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
						fmt::print(stderr, "ERROR: unrecognized restore mode `{}'\n", printable(restoreType));
															#line 332 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
						success = false;
															#line 1539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
						loopDepth = a_body1cont14(loopDepth);
					}
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MetaclusterRestoreCommandActorState();
		static_cast<MetaclusterRestoreCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 339 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!messages.empty())
															#line 1570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 340 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print(success ? stdout : stderr, "\nThe restore reported the following messages:\n\n");
															#line 341 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			for(int i = 0;i < messages.size();++i) {
															#line 342 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print(success ? stdout : stderr, "  {}. {}\n", i + 1, messages[i]);
															#line 1578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
															#line 345 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (success)
															#line 1582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 346 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("\n");
															#line 1586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
		}
															#line 350 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (success)
															#line 1591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 351 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (dryRun)
															#line 1595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 352 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("The restore dry run completed successfully. To perform the restore, run the same command\n");
															#line 353 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("without the `dryrun' argument.\n");
															#line 1601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
			else
			{
															#line 355 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("The cluster `{}' has been restored\n", printable(clusterName).c_str());
															#line 1607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
		}
															#line 359 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!static_cast<MetaclusterRestoreCommandActor*>(this)->SAV<bool>::futures) { (void)(success); this->~MetaclusterRestoreCommandActorState(); static_cast<MetaclusterRestoreCommandActor*>(this)->destroy(); return 0; }
															#line 1612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		new (&static_cast<MetaclusterRestoreCommandActor*>(this)->SAV< bool >::value()) bool(std::move(success)); // state_var_RVO
		this->~MetaclusterRestoreCommandActorState();
		static_cast<MetaclusterRestoreCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 335 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			success = false;
															#line 336 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print(stderr, "ERROR: {} ({})\n", e.what(), e.code());
															#line 1627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MetaclusterRestoreCommandActor*>(this)->actor_wait_state > 0) static_cast<MetaclusterRestoreCommandActor*>(this)->actor_wait_state = 0;
		static_cast<MetaclusterRestoreCommandActor*>(this)->ActorCallback< MetaclusterRestoreCommandActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MetaclusterRestoreCommandActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRestoreCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MetaclusterRestoreCommandActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRestoreCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MetaclusterRestoreCommandActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRestoreCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont14(int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont15(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont15(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MetaclusterRestoreCommandActor*>(this)->actor_wait_state > 0) static_cast<MetaclusterRestoreCommandActor*>(this)->actor_wait_state = 0;
		static_cast<MetaclusterRestoreCommandActor*>(this)->ActorCallback< MetaclusterRestoreCommandActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MetaclusterRestoreCommandActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRestoreCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MetaclusterRestoreCommandActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRestoreCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MetaclusterRestoreCommandActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRestoreCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 267 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 267 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 273 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	bool dryRun;
															#line 274 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	bool forceJoin;
															#line 275 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	bool forceReuseTenantIdPrefix;
															#line 295 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	ClusterName clusterName;
															#line 296 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	StringRef restoreType;
															#line 308 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	std::vector<std::string> messages;
															#line 309 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	bool success;
															#line 1855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
};
// This generated class is to be used only via metaclusterRestoreCommand()
															#line 267 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterRestoreCommandActor final : public Actor<bool>, public ActorCallback< MetaclusterRestoreCommandActor, 0, Void >, public ActorCallback< MetaclusterRestoreCommandActor, 1, Void >, public FastAllocated<MetaclusterRestoreCommandActor>, public MetaclusterRestoreCommandActorState<MetaclusterRestoreCommandActor> {
															#line 1860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
	using FastAllocated<MetaclusterRestoreCommandActor>::operator new;
	using FastAllocated<MetaclusterRestoreCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3536563707598186240UL, 1364791333675139840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MetaclusterRestoreCommandActor, 0, Void >;
friend struct ActorCallback< MetaclusterRestoreCommandActor, 1, Void >;
															#line 267 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterRestoreCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 1878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		 : Actor<bool>(),
		   MetaclusterRestoreCommandActorState<MetaclusterRestoreCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10900587210149291776UL, 12394321387579238912UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterRestoreCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("metaclusterRestoreCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("metaclusterRestoreCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MetaclusterRestoreCommandActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MetaclusterRestoreCommandActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 267 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
[[nodiscard]] Future<bool> metaclusterRestoreCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 267 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	return Future<bool>(new MetaclusterRestoreCommandActor(db, tokens));
															#line 1911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
}

#line 361 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"

// metacluster configure command
															#line 1917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
// This generated class is to be used only via metaclusterConfigureCommand()
															#line 363 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
template <class MetaclusterConfigureCommandActor>
															#line 363 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterConfigureCommandActorState {
															#line 1923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
															#line 363 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterConfigureCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 363 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
															#line 363 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		 : db(db),
															#line 363 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		   tokens(tokens)
															#line 1932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this));

	}
	~MetaclusterConfigureCommandActorState() 
	{
		fdb_probe_actor_destroy("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 364 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (tokens.size() < 4)
															#line 1947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 365 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Usage: metacluster configure <NAME> <max_tenant_groups=<NUM_GROUPS>|\n" "connection_string=<CONNECTION_STRING>|\n" "auto_tenant_assignment=<enabled|disabled>> ...\n\n");
															#line 368 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Updates the configuration of the metacluster.\n");
															#line 369 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				printMetaclusterConfigureOptionsUsage();
															#line 370 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterConfigureCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterConfigureCommandActorState(); static_cast<MetaclusterConfigureCommandActor*>(this)->destroy(); return 0; }
															#line 1957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterConfigureCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MetaclusterConfigureCommandActorState();
				static_cast<MetaclusterConfigureCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 373 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			tr = db->createTransaction();
															#line 375 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			;
															#line 1967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MetaclusterConfigureCommandActorState();
		static_cast<MetaclusterConfigureCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 399 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!static_cast<MetaclusterConfigureCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterConfigureCommandActorState(); static_cast<MetaclusterConfigureCommandActor*>(this)->destroy(); return 0; }
															#line 1990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		new (&static_cast<MetaclusterConfigureCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~MetaclusterConfigureCommandActorState();
		static_cast<MetaclusterConfigureCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 377 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 378 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 379 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			StrictFuture<Optional<metacluster::DataClusterMetadata>> __when_expr_0 = metacluster::tryGetClusterTransaction(tr, tokens[2]);
															#line 379 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (static_cast<MetaclusterConfigureCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MetaclusterConfigureCommandActor*>(this)->actor_wait_state = 1;
															#line 379 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MetaclusterConfigureCommandActor, 0, Optional<metacluster::DataClusterMetadata> >*>(static_cast<MetaclusterConfigureCommandActor*>(this)));
															#line 2021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 395 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 395 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (static_cast<MetaclusterConfigureCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<MetaclusterConfigureCommandActor*>(this)->actor_wait_state = 3;
															#line 395 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MetaclusterConfigureCommandActor, 2, Void >*>(static_cast<MetaclusterConfigureCommandActor*>(this)));
															#line 2063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<metacluster::DataClusterMetadata> const& metadata,int loopDepth) 
	{
															#line 381 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!metadata.present())
															#line 2078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 382 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			return a_body1loopBody1Catch1(cluster_not_found(), loopDepth);
															#line 2082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
															#line 385 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		auto config = parseClusterConfiguration(tokens, metadata.get().entry, 3, tokens.size());
															#line 386 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!config.present())
															#line 2088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 387 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (!static_cast<MetaclusterConfigureCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterConfigureCommandActorState(); static_cast<MetaclusterConfigureCommandActor*>(this)->destroy(); return 0; }
															#line 2092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			new (&static_cast<MetaclusterConfigureCommandActor*>(this)->SAV< bool >::value()) bool(false);
			this->~MetaclusterConfigureCommandActorState();
			static_cast<MetaclusterConfigureCommandActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 390 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		metacluster::updateClusterMetadata(tr, tokens[2], metadata.get(), config.get().first, config.get().second);
															#line 392 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 392 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (static_cast<MetaclusterConfigureCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MetaclusterConfigureCommandActor*>(this)->actor_wait_state = 2;
															#line 392 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MetaclusterConfigureCommandActor, 1, Void >*>(static_cast<MetaclusterConfigureCommandActor*>(this)));
															#line 2109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<metacluster::DataClusterMetadata> && metadata,int loopDepth) 
	{
															#line 381 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!metadata.present())
															#line 2118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 382 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			return a_body1loopBody1Catch1(cluster_not_found(), loopDepth);
															#line 2122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
															#line 385 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		auto config = parseClusterConfiguration(tokens, metadata.get().entry, 3, tokens.size());
															#line 386 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!config.present())
															#line 2128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 387 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (!static_cast<MetaclusterConfigureCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterConfigureCommandActorState(); static_cast<MetaclusterConfigureCommandActor*>(this)->destroy(); return 0; }
															#line 2132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			new (&static_cast<MetaclusterConfigureCommandActor*>(this)->SAV< bool >::value()) bool(false);
			this->~MetaclusterConfigureCommandActorState();
			static_cast<MetaclusterConfigureCommandActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 390 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		metacluster::updateClusterMetadata(tr, tokens[2], metadata.get(), config.get().first, config.get().second);
															#line 392 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 392 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (static_cast<MetaclusterConfigureCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MetaclusterConfigureCommandActor*>(this)->actor_wait_state = 2;
															#line 392 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MetaclusterConfigureCommandActor, 1, Void >*>(static_cast<MetaclusterConfigureCommandActor*>(this)));
															#line 2149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<metacluster::DataClusterMetadata> const& metadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(metadata, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<metacluster::DataClusterMetadata> && metadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(metadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MetaclusterConfigureCommandActor*>(this)->actor_wait_state > 0) static_cast<MetaclusterConfigureCommandActor*>(this)->actor_wait_state = 0;
		static_cast<MetaclusterConfigureCommandActor*>(this)->ActorCallback< MetaclusterConfigureCommandActor, 0, Optional<metacluster::DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< MetaclusterConfigureCommandActor, 0, Optional<metacluster::DataClusterMetadata> >*,Optional<metacluster::DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MetaclusterConfigureCommandActor, 0, Optional<metacluster::DataClusterMetadata> >*,Optional<metacluster::DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MetaclusterConfigureCommandActor, 0, Optional<metacluster::DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MetaclusterConfigureCommandActor*>(this)->actor_wait_state > 0) static_cast<MetaclusterConfigureCommandActor*>(this)->actor_wait_state = 0;
		static_cast<MetaclusterConfigureCommandActor*>(this)->ActorCallback< MetaclusterConfigureCommandActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MetaclusterConfigureCommandActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MetaclusterConfigureCommandActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MetaclusterConfigureCommandActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MetaclusterConfigureCommandActor*>(this)->actor_wait_state > 0) static_cast<MetaclusterConfigureCommandActor*>(this)->actor_wait_state = 0;
		static_cast<MetaclusterConfigureCommandActor*>(this)->ActorCallback< MetaclusterConfigureCommandActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MetaclusterConfigureCommandActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MetaclusterConfigureCommandActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MetaclusterConfigureCommandActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 363 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 363 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 373 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	Reference<ITransaction> tr;
															#line 2409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
};
// This generated class is to be used only via metaclusterConfigureCommand()
															#line 363 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterConfigureCommandActor final : public Actor<bool>, public ActorCallback< MetaclusterConfigureCommandActor, 0, Optional<metacluster::DataClusterMetadata> >, public ActorCallback< MetaclusterConfigureCommandActor, 1, Void >, public ActorCallback< MetaclusterConfigureCommandActor, 2, Void >, public FastAllocated<MetaclusterConfigureCommandActor>, public MetaclusterConfigureCommandActorState<MetaclusterConfigureCommandActor> {
															#line 2414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
	using FastAllocated<MetaclusterConfigureCommandActor>::operator new;
	using FastAllocated<MetaclusterConfigureCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12420207812172772608UL, 6051652955859182336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MetaclusterConfigureCommandActor, 0, Optional<metacluster::DataClusterMetadata> >;
friend struct ActorCallback< MetaclusterConfigureCommandActor, 1, Void >;
friend struct ActorCallback< MetaclusterConfigureCommandActor, 2, Void >;
															#line 363 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterConfigureCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 2433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		 : Actor<bool>(),
		   MetaclusterConfigureCommandActorState<MetaclusterConfigureCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7569231891212270592UL, 3775659361026018816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterConfigureCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("metaclusterConfigureCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("metaclusterConfigureCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MetaclusterConfigureCommandActor, 0, Optional<metacluster::DataClusterMetadata> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MetaclusterConfigureCommandActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MetaclusterConfigureCommandActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 363 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
[[nodiscard]] Future<bool> metaclusterConfigureCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 363 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	return Future<bool>(new MetaclusterConfigureCommandActor(db, tokens));
															#line 2467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
}

#line 401 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"

// metacluster list command
															#line 2473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
// This generated class is to be used only via metaclusterListCommand()
															#line 403 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
template <class MetaclusterListCommandActor>
															#line 403 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterListCommandActorState {
															#line 2479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
															#line 403 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterListCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 403 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
															#line 403 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		 : db(db),
															#line 403 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		   tokens(tokens)
															#line 2488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("metaclusterListCommand", reinterpret_cast<unsigned long>(this));

	}
	~MetaclusterListCommandActorState() 
	{
		fdb_probe_actor_destroy("metaclusterListCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 404 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (tokens.size() > 5)
															#line 2503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 405 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Usage: metacluster list [BEGIN] [END] [LIMIT]\n\n");
															#line 406 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Lists the data clusters in a metacluster.\n");
															#line 407 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Only cluster names in the range BEGIN - END will be printed.\n");
															#line 408 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("An optional LIMIT can be specified to limit the number of results (default 100).\n");
															#line 409 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterListCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterListCommandActorState(); static_cast<MetaclusterListCommandActor*>(this)->destroy(); return 0; }
															#line 2515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterListCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MetaclusterListCommandActorState();
				static_cast<MetaclusterListCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 412 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			begin = tokens.size() > 2 ? tokens[2] : ""_sr;
															#line 413 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			end = tokens.size() > 3 ? tokens[3] : "\xff"_sr;
															#line 414 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			int limit = 100;
															#line 416 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (tokens.size() > 4)
															#line 2529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 417 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				int n = 0;
															#line 418 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (sscanf(tokens[3].toString().c_str(), "%d%n", &limit, &n) != 1 || n != tokens[3].size() || limit < 0)
															#line 2535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				{
															#line 419 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					fmt::print(stderr, "ERROR: invalid limit {}\n", tokens[3].toString().c_str());
															#line 420 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					if (!static_cast<MetaclusterListCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterListCommandActorState(); static_cast<MetaclusterListCommandActor*>(this)->destroy(); return 0; }
															#line 2541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
					new (&static_cast<MetaclusterListCommandActor*>(this)->SAV< bool >::value()) bool(false);
					this->~MetaclusterListCommandActorState();
					static_cast<MetaclusterListCommandActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 424 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			StrictFuture<std::map<ClusterName, metacluster::DataClusterMetadata>> __when_expr_0 = metacluster::listClusters(db, begin, end, limit);
															#line 424 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (static_cast<MetaclusterListCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MetaclusterListCommandActor*>(this)->actor_wait_state = 1;
															#line 424 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MetaclusterListCommandActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*>(static_cast<MetaclusterListCommandActor*>(this)));
															#line 2557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MetaclusterListCommandActorState();
		static_cast<MetaclusterListCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::map<ClusterName, metacluster::DataClusterMetadata> const& clusters,int loopDepth) 
	{
															#line 426 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (clusters.empty())
															#line 2580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 427 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (tokens.size() == 2)
															#line 2584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 428 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("The metacluster has no registered data clusters\n");
															#line 2588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
			else
			{
															#line 430 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("The metacluster has no registered data clusters in the specified range\n");
															#line 2594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
		}
															#line 434 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		int index = 0;
															#line 435 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		for( auto cluster : clusters ) {
															#line 436 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  {}. {}\n", ++index, printable(cluster.first).c_str());
															#line 2603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
															#line 439 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!static_cast<MetaclusterListCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterListCommandActorState(); static_cast<MetaclusterListCommandActor*>(this)->destroy(); return 0; }
															#line 2607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		new (&static_cast<MetaclusterListCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~MetaclusterListCommandActorState();
		static_cast<MetaclusterListCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::map<ClusterName, metacluster::DataClusterMetadata> && clusters,int loopDepth) 
	{
															#line 426 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (clusters.empty())
															#line 2619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 427 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (tokens.size() == 2)
															#line 2623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 428 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("The metacluster has no registered data clusters\n");
															#line 2627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
			else
			{
															#line 430 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("The metacluster has no registered data clusters in the specified range\n");
															#line 2633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
		}
															#line 434 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		int index = 0;
															#line 435 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		for( auto cluster : clusters ) {
															#line 436 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  {}. {}\n", ++index, printable(cluster.first).c_str());
															#line 2642 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
															#line 439 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!static_cast<MetaclusterListCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterListCommandActorState(); static_cast<MetaclusterListCommandActor*>(this)->destroy(); return 0; }
															#line 2646 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		new (&static_cast<MetaclusterListCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~MetaclusterListCommandActorState();
		static_cast<MetaclusterListCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::map<ClusterName, metacluster::DataClusterMetadata> const& clusters,int loopDepth) 
	{
		loopDepth = a_body1cont1(clusters, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::map<ClusterName, metacluster::DataClusterMetadata> && clusters,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(clusters), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MetaclusterListCommandActor*>(this)->actor_wait_state > 0) static_cast<MetaclusterListCommandActor*>(this)->actor_wait_state = 0;
		static_cast<MetaclusterListCommandActor*>(this)->ActorCallback< MetaclusterListCommandActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< MetaclusterListCommandActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*,std::map<ClusterName, metacluster::DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("metaclusterListCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterListCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MetaclusterListCommandActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*,std::map<ClusterName, metacluster::DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("metaclusterListCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterListCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MetaclusterListCommandActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("metaclusterListCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterListCommand", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 403 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 403 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 412 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	ClusterNameRef begin;
															#line 413 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	ClusterNameRef end;
															#line 2737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
};
// This generated class is to be used only via metaclusterListCommand()
															#line 403 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterListCommandActor final : public Actor<bool>, public ActorCallback< MetaclusterListCommandActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >, public FastAllocated<MetaclusterListCommandActor>, public MetaclusterListCommandActorState<MetaclusterListCommandActor> {
															#line 2742 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
	using FastAllocated<MetaclusterListCommandActor>::operator new;
	using FastAllocated<MetaclusterListCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4209084309797728000UL, 7316321899668949248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MetaclusterListCommandActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >;
															#line 403 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterListCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 2759 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		 : Actor<bool>(),
		   MetaclusterListCommandActorState<MetaclusterListCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("metaclusterListCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18097409105580733440UL, 16785647420936323072UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterListCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("metaclusterListCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("metaclusterListCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MetaclusterListCommandActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 403 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
[[nodiscard]] Future<bool> metaclusterListCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 403 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	return Future<bool>(new MetaclusterListCommandActor(db, tokens));
															#line 2791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
}

#line 441 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"

// metacluster get command
															#line 2797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
// This generated class is to be used only via metaclusterGetCommand()
															#line 443 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
template <class MetaclusterGetCommandActor>
															#line 443 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterGetCommandActorState {
															#line 2803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
															#line 443 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterGetCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 443 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
															#line 443 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		 : db(db),
															#line 443 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		   tokens(tokens)
															#line 2812 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("metaclusterGetCommand", reinterpret_cast<unsigned long>(this));

	}
	~MetaclusterGetCommandActorState() 
	{
		fdb_probe_actor_destroy("metaclusterGetCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 444 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (tokens.size() > 4 || tokens.size() < 3 || (tokens.size() == 4 && tokens[3] != "JSON"_sr))
															#line 2827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 445 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Usage: metacluster get <NAME> [JSON]\n\n");
															#line 446 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Prints metadata associated with the given data cluster.\n");
															#line 447 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("If JSON is specified, then the output will be in JSON format.\n");
															#line 448 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterGetCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterGetCommandActorState(); static_cast<MetaclusterGetCommandActor*>(this)->destroy(); return 0; }
															#line 2837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterGetCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MetaclusterGetCommandActorState();
				static_cast<MetaclusterGetCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 451 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			useJson = tokens.size() == 4;
															#line 2845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			try {
															#line 454 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				StrictFuture<metacluster::DataClusterMetadata> __when_expr_0 = metacluster::getCluster(db, tokens[2]);
															#line 454 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (static_cast<MetaclusterGetCommandActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<MetaclusterGetCommandActor*>(this)->actor_wait_state = 1;
															#line 454 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MetaclusterGetCommandActor, 0, metacluster::DataClusterMetadata >*>(static_cast<MetaclusterGetCommandActor*>(this)));
															#line 2856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MetaclusterGetCommandActorState();
		static_cast<MetaclusterGetCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 484 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!static_cast<MetaclusterGetCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterGetCommandActorState(); static_cast<MetaclusterGetCommandActor*>(this)->destroy(); return 0; }
															#line 2885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		new (&static_cast<MetaclusterGetCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~MetaclusterGetCommandActorState();
		static_cast<MetaclusterGetCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 473 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (useJson)
															#line 2898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 474 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				json_spirit::mObject obj;
															#line 475 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				obj[msgTypeKey] = "error";
															#line 476 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				obj[msgErrorKey] = e.what();
															#line 477 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("{}\n", json_spirit::write_string(json_spirit::mValue(obj), json_spirit::pretty_print).c_str());
															#line 478 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterGetCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterGetCommandActorState(); static_cast<MetaclusterGetCommandActor*>(this)->destroy(); return 0; }
															#line 2910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterGetCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MetaclusterGetCommandActorState();
				static_cast<MetaclusterGetCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 480 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(metacluster::DataClusterMetadata const& metadata,int loopDepth) 
	{
															#line 456 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (useJson)
															#line 2935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 457 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			json_spirit::mObject obj;
															#line 458 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			obj[msgTypeKey] = "success";
															#line 459 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			obj[msgClusterKey] = metadata.toJson();
															#line 460 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("{}\n", json_spirit::write_string(json_spirit::mValue(obj), json_spirit::pretty_print).c_str());
															#line 2945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
		else
		{
															#line 462 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  id: {}\n", metadata.entry.id.toString().c_str());
															#line 463 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  connection string: {}\n", metadata.connectionString.toString().c_str());
															#line 464 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  cluster state: {}\n", metacluster::DataClusterEntry::clusterStateToString(metadata.entry.clusterState));
															#line 466 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  tenant group capacity: {}\n", metadata.entry.capacity.numTenantGroups);
															#line 467 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  allocated tenant groups: {}\n", metadata.entry.allocated.numTenantGroups);
															#line 468 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print( "  auto tenant assignment: {}\n", metacluster::DataClusterEntry::autoTenantAssignmentToString(metadata.entry.autoTenantAssignment));
															#line 2961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(metacluster::DataClusterMetadata && metadata,int loopDepth) 
	{
															#line 456 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (useJson)
															#line 2971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 457 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			json_spirit::mObject obj;
															#line 458 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			obj[msgTypeKey] = "success";
															#line 459 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			obj[msgClusterKey] = metadata.toJson();
															#line 460 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("{}\n", json_spirit::write_string(json_spirit::mValue(obj), json_spirit::pretty_print).c_str());
															#line 2981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
		else
		{
															#line 462 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  id: {}\n", metadata.entry.id.toString().c_str());
															#line 463 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  connection string: {}\n", metadata.connectionString.toString().c_str());
															#line 464 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  cluster state: {}\n", metacluster::DataClusterEntry::clusterStateToString(metadata.entry.clusterState));
															#line 466 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  tenant group capacity: {}\n", metadata.entry.capacity.numTenantGroups);
															#line 467 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  allocated tenant groups: {}\n", metadata.entry.allocated.numTenantGroups);
															#line 468 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print( "  auto tenant assignment: {}\n", metacluster::DataClusterEntry::autoTenantAssignmentToString(metadata.entry.autoTenantAssignment));
															#line 2997 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1when1(metacluster::DataClusterMetadata const& metadata,int loopDepth) 
	{
		loopDepth = a_body1cont3(metadata, loopDepth);

		return loopDepth;
	}
	int a_body1when1(metacluster::DataClusterMetadata && metadata,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(metadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MetaclusterGetCommandActor*>(this)->actor_wait_state > 0) static_cast<MetaclusterGetCommandActor*>(this)->actor_wait_state = 0;
		static_cast<MetaclusterGetCommandActor*>(this)->ActorCallback< MetaclusterGetCommandActor, 0, metacluster::DataClusterMetadata >::remove();

	}
	void a_callback_fire(ActorCallback< MetaclusterGetCommandActor, 0, metacluster::DataClusterMetadata >*,metacluster::DataClusterMetadata const& value) 
	{
		fdb_probe_actor_enter("metaclusterGetCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterGetCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MetaclusterGetCommandActor, 0, metacluster::DataClusterMetadata >*,metacluster::DataClusterMetadata && value) 
	{
		fdb_probe_actor_enter("metaclusterGetCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterGetCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MetaclusterGetCommandActor, 0, metacluster::DataClusterMetadata >*,Error err) 
	{
		fdb_probe_actor_enter("metaclusterGetCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterGetCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 443 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 443 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 451 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	bool useJson;
															#line 3097 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
};
// This generated class is to be used only via metaclusterGetCommand()
															#line 443 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterGetCommandActor final : public Actor<bool>, public ActorCallback< MetaclusterGetCommandActor, 0, metacluster::DataClusterMetadata >, public FastAllocated<MetaclusterGetCommandActor>, public MetaclusterGetCommandActorState<MetaclusterGetCommandActor> {
															#line 3102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
	using FastAllocated<MetaclusterGetCommandActor>::operator new;
	using FastAllocated<MetaclusterGetCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10060567315370788864UL, 11574770141808801536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MetaclusterGetCommandActor, 0, metacluster::DataClusterMetadata >;
															#line 443 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterGetCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 3119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		 : Actor<bool>(),
		   MetaclusterGetCommandActorState<MetaclusterGetCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("metaclusterGetCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1129192640163284992UL, 17376949306834362368UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterGetCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("metaclusterGetCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("metaclusterGetCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MetaclusterGetCommandActor, 0, metacluster::DataClusterMetadata >*)0, actor_cancelled()); break;
		}

	}
};
															#line 443 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
[[nodiscard]] Future<bool> metaclusterGetCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 443 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	return Future<bool>(new MetaclusterGetCommandActor(db, tokens));
															#line 3151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
}

#line 486 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"

// metacluster status command
															#line 3157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
// This generated class is to be used only via metaclusterStatusCommand()
															#line 488 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
template <class MetaclusterStatusCommandActor>
															#line 488 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterStatusCommandActorState {
															#line 3163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
															#line 488 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterStatusCommandActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 488 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
															#line 488 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		 : db(db),
															#line 488 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		   tokens(tokens)
															#line 3172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
	{
		fdb_probe_actor_create("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this));

	}
	~MetaclusterStatusCommandActorState() 
	{
		fdb_probe_actor_destroy("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 489 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (tokens.size() < 2 || tokens.size() > 3)
															#line 3187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 490 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Usage: metacluster status [JSON]\n\n");
															#line 491 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("Prints metacluster metadata.\n");
															#line 492 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("If JSON is specified, then the output will be in JSON format.\n");
															#line 493 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterStatusCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterStatusCommandActorState(); static_cast<MetaclusterStatusCommandActor*>(this)->destroy(); return 0; }
															#line 3197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterStatusCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MetaclusterStatusCommandActorState();
				static_cast<MetaclusterStatusCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 496 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			useJson = tokens.size() == 3;
															#line 498 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			metaclusterName = Optional<std::string>();
															#line 500 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			tr = db->createTransaction();
															#line 502 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			;
															#line 3211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MetaclusterStatusCommandActorState();
		static_cast<MetaclusterStatusCommandActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 504 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 505 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_0 = metacluster::metadata::metaclusterRegistration().get(tr);
															#line 505 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (static_cast<MetaclusterStatusCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MetaclusterStatusCommandActor*>(this)->actor_wait_state = 1;
															#line 505 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MetaclusterStatusCommandActor, 0, Optional<MetaclusterRegistrationEntry> >*>(static_cast<MetaclusterStatusCommandActor*>(this)));
															#line 3251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 572 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (useJson)
															#line 3267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 573 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				json_spirit::mObject obj;
															#line 574 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				obj[msgTypeKey] = "error";
															#line 575 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				obj[msgErrorKey] = e.what();
															#line 576 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("{}\n", json_spirit::write_string(json_spirit::mValue(obj), json_spirit::pretty_print).c_str());
															#line 578 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterStatusCommandActor*>(this)->SAV<bool>::futures) { (void)(false); this->~MetaclusterStatusCommandActorState(); static_cast<MetaclusterStatusCommandActor*>(this)->destroy(); return 0; }
															#line 3279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterStatusCommandActor*>(this)->SAV< bool >::value()) bool(false);
				this->~MetaclusterStatusCommandActorState();
				static_cast<MetaclusterStatusCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 580 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 3289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<MetaclusterRegistrationEntry> const& registrationEntry,int loopDepth) 
	{
															#line 507 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		const ClusterType clusterType = !registrationEntry.present() ? ClusterType::STANDALONE : registrationEntry.get().clusterType;
															#line 509 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (ClusterType::STANDALONE == clusterType)
															#line 3306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 510 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (useJson)
															#line 3310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 511 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				json_spirit::mObject obj;
															#line 512 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				obj[msgTypeKey] = "success";
															#line 513 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				obj[msgClusterTypeKey] = clusterTypeToString(clusterType);
															#line 514 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("{}\n", json_spirit::write_string(json_spirit::mValue(obj), json_spirit::pretty_print).c_str());
															#line 3320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
			else
			{
															#line 517 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("This cluster is not part of a metacluster\n");
															#line 3326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
															#line 519 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (!static_cast<MetaclusterStatusCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterStatusCommandActorState(); static_cast<MetaclusterStatusCommandActor*>(this)->destroy(); return 0; }
															#line 3330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			new (&static_cast<MetaclusterStatusCommandActor*>(this)->SAV< bool >::value()) bool(true);
			this->~MetaclusterStatusCommandActorState();
			static_cast<MetaclusterStatusCommandActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 520 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (ClusterType::METACLUSTER_DATA == clusterType)
															#line 3340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 521 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				ASSERT(registrationEntry.present());
															#line 522 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				metaclusterName = registrationEntry.get().metaclusterName.toString();
															#line 523 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (useJson)
															#line 3348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				{
															#line 524 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					json_spirit::mObject obj;
															#line 525 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					obj[msgTypeKey] = "success";
															#line 526 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					obj[msgClusterTypeKey] = clusterTypeToString(clusterType);
															#line 527 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					json_spirit::mObject metaclusterObj;
															#line 528 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					metaclusterObj[msgMetaclusterName] = metaclusterName.get();
															#line 529 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					obj[msgMetaclusterKey] = metaclusterObj;
															#line 530 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					fmt::print("{}\n", json_spirit::write_string(json_spirit::mValue(obj), json_spirit::pretty_print).c_str());
															#line 3364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				}
				else
				{
															#line 533 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					fmt::print("This cluster \"{}\" is a data cluster within the metacluster named \"{}\"\n", registrationEntry.get().name.toString().c_str(), metaclusterName.get().c_str());
															#line 3370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				}
															#line 537 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterStatusCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterStatusCommandActorState(); static_cast<MetaclusterStatusCommandActor*>(this)->destroy(); return 0; }
															#line 3374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterStatusCommandActor*>(this)->SAV< bool >::value()) bool(true);
				this->~MetaclusterStatusCommandActorState();
				static_cast<MetaclusterStatusCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 540 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		metaclusterName = registrationEntry.get().metaclusterName.toString();
															#line 542 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		ASSERT(ClusterType::METACLUSTER_MANAGEMENT == clusterType);
															#line 543 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		StrictFuture<std::map<ClusterName, metacluster::DataClusterMetadata>> __when_expr_1 = metacluster::listClustersTransaction(tr, ""_sr, "\xff"_sr, CLIENT_KNOBS->MAX_DATA_CLUSTERS);
															#line 543 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (static_cast<MetaclusterStatusCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MetaclusterStatusCommandActor*>(this)->actor_wait_state = 2;
															#line 543 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MetaclusterStatusCommandActor, 1, std::map<ClusterName, metacluster::DataClusterMetadata> >*>(static_cast<MetaclusterStatusCommandActor*>(this)));
															#line 3394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<MetaclusterRegistrationEntry> && registrationEntry,int loopDepth) 
	{
															#line 507 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		const ClusterType clusterType = !registrationEntry.present() ? ClusterType::STANDALONE : registrationEntry.get().clusterType;
															#line 509 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (ClusterType::STANDALONE == clusterType)
															#line 3405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 510 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (useJson)
															#line 3409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 511 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				json_spirit::mObject obj;
															#line 512 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				obj[msgTypeKey] = "success";
															#line 513 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				obj[msgClusterTypeKey] = clusterTypeToString(clusterType);
															#line 514 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("{}\n", json_spirit::write_string(json_spirit::mValue(obj), json_spirit::pretty_print).c_str());
															#line 3419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
			else
			{
															#line 517 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				fmt::print("This cluster is not part of a metacluster\n");
															#line 3425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			}
															#line 519 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (!static_cast<MetaclusterStatusCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterStatusCommandActorState(); static_cast<MetaclusterStatusCommandActor*>(this)->destroy(); return 0; }
															#line 3429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			new (&static_cast<MetaclusterStatusCommandActor*>(this)->SAV< bool >::value()) bool(true);
			this->~MetaclusterStatusCommandActorState();
			static_cast<MetaclusterStatusCommandActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 520 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			if (ClusterType::METACLUSTER_DATA == clusterType)
															#line 3439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
			{
															#line 521 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				ASSERT(registrationEntry.present());
															#line 522 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				metaclusterName = registrationEntry.get().metaclusterName.toString();
															#line 523 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (useJson)
															#line 3447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				{
															#line 524 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					json_spirit::mObject obj;
															#line 525 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					obj[msgTypeKey] = "success";
															#line 526 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					obj[msgClusterTypeKey] = clusterTypeToString(clusterType);
															#line 527 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					json_spirit::mObject metaclusterObj;
															#line 528 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					metaclusterObj[msgMetaclusterName] = metaclusterName.get();
															#line 529 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					obj[msgMetaclusterKey] = metaclusterObj;
															#line 530 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					fmt::print("{}\n", json_spirit::write_string(json_spirit::mValue(obj), json_spirit::pretty_print).c_str());
															#line 3463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				}
				else
				{
															#line 533 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
					fmt::print("This cluster \"{}\" is a data cluster within the metacluster named \"{}\"\n", registrationEntry.get().name.toString().c_str(), metaclusterName.get().c_str());
															#line 3469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				}
															#line 537 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
				if (!static_cast<MetaclusterStatusCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterStatusCommandActorState(); static_cast<MetaclusterStatusCommandActor*>(this)->destroy(); return 0; }
															#line 3473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
				new (&static_cast<MetaclusterStatusCommandActor*>(this)->SAV< bool >::value()) bool(true);
				this->~MetaclusterStatusCommandActorState();
				static_cast<MetaclusterStatusCommandActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 540 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		metaclusterName = registrationEntry.get().metaclusterName.toString();
															#line 542 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		ASSERT(ClusterType::METACLUSTER_MANAGEMENT == clusterType);
															#line 543 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		StrictFuture<std::map<ClusterName, metacluster::DataClusterMetadata>> __when_expr_1 = metacluster::listClustersTransaction(tr, ""_sr, "\xff"_sr, CLIENT_KNOBS->MAX_DATA_CLUSTERS);
															#line 543 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (static_cast<MetaclusterStatusCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MetaclusterStatusCommandActor*>(this)->actor_wait_state = 2;
															#line 543 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MetaclusterStatusCommandActor, 1, std::map<ClusterName, metacluster::DataClusterMetadata> >*>(static_cast<MetaclusterStatusCommandActor*>(this)));
															#line 3493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<MetaclusterRegistrationEntry> const& registrationEntry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(registrationEntry, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<MetaclusterRegistrationEntry> && registrationEntry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(registrationEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MetaclusterStatusCommandActor*>(this)->actor_wait_state > 0) static_cast<MetaclusterStatusCommandActor*>(this)->actor_wait_state = 0;
		static_cast<MetaclusterStatusCommandActor*>(this)->ActorCallback< MetaclusterStatusCommandActor, 0, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< MetaclusterStatusCommandActor, 0, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterStatusCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MetaclusterStatusCommandActor, 0, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterStatusCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MetaclusterStatusCommandActor, 0, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterStatusCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 545 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		StrictFuture<Optional<int64_t>> __when_expr_2 = TenantMetadata::tenantIdPrefix().get(tr);
															#line 545 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (static_cast<MetaclusterStatusCommandActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MetaclusterStatusCommandActor*>(this)->actor_wait_state = 3;
															#line 545 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MetaclusterStatusCommandActor, 2, Optional<int64_t> >*>(static_cast<MetaclusterStatusCommandActor*>(this)));
															#line 3584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::map<ClusterName, metacluster::DataClusterMetadata> const& __clusters,int loopDepth) 
	{
															#line 543 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		clusters = __clusters;
															#line 3593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::map<ClusterName, metacluster::DataClusterMetadata> && __clusters,int loopDepth) 
	{
		clusters = std::move(__clusters);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MetaclusterStatusCommandActor*>(this)->actor_wait_state > 0) static_cast<MetaclusterStatusCommandActor*>(this)->actor_wait_state = 0;
		static_cast<MetaclusterStatusCommandActor*>(this)->ActorCallback< MetaclusterStatusCommandActor, 1, std::map<ClusterName, metacluster::DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< MetaclusterStatusCommandActor, 1, std::map<ClusterName, metacluster::DataClusterMetadata> >*,std::map<ClusterName, metacluster::DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterStatusCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MetaclusterStatusCommandActor, 1, std::map<ClusterName, metacluster::DataClusterMetadata> >*,std::map<ClusterName, metacluster::DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterStatusCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MetaclusterStatusCommandActor, 1, std::map<ClusterName, metacluster::DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterStatusCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont11(Optional<int64_t> const& optionalIdPrefix,int loopDepth) 
	{
															#line 546 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		ASSERT(optionalIdPrefix.present());
															#line 547 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		int64_t tenantIdPrefix = optionalIdPrefix.get();
															#line 548 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		auto capacityNumbers = metacluster::util::metaclusterCapacity(clusters);
															#line 549 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (useJson)
															#line 3678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 550 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			json_spirit::mObject obj;
															#line 551 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			obj[msgTypeKey] = "success";
															#line 552 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			obj[msgClusterTypeKey] = clusterTypeToString(ClusterType::METACLUSTER_MANAGEMENT);
															#line 554 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			json_spirit::mObject metaclusterObj;
															#line 555 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			metaclusterObj[msgMetaclusterName] = metaclusterName.get();
															#line 556 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			metaclusterObj[msgDataClustersKey] = static_cast<int>(clusters.size());
															#line 557 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			metaclusterObj[msgCapacityKey] = capacityNumbers.first.toJson();
															#line 558 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			metaclusterObj[msgAllocatedKey] = capacityNumbers.second.toJson();
															#line 559 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			metaclusterObj[msgTenantIdPrefixKey] = tenantIdPrefix;
															#line 561 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			obj[msgMetaclusterKey] = metaclusterObj;
															#line 562 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("{}\n", json_spirit::write_string(json_spirit::mValue(obj), json_spirit::pretty_print).c_str());
															#line 3702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
		else
		{
															#line 565 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  number of data clusters: {}\n", clusters.size());
															#line 566 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  tenant group capacity: {}\n", capacityNumbers.first.numTenantGroups);
															#line 567 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  allocated tenant groups: {}\n", capacityNumbers.second.numTenantGroups);
															#line 568 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  tenant id prefix: {}\n", tenantIdPrefix);
															#line 3714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
															#line 570 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!static_cast<MetaclusterStatusCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterStatusCommandActorState(); static_cast<MetaclusterStatusCommandActor*>(this)->destroy(); return 0; }
															#line 3718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		new (&static_cast<MetaclusterStatusCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~MetaclusterStatusCommandActorState();
		static_cast<MetaclusterStatusCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont11(Optional<int64_t> && optionalIdPrefix,int loopDepth) 
	{
															#line 546 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		ASSERT(optionalIdPrefix.present());
															#line 547 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		int64_t tenantIdPrefix = optionalIdPrefix.get();
															#line 548 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		auto capacityNumbers = metacluster::util::metaclusterCapacity(clusters);
															#line 549 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (useJson)
															#line 3736 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		{
															#line 550 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			json_spirit::mObject obj;
															#line 551 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			obj[msgTypeKey] = "success";
															#line 552 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			obj[msgClusterTypeKey] = clusterTypeToString(ClusterType::METACLUSTER_MANAGEMENT);
															#line 554 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			json_spirit::mObject metaclusterObj;
															#line 555 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			metaclusterObj[msgMetaclusterName] = metaclusterName.get();
															#line 556 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			metaclusterObj[msgDataClustersKey] = static_cast<int>(clusters.size());
															#line 557 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			metaclusterObj[msgCapacityKey] = capacityNumbers.first.toJson();
															#line 558 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			metaclusterObj[msgAllocatedKey] = capacityNumbers.second.toJson();
															#line 559 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			metaclusterObj[msgTenantIdPrefixKey] = tenantIdPrefix;
															#line 561 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			obj[msgMetaclusterKey] = metaclusterObj;
															#line 562 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("{}\n", json_spirit::write_string(json_spirit::mValue(obj), json_spirit::pretty_print).c_str());
															#line 3760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
		else
		{
															#line 565 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  number of data clusters: {}\n", clusters.size());
															#line 566 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  tenant group capacity: {}\n", capacityNumbers.first.numTenantGroups);
															#line 567 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  allocated tenant groups: {}\n", capacityNumbers.second.numTenantGroups);
															#line 568 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
			fmt::print("  tenant id prefix: {}\n", tenantIdPrefix);
															#line 3772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		}
															#line 570 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
		if (!static_cast<MetaclusterStatusCommandActor*>(this)->SAV<bool>::futures) { (void)(true); this->~MetaclusterStatusCommandActorState(); static_cast<MetaclusterStatusCommandActor*>(this)->destroy(); return 0; }
															#line 3776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		new (&static_cast<MetaclusterStatusCommandActor*>(this)->SAV< bool >::value()) bool(true);
		this->~MetaclusterStatusCommandActorState();
		static_cast<MetaclusterStatusCommandActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Optional<int64_t> const& optionalIdPrefix,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(optionalIdPrefix, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Optional<int64_t> && optionalIdPrefix,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(optionalIdPrefix), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MetaclusterStatusCommandActor*>(this)->actor_wait_state > 0) static_cast<MetaclusterStatusCommandActor*>(this)->actor_wait_state = 0;
		static_cast<MetaclusterStatusCommandActor*>(this)->ActorCallback< MetaclusterStatusCommandActor, 2, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< MetaclusterStatusCommandActor, 2, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterStatusCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MetaclusterStatusCommandActor, 2, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterStatusCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MetaclusterStatusCommandActor, 2, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterStatusCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 488 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	Reference<IDatabase> db;
															#line 488 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	std::vector<StringRef> tokens;
															#line 496 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	bool useJson;
															#line 498 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	Optional<std::string> metaclusterName;
															#line 500 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	Reference<ITransaction> tr;
															#line 543 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	std::map<ClusterName, metacluster::DataClusterMetadata> clusters;
															#line 3871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
};
// This generated class is to be used only via metaclusterStatusCommand()
															#line 488 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
class MetaclusterStatusCommandActor final : public Actor<bool>, public ActorCallback< MetaclusterStatusCommandActor, 0, Optional<MetaclusterRegistrationEntry> >, public ActorCallback< MetaclusterStatusCommandActor, 1, std::map<ClusterName, metacluster::DataClusterMetadata> >, public ActorCallback< MetaclusterStatusCommandActor, 2, Optional<int64_t> >, public FastAllocated<MetaclusterStatusCommandActor>, public MetaclusterStatusCommandActorState<MetaclusterStatusCommandActor> {
															#line 3876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
public:
	using FastAllocated<MetaclusterStatusCommandActor>::operator new;
	using FastAllocated<MetaclusterStatusCommandActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4023877308488208384UL, 9756291062775316224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MetaclusterStatusCommandActor, 0, Optional<MetaclusterRegistrationEntry> >;
friend struct ActorCallback< MetaclusterStatusCommandActor, 1, std::map<ClusterName, metacluster::DataClusterMetadata> >;
friend struct ActorCallback< MetaclusterStatusCommandActor, 2, Optional<int64_t> >;
															#line 488 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	MetaclusterStatusCommandActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 3895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
		 : Actor<bool>(),
		   MetaclusterStatusCommandActorState<MetaclusterStatusCommandActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(25474313289221376UL, 3758702215524853248UL);
		ActorExecutionContextHelper __helper(static_cast<MetaclusterStatusCommandActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("metaclusterStatusCommand");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("metaclusterStatusCommand", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MetaclusterStatusCommandActor, 0, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MetaclusterStatusCommandActor, 1, std::map<ClusterName, metacluster::DataClusterMetadata> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MetaclusterStatusCommandActor, 2, Optional<int64_t> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 488 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
[[nodiscard]] Future<bool> metaclusterStatusCommand( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 488 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"
	return Future<bool>(new MetaclusterStatusCommandActor(db, tokens));
															#line 3929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/MetaclusterCommands.actor.g.cpp"
}

#line 585 "/Users/ec2-user/foundationdb/fdbcli/MetaclusterCommands.actor.cpp"

// metacluster command
Future<bool> metaclusterCommand(Reference<IDatabase> db, std::vector<StringRef> tokens) {
	if (tokens.size() == 1) {
		printUsage(tokens[0]);
		return true;
	} else if (tokencmp(tokens[1], "create_experimental")) {
		return metaclusterCreateCommand(db, tokens);
	} else if (tokencmp(tokens[1], "decommission")) {
		return metaclusterDecommissionCommand(db, tokens);
	} else if (tokencmp(tokens[1], "register")) {
		return metaclusterRegisterCommand(db, tokens);
	} else if (tokencmp(tokens[1], "remove")) {
		return metaclusterRemoveCommand(db, tokens);
	} else if (tokencmp(tokens[1], "restore")) {
		return metaclusterRestoreCommand(db, tokens);
	} else if (tokencmp(tokens[1], "configure")) {
		return metaclusterConfigureCommand(db, tokens);
	} else if (tokencmp(tokens[1], "list")) {
		return metaclusterListCommand(db, tokens);
	} else if (tokencmp(tokens[1], "get")) {
		return metaclusterGetCommand(db, tokens);
	} else if (tokencmp(tokens[1], "status")) {
		return metaclusterStatusCommand(db, tokens);
	} else {
		printUsage(tokens[0]);
		return true;
	}
}

void metaclusterGenerator(const char* text,
                          const char* line,
                          std::vector<std::string>& lc,
                          std::vector<StringRef> const& tokens) {
	if (tokens.size() == 1) {
		const char* opts[] = { "create_experimental", "decommission", "register", "remove", "restore",
			                   "configure",           "list",         "get",      "status", nullptr };
		arrayGenerator(text, line, opts, lc);
	} else if (tokens.size() > 1 && (tokencmp(tokens[1], "register") || tokencmp(tokens[1], "configure"))) {
		const char* opts[] = { "max_tenant_groups=", "connection_string=", "auto_tenant_assignment=", nullptr };
		arrayGenerator(text, line, opts, lc);
	} else if ((tokens.size() == 2 && tokencmp(tokens[1], "status")) ||
	           (tokens.size() == 3 && tokencmp(tokens[1], "get"))) {
		const char* opts[] = { "JSON", nullptr };
		arrayGenerator(text, line, opts, lc);
	} else if (tokens.size() == 2 && tokencmp(tokens[1], "remove")) {
		const char* opts[] = { "FORCE", nullptr };
		arrayGenerator(text, line, opts, lc);
	} else if (tokens.size() > 1 && tokencmp(tokens[1], "restore")) {
		if (tokens.size() == 3) {
			const char* opts[] = { "dryrun", "connection_string=", nullptr };
			arrayGenerator(text, line, opts, lc);
		} else {
			int dryrun = tokens[3] == "dryrun"_sr ? 1 : 0;
			if (tokens.size() == 3 + dryrun) {
				const char* opts[] = { "connection_string=", nullptr };
				arrayGenerator(text, line, opts, lc);
			} else if (tokens.size() == 4 + dryrun) {
				const char* opts[] = { "restore_known_data_cluster", "repopulate_from_data_cluster", nullptr };
				arrayGenerator(text, line, opts, lc);
			} else if (tokens.size() >= 5 + dryrun && tokens.size() < 7 + dryrun) {
				const char* opts[] = { "force_join", "force_reuse_tenant_id_prefix", nullptr };
				arrayGenerator(text, line, opts, lc);
			}
		}
	}
}

std::vector<const char*> metaclusterHintGenerator(std::vector<StringRef> const& tokens, bool inArgument) {
	if (tokens.size() == 1) {
		return { "<create_experimental|decommission|register|remove|restore|configure|list|get|status>", "[ARGS]" };
	} else if (tokencmp(tokens[1], "create_experimental") && tokens.size() < 4) {
		static std::vector<const char*> opts = { "<NAME>", "<TENANT_ID_PREFIX>" };
		return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
	} else if (tokencmp(tokens[1], "decommission")) {
		return {};
	} else if (tokencmp(tokens[1], "register") && tokens.size() < 5) {
		static std::vector<const char*> opts = {
			"<NAME>",
			"connection_string=<CONNECTION_STRING>",
			"[max_tenant_groups=<NUM_GROUPS>|auto_tenant_assignment=<enabled|disabled>]"
		};
		return std::vector<const char*>(opts.begin() + std::min<int>(2, tokens.size() - 2), opts.end());
	} else if (tokencmp(tokens[1], "remove") && tokens.size() < 4) {
		static std::vector<const char*> opts = { "[FORCE]", "<NAME>" };
		if (tokens.size() == 2) {
			return opts;
		} else if (tokens.size() == 3 && (inArgument || tokens[2].size() == "FORCE"_sr.size()) &&
		           "FORCE"_sr.startsWith(tokens[2])) {
			return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
		} else {
			return {};
		}
	} else if (tokencmp(tokens[1], "restore") && tokens.size() < 8) {
		static std::vector<const char*> opts = { "<NAME>",
			                                     "[dryrun]",
			                                     "connection_string=<CONNECTION_STRING>",
			                                     "<restore_known_data_cluster|repopulate_from_data_cluster>",
			                                     "[force_join|force_reuse_tenant_id_prefix]" };
		if (tokens.size() < 4 || (tokens[3].size() <= 7 && "dryrun"_sr.startsWith(tokens[3]))) {
			return std::vector<const char*>(opts.begin() + std::min(tokens.size() - 2, opts.size() - 1), opts.end());
		} else if (tokens.size() < 7) {
			return std::vector<const char*>(opts.begin() + std::min(tokens.size() - 1, opts.size() - 1), opts.end());
		} else {
			return {};
		}
	} else if (tokencmp(tokens[1], "configure")) {
		static std::vector<const char*> opts = { "<NAME>",
			                                     "<max_tenant_groups=<NUM_GROUPS>|connection_string=<CONNECTION_STRING>"
			                                     "|auto_tenant_assignment=<enabled|disabled>>" };
		return std::vector<const char*>(opts.begin() + std::min<int>(1, tokens.size() - 2), opts.end());
	} else if (tokencmp(tokens[1], "list") && tokens.size() < 5) {
		static std::vector<const char*> opts = { "[BEGIN]", "[END]", "[LIMIT]" };
		return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
	} else if (tokencmp(tokens[1], "get") && tokens.size() < 4) {
		static std::vector<const char*> opts = { "<NAME>", "[JSON]" };
		return std::vector<const char*>(opts.begin() + tokens.size() - 2, opts.end());
	} else if (tokencmp(tokens[1], "status") && tokens.size() == 2) {
		return { "[JSON]" };
	} else {
		return {};
	}
}

CommandFactory metaclusterRegisterFactory(
    "metacluster",
    CommandHelp(
        "metacluster <create_experimental|decommission|register|remove|restore|configure|list|get|status> [ARGS]",
        "view and manage a metacluster",
        "`create_experimental' and `decommission' set up or deconfigure a metacluster.\n"
        "`register' and `remove' add and remove data clusters from the metacluster.\n"
        "`configure' updates the configuration of a data cluster.\n"
        "`restore' is used to recover from lost management or data clusters.\n"
        "`list' prints a list of data clusters in the metacluster.\n"
        "`get' prints the metadata for a particular data cluster.\n"
        "`status' prints metacluster metadata.\n"),
    &metaclusterGenerator,
    &metaclusterHintGenerator);

} // namespace fdb_cli
