#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
/*
 * FileConfigureCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/FlowLineNoise.h"
#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/Schemas.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

															#line 39 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
// This generated class is to be used only via fileConfigureCommandActor()
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
template <class FileConfigureCommandActorActor>
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
class FileConfigureCommandActorActorState {
															#line 45 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
public:
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
	FileConfigureCommandActorActorState(Reference<IDatabase> const& db,std::string const& filePath,bool const& isNewDatabase,bool const& force) 
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
		 : db(db),
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
		   filePath(filePath),
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
		   isNewDatabase(isNewDatabase),
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
		   force(force)
															#line 58 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("fileConfigureCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~FileConfigureCommandActorActorState() 
	{
		fdb_probe_actor_destroy("fileConfigureCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 41 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
			std::string contents(readFileBytes(filePath, 100000));
															#line 42 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
			json_spirit::mValue config;
															#line 43 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
			if (!json_spirit::read_string(contents, config))
															#line 77 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
			{
															#line 44 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
				fprintf(stderr, "ERROR: Invalid JSON\n");
															#line 45 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
				if (!static_cast<FileConfigureCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FileConfigureCommandActorActorState(); static_cast<FileConfigureCommandActorActor*>(this)->destroy(); return 0; }
															#line 83 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
				new (&static_cast<FileConfigureCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~FileConfigureCommandActorActorState();
				static_cast<FileConfigureCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 47 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
			if (config.type() != json_spirit::obj_type)
															#line 91 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
			{
															#line 48 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
				fprintf(stderr, "ERROR: Configuration file must contain a JSON object\n");
															#line 49 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
				if (!static_cast<FileConfigureCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FileConfigureCommandActorActorState(); static_cast<FileConfigureCommandActorActor*>(this)->destroy(); return 0; }
															#line 97 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
				new (&static_cast<FileConfigureCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~FileConfigureCommandActorActorState();
				static_cast<FileConfigureCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 51 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
			StatusObject configJSON = config.get_obj();
															#line 53 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
			json_spirit::mValue schema;
															#line 54 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
			if (!json_spirit::read_string(JSONSchemas::clusterConfigurationSchema.toString(), schema))
															#line 109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
			{
															#line 55 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
				ASSERT(false);
															#line 113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
			}
															#line 58 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
			std::string errorStr;
															#line 59 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
			if (!schemaMatch(schema.get_obj(), configJSON, errorStr))
															#line 119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
			{
															#line 60 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
				printf("%s", errorStr.c_str());
															#line 61 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
				if (!static_cast<FileConfigureCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FileConfigureCommandActorActorState(); static_cast<FileConfigureCommandActorActor*>(this)->destroy(); return 0; }
															#line 125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
				new (&static_cast<FileConfigureCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~FileConfigureCommandActorActorState();
				static_cast<FileConfigureCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
			configString = std::string();
															#line 133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
			try {
															#line 67 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
				configString += DatabaseConfiguration::configureStringFromJSON(configJSON);
															#line 137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
				loopDepth = a_body1cont7(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FileConfigureCommandActorActorState();
		static_cast<FileConfigureCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 74 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
		if (isNewDatabase)
															#line 166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
		{
															#line 75 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
			configString = "new" + configString;
															#line 170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
		}
		else
		{
															#line 77 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
			configString.erase(0, 1);
															#line 176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
		}
															#line 80 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
		StrictFuture<ConfigurationResult> __when_expr_0 = ManagementAPI::changeConfig(db, configString, force);
															#line 80 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
		if (static_cast<FileConfigureCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 182 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1cont1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FileConfigureCommandActorActor*>(this)->actor_wait_state = 1;
															#line 80 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FileConfigureCommandActorActor, 0, ConfigurationResult >*>(static_cast<FileConfigureCommandActorActor*>(this)));
															#line 187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
			fmt::print("ERROR: {}", e.what());
															#line 70 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
			printUsage("fileconfigure"_sr);
															#line 71 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
			if (!static_cast<FileConfigureCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~FileConfigureCommandActorActorState(); static_cast<FileConfigureCommandActorActor*>(this)->destroy(); return 0; }
															#line 201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
			new (&static_cast<FileConfigureCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
			this->~FileConfigureCommandActorActorState();
			static_cast<FileConfigureCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(ConfigurationResult const& result,int loopDepth) 
	{
															#line 83 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
		bool ret = true;
															#line 84 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
		switch (result) { case ConfigurationResult::NO_OPTIONS_PROVIDED: fprintf(stderr, "ERROR: No options provided\n"); ret = false; break; case ConfigurationResult::CONFLICTING_OPTIONS: fprintf(stderr, "ERROR: Conflicting options\n"); ret = false; break; case ConfigurationResult::UNKNOWN_OPTION: fprintf(stderr, "ERROR: Unknown option\n"); ret = false; break; case ConfigurationResult::INCOMPLETE_CONFIGURATION: fprintf(stderr, "ERROR: Must specify both a replication level and a storage engine when creating a new database\n"); ret = false; break; case ConfigurationResult::INVALID_CONFIGURATION: fprintf(stderr, "ERROR: These changes would make the configuration invalid\n"); ret = false; break; case ConfigurationResult::DATABASE_ALREADY_CREATED: fprintf(stderr, "ERROR: Database already exists! To change configuration, don't say `new'\n"); ret = false; break; case ConfigurationResult::DATABASE_CREATED: printf("Database created\n"); break; case ConfigurationResult::DATABASE_UNAVAILABLE: fprintf(stderr, "ERROR: The database is unavailable\n"); printf("Type `fileconfigure FORCE <FILENAME>' to configure without this check\n"); ret = false; break; case ConfigurationResult::STORAGE_IN_UNKNOWN_DCID: fprintf(stderr, "ERROR: All storage servers must be in one of the known regions\n"); printf("Type `fileconfigure FORCE <FILENAME>' to configure without this check\n"); ret = false; break; case ConfigurationResult::REGION_NOT_FULLY_REPLICATED: fprintf(stderr, "ERROR: When usable_regions > 1, All regions with priority >= 0 must be fully replicated " "before changing the configuration\n"); printf("Type `fileconfigure FORCE <FILENAME>' to configure without this check\n"); ret = false; break; case ConfigurationResult::MULTIPLE_ACTIVE_REGIONS: fprintf(stderr, "ERROR: When changing usable_regions, only one region can have priority >= 0\n"); printf("Type `fileconfigure FORCE <FILENAME>' to configure without this check\n"); ret = false; break; case ConfigurationResult::REGIONS_CHANGED: fprintf(stderr, "ERROR: The region configuration cannot be changed while simultaneously changing usable_regions\n"); printf("Type `fileconfigure FORCE <FILENAME>' to configure without this check\n"); ret = false; break; case ConfigurationResult::NOT_ENOUGH_WORKERS: fprintf(stderr, "ERROR: Not enough processes exist to support the specified configuration\n"); printf("Type `fileconfigure FORCE <FILENAME>' to configure without this check\n"); ret = false; break; case ConfigurationResult::REGION_REPLICATION_MISMATCH: fprintf(stderr, "ERROR: `three_datacenter' replication is incompatible with region configuration\n"); printf("Type `fileconfigure FORCE <TOKEN...>' to configure without this check\n"); ret = false; break; case ConfigurationResult::DCID_MISSING: fprintf(stderr, "ERROR: `No storage servers in one of the specified regions\n"); printf("Type `fileconfigure FORCE <TOKEN...>' to configure without this check\n"); ret = false; break; case ConfigurationResult::SUCCESS: printf("Configuration changed\n"); break; default: ASSERT(false); ret = false; };
															#line 163 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
		if (!static_cast<FileConfigureCommandActorActor*>(this)->SAV<bool>::futures) { (void)(ret); this->~FileConfigureCommandActorActorState(); static_cast<FileConfigureCommandActorActor*>(this)->destroy(); return 0; }
															#line 236 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
		new (&static_cast<FileConfigureCommandActorActor*>(this)->SAV< bool >::value()) bool(ret);
		this->~FileConfigureCommandActorActorState();
		static_cast<FileConfigureCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(ConfigurationResult && result,int loopDepth) 
	{
															#line 83 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
		bool ret = true;
															#line 84 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
		switch (result) { case ConfigurationResult::NO_OPTIONS_PROVIDED: fprintf(stderr, "ERROR: No options provided\n"); ret = false; break; case ConfigurationResult::CONFLICTING_OPTIONS: fprintf(stderr, "ERROR: Conflicting options\n"); ret = false; break; case ConfigurationResult::UNKNOWN_OPTION: fprintf(stderr, "ERROR: Unknown option\n"); ret = false; break; case ConfigurationResult::INCOMPLETE_CONFIGURATION: fprintf(stderr, "ERROR: Must specify both a replication level and a storage engine when creating a new database\n"); ret = false; break; case ConfigurationResult::INVALID_CONFIGURATION: fprintf(stderr, "ERROR: These changes would make the configuration invalid\n"); ret = false; break; case ConfigurationResult::DATABASE_ALREADY_CREATED: fprintf(stderr, "ERROR: Database already exists! To change configuration, don't say `new'\n"); ret = false; break; case ConfigurationResult::DATABASE_CREATED: printf("Database created\n"); break; case ConfigurationResult::DATABASE_UNAVAILABLE: fprintf(stderr, "ERROR: The database is unavailable\n"); printf("Type `fileconfigure FORCE <FILENAME>' to configure without this check\n"); ret = false; break; case ConfigurationResult::STORAGE_IN_UNKNOWN_DCID: fprintf(stderr, "ERROR: All storage servers must be in one of the known regions\n"); printf("Type `fileconfigure FORCE <FILENAME>' to configure without this check\n"); ret = false; break; case ConfigurationResult::REGION_NOT_FULLY_REPLICATED: fprintf(stderr, "ERROR: When usable_regions > 1, All regions with priority >= 0 must be fully replicated " "before changing the configuration\n"); printf("Type `fileconfigure FORCE <FILENAME>' to configure without this check\n"); ret = false; break; case ConfigurationResult::MULTIPLE_ACTIVE_REGIONS: fprintf(stderr, "ERROR: When changing usable_regions, only one region can have priority >= 0\n"); printf("Type `fileconfigure FORCE <FILENAME>' to configure without this check\n"); ret = false; break; case ConfigurationResult::REGIONS_CHANGED: fprintf(stderr, "ERROR: The region configuration cannot be changed while simultaneously changing usable_regions\n"); printf("Type `fileconfigure FORCE <FILENAME>' to configure without this check\n"); ret = false; break; case ConfigurationResult::NOT_ENOUGH_WORKERS: fprintf(stderr, "ERROR: Not enough processes exist to support the specified configuration\n"); printf("Type `fileconfigure FORCE <FILENAME>' to configure without this check\n"); ret = false; break; case ConfigurationResult::REGION_REPLICATION_MISMATCH: fprintf(stderr, "ERROR: `three_datacenter' replication is incompatible with region configuration\n"); printf("Type `fileconfigure FORCE <TOKEN...>' to configure without this check\n"); ret = false; break; case ConfigurationResult::DCID_MISSING: fprintf(stderr, "ERROR: `No storage servers in one of the specified regions\n"); printf("Type `fileconfigure FORCE <TOKEN...>' to configure without this check\n"); ret = false; break; case ConfigurationResult::SUCCESS: printf("Configuration changed\n"); break; default: ASSERT(false); ret = false; };
															#line 163 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
		if (!static_cast<FileConfigureCommandActorActor*>(this)->SAV<bool>::futures) { (void)(ret); this->~FileConfigureCommandActorActorState(); static_cast<FileConfigureCommandActorActor*>(this)->destroy(); return 0; }
															#line 252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
		new (&static_cast<FileConfigureCommandActorActor*>(this)->SAV< bool >::value()) bool(ret);
		this->~FileConfigureCommandActorActorState();
		static_cast<FileConfigureCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(ConfigurationResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont8(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(ConfigurationResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FileConfigureCommandActorActor*>(this)->actor_wait_state > 0) static_cast<FileConfigureCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<FileConfigureCommandActorActor*>(this)->ActorCallback< FileConfigureCommandActorActor, 0, ConfigurationResult >::remove();

	}
	void a_callback_fire(ActorCallback< FileConfigureCommandActorActor, 0, ConfigurationResult >*,ConfigurationResult const& value) 
	{
		fdb_probe_actor_enter("fileConfigureCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FileConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fileConfigureCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FileConfigureCommandActorActor, 0, ConfigurationResult >*,ConfigurationResult && value) 
	{
		fdb_probe_actor_enter("fileConfigureCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FileConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fileConfigureCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FileConfigureCommandActorActor, 0, ConfigurationResult >*,Error err) 
	{
		fdb_probe_actor_enter("fileConfigureCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FileConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fileConfigureCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
	std::string filePath;
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
	bool isNewDatabase;
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
	bool force;
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
	std::string configString;
															#line 345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
};
// This generated class is to be used only via fileConfigureCommandActor()
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
class FileConfigureCommandActorActor final : public Actor<bool>, public ActorCallback< FileConfigureCommandActorActor, 0, ConfigurationResult >, public FastAllocated<FileConfigureCommandActorActor>, public FileConfigureCommandActorActorState<FileConfigureCommandActorActor> {
															#line 350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
public:
	using FastAllocated<FileConfigureCommandActorActor>::operator new;
	using FastAllocated<FileConfigureCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1689965508632391680UL, 2842385601770260480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FileConfigureCommandActorActor, 0, ConfigurationResult >;
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
	FileConfigureCommandActorActor(Reference<IDatabase> const& db,std::string const& filePath,bool const& isNewDatabase,bool const& force) 
															#line 367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
		 : Actor<bool>(),
		   FileConfigureCommandActorActorState<FileConfigureCommandActorActor>(db, filePath, isNewDatabase, force),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fileConfigureCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2243517724176282880UL, 601024886880896256UL);
		ActorExecutionContextHelper __helper(static_cast<FileConfigureCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fileConfigureCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fileConfigureCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FileConfigureCommandActorActor, 0, ConfigurationResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
[[nodiscard]] Future<bool> fileConfigureCommandActor( Reference<IDatabase> const& db, std::string const& filePath, bool const& isNewDatabase, bool const& force ) {
															#line 37 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"
	return Future<bool>(new FileConfigureCommandActorActor(db, filePath, isNewDatabase, force));
															#line 399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/FileConfigureCommand.actor.g.cpp"
}

#line 165 "/Users/ec2-user/foundationdb/fdbcli/FileConfigureCommand.actor.cpp"

CommandFactory fileconfigureFactory(
    "fileconfigure",
    CommandHelp(
        "fileconfigure [new] <FILENAME>",
        "change the database configuration from a file",
        "The `new' option, if present, initializes a new database with the given configuration rather than changing "
        "the configuration of an existing one. Load a JSON document from the provided file, and change the database "
        "configuration to match the contents of the JSON document. The format should be the same as the value of the "
        "\"configuration\" entry in status JSON without \"excluded_servers\" or \"coordinators_count\"."));

} // namespace fdb_cli
