#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
/*
 * CoordinatorsCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "boost/algorithm/string.hpp"

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/Schemas.h"
#include "fdbclient/ManagementAPI.actor.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

															#line 40 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
// This generated class is to be used only via printCoordinatorsInfo()
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
template <class PrintCoordinatorsInfoActor>
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
class PrintCoordinatorsInfoActorState {
															#line 46 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
public:
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	PrintCoordinatorsInfoActorState(Reference<IDatabase> const& db) 
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		 : db(db),
															#line 39 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 55 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this));

	}
	~PrintCoordinatorsInfoActorState() 
	{
		fdb_probe_actor_destroy("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 40 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			;
															#line 70 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintCoordinatorsInfoActorState();
		static_cast<PrintCoordinatorsInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 43 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			descriptionF = tr->get(fdb_cli::clusterDescriptionSpecialKey);
															#line 44 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = safeThreadFutureToFuture(descriptionF);
															#line 44 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			if (static_cast<PrintCoordinatorsInfoActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintCoordinatorsInfoActor*>(this)->actor_wait_state = 1;
															#line 44 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintCoordinatorsInfoActor, 0, Optional<Value> >*>(static_cast<PrintCoordinatorsInfoActor*>(this)));
															#line 110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 57 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 57 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			if (static_cast<PrintCoordinatorsInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<PrintCoordinatorsInfoActor*>(this)->actor_wait_state = 3;
															#line 57 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PrintCoordinatorsInfoActor, 2, Void >*>(static_cast<PrintCoordinatorsInfoActor*>(this)));
															#line 139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& description,int loopDepth) 
	{
															#line 45 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		ASSERT(description.present());
															#line 46 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		printf("Cluster description: %s\n", description.get().toString().c_str());
															#line 48 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		processesF = tr->get(fdb_cli::coordinatorsProcessSpecialKey);
															#line 49 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = safeThreadFutureToFuture(processesF);
															#line 49 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		if (static_cast<PrintCoordinatorsInfoActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PrintCoordinatorsInfoActor*>(this)->actor_wait_state = 2;
															#line 49 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrintCoordinatorsInfoActor, 1, Optional<Value> >*>(static_cast<PrintCoordinatorsInfoActor*>(this)));
															#line 167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && description,int loopDepth) 
	{
															#line 45 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		ASSERT(description.present());
															#line 46 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		printf("Cluster description: %s\n", description.get().toString().c_str());
															#line 48 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		processesF = tr->get(fdb_cli::coordinatorsProcessSpecialKey);
															#line 49 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = safeThreadFutureToFuture(processesF);
															#line 49 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		if (static_cast<PrintCoordinatorsInfoActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PrintCoordinatorsInfoActor*>(this)->actor_wait_state = 2;
															#line 49 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrintCoordinatorsInfoActor, 1, Optional<Value> >*>(static_cast<PrintCoordinatorsInfoActor*>(this)));
															#line 189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& description,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(description, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && description,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(description), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintCoordinatorsInfoActor*>(this)->actor_wait_state > 0) static_cast<PrintCoordinatorsInfoActor*>(this)->actor_wait_state = 0;
		static_cast<PrintCoordinatorsInfoActor*>(this)->ActorCallback< PrintCoordinatorsInfoActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< PrintCoordinatorsInfoActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintCoordinatorsInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintCoordinatorsInfoActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintCoordinatorsInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintCoordinatorsInfoActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintCoordinatorsInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Value> const& processes,int loopDepth) 
	{
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		ASSERT(processes.present());
															#line 51 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		std::vector<std::string> process_addresses;
															#line 52 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		boost::split(process_addresses, processes.get().toString(), [](char c) { return c == ','; });
															#line 53 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		printf("Cluster coordinators (%zu): %s\n", process_addresses.size(), processes.get().toString().c_str());
															#line 54 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		printf("Type `help coordinators' to learn how to change this information.\n");
															#line 55 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		if (!static_cast<PrintCoordinatorsInfoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintCoordinatorsInfoActorState(); static_cast<PrintCoordinatorsInfoActor*>(this)->destroy(); return 0; }
															#line 283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		new (&static_cast<PrintCoordinatorsInfoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintCoordinatorsInfoActorState();
		static_cast<PrintCoordinatorsInfoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && processes,int loopDepth) 
	{
															#line 50 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		ASSERT(processes.present());
															#line 51 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		std::vector<std::string> process_addresses;
															#line 52 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		boost::split(process_addresses, processes.get().toString(), [](char c) { return c == ','; });
															#line 53 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		printf("Cluster coordinators (%zu): %s\n", process_addresses.size(), processes.get().toString().c_str());
															#line 54 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		printf("Type `help coordinators' to learn how to change this information.\n");
															#line 55 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		if (!static_cast<PrintCoordinatorsInfoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintCoordinatorsInfoActorState(); static_cast<PrintCoordinatorsInfoActor*>(this)->destroy(); return 0; }
															#line 305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		new (&static_cast<PrintCoordinatorsInfoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintCoordinatorsInfoActorState();
		static_cast<PrintCoordinatorsInfoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& processes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(processes, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && processes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(processes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PrintCoordinatorsInfoActor*>(this)->actor_wait_state > 0) static_cast<PrintCoordinatorsInfoActor*>(this)->actor_wait_state = 0;
		static_cast<PrintCoordinatorsInfoActor*>(this)->ActorCallback< PrintCoordinatorsInfoActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< PrintCoordinatorsInfoActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintCoordinatorsInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrintCoordinatorsInfoActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintCoordinatorsInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrintCoordinatorsInfoActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintCoordinatorsInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PrintCoordinatorsInfoActor*>(this)->actor_wait_state > 0) static_cast<PrintCoordinatorsInfoActor*>(this)->actor_wait_state = 0;
		static_cast<PrintCoordinatorsInfoActor*>(this)->ActorCallback< PrintCoordinatorsInfoActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintCoordinatorsInfoActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintCoordinatorsInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PrintCoordinatorsInfoActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintCoordinatorsInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PrintCoordinatorsInfoActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintCoordinatorsInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 39 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 43 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	ThreadFuture<Optional<Value>> descriptionF;
															#line 48 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	ThreadFuture<Optional<Value>> processesF;
															#line 483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
};
// This generated class is to be used only via printCoordinatorsInfo()
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
class PrintCoordinatorsInfoActor final : public Actor<Void>, public ActorCallback< PrintCoordinatorsInfoActor, 0, Optional<Value> >, public ActorCallback< PrintCoordinatorsInfoActor, 1, Optional<Value> >, public ActorCallback< PrintCoordinatorsInfoActor, 2, Void >, public FastAllocated<PrintCoordinatorsInfoActor>, public PrintCoordinatorsInfoActorState<PrintCoordinatorsInfoActor> {
															#line 488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
public:
	using FastAllocated<PrintCoordinatorsInfoActor>::operator new;
	using FastAllocated<PrintCoordinatorsInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16196505451827184384UL, 13613898395339378944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintCoordinatorsInfoActor, 0, Optional<Value> >;
friend struct ActorCallback< PrintCoordinatorsInfoActor, 1, Optional<Value> >;
friend struct ActorCallback< PrintCoordinatorsInfoActor, 2, Void >;
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	PrintCoordinatorsInfoActor(Reference<IDatabase> const& db) 
															#line 507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		 : Actor<Void>(),
		   PrintCoordinatorsInfoActorState<PrintCoordinatorsInfoActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15707786927814087680UL, 11158376476469806336UL);
		ActorExecutionContextHelper __helper(static_cast<PrintCoordinatorsInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printCoordinatorsInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printCoordinatorsInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintCoordinatorsInfoActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PrintCoordinatorsInfoActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PrintCoordinatorsInfoActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
[[nodiscard]] Future<Void> printCoordinatorsInfo( Reference<IDatabase> const& db ) {
															#line 38 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	return Future<Void>(new PrintCoordinatorsInfoActor(db));
															#line 541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
}

#line 61 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"

															#line 546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
// This generated class is to be used only via changeCoordinators()
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
template <class ChangeCoordinatorsActor>
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
class ChangeCoordinatorsActorState {
															#line 552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
public:
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	ChangeCoordinatorsActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		 : db(db),
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		   tokens(tokens),
															#line 63 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		   retries(0),
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		   notEnoughMachineResults(0),
															#line 65 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		   new_cluster_description(),
															#line 66 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		   auto_coordinators_str(),
															#line 67 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		   disableConfigDB(false)
															#line 571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("changeCoordinators", reinterpret_cast<unsigned long>(this));

	}
	~ChangeCoordinatorsActorState() 
	{
		fdb_probe_actor_destroy("changeCoordinators", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 68 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			StringRef nameTokenBegin = "description="_sr;
															#line 69 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			StringRef noConfigDB = "--no-config-db"_sr;
															#line 70 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			for(auto tok = tokens.begin() + 1;tok != tokens.end();++tok) {
															#line 71 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				if (tok->startsWith(nameTokenBegin) && new_cluster_description.empty())
															#line 592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				{
															#line 72 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					new_cluster_description = tok->substr(nameTokenBegin.size());
															#line 73 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					auto next = tok - 1;
															#line 74 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					std::copy(tok + 1, tokens.end(), tok);
															#line 75 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					tokens.resize(tokens.size() - 1);
															#line 76 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					tok = next;
															#line 604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				}
				else
				{
															#line 77 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					if (tok->startsWith(noConfigDB))
															#line 610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
					{
															#line 78 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
						disableConfigDB = true;
															#line 79 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
						auto next = tok - 1;
															#line 80 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
						std::copy(tok + 1, tokens.end(), tok);
															#line 81 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
						tokens.resize(tokens.size() - 1);
															#line 82 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
						tok = next;
															#line 622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
					}
				}
			}
															#line 86 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			automatic = tokens.size() == 2 && tokens[1] == "auto"_sr;
															#line 87 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			tr = db->createTransaction();
															#line 88 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			;
															#line 632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeCoordinatorsActorState();
		static_cast<ChangeCoordinatorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 89 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		try {
															#line 92 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			if (new_cluster_description.size())
															#line 666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			{
															#line 93 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				tr->set(fdb_cli::clusterDescriptionSpecialKey, new_cluster_description);
															#line 670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			}
															#line 95 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			if (disableConfigDB)
															#line 674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			{
															#line 97 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				tr->set(fdb_cli::configDBSpecialKey, ""_sr);
															#line 678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			}
															#line 100 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			if (automatic)
															#line 682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			{
															#line 102 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				if (!auto_coordinators_str.size())
															#line 686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				{
															#line 104 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					auto_coordinatorsF = tr->get(fdb_cli::coordinatorsAutoSpecialKey);
															#line 106 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					StrictFuture<Optional<Value>> __when_expr_0 = safeThreadFutureToFuture(auto_coordinatorsF);
															#line 106 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
					static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 1;
															#line 106 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 0, Optional<Value> >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1loopBody1cont5(loopDepth);
				}
			}
			else
			{
															#line 111 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				if (tokens.size() > 1)
															#line 711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				{
															#line 112 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					new_coordinators_addresses = std::set<NetworkAddress>();
															#line 113 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					new_coordinators_hostnames = std::set<Hostname>();
															#line 114 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					newCoordinatorslist = std::vector<std::string>();
															#line 115 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					t = std::vector<StringRef>::iterator();
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					t = tokens.begin() + 1;
															#line 723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
					loopDepth = a_body1loopBody1loopHead1(loopDepth);
				}
				else
				{
					loopDepth = a_body1loopBody1cont9(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 156 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			err = Error(e);
															#line 157 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			if (e.code() == error_code_special_keys_api_failure)
															#line 753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			{
															#line 158 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				StrictFuture<std::string> __when_expr_2 = fdb_cli::getSpecialKeysFailureErrorMessage(tr);
															#line 158 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 759 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 3;
															#line 158 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 2, std::string >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 151 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 151 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 2;
															#line 151 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 1, Void >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 110 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		tr->set(fdb_cli::coordinatorsProcessSpecialKey, auto_coordinators_str);
															#line 800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Optional<Value> const& auto_coordinators,int loopDepth) 
	{
															#line 107 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		ASSERT(auto_coordinators.present());
															#line 108 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		auto_coordinators_str = auto_coordinators.get().toString();
															#line 811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Optional<Value> && auto_coordinators,int loopDepth) 
	{
															#line 107 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		ASSERT(auto_coordinators.present());
															#line 108 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		auto_coordinators_str = auto_coordinators.get().toString();
															#line 822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& auto_coordinators,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(auto_coordinators, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && auto_coordinators,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(auto_coordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCoordinatorsActor*>(this)->ActorCallback< ChangeCoordinatorsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeCoordinatorsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
															#line 148 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		std::string new_coordinators_str = boost::algorithm::join(newCoordinatorslist, ",");
															#line 149 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		tr->set(fdb_cli::coordinatorsProcessSpecialKey, new_coordinators_str);
															#line 914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		if (!(t != tokens.end()))
															#line 930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 118 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			if (Hostname::isHostname(t->toString()))
															#line 937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			{
															#line 120 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				const auto& hostname = Hostname::parse(t->toString());
															#line 121 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				if (new_coordinators_hostnames.count(hostname))
															#line 943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				{
															#line 122 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					fprintf(stderr, "ERROR: passed redundant coordinators: `%s'\n", hostname.toString().c_str());
															#line 125 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					if (!static_cast<ChangeCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ChangeCoordinatorsActorState(); static_cast<ChangeCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
					new (&static_cast<ChangeCoordinatorsActor*>(this)->SAV< bool >::value()) bool(true);
					this->~ChangeCoordinatorsActorState();
					static_cast<ChangeCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 127 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				new_coordinators_hostnames.insert(hostname);
															#line 128 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				newCoordinatorslist.push_back(hostname.toString());
															#line 959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			}
			else
			{
															#line 130 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				const auto& addr = NetworkAddress::parse(t->toString());
															#line 131 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				if (new_coordinators_addresses.count(addr))
															#line 967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				{
															#line 132 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					fprintf( stderr, "ERROR: passed redundant coordinators: `%s'\n", addr.toString().c_str());
															#line 134 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					if (!static_cast<ChangeCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ChangeCoordinatorsActorState(); static_cast<ChangeCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
					new (&static_cast<ChangeCoordinatorsActor*>(this)->SAV< bool >::value()) bool(true);
					this->~ChangeCoordinatorsActorState();
					static_cast<ChangeCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 136 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				new_coordinators_addresses.insert(addr);
															#line 137 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				newCoordinatorslist.push_back(addr.toString());
															#line 983 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 116 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		++t;
															#line 1012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 140 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			if (e.code() == error_code_connection_string_invalid)
															#line 1022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			{
															#line 141 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				fprintf( stderr, "ERROR: '%s' is not a valid network endpoint address\n", t->toString().c_str());
															#line 143 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				if (!static_cast<ChangeCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ChangeCoordinatorsActorState(); static_cast<ChangeCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 1028 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				new (&static_cast<ChangeCoordinatorsActor*>(this)->SAV< bool >::value()) bool(true);
				this->~ChangeCoordinatorsActorState();
				static_cast<ChangeCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 145 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			return a_body1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 1036 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 154 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		ASSERT(false);
															#line 1063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont11cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 154 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		ASSERT(false);
															#line 1072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont11cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCoordinatorsActor*>(this)->ActorCallback< ChangeCoordinatorsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeCoordinatorsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont11cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 179 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		StrictFuture<Void> __when_expr_4 = safeThreadFutureToFuture(tr->onError(err));
															#line 179 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 5;
															#line 179 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 4, Void >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 1176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string const& errorMsgStr,int loopDepth) 
	{
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		if (errorMsgStr == ManagementAPI::generateErrorMessage(CoordinatorsResult::NOT_ENOUGH_MACHINES) && notEnoughMachineResults < 1)
															#line 1185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		{
															#line 163 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			notEnoughMachineResults++;
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont2when1(__when_expr_3.get(), loopDepth); };
			static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 4;
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 3, Void >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 1198 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 167 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			if (errorMsgStr == ManagementAPI::generateErrorMessage(CoordinatorsResult::SAME_NETWORK_ADDRESSES))
															#line 1205 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			{
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				if (retries)
															#line 1209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				{
															#line 170 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					printf("Coordination state changed\n");
															#line 1213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				}
				else
				{
															#line 172 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					printf("No change (existing configuration satisfies request)\n");
															#line 1219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				}
															#line 173 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				if (!static_cast<ChangeCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ChangeCoordinatorsActorState(); static_cast<ChangeCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 1223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				new (&static_cast<ChangeCoordinatorsActor*>(this)->SAV< bool >::value()) bool(true);
				this->~ChangeCoordinatorsActorState();
				static_cast<ChangeCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 175 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				fprintf(stderr, "ERROR: %s\n", errorMsgStr.c_str());
															#line 176 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				if (!static_cast<ChangeCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ChangeCoordinatorsActorState(); static_cast<ChangeCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 1235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				new (&static_cast<ChangeCoordinatorsActor*>(this)->SAV< bool >::value()) bool(false);
				this->~ChangeCoordinatorsActorState();
				static_cast<ChangeCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(std::string && errorMsgStr,int loopDepth) 
	{
															#line 159 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		if (errorMsgStr == ManagementAPI::generateErrorMessage(CoordinatorsResult::NOT_ENOUGH_MACHINES) && notEnoughMachineResults < 1)
															#line 1249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		{
															#line 163 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			notEnoughMachineResults++;
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont2when1(__when_expr_3.get(), loopDepth); };
			static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 4;
															#line 164 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeCoordinatorsActor, 3, Void >*>(static_cast<ChangeCoordinatorsActor*>(this)));
															#line 1262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 167 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			if (errorMsgStr == ManagementAPI::generateErrorMessage(CoordinatorsResult::SAME_NETWORK_ADDRESSES))
															#line 1269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			{
															#line 169 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				if (retries)
															#line 1273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				{
															#line 170 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					printf("Coordination state changed\n");
															#line 1277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				}
				else
				{
															#line 172 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
					printf("No change (existing configuration satisfies request)\n");
															#line 1283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				}
															#line 173 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				if (!static_cast<ChangeCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ChangeCoordinatorsActorState(); static_cast<ChangeCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 1287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				new (&static_cast<ChangeCoordinatorsActor*>(this)->SAV< bool >::value()) bool(true);
				this->~ChangeCoordinatorsActorState();
				static_cast<ChangeCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 175 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				fprintf(stderr, "ERROR: %s\n", errorMsgStr.c_str());
															#line 176 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				if (!static_cast<ChangeCoordinatorsActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ChangeCoordinatorsActorState(); static_cast<ChangeCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 1299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				new (&static_cast<ChangeCoordinatorsActor*>(this)->SAV< bool >::value()) bool(false);
				this->~ChangeCoordinatorsActorState();
				static_cast<ChangeCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string const& errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(errorMsgStr, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(std::string && errorMsgStr,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(errorMsgStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCoordinatorsActor*>(this)->ActorCallback< ChangeCoordinatorsActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangeCoordinatorsActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
															#line 165 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		tr->reset();
															#line 1388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
															#line 165 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		tr->reset();
															#line 1397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCoordinatorsActor*>(this)->ActorCallback< ChangeCoordinatorsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangeCoordinatorsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont11(Void const& _,int loopDepth) 
	{
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		++retries;
															#line 1481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont11(Void && _,int loopDepth) 
	{
															#line 180 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		++retries;
															#line 1490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeCoordinatorsActor*>(this)->ActorCallback< ChangeCoordinatorsActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ChangeCoordinatorsActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ChangeCoordinatorsActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 63 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	int retries;
															#line 64 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	int notEnoughMachineResults;
															#line 65 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	StringRef new_cluster_description;
															#line 66 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	std::string auto_coordinators_str;
															#line 67 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	bool disableConfigDB;
															#line 86 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	bool automatic;
															#line 87 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 104 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	ThreadFuture<Optional<Value>> auto_coordinatorsF;
															#line 112 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	std::set<NetworkAddress> new_coordinators_addresses;
															#line 113 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	std::set<Hostname> new_coordinators_hostnames;
															#line 114 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	std::vector<std::string> newCoordinatorslist;
															#line 115 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	std::vector<StringRef>::iterator t;
															#line 156 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	Error err;
															#line 1600 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
};
// This generated class is to be used only via changeCoordinators()
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
class ChangeCoordinatorsActor final : public Actor<bool>, public ActorCallback< ChangeCoordinatorsActor, 0, Optional<Value> >, public ActorCallback< ChangeCoordinatorsActor, 1, Void >, public ActorCallback< ChangeCoordinatorsActor, 2, std::string >, public ActorCallback< ChangeCoordinatorsActor, 3, Void >, public ActorCallback< ChangeCoordinatorsActor, 4, Void >, public FastAllocated<ChangeCoordinatorsActor>, public ChangeCoordinatorsActorState<ChangeCoordinatorsActor> {
															#line 1605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
public:
	using FastAllocated<ChangeCoordinatorsActor>::operator new;
	using FastAllocated<ChangeCoordinatorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15528899380731009280UL, 10989600387334016768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeCoordinatorsActor, 0, Optional<Value> >;
friend struct ActorCallback< ChangeCoordinatorsActor, 1, Void >;
friend struct ActorCallback< ChangeCoordinatorsActor, 2, std::string >;
friend struct ActorCallback< ChangeCoordinatorsActor, 3, Void >;
friend struct ActorCallback< ChangeCoordinatorsActor, 4, Void >;
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	ChangeCoordinatorsActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 1626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		 : Actor<bool>(),
		   ChangeCoordinatorsActorState<ChangeCoordinatorsActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeCoordinators", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3491648785959313408UL, 8764310282253397504UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeCoordinators");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeCoordinators", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeCoordinatorsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeCoordinatorsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangeCoordinatorsActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangeCoordinatorsActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ChangeCoordinatorsActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
[[nodiscard]] Future<bool> changeCoordinators( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 62 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	return Future<bool>(new ChangeCoordinatorsActor(db, tokens));
															#line 1662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
}

#line 184 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"

} // namespace

namespace fdb_cli {

const KeyRef clusterDescriptionSpecialKey = "\xff\xff/configuration/coordinators/cluster_description"_sr;
const KeyRef configDBSpecialKey = "\xff\xff/configuration/coordinators/config_db"_sr;
const KeyRef coordinatorsAutoSpecialKey = "\xff\xff/management/auto_coordinators"_sr;
const KeyRef coordinatorsProcessSpecialKey = "\xff\xff/configuration/coordinators/processes"_sr;

															#line 1676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
// This generated class is to be used only via coordinatorsCommandActor()
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
template <class CoordinatorsCommandActorActor>
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
class CoordinatorsCommandActorActorState {
															#line 1682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
public:
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	CoordinatorsCommandActorActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		 : db(db),
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		   tokens(tokens)
															#line 1691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~CoordinatorsCommandActorActorState() 
	{
		fdb_probe_actor_destroy("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 195 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
			if (tokens.size() < 2)
															#line 1706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
			{
															#line 196 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				StrictFuture<Void> __when_expr_0 = printCoordinatorsInfo(db);
															#line 196 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				if (static_cast<CoordinatorsCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CoordinatorsCommandActorActor*>(this)->actor_wait_state = 1;
															#line 196 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsCommandActorActor, 0, Void >*>(static_cast<CoordinatorsCommandActorActor*>(this)));
															#line 1717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 199 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				StrictFuture<bool> __when_expr_1 = changeCoordinators(db, tokens);
															#line 199 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				if (static_cast<CoordinatorsCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<CoordinatorsCommandActorActor*>(this)->actor_wait_state = 2;
															#line 199 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CoordinatorsCommandActorActor, 1, bool >*>(static_cast<CoordinatorsCommandActorActor*>(this)));
															#line 1731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CoordinatorsCommandActorActorState();
		static_cast<CoordinatorsCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 197 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		if (!static_cast<CoordinatorsCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CoordinatorsCommandActorActorState(); static_cast<CoordinatorsCommandActorActor*>(this)->destroy(); return 0; }
															#line 1755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		new (&static_cast<CoordinatorsCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CoordinatorsCommandActorActorState();
		static_cast<CoordinatorsCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 197 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		if (!static_cast<CoordinatorsCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CoordinatorsCommandActorActorState(); static_cast<CoordinatorsCommandActorActor*>(this)->destroy(); return 0; }
															#line 1767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		new (&static_cast<CoordinatorsCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CoordinatorsCommandActorActorState();
		static_cast<CoordinatorsCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CoordinatorsCommandActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsCommandActorActor*>(this)->ActorCallback< CoordinatorsCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CoordinatorsCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CoordinatorsCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(bool const& result,int loopDepth) 
	{
															#line 200 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		if (!static_cast<CoordinatorsCommandActorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~CoordinatorsCommandActorActorState(); static_cast<CoordinatorsCommandActorActor*>(this)->destroy(); return 0; }
															#line 1854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		new (&static_cast<CoordinatorsCommandActorActor*>(this)->SAV< bool >::value()) bool(result);
		this->~CoordinatorsCommandActorActorState();
		static_cast<CoordinatorsCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(bool && result,int loopDepth) 
	{
															#line 200 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
		if (!static_cast<CoordinatorsCommandActorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~CoordinatorsCommandActorActorState(); static_cast<CoordinatorsCommandActorActor*>(this)->destroy(); return 0; }
															#line 1866 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		new (&static_cast<CoordinatorsCommandActorActor*>(this)->SAV< bool >::value()) bool(result);
		this->~CoordinatorsCommandActorActorState();
		static_cast<CoordinatorsCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1cont4(result, loopDepth);

		return loopDepth;
	}
	int a_body1when2(bool && result,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CoordinatorsCommandActorActor*>(this)->actor_wait_state > 0) static_cast<CoordinatorsCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<CoordinatorsCommandActorActor*>(this)->ActorCallback< CoordinatorsCommandActorActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CoordinatorsCommandActorActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CoordinatorsCommandActorActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CoordinatorsCommandActorActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 1953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
};
// This generated class is to be used only via coordinatorsCommandActor()
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
class CoordinatorsCommandActorActor final : public Actor<bool>, public ActorCallback< CoordinatorsCommandActorActor, 0, Void >, public ActorCallback< CoordinatorsCommandActorActor, 1, bool >, public FastAllocated<CoordinatorsCommandActorActor>, public CoordinatorsCommandActorActorState<CoordinatorsCommandActorActor> {
															#line 1958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
public:
	using FastAllocated<CoordinatorsCommandActorActor>::operator new;
	using FastAllocated<CoordinatorsCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9442168627587569408UL, 12301539643848299264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CoordinatorsCommandActorActor, 0, Void >;
friend struct ActorCallback< CoordinatorsCommandActorActor, 1, bool >;
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	CoordinatorsCommandActorActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 1976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
		 : Actor<bool>(),
		   CoordinatorsCommandActorActorState<CoordinatorsCommandActorActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3541193869226919680UL, 1523717445663981312UL);
		ActorExecutionContextHelper __helper(static_cast<CoordinatorsCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("coordinatorsCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("coordinatorsCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CoordinatorsCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CoordinatorsCommandActorActor, 1, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
[[nodiscard]] Future<bool> coordinatorsCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 194 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"
	return Future<bool>(new CoordinatorsCommandActorActor(db, tokens));
															#line 2009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbcli/CoordinatorsCommand.actor.g.cpp"
}

#line 203 "/Users/ec2-user/foundationdb/fdbcli/CoordinatorsCommand.actor.cpp"

CommandFactory coordinatorsFactory(
    "coordinators",
    CommandHelp(
        "coordinators auto|<ADDRESS>+ [description=new_cluster_description]",
        "change cluster coordinators or description",
        "If 'auto' is specified, coordinator addresses will be chosen automatically to support the configured "
        "redundancy level. (If the current set of coordinators are healthy and already support the redundancy level, "
        "nothing will be changed.)\n\nOtherwise, sets the coordinators to the list of IP:port pairs specified by "
        "<ADDRESS>+. An fdbserver process must be running on each of the specified addresses.\n\ne.g. coordinators "
        "10.0.0.1:4000 10.0.0.2:4000 10.0.0.3:4000\n\nIf 'description=desc' is specified then the description field in "
        "the cluster\nfile is changed to desc, which must match [A-Za-z0-9_]+."));
} // namespace fdb_cli
