#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
/*
 * Throttling.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <boost/lexical_cast.hpp>

#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/Schemas.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last include

struct TokenBucket {
	static constexpr const double addTokensInterval = 0.1;
	static constexpr const double maxSleepTime = 60.0;

	double transactionRate;
	double maxBurst;
	double bucketSize;
	Future<Void> tokenAdderActor;

																#line 40 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
// This generated class is to be used only via tokenAdder()
															#line 38 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
template <class TokenAdderActor>
															#line 38 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
class TokenAdderActorState {
															#line 46 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
public:
															#line 38 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	TokenAdderActorState(TokenBucket* const& self) 
															#line 38 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
															#line 38 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		 : self(self)
															#line 53 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
	{
		fdb_probe_actor_create("tokenAdder", reinterpret_cast<unsigned long>(this));

	}
	~TokenAdderActorState() 
	{
		fdb_probe_actor_destroy("tokenAdder", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 39 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			;
															#line 68 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TokenAdderActorState();
		static_cast<TokenAdderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		self->bucketSize = std::min(self->bucketSize + self->transactionRate * addTokensInterval, self->maxBurst);
															#line 41 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		if (deterministicRandom()->randomInt(0, 100) == 0)
															#line 100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		{
															#line 42 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			TraceEvent("AddingTokensx100") .detail("BucketSize", self->bucketSize) .detail("TransactionRate", self->transactionRate);
															#line 104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		}
															#line 45 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(addTokensInterval);
															#line 45 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		if (static_cast<TokenAdderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 110 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TokenAdderActor*>(this)->actor_wait_state = 1;
															#line 45 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TokenAdderActor, 0, Void >*>(static_cast<TokenAdderActor*>(this)));
															#line 115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TokenAdderActor*>(this)->actor_wait_state > 0) static_cast<TokenAdderActor*>(this)->actor_wait_state = 0;
		static_cast<TokenAdderActor*>(this)->ActorCallback< TokenAdderActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TokenAdderActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tokenAdder", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TokenAdderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tokenAdder", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TokenAdderActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tokenAdder", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TokenAdderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tokenAdder", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TokenAdderActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tokenAdder", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TokenAdderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tokenAdder", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 38 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	TokenBucket* self;
															#line 209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
};
// This generated class is to be used only via tokenAdder()
															#line 38 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
class TokenAdderActor final : public Actor<Void>, public ActorCallback< TokenAdderActor, 0, Void >, public FastAllocated<TokenAdderActor>, public TokenAdderActorState<TokenAdderActor> {
															#line 214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
public:
	using FastAllocated<TokenAdderActor>::operator new;
	using FastAllocated<TokenAdderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8984069317021622016UL, 6309807918684225024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TokenAdderActor, 0, Void >;
															#line 38 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	TokenAdderActor(TokenBucket* const& self) 
															#line 231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		 : Actor<Void>(),
		   TokenAdderActorState<TokenAdderActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tokenAdder", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9386387195187968256UL, 9905856023436435968UL);
		ActorExecutionContextHelper __helper(static_cast<TokenAdderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tokenAdder");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tokenAdder", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TokenAdderActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 38 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
[[nodiscard]] static Future<Void> tokenAdder( TokenBucket* const& self ) {
															#line 38 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	return Future<Void>(new TokenAdderActor(self));
															#line 263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
}

#line 48 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"

	TokenBucket(double maxBurst = 1000) : transactionRate(0), maxBurst(maxBurst), bucketSize(maxBurst) {
		tokenAdderActor = tokenAdder(this);
	}

																#line 272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
// This generated class is to be used only via startTransaction()
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
template <class StartTransactionActor>
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
class StartTransactionActorState {
															#line 278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
public:
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	StartTransactionActorState(TokenBucket* const& self) 
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		 : self(self),
															#line 54 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		   sleepTime(addTokensInterval)
															#line 287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
	{
		fdb_probe_actor_create("startTransaction", reinterpret_cast<unsigned long>(this));

	}
	~StartTransactionActorState() 
	{
		fdb_probe_actor_destroy("startTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 55 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			;
															#line 302 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartTransactionActorState();
		static_cast<StartTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 56 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		if (self->bucketSize >= 1.0)
															#line 332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		{
															#line 57 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			--self->bucketSize;
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			if (!static_cast<StartTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartTransactionActorState(); static_cast<StartTransactionActor*>(this)->destroy(); return 0; }
															#line 338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			new (&static_cast<StartTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StartTransactionActorState();
			static_cast<StartTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		if (deterministicRandom()->randomInt(0, 100) == 0)
															#line 346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		{
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			TraceEvent("ThrottlingTransactionx100").detail("SleepTime", sleepTime);
															#line 350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		}
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(sleepTime);
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		if (static_cast<StartTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 356 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<StartTransactionActor*>(this)->actor_wait_state = 1;
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartTransactionActor, 0, Void >*>(static_cast<StartTransactionActor*>(this)));
															#line 361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		sleepTime = std::min(sleepTime * 2, maxSleepTime);
															#line 370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		sleepTime = std::min(sleepTime * 2, maxSleepTime);
															#line 379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartTransactionActor*>(this)->actor_wait_state > 0) static_cast<StartTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<StartTransactionActor*>(this)->ActorCallback< StartTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	TokenBucket* self;
															#line 54 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	double sleepTime;
															#line 463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
};
// This generated class is to be used only via startTransaction()
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
class StartTransactionActor final : public Actor<Void>, public ActorCallback< StartTransactionActor, 0, Void >, public FastAllocated<StartTransactionActor>, public StartTransactionActorState<StartTransactionActor> {
															#line 468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
public:
	using FastAllocated<StartTransactionActor>::operator new;
	using FastAllocated<StartTransactionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12380905951617096448UL, 11762638730020488192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartTransactionActor, 0, Void >;
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	StartTransactionActor(TokenBucket* const& self) 
															#line 485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		 : Actor<Void>(),
		   StartTransactionActorState<StartTransactionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7927092769933293824UL, 16612754116029991424UL);
		ActorExecutionContextHelper __helper(static_cast<StartTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartTransactionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
[[nodiscard]] static Future<Void> startTransaction( TokenBucket* const& self ) {
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	return Future<Void>(new StartTransactionActor(self));
															#line 517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
}

#line 66 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
};

// workload description:
// The Throttling workload runs a simple random read-write workload while throttling using a token bucket algorithm
// using the TPS limit obtained from the health metrics namespace. It periodically reads health metrics from the special
// key and tests whether or not the received health metrics are reasonable.
struct ThrottlingWorkload : KVWorkload {

	double testDuration;
	int actorsPerClient;
	int writesPerTransaction;
	int readsPerTransaction;
	double throttlingMultiplier;
	int transactionsCommitted;
	TokenBucket tokenBucket;
	bool correctSpecialKeys = true;

	static constexpr auto NAME = "Throttling";

	ThrottlingWorkload(WorkloadContext const& wcx) : KVWorkload(wcx), transactionsCommitted(0) {
		testDuration = getOption(options, "testDuration"_sr, 60.0);
		actorsPerClient = getOption(options, "actorsPerClient"_sr, 10);
		writesPerTransaction = getOption(options, "writesPerTransaction"_sr, 10);
		readsPerTransaction = getOption(options, "readsPerTransaction"_sr, 10);
		throttlingMultiplier = getOption(options, "throttlingMultiplier"_sr, 0.5);
		int maxBurst = getOption(options, "maxBurst"_sr, 1000);
		tokenBucket.maxBurst = maxBurst;
	}

	static Value getRandomValue() {
		return Standalone<StringRef>(format("Value/%d", deterministicRandom()->randomInt(0, 10e6)));
	}

																#line 554 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
// This generated class is to be used only via clientActor()
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
template <class ClientActorActor>
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
class ClientActorActorState {
															#line 560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
public:
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	ClientActorActorState(Database const& cx,ThrottlingWorkload* const& self) 
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		 : cx(cx),
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		   self(self),
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		   tr(cx)
															#line 571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
	{
		fdb_probe_actor_create("clientActor", reinterpret_cast<unsigned long>(this));

	}
	~ClientActorActorState() 
	{
		fdb_probe_actor_destroy("clientActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			;
															#line 586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClientActorActorState();
		static_cast<ClientActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		StrictFuture<Void> __when_expr_0 = TokenBucket::startTransaction(&self->tokenBucket);
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		if (static_cast<ClientActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ClientActorActor*>(this)->actor_wait_state = 1;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClientActorActor, 0, Void >*>(static_cast<ClientActorActor*>(this)));
															#line 623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		tr.reset();
															#line 632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		try {
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			i = int();
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			i = 0;
															#line 638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		tr.reset();
															#line 653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		try {
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			i = int();
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			i = 0;
															#line 659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClientActorActor*>(this)->actor_wait_state > 0) static_cast<ClientActorActor*>(this)->actor_wait_state = 0;
		static_cast<ClientActorActor*>(this)->ActorCallback< ClientActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClientActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClientActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClientActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			{
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		for(i = 0;i < self->writesPerTransaction;++i) {
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			tr.set(self->getRandomKey(), getRandomValue());
															#line 778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		}
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		if (static_cast<ClientActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ClientActorActor*>(this)->actor_wait_state = 3;
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClientActorActor, 2, Void >*>(static_cast<ClientActorActor*>(this)));
															#line 789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		if (!(i < self->readsPerTransaction))
															#line 805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(self->getRandomKey());
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		if (static_cast<ClientActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClientActorActor*>(this)->actor_wait_state = 2;
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClientActorActor, 1, Optional<Value> >*>(static_cast<ClientActorActor*>(this)));
															#line 818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		++i;
															#line 840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> const& __value,int loopDepth) 
	{
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		value = __value;
															#line 849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> && __value,int loopDepth) 
	{
		value = std::move(__value);
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClientActorActor*>(this)->actor_wait_state > 0) static_cast<ClientActorActor*>(this)->actor_wait_state = 0;
		static_cast<ClientActorActor*>(this)->ActorCallback< ClientActorActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ClientActorActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClientActorActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClientActorActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		if (deterministicRandom()->randomInt(0, 1000) == 0)
															#line 928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		{
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			TraceEvent("TransactionCommittedx1000").log();
															#line 932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		}
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		++self->transactionsCommitted;
															#line 936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		if (deterministicRandom()->randomInt(0, 1000) == 0)
															#line 945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		{
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			TraceEvent("TransactionCommittedx1000").log();
															#line 949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		}
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		++self->transactionsCommitted;
															#line 953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClientActorActor*>(this)->actor_wait_state > 0) static_cast<ClientActorActor*>(this)->actor_wait_state = 0;
		static_cast<ClientActorActor*>(this)->ActorCallback< ClientActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClientActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClientActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClientActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	Database cx;
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	ThrottlingWorkload* self;
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	int i;
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	Optional<Value> value;
															#line 1056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
};
// This generated class is to be used only via clientActor()
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
class ClientActorActor final : public Actor<Void>, public ActorCallback< ClientActorActor, 0, Void >, public ActorCallback< ClientActorActor, 1, Optional<Value> >, public ActorCallback< ClientActorActor, 2, Void >, public FastAllocated<ClientActorActor>, public ClientActorActorState<ClientActorActor> {
															#line 1061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
public:
	using FastAllocated<ClientActorActor>::operator new;
	using FastAllocated<ClientActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7857485770030625280UL, 18429868994470760704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClientActorActor, 0, Void >;
friend struct ActorCallback< ClientActorActor, 1, Optional<Value> >;
friend struct ActorCallback< ClientActorActor, 2, Void >;
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	ClientActorActor(Database const& cx,ThrottlingWorkload* const& self) 
															#line 1080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		 : Actor<Void>(),
		   ClientActorActorState<ClientActorActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clientActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6021943787349627904UL, 14719853726392556032UL);
		ActorExecutionContextHelper __helper(static_cast<ClientActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clientActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clientActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClientActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClientActorActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClientActorActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
[[nodiscard]] static Future<Void> clientActor( Database const& cx, ThrottlingWorkload* const& self ) {
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	return Future<Void>(new ClientActorActor(cx, self));
															#line 1114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
}

#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"

																#line 1119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
// This generated class is to be used only via specialKeysActor()
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
template <class SpecialKeysActorActor>
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
class SpecialKeysActorActorState {
															#line 1125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
public:
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	SpecialKeysActorActorState(Database const& cx,ThrottlingWorkload* const& self) 
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		 : cx(cx),
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		   self(self),
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		   tr(cx),
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		   aggregateSchema(readJSONStrictly(JSONSchemas::aggregateHealthSchema.toString()).get_obj()),
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		   storageSchema(readJSONStrictly(JSONSchemas::storageHealthSchema.toString()).get_obj()),
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		   logSchema(readJSONStrictly(JSONSchemas::logHealthSchema.toString()).get_obj())
															#line 1142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
	{
		fdb_probe_actor_create("specialKeysActor", reinterpret_cast<unsigned long>(this));

	}
	~SpecialKeysActorActorState() 
	{
		fdb_probe_actor_destroy("specialKeysActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			;
															#line 1157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SpecialKeysActorActorState();
		static_cast<SpecialKeysActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(prefixRange("\xff\xff/metrics/health/"_sr), CLIENT_KNOBS->TOO_MANY);
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			if (static_cast<SpecialKeysActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SpecialKeysActorActor*>(this)->actor_wait_state = 1;
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SpecialKeysActorActor, 0, RangeResult >*>(static_cast<SpecialKeysActorActor*>(this)));
															#line 1195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			if (static_cast<SpecialKeysActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SpecialKeysActorActor*>(this)->actor_wait_state = 3;
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SpecialKeysActorActor, 2, Void >*>(static_cast<SpecialKeysActorActor*>(this)));
															#line 1224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& result,int loopDepth) 
	{
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		ASSERT(!result.more);
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		for( const auto& [k, v] : result ) {
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			ASSERT(k.startsWith("\xff\xff/metrics/health/"_sr));
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			auto valueObj = readJSONStrictly(v.toString()).get_obj();
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			if (k.removePrefix("\xff\xff/metrics/health/"_sr) == "aggregate"_sr)
															#line 1247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			{
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
				CODE_PROBE(true, "Test aggregate health metrics schema");
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
				std::string errorStr;
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
				if (!schemaMatch(aggregateSchema, valueObj, errorStr, SevError, true))
															#line 1255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
				{
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
					TraceEvent(SevError, "AggregateHealthSchemaValidationFailed") .detail("ErrorStr", errorStr.c_str()) .detail("JSON", json_spirit::write_string(json_spirit::mValue(v.toString())));
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
					self->correctSpecialKeys = false;
															#line 1261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
				}
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
				auto tpsLimit = valueObj.at("tps_limit").get_real();
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
				self->tokenBucket.transactionRate = tpsLimit * self->throttlingMultiplier / self->clientCount;
															#line 1267 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			}
			else
			{
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
				if (k.removePrefix("\xff\xff/metrics/health/"_sr).startsWith("storage/"_sr))
															#line 1273 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
				{
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
					CODE_PROBE(true, "Test storage health metrics schema");
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
					UID::fromString(k.removePrefix("\xff\xff/metrics/health/storage/"_sr) .toString());
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
					std::string errorStr;
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
					if (!schemaMatch(storageSchema, valueObj, errorStr, SevError, true))
															#line 1283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
					{
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
						TraceEvent(SevError, "StorageHealthSchemaValidationFailed") .detail("ErrorStr", errorStr.c_str()) .detail("JSON", json_spirit::write_string(json_spirit::mValue(v.toString())));
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
						self->correctSpecialKeys = false;
															#line 1289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
					}
				}
				else
				{
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
					if (k.removePrefix("\xff\xff/metrics/health/"_sr).startsWith("log/"_sr))
															#line 1296 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
					{
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
						CODE_PROBE(true, "Test log health metrics schema");
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
						UID::fromString(k.removePrefix("\xff\xff/metrics/health/log/"_sr) .toString());
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
						std::string errorStr;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
						if (!schemaMatch(logSchema, valueObj, errorStr, SevError, true))
															#line 1306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
						{
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
							TraceEvent(SevError, "LogHealthSchemaValidationFailed") .detail("ErrorStr", errorStr.c_str()) .detail("JSON", json_spirit::write_string(json_spirit::mValue(v.toString())));
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
							self->correctSpecialKeys = false;
															#line 1312 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
						}
					}
					else
					{
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
						ASSERT(false);
															#line 1319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
					}
				}
			}
		}
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(5);
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		if (static_cast<SpecialKeysActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SpecialKeysActorActor*>(this)->actor_wait_state = 2;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SpecialKeysActorActor, 1, Void >*>(static_cast<SpecialKeysActorActor*>(this)));
															#line 1333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && result,int loopDepth) 
	{
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		ASSERT(!result.more);
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		for( const auto& [k, v] : result ) {
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			ASSERT(k.startsWith("\xff\xff/metrics/health/"_sr));
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			auto valueObj = readJSONStrictly(v.toString()).get_obj();
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			if (k.removePrefix("\xff\xff/metrics/health/"_sr) == "aggregate"_sr)
															#line 1350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			{
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
				CODE_PROBE(true, "Test aggregate health metrics schema");
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
				std::string errorStr;
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
				if (!schemaMatch(aggregateSchema, valueObj, errorStr, SevError, true))
															#line 1358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
				{
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
					TraceEvent(SevError, "AggregateHealthSchemaValidationFailed") .detail("ErrorStr", errorStr.c_str()) .detail("JSON", json_spirit::write_string(json_spirit::mValue(v.toString())));
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
					self->correctSpecialKeys = false;
															#line 1364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
				}
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
				auto tpsLimit = valueObj.at("tps_limit").get_real();
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
				self->tokenBucket.transactionRate = tpsLimit * self->throttlingMultiplier / self->clientCount;
															#line 1370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			}
			else
			{
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
				if (k.removePrefix("\xff\xff/metrics/health/"_sr).startsWith("storage/"_sr))
															#line 1376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
				{
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
					CODE_PROBE(true, "Test storage health metrics schema");
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
					UID::fromString(k.removePrefix("\xff\xff/metrics/health/storage/"_sr) .toString());
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
					std::string errorStr;
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
					if (!schemaMatch(storageSchema, valueObj, errorStr, SevError, true))
															#line 1386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
					{
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
						TraceEvent(SevError, "StorageHealthSchemaValidationFailed") .detail("ErrorStr", errorStr.c_str()) .detail("JSON", json_spirit::write_string(json_spirit::mValue(v.toString())));
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
						self->correctSpecialKeys = false;
															#line 1392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
					}
				}
				else
				{
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
					if (k.removePrefix("\xff\xff/metrics/health/"_sr).startsWith("log/"_sr))
															#line 1399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
					{
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
						CODE_PROBE(true, "Test log health metrics schema");
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
						UID::fromString(k.removePrefix("\xff\xff/metrics/health/log/"_sr) .toString());
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
						std::string errorStr;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
						if (!schemaMatch(logSchema, valueObj, errorStr, SevError, true))
															#line 1409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
						{
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
							TraceEvent(SevError, "LogHealthSchemaValidationFailed") .detail("ErrorStr", errorStr.c_str()) .detail("JSON", json_spirit::write_string(json_spirit::mValue(v.toString())));
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
							self->correctSpecialKeys = false;
															#line 1415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
						}
					}
					else
					{
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
						ASSERT(false);
															#line 1422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
					}
				}
			}
		}
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(5);
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		if (static_cast<SpecialKeysActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SpecialKeysActorActor*>(this)->actor_wait_state = 2;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SpecialKeysActorActor, 1, Void >*>(static_cast<SpecialKeysActorActor*>(this)));
															#line 1436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SpecialKeysActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeysActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeysActorActor*>(this)->ActorCallback< SpecialKeysActorActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeysActorActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("specialKeysActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeysActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("specialKeysActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SpecialKeysActorActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("specialKeysActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeysActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("specialKeysActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SpecialKeysActorActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("specialKeysActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeysActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("specialKeysActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SpecialKeysActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeysActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeysActorActor*>(this)->ActorCallback< SpecialKeysActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeysActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("specialKeysActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeysActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("specialKeysActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SpecialKeysActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("specialKeysActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeysActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("specialKeysActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SpecialKeysActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("specialKeysActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeysActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("specialKeysActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont14(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SpecialKeysActorActor*>(this)->actor_wait_state > 0) static_cast<SpecialKeysActorActor*>(this)->actor_wait_state = 0;
		static_cast<SpecialKeysActorActor*>(this)->ActorCallback< SpecialKeysActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SpecialKeysActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("specialKeysActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeysActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("specialKeysActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SpecialKeysActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("specialKeysActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeysActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("specialKeysActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SpecialKeysActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("specialKeysActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeysActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("specialKeysActor", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	Database cx;
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	ThrottlingWorkload* self;
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	json_spirit::mValue aggregateSchema;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	json_spirit::mValue storageSchema;
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	json_spirit::mValue logSchema;
															#line 1715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
};
// This generated class is to be used only via specialKeysActor()
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
class SpecialKeysActorActor final : public Actor<Void>, public ActorCallback< SpecialKeysActorActor, 0, RangeResult >, public ActorCallback< SpecialKeysActorActor, 1, Void >, public ActorCallback< SpecialKeysActorActor, 2, Void >, public FastAllocated<SpecialKeysActorActor>, public SpecialKeysActorActorState<SpecialKeysActorActor> {
															#line 1720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
public:
	using FastAllocated<SpecialKeysActorActor>::operator new;
	using FastAllocated<SpecialKeysActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7303642455694373120UL, 4659251210052988928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SpecialKeysActorActor, 0, RangeResult >;
friend struct ActorCallback< SpecialKeysActorActor, 1, Void >;
friend struct ActorCallback< SpecialKeysActorActor, 2, Void >;
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	SpecialKeysActorActor(Database const& cx,ThrottlingWorkload* const& self) 
															#line 1739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		 : Actor<Void>(),
		   SpecialKeysActorActorState<SpecialKeysActorActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("specialKeysActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4730072314823998720UL, 4632338522313574912UL);
		ActorExecutionContextHelper __helper(static_cast<SpecialKeysActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("specialKeysActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("specialKeysActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SpecialKeysActorActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SpecialKeysActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SpecialKeysActorActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
[[nodiscard]] static Future<Void> specialKeysActor( Database const& cx, ThrottlingWorkload* const& self ) {
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	return Future<Void>(new SpecialKeysActorActor(cx, self));
															#line 1773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
}

#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"

																#line 1778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
template <class _startActor>
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
class _startActorState {
															#line 1784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
public:
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	_startActorState(Database const& cx,ThrottlingWorkload* const& self) 
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		 : cx(cx),
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		   self(self),
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		   clientActors(),
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		   actorId()
															#line 1797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			for(actorId = 0;actorId < self->actorsPerClient;++actorId) {
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
				clientActors.push_back(timeout(clientActor(cx, self), self->testDuration, Void()));
															#line 1814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			}
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			clientActors.push_back(timeout(specialKeysActor(cx, self), self->testDuration, Void()));
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			clientActors.push_back(timeout(self->tokenBucket.tokenAdderActor, self->testDuration, Void()));
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->testDuration);
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1824 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	Database cx;
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	ThrottlingWorkload* self;
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	std::vector<Future<Void>> clientActors;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	int actorId;
															#line 1955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11878266014849511424UL, 4054981077334266368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	_startActor(Database const& cx,ThrottlingWorkload* const& self) 
															#line 1977 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, ThrottlingWorkload* const& self ) {
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 2009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Throttling.actor.g.cpp"
}

#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/Throttling.actor.cpp"

	Future<Void> start(Database const& cx) override { return _start(cx, this); }
	Future<bool> check(Database const& cx) override { return correctSpecialKeys; }

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.emplace_back("TransactionsCommitted", transactionsCommitted, Averaged::False);
	}
};

WorkloadFactory<ThrottlingWorkload> ThrottlingWorkloadFactory;
