#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
/*
 * Storefront.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// Storefront workload will maintain 2 tables: one for orders and one for items
// Items table will have an entry for each item and the current total of "unfilled" orders
// Orders table will have an entry for each order with a 16-character representation list of each item ordered

typedef uint64_t orderID;

struct StorefrontWorkload : TestWorkload {
	static constexpr auto NAME = "Storefront";

	double testDuration, transactionsPerSecond;
	int actorCount, itemCount, maxOrderSize;
	// bool isFulfilling;

	std::vector<Future<Void>> clients;
	std::map<orderID, std::map<int, int>> orders;
	PerfIntCounter transactions, retries, spuriousCommitFailures;
	PerfDoubleCounter totalLatency;

	StorefrontWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), transactions("Transactions"), retries("Retries"),
	    spuriousCommitFailures("Spurious Commit Failures"), totalLatency("Total Latency") {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		transactionsPerSecond = getOption(options, "transactionsPerSecond"_sr, 1000.0);
		actorCount = getOption(options, "actorsPerClient"_sr, std::max((int)(transactionsPerSecond / 100), 1));
		maxOrderSize = getOption(options, "maxOrderSize"_sr, 20);
		itemCount = getOption(options, "itemCount"_sr, transactionsPerSecond * clientCount * maxOrderSize);
	}

	Future<Void> setup(Database const& cx) override { return bulkSetup(cx, this, itemCount, Promise<double>()); }

	Future<Void> start(Database const& cx) override {
		for (int c = 0; c < actorCount; c++)
			clients.push_back(orderingClient(cx->clone(), this, actorCount / transactionsPerSecond));
		/*if(isFulfilling)
		    for(int c=0; c<actorCount; c++)
		            clients.push_back(
		                fulfillmentClient( cx->clone(), this, actorCount / transactionsPerSecond, itemCount ) );*/
		return delay(testDuration);
	}

	Future<bool> check(Database const& cx) override {
		int errors = 0;
		for (int c = 0; c < clients.size(); c++)
			if (clients[c].isError()) {
				errors++;
				TraceEvent(SevError, "TestFailure").error(clients[c].getError()).detail("Reason", "ClientError");
			}
		clients.clear();
		return inventoryCheck(cx->clone(), this, !errors);
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(transactions.getMetric());
		m.push_back(retries.getMetric());
		m.emplace_back("Avg Latency (ms)", 1000 * totalLatency.getValue() / transactions.getValue(), Averaged::True);
	}

	/*static inline orderID valueToOrderID( const StringRef& v ) {
	    orderID x = 0;
	    sscanf( v.toString().c_str(), "%llx", &x );
	    return x;
	}*/

	static inline int valueToInt(const StringRef& v) {
		int x = 0;
		sscanf(v.toString().c_str(), "%d", &x);
		return x;
	}

	Key keyForIndex(int n) { return itemKey(n); }
	Key itemKey(int item) { return StringRef(format("/items/%016d", item)); }
	Key orderKey(orderID order) { return StringRef(format("/orders/%016llx", order)); }
	Value itemValue(int count) { return StringRef(format("%d", count)); }

	Standalone<KeyValueRef> operator()(int n) { return KeyValueRef(itemKey(n), itemValue(0)); }

																#line 105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
// This generated class is to be used only via itemUpdater()
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
template <class ItemUpdaterActor>
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
class ItemUpdaterActorState {
															#line 111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
public:
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	ItemUpdaterActorState(Transaction* const& tr,StorefrontWorkload* const& self,int const& item,int const& quantity) 
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		 : tr(tr),
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		   self(self),
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		   item(item),
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		   quantity(quantity),
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		   iKey(self->itemKey(item))
															#line 126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
	{
		fdb_probe_actor_create("itemUpdater", reinterpret_cast<unsigned long>(this));

	}
	~ItemUpdaterActorState() 
	{
		fdb_probe_actor_destroy("itemUpdater", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(iKey);
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			if (static_cast<ItemUpdaterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ItemUpdaterActor*>(this)->actor_wait_state = 1;
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ItemUpdaterActor, 0, Optional<Value> >*>(static_cast<ItemUpdaterActor*>(this)));
															#line 148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ItemUpdaterActorState();
		static_cast<ItemUpdaterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (!val.present())
															#line 171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		{
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			TraceEvent(SevError, "StorefrontItemMissing") .detail("Key", printable(iKey)) .detail("Item", item) .detail("Version", tr->getReadVersion().get()) .detailf("From", "%016llx", debug_lastLoadBalanceResultEndpointToken);
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			ASSERT(val.present());
															#line 177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		}
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		int currentCount = valueToInt(val.get());
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		tr->set(iKey, self->itemValue(currentCount + quantity));
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (!static_cast<ItemUpdaterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ItemUpdaterActorState(); static_cast<ItemUpdaterActor*>(this)->destroy(); return 0; }
															#line 185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		new (&static_cast<ItemUpdaterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ItemUpdaterActorState();
		static_cast<ItemUpdaterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (!val.present())
															#line 197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		{
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			TraceEvent(SevError, "StorefrontItemMissing") .detail("Key", printable(iKey)) .detail("Item", item) .detail("Version", tr->getReadVersion().get()) .detailf("From", "%016llx", debug_lastLoadBalanceResultEndpointToken);
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			ASSERT(val.present());
															#line 203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		}
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		int currentCount = valueToInt(val.get());
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		tr->set(iKey, self->itemValue(currentCount + quantity));
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (!static_cast<ItemUpdaterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ItemUpdaterActorState(); static_cast<ItemUpdaterActor*>(this)->destroy(); return 0; }
															#line 211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		new (&static_cast<ItemUpdaterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ItemUpdaterActorState();
		static_cast<ItemUpdaterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ItemUpdaterActor*>(this)->actor_wait_state > 0) static_cast<ItemUpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<ItemUpdaterActor*>(this)->ActorCallback< ItemUpdaterActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ItemUpdaterActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("itemUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ItemUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("itemUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ItemUpdaterActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("itemUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ItemUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("itemUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ItemUpdaterActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("itemUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ItemUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("itemUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	Transaction* tr;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	StorefrontWorkload* self;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	int item;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	int quantity;
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	Key iKey;
															#line 304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
};
// This generated class is to be used only via itemUpdater()
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
class ItemUpdaterActor final : public Actor<Void>, public ActorCallback< ItemUpdaterActor, 0, Optional<Value> >, public FastAllocated<ItemUpdaterActor>, public ItemUpdaterActorState<ItemUpdaterActor> {
															#line 309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
public:
	using FastAllocated<ItemUpdaterActor>::operator new;
	using FastAllocated<ItemUpdaterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10239153179773288960UL, 6758705725613565696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ItemUpdaterActor, 0, Optional<Value> >;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	ItemUpdaterActor(Transaction* const& tr,StorefrontWorkload* const& self,int const& item,int const& quantity) 
															#line 326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		 : Actor<Void>(),
		   ItemUpdaterActorState<ItemUpdaterActor>(tr, self, item, quantity),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("itemUpdater", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3316327942179076864UL, 9698781951958476544UL);
		ActorExecutionContextHelper __helper(static_cast<ItemUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("itemUpdater");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("itemUpdater", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ItemUpdaterActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
[[nodiscard]] Future<Void> itemUpdater( Transaction* const& tr, StorefrontWorkload* const& self, int const& item, int const& quantity ) {
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	return Future<Void>(new ItemUpdaterActor(tr, self, item, quantity));
															#line 358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
}

#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"

																#line 363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
// This generated class is to be used only via orderingClient()
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
template <class OrderingClientActor>
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
class OrderingClientActorState {
															#line 369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
public:
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	OrderingClientActorState(Database const& cx,StorefrontWorkload* const& self,double const& delay) 
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		 : cx(cx),
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		   self(self),
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		   delay(delay),
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		   lastTime(now())
															#line 382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
	{
		fdb_probe_actor_create("orderingClient", reinterpret_cast<unsigned long>(this));

	}
	~OrderingClientActorState() 
	{
		fdb_probe_actor_destroy("orderingClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
				;
															#line 398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OrderingClientActorState();
		static_cast<OrderingClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			TraceEvent(SevError, "OrderingClient").error(e);
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, delay);
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (static_cast<OrderingClientActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<OrderingClientActor*>(this)->actor_wait_state = 1;
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OrderingClientActor, 0, Void >*>(static_cast<OrderingClientActor*>(this)));
															#line 458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		tstart = now();
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		itemsToOrder = deterministicRandom()->randomInt(1, self->maxOrderSize);
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		id = deterministicRandom()->randomUniqueID().hash();
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		orderKey = self->orderKey(id);
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		tr = Transaction(cx);
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		;
															#line 477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		tstart = now();
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		itemsToOrder = deterministicRandom()->randomInt(1, self->maxOrderSize);
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		id = deterministicRandom()->randomUniqueID().hash();
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		orderKey = self->orderKey(id);
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		tr = Transaction(cx);
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		;
															#line 496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OrderingClientActor*>(this)->actor_wait_state > 0) static_cast<OrderingClientActor*>(this)->actor_wait_state = 0;
		static_cast<OrderingClientActor*>(this)->ActorCallback< OrderingClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OrderingClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OrderingClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OrderingClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		++self->transactions;
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		self->totalLatency += now() - tstart;
															#line 582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(orderKey);
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			if (static_cast<OrderingClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<OrderingClientActor*>(this)->actor_wait_state = 2;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OrderingClientActor, 1, Optional<Value> >*>(static_cast<OrderingClientActor*>(this)));
															#line 606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		++self->retries;
															#line 634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			if (static_cast<OrderingClientActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 646 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<OrderingClientActor*>(this)->actor_wait_state = 5;
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< OrderingClientActor, 4, Void >*>(static_cast<OrderingClientActor*>(this)));
															#line 651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Value> const& order,int loopDepth) 
	{
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (order.present())
															#line 666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		{
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			++self->spuriousCommitFailures;
															#line 670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		items = std::map<int, int>();
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		for(int i = 0;i < itemsToOrder;i++) {
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			items[deterministicRandom()->randomInt(0, self->itemCount)]++;
															#line 679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		}
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		itemList = std::vector<int>();
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		std::map<int, int>::iterator it;
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		updaters = std::vector<Future<Void>>();
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		for(it = items.begin();it != items.end();it++) {
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			for(int i = 0;i < it->second;i++) {
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
				itemList.push_back(it->first);
															#line 693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			}
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			updaters.push_back(self->itemUpdater(&tr, self, it->first, it->second));
															#line 697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		}
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(updaters);
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (static_cast<OrderingClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<OrderingClientActor*>(this)->actor_wait_state = 3;
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< OrderingClientActor, 2, Void >*>(static_cast<OrderingClientActor*>(this)));
															#line 708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Value> && order,int loopDepth) 
	{
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (order.present())
															#line 717 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		{
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			++self->spuriousCommitFailures;
															#line 721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		items = std::map<int, int>();
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		for(int i = 0;i < itemsToOrder;i++) {
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			items[deterministicRandom()->randomInt(0, self->itemCount)]++;
															#line 730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		}
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		itemList = std::vector<int>();
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		std::map<int, int>::iterator it;
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		updaters = std::vector<Future<Void>>();
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		for(it = items.begin();it != items.end();it++) {
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			for(int i = 0;i < it->second;i++) {
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
				itemList.push_back(it->first);
															#line 744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			}
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			updaters.push_back(self->itemUpdater(&tr, self, it->first, it->second));
															#line 748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		}
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(updaters);
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (static_cast<OrderingClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<OrderingClientActor*>(this)->actor_wait_state = 3;
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< OrderingClientActor, 2, Void >*>(static_cast<OrderingClientActor*>(this)));
															#line 759 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> const& order,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(order, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> && order,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(order), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OrderingClientActor*>(this)->actor_wait_state > 0) static_cast<OrderingClientActor*>(this)->actor_wait_state = 0;
		static_cast<OrderingClientActor*>(this)->ActorCallback< OrderingClientActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< OrderingClientActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OrderingClientActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OrderingClientActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		updaters.clear();
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		BinaryWriter wr(AssumeVersion(g_network->protocolVersion()));
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		wr << itemList;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		tr.set(orderKey, wr.toValue());
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (static_cast<OrderingClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<OrderingClientActor*>(this)->actor_wait_state = 4;
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< OrderingClientActor, 3, Void >*>(static_cast<OrderingClientActor*>(this)));
															#line 858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		updaters.clear();
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		BinaryWriter wr(AssumeVersion(g_network->protocolVersion()));
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		wr << itemList;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		tr.set(orderKey, wr.toValue());
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (static_cast<OrderingClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<OrderingClientActor*>(this)->actor_wait_state = 4;
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< OrderingClientActor, 3, Void >*>(static_cast<OrderingClientActor*>(this)));
															#line 882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<OrderingClientActor*>(this)->actor_wait_state > 0) static_cast<OrderingClientActor*>(this)->actor_wait_state = 0;
		static_cast<OrderingClientActor*>(this)->ActorCallback< OrderingClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OrderingClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< OrderingClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< OrderingClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		self->orders[id] = items;
															#line 966 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		self->orders[id] = items;
															#line 975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<OrderingClientActor*>(this)->actor_wait_state > 0) static_cast<OrderingClientActor*>(this)->actor_wait_state = 0;
		static_cast<OrderingClientActor*>(this)->ActorCallback< OrderingClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OrderingClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< OrderingClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< OrderingClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<OrderingClientActor*>(this)->actor_wait_state > 0) static_cast<OrderingClientActor*>(this)->actor_wait_state = 0;
		static_cast<OrderingClientActor*>(this)->ActorCallback< OrderingClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OrderingClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< OrderingClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< OrderingClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	Database cx;
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	StorefrontWorkload* self;
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	double delay;
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	double lastTime;
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	double tstart;
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	int itemsToOrder;
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	orderID id;
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	Key orderKey;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	Transaction tr;
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	std::map<int, int> items;
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	std::vector<int> itemList;
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	std::vector<Future<Void>> updaters;
															#line 1166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
};
// This generated class is to be used only via orderingClient()
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
class OrderingClientActor final : public Actor<Void>, public ActorCallback< OrderingClientActor, 0, Void >, public ActorCallback< OrderingClientActor, 1, Optional<Value> >, public ActorCallback< OrderingClientActor, 2, Void >, public ActorCallback< OrderingClientActor, 3, Void >, public ActorCallback< OrderingClientActor, 4, Void >, public FastAllocated<OrderingClientActor>, public OrderingClientActorState<OrderingClientActor> {
															#line 1171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
public:
	using FastAllocated<OrderingClientActor>::operator new;
	using FastAllocated<OrderingClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15161119118568682496UL, 421574496167528704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OrderingClientActor, 0, Void >;
friend struct ActorCallback< OrderingClientActor, 1, Optional<Value> >;
friend struct ActorCallback< OrderingClientActor, 2, Void >;
friend struct ActorCallback< OrderingClientActor, 3, Void >;
friend struct ActorCallback< OrderingClientActor, 4, Void >;
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	OrderingClientActor(Database const& cx,StorefrontWorkload* const& self,double const& delay) 
															#line 1192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		 : Actor<Void>(),
		   OrderingClientActorState<OrderingClientActor>(cx, self, delay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("orderingClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13119216650528016128UL, 17748870771655984128UL);
		ActorExecutionContextHelper __helper(static_cast<OrderingClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("orderingClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("orderingClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OrderingClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OrderingClientActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< OrderingClientActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< OrderingClientActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< OrderingClientActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
[[nodiscard]] Future<Void> orderingClient( Database const& cx, StorefrontWorkload* const& self, double const& delay ) {
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	return Future<Void>(new OrderingClientActor(cx, self, delay));
															#line 1228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
}

#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"

																#line 1233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
// This generated class is to be used only via orderChecker()
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
template <class OrderCheckerActor>
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
class OrderCheckerActorState {
															#line 1239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
public:
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	OrderCheckerActorState(Database const& cx,StorefrontWorkload* const& self,std::vector<orderID> const& ids) 
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		 : cx(cx),
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		   self(self),
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		   ids(ids),
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		   tr(cx),
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		   idx(0)
															#line 1254 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
	{
		fdb_probe_actor_create("orderChecker", reinterpret_cast<unsigned long>(this));

	}
	~OrderCheckerActorState() 
	{
		fdb_probe_actor_destroy("orderChecker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			;
															#line 1269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OrderCheckerActorState();
		static_cast<OrderCheckerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			;
															#line 1300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			if (static_cast<OrderCheckerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<OrderCheckerActor*>(this)->actor_wait_state = 2;
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OrderCheckerActor, 1, Void >*>(static_cast<OrderCheckerActor*>(this)));
															#line 1329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 204 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (!static_cast<OrderCheckerActor*>(this)->SAV<bool>::futures) { (void)(true); this->~OrderCheckerActorState(); static_cast<OrderCheckerActor*>(this)->destroy(); return 0; }
															#line 1344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		new (&static_cast<OrderCheckerActor*>(this)->SAV< bool >::value()) bool(true);
		this->~OrderCheckerActorState();
		static_cast<OrderCheckerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (!(idx < ids.size()))
															#line 1363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		id = ids[idx];
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_0 = tr.get(self->orderKey(id));
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (static_cast<OrderCheckerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<OrderCheckerActor*>(this)->actor_wait_state = 1;
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OrderCheckerActor, 0, Optional<Value> >*>(static_cast<OrderCheckerActor*>(this)));
															#line 1378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (!val.present())
															#line 1400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		{
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			TraceEvent(SevError, "TestFailure").detail("Reason", "OrderNotPresent").detail("OrderID", id);
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			if (!static_cast<OrderCheckerActor*>(this)->SAV<bool>::futures) { (void)(false); this->~OrderCheckerActorState(); static_cast<OrderCheckerActor*>(this)->destroy(); return 0; }
															#line 1406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			new (&static_cast<OrderCheckerActor*>(this)->SAV< bool >::value()) bool(false);
			this->~OrderCheckerActorState();
			static_cast<OrderCheckerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		std::vector<int> itemList;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		std::map<int, int>::iterator it;
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		for(it = self->orders[id].begin();it != self->orders[id].end();it++) {
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			for(int i = 0;i < it->second;i++) {
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
				itemList.push_back(it->first);
															#line 1422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			}
		}
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		BinaryWriter wr(AssumeVersion(g_network->protocolVersion()));
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		wr << itemList;
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (wr.toValue() != val.get().toString())
															#line 1431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		{
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			TraceEvent(SevError, "TestFailure") .detail("Reason", "OrderContentsMismatch") .detail("OrderID", id);
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			if (!static_cast<OrderCheckerActor*>(this)->SAV<bool>::futures) { (void)(false); this->~OrderCheckerActorState(); static_cast<OrderCheckerActor*>(this)->destroy(); return 0; }
															#line 1437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			new (&static_cast<OrderCheckerActor*>(this)->SAV< bool >::value()) bool(false);
			this->~OrderCheckerActorState();
			static_cast<OrderCheckerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		idx++;
															#line 1445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (!val.present())
															#line 1454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		{
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			TraceEvent(SevError, "TestFailure").detail("Reason", "OrderNotPresent").detail("OrderID", id);
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			if (!static_cast<OrderCheckerActor*>(this)->SAV<bool>::futures) { (void)(false); this->~OrderCheckerActorState(); static_cast<OrderCheckerActor*>(this)->destroy(); return 0; }
															#line 1460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			new (&static_cast<OrderCheckerActor*>(this)->SAV< bool >::value()) bool(false);
			this->~OrderCheckerActorState();
			static_cast<OrderCheckerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		std::vector<int> itemList;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		std::map<int, int>::iterator it;
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		for(it = self->orders[id].begin();it != self->orders[id].end();it++) {
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			for(int i = 0;i < it->second;i++) {
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
				itemList.push_back(it->first);
															#line 1476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			}
		}
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		BinaryWriter wr(AssumeVersion(g_network->protocolVersion()));
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		wr << itemList;
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (wr.toValue() != val.get().toString())
															#line 1485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		{
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			TraceEvent(SevError, "TestFailure") .detail("Reason", "OrderContentsMismatch") .detail("OrderID", id);
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			if (!static_cast<OrderCheckerActor*>(this)->SAV<bool>::futures) { (void)(false); this->~OrderCheckerActorState(); static_cast<OrderCheckerActor*>(this)->destroy(); return 0; }
															#line 1491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			new (&static_cast<OrderCheckerActor*>(this)->SAV< bool >::value()) bool(false);
			this->~OrderCheckerActorState();
			static_cast<OrderCheckerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 182 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		idx++;
															#line 1499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OrderCheckerActor*>(this)->actor_wait_state > 0) static_cast<OrderCheckerActor*>(this)->actor_wait_state = 0;
		static_cast<OrderCheckerActor*>(this)->ActorCallback< OrderCheckerActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< OrderCheckerActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("orderChecker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrderCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderChecker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OrderCheckerActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("orderChecker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrderCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderChecker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OrderCheckerActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("orderChecker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OrderCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderChecker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OrderCheckerActor*>(this)->actor_wait_state > 0) static_cast<OrderCheckerActor*>(this)->actor_wait_state = 0;
		static_cast<OrderCheckerActor*>(this)->ActorCallback< OrderCheckerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OrderCheckerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("orderChecker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrderCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderChecker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OrderCheckerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("orderChecker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OrderCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderChecker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OrderCheckerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("orderChecker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OrderCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("orderChecker", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	Database cx;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	StorefrontWorkload* self;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	std::vector<orderID> ids;
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	Transaction tr;
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	int idx;
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	orderID id;
															#line 1678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
};
// This generated class is to be used only via orderChecker()
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
class OrderCheckerActor final : public Actor<bool>, public ActorCallback< OrderCheckerActor, 0, Optional<Value> >, public ActorCallback< OrderCheckerActor, 1, Void >, public FastAllocated<OrderCheckerActor>, public OrderCheckerActorState<OrderCheckerActor> {
															#line 1683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
public:
	using FastAllocated<OrderCheckerActor>::operator new;
	using FastAllocated<OrderCheckerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4495350155468254464UL, 17306098758885475072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OrderCheckerActor, 0, Optional<Value> >;
friend struct ActorCallback< OrderCheckerActor, 1, Void >;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	OrderCheckerActor(Database const& cx,StorefrontWorkload* const& self,std::vector<orderID> const& ids) 
															#line 1701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		 : Actor<bool>(),
		   OrderCheckerActorState<OrderCheckerActor>(cx, self, ids),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("orderChecker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10361889986340222208UL, 1019863462488026112UL);
		ActorExecutionContextHelper __helper(static_cast<OrderCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("orderChecker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("orderChecker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OrderCheckerActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OrderCheckerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
[[nodiscard]] Future<bool> orderChecker( Database const& cx, StorefrontWorkload* const& self, std::vector<orderID> const& ids ) {
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	return Future<bool>(new OrderCheckerActor(cx, self, ids));
															#line 1734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
}

#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"

																#line 1739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
// This generated class is to be used only via inventoryCheck()
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
template <class InventoryCheckActor>
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
class InventoryCheckActorState {
															#line 1745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
public:
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	InventoryCheckActorState(Database const& cx,StorefrontWorkload* const& self,bool const& ok) 
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		 : cx(cx),
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		   self(self),
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		   ok(ok),
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		   checkers(),
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		   it(self->orders.begin())
															#line 1760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
	{
		fdb_probe_actor_create("inventoryCheck", reinterpret_cast<unsigned long>(this));

	}
	~InventoryCheckActorState() 
	{
		fdb_probe_actor_destroy("inventoryCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			;
															#line 1775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InventoryCheckActorState();
		static_cast<InventoryCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (!static_cast<InventoryCheckActor*>(this)->SAV<bool>::futures) { (void)(ok); this->~InventoryCheckActorState(); static_cast<InventoryCheckActor*>(this)->destroy(); return 0; }
															#line 1798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		new (&static_cast<InventoryCheckActor*>(this)->SAV< bool >::value()) bool(std::move(ok)); // state_var_RVO
		this->~InventoryCheckActorState();
		static_cast<InventoryCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (!(it != self->orders.end()))
															#line 1817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		for(int a = 0;a < self->actorCount && it != self->orders.end();a++) {
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			std::vector<orderID> orderIDs;
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			for(int i = 0;i < 100 && it != self->orders.end();i++) {
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
				orderIDs.push_back(it->first);
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
				it++;
															#line 1831 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
			}
															#line 221 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			checkers.push_back(self->orderChecker(cx->clone(), self, orderIDs));
															#line 1835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		}
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitForAll(checkers);
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		if (static_cast<InventoryCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<InventoryCheckActor*>(this)->actor_wait_state = 1;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InventoryCheckActor, 0, Void >*>(static_cast<InventoryCheckActor*>(this)));
															#line 1846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		for(int c = 0;c < checkers.size();c++) {
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			ok = ok && !checkers[c].isError() && checkers[c].isReady() && checkers[c].get();
															#line 1870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		}
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		checkers.clear();
															#line 1874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		for(int c = 0;c < checkers.size();c++) {
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
			ok = ok && !checkers[c].isError() && checkers[c].isReady() && checkers[c].get();
															#line 1885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		}
															#line 226 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
		checkers.clear();
															#line 1889 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InventoryCheckActor*>(this)->actor_wait_state > 0) static_cast<InventoryCheckActor*>(this)->actor_wait_state = 0;
		static_cast<InventoryCheckActor*>(this)->ActorCallback< InventoryCheckActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InventoryCheckActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("inventoryCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InventoryCheckActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("inventoryCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InventoryCheckActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("inventoryCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryCheck", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	Database cx;
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	StorefrontWorkload* self;
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	bool ok;
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	std::vector<Future<bool>> checkers;
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	std::map<orderID, std::map<int, int>>::iterator it;
															#line 1979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
};
// This generated class is to be used only via inventoryCheck()
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
class InventoryCheckActor final : public Actor<bool>, public ActorCallback< InventoryCheckActor, 0, Void >, public FastAllocated<InventoryCheckActor>, public InventoryCheckActorState<InventoryCheckActor> {
															#line 1984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
public:
	using FastAllocated<InventoryCheckActor>::operator new;
	using FastAllocated<InventoryCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2628585213579274496UL, 5404574352625540864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InventoryCheckActor, 0, Void >;
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	InventoryCheckActor(Database const& cx,StorefrontWorkload* const& self,bool const& ok) 
															#line 2001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
		 : Actor<bool>(),
		   InventoryCheckActorState<InventoryCheckActor>(cx, self, ok),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("inventoryCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1043141407758579968UL, 1116093752726661888UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("inventoryCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("inventoryCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InventoryCheckActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
[[nodiscard]] Future<bool> inventoryCheck( Database const& cx, StorefrontWorkload* const& self, bool const& ok ) {
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
	return Future<bool>(new InventoryCheckActor(cx, self, ok));
															#line 2033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Storefront.actor.g.cpp"
}

#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/Storefront.actor.cpp"
};

WorkloadFactory<StorefrontWorkload> StorefrontWorkloadFactory;
