#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
/*
 * StorageQuota.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/Tenant.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbrpc/TenantName.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"

#include "flow/Trace.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct StorageQuotaWorkload : TestWorkload {
	static constexpr auto NAME = "StorageQuota";
	TenantGroupName group;
	TenantName tenantName;
	Reference<Tenant> tenant;
	int nodeCount;
	TenantName emptyTenantName;
	Reference<Tenant> emptyTenant;

	StorageQuotaWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		group = getOption(options, "group"_sr, "DefaultGroup"_sr);
		tenantName = getOption(options, "tenant"_sr, "DefaultTenant"_sr);
		nodeCount = getOption(options, "nodeCount"_sr, 10000);
		emptyTenantName = getOption(options, "emptyTenant"_sr, "DefaultTenant"_sr);
	}

	Future<Void> setup(Database const& cx) override {
		tenant = makeReference<Tenant>(cx, tenantName);
		emptyTenant = makeReference<Tenant>(cx, emptyTenantName);

		// Use default values for arguments between (and including) postSetupWarming and endNodeIdx params.
		return bulkSetup(cx,
		                 this,
		                 nodeCount,
		                 Promise<double>(),
		                 true,
		                 0.0,
		                 1e12,
		                 std::vector<uint64_t>(),
		                 Promise<std::vector<std::pair<uint64_t, double>>>(),
		                 0,
		                 0.1,
		                 0,
		                 0,
		                 { tenant });
	}

	Future<Void> start(Database const& cx) override { return (clientId == 0) ? _start(this, cx) : Void(); }
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}

	// Functions required by `bulkSetup()`
	Key keyForIndex(int n) { return doubleToTestKey((double)n / nodeCount); }
	Value value(int n) { return doubleToTestKey(n); }
	Standalone<KeyValueRef> operator()(int n) { return KeyValueRef(keyForIndex(n), value((n + 1) % nodeCount)); }

																#line 84 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
template <class _startActor>
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
class _startActorState {
															#line 90 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
public:
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	_startActorState(StorageQuotaWorkload* const& self,Database const& cx) 
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		 : self(self),
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		   cx(cx)
															#line 99 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			StrictFuture<TenantMapEntry> __when_expr_0 = TenantAPI::getTenant(cx.getReference(), self->tenantName);
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, TenantMapEntry >*>(static_cast<_startActor*>(this)));
															#line 121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		StrictFuture<TenantMapEntry> __when_expr_1 = TenantAPI::getTenant(cx.getReference(), self->emptyTenantName);
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, TenantMapEntry >*>(static_cast<_startActor*>(this)));
															#line 151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(TenantMapEntry const& __entry1,int loopDepth) 
	{
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		entry1 = __entry1;
															#line 160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(TenantMapEntry && __entry1,int loopDepth) 
	{
		entry1 = std::move(__entry1);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, TenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, TenantMapEntry >*,TenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, TenantMapEntry >*,TenantMapEntry && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, TenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		ASSERT(entry1.tenantGroup.present() && entry1.tenantGroup.get() == self->group && entry2.tenantGroup.present() && entry2.tenantGroup.get() == self->group);
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		StrictFuture<int64_t> __when_expr_2 = getSize(cx, self->tenant);
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, int64_t >*>(static_cast<_startActor*>(this)));
															#line 248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(TenantMapEntry const& __entry2,int loopDepth) 
	{
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		entry2 = __entry2;
															#line 257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(TenantMapEntry && __entry2,int loopDepth) 
	{
		entry2 = std::move(__entry2);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, TenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, TenantMapEntry >*,TenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, TenantMapEntry >*,TenantMapEntry && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, TenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		quota = size - 1;
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		StrictFuture<Void> __when_expr_3 = setStorageQuota(cx, self->group, quota);
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(int64_t const& __size,int loopDepth) 
	{
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		size = __size;
															#line 354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t && __size,int loopDepth) 
	{
		size = std::move(__size);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		StrictFuture<Optional<int64_t>> __when_expr_4 = getStorageQuota(cx, self->group);
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 435 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Optional<int64_t> >*>(static_cast<_startActor*>(this)));
															#line 440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		StrictFuture<Optional<int64_t>> __when_expr_4 = getStorageQuota(cx, self->group);
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Optional<int64_t> >*>(static_cast<_startActor*>(this)));
															#line 456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		ASSERT(quotaRead.present() && quotaRead.get() == quota);
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (!SERVER_KNOBS->STORAGE_QUOTA_ENABLED)
															#line 542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		{
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		StrictFuture<bool> __when_expr_5 = tryWrite(self, cx, self->tenant, false, false);
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, bool >*>(static_cast<_startActor*>(this)));
															#line 561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Optional<int64_t> const& __quotaRead,int loopDepth) 
	{
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		quotaRead = __quotaRead;
															#line 570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Optional<int64_t> && __quotaRead,int loopDepth) 
	{
		quotaRead = std::move(__quotaRead);
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		ASSERT(rejected1);
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		StrictFuture<bool> __when_expr_6 = tryWrite(self, cx, self->emptyTenant, false, false);
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, bool >*>(static_cast<_startActor*>(this)));
															#line 658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(bool const& __rejected1,int loopDepth) 
	{
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		rejected1 = __rejected1;
															#line 667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(bool && __rejected1,int loopDepth) 
	{
		rejected1 = std::move(__rejected1);
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		ASSERT(rejected2);
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		StrictFuture<bool> __when_expr_7 = tryWrite(self, cx, self->tenant, true, true);
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont8when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, bool >*>(static_cast<_startActor*>(this)));
															#line 755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(bool const& __rejected2,int loopDepth) 
	{
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		rejected2 = __rejected2;
															#line 764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(bool && __rejected2,int loopDepth) 
	{
		rejected2 = std::move(__rejected2);
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		ASSERT(bypassed);
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		{
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			quota = size * 2;
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			StrictFuture<Void> __when_expr_8 = setStorageQuota(cx, self->group, quota);
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont9when1(__when_expr_8.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			StrictFuture<Void> __when_expr_9 = clearStorageQuota(cx, self->group);
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont9when2(__when_expr_9.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont8when1(bool const& __bypassed,int loopDepth) 
	{
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		bypassed = __bypassed;
															#line 882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(bool && __bypassed,int loopDepth) 
	{
		bypassed = std::move(__bypassed);
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		StrictFuture<bool> __when_expr_10 = tryWrite(self, cx, self->tenant, false, true);
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, bool >*>(static_cast<_startActor*>(this)));
															#line 968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont9when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont9when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		ASSERT(committed1);
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		StrictFuture<bool> __when_expr_11 = tryWrite(self, cx, self->emptyTenant, false, true);
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, bool >*>(static_cast<_startActor*>(this)));
															#line 1160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10when1(bool const& __committed1,int loopDepth) 
	{
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		committed1 = __committed1;
															#line 1169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(bool && __committed1,int loopDepth) 
	{
		committed1 = std::move(__committed1);
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10cont2(int loopDepth) 
	{
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		ASSERT(committed2);
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(bool const& __committed2,int loopDepth) 
	{
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		committed2 = __committed2;
															#line 1262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(bool && __committed2,int loopDepth) 
	{
		committed2 = std::move(__committed2);
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, bool >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, bool >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	StorageQuotaWorkload* self;
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	Database cx;
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	TenantMapEntry entry1;
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	TenantMapEntry entry2;
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	int64_t size;
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	int64_t quota;
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	Optional<int64_t> quotaRead;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	bool rejected1;
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	bool rejected2;
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	bool bypassed;
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	bool committed1;
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	bool committed2;
															#line 1361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, TenantMapEntry >, public ActorCallback< _startActor, 1, TenantMapEntry >, public ActorCallback< _startActor, 2, int64_t >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Optional<int64_t> >, public ActorCallback< _startActor, 5, bool >, public ActorCallback< _startActor, 6, bool >, public ActorCallback< _startActor, 7, bool >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, Void >, public ActorCallback< _startActor, 10, bool >, public ActorCallback< _startActor, 11, bool >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5228975193561639680UL, 12140996252284462848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, TenantMapEntry >;
friend struct ActorCallback< _startActor, 1, TenantMapEntry >;
friend struct ActorCallback< _startActor, 2, int64_t >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Optional<int64_t> >;
friend struct ActorCallback< _startActor, 5, bool >;
friend struct ActorCallback< _startActor, 6, bool >;
friend struct ActorCallback< _startActor, 7, bool >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, Void >;
friend struct ActorCallback< _startActor, 10, bool >;
friend struct ActorCallback< _startActor, 11, bool >;
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	_startActor(StorageQuotaWorkload* const& self,Database const& cx) 
															#line 1394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, TenantMapEntry >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, TenantMapEntry >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, int64_t >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Optional<int64_t> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, bool >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, bool >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, bool >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, bool >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
[[nodiscard]] Future<Void> _start( StorageQuotaWorkload* const& self, Database const& cx ) {
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 1437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
}

#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"

																#line 1442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
// This generated class is to be used only via getSize()
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
template <class GetSizeActor>
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
class GetSizeActorState {
															#line 1448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
public:
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	GetSizeActorState(Database const& cx,Reference<Tenant> const& tenant) 
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		 : cx(cx),
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		   tenant(tenant),
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		   tr(cx, tenant),
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		   totalDelay(0.0),
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		   previousSize(-1)
															#line 1463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
	{
		fdb_probe_actor_create("getSize", reinterpret_cast<unsigned long>(this));

	}
	~GetSizeActorState() 
	{
		fdb_probe_actor_destroy("getSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			;
															#line 1478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetSizeActorState();
		static_cast<GetSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			StrictFuture<int64_t> __when_expr_0 = tr.getEstimatedRangeSizeBytes(normalKeys);
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			if (static_cast<GetSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetSizeActor*>(this)->actor_wait_state = 1;
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetSizeActor, 0, int64_t >*>(static_cast<GetSizeActor*>(this)));
															#line 1516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			TraceEvent(SevDebug, "GetSizeError").errorUnsuppressed(e).detail("Tenant", tenant);
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			if (static_cast<GetSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1542 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetSizeActor*>(this)->actor_wait_state = 3;
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetSizeActor, 2, Void >*>(static_cast<GetSizeActor*>(this)));
															#line 1547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (size > previousSize && totalDelay < 50.0)
															#line 1562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		{
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			totalDelay += 5.0;
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			if (static_cast<GetSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetSizeActor*>(this)->actor_wait_state = 2;
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetSizeActor, 1, Void >*>(static_cast<GetSizeActor*>(this)));
															#line 1575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			TraceEvent(SevDebug, "GetSizeResult").detail("Tenant", tenant).detail("Size", size);
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			if (!static_cast<GetSizeActor*>(this)->SAV<int64_t>::futures) { (void)(size); this->~GetSizeActorState(); static_cast<GetSizeActor*>(this)->destroy(); return 0; }
															#line 1584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			new (&static_cast<GetSizeActor*>(this)->SAV< int64_t >::value()) int64_t(std::move(size)); // state_var_RVO
			this->~GetSizeActorState();
			static_cast<GetSizeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t const& __size,int loopDepth) 
	{
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		size = __size;
															#line 1597 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t && __size,int loopDepth) 
	{
		size = std::move(__size);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetSizeActor*>(this)->actor_wait_state > 0) static_cast<GetSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSizeActor*>(this)->ActorCallback< GetSizeActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< GetSizeActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetSizeActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetSizeActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetSizeActor*>(this)->actor_wait_state > 0) static_cast<GetSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSizeActor*>(this)->ActorCallback< GetSizeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSizeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetSizeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetSizeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetSizeActor*>(this)->actor_wait_state > 0) static_cast<GetSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetSizeActor*>(this)->ActorCallback< GetSizeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetSizeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetSizeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetSizeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	Database cx;
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	Reference<Tenant> tenant;
															#line 128 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	double totalDelay;
															#line 130 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	int64_t previousSize;
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	int64_t size;
															#line 1877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
};
// This generated class is to be used only via getSize()
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
class GetSizeActor final : public Actor<int64_t>, public ActorCallback< GetSizeActor, 0, int64_t >, public ActorCallback< GetSizeActor, 1, Void >, public ActorCallback< GetSizeActor, 2, Void >, public FastAllocated<GetSizeActor>, public GetSizeActorState<GetSizeActor> {
															#line 1882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
public:
	using FastAllocated<GetSizeActor>::operator new;
	using FastAllocated<GetSizeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2911547560692809984UL, 14702951346094039808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetSizeActor, 0, int64_t >;
friend struct ActorCallback< GetSizeActor, 1, Void >;
friend struct ActorCallback< GetSizeActor, 2, Void >;
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	GetSizeActor(Database const& cx,Reference<Tenant> const& tenant) 
															#line 1901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetSizeActorState<GetSizeActor>(cx, tenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4272503028879048960UL, 8207068131534081792UL);
		ActorExecutionContextHelper __helper(static_cast<GetSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetSizeActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetSizeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetSizeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
[[nodiscard]] static Future<int64_t> getSize( Database const& cx, Reference<Tenant> const& tenant ) {
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	return Future<int64_t>(new GetSizeActor(cx, tenant));
															#line 1935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
}

#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"

	static Future<Void> setStorageQuota(Database cx, TenantGroupName tenantGroupName, int64_t quota) {
		return runRYWTransactionVoid(cx,
		                             [tenantGroupName = tenantGroupName,
		                              quota = quota](Reference<ReadYourWritesTransaction> tr) -> Future<Void> {
			                             tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
			                             TenantMetadata::storageQuota().set(tr, tenantGroupName, quota);
			                             return Void();
		                             });
	}

	static Future<Void> clearStorageQuota(Database cx, TenantGroupName tenantGroupName) {
		return runRYWTransactionVoid(
		    cx, [tenantGroupName = tenantGroupName](Reference<ReadYourWritesTransaction> tr) -> Future<Void> {
			    tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
			    TenantMetadata::storageQuota().erase(tr, tenantGroupName);
			    return Void();
		    });
	}

	static Future<Optional<int64_t>> getStorageQuota(Database cx, TenantGroupName tenantGroupName) {
		return runRYWTransaction(cx, [tenantGroupName = tenantGroupName](Reference<ReadYourWritesTransaction> tr) {
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
			return TenantMetadata::storageQuota().get(tr, tenantGroupName);
		});
	}

																#line 1966 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
// This generated class is to be used only via tryWrite()
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
template <class TryWriteActor>
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
class TryWriteActorState {
															#line 1972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
public:
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	TryWriteActorState(StorageQuotaWorkload* const& self,Database const& cx,Reference<Tenant> const& tenant,bool const& bypassQuota,bool const& expectOk) 
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		 : self(self),
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		   cx(cx),
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		   tenant(tenant),
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		   bypassQuota(bypassQuota),
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		   expectOk(expectOk),
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		   i()
															#line 1989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
	{
		fdb_probe_actor_create("tryWrite", reinterpret_cast<unsigned long>(this));

	}
	~TryWriteActorState() 
	{
		fdb_probe_actor_destroy("tryWrite", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			i = 0;
															#line 2004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryWriteActorState();
		static_cast<TryWriteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (!static_cast<TryWriteActor*>(this)->SAV<bool>::futures) { (void)(false); this->~TryWriteActorState(); static_cast<TryWriteActor*>(this)->destroy(); return 0; }
															#line 2027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		new (&static_cast<TryWriteActor*>(this)->SAV< bool >::value()) bool(false);
		this->~TryWriteActorState();
		static_cast<TryWriteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (!(i < 10))
															#line 2046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		tr = Transaction(cx, tenant);
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (bypassQuota)
															#line 2054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		{
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			tr.setOption(FDBTransactionOptions::BYPASS_STORAGE_QUOTA);
															#line 2058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		}
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		;
															#line 2062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(5.0);
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (static_cast<TryWriteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2086 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<TryWriteActor*>(this)->actor_wait_state = 3;
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TryWriteActor, 2, Void >*>(static_cast<TryWriteActor*>(this)));
															#line 2091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			Standalone<KeyValueRef> kv = (*self)(deterministicRandom()->randomInt(0, std::numeric_limits<int>::max()));
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			tr.set(kv.key, kv.value);
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			if (static_cast<TryWriteActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryWriteActor*>(this)->actor_wait_state = 1;
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryWriteActor, 0, Void >*>(static_cast<TryWriteActor*>(this)));
															#line 2119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			if (e.code() == error_code_storage_quota_exceeded)
															#line 2154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			{
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
				if (!expectOk)
															#line 2158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
				{
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
					if (!static_cast<TryWriteActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TryWriteActorState(); static_cast<TryWriteActor*>(this)->destroy(); return 0; }
															#line 2162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
					new (&static_cast<TryWriteActor*>(this)->SAV< bool >::value()) bool(true);
					this->~TryWriteActorState();
					static_cast<TryWriteActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
				StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
				if (static_cast<TryWriteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
				static_cast<TryWriteActor*>(this)->actor_wait_state = 2;
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryWriteActor, 1, Void >*>(static_cast<TryWriteActor*>(this)));
															#line 2181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (expectOk)
															#line 2197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		{
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			if (!static_cast<TryWriteActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TryWriteActorState(); static_cast<TryWriteActor*>(this)->destroy(); return 0; }
															#line 2201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			new (&static_cast<TryWriteActor*>(this)->SAV< bool >::value()) bool(true);
			this->~TryWriteActorState();
			static_cast<TryWriteActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		if (expectOk)
															#line 2215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		{
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
			if (!static_cast<TryWriteActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TryWriteActorState(); static_cast<TryWriteActor*>(this)->destroy(); return 0; }
															#line 2219 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
			new (&static_cast<TryWriteActor*>(this)->SAV< bool >::value()) bool(true);
			this->~TryWriteActorState();
			static_cast<TryWriteActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryWriteActor*>(this)->actor_wait_state > 0) static_cast<TryWriteActor*>(this)->actor_wait_state = 0;
		static_cast<TryWriteActor*>(this)->ActorCallback< TryWriteActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryWriteActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryWriteActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryWriteActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TryWriteActor*>(this)->actor_wait_state > 0) static_cast<TryWriteActor*>(this)->actor_wait_state = 0;
		static_cast<TryWriteActor*>(this)->ActorCallback< TryWriteActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryWriteActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryWrite", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryWrite", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TryWriteActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryWrite", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryWrite", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TryWriteActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryWrite", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryWrite", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		i++;
															#line 2401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
		i++;
															#line 2410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TryWriteActor*>(this)->actor_wait_state > 0) static_cast<TryWriteActor*>(this)->actor_wait_state = 0;
		static_cast<TryWriteActor*>(this)->ActorCallback< TryWriteActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryWriteActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryWrite", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryWrite", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TryWriteActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryWrite", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryWrite", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TryWriteActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryWrite", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryWrite", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	StorageQuotaWorkload* self;
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	Database cx;
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	Reference<Tenant> tenant;
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	bool bypassQuota;
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	bool expectOk;
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	int i;
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	Transaction tr;
															#line 2504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
};
// This generated class is to be used only via tryWrite()
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
class TryWriteActor final : public Actor<bool>, public ActorCallback< TryWriteActor, 0, Void >, public ActorCallback< TryWriteActor, 1, Void >, public ActorCallback< TryWriteActor, 2, Void >, public FastAllocated<TryWriteActor>, public TryWriteActorState<TryWriteActor> {
															#line 2509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
public:
	using FastAllocated<TryWriteActor>::operator new;
	using FastAllocated<TryWriteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1934465476231515136UL, 9460364815658945280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryWriteActor, 0, Void >;
friend struct ActorCallback< TryWriteActor, 1, Void >;
friend struct ActorCallback< TryWriteActor, 2, Void >;
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	TryWriteActor(StorageQuotaWorkload* const& self,Database const& cx,Reference<Tenant> const& tenant,bool const& bypassQuota,bool const& expectOk) 
															#line 2528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
		 : Actor<bool>(),
		   TryWriteActorState<TryWriteActor>(self, cx, tenant, bypassQuota, expectOk),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryWrite", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6676048697371729920UL, 2325963989740166656UL);
		ActorExecutionContextHelper __helper(static_cast<TryWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryWrite");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryWrite", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryWriteActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TryWriteActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TryWriteActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
[[nodiscard]] static Future<bool> tryWrite( StorageQuotaWorkload* const& self, Database const& cx, Reference<Tenant> const& tenant, bool const& bypassQuota, bool const& expectOk ) {
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
	return Future<bool>(new TryWriteActor(self, cx, tenant, bypassQuota, expectOk));
															#line 2562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/StorageQuota.actor.g.cpp"
}

#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/StorageQuota.actor.cpp"
};

WorkloadFactory<StorageQuotaWorkload> StorageQuotaWorkloadFactory;
