#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
/*
 * Serializability.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/ActorCollection.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct SerializabilityWorkload : TestWorkload {
	static constexpr auto NAME = "Serializability";

	double testDuration;
	bool adjacentKeys;
	int nodes;
	int numOps;
	std::pair<int, int> valueSizeRange;
	int maxClearSize;
	std::string keyPrefix;

	bool success;

	struct GetRangeOperation {
		KeySelector begin;
		KeySelector end;
		int limit;
		Snapshot snapshot{ Snapshot::False };
		Reverse reverse{ Reverse::False };
	};

	struct GetKeyOperation {
		KeySelector key;
		Snapshot snapshot{ Snapshot::False };
	};

	struct GetOperation {
		Key key;
		Snapshot snapshot{ Snapshot::False };
	};

	struct TransactionOperation {
		Optional<Standalone<MutationRef>> mutationOp;
		Optional<GetRangeOperation> getRangeOp;
		Optional<GetKeyOperation> getKeyOp;
		Optional<GetOperation> getOp;
		Optional<Key> watchOp;
		Optional<KeyRange> writeConflictOp;
		Optional<KeyRange> readConflictOp;
	};

	SerializabilityWorkload(WorkloadContext const& wcx) : TestWorkload(wcx), success(true) {
		testDuration = getOption(options, "testDuration"_sr, 30.0);
		numOps = getOption(options, "numOps"_sr, 21);
		nodes = getOption(options, "nodes"_sr, 1000);

		adjacentKeys = false; // deterministicRandom()->random01() < 0.5;
		valueSizeRange = std::make_pair(0, 100);
		// keyPrefix = "\x02";

		maxClearSize = deterministicRandom()->randomInt(10, 2 * nodes);
		if (clientId == 0)
			TraceEvent("SerializabilityConfiguration")
			    .detail("Nodes", nodes)
			    .detail("AdjacentKeys", adjacentKeys)
			    .detail("ValueSizeMin", valueSizeRange.first)
			    .detail("ValueSizeMax", valueSizeRange.second)
			    .detail("MaxClearSize", maxClearSize);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId == 0)
			return _start(cx, this);
		return Void();
	}

	Future<bool> check(Database const& cx) override { return success; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	Value getRandomValue() const {
		return Value(
		    std::string(deterministicRandom()->randomInt(valueSizeRange.first, valueSizeRange.second + 1), 'x'));
	}

	Key getRandomKey() const { return getKeyForIndex(deterministicRandom()->randomInt(0, nodes)); }

	Key getKeyForIndex(int idx) const {
		if (adjacentKeys) {
			return Key(idx ? keyPrefix + std::string(idx, '\x00') : "");
		} else {
			return Key(keyPrefix + format("%010d", idx));
		}
	}

	KeySelector getRandomKeySelector() const {
		int scale = 1 << deterministicRandom()->randomInt(0, 14);
		return KeySelectorRef(
		    getRandomKey(), deterministicRandom()->random01() < 0.5, deterministicRandom()->randomInt(-scale, scale));
	}

	KeyRange getRandomRange(int sizeLimit) const {
		int startLocation = deterministicRandom()->randomInt(0, nodes);
		int scale = deterministicRandom()->randomInt(
		    0, deterministicRandom()->randomInt(2, 5) * deterministicRandom()->randomInt(2, 5));
		int endLocation = startLocation + deterministicRandom()->randomInt(
		                                      0, 1 + std::min(sizeLimit, std::min(nodes - startLocation, 1 << scale)));

		return KeyRangeRef(getKeyForIndex(startLocation), getKeyForIndex(endLocation));
	}

	std::vector<TransactionOperation> randomTransaction() {
		int maxOps = deterministicRandom()->randomInt(1, numOps);
		std::vector<TransactionOperation> result;
		bool hasMutation = false;
		for (int j = 0; j < maxOps; j++) {
			int operationType = deterministicRandom()->randomInt(0, 20);
			TransactionOperation op;
			if (operationType == 0) {
				GetKeyOperation getKey;
				getKey.key = getRandomKeySelector();
				getKey.snapshot.set(deterministicRandom()->coinflip());
				op.getKeyOp = getKey;
			} else if (operationType == 1) {
				GetRangeOperation getRange;
				getRange.begin = getRandomKeySelector();
				getRange.end = getRandomKeySelector();
				getRange.limit = deterministicRandom()->randomInt(0, 1 << deterministicRandom()->randomInt(1, 10));
				getRange.reverse.set(deterministicRandom()->coinflip());
				getRange.snapshot.set(deterministicRandom()->coinflip());
				op.getRangeOp = getRange;
			} else if (operationType == 2) {
				GetOperation getOp;
				getOp.key = getRandomKey();
				getOp.snapshot.set(deterministicRandom()->coinflip());
				op.getOp = getOp;
			} else if (operationType == 3) {
				KeyRange range = getRandomRange(maxClearSize);
				op.mutationOp = MutationRef(MutationRef::ClearRange, range.begin, range.end);
				if (!range.empty())
					hasMutation = true;
			} else if (operationType == 4) {
				KeyRange range = singleKeyRange(getRandomKey());
				op.mutationOp = MutationRef(MutationRef::ClearRange, range.begin, range.end);
				hasMutation = true;
			} else if (operationType == 5) {
				op.watchOp = getRandomKey();
			} else if (operationType == 6) {
				op.writeConflictOp = getRandomRange(maxClearSize);
			} else if (operationType == 7) {
				op.readConflictOp = getRandomRange(maxClearSize);
			} else if (operationType == 8) {
				Key key = getRandomKey();
				Value value = getRandomValue();
				MutationRef::Type opType;
				switch (deterministicRandom()->randomInt(0, 8)) {
				case 0:
					opType = MutationRef::AddValue;
					break;
				case 1:
					opType = MutationRef::And;
					break;
				case 2:
					opType = MutationRef::Or;
					break;
				case 3:
					opType = MutationRef::Xor;
					break;
				case 4:
					opType = MutationRef::Max;
					break;
				case 5:
					opType = MutationRef::Min;
					break;
				case 6:
					opType = MutationRef::ByteMin;
					break;
				case 7:
					opType = MutationRef::ByteMax;
					break;
				}
				op.mutationOp = MutationRef(opType, key, value);
				hasMutation = true;
			} else if (operationType >= 9) {
				Key key = getRandomKey();
				Value value = getRandomValue();
				op.mutationOp = MutationRef(MutationRef::SetValue, key, value);
				hasMutation = true;
			}
			result.push_back(op);
		}

		if (!hasMutation) {
			Key key = getRandomKey();
			Value value = getRandomValue();
			TransactionOperation op;
			op.mutationOp = MutationRef(MutationRef::SetValue, key, value);
			result.push_back(op);
		}

		return result;
	}

	template <class T>
	static void dontCheck(std::vector<Future<T>>& futures) {
		// Replace the last future in the vector with one that will be completed at the same time and
		// with the same error status, but has a constant result.  This is used to suppress the results
		// of reads that aren't deterministic in the test context.
		futures.back() = tag(::success(futures.back()), T());
	}

																#line 233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
// This generated class is to be used only via runTransaction()
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
template <class RunTransactionActor>
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
class RunTransactionActorState {
															#line 239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
public:
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	RunTransactionActorState(ReadYourWritesTransaction* const& tr,std::vector<TransactionOperation> const& ops,std::vector<Future<Optional<Value>>>* const& getFutures,std::vector<Future<Key>>* const& getKeyFutures,std::vector<Future<RangeResult>>* const& getRangeFutures,std::vector<Future<Void>>* const& watchFutures,bool const& checkSnapshotReads) 
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		 : tr(tr),
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		   ops(ops),
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		   getFutures(getFutures),
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		   getKeyFutures(getKeyFutures),
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		   getRangeFutures(getRangeFutures),
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		   watchFutures(watchFutures),
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		   checkSnapshotReads(checkSnapshotReads),
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		   opNum(0)
															#line 260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
	{
		fdb_probe_actor_create("runTransaction", reinterpret_cast<unsigned long>(this));

	}
	~RunTransactionActorState() 
	{
		fdb_probe_actor_destroy("runTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			;
															#line 275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunTransactionActorState();
		static_cast<RunTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (!static_cast<RunTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunTransactionActorState(); static_cast<RunTransactionActor*>(this)->destroy(); return 0; }
															#line 298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		new (&static_cast<RunTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunTransactionActorState();
		static_cast<RunTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (!(opNum < ops.size()))
															#line 317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (ops[opNum].getKeyOp.present())
															#line 323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		{
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			auto& op = ops[opNum].getKeyOp.get();
															#line 243 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			getKeyFutures->push_back(tr->getKey(op.key, op.snapshot));
															#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			if (op.snapshot && !checkSnapshotReads)
															#line 331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			{
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				dontCheck(*getKeyFutures);
															#line 335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			}
		}
		else
		{
															#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			if (ops[opNum].getOp.present())
															#line 342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			{
															#line 247 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				auto& op = ops[opNum].getOp.get();
															#line 249 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				getFutures->push_back(tr->get(op.key, op.snapshot));
															#line 250 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				if (op.snapshot && !checkSnapshotReads)
															#line 350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				{
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					dontCheck(*getFutures);
															#line 354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
			}
			else
			{
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				if (ops[opNum].getRangeOp.present())
															#line 361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				{
															#line 253 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					auto& op = ops[opNum].getRangeOp.get();
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					getRangeFutures->push_back(tr->getRange(op.begin, op.end, op.limit, op.snapshot, op.reverse));
															#line 256 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					if (op.snapshot && !checkSnapshotReads)
															#line 369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
					{
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
						dontCheck(*getRangeFutures);
															#line 373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
					}
				}
				else
				{
															#line 258 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					if (ops[opNum].mutationOp.present())
															#line 380 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
					{
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
						auto& op = ops[opNum].mutationOp.get();
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
						if (op.type == MutationRef::SetValue)
															#line 386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
						{
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
							tr->set(op.param1, op.param2);
															#line 390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
						}
						else
						{
															#line 263 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
							if (op.type == MutationRef::ClearRange)
															#line 396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
							{
															#line 265 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
								tr->clear(KeyRangeRef(op.param1, op.param2));
															#line 400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
							}
							else
							{
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
								tr->atomicOp(op.param1, op.param2, op.type);
															#line 406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
							}
						}
					}
					else
					{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
						if (ops[opNum].readConflictOp.present())
															#line 414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
						{
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
							auto& op = ops[opNum].readConflictOp.get();
															#line 273 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
							tr->addReadConflictRange(op);
															#line 420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
						}
						else
						{
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
							if (ops[opNum].watchOp.present())
															#line 426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
							{
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
								auto& op = ops[opNum].watchOp.get();
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
								watchFutures->push_back(tr->watch(op));
															#line 432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
							}
							else
							{
															#line 278 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
								if (ops[opNum].writeConflictOp.present())
															#line 438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
								{
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
									auto& op = ops[opNum].writeConflictOp.get();
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
									tr->addWriteConflictRange(op);
															#line 444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
								}
							}
						}
					}
				}
			}
		}
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (deterministicRandom()->random01() < 0.2)
															#line 454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		{
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			waitType = deterministicRandom()->randomInt(0, 4);
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			;
															#line 460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		opNum++;
															#line 487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont23(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (waitType == 0 && getFutures->size())
															#line 509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		{
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			StrictFuture<Void> __when_expr_0 = ::success(deterministicRandom()->randomChoice(*getFutures));
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			if (static_cast<RunTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunTransactionActor*>(this)->actor_wait_state = 1;
															#line 289 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunTransactionActor, 0, Void >*>(static_cast<RunTransactionActor*>(this)));
															#line 520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			if (waitType == 1 && getKeyFutures->size())
															#line 527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			{
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				StrictFuture<Void> __when_expr_1 = ::success(deterministicRandom()->randomChoice(*getKeyFutures));
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				if (static_cast<RunTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<RunTransactionActor*>(this)->actor_wait_state = 2;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunTransactionActor, 1, Void >*>(static_cast<RunTransactionActor*>(this)));
															#line 538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				if (waitType == 2 && getRangeFutures->size())
															#line 545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				{
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					StrictFuture<Void> __when_expr_2 = ::success(deterministicRandom()->randomChoice(*getRangeFutures));
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					if (static_cast<RunTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when3(__when_expr_2.get(), loopDepth); };
					static_cast<RunTransactionActor*>(this)->actor_wait_state = 3;
															#line 295 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunTransactionActor, 2, Void >*>(static_cast<RunTransactionActor*>(this)));
															#line 556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					if (waitType == 3)
															#line 563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
					{
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
						StrictFuture<Void> __when_expr_3 = delay(0.001 * deterministicRandom()->random01());
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
						if (static_cast<RunTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when4(__when_expr_3.get(), loopDepth); };
						static_cast<RunTransactionActor*>(this)->actor_wait_state = 4;
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunTransactionActor, 3, Void >*>(static_cast<RunTransactionActor*>(this)));
															#line 574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1loopBody1loopBody1cont10(loopDepth);
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont23(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 301 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		waitType = (waitType + 1) % 4;
															#line 604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunTransactionActor*>(this)->ActorCallback< RunTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunTransactionActor*>(this)->ActorCallback< RunTransactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTransactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunTransactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunTransactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont8(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont8(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunTransactionActor*>(this)->ActorCallback< RunTransactionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTransactionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunTransactionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunTransactionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont10(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont11(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont11(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunTransactionActor*>(this)->ActorCallback< RunTransactionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunTransactionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunTransactionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunTransactionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	ReadYourWritesTransaction* tr;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	std::vector<TransactionOperation> ops;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	std::vector<Future<Optional<Value>>>* getFutures;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	std::vector<Future<Key>>* getKeyFutures;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	std::vector<Future<RangeResult>>* getRangeFutures;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	std::vector<Future<Void>>* watchFutures;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	bool checkSnapshotReads;
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	int opNum;
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	int waitType;
															#line 993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
};
// This generated class is to be used only via runTransaction()
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
class RunTransactionActor final : public Actor<Void>, public ActorCallback< RunTransactionActor, 0, Void >, public ActorCallback< RunTransactionActor, 1, Void >, public ActorCallback< RunTransactionActor, 2, Void >, public ActorCallback< RunTransactionActor, 3, Void >, public FastAllocated<RunTransactionActor>, public RunTransactionActorState<RunTransactionActor> {
															#line 998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
public:
	using FastAllocated<RunTransactionActor>::operator new;
	using FastAllocated<RunTransactionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(466519153850317568UL, 15067721194494113024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunTransactionActor, 0, Void >;
friend struct ActorCallback< RunTransactionActor, 1, Void >;
friend struct ActorCallback< RunTransactionActor, 2, Void >;
friend struct ActorCallback< RunTransactionActor, 3, Void >;
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	RunTransactionActor(ReadYourWritesTransaction* const& tr,std::vector<TransactionOperation> const& ops,std::vector<Future<Optional<Value>>>* const& getFutures,std::vector<Future<Key>>* const& getKeyFutures,std::vector<Future<RangeResult>>* const& getRangeFutures,std::vector<Future<Void>>* const& watchFutures,bool const& checkSnapshotReads) 
															#line 1018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		 : Actor<Void>(),
		   RunTransactionActorState<RunTransactionActor>(tr, ops, getFutures, getKeyFutures, getRangeFutures, watchFutures, checkSnapshotReads),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(431366012606644224UL, 110055432891511040UL);
		ActorExecutionContextHelper __helper(static_cast<RunTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunTransactionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunTransactionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunTransactionActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunTransactionActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
[[nodiscard]] static Future<Void> runTransaction( ReadYourWritesTransaction* const& tr, std::vector<TransactionOperation> const& ops, std::vector<Future<Optional<Value>>>* const& getFutures, std::vector<Future<Key>>* const& getKeyFutures, std::vector<Future<RangeResult>>* const& getRangeFutures, std::vector<Future<Void>>* const& watchFutures, bool const& checkSnapshotReads ) {
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	return Future<Void>(new RunTransactionActor(tr, ops, getFutures, getKeyFutures, getRangeFutures, watchFutures, checkSnapshotReads));
															#line 1053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
}

#line 308 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"

																#line 1058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
// This generated class is to be used only via getDatabaseContents()
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
template <class GetDatabaseContentsActor>
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
class GetDatabaseContentsActorState {
															#line 1064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
public:
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	GetDatabaseContentsActorState(Database const& cx,int const& nodes) 
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		 : cx(cx),
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		   nodes(nodes),
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		   tr(cx)
															#line 1075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
	{
		fdb_probe_actor_create("getDatabaseContents", reinterpret_cast<unsigned long>(this));

	}
	~GetDatabaseContentsActorState() 
	{
		fdb_probe_actor_destroy("getDatabaseContents", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(normalKeys, nodes + 1);
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			if (static_cast<GetDatabaseContentsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetDatabaseContentsActor*>(this)->actor_wait_state = 1;
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDatabaseContentsActor, 0, RangeResult >*>(static_cast<GetDatabaseContentsActor*>(this)));
															#line 1097 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDatabaseContentsActorState();
		static_cast<GetDatabaseContentsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& result,int loopDepth) 
	{
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		ASSERT(result.size() <= nodes);
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (!static_cast<GetDatabaseContentsActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetDatabaseContentsActorState(); static_cast<GetDatabaseContentsActor*>(this)->destroy(); return 0; }
															#line 1122 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		new (&static_cast<GetDatabaseContentsActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetDatabaseContentsActorState();
		static_cast<GetDatabaseContentsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && result,int loopDepth) 
	{
															#line 313 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		ASSERT(result.size() <= nodes);
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (!static_cast<GetDatabaseContentsActor*>(this)->SAV<RangeResult>::futures) { (void)(result); this->~GetDatabaseContentsActorState(); static_cast<GetDatabaseContentsActor*>(this)->destroy(); return 0; }
															#line 1136 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		new (&static_cast<GetDatabaseContentsActor*>(this)->SAV< RangeResult >::value()) RangeResult(result);
		this->~GetDatabaseContentsActorState();
		static_cast<GetDatabaseContentsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDatabaseContentsActor*>(this)->actor_wait_state > 0) static_cast<GetDatabaseContentsActor*>(this)->actor_wait_state = 0;
		static_cast<GetDatabaseContentsActor*>(this)->ActorCallback< GetDatabaseContentsActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetDatabaseContentsActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getDatabaseContents", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatabaseContents", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDatabaseContentsActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getDatabaseContents", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatabaseContents", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDatabaseContentsActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getDatabaseContents", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatabaseContents", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	Database cx;
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	int nodes;
															#line 310 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1225 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
};
// This generated class is to be used only via getDatabaseContents()
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
class GetDatabaseContentsActor final : public Actor<RangeResult>, public ActorCallback< GetDatabaseContentsActor, 0, RangeResult >, public FastAllocated<GetDatabaseContentsActor>, public GetDatabaseContentsActorState<GetDatabaseContentsActor> {
															#line 1230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
public:
	using FastAllocated<GetDatabaseContentsActor>::operator new;
	using FastAllocated<GetDatabaseContentsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4358166272690553344UL, 4955911530012090880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDatabaseContentsActor, 0, RangeResult >;
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	GetDatabaseContentsActor(Database const& cx,int const& nodes) 
															#line 1247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		 : Actor<RangeResult>(),
		   GetDatabaseContentsActorState<GetDatabaseContentsActor>(cx, nodes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDatabaseContents", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17713415544567872000UL, 519083008247981056UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatabaseContentsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDatabaseContents");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDatabaseContents", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDatabaseContentsActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
[[nodiscard]] static Future<RangeResult> getDatabaseContents( Database const& cx, int const& nodes ) {
															#line 309 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	return Future<RangeResult>(new GetDatabaseContentsActor(cx, nodes));
															#line 1279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
}

#line 316 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"

																#line 1284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
// This generated class is to be used only via resetDatabase()
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
template <class ResetDatabaseActor>
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
class ResetDatabaseActorState {
															#line 1290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
public:
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	ResetDatabaseActorState(Database const& cx,Standalone<VectorRef<KeyValueRef>> const& data) 
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		 : cx(cx),
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		   data(data),
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		   tr(cx)
															#line 1301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
	{
		fdb_probe_actor_create("resetDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ResetDatabaseActorState() 
	{
		fdb_probe_actor_destroy("resetDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 320 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			tr.clear(normalKeys);
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			for( auto kv : data ) {
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				tr.set(kv.key, kv.value);
															#line 1320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			}
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			if (static_cast<ResetDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ResetDatabaseActor*>(this)->actor_wait_state = 1;
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ResetDatabaseActor, 0, Void >*>(static_cast<ResetDatabaseActor*>(this)));
															#line 1331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ResetDatabaseActorState();
		static_cast<ResetDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (!static_cast<ResetDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResetDatabaseActorState(); static_cast<ResetDatabaseActor*>(this)->destroy(); return 0; }
															#line 1354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		new (&static_cast<ResetDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResetDatabaseActorState();
		static_cast<ResetDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (!static_cast<ResetDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResetDatabaseActorState(); static_cast<ResetDatabaseActor*>(this)->destroy(); return 0; }
															#line 1366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		new (&static_cast<ResetDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResetDatabaseActorState();
		static_cast<ResetDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ResetDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ResetDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ResetDatabaseActor*>(this)->ActorCallback< ResetDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResetDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resetDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResetDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resetDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ResetDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resetDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResetDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	Database cx;
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> data;
															#line 318 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
};
// This generated class is to be used only via resetDatabase()
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
class ResetDatabaseActor final : public Actor<Void>, public ActorCallback< ResetDatabaseActor, 0, Void >, public FastAllocated<ResetDatabaseActor>, public ResetDatabaseActorState<ResetDatabaseActor> {
															#line 1460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
public:
	using FastAllocated<ResetDatabaseActor>::operator new;
	using FastAllocated<ResetDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3700489218715765760UL, 15773029254965230592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ResetDatabaseActor, 0, Void >;
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	ResetDatabaseActor(Database const& cx,Standalone<VectorRef<KeyValueRef>> const& data) 
															#line 1477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		 : Actor<Void>(),
		   ResetDatabaseActorState<ResetDatabaseActor>(cx, data),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("resetDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13901609057469148672UL, 17750787279055264512UL);
		ActorExecutionContextHelper __helper(static_cast<ResetDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("resetDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("resetDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ResetDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
[[nodiscard]] static Future<Void> resetDatabase( Database const& cx, Standalone<VectorRef<KeyValueRef>> const& data ) {
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	return Future<Void>(new ResetDatabaseActor(cx, data));
															#line 1509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
}

#line 327 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"

																#line 1514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
template <class _startActor>
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
class _startActorState {
															#line 1520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
public:
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	_startActorState(Database const& cx,SerializabilityWorkload* const& self) 
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		 : cx(cx),
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		   self(self),
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		   startTime(now())
															#line 1531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			;
															#line 1546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		tr = std::vector<ReadYourWritesTransaction>();
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		getFutures = std::vector<std::vector<Future<Optional<Value>>>>();
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		getKeyFutures = std::vector<std::vector<Future<Key>>>();
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		getRangeFutures = std::vector<std::vector<Future<RangeResult>>>();
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		watchFutures = std::vector<std::vector<Future<Void>>>();
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < 5;i++) {
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			tr.push_back(ReadYourWritesTransaction(cx));
															#line 340 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			getFutures.push_back(std::vector<Future<Optional<Value>>>());
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			getKeyFutures.push_back(std::vector<Future<Key>>());
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			getRangeFutures.push_back(std::vector<Future<RangeResult>>());
															#line 343 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			watchFutures.push_back(std::vector<Future<Void>>());
															#line 1596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
		try {
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			if (now() - startTime > self->testDuration)
															#line 1601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			{
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_startActorState();
				static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			initialData = Standalone<VectorRef<KeyValueRef>>();
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			int initialAmount = deterministicRandom()->randomInt(0, 100);
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			for(int i = 0;i < initialAmount;i++) {
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				Key key = self->getRandomKey();
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				Value value = self->getRandomValue();
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				initialData.push_back_deep(initialData.arena(), KeyValueRef(key, value));
															#line 1623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			}
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			a = self->randomTransaction();
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			b = self->randomTransaction();
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			c = self->randomTransaction();
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			StrictFuture<Void> __when_expr_0 = resetDatabase(cx, initialData);
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1635 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			trErr = ReadYourWritesTransaction(cx);
															#line 528 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			StrictFuture<Void> __when_expr_15 = trErr.onError(e);
															#line 528 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_15.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 528 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 1671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runTransaction( &tr[0], a, &getFutures[0], &getKeyFutures[0], &getRangeFutures[0], &watchFutures[0], true);
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runTransaction( &tr[0], a, &getFutures[0], &getKeyFutures[0], &getRangeFutures[0], &watchFutures[0], true);
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1709 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr[0].commit();
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr[0].commit();
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_3 = runTransaction( &tr[1], b, &getFutures[0], &getKeyFutures[0], &getRangeFutures[0], &watchFutures[0], true);
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_3 = runTransaction( &tr[1], b, &getFutures[0], &getKeyFutures[0], &getRangeFutures[0], &watchFutures[0], true);
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1918 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr[1].commit();
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2009 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 2014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr[1].commit();
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2025 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 2030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_5 = runTransaction( &tr[2], c, &getFutures[2], &getKeyFutures[2], &getRangeFutures[2], &watchFutures[2], false);
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 2121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_5 = runTransaction( &tr[2], c, &getFutures[2], &getKeyFutures[2], &getRangeFutures[2], &watchFutures[2], false);
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 2137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_6 = tr[2].commit();
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont10when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 2228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_6 = tr[2].commit();
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont10when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 2244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<RangeResult> __when_expr_7 = getDatabaseContents(cx, self->nodes);
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont10cont1when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 2335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont1(Void && _,int loopDepth) 
	{
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<RangeResult> __when_expr_7 = getDatabaseContents(cx, self->nodes);
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont10cont1when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 2351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont10cont2(int loopDepth) 
	{
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_8 = resetDatabase(cx, initialData);
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont10cont2when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 2442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont1when1(RangeResult const& __result1,int loopDepth) 
	{
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		result1 = __result1;
															#line 2451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = a_body1loopBody1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont1when1(RangeResult && __result1,int loopDepth) 
	{
		result1 = std::move(__result1);
		loopDepth = a_body1loopBody1cont10cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont10cont3(Void const& _,int loopDepth) 
	{
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_9 = runTransaction( &tr[3], a, &getFutures[3], &getKeyFutures[3], &getRangeFutures[3], &watchFutures[3], true);
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1loopBody1cont10cont3when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 2537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont3(Void && _,int loopDepth) 
	{
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_9 = runTransaction( &tr[3], a, &getFutures[3], &getKeyFutures[3], &getRangeFutures[3], &watchFutures[3], true);
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1loopBody1cont10cont3when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 2553 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1cont10cont4(Void const& _,int loopDepth) 
	{
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_10 = runTransaction( &tr[3], b, &getFutures[3], &getKeyFutures[3], &getRangeFutures[3], &watchFutures[3], true);
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1loopBody1cont10cont4when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 2644 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont4(Void && _,int loopDepth) 
	{
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_10 = runTransaction( &tr[3], b, &getFutures[3], &getKeyFutures[3], &getRangeFutures[3], &watchFutures[3], true);
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1loopBody1cont10cont4when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 2660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1cont10cont5(Void const& _,int loopDepth) 
	{
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_11 = runTransaction( &tr[4], c, &getFutures[4], &getKeyFutures[4], &getRangeFutures[4], &watchFutures[4], false);
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1loopBody1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1loopBody1cont10cont5when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 2751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont5(Void && _,int loopDepth) 
	{
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_11 = runTransaction( &tr[4], c, &getFutures[4], &getKeyFutures[4], &getRangeFutures[4], &watchFutures[4], false);
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1loopBody1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1loopBody1cont10cont5when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 2767 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont10cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1cont10cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1loopBody1cont10cont6(Void const& _,int loopDepth) 
	{
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_12 = tr[3].commit();
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1loopBody1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1loopBody1cont10cont6when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 2858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont6(Void && _,int loopDepth) 
	{
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_12 = tr[3].commit();
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1loopBody1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1loopBody1cont10cont6when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 2874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont10cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1cont10cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1loopBody1cont10cont7(Void const& _,int loopDepth) 
	{
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_13 = tr[4].commit();
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2960 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1loopBody1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1loopBody1cont10cont7when1(__when_expr_13.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 2965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont7(Void && _,int loopDepth) 
	{
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<Void> __when_expr_13 = tr[4].commit();
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1loopBody1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1loopBody1cont10cont7when1(__when_expr_13.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 2981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1cont10cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1cont10cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1loopBody1cont10cont8(Void const& _,int loopDepth) 
	{
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<RangeResult> __when_expr_14 = getDatabaseContents(cx, self->nodes);
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1loopBody1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1loopBody1cont10cont8when1(__when_expr_14.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 3072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont8(Void && _,int loopDepth) 
	{
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		StrictFuture<RangeResult> __when_expr_14 = getDatabaseContents(cx, self->nodes);
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3083 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1loopBody1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1loopBody1cont10cont8when1(__when_expr_14.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 3088 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1loopBody1cont10cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1loopBody1cont10cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1loopBody1cont10cont9(RangeResult const& result2,int loopDepth) 
	{
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (result1.size() != result2.size())
															#line 3172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		{
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			TraceEvent(SevError, "SRL_ResultMismatch") .detail("Size1", result1.size()) .detail("Size2", result2.size());
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			for( auto kv : result1 ) {
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				TraceEvent("SRL_Result1").detail("Kv", printable(kv));
															#line 3180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			}
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			for( auto kv : result2 ) {
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				TraceEvent("SRL_Result2").detail("Kv", printable(kv));
															#line 3186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			}
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(false);
															#line 3190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < result1.size();i++) {
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			if (result1[i] != result2[i])
															#line 3196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			{
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				TraceEvent(SevError, "SRL_ResultMismatch") .detail("I", i) .detail("Result1", printable(result1[i])) .detail("Result2", printable(result2[i])) .detail("Result1Value", printable(result1[i].value)) .detail("Result2Value", printable(result2[i].value));
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				for( auto kv : result1 ) {
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent("SRL_Result1").detail("Kv", printable(kv));
															#line 3204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				for( auto kv : result2 ) {
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent("SRL_Result2").detail("Kv", printable(kv));
															#line 3210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				ASSERT(false);
															#line 3214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			}
		}
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getFutures[0].size();i++) {
															#line 434 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getFutures[0][i].get() == getFutures[3][i].get());
															#line 3221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getFutures[1].size();i++) {
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getFutures[1][i].get() == getFutures[3][getFutures[0].size() + i].get());
															#line 3227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getFutures[2].size();i++) {
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getFutures[2][i].get() == getFutures[4][i].get());
															#line 3233 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getKeyFutures[0].size();i++) {
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getKeyFutures[0][i].get() == getKeyFutures[3][i].get());
															#line 3239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getKeyFutures[1].size();i++) {
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getKeyFutures[1][i].get() == getKeyFutures[3][getKeyFutures[0].size() + i].get());
															#line 3245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getKeyFutures[2].size();i++) {
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getKeyFutures[2][i].get() == getKeyFutures[4][i].get());
															#line 3251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getRangeFutures[0].size();i++) {
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			if (getRangeFutures[0][i].get().size() != getRangeFutures[3][i].get().size())
															#line 3257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			{
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				TraceEvent(SevError, "SRL_ResultMismatch") .detail("Size1", getRangeFutures[0][i].get().size()) .detail("Size2", getRangeFutures[3][i].get().size());
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				for( auto kv : getRangeFutures[0][i].get() ) {
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent("SRL_Result1").detail("Kv", printable(kv));
															#line 3265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
															#line 461 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				for( auto kv : getRangeFutures[3][i].get() ) {
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent("SRL_Result2").detail("Kv", printable(kv));
															#line 3271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
															#line 464 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				ASSERT(false);
															#line 3275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			}
															#line 467 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			for(int j = 0;j < getRangeFutures[0][i].get().size();j++) {
															#line 468 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				if (getRangeFutures[0][i].get()[j] != getRangeFutures[3][i].get()[j])
															#line 3281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				{
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent(SevError, "SRL_ResultMismatch") .detail("J", j) .detail("Result1", printable(getRangeFutures[0][i].get()[j])) .detail("Result2", printable(getRangeFutures[3][i].get()[j])) .detail("Result1Value", printable(getRangeFutures[0][i].get()[j].value)) .detail("Result2Value", printable(getRangeFutures[3][i].get()[j].value));
															#line 476 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					for( auto kv : getRangeFutures[0][i].get() ) {
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
						TraceEvent("SRL_Result1").detail("Kv", printable(kv));
															#line 3289 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
					}
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					for( auto kv : getRangeFutures[3][i].get() ) {
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
						TraceEvent("SRL_Result2").detail("Kv", printable(kv));
															#line 3295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
					}
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					ASSERT(false);
															#line 3299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
			}
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getRangeFutures[0][i].get() == getRangeFutures[3][i].get());
															#line 3304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 488 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getRangeFutures[1].size();i++) {
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getRangeFutures[1][i].get() == getRangeFutures[3][getRangeFutures[0].size() + i].get());
															#line 3310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getRangeFutures[2].size();i++) {
															#line 493 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			if (getRangeFutures[2][i].get().size() != getRangeFutures[4][i].get().size())
															#line 3316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			{
															#line 494 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				TraceEvent(SevError, "SRL_ResultMismatch") .detail("Size1", getRangeFutures[2][i].get().size()) .detail("Size2", getRangeFutures[4][i].get().size());
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				for( auto kv : getRangeFutures[2][i].get() ) {
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent("SRL_Result1").detail("Kv", printable(kv));
															#line 3324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				for( auto kv : getRangeFutures[4][i].get() ) {
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent("SRL_Result2").detail("Kv", printable(kv));
															#line 3330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				ASSERT(false);
															#line 3334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			}
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			for(int j = 0;j < getRangeFutures[2][i].get().size();j++) {
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				if (getRangeFutures[2][i].get()[j] != getRangeFutures[4][i].get()[j])
															#line 3340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				{
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent(SevError, "SRL_ResultMismatch") .detail("J", j) .detail("Result1", printable(getRangeFutures[2][i].get()[j])) .detail("Result2", printable(getRangeFutures[4][i].get()[j])) .detail("Result1Value", printable(getRangeFutures[2][i].get()[j].value)) .detail("Result2Value", printable(getRangeFutures[4][i].get()[j].value));
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					for( auto kv : getRangeFutures[2][i].get() ) {
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
						TraceEvent("SRL_Result1").detail("Kv", printable(kv));
															#line 3348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
					}
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					for( auto kv : getRangeFutures[4][i].get() ) {
															#line 518 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
						TraceEvent("SRL_Result2").detail("Kv", printable(kv));
															#line 3354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
					}
															#line 520 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					ASSERT(false);
															#line 3358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
			}
															#line 524 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getRangeFutures[2][i].get() == getRangeFutures[4][i].get());
															#line 3363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont10cont41(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont9(RangeResult && result2,int loopDepth) 
	{
															#line 402 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		if (result1.size() != result2.size())
															#line 3373 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		{
															#line 403 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			TraceEvent(SevError, "SRL_ResultMismatch") .detail("Size1", result1.size()) .detail("Size2", result2.size());
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			for( auto kv : result1 ) {
															#line 408 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				TraceEvent("SRL_Result1").detail("Kv", printable(kv));
															#line 3381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			}
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			for( auto kv : result2 ) {
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				TraceEvent("SRL_Result2").detail("Kv", printable(kv));
															#line 3387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			}
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(false);
															#line 3391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 415 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < result1.size();i++) {
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			if (result1[i] != result2[i])
															#line 3397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			{
															#line 417 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				TraceEvent(SevError, "SRL_ResultMismatch") .detail("I", i) .detail("Result1", printable(result1[i])) .detail("Result2", printable(result2[i])) .detail("Result1Value", printable(result1[i].value)) .detail("Result2Value", printable(result2[i].value));
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				for( auto kv : result1 ) {
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent("SRL_Result1").detail("Kv", printable(kv));
															#line 3405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				for( auto kv : result2 ) {
															#line 427 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent("SRL_Result2").detail("Kv", printable(kv));
															#line 3411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				ASSERT(false);
															#line 3415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			}
		}
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getFutures[0].size();i++) {
															#line 434 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getFutures[0][i].get() == getFutures[3][i].get());
															#line 3422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 436 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getFutures[1].size();i++) {
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getFutures[1][i].get() == getFutures[3][getFutures[0].size() + i].get());
															#line 3428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getFutures[2].size();i++) {
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getFutures[2][i].get() == getFutures[4][i].get());
															#line 3434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getKeyFutures[0].size();i++) {
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getKeyFutures[0][i].get() == getKeyFutures[3][i].get());
															#line 3440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 446 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getKeyFutures[1].size();i++) {
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getKeyFutures[1][i].get() == getKeyFutures[3][getKeyFutures[0].size() + i].get());
															#line 3446 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 449 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getKeyFutures[2].size();i++) {
															#line 450 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getKeyFutures[2][i].get() == getKeyFutures[4][i].get());
															#line 3452 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getRangeFutures[0].size();i++) {
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			if (getRangeFutures[0][i].get().size() != getRangeFutures[3][i].get().size())
															#line 3458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			{
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				TraceEvent(SevError, "SRL_ResultMismatch") .detail("Size1", getRangeFutures[0][i].get().size()) .detail("Size2", getRangeFutures[3][i].get().size());
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				for( auto kv : getRangeFutures[0][i].get() ) {
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent("SRL_Result1").detail("Kv", printable(kv));
															#line 3466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
															#line 461 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				for( auto kv : getRangeFutures[3][i].get() ) {
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent("SRL_Result2").detail("Kv", printable(kv));
															#line 3472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
															#line 464 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				ASSERT(false);
															#line 3476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			}
															#line 467 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			for(int j = 0;j < getRangeFutures[0][i].get().size();j++) {
															#line 468 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				if (getRangeFutures[0][i].get()[j] != getRangeFutures[3][i].get()[j])
															#line 3482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				{
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent(SevError, "SRL_ResultMismatch") .detail("J", j) .detail("Result1", printable(getRangeFutures[0][i].get()[j])) .detail("Result2", printable(getRangeFutures[3][i].get()[j])) .detail("Result1Value", printable(getRangeFutures[0][i].get()[j].value)) .detail("Result2Value", printable(getRangeFutures[3][i].get()[j].value));
															#line 476 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					for( auto kv : getRangeFutures[0][i].get() ) {
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
						TraceEvent("SRL_Result1").detail("Kv", printable(kv));
															#line 3490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
					}
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					for( auto kv : getRangeFutures[3][i].get() ) {
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
						TraceEvent("SRL_Result2").detail("Kv", printable(kv));
															#line 3496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
					}
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					ASSERT(false);
															#line 3500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
			}
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getRangeFutures[0][i].get() == getRangeFutures[3][i].get());
															#line 3505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 488 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getRangeFutures[1].size();i++) {
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getRangeFutures[1][i].get() == getRangeFutures[3][getRangeFutures[0].size() + i].get());
															#line 3511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
		for(int i = 0;i < getRangeFutures[2].size();i++) {
															#line 493 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			if (getRangeFutures[2][i].get().size() != getRangeFutures[4][i].get().size())
															#line 3517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			{
															#line 494 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				TraceEvent(SevError, "SRL_ResultMismatch") .detail("Size1", getRangeFutures[2][i].get().size()) .detail("Size2", getRangeFutures[4][i].get().size());
															#line 498 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				for( auto kv : getRangeFutures[2][i].get() ) {
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent("SRL_Result1").detail("Kv", printable(kv));
															#line 3525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
															#line 500 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				for( auto kv : getRangeFutures[4][i].get() ) {
															#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent("SRL_Result2").detail("Kv", printable(kv));
															#line 3531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				ASSERT(false);
															#line 3535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
			}
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			for(int j = 0;j < getRangeFutures[2][i].get().size();j++) {
															#line 507 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
				if (getRangeFutures[2][i].get()[j] != getRangeFutures[4][i].get()[j])
															#line 3541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				{
															#line 508 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					TraceEvent(SevError, "SRL_ResultMismatch") .detail("J", j) .detail("Result1", printable(getRangeFutures[2][i].get()[j])) .detail("Result2", printable(getRangeFutures[4][i].get()[j])) .detail("Result1Value", printable(getRangeFutures[2][i].get()[j].value)) .detail("Result2Value", printable(getRangeFutures[4][i].get()[j].value));
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					for( auto kv : getRangeFutures[2][i].get() ) {
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
						TraceEvent("SRL_Result1").detail("Kv", printable(kv));
															#line 3549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
					}
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					for( auto kv : getRangeFutures[4][i].get() ) {
															#line 518 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
						TraceEvent("SRL_Result2").detail("Kv", printable(kv));
															#line 3555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
					}
															#line 520 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
					ASSERT(false);
															#line 3559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
				}
			}
															#line 524 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
			ASSERT(getRangeFutures[2][i].get() == getRangeFutures[4][i].get());
															#line 3564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont10cont41(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont8when1(RangeResult const& result2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont9(result2, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont8when1(RangeResult && result2,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont9(std::move(result2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 14, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 14, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1loopBody1cont10cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _startActor, 14, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1loopBody1cont10cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _startActor, 14, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1loopBody1cont10cont41(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< _startActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	Database cx;
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	SerializabilityWorkload* self;
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	double startTime;
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	std::vector<ReadYourWritesTransaction> tr;
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	std::vector<std::vector<Future<Optional<Value>>>> getFutures;
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	std::vector<std::vector<Future<Key>>> getKeyFutures;
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	std::vector<std::vector<Future<RangeResult>>> getRangeFutures;
															#line 336 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	std::vector<std::vector<Future<Void>>> watchFutures;
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> initialData;
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	std::vector<TransactionOperation> a;
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	std::vector<TransactionOperation> b;
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	std::vector<TransactionOperation> c;
															#line 385 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	RangeResult result1;
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	ReadYourWritesTransaction trErr;
															#line 3773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, RangeResult >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, Void >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, Void >, public ActorCallback< _startActor, 12, Void >, public ActorCallback< _startActor, 13, Void >, public ActorCallback< _startActor, 14, RangeResult >, public ActorCallback< _startActor, 15, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 3778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11142675054260896512UL, 13312882687149221376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, RangeResult >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, Void >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, Void >;
friend struct ActorCallback< _startActor, 12, Void >;
friend struct ActorCallback< _startActor, 13, Void >;
friend struct ActorCallback< _startActor, 14, RangeResult >;
friend struct ActorCallback< _startActor, 15, Void >;
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	_startActor(Database const& cx,SerializabilityWorkload* const& self) 
															#line 3810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, RangeResult >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _startActor, 14, RangeResult >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< _startActor, 15, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, SerializabilityWorkload* const& self ) {
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 3857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Serializability.actor.g.cpp"
}

#line 532 "/Users/ec2-user/foundationdb/fdbserver/workloads/Serializability.actor.cpp"
};

WorkloadFactory<SerializabilityWorkload> SerializabilityWorkloadFactory;
