#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
/*
 * SelectorCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct SelectorCorrectnessWorkload : TestWorkload {
	static constexpr auto NAME = "SelectorCorrectness";

	int minOperationsPerTransaction, maxOperationsPerTransaction, maxKeySpace, maxOffset;
	bool testReadYourWrites;
	double testDuration;

	std::vector<Future<Void>> clients;
	PerfIntCounter transactions, retries;

	SelectorCorrectnessWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), transactions("Transactions"), retries("Retries") {

		minOperationsPerTransaction = getOption(options, "minOperationsPerTransaction"_sr, 10);
		maxOperationsPerTransaction = getOption(options, "minOperationsPerTransaction"_sr, 50);
		maxKeySpace = getOption(options, "maxKeySpace"_sr, 10);
		maxOffset = getOption(options, "maxOffset"_sr, 20);
		testReadYourWrites = getOption(options, "testReadYourWrites"_sr, true);
		testDuration = getOption(options, "testDuration"_sr, 10.0);
	}

	Future<Void> setup(Database const& cx) override { return SelectorCorrectnessSetup(cx->clone(), this); }

	Future<Void> start(Database const& cx) override {
		clients.push_back(timeout(SelectorCorrectnessClient(cx->clone(), this), testDuration, Void()));
		return delay(testDuration);
	}

	Future<bool> check(Database const& cx) override {
		clients.clear();
		return true;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(transactions.getMetric());
		m.push_back(retries.getMetric());
	}

																#line 67 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
// This generated class is to be used only via SelectorCorrectnessSetup()
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
template <class SelectorCorrectnessSetupActor>
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
class SelectorCorrectnessSetupActorState {
															#line 73 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
public:
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	SelectorCorrectnessSetupActorState(Database const& cx,SelectorCorrectnessWorkload* const& self) 
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		 : cx(cx),
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		   self(self),
															#line 66 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		   myValue(StringRef(format("%010d", deterministicRandom()->randomInt(0, 10000000)))),
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		   tr(cx)
															#line 86 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this));

	}
	~SelectorCorrectnessSetupActorState() 
	{
		fdb_probe_actor_destroy("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			if (!self->testReadYourWrites)
															#line 101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			{
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				;
															#line 105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				;
															#line 112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
				loopDepth = a_body1loopHead2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SelectorCorrectnessSetupActorState();
		static_cast<SelectorCorrectnessSetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		if (!static_cast<SelectorCorrectnessSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SelectorCorrectnessSetupActorState(); static_cast<SelectorCorrectnessSetupActor*>(this)->destroy(); return 0; }
															#line 136 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		new (&static_cast<SelectorCorrectnessSetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SelectorCorrectnessSetupActorState();
		static_cast<SelectorCorrectnessSetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			for(int i = 0;i < self->maxKeySpace;i += 2) {
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				tr.set(StringRef(format("%010d", i)), myValue);
															#line 164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			}
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			if (static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state = 1;
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SelectorCorrectnessSetupActor, 0, Void >*>(static_cast<SelectorCorrectnessSetupActor*>(this)));
															#line 175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			if (static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state = 2;
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SelectorCorrectnessSetupActor, 1, Void >*>(static_cast<SelectorCorrectnessSetupActor*>(this)));
															#line 217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state > 0) static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state = 0;
		static_cast<SelectorCorrectnessSetupActor*>(this)->ActorCallback< SelectorCorrectnessSetupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessSetupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessSetupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SelectorCorrectnessSetupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state > 0) static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state = 0;
		static_cast<SelectorCorrectnessSetupActor*>(this)->ActorCallback< SelectorCorrectnessSetupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessSetupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessSetupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SelectorCorrectnessSetupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead2(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2(int loopDepth) 
	{
		try {
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			for(int i = 0;i < self->maxKeySpace;i += 4) {
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				tr.set(StringRef(format("%010d", i)), myValue);
															#line 422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			}
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			for(int i = 2;i < self->maxKeySpace;i += 4) {
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				if (deterministicRandom()->random01() > 0.5)
															#line 428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
				{
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
					tr.set(StringRef(format("%010d", i)), myValue);
															#line 432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
				}
			}
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			if (static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state < 0) return a_body1loopBody2Catch1(actor_cancelled(), loopDepth);
															#line 439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody2when1(__when_expr_2.get(), loopDepth); };
			static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state = 3;
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SelectorCorrectnessSetupActor, 2, Void >*>(static_cast<SelectorCorrectnessSetupActor*>(this)));
															#line 444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break2(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody2cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead2(0);

		return loopDepth;
	}
	int a_body1loopBody2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			if (static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody2Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state = 4;
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SelectorCorrectnessSetupActor, 3, Void >*>(static_cast<SelectorCorrectnessSetupActor*>(this)));
															#line 486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody2cont2(Void const& _,int loopDepth) 
	{
		return a_body1break2(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody2cont2(Void && _,int loopDepth) 
	{
		return a_body1break2(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state > 0) static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state = 0;
		static_cast<SelectorCorrectnessSetupActor*>(this)->ActorCallback< SelectorCorrectnessSetupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessSetupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessSetupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SelectorCorrectnessSetupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody2Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state > 0) static_cast<SelectorCorrectnessSetupActor*>(this)->actor_wait_state = 0;
		static_cast<SelectorCorrectnessSetupActor*>(this)->ActorCallback< SelectorCorrectnessSetupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessSetupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody2Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessSetupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody2Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SelectorCorrectnessSetupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	Database cx;
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	SelectorCorrectnessWorkload* self;
															#line 66 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	Value myValue;
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	Transaction tr;
															#line 679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
};
// This generated class is to be used only via SelectorCorrectnessSetup()
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
class SelectorCorrectnessSetupActor final : public Actor<Void>, public ActorCallback< SelectorCorrectnessSetupActor, 0, Void >, public ActorCallback< SelectorCorrectnessSetupActor, 1, Void >, public ActorCallback< SelectorCorrectnessSetupActor, 2, Void >, public ActorCallback< SelectorCorrectnessSetupActor, 3, Void >, public FastAllocated<SelectorCorrectnessSetupActor>, public SelectorCorrectnessSetupActorState<SelectorCorrectnessSetupActor> {
															#line 684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
public:
	using FastAllocated<SelectorCorrectnessSetupActor>::operator new;
	using FastAllocated<SelectorCorrectnessSetupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9139599359320251136UL, 5984635961589575936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SelectorCorrectnessSetupActor, 0, Void >;
friend struct ActorCallback< SelectorCorrectnessSetupActor, 1, Void >;
friend struct ActorCallback< SelectorCorrectnessSetupActor, 2, Void >;
friend struct ActorCallback< SelectorCorrectnessSetupActor, 3, Void >;
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	SelectorCorrectnessSetupActor(Database const& cx,SelectorCorrectnessWorkload* const& self) 
															#line 704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   SelectorCorrectnessSetupActorState<SelectorCorrectnessSetupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7254672049556388096UL, 11995962633367131648UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("SelectorCorrectnessSetup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("SelectorCorrectnessSetup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SelectorCorrectnessSetupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SelectorCorrectnessSetupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SelectorCorrectnessSetupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SelectorCorrectnessSetupActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
[[nodiscard]] Future<Void> SelectorCorrectnessSetup( Database const& cx, SelectorCorrectnessWorkload* const& self ) {
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	return Future<Void>(new SelectorCorrectnessSetupActor(cx, self));
															#line 739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
}

#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"

																#line 744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
// This generated class is to be used only via SelectorCorrectnessClient()
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
template <class SelectorCorrectnessClientActor>
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
class SelectorCorrectnessClientActorState {
															#line 750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
public:
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	SelectorCorrectnessClientActorState(Database const& cx,SelectorCorrectnessWorkload* const& self) 
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		 : cx(cx),
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		   self(self),
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		   i(),
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		   j(),
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		   myKeyA(),
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		   myKeyB(),
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		   myValue(),
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		   onEqualA(),
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		   onEqualB(),
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		   offsetA(),
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		   offsetB(),
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		   maxKey(),
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		   reverse(Reverse::False)
															#line 781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this));

	}
	~SelectorCorrectnessClientActorState() 
	{
		fdb_probe_actor_destroy("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			maxKey = Standalone<StringRef>(format("%010d", self->maxKeySpace + 1));
															#line 116 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			;
															#line 798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SelectorCorrectnessClientActorState();
		static_cast<SelectorCorrectnessClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		tr = Transaction(cx);
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		trRYOW = ReadYourWritesTransaction(cx);
															#line 121 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		if (self->testReadYourWrites)
															#line 832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		{
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			myValue = StringRef(format("%010d", deterministicRandom()->randomInt(0, 10000000)));
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			for(int i = 2;i < self->maxKeySpace;i += 4) {
															#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				trRYOW.set(StringRef(format("%010d", i)), myValue);
															#line 840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			}
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			for(int i = 0;i < self->maxKeySpace;i += 4) {
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				if (deterministicRandom()->random01() > 0.5)
															#line 846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
				{
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
					trRYOW.set(StringRef(format("%010d", i)), myValue);
															#line 850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
				}
			}
		}
		try {
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			i = 0;
															#line 857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_4 = trRYOW.onError(e);
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			if (static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state = 5;
															#line 240 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SelectorCorrectnessClientActor, 4, Void >*>(static_cast<SelectorCorrectnessClientActor*>(this)));
															#line 886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		tr.reset();
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		trRYOW.reset();
															#line 238 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		++self->transactions;
															#line 905 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		if (!(i < deterministicRandom()->randomInt(self->minOperationsPerTransaction, self->maxOperationsPerTransaction + 1)))
															#line 921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		j = deterministicRandom()->randomInt(0, 2);
															#line 135 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		if (j < 1)
															#line 929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		{
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			searchInt = deterministicRandom()->randomInt(0, self->maxKeySpace);
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			myKeyA = format("%010d", searchInt);
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			if (self->testReadYourWrites)
															#line 937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			{
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_0 = trRYOW.get(StringRef(myKeyA));
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				if (static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state = 1;
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SelectorCorrectnessClientActor, 0, Optional<Value> >*>(static_cast<SelectorCorrectnessClientActor*>(this)));
															#line 948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_1 = tr.get(StringRef(myKeyA));
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				if (static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state = 2;
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SelectorCorrectnessClientActor, 1, Optional<Value> >*>(static_cast<SelectorCorrectnessClientActor*>(this)));
															#line 962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
		}
		else
		{
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			int a = deterministicRandom()->randomInt(2, self->maxKeySpace);
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			int b = deterministicRandom()->randomInt(2, 2 * self->maxKeySpace);
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			int abmax = std::max(a, b);
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			int abmin = std::min(a, b) - 1;
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			myKeyA = format("%010d", abmin);
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			myKeyB = format("%010d", abmax);
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			onEqualA = deterministicRandom()->randomInt(0, 2) != 0;
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			onEqualB = deterministicRandom()->randomInt(0, 2) != 0;
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			offsetA = 1;
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			offsetB = deterministicRandom()->randomInt(1, self->maxOffset);
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			reverse.set(deterministicRandom()->coinflip());
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			expectedSize = (std::min(abmax + 2 * offsetB - (abmax % 2 == 1 ? 1 : (onEqualB ? 0 : 2)), self->maxKeySpace) - (std::max(abmin + 2 * offsetA - (abmin % 2 == 1 ? 1 : (onEqualA ? 0 : 2)), 0))) / 2;
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			if (self->testReadYourWrites)
															#line 994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			{
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				StrictFuture<RangeResult> __when_expr_2 = trRYOW.getRange(KeySelectorRef(StringRef(myKeyA), onEqualA, offsetA), KeySelectorRef(StringRef(myKeyB), onEqualB, offsetB), 2 * (self->maxKeySpace + self->maxOffset), Snapshot::False, reverse);
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				if (static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when3(__when_expr_2.get(), loopDepth); };
				static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state = 3;
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SelectorCorrectnessClientActor, 2, RangeResult >*>(static_cast<SelectorCorrectnessClientActor*>(this)));
															#line 1005 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				StrictFuture<RangeResult> __when_expr_3 = tr.getRange(KeySelectorRef(StringRef(myKeyA), onEqualA, offsetA), KeySelectorRef(StringRef(myKeyB), onEqualB, offsetB), 2 * (self->maxKeySpace + self->maxOffset), Snapshot::False, reverse);
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				if (static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1014 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when4(__when_expr_3.get(), loopDepth); };
				static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state = 4;
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SelectorCorrectnessClientActor, 3, RangeResult >*>(static_cast<SelectorCorrectnessClientActor*>(this)));
															#line 1019 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		i++;
															#line 1043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Optional<Value> const& getTest,int loopDepth) 
	{
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		if ((searchInt % 2 == 0 && !getTest.present()) || (searchInt % 2 == 1 && getTest.present()))
															#line 1058 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		{
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "Value not present") .detail("KeyA", myKeyA);
															#line 1062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Optional<Value> && getTest,int loopDepth) 
	{
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		if ((searchInt % 2 == 0 && !getTest.present()) || (searchInt % 2 == 1 && getTest.present()))
															#line 1072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		{
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "Value not present") .detail("KeyA", myKeyA);
															#line 1076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> const& getTest,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(getTest, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Optional<Value> && getTest,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(getTest), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state > 0) static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state = 0;
		static_cast<SelectorCorrectnessClientActor*>(this)->ActorCallback< SelectorCorrectnessClientActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessClientActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessClientActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SelectorCorrectnessClientActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont7(Optional<Value> const& getTest,int loopDepth) 
	{
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		if ((searchInt % 2 == 0 && !getTest.present()) || (searchInt % 2 == 1 && getTest.present()))
															#line 1161 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		{
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "Value not present") .detail("KeyA", myKeyA);
															#line 1165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont7(Optional<Value> && getTest,int loopDepth) 
	{
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		if ((searchInt % 2 == 0 && !getTest.present()) || (searchInt % 2 == 1 && getTest.present()))
															#line 1175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		{
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "Value not present") .detail("KeyA", myKeyA);
															#line 1179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Optional<Value> const& getTest,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont7(getTest, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Optional<Value> && getTest,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont7(std::move(getTest), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state > 0) static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state = 0;
		static_cast<SelectorCorrectnessClientActor*>(this)->ActorCallback< SelectorCorrectnessClientActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessClientActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessClientActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SelectorCorrectnessClientActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont10(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont11(RangeResult const& getRangeTest,int loopDepth) 
	{
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		int trueSize = 0;
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		for(;trueSize < getRangeTest.size() && getRangeTest[!reverse ? trueSize : getRangeTest.size() - trueSize - 1].key < maxKey;) {
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			trueSize++;
															#line 1274 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		}
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		if (trueSize != expectedSize)
															#line 1278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			std::string outStr = "";
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			for(int k = 0;k < trueSize;k++) {
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				std::string keyStr = printable(getRangeTest[!reverse ? k : getRangeTest.size() - k - 1].key);
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				outStr = outStr + keyStr + " ";
															#line 1288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			}
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "The getRange results did not match expected size") .detail("Size", trueSize) .detail("Expected", expectedSize) .detail("Data", outStr) .detail("DataSize", getRangeTest.size());
															#line 1292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont11(RangeResult && getRangeTest,int loopDepth) 
	{
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		int trueSize = 0;
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		for(;trueSize < getRangeTest.size() && getRangeTest[!reverse ? trueSize : getRangeTest.size() - trueSize - 1].key < maxKey;) {
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			trueSize++;
															#line 1306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		}
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		if (trueSize != expectedSize)
															#line 1310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			std::string outStr = "";
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			for(int k = 0;k < trueSize;k++) {
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				std::string keyStr = printable(getRangeTest[!reverse ? k : getRangeTest.size() - k - 1].key);
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				outStr = outStr + keyStr + " ";
															#line 1320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			}
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "The getRange results did not match expected size") .detail("Size", trueSize) .detail("Expected", expectedSize) .detail("Data", outStr) .detail("DataSize", getRangeTest.size());
															#line 1324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(RangeResult const& getRangeTest,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont11(getRangeTest, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(RangeResult && getRangeTest,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont11(std::move(getRangeTest), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state > 0) static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state = 0;
		static_cast<SelectorCorrectnessClientActor*>(this)->ActorCallback< SelectorCorrectnessClientActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessClientActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessClientActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SelectorCorrectnessClientActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont12(RangeResult const& getRangeTest,int loopDepth) 
	{
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		int trueSize = 0;
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		for(;trueSize < getRangeTest.size() && getRangeTest[!reverse ? trueSize : getRangeTest.size() - trueSize - 1].key < maxKey;) {
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			trueSize++;
															#line 1413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		}
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		if (trueSize != expectedSize)
															#line 1417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		{
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			std::string outStr = "";
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			for(int k = 0;k < trueSize;k++) {
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				std::string keyStr = printable(getRangeTest[!reverse ? k : getRangeTest.size() - k - 1].key);
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				outStr = outStr + keyStr + " ";
															#line 1427 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			}
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "The getRange results did not match expected size") .detail("Size", trueSize) .detail("Expected", expectedSize) .detail("Data", outStr) .detail("DataSize", getRangeTest.size());
															#line 1431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont12(RangeResult && getRangeTest,int loopDepth) 
	{
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		int trueSize = 0;
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		for(;trueSize < getRangeTest.size() && getRangeTest[!reverse ? trueSize : getRangeTest.size() - trueSize - 1].key < maxKey;) {
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			trueSize++;
															#line 1445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		}
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		if (trueSize != expectedSize)
															#line 1449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		{
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			std::string outStr = "";
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			for(int k = 0;k < trueSize;k++) {
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				std::string keyStr = printable(getRangeTest[!reverse ? k : getRangeTest.size() - k - 1].key);
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
				outStr = outStr + keyStr + " ";
															#line 1459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
			}
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
			TraceEvent(SevError, "RanSelTestFailure") .detail("Reason", "The getRange results did not match expected size") .detail("Size", trueSize) .detail("Expected", expectedSize) .detail("Data", outStr) .detail("DataSize", getRangeTest.size());
															#line 1463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when4(RangeResult const& getRangeTest,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont12(getRangeTest, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when4(RangeResult && getRangeTest,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont12(std::move(getRangeTest), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state > 0) static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state = 0;
		static_cast<SelectorCorrectnessClientActor*>(this)->ActorCallback< SelectorCorrectnessClientActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessClientActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessClientActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SelectorCorrectnessClientActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		trRYOW.reset();
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		++self->retries;
															#line 1563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 241 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		trRYOW.reset();
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
		++self->retries;
															#line 1574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state > 0) static_cast<SelectorCorrectnessClientActor*>(this)->actor_wait_state = 0;
		static_cast<SelectorCorrectnessClientActor*>(this)->ActorCallback< SelectorCorrectnessClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< SelectorCorrectnessClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< SelectorCorrectnessClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	Database cx;
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	SelectorCorrectnessWorkload* self;
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	int i;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	int j;
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	std::string myKeyA;
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	std::string myKeyB;
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	Value myValue;
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	bool onEqualA;
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	bool onEqualB;
															#line 109 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	int offsetA;
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	int offsetB;
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	Standalone<StringRef> maxKey;
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	Reverse reverse;
															#line 118 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	Transaction tr;
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	ReadYourWritesTransaction trRYOW;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	int searchInt;
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	int expectedSize;
															#line 1688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
};
// This generated class is to be used only via SelectorCorrectnessClient()
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
class SelectorCorrectnessClientActor final : public Actor<Void>, public ActorCallback< SelectorCorrectnessClientActor, 0, Optional<Value> >, public ActorCallback< SelectorCorrectnessClientActor, 1, Optional<Value> >, public ActorCallback< SelectorCorrectnessClientActor, 2, RangeResult >, public ActorCallback< SelectorCorrectnessClientActor, 3, RangeResult >, public ActorCallback< SelectorCorrectnessClientActor, 4, Void >, public FastAllocated<SelectorCorrectnessClientActor>, public SelectorCorrectnessClientActorState<SelectorCorrectnessClientActor> {
															#line 1693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
public:
	using FastAllocated<SelectorCorrectnessClientActor>::operator new;
	using FastAllocated<SelectorCorrectnessClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17203913225737204480UL, 5560766975168389376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SelectorCorrectnessClientActor, 0, Optional<Value> >;
friend struct ActorCallback< SelectorCorrectnessClientActor, 1, Optional<Value> >;
friend struct ActorCallback< SelectorCorrectnessClientActor, 2, RangeResult >;
friend struct ActorCallback< SelectorCorrectnessClientActor, 3, RangeResult >;
friend struct ActorCallback< SelectorCorrectnessClientActor, 4, Void >;
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	SelectorCorrectnessClientActor(Database const& cx,SelectorCorrectnessWorkload* const& self) 
															#line 1714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   SelectorCorrectnessClientActorState<SelectorCorrectnessClientActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14576126037548593920UL, 8912058803718844160UL);
		ActorExecutionContextHelper __helper(static_cast<SelectorCorrectnessClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("SelectorCorrectnessClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("SelectorCorrectnessClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SelectorCorrectnessClientActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SelectorCorrectnessClientActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SelectorCorrectnessClientActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SelectorCorrectnessClientActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< SelectorCorrectnessClientActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
[[nodiscard]] Future<Void> SelectorCorrectnessClient( Database const& cx, SelectorCorrectnessWorkload* const& self ) {
															#line 101 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
	return Future<Void>(new SelectorCorrectnessClientActor(cx, self));
															#line 1750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/SelectorCorrectness.actor.g.cpp"
}

#line 246 "/Users/ec2-user/foundationdb/fdbserver/workloads/SelectorCorrectness.actor.cpp"
};

WorkloadFactory<SelectorCorrectnessWorkload> SelectorCorrectnessWorkloadFactory;
