#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
/*
 * MetaclusterManagementWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdint>
#include <limits>
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/GenericManagementAPI.actor.h"
#include "fdbclient/MultiVersionTransaction.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbclient/ThreadSafeTransaction.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/Knobs.h"
#include "flow/BooleanParam.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/flow.h"
#include "fdbserver/ServerDBInfo.actor.h"

#include "metacluster/Metacluster.h"
#include "metacluster/MetaclusterConsistency.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

struct MetaclusterManagementWorkload : TestWorkload {
	static constexpr auto NAME = "MetaclusterManagement";

	struct TenantTestData : ReferenceCounted<TenantTestData> {
		ClusterName cluster;
		Optional<TenantGroupName> tenantGroup;
		Optional<UID> lockId;
		TenantAPI::TenantLockState lockState = TenantAPI::TenantLockState::UNLOCKED;

		TenantTestData() {}
		TenantTestData(ClusterName cluster, Optional<TenantGroupName> tenantGroup)
		  : cluster(cluster), tenantGroup(tenantGroup) {}
	};

	struct TenantGroupData : ReferenceCounted<TenantGroupData> {
		ClusterName cluster;
		std::set<TenantName> tenants;

		TenantGroupData() {}
		TenantGroupData(ClusterName cluster) : cluster(cluster) {}
	};

	struct DataClusterData : ReferenceCounted<DataClusterData> {
		Database db;
		bool registered = false;
		bool detached = false;
		int tenantGroupCapacity = 0;
		MetaclusterVersion version;

		std::map<TenantName, Reference<TenantTestData>> tenants;
		std::map<TenantGroupName, Reference<TenantGroupData>> tenantGroups;
		std::set<TenantName> ungroupedTenants;

		metacluster::AutoTenantAssignment autoTenantAssignment = metacluster::AutoTenantAssignment::ENABLED;

		DataClusterData() {}
		DataClusterData(Database db) : db(db) {}
	};

	bool metaclusterCreated;

	Reference<IDatabase> managementDb;
	MetaclusterVersion managementVersion;

	std::map<ClusterName, Reference<DataClusterData>> dataDbs;
	std::map<TenantGroupName, Reference<TenantGroupData>> tenantGroups;
	std::set<TenantName> ungroupedTenants;
	std::vector<ClusterName> dataDbIndex;

	int64_t totalTenantGroupCapacity = 0;
	std::map<TenantName, Reference<TenantTestData>> createdTenants;

	int maxTenants;
	int maxTenantGroups;
	bool allowTenantIdPrefixReuse;
	int64_t tenantIdPrefix = -1;
	std::set<int64_t> usedPrefixes;
	double testDuration;
	bool useExistingMetacluster;

	MetaclusterManagementWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), metaclusterCreated(deterministicRandom()->coinflip()) {
		maxTenants = std::min<int>(1e8 - 1, getOption(options, "maxTenants"_sr, 1000));
		maxTenantGroups = std::min<int>(2 * maxTenants, getOption(options, "maxTenantGroups"_sr, 20));
		testDuration = getOption(options, "testDuration"_sr, 120.0);
		useExistingMetacluster = getOption(options, "useExistingMetacluster"_sr, false);
		allowTenantIdPrefixReuse = deterministicRandom()->coinflip();
		MetaclusterRegistrationEntry::allowUnsupportedRegistrationWrites = true;
	}

	Optional<int64_t> generateTenantIdPrefix() {
		for (int i = 0; i < 20; ++i) {
			int64_t newPrefix = deterministicRandom()->randomInt(TenantAPI::TENANT_ID_PREFIX_MIN_VALUE,
			                                                     TenantAPI::TENANT_ID_PREFIX_MAX_VALUE + 1);
			if (allowTenantIdPrefixReuse || !usedPrefixes.contains(newPrefix)) {
				CODE_PROBE(usedPrefixes.contains(newPrefix), "Reusing tenant ID prefix", probe::decoration::rare);
				return newPrefix;
			}
		}

		return false;
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override { out.insert("Attrition"); }

	Future<Void> setup(Database const& cx) override {
		if (clientId == 0) {
			if (!useExistingMetacluster && g_network->isSimulated() && BUGGIFY) {
				IKnobCollection::getMutableGlobalKnobCollection().setKnob(
				    "max_tenants_per_cluster", KnobValueRef::create(int{ deterministicRandom()->randomInt(20, 100) }));
			}
			return _setup(cx, this);
		} else {
			return Void();
		}
	}
																#line 144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class _setupActor>
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class _setupActorState {
															#line 150 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	_setupActorState(Database const& cx,MetaclusterManagementWorkload* const& self) 
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : cx(cx),
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   self(self)
															#line 159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(g_simulator->extraDatabases.size() > 0);
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (!self->useExistingMetacluster)
															#line 176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (self->metaclusterCreated)
															#line 180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 147 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					self->tenantIdPrefix = self->generateTenantIdPrefix().get();
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					self->usedPrefixes.insert(self->tenantIdPrefix);
															#line 186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				StrictFuture<metacluster::util::SimulatedMetacluster> __when_expr_0 = metacluster::util::createSimulatedMetacluster( cx, self->tenantIdPrefix, Optional<metacluster::DataClusterEntry>(), metacluster::util::SkipMetaclusterCreation(!self->metaclusterCreated));
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >*>(static_cast<_setupActor*>(this)));
															#line 197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				StrictFuture<metacluster::util::SimulatedMetacluster> __when_expr_2 = metacluster::util::createSimulatedMetacluster( cx, {}, {}, metacluster::util::SkipMetaclusterCreation::True);
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when2(__when_expr_2.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, metacluster::util::SimulatedMetacluster >*>(static_cast<_setupActor*>(this)));
															#line 211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(metacluster::util::SimulatedMetacluster const& simMetacluster,int loopDepth) 
	{
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->managementDb = simMetacluster.managementDb;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for( auto const& [name, db] : simMetacluster.dataDbs ) {
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->dataDbIndex.push_back(name);
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->dataDbs[name] = makeReference<DataClusterData>(db);
															#line 253 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (self->metaclusterCreated)
															#line 257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_1 = metacluster::metadata::metaclusterRegistration().get(self->managementDb);
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Optional<MetaclusterRegistrationEntry> >*>(static_cast<_setupActor*>(this)));
															#line 268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(metacluster::util::SimulatedMetacluster && simMetacluster,int loopDepth) 
	{
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->managementDb = simMetacluster.managementDb;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for( auto const& [name, db] : simMetacluster.dataDbs ) {
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->dataDbIndex.push_back(name);
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->dataDbs[name] = makeReference<DataClusterData>(db);
															#line 288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (self->metaclusterCreated)
															#line 292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_1 = metacluster::metadata::metaclusterRegistration().get(self->managementDb);
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 298 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Optional<MetaclusterRegistrationEntry> >*>(static_cast<_setupActor*>(this)));
															#line 303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(metacluster::util::SimulatedMetacluster const& simMetacluster,int loopDepth) 
	{
		loopDepth = a_body1cont2(simMetacluster, loopDepth);

		return loopDepth;
	}
	int a_body1when1(metacluster::util::SimulatedMetacluster && simMetacluster,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(simMetacluster), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >*,metacluster::util::SimulatedMetacluster const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >*,metacluster::util::SimulatedMetacluster && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Optional<MetaclusterRegistrationEntry> const& registration,int loopDepth) 
	{
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(registration.present());
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->managementVersion = registration.get().version;
															#line 400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Optional<MetaclusterRegistrationEntry> && registration,int loopDepth) 
	{
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(registration.present());
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->managementVersion = registration.get().version;
															#line 411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<MetaclusterRegistrationEntry> const& registration,int loopDepth) 
	{
		loopDepth = a_body1cont6(registration, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<MetaclusterRegistrationEntry> && registration,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(registration), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(metacluster::util::SimulatedMetacluster const& simMetacluster,int loopDepth) 
	{
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->managementDb = simMetacluster.managementDb;
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = loadExistingMetacluster(self);
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 4;
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 3, Void >*>(static_cast<_setupActor*>(this)));
															#line 504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(metacluster::util::SimulatedMetacluster && simMetacluster,int loopDepth) 
	{
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->managementDb = simMetacluster.managementDb;
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = loadExistingMetacluster(self);
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 517 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 4;
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 3, Void >*>(static_cast<_setupActor*>(this)));
															#line 522 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when2(metacluster::util::SimulatedMetacluster const& simMetacluster,int loopDepth) 
	{
		loopDepth = a_body1cont8(simMetacluster, loopDepth);

		return loopDepth;
	}
	int a_body1when2(metacluster::util::SimulatedMetacluster && simMetacluster,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(simMetacluster), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 2, metacluster::util::SimulatedMetacluster >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, metacluster::util::SimulatedMetacluster >*,metacluster::util::SimulatedMetacluster const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, metacluster::util::SimulatedMetacluster >*,metacluster::util::SimulatedMetacluster && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _setupActor, 2, metacluster::util::SimulatedMetacluster >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _setupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _setupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Database cx;
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >, public ActorCallback< _setupActor, 1, Optional<MetaclusterRegistrationEntry> >, public ActorCallback< _setupActor, 2, metacluster::util::SimulatedMetacluster >, public ActorCallback< _setupActor, 3, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6310236851126984448UL, 10598344626782271488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >;
friend struct ActorCallback< _setupActor, 1, Optional<MetaclusterRegistrationEntry> >;
friend struct ActorCallback< _setupActor, 2, metacluster::util::SimulatedMetacluster >;
friend struct ActorCallback< _setupActor, 3, Void >;
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	_setupActor(Database const& cx,MetaclusterManagementWorkload* const& self) 
															#line 718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, metacluster::util::SimulatedMetacluster >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _setupActor, 2, metacluster::util::SimulatedMetacluster >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _setupActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _setup( Database const& cx, MetaclusterManagementWorkload* const& self ) {
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 753 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via loadExistingMetacluster()
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class LoadExistingMetaclusterActor>
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class LoadExistingMetaclusterActorState {
															#line 764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	LoadExistingMetaclusterActorState(MetaclusterManagementWorkload* const& self) 
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   metaclusterData(self->managementDb)
															#line 773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("loadExistingMetacluster", reinterpret_cast<unsigned long>(this));

	}
	~LoadExistingMetaclusterActorState() 
	{
		fdb_probe_actor_destroy("loadExistingMetacluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = metaclusterData.load();
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<LoadExistingMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadExistingMetaclusterActor*>(this)->actor_wait_state = 1;
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadExistingMetaclusterActor, 0, Void >*>(static_cast<LoadExistingMetaclusterActor*>(this)));
															#line 795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadExistingMetaclusterActorState();
		static_cast<LoadExistingMetaclusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->metaclusterCreated = true;
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->managementVersion = metaclusterData.managementMetadata.metaclusterRegistration.get().version;
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->tenantIdPrefix = metaclusterData.managementMetadata.tenantIdPrefix.get();
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->usedPrefixes.insert(self->tenantIdPrefix);
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for( auto const& [name, metadata] : metaclusterData.managementMetadata.dataClusters ) {
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			metacluster::util::MetaclusterData<IDatabase>::DataClusterData dataClusterMetadata = metaclusterData.dataClusterMetadata[name];
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->dataDbIndex.push_back(name);
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			Reference<DataClusterData> dataDb = makeReference<DataClusterData>( Database::createSimulatedExtraDatabase(metadata.connectionString.toString()));
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->dataDbs[name] = dataDb;
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->registered = true;
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->detached = false;
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->tenantGroupCapacity = metadata.entry.capacity.numTenantGroups;
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->version = dataClusterMetadata.metaclusterRegistration.get().version;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->autoTenantAssignment = metadata.entry.autoTenantAssignment;
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->totalTenantGroupCapacity += std::max(metadata.entry.capacity.numTenantGroups, metadata.entry.allocated.numTenantGroups);
															#line 846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for( auto const& [id, entry] : metaclusterData.managementMetadata.tenantData.tenantMap ) {
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			Reference<TenantTestData> tenantData = makeReference<TenantTestData>(entry.assignedCluster, entry.tenantGroup);
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->createdTenants[entry.tenantName] = tenantData;
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			Reference<DataClusterData> dataDb = self->dataDbs[entry.assignedCluster];
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->tenants[entry.tenantName] = tenantData;
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantData->lockId = entry.tenantLockId;
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantData->lockState = entry.tenantLockState;
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (!entry.tenantGroup.present())
															#line 864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				self->ungroupedTenants.insert(entry.tenantName);
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				dataDb->ungroupedTenants.insert(entry.tenantName);
															#line 870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
			else
			{
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				auto itr = self->tenantGroups.find(entry.tenantGroup.get());
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (itr == self->tenantGroups.end())
															#line 878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					itr = self->tenantGroups .try_emplace(entry.tenantGroup.get(), makeReference<TenantGroupData>(entry.assignedCluster)) .first;
															#line 882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				auto tenantGroup = itr->second;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				tenantGroup->tenants.insert(entry.tenantName);
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				dataDb->tenantGroups[entry.tenantGroup.get()] = tenantGroup;
															#line 890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
		}
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<LoadExistingMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadExistingMetaclusterActorState(); static_cast<LoadExistingMetaclusterActor*>(this)->destroy(); return 0; }
															#line 895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<LoadExistingMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadExistingMetaclusterActorState();
		static_cast<LoadExistingMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->metaclusterCreated = true;
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->managementVersion = metaclusterData.managementMetadata.metaclusterRegistration.get().version;
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->tenantIdPrefix = metaclusterData.managementMetadata.tenantIdPrefix.get();
															#line 186 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->usedPrefixes.insert(self->tenantIdPrefix);
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for( auto const& [name, metadata] : metaclusterData.managementMetadata.dataClusters ) {
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			metacluster::util::MetaclusterData<IDatabase>::DataClusterData dataClusterMetadata = metaclusterData.dataClusterMetadata[name];
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->dataDbIndex.push_back(name);
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			Reference<DataClusterData> dataDb = makeReference<DataClusterData>( Database::createSimulatedExtraDatabase(metadata.connectionString.toString()));
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->dataDbs[name] = dataDb;
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->registered = true;
															#line 198 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->detached = false;
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->tenantGroupCapacity = metadata.entry.capacity.numTenantGroups;
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->version = dataClusterMetadata.metaclusterRegistration.get().version;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->autoTenantAssignment = metadata.entry.autoTenantAssignment;
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->totalTenantGroupCapacity += std::max(metadata.entry.capacity.numTenantGroups, metadata.entry.allocated.numTenantGroups);
															#line 935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for( auto const& [id, entry] : metaclusterData.managementMetadata.tenantData.tenantMap ) {
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			Reference<TenantTestData> tenantData = makeReference<TenantTestData>(entry.assignedCluster, entry.tenantGroup);
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->createdTenants[entry.tenantName] = tenantData;
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			Reference<DataClusterData> dataDb = self->dataDbs[entry.assignedCluster];
															#line 213 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->tenants[entry.tenantName] = tenantData;
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantData->lockId = entry.tenantLockId;
															#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantData->lockState = entry.tenantLockState;
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (!entry.tenantGroup.present())
															#line 953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				self->ungroupedTenants.insert(entry.tenantName);
															#line 220 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				dataDb->ungroupedTenants.insert(entry.tenantName);
															#line 959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
			else
			{
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				auto itr = self->tenantGroups.find(entry.tenantGroup.get());
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (itr == self->tenantGroups.end())
															#line 967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					itr = self->tenantGroups .try_emplace(entry.tenantGroup.get(), makeReference<TenantGroupData>(entry.assignedCluster)) .first;
															#line 971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
															#line 229 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				auto tenantGroup = itr->second;
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				tenantGroup->tenants.insert(entry.tenantName);
															#line 231 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				dataDb->tenantGroups[entry.tenantGroup.get()] = tenantGroup;
															#line 979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
		}
															#line 235 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<LoadExistingMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadExistingMetaclusterActorState(); static_cast<LoadExistingMetaclusterActor*>(this)->destroy(); return 0; }
															#line 984 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<LoadExistingMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadExistingMetaclusterActorState();
		static_cast<LoadExistingMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadExistingMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<LoadExistingMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<LoadExistingMetaclusterActor*>(this)->ActorCallback< LoadExistingMetaclusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadExistingMetaclusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadExistingMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadExistingMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadExistingMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadExistingMetaclusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadExistingMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadExistingMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadExistingMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadExistingMetaclusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadExistingMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadExistingMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadExistingMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	metacluster::util::MetaclusterData<IDatabase> metaclusterData;
															#line 1071 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via loadExistingMetacluster()
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class LoadExistingMetaclusterActor final : public Actor<Void>, public ActorCallback< LoadExistingMetaclusterActor, 0, Void >, public FastAllocated<LoadExistingMetaclusterActor>, public LoadExistingMetaclusterActorState<LoadExistingMetaclusterActor> {
															#line 1076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<LoadExistingMetaclusterActor>::operator new;
	using FastAllocated<LoadExistingMetaclusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8251583429002014720UL, 10577137085990354944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadExistingMetaclusterActor, 0, Void >;
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	LoadExistingMetaclusterActor(MetaclusterManagementWorkload* const& self) 
															#line 1093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   LoadExistingMetaclusterActorState<LoadExistingMetaclusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadExistingMetacluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8286402591196547840UL, 13696499507679884032UL);
		ActorExecutionContextHelper __helper(static_cast<LoadExistingMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadExistingMetacluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadExistingMetacluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadExistingMetaclusterActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> loadExistingMetacluster( MetaclusterManagementWorkload* const& self ) {
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new LoadExistingMetaclusterActor(self));
															#line 1125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

	ClusterName chooseClusterName() { return dataDbIndex[deterministicRandom()->randomInt(0, dataDbIndex.size())]; }

	TenantName chooseTenantName() {
		TenantName tenant(format("tenant%08d", deterministicRandom()->randomInt(0, maxTenants)));
		return tenant;
	}

	Optional<TenantGroupName> chooseTenantGroup() {
		Optional<TenantGroupName> tenantGroup;
		if (deterministicRandom()->coinflip()) {
			tenantGroup =
			    TenantGroupNameRef(format("tenantgroup%08d", deterministicRandom()->randomInt(0, maxTenantGroups)));
		}

		return tenantGroup;
	}

	bool isValidVersion(Optional<Reference<DataClusterData>> dataDb = {}) {
		bool managementValid = managementVersion >= MetaclusterVersion::MIN_SUPPORTED &&
		                       managementVersion <= MetaclusterVersion::MAX_SUPPORTED;

		bool dataValid = !dataDb.present() || (dataDb.get()->version >= MetaclusterVersion::MIN_SUPPORTED &&
		                                       dataDb.get()->version <= MetaclusterVersion::MAX_SUPPORTED);

		CODE_PROBE(!managementValid, "Management cluster invalid version");
		CODE_PROBE(!dataValid, "Data cluster invalid version");
		return managementValid && dataValid;
	}

																#line 1159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via waitForFullyRecovered()
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class WaitForFullyRecoveredActor>
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class WaitForFullyRecoveredActorState {
															#line 1165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	WaitForFullyRecoveredActorState(MetaclusterManagementWorkload* const& self) 
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self)
															#line 1172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForFullyRecovered", reinterpret_cast<unsigned long>(this));

	}
	~WaitForFullyRecoveredActorState() 
	{
		fdb_probe_actor_destroy("waitForFullyRecovered", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			;
															#line 1187 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForFullyRecoveredActorState();
		static_cast<WaitForFullyRecoveredActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<WaitForFullyRecoveredActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForFullyRecoveredActorState(); static_cast<WaitForFullyRecoveredActor*>(this)->destroy(); return 0; }
															#line 1210 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<WaitForFullyRecoveredActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForFullyRecoveredActorState();
		static_cast<WaitForFullyRecoveredActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!(self->dbInfo->get().recoveryState != RecoveryState::FULLY_RECOVERED))
															#line 1229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->dbInfo->onChange();
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<WaitForFullyRecoveredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitForFullyRecoveredActor*>(this)->actor_wait_state = 1;
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForFullyRecoveredActor, 0, Void >*>(static_cast<WaitForFullyRecoveredActor*>(this)));
															#line 1242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForFullyRecoveredActor*>(this)->actor_wait_state > 0) static_cast<WaitForFullyRecoveredActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForFullyRecoveredActor*>(this)->ActorCallback< WaitForFullyRecoveredActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForFullyRecoveredActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForFullyRecovered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForFullyRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForFullyRecovered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForFullyRecoveredActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForFullyRecovered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForFullyRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForFullyRecovered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForFullyRecoveredActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForFullyRecovered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForFullyRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForFullyRecovered", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 1349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via waitForFullyRecovered()
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class WaitForFullyRecoveredActor final : public Actor<Void>, public ActorCallback< WaitForFullyRecoveredActor, 0, Void >, public FastAllocated<WaitForFullyRecoveredActor>, public WaitForFullyRecoveredActorState<WaitForFullyRecoveredActor> {
															#line 1354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<WaitForFullyRecoveredActor>::operator new;
	using FastAllocated<WaitForFullyRecoveredActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5507758177674105856UL, 12989663822687284224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForFullyRecoveredActor, 0, Void >;
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	WaitForFullyRecoveredActor(MetaclusterManagementWorkload* const& self) 
															#line 1371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   WaitForFullyRecoveredActorState<WaitForFullyRecoveredActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForFullyRecovered", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13776937165092367104UL, 521992309075683328UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForFullyRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForFullyRecovered");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForFullyRecovered", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForFullyRecoveredActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> waitForFullyRecovered( MetaclusterManagementWorkload* const& self ) {
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new WaitForFullyRecoveredActor(self));
															#line 1403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 1408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via setMetaclusterVersion()
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class DB, class SetMetaclusterVersionActor>
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class SetMetaclusterVersionActorState {
															#line 1414 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	SetMetaclusterVersionActorState(Reference<DB> const& db,MetaclusterVersion const& version) 
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : db(db),
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   version(version),
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   tr(db->createTransaction())
															#line 1425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("setMetaclusterVersion", reinterpret_cast<unsigned long>(this));

	}
	~SetMetaclusterVersionActorState() 
	{
		fdb_probe_actor_destroy("setMetaclusterVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			;
															#line 1440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetMetaclusterVersionActorState();
		static_cast<SetMetaclusterVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 281 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Optional<UnversionedMetaclusterRegistrationEntry>> __when_expr_0 = metacluster::metadata::unversionedMetaclusterRegistration().get(tr);
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<SetMetaclusterVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetMetaclusterVersionActor*>(this)->actor_wait_state = 1;
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetMetaclusterVersionActor, 0, Optional<UnversionedMetaclusterRegistrationEntry> >*>(static_cast<SetMetaclusterVersionActor*>(this)));
															#line 1480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<SetMetaclusterVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SetMetaclusterVersionActor*>(this)->actor_wait_state = 3;
															#line 298 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SetMetaclusterVersionActor, 2, Void >*>(static_cast<SetMetaclusterVersionActor*>(this)));
															#line 1509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(registration.present());
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (registration.get().version == version)
															#line 1526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 287 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (!static_cast<SetMetaclusterVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetMetaclusterVersionActorState(); static_cast<SetMetaclusterVersionActor*>(this)->destroy(); return 0; }
															#line 1530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			new (&static_cast<SetMetaclusterVersionActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~SetMetaclusterVersionActorState();
			static_cast<SetMetaclusterVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		MetaclusterRegistrationEntry newRegistration(registration.get());
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		newRegistration.version = version;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		metacluster::metadata::metaclusterRegistration().set(tr, newRegistration);
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<SetMetaclusterVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetMetaclusterVersionActor*>(this)->actor_wait_state = 2;
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetMetaclusterVersionActor, 1, Void >*>(static_cast<SetMetaclusterVersionActor*>(this)));
															#line 1551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<UnversionedMetaclusterRegistrationEntry> const& __registration,int loopDepth) 
	{
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		registration = __registration;
															#line 1560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<UnversionedMetaclusterRegistrationEntry> && __registration,int loopDepth) 
	{
		registration = std::move(__registration);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetMetaclusterVersionActor*>(this)->actor_wait_state > 0) static_cast<SetMetaclusterVersionActor*>(this)->actor_wait_state = 0;
		static_cast<SetMetaclusterVersionActor*>(this)->ActorCallback< SetMetaclusterVersionActor, 0, Optional<UnversionedMetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< SetMetaclusterVersionActor, 0, Optional<UnversionedMetaclusterRegistrationEntry> >*,Optional<UnversionedMetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetMetaclusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetMetaclusterVersionActor, 0, Optional<UnversionedMetaclusterRegistrationEntry> >*,Optional<UnversionedMetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetMetaclusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetMetaclusterVersionActor, 0, Optional<UnversionedMetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetMetaclusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(false);
															#line 1639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(false);
															#line 1648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetMetaclusterVersionActor*>(this)->actor_wait_state > 0) static_cast<SetMetaclusterVersionActor*>(this)->actor_wait_state = 0;
		static_cast<SetMetaclusterVersionActor*>(this)->ActorCallback< SetMetaclusterVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetMetaclusterVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetMetaclusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetMetaclusterVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetMetaclusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetMetaclusterVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetMetaclusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SetMetaclusterVersionActor*>(this)->actor_wait_state > 0) static_cast<SetMetaclusterVersionActor*>(this)->actor_wait_state = 0;
		static_cast<SetMetaclusterVersionActor*>(this)->ActorCallback< SetMetaclusterVersionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetMetaclusterVersionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetMetaclusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SetMetaclusterVersionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetMetaclusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SetMetaclusterVersionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetMetaclusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Reference<DB> db;
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterVersion version;
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Reference<typename DB::TransactionT> tr;
															#line 282 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Optional<UnversionedMetaclusterRegistrationEntry> registration;
															#line 1836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via setMetaclusterVersion()
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class DB>
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class SetMetaclusterVersionActor final : public Actor<Void>, public ActorCallback< SetMetaclusterVersionActor<DB>, 0, Optional<UnversionedMetaclusterRegistrationEntry> >, public ActorCallback< SetMetaclusterVersionActor<DB>, 1, Void >, public ActorCallback< SetMetaclusterVersionActor<DB>, 2, Void >, public FastAllocated<SetMetaclusterVersionActor<DB>>, public SetMetaclusterVersionActorState<DB, SetMetaclusterVersionActor<DB>> {
															#line 1843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<SetMetaclusterVersionActor<DB>>::operator new;
	using FastAllocated<SetMetaclusterVersionActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3477443667797973760UL, 1444927052259888896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetMetaclusterVersionActor<DB>, 0, Optional<UnversionedMetaclusterRegistrationEntry> >;
friend struct ActorCallback< SetMetaclusterVersionActor<DB>, 1, Void >;
friend struct ActorCallback< SetMetaclusterVersionActor<DB>, 2, Void >;
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	SetMetaclusterVersionActor(Reference<DB> const& db,MetaclusterVersion const& version) 
															#line 1862 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   SetMetaclusterVersionActorState<DB, SetMetaclusterVersionActor<DB>>(db, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17384116750352374016UL, 8561882404155196416UL);
		ActorExecutionContextHelper __helper(static_cast<SetMetaclusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setMetaclusterVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setMetaclusterVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetMetaclusterVersionActor<DB>, 0, Optional<UnversionedMetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetMetaclusterVersionActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SetMetaclusterVersionActor<DB>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class DB>
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> setMetaclusterVersion( Reference<DB> const& db, MetaclusterVersion const& version ) {
															#line 275 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new SetMetaclusterVersionActor<DB>(db, version));
															#line 1898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 302 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

	Future<Void> checkAndResetMetaclusterVersion(ClusterName clusterName) {
		auto dataDbItr = dataDbs.find(clusterName);
		ASSERT(dataDbItr != dataDbs.end());
		ASSERT(!isValidVersion(dataDbItr->second));

		dataDbItr->second->version = (MetaclusterVersion)deterministicRandom()->randomInt(
		    (int)MetaclusterVersion::MIN_SUPPORTED, (int)MetaclusterVersion::MAX_SUPPORTED + 1);

		return setMetaclusterVersion(dataDbItr->second->db.getReference(), dataDbItr->second->version);
	}

																#line 1914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via createMetacluster()
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class CreateMetaclusterActor>
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class CreateMetaclusterActorState {
															#line 1920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	CreateMetaclusterActorState(MetaclusterManagementWorkload* const& self) 
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   clusterName("metacluster"_sr)
															#line 1929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("createMetacluster", reinterpret_cast<unsigned long>(this));

	}
	~CreateMetaclusterActorState() 
	{
		fdb_probe_actor_destroy("createMetacluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (deterministicRandom()->random01() < 0.01)
															#line 1944 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				clusterName = clusterName.withPrefix("\xff"_sr);
															#line 1948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
			try {
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				newTenantIdPrefix = self->generateTenantIdPrefix();
															#line 322 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!newTenantIdPrefix.present())
															#line 1955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 323 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<CreateMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateMetaclusterActorState(); static_cast<CreateMetaclusterActor*>(this)->destroy(); return 0; }
															#line 1959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<CreateMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CreateMetaclusterActorState();
					static_cast<CreateMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				StrictFuture<Optional<std::string>> __when_expr_0 = metacluster::createMetacluster(self->managementDb, clusterName, newTenantIdPrefix.get(), false);
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1969 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 1;
															#line 326 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateMetaclusterActor, 0, Optional<std::string> >*>(static_cast<CreateMetaclusterActor*>(this)));
															#line 1974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateMetaclusterActorState();
		static_cast<CreateMetaclusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<CreateMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateMetaclusterActorState(); static_cast<CreateMetaclusterActor*>(this)->destroy(); return 0; }
															#line 2003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<CreateMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateMetaclusterActorState();
		static_cast<CreateMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_invalid_cluster_name)
															#line 2016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(clusterName.startsWith("\xff"_sr));
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!static_cast<CreateMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateMetaclusterActorState(); static_cast<CreateMetaclusterActor*>(this)->destroy(); return 0; }
															#line 2022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				new (&static_cast<CreateMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CreateMetaclusterActorState();
				static_cast<CreateMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (e.code() == error_code_unsupported_metacluster_version)
															#line 2032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(!self->isValidVersion());
															#line 352 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<CreateMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateMetaclusterActorState(); static_cast<CreateMetaclusterActor*>(this)->destroy(); return 0; }
															#line 2038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<CreateMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CreateMetaclusterActorState();
					static_cast<CreateMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			TraceEvent(SevError, "CreateMetaclusterFailure").error(e).detail("ClusterName", clusterName);
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 2049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Optional<std::string> const& result,int loopDepth) 
	{
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!clusterName.startsWith("\xff"_sr));
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!result.present())
															#line 2066 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(!self->metaclusterCreated);
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->metaclusterCreated = true;
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->tenantIdPrefix = newTenantIdPrefix.get();
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->usedPrefixes.insert(self->tenantIdPrefix);
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_1 = metacluster::metadata::metaclusterRegistration().get(self->managementDb);
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
			static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 2;
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateMetaclusterActor, 1, Optional<MetaclusterRegistrationEntry> >*>(static_cast<CreateMetaclusterActor*>(this)));
															#line 2085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(self->metaclusterCreated);
															#line 2092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Optional<std::string> && result,int loopDepth) 
	{
															#line 329 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!clusterName.startsWith("\xff"_sr));
															#line 330 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!result.present())
															#line 2104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 331 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(!self->metaclusterCreated);
															#line 332 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->metaclusterCreated = true;
															#line 334 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->tenantIdPrefix = newTenantIdPrefix.get();
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->usedPrefixes.insert(self->tenantIdPrefix);
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_1 = metacluster::metadata::metaclusterRegistration().get(self->managementDb);
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
			static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 2;
															#line 337 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateMetaclusterActor, 1, Optional<MetaclusterRegistrationEntry> >*>(static_cast<CreateMetaclusterActor*>(this)));
															#line 2123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(self->metaclusterCreated);
															#line 2130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Optional<std::string> const& result,int loopDepth) 
	{
		loopDepth = a_body1cont3(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<std::string> && result,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<CreateMetaclusterActor*>(this)->ActorCallback< CreateMetaclusterActor, 0, Optional<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 0, Optional<std::string> >*,Optional<std::string> const& value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 0, Optional<std::string> >*,Optional<std::string> && value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateMetaclusterActor, 0, Optional<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Optional<MetaclusterRegistrationEntry> const& registrationEntry,int loopDepth) 
	{
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(registrationEntry.present());
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->managementVersion = registrationEntry.get().version;
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForFullyRecovered(self);
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont6when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 3;
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateMetaclusterActor, 2, Void >*>(static_cast<CreateMetaclusterActor*>(this)));
															#line 2232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Optional<MetaclusterRegistrationEntry> && registrationEntry,int loopDepth) 
	{
															#line 339 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(registrationEntry.present());
															#line 341 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->managementVersion = registrationEntry.get().version;
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForFullyRecovered(self);
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont6when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 3;
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateMetaclusterActor, 2, Void >*>(static_cast<CreateMetaclusterActor*>(this)));
															#line 2252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Optional<MetaclusterRegistrationEntry> const& registrationEntry,int loopDepth) 
	{
		loopDepth = a_body1cont6(registrationEntry, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<MetaclusterRegistrationEntry> && registrationEntry,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(registrationEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<CreateMetaclusterActor*>(this)->ActorCallback< CreateMetaclusterActor, 1, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 1, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 1, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateMetaclusterActor, 1, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<CreateMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<CreateMetaclusterActor*>(this)->ActorCallback< CreateMetaclusterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateMetaclusterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateMetaclusterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 315 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ClusterName clusterName;
															#line 321 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Optional<int64_t> newTenantIdPrefix;
															#line 2438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via createMetacluster()
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class CreateMetaclusterActor final : public Actor<Void>, public ActorCallback< CreateMetaclusterActor, 0, Optional<std::string> >, public ActorCallback< CreateMetaclusterActor, 1, Optional<MetaclusterRegistrationEntry> >, public ActorCallback< CreateMetaclusterActor, 2, Void >, public FastAllocated<CreateMetaclusterActor>, public CreateMetaclusterActorState<CreateMetaclusterActor> {
															#line 2443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<CreateMetaclusterActor>::operator new;
	using FastAllocated<CreateMetaclusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11234878341521853952UL, 816110729092613888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateMetaclusterActor, 0, Optional<std::string> >;
friend struct ActorCallback< CreateMetaclusterActor, 1, Optional<MetaclusterRegistrationEntry> >;
friend struct ActorCallback< CreateMetaclusterActor, 2, Void >;
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	CreateMetaclusterActor(MetaclusterManagementWorkload* const& self) 
															#line 2462 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   CreateMetaclusterActorState<CreateMetaclusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createMetacluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9165621760296402688UL, 14508341675007748352UL);
		ActorExecutionContextHelper __helper(static_cast<CreateMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createMetacluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createMetacluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateMetaclusterActor, 0, Optional<std::string> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateMetaclusterActor, 1, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateMetaclusterActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> createMetacluster( MetaclusterManagementWorkload* const& self ) {
															#line 314 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new CreateMetaclusterActor(self));
															#line 2496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 361 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 2501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via decommissionMetacluster()
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class DecommissionMetaclusterActor>
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class DecommissionMetaclusterActorState {
															#line 2507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	DecommissionMetaclusterActorState(MetaclusterManagementWorkload* const& self) 
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   empty(self->createdTenants.empty())
															#line 2516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("decommissionMetacluster", reinterpret_cast<unsigned long>(this));

	}
	~DecommissionMetaclusterActorState() 
	{
		fdb_probe_actor_destroy("decommissionMetacluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 364 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			for( auto db : self->dataDbs ) {
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				empty = empty && !db.second->registered;
															#line 2533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
			try {
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = metacluster::decommissionMetacluster(self->managementDb);
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state = 1;
															#line 369 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DecommissionMetaclusterActor, 0, Void >*>(static_cast<DecommissionMetaclusterActor*>(this)));
															#line 2545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DecommissionMetaclusterActorState();
		static_cast<DecommissionMetaclusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<DecommissionMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DecommissionMetaclusterActorState(); static_cast<DecommissionMetaclusterActor*>(this)->destroy(); return 0; }
															#line 2574 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<DecommissionMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DecommissionMetaclusterActorState();
		static_cast<DecommissionMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_cluster_not_empty)
															#line 2587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(!empty);
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!static_cast<DecommissionMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DecommissionMetaclusterActorState(); static_cast<DecommissionMetaclusterActor*>(this)->destroy(); return 0; }
															#line 2593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				new (&static_cast<DecommissionMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DecommissionMetaclusterActorState();
				static_cast<DecommissionMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (e.code() == error_code_invalid_metacluster_operation)
															#line 2603 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(!self->metaclusterCreated);
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<DecommissionMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DecommissionMetaclusterActorState(); static_cast<DecommissionMetaclusterActor*>(this)->destroy(); return 0; }
															#line 2609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<DecommissionMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~DecommissionMetaclusterActorState();
					static_cast<DecommissionMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (e.code() == error_code_unsupported_metacluster_version)
															#line 2619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 383 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(!self->isValidVersion());
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (!static_cast<DecommissionMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DecommissionMetaclusterActorState(); static_cast<DecommissionMetaclusterActor*>(this)->destroy(); return 0; }
															#line 2625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						new (&static_cast<DecommissionMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~DecommissionMetaclusterActorState();
						static_cast<DecommissionMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			TraceEvent(SevError, "DecommissionMetaclusterFailure").error(e);
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 2637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion());
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(empty);
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->metaclusterCreated = false;
															#line 2658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion());
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(empty);
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->metaclusterCreated = false;
															#line 2673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<DecommissionMetaclusterActor*>(this)->ActorCallback< DecommissionMetaclusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DecommissionMetaclusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DecommissionMetaclusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DecommissionMetaclusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool empty;
															#line 2770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via decommissionMetacluster()
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class DecommissionMetaclusterActor final : public Actor<Void>, public ActorCallback< DecommissionMetaclusterActor, 0, Void >, public FastAllocated<DecommissionMetaclusterActor>, public DecommissionMetaclusterActorState<DecommissionMetaclusterActor> {
															#line 2775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<DecommissionMetaclusterActor>::operator new;
	using FastAllocated<DecommissionMetaclusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18033577622738012928UL, 16471022420943570944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DecommissionMetaclusterActor, 0, Void >;
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	DecommissionMetaclusterActor(MetaclusterManagementWorkload* const& self) 
															#line 2792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   DecommissionMetaclusterActorState<DecommissionMetaclusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13487502973662777088UL, 11711500406943873536UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("decommissionMetacluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DecommissionMetaclusterActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> decommissionMetacluster( MetaclusterManagementWorkload* const& self ) {
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new DecommissionMetaclusterActor(self));
															#line 2824 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 393 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 2829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via registerCluster()
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class RegisterClusterActor>
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class RegisterClusterActorState {
															#line 2835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	RegisterClusterActorState(MetaclusterManagementWorkload* const& self) 
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   clusterName(self->chooseClusterName()),
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   dataDb(self->dataDbs[clusterName]),
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   retried(false)
															#line 2848 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("registerCluster", reinterpret_cast<unsigned long>(this));

	}
	~RegisterClusterActorState() 
	{
		fdb_probe_actor_destroy("registerCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 399 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (deterministicRandom()->random01() < 0.1)
															#line 2863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 400 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				clusterName = "\xff"_sr.withSuffix(clusterName);
															#line 2867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
			try {
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				entry = metacluster::DataClusterEntry();
															#line 405 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				entry.capacity.numTenantGroups = deterministicRandom()->randomInt(0, 4);
															#line 406 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (deterministicRandom()->random01() < 0.25)
															#line 2876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 407 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					entry.autoTenantAssignment = metacluster::AutoTenantAssignment::DISABLED;
															#line 2880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				;
															#line 2884 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterClusterActorState();
		static_cast<RegisterClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 499 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 2913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterClusterActorState();
		static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_cluster_already_exists)
															#line 2926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 474 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(dataDb->registered);
															#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 2932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RegisterClusterActorState();
				static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 476 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (e.code() == error_code_cluster_not_empty)
															#line 2942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 477 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(dataDb->detached && !dataDb->tenants.empty());
															#line 478 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 2948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~RegisterClusterActorState();
					static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 479 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (e.code() == error_code_invalid_cluster_name)
															#line 2958 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 480 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(clusterName.startsWith("\xff"_sr));
															#line 481 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 2964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~RegisterClusterActorState();
						static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
					else
					{
															#line 482 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (e.code() == error_code_unsupported_metacluster_version)
															#line 2974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						{
															#line 488 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							ASSERT(!self->isValidVersion(dataDb->registered ? dataDb : Optional<Reference<DataClusterData>>()));
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 2980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
							new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
							this->~RegisterClusterActorState();
							static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
						else
						{
															#line 490 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							if (e.code() == error_code_invalid_metacluster_operation)
															#line 2990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
							{
															#line 491 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
								ASSERT(!self->metaclusterCreated);
															#line 492 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
								if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 2996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
								new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
								this->~RegisterClusterActorState();
								static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
						}
					}
				}
			}
															#line 495 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			TraceEvent(SevError, "RegisterClusterFailure").error(e).detail("ClusterName", clusterName);
															#line 496 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 3010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!clusterName.startsWith("\xff"_sr));
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!dataDb->registered);
															#line 454 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!dataDb->detached || dataDb->tenants.empty());
															#line 455 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion());
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_3 = metacluster::metadata::metaclusterRegistration().get(dataDb->db.getReference());
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<RegisterClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<RegisterClusterActor*>(this)->actor_wait_state = 4;
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RegisterClusterActor, 3, Optional<MetaclusterRegistrationEntry> >*>(static_cast<RegisterClusterActor*>(this)));
															#line 3042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 412 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			Future<Void> registerFuture = metacluster::registerCluster(self->managementDb, clusterName, dataDb->db->getConnectionRecord()->getConnectionString(), entry);
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Optional<Void>> __when_expr_0 = timeout(registerFuture, deterministicRandom()->randomInt(1, 30));
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<RegisterClusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegisterClusterActor*>(this)->actor_wait_state = 1;
															#line 418 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterClusterActor, 0, Optional<Void> >*>(static_cast<RegisterClusterActor*>(this)));
															#line 3068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			registerError = e;
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (registerError.code() == error_code_cluster_removed || registerError.code() == error_code_cluster_not_empty)
															#line 3105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 428 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (registerError.code() == error_code_cluster_removed)
															#line 3109 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(retried);
															#line 3113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
				else
				{
															#line 430 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (registerError.code() == error_code_cluster_not_empty)
															#line 3119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 431 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(dataDb->detached);
															#line 3123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					}
				}
															#line 434 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_1 = success(errorOr(metacluster::removeCluster(self->managementDb, clusterName, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove::True)));
															#line 434 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (static_cast<RegisterClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
				static_cast<RegisterClusterActor*>(this)->actor_wait_state = 2;
															#line 434 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RegisterClusterActor, 1, Void >*>(static_cast<RegisterClusterActor*>(this)));
															#line 3135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (registerError.code() == error_code_cluster_already_exists && retried && !dataDb->registered)
															#line 3142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					StrictFuture<Optional<metacluster::DataClusterMetadata>> __when_expr_2 = metacluster::tryGetCluster(self->managementDb, clusterName);
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (static_cast<RegisterClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when2(__when_expr_2.get(), loopDepth); };
					static_cast<RegisterClusterActor*>(this)->actor_wait_state = 3;
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RegisterClusterActor, 2, Optional<metacluster::DataClusterMetadata> >*>(static_cast<RegisterClusterActor*>(this)));
															#line 3153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 447 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					return a_body1Catch2(registerError, std::max(0, loopDepth - 1));
															#line 3160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Void> const& result,int loopDepth) 
	{
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 3176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			retried = true;
															#line 3184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Void> && result,int loopDepth) 
	{
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 3194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 422 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			retried = true;
															#line 3202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterClusterActor*>(this)->actor_wait_state > 0) static_cast<RegisterClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterClusterActor*>(this)->ActorCallback< RegisterClusterActor, 0, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 0, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 0, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterClusterActor, 0, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 3300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterClusterActorState();
		static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 3312 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterClusterActorState();
		static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RegisterClusterActor*>(this)->actor_wait_state > 0) static_cast<RegisterClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterClusterActor*>(this)->ActorCallback< RegisterClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RegisterClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont8(Optional<metacluster::DataClusterMetadata> const& clusterMetadata,int loopDepth) 
	{
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(clusterMetadata.present());
															#line 3399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont8(Optional<metacluster::DataClusterMetadata> && clusterMetadata,int loopDepth) 
	{
															#line 444 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(clusterMetadata.present());
															#line 3408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Optional<metacluster::DataClusterMetadata> const& clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont8(clusterMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Optional<metacluster::DataClusterMetadata> && clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont8(std::move(clusterMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RegisterClusterActor*>(this)->actor_wait_state > 0) static_cast<RegisterClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterClusterActor*>(this)->ActorCallback< RegisterClusterActor, 2, Optional<metacluster::DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 2, Optional<metacluster::DataClusterMetadata> >*,Optional<metacluster::DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 2, Optional<metacluster::DataClusterMetadata> >*,Optional<metacluster::DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RegisterClusterActor, 2, Optional<metacluster::DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Optional<MetaclusterRegistrationEntry> const& registration,int loopDepth) 
	{
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(registration.present());
															#line 461 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->version = registration.get().version;
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->tenantGroupCapacity = entry.capacity.numTenantGroups;
															#line 464 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->totalTenantGroupCapacity += entry.capacity.numTenantGroups;
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->registered = true;
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->detached = false;
															#line 467 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->autoTenantAssignment = entry.autoTenantAssignment;
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(runTransaction(dataDb->db.getReference(), [](Reference<ReadYourWritesTransaction> tr) { return tr->getReadVersion(); }));
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<RegisterClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<RegisterClusterActor*>(this)->actor_wait_state = 5;
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RegisterClusterActor, 4, Void >*>(static_cast<RegisterClusterActor*>(this)));
															#line 3513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Optional<MetaclusterRegistrationEntry> && registration,int loopDepth) 
	{
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(registration.present());
															#line 461 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->version = registration.get().version;
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->tenantGroupCapacity = entry.capacity.numTenantGroups;
															#line 464 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->totalTenantGroupCapacity += entry.capacity.numTenantGroups;
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->registered = true;
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->detached = false;
															#line 467 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->autoTenantAssignment = entry.autoTenantAssignment;
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(runTransaction(dataDb->db.getReference(), [](Reference<ReadYourWritesTransaction> tr) { return tr->getReadVersion(); }));
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<RegisterClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<RegisterClusterActor*>(this)->actor_wait_state = 5;
															#line 470 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RegisterClusterActor, 4, Void >*>(static_cast<RegisterClusterActor*>(this)));
															#line 3543 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Optional<MetaclusterRegistrationEntry> const& registration,int loopDepth) 
	{
		loopDepth = a_body1cont5(registration, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<MetaclusterRegistrationEntry> && registration,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(registration), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RegisterClusterActor*>(this)->actor_wait_state > 0) static_cast<RegisterClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterClusterActor*>(this)->ActorCallback< RegisterClusterActor, 3, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 3, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 3, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RegisterClusterActor, 3, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RegisterClusterActor*>(this)->actor_wait_state > 0) static_cast<RegisterClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterClusterActor*>(this)->ActorCallback< RegisterClusterActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RegisterClusterActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ClusterName clusterName;
															#line 396 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Reference<DataClusterData> dataDb;
															#line 397 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool retried;
															#line 404 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	metacluster::DataClusterEntry entry;
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Error registerError;
															#line 3735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via registerCluster()
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class RegisterClusterActor final : public Actor<Void>, public ActorCallback< RegisterClusterActor, 0, Optional<Void> >, public ActorCallback< RegisterClusterActor, 1, Void >, public ActorCallback< RegisterClusterActor, 2, Optional<metacluster::DataClusterMetadata> >, public ActorCallback< RegisterClusterActor, 3, Optional<MetaclusterRegistrationEntry> >, public ActorCallback< RegisterClusterActor, 4, Void >, public FastAllocated<RegisterClusterActor>, public RegisterClusterActorState<RegisterClusterActor> {
															#line 3740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<RegisterClusterActor>::operator new;
	using FastAllocated<RegisterClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9762528504714578688UL, 14964588448042498816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterClusterActor, 0, Optional<Void> >;
friend struct ActorCallback< RegisterClusterActor, 1, Void >;
friend struct ActorCallback< RegisterClusterActor, 2, Optional<metacluster::DataClusterMetadata> >;
friend struct ActorCallback< RegisterClusterActor, 3, Optional<MetaclusterRegistrationEntry> >;
friend struct ActorCallback< RegisterClusterActor, 4, Void >;
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	RegisterClusterActor(MetaclusterManagementWorkload* const& self) 
															#line 3761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RegisterClusterActorState<RegisterClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5031830753118412800UL, 13167156597116580864UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterClusterActor, 0, Optional<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RegisterClusterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RegisterClusterActor, 2, Optional<metacluster::DataClusterMetadata> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RegisterClusterActor, 3, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RegisterClusterActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> registerCluster( MetaclusterManagementWorkload* const& self ) {
															#line 394 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new RegisterClusterActor(self));
															#line 3797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 501 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 3802 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via removeCluster()
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class RemoveClusterActor>
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class RemoveClusterActorState {
															#line 3808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	RemoveClusterActorState(MetaclusterManagementWorkload* const& self) 
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   clusterName(self->chooseClusterName()),
															#line 504 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   dataDb(self->dataDbs[clusterName]),
															#line 505 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   retried(false),
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   detachCluster(deterministicRandom()->coinflip())
															#line 3823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("removeCluster", reinterpret_cast<unsigned long>(this));

	}
	~RemoveClusterActorState() 
	{
		fdb_probe_actor_destroy("removeCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 509 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				;
															#line 3839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RemoveClusterActorState();
		static_cast<RemoveClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 584 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<RemoveClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveClusterActorState(); static_cast<RemoveClusterActor*>(this)->destroy(); return 0; }
															#line 3868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<RemoveClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveClusterActorState();
		static_cast<RemoveClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_cluster_not_found)
															#line 3881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(!dataDb->registered);
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!static_cast<RemoveClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveClusterActorState(); static_cast<RemoveClusterActor*>(this)->destroy(); return 0; }
															#line 3887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				new (&static_cast<RemoveClusterActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RemoveClusterActorState();
				static_cast<RemoveClusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 572 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (e.code() == error_code_cluster_not_empty && !detachCluster)
															#line 3897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 573 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(!dataDb->tenants.empty());
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<RemoveClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveClusterActorState(); static_cast<RemoveClusterActor*>(this)->destroy(); return 0; }
															#line 3903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<RemoveClusterActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~RemoveClusterActorState();
					static_cast<RemoveClusterActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (e.code() == error_code_invalid_metacluster_operation)
															#line 3913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(!self->metaclusterCreated);
															#line 577 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (!static_cast<RemoveClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveClusterActorState(); static_cast<RemoveClusterActor*>(this)->destroy(); return 0; }
															#line 3919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						new (&static_cast<RemoveClusterActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~RemoveClusterActorState();
						static_cast<RemoveClusterActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			TraceEvent(SevError, "RemoveClusterFailure").error(e).detail("ClusterName", clusterName);
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 3931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 541 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(dataDb->registered);
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(detachCluster || dataDb->tenants.empty());
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion(dataDb));
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->totalTenantGroupCapacity -= std::max<int64_t>( dataDb->tenantGroups.size() + dataDb->ungroupedTenants.size(), dataDb->tenantGroupCapacity);
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->tenantGroupCapacity = 0;
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->registered = false;
															#line 550 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->autoTenantAssignment = metacluster::AutoTenantAssignment::ENABLED;
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (detachCluster)
															#line 3962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 553 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->detached = true;
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			for( auto const& t : dataDb->ungroupedTenants ) {
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				self->ungroupedTenants.erase(t);
															#line 3970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			for( auto const& t : dataDb->tenantGroups ) {
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				self->tenantGroups.erase(t.first);
															#line 3976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			for( auto const& t : dataDb->tenants ) {
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				self->createdTenants.erase(t.first);
															#line 3982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
		}
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(runTransaction(dataDb->db.getReference(), [](Reference<ReadYourWritesTransaction> tr) { return tr->getReadVersion(); }));
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<RemoveClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3989 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<RemoveClusterActor*>(this)->actor_wait_state = 4;
															#line 566 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RemoveClusterActor, 3, Void >*>(static_cast<RemoveClusterActor*>(this)));
															#line 3994 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 510 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		Future<bool> removeFuture = metacluster::removeCluster(self->managementDb, clusterName, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove(detachCluster));
															#line 4010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		try {
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Optional<bool>> __when_expr_0 = timeout(removeFuture, deterministicRandom()->randomInt(1, 30));
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<RemoveClusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RemoveClusterActor*>(this)->actor_wait_state = 1;
															#line 515 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RemoveClusterActor, 0, Optional<bool> >*>(static_cast<RemoveClusterActor*>(this)));
															#line 4021 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 523 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_cluster_not_found && retried && dataDb->registered)
															#line 4056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 524 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				StrictFuture<Optional<metacluster::DataClusterMetadata>> __when_expr_1 = metacluster::tryGetCluster(self->managementDb, clusterName);
															#line 524 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (static_cast<RemoveClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
				static_cast<RemoveClusterActor*>(this)->actor_wait_state = 2;
															#line 524 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RemoveClusterActor, 1, Optional<metacluster::DataClusterMetadata> >*>(static_cast<RemoveClusterActor*>(this)));
															#line 4067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 529 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (e.code() == error_code_unsupported_metacluster_version)
															#line 4074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 530 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!self->isValidVersion())
															#line 4078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 531 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (!static_cast<RemoveClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveClusterActorState(); static_cast<RemoveClusterActor*>(this)->destroy(); return 0; }
															#line 4082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						new (&static_cast<RemoveClusterActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~RemoveClusterActorState();
						static_cast<RemoveClusterActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
					else
					{
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_2 = self->checkAndResetMetaclusterVersion(clusterName);
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (static_cast<RemoveClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when2(__when_expr_2.get(), loopDepth); };
						static_cast<RemoveClusterActor*>(this)->actor_wait_state = 3;
															#line 533 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RemoveClusterActor, 2, Void >*>(static_cast<RemoveClusterActor*>(this)));
															#line 4099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						loopDepth = 0;
					}
				}
				else
				{
															#line 536 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					return a_body1Catch2(e, std::max(0, loopDepth - 1));
															#line 4107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<bool> const& result,int loopDepth) 
	{
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 4123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(result.get());
															#line 4127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 520 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			retried = true;
															#line 4134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<bool> && result,int loopDepth) 
	{
															#line 516 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 4144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 517 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(result.get());
															#line 4148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 520 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			retried = true;
															#line 4155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<bool> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<bool> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RemoveClusterActor*>(this)->actor_wait_state > 0) static_cast<RemoveClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveClusterActor*>(this)->ActorCallback< RemoveClusterActor, 0, Optional<bool> >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveClusterActor, 0, Optional<bool> >*,Optional<bool> const& value) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RemoveClusterActor, 0, Optional<bool> >*,Optional<bool> && value) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RemoveClusterActor, 0, Optional<bool> >*,Error err) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Optional<metacluster::DataClusterMetadata> const& clusterMetadata,int loopDepth) 
	{
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!clusterMetadata.present());
															#line 4259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Optional<metacluster::DataClusterMetadata> && clusterMetadata,int loopDepth) 
	{
															#line 527 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!clusterMetadata.present());
															#line 4268 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Optional<metacluster::DataClusterMetadata> const& clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(clusterMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Optional<metacluster::DataClusterMetadata> && clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(clusterMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RemoveClusterActor*>(this)->actor_wait_state > 0) static_cast<RemoveClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveClusterActor*>(this)->ActorCallback< RemoveClusterActor, 1, Optional<metacluster::DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveClusterActor, 1, Optional<metacluster::DataClusterMetadata> >*,Optional<metacluster::DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RemoveClusterActor, 1, Optional<metacluster::DataClusterMetadata> >*,Optional<metacluster::DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RemoveClusterActor, 1, Optional<metacluster::DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RemoveClusterActor*>(this)->actor_wait_state > 0) static_cast<RemoveClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveClusterActor*>(this)->ActorCallback< RemoveClusterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveClusterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RemoveClusterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RemoveClusterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RemoveClusterActor*>(this)->actor_wait_state > 0) static_cast<RemoveClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveClusterActor*>(this)->ActorCallback< RemoveClusterActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveClusterActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RemoveClusterActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RemoveClusterActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 503 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ClusterName clusterName;
															#line 504 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Reference<DataClusterData> dataDb;
															#line 505 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool retried;
															#line 506 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	metacluster::ForceRemove detachCluster;
															#line 4557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via removeCluster()
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class RemoveClusterActor final : public Actor<Void>, public ActorCallback< RemoveClusterActor, 0, Optional<bool> >, public ActorCallback< RemoveClusterActor, 1, Optional<metacluster::DataClusterMetadata> >, public ActorCallback< RemoveClusterActor, 2, Void >, public ActorCallback< RemoveClusterActor, 3, Void >, public FastAllocated<RemoveClusterActor>, public RemoveClusterActorState<RemoveClusterActor> {
															#line 4562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<RemoveClusterActor>::operator new;
	using FastAllocated<RemoveClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12780914197152149248UL, 14414691558990914816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RemoveClusterActor, 0, Optional<bool> >;
friend struct ActorCallback< RemoveClusterActor, 1, Optional<metacluster::DataClusterMetadata> >;
friend struct ActorCallback< RemoveClusterActor, 2, Void >;
friend struct ActorCallback< RemoveClusterActor, 3, Void >;
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	RemoveClusterActor(MetaclusterManagementWorkload* const& self) 
															#line 4582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RemoveClusterActorState<RemoveClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(812508501301004544UL, 4934221500031631872UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("removeCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RemoveClusterActor, 0, Optional<bool> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RemoveClusterActor, 1, Optional<metacluster::DataClusterMetadata> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RemoveClusterActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RemoveClusterActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> removeCluster( MetaclusterManagementWorkload* const& self ) {
															#line 502 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new RemoveClusterActor(self));
															#line 4617 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 586 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 4622 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via removeFailedRestoredCluster()
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class RemoveFailedRestoredClusterActor>
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class RemoveFailedRestoredClusterActorState {
															#line 4628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	RemoveFailedRestoredClusterActorState(MetaclusterManagementWorkload* const& self,ClusterName const& clusterName) 
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   clusterName(clusterName)
															#line 4637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("removeFailedRestoredCluster", reinterpret_cast<unsigned long>(this));

	}
	~RemoveFailedRestoredClusterActorState() 
	{
		fdb_probe_actor_destroy("removeFailedRestoredCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = success(metacluster::removeCluster( self->managementDb, clusterName, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove::True));
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (static_cast<RemoveFailedRestoredClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4655 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RemoveFailedRestoredClusterActor*>(this)->actor_wait_state = 1;
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RemoveFailedRestoredClusterActor, 0, Void >*>(static_cast<RemoveFailedRestoredClusterActor*>(this)));
															#line 4660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RemoveFailedRestoredClusterActorState();
		static_cast<RemoveFailedRestoredClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 599 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<RemoveFailedRestoredClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveFailedRestoredClusterActorState(); static_cast<RemoveFailedRestoredClusterActor*>(this)->destroy(); return 0; }
															#line 4689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<RemoveFailedRestoredClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveFailedRestoredClusterActorState();
		static_cast<RemoveFailedRestoredClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() != error_code_cluster_not_found)
															#line 4702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 4706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RemoveFailedRestoredClusterActor*>(this)->actor_wait_state > 0) static_cast<RemoveFailedRestoredClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveFailedRestoredClusterActor*>(this)->ActorCallback< RemoveFailedRestoredClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveFailedRestoredClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeFailedRestoredCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveFailedRestoredClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeFailedRestoredCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RemoveFailedRestoredClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeFailedRestoredCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveFailedRestoredClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeFailedRestoredCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RemoveFailedRestoredClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeFailedRestoredCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveFailedRestoredClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeFailedRestoredCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ClusterName clusterName;
															#line 4822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via removeFailedRestoredCluster()
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class RemoveFailedRestoredClusterActor final : public Actor<Void>, public ActorCallback< RemoveFailedRestoredClusterActor, 0, Void >, public FastAllocated<RemoveFailedRestoredClusterActor>, public RemoveFailedRestoredClusterActorState<RemoveFailedRestoredClusterActor> {
															#line 4827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<RemoveFailedRestoredClusterActor>::operator new;
	using FastAllocated<RemoveFailedRestoredClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4595437498296599296UL, 12525524863131224064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RemoveFailedRestoredClusterActor, 0, Void >;
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	RemoveFailedRestoredClusterActor(MetaclusterManagementWorkload* const& self,ClusterName const& clusterName) 
															#line 4844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RemoveFailedRestoredClusterActorState<RemoveFailedRestoredClusterActor>(self, clusterName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("removeFailedRestoredCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17352619802107581952UL, 7116100976161541632UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveFailedRestoredClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("removeFailedRestoredCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("removeFailedRestoredCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RemoveFailedRestoredClusterActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> removeFailedRestoredCluster( MetaclusterManagementWorkload* const& self, ClusterName const& clusterName ) {
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new RemoveFailedRestoredClusterActor(self, clusterName));
															#line 4876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 601 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 4881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via resolveCollisions()
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class ResolveCollisionsActor>
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class ResolveCollisionsActorState {
															#line 4887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ResolveCollisionsActorState(MetaclusterManagementWorkload* const& self,ClusterName const& clusterName,Reference<DataClusterData> const& dataDb) 
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   clusterName(clusterName),
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   dataDb(dataDb),
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   tenantsToRemove(),
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   foundTenantCollision(false)
															#line 4902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("resolveCollisions", reinterpret_cast<unsigned long>(this));

	}
	~ResolveCollisionsActorState() 
	{
		fdb_probe_actor_destroy("resolveCollisions", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 608 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			for( auto t : dataDb->tenants ) {
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (self->createdTenants.contains(t.first))
															#line 4919 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					foundTenantCollision = true;
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					tenantsToRemove.insert(t.first);
															#line 4925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
			}
															#line 615 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			foundGroupCollision = false;
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			for( auto t : dataDb->tenantGroups ) {
															#line 617 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (self->tenantGroups.contains(t.first))
															#line 4934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 618 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					foundGroupCollision = true;
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					tenantsToRemove.insert(t.second->tenants.begin(), t.second->tenants.end());
															#line 4940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
			}
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tr = dataDb->db->createTransaction();
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			;
															#line 4947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ResolveCollisionsActorState();
		static_cast<ResolveCollisionsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		CODE_PROBE(foundTenantCollision, "Resolved tenant collision for restore", probe::decoration::rare);
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		CODE_PROBE(foundGroupCollision, "Resolved group collision for restore");
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<ResolveCollisionsActor*>(this)->SAV<bool>::futures) { (void)(foundTenantCollision || foundGroupCollision); this->~ResolveCollisionsActorState(); static_cast<ResolveCollisionsActor*>(this)->destroy(); return 0; }
															#line 4974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<ResolveCollisionsActor*>(this)->SAV< bool >::value()) bool(foundTenantCollision || foundGroupCollision);
		this->~ResolveCollisionsActorState();
		static_cast<ResolveCollisionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			getFutures = std::vector<Future<Optional<int64_t>>>();
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			for( auto const& t : tenantsToRemove ) {
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				getFutures.push_back(TenantMetadata::tenantNameIndex().get(tr, t));
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				auto tenantItr = dataDb->tenants.find(t);
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (tenantItr != dataDb->tenants.end())
															#line 5004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 632 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (tenantItr->second->tenantGroup.present())
															#line 5008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 633 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						auto groupItr = dataDb->tenantGroups.find(tenantItr->second->tenantGroup.get());
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(groupItr != dataDb->tenantGroups.end());
															#line 635 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						groupItr->second->tenants.erase(t);
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (groupItr->second->tenants.empty())
															#line 5018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						{
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							dataDb->tenantGroups.erase(groupItr);
															#line 5022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						}
					}
															#line 640 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					dataDb->tenants.erase(tenantItr);
															#line 5027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				dataDb->ungroupedTenants.erase(t);
															#line 5031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(getFutures);
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<ResolveCollisionsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ResolveCollisionsActor*>(this)->actor_wait_state = 1;
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ResolveCollisionsActor, 0, Void >*>(static_cast<ResolveCollisionsActor*>(this)));
															#line 5042 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<ResolveCollisionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5079 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<ResolveCollisionsActor*>(this)->actor_wait_state = 4;
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ResolveCollisionsActor, 3, Void >*>(static_cast<ResolveCollisionsActor*>(this)));
															#line 5084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		deleteFutures = std::vector<Future<Void>>();
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for( auto const& f : getFutures ) {
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (f.get().present())
															#line 5103 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 650 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				deleteFutures.push_back(TenantAPI::deleteTenantTransaction(tr, f.get().get()));
															#line 5107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
		}
															#line 654 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(deleteFutures);
															#line 654 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<ResolveCollisionsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ResolveCollisionsActor*>(this)->actor_wait_state = 2;
															#line 654 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ResolveCollisionsActor, 1, Void >*>(static_cast<ResolveCollisionsActor*>(this)));
															#line 5119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		deleteFutures = std::vector<Future<Void>>();
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for( auto const& f : getFutures ) {
															#line 649 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (f.get().present())
															#line 5132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 650 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				deleteFutures.push_back(TenantAPI::deleteTenantTransaction(tr, f.get().get()));
															#line 5136 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
		}
															#line 654 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(deleteFutures);
															#line 654 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<ResolveCollisionsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ResolveCollisionsActor*>(this)->actor_wait_state = 2;
															#line 654 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ResolveCollisionsActor, 1, Void >*>(static_cast<ResolveCollisionsActor*>(this)));
															#line 5148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ResolveCollisionsActor*>(this)->actor_wait_state > 0) static_cast<ResolveCollisionsActor*>(this)->actor_wait_state = 0;
		static_cast<ResolveCollisionsActor*>(this)->ActorCallback< ResolveCollisionsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResolveCollisionsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resolveCollisions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveCollisions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResolveCollisionsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resolveCollisions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveCollisions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ResolveCollisionsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resolveCollisions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveCollisions", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<ResolveCollisionsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_2.get(), loopDepth); };
		static_cast<ResolveCollisionsActor*>(this)->actor_wait_state = 3;
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ResolveCollisionsActor, 2, Void >*>(static_cast<ResolveCollisionsActor*>(this)));
															#line 5239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<ResolveCollisionsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_2.get(), loopDepth); };
		static_cast<ResolveCollisionsActor*>(this)->actor_wait_state = 3;
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ResolveCollisionsActor, 2, Void >*>(static_cast<ResolveCollisionsActor*>(this)));
															#line 5255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ResolveCollisionsActor*>(this)->actor_wait_state > 0) static_cast<ResolveCollisionsActor*>(this)->actor_wait_state = 0;
		static_cast<ResolveCollisionsActor*>(this)->ActorCallback< ResolveCollisionsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResolveCollisionsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resolveCollisions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveCollisions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ResolveCollisionsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resolveCollisions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveCollisions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ResolveCollisionsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resolveCollisions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveCollisions", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ResolveCollisionsActor*>(this)->actor_wait_state > 0) static_cast<ResolveCollisionsActor*>(this)->actor_wait_state = 0;
		static_cast<ResolveCollisionsActor*>(this)->ActorCallback< ResolveCollisionsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResolveCollisionsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resolveCollisions", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveCollisions", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ResolveCollisionsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resolveCollisions", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveCollisions", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ResolveCollisionsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resolveCollisions", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveCollisions", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ResolveCollisionsActor*>(this)->actor_wait_state > 0) static_cast<ResolveCollisionsActor*>(this)->actor_wait_state = 0;
		static_cast<ResolveCollisionsActor*>(this)->ActorCallback< ResolveCollisionsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResolveCollisionsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resolveCollisions", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveCollisions", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ResolveCollisionsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resolveCollisions", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveCollisions", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ResolveCollisionsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resolveCollisions", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resolveCollisions", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ClusterName clusterName;
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Reference<DataClusterData> dataDb;
															#line 605 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	std::set<TenantName> tenantsToRemove;
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool foundTenantCollision;
															#line 615 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool foundGroupCollision;
															#line 623 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	std::vector<Future<Optional<int64_t>>> getFutures;
															#line 647 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	std::vector<Future<Void>> deleteFutures;
															#line 5527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via resolveCollisions()
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class ResolveCollisionsActor final : public Actor<bool>, public ActorCallback< ResolveCollisionsActor, 0, Void >, public ActorCallback< ResolveCollisionsActor, 1, Void >, public ActorCallback< ResolveCollisionsActor, 2, Void >, public ActorCallback< ResolveCollisionsActor, 3, Void >, public FastAllocated<ResolveCollisionsActor>, public ResolveCollisionsActorState<ResolveCollisionsActor> {
															#line 5532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<ResolveCollisionsActor>::operator new;
	using FastAllocated<ResolveCollisionsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13394756642829466624UL, 766276324108416256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ResolveCollisionsActor, 0, Void >;
friend struct ActorCallback< ResolveCollisionsActor, 1, Void >;
friend struct ActorCallback< ResolveCollisionsActor, 2, Void >;
friend struct ActorCallback< ResolveCollisionsActor, 3, Void >;
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ResolveCollisionsActor(MetaclusterManagementWorkload* const& self,ClusterName const& clusterName,Reference<DataClusterData> const& dataDb) 
															#line 5552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   ResolveCollisionsActorState<ResolveCollisionsActor>(self, clusterName, dataDb),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("resolveCollisions", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18280637146590371328UL, 3265466139284598784UL);
		ActorExecutionContextHelper __helper(static_cast<ResolveCollisionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("resolveCollisions");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("resolveCollisions", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ResolveCollisionsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ResolveCollisionsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ResolveCollisionsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ResolveCollisionsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<bool> resolveCollisions( MetaclusterManagementWorkload* const& self, ClusterName const& clusterName, Reference<DataClusterData> const& dataDb ) {
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<bool>(new ResolveCollisionsActor(self, clusterName, dataDb));
															#line 5587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 666 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 5592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via restoreCluster()
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class RestoreClusterActor>
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class RestoreClusterActorState {
															#line 5598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	RestoreClusterActorState(MetaclusterManagementWorkload* const& self) 
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 668 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   clusterName(self->chooseClusterName()),
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   dataDb(self->dataDbs[clusterName]),
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   dryRun(deterministicRandom()->coinflip()),
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   forceJoin(deterministicRandom()->coinflip()),
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   forceReuseTenantIdPrefix(deterministicRandom()->coinflip()),
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   messages(),
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   retried(false)
															#line 5619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("restoreCluster", reinterpret_cast<unsigned long>(this));

	}
	~RestoreClusterActorState() 
	{
		fdb_probe_actor_destroy("restoreCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			;
															#line 5634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreClusterActorState();
		static_cast<RestoreClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 780 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<RestoreClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreClusterActorState(); static_cast<RestoreClusterActor*>(this)->destroy(); return 0; }
															#line 5657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<RestoreClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RestoreClusterActorState();
		static_cast<RestoreClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 679 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (dataDb->detached)
															#line 5677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 680 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (retried)
															#line 5681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_0 = removeFailedRestoredCluster(self, clusterName);
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5687 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
					static_cast<RestoreClusterActor*>(this)->actor_wait_state = 1;
															#line 681 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 0, Void >*>(static_cast<RestoreClusterActor*>(this)));
															#line 5692 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 685 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_1 = success(metacluster::removeCluster(dataDb->db.getReference(), clusterName, ClusterType::METACLUSTER_DATA, metacluster::ForceRemove::True));
															#line 685 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
					static_cast<RestoreClusterActor*>(this)->actor_wait_state = 2;
															#line 685 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 1, Void >*>(static_cast<RestoreClusterActor*>(this)));
															#line 5706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			error = e;
															#line 731 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (error.code() == error_code_conflicting_restore || error.code() == error_code_cluster_already_exists)
															#line 5749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(retried);
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				CODE_PROBE(true, "MetaclusterManagementWorkload: timed out restore conflicts with retried restore", probe::decoration::rare);
															#line 5755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				return a_body1loopHead1(loopDepth); // continue
			}
			else
			{
															#line 738 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (error.code() == error_code_cluster_not_found)
															#line 5762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(!dataDb->registered);
															#line 740 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<RestoreClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreClusterActorState(); static_cast<RestoreClusterActor*>(this)->destroy(); return 0; }
															#line 5768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<RestoreClusterActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~RestoreClusterActorState();
					static_cast<RestoreClusterActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 741 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (error.code() == error_code_tenant_already_exists || error.code() == error_code_invalid_tenant_configuration)
															#line 5778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 743 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(dataDb->detached);
															#line 744 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_3 = removeFailedRestoredCluster(self, clusterName);
															#line 744 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
						static_cast<RestoreClusterActor*>(this)->actor_wait_state = 4;
															#line 744 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 3, Void >*>(static_cast<RestoreClusterActor*>(this)));
															#line 5791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (error.code() == error_code_invalid_metacluster_configuration)
															#line 5798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						{
															#line 759 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							ASSERT(!forceReuseTenantIdPrefix && dataDb->detached);
															#line 760 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							StrictFuture<Void> __when_expr_5 = removeFailedRestoredCluster(self, clusterName);
															#line 760 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
							if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when2(__when_expr_5.get(), loopDepth); };
							static_cast<RestoreClusterActor*>(this)->actor_wait_state = 6;
															#line 760 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 5, Void >*>(static_cast<RestoreClusterActor*>(this)));
															#line 5811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							if (error.code() == error_code_unsupported_metacluster_version)
															#line 5818 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
							{
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
								if (!self->isValidVersion())
															#line 5822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
								{
															#line 765 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
									if (!static_cast<RestoreClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreClusterActorState(); static_cast<RestoreClusterActor*>(this)->destroy(); return 0; }
															#line 5826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
									new (&static_cast<RestoreClusterActor*>(this)->SAV< Void >::value()) Void(Void());
									this->~RestoreClusterActorState();
									static_cast<RestoreClusterActor*>(this)->finishSendAndDelPromiseRef();
									return 0;
								}
								else
								{
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
									StrictFuture<Void> __when_expr_6 = self->checkAndResetMetaclusterVersion(clusterName);
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
									if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
									if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when3(__when_expr_6.get(), loopDepth); };
									static_cast<RestoreClusterActor*>(this)->actor_wait_state = 7;
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
									__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 6, Void >*>(static_cast<RestoreClusterActor*>(this)));
															#line 5843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
									loopDepth = 0;
								}
							}
							else
							{
															#line 770 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
								if (e.code() == error_code_invalid_metacluster_operation)
															#line 5851 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
								{
															#line 771 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
									ASSERT(!self->metaclusterCreated);
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
									if (!static_cast<RestoreClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreClusterActorState(); static_cast<RestoreClusterActor*>(this)->destroy(); return 0; }
															#line 5857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
									new (&static_cast<RestoreClusterActor*>(this)->SAV< Void >::value()) Void(Void());
									this->~RestoreClusterActorState();
									static_cast<RestoreClusterActor*>(this)->finishSendAndDelPromiseRef();
									return 0;
								}
								loopDepth = a_body1loopBody1Catch1cont13(loopDepth);
							}
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 692 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		Future<Void> restoreFuture = metacluster::restoreCluster(self->managementDb, clusterName, dataDb->db->getConnectionRecord()->getConnectionString(), metacluster::ApplyManagementClusterUpdates(!dataDb->detached), metacluster::RestoreDryRun(dryRun), metacluster::ForceJoin(forceJoin), metacluster::ForceReuseTenantIdPrefix(forceReuseTenantIdPrefix), &messages);
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Optional<Void>> __when_expr_2 = timeout(restoreFuture, deterministicRandom()->randomInt(1, 30));
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RestoreClusterActor*>(this)->actor_wait_state = 3;
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 2, Optional<Void> >*>(static_cast<RestoreClusterActor*>(this)));
															#line 5891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Optional<Void> const& result,int loopDepth) 
	{
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!result.present())
															#line 6080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			retried = true;
															#line 6084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(dataDb->registered || dataDb->detached);
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion(dataDb));
															#line 711 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (dataDb->detached && !dryRun)
															#line 6095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 712 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->detached = false;
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->registered = true;
															#line 714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			for( auto const& t : dataDb->ungroupedTenants ) {
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				self->ungroupedTenants.insert(t);
															#line 6105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			for( auto const& t : dataDb->tenantGroups ) {
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(self->tenantGroups.try_emplace(t.first, t.second).second);
															#line 6111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			for( auto const& t : dataDb->tenants ) {
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(self->createdTenants.try_emplace(t.first, t.second).second);
															#line 722 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(self->createdTenants[t.first]->cluster == clusterName);
															#line 6119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->totalTenantGroupCapacity += dataDb->ungroupedTenants.size() + dataDb->tenantGroups.size();
															#line 6123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont6(Optional<Void> && result,int loopDepth) 
	{
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!result.present())
															#line 6133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			retried = true;
															#line 6137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 707 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 708 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(dataDb->registered || dataDb->detached);
															#line 709 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion(dataDb));
															#line 711 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (dataDb->detached && !dryRun)
															#line 6148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 712 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->detached = false;
															#line 713 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->registered = true;
															#line 714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			for( auto const& t : dataDb->ungroupedTenants ) {
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				self->ungroupedTenants.insert(t);
															#line 6158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			for( auto const& t : dataDb->tenantGroups ) {
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(self->tenantGroups.try_emplace(t.first, t.second).second);
															#line 6164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			for( auto const& t : dataDb->tenants ) {
															#line 721 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(self->createdTenants.try_emplace(t.first, t.second).second);
															#line 722 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(self->createdTenants[t.first]->cluster == clusterName);
															#line 6172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 725 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->totalTenantGroupCapacity += dataDb->ungroupedTenants.size() + dataDb->tenantGroups.size();
															#line 6176 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 2, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 2, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 2, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 2, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 775 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		TraceEvent(SevError, "RestoreClusterFailure").error(error).detail("ClusterName", clusterName);
															#line 776 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(false);
															#line 6263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6(Void const& _,int loopDepth) 
	{
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_4 = resolveCollisions(self, clusterName, dataDb);
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<RestoreClusterActor*>(this)->actor_wait_state = 5;
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 4, bool >*>(static_cast<RestoreClusterActor*>(this)));
															#line 6291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6(Void && _,int loopDepth) 
	{
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_4 = resolveCollisions(self, clusterName, dataDb);
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6302 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<RestoreClusterActor*>(this)->actor_wait_state = 5;
															#line 746 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 4, bool >*>(static_cast<RestoreClusterActor*>(this)));
															#line 6307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont7(bool const& resolvedCollisions,int loopDepth) 
	{
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (resolvedCollisions)
															#line 6391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
		else
		{
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(self->allowTenantIdPrefixReuse);
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(!messages.empty());
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(messages[0].find("has the same ID"));
															#line 755 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			CODE_PROBE(true, "Reused tenant ID", probe::decoration::rare);
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (!static_cast<RestoreClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreClusterActorState(); static_cast<RestoreClusterActor*>(this)->destroy(); return 0; }
															#line 6407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			new (&static_cast<RestoreClusterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RestoreClusterActorState();
			static_cast<RestoreClusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont7(bool && resolvedCollisions,int loopDepth) 
	{
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (resolvedCollisions)
															#line 6420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
		else
		{
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(self->allowTenantIdPrefixReuse);
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(!messages.empty());
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(messages[0].find("has the same ID"));
															#line 755 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			CODE_PROBE(true, "Reused tenant ID", probe::decoration::rare);
															#line 756 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (!static_cast<RestoreClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreClusterActorState(); static_cast<RestoreClusterActor*>(this)->destroy(); return 0; }
															#line 6436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			new (&static_cast<RestoreClusterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RestoreClusterActorState();
			static_cast<RestoreClusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6when1(bool const& resolvedCollisions,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(resolvedCollisions, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6when1(bool && resolvedCollisions,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(std::move(resolvedCollisions), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 4, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 4, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 4, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 4, bool >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1Catch1cont11(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont12(Void const& _,int loopDepth) 
	{
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		forceReuseTenantIdPrefix = true;
															#line 6530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont12(Void && _,int loopDepth) 
	{
															#line 761 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		forceReuseTenantIdPrefix = true;
															#line 6539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont13(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont16(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont16(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 668 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ClusterName clusterName;
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Reference<DataClusterData> dataDb;
															#line 670 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool dryRun;
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool forceJoin;
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool forceReuseTenantIdPrefix;
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	std::vector<std::string> messages;
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool retried;
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Error error;
															#line 6730 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via restoreCluster()
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class RestoreClusterActor final : public Actor<Void>, public ActorCallback< RestoreClusterActor, 0, Void >, public ActorCallback< RestoreClusterActor, 1, Void >, public ActorCallback< RestoreClusterActor, 2, Optional<Void> >, public ActorCallback< RestoreClusterActor, 3, Void >, public ActorCallback< RestoreClusterActor, 4, bool >, public ActorCallback< RestoreClusterActor, 5, Void >, public ActorCallback< RestoreClusterActor, 6, Void >, public FastAllocated<RestoreClusterActor>, public RestoreClusterActorState<RestoreClusterActor> {
															#line 6735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<RestoreClusterActor>::operator new;
	using FastAllocated<RestoreClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9530564923733956864UL, 917922684048055040UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreClusterActor, 0, Void >;
friend struct ActorCallback< RestoreClusterActor, 1, Void >;
friend struct ActorCallback< RestoreClusterActor, 2, Optional<Void> >;
friend struct ActorCallback< RestoreClusterActor, 3, Void >;
friend struct ActorCallback< RestoreClusterActor, 4, bool >;
friend struct ActorCallback< RestoreClusterActor, 5, Void >;
friend struct ActorCallback< RestoreClusterActor, 6, Void >;
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	RestoreClusterActor(MetaclusterManagementWorkload* const& self) 
															#line 6758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RestoreClusterActorState<RestoreClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12143823830767418880UL, 265345168070311680UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("restoreCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreClusterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RestoreClusterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RestoreClusterActor, 2, Optional<Void> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RestoreClusterActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RestoreClusterActor, 4, bool >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RestoreClusterActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RestoreClusterActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> restoreCluster( MetaclusterManagementWorkload* const& self ) {
															#line 667 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new RestoreClusterActor(self));
															#line 6796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 782 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 6801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via listClusters()
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class ListClustersActor>
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class ListClustersActorState {
															#line 6807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ListClustersActorState(MetaclusterManagementWorkload* const& self) 
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   clusterName1(self->chooseClusterName()),
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   clusterName2(self->chooseClusterName()),
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   limit(deterministicRandom()->randomInt(1, self->dataDbs.size() + 1))
															#line 6820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("listClusters", reinterpret_cast<unsigned long>(this));

	}
	~ListClustersActorState() 
	{
		fdb_probe_actor_destroy("listClusters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				StrictFuture<std::map<ClusterName, metacluster::DataClusterMetadata>> __when_expr_0 = metacluster::listClusters(self->managementDb, clusterName1, clusterName2, limit);
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (static_cast<ListClustersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ListClustersActor*>(this)->actor_wait_state = 1;
															#line 789 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*>(static_cast<ListClustersActor*>(this)));
															#line 6843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListClustersActorState();
		static_cast<ListClustersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 833 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<ListClustersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListClustersActorState(); static_cast<ListClustersActor*>(this)->destroy(); return 0; }
															#line 6872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<ListClustersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListClustersActorState();
		static_cast<ListClustersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_inverted_range)
															#line 6885 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(clusterName1 > clusterName2);
															#line 816 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!static_cast<ListClustersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListClustersActorState(); static_cast<ListClustersActor*>(this)->destroy(); return 0; }
															#line 6891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				new (&static_cast<ListClustersActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ListClustersActorState();
				static_cast<ListClustersActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 817 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (e.code() == error_code_unsupported_metacluster_version)
															#line 6901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 818 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(!self->isValidVersion());
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<ListClustersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListClustersActorState(); static_cast<ListClustersActor*>(this)->destroy(); return 0; }
															#line 6907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<ListClustersActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~ListClustersActorState();
					static_cast<ListClustersActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (e.code() == error_code_invalid_metacluster_operation)
															#line 6917 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 821 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(!self->metaclusterCreated);
															#line 822 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (!static_cast<ListClustersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListClustersActorState(); static_cast<ListClustersActor*>(this)->destroy(); return 0; }
															#line 6923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						new (&static_cast<ListClustersActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~ListClustersActorState();
						static_cast<ListClustersActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			TraceEvent(SevError, "ListClustersFailure") .error(e) .detail("BeginClusterName", clusterName1) .detail("EndClusterName", clusterName2) .detail("Limit", limit);
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 6935 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::map<ClusterName, metacluster::DataClusterMetadata> const& clusterList,int loopDepth) 
	{
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(clusterName1 <= clusterName2);
															#line 793 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion());
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 796 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto resultItr = clusterList.begin();
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		int count = 0;
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for(auto localItr = self->dataDbs.find(clusterName1);localItr != self->dataDbs.find(clusterName2) && count < limit;++localItr) {
															#line 802 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (localItr->second->registered)
															#line 6962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 803 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(resultItr != clusterList.end());
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(resultItr->first == localItr->first);
															#line 805 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(resultItr->second.connectionString == localItr->second->db->getConnectionRecord()->getConnectionString());
															#line 807 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				++resultItr;
															#line 808 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				++count;
															#line 6974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
		}
															#line 812 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(resultItr == clusterList.end());
															#line 6979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::map<ClusterName, metacluster::DataClusterMetadata> && clusterList,int loopDepth) 
	{
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(clusterName1 <= clusterName2);
															#line 793 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion());
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 796 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto resultItr = clusterList.begin();
															#line 798 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		int count = 0;
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for(auto localItr = self->dataDbs.find(clusterName1);localItr != self->dataDbs.find(clusterName2) && count < limit;++localItr) {
															#line 802 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (localItr->second->registered)
															#line 7000 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 803 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(resultItr != clusterList.end());
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(resultItr->first == localItr->first);
															#line 805 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(resultItr->second.connectionString == localItr->second->db->getConnectionRecord()->getConnectionString());
															#line 807 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				++resultItr;
															#line 808 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				++count;
															#line 7012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
		}
															#line 812 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(resultItr == clusterList.end());
															#line 7017 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::map<ClusterName, metacluster::DataClusterMetadata> const& clusterList,int loopDepth) 
	{
		loopDepth = a_body1cont2(clusterList, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::map<ClusterName, metacluster::DataClusterMetadata> && clusterList,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(clusterList), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListClustersActor*>(this)->actor_wait_state > 0) static_cast<ListClustersActor*>(this)->actor_wait_state = 0;
		static_cast<ListClustersActor*>(this)->ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*,std::map<ClusterName, metacluster::DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*,std::map<ClusterName, metacluster::DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ClusterName clusterName1;
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ClusterName clusterName2;
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	int limit;
															#line 7118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via listClusters()
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class ListClustersActor final : public Actor<Void>, public ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >, public FastAllocated<ListClustersActor>, public ListClustersActorState<ListClustersActor> {
															#line 7123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<ListClustersActor>::operator new;
	using FastAllocated<ListClustersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5040523366165859584UL, 13303225778010882816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >;
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ListClustersActor(MetaclusterManagementWorkload* const& self) 
															#line 7140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ListClustersActorState<ListClustersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2037707045627374080UL, 7691457401409661952UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listClusters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> listClusters( MetaclusterManagementWorkload* const& self ) {
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new ListClustersActor(self));
															#line 7172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 835 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 7177 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via getCluster()
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class GetClusterActor>
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class GetClusterActorState {
															#line 7183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	GetClusterActorState(MetaclusterManagementWorkload* const& self) 
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 837 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   clusterName(self->chooseClusterName()),
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   dataDb(self->dataDbs[clusterName])
															#line 7194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getCluster", reinterpret_cast<unsigned long>(this));

	}
	~GetClusterActorState() 
	{
		fdb_probe_actor_destroy("getCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				StrictFuture<metacluster::DataClusterMetadata> __when_expr_0 = metacluster::getCluster(self->managementDb, clusterName);
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (static_cast<GetClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetClusterActor*>(this)->actor_wait_state = 1;
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >*>(static_cast<GetClusterActor*>(this)));
															#line 7217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetClusterActorState();
		static_cast<GetClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 865 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<GetClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetClusterActorState(); static_cast<GetClusterActor*>(this)->destroy(); return 0; }
															#line 7246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<GetClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetClusterActorState();
		static_cast<GetClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 850 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_cluster_not_found)
															#line 7259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 851 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(!dataDb->registered);
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!static_cast<GetClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetClusterActorState(); static_cast<GetClusterActor*>(this)->destroy(); return 0; }
															#line 7265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				new (&static_cast<GetClusterActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetClusterActorState();
				static_cast<GetClusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 853 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (e.code() == error_code_unsupported_metacluster_version)
															#line 7275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 854 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(!self->isValidVersion());
															#line 855 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<GetClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetClusterActorState(); static_cast<GetClusterActor*>(this)->destroy(); return 0; }
															#line 7281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<GetClusterActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetClusterActorState();
					static_cast<GetClusterActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 856 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (e.code() == error_code_invalid_metacluster_operation)
															#line 7291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(!self->metaclusterCreated);
															#line 858 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (!static_cast<GetClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetClusterActorState(); static_cast<GetClusterActor*>(this)->destroy(); return 0; }
															#line 7297 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						new (&static_cast<GetClusterActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~GetClusterActorState();
						static_cast<GetClusterActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			TraceEvent(SevError, "GetClusterFailure").error(e).detail("ClusterName", clusterName);
															#line 862 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 7309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(metacluster::DataClusterMetadata const& clusterMetadata,int loopDepth) 
	{
															#line 844 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(dataDb->registered);
															#line 845 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion());
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 847 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(dataDb->db->getConnectionRecord()->getConnectionString() == clusterMetadata.connectionString);
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT_EQ(dataDb->autoTenantAssignment, clusterMetadata.entry.autoTenantAssignment);
															#line 7332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(metacluster::DataClusterMetadata && clusterMetadata,int loopDepth) 
	{
															#line 844 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(dataDb->registered);
															#line 845 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion());
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 847 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(dataDb->db->getConnectionRecord()->getConnectionString() == clusterMetadata.connectionString);
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT_EQ(dataDb->autoTenantAssignment, clusterMetadata.entry.autoTenantAssignment);
															#line 7349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(metacluster::DataClusterMetadata const& clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont2(clusterMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1when1(metacluster::DataClusterMetadata && clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(clusterMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetClusterActor*>(this)->actor_wait_state > 0) static_cast<GetClusterActor*>(this)->actor_wait_state = 0;
		static_cast<GetClusterActor*>(this)->ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >::remove();

	}
	void a_callback_fire(ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >*,metacluster::DataClusterMetadata const& value) 
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >*,metacluster::DataClusterMetadata && value) 
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >*,Error err) 
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 837 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ClusterName clusterName;
															#line 838 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Reference<DataClusterData> dataDb;
															#line 7448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via getCluster()
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class GetClusterActor final : public Actor<Void>, public ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >, public FastAllocated<GetClusterActor>, public GetClusterActorState<GetClusterActor> {
															#line 7453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<GetClusterActor>::operator new;
	using FastAllocated<GetClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2390981718840287744UL, 2023333382289131520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >;
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	GetClusterActor(MetaclusterManagementWorkload* const& self) 
															#line 7470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   GetClusterActorState<GetClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3838274093655030272UL, 16128179049859696384UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >*)0, actor_cancelled()); break;
		}

	}
};
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> getCluster( MetaclusterManagementWorkload* const& self ) {
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new GetClusterActor(self));
															#line 7502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 867 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 7507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via configureImpl()
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class ConfigureImplActor>
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class ConfigureImplActorState {
															#line 7513 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ConfigureImplActorState(MetaclusterManagementWorkload* const& self,ClusterName const& clusterName,Reference<DataClusterData> const& dataDb,Optional<int64_t> const& numTenantGroups,Optional<ClusterConnectionString> const& connectionString,Optional<metacluster::AutoTenantAssignment> const& autoTenantAssignment) 
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   clusterName(clusterName),
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   dataDb(dataDb),
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   numTenantGroups(numTenantGroups),
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   connectionString(connectionString),
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   autoTenantAssignment(autoTenantAssignment),
															#line 875 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   tr(self->managementDb->createTransaction())
															#line 7532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("configureImpl", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureImplActorState() 
	{
		fdb_probe_actor_destroy("configureImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			;
															#line 7547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureImplActorState();
		static_cast<ConfigureImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 878 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 879 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Optional<metacluster::DataClusterMetadata>> __when_expr_0 = metacluster::tryGetClusterTransaction(tr, clusterName);
															#line 879 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConfigureImplActor*>(this)->actor_wait_state = 1;
															#line 879 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >*>(static_cast<ConfigureImplActor*>(this)));
															#line 7587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 903 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 903 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ConfigureImplActor*>(this)->actor_wait_state = 3;
															#line 903 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 2, Void >*>(static_cast<ConfigureImplActor*>(this)));
															#line 7616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<metacluster::DataClusterMetadata> const& clusterMetadata,int loopDepth) 
	{
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		entry = Optional<metacluster::DataClusterEntry>();
															#line 883 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (clusterMetadata.present())
															#line 7633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (numTenantGroups.present())
															#line 7637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 885 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!entry.present())
															#line 7641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 886 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					entry = clusterMetadata.get().entry;
															#line 7645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
															#line 888 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				entry.get().capacity.numTenantGroups = numTenantGroups.get();
															#line 7649 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (autoTenantAssignment.present())
															#line 7653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 891 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!entry.present())
															#line 7657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 892 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					entry = clusterMetadata.get().entry;
															#line 7661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
															#line 894 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				entry.get().autoTenantAssignment = autoTenantAssignment.get();
															#line 7665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 896 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			metacluster::updateClusterMetadata(tr, clusterName, clusterMetadata.get(), connectionString, entry);
															#line 898 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 898 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ConfigureImplActor*>(this)->actor_wait_state = 2;
															#line 898 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 1, Void >*>(static_cast<ConfigureImplActor*>(this)));
															#line 7678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<metacluster::DataClusterMetadata> && clusterMetadata,int loopDepth) 
	{
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		entry = Optional<metacluster::DataClusterEntry>();
															#line 883 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (clusterMetadata.present())
															#line 7694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (numTenantGroups.present())
															#line 7698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 885 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!entry.present())
															#line 7702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 886 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					entry = clusterMetadata.get().entry;
															#line 7706 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
															#line 888 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				entry.get().capacity.numTenantGroups = numTenantGroups.get();
															#line 7710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (autoTenantAssignment.present())
															#line 7714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 891 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!entry.present())
															#line 7718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 892 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					entry = clusterMetadata.get().entry;
															#line 7722 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
															#line 894 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				entry.get().autoTenantAssignment = autoTenantAssignment.get();
															#line 7726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 896 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			metacluster::updateClusterMetadata(tr, clusterName, clusterMetadata.get(), connectionString, entry);
															#line 898 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 898 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ConfigureImplActor*>(this)->actor_wait_state = 2;
															#line 898 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 1, Void >*>(static_cast<ConfigureImplActor*>(this)));
															#line 7739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<metacluster::DataClusterMetadata> const& clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(clusterMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<metacluster::DataClusterMetadata> && clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(clusterMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureImplActor*>(this)->ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >*,Optional<metacluster::DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >*,Optional<metacluster::DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 901 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<ConfigureImplActor*>(this)->SAV<Optional<metacluster::DataClusterEntry>>::futures) { (void)(entry); this->~ConfigureImplActorState(); static_cast<ConfigureImplActor*>(this)->destroy(); return 0; }
															#line 7828 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<ConfigureImplActor*>(this)->SAV< Optional<metacluster::DataClusterEntry> >::value()) Optional<metacluster::DataClusterEntry>(std::move(entry)); // state_var_RVO
		this->~ConfigureImplActorState();
		static_cast<ConfigureImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureImplActor*>(this)->ActorCallback< ConfigureImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigureImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureImplActor*>(this)->ActorCallback< ConfigureImplActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConfigureImplActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ClusterName clusterName;
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Reference<DataClusterData> dataDb;
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Optional<int64_t> numTenantGroups;
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Optional<ClusterConnectionString> connectionString;
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Optional<metacluster::AutoTenantAssignment> autoTenantAssignment;
															#line 875 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Reference<ITransaction> tr;
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Optional<metacluster::DataClusterEntry> entry;
															#line 8026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via configureImpl()
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class ConfigureImplActor final : public Actor<Optional<metacluster::DataClusterEntry>>, public ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >, public ActorCallback< ConfigureImplActor, 1, Void >, public ActorCallback< ConfigureImplActor, 2, Void >, public FastAllocated<ConfigureImplActor>, public ConfigureImplActorState<ConfigureImplActor> {
															#line 8031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<ConfigureImplActor>::operator new;
	using FastAllocated<ConfigureImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7027870203105932032UL, 18338097477272016640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<metacluster::DataClusterEntry>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >;
friend struct ActorCallback< ConfigureImplActor, 1, Void >;
friend struct ActorCallback< ConfigureImplActor, 2, Void >;
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ConfigureImplActor(MetaclusterManagementWorkload* const& self,ClusterName const& clusterName,Reference<DataClusterData> const& dataDb,Optional<int64_t> const& numTenantGroups,Optional<ClusterConnectionString> const& connectionString,Optional<metacluster::AutoTenantAssignment> const& autoTenantAssignment) 
															#line 8050 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Optional<metacluster::DataClusterEntry>>(),
		   ConfigureImplActorState<ConfigureImplActor>(self, clusterName, dataDb, numTenantGroups, connectionString, autoTenantAssignment),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(766673556958241024UL, 14520056664626172928UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigureImplActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConfigureImplActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Optional<metacluster::DataClusterEntry>> configureImpl( MetaclusterManagementWorkload* const& self, ClusterName const& clusterName, Reference<DataClusterData> const& dataDb, Optional<int64_t> const& numTenantGroups, Optional<ClusterConnectionString> const& connectionString, Optional<metacluster::AutoTenantAssignment> const& autoTenantAssignment ) {
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Optional<metacluster::DataClusterEntry>>(new ConfigureImplActor(self, clusterName, dataDb, numTenantGroups, connectionString, autoTenantAssignment));
															#line 8084 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 907 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 8089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via configureCluster()
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class ConfigureClusterActor>
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class ConfigureClusterActorState {
															#line 8095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ConfigureClusterActorState(MetaclusterManagementWorkload* const& self) 
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   clusterName(self->chooseClusterName()),
															#line 910 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   dataDb(self->dataDbs[clusterName]),
															#line 911 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   updatedEntry(),
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   newNumTenantGroups(),
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   connectionString(),
															#line 915 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   autoTenantAssignment()
															#line 8114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("configureCluster", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureClusterActorState() 
	{
		fdb_probe_actor_destroy("configureCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 916 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 8129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 917 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				newNumTenantGroups = deterministicRandom()->randomInt(0, 4);
															#line 8133 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 8137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 920 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				connectionString = dataDb->db->getConnectionRecord()->getConnectionString();
															#line 8141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 8145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 923 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				autoTenantAssignment = deterministicRandom()->coinflip() ? metacluster::AutoTenantAssignment::DISABLED : metacluster::AutoTenantAssignment::ENABLED;
															#line 8149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
			try {
															#line 928 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				;
															#line 8154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureClusterActorState();
		static_cast<ConfigureClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 965 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<ConfigureClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureClusterActorState(); static_cast<ConfigureClusterActor*>(this)->destroy(); return 0; }
															#line 8183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<ConfigureClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureClusterActorState();
		static_cast<ConfigureClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 953 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_unsupported_metacluster_version)
															#line 8196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 954 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(!self->isValidVersion());
															#line 955 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!static_cast<ConfigureClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureClusterActorState(); static_cast<ConfigureClusterActor*>(this)->destroy(); return 0; }
															#line 8202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				new (&static_cast<ConfigureClusterActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ConfigureClusterActorState();
				static_cast<ConfigureClusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 956 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (e.code() == error_code_invalid_metacluster_operation)
															#line 8212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 957 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(!self->metaclusterCreated);
															#line 958 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<ConfigureClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureClusterActorState(); static_cast<ConfigureClusterActor*>(this)->destroy(); return 0; }
															#line 8218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<ConfigureClusterActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~ConfigureClusterActorState();
					static_cast<ConfigureClusterActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 961 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			TraceEvent(SevError, "ConfigureClusterFailure").error(e).detail("ClusterName", clusterName);
															#line 962 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 8229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 940 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion());
															#line 942 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (updatedEntry.present())
															#line 8248 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			int allocatedGroups = dataDb->tenantGroups.size() + dataDb->ungroupedTenants.size();
															#line 944 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			int64_t tenantGroupDelta = std::max<int64_t>(updatedEntry.get().capacity.numTenantGroups, allocatedGroups) - std::max<int64_t>(dataDb->tenantGroupCapacity, allocatedGroups);
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->totalTenantGroupCapacity += tenantGroupDelta;
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->tenantGroupCapacity = updatedEntry.get().capacity.numTenantGroups;
															#line 950 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->autoTenantAssignment = updatedEntry.get().autoTenantAssignment;
															#line 8260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Optional<Optional<metacluster::DataClusterEntry>>> __when_expr_0 = timeout(configureImpl( self, clusterName, dataDb, newNumTenantGroups, connectionString, autoTenantAssignment), deterministicRandom()->randomInt(1, 30));
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<ConfigureClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8279 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ConfigureClusterActor*>(this)->actor_wait_state = 1;
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >*>(static_cast<ConfigureClusterActor*>(this)));
															#line 8284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Optional<metacluster::DataClusterEntry>> const& result,int loopDepth) 
	{
															#line 933 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 8306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			updatedEntry = result.get();
															#line 8310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Optional<metacluster::DataClusterEntry>> && result,int loopDepth) 
	{
															#line 933 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 8321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 934 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			updatedEntry = result.get();
															#line 8325 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Optional<metacluster::DataClusterEntry>> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Optional<metacluster::DataClusterEntry>> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureClusterActor*>(this)->actor_wait_state > 0) static_cast<ConfigureClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureClusterActor*>(this)->ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >*,Optional<Optional<metacluster::DataClusterEntry>> const& value) 
	{
		fdb_probe_actor_enter("configureCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >*,Optional<Optional<metacluster::DataClusterEntry>> && value) 
	{
		fdb_probe_actor_enter("configureCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("configureCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ClusterName clusterName;
															#line 910 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Reference<DataClusterData> dataDb;
															#line 911 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Optional<metacluster::DataClusterEntry> updatedEntry;
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Optional<int64_t> newNumTenantGroups;
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Optional<ClusterConnectionString> connectionString;
															#line 915 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Optional<metacluster::AutoTenantAssignment> autoTenantAssignment;
															#line 8434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via configureCluster()
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class ConfigureClusterActor final : public Actor<Void>, public ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >, public FastAllocated<ConfigureClusterActor>, public ConfigureClusterActorState<ConfigureClusterActor> {
															#line 8439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<ConfigureClusterActor>::operator new;
	using FastAllocated<ConfigureClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18428986192005431808UL, 12885996829887113728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >;
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ConfigureClusterActor(MetaclusterManagementWorkload* const& self) 
															#line 8456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ConfigureClusterActorState<ConfigureClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6960254137143238656UL, 15722660461201014016UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> configureCluster( MetaclusterManagementWorkload* const& self ) {
															#line 908 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new ConfigureClusterActor(self));
															#line 8488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 967 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 8493 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via verifyListFilter()
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class VerifyListFilterActor>
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class VerifyListFilterActorState {
															#line 8499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	VerifyListFilterActorState(MetaclusterManagementWorkload* const& self,TenantName const& tenant,const char* const& context) 
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   tenant(tenant),
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   context(context)
															#line 8510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("verifyListFilter", reinterpret_cast<unsigned long>(this));

	}
	~VerifyListFilterActorState() 
	{
		fdb_probe_actor_destroy("verifyListFilter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				StrictFuture<metacluster::MetaclusterTenantMapEntry> __when_expr_0 = metacluster::getTenant(self->managementDb, tenant);
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (static_cast<VerifyListFilterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8528 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<VerifyListFilterActor*>(this)->actor_wait_state = 1;
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VerifyListFilterActor, 0, metacluster::MetaclusterTenantMapEntry >*>(static_cast<VerifyListFilterActor*>(this)));
															#line 8533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VerifyListFilterActorState();
		static_cast<VerifyListFilterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1003 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<VerifyListFilterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~VerifyListFilterActorState(); static_cast<VerifyListFilterActor*>(this)->destroy(); return 0; }
															#line 8562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<VerifyListFilterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~VerifyListFilterActorState();
		static_cast<VerifyListFilterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 998 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() != error_code_tenant_not_found)
															#line 8575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 999 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				TraceEvent(SevError, "VerifyListFilterFailure").error(e).detail("Tenant", tenant);
															#line 1000 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 8581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 974 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		checkState = checkEntry.tenantState;
															#line 975 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		filters = std::vector<metacluster::TenantState>();
															#line 976 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		filters.push_back(checkState);
															#line 978 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>>> __when_expr_1 = metacluster::listTenantMetadata(self->managementDb, ""_sr, "\xff\xff"_sr, 10e6, 0, filters);
															#line 978 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<VerifyListFilterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<VerifyListFilterActor*>(this)->actor_wait_state = 2;
															#line 978 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyListFilterActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >*>(static_cast<VerifyListFilterActor*>(this)));
															#line 8610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(metacluster::MetaclusterTenantMapEntry const& __checkEntry,int loopDepth) 
	{
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		checkEntry = __checkEntry;
															#line 8619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(metacluster::MetaclusterTenantMapEntry && __checkEntry,int loopDepth) 
	{
		checkEntry = std::move(__checkEntry);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VerifyListFilterActor*>(this)->actor_wait_state > 0) static_cast<VerifyListFilterActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyListFilterActor*>(this)->ActorCallback< VerifyListFilterActor, 0, metacluster::MetaclusterTenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyListFilterActor, 0, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("verifyListFilter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyListFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyListFilter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VerifyListFilterActor, 0, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry && value) 
	{
		fdb_probe_actor_enter("verifyListFilter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyListFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyListFilter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VerifyListFilterActor, 0, metacluster::MetaclusterTenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("verifyListFilter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyListFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyListFilter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 981 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<metacluster::MetaclusterTenantMapEntry> __when_expr_2 = metacluster::getTenant(self->managementDb, tenant);
															#line 981 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<VerifyListFilterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8700 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<VerifyListFilterActor*>(this)->actor_wait_state = 3;
															#line 981 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< VerifyListFilterActor, 2, metacluster::MetaclusterTenantMapEntry >*>(static_cast<VerifyListFilterActor*>(this)));
															#line 8705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> const& __tenantList,int loopDepth) 
	{
															#line 978 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		tenantList = __tenantList;
															#line 8714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> && __tenantList,int loopDepth) 
	{
		tenantList = std::move(__tenantList);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<VerifyListFilterActor*>(this)->actor_wait_state > 0) static_cast<VerifyListFilterActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyListFilterActor*>(this)->ActorCallback< VerifyListFilterActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyListFilterActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >*,std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("verifyListFilter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyListFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyListFilter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< VerifyListFilterActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >*,std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("verifyListFilter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyListFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyListFilter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< VerifyListFilterActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyListFilter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyListFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyListFilter", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 983 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		DisabledTraceEvent(SevDebug, "VerifyListFilter") .detail("Context", context) .detail("Tenant", tenant) .detail("CheckState", (int)checkState) .detail("Entry2State", (int)checkEntry2.tenantState);
															#line 989 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		bool found = false;
															#line 990 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for( auto pair : tenantList ) {
															#line 991 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(pair.second.tenantState == checkState);
															#line 992 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (pair.first == tenant)
															#line 8801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 993 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				found = true;
															#line 8805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
		}
															#line 996 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(found || checkEntry2.tenantState != checkState);
															#line 8810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(metacluster::MetaclusterTenantMapEntry const& __checkEntry2,int loopDepth) 
	{
															#line 981 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		checkEntry2 = __checkEntry2;
															#line 8819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(metacluster::MetaclusterTenantMapEntry && __checkEntry2,int loopDepth) 
	{
		checkEntry2 = std::move(__checkEntry2);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<VerifyListFilterActor*>(this)->actor_wait_state > 0) static_cast<VerifyListFilterActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyListFilterActor*>(this)->ActorCallback< VerifyListFilterActor, 2, metacluster::MetaclusterTenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyListFilterActor, 2, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("verifyListFilter", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyListFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyListFilter", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< VerifyListFilterActor, 2, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry && value) 
	{
		fdb_probe_actor_enter("verifyListFilter", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyListFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyListFilter", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< VerifyListFilterActor, 2, metacluster::MetaclusterTenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("verifyListFilter", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyListFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyListFilter", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	TenantName tenant;
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	const char* context;
															#line 972 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	metacluster::MetaclusterTenantMapEntry checkEntry;
															#line 974 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	metacluster::TenantState checkState;
															#line 975 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	std::vector<metacluster::TenantState> filters;
															#line 978 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> tenantList;
															#line 981 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	metacluster::MetaclusterTenantMapEntry checkEntry2;
															#line 8923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via verifyListFilter()
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class VerifyListFilterActor final : public Actor<Void>, public ActorCallback< VerifyListFilterActor, 0, metacluster::MetaclusterTenantMapEntry >, public ActorCallback< VerifyListFilterActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >, public ActorCallback< VerifyListFilterActor, 2, metacluster::MetaclusterTenantMapEntry >, public FastAllocated<VerifyListFilterActor>, public VerifyListFilterActorState<VerifyListFilterActor> {
															#line 8928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<VerifyListFilterActor>::operator new;
	using FastAllocated<VerifyListFilterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9653886924925731328UL, 247767640037521152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VerifyListFilterActor, 0, metacluster::MetaclusterTenantMapEntry >;
friend struct ActorCallback< VerifyListFilterActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >;
friend struct ActorCallback< VerifyListFilterActor, 2, metacluster::MetaclusterTenantMapEntry >;
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	VerifyListFilterActor(MetaclusterManagementWorkload* const& self,TenantName const& tenant,const char* const& context) 
															#line 8947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   VerifyListFilterActorState<VerifyListFilterActor>(self, tenant, context),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("verifyListFilter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9110511872290870528UL, 9893867679847069952UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyListFilterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("verifyListFilter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("verifyListFilter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VerifyListFilterActor, 0, metacluster::MetaclusterTenantMapEntry >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< VerifyListFilterActor, 1, std::vector<std::pair<TenantName, metacluster::MetaclusterTenantMapEntry>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< VerifyListFilterActor, 2, metacluster::MetaclusterTenantMapEntry >*)0, actor_cancelled()); break;
		}

	}
};
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> verifyListFilter( MetaclusterManagementWorkload* const& self, TenantName const& tenant, const char* const& context ) {
															#line 968 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new VerifyListFilterActor(self, tenant, context));
															#line 8981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 1005 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 8986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via createTenant()
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class CreateTenantActor>
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class CreateTenantActorState {
															#line 8992 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	CreateTenantActorState(MetaclusterManagementWorkload* const& self) 
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 1007 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   tenant(self->chooseTenantName()),
															#line 1008 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   tenantGroup(self->chooseTenantGroup()),
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   assignClusterAutomatically(deterministicRandom()->coinflip()),
															#line 1010 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   ignoreCapacityLimit(deterministicRandom()->coinflip())
															#line 9007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("createTenant", reinterpret_cast<unsigned long>(this));

	}
	~CreateTenantActorState() 
	{
		fdb_probe_actor_destroy("createTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1012 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			auto itr = self->createdTenants.find(tenant);
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			exists = itr != self->createdTenants.end();
															#line 1014 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantGroupExists = tenantGroup.present() && self->tenantGroups.contains(tenantGroup.get());
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			hasCapacity = tenantGroupExists || self->ungroupedTenants.size() + self->tenantGroups.size() < self->totalTenantGroupCapacity;
															#line 1018 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (assignClusterAutomatically && !tenantGroupExists && hasCapacity)
															#line 9030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1024 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				bool emptyCapacityIndex = true;
															#line 1025 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				for( auto dataDb : self->dataDbs ) {
															#line 1026 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (metacluster::AutoTenantAssignment::DISABLED == dataDb.second->autoTenantAssignment || !dataDb.second->registered || dataDb.second->detached)
															#line 9038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
						continue;
					}
															#line 1030 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (dataDb.second->ungroupedTenants.size() + dataDb.second->tenantGroups.size() < dataDb.second->tenantGroupCapacity)
															#line 9044 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 1032 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						emptyCapacityIndex = false;
															#line 9048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						break;
					}
				}
															#line 1036 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				hasCapacity = !emptyCapacityIndex;
															#line 9054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 1038 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			retried = false;
															#line 1040 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantMapEntry = metacluster::MetaclusterTenantMapEntry();
															#line 1041 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantMapEntry.tenantName = tenant;
															#line 1042 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantMapEntry.tenantGroup = tenantGroup;
															#line 1047 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			preferredClusters = std::vector<ClusterName>();
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			preferredClusterIndex = 0;
															#line 1049 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (!assignClusterAutomatically)
															#line 9070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1050 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				preferredClusters.push_back(self->chooseClusterName());
															#line 1051 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				preferredClusters.push_back(self->chooseClusterName());
															#line 1052 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				tenantMapEntry.assignedCluster = preferredClusters[preferredClusterIndex];
															#line 9078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
			try {
															#line 1056 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				;
															#line 9083 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1209 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 9112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1172 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_tenant_already_exists)
															#line 9125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1173 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(exists);
															#line 1174 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 9131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CreateTenantActorState();
				static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 1175 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (e.code() == error_code_metacluster_no_capacity)
															#line 9141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1176 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(!exists && !hasCapacity);
															#line 1177 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 9147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~CreateTenantActorState();
					static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 1178 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (e.code() == error_code_cluster_no_capacity)
															#line 9157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 1179 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(!assignClusterAutomatically);
															#line 1184 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(!ignoreCapacityLimit);
															#line 1185 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 9165 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~CreateTenantActorState();
						static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
					else
					{
															#line 1186 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (e.code() == error_code_cluster_not_found)
															#line 9175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						{
															#line 1187 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							ASSERT(!assignClusterAutomatically);
															#line 1188 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 9181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
							new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
							this->~CreateTenantActorState();
							static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
						else
						{
															#line 1189 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							if (e.code() == error_code_invalid_tenant_configuration)
															#line 9191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
							{
															#line 1190 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
								bool tenantGroupClusterMismatch = false;
															#line 1191 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
								if (tenantGroup.present())
															#line 9197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
								{
															#line 1192 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
									auto itr = self->tenantGroups.find(tenantGroup.get());
															#line 1193 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
									if (itr != self->tenantGroups.end() && itr->second->cluster != tenantMapEntry.assignedCluster)
															#line 9203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
									{
															#line 1194 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
										tenantGroupClusterMismatch = true;
															#line 9207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
									}
								}
															#line 1197 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
								bool invalidIgnoreCapacityLimit = assignClusterAutomatically && ignoreCapacityLimit;
															#line 1198 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
								ASSERT(tenantGroupClusterMismatch || invalidIgnoreCapacityLimit);
															#line 1199 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
								if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 9216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
								new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
								this->~CreateTenantActorState();
								static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
							else
							{
															#line 1200 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
								if (e.code() == error_code_invalid_metacluster_operation)
															#line 9226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
								{
															#line 1201 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
									ASSERT(!self->metaclusterCreated);
															#line 1202 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
									if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 9232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
									new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
									this->~CreateTenantActorState();
									static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
									return 0;
								}
							}
						}
					}
				}
			}
															#line 1205 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			TraceEvent(SevError, "CreateTenantFailure").error(e).detail("TenantName", tenant);
															#line 1206 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 9247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1114 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<metacluster::MetaclusterTenantMapEntry> __when_expr_6 = metacluster::getTenant(self->managementDb, tenant);
															#line 1114 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<CreateTenantActor*>(this)->actor_wait_state = 7;
															#line 1114 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 6, metacluster::MetaclusterTenantMapEntry >*>(static_cast<CreateTenantActor*>(this)));
															#line 9269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1058 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (!assignClusterAutomatically && deterministicRandom()->coinflip())
															#line 9286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1059 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				preferredClusterIndex = deterministicRandom()->randomInt(0, preferredClusters.size());
															#line 1060 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				tenantMapEntry.assignedCluster = preferredClusters[preferredClusterIndex];
															#line 9292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 1062 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			Future<Void> createFuture = metacluster::createTenant( self->managementDb, tenantMapEntry, assignClusterAutomatically, ignoreCapacityLimit);
															#line 1064 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Optional<Void>> __when_expr_0 = timeout(createFuture, deterministicRandom()->randomInt(1, 30));
															#line 1064 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 1;
															#line 1064 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 0, Optional<Void> >*>(static_cast<CreateTenantActor*>(this)));
															#line 9305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1072 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_tenant_already_exists && retried && !exists)
															#line 9340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1073 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				StrictFuture<Optional<metacluster::MetaclusterTenantMapEntry>> __when_expr_2 = metacluster::tryGetTenant(self->managementDb, tenant);
															#line 1073 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<CreateTenantActor*>(this)->actor_wait_state = 3;
															#line 1073 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >*>(static_cast<CreateTenantActor*>(this)));
															#line 9351 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1078 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!assignClusterAutomatically && (e.code() == error_code_cluster_no_capacity || e.code() == error_code_cluster_not_found || e.code() == error_code_invalid_tenant_configuration))
															#line 9358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					error = e;
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					StrictFuture<Optional<metacluster::MetaclusterTenantMapEntry>> __when_expr_3 = metacluster::tryGetTenant(self->managementDb, tenant);
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9366 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when2(__when_expr_3.get(), loopDepth); };
					static_cast<CreateTenantActor*>(this)->actor_wait_state = 4;
															#line 1082 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >*>(static_cast<CreateTenantActor*>(this)));
															#line 9371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 1098 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (e.code() == error_code_unsupported_metacluster_version)
															#line 9378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 1099 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (!self->isValidVersion())
															#line 9382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						{
															#line 1100 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							if (!static_cast<CreateTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 9386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
							new (&static_cast<CreateTenantActor*>(this)->SAV< Void >::value()) Void(Void());
							this->~CreateTenantActorState();
							static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
						else
						{
															#line 1102 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							StrictFuture<Optional<metacluster::MetaclusterTenantMapEntry>> __when_expr_4 = metacluster::tryGetTenant(self->managementDb, tenant);
															#line 1102 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
							if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when3(__when_expr_4.get(), loopDepth); };
							static_cast<CreateTenantActor*>(this)->actor_wait_state = 5;
															#line 1102 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*>(static_cast<CreateTenantActor*>(this)));
															#line 9403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
							loopDepth = 0;
						}
					}
					else
					{
															#line 1109 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						return a_body1Catch2(e, std::max(0, loopDepth - 1));
															#line 9411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Void> const& result,int loopDepth) 
	{
															#line 1065 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 9428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 1068 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			retried = true;
															#line 1069 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = verifyListFilter(self, tenant, "createTenant");
															#line 1069 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9440 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 2;
															#line 1069 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 1, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 9445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Void> && result,int loopDepth) 
	{
															#line 1065 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 9455 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 1068 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			retried = true;
															#line 1069 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = verifyListFilter(self, tenant, "createTenant");
															#line 1069 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 2;
															#line 1069 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 1, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 9472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 0, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 0, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 0, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 0, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Optional<metacluster::MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
															#line 1075 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(entry.present());
															#line 1076 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		tenantMapEntry = entry.get();
															#line 9665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Optional<metacluster::MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
															#line 1075 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(entry.present());
															#line 1076 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		tenantMapEntry = entry.get();
															#line 9676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Optional<metacluster::MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(entry, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Optional<metacluster::MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont5(Optional<metacluster::MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
															#line 1089 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (preferredClusters.size() > 1 && (!entry.present() || entry.get().assignedCluster != tenantMapEntry.assignedCluster))
															#line 9760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1091 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			preferredClusters.erase(preferredClusters.begin() + preferredClusterIndex);
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			preferredClusterIndex = 0;
															#line 1093 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantMapEntry.assignedCluster = preferredClusters[preferredClusterIndex];
															#line 9768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		return a_body1Catch2(error, std::max(0, loopDepth - 1));
															#line 9773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(Optional<metacluster::MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
															#line 1089 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (preferredClusters.size() > 1 && (!entry.present() || entry.get().assignedCluster != tenantMapEntry.assignedCluster))
															#line 9781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1091 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			preferredClusters.erase(preferredClusters.begin() + preferredClusterIndex);
															#line 1092 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			preferredClusterIndex = 0;
															#line 1093 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantMapEntry.assignedCluster = preferredClusters[preferredClusterIndex];
															#line 9789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 1097 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		return a_body1Catch2(error, std::max(0, loopDepth - 1));
															#line 9794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Optional<metacluster::MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(entry, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Optional<metacluster::MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont11(Optional<metacluster::MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
															#line 1104 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(entry.present());
															#line 1105 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->checkAndResetMetaclusterVersion(entry.get().assignedCluster);
															#line 1105 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9881 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont11when1(__when_expr_5.get(), loopDepth); };
		static_cast<CreateTenantActor*>(this)->actor_wait_state = 6;
															#line 1105 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 5, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 9886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont11(Optional<metacluster::MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
															#line 1104 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(entry.present());
															#line 1105 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->checkAndResetMetaclusterVersion(entry.get().assignedCluster);
															#line 1105 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont11when1(__when_expr_5.get(), loopDepth); };
		static_cast<CreateTenantActor*>(this)->actor_wait_state = 6;
															#line 1105 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 5, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 9904 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1when3(Optional<metacluster::MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont11(entry, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when3(Optional<metacluster::MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont11(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1Catch1cont11cont1(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont11cont1(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont8(metacluster::MetaclusterTenantMapEntry const& entry,int loopDepth) 
	{
															#line 1116 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!exists);
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(ignoreCapacityLimit || hasCapacity);
															#line 1119 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!hasCapacity)
															#line 10081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(!tenantGroupExists);
															#line 1121 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(ignoreCapacityLimit);
															#line 10087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1123 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!ignoreCapacityLimit || !assignClusterAutomatically);
															#line 1124 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(entry.tenantGroup == tenantGroup);
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(TenantAPI::getTenantIdPrefix(entry.id) == self->tenantIdPrefix);
															#line 1127 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		Reference<TenantTestData> tenantData = makeReference<TenantTestData>(entry.assignedCluster, tenantGroup);
															#line 1128 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->createdTenants[tenant] = tenantData;
															#line 1130 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto assignedCluster = self->dataDbs.find(entry.assignedCluster);
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(assignClusterAutomatically || tenantMapEntry.assignedCluster == assignedCluster->first);
															#line 1132 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(assignedCluster != self->dataDbs.end());
															#line 1133 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(assignedCluster->second->tenants.try_emplace(tenant, tenantData).second);
															#line 1135 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		Optional<ClusterName> clusterAssignedToTenantGroup;
															#line 1136 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion(assignedCluster->second));
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		bool allocationAdded = false;
															#line 1139 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (tenantGroup.present())
															#line 10115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1140 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			auto [tenantGroupData, _allocationAdded] = self->tenantGroups.try_emplace( tenantGroup.get(), makeReference<TenantGroupData>(entry.assignedCluster));
															#line 1143 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			allocationAdded = _allocationAdded;
															#line 1144 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(tenantGroupData->second->cluster == entry.assignedCluster);
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			clusterAssignedToTenantGroup = tenantGroupData->second->cluster;
															#line 1146 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantGroupData->second->tenants.insert(tenant);
															#line 1147 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			assignedCluster->second->tenantGroups[tenantGroup.get()] = tenantGroupData->second;
															#line 10129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		else
		{
															#line 1149 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			allocationAdded = true;
															#line 1150 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->ungroupedTenants.insert(tenant);
															#line 1151 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			assignedCluster->second->ungroupedTenants.insert(tenant);
															#line 10139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1154 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (allocationAdded && assignedCluster->second->ungroupedTenants.size() + assignedCluster->second->tenantGroups.size() > assignedCluster->second->tenantGroupCapacity)
															#line 10143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1157 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			++self->totalTenantGroupCapacity;
															#line 10147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!assignClusterAutomatically || clusterAssignedToTenantGroup.present() || assignedCluster->second->autoTenantAssignment == metacluster::AutoTenantAssignment::ENABLED);
															#line 1168 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(tenantGroupExists || ignoreCapacityLimit || assignedCluster->second->tenantGroupCapacity >= assignedCluster->second->tenantGroups.size() + assignedCluster->second->ungroupedTenants.size());
															#line 10153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(metacluster::MetaclusterTenantMapEntry && entry,int loopDepth) 
	{
															#line 1116 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 1117 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!exists);
															#line 1118 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(ignoreCapacityLimit || hasCapacity);
															#line 1119 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!hasCapacity)
															#line 10168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1120 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(!tenantGroupExists);
															#line 1121 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(ignoreCapacityLimit);
															#line 10174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1123 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!ignoreCapacityLimit || !assignClusterAutomatically);
															#line 1124 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(entry.tenantGroup == tenantGroup);
															#line 1125 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(TenantAPI::getTenantIdPrefix(entry.id) == self->tenantIdPrefix);
															#line 1127 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		Reference<TenantTestData> tenantData = makeReference<TenantTestData>(entry.assignedCluster, tenantGroup);
															#line 1128 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->createdTenants[tenant] = tenantData;
															#line 1130 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto assignedCluster = self->dataDbs.find(entry.assignedCluster);
															#line 1131 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(assignClusterAutomatically || tenantMapEntry.assignedCluster == assignedCluster->first);
															#line 1132 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(assignedCluster != self->dataDbs.end());
															#line 1133 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(assignedCluster->second->tenants.try_emplace(tenant, tenantData).second);
															#line 1135 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		Optional<ClusterName> clusterAssignedToTenantGroup;
															#line 1136 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion(assignedCluster->second));
															#line 1138 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		bool allocationAdded = false;
															#line 1139 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (tenantGroup.present())
															#line 10202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1140 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			auto [tenantGroupData, _allocationAdded] = self->tenantGroups.try_emplace( tenantGroup.get(), makeReference<TenantGroupData>(entry.assignedCluster));
															#line 1143 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			allocationAdded = _allocationAdded;
															#line 1144 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(tenantGroupData->second->cluster == entry.assignedCluster);
															#line 1145 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			clusterAssignedToTenantGroup = tenantGroupData->second->cluster;
															#line 1146 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantGroupData->second->tenants.insert(tenant);
															#line 1147 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			assignedCluster->second->tenantGroups[tenantGroup.get()] = tenantGroupData->second;
															#line 10216 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		else
		{
															#line 1149 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			allocationAdded = true;
															#line 1150 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->ungroupedTenants.insert(tenant);
															#line 1151 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			assignedCluster->second->ungroupedTenants.insert(tenant);
															#line 10226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1154 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (allocationAdded && assignedCluster->second->ungroupedTenants.size() + assignedCluster->second->tenantGroups.size() > assignedCluster->second->tenantGroupCapacity)
															#line 10230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1157 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			++self->totalTenantGroupCapacity;
															#line 10234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1165 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!assignClusterAutomatically || clusterAssignedToTenantGroup.present() || assignedCluster->second->autoTenantAssignment == metacluster::AutoTenantAssignment::ENABLED);
															#line 1168 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(tenantGroupExists || ignoreCapacityLimit || assignedCluster->second->tenantGroupCapacity >= assignedCluster->second->tenantGroups.size() + assignedCluster->second->ungroupedTenants.size());
															#line 10240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(metacluster::MetaclusterTenantMapEntry const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont8(entry, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(metacluster::MetaclusterTenantMapEntry && entry,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 6, metacluster::MetaclusterTenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 6, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 6, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 6, metacluster::MetaclusterTenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont14(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 1007 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	TenantName tenant;
															#line 1008 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Optional<TenantGroupName> tenantGroup;
															#line 1009 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	metacluster::AssignClusterAutomatically assignClusterAutomatically;
															#line 1010 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	metacluster::IgnoreCapacityLimit ignoreCapacityLimit;
															#line 1013 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool exists;
															#line 1014 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool tenantGroupExists;
															#line 1015 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool hasCapacity;
															#line 1038 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool retried;
															#line 1040 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	metacluster::MetaclusterTenantMapEntry tenantMapEntry;
															#line 1047 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	std::vector<ClusterName> preferredClusters;
															#line 1048 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	int preferredClusterIndex;
															#line 1081 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Error error;
															#line 10359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via createTenant()
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class CreateTenantActor final : public Actor<Void>, public ActorCallback< CreateTenantActor, 0, Optional<Void> >, public ActorCallback< CreateTenantActor, 1, Void >, public ActorCallback< CreateTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >, public ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >, public ActorCallback< CreateTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >, public ActorCallback< CreateTenantActor, 5, Void >, public ActorCallback< CreateTenantActor, 6, metacluster::MetaclusterTenantMapEntry >, public FastAllocated<CreateTenantActor>, public CreateTenantActorState<CreateTenantActor> {
															#line 10364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<CreateTenantActor>::operator new;
	using FastAllocated<CreateTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10806472323757474816UL, 15407275427831507456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateTenantActor, 0, Optional<Void> >;
friend struct ActorCallback< CreateTenantActor, 1, Void >;
friend struct ActorCallback< CreateTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >;
friend struct ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >;
friend struct ActorCallback< CreateTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >;
friend struct ActorCallback< CreateTenantActor, 5, Void >;
friend struct ActorCallback< CreateTenantActor, 6, metacluster::MetaclusterTenantMapEntry >;
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	CreateTenantActor(MetaclusterManagementWorkload* const& self) 
															#line 10387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   CreateTenantActorState<CreateTenantActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2480746510970185984UL, 428737674404862208UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateTenantActor, 0, Optional<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateTenantActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CreateTenantActor, 3, Optional<metacluster::MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CreateTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CreateTenantActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CreateTenantActor, 6, metacluster::MetaclusterTenantMapEntry >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> createTenant( MetaclusterManagementWorkload* const& self ) {
															#line 1006 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new CreateTenantActor(self));
															#line 10425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 1211 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 10430 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via deleteTenant()
															#line 1212 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class DeleteTenantActor>
															#line 1212 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class DeleteTenantActorState {
															#line 10436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 1212 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	DeleteTenantActorState(MetaclusterManagementWorkload* const& self) 
															#line 1212 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 1212 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 1213 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   tenant(self->chooseTenantName())
															#line 10445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteTenant", reinterpret_cast<unsigned long>(this));

	}
	~DeleteTenantActorState() 
	{
		fdb_probe_actor_destroy("deleteTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1215 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			auto itr = self->createdTenants.find(tenant);
															#line 1216 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			exists = itr != self->createdTenants.end();
															#line 1217 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			retried = false;
															#line 10464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			try {
															#line 1220 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				;
															#line 10468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteTenantActorState();
		static_cast<DeleteTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1304 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 10497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantActorState();
		static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1292 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_tenant_not_found)
															#line 10510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1293 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(!exists);
															#line 1294 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 10516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DeleteTenantActorState();
				static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 1295 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (e.code() == error_code_invalid_metacluster_operation)
															#line 10526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1296 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(!self->metaclusterCreated);
															#line 1297 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 10532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~DeleteTenantActorState();
					static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 1300 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			TraceEvent(SevError, "DeleteTenantFailure").error(e).detail("TenantName", tenant);
															#line 1301 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 10543 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1252 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 1253 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(exists);
															#line 1254 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto tenantData = self->createdTenants.find(tenant);
															#line 1255 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(tenantData != self->createdTenants.end());
															#line 1257 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		bool erasedTenantGroup = false;
															#line 1258 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (tenantData->second->tenantGroup.present())
															#line 10568 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1259 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			auto tenantGroupData = self->tenantGroups.find(tenantData->second->tenantGroup.get());
															#line 1260 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(tenantGroupData != self->tenantGroups.end());
															#line 1261 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantGroupData->second->tenants.erase(tenant);
															#line 1262 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (tenantGroupData->second->tenants.empty())
															#line 10578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1263 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				erasedTenantGroup = true;
															#line 1264 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				self->tenantGroups.erase(tenantData->second->tenantGroup.get());
															#line 10584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
		}
		else
		{
															#line 1267 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->ungroupedTenants.erase(tenant);
															#line 10591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1270 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto dataDb = self->dataDbs[tenantData->second->cluster];
															#line 1271 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(dataDb->registered);
															#line 1272 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto tenantItr = dataDb->tenants.find(tenant);
															#line 1273 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(tenantItr != dataDb->tenants.end());
															#line 1274 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion(dataDb));
															#line 1276 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		bool reducedAllocatedCount = false;
															#line 1277 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (erasedTenantGroup)
															#line 10607 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1278 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			reducedAllocatedCount = true;
															#line 1279 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->tenantGroups.erase(tenantData->second->tenantGroup.get());
															#line 10613 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		else
		{
															#line 1280 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (!tenantData->second->tenantGroup.present())
															#line 10619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1281 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				reducedAllocatedCount = true;
															#line 1282 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				dataDb->ungroupedTenants.erase(tenant);
															#line 10625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
		}
															#line 1285 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (reducedAllocatedCount && dataDb->ungroupedTenants.size() + dataDb->tenantGroups.size() >= dataDb->tenantGroupCapacity)
															#line 10630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1287 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			--self->totalTenantGroupCapacity;
															#line 10634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1289 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->tenants.erase(tenantItr);
															#line 1290 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->createdTenants.erase(tenant);
															#line 10640 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1222 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			Future<Void> deleteFuture = metacluster::deleteTenant(self->managementDb, tenant);
															#line 1223 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Optional<Void>> __when_expr_0 = timeout(deleteFuture, deterministicRandom()->randomInt(1, 30));
															#line 1223 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteTenantActor*>(this)->actor_wait_state = 1;
															#line 1223 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 0, Optional<Void> >*>(static_cast<DeleteTenantActor*>(this)));
															#line 10666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1232 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_tenant_not_found && retried && exists)
															#line 10701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1233 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				StrictFuture<Optional<metacluster::MetaclusterTenantMapEntry>> __when_expr_2 = metacluster::tryGetTenant(self->managementDb, tenant);
															#line 1233 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
				static_cast<DeleteTenantActor*>(this)->actor_wait_state = 3;
															#line 1233 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >*>(static_cast<DeleteTenantActor*>(this)));
															#line 10712 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1237 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (e.code() == error_code_unsupported_metacluster_version)
															#line 10719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1238 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!self->isValidVersion())
															#line 10723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 1239 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 10727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~DeleteTenantActorState();
						static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
					else
					{
															#line 1241 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						auto tenantItr = self->createdTenants.find(tenant);
															#line 1242 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(tenantItr != self->createdTenants.end());
															#line 1243 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_3 = self->checkAndResetMetaclusterVersion(tenantItr->second->cluster);
															#line 1243 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when2(__when_expr_3.get(), loopDepth); };
						static_cast<DeleteTenantActor*>(this)->actor_wait_state = 4;
															#line 1243 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 3, Void >*>(static_cast<DeleteTenantActor*>(this)));
															#line 10748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						loopDepth = 0;
					}
				}
				else
				{
															#line 1247 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					return a_body1Catch2(e, std::max(0, loopDepth - 1));
															#line 10756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Void> const& result,int loopDepth) 
	{
															#line 1225 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 10772 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			retried = true;
															#line 1229 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = verifyListFilter(self, tenant, "deleteTenant");
															#line 1229 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<DeleteTenantActor*>(this)->actor_wait_state = 2;
															#line 1229 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 1, Void >*>(static_cast<DeleteTenantActor*>(this)));
															#line 10789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Void> && result,int loopDepth) 
	{
															#line 1225 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 10799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 1228 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			retried = true;
															#line 1229 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = verifyListFilter(self, tenant, "deleteTenant");
															#line 1229 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<DeleteTenantActor*>(this)->actor_wait_state = 2;
															#line 1229 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 1, Void >*>(static_cast<DeleteTenantActor*>(this)));
															#line 10816 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 0, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 0, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 0, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 0, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Optional<metacluster::MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
															#line 1235 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!entry.present());
															#line 11007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Optional<metacluster::MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
															#line 1235 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!entry.present());
															#line 11016 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Optional<metacluster::MetaclusterTenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(entry, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Optional<metacluster::MetaclusterTenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont7(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont7(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1212 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 1213 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	TenantName tenant;
															#line 1216 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool exists;
															#line 1217 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool retried;
															#line 11204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via deleteTenant()
															#line 1212 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class DeleteTenantActor final : public Actor<Void>, public ActorCallback< DeleteTenantActor, 0, Optional<Void> >, public ActorCallback< DeleteTenantActor, 1, Void >, public ActorCallback< DeleteTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >, public ActorCallback< DeleteTenantActor, 3, Void >, public FastAllocated<DeleteTenantActor>, public DeleteTenantActorState<DeleteTenantActor> {
															#line 11209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<DeleteTenantActor>::operator new;
	using FastAllocated<DeleteTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10571135319841460480UL, 4754938364792373504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteTenantActor, 0, Optional<Void> >;
friend struct ActorCallback< DeleteTenantActor, 1, Void >;
friend struct ActorCallback< DeleteTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >;
friend struct ActorCallback< DeleteTenantActor, 3, Void >;
															#line 1212 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	DeleteTenantActor(MetaclusterManagementWorkload* const& self) 
															#line 11229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteTenantActorState<DeleteTenantActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14546017859301560576UL, 18123705475076122368UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteTenantActor, 0, Optional<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DeleteTenantActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DeleteTenantActor, 2, Optional<metacluster::MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DeleteTenantActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1212 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> deleteTenant( MetaclusterManagementWorkload* const& self ) {
															#line 1212 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new DeleteTenantActor(self));
															#line 11264 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 1306 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 11269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via configureTenant()
															#line 1307 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class ConfigureTenantActor>
															#line 1307 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class ConfigureTenantActorState {
															#line 11275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 1307 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ConfigureTenantActorState(MetaclusterManagementWorkload* const& self) 
															#line 1307 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 1307 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 1308 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   tenant(self->chooseTenantName()),
															#line 1309 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   newTenantGroup(self->chooseTenantGroup()),
															#line 1310 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   ignoreCapacityLimit(deterministicRandom()->coinflip())
															#line 11288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("configureTenant", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureTenantActorState() 
	{
		fdb_probe_actor_destroy("configureTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1312 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			auto itr = self->createdTenants.find(tenant);
															#line 1313 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			exists = itr != self->createdTenants.end();
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantGroupExists = newTenantGroup.present() && self->tenantGroups.find(newTenantGroup.get()) != self->tenantGroups.end();
															#line 1317 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			hasCapacity = false;
															#line 1318 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			oldClusterName = Optional<ClusterName>();
															#line 1319 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (exists)
															#line 11313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1320 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				auto& dataDb = self->dataDbs[itr->second->cluster];
															#line 1321 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				hasCapacity = dataDb->ungroupedTenants.size() + dataDb->tenantGroups.size() < dataDb->tenantGroupCapacity;
															#line 1322 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				oldClusterName = itr->second->cluster;
															#line 11321 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 1325 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			newClusterName = oldClusterName;
															#line 1326 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 11327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1327 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				newClusterName = self->chooseClusterName();
															#line 11331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 1330 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			configurationParameters = { { "assigned_cluster"_sr, newClusterName }, { "tenant_group"_sr, newTenantGroup } };
															#line 1334 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			configChanged = exists && (itr->second->tenantGroup != newTenantGroup || oldClusterName != newClusterName);
															#line 11337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			try {
															#line 1338 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				;
															#line 11341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureTenantActorState();
		static_cast<ConfigureTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1450 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 11370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureTenantActorState();
		static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1425 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_tenant_not_found)
															#line 11383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1426 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(!exists);
															#line 1427 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 11389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ConfigureTenantActorState();
				static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 1428 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (e.code() == error_code_cluster_no_capacity)
															#line 11399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1429 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(exists && !hasCapacity && !ignoreCapacityLimit);
															#line 1430 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 11405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~ConfigureTenantActorState();
					static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 1431 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (e.code() == error_code_invalid_tenant_configuration)
															#line 11415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 1432 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(exists);
															#line 1433 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (oldClusterName == newClusterName)
															#line 11421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						{
															#line 1434 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							ASSERT(tenantGroupExists && self->createdTenants[tenant]->cluster != self->tenantGroups[newTenantGroup.get()]->cluster);
															#line 11425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						}
															#line 1437 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 11429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~ConfigureTenantActorState();
						static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
					else
					{
															#line 1438 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (e.code() == error_code_invalid_metacluster_operation)
															#line 11439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						{
															#line 1439 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							ASSERT(!self->metaclusterCreated);
															#line 1440 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 11445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
							new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
							this->~ConfigureTenantActorState();
							static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
					}
				}
			}
															#line 1443 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			TraceEvent(SevError, "ConfigureTenantFailure") .error(e) .detail("TenantName", tenant) .detail("TenantGroup", newTenantGroup);
															#line 1447 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 11458 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1365 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 1366 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(exists);
															#line 1367 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto tenantData = self->createdTenants.find(tenant);
															#line 1368 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(tenantData != self->createdTenants.end());
															#line 1370 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto& dataDb = self->dataDbs[tenantData->second->cluster];
															#line 1371 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(dataDb->registered);
															#line 1373 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (configChanged)
															#line 11485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1374 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(self->isValidVersion(dataDb));
															#line 11489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		else
		{
															#line 1376 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(self->isValidVersion());
															#line 11495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1379 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		bool allocationRemoved = false;
															#line 1380 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		bool allocationAdded = false;
															#line 1381 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (tenantData->second->tenantGroup != newTenantGroup)
															#line 11503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1382 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (tenantData->second->tenantGroup.present())
															#line 11507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1383 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				auto& tenantGroupData = self->tenantGroups[tenantData->second->tenantGroup.get()];
															#line 1384 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				tenantGroupData->tenants.erase(tenant);
															#line 1385 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (tenantGroupData->tenants.empty())
															#line 11515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1386 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					allocationRemoved = true;
															#line 1387 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					self->tenantGroups.erase(tenantData->second->tenantGroup.get());
															#line 1388 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					dataDb->tenantGroups.erase(tenantData->second->tenantGroup.get());
															#line 11523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
			}
			else
			{
															#line 1391 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				allocationRemoved = true;
															#line 1392 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				self->ungroupedTenants.erase(tenant);
															#line 1393 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				dataDb->ungroupedTenants.erase(tenant);
															#line 11534 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 1396 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (newTenantGroup.present())
															#line 11538 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1397 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				auto [tenantGroupData, inserted] = self->tenantGroups.try_emplace( newTenantGroup.get(), makeReference<TenantGroupData>(tenantData->second->cluster));
															#line 1399 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				tenantGroupData->second->tenants.insert(tenant);
															#line 1400 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (inserted)
															#line 11546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1401 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					allocationAdded = true;
															#line 1402 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(dataDb->tenantGroups.try_emplace(newTenantGroup.get(), tenantGroupData->second).second);
															#line 11552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
			}
			else
			{
															#line 1405 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				allocationAdded = true;
															#line 1406 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				self->ungroupedTenants.insert(tenant);
															#line 1407 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				dataDb->ungroupedTenants.insert(tenant);
															#line 11563 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 1410 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantData->second->tenantGroup = newTenantGroup;
															#line 1412 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (allocationAdded && !allocationRemoved)
															#line 11569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1413 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(ignoreCapacityLimit || hasCapacity);
															#line 1414 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!hasCapacity)
															#line 11575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1415 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					++self->totalTenantGroupCapacity;
															#line 11579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
			}
			else
			{
															#line 1417 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (allocationRemoved && !allocationAdded && dataDb->ungroupedTenants.size() + dataDb->tenantGroups.size() >= dataDb->tenantGroupCapacity)
															#line 11586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1420 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					--self->totalTenantGroupCapacity;
															#line 11590 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
			}
		}
															#line 1423 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(oldClusterName == newClusterName);
															#line 11596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1339 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		Future<Void> configureFuture = metacluster::configureTenant( self->managementDb, tenant, configurationParameters, ignoreCapacityLimit);
															#line 11612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		try {
															#line 1342 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Optional<Void>> __when_expr_0 = timeout(configureFuture, deterministicRandom()->randomInt(1, 30));
															#line 1342 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 1;
															#line 1342 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantActor, 0, Optional<Void> >*>(static_cast<ConfigureTenantActor*>(this)));
															#line 11623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1349 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			error = e;
															#line 1350 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_unsupported_metacluster_version)
															#line 11660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1351 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!self->isValidVersion())
															#line 11664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1352 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<ConfigureTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantActorState(); static_cast<ConfigureTenantActor*>(this)->destroy(); return 0; }
															#line 11668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<ConfigureTenantActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~ConfigureTenantActorState();
					static_cast<ConfigureTenantActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 1354 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					auto tenantItr = self->createdTenants.find(tenant);
															#line 1355 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(tenantItr != self->createdTenants.end());
															#line 1356 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_2 = self->checkAndResetMetaclusterVersion(tenantItr->second->cluster);
															#line 1356 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
					static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 3;
															#line 1356 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantActor, 2, Void >*>(static_cast<ConfigureTenantActor*>(this)));
															#line 11689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Void> const& result,int loopDepth) 
	{
															#line 1344 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 11710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1347 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = verifyListFilter(self, tenant, "configureTenant");
															#line 1347 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 2;
															#line 1347 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantActor, 1, Void >*>(static_cast<ConfigureTenantActor*>(this)));
															#line 11723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Void> && result,int loopDepth) 
	{
															#line 1344 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 11732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1347 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = verifyListFilter(self, tenant, "configureTenant");
															#line 1347 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 2;
															#line 1347 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantActor, 1, Void >*>(static_cast<ConfigureTenantActor*>(this)));
															#line 11745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state > 0) static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureTenantActor*>(this)->ActorCallback< ConfigureTenantActor, 0, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 0, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 0, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureTenantActor, 0, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state > 0) static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureTenantActor*>(this)->ActorCallback< ConfigureTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigureTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 1361 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		return a_body1Catch2(error, std::max(0, loopDepth - 1));
															#line 11929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConfigureTenantActor*>(this)->actor_wait_state > 0) static_cast<ConfigureTenantActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureTenantActor*>(this)->ActorCallback< ConfigureTenantActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConfigureTenantActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConfigureTenantActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont19(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1307 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 1308 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	TenantName tenant;
															#line 1309 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Optional<TenantGroupName> newTenantGroup;
															#line 1310 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	metacluster::IgnoreCapacityLimit ignoreCapacityLimit;
															#line 1313 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool exists;
															#line 1314 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool tenantGroupExists;
															#line 1317 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool hasCapacity;
															#line 1318 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Optional<ClusterName> oldClusterName;
															#line 1325 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Optional<ClusterName> newClusterName;
															#line 1330 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	std::map<Standalone<StringRef>, Optional<Value>> configurationParameters;
															#line 1334 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool configChanged;
															#line 1349 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Error error;
															#line 12057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via configureTenant()
															#line 1307 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class ConfigureTenantActor final : public Actor<Void>, public ActorCallback< ConfigureTenantActor, 0, Optional<Void> >, public ActorCallback< ConfigureTenantActor, 1, Void >, public ActorCallback< ConfigureTenantActor, 2, Void >, public FastAllocated<ConfigureTenantActor>, public ConfigureTenantActorState<ConfigureTenantActor> {
															#line 12062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<ConfigureTenantActor>::operator new;
	using FastAllocated<ConfigureTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5871907969569153536UL, 2062817320797218816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureTenantActor, 0, Optional<Void> >;
friend struct ActorCallback< ConfigureTenantActor, 1, Void >;
friend struct ActorCallback< ConfigureTenantActor, 2, Void >;
															#line 1307 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ConfigureTenantActor(MetaclusterManagementWorkload* const& self) 
															#line 12081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ConfigureTenantActorState<ConfigureTenantActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7048885742222706688UL, 1739664772098993408UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureTenantActor, 0, Optional<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigureTenantActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConfigureTenantActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1307 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> configureTenant( MetaclusterManagementWorkload* const& self ) {
															#line 1307 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new ConfigureTenantActor(self));
															#line 12115 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 1452 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 12120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via lockTenant()
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class LockTenantActor>
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class LockTenantActorState {
															#line 12126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	LockTenantActorState(MetaclusterManagementWorkload* const& self) 
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 1454 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   tenant(self->chooseTenantName()),
															#line 1455 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   lockState((TenantAPI::TenantLockState)deterministicRandom()->randomInt(0, 3))
															#line 12137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("lockTenant", reinterpret_cast<unsigned long>(this));

	}
	~LockTenantActorState() 
	{
		fdb_probe_actor_destroy("lockTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1457 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			auto itr = self->createdTenants.find(tenant);
															#line 1458 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			exists = itr != self->createdTenants.end();
															#line 1459 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			lockId = exists && itr->second->lockId.present() && deterministicRandom()->coinflip() ? itr->second->lockId.get() : deterministicRandom()->randomUniqueID();
															#line 12156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			try {
															#line 1464 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				;
															#line 12160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LockTenantActorState();
		static_cast<LockTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1536 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<LockTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LockTenantActorState(); static_cast<LockTenantActor*>(this)->destroy(); return 0; }
															#line 12189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<LockTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LockTenantActorState();
		static_cast<LockTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1514 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_tenant_not_found)
															#line 12202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1515 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(!exists);
															#line 1516 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!static_cast<LockTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LockTenantActorState(); static_cast<LockTenantActor*>(this)->destroy(); return 0; }
															#line 12208 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				new (&static_cast<LockTenantActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~LockTenantActorState();
				static_cast<LockTenantActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 1517 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (e.code() == error_code_invalid_metacluster_operation)
															#line 12218 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1518 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(!self->metaclusterCreated);
															#line 1519 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<LockTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LockTenantActorState(); static_cast<LockTenantActor*>(this)->destroy(); return 0; }
															#line 12224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<LockTenantActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~LockTenantActorState();
					static_cast<LockTenantActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 1520 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (e.code() == error_code_tenant_locked)
															#line 12234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 1521 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(exists);
															#line 1522 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						auto tenantData = self->createdTenants.find(tenant);
															#line 1523 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(tenantData != self->createdTenants.end());
															#line 1524 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(tenantData->second->lockId.present() && lockId != tenantData->second->lockId.get());
															#line 1525 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (!static_cast<LockTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LockTenantActorState(); static_cast<LockTenantActor*>(this)->destroy(); return 0; }
															#line 12246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						new (&static_cast<LockTenantActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~LockTenantActorState();
						static_cast<LockTenantActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
															#line 1528 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			TraceEvent(SevError, "LockTenantFailure") .error(e) .detail("TenantName", tenant) .detail("LockState", TenantAPI::tenantLockStateToString(lockState)) .detail("LockId", lockId);
															#line 1533 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 12258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1490 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 1491 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(exists);
															#line 1492 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto tenantData = self->createdTenants.find(tenant);
															#line 1493 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(tenantData != self->createdTenants.end());
															#line 1495 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!tenantData->second->lockId.present() || lockId == tenantData->second->lockId.get());
															#line 1497 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto& dataDb = self->dataDbs[tenantData->second->cluster];
															#line 1498 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(dataDb->registered);
															#line 1500 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (lockState == tenantData->second->lockState)
															#line 12287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1501 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(self->isValidVersion());
															#line 12291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		else
		{
															#line 1503 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(self->isValidVersion(dataDb));
															#line 12297 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1506 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (lockState == TenantAPI::TenantLockState::UNLOCKED)
															#line 12301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1507 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantData->second->lockId = {};
															#line 12305 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		else
		{
															#line 1509 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantData->second->lockId = lockId;
															#line 12311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1512 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		tenantData->second->lockState = lockState;
															#line 12315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1465 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		Future<Void> lockFuture = metacluster::changeTenantLockState(self->managementDb, tenant, lockState, lockId);
															#line 12331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		try {
															#line 1468 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Optional<Void>> __when_expr_0 = timeout(lockFuture, deterministicRandom()->randomInt(1, 30));
															#line 1468 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<LockTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LockTenantActor*>(this)->actor_wait_state = 1;
															#line 1468 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LockTenantActor, 0, Optional<Void> >*>(static_cast<LockTenantActor*>(this)));
															#line 12342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			error = e;
															#line 1475 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_unsupported_metacluster_version)
															#line 12379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1476 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!self->isValidVersion())
															#line 12383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1477 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<LockTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LockTenantActorState(); static_cast<LockTenantActor*>(this)->destroy(); return 0; }
															#line 12387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<LockTenantActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~LockTenantActorState();
					static_cast<LockTenantActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 1479 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					auto tenantItr = self->createdTenants.find(tenant);
															#line 1480 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(tenantItr != self->createdTenants.end());
															#line 1481 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_1 = self->checkAndResetMetaclusterVersion(tenantItr->second->cluster);
															#line 1481 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (static_cast<LockTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
					static_cast<LockTenantActor*>(this)->actor_wait_state = 2;
															#line 1481 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LockTenantActor, 1, Void >*>(static_cast<LockTenantActor*>(this)));
															#line 12408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Void> const& result,int loopDepth) 
	{
															#line 1470 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 12429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Void> && result,int loopDepth) 
	{
															#line 1470 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 12441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LockTenantActor*>(this)->actor_wait_state > 0) static_cast<LockTenantActor*>(this)->actor_wait_state = 0;
		static_cast<LockTenantActor*>(this)->ActorCallback< LockTenantActor, 0, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< LockTenantActor, 0, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("lockTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LockTenantActor, 0, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("lockTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LockTenantActor, 0, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("lockTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 1486 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		return a_body1Catch2(error, std::max(0, loopDepth - 1));
															#line 12541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LockTenantActor*>(this)->actor_wait_state > 0) static_cast<LockTenantActor*>(this)->actor_wait_state = 0;
		static_cast<LockTenantActor*>(this)->ActorCallback< LockTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LockTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LockTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LockTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LockTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LockTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 1454 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	TenantName tenant;
															#line 1455 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	TenantAPI::TenantLockState lockState;
															#line 1458 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool exists;
															#line 1459 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	UID lockId;
															#line 1474 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Error error;
															#line 12657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via lockTenant()
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class LockTenantActor final : public Actor<Void>, public ActorCallback< LockTenantActor, 0, Optional<Void> >, public ActorCallback< LockTenantActor, 1, Void >, public FastAllocated<LockTenantActor>, public LockTenantActorState<LockTenantActor> {
															#line 12662 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<LockTenantActor>::operator new;
	using FastAllocated<LockTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9634882730746633472UL, 6253854344226891776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LockTenantActor, 0, Optional<Void> >;
friend struct ActorCallback< LockTenantActor, 1, Void >;
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	LockTenantActor(MetaclusterManagementWorkload* const& self) 
															#line 12680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   LockTenantActorState<LockTenantActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lockTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2654358048017238528UL, 4818237803466714112UL);
		ActorExecutionContextHelper __helper(static_cast<LockTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lockTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lockTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LockTenantActor, 0, Optional<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LockTenantActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> lockTenant( MetaclusterManagementWorkload* const& self ) {
															#line 1453 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new LockTenantActor(self));
															#line 12713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 1538 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 12718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via renameTenant()
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class RenameTenantActor>
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class RenameTenantActorState {
															#line 12724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	RenameTenantActorState(MetaclusterManagementWorkload* const& self) 
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 1540 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   tenant(self->chooseTenantName()),
															#line 1541 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   newTenantName(self->chooseTenantName())
															#line 12735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("renameTenant", reinterpret_cast<unsigned long>(this));

	}
	~RenameTenantActorState() 
	{
		fdb_probe_actor_destroy("renameTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1543 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			auto itr = self->createdTenants.find(tenant);
															#line 1544 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			exists = itr != self->createdTenants.end();
															#line 1546 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			itr = self->createdTenants.find(newTenantName);
															#line 1547 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			newTenantExists = itr != self->createdTenants.end();
															#line 12756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			try {
															#line 1550 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				retried = false;
															#line 1551 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				;
															#line 12762 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1641 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 12791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1623 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_tenant_not_found)
															#line 12804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1624 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(!exists);
															#line 1625 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 12810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RenameTenantActorState();
				static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 1626 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (e.code() == error_code_tenant_already_exists)
															#line 12820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1627 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					ASSERT(newTenantExists);
															#line 1628 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 12826 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~RenameTenantActorState();
					static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 1629 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (e.code() == error_code_invalid_metacluster_operation)
															#line 12836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 1630 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(!self->metaclusterCreated);
															#line 1631 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 12842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~RenameTenantActorState();
						static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
															#line 1634 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			TraceEvent(SevError, "RenameTenantFailure") .error(e) .detail("OldTenantName", tenant) .detail("NewTenantName", newTenantName);
															#line 1638 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(false);
															#line 12854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1582 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = verifyListFilter(self, newTenantName, "renameTenantNew");
															#line 1582 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12871 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 4;
															#line 1582 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 3, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 12876 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1553 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			Future<Void> renameFuture = metacluster::renameTenant(self->managementDb, tenant, newTenantName);
															#line 1554 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Optional<Void>> __when_expr_0 = timeout(renameFuture, deterministicRandom()->randomInt(1, 30));
															#line 1554 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RenameTenantActor*>(this)->actor_wait_state = 1;
															#line 1554 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 0, Optional<Void> >*>(static_cast<RenameTenantActor*>(this)));
															#line 12902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1563 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			error = e;
															#line 1565 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (e.code() == error_code_tenant_not_found && exists && !newTenantExists && retried)
															#line 12939 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 1567 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (e.code() == error_code_unsupported_metacluster_version)
															#line 12947 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1568 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (!self->isValidVersion())
															#line 12951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 1569 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 12955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~RenameTenantActorState();
						static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
					else
					{
															#line 1571 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						auto tenantItr = self->createdTenants.find(tenant);
															#line 1572 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						ASSERT(tenantItr != self->createdTenants.end());
															#line 1573 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_2 = self->checkAndResetMetaclusterVersion(tenantItr->second->cluster);
															#line 1573 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
						static_cast<RenameTenantActor*>(this)->actor_wait_state = 3;
															#line 1573 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 2, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 12976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						loopDepth = 0;
					}
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont3(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Void> const& result,int loopDepth) 
	{
															#line 1556 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 12998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1560 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		retried = true;
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = verifyListFilter(self, tenant, "renameTenant");
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 2;
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 1, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 13013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Void> && result,int loopDepth) 
	{
															#line 1556 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (result.present())
															#line 13022 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1560 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		retried = true;
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = verifyListFilter(self, tenant, "renameTenant");
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 2;
															#line 1561 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 1, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 13037 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 0, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 0, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 0, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 0, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 1578 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		return a_body1Catch2(error, std::max(0, loopDepth - 1));
															#line 13221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1584 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 1585 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(exists);
															#line 1586 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!newTenantExists);
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Optional<metacluster::MetaclusterTenantMapEntry>> __when_expr_4 = metacluster::tryGetTenant(self->managementDb, tenant);
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 5;
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*>(static_cast<RenameTenantActor*>(this)));
															#line 13335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1584 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->metaclusterCreated);
															#line 1585 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(exists);
															#line 1586 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!newTenantExists);
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Optional<metacluster::MetaclusterTenantMapEntry>> __when_expr_4 = metacluster::tryGetTenant(self->managementDb, tenant);
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 5;
															#line 1588 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*>(static_cast<RenameTenantActor*>(this)));
															#line 13357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont4(Optional<metacluster::MetaclusterTenantMapEntry> const& oldEntry,int loopDepth) 
	{
															#line 1590 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!oldEntry.present());
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<metacluster::MetaclusterTenantMapEntry> __when_expr_5 = metacluster::getTenant(self->managementDb, newTenantName);
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont4when1(__when_expr_5.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 6;
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 5, metacluster::MetaclusterTenantMapEntry >*>(static_cast<RenameTenantActor*>(this)));
															#line 13450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Optional<metacluster::MetaclusterTenantMapEntry> && oldEntry,int loopDepth) 
	{
															#line 1590 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!oldEntry.present());
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<metacluster::MetaclusterTenantMapEntry> __when_expr_5 = metacluster::getTenant(self->managementDb, newTenantName);
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 13463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont4when1(__when_expr_5.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 6;
															#line 1592 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 5, metacluster::MetaclusterTenantMapEntry >*>(static_cast<RenameTenantActor*>(this)));
															#line 13468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Optional<metacluster::MetaclusterTenantMapEntry> const& oldEntry,int loopDepth) 
	{
		loopDepth = a_body1cont4(oldEntry, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Optional<metacluster::MetaclusterTenantMapEntry> && oldEntry,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(oldEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*,Optional<metacluster::MetaclusterTenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont5(metacluster::MetaclusterTenantMapEntry const& newEntry,int loopDepth) 
	{
															#line 1595 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto tenantDataItr = self->createdTenants.find(tenant);
															#line 1596 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(tenantDataItr != self->createdTenants.end());
															#line 1598 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		Reference<TenantTestData> tenantData = tenantDataItr->second;
															#line 1599 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(tenantData->tenantGroup == newEntry.tenantGroup);
															#line 1600 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(tenantData->cluster == newEntry.assignedCluster);
															#line 1602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->createdTenants[newTenantName] = tenantData;
															#line 1603 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->createdTenants.erase(tenantDataItr);
															#line 1605 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto& dataDb = self->dataDbs[newEntry.assignedCluster];
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(dataDb->registered);
															#line 1607 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion(dataDb));
															#line 1609 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->tenants.erase(tenant);
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->tenants[newTenantName] = tenantData;
															#line 1612 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (newEntry.tenantGroup.present())
															#line 13576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1613 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			auto& tenantGroup = self->tenantGroups[newEntry.tenantGroup.get()];
															#line 1614 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantGroup->tenants.erase(tenant);
															#line 1615 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantGroup->tenants.insert(newTenantName);
															#line 13584 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		else
		{
															#line 1617 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->ungroupedTenants.erase(tenant);
															#line 1618 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->ungroupedTenants.insert(newTenantName);
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->ungroupedTenants.erase(tenant);
															#line 1620 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->ungroupedTenants.insert(newTenantName);
															#line 13596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(metacluster::MetaclusterTenantMapEntry && newEntry,int loopDepth) 
	{
															#line 1595 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto tenantDataItr = self->createdTenants.find(tenant);
															#line 1596 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(tenantDataItr != self->createdTenants.end());
															#line 1598 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		Reference<TenantTestData> tenantData = tenantDataItr->second;
															#line 1599 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(tenantData->tenantGroup == newEntry.tenantGroup);
															#line 1600 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(tenantData->cluster == newEntry.assignedCluster);
															#line 1602 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->createdTenants[newTenantName] = tenantData;
															#line 1603 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		self->createdTenants.erase(tenantDataItr);
															#line 1605 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto& dataDb = self->dataDbs[newEntry.assignedCluster];
															#line 1606 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(dataDb->registered);
															#line 1607 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(self->isValidVersion(dataDb));
															#line 1609 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->tenants.erase(tenant);
															#line 1610 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDb->tenants[newTenantName] = tenantData;
															#line 1612 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (newEntry.tenantGroup.present())
															#line 13630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1613 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			auto& tenantGroup = self->tenantGroups[newEntry.tenantGroup.get()];
															#line 1614 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantGroup->tenants.erase(tenant);
															#line 1615 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tenantGroup->tenants.insert(newTenantName);
															#line 13638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		else
		{
															#line 1617 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->ungroupedTenants.erase(tenant);
															#line 1618 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataDb->ungroupedTenants.insert(newTenantName);
															#line 1619 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->ungroupedTenants.erase(tenant);
															#line 1620 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			self->ungroupedTenants.insert(newTenantName);
															#line 13650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(metacluster::MetaclusterTenantMapEntry const& newEntry,int loopDepth) 
	{
		loopDepth = a_body1cont5(newEntry, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(metacluster::MetaclusterTenantMapEntry && newEntry,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(newEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 5, metacluster::MetaclusterTenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 5, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 5, metacluster::MetaclusterTenantMapEntry >*,metacluster::MetaclusterTenantMapEntry && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 5, metacluster::MetaclusterTenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 1540 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	TenantName tenant;
															#line 1541 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	TenantName newTenantName;
															#line 1544 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool exists;
															#line 1547 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool newTenantExists;
															#line 1550 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool retried;
															#line 1563 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Error error;
															#line 13758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via renameTenant()
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class RenameTenantActor final : public Actor<Void>, public ActorCallback< RenameTenantActor, 0, Optional<Void> >, public ActorCallback< RenameTenantActor, 1, Void >, public ActorCallback< RenameTenantActor, 2, Void >, public ActorCallback< RenameTenantActor, 3, Void >, public ActorCallback< RenameTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >, public ActorCallback< RenameTenantActor, 5, metacluster::MetaclusterTenantMapEntry >, public FastAllocated<RenameTenantActor>, public RenameTenantActorState<RenameTenantActor> {
															#line 13763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<RenameTenantActor>::operator new;
	using FastAllocated<RenameTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6814733686828939264UL, 15543814071591297536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RenameTenantActor, 0, Optional<Void> >;
friend struct ActorCallback< RenameTenantActor, 1, Void >;
friend struct ActorCallback< RenameTenantActor, 2, Void >;
friend struct ActorCallback< RenameTenantActor, 3, Void >;
friend struct ActorCallback< RenameTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >;
friend struct ActorCallback< RenameTenantActor, 5, metacluster::MetaclusterTenantMapEntry >;
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	RenameTenantActor(MetaclusterManagementWorkload* const& self) 
															#line 13785 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RenameTenantActorState<RenameTenantActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(972264867922354944UL, 1896563828629082368UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("renameTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RenameTenantActor, 0, Optional<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RenameTenantActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RenameTenantActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RenameTenantActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RenameTenantActor, 4, Optional<metacluster::MetaclusterTenantMapEntry> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RenameTenantActor, 5, metacluster::MetaclusterTenantMapEntry >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> renameTenant( MetaclusterManagementWorkload* const& self ) {
															#line 1539 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new RenameTenantActor(self));
															#line 13822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 1643 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 13827 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via changeClusterVersion()
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class ChangeClusterVersionActor>
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class ChangeClusterVersionActorState {
															#line 13833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ChangeClusterVersionActorState(MetaclusterManagementWorkload* const& self) 
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 1645 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   newVersion((MetaclusterVersion)deterministicRandom()->randomInt( (int)MetaclusterVersion::BEGIN, (int)MetaclusterVersion::END + 1))
															#line 13842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("changeClusterVersion", reinterpret_cast<unsigned long>(this));

	}
	~ChangeClusterVersionActorState() 
	{
		fdb_probe_actor_destroy("changeClusterVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1648 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 13857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1649 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (self->metaclusterCreated)
															#line 13861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1650 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					self->managementVersion = newVersion;
															#line 1651 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_0 = self->setMetaclusterVersion(self->managementDb, self->managementVersion);
															#line 1651 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (static_cast<ChangeClusterVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13869 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<ChangeClusterVersionActor*>(this)->actor_wait_state = 1;
															#line 1651 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeClusterVersionActor, 0, Void >*>(static_cast<ChangeClusterVersionActor*>(this)));
															#line 13874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
															#line 1655 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ClusterName clusterName = self->chooseClusterName();
															#line 1656 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				auto& dataDb = self->dataDbs[clusterName];
															#line 1657 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (dataDb->registered)
															#line 13890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1658 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					dataDb->version = newVersion;
															#line 1659 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_2 = self->setMetaclusterVersion(dataDb->db.getReference(), dataDb->version);
															#line 1659 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (static_cast<ChangeClusterVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when2(__when_expr_2.get(), loopDepth); };
					static_cast<ChangeClusterVersionActor*>(this)->actor_wait_state = 3;
															#line 1659 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeClusterVersionActor, 2, Void >*>(static_cast<ChangeClusterVersionActor*>(this)));
															#line 13903 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont5(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeClusterVersionActorState();
		static_cast<ChangeClusterVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1663 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<ChangeClusterVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeClusterVersionActorState(); static_cast<ChangeClusterVersionActor*>(this)->destroy(); return 0; }
															#line 13932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<ChangeClusterVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeClusterVersionActorState();
		static_cast<ChangeClusterVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1652 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForFullyRecovered(self);
															#line 1652 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<ChangeClusterVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeClusterVersionActor*>(this)->actor_wait_state = 2;
															#line 1652 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeClusterVersionActor, 1, Void >*>(static_cast<ChangeClusterVersionActor*>(this)));
															#line 13957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1652 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForFullyRecovered(self);
															#line 1652 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<ChangeClusterVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13968 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeClusterVersionActor*>(this)->actor_wait_state = 2;
															#line 1652 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeClusterVersionActor, 1, Void >*>(static_cast<ChangeClusterVersionActor*>(this)));
															#line 13973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeClusterVersionActor*>(this)->actor_wait_state > 0) static_cast<ChangeClusterVersionActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeClusterVersionActor*>(this)->ActorCallback< ChangeClusterVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeClusterVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeClusterVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeClusterVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeClusterVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeClusterVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeClusterVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeClusterVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeClusterVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeClusterVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeClusterVersionActor*>(this)->actor_wait_state > 0) static_cast<ChangeClusterVersionActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeClusterVersionActor*>(this)->ActorCallback< ChangeClusterVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeClusterVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeClusterVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeClusterVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeClusterVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeClusterVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeClusterVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeClusterVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeClusterVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeClusterVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangeClusterVersionActor*>(this)->actor_wait_state > 0) static_cast<ChangeClusterVersionActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeClusterVersionActor*>(this)->ActorCallback< ChangeClusterVersionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeClusterVersionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeClusterVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeClusterVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangeClusterVersionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeClusterVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeClusterVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangeClusterVersionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeClusterVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeClusterVersion", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 1645 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterVersion newVersion;
															#line 14237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via changeClusterVersion()
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class ChangeClusterVersionActor final : public Actor<Void>, public ActorCallback< ChangeClusterVersionActor, 0, Void >, public ActorCallback< ChangeClusterVersionActor, 1, Void >, public ActorCallback< ChangeClusterVersionActor, 2, Void >, public FastAllocated<ChangeClusterVersionActor>, public ChangeClusterVersionActorState<ChangeClusterVersionActor> {
															#line 14242 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<ChangeClusterVersionActor>::operator new;
	using FastAllocated<ChangeClusterVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4367500421406062336UL, 15309339894603262208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeClusterVersionActor, 0, Void >;
friend struct ActorCallback< ChangeClusterVersionActor, 1, Void >;
friend struct ActorCallback< ChangeClusterVersionActor, 2, Void >;
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ChangeClusterVersionActor(MetaclusterManagementWorkload* const& self) 
															#line 14261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeClusterVersionActorState<ChangeClusterVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeClusterVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5122342391732220672UL, 15290517130722984448UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeClusterVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeClusterVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeClusterVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeClusterVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeClusterVersionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangeClusterVersionActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> changeClusterVersion( MetaclusterManagementWorkload* const& self ) {
															#line 1644 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new ChangeClusterVersionActor(self));
															#line 14295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 1665 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId == 0) {
			return _start(cx, this);
		} else {
			return Void();
		}
	}
																#line 14307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class _startActor>
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class _startActorState {
															#line 14313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	_startActorState(Database const& cx,MetaclusterManagementWorkload* const& self) 
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : cx(cx),
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   self(self),
															#line 1674 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   start(now())
															#line 14324 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1677 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			;
															#line 14339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1710 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 14362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1677 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!(now() < start + self->testDuration))
															#line 14381 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1678 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		operation = deterministicRandom()->randomInt(0, 14);
															#line 1679 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (operation == 0)
															#line 14389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1680 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = createMetacluster(self);
															#line 1680 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 1680 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 14400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1681 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (operation == 1)
															#line 14407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1682 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_1 = decommissionMetacluster(self);
															#line 1682 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 1682 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 14418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1683 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (operation == 2)
															#line 14425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1684 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_2 = registerCluster(self);
															#line 1684 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 1684 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 14436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 1685 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					if (operation == 3)
															#line 14443 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
					{
															#line 1686 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_3 = removeCluster(self);
															#line 1686 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14449 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
						static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 1686 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 14454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 1687 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
						if (operation == 4)
															#line 14461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
						{
															#line 1688 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							StrictFuture<Void> __when_expr_4 = listClusters(self);
															#line 1688 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
							if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.get(), loopDepth); };
							static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 1688 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 14472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 1689 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
							if (operation == 5)
															#line 14479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
							{
															#line 1690 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
								StrictFuture<Void> __when_expr_5 = getCluster(self);
															#line 1690 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
								if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14485 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
								if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when6(__when_expr_5.get(), loopDepth); };
								static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 1690 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
								__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 14490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
								loopDepth = 0;
							}
							else
							{
															#line 1691 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
								if (operation == 6)
															#line 14497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
								{
															#line 1692 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
									StrictFuture<Void> __when_expr_6 = configureCluster(self);
															#line 1692 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
									if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
									if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when7(__when_expr_6.get(), loopDepth); };
									static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 1692 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
									__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 14508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
									loopDepth = 0;
								}
								else
								{
															#line 1693 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
									if (operation == 7)
															#line 14515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
									{
															#line 1694 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
										StrictFuture<Void> __when_expr_7 = restoreCluster(self);
															#line 1694 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
										if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14521 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
										if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when8(__when_expr_7.get(), loopDepth); };
										static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 1694 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
										__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 14526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
										loopDepth = 0;
									}
									else
									{
															#line 1695 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
										if (operation == 8)
															#line 14533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
										{
															#line 1696 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
											StrictFuture<Void> __when_expr_8 = createTenant(self);
															#line 1696 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
											if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
											if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when9(__when_expr_8.get(), loopDepth); };
											static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 1696 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
											__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 14544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
											loopDepth = 0;
										}
										else
										{
															#line 1697 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
											if (operation == 9)
															#line 14551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
											{
															#line 1698 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
												StrictFuture<Void> __when_expr_9 = deleteTenant(self);
															#line 1698 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
												if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
												if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when10(__when_expr_9.get(), loopDepth); };
												static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 1698 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
												__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 14562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
												loopDepth = 0;
											}
											else
											{
															#line 1699 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
												if (operation == 10)
															#line 14569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
												{
															#line 1700 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
													StrictFuture<Void> __when_expr_10 = configureTenant(self);
															#line 1700 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
													if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
													if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when11(__when_expr_10.get(), loopDepth); };
													static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 1700 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
													__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 14580 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
													loopDepth = 0;
												}
												else
												{
															#line 1701 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
													if (operation == 11)
															#line 14587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
													{
															#line 1702 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
														StrictFuture<Void> __when_expr_11 = lockTenant(self);
															#line 1702 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
														if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
														if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when12(__when_expr_11.get(), loopDepth); };
														static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 1702 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
														__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 14598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
														loopDepth = 0;
													}
													else
													{
															#line 1703 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
														if (operation == 12)
															#line 14605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
														{
															#line 1704 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															StrictFuture<Void> __when_expr_12 = renameTenant(self);
															#line 1704 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
															if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when13(__when_expr_12.get(), loopDepth); };
															static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 1704 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 14616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
															loopDepth = 0;
														}
														else
														{
															#line 1705 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															if (operation == 13)
															#line 14623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
															{
															#line 1706 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
																StrictFuture<Void> __when_expr_13 = changeClusterVersion(self);
															#line 1706 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
																if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
																if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when14(__when_expr_13.get(), loopDepth); };
																static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 1706 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
																__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 14634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
																loopDepth = 0;
															}
															else
															{
																loopDepth = a_body1loopBody1cont28(loopDepth);
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont14(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont15(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont15(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont16(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont17(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont17(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont18(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1cont20(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont21(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont21(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont21(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont21(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1when10(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1cont22(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont23(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont23(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont23(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont23(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1when11(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1when11(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1loopBody1cont24(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont22(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont25(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont25(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont25(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont25(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1when12(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1when12(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1loopBody1cont26(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont24(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont27(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont26(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont27(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont26(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont27(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont27(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1when13(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1loopBody1when13(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1loopBody1cont28(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont26(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont29(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont29(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont28(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont29(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont29(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1loopBody1when14(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1loopBody1when14(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Database cx;
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 1674 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	double start;
															#line 1678 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	int operation;
															#line 15980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, Void >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, Void >, public ActorCallback< _startActor, 12, Void >, public ActorCallback< _startActor, 13, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 15985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5282090875268671488UL, 6163940386485590016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, Void >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, Void >;
friend struct ActorCallback< _startActor, 12, Void >;
friend struct ActorCallback< _startActor, 13, Void >;
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	_startActor(Database const& cx,MetaclusterManagementWorkload* const& self) 
															#line 16015 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, MetaclusterManagementWorkload* const& self ) {
															#line 1673 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 16060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 1712 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

	// Checks that the data cluster state matches our local state
																#line 16066 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via checkDataCluster()
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class CheckDataClusterActor>
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class CheckDataClusterActorState {
															#line 16072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	CheckDataClusterActorState(MetaclusterManagementWorkload* const& self,ClusterName const& clusterName,Reference<DataClusterData> const& clusterData) 
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   clusterName(clusterName),
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   clusterData(clusterData),
															#line 1717 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   metaclusterRegistration(),
															#line 1718 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   tenants(),
															#line 1719 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   tr(clusterData->db->createTransaction())
															#line 16089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("checkDataCluster", reinterpret_cast<unsigned long>(this));

	}
	~CheckDataClusterActorState() 
	{
		fdb_probe_actor_destroy("checkDataCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1721 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			;
															#line 16104 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckDataClusterActorState();
		static_cast<CheckDataClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1734 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (clusterData->registered)
															#line 16127 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1735 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(metaclusterRegistration.present() && metaclusterRegistration.get().clusterType == ClusterType::METACLUSTER_DATA);
															#line 16131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
		else
		{
															#line 1738 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(!metaclusterRegistration.present());
															#line 16137 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1741 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT_EQ(tenants.size(), clusterData->tenants.size());
															#line 1742 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for( auto [tenantName, tenantEntry] : tenants ) {
															#line 1743 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(clusterData->tenants.contains(tenantName));
															#line 1744 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			auto tenantData = clusterData->tenants.find(tenantName);
															#line 1745 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(tenantData != clusterData->tenants.end());
															#line 1746 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(tenantData->second->cluster == clusterName);
															#line 1747 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			ASSERT(tenantData->second->tenantGroup == tenantEntry.tenantGroup);
															#line 1749 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (!clusterData->detached)
															#line 16155 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1750 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				auto itr = self->createdTenants.find(tenantName);
															#line 1751 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(itr != self->createdTenants.end());
															#line 1752 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(itr->second == tenantData->second);
															#line 16163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
		}
															#line 1756 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<CheckDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataClusterActorState(); static_cast<CheckDataClusterActor*>(this)->destroy(); return 0; }
															#line 16168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<CheckDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckDataClusterActorState();
		static_cast<CheckDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1723 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1724 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(metaclusterRegistration, metacluster::metadata::metaclusterRegistration().get(tr)) && store(tenants, TenantAPI::listTenantMetadataTransaction( tr, ""_sr, "\xff\xff"_sr, clusterData->tenants.size() + 1));
															#line 1724 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<CheckDataClusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16192 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckDataClusterActor*>(this)->actor_wait_state = 1;
															#line 1724 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckDataClusterActor, 0, Void >*>(static_cast<CheckDataClusterActor*>(this)));
															#line 16197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1730 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 1730 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<CheckDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16234 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckDataClusterActor*>(this)->actor_wait_state = 2;
															#line 1730 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckDataClusterActor, 1, Void >*>(static_cast<CheckDataClusterActor*>(this)));
															#line 16239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckDataClusterActor*>(this)->actor_wait_state > 0) static_cast<CheckDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataClusterActor*>(this)->ActorCallback< CheckDataClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckDataClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckDataClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckDataClusterActor*>(this)->actor_wait_state > 0) static_cast<CheckDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataClusterActor*>(this)->ActorCallback< CheckDataClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckDataClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckDataClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	ClusterName clusterName;
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Reference<DataClusterData> clusterData;
															#line 1717 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Optional<MetaclusterRegistrationEntry> metaclusterRegistration;
															#line 1718 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	std::vector<std::pair<TenantName, TenantMapEntry>> tenants;
															#line 1719 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 16436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via checkDataCluster()
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class CheckDataClusterActor final : public Actor<Void>, public ActorCallback< CheckDataClusterActor, 0, Void >, public ActorCallback< CheckDataClusterActor, 1, Void >, public FastAllocated<CheckDataClusterActor>, public CheckDataClusterActorState<CheckDataClusterActor> {
															#line 16441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<CheckDataClusterActor>::operator new;
	using FastAllocated<CheckDataClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16761247001495314176UL, 10055033666830546176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckDataClusterActor, 0, Void >;
friend struct ActorCallback< CheckDataClusterActor, 1, Void >;
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	CheckDataClusterActor(MetaclusterManagementWorkload* const& self,ClusterName const& clusterName,Reference<DataClusterData> const& clusterData) 
															#line 16459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   CheckDataClusterActorState<CheckDataClusterActor>(self, clusterName, clusterData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkDataCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7796995959147916032UL, 12232873414231258624UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkDataCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkDataCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckDataClusterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckDataClusterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> checkDataCluster( MetaclusterManagementWorkload* const& self, ClusterName const& clusterName, Reference<DataClusterData> const& clusterData ) {
															#line 1714 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new CheckDataClusterActor(self, clusterName, clusterData));
															#line 16492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 1758 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

																#line 16497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via teardownMetacluster()
															#line 1759 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class TeardownMetaclusterActor>
															#line 1759 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class TeardownMetaclusterActorState {
															#line 16503 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 1759 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	TeardownMetaclusterActorState(MetaclusterManagementWorkload* const& self) 
															#line 1759 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 1759 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self),
															#line 1760 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   tr(self->managementDb->createTransaction()),
															#line 1762 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		   deleteTenants(deterministicRandom()->coinflip())
															#line 16514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("teardownMetacluster", reinterpret_cast<unsigned long>(this));

	}
	~TeardownMetaclusterActorState() 
	{
		fdb_probe_actor_destroy("teardownMetacluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1764 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (deleteTenants)
															#line 16529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1765 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				StrictFuture<std::vector<std::pair<TenantName, int64_t>>> __when_expr_0 = metacluster::listTenants(self->managementDb, ""_sr, "\xff\xff"_sr, 10e6);
															#line 1765 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state = 1;
															#line 1765 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TeardownMetaclusterActor, 0, std::vector<std::pair<TenantName, int64_t>> >*>(static_cast<TeardownMetaclusterActor*>(this)));
															#line 16540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TeardownMetaclusterActorState();
		static_cast<TeardownMetaclusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1776 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<std::map<ClusterName, metacluster::DataClusterMetadata>> __when_expr_2 = metacluster::listClusters(self->managementDb, ""_sr, "\xff\xff"_sr, CLIENT_KNOBS->MAX_DATA_CLUSTERS);
															#line 1776 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state = 3;
															#line 1776 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TeardownMetaclusterActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >*>(static_cast<TeardownMetaclusterActor*>(this)));
															#line 16575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1768 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		deleteTenantFutures = std::vector<Future<Void>>();
															#line 1769 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for( auto [tenantName, tid] : tenants ) {
															#line 1770 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			deleteTenantFutures.push_back(metacluster::deleteTenant(self->managementDb, tenantName));
															#line 16588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1773 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(deleteTenantFutures);
															#line 1773 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state = 2;
															#line 1773 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TeardownMetaclusterActor, 1, Void >*>(static_cast<TeardownMetaclusterActor*>(this)));
															#line 16599 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<TenantName, int64_t>> const& __tenants,int loopDepth) 
	{
															#line 1765 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		tenants = __tenants;
															#line 16608 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<TenantName, int64_t>> && __tenants,int loopDepth) 
	{
		tenants = std::move(__tenants);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<TeardownMetaclusterActor*>(this)->ActorCallback< TeardownMetaclusterActor, 0, std::vector<std::pair<TenantName, int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< TeardownMetaclusterActor, 0, std::vector<std::pair<TenantName, int64_t>> >*,std::vector<std::pair<TenantName, int64_t>> const& value) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TeardownMetaclusterActor, 0, std::vector<std::pair<TenantName, int64_t>> >*,std::vector<std::pair<TenantName, int64_t>> && value) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TeardownMetaclusterActor, 0, std::vector<std::pair<TenantName, int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<TeardownMetaclusterActor*>(this)->ActorCallback< TeardownMetaclusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TeardownMetaclusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TeardownMetaclusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TeardownMetaclusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1779 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		std::vector<Future<Void>> removeClusterFutures;
															#line 1780 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for( auto [clusterName, clusterMetadata] : dataClusters ) {
															#line 1781 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			removeClusterFutures.push_back( success(metacluster::removeCluster(self->managementDb, clusterName, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove(!deleteTenants))));
															#line 16778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1788 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(removeClusterFutures);
															#line 1788 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state = 4;
															#line 1788 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TeardownMetaclusterActor, 3, Void >*>(static_cast<TeardownMetaclusterActor*>(this)));
															#line 16789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::map<ClusterName, metacluster::DataClusterMetadata> const& __dataClusters,int loopDepth) 
	{
															#line 1776 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataClusters = __dataClusters;
															#line 16798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::map<ClusterName, metacluster::DataClusterMetadata> && __dataClusters,int loopDepth) 
	{
		dataClusters = std::move(__dataClusters);
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<TeardownMetaclusterActor*>(this)->ActorCallback< TeardownMetaclusterActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< TeardownMetaclusterActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >*,std::map<ClusterName, metacluster::DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TeardownMetaclusterActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >*,std::map<ClusterName, metacluster::DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TeardownMetaclusterActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1789 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = metacluster::decommissionMetacluster(self->managementDb);
															#line 1789 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state = 5;
															#line 1789 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TeardownMetaclusterActor, 4, Void >*>(static_cast<TeardownMetaclusterActor*>(this)));
															#line 16884 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1789 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = metacluster::decommissionMetacluster(self->managementDb);
															#line 1789 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state = 5;
															#line 1789 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TeardownMetaclusterActor, 4, Void >*>(static_cast<TeardownMetaclusterActor*>(this)));
															#line 16900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<TeardownMetaclusterActor*>(this)->ActorCallback< TeardownMetaclusterActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TeardownMetaclusterActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TeardownMetaclusterActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TeardownMetaclusterActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 1791 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_5 = metacluster::metadata::metaclusterRegistration().get(self->managementDb);
															#line 1791 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16986 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state = 6;
															#line 1791 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TeardownMetaclusterActor, 5, Optional<MetaclusterRegistrationEntry> >*>(static_cast<TeardownMetaclusterActor*>(this)));
															#line 16991 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 1791 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_5 = metacluster::metadata::metaclusterRegistration().get(self->managementDb);
															#line 1791 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17002 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state = 6;
															#line 1791 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TeardownMetaclusterActor, 5, Optional<MetaclusterRegistrationEntry> >*>(static_cast<TeardownMetaclusterActor*>(this)));
															#line 17007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<TeardownMetaclusterActor*>(this)->ActorCallback< TeardownMetaclusterActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TeardownMetaclusterActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TeardownMetaclusterActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TeardownMetaclusterActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont9(Optional<MetaclusterRegistrationEntry> const& entry,int loopDepth) 
	{
															#line 1793 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!entry.present());
															#line 1795 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<TeardownMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TeardownMetaclusterActorState(); static_cast<TeardownMetaclusterActor*>(this)->destroy(); return 0; }
															#line 17093 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<TeardownMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TeardownMetaclusterActorState();
		static_cast<TeardownMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Optional<MetaclusterRegistrationEntry> && entry,int loopDepth) 
	{
															#line 1793 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!entry.present());
															#line 1795 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<TeardownMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TeardownMetaclusterActorState(); static_cast<TeardownMetaclusterActor*>(this)->destroy(); return 0; }
															#line 17107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<TeardownMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TeardownMetaclusterActorState();
		static_cast<TeardownMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8when1(Optional<MetaclusterRegistrationEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont9(entry, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Optional<MetaclusterRegistrationEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<TeardownMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<TeardownMetaclusterActor*>(this)->ActorCallback< TeardownMetaclusterActor, 5, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< TeardownMetaclusterActor, 5, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TeardownMetaclusterActor, 5, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TeardownMetaclusterActor, 5, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1759 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 1760 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	Reference<ITransaction> tr;
															#line 1762 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	bool deleteTenants;
															#line 1765 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	std::vector<std::pair<TenantName, int64_t>> tenants;
															#line 1768 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	std::vector<Future<Void>> deleteTenantFutures;
															#line 1776 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	std::map<ClusterName, metacluster::DataClusterMetadata> dataClusters;
															#line 17202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via teardownMetacluster()
															#line 1759 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class TeardownMetaclusterActor final : public Actor<Void>, public ActorCallback< TeardownMetaclusterActor, 0, std::vector<std::pair<TenantName, int64_t>> >, public ActorCallback< TeardownMetaclusterActor, 1, Void >, public ActorCallback< TeardownMetaclusterActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >, public ActorCallback< TeardownMetaclusterActor, 3, Void >, public ActorCallback< TeardownMetaclusterActor, 4, Void >, public ActorCallback< TeardownMetaclusterActor, 5, Optional<MetaclusterRegistrationEntry> >, public FastAllocated<TeardownMetaclusterActor>, public TeardownMetaclusterActorState<TeardownMetaclusterActor> {
															#line 17207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<TeardownMetaclusterActor>::operator new;
	using FastAllocated<TeardownMetaclusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8822439467885864192UL, 9325302797547223552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TeardownMetaclusterActor, 0, std::vector<std::pair<TenantName, int64_t>> >;
friend struct ActorCallback< TeardownMetaclusterActor, 1, Void >;
friend struct ActorCallback< TeardownMetaclusterActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >;
friend struct ActorCallback< TeardownMetaclusterActor, 3, Void >;
friend struct ActorCallback< TeardownMetaclusterActor, 4, Void >;
friend struct ActorCallback< TeardownMetaclusterActor, 5, Optional<MetaclusterRegistrationEntry> >;
															#line 1759 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	TeardownMetaclusterActor(MetaclusterManagementWorkload* const& self) 
															#line 17229 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   TeardownMetaclusterActorState<TeardownMetaclusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("teardownMetacluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18390422970879430144UL, 4646208038987796992UL);
		ActorExecutionContextHelper __helper(static_cast<TeardownMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("teardownMetacluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("teardownMetacluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TeardownMetaclusterActor, 0, std::vector<std::pair<TenantName, int64_t>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TeardownMetaclusterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TeardownMetaclusterActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TeardownMetaclusterActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TeardownMetaclusterActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TeardownMetaclusterActor, 5, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1759 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<Void> teardownMetacluster( MetaclusterManagementWorkload* const& self ) {
															#line 1759 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<Void>(new TeardownMetaclusterActor(self));
															#line 17266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 1797 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

	Future<bool> check(Database const& cx) override {
		if (clientId == 0) {
			return _check(this);
		} else {
			return true;
		}
	}
																#line 17278 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 1805 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
template <class _checkActor>
															#line 1805 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class _checkActorState {
															#line 17284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
															#line 1805 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	_checkActorState(MetaclusterManagementWorkload* const& self) 
															#line 1805 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
															#line 1805 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		 : self(self)
															#line 17291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1806 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			std::vector<Future<Void>> setVersionFutures;
															#line 1807 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (self->metaclusterCreated)
															#line 17308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1808 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				self->managementVersion = MetaclusterVersion::MAX_SUPPORTED;
															#line 1809 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				setVersionFutures.push_back(self->setMetaclusterVersion(self->managementDb, self->managementVersion));
															#line 17314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 1811 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			for( auto& [name, dataDb] : self->dataDbs ) {
															#line 1812 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				if (dataDb->registered)
															#line 17320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				{
															#line 1813 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					dataDb->version = MetaclusterVersion::MAX_SUPPORTED;
															#line 1814 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
					setVersionFutures.push_back(self->setMetaclusterVersion(dataDb->db.getReference(), dataDb->version));
															#line 17326 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
				}
			}
															#line 1818 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(setVersionFutures);
															#line 1818 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 1818 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Void >*>(static_cast<_checkActor*>(this)));
															#line 17338 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1821 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (self->metaclusterCreated)
															#line 17361 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1822 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			metaclusterConsistencyCheck = metacluster::util::MetaclusterConsistencyCheck<IDatabase>(self->managementDb, metacluster::util::AllowPartialMetaclusterOperations::False);
															#line 1824 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = metaclusterConsistencyCheck.run();
															#line 1824 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 1824 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 17374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1853 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_5 = metacluster::metadata::metaclusterRegistration().get(self->managementDb);
															#line 1853 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1when2(__when_expr_5.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 6;
															#line 1853 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 5, Optional<MetaclusterRegistrationEntry> >*>(static_cast<_checkActor*>(this)));
															#line 17388 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1821 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (self->metaclusterCreated)
															#line 17398 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
															#line 1822 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			metaclusterConsistencyCheck = metacluster::util::MetaclusterConsistencyCheck<IDatabase>(self->managementDb, metacluster::util::AllowPartialMetaclusterOperations::False);
															#line 1824 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = metaclusterConsistencyCheck.run();
															#line 1824 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 1824 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 17411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1853 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_5 = metacluster::metadata::metaclusterRegistration().get(self->managementDb);
															#line 1853 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17420 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1when2(__when_expr_5.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 6;
															#line 1853 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 5, Optional<MetaclusterRegistrationEntry> >*>(static_cast<_checkActor*>(this)));
															#line 17425 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1866 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 17510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1826 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<std::map<ClusterName, metacluster::DataClusterMetadata>> __when_expr_2 = metacluster::listClusters( self->managementDb, ""_sr, "\xff\xff"_sr, CLIENT_KNOBS->MAX_DATA_CLUSTERS + 1);
															#line 1826 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont6when1(__when_expr_2.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 1826 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >*>(static_cast<_checkActor*>(this)));
															#line 17529 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1826 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<std::map<ClusterName, metacluster::DataClusterMetadata>> __when_expr_2 = metacluster::listClusters( self->managementDb, ""_sr, "\xff\xff"_sr, CLIENT_KNOBS->MAX_DATA_CLUSTERS + 1);
															#line 1826 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont6when1(__when_expr_2.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 1826 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >*>(static_cast<_checkActor*>(this)));
															#line 17545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(std::map<ClusterName, metacluster::DataClusterMetadata> const& dataClusters,int loopDepth) 
	{
															#line 1829 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		int totalTenantGroupsAllocated = 0;
															#line 1830 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		std::vector<Future<Void>> dataClusterChecks;
															#line 1831 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for( auto [clusterName, dataClusterData] : self->dataDbs ) {
															#line 1832 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			auto dataClusterItr = dataClusters.find(clusterName);
															#line 1833 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (dataClusterData->registered)
															#line 17637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1834 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(dataClusterItr != dataClusters.end());
															#line 1835 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(dataClusterItr->second.entry.capacity.numTenantGroups == dataClusterData->tenantGroupCapacity);
															#line 1837 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT_EQ(dataClusterItr->second.entry.autoTenantAssignment, dataClusterData->autoTenantAssignment);
															#line 1838 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				totalTenantGroupsAllocated += dataClusterData->tenantGroups.size() + dataClusterData->ungroupedTenants.size();
															#line 17647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
			else
			{
															#line 1841 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(dataClusterItr == dataClusters.end());
															#line 17653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 1844 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataClusterChecks.push_back(checkDataCluster(self, clusterName, dataClusterData));
															#line 17657 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1846 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto capacityNumbers = metacluster::util::metaclusterCapacity(dataClusters);
															#line 1847 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(capacityNumbers.first.numTenantGroups == self->totalTenantGroupCapacity);
															#line 1848 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(capacityNumbers.second.numTenantGroups == totalTenantGroupsAllocated);
															#line 1850 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(dataClusterChecks);
															#line 1850 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17669 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 4;
															#line 1850 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 3, Void >*>(static_cast<_checkActor*>(this)));
															#line 17674 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(std::map<ClusterName, metacluster::DataClusterMetadata> && dataClusters,int loopDepth) 
	{
															#line 1829 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		int totalTenantGroupsAllocated = 0;
															#line 1830 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		std::vector<Future<Void>> dataClusterChecks;
															#line 1831 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		for( auto [clusterName, dataClusterData] : self->dataDbs ) {
															#line 1832 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			auto dataClusterItr = dataClusters.find(clusterName);
															#line 1833 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			if (dataClusterData->registered)
															#line 17691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			{
															#line 1834 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(dataClusterItr != dataClusters.end());
															#line 1835 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(dataClusterItr->second.entry.capacity.numTenantGroups == dataClusterData->tenantGroupCapacity);
															#line 1837 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT_EQ(dataClusterItr->second.entry.autoTenantAssignment, dataClusterData->autoTenantAssignment);
															#line 1838 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				totalTenantGroupsAllocated += dataClusterData->tenantGroups.size() + dataClusterData->ungroupedTenants.size();
															#line 17701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
			else
			{
															#line 1841 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
				ASSERT(dataClusterItr == dataClusters.end());
															#line 17707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
			}
															#line 1844 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
			dataClusterChecks.push_back(checkDataCluster(self, clusterName, dataClusterData));
															#line 17711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		}
															#line 1846 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		auto capacityNumbers = metacluster::util::metaclusterCapacity(dataClusters);
															#line 1847 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(capacityNumbers.first.numTenantGroups == self->totalTenantGroupCapacity);
															#line 1848 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(capacityNumbers.second.numTenantGroups == totalTenantGroupsAllocated);
															#line 1850 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(dataClusterChecks);
															#line 1850 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 4;
															#line 1850 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 3, Void >*>(static_cast<_checkActor*>(this)));
															#line 17728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(std::map<ClusterName, metacluster::DataClusterMetadata> const& dataClusters,int loopDepth) 
	{
		loopDepth = a_body1cont7(dataClusters, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(std::map<ClusterName, metacluster::DataClusterMetadata> && dataClusters,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(dataClusters), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >*,std::map<ClusterName, metacluster::DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >*,std::map<ClusterName, metacluster::DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _checkActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 1851 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = teardownMetacluster(self);
															#line 1851 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17814 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 5;
															#line 1851 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 4, Void >*>(static_cast<_checkActor*>(this)));
															#line 17819 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 1851 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = teardownMetacluster(self);
															#line 1851 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 5;
															#line 1851 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 4, Void >*>(static_cast<_checkActor*>(this)));
															#line 17835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _checkActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _checkActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _checkActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont13(Optional<MetaclusterRegistrationEntry> const& managementRegistration,int loopDepth) 
	{
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!managementRegistration.present());
															#line 1857 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDbItr = std::map<ClusterName, Reference<DataClusterData>>::iterator();
															#line 1858 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDbItr = self->dataDbs.begin();
															#line 18010 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont13loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Optional<MetaclusterRegistrationEntry> && managementRegistration,int loopDepth) 
	{
															#line 1855 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!managementRegistration.present());
															#line 1857 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDbItr = std::map<ClusterName, Reference<DataClusterData>>::iterator();
															#line 1858 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		dataDbItr = self->dataDbs.begin();
															#line 18023 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = a_body1cont13loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Optional<MetaclusterRegistrationEntry> const& managementRegistration,int loopDepth) 
	{
		loopDepth = a_body1cont13(managementRegistration, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Optional<MetaclusterRegistrationEntry> && managementRegistration,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(managementRegistration), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 5, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _checkActor, 5, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _checkActor, 5, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont13cont1(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont13loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont13loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont13loopBody1(int loopDepth) 
	{
															#line 1858 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (!(dataDbItr != self->dataDbs.end()))
															#line 18120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		{
			return a_body1cont13break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1859 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!dataDbItr->second->registered);
															#line 1860 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_6 = metacluster::metadata::metaclusterRegistration().get(dataDbItr->second->db.getReference());
															#line 1860 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 18130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont13loopBody1when1(__when_expr_6.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 7;
															#line 1860 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 6, Optional<MetaclusterRegistrationEntry> >*>(static_cast<_checkActor*>(this)));
															#line 18135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13break1(int loopDepth) 
	{
		try {
			return a_body1cont13cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13loopBody1cont1(Optional<MetaclusterRegistrationEntry> const& dataDbRegistration,int loopDepth) 
	{
															#line 1862 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!dataDbRegistration.present());
															#line 1858 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		++dataDbItr;
															#line 18159 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13loopBody1cont1(Optional<MetaclusterRegistrationEntry> && dataDbRegistration,int loopDepth) 
	{
															#line 1862 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		ASSERT(!dataDbRegistration.present());
															#line 1858 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
		++dataDbItr;
															#line 18170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont13loopHead1(0);

		return loopDepth;
	}
	int a_body1cont13loopBody1when1(Optional<MetaclusterRegistrationEntry> const& dataDbRegistration,int loopDepth) 
	{
		loopDepth = a_body1cont13loopBody1cont1(dataDbRegistration, loopDepth);

		return loopDepth;
	}
	int a_body1cont13loopBody1when1(Optional<MetaclusterRegistrationEntry> && dataDbRegistration,int loopDepth) 
	{
		loopDepth = a_body1cont13loopBody1cont1(std::move(dataDbRegistration), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 6, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont13loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _checkActor, 6, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont13loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _checkActor, 6, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 1805 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	MetaclusterManagementWorkload* self;
															#line 1822 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	metacluster::util::MetaclusterConsistencyCheck<IDatabase> metaclusterConsistencyCheck;
															#line 1857 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	std::map<ClusterName, Reference<DataClusterData>>::iterator dataDbItr;
															#line 18256 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 1805 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Void >, public ActorCallback< _checkActor, 1, Void >, public ActorCallback< _checkActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >, public ActorCallback< _checkActor, 3, Void >, public ActorCallback< _checkActor, 4, Void >, public ActorCallback< _checkActor, 5, Optional<MetaclusterRegistrationEntry> >, public ActorCallback< _checkActor, 6, Optional<MetaclusterRegistrationEntry> >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 18261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17699431848036836608UL, 6491656278353806080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Void >;
friend struct ActorCallback< _checkActor, 1, Void >;
friend struct ActorCallback< _checkActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >;
friend struct ActorCallback< _checkActor, 3, Void >;
friend struct ActorCallback< _checkActor, 4, Void >;
friend struct ActorCallback< _checkActor, 5, Optional<MetaclusterRegistrationEntry> >;
friend struct ActorCallback< _checkActor, 6, Optional<MetaclusterRegistrationEntry> >;
															#line 1805 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	_checkActor(MetaclusterManagementWorkload* const& self) 
															#line 18284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _checkActor, 2, std::map<ClusterName, metacluster::DataClusterMetadata> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _checkActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _checkActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _checkActor, 5, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _checkActor, 6, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1805 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
[[nodiscard]] static Future<bool> _check( MetaclusterManagementWorkload* const& self ) {
															#line 1805 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"
	return Future<bool>(new _checkActor(self));
															#line 18322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementWorkload.actor.g.cpp"
}

#line 1868 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementWorkload.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<MetaclusterManagementWorkload> MetaclusterManagementWorkloadFactory;
