#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
/*
 * MetaclusterManagementConcurrencyWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdint>
#include <limits>
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/GenericManagementAPI.actor.h"
#include "fdbclient/MultiVersionTransaction.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/RunTransaction.actor.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbclient/ThreadSafeTransaction.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/Knobs.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/ProtocolVersion.h"
#include "flow/flow.h"

#include "metacluster/Metacluster.h"
#include "metacluster/MetaclusterConsistency.actor.h"
#include "metacluster/TenantConsistency.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

struct MetaclusterManagementConcurrencyWorkload : TestWorkload {
	static constexpr auto NAME = "MetaclusterManagementConcurrency";

	metacluster::util::SimulatedMetacluster simMetacluster;
	std::vector<ClusterName> dataDbIndex;

	double testDuration;
	bool createMetacluster;

	MetaclusterManagementConcurrencyWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 90.0);
		createMetacluster = getOption(options, "createMetacluster"_sr, true);
	}

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }

																#line 64 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class _setupActor>
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class _setupActorState {
															#line 70 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	_setupActorState(Database const& cx,MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : cx(cx),
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   self(self)
															#line 79 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(self->simMetacluster, metacluster::util::createSimulatedMetacluster( cx, deterministicRandom()->randomInt(TenantAPI::TENANT_ID_PREFIX_MIN_VALUE, TenantAPI::TENANT_ID_PREFIX_MAX_VALUE + 1), {}, metacluster::util::SkipMetaclusterCreation(self->clientId != 0 || !self->createMetacluster)));
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 96 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 101 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT_GT(self->simMetacluster.dataDbs.size(), 0);
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		for( auto const& [name, db] : self->simMetacluster.dataDbs ) {
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			self->dataDbIndex.push_back(name);
															#line 128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		}
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT_GT(self->simMetacluster.dataDbs.size(), 0);
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		for( auto const& [name, db] : self->simMetacluster.dataDbs ) {
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			self->dataDbIndex.push_back(name);
															#line 148 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		}
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database cx;
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 239 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 244 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3148446615096452864UL, 16239039742318931968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	_setupActor(Database const& cx,MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _setup( Database const& cx, MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

	ClusterName chooseClusterName() { return dataDbIndex[deterministicRandom()->randomInt(0, dataDbIndex.size())]; }

																#line 300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via registerCluster()
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class RegisterClusterActor>
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class RegisterClusterActorState {
															#line 306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	RegisterClusterActorState(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName(self->chooseClusterName()),
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   dataDb(self->simMetacluster.dataDbs[clusterName]),
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   debugId(deterministicRandom()->randomUniqueID())
															#line 319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("registerCluster", reinterpret_cast<unsigned long>(this));

	}
	~RegisterClusterActorState() 
	{
		fdb_probe_actor_destroy("registerCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				entry = metacluster::DataClusterEntry();
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				entry.capacity.numTenantGroups = deterministicRandom()->randomInt(0, 4);
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (deterministicRandom()->random01() < 0.2)
															#line 339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					entry.autoTenantAssignment = metacluster::AutoTenantAssignment::DISABLED;
															#line 343 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				}
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				;
															#line 347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterClusterActorState();
		static_cast<RegisterClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 376 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterClusterActorState();
		static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRegisterClusterError", debugId) .error(e) .detail("ClusterName", clusterName);
															#line 117 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (e.code() != error_code_cluster_already_exists && e.code() != error_code_cluster_not_empty && e.code() != error_code_cluster_already_registered && e.code() != error_code_cluster_removed && e.code() != error_code_cluster_restoring)
															#line 391 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 120 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				TraceEvent(SevError, "MetaclusterManagementConcurrencyRegisterClusterFailure", debugId) .error(e) .detail("ClusterName", clusterName);
															#line 123 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				ASSERT(false);
															#line 397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(errorOr(metacluster::removeCluster(self->simMetacluster.managementDb, clusterName, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove::True)));
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<RegisterClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 403 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
			static_cast<RegisterClusterActor*>(this)->actor_wait_state = 2;
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RegisterClusterActor, 1, Void >*>(static_cast<RegisterClusterActor*>(this)));
															#line 408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRegisteringCluster", debugId) .detail("ClusterName", clusterName) .detail("NumTenantGroups", entry.capacity.numTenantGroups);
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		Future<Void> registerFuture = metacluster::registerCluster(self->simMetacluster.managementDb, clusterName, dataDb.getReference()->getConnectionRecord()->getConnectionString(), entry);
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Optional<Void>> __when_expr_0 = timeout(registerFuture, deterministicRandom()->randomInt(1, 30));
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<RegisterClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RegisterClusterActor*>(this)->actor_wait_state = 1;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterClusterActor, 0, Optional<Void> >*>(static_cast<RegisterClusterActor*>(this)));
															#line 447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Void> const& result,int loopDepth) 
	{
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRegisteredCluster", debugId) .detail("ClusterName", clusterName) .detail("NumTenantGroups", entry.capacity.numTenantGroups);
															#line 473 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Register cluster timed out");
															#line 478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Void> && result,int loopDepth) 
	{
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 105 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRegisteredCluster", debugId) .detail("ClusterName", clusterName) .detail("NumTenantGroups", entry.capacity.numTenantGroups);
															#line 491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Register cluster timed out");
															#line 496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterClusterActor*>(this)->actor_wait_state > 0) static_cast<RegisterClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterClusterActor*>(this)->ActorCallback< RegisterClusterActor, 0, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 0, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 0, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterClusterActor, 0, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterClusterActorState();
		static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
															#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterClusterActorState();
		static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RegisterClusterActor*>(this)->actor_wait_state > 0) static_cast<RegisterClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterClusterActor*>(this)->ActorCallback< RegisterClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RegisterClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName;
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database dataDb;
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	UID debugId;
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	metacluster::DataClusterEntry entry;
															#line 698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via registerCluster()
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class RegisterClusterActor final : public Actor<Void>, public ActorCallback< RegisterClusterActor, 0, Optional<Void> >, public ActorCallback< RegisterClusterActor, 1, Void >, public FastAllocated<RegisterClusterActor>, public RegisterClusterActorState<RegisterClusterActor> {
															#line 703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<RegisterClusterActor>::operator new;
	using FastAllocated<RegisterClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14814498359568612608UL, 10132801675145895936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterClusterActor, 0, Optional<Void> >;
friend struct ActorCallback< RegisterClusterActor, 1, Void >;
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	RegisterClusterActor(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 721 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RegisterClusterActorState<RegisterClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5031830753118412800UL, 13167156597116580864UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterClusterActor, 0, Optional<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RegisterClusterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> registerCluster( MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new RegisterClusterActor(self));
															#line 754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

																#line 759 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via removeCluster()
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class RemoveClusterActor>
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class RemoveClusterActorState {
															#line 765 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	RemoveClusterActorState(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName(self->chooseClusterName()),
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   dataDb(self->simMetacluster.dataDbs[clusterName]),
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   forceRemove(deterministicRandom()->coinflip()),
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   debugId(deterministicRandom()->randomUniqueID())
															#line 780 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("removeCluster", reinterpret_cast<unsigned long>(this));

	}
	~RemoveClusterActorState() 
	{
		fdb_probe_actor_destroy("removeCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				;
															#line 796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RemoveClusterActorState();
		static_cast<RemoveClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<RemoveClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveClusterActorState(); static_cast<RemoveClusterActor*>(this)->destroy(); return 0; }
															#line 825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<RemoveClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveClusterActorState();
		static_cast<RemoveClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 163 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRemoveClusterError", debugId) .error(e) .detail("ClusterName", clusterName);
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (e.code() != error_code_cluster_not_found && e.code() != error_code_cluster_not_empty)
															#line 840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				TraceEvent(SevError, "MetaclusterManagementConcurrencyRemoveClusterFailure", debugId) .error(e) .detail("ClusterName", clusterName);
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				ASSERT(false);
															#line 846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 172 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (!static_cast<RemoveClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveClusterActorState(); static_cast<RemoveClusterActor*>(this)->destroy(); return 0; }
															#line 850 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			new (&static_cast<RemoveClusterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RemoveClusterActorState();
			static_cast<RemoveClusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 146 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRemovingCluster", debugId) .detail("ClusterName", clusterName);
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		Future<bool> removeFuture = metacluster::removeCluster(self->simMetacluster.managementDb, clusterName, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove::False);
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Optional<bool>> __when_expr_0 = timeout(removeFuture, deterministicRandom()->randomInt(1, 30));
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<RemoveClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RemoveClusterActor*>(this)->actor_wait_state = 1;
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RemoveClusterActor, 0, Optional<bool> >*>(static_cast<RemoveClusterActor*>(this)));
															#line 892 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<bool> const& result,int loopDepth) 
	{
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			ASSERT(result.get());
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRemovedCluster", debugId) .detail("ClusterName", clusterName);
															#line 920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Remove cluster timed out");
															#line 925 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<bool> && result,int loopDepth) 
	{
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 934 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			ASSERT(result.get());
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRemovedCluster", debugId) .detail("ClusterName", clusterName);
															#line 940 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Remove cluster timed out");
															#line 945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<bool> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<bool> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RemoveClusterActor*>(this)->actor_wait_state > 0) static_cast<RemoveClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveClusterActor*>(this)->ActorCallback< RemoveClusterActor, 0, Optional<bool> >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveClusterActor, 0, Optional<bool> >*,Optional<bool> const& value) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RemoveClusterActor, 0, Optional<bool> >*,Optional<bool> && value) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RemoveClusterActor, 0, Optional<bool> >*,Error err) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName;
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database dataDb;
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	metacluster::ForceRemove forceRemove;
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	UID debugId;
															#line 1048 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via removeCluster()
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class RemoveClusterActor final : public Actor<Void>, public ActorCallback< RemoveClusterActor, 0, Optional<bool> >, public FastAllocated<RemoveClusterActor>, public RemoveClusterActorState<RemoveClusterActor> {
															#line 1053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<RemoveClusterActor>::operator new;
	using FastAllocated<RemoveClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10287209932397987840UL, 727719420801626112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RemoveClusterActor, 0, Optional<bool> >;
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	RemoveClusterActor(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 1070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RemoveClusterActorState<RemoveClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(812508501301004544UL, 4934221500031631872UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("removeCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RemoveClusterActor, 0, Optional<bool> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> removeCluster( MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 137 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new RemoveClusterActor(self));
															#line 1102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 177 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

																#line 1107 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via listClusters()
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class ListClustersActor>
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class ListClustersActorState {
															#line 1113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ListClustersActorState(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName1(self->chooseClusterName()),
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName2(self->chooseClusterName()),
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   limit(deterministicRandom()->randomInt(1, self->simMetacluster.dataDbs.size() + 1))
															#line 1126 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("listClusters", reinterpret_cast<unsigned long>(this));

	}
	~ListClustersActorState() 
	{
		fdb_probe_actor_destroy("listClusters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				TraceEvent(SevDebug, "MetaclusterManagementConcurrencyListClusters") .detail("StartClusterName", clusterName1) .detail("EndClusterName", clusterName2) .detail("Limit", limit);
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				StrictFuture<std::map<ClusterName, metacluster::DataClusterMetadata>> __when_expr_0 = metacluster::listClusters(self->simMetacluster.managementDb, clusterName1, clusterName2, limit);
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (static_cast<ListClustersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ListClustersActor*>(this)->actor_wait_state = 1;
															#line 188 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*>(static_cast<ListClustersActor*>(this)));
															#line 1151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListClustersActorState();
		static_cast<ListClustersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<ListClustersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListClustersActorState(); static_cast<ListClustersActor*>(this)->destroy(); return 0; }
															#line 1180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<ListClustersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListClustersActorState();
		static_cast<ListClustersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyListClustersError") .error(e) .detail("StartClusterName", clusterName1) .detail("EndClusterName", clusterName2) .detail("Limit", limit);
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (e.code() != error_code_inverted_range)
															#line 1195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 206 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				TraceEvent(SevError, "MetaclusterManagementConcurrencyListClusterFailure") .error(e) .detail("ClusterName1", clusterName1) .detail("ClusterName2", clusterName2);
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				ASSERT(false);
															#line 1201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 212 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (!static_cast<ListClustersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListClustersActorState(); static_cast<ListClustersActor*>(this)->destroy(); return 0; }
															#line 1205 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			new (&static_cast<ListClustersActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ListClustersActorState();
			static_cast<ListClustersActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::map<ClusterName, metacluster::DataClusterMetadata> const& clusterList,int loopDepth) 
	{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyListedClusters") .detail("StartClusterName", clusterName1) .detail("EndClusterName", clusterName2) .detail("Limit", limit);
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT(clusterName1 <= clusterName2);
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT(clusterList.size() <= limit);
															#line 1227 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::map<ClusterName, metacluster::DataClusterMetadata> && clusterList,int loopDepth) 
	{
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyListedClusters") .detail("StartClusterName", clusterName1) .detail("EndClusterName", clusterName2) .detail("Limit", limit);
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT(clusterName1 <= clusterName2);
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT(clusterList.size() <= limit);
															#line 1240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::map<ClusterName, metacluster::DataClusterMetadata> const& clusterList,int loopDepth) 
	{
		loopDepth = a_body1cont2(clusterList, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::map<ClusterName, metacluster::DataClusterMetadata> && clusterList,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(clusterList), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListClustersActor*>(this)->actor_wait_state > 0) static_cast<ListClustersActor*>(this)->actor_wait_state = 0;
		static_cast<ListClustersActor*>(this)->ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*,std::map<ClusterName, metacluster::DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*,std::map<ClusterName, metacluster::DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 179 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName1;
															#line 180 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName2;
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	int limit;
															#line 1341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via listClusters()
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class ListClustersActor final : public Actor<Void>, public ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >, public FastAllocated<ListClustersActor>, public ListClustersActorState<ListClustersActor> {
															#line 1346 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<ListClustersActor>::operator new;
	using FastAllocated<ListClustersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1208833280981223680UL, 2199286000756041472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >;
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ListClustersActor(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 1363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ListClustersActorState<ListClustersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2037707045627374080UL, 7691457401409661952UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listClusters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> listClusters( MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new ListClustersActor(self));
															#line 1395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 216 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

																#line 1400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via getCluster()
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class GetClusterActor>
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class GetClusterActorState {
															#line 1406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	GetClusterActorState(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName(self->chooseClusterName()),
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   dataDb(self->simMetacluster.dataDbs[clusterName])
															#line 1417 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getCluster", reinterpret_cast<unsigned long>(this));

	}
	~GetClusterActorState() 
	{
		fdb_probe_actor_destroy("getCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 222 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				TraceEvent(SevDebug, "MetaclusterManagementConcurrencyGetCluster").detail("ClusterName", clusterName);
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				StrictFuture<metacluster::DataClusterMetadata> __when_expr_0 = metacluster::getCluster(self->simMetacluster.managementDb, clusterName);
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (static_cast<GetClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetClusterActor*>(this)->actor_wait_state = 1;
															#line 223 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >*>(static_cast<GetClusterActor*>(this)));
															#line 1442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetClusterActorState();
		static_cast<GetClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 242 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<GetClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetClusterActorState(); static_cast<GetClusterActor*>(this)->destroy(); return 0; }
															#line 1471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<GetClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetClusterActorState();
		static_cast<GetClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyGetClusterError") .error(e) .detail("ClusterName", clusterName);
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (e.code() != error_code_cluster_not_found)
															#line 1486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 234 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				TraceEvent(SevError, "MetaclusterManagementConcurrencyGetClusterFailure") .error(e) .detail("ClusterName", clusterName);
															#line 237 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				ASSERT(false);
															#line 1492 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 239 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (!static_cast<GetClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetClusterActorState(); static_cast<GetClusterActor*>(this)->destroy(); return 0; }
															#line 1496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			new (&static_cast<GetClusterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetClusterActorState();
			static_cast<GetClusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(metacluster::DataClusterMetadata const& clusterMetadata,int loopDepth) 
	{
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyGotCluster").detail("ClusterName", clusterName);
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT(dataDb.getReference()->getConnectionRecord()->getConnectionString() == clusterMetadata.connectionString);
															#line 1516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(metacluster::DataClusterMetadata && clusterMetadata,int loopDepth) 
	{
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyGotCluster").detail("ClusterName", clusterName);
															#line 227 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT(dataDb.getReference()->getConnectionRecord()->getConnectionString() == clusterMetadata.connectionString);
															#line 1527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(metacluster::DataClusterMetadata const& clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont2(clusterMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1when1(metacluster::DataClusterMetadata && clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(clusterMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetClusterActor*>(this)->actor_wait_state > 0) static_cast<GetClusterActor*>(this)->actor_wait_state = 0;
		static_cast<GetClusterActor*>(this)->ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >::remove();

	}
	void a_callback_fire(ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >*,metacluster::DataClusterMetadata const& value) 
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >*,metacluster::DataClusterMetadata && value) 
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >*,Error err) 
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName;
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database dataDb;
															#line 1626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via getCluster()
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class GetClusterActor final : public Actor<Void>, public ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >, public FastAllocated<GetClusterActor>, public GetClusterActorState<GetClusterActor> {
															#line 1631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<GetClusterActor>::operator new;
	using FastAllocated<GetClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4454665491857438464UL, 7700868224725705216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >;
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	GetClusterActor(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 1648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   GetClusterActorState<GetClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3838274093655030272UL, 16128179049859696384UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >*)0, actor_cancelled()); break;
		}

	}
};
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> getCluster( MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new GetClusterActor(self));
															#line 1680 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 244 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

																#line 1685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via configureImpl()
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class ConfigureImplActor>
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class ConfigureImplActorState {
															#line 1691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ConfigureImplActorState(MetaclusterManagementConcurrencyWorkload* const& self,ClusterName const& clusterName,Optional<int64_t> const& numTenantGroups,Optional<ClusterConnectionString> const& connectionString,Optional<metacluster::AutoTenantAssignment> const& autoTenantAssignment) 
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName(clusterName),
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   numTenantGroups(numTenantGroups),
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   connectionString(connectionString),
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   autoTenantAssignment(autoTenantAssignment),
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   tr(self->simMetacluster.managementDb->createTransaction())
															#line 1708 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("configureImpl", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureImplActorState() 
	{
		fdb_probe_actor_destroy("configureImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 252 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			;
															#line 1723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureImplActorState();
		static_cast<ConfigureImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 254 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Optional<metacluster::DataClusterMetadata>> __when_expr_0 = metacluster::tryGetClusterTransaction(tr, clusterName);
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1758 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConfigureImplActor*>(this)->actor_wait_state = 1;
															#line 255 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >*>(static_cast<ConfigureImplActor*>(this)));
															#line 1763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ConfigureImplActor*>(this)->actor_wait_state = 3;
															#line 279 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 2, Void >*>(static_cast<ConfigureImplActor*>(this)));
															#line 1792 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<metacluster::DataClusterMetadata> const& clusterMetadata,int loopDepth) 
	{
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		entry = Optional<metacluster::DataClusterEntry>();
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (clusterMetadata.present())
															#line 1809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (numTenantGroups.present())
															#line 1813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (!entry.present())
															#line 1817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					entry = clusterMetadata.get().entry;
															#line 1821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				}
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				entry.get().capacity.numTenantGroups = numTenantGroups.get();
															#line 1825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (autoTenantAssignment.present())
															#line 1829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (!entry.present())
															#line 1833 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					entry = clusterMetadata.get().entry;
															#line 1837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				}
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				entry.get().autoTenantAssignment = autoTenantAssignment.get();
															#line 1841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			metacluster::updateClusterMetadata(tr, clusterName, clusterMetadata.get(), connectionString, entry);
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ConfigureImplActor*>(this)->actor_wait_state = 2;
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 1, Void >*>(static_cast<ConfigureImplActor*>(this)));
															#line 1854 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<metacluster::DataClusterMetadata> && clusterMetadata,int loopDepth) 
	{
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		entry = Optional<metacluster::DataClusterEntry>();
															#line 259 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (clusterMetadata.present())
															#line 1870 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 260 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (numTenantGroups.present())
															#line 1874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 261 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (!entry.present())
															#line 1878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 262 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					entry = clusterMetadata.get().entry;
															#line 1882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				}
															#line 264 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				entry.get().capacity.numTenantGroups = numTenantGroups.get();
															#line 1886 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 266 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (autoTenantAssignment.present())
															#line 1890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 267 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (!entry.present())
															#line 1894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					entry = clusterMetadata.get().entry;
															#line 1898 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				}
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				entry.get().autoTenantAssignment = autoTenantAssignment.get();
															#line 1902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			metacluster::updateClusterMetadata(tr, clusterName, clusterMetadata.get(), connectionString, entry);
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ConfigureImplActor*>(this)->actor_wait_state = 2;
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 1, Void >*>(static_cast<ConfigureImplActor*>(this)));
															#line 1915 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<metacluster::DataClusterMetadata> const& clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(clusterMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<metacluster::DataClusterMetadata> && clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(clusterMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureImplActor*>(this)->ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >*,Optional<metacluster::DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >*,Optional<metacluster::DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 277 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<ConfigureImplActor*>(this)->SAV<Optional<metacluster::DataClusterEntry>>::futures) { (void)(entry); this->~ConfigureImplActorState(); static_cast<ConfigureImplActor*>(this)->destroy(); return 0; }
															#line 2004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<ConfigureImplActor*>(this)->SAV< Optional<metacluster::DataClusterEntry> >::value()) Optional<metacluster::DataClusterEntry>(std::move(entry)); // state_var_RVO
		this->~ConfigureImplActorState();
		static_cast<ConfigureImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureImplActor*>(this)->ActorCallback< ConfigureImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigureImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureImplActor*>(this)->ActorCallback< ConfigureImplActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConfigureImplActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName;
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Optional<int64_t> numTenantGroups;
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Optional<ClusterConnectionString> connectionString;
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Optional<metacluster::AutoTenantAssignment> autoTenantAssignment;
															#line 251 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Reference<ITransaction> tr;
															#line 257 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Optional<metacluster::DataClusterEntry> entry;
															#line 2200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via configureImpl()
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class ConfigureImplActor final : public Actor<Optional<metacluster::DataClusterEntry>>, public ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >, public ActorCallback< ConfigureImplActor, 1, Void >, public ActorCallback< ConfigureImplActor, 2, Void >, public FastAllocated<ConfigureImplActor>, public ConfigureImplActorState<ConfigureImplActor> {
															#line 2205 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<ConfigureImplActor>::operator new;
	using FastAllocated<ConfigureImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14923018559824582400UL, 7616274199474227456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<metacluster::DataClusterEntry>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >;
friend struct ActorCallback< ConfigureImplActor, 1, Void >;
friend struct ActorCallback< ConfigureImplActor, 2, Void >;
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ConfigureImplActor(MetaclusterManagementConcurrencyWorkload* const& self,ClusterName const& clusterName,Optional<int64_t> const& numTenantGroups,Optional<ClusterConnectionString> const& connectionString,Optional<metacluster::AutoTenantAssignment> const& autoTenantAssignment) 
															#line 2224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Optional<metacluster::DataClusterEntry>>(),
		   ConfigureImplActorState<ConfigureImplActor>(self, clusterName, numTenantGroups, connectionString, autoTenantAssignment),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(766673556958241024UL, 14520056664626172928UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigureImplActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConfigureImplActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Optional<metacluster::DataClusterEntry>> configureImpl( MetaclusterManagementConcurrencyWorkload* const& self, ClusterName const& clusterName, Optional<int64_t> const& numTenantGroups, Optional<ClusterConnectionString> const& connectionString, Optional<metacluster::AutoTenantAssignment> const& autoTenantAssignment ) {
															#line 245 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Optional<metacluster::DataClusterEntry>>(new ConfigureImplActor(self, clusterName, numTenantGroups, connectionString, autoTenantAssignment));
															#line 2258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 283 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

																#line 2263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via configureCluster()
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class ConfigureClusterActor>
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class ConfigureClusterActorState {
															#line 2269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ConfigureClusterActorState(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName(self->chooseClusterName()),
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   dataDb(self->simMetacluster.dataDbs[clusterName]),
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   debugId(deterministicRandom()->randomUniqueID()),
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   newNumTenantGroups(),
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   connectionString(),
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   autoTenantAssignment()
															#line 2288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("configureCluster", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureClusterActorState() 
	{
		fdb_probe_actor_destroy("configureCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 293 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 2303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 294 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				newNumTenantGroups = deterministicRandom()->randomInt(0, 4);
															#line 2307 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 296 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 2311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 297 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				connectionString = dataDb.getReference()->getConnectionRecord()->getConnectionString();
															#line 2315 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 299 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 2319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 300 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				autoTenantAssignment = deterministicRandom()->coinflip() ? metacluster::AutoTenantAssignment::DISABLED : metacluster::AutoTenantAssignment::ENABLED;
															#line 2323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
			try {
															#line 305 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				;
															#line 2328 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureClusterActorState();
		static_cast<ConfigureClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<ConfigureClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureClusterActorState(); static_cast<ConfigureClusterActor*>(this)->destroy(); return 0; }
															#line 2357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<ConfigureClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureClusterActorState();
		static_cast<ConfigureClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 328 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyConfigureClusterError", debugId) .error(e) .detail("ClusterName", clusterName) .detail("NewNumTenantGroups", newNumTenantGroups.orDefault(-1)) .detail("NewConnectionString", connectionString.map(&ClusterConnectionString::toString).orDefault(""));
															#line 333 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (e.code() != error_code_cluster_not_found && e.code() != error_code_cluster_removed && e.code() != error_code_invalid_metacluster_operation && e.code() != error_code_cluster_restoring)
															#line 2372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 335 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				TraceEvent(SevError, "MetaclusterManagementConcurrencyConfigureClusterFailure") .error(e) .detail("ClusterName", clusterName);
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				ASSERT(false);
															#line 2378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 306 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyConfigureCluster", debugId) .detail("ClusterName", clusterName) .detail("NewNumTenantGroups", newNumTenantGroups.orDefault(-1)) .detail("NewConnectionString", connectionString.map(&ClusterConnectionString::toString).orDefault(""));
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Optional<Optional<metacluster::DataClusterEntry>>> __when_expr_0 = timeout( configureImpl(self, clusterName, newNumTenantGroups, connectionString, autoTenantAssignment), deterministicRandom()->randomInt(1, 30));
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<ConfigureClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ConfigureClusterActor*>(this)->actor_wait_state = 1;
															#line 312 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >*>(static_cast<ConfigureClusterActor*>(this)));
															#line 2416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Optional<metacluster::DataClusterEntry>> const& result,int loopDepth) 
	{
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 2438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyConfiguredCluster", debugId) .detail("ClusterName", clusterName) .detail("NewNumTenantGroups", newNumTenantGroups.orDefault(-1)) .detail("NewConnectionString", connectionString.map(&ClusterConnectionString::toString).orDefault(""));
															#line 2442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Configure cluster timed out");
															#line 2447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Optional<metacluster::DataClusterEntry>> && result,int loopDepth) 
	{
															#line 316 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 2456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 317 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyConfiguredCluster", debugId) .detail("ClusterName", clusterName) .detail("NewNumTenantGroups", newNumTenantGroups.orDefault(-1)) .detail("NewConnectionString", connectionString.map(&ClusterConnectionString::toString).orDefault(""));
															#line 2460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 325 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Configure cluster timed out");
															#line 2465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Optional<metacluster::DataClusterEntry>> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Optional<metacluster::DataClusterEntry>> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureClusterActor*>(this)->actor_wait_state > 0) static_cast<ConfigureClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureClusterActor*>(this)->ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >*,Optional<Optional<metacluster::DataClusterEntry>> const& value) 
	{
		fdb_probe_actor_enter("configureCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >*,Optional<Optional<metacluster::DataClusterEntry>> && value) 
	{
		fdb_probe_actor_enter("configureCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("configureCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 285 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName;
															#line 286 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database dataDb;
															#line 288 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	UID debugId;
															#line 290 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Optional<int64_t> newNumTenantGroups;
															#line 291 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Optional<ClusterConnectionString> connectionString;
															#line 292 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Optional<metacluster::AutoTenantAssignment> autoTenantAssignment;
															#line 2572 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via configureCluster()
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class ConfigureClusterActor final : public Actor<Void>, public ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >, public FastAllocated<ConfigureClusterActor>, public ConfigureClusterActorState<ConfigureClusterActor> {
															#line 2577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<ConfigureClusterActor>::operator new;
	using FastAllocated<ConfigureClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12780629456213540096UL, 6788287247259866112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >;
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ConfigureClusterActor(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 2594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ConfigureClusterActorState<ConfigureClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6960254137143238656UL, 15722660461201014016UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> configureCluster( MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 284 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new ConfigureClusterActor(self));
															#line 2626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 344 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

																#line 2631 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via restoreCluster()
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class RestoreClusterActor>
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class RestoreClusterActorState {
															#line 2637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	RestoreClusterActorState(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName(self->chooseClusterName()),
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   db(self->simMetacluster.dataDbs[clusterName]),
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   applyManagementClusterUpdates(deterministicRandom()->coinflip()),
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   forceJoin(deterministicRandom()->coinflip()),
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   removeFirst(!applyManagementClusterUpdates && deterministicRandom()->coinflip()),
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   debugId(deterministicRandom()->randomUniqueID())
															#line 2656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("restoreCluster", reinterpret_cast<unsigned long>(this));

	}
	~RestoreClusterActorState() 
	{
		fdb_probe_actor_destroy("restoreCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 356 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				;
															#line 2672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreClusterActorState();
		static_cast<RestoreClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 448 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<RestoreClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreClusterActorState(); static_cast<RestoreClusterActor*>(this)->destroy(); return 0; }
															#line 2701 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<RestoreClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RestoreClusterActorState();
		static_cast<RestoreClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 419 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreError", debugId) .error(e) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 424 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (e.code() == error_code_cluster_already_registered)
															#line 2716 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 425 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				ASSERT(!forceJoin || !applyManagementClusterUpdates);
															#line 2720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
			else
			{
															#line 426 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (applyManagementClusterUpdates && e.code() == error_code_invalid_data_cluster)
															#line 2726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				{
				}
				else
				{
															#line 429 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					if (!applyManagementClusterUpdates && (e.code() == error_code_cluster_already_exists || e.code() == error_code_tenant_already_exists || e.code() == error_code_invalid_tenant_configuration))
															#line 2733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
					{
					}
					else
					{
															#line 433 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
						if (e.code() != error_code_cluster_not_found && e.code() != error_code_cluster_removed && e.code() != error_code_conflicting_restore)
															#line 2740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
						{
															#line 435 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
							TraceEvent(SevError, "MetaclusterManagementConcurrencyRestoreFailure", debugId) .error(e) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
							ASSERT(false);
															#line 2746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
						}
					}
				}
			}
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_3 = success(errorOr(metacluster::removeCluster(self->simMetacluster.managementDb, clusterName, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove::True)));
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_3.get(), loopDepth); };
			static_cast<RestoreClusterActor*>(this)->actor_wait_state = 4;
															#line 442 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 3, Void >*>(static_cast<RestoreClusterActor*>(this)));
															#line 2760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestore", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (removeFirst)
															#line 2790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreRemoveDataCluster", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(errorOr(metacluster::removeCluster(self->simMetacluster.managementDb, clusterName, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove::True)));
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreClusterActor*>(this)->actor_wait_state = 1;
															#line 366 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 0, Void >*>(static_cast<RestoreClusterActor*>(this)));
															#line 2803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		messages = std::vector<std::string>();
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 2832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreDryRun", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = metacluster::restoreCluster(self->simMetacluster.managementDb, clusterName, db->getConnectionRecord()->getConnectionString(), applyManagementClusterUpdates, metacluster::RestoreDryRun::True, forceJoin, metacluster::ForceReuseTenantIdPrefix::True, &messages);
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2840 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RestoreClusterActor*>(this)->actor_wait_state = 2;
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 1, Void >*>(static_cast<RestoreClusterActor*>(this)));
															#line 2845 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreRemovedDataCluster", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 2859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 371 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreRemovedDataCluster", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 2868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Optional<Void>> __when_expr_2 = timeout(metacluster::restoreCluster(self->simMetacluster.managementDb, clusterName, db->getConnectionRecord()->getConnectionString(), applyManagementClusterUpdates, metacluster::RestoreDryRun::False, forceJoin, metacluster::ForceReuseTenantIdPrefix::True, &messages), 30.0);
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<RestoreClusterActor*>(this)->actor_wait_state = 3;
															#line 398 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 2, Optional<Void> >*>(static_cast<RestoreClusterActor*>(this)));
															#line 2959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreDryRunDone", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		messages.clear();
															#line 2970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreDryRunDone", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 395 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		messages.clear();
															#line 2981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Optional<Void> const& result,int loopDepth) 
	{
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 3065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreComplete", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 3069 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Restore cluster timed out");
															#line 3074 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Optional<Void> && result,int loopDepth) 
	{
															#line 409 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 3083 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 410 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreComplete", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 3087 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 416 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Restore cluster timed out");
															#line 3092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 2, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 2, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 2, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 2, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName;
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database db;
															#line 348 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	metacluster::ApplyManagementClusterUpdates applyManagementClusterUpdates;
															#line 350 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	metacluster::ForceJoin forceJoin;
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	bool removeFirst;
															#line 353 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	UID debugId;
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	std::vector<std::string> messages;
															#line 3288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via restoreCluster()
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class RestoreClusterActor final : public Actor<Void>, public ActorCallback< RestoreClusterActor, 0, Void >, public ActorCallback< RestoreClusterActor, 1, Void >, public ActorCallback< RestoreClusterActor, 2, Optional<Void> >, public ActorCallback< RestoreClusterActor, 3, Void >, public FastAllocated<RestoreClusterActor>, public RestoreClusterActorState<RestoreClusterActor> {
															#line 3293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<RestoreClusterActor>::operator new;
	using FastAllocated<RestoreClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18330159064511410944UL, 11014968853488438272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreClusterActor, 0, Void >;
friend struct ActorCallback< RestoreClusterActor, 1, Void >;
friend struct ActorCallback< RestoreClusterActor, 2, Optional<Void> >;
friend struct ActorCallback< RestoreClusterActor, 3, Void >;
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	RestoreClusterActor(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 3313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RestoreClusterActorState<RestoreClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12143823830767418880UL, 265345168070311680UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("restoreCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreClusterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RestoreClusterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RestoreClusterActor, 2, Optional<Void> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RestoreClusterActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> restoreCluster( MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new RestoreClusterActor(self));
															#line 3348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 450 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

	Future<Void> start(Database const& cx) override { return _start(cx, this); }
																#line 3354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class _startActor>
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class _startActorState {
															#line 3360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	_startActorState(Database const& cx,MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : cx(cx),
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   self(self),
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   start(now())
															#line 3371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			;
															#line 3386 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 473 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 456 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!(now() < start + self->testDuration))
															#line 3428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		operation = deterministicRandom()->randomInt(0, 6);
															#line 458 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (operation == 0)
															#line 3436 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = registerCluster(self);
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3442 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 459 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 3447 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 460 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (operation == 1)
															#line 3454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 461 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_1 = removeCluster(self);
															#line 461 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 461 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 3465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 462 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (operation == 2)
															#line 3472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_2 = listClusters(self);
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3478 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 463 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 3483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 464 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					if (operation == 3)
															#line 3490 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
					{
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_3 = getCluster(self);
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
						if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
						static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 465 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 3501 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 466 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
						if (operation == 4)
															#line 3508 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
						{
															#line 467 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
							StrictFuture<Void> __when_expr_4 = configureCluster(self);
															#line 467 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
							if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
							if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.get(), loopDepth); };
							static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 467 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
							__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 3519 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 468 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
							if (operation == 5)
															#line 3526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
							{
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
								StrictFuture<Void> __when_expr_5 = restoreCluster(self);
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
								if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3532 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
								if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when6(__when_expr_5.get(), loopDepth); };
								static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 469 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
								__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 3537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
								loopDepth = 0;
							}
							else
							{
								loopDepth = a_body1loopBody1cont12(loopDepth);
							}
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database cx;
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 453 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	double start;
															#line 457 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	int operation;
															#line 4131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 4136 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7780512366232120576UL, 7310360895654565888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	_startActor(Database const& cx,MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 4158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 452 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 4195 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 475 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

	Future<bool> check(Database const& cx) override {
		if (clientId == 0) {
			return _check(cx, this);
		} else {
			return true;
		}
	}
																#line 4207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class _checkActor>
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class _checkActorState {
															#line 4213 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	_checkActorState(Database const& cx,MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : cx(cx),
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   self(self),
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   metaclusterConsistencyCheck(self->simMetacluster.managementDb, metacluster::util::AllowPartialMetaclusterOperations::True)
															#line 4224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = metaclusterConsistencyCheck.run();
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 487 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Void >*>(static_cast<_checkActor*>(this)));
															#line 4246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 4269 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 489 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 4281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database cx;
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 485 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	metacluster::util::MetaclusterConsistencyCheck<IDatabase> metaclusterConsistencyCheck;
															#line 4370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 4375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5176934469298640384UL, 12349716415982620416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Void >;
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	_checkActor(Database const& cx,MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 4392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<bool> _check( Database const& cx, MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 483 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 4424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 491 "/Users/ec2-user/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<MetaclusterManagementConcurrencyWorkload> MetaclusterManagementConcurrencyWorkloadFactory;
