#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
/*
 * LogMetrics.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flow/SystemMonitor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/MasterInterface.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/ServerDBInfo.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct LogMetricsWorkload : TestWorkload {
	static constexpr auto NAME = "LogMetrics";

	std::string dataFolder;
	double logAt, logDuration, logsPerSecond;

	LogMetricsWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		logAt = getOption(options, "logAt"_sr, 0.0);
		logDuration = getOption(options, "logDuration"_sr, 30.0);
		logsPerSecond = getOption(options, "logsPerSecond"_sr, 20);
		dataFolder = getOption(options, "dataFolder"_sr, ""_sr).toString();
	}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override {
		if (clientId)
			return Void();
		return _start(cx, this);
	}

																#line 55 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
// This generated class is to be used only via setSystemRate()
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
template <class SetSystemRateActor>
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
class SetSystemRateActorState {
															#line 61 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
public:
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
	SetSystemRateActorState(LogMetricsWorkload* const& self,Database const& cx,uint32_t const& rate) 
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		 : self(self),
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		   cx(cx),
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		   rate(rate),
															#line 55 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		   br(Unversioned())
															#line 74 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
	{
		fdb_probe_actor_create("setSystemRate", reinterpret_cast<unsigned long>(this));

	}
	~SetSystemRateActorState() 
	{
		fdb_probe_actor_destroy("setSystemRate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 56 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 56 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
			if (static_cast<SetSystemRateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 91 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetSystemRateActor*>(this)->actor_wait_state = 1;
															#line 56 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetSystemRateActor, 0, std::vector<WorkerDetails> >*>(static_cast<SetSystemRateActor*>(this)));
															#line 96 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetSystemRateActorState();
		static_cast<SetSystemRateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		TraceEvent("RateChangeTrigger").log();
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		SetMetricsLogRateRequest req(rate);
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
			workers[i].interf.setMetricsRate.send(req);
															#line 125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		}
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		br << rate;
															#line 66 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		;
															#line 131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		TraceEvent("RateChangeTrigger").log();
															#line 59 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		SetMetricsLogRateRequest req(rate);
															#line 60 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 61 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
			workers[i].interf.setMetricsRate.send(req);
															#line 146 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		}
															#line 65 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		br << rate;
															#line 66 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		;
															#line 152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(workers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetSystemRateActor*>(this)->actor_wait_state > 0) static_cast<SetSystemRateActor*>(this)->actor_wait_state = 0;
		static_cast<SetSystemRateActor*>(this)->ActorCallback< SetSystemRateActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< SetSystemRateActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("setSystemRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetSystemRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSystemRate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetSystemRateActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("setSystemRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetSystemRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSystemRate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetSystemRateActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("setSystemRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetSystemRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSystemRate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		if (!static_cast<SetSystemRateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetSystemRateActorState(); static_cast<SetSystemRateActor*>(this)->destroy(); return 0; }
															#line 236 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		new (&static_cast<SetSystemRateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetSystemRateActorState();
		static_cast<SetSystemRateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		tr = Transaction(cx);
															#line 255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		try {
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(tr.getReadVersion());
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
			if (static_cast<SetSystemRateActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 261 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetSystemRateActor*>(this)->actor_wait_state = 2;
															#line 69 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetSystemRateActor, 1, Void >*>(static_cast<SetSystemRateActor*>(this)));
															#line 266 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
			if (static_cast<SetSystemRateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<SetSystemRateActor*>(this)->actor_wait_state = 4;
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SetSystemRateActor, 3, Void >*>(static_cast<SetSystemRateActor*>(this)));
															#line 308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		tr.set(fastLoggingEnabled, br.toValue());
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		tr.makeSelfConflicting();
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		if (static_cast<SetSystemRateActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<SetSystemRateActor*>(this)->actor_wait_state = 3;
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SetSystemRateActor, 2, Void >*>(static_cast<SetSystemRateActor*>(this)));
															#line 334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		tr.set(fastLoggingEnabled, br.toValue());
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		tr.makeSelfConflicting();
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		if (static_cast<SetSystemRateActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<SetSystemRateActor*>(this)->actor_wait_state = 3;
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SetSystemRateActor, 2, Void >*>(static_cast<SetSystemRateActor*>(this)));
															#line 354 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetSystemRateActor*>(this)->actor_wait_state > 0) static_cast<SetSystemRateActor*>(this)->actor_wait_state = 0;
		static_cast<SetSystemRateActor*>(this)->ActorCallback< SetSystemRateActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetSystemRateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setSystemRate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetSystemRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSystemRate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetSystemRateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setSystemRate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetSystemRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSystemRate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetSystemRateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setSystemRate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetSystemRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSystemRate", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SetSystemRateActor*>(this)->actor_wait_state > 0) static_cast<SetSystemRateActor*>(this)->actor_wait_state = 0;
		static_cast<SetSystemRateActor*>(this)->ActorCallback< SetSystemRateActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetSystemRateActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setSystemRate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetSystemRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSystemRate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SetSystemRateActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setSystemRate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetSystemRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSystemRate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SetSystemRateActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setSystemRate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetSystemRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSystemRate", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SetSystemRateActor*>(this)->actor_wait_state > 0) static_cast<SetSystemRateActor*>(this)->actor_wait_state = 0;
		static_cast<SetSystemRateActor*>(this)->ActorCallback< SetSystemRateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetSystemRateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setSystemRate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetSystemRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSystemRate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SetSystemRateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setSystemRate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetSystemRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSystemRate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SetSystemRateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setSystemRate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetSystemRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setSystemRate", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
	LogMetricsWorkload* self;
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
	Database cx;
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
	uint32_t rate;
															#line 55 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
	BinaryWriter br;
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
	Transaction tr;
															#line 618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
};
// This generated class is to be used only via setSystemRate()
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
class SetSystemRateActor final : public Actor<Void>, public ActorCallback< SetSystemRateActor, 0, std::vector<WorkerDetails> >, public ActorCallback< SetSystemRateActor, 1, Void >, public ActorCallback< SetSystemRateActor, 2, Void >, public ActorCallback< SetSystemRateActor, 3, Void >, public FastAllocated<SetSystemRateActor>, public SetSystemRateActorState<SetSystemRateActor> {
															#line 623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
public:
	using FastAllocated<SetSystemRateActor>::operator new;
	using FastAllocated<SetSystemRateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15356809059685707520UL, 1488534052433422592UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetSystemRateActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< SetSystemRateActor, 1, Void >;
friend struct ActorCallback< SetSystemRateActor, 2, Void >;
friend struct ActorCallback< SetSystemRateActor, 3, Void >;
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
	SetSystemRateActor(LogMetricsWorkload* const& self,Database const& cx,uint32_t const& rate) 
															#line 643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		 : Actor<Void>(),
		   SetSystemRateActorState<SetSystemRateActor>(self, cx, rate),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setSystemRate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2556973735170750464UL, 13610307823371478528UL);
		ActorExecutionContextHelper __helper(static_cast<SetSystemRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setSystemRate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setSystemRate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetSystemRateActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetSystemRateActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SetSystemRateActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SetSystemRateActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
[[nodiscard]] Future<Void> setSystemRate( LogMetricsWorkload* const& self, Database const& cx, uint32_t const& rate ) {
															#line 53 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
	return Future<Void>(new SetSystemRateActor(self, cx, rate));
															#line 678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
}

#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"

																#line 683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
template <class _startActor>
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
class _startActorState {
															#line 689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
public:
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
	_startActorState(Database const& cx,LogMetricsWorkload* const& self) 
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		 : cx(cx),
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		   self(self)
															#line 698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->logAt);
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->setSystemRate(self, cx, self->logsPerSecond);
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->setSystemRate(self, cx, self->logsPerSecond);
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		StrictFuture<Void> __when_expr_2 = timeout(recurring(&systemMonitor, 1.0 / self->logsPerSecond), self->logDuration, Void());
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 857 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		StrictFuture<Void> __when_expr_2 = timeout(recurring(&systemMonitor, 1.0 / self->logsPerSecond), self->logDuration, Void());
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->setSystemRate(self, cx, 1.0);
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 964 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->setSystemRate(self, cx, 1.0);
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 89 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 980 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
	Database cx;
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
	LogMetricsWorkload* self;
															#line 1163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10680907103712115456UL, 4462028834448721408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
	_startActor(Database const& cx,LogMetricsWorkload* const& self) 
															#line 1188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, LogMetricsWorkload* const& self ) {
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/LogMetrics.actor.g.cpp"
}

#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/LogMetrics.actor.cpp"

	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<LogMetricsWorkload> LogMetricsWorkloadFactory;
