#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
/*
 * Increment.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct Increment : TestWorkload {
	static constexpr auto NAME = "Increment";
	int actorCount, nodeCount;
	double testDuration, transactionsPerSecond, minExpectedTransactionsPerSecond;

	std::vector<Future<Void>> clients;
	PerfIntCounter transactions, retries, tooOldRetries, commitFailedRetries;
	PerfDoubleCounter totalLatency;

	Increment(WorkloadContext const& wcx)
	  : TestWorkload(wcx), transactions("Transactions"), retries("Retries"), tooOldRetries("Retries.too_old"),
	    commitFailedRetries("Retries.commit_failed"), totalLatency("Latency") {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		transactionsPerSecond = getOption(options, "transactionsPerSecond"_sr, 5000.0);
		actorCount = getOption(options, "actorsPerClient"_sr, transactionsPerSecond / 5);
		nodeCount = getOption(options, "nodeCount"_sr, transactionsPerSecond * clientCount);
		minExpectedTransactionsPerSecond = transactionsPerSecond * getOption(options, "expectedRate"_sr, 0.7);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override {
		for (int c = 0; c < actorCount; c++)
			clients.push_back(
			    timeout(incrementClient(cx->clone(), this, actorCount / transactionsPerSecond), testDuration, Void()));
		return delay(testDuration);
	}
	Future<bool> check(Database const& cx) override {
		int errors = 0;
		for (int c = 0; c < clients.size(); c++)
			errors += clients[c].isError();
		if (errors)
			TraceEvent(SevError, "TestFailure").detail("Reason", "There were client errors.");
		clients.clear();
		return incrementCheck(cx->clone(), this, !errors);
	}
	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(transactions.getMetric());
		m.push_back(retries.getMetric());
		m.push_back(tooOldRetries.getMetric());
		m.push_back(commitFailedRetries.getMetric());
		m.emplace_back("Avg Latency (ms)", 1000 * totalLatency.getValue() / transactions.getValue(), Averaged::True);
		m.emplace_back("Read rows/simsec (approx)", transactions.getValue() * 3 / testDuration, Averaged::False);
		m.emplace_back("Write rows/simsec (approx)", transactions.getValue() * 4 / testDuration, Averaged::False);
	}

	static Key intToTestKey(int i) { return StringRef(format("%016d", i)); }

																#line 76 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
// This generated class is to be used only via incrementClient()
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
template <class IncrementClientActor>
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
class IncrementClientActorState {
															#line 82 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
public:
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	IncrementClientActorState(Database const& cx,Increment* const& self,double const& delay) 
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		 : cx(cx),
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		   self(self),
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		   delay(delay),
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		   lastTime(now())
															#line 95 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
	{
		fdb_probe_actor_create("incrementClient", reinterpret_cast<unsigned long>(this));

	}
	~IncrementClientActorState() 
	{
		fdb_probe_actor_destroy("incrementClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
				;
															#line 111 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncrementClientActorState();
		static_cast<IncrementClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			TraceEvent(SevError, "IncrementClient").error(e);
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, delay);
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		if (static_cast<IncrementClientActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 166 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<IncrementClientActor*>(this)->actor_wait_state = 1;
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncrementClientActor, 0, Void >*>(static_cast<IncrementClientActor*>(this)));
															#line 171 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		tstart = now();
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		tr = Transaction(cx);
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		;
															#line 184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		tstart = now();
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		tr = Transaction(cx);
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		;
															#line 197 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncrementClientActor*>(this)->actor_wait_state > 0) static_cast<IncrementClientActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementClientActor*>(this)->ActorCallback< IncrementClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncrementClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncrementClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		++self->transactions;
															#line 103 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		self->totalLatency += now() - tstart;
															#line 283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			tr.atomicOp(intToTestKey(deterministicRandom()->randomInt(0, self->nodeCount / 2)), "\x01"_sr, MutationRef::AddValue);
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			tr.atomicOp( intToTestKey(deterministicRandom()->randomInt(self->nodeCount / 2, self->nodeCount)), "\x01"_sr, MutationRef::AddValue);
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			if (static_cast<IncrementClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<IncrementClientActor*>(this)->actor_wait_state = 2;
															#line 91 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncrementClientActor, 1, Void >*>(static_cast<IncrementClientActor*>(this)));
															#line 311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		++self->retries;
															#line 339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 94 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			if (e.code() == error_code_transaction_too_old)
															#line 349 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
			{
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
				++self->tooOldRetries;
															#line 353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
			}
			else
			{
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
				if (e.code() == error_code_not_committed)
															#line 359 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
				{
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
					++self->commitFailedRetries;
															#line 363 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
				}
			}
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			if (static_cast<IncrementClientActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<IncrementClientActor*>(this)->actor_wait_state = 3;
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IncrementClientActor, 2, Void >*>(static_cast<IncrementClientActor*>(this)));
															#line 375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IncrementClientActor*>(this)->actor_wait_state > 0) static_cast<IncrementClientActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementClientActor*>(this)->ActorCallback< IncrementClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IncrementClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IncrementClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<IncrementClientActor*>(this)->actor_wait_state > 0) static_cast<IncrementClientActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementClientActor*>(this)->ActorCallback< IncrementClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< IncrementClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< IncrementClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementClient", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	Database cx;
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	Increment* self;
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	double delay;
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	double lastTime;
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	double tstart;
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	Transaction tr;
															#line 572 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
};
// This generated class is to be used only via incrementClient()
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
class IncrementClientActor final : public Actor<Void>, public ActorCallback< IncrementClientActor, 0, Void >, public ActorCallback< IncrementClientActor, 1, Void >, public ActorCallback< IncrementClientActor, 2, Void >, public FastAllocated<IncrementClientActor>, public IncrementClientActorState<IncrementClientActor> {
															#line 577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
public:
	using FastAllocated<IncrementClientActor>::operator new;
	using FastAllocated<IncrementClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3755961535298023936UL, 6439920001242589440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IncrementClientActor, 0, Void >;
friend struct ActorCallback< IncrementClientActor, 1, Void >;
friend struct ActorCallback< IncrementClientActor, 2, Void >;
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	IncrementClientActor(Database const& cx,Increment* const& self,double const& delay) 
															#line 596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
		 : Actor<Void>(),
		   IncrementClientActorState<IncrementClientActor>(cx, self, delay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("incrementClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12810561397305909760UL, 8220679652405561856UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("incrementClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("incrementClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncrementClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IncrementClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< IncrementClientActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
[[nodiscard]] Future<Void> incrementClient( Database const& cx, Increment* const& self, double const& delay ) {
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	return Future<Void>(new IncrementClientActor(cx, self, delay));
															#line 630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
}

#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	bool incrementCheckData(const VectorRef<KeyValueRef>& data, Version v, Increment* self) {
		CODE_PROBE(self->transactions.getValue(), "incrementCheckData transaction has value");
		if (self->transactions.getValue() && data.size() == 0) {
			TraceEvent(SevError, "TestFailure")
			    .detail("Reason", "No successful increments")
			    .detail("Before", nodeCount)
			    .detail("After", data.size())
			    .detail("Version", v);
			return false;
		}
		int firstSum = 0;
		int secondSum = 0;
		for (auto it : data) {
			ASSERT(it.value.size() <= sizeof(uint64_t));
			uint64_t intValue = 0;
			memcpy(&intValue, it.value.begin(), it.value.size());
			if (it.key < intToTestKey(nodeCount / 2)) {
				firstSum += intValue;
			} else {
				secondSum += intValue;
			}
		}
		if (firstSum != secondSum) {
			TraceEvent(SevError, "TestFailure")
			    .detail("Reason", "Bad increments")
			    .detail("A", firstSum)
			    .detail("B", secondSum);
			return false;
		}
		return true;
	}
																#line 665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
// This generated class is to be used only via incrementCheck()
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
template <class IncrementCheckActor>
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
class IncrementCheckActorState {
															#line 671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
public:
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	IncrementCheckActorState(Database const& cx,Increment* const& self,bool const& ok) 
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		 : cx(cx),
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		   self(self),
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		   ok(ok)
															#line 682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
	{
		fdb_probe_actor_create("incrementCheck", reinterpret_cast<unsigned long>(this));

	}
	~IncrementCheckActorState() 
	{
		fdb_probe_actor_destroy("incrementCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 142 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			if (self->transactions.getMetric().value() < self->testDuration * self->minExpectedTransactionsPerSecond)
															#line 697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
			{
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
				TraceEvent(SevWarnAlways, "TestFailure") .detail("Reason", "Rate below desired rate") .detail("File", __FILE__) .detail( "Details", format("%.2f", self->transactions.getMetric().value() / (self->transactionsPerSecond * self->testDuration))) .detail("TransactionsAchieved", self->transactions.getMetric().value()) .detail("MinTransactionsExpected", self->testDuration * self->minExpectedTransactionsPerSecond) .detail("TransactionGoal", self->transactionsPerSecond * self->testDuration);
															#line 153 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
				ok = false;
															#line 703 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
			}
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			if (!self->clientId)
															#line 707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
			{
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
				tr = Transaction(cx);
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
				retryCount = 0;
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
				;
															#line 715 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncrementCheckActorState();
		static_cast<IncrementCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		if (!static_cast<IncrementCheckActor*>(this)->SAV<bool>::futures) { (void)(ok); this->~IncrementCheckActorState(); static_cast<IncrementCheckActor*>(this)->destroy(); return 0; }
															#line 743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
		new (&static_cast<IncrementCheckActor*>(this)->SAV< bool >::value()) bool(std::move(ok)); // state_var_RVO
		this->~IncrementCheckActorState();
		static_cast<IncrementCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			if (static_cast<IncrementCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 771 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IncrementCheckActor*>(this)->actor_wait_state = 1;
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncrementCheckActor, 0, Version >*>(static_cast<IncrementCheckActor*>(this)));
															#line 776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			retryCount++;
															#line 169 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			TraceEvent(retryCount > 20 ? SevWarnAlways : SevWarn, "IncrementCheckError").error(e);
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			if (static_cast<IncrementCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 817 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<IncrementCheckActor*>(this)->actor_wait_state = 3;
															#line 170 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IncrementCheckActor, 2, Void >*>(static_cast<IncrementCheckActor*>(this)));
															#line 822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(firstGreaterOrEqual(intToTestKey(0)), firstGreaterOrEqual(intToTestKey(self->nodeCount)), self->nodeCount + 1);
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		if (static_cast<IncrementCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 839 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<IncrementCheckActor*>(this)->actor_wait_state = 2;
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncrementCheckActor, 1, RangeResult >*>(static_cast<IncrementCheckActor*>(this)));
															#line 844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& __v,int loopDepth) 
	{
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		v = __v;
															#line 853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && __v,int loopDepth) 
	{
		v = std::move(__v);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncrementCheckActor*>(this)->actor_wait_state > 0) static_cast<IncrementCheckActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementCheckActor*>(this)->ActorCallback< IncrementCheckActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementCheckActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("incrementCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncrementCheckActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("incrementCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncrementCheckActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("incrementCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& data,int loopDepth) 
	{
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		ok = self->incrementCheckData(data, v, self) && ok;
															#line 932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && data,int loopDepth) 
	{
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
		ok = self->incrementCheckData(data, v, self) && ok;
															#line 941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& data,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(data, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && data,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(data), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IncrementCheckActor*>(this)->actor_wait_state > 0) static_cast<IncrementCheckActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementCheckActor*>(this)->ActorCallback< IncrementCheckActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementCheckActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("incrementCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IncrementCheckActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("incrementCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IncrementCheckActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("incrementCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<IncrementCheckActor*>(this)->actor_wait_state > 0) static_cast<IncrementCheckActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementCheckActor*>(this)->ActorCallback< IncrementCheckActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementCheckActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< IncrementCheckActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementCheck", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< IncrementCheckActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementCheck", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementCheck", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	Database cx;
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	Increment* self;
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	bool ok;
															#line 157 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	Transaction tr;
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	int retryCount;
															#line 161 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	Version v;
															#line 1120 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
};
// This generated class is to be used only via incrementCheck()
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
class IncrementCheckActor final : public Actor<bool>, public ActorCallback< IncrementCheckActor, 0, Version >, public ActorCallback< IncrementCheckActor, 1, RangeResult >, public ActorCallback< IncrementCheckActor, 2, Void >, public FastAllocated<IncrementCheckActor>, public IncrementCheckActorState<IncrementCheckActor> {
															#line 1125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
public:
	using FastAllocated<IncrementCheckActor>::operator new;
	using FastAllocated<IncrementCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11616277367820967936UL, 6185640574902939136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IncrementCheckActor, 0, Version >;
friend struct ActorCallback< IncrementCheckActor, 1, RangeResult >;
friend struct ActorCallback< IncrementCheckActor, 2, Void >;
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	IncrementCheckActor(Database const& cx,Increment* const& self,bool const& ok) 
															#line 1144 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
		 : Actor<bool>(),
		   IncrementCheckActorState<IncrementCheckActor>(cx, self, ok),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("incrementCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17692613906105887232UL, 843475133896181504UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("incrementCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("incrementCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncrementCheckActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IncrementCheckActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< IncrementCheckActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
[[nodiscard]] Future<bool> incrementCheck( Database const& cx, Increment* const& self, bool const& ok ) {
															#line 141 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
	return Future<bool>(new IncrementCheckActor(cx, self, ok));
															#line 1178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/Increment.actor.g.cpp"
}

#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/Increment.actor.cpp"
};

WorkloadFactory<Increment> IncrementWorkloadFactory;
