#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
/*
 * GcGenerations.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/StatusClient.h"
#include "fdbrpc/Locality.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/RecoveryState.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbrpc/simulator.h"
#include "flow/CodeProbe.h"
#include "flow/NetworkAddress.h"
#include "flow/Error.h"
#include "flow/Trace.h"
#include "flow/flow.h"
#include "flow/network.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// This workload tests that when TRACK_TLOG_RECOVERY is turned on, older TLog generations can be garbage collected
// during the recovery before reaching fully_recovered.
struct GcGenerationsWorkload : TestWorkload {
	static constexpr auto NAME = "GcGenerations";
	bool enabled;
	double testDuration;
	double startDelay;
	std::vector<std::pair<IPAddress, IPAddress>> cloggedPairs;

	GcGenerationsWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		enabled = !clientId; // only do this on the "first" client
		testDuration = getOption(options, "testDuration"_sr, 1000.0);
		startDelay = getOption(options, "startDelay"_sr, 30.0);
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert("Attrition");
		out.insert("RandomClogging");
	}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override {
		if (g_network->isSimulated() && enabled)
			return timeout(reportErrors(gcGenerationsTestClient(this, cx), "GcGenerationsError"), testDuration, Void());
		else
			return Void();
	}
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}

	void unclogAll() {
		TraceEvent("GcGenerationsUnclogRemote").detail("UnclogConnectionCount", cloggedPairs.size());
		// unclog previously clogged connections
		for (const auto& pair : cloggedPairs) {
			g_simulator->unclogPair(pair.first, pair.second);
		}
		cloggedPairs.clear();
	}

																#line 81 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
// This generated class is to be used only via clogRemoteDc()
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
template <class ClogRemoteDcActor>
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
class ClogRemoteDcActorState {
															#line 87 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
public:
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	ClogRemoteDcActorState(GcGenerationsWorkload* const& self,Database const& cx) 
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		 : self(self),
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		   cx(cx)
															#line 96 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
	{
		fdb_probe_actor_create("clogRemoteDc", reinterpret_cast<unsigned long>(this));

	}
	~ClogRemoteDcActorState() 
	{
		fdb_probe_actor_destroy("clogRemoteDc", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			StrictFuture<Optional<ClusterConnectionString>> __when_expr_0 = getConnectionString(cx);
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			if (static_cast<ClogRemoteDcActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClogRemoteDcActor*>(this)->actor_wait_state = 1;
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClogRemoteDcActor, 0, Optional<ClusterConnectionString> >*>(static_cast<ClogRemoteDcActor*>(this)));
															#line 118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClogRemoteDcActorState();
		static_cast<ClogRemoteDcActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<ClusterConnectionString> const& csOptional,int loopDepth) 
	{
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		coordinators = std::vector<NetworkAddress>();
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (csOptional.present())
															#line 143 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		{
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			ClusterConnectionString cs = csOptional.get();
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(coordinators, cs.tryResolveHostnames());
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			if (static_cast<ClogRemoteDcActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 151 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClogRemoteDcActor*>(this)->actor_wait_state = 2;
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClogRemoteDcActor, 1, Void >*>(static_cast<ClogRemoteDcActor*>(this)));
															#line 156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<ClusterConnectionString> && csOptional,int loopDepth) 
	{
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		coordinators = std::vector<NetworkAddress>();
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (csOptional.present())
															#line 172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		{
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			ClusterConnectionString cs = csOptional.get();
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(coordinators, cs.tryResolveHostnames());
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			if (static_cast<ClogRemoteDcActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClogRemoteDcActor*>(this)->actor_wait_state = 2;
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClogRemoteDcActor, 1, Void >*>(static_cast<ClogRemoteDcActor*>(this)));
															#line 185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Optional<ClusterConnectionString> const& csOptional,int loopDepth) 
	{
		loopDepth = a_body1cont1(csOptional, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<ClusterConnectionString> && csOptional,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(csOptional), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClogRemoteDcActor*>(this)->actor_wait_state > 0) static_cast<ClogRemoteDcActor*>(this)->actor_wait_state = 0;
		static_cast<ClogRemoteDcActor*>(this)->ActorCallback< ClogRemoteDcActor, 0, Optional<ClusterConnectionString> >::remove();

	}
	void a_callback_fire(ActorCallback< ClogRemoteDcActor, 0, Optional<ClusterConnectionString> >*,Optional<ClusterConnectionString> const& value) 
	{
		fdb_probe_actor_enter("clogRemoteDc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteDc", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClogRemoteDcActor, 0, Optional<ClusterConnectionString> >*,Optional<ClusterConnectionString> && value) 
	{
		fdb_probe_actor_enter("clogRemoteDc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteDc", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClogRemoteDcActor, 0, Optional<ClusterConnectionString> >*,Error err) 
	{
		fdb_probe_actor_enter("clogRemoteDc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteDc", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		auto isCoordinator = [](const std::vector<NetworkAddress>& coordinators, const IPAddress& ip) { for (const auto& c : coordinators) { if (c.ip == ip) { return true; } } return false; };
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		std::vector<IPAddress> ips;
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		std::vector<IPAddress> remoteIps;
															#line 98 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		for( const auto& process : g_simulator->getAllProcesses() ) {
															#line 99 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			const auto& ip = process->address.ip;
															#line 100 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			if (process->locality.dcId().present() && process->locality.dcId() == g_simulator->remoteDcId && !isCoordinator(coordinators, ip))
															#line 284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			{
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
				remoteIps.push_back(ip);
															#line 288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			}
			else
			{
															#line 104 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
				ips.push_back(ip);
															#line 294 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			}
		}
															#line 107 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		ASSERT(ips.size() > 0);
															#line 108 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		ASSERT(remoteIps.size() > 0);
															#line 110 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		for( const auto& ip : ips ) {
															#line 111 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			for( const auto& remoteIp : remoteIps ) {
															#line 112 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
				g_simulator->clogPair(ip, remoteIp, 10000);
															#line 113 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
				g_simulator->clogPair(remoteIp, ip, 10000);
															#line 114 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
				self->cloggedPairs.emplace_back(ip, remoteIp);
															#line 115 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
				self->cloggedPairs.emplace_back(remoteIp, ip);
															#line 313 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			}
		}
															#line 119 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		TraceEvent("PartitionRemoteDc") .detail("RemoteDc", g_simulator->remoteDcId) .detail("CloggedRemoteProcess", describe(remoteIps));
															#line 122 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (!static_cast<ClogRemoteDcActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClogRemoteDcActorState(); static_cast<ClogRemoteDcActor*>(this)->destroy(); return 0; }
															#line 320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		new (&static_cast<ClogRemoteDcActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClogRemoteDcActorState();
		static_cast<ClogRemoteDcActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClogRemoteDcActor*>(this)->actor_wait_state > 0) static_cast<ClogRemoteDcActor*>(this)->actor_wait_state = 0;
		static_cast<ClogRemoteDcActor*>(this)->ActorCallback< ClogRemoteDcActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClogRemoteDcActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogRemoteDc", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteDc", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClogRemoteDcActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogRemoteDc", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteDc", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClogRemoteDcActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogRemoteDc", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogRemoteDc", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	GcGenerationsWorkload* self;
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	Database cx;
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	std::vector<NetworkAddress> coordinators;
															#line 421 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
};
// This generated class is to be used only via clogRemoteDc()
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
class ClogRemoteDcActor final : public Actor<Void>, public ActorCallback< ClogRemoteDcActor, 0, Optional<ClusterConnectionString> >, public ActorCallback< ClogRemoteDcActor, 1, Void >, public FastAllocated<ClogRemoteDcActor>, public ClogRemoteDcActorState<ClogRemoteDcActor> {
															#line 426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
public:
	using FastAllocated<ClogRemoteDcActor>::operator new;
	using FastAllocated<ClogRemoteDcActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6495247624838216960UL, 13174632316141744640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClogRemoteDcActor, 0, Optional<ClusterConnectionString> >;
friend struct ActorCallback< ClogRemoteDcActor, 1, Void >;
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	ClogRemoteDcActor(GcGenerationsWorkload* const& self,Database const& cx) 
															#line 444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		 : Actor<Void>(),
		   ClogRemoteDcActorState<ClogRemoteDcActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clogRemoteDc", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5867324616969827072UL, 17036584522749573888UL);
		ActorExecutionContextHelper __helper(static_cast<ClogRemoteDcActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clogRemoteDc");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clogRemoteDc", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClogRemoteDcActor, 0, Optional<ClusterConnectionString> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClogRemoteDcActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
[[nodiscard]] Future<Void> clogRemoteDc( GcGenerationsWorkload* const& self, Database const& cx ) {
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	return Future<Void>(new ClogRemoteDcActor(self, cx));
															#line 477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
}

#line 124 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"

																#line 482 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
// This generated class is to be used only via dbAvailable()
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
template <class DbAvailableActor>
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
class DbAvailableActorState {
															#line 488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
public:
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	DbAvailableActorState(GcGenerationsWorkload* const& self) 
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		 : self(self)
															#line 495 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
	{
		fdb_probe_actor_create("dbAvailable", reinterpret_cast<unsigned long>(this));

	}
	~DbAvailableActorState() 
	{
		fdb_probe_actor_destroy("dbAvailable", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			;
															#line 510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DbAvailableActorState();
		static_cast<DbAvailableActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 129 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (!static_cast<DbAvailableActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DbAvailableActorState(); static_cast<DbAvailableActor*>(this)->destroy(); return 0; }
															#line 533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		new (&static_cast<DbAvailableActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DbAvailableActorState();
		static_cast<DbAvailableActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 126 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (!(self->dbInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->dbInfo->onChange();
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (static_cast<DbAvailableActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DbAvailableActor*>(this)->actor_wait_state = 1;
															#line 127 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DbAvailableActor, 0, Void >*>(static_cast<DbAvailableActor*>(this)));
															#line 565 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DbAvailableActor*>(this)->actor_wait_state > 0) static_cast<DbAvailableActor*>(this)->actor_wait_state = 0;
		static_cast<DbAvailableActor*>(this)->ActorCallback< DbAvailableActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DbAvailableActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dbAvailable", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DbAvailableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dbAvailable", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DbAvailableActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dbAvailable", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DbAvailableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dbAvailable", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DbAvailableActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dbAvailable", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DbAvailableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dbAvailable", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	GcGenerationsWorkload* self;
															#line 672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
};
// This generated class is to be used only via dbAvailable()
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
class DbAvailableActor final : public Actor<Void>, public ActorCallback< DbAvailableActor, 0, Void >, public FastAllocated<DbAvailableActor>, public DbAvailableActorState<DbAvailableActor> {
															#line 677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
public:
	using FastAllocated<DbAvailableActor>::operator new;
	using FastAllocated<DbAvailableActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6387272154233586176UL, 15335276983954704640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DbAvailableActor, 0, Void >;
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	DbAvailableActor(GcGenerationsWorkload* const& self) 
															#line 694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		 : Actor<Void>(),
		   DbAvailableActorState<DbAvailableActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dbAvailable", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3551237000665768448UL, 3675797406699858688UL);
		ActorExecutionContextHelper __helper(static_cast<DbAvailableActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dbAvailable");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dbAvailable", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DbAvailableActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
[[nodiscard]] Future<Void> dbAvailable( GcGenerationsWorkload* const& self ) {
															#line 125 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	return Future<Void>(new DbAvailableActor(self));
															#line 726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
}

#line 131 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"

																#line 731 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
// This generated class is to be used only via generateMultipleTxnGenerations()
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
template <class GenerateMultipleTxnGenerationsActor>
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
class GenerateMultipleTxnGenerationsActorState {
															#line 737 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
public:
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	GenerateMultipleTxnGenerationsActorState(GcGenerationsWorkload* const& self,Database const& cx) 
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		 : self(self),
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		   cx(cx)
															#line 746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
	{
		fdb_probe_actor_create("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this));

	}
	~GenerateMultipleTxnGenerationsActorState() 
	{
		fdb_probe_actor_destroy("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->clogRemoteDc(self, cx);
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			if (static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state = 1;
															#line 133 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GenerateMultipleTxnGenerationsActor, 0, Void >*>(static_cast<GenerateMultipleTxnGenerationsActor*>(this)));
															#line 768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GenerateMultipleTxnGenerationsActorState();
		static_cast<GenerateMultipleTxnGenerationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		i = 0;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		generationCount = 0;
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		;
															#line 795 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		i = 0;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		generationCount = 0;
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		;
															#line 808 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state > 0) static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state = 0;
		static_cast<GenerateMultipleTxnGenerationsActor*>(this)->ActorCallback< GenerateMultipleTxnGenerationsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GenerateMultipleTxnGenerationsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMultipleTxnGenerationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GenerateMultipleTxnGenerationsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMultipleTxnGenerationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GenerateMultipleTxnGenerationsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMultipleTxnGenerationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 162 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		TraceEvent("AfterMultipleRecovery") .detail("OldGenerationCount", self->dbInfo->get().logSystemConfig.oldTLogs.size());
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (!static_cast<GenerateMultipleTxnGenerationsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GenerateMultipleTxnGenerationsActorState(); static_cast<GenerateMultipleTxnGenerationsActor*>(this)->destroy(); return 0; }
															#line 894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		new (&static_cast<GenerateMultipleTxnGenerationsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GenerateMultipleTxnGenerationsActorState();
		static_cast<GenerateMultipleTxnGenerationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (!(i < 6))
															#line 913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(30);
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state = 2;
															#line 139 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GenerateMultipleTxnGenerationsActor, 1, Void >*>(static_cast<GenerateMultipleTxnGenerationsActor*>(this)));
															#line 926 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		TraceEvent("WaitingForDbAvailable") .detail("Index", i) .detail("RecoveryState", self->dbInfo->get().recoveryState);
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->dbAvailable(self);
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 952 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state = 3;
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GenerateMultipleTxnGenerationsActor, 2, Void >*>(static_cast<GenerateMultipleTxnGenerationsActor*>(this)));
															#line 957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 140 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		TraceEvent("WaitingForDbAvailable") .detail("Index", i) .detail("RecoveryState", self->dbInfo->get().recoveryState);
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->dbAvailable(self);
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state = 3;
															#line 143 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GenerateMultipleTxnGenerationsActor, 2, Void >*>(static_cast<GenerateMultipleTxnGenerationsActor*>(this)));
															#line 975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state > 0) static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state = 0;
		static_cast<GenerateMultipleTxnGenerationsActor*>(this)->ActorCallback< GenerateMultipleTxnGenerationsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GenerateMultipleTxnGenerationsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMultipleTxnGenerationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GenerateMultipleTxnGenerationsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMultipleTxnGenerationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GenerateMultipleTxnGenerationsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMultipleTxnGenerationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		generationCount = self->dbInfo->get().logSystemConfig.oldTLogs.size();
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		TraceEvent("WaitingForDbAvailableDone") .detail("Index", i) .detail("Master", self->dbInfo->get().master.address());
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		g_simulator->rebootProcess(g_simulator->getProcessByAddress(self->dbInfo->get().master.address()), ISimulator::KillType::Reboot);
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		;
															#line 1065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 144 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		generationCount = self->dbInfo->get().logSystemConfig.oldTLogs.size();
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		TraceEvent("WaitingForDbAvailableDone") .detail("Index", i) .detail("Master", self->dbInfo->get().master.address());
															#line 148 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		g_simulator->rebootProcess(g_simulator->getProcessByAddress(self->dbInfo->get().master.address()), ISimulator::KillType::Reboot);
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		;
															#line 1080 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state > 0) static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state = 0;
		static_cast<GenerateMultipleTxnGenerationsActor*>(this)->ActorCallback< GenerateMultipleTxnGenerationsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GenerateMultipleTxnGenerationsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMultipleTxnGenerationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GenerateMultipleTxnGenerationsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMultipleTxnGenerationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GenerateMultipleTxnGenerationsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMultipleTxnGenerationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
															#line 156 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		TraceEvent("CurrentGenerations") .detail("PrevCount", generationCount) .detail("New", self->dbInfo->get().logSystemConfig.oldTLogs.size());
															#line 159 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		ASSERT(self->dbInfo->get().logSystemConfig.oldTLogs.size() > generationCount);
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		generationCount = self->dbInfo->get().logSystemConfig.oldTLogs.size();
															#line 138 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		++i;
															#line 1170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (!(self->dbInfo->get().logSystemConfig.oldTLogs.size() == generationCount || self->dbInfo->get().recoveryState < RecoveryState::RECOVERY_TRANSACTION))
															#line 1186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		{
			return a_body1cont1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->dbInfo->onChange();
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state = 4;
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GenerateMultipleTxnGenerationsActor, 3, Void >*>(static_cast<GenerateMultipleTxnGenerationsActor*>(this)));
															#line 1199 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state > 0) static_cast<GenerateMultipleTxnGenerationsActor*>(this)->actor_wait_state = 0;
		static_cast<GenerateMultipleTxnGenerationsActor*>(this)->ActorCallback< GenerateMultipleTxnGenerationsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GenerateMultipleTxnGenerationsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMultipleTxnGenerationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GenerateMultipleTxnGenerationsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMultipleTxnGenerationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GenerateMultipleTxnGenerationsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMultipleTxnGenerationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	GcGenerationsWorkload* self;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	Database cx;
															#line 134 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	int i;
															#line 136 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	int generationCount;
															#line 1312 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
};
// This generated class is to be used only via generateMultipleTxnGenerations()
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
class GenerateMultipleTxnGenerationsActor final : public Actor<Void>, public ActorCallback< GenerateMultipleTxnGenerationsActor, 0, Void >, public ActorCallback< GenerateMultipleTxnGenerationsActor, 1, Void >, public ActorCallback< GenerateMultipleTxnGenerationsActor, 2, Void >, public ActorCallback< GenerateMultipleTxnGenerationsActor, 3, Void >, public FastAllocated<GenerateMultipleTxnGenerationsActor>, public GenerateMultipleTxnGenerationsActorState<GenerateMultipleTxnGenerationsActor> {
															#line 1317 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
public:
	using FastAllocated<GenerateMultipleTxnGenerationsActor>::operator new;
	using FastAllocated<GenerateMultipleTxnGenerationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1993599238099954176UL, 16468983755611750912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GenerateMultipleTxnGenerationsActor, 0, Void >;
friend struct ActorCallback< GenerateMultipleTxnGenerationsActor, 1, Void >;
friend struct ActorCallback< GenerateMultipleTxnGenerationsActor, 2, Void >;
friend struct ActorCallback< GenerateMultipleTxnGenerationsActor, 3, Void >;
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	GenerateMultipleTxnGenerationsActor(GcGenerationsWorkload* const& self,Database const& cx) 
															#line 1337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		 : Actor<Void>(),
		   GenerateMultipleTxnGenerationsActorState<GenerateMultipleTxnGenerationsActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7141871145588261120UL, 903825206739796992UL);
		ActorExecutionContextHelper __helper(static_cast<GenerateMultipleTxnGenerationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("generateMultipleTxnGenerations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("generateMultipleTxnGenerations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GenerateMultipleTxnGenerationsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GenerateMultipleTxnGenerationsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GenerateMultipleTxnGenerationsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GenerateMultipleTxnGenerationsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
[[nodiscard]] Future<Void> generateMultipleTxnGenerations( GcGenerationsWorkload* const& self, Database const& cx ) {
															#line 132 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	return Future<Void>(new GenerateMultipleTxnGenerationsActor(self, cx));
															#line 1372 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
}

#line 166 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"

																#line 1377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
// This generated class is to be used only via generationReduced()
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
template <class GenerationReducedActor>
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
class GenerationReducedActorState {
															#line 1383 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
public:
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	GenerationReducedActorState(GcGenerationsWorkload* const& self) 
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		 : self(self)
															#line 1390 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
	{
		fdb_probe_actor_create("generationReduced", reinterpret_cast<unsigned long>(this));

	}
	~GenerationReducedActorState() 
	{
		fdb_probe_actor_destroy("generationReduced", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 168 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			TraceEvent("WaitForGenerationReduction") .detail("GenerationCount", self->dbInfo->get().logSystemConfig.oldTLogs.size()) .detail("RecoveryState", self->dbInfo->get().recoveryState);
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			;
															#line 1407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GenerationReducedActorState();
		static_cast<GenerationReducedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 178 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		TraceEvent("WaitForGenerationReduction") .detail("GenerationCount", self->dbInfo->get().logSystemConfig.oldTLogs.size()) .detail("RecoveryState", self->dbInfo->get().recoveryState);
															#line 181 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (!static_cast<GenerationReducedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GenerationReducedActorState(); static_cast<GenerationReducedActor*>(this)->destroy(); return 0; }
															#line 1432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		new (&static_cast<GenerationReducedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GenerationReducedActorState();
		static_cast<GenerationReducedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 171 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (!(self->dbInfo->get().logSystemConfig.oldTLogs.size() > 1 || self->dbInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 1451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 173 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		TraceEvent("WaitForGenerationReduction") .detail("GenerationCount", self->dbInfo->get().logSystemConfig.oldTLogs.size()) .detail("RecoveryState", self->dbInfo->get().recoveryState);
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->dbInfo->onChange();
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (static_cast<GenerationReducedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1461 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GenerationReducedActor*>(this)->actor_wait_state = 1;
															#line 176 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GenerationReducedActor, 0, Void >*>(static_cast<GenerationReducedActor*>(this)));
															#line 1466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GenerationReducedActor*>(this)->actor_wait_state > 0) static_cast<GenerationReducedActor*>(this)->actor_wait_state = 0;
		static_cast<GenerationReducedActor*>(this)->ActorCallback< GenerationReducedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GenerationReducedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("generationReduced", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GenerationReducedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generationReduced", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GenerationReducedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("generationReduced", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GenerationReducedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generationReduced", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GenerationReducedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("generationReduced", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GenerationReducedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("generationReduced", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	GcGenerationsWorkload* self;
															#line 1573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
};
// This generated class is to be used only via generationReduced()
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
class GenerationReducedActor final : public Actor<Void>, public ActorCallback< GenerationReducedActor, 0, Void >, public FastAllocated<GenerationReducedActor>, public GenerationReducedActorState<GenerationReducedActor> {
															#line 1578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
public:
	using FastAllocated<GenerationReducedActor>::operator new;
	using FastAllocated<GenerationReducedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12344821248758943744UL, 4960317492977267712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GenerationReducedActor, 0, Void >;
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	GenerationReducedActor(GcGenerationsWorkload* const& self) 
															#line 1595 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		 : Actor<Void>(),
		   GenerationReducedActorState<GenerationReducedActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("generationReduced", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10424236528033074432UL, 14461634684345356032UL);
		ActorExecutionContextHelper __helper(static_cast<GenerationReducedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("generationReduced");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("generationReduced", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GenerationReducedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
[[nodiscard]] Future<Void> generationReduced( GcGenerationsWorkload* const& self ) {
															#line 167 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	return Future<Void>(new GenerationReducedActor(self));
															#line 1627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
}

#line 183 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"

																#line 1632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
// This generated class is to be used only via gcGenerationsTestClient()
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
template <class GcGenerationsTestClientActor>
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
class GcGenerationsTestClientActorState {
															#line 1638 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
public:
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	GcGenerationsTestClientActorState(GcGenerationsWorkload* const& self,Database const& cx) 
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		 : self(self),
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		   cx(cx)
															#line 1647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
	{
		fdb_probe_actor_create("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this));

	}
	~GcGenerationsTestClientActorState() 
	{
		fdb_probe_actor_destroy("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 185 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			g_simulator->disableTLogRecoveryFinish = true;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->startDelay);
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			if (static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1666 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state = 1;
															#line 187 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GcGenerationsTestClientActor, 0, Void >*>(static_cast<GcGenerationsTestClientActor*>(this)));
															#line 1671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GcGenerationsTestClientActorState();
		static_cast<GcGenerationsTestClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		TraceEvent("WaitingForDbAvailable").detail("RecoveryState", self->dbInfo->get().recoveryState);
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		;
															#line 1696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 189 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		TraceEvent("WaitingForDbAvailable").detail("RecoveryState", self->dbInfo->get().recoveryState);
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		;
															#line 1707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state > 0) static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state = 0;
		static_cast<GcGenerationsTestClientActor*>(this)->ActorCallback< GcGenerationsTestClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GcGenerationsTestClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GcGenerationsTestClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GcGenerationsTestClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 194 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		double startTime = now();
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		double workloadEnd = now() + self->testDuration;
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		TraceEvent("GcGenerations").detail("StartTime", startTime).detail("EndTime", workloadEnd);
															#line 199 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		extendConnectionFailures("GcGenerations", FLOW_KNOBS->SIM_SPEEDUP_AFTER_SECONDS);
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->generateMultipleTxnGenerations(self, cx);
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1801 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state = 3;
															#line 201 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GcGenerationsTestClientActor, 2, Void >*>(static_cast<GcGenerationsTestClientActor*>(this)));
															#line 1806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (!(self->dbInfo->get().recoveryState < RecoveryState::ACCEPTING_COMMITS))
															#line 1822 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->dbInfo->onChange();
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state = 2;
															#line 191 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GcGenerationsTestClientActor, 1, Void >*>(static_cast<GcGenerationsTestClientActor*>(this)));
															#line 1835 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state > 0) static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state = 0;
		static_cast<GcGenerationsTestClientActor*>(this)->ActorCallback< GcGenerationsTestClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GcGenerationsTestClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GcGenerationsTestClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GcGenerationsTestClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		self->unclogAll();
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		disableConnectionFailures("GcGenerations");
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->generationReduced(self);
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state = 4;
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GcGenerationsTestClientActor, 3, Void >*>(static_cast<GcGenerationsTestClientActor*>(this)));
															#line 1955 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		self->unclogAll();
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		disableConnectionFailures("GcGenerations");
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->generationReduced(self);
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state = 4;
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GcGenerationsTestClientActor, 3, Void >*>(static_cast<GcGenerationsTestClientActor*>(this)));
															#line 1975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state > 0) static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state = 0;
		static_cast<GcGenerationsTestClientActor*>(this)->ActorCallback< GcGenerationsTestClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GcGenerationsTestClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GcGenerationsTestClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GcGenerationsTestClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		g_simulator->disableTLogRecoveryFinish = false;
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		TraceEvent("WaitingForDbFullyRecovered").detail("RecoveryState", self->dbInfo->get().recoveryState);
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		;
															#line 2063 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		g_simulator->disableTLogRecoveryFinish = false;
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		TraceEvent("WaitingForDbFullyRecovered").detail("RecoveryState", self->dbInfo->get().recoveryState);
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		;
															#line 2076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state > 0) static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state = 0;
		static_cast<GcGenerationsTestClientActor*>(this)->ActorCallback< GcGenerationsTestClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GcGenerationsTestClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GcGenerationsTestClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GcGenerationsTestClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		TraceEvent("GcGenerationsWorkloadFinish").log();
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (!static_cast<GcGenerationsTestClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GcGenerationsTestClientActorState(); static_cast<GcGenerationsTestClientActor*>(this)->destroy(); return 0; }
															#line 2162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		new (&static_cast<GcGenerationsTestClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GcGenerationsTestClientActorState();
		static_cast<GcGenerationsTestClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (!(self->dbInfo->get().recoveryState != RecoveryState::FULLY_RECOVERED))
															#line 2181 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->dbInfo->onChange();
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		if (static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state = 5;
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GcGenerationsTestClientActor, 4, Void >*>(static_cast<GcGenerationsTestClientActor*>(this)));
															#line 2194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state > 0) static_cast<GcGenerationsTestClientActor*>(this)->actor_wait_state = 0;
		static_cast<GcGenerationsTestClientActor*>(this)->ActorCallback< GcGenerationsTestClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GcGenerationsTestClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GcGenerationsTestClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GcGenerationsTestClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	GcGenerationsWorkload* self;
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	Database cx;
															#line 2303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
};
// This generated class is to be used only via gcGenerationsTestClient()
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
class GcGenerationsTestClientActor final : public Actor<Void>, public ActorCallback< GcGenerationsTestClientActor, 0, Void >, public ActorCallback< GcGenerationsTestClientActor, 1, Void >, public ActorCallback< GcGenerationsTestClientActor, 2, Void >, public ActorCallback< GcGenerationsTestClientActor, 3, Void >, public ActorCallback< GcGenerationsTestClientActor, 4, Void >, public FastAllocated<GcGenerationsTestClientActor>, public GcGenerationsTestClientActorState<GcGenerationsTestClientActor> {
															#line 2308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
public:
	using FastAllocated<GcGenerationsTestClientActor>::operator new;
	using FastAllocated<GcGenerationsTestClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9935651910472242176UL, 7494704020282790144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GcGenerationsTestClientActor, 0, Void >;
friend struct ActorCallback< GcGenerationsTestClientActor, 1, Void >;
friend struct ActorCallback< GcGenerationsTestClientActor, 2, Void >;
friend struct ActorCallback< GcGenerationsTestClientActor, 3, Void >;
friend struct ActorCallback< GcGenerationsTestClientActor, 4, Void >;
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	GcGenerationsTestClientActor(GcGenerationsWorkload* const& self,Database const& cx) 
															#line 2329 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
		 : Actor<Void>(),
		   GcGenerationsTestClientActorState<GcGenerationsTestClientActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1350947391055559936UL, 3949261457655595776UL);
		ActorExecutionContextHelper __helper(static_cast<GcGenerationsTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("gcGenerationsTestClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("gcGenerationsTestClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GcGenerationsTestClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GcGenerationsTestClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GcGenerationsTestClientActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GcGenerationsTestClientActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GcGenerationsTestClientActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
[[nodiscard]] Future<Void> gcGenerationsTestClient( GcGenerationsWorkload* const& self, Database const& cx ) {
															#line 184 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
	return Future<Void>(new GcGenerationsTestClientActor(self, cx));
															#line 2365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/GcGenerations.actor.g.cpp"
}

#line 217 "/Users/ec2-user/foundationdb/fdbserver/workloads/GcGenerations.actor.cpp"
};

WorkloadFactory<GcGenerationsWorkload> GcGenerationsWorkloadFactory;