#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
/*
 * ChangeFeeds.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/Arena.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/serialize.h"
#include <cstring>
#include <limits>

#include "flow/actorcompiler.h" // This must be the last #include.

															#line 39 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
namespace {
// This generated class is to be used only via readDatabase()
															#line 37 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
template <class ReadDatabaseActor>
															#line 37 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
class ReadDatabaseActorState {
															#line 46 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
public:
															#line 37 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	ReadDatabaseActorState(Database const& cx) 
															#line 37 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
															#line 37 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		 : cx(cx),
															#line 38 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		   tr(cx)
															#line 55 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
	{
		fdb_probe_actor_create("readDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ReadDatabaseActorState() 
	{
		fdb_probe_actor_destroy("readDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 39 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			;
															#line 70 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadDatabaseActorState();
		static_cast<ReadDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		output = Standalone<VectorRef<KeyValueRef>>();
															#line 41 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		readVersion = Version();
															#line 102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		try {
															#line 43 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 43 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			if (static_cast<ReadDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 108 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadDatabaseActor*>(this)->actor_wait_state = 1;
															#line 43 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadDatabaseActor, 0, Version >*>(static_cast<ReadDatabaseActor*>(this)));
															#line 113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 55 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			{
															#line 56 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				if (!static_cast<ReadDatabaseActor*>(this)->SAV<std::pair<Standalone<VectorRef<KeyValueRef>>, Version>>::futures) { (void)(std::make_pair(output, readVersion)); this->~ReadDatabaseActorState(); static_cast<ReadDatabaseActor*>(this)->destroy(); return 0; }
															#line 139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
				new (&static_cast<ReadDatabaseActor*>(this)->SAV< std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >::value()) std::pair<Standalone<VectorRef<KeyValueRef>>, Version>(std::make_pair(output, readVersion));
				this->~ReadDatabaseActorState();
				static_cast<ReadDatabaseActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			if (static_cast<ReadDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 149 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ReadDatabaseActor*>(this)->actor_wait_state = 3;
															#line 58 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadDatabaseActor, 2, Void >*>(static_cast<ReadDatabaseActor*>(this)));
															#line 154 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& ver,int loopDepth) 
	{
															#line 44 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		readVersion = ver;
															#line 46 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		results = PromiseStream<Standalone<RangeResultRef>>();
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		stream = tr.getRangeStream(results, normalKeys, GetRangeLimits());
															#line 49 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		;
															#line 175 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && ver,int loopDepth) 
	{
															#line 44 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		readVersion = ver;
															#line 46 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		results = PromiseStream<Standalone<RangeResultRef>>();
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		stream = tr.getRangeStream(results, normalKeys, GetRangeLimits());
															#line 49 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		;
															#line 190 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& ver,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ver, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && ver,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ver), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ReadDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ReadDatabaseActor*>(this)->ActorCallback< ReadDatabaseActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ReadDatabaseActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("readDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadDatabaseActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("readDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadDatabaseActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("readDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 50 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		auto __when_expr_1 = results.getFuture();
															#line 281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<Standalone<RangeResultRef>>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<Standalone<RangeResultRef>>>::value, "invalid type");
															#line 50 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		if (static_cast<ReadDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 285 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.pop(), loopDepth); };
		static_cast<ReadDatabaseActor*>(this)->actor_wait_state = 2;
															#line 50 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ReadDatabaseActor, 1, Standalone<RangeResultRef> >*>(static_cast<ReadDatabaseActor*>(this)));
															#line 290 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Standalone<RangeResultRef> const& res,int loopDepth) 
	{
															#line 51 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		output.arena().dependsOn(res.arena());
															#line 52 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		output.append(output.arena(), res.begin(), res.size());
															#line 301 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Standalone<RangeResultRef> && res,int loopDepth) 
	{
															#line 51 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		output.arena().dependsOn(res.arena());
															#line 52 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		output.append(output.arena(), res.begin(), res.size());
															#line 312 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Standalone<RangeResultRef> const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Standalone<RangeResultRef> && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ReadDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ReadDatabaseActor*>(this)->ActorSingleCallback< ReadDatabaseActor, 1, Standalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ReadDatabaseActor, 1, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("readDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ReadDatabaseActor, 1, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("readDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ReadDatabaseActor, 1, Standalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("readDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ReadDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ReadDatabaseActor*>(this)->ActorCallback< ReadDatabaseActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadDatabaseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadDatabaseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadDatabaseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 37 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Database cx;
															#line 38 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Transaction tr;
															#line 40 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> output;
															#line 41 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Version readVersion;
															#line 46 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	PromiseStream<Standalone<RangeResultRef>> results;
															#line 47 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Future<Void> stream;
															#line 491 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
};
// This generated class is to be used only via readDatabase()
															#line 37 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
class ReadDatabaseActor final : public Actor<std::pair<Standalone<VectorRef<KeyValueRef>>, Version>>, public ActorCallback< ReadDatabaseActor, 0, Version >, public ActorSingleCallback< ReadDatabaseActor, 1, Standalone<RangeResultRef> >, public ActorCallback< ReadDatabaseActor, 2, Void >, public FastAllocated<ReadDatabaseActor>, public ReadDatabaseActorState<ReadDatabaseActor> {
															#line 496 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
public:
	using FastAllocated<ReadDatabaseActor>::operator new;
	using FastAllocated<ReadDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14130303107099724288UL, 2593417161616118784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<Standalone<VectorRef<KeyValueRef>>, Version>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadDatabaseActor, 0, Version >;
friend struct ActorSingleCallback< ReadDatabaseActor, 1, Standalone<RangeResultRef> >;
friend struct ActorCallback< ReadDatabaseActor, 2, Void >;
															#line 37 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	ReadDatabaseActor(Database const& cx) 
															#line 515 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		 : Actor<std::pair<Standalone<VectorRef<KeyValueRef>>, Version>>(),
		   ReadDatabaseActorState<ReadDatabaseActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16521614789302715392UL, 4577999174448396032UL);
		ActorExecutionContextHelper __helper(static_cast<ReadDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadDatabaseActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< ReadDatabaseActor, 1, Standalone<RangeResultRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadDatabaseActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 37 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
[[nodiscard]] Future<std::pair<Standalone<VectorRef<KeyValueRef>>, Version>> readDatabase( Database const& cx ) {
															#line 37 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	return Future<std::pair<Standalone<VectorRef<KeyValueRef>>, Version>>(new ReadDatabaseActor(cx));
															#line 550 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
}

#line 62 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"

															#line 555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
namespace {
// This generated class is to be used only via readMutations()
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
template <class ReadMutationsActor>
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
class ReadMutationsActorState {
															#line 562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
public:
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	ReadMutationsActorState(Database const& cx,Key const& rangeID,Promise<Version> const& end) 
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		 : cx(cx),
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		   rangeID(rangeID),
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		   end(end),
															#line 66 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		   begin(0),
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		   output()
															#line 577 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
	{
		fdb_probe_actor_create("readMutations", reinterpret_cast<unsigned long>(this));

	}
	~ReadMutationsActorState() 
	{
		fdb_probe_actor_destroy("readMutations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			;
															#line 592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadMutationsActorState();
		static_cast<ReadMutationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			results = makeReference<ChangeFeedData>();
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			stream = cx->getChangeFeedStream(results, rangeID, begin, std::numeric_limits<Version>::max(), normalKeys);
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			;
															#line 627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 102 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		auto __when_expr_0 = results->mutations.getFuture();
															#line 664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<Standalone<VectorRef<MutationsAndVersionRef>>>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<Standalone<VectorRef<MutationsAndVersionRef>>>>::value, "invalid type");
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		if (static_cast<ReadMutationsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		StrictFuture<Void> __when_expr_1 = end.isSet() ? Future<Void>(Never()) : success(end.getFuture());
															#line 672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		StrictFuture<Void> __when_expr_2 = !end.isSet() ? Future<Void>(Never()) : results->whenAtLeast(end.getFuture().get());
															#line 676 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<ReadMutationsActor*>(this)->actor_wait_state = 1;
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ReadMutationsActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >*>(static_cast<ReadMutationsActor*>(this)));
															#line 95 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadMutationsActor, 1, Void >*>(static_cast<ReadMutationsActor*>(this)));
															#line 96 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadMutationsActor, 2, Void >*>(static_cast<ReadMutationsActor*>(this)));
															#line 685 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<VectorRef<MutationsAndVersionRef>> const& res,int loopDepth) 
	{
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		output.arena().dependsOn(res.arena());
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		for( auto& it : res ) {
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			if (it.mutations.size() == 1 && it.mutations.back().param1 == lastEpochEndPrivateKey)
															#line 704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			{
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				Version rollbackVersion;
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				BinaryReader br(it.mutations.back().param2, Unversioned());
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				br >> rollbackVersion;
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				TraceEvent("ChangeFeedRollback") .detail("Ver", it.version) .detail("RollbackVer", rollbackVersion);
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				for(;output.size() && output.back().version > rollbackVersion;) {
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
					TraceEvent("ChangeFeedRollbackVer").detail("Ver", output.back().version);
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
					output.pop_back();
															#line 720 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
				}
			}
			else
			{
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				output.push_back(output.arena(), it);
															#line 727 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			}
		}
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		begin = res.back().version + 1;
															#line 732 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<VectorRef<MutationsAndVersionRef>> && res,int loopDepth) 
	{
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		output.arena().dependsOn(res.arena());
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		for( auto& it : res ) {
															#line 78 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			if (it.mutations.size() == 1 && it.mutations.back().param1 == lastEpochEndPrivateKey)
															#line 745 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			{
															#line 79 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				Version rollbackVersion;
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				BinaryReader br(it.mutations.back().param2, Unversioned());
															#line 81 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				br >> rollbackVersion;
															#line 82 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				TraceEvent("ChangeFeedRollback") .detail("Ver", it.version) .detail("RollbackVer", rollbackVersion);
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				for(;output.size() && output.back().version > rollbackVersion;) {
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
					TraceEvent("ChangeFeedRollbackVer").detail("Ver", output.back().version);
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
					output.pop_back();
															#line 761 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
				}
			}
			else
			{
															#line 90 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				output.push_back(output.arena(), it);
															#line 768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			}
		}
															#line 93 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		begin = res.back().version + 1;
															#line 773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		if (!static_cast<ReadMutationsActor*>(this)->SAV<Standalone<VectorRef<MutationsAndVersionRef>>>::futures) { (void)(output); this->~ReadMutationsActorState(); static_cast<ReadMutationsActor*>(this)->destroy(); return 0; }
															#line 794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		new (&static_cast<ReadMutationsActor*>(this)->SAV< Standalone<VectorRef<MutationsAndVersionRef>> >::value()) Standalone<VectorRef<MutationsAndVersionRef>>(std::move(output)); // state_var_RVO
		this->~ReadMutationsActorState();
		static_cast<ReadMutationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 97 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		if (!static_cast<ReadMutationsActor*>(this)->SAV<Standalone<VectorRef<MutationsAndVersionRef>>>::futures) { (void)(output); this->~ReadMutationsActorState(); static_cast<ReadMutationsActor*>(this)->destroy(); return 0; }
															#line 806 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		new (&static_cast<ReadMutationsActor*>(this)->SAV< Standalone<VectorRef<MutationsAndVersionRef>> >::value()) Standalone<VectorRef<MutationsAndVersionRef>>(std::move(output)); // state_var_RVO
		this->~ReadMutationsActorState();
		static_cast<ReadMutationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadMutationsActor*>(this)->actor_wait_state > 0) static_cast<ReadMutationsActor*>(this)->actor_wait_state = 0;
		static_cast<ReadMutationsActor*>(this)->ActorSingleCallback< ReadMutationsActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >::remove();
		static_cast<ReadMutationsActor*>(this)->ActorCallback< ReadMutationsActor, 1, Void >::remove();
		static_cast<ReadMutationsActor*>(this)->ActorCallback< ReadMutationsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ReadMutationsActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >*,Standalone<VectorRef<MutationsAndVersionRef>> const& value) 
	{
		fdb_probe_actor_enter("readMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ReadMutationsActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >*,Standalone<VectorRef<MutationsAndVersionRef>> && value) 
	{
		fdb_probe_actor_enter("readMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ReadMutationsActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("readMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadMutationsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readMutations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMutations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadMutationsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readMutations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMutations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadMutationsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readMutations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMutations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadMutationsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readMutations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMutations", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadMutationsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readMutations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMutations", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadMutationsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readMutations", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMutations", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Database cx;
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Key rangeID;
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Promise<Version> end;
															#line 66 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Version begin;
															#line 67 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Standalone<VectorRef<MutationsAndVersionRef>> output;
															#line 70 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Reference<ChangeFeedData> results;
															#line 71 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Future<Void> stream;
															#line 1007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
};
// This generated class is to be used only via readMutations()
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
class ReadMutationsActor final : public Actor<Standalone<VectorRef<MutationsAndVersionRef>>>, public ActorSingleCallback< ReadMutationsActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >, public ActorCallback< ReadMutationsActor, 1, Void >, public ActorCallback< ReadMutationsActor, 2, Void >, public FastAllocated<ReadMutationsActor>, public ReadMutationsActorState<ReadMutationsActor> {
															#line 1012 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
public:
	using FastAllocated<ReadMutationsActor>::operator new;
	using FastAllocated<ReadMutationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10917388627037243904UL, 4254233050740631296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<MutationsAndVersionRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ReadMutationsActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >;
friend struct ActorCallback< ReadMutationsActor, 1, Void >;
friend struct ActorCallback< ReadMutationsActor, 2, Void >;
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	ReadMutationsActor(Database const& cx,Key const& rangeID,Promise<Version> const& end) 
															#line 1031 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		 : Actor<Standalone<VectorRef<MutationsAndVersionRef>>>(),
		   ReadMutationsActorState<ReadMutationsActor>(cx, rangeID, end),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readMutations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1847176066023197440UL, 6444783185146314752UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readMutations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readMutations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ReadMutationsActor, 0, Standalone<VectorRef<MutationsAndVersionRef>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
[[nodiscard]] Future<Standalone<VectorRef<MutationsAndVersionRef>>> readMutations( Database const& cx, Key const& rangeID, Promise<Version> const& end ) {
															#line 63 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	return Future<Standalone<VectorRef<MutationsAndVersionRef>>>(new ReadMutationsActor(cx, rangeID, end));
															#line 1064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
}

#line 106 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"

Standalone<VectorRef<KeyValueRef>> advanceData(Standalone<VectorRef<KeyValueRef>> source,
                                               Standalone<VectorRef<MutationsAndVersionRef>> mutations,
                                               Version begin,
                                               Version end) {
	StringRef dbgKey = ""_sr;
	std::map<KeyRef, ValueRef> data;
	for (auto& kv : source) {
		if (kv.key == dbgKey)
			TraceEvent("ChangeFeedDbgStart").detail("K", kv.key).detail("V", kv.value);
		data[kv.key] = kv.value;
	}
	for (auto& it : mutations) {
		if (it.version > begin && it.version <= end) {
			for (auto& m : it.mutations) {
				if (m.type == MutationRef::SetValue) {
					if (m.param1 == dbgKey)
						TraceEvent("ChangeFeedDbgSet")
						    .detail("Ver", it.version)
						    .detail("K", m.param1)
						    .detail("V", m.param2);
					data[m.param1] = m.param2;
				} else {
					ASSERT(m.type == MutationRef::ClearRange);
					if (KeyRangeRef(m.param1, m.param2).contains(dbgKey))
						TraceEvent("ChangeFeedDbgClear")
						    .detail("Ver", it.version)
						    .detail("Begin", m.param1)
						    .detail("End", m.param2);
					data.erase(data.lower_bound(m.param1), data.lower_bound(m.param2));
				}
			}
		}
	}
	Standalone<VectorRef<KeyValueRef>> output;
	output.arena().dependsOn(source.arena());
	output.arena().dependsOn(mutations.arena());
	for (auto& kv : data) {
		output.push_back(output.arena(), KeyValueRef(kv.first, kv.second));
	}
	return output;
}

bool compareData(Standalone<VectorRef<KeyValueRef>> source, Standalone<VectorRef<KeyValueRef>> dest) {
	if (source.size() != dest.size()) {
		TraceEvent(SevError, "ChangeFeedSizeMismatch").detail("SrcSize", source.size()).detail("DestSize", dest.size());
	}
	for (int i = 0; i < std::min(source.size(), dest.size()); i++) {
		if (source[i] != dest[i]) {
			TraceEvent("ChangeFeedMutationMismatch")
			    .detail("Index", i)
			    .detail("SrcKey", source[i].key)
			    .detail("DestKey", dest[i].key)
			    .detail("SrcValue", source[i].value)
			    .detail("DestValue", dest[i].value);
			return false;
		}
	}
	return source.size() == dest.size();
}

struct ChangeFeedsWorkload : TestWorkload {
	static constexpr auto NAME = "ChangeFeeds";
	double testDuration;
	Future<Void> client;

	ChangeFeedsWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override {
		if (clientId == 0) {
			client = changeFeedClient(cx->clone(), this);
			return delay(testDuration);
		}
		return Void();
	}
	Future<bool> check(Database const& cx) override {
		client = Future<Void>();
		return true;
	}
	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 1152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
// This generated class is to be used only via changeFeedClient()
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
template <class ChangeFeedClientActor>
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
class ChangeFeedClientActorState {
															#line 1158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
public:
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	ChangeFeedClientActorState(Database const& cx,ChangeFeedsWorkload* const& self) 
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		 : cx(cx),
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		   self(self),
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		   rangeID(StringRef(deterministicRandom()->randomUniqueID().toString()))
															#line 1169 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
	{
		fdb_probe_actor_create("changeFeedClient", reinterpret_cast<unsigned long>(this));

	}
	~ChangeFeedClientActorState() 
	{
		fdb_probe_actor_destroy("changeFeedClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			StrictFuture<Void> __when_expr_0 = updateChangeFeed(cx, rangeID, ChangeFeedStatus::CHANGE_FEED_CREATE, normalKeys);
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1186 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 1;
															#line 193 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedClientActor, 0, Void >*>(static_cast<ChangeFeedClientActor*>(this)));
															#line 1191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeFeedClientActorState();
		static_cast<ChangeFeedClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		;
															#line 1214 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 195 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		;
															#line 1223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedClientActor*>(this)->ActorCallback< ChangeFeedClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeFeedClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeFeedClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		endVersion = Promise<Version>();
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		fMutations = readMutations(cx, rangeID, endVersion);
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(deterministicRandom()->random01());
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1320 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 2;
															#line 200 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedClientActor, 1, Void >*>(static_cast<ChangeFeedClientActor*>(this)));
															#line 1325 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		StrictFuture<std::pair<Standalone<VectorRef<KeyValueRef>>, Version>> __when_expr_2 = readDatabase(cx);
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1336 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 3;
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedClientActor, 2, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >*>(static_cast<ChangeFeedClientActor*>(this)));
															#line 1341 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		StrictFuture<std::pair<Standalone<VectorRef<KeyValueRef>>, Version>> __when_expr_2 = readDatabase(cx);
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 3;
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedClientActor, 2, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >*>(static_cast<ChangeFeedClientActor*>(this)));
															#line 1357 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedClientActor*>(this)->ActorCallback< ChangeFeedClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeFeedClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeFeedClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 203 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		TraceEvent("ChangeFeedReadDB").detail("Ver1", firstResults.second);
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(10 * deterministicRandom()->random01());
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 4;
															#line 205 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedClientActor, 3, Void >*>(static_cast<ChangeFeedClientActor*>(this)));
															#line 1450 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(std::pair<Standalone<VectorRef<KeyValueRef>>, Version> const& __firstResults,int loopDepth) 
	{
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		firstResults = __firstResults;
															#line 1459 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(std::pair<Standalone<VectorRef<KeyValueRef>>, Version> && __firstResults,int loopDepth) 
	{
		firstResults = std::move(__firstResults);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedClientActor*>(this)->ActorCallback< ChangeFeedClientActor, 2, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedClientActor, 2, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >*,std::pair<Standalone<VectorRef<KeyValueRef>>, Version> const& value) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangeFeedClientActor, 2, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >*,std::pair<Standalone<VectorRef<KeyValueRef>>, Version> && value) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangeFeedClientActor, 2, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		StrictFuture<std::pair<Standalone<VectorRef<KeyValueRef>>, Version>> __when_expr_4 = readDatabase(cx);
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 5;
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedClientActor, 4, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >*>(static_cast<ChangeFeedClientActor*>(this)));
															#line 1545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		StrictFuture<std::pair<Standalone<VectorRef<KeyValueRef>>, Version>> __when_expr_4 = readDatabase(cx);
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
		static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 5;
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedClientActor, 4, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >*>(static_cast<ChangeFeedClientActor*>(this)));
															#line 1561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedClientActor*>(this)->ActorCallback< ChangeFeedClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangeFeedClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangeFeedClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
															#line 208 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		TraceEvent("ChangeFeedReadDB").detail("Ver2", secondResults.second);
															#line 209 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		endVersion.send(secondResults.second + 1);
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		StrictFuture<Standalone<VectorRef<MutationsAndVersionRef>>> __when_expr_5 = fMutations;
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont4when1(__when_expr_5.get(), loopDepth); };
		static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 6;
															#line 210 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedClientActor, 5, Standalone<VectorRef<MutationsAndVersionRef>> >*>(static_cast<ChangeFeedClientActor*>(this)));
															#line 1656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(std::pair<Standalone<VectorRef<KeyValueRef>>, Version> const& __secondResults,int loopDepth) 
	{
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		secondResults = __secondResults;
															#line 1665 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(std::pair<Standalone<VectorRef<KeyValueRef>>, Version> && __secondResults,int loopDepth) 
	{
		secondResults = std::move(__secondResults);
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedClientActor*>(this)->ActorCallback< ChangeFeedClientActor, 4, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedClientActor, 4, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >*,std::pair<Standalone<VectorRef<KeyValueRef>>, Version> const& value) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ChangeFeedClientActor, 4, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >*,std::pair<Standalone<VectorRef<KeyValueRef>>, Version> && value) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ChangeFeedClientActor, 4, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont5(Standalone<VectorRef<MutationsAndVersionRef>> const& mutations,int loopDepth) 
	{
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		Standalone<VectorRef<KeyValueRef>> advancedResults = advanceData(firstResults.first, mutations, firstResults.second, secondResults.second);
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		if (!compareData(secondResults.first, advancedResults))
															#line 1746 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		{
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			TraceEvent(SevError, "ChangeFeedMismatch") .detail("FirstVersion", firstResults.second) .detail("SecondVersion", secondResults.second);
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			for(int i = 0;i < secondResults.first.size();i++) {
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				TraceEvent("ChangeFeedBase") .detail("Index", i) .detail("K", secondResults.first[i].key) .detail("V", secondResults.first[i].value);
															#line 1754 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			}
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			for(int i = 0;i < advancedResults.size();i++) {
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				TraceEvent("ChangeFeedAdvanced") .detail("Index", i) .detail("K", advancedResults[i].key) .detail("V", advancedResults[i].value);
															#line 1760 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			}
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			ASSERT(false);
															#line 1764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		}
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		StrictFuture<Void> __when_expr_6 = cx->popChangeFeedMutations(rangeID, secondResults.second);
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1770 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont5when1(__when_expr_6.get(), loopDepth); };
		static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 7;
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedClientActor, 6, Void >*>(static_cast<ChangeFeedClientActor*>(this)));
															#line 1775 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Standalone<VectorRef<MutationsAndVersionRef>> && mutations,int loopDepth) 
	{
															#line 211 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		Standalone<VectorRef<KeyValueRef>> advancedResults = advanceData(firstResults.first, mutations, firstResults.second, secondResults.second);
															#line 214 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		if (!compareData(secondResults.first, advancedResults))
															#line 1786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		{
															#line 215 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			TraceEvent(SevError, "ChangeFeedMismatch") .detail("FirstVersion", firstResults.second) .detail("SecondVersion", secondResults.second);
															#line 218 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			for(int i = 0;i < secondResults.first.size();i++) {
															#line 219 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				TraceEvent("ChangeFeedBase") .detail("Index", i) .detail("K", secondResults.first[i].key) .detail("V", secondResults.first[i].value);
															#line 1794 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			}
															#line 224 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			for(int i = 0;i < advancedResults.size();i++) {
															#line 225 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
				TraceEvent("ChangeFeedAdvanced") .detail("Index", i) .detail("K", advancedResults[i].key) .detail("V", advancedResults[i].value);
															#line 1800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
			}
															#line 230 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
			ASSERT(false);
															#line 1804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		}
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		StrictFuture<Void> __when_expr_6 = cx->popChangeFeedMutations(rangeID, secondResults.second);
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1810 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont5when1(__when_expr_6.get(), loopDepth); };
		static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 7;
															#line 233 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedClientActor, 6, Void >*>(static_cast<ChangeFeedClientActor*>(this)));
															#line 1815 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Standalone<VectorRef<MutationsAndVersionRef>> const& mutations,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(mutations, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Standalone<VectorRef<MutationsAndVersionRef>> && mutations,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(mutations), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedClientActor*>(this)->ActorCallback< ChangeFeedClientActor, 5, Standalone<VectorRef<MutationsAndVersionRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedClientActor, 5, Standalone<VectorRef<MutationsAndVersionRef>> >*,Standalone<VectorRef<MutationsAndVersionRef>> const& value) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ChangeFeedClientActor, 5, Standalone<VectorRef<MutationsAndVersionRef>> >*,Standalone<VectorRef<MutationsAndVersionRef>> && value) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ChangeFeedClientActor, 5, Standalone<VectorRef<MutationsAndVersionRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ChangeFeedClientActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedClientActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedClientActor*>(this)->ActorCallback< ChangeFeedClientActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedClientActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ChangeFeedClientActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ChangeFeedClientActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Database cx;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	ChangeFeedsWorkload* self;
															#line 192 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Key rangeID;
															#line 196 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Promise<Version> endVersion;
															#line 197 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	Future<Standalone<VectorRef<MutationsAndVersionRef>>> fMutations;
															#line 202 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	std::pair<Standalone<VectorRef<KeyValueRef>>, Version> firstResults;
															#line 207 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	std::pair<Standalone<VectorRef<KeyValueRef>>, Version> secondResults;
															#line 1996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
};
// This generated class is to be used only via changeFeedClient()
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
class ChangeFeedClientActor final : public Actor<Void>, public ActorCallback< ChangeFeedClientActor, 0, Void >, public ActorCallback< ChangeFeedClientActor, 1, Void >, public ActorCallback< ChangeFeedClientActor, 2, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >, public ActorCallback< ChangeFeedClientActor, 3, Void >, public ActorCallback< ChangeFeedClientActor, 4, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >, public ActorCallback< ChangeFeedClientActor, 5, Standalone<VectorRef<MutationsAndVersionRef>> >, public ActorCallback< ChangeFeedClientActor, 6, Void >, public FastAllocated<ChangeFeedClientActor>, public ChangeFeedClientActorState<ChangeFeedClientActor> {
															#line 2001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
public:
	using FastAllocated<ChangeFeedClientActor>::operator new;
	using FastAllocated<ChangeFeedClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10046427857022267136UL, 1413958521929904384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeFeedClientActor, 0, Void >;
friend struct ActorCallback< ChangeFeedClientActor, 1, Void >;
friend struct ActorCallback< ChangeFeedClientActor, 2, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >;
friend struct ActorCallback< ChangeFeedClientActor, 3, Void >;
friend struct ActorCallback< ChangeFeedClientActor, 4, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >;
friend struct ActorCallback< ChangeFeedClientActor, 5, Standalone<VectorRef<MutationsAndVersionRef>> >;
friend struct ActorCallback< ChangeFeedClientActor, 6, Void >;
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	ChangeFeedClientActor(Database const& cx,ChangeFeedsWorkload* const& self) 
															#line 2024 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeFeedClientActorState<ChangeFeedClientActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeFeedClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3089155111868823040UL, 1626874736782956032UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeFeedClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeFeedClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeFeedClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeFeedClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangeFeedClientActor, 2, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangeFeedClientActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ChangeFeedClientActor, 4, std::pair<Standalone<VectorRef<KeyValueRef>>, Version> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ChangeFeedClientActor, 5, Standalone<VectorRef<MutationsAndVersionRef>> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ChangeFeedClientActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
[[nodiscard]] Future<Void> changeFeedClient( Database const& cx, ChangeFeedsWorkload* const& self ) {
															#line 190 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
	return Future<Void>(new ChangeFeedClientActor(cx, self));
															#line 2062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/workloads/ChangeFeeds.actor.g.cpp"
}

#line 236 "/Users/ec2-user/foundationdb/fdbserver/workloads/ChangeFeeds.actor.cpp"
};

WorkloadFactory<ChangeFeedsWorkload> ChangeFeedsWorkloadFactory;
