#define POST_ACTOR_COMPILER 1
#line 1 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
/*
 * ConfigDatabaseUnitTests.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/CoordinationInterface.h"
#include "fdbclient/IConfigTransaction.h"
#include "fdbclient/TestKnobCollection.h"
#include "fdbserver/ConfigBroadcaster.h"
#include "fdbserver/ConfigNode.h"
#include "fdbserver/LocalConfiguration.h"
#include "fdbclient/Tuple.h"
#include "flow/UnitTest.h"
#include "flow/actorcompiler.h" // must be last include

namespace {

Key encodeConfigKey(Optional<KeyRef> configClass, KeyRef knobName) {
	Tuple tuple;
	if (configClass.present()) {
		tuple.append(configClass.get());
	} else {
		tuple.appendNull();
	}
	tuple << knobName;
	return tuple.pack();
}

void appendVersionedMutation(Standalone<VectorRef<VersionedConfigMutationRef>>& versionedMutations,
                             Version version,
                             Optional<KeyRef> configClass,
                             KeyRef knobName,
                             Optional<KnobValueRef> knobValue) {
	auto configKey = ConfigKeyRef(configClass, knobName);
	auto mutation = ConfigMutationRef(configKey, knobValue);
	versionedMutations.emplace_back_deep(versionedMutations.arena(), version, mutation);
}

class WriteToTransactionEnvironment {
	std::string dataDir;
	ConfigTransactionInterface cti;
	ConfigFollowerInterface cfi;
	Reference<ConfigNode> node;
	Future<Void> ctiServer;
	Future<Void> cfiServer;
	Version lastWrittenVersion{ 0 };

	static Value longToValue(int64_t v) {
		auto s = format("%lld", v);
		return StringRef(reinterpret_cast<uint8_t const*>(s.c_str()), s.size());
	}

																#line 70 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via set()
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class SetActor>
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetActorState {
															#line 76 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetActorState(WriteToTransactionEnvironment* const& self,Optional<KeyRef> const& configClass,KeyRef const& knobName,int64_t const& value) 
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configClass(configClass),
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   knobName(knobName),
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   value(value),
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   tr(IConfigTransaction::createTestSimple(self->cti))
															#line 91 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("set", reinterpret_cast<unsigned long>(this));

	}
	~SetActorState() 
	{
		fdb_probe_actor_destroy("set", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 73 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			auto configKey = encodeConfigKey(configClass, knobName);
															#line 74 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			tr->set(configKey, longToValue(value));
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<SetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 112 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetActor*>(this)->actor_wait_state = 1;
															#line 75 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetActor, 0, Void >*>(static_cast<SetActor*>(this)));
															#line 117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetActorState();
		static_cast<SetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->lastWrittenVersion = tr->getCommittedVersion();
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetActorState(); static_cast<SetActor*>(this)->destroy(); return 0; }
															#line 142 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetActorState();
		static_cast<SetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 76 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->lastWrittenVersion = tr->getCommittedVersion();
															#line 77 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetActorState(); static_cast<SetActor*>(this)->destroy(); return 0; }
															#line 156 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetActorState();
		static_cast<SetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetActor*>(this)->actor_wait_state > 0) static_cast<SetActor*>(this)->actor_wait_state = 0;
		static_cast<SetActor*>(this)->ActorCallback< SetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("set", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("set", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("set", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("set", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("set", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("set", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	WriteToTransactionEnvironment* self;
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<KeyRef> configClass;
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	KeyRef knobName;
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	int64_t value;
															#line 72 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Reference<IConfigTransaction> tr;
															#line 249 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via set()
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetActor final : public Actor<Void>, public ActorCallback< SetActor, 0, Void >, public FastAllocated<SetActor>, public SetActorState<SetActor> {
															#line 254 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<SetActor>::operator new;
	using FastAllocated<SetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6782803535475995392UL, 13408133727152519680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetActor, 0, Void >;
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetActor(WriteToTransactionEnvironment* const& self,Optional<KeyRef> const& configClass,KeyRef const& knobName,int64_t const& value) 
															#line 271 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   SetActorState<SetActor>(self, configClass, knobName, value),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("set", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15524163840979486720UL, 4513504769136616192UL);
		ActorExecutionContextHelper __helper(static_cast<SetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("set");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("set", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> set( WriteToTransactionEnvironment* const& self, Optional<KeyRef> const& configClass, KeyRef const& knobName, int64_t const& value ) {
															#line 68 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new SetActor(self, configClass, knobName, value));
															#line 303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 79 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

																#line 308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via clear()
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class ClearActor>
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class ClearActorState {
															#line 314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	ClearActorState(WriteToTransactionEnvironment* const& self,Optional<KeyRef> const& configClass,KeyRef const& knobName) 
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configClass(configClass),
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   knobName(knobName),
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   tr(IConfigTransaction::createTestSimple(self->cti))
															#line 327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("clear", reinterpret_cast<unsigned long>(this));

	}
	~ClearActorState() 
	{
		fdb_probe_actor_destroy("clear", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 84 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			auto configKey = encodeConfigKey(configClass, knobName);
															#line 85 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			tr->clear(configKey);
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<ClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 348 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearActor*>(this)->actor_wait_state = 1;
															#line 86 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearActor, 0, Void >*>(static_cast<ClearActor*>(this)));
															#line 353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearActorState();
		static_cast<ClearActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->lastWrittenVersion = tr->getCommittedVersion();
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<ClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearActorState(); static_cast<ClearActor*>(this)->destroy(); return 0; }
															#line 378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<ClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearActorState();
		static_cast<ClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 87 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->lastWrittenVersion = tr->getCommittedVersion();
															#line 88 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<ClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearActorState(); static_cast<ClearActor*>(this)->destroy(); return 0; }
															#line 392 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<ClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearActorState();
		static_cast<ClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearActor*>(this)->actor_wait_state > 0) static_cast<ClearActor*>(this)->actor_wait_state = 0;
		static_cast<ClearActor*>(this)->ActorCallback< ClearActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clear", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	WriteToTransactionEnvironment* self;
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<KeyRef> configClass;
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	KeyRef knobName;
															#line 83 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Reference<IConfigTransaction> tr;
															#line 483 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via clear()
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class ClearActor final : public Actor<Void>, public ActorCallback< ClearActor, 0, Void >, public FastAllocated<ClearActor>, public ClearActorState<ClearActor> {
															#line 488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<ClearActor>::operator new;
	using FastAllocated<ClearActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9945495789253069056UL, 10280582908268971776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearActor, 0, Void >;
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	ClearActor(WriteToTransactionEnvironment* const& self,Optional<KeyRef> const& configClass,KeyRef const& knobName) 
															#line 505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   ClearActorState<ClearActor>(self, configClass, knobName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clear", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3507049568125712128UL, 16633398102453084160UL);
		ActorExecutionContextHelper __helper(static_cast<ClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clear");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clear", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> clear( WriteToTransactionEnvironment* const& self, Optional<KeyRef> const& configClass, KeyRef const& knobName ) {
															#line 80 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new ClearActor(self, configClass, knobName));
															#line 537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 90 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

	void setup() {
		ctiServer = node->serve(cti);
		cfiServer = node->serve(cfi);
	}

public:
	WriteToTransactionEnvironment(std::string const& dataDir)
	  : dataDir(dataDir), node(makeReference<ConfigNode>(dataDir)) {
		platform::eraseDirectoryRecursive(dataDir);
		setup();
	}

	Future<Void> set(Optional<KeyRef> configClass, KeyRef knobName, int64_t value) {
		return set(this, configClass, knobName, value);
	}

	Future<Void> clear(Optional<KeyRef> configClass, KeyRef knobName) { return clear(this, configClass, knobName); }

	Future<Void> compact() { return cfi.compact.getReply(ConfigFollowerCompactRequest{ lastWrittenVersion }); }

	Future<Void> rollforward(Optional<Version> rollback,
	                         Version lastKnownCommitted,
	                         Version target,
	                         Standalone<VectorRef<VersionedConfigMutationRef>> mutations,
	                         Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> annotations) {
		return cfi.rollforward.getReply(
		    ConfigFollowerRollforwardRequest{ rollback, lastKnownCommitted, target, mutations, annotations, false });
	}

	void restartNode() {
		cfiServer.cancel();
		ctiServer.cancel();
		node = makeReference<ConfigNode>(dataDir);
		setup();
	}

	ConfigTransactionInterface getTransactionInterface() const { return cti; }

	ConfigFollowerInterface getFollowerInterface() const { return cfi; }

	void close() const { node->close(); }

	Future<Void> onClosed() const { return node->onClosed(); }

	Future<Void> getError() const { return cfiServer || ctiServer; }
};

class ReadFromLocalConfigEnvironment {
	UID id;
	std::string dataDir;
	Reference<LocalConfiguration> localConfiguration;
	Reference<AsyncVar<ConfigBroadcastInterface> const> cbi;
	Future<Void> consumer;

																#line 596 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via checkEventually()
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class T, class V, class E, class CheckEventuallyActor>
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class CheckEventuallyActorState {
															#line 602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	CheckEventuallyActorState(Reference<LocalConfiguration const> const& localConfiguration,V T::* const& member,Optional<E> const& expected) 
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : localConfiguration(localConfiguration),
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   member(member),
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   expected(expected),
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   lastMismatchTime(now())
															#line 615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("checkEventually", reinterpret_cast<unsigned long>(this));

	}
	~CheckEventuallyActorState() 
	{
		fdb_probe_actor_destroy("checkEventually", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 150 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			;
															#line 630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckEventuallyActorState();
		static_cast<CheckEventuallyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 151 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (localConfiguration->getTestKnobs().*member == expected.orDefault(0))
															#line 660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 152 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (!static_cast<CheckEventuallyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckEventuallyActorState(); static_cast<CheckEventuallyActor*>(this)->destroy(); return 0; }
															#line 664 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			new (&static_cast<CheckEventuallyActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CheckEventuallyActorState();
			static_cast<CheckEventuallyActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 154 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (now() > lastMismatchTime + 1.0)
															#line 672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 155 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			TraceEvent(SevWarn, "CheckEventuallyStillChecking") .detail("Expected", expected.present() ? expected.get() : 0) .detail("TestMember", localConfiguration->getTestKnobs().*member);
															#line 158 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			lastMismatchTime = now();
															#line 678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delayJittered(0.1);
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<CheckEventuallyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckEventuallyActor*>(this)->actor_wait_state = 1;
															#line 160 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckEventuallyActor, 0, Void >*>(static_cast<CheckEventuallyActor*>(this)));
															#line 689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckEventuallyActor*>(this)->actor_wait_state > 0) static_cast<CheckEventuallyActor*>(this)->actor_wait_state = 0;
		static_cast<CheckEventuallyActor*>(this)->ActorCallback< CheckEventuallyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckEventuallyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkEventually", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckEventuallyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkEventually", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckEventuallyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkEventually", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckEventuallyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkEventually", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckEventuallyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkEventually", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckEventuallyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkEventually", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Reference<LocalConfiguration const> localConfiguration;
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	V T::* member;
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<E> expected;
															#line 149 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	double lastMismatchTime;
															#line 789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via checkEventually()
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class T, class V, class E>
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class CheckEventuallyActor final : public Actor<Void>, public ActorCallback< CheckEventuallyActor<T, V, E>, 0, Void >, public FastAllocated<CheckEventuallyActor<T, V, E>>, public CheckEventuallyActorState<T, V, E, CheckEventuallyActor<T, V, E>> {
															#line 796 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<CheckEventuallyActor<T, V, E>>::operator new;
	using FastAllocated<CheckEventuallyActor<T, V, E>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10544019093091025152UL, 7113643101632850944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckEventuallyActor<T, V, E>, 0, Void >;
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	CheckEventuallyActor(Reference<LocalConfiguration const> const& localConfiguration,V T::* const& member,Optional<E> const& expected) 
															#line 813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   CheckEventuallyActorState<T, V, E, CheckEventuallyActor<T, V, E>>(localConfiguration, member, expected),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkEventually", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4366034608073670656UL, 7348849017565997056UL);
		ActorExecutionContextHelper __helper(static_cast<CheckEventuallyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkEventually");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkEventually", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckEventuallyActor<T, V, E>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class T, class V, class E>
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> checkEventually( Reference<LocalConfiguration const> const& localConfiguration, V T::* const& member, Optional<E> const& expected ) {
															#line 145 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new CheckEventuallyActor<T, V, E>(localConfiguration, member, expected));
															#line 847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 163 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

																#line 852 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via setup()
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class SetupActor>
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetupActorState {
															#line 858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetupActorState(ReadFromLocalConfigEnvironment* const& self) 
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self)
															#line 865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("setup", reinterpret_cast<unsigned long>(this));

	}
	~SetupActorState() 
	{
		fdb_probe_actor_destroy("setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->localConfiguration->initialize();
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<SetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 882 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetupActor*>(this)->actor_wait_state = 1;
															#line 165 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupActor, 0, Void >*>(static_cast<SetupActor*>(this)));
															#line 887 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (self->cbi)
															#line 910 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			self->consumer.cancel();
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			self->consumer = self->localConfiguration->consume(self->cbi->get());
															#line 916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActorState(); static_cast<SetupActor*>(this)->destroy(); return 0; }
															#line 920 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 166 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (self->cbi)
															#line 932 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 174 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			self->consumer.cancel();
															#line 175 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			self->consumer = self->localConfiguration->consume(self->cbi->get());
															#line 938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 177 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActorState(); static_cast<SetupActor*>(this)->destroy(); return 0; }
															#line 942 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActorState();
		static_cast<SetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupActor*>(this)->actor_wait_state > 0) static_cast<SetupActor*>(this)->actor_wait_state = 0;
		static_cast<SetupActor*>(this)->ActorCallback< SetupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	ReadFromLocalConfigEnvironment* self;
															#line 1027 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via setup()
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetupActor final : public Actor<Void>, public ActorCallback< SetupActor, 0, Void >, public FastAllocated<SetupActor>, public SetupActorState<SetupActor> {
															#line 1032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<SetupActor>::operator new;
	using FastAllocated<SetupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12333774350007763968UL, 9368832146463359488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupActor, 0, Void >;
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetupActor(ReadFromLocalConfigEnvironment* const& self) 
															#line 1049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   SetupActorState<SetupActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13998344965578828288UL, 688267501332814080UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> setup( ReadFromLocalConfigEnvironment* const& self ) {
															#line 164 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new SetupActor(self));
															#line 1081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 179 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

public:
	ReadFromLocalConfigEnvironment(std::string const& dataDir,
	                               std::string const& configPath,
	                               std::map<std::string, std::string> const& manualKnobOverrides)
	  : dataDir(dataDir),
	    localConfiguration(makeReference<LocalConfiguration>(dataDir, configPath, manualKnobOverrides, IsTest::True)),
	    consumer(Never()) {}

	Future<Void> setup() { return setup(this); }

	Future<Void> restartLocalConfig(std::string const& newConfigPath) {
		std::map<std::string, std::string> manualKnobOverrides = {};
		localConfiguration =
		    makeReference<LocalConfiguration>(dataDir, newConfigPath, manualKnobOverrides, IsTest::True);
		return setup();
	}

	void connectToBroadcaster(Reference<AsyncVar<ConfigBroadcastInterface> const> const& cbi) {
		this->cbi = cbi;
		consumer = localConfiguration->consume(cbi->get());
	}

	template <class T, class V, class E>
	void checkImmediate(V T::* member, Optional<E> expected) const {
		if (expected.present()) {
			ASSERT_EQ(localConfiguration->getTestKnobs().*member, expected.get());
		} else {
			ASSERT_EQ(localConfiguration->getTestKnobs().*member, 0);
		}
	}

	template <class T, class V, class E>
	Future<Void> checkEventually(V T::* member, Optional<E> expected) const {
		return checkEventually(localConfiguration, member, expected);
	}

	LocalConfiguration& getMutableLocalConfiguration() { return *localConfiguration; }

	void close() const { localConfiguration->close(); }
	Future<Void> onClosed() const { return localConfiguration->onClosed(); }

	Future<Void> getError() const { return consumer; }

	Version lastSeenVersion() { return localConfiguration->lastSeenVersion(); }

	ConfigClassSet configClassSet() { return localConfiguration->configClassSet(); }
};

class LocalConfigEnvironment {
	ReadFromLocalConfigEnvironment readFrom;
	Version lastWrittenVersion{ 0 };

	Future<Void> addMutation(Optional<KeyRef> configClass, KeyRef knobName, Optional<KnobValueRef> value) {
		Standalone<VectorRef<VersionedConfigMutationRef>> versionedMutations;
		appendVersionedMutation(versionedMutations, ++lastWrittenVersion, configClass, knobName, value);
		return readFrom.getMutableLocalConfiguration().addChanges(versionedMutations, lastWrittenVersion, 0);
	}

public:
	LocalConfigEnvironment(std::string const& dataDir,
	                       std::string const& configPath,
	                       std::map<std::string, std::string> const& manualKnobOverrides = {})
	  : readFrom(dataDir, configPath, manualKnobOverrides) {}
	Future<Void> setup(ConfigClassSet const& configClassSet) { return readFrom.setup(); }
	Future<Void> restartLocalConfig(std::string const& newConfigPath) {
		return readFrom.restartLocalConfig(newConfigPath);
	}
	Future<Void> getError() const { return Never(); }
	Future<Void> clear(Optional<KeyRef> configClass, KeyRef knobName) { return addMutation(configClass, knobName, {}); }
	Future<Void> set(Optional<KeyRef> configClass, KeyRef knobName, int64_t value) {
		auto knobValue = KnobValueRef::create(value);
		return addMutation(configClass, knobName, knobValue.contents());
	}
	template <class T, class V, class E>
	void check(V T::* member, Optional<E> value) const {
		return readFrom.checkImmediate(member, value);
	}
};

class BroadcasterToLocalConfigEnvironment {
	ReadFromLocalConfigEnvironment readFrom;
	Reference<AsyncVar<ConfigBroadcastInterface>> cbi;
	ConfigBroadcaster broadcaster;
	Version lastWrittenVersion{ 0 };
	Future<Void> broadcastServer;
	Promise<Void> workerFailure;
	Future<Void> workerFailed_;

																#line 1174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via setup()
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class SetupActor1>
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetupActor1State {
															#line 1180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetupActor1State(BroadcasterToLocalConfigEnvironment* const& self,ConfigClassSet const& configClassSet) 
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configClassSet(configClassSet)
															#line 1189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("setup", reinterpret_cast<unsigned long>(this));

	}
	~SetupActor1State() 
	{
		fdb_probe_actor_destroy("setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->readFrom.setup();
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<SetupActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetupActor1*>(this)->actor_wait_state = 1;
															#line 269 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupActor1, 0, Void >*>(static_cast<SetupActor1*>(this)));
															#line 1211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupActor1State();
		static_cast<SetupActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->cbi = makeReference<AsyncVar<ConfigBroadcastInterface>>();
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->readFrom.connectToBroadcaster(self->cbi);
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->broadcastServer = self->broadcaster.registerNode(self->cbi->get(), 0, configClassSet, self->workerFailure.getFuture(), true);
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetupActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActor1State(); static_cast<SetupActor1*>(this)->destroy(); return 0; }
															#line 1240 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetupActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActor1State();
		static_cast<SetupActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 270 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->cbi = makeReference<AsyncVar<ConfigBroadcastInterface>>();
															#line 271 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->readFrom.connectToBroadcaster(self->cbi);
															#line 272 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->broadcastServer = self->broadcaster.registerNode(self->cbi->get(), 0, configClassSet, self->workerFailure.getFuture(), true);
															#line 274 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetupActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActor1State(); static_cast<SetupActor1*>(this)->destroy(); return 0; }
															#line 1258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetupActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActor1State();
		static_cast<SetupActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupActor1*>(this)->actor_wait_state > 0) static_cast<SetupActor1*>(this)->actor_wait_state = 0;
		static_cast<SetupActor1*>(this)->ActorCallback< SetupActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	BroadcasterToLocalConfigEnvironment* self;
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	ConfigClassSet configClassSet;
															#line 1345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via setup()
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetupActor1 final : public Actor<Void>, public ActorCallback< SetupActor1, 0, Void >, public FastAllocated<SetupActor1>, public SetupActor1State<SetupActor1> {
															#line 1350 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<SetupActor1>::operator new;
	using FastAllocated<SetupActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12333774350007763968UL, 9368832146463359488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupActor1, 0, Void >;
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetupActor1(BroadcasterToLocalConfigEnvironment* const& self,ConfigClassSet const& configClassSet) 
															#line 1367 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   SetupActor1State<SetupActor1>(self, configClassSet),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7554903555599063552UL, 3002477495560883968UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> setup( BroadcasterToLocalConfigEnvironment* const& self, ConfigClassSet const& configClassSet ) {
															#line 268 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new SetupActor1(self, configClassSet));
															#line 1399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 276 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

	void addMutation(Optional<KeyRef> configClass, KeyRef knobName, KnobValueRef value) {
		Standalone<VectorRef<VersionedConfigMutationRef>> versionedMutations;
		appendVersionedMutation(versionedMutations, ++lastWrittenVersion, configClass, knobName, value);
		broadcaster.applyChanges(versionedMutations, lastWrittenVersion, {}, {});
	}

public:
	BroadcasterToLocalConfigEnvironment(std::string const& dataDir, std::string const& configPath)
	  : readFrom(dataDir, configPath, {}), cbi(makeReference<AsyncVar<ConfigBroadcastInterface>>()),
	    broadcaster(ConfigFollowerInterface{}) {}

	Future<Void> setup(ConfigClassSet const& configClassSet) { return setup(this, configClassSet); }

	void set(Optional<KeyRef> configClass, KeyRef knobName, int64_t value) {
		auto knobValue = KnobValueRef::create(value);
		addMutation(configClass, knobName, knobValue.contents());
	}

	void clear(Optional<KeyRef> configClass, KeyRef knobName) { addMutation(configClass, knobName, {}); }

	template <class T, class V, class E>
	Future<Void> check(V T::* member, Optional<E> value) const {
		return readFrom.checkEventually(member, value);
	}

	JsonBuilderObject getStatus() const { return broadcaster.getStatus(); }

	void changeBroadcaster() {
		broadcastServer.cancel();
		cbi->set(ConfigBroadcastInterface{});
		readFrom.connectToBroadcaster(cbi);
		broadcastServer = broadcaster.registerNode(
		    cbi->get(), readFrom.lastSeenVersion(), readFrom.configClassSet(), workerFailure.getFuture(), true);
	}

	Future<Void> restartLocalConfig(std::string const& newConfigPath) {
		return readFrom.restartLocalConfig(newConfigPath);
	}

	void killLocalConfig() {
		workerFailed_ = broadcaster.getClientFailure(cbi->get().id());
		workerFailure.send(Void());
	}

	Future<Void> workerFailed() {
		ASSERT(workerFailed_.isValid());
		return workerFailed_;
	}

	void compact() { broadcaster.compact(lastWrittenVersion); }

	void close() const { readFrom.close(); }

	Future<Void> onClosed() const { return readFrom.onClosed(); }

	Future<Void> getError() const { return readFrom.getError() || broadcaster.getError(); }
};

class TransactionEnvironment {
	WriteToTransactionEnvironment writeTo;

																#line 1465 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via check()
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class CheckActor>
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class CheckActorState {
															#line 1471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	CheckActorState(TransactionEnvironment* const& self,Optional<KeyRef> const& configClass,KeyRef const& knobName,Optional<int64_t> const& expected) 
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configClass(configClass),
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   knobName(knobName),
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   expected(expected),
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   tr(IConfigTransaction::createTestSimple(self->writeTo.getTransactionInterface())),
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configKey(encodeConfigKey(configClass, knobName))
															#line 1488 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("check", reinterpret_cast<unsigned long>(this));

	}
	~CheckActorState() 
	{
		fdb_probe_actor_destroy("check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(configKey);
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<CheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1505 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckActor*>(this)->actor_wait_state = 1;
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckActor, 0, Optional<Value> >*>(static_cast<CheckActor*>(this)));
															#line 1510 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckActorState();
		static_cast<CheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 346 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (expected.present())
															#line 1533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 347 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT_EQ(Tuple::unpack(value.get()).getInt(0), expected.get());
															#line 1537 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
		else
		{
															#line 349 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(!value.present());
															#line 1543 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 351 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<CheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckActorState(); static_cast<CheckActor*>(this)->destroy(); return 0; }
															#line 1547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<CheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckActorState();
		static_cast<CheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& __value,int loopDepth) 
	{
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		value = __value;
															#line 1559 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && __value,int loopDepth) 
	{
		value = std::move(__value);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckActor*>(this)->actor_wait_state > 0) static_cast<CheckActor*>(this)->actor_wait_state = 0;
		static_cast<CheckActor*>(this)->ActorCallback< CheckActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("check", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionEnvironment* self;
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<KeyRef> configClass;
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	KeyRef knobName;
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<int64_t> expected;
															#line 342 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Reference<IConfigTransaction> tr;
															#line 344 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Key configKey;
															#line 345 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<Value> value;
															#line 1648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via check()
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class CheckActor final : public Actor<Void>, public ActorCallback< CheckActor, 0, Optional<Value> >, public FastAllocated<CheckActor>, public CheckActorState<CheckActor> {
															#line 1653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<CheckActor>::operator new;
	using FastAllocated<CheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1704267264018904320UL, 3008995409989093376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckActor, 0, Optional<Value> >;
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	CheckActor(TransactionEnvironment* const& self,Optional<KeyRef> const& configClass,KeyRef const& knobName,Optional<int64_t> const& expected) 
															#line 1670 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   CheckActorState<CheckActor>(self, configClass, knobName, expected),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9223858490859549696UL, 13188886265273636608UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> check( TransactionEnvironment* const& self, Optional<KeyRef> const& configClass, KeyRef const& knobName, Optional<int64_t> const& expected ) {
															#line 338 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new CheckActor(self, configClass, knobName, expected));
															#line 1702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 353 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

																#line 1707 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via getConfigClasses()
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class GetConfigClassesActor>
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class GetConfigClassesActorState {
															#line 1713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	GetConfigClassesActorState(TransactionEnvironment* const& self) 
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   tr(IConfigTransaction::createTestSimple(self->writeTo.getTransactionInterface())),
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   begin(firstGreaterOrEqual(configClassKeys.begin)),
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   end(firstGreaterOrEqual(configClassKeys.end))
															#line 1726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("getConfigClasses", reinterpret_cast<unsigned long>(this));

	}
	~GetConfigClassesActorState() 
	{
		fdb_probe_actor_destroy("getConfigClasses", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(begin, end, 1000);
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 1;
															#line 359 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetConfigClassesActor, 0, RangeResult >*>(static_cast<GetConfigClassesActor*>(this)));
															#line 1748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetConfigClassesActorState();
		static_cast<GetConfigClassesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& range,int loopDepth) 
	{
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		Standalone<VectorRef<KeyRef>> result;
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		for( const auto& kv : range ) {
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			result.push_back_deep(result.arena(), kv.key);
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(kv.value == ""_sr);
															#line 1777 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<GetConfigClassesActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(result); this->~GetConfigClassesActorState(); static_cast<GetConfigClassesActor*>(this)->destroy(); return 0; }
															#line 1781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<GetConfigClassesActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(result);
		this->~GetConfigClassesActorState();
		static_cast<GetConfigClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && range,int loopDepth) 
	{
															#line 360 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		Standalone<VectorRef<KeyRef>> result;
															#line 361 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		for( const auto& kv : range ) {
															#line 362 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			result.push_back_deep(result.arena(), kv.key);
															#line 363 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(kv.value == ""_sr);
															#line 1799 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 365 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<GetConfigClassesActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(result); this->~GetConfigClassesActorState(); static_cast<GetConfigClassesActor*>(this)->destroy(); return 0; }
															#line 1803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<GetConfigClassesActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(result);
		this->~GetConfigClassesActorState();
		static_cast<GetConfigClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& range,int loopDepth) 
	{
		loopDepth = a_body1cont1(range, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && range,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<GetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<GetConfigClassesActor*>(this)->ActorCallback< GetConfigClassesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetConfigClassesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetConfigClassesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionEnvironment* self;
															#line 355 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Reference<IConfigTransaction> tr;
															#line 357 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	KeySelector begin;
															#line 358 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	KeySelector end;
															#line 1894 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via getConfigClasses()
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class GetConfigClassesActor final : public Actor<Standalone<VectorRef<KeyRef>>>, public ActorCallback< GetConfigClassesActor, 0, RangeResult >, public FastAllocated<GetConfigClassesActor>, public GetConfigClassesActorState<GetConfigClassesActor> {
															#line 1899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<GetConfigClassesActor>::operator new;
	using FastAllocated<GetConfigClassesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5696707869776050944UL, 14867857413693274368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetConfigClassesActor, 0, RangeResult >;
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	GetConfigClassesActor(TransactionEnvironment* const& self) 
															#line 1916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Standalone<VectorRef<KeyRef>>>(),
		   GetConfigClassesActorState<GetConfigClassesActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getConfigClasses", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14805324959998266368UL, 16789838799325584384UL);
		ActorExecutionContextHelper __helper(static_cast<GetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getConfigClasses");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getConfigClasses", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetConfigClassesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<KeyRef>>> getConfigClasses( TransactionEnvironment* const& self ) {
															#line 354 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Standalone<VectorRef<KeyRef>>>(new GetConfigClassesActor(self));
															#line 1948 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 367 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

																#line 1953 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via getKnobNames()
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class GetKnobNamesActor>
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class GetKnobNamesActorState {
															#line 1959 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	GetKnobNamesActorState(TransactionEnvironment* const& self,Optional<KeyRef> const& configClass) 
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configClass(configClass),
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   tr(IConfigTransaction::createTestSimple(self->writeTo.getTransactionInterface())),
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   keys(globalConfigKnobKeys)
															#line 1972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("getKnobNames", reinterpret_cast<unsigned long>(this));

	}
	~GetKnobNamesActorState() 
	{
		fdb_probe_actor_destroy("getKnobNames", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 373 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (configClass.present())
															#line 1987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			{
															#line 374 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
				keys = singleKeyRange(configClass.get().withPrefix(configKnobKeys.begin));
															#line 1991 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			}
															#line 376 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			KeySelector begin = firstGreaterOrEqual(keys.begin);
															#line 377 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			KeySelector end = firstGreaterOrEqual(keys.end);
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(begin, end, 1000);
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<GetKnobNamesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetKnobNamesActor*>(this)->actor_wait_state = 1;
															#line 378 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKnobNamesActor, 0, RangeResult >*>(static_cast<GetKnobNamesActor*>(this)));
															#line 2006 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKnobNamesActorState();
		static_cast<GetKnobNamesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& range,int loopDepth) 
	{
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		Standalone<VectorRef<KeyRef>> result;
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		for( const auto& kv : range ) {
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			result.push_back_deep(result.arena(), kv.key);
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(kv.value == ""_sr);
															#line 2035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<GetKnobNamesActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(result); this->~GetKnobNamesActorState(); static_cast<GetKnobNamesActor*>(this)->destroy(); return 0; }
															#line 2039 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<GetKnobNamesActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(result);
		this->~GetKnobNamesActorState();
		static_cast<GetKnobNamesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && range,int loopDepth) 
	{
															#line 379 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		Standalone<VectorRef<KeyRef>> result;
															#line 380 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		for( const auto& kv : range ) {
															#line 381 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			result.push_back_deep(result.arena(), kv.key);
															#line 382 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(kv.value == ""_sr);
															#line 2057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		}
															#line 384 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<GetKnobNamesActor*>(this)->SAV<Standalone<VectorRef<KeyRef>>>::futures) { (void)(result); this->~GetKnobNamesActorState(); static_cast<GetKnobNamesActor*>(this)->destroy(); return 0; }
															#line 2061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<GetKnobNamesActor*>(this)->SAV< Standalone<VectorRef<KeyRef>> >::value()) Standalone<VectorRef<KeyRef>>(result);
		this->~GetKnobNamesActorState();
		static_cast<GetKnobNamesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& range,int loopDepth) 
	{
		loopDepth = a_body1cont1(range, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && range,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKnobNamesActor*>(this)->actor_wait_state > 0) static_cast<GetKnobNamesActor*>(this)->actor_wait_state = 0;
		static_cast<GetKnobNamesActor*>(this)->ActorCallback< GetKnobNamesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetKnobNamesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getKnobNames", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobNamesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobNames", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKnobNamesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getKnobNames", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobNamesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobNames", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKnobNamesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getKnobNames", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobNamesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKnobNames", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionEnvironment* self;
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<KeyRef> configClass;
															#line 370 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Reference<IConfigTransaction> tr;
															#line 372 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	KeyRange keys;
															#line 2152 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via getKnobNames()
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class GetKnobNamesActor final : public Actor<Standalone<VectorRef<KeyRef>>>, public ActorCallback< GetKnobNamesActor, 0, RangeResult >, public FastAllocated<GetKnobNamesActor>, public GetKnobNamesActorState<GetKnobNamesActor> {
															#line 2157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<GetKnobNamesActor>::operator new;
	using FastAllocated<GetKnobNamesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10633155054976774656UL, 3927028414431651328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKnobNamesActor, 0, RangeResult >;
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	GetKnobNamesActor(TransactionEnvironment* const& self,Optional<KeyRef> const& configClass) 
															#line 2174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Standalone<VectorRef<KeyRef>>>(),
		   GetKnobNamesActorState<GetKnobNamesActor>(self, configClass),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKnobNames", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16492234349335322368UL, 15783780456143899392UL);
		ActorExecutionContextHelper __helper(static_cast<GetKnobNamesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKnobNames");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKnobNames", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKnobNamesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<KeyRef>>> getKnobNames( TransactionEnvironment* const& self, Optional<KeyRef> const& configClass ) {
															#line 368 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Standalone<VectorRef<KeyRef>>>(new GetKnobNamesActor(self, configClass));
															#line 2206 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 386 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

																#line 2211 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via badRangeRead()
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class BadRangeReadActor>
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class BadRangeReadActorState {
															#line 2217 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	BadRangeReadActorState(TransactionEnvironment* const& self) 
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   tr(IConfigTransaction::createTestSimple(self->writeTo.getTransactionInterface()))
															#line 2226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("badRangeRead", reinterpret_cast<unsigned long>(this));

	}
	~BadRangeReadActorState() 
	{
		fdb_probe_actor_destroy("badRangeRead", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 390 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			KeySelector begin = firstGreaterOrEqual(normalKeys.begin);
															#line 391 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			KeySelector end = firstGreaterOrEqual(normalKeys.end);
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(tr->getRange(begin, end, 1000));
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<BadRangeReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2247 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BadRangeReadActor*>(this)->actor_wait_state = 1;
															#line 392 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BadRangeReadActor, 0, Void >*>(static_cast<BadRangeReadActor*>(this)));
															#line 2252 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BadRangeReadActorState();
		static_cast<BadRangeReadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<BadRangeReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BadRangeReadActorState(); static_cast<BadRangeReadActor*>(this)->destroy(); return 0; }
															#line 2275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<BadRangeReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BadRangeReadActorState();
		static_cast<BadRangeReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 393 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<BadRangeReadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BadRangeReadActorState(); static_cast<BadRangeReadActor*>(this)->destroy(); return 0; }
															#line 2287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<BadRangeReadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BadRangeReadActorState();
		static_cast<BadRangeReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BadRangeReadActor*>(this)->actor_wait_state > 0) static_cast<BadRangeReadActor*>(this)->actor_wait_state = 0;
		static_cast<BadRangeReadActor*>(this)->ActorCallback< BadRangeReadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BadRangeReadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("badRangeRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BadRangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("badRangeRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BadRangeReadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("badRangeRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BadRangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("badRangeRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BadRangeReadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("badRangeRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BadRangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("badRangeRead", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionEnvironment* self;
															#line 388 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Reference<IConfigTransaction> tr;
															#line 2374 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via badRangeRead()
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class BadRangeReadActor final : public Actor<Void>, public ActorCallback< BadRangeReadActor, 0, Void >, public FastAllocated<BadRangeReadActor>, public BadRangeReadActorState<BadRangeReadActor> {
															#line 2379 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<BadRangeReadActor>::operator new;
	using FastAllocated<BadRangeReadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13972989022075668224UL, 9299404277440147968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BadRangeReadActor, 0, Void >;
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	BadRangeReadActor(TransactionEnvironment* const& self) 
															#line 2396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   BadRangeReadActorState<BadRangeReadActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("badRangeRead", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12901388174225587456UL, 11541444727201612032UL);
		ActorExecutionContextHelper __helper(static_cast<BadRangeReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("badRangeRead");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("badRangeRead", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BadRangeReadActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> badRangeRead( TransactionEnvironment* const& self ) {
															#line 387 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new BadRangeReadActor(self));
															#line 2428 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 395 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

public:
	TransactionEnvironment(std::string const& dataDir) : writeTo(dataDir) {}

	Future<Void> setup() { return Void(); }

	void restartNode() { writeTo.restartNode(); }
	template <class T>
	Future<Void> set(Optional<KeyRef> configClass, KeyRef knobName, T value) {
		return writeTo.set(configClass, knobName, value);
	}
	Future<Void> clear(Optional<KeyRef> configClass, KeyRef knobName) { return writeTo.clear(configClass, knobName); }
	Future<Void> check(Optional<KeyRef> configClass, KeyRef knobName, Optional<int64_t> expected) {
		return check(this, configClass, knobName, expected);
	}
	Future<Void> badRangeRead() { return badRangeRead(this); }

	Future<Standalone<VectorRef<KeyRef>>> getConfigClasses() { return getConfigClasses(this); }
	Future<Standalone<VectorRef<KeyRef>>> getKnobNames(Optional<KeyRef> configClass) {
		return getKnobNames(this, configClass);
	}

	Future<Void> compact() { return writeTo.compact(); }
	Future<Void> rollforward(Optional<Version> rollback,
	                         Version lastKnownCommitted,
	                         Version target,
	                         Standalone<VectorRef<VersionedConfigMutationRef>> mutations,
	                         Standalone<VectorRef<VersionedConfigCommitAnnotationRef>> annotations) {
		return writeTo.rollforward(rollback, lastKnownCommitted, target, mutations, annotations);
	}
	Future<Void> getError() const { return writeTo.getError(); }
};

class TransactionToLocalConfigEnvironment {
	WriteToTransactionEnvironment writeTo;
	ReadFromLocalConfigEnvironment readFrom;
	Reference<AsyncVar<ConfigBroadcastInterface>> cbi;
	ConfigBroadcaster broadcaster;
	Future<Void> broadcastServer;
	Promise<Void> workerFailure;
	Future<Void> workerFailed_;

																#line 2474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via setup()
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class SetupActor2>
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetupActor2State {
															#line 2480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetupActor2State(TransactionToLocalConfigEnvironment* const& self,ConfigClassSet const& configClassSet) 
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : self(self),
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configClassSet(configClassSet)
															#line 2489 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("setup", reinterpret_cast<unsigned long>(this));

	}
	~SetupActor2State() 
	{
		fdb_probe_actor_destroy("setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->readFrom.setup();
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<SetupActor2*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2506 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetupActor2*>(this)->actor_wait_state = 1;
															#line 438 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupActor2, 0, Void >*>(static_cast<SetupActor2*>(this)));
															#line 2511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupActor2State();
		static_cast<SetupActor2*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->cbi = makeReference<AsyncVar<ConfigBroadcastInterface>>();
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->readFrom.connectToBroadcaster(self->cbi);
															#line 441 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->broadcastServer = self->broadcaster.registerNode(self->cbi->get(), 0, configClassSet, self->workerFailure.getFuture(), true);
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetupActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActor2State(); static_cast<SetupActor2*>(this)->destroy(); return 0; }
															#line 2540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetupActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActor2State();
		static_cast<SetupActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 439 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->cbi = makeReference<AsyncVar<ConfigBroadcastInterface>>();
															#line 440 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->readFrom.connectToBroadcaster(self->cbi);
															#line 441 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		self->broadcastServer = self->broadcaster.registerNode(self->cbi->get(), 0, configClassSet, self->workerFailure.getFuture(), true);
															#line 443 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<SetupActor2*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetupActor2State(); static_cast<SetupActor2*>(this)->destroy(); return 0; }
															#line 2558 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<SetupActor2*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetupActor2State();
		static_cast<SetupActor2*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupActor2*>(this)->actor_wait_state > 0) static_cast<SetupActor2*>(this)->actor_wait_state = 0;
		static_cast<SetupActor2*>(this)->ActorCallback< SetupActor2, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupActor2, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupActor2, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupActor2, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionToLocalConfigEnvironment* self;
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	ConfigClassSet configClassSet;
															#line 2645 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via setup()
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class SetupActor2 final : public Actor<Void>, public ActorCallback< SetupActor2, 0, Void >, public FastAllocated<SetupActor2>, public SetupActor2State<SetupActor2> {
															#line 2650 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<SetupActor2>::operator new;
	using FastAllocated<SetupActor2>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12333774350007763968UL, 9368832146463359488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupActor2, 0, Void >;
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	SetupActor2(TransactionToLocalConfigEnvironment* const& self,ConfigClassSet const& configClassSet) 
															#line 2667 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   SetupActor2State<SetupActor2>(self, configClassSet),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(605885446803886848UL, 8965722389878324480UL);
		ActorExecutionContextHelper __helper(static_cast<SetupActor2*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupActor2, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] static Future<Void> setup( TransactionToLocalConfigEnvironment* const& self, ConfigClassSet const& configClassSet ) {
															#line 437 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new SetupActor2(self, configClassSet));
															#line 2699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 445 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

public:
	TransactionToLocalConfigEnvironment(std::string const& dataDir, std::string const& configPath)
	  : writeTo(dataDir), readFrom(dataDir, configPath, {}), cbi(makeReference<AsyncVar<ConfigBroadcastInterface>>()),
	    broadcaster(writeTo.getFollowerInterface()) {}

	Future<Void> setup(ConfigClassSet const& configClassSet) { return setup(this, configClassSet); }

	void restartNode() { writeTo.restartNode(); }

	JsonBuilderObject getStatus() const { return broadcaster.getStatus(); }

	void changeBroadcaster() {
		broadcastServer.cancel();
		cbi->set(ConfigBroadcastInterface{});
		readFrom.connectToBroadcaster(cbi);
		broadcastServer = broadcaster.registerNode(
		    cbi->get(), readFrom.lastSeenVersion(), readFrom.configClassSet(), workerFailure.getFuture(), true);
	}

	Future<Void> restartLocalConfig(std::string const& newConfigPath) {
		return readFrom.restartLocalConfig(newConfigPath);
	}

	void killLocalConfig() {
		workerFailed_ = broadcaster.getClientFailure(cbi->get().id());
		workerFailure.send(Void());
	}

	Future<Void> workerFailed() {
		ASSERT(workerFailed_.isValid());
		return workerFailed_;
	}

	Future<Void> compact() { return writeTo.compact(); }

	template <class T>
	Future<Void> set(Optional<KeyRef> configClass, KeyRef knobName, T const& value) {
		return writeTo.set(configClass, knobName, value);
	}
	Future<Void> clear(Optional<KeyRef> configClass, KeyRef knobName) { return writeTo.clear(configClass, knobName); }
	template <class T, class V, class E>
	Future<Void> check(V T::* member, Optional<E> value) const {
		return readFrom.checkEventually(member, value);
	}
	void close() const {
		writeTo.close();
		readFrom.close();
	}
	Future<Void> onClosed() const { return writeTo.onClosed() && readFrom.onClosed(); }
	Future<Void> getError() const { return writeTo.getError() || readFrom.getError() || broadcaster.getError(); }
};

// These functions give a common interface to all environments, to improve code reuse
template <class Env, class... Args>
Future<Void> set(Env& env, Args&&... args) {
	return waitOrError(env.set(std::forward<Args>(args)...), env.getError());
}
template <class... Args>
Future<Void> set(BroadcasterToLocalConfigEnvironment& env, Args&&... args) {
	env.set(std::forward<Args>(args)...);
	return Void();
}
template <class Env, class... Args>
Future<Void> clear(Env& env, Args&&... args) {
	return waitOrError(env.clear(std::forward<Args>(args)...), env.getError());
}
template <class... Args>
Future<Void> clear(BroadcasterToLocalConfigEnvironment& env, Args&&... args) {
	env.clear(std::forward<Args>(args)...);
	return Void();
}
template <class Env, class... Args>
Future<Void> check(Env& env, Args&&... args) {
	return waitOrError(env.check(std::forward<Args>(args)...), env.getError());
}
template <class... Args>
Future<Void> check(LocalConfigEnvironment& env, Args&&... args) {
	env.check(std::forward<Args>(args)...);
	return Void();
}
template <class Env>
Future<Void> compact(Env& env) {
	return waitOrError(env.compact(), env.getError());
}
Future<Void> compact(BroadcasterToLocalConfigEnvironment& env) {
	env.compact();
	return Void();
}
template <class Env, class... Args>
Future<Void> rollforward(Env& env, Args&&... args) {
	return waitOrError(env.rollforward(std::forward<Args>(args)...), env.getError());
}

															#line 2797 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testRestartLocalConfig()
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestRestartLocalConfigActor>
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestRestartLocalConfigActorState {
															#line 2803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestRestartLocalConfigActorState(UnitTestParameters const& params) 
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 541 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 2812 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testRestartLocalConfig", reinterpret_cast<unsigned long>(this));

	}
	~TestRestartLocalConfigActorState() 
	{
		fdb_probe_actor_destroy("testRestartLocalConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 1;
															#line 542 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 0, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 2834 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestRestartLocalConfigActorState();
		static_cast<TestRestartLocalConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2859 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 2;
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 1, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 2864 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 2;
															#line 543 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 1, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 2880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigActor*>(this)->ActorCallback< TestRestartLocalConfigActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2966 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 3;
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 2, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 2971 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2982 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 3;
															#line 544 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 2, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 2987 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigActor*>(this)->ActorCallback< TestRestartLocalConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = env.restartLocalConfig("class-A");
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 4;
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 3, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3078 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = env.restartLocalConfig("class-A");
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3089 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 4;
															#line 545 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 3, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigActor*>(this)->ActorCallback< TestRestartLocalConfigActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3180 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 5;
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 4, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3185 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3196 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 5;
															#line 546 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 4, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3201 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigActor*>(this)->ActorCallback< TestRestartLocalConfigActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = set(env, "class-A"_sr, "test_long"_sr, 2);
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3287 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 6;
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 5, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = set(env, "class-A"_sr, "test_long"_sr, 2);
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3303 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 6;
															#line 547 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 5, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3308 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigActor*>(this)->ActorCallback< TestRestartLocalConfigActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_6 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3394 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 7;
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 6, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3399 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_6 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3410 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 7;
															#line 548 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigActor, 6, Void >*>(static_cast<TestRestartLocalConfigActor*>(this)));
															#line 3415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigActor*>(this)->ActorCallback< TestRestartLocalConfigActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestRestartLocalConfigActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRestartLocalConfigActorState(); static_cast<TestRestartLocalConfigActor*>(this)->destroy(); return 0; }
															#line 3499 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestRestartLocalConfigActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestRestartLocalConfigActorState();
		static_cast<TestRestartLocalConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 549 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestRestartLocalConfigActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRestartLocalConfigActorState(); static_cast<TestRestartLocalConfigActor*>(this)->destroy(); return 0; }
															#line 3511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestRestartLocalConfigActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestRestartLocalConfigActorState();
		static_cast<TestRestartLocalConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigActor*>(this)->ActorCallback< TestRestartLocalConfigActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 541 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 3598 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testRestartLocalConfig()
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestRestartLocalConfigActor final : public Actor<Void>, public ActorCallback< TestRestartLocalConfigActor<Env>, 0, Void >, public ActorCallback< TestRestartLocalConfigActor<Env>, 1, Void >, public ActorCallback< TestRestartLocalConfigActor<Env>, 2, Void >, public ActorCallback< TestRestartLocalConfigActor<Env>, 3, Void >, public ActorCallback< TestRestartLocalConfigActor<Env>, 4, Void >, public ActorCallback< TestRestartLocalConfigActor<Env>, 5, Void >, public ActorCallback< TestRestartLocalConfigActor<Env>, 6, Void >, public FastAllocated<TestRestartLocalConfigActor<Env>>, public TestRestartLocalConfigActorState<Env, TestRestartLocalConfigActor<Env>> {
															#line 3605 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestRestartLocalConfigActor<Env>>::operator new;
	using FastAllocated<TestRestartLocalConfigActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15383425229619636224UL, 644889925018839552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestRestartLocalConfigActor<Env>, 0, Void >;
friend struct ActorCallback< TestRestartLocalConfigActor<Env>, 1, Void >;
friend struct ActorCallback< TestRestartLocalConfigActor<Env>, 2, Void >;
friend struct ActorCallback< TestRestartLocalConfigActor<Env>, 3, Void >;
friend struct ActorCallback< TestRestartLocalConfigActor<Env>, 4, Void >;
friend struct ActorCallback< TestRestartLocalConfigActor<Env>, 5, Void >;
friend struct ActorCallback< TestRestartLocalConfigActor<Env>, 6, Void >;
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestRestartLocalConfigActor(UnitTestParameters const& params) 
															#line 3628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestRestartLocalConfigActorState<Env, TestRestartLocalConfigActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9306454998092319488UL, 2954517028675423488UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testRestartLocalConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testRestartLocalConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestRestartLocalConfigActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestRestartLocalConfigActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestRestartLocalConfigActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestRestartLocalConfigActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestRestartLocalConfigActor<Env>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestRestartLocalConfigActor<Env>, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TestRestartLocalConfigActor<Env>, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testRestartLocalConfig( UnitTestParameters const& params ) {
															#line 539 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestRestartLocalConfigActor<Env>(params));
															#line 3668 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 551 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 3673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testRestartLocalConfigAndChangeClass()
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestRestartLocalConfigAndChangeClassActor>
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestRestartLocalConfigAndChangeClassActorState {
															#line 3679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestRestartLocalConfigAndChangeClassActorState(UnitTestParameters const& params) 
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 3688 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this));

	}
	~TestRestartLocalConfigAndChangeClassActorState() 
	{
		fdb_probe_actor_destroy("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr, "class-B"_sr }));
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3705 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 1;
															#line 555 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 0, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 3710 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestRestartLocalConfigAndChangeClassActorState();
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 556 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 556 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3735 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 2;
															#line 556 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 1, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 3740 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 556 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 556 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3751 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 2;
															#line 556 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 1, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 3756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->ActorCallback< TestRestartLocalConfigAndChangeClassActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 3;
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 2, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 3847 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 3;
															#line 557 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 2, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 3863 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->ActorCallback< TestRestartLocalConfigAndChangeClassActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = env.restartLocalConfig("class-B");
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3949 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 4;
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 3, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 3954 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = env.restartLocalConfig("class-B");
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3965 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 4;
															#line 558 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 3, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 3970 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->ActorCallback< TestRestartLocalConfigAndChangeClassActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 0 });
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 5;
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 4, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 4061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 0 });
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 5;
															#line 559 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 4, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 4077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->ActorCallback< TestRestartLocalConfigAndChangeClassActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 2 });
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 6;
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 5, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 4168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 2 });
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 6;
															#line 560 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 5, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 4184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->ActorCallback< TestRestartLocalConfigAndChangeClassActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_6 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 7;
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 6, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 4275 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_6 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 7;
															#line 561 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestRestartLocalConfigAndChangeClassActor, 6, Void >*>(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)));
															#line 4291 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->ActorCallback< TestRestartLocalConfigAndChangeClassActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRestartLocalConfigAndChangeClassActorState(); static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->destroy(); return 0; }
															#line 4375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestRestartLocalConfigAndChangeClassActorState();
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 562 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestRestartLocalConfigAndChangeClassActorState(); static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->destroy(); return 0; }
															#line 4387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestRestartLocalConfigAndChangeClassActorState();
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state > 0) static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->actor_wait_state = 0;
		static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->ActorCallback< TestRestartLocalConfigAndChangeClassActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TestRestartLocalConfigAndChangeClassActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 554 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 4474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testRestartLocalConfigAndChangeClass()
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestRestartLocalConfigAndChangeClassActor final : public Actor<Void>, public ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 0, Void >, public ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 1, Void >, public ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 2, Void >, public ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 3, Void >, public ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 4, Void >, public ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 5, Void >, public ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 6, Void >, public FastAllocated<TestRestartLocalConfigAndChangeClassActor<Env>>, public TestRestartLocalConfigAndChangeClassActorState<Env, TestRestartLocalConfigAndChangeClassActor<Env>> {
															#line 4481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestRestartLocalConfigAndChangeClassActor<Env>>::operator new;
	using FastAllocated<TestRestartLocalConfigAndChangeClassActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11966935615651988224UL, 6028838091996035328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 0, Void >;
friend struct ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 1, Void >;
friend struct ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 2, Void >;
friend struct ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 3, Void >;
friend struct ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 4, Void >;
friend struct ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 5, Void >;
friend struct ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 6, Void >;
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestRestartLocalConfigAndChangeClassActor(UnitTestParameters const& params) 
															#line 4504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestRestartLocalConfigAndChangeClassActorState<Env, TestRestartLocalConfigAndChangeClassActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6942187281364030976UL, 9357118023387732480UL);
		ActorExecutionContextHelper __helper(static_cast<TestRestartLocalConfigAndChangeClassActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testRestartLocalConfigAndChangeClass");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testRestartLocalConfigAndChangeClass", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TestRestartLocalConfigAndChangeClassActor<Env>, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testRestartLocalConfigAndChangeClass( UnitTestParameters const& params ) {
															#line 552 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestRestartLocalConfigAndChangeClassActor<Env>(params));
															#line 4544 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 564 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 4549 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testNewLocalConfigAfterCompaction()
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestNewLocalConfigAfterCompactionActor>
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestNewLocalConfigAfterCompactionActorState {
															#line 4555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestNewLocalConfigAfterCompactionActorState(UnitTestParameters const& params) 
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 4564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this));

	}
	~TestNewLocalConfigAfterCompactionActorState() 
	{
		fdb_probe_actor_destroy("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 1;
															#line 568 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 0, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestNewLocalConfigAfterCompactionActorState();
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4611 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 2;
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 1, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4616 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4627 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 2;
															#line 569 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 1, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 3;
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 2, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4734 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 3;
															#line 570 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 2, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4739 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = compact(env);
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 4;
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 3, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4830 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = compact(env);
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 4;
															#line 571 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 3, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4846 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		platform::eraseDirectoryRecursive(params.getDataDir());
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		platform::createDirectory(params.getDataDir());
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = env.restartLocalConfig("class-A");
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 5;
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 4, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 574 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		platform::eraseDirectoryRecursive(params.getDataDir());
															#line 575 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		platform::createDirectory(params.getDataDir());
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = env.restartLocalConfig("class-A");
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4956 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 5;
															#line 576 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 4, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 4961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 578 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.changeBroadcaster();
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5049 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 6;
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 5, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 5054 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 578 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.changeBroadcaster();
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 6;
															#line 579 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 5, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 5072 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_6 = set(env, "class-A"_sr, "test_long"_sr, 2);
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 7;
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 6, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 5163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_6 = set(env, "class-A"_sr, "test_long"_sr, 2);
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 7;
															#line 580 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 6, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 5179 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_7 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5265 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 8;
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 7, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 5270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_7 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 8;
															#line 581 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TestNewLocalConfigAfterCompactionActor, 7, Void >*>(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)));
															#line 5286 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->SAV<std::string>::futures) { (void)(env.getStatus().getJson()); this->~TestNewLocalConfigAfterCompactionActorState(); static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->destroy(); return 0; }
															#line 5370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->SAV< std::string >::value()) std::string(env.getStatus().getJson());
		this->~TestNewLocalConfigAfterCompactionActorState();
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 582 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->SAV<std::string>::futures) { (void)(env.getStatus().getJson()); this->~TestNewLocalConfigAfterCompactionActorState(); static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->destroy(); return 0; }
															#line 5382 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->SAV< std::string >::value()) std::string(env.getStatus().getJson());
		this->~TestNewLocalConfigAfterCompactionActorState();
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state > 0) static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->actor_wait_state = 0;
		static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->ActorCallback< TestNewLocalConfigAfterCompactionActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< TestNewLocalConfigAfterCompactionActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< TestNewLocalConfigAfterCompactionActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), 7);

	}
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 567 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 5469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testNewLocalConfigAfterCompaction()
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestNewLocalConfigAfterCompactionActor final : public Actor<std::string>, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 0, Void >, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 1, Void >, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 2, Void >, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 3, Void >, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 4, Void >, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 5, Void >, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 6, Void >, public ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 7, Void >, public FastAllocated<TestNewLocalConfigAfterCompactionActor<Env>>, public TestNewLocalConfigAfterCompactionActorState<Env, TestNewLocalConfigAfterCompactionActor<Env>> {
															#line 5476 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestNewLocalConfigAfterCompactionActor<Env>>::operator new;
	using FastAllocated<TestNewLocalConfigAfterCompactionActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13409776866949348608UL, 3558839625119839232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 0, Void >;
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 1, Void >;
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 2, Void >;
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 3, Void >;
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 4, Void >;
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 5, Void >;
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 6, Void >;
friend struct ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 7, Void >;
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestNewLocalConfigAfterCompactionActor(UnitTestParameters const& params) 
															#line 5500 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<std::string>(),
		   TestNewLocalConfigAfterCompactionActorState<Env, TestNewLocalConfigAfterCompactionActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6650899712828477952UL, 9683732796116094976UL);
		ActorExecutionContextHelper __helper(static_cast<TestNewLocalConfigAfterCompactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testNewLocalConfigAfterCompaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testNewLocalConfigAfterCompaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< TestNewLocalConfigAfterCompactionActor<Env>, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<std::string> testNewLocalConfigAfterCompaction( UnitTestParameters const& params ) {
															#line 565 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<std::string>(new TestNewLocalConfigAfterCompactionActor<Env>(params));
															#line 5541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 584 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 5546 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testKillWorker()
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestKillWorkerActor>
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestKillWorkerActorState {
															#line 5552 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestKillWorkerActorState(UnitTestParameters const& params) 
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 5561 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testKillWorker", reinterpret_cast<unsigned long>(this));

	}
	~TestKillWorkerActorState() 
	{
		fdb_probe_actor_destroy("testKillWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5578 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 1;
															#line 588 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestKillWorkerActor, 0, Void >*>(static_cast<TestKillWorkerActor*>(this)));
															#line 5583 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestKillWorkerActorState();
		static_cast<TestKillWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.killLocalConfig();
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = timeoutError(env.workerFailed(), 3);
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5610 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 2;
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestKillWorkerActor, 1, Void >*>(static_cast<TestKillWorkerActor*>(this)));
															#line 5615 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 589 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.killLocalConfig();
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = timeoutError(env.workerFailed(), 3);
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5628 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 2;
															#line 591 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestKillWorkerActor, 1, Void >*>(static_cast<TestKillWorkerActor*>(this)));
															#line 5633 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<TestKillWorkerActor*>(this)->ActorCallback< TestKillWorkerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKillWorkerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestKillWorkerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestKillWorkerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		Future<Void> closed = env.onClosed();
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.close();
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = closed;
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5723 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 3;
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestKillWorkerActor, 2, Void >*>(static_cast<TestKillWorkerActor*>(this)));
															#line 5728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 592 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		Future<Void> closed = env.onClosed();
															#line 593 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.close();
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = closed;
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 3;
															#line 594 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestKillWorkerActor, 2, Void >*>(static_cast<TestKillWorkerActor*>(this)));
															#line 5748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<TestKillWorkerActor*>(this)->ActorCallback< TestKillWorkerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKillWorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestKillWorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestKillWorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestKillWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestKillWorkerActorState(); static_cast<TestKillWorkerActor*>(this)->destroy(); return 0; }
															#line 5832 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestKillWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestKillWorkerActorState();
		static_cast<TestKillWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 595 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestKillWorkerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestKillWorkerActorState(); static_cast<TestKillWorkerActor*>(this)->destroy(); return 0; }
															#line 5844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestKillWorkerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestKillWorkerActorState();
		static_cast<TestKillWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestKillWorkerActor*>(this)->actor_wait_state > 0) static_cast<TestKillWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<TestKillWorkerActor*>(this)->ActorCallback< TestKillWorkerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestKillWorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestKillWorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestKillWorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 587 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 5931 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testKillWorker()
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestKillWorkerActor final : public Actor<Void>, public ActorCallback< TestKillWorkerActor<Env>, 0, Void >, public ActorCallback< TestKillWorkerActor<Env>, 1, Void >, public ActorCallback< TestKillWorkerActor<Env>, 2, Void >, public FastAllocated<TestKillWorkerActor<Env>>, public TestKillWorkerActorState<Env, TestKillWorkerActor<Env>> {
															#line 5938 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestKillWorkerActor<Env>>::operator new;
	using FastAllocated<TestKillWorkerActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16647474268033434368UL, 5912238813432029696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestKillWorkerActor<Env>, 0, Void >;
friend struct ActorCallback< TestKillWorkerActor<Env>, 1, Void >;
friend struct ActorCallback< TestKillWorkerActor<Env>, 2, Void >;
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestKillWorkerActor(UnitTestParameters const& params) 
															#line 5957 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestKillWorkerActorState<Env, TestKillWorkerActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testKillWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1488883752621364480UL, 6135929532874476032UL);
		ActorExecutionContextHelper __helper(static_cast<TestKillWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testKillWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testKillWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestKillWorkerActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestKillWorkerActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestKillWorkerActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testKillWorker( UnitTestParameters const& params ) {
															#line 585 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestKillWorkerActor<Env>(params));
															#line 5993 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 597 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 5998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testSet()
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestSetActor>
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestSetActorState {
															#line 6004 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestSetActorState(UnitTestParameters const& params) 
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 6013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testSet", reinterpret_cast<unsigned long>(this));

	}
	~TestSetActorState() 
	{
		fdb_probe_actor_destroy("testSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestSetActor*>(this)->actor_wait_state = 1;
															#line 601 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestSetActor, 0, Void >*>(static_cast<TestSetActor*>(this)));
															#line 6035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestSetActorState();
		static_cast<TestSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestSetActor*>(this)->actor_wait_state = 2;
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestSetActor, 1, Void >*>(static_cast<TestSetActor*>(this)));
															#line 6065 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6076 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestSetActor*>(this)->actor_wait_state = 2;
															#line 602 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestSetActor, 1, Void >*>(static_cast<TestSetActor*>(this)));
															#line 6081 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestSetActor*>(this)->actor_wait_state > 0) static_cast<TestSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestSetActor*>(this)->ActorCallback< TestSetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestSetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestSetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestSetActor*>(this)->actor_wait_state = 3;
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestSetActor, 2, Void >*>(static_cast<TestSetActor*>(this)));
															#line 6172 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestSetActor*>(this)->actor_wait_state = 3;
															#line 603 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestSetActor, 2, Void >*>(static_cast<TestSetActor*>(this)));
															#line 6188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestSetActor*>(this)->actor_wait_state > 0) static_cast<TestSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestSetActor*>(this)->ActorCallback< TestSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestSetActorState(); static_cast<TestSetActor*>(this)->destroy(); return 0; }
															#line 6272 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestSetActorState();
		static_cast<TestSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 604 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestSetActorState(); static_cast<TestSetActor*>(this)->destroy(); return 0; }
															#line 6284 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestSetActorState();
		static_cast<TestSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestSetActor*>(this)->actor_wait_state > 0) static_cast<TestSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestSetActor*>(this)->ActorCallback< TestSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 600 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 6371 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testSet()
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestSetActor final : public Actor<Void>, public ActorCallback< TestSetActor<Env>, 0, Void >, public ActorCallback< TestSetActor<Env>, 1, Void >, public ActorCallback< TestSetActor<Env>, 2, Void >, public FastAllocated<TestSetActor<Env>>, public TestSetActorState<Env, TestSetActor<Env>> {
															#line 6378 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestSetActor<Env>>::operator new;
	using FastAllocated<TestSetActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1384307397118039296UL, 8864684394203077120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestSetActor<Env>, 0, Void >;
friend struct ActorCallback< TestSetActor<Env>, 1, Void >;
friend struct ActorCallback< TestSetActor<Env>, 2, Void >;
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestSetActor(UnitTestParameters const& params) 
															#line 6397 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestSetActorState<Env, TestSetActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3030299605040313600UL, 16573408122665413376UL);
		ActorExecutionContextHelper __helper(static_cast<TestSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestSetActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestSetActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestSetActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testSet( UnitTestParameters const& params ) {
															#line 598 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestSetActor<Env>(params));
															#line 6433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 606 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 6438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testAtomicSet()
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestAtomicSetActor>
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestAtomicSetActorState {
															#line 6444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestAtomicSetActorState(UnitTestParameters const& params) 
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 6453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testAtomicSet", reinterpret_cast<unsigned long>(this));

	}
	~TestAtomicSetActorState() 
	{
		fdb_probe_actor_destroy("testAtomicSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6470 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 1;
															#line 610 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAtomicSetActor, 0, Void >*>(static_cast<TestAtomicSetActor*>(this)));
															#line 6475 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAtomicSetActorState();
		static_cast<TestAtomicSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		restarted = false;
															#line 6498 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		try {
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_atomic_long"_sr, int64_t{ 1 });
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6504 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 2;
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicSetActor, 1, Void >*>(static_cast<TestAtomicSetActor*>(this)));
															#line 6509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		restarted = false;
															#line 6524 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		try {
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_atomic_long"_sr, int64_t{ 1 });
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 2;
															#line 613 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicSetActor, 1, Void >*>(static_cast<TestAtomicSetActor*>(this)));
															#line 6535 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicSetActor*>(this)->ActorCallback< TestAtomicSetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAtomicSetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 618 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(restarted);
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = env.restartLocalConfig("class-A");
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6629 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 3;
															#line 619 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAtomicSetActor, 2, Void >*>(static_cast<TestAtomicSetActor*>(this)));
															#line 6634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 615 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(e.code() == error_code_local_config_changed);
															#line 616 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			restarted = true;
															#line 6646 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicSetActor*>(this)->ActorCallback< TestAtomicSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAtomicSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_ATOMIC_LONG, Optional<int64_t>{ 1 });
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6763 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 4;
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAtomicSetActor, 3, Void >*>(static_cast<TestAtomicSetActor*>(this)));
															#line 6768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_ATOMIC_LONG, Optional<int64_t>{ 1 });
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6779 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 4;
															#line 620 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAtomicSetActor, 3, Void >*>(static_cast<TestAtomicSetActor*>(this)));
															#line 6784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicSetActor*>(this)->ActorCallback< TestAtomicSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAtomicSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 621 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestAtomicSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAtomicSetActorState(); static_cast<TestAtomicSetActor*>(this)->destroy(); return 0; }
															#line 6868 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestAtomicSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAtomicSetActorState();
		static_cast<TestAtomicSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 621 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestAtomicSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAtomicSetActorState(); static_cast<TestAtomicSetActor*>(this)->destroy(); return 0; }
															#line 6880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestAtomicSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAtomicSetActorState();
		static_cast<TestAtomicSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestAtomicSetActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicSetActor*>(this)->ActorCallback< TestAtomicSetActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestAtomicSetActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestAtomicSetActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 609 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 611 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	bool restarted;
															#line 6969 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testAtomicSet()
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestAtomicSetActor final : public Actor<Void>, public ActorCallback< TestAtomicSetActor<Env>, 0, Void >, public ActorCallback< TestAtomicSetActor<Env>, 1, Void >, public ActorCallback< TestAtomicSetActor<Env>, 2, Void >, public ActorCallback< TestAtomicSetActor<Env>, 3, Void >, public FastAllocated<TestAtomicSetActor<Env>>, public TestAtomicSetActorState<Env, TestAtomicSetActor<Env>> {
															#line 6976 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestAtomicSetActor<Env>>::operator new;
	using FastAllocated<TestAtomicSetActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14107661012735575040UL, 12803649998452668672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAtomicSetActor<Env>, 0, Void >;
friend struct ActorCallback< TestAtomicSetActor<Env>, 1, Void >;
friend struct ActorCallback< TestAtomicSetActor<Env>, 2, Void >;
friend struct ActorCallback< TestAtomicSetActor<Env>, 3, Void >;
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestAtomicSetActor(UnitTestParameters const& params) 
															#line 6996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestAtomicSetActorState<Env, TestAtomicSetActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAtomicSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14410322354549321984UL, 15508186000614925568UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAtomicSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAtomicSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAtomicSetActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAtomicSetActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestAtomicSetActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestAtomicSetActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testAtomicSet( UnitTestParameters const& params ) {
															#line 607 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestAtomicSetActor<Env>(params));
															#line 7033 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 623 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 7038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testClear()
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestClearActor>
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestClearActorState {
															#line 7044 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestClearActorState(UnitTestParameters const& params) 
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 7053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testClear", reinterpret_cast<unsigned long>(this));

	}
	~TestClearActorState() 
	{
		fdb_probe_actor_destroy("testClear", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestClearActor*>(this)->actor_wait_state = 1;
															#line 627 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestClearActor, 0, Void >*>(static_cast<TestClearActor*>(this)));
															#line 7075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestClearActorState();
		static_cast<TestClearActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7100 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestClearActor*>(this)->actor_wait_state = 2;
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestClearActor, 1, Void >*>(static_cast<TestClearActor*>(this)));
															#line 7105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7116 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestClearActor*>(this)->actor_wait_state = 2;
															#line 628 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestClearActor, 1, Void >*>(static_cast<TestClearActor*>(this)));
															#line 7121 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestClearActor*>(this)->actor_wait_state > 0) static_cast<TestClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestClearActor*>(this)->ActorCallback< TestClearActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestClearActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestClearActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestClearActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = clear(env, "class-A"_sr, "test_long"_sr);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestClearActor*>(this)->actor_wait_state = 3;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestClearActor, 2, Void >*>(static_cast<TestClearActor*>(this)));
															#line 7212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = clear(env, "class-A"_sr, "test_long"_sr);
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7223 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestClearActor*>(this)->actor_wait_state = 3;
															#line 629 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestClearActor, 2, Void >*>(static_cast<TestClearActor*>(this)));
															#line 7228 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestClearActor*>(this)->actor_wait_state > 0) static_cast<TestClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestClearActor*>(this)->ActorCallback< TestClearActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestClearActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestClearActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestClearActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{});
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestClearActor*>(this)->actor_wait_state = 4;
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestClearActor, 3, Void >*>(static_cast<TestClearActor*>(this)));
															#line 7319 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{});
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestClearActor*>(this)->actor_wait_state = 4;
															#line 630 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestClearActor, 3, Void >*>(static_cast<TestClearActor*>(this)));
															#line 7335 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestClearActor*>(this)->actor_wait_state > 0) static_cast<TestClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestClearActor*>(this)->ActorCallback< TestClearActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestClearActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestClearActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestClearActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestClearActorState(); static_cast<TestClearActor*>(this)->destroy(); return 0; }
															#line 7419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestClearActorState();
		static_cast<TestClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 631 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestClearActorState(); static_cast<TestClearActor*>(this)->destroy(); return 0; }
															#line 7431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestClearActorState();
		static_cast<TestClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestClearActor*>(this)->actor_wait_state > 0) static_cast<TestClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestClearActor*>(this)->ActorCallback< TestClearActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestClearActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestClearActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestClearActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 626 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 7518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testClear()
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestClearActor final : public Actor<Void>, public ActorCallback< TestClearActor<Env>, 0, Void >, public ActorCallback< TestClearActor<Env>, 1, Void >, public ActorCallback< TestClearActor<Env>, 2, Void >, public ActorCallback< TestClearActor<Env>, 3, Void >, public FastAllocated<TestClearActor<Env>>, public TestClearActorState<Env, TestClearActor<Env>> {
															#line 7525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestClearActor<Env>>::operator new;
	using FastAllocated<TestClearActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(586619348828707072UL, 17465188998855906560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestClearActor<Env>, 0, Void >;
friend struct ActorCallback< TestClearActor<Env>, 1, Void >;
friend struct ActorCallback< TestClearActor<Env>, 2, Void >;
friend struct ActorCallback< TestClearActor<Env>, 3, Void >;
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestClearActor(UnitTestParameters const& params) 
															#line 7545 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestClearActorState<Env, TestClearActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testClear", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17917248854791249408UL, 4427933218532448512UL);
		ActorExecutionContextHelper __helper(static_cast<TestClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testClear");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testClear", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestClearActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestClearActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestClearActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestClearActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testClear( UnitTestParameters const& params ) {
															#line 624 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestClearActor<Env>(params));
															#line 7582 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 633 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 7587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testAtomicClear()
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestAtomicClearActor>
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestAtomicClearActorState {
															#line 7593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestAtomicClearActorState(UnitTestParameters const& params) 
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 7602 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testAtomicClear", reinterpret_cast<unsigned long>(this));

	}
	~TestAtomicClearActorState() 
	{
		fdb_probe_actor_destroy("testAtomicClear", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 1;
															#line 637 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestAtomicClearActor, 0, Void >*>(static_cast<TestAtomicClearActor*>(this)));
															#line 7624 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestAtomicClearActorState();
		static_cast<TestAtomicClearActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		restarted = false;
															#line 7647 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		try {
															#line 640 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_atomic_long"_sr, int64_t{ 1 });
															#line 640 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 7653 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 2;
															#line 640 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicClearActor, 1, Void >*>(static_cast<TestAtomicClearActor*>(this)));
															#line 7658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		restarted = false;
															#line 7673 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		try {
															#line 640 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_atomic_long"_sr, int64_t{ 1 });
															#line 640 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 7679 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 2;
															#line 640 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestAtomicClearActor, 1, Void >*>(static_cast<TestAtomicClearActor*>(this)));
															#line 7684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicClearActor*>(this)->ActorCallback< TestAtomicClearActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestAtomicClearActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 645 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(restarted);
															#line 646 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		restarted = false;
															#line 7776 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		try {
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_2 = clear(env, "class-A"_sr, "test_atomic_long"_sr);
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 7782 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 3;
															#line 648 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestAtomicClearActor, 2, Void >*>(static_cast<TestAtomicClearActor*>(this)));
															#line 7787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 642 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(e.code() == error_code_local_config_changed);
															#line 643 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			restarted = true;
															#line 7805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicClearActor*>(this)->ActorCallback< TestAtomicClearActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestAtomicClearActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
															#line 653 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(restarted);
															#line 654 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_ATOMIC_LONG, Optional<int64_t>{});
															#line 654 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7924 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 4;
															#line 654 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestAtomicClearActor, 3, Void >*>(static_cast<TestAtomicClearActor*>(this)));
															#line 7929 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 650 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			ASSERT(e.code() == error_code_local_config_changed);
															#line 651 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			restarted = true;
															#line 7941 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicClearActor*>(this)->ActorCallback< TestAtomicClearActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestAtomicClearActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestAtomicClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAtomicClearActorState(); static_cast<TestAtomicClearActor*>(this)->destroy(); return 0; }
															#line 8056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestAtomicClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAtomicClearActorState();
		static_cast<TestAtomicClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 655 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestAtomicClearActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestAtomicClearActorState(); static_cast<TestAtomicClearActor*>(this)->destroy(); return 0; }
															#line 8068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestAtomicClearActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestAtomicClearActorState();
		static_cast<TestAtomicClearActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestAtomicClearActor*>(this)->actor_wait_state > 0) static_cast<TestAtomicClearActor*>(this)->actor_wait_state = 0;
		static_cast<TestAtomicClearActor*>(this)->ActorCallback< TestAtomicClearActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestAtomicClearActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestAtomicClearActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 636 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 638 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	bool restarted;
															#line 8157 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testAtomicClear()
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestAtomicClearActor final : public Actor<Void>, public ActorCallback< TestAtomicClearActor<Env>, 0, Void >, public ActorCallback< TestAtomicClearActor<Env>, 1, Void >, public ActorCallback< TestAtomicClearActor<Env>, 2, Void >, public ActorCallback< TestAtomicClearActor<Env>, 3, Void >, public FastAllocated<TestAtomicClearActor<Env>>, public TestAtomicClearActorState<Env, TestAtomicClearActor<Env>> {
															#line 8164 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestAtomicClearActor<Env>>::operator new;
	using FastAllocated<TestAtomicClearActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2761144599634574336UL, 14013765880498514176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestAtomicClearActor<Env>, 0, Void >;
friend struct ActorCallback< TestAtomicClearActor<Env>, 1, Void >;
friend struct ActorCallback< TestAtomicClearActor<Env>, 2, Void >;
friend struct ActorCallback< TestAtomicClearActor<Env>, 3, Void >;
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestAtomicClearActor(UnitTestParameters const& params) 
															#line 8184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestAtomicClearActorState<Env, TestAtomicClearActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testAtomicClear", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9360441192302812160UL, 17781041177295283712UL);
		ActorExecutionContextHelper __helper(static_cast<TestAtomicClearActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testAtomicClear");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testAtomicClear", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestAtomicClearActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestAtomicClearActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestAtomicClearActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestAtomicClearActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testAtomicClear( UnitTestParameters const& params ) {
															#line 634 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestAtomicClearActor<Env>(params));
															#line 8221 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 657 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 8226 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testGlobalSet()
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestGlobalSetActor>
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestGlobalSetActorState {
															#line 8232 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestGlobalSetActorState(UnitTestParameters const& params) 
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 8241 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testGlobalSet", reinterpret_cast<unsigned long>(this));

	}
	~TestGlobalSetActorState() 
	{
		fdb_probe_actor_destroy("testGlobalSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 661 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 661 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8258 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 1;
															#line 661 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 0, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestGlobalSetActorState();
		static_cast<TestGlobalSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, Optional<KeyRef>{}, "test_long"_sr, int64_t{ 1 });
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8288 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 2;
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 1, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8293 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, Optional<KeyRef>{}, "test_long"_sr, int64_t{ 1 });
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8304 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 2;
															#line 662 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 1, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state > 0) static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestGlobalSetActor*>(this)->ActorCallback< TestGlobalSetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestGlobalSetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 3;
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 2, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 3;
															#line 663 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 2, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state > 0) static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestGlobalSetActor*>(this)->ActorCallback< TestGlobalSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestGlobalSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 10 });
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 4;
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 3, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8507 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 10 });
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8518 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 4;
															#line 664 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 3, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8523 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state > 0) static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestGlobalSetActor*>(this)->ActorCallback< TestGlobalSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestGlobalSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 10 });
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 5;
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 4, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8614 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 10 });
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 5;
															#line 665 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestGlobalSetActor, 4, Void >*>(static_cast<TestGlobalSetActor*>(this)));
															#line 8630 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state > 0) static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestGlobalSetActor*>(this)->ActorCallback< TestGlobalSetActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestGlobalSetActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestGlobalSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGlobalSetActorState(); static_cast<TestGlobalSetActor*>(this)->destroy(); return 0; }
															#line 8714 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestGlobalSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGlobalSetActorState();
		static_cast<TestGlobalSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 666 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestGlobalSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGlobalSetActorState(); static_cast<TestGlobalSetActor*>(this)->destroy(); return 0; }
															#line 8726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestGlobalSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGlobalSetActorState();
		static_cast<TestGlobalSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestGlobalSetActor*>(this)->actor_wait_state > 0) static_cast<TestGlobalSetActor*>(this)->actor_wait_state = 0;
		static_cast<TestGlobalSetActor*>(this)->ActorCallback< TestGlobalSetActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestGlobalSetActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestGlobalSetActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 660 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 8813 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testGlobalSet()
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestGlobalSetActor final : public Actor<Void>, public ActorCallback< TestGlobalSetActor<Env>, 0, Void >, public ActorCallback< TestGlobalSetActor<Env>, 1, Void >, public ActorCallback< TestGlobalSetActor<Env>, 2, Void >, public ActorCallback< TestGlobalSetActor<Env>, 3, Void >, public ActorCallback< TestGlobalSetActor<Env>, 4, Void >, public FastAllocated<TestGlobalSetActor<Env>>, public TestGlobalSetActorState<Env, TestGlobalSetActor<Env>> {
															#line 8820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestGlobalSetActor<Env>>::operator new;
	using FastAllocated<TestGlobalSetActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3832168042231138560UL, 5578708578822073088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestGlobalSetActor<Env>, 0, Void >;
friend struct ActorCallback< TestGlobalSetActor<Env>, 1, Void >;
friend struct ActorCallback< TestGlobalSetActor<Env>, 2, Void >;
friend struct ActorCallback< TestGlobalSetActor<Env>, 3, Void >;
friend struct ActorCallback< TestGlobalSetActor<Env>, 4, Void >;
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestGlobalSetActor(UnitTestParameters const& params) 
															#line 8841 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestGlobalSetActorState<Env, TestGlobalSetActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testGlobalSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9792832150164213248UL, 17045993986056810240UL);
		ActorExecutionContextHelper __helper(static_cast<TestGlobalSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testGlobalSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testGlobalSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestGlobalSetActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestGlobalSetActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestGlobalSetActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestGlobalSetActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestGlobalSetActor<Env>, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testGlobalSet( UnitTestParameters const& params ) {
															#line 658 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestGlobalSetActor<Env>(params));
															#line 8879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 668 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 8884 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testIgnore()
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestIgnoreActor>
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestIgnoreActorState {
															#line 8890 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestIgnoreActorState(UnitTestParameters const& params) 
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 8899 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testIgnore", reinterpret_cast<unsigned long>(this));

	}
	~TestIgnoreActorState() 
	{
		fdb_probe_actor_destroy("testIgnore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr, "class-B"_sr }));
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestIgnoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8916 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestIgnoreActor*>(this)->actor_wait_state = 1;
															#line 672 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestIgnoreActor, 0, Void >*>(static_cast<TestIgnoreActor*>(this)));
															#line 8921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestIgnoreActorState();
		static_cast<TestIgnoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 1 });
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestIgnoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8946 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestIgnoreActor*>(this)->actor_wait_state = 2;
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestIgnoreActor, 1, Void >*>(static_cast<TestIgnoreActor*>(this)));
															#line 8951 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 1 });
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestIgnoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8962 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestIgnoreActor*>(this)->actor_wait_state = 2;
															#line 673 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestIgnoreActor, 1, Void >*>(static_cast<TestIgnoreActor*>(this)));
															#line 8967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestIgnoreActor*>(this)->actor_wait_state > 0) static_cast<TestIgnoreActor*>(this)->actor_wait_state = 0;
		static_cast<TestIgnoreActor*>(this)->ActorCallback< TestIgnoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestIgnoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(5);
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestIgnoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
															#line 676 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 9057 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when2(__when_expr_3.get(), loopDepth); };
		static_cast<TestIgnoreActor*>(this)->actor_wait_state = 3;
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestIgnoreActor, 2, Void >*>(static_cast<TestIgnoreActor*>(this)));
															#line 676 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestIgnoreActor, 3, Void >*>(static_cast<TestIgnoreActor*>(this)));
															#line 9064 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(5);
															#line 674 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestIgnoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
															#line 676 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 9079 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2when2(__when_expr_3.get(), loopDepth); };
		static_cast<TestIgnoreActor*>(this)->actor_wait_state = 3;
															#line 675 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestIgnoreActor, 2, Void >*>(static_cast<TestIgnoreActor*>(this)));
															#line 676 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestIgnoreActor, 3, Void >*>(static_cast<TestIgnoreActor*>(this)));
															#line 9086 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestIgnoreActor*>(this)->actor_wait_state > 0) static_cast<TestIgnoreActor*>(this)->actor_wait_state = 0;
		static_cast<TestIgnoreActor*>(this)->ActorCallback< TestIgnoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestIgnoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 680 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestIgnoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestIgnoreActorState(); static_cast<TestIgnoreActor*>(this)->destroy(); return 0; }
															#line 9170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestIgnoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestIgnoreActorState();
		static_cast<TestIgnoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(Void const& _,int loopDepth) 
	{
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(false);
															#line 9194 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when2(Void && _,int loopDepth) 
	{
															#line 677 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(false);
															#line 9203 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestIgnoreActor*>(this)->actor_wait_state > 0) static_cast<TestIgnoreActor*>(this)->actor_wait_state = 0;
		static_cast<TestIgnoreActor*>(this)->ActorCallback< TestIgnoreActor, 2, Void >::remove();
		static_cast<TestIgnoreActor*>(this)->ActorCallback< TestIgnoreActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestIgnoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestIgnoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestIgnoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 671 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 9333 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testIgnore()
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestIgnoreActor final : public Actor<Void>, public ActorCallback< TestIgnoreActor<Env>, 0, Void >, public ActorCallback< TestIgnoreActor<Env>, 1, Void >, public ActorCallback< TestIgnoreActor<Env>, 2, Void >, public ActorCallback< TestIgnoreActor<Env>, 3, Void >, public FastAllocated<TestIgnoreActor<Env>>, public TestIgnoreActorState<Env, TestIgnoreActor<Env>> {
															#line 9340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestIgnoreActor<Env>>::operator new;
	using FastAllocated<TestIgnoreActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17950643167741064704UL, 3173477287461981696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestIgnoreActor<Env>, 0, Void >;
friend struct ActorCallback< TestIgnoreActor<Env>, 1, Void >;
friend struct ActorCallback< TestIgnoreActor<Env>, 2, Void >;
friend struct ActorCallback< TestIgnoreActor<Env>, 3, Void >;
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestIgnoreActor(UnitTestParameters const& params) 
															#line 9360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestIgnoreActorState<Env, TestIgnoreActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testIgnore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11448046487994411520UL, 18228452843738158848UL);
		ActorExecutionContextHelper __helper(static_cast<TestIgnoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testIgnore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testIgnore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestIgnoreActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestIgnoreActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestIgnoreActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testIgnore( UnitTestParameters const& params ) {
															#line 669 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestIgnoreActor<Env>(params));
															#line 9396 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 682 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 9401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testCompact()
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestCompactActor>
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestCompactActorState {
															#line 9407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestCompactActorState(UnitTestParameters const& params) 
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 685 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 9416 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testCompact", reinterpret_cast<unsigned long>(this));

	}
	~TestCompactActorState() 
	{
		fdb_probe_actor_destroy("testCompact", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9433 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestCompactActor*>(this)->actor_wait_state = 1;
															#line 686 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 0, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9438 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestCompactActorState();
		static_cast<TestCompactActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 687 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 687 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9463 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 2;
															#line 687 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 1, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9468 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 687 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 687 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 2;
															#line 687 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 1, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9484 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestCompactActor*>(this)->actor_wait_state > 0) static_cast<TestCompactActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompactActor*>(this)->ActorCallback< TestCompactActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestCompactActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = compact(env);
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9570 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 3;
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 2, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9575 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = compact(env);
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 3;
															#line 688 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 2, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9591 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestCompactActor*>(this)->actor_wait_state > 0) static_cast<TestCompactActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompactActor*>(this)->ActorCallback< TestCompactActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestCompactActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9677 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 4;
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 3, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9682 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 4;
															#line 689 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 3, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9698 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestCompactActor*>(this)->actor_wait_state > 0) static_cast<TestCompactActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompactActor*>(this)->ActorCallback< TestCompactActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestCompactActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 2 });
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9784 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 5;
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 4, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9789 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 2 });
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9800 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 5;
															#line 690 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 4, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9805 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestCompactActor*>(this)->actor_wait_state > 0) static_cast<TestCompactActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompactActor*>(this)->ActorCallback< TestCompactActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestCompactActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 691 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 691 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9891 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 6;
															#line 691 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 5, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9896 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 691 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_5 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 691 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestCompactActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<TestCompactActor*>(this)->actor_wait_state = 6;
															#line 691 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TestCompactActor, 5, Void >*>(static_cast<TestCompactActor*>(this)));
															#line 9912 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestCompactActor*>(this)->actor_wait_state > 0) static_cast<TestCompactActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompactActor*>(this)->ActorCallback< TestCompactActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestCompactActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 692 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestCompactActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCompactActorState(); static_cast<TestCompactActor*>(this)->destroy(); return 0; }
															#line 9996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestCompactActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCompactActorState();
		static_cast<TestCompactActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 692 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestCompactActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestCompactActorState(); static_cast<TestCompactActor*>(this)->destroy(); return 0; }
															#line 10008 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestCompactActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestCompactActorState();
		static_cast<TestCompactActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TestCompactActor*>(this)->actor_wait_state > 0) static_cast<TestCompactActor*>(this)->actor_wait_state = 0;
		static_cast<TestCompactActor*>(this)->ActorCallback< TestCompactActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TestCompactActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TestCompactActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 685 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 10095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testCompact()
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestCompactActor final : public Actor<Void>, public ActorCallback< TestCompactActor<Env>, 0, Void >, public ActorCallback< TestCompactActor<Env>, 1, Void >, public ActorCallback< TestCompactActor<Env>, 2, Void >, public ActorCallback< TestCompactActor<Env>, 3, Void >, public ActorCallback< TestCompactActor<Env>, 4, Void >, public ActorCallback< TestCompactActor<Env>, 5, Void >, public FastAllocated<TestCompactActor<Env>>, public TestCompactActorState<Env, TestCompactActor<Env>> {
															#line 10102 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestCompactActor<Env>>::operator new;
	using FastAllocated<TestCompactActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18241997396865217024UL, 117022347238963712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestCompactActor<Env>, 0, Void >;
friend struct ActorCallback< TestCompactActor<Env>, 1, Void >;
friend struct ActorCallback< TestCompactActor<Env>, 2, Void >;
friend struct ActorCallback< TestCompactActor<Env>, 3, Void >;
friend struct ActorCallback< TestCompactActor<Env>, 4, Void >;
friend struct ActorCallback< TestCompactActor<Env>, 5, Void >;
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestCompactActor(UnitTestParameters const& params) 
															#line 10124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestCompactActorState<Env, TestCompactActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testCompact", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13482025005204312064UL, 2440409313776067584UL);
		ActorExecutionContextHelper __helper(static_cast<TestCompactActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testCompact");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testCompact", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestCompactActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestCompactActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestCompactActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestCompactActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestCompactActor<Env>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TestCompactActor<Env>, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testCompact( UnitTestParameters const& params ) {
															#line 683 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestCompactActor<Env>(params));
															#line 10163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 694 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 10168 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testChangeBroadcaster()
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env, class TestChangeBroadcasterActor>
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestChangeBroadcasterActorState {
															#line 10174 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestChangeBroadcasterActorState(UnitTestParameters const& params) 
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 697 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 10183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testChangeBroadcaster", reinterpret_cast<unsigned long>(this));

	}
	~TestChangeBroadcasterActorState() 
	{
		fdb_probe_actor_destroy("testChangeBroadcaster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10200 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 1;
															#line 698 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 0, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10205 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestChangeBroadcasterActorState();
		static_cast<TestChangeBroadcasterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10230 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 2;
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 1, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10235 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10246 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 2;
															#line 699 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 1, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state > 0) static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 0;
		static_cast<TestChangeBroadcasterActor*>(this)->ActorCallback< TestChangeBroadcasterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestChangeBroadcasterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 3;
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 2, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10342 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10353 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 3;
															#line 700 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 2, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10358 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state > 0) static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 0;
		static_cast<TestChangeBroadcasterActor*>(this)->ActorCallback< TestChangeBroadcasterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestChangeBroadcasterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.changeBroadcaster();
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 2 });
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10446 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 4;
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 3, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 701 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.changeBroadcaster();
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 2 });
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10464 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 4;
															#line 702 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 3, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10469 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state > 0) static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 0;
		static_cast<TestChangeBroadcasterActor*>(this)->ActorCallback< TestChangeBroadcasterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestChangeBroadcasterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 5;
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 4, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10560 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 2 });
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10571 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 5;
															#line 703 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestChangeBroadcasterActor, 4, Void >*>(static_cast<TestChangeBroadcasterActor*>(this)));
															#line 10576 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state > 0) static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 0;
		static_cast<TestChangeBroadcasterActor*>(this)->ActorCallback< TestChangeBroadcasterActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestChangeBroadcasterActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestChangeBroadcasterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestChangeBroadcasterActorState(); static_cast<TestChangeBroadcasterActor*>(this)->destroy(); return 0; }
															#line 10660 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestChangeBroadcasterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestChangeBroadcasterActorState();
		static_cast<TestChangeBroadcasterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 704 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestChangeBroadcasterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestChangeBroadcasterActorState(); static_cast<TestChangeBroadcasterActor*>(this)->destroy(); return 0; }
															#line 10672 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestChangeBroadcasterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestChangeBroadcasterActorState();
		static_cast<TestChangeBroadcasterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state > 0) static_cast<TestChangeBroadcasterActor*>(this)->actor_wait_state = 0;
		static_cast<TestChangeBroadcasterActor*>(this)->ActorCallback< TestChangeBroadcasterActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestChangeBroadcasterActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestChangeBroadcasterActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 697 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Env env;
															#line 10759 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testChangeBroadcaster()
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestChangeBroadcasterActor final : public Actor<Void>, public ActorCallback< TestChangeBroadcasterActor<Env>, 0, Void >, public ActorCallback< TestChangeBroadcasterActor<Env>, 1, Void >, public ActorCallback< TestChangeBroadcasterActor<Env>, 2, Void >, public ActorCallback< TestChangeBroadcasterActor<Env>, 3, Void >, public ActorCallback< TestChangeBroadcasterActor<Env>, 4, Void >, public FastAllocated<TestChangeBroadcasterActor<Env>>, public TestChangeBroadcasterActorState<Env, TestChangeBroadcasterActor<Env>> {
															#line 10766 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestChangeBroadcasterActor<Env>>::operator new;
	using FastAllocated<TestChangeBroadcasterActor<Env>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2077449711950471168UL, 10033785372370934784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestChangeBroadcasterActor<Env>, 0, Void >;
friend struct ActorCallback< TestChangeBroadcasterActor<Env>, 1, Void >;
friend struct ActorCallback< TestChangeBroadcasterActor<Env>, 2, Void >;
friend struct ActorCallback< TestChangeBroadcasterActor<Env>, 3, Void >;
friend struct ActorCallback< TestChangeBroadcasterActor<Env>, 4, Void >;
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestChangeBroadcasterActor(UnitTestParameters const& params) 
															#line 10787 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestChangeBroadcasterActorState<Env, TestChangeBroadcasterActor<Env>>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8948996388665113344UL, 6882640595381780480UL);
		ActorExecutionContextHelper __helper(static_cast<TestChangeBroadcasterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testChangeBroadcaster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testChangeBroadcaster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestChangeBroadcasterActor<Env>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestChangeBroadcasterActor<Env>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestChangeBroadcasterActor<Env>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestChangeBroadcasterActor<Env>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestChangeBroadcasterActor<Env>, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class Env>
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testChangeBroadcaster( UnitTestParameters const& params ) {
															#line 695 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestChangeBroadcasterActor<Env>(params));
															#line 10825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 706 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

bool matches(Standalone<VectorRef<KeyRef>> const& vec, std::set<Key> const& compareTo) {
	std::set<Key> s;
	for (const auto& value : vec) {
		s.insert(value);
	}
	return (s == compareTo);
}

															#line 10838 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testGetConfigClasses()
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class TestGetConfigClassesActor>
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestGetConfigClassesActorState {
															#line 10844 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestGetConfigClassesActorState(UnitTestParameters const& params,bool const& doCompact) 
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   doCompact(doCompact),
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir())
															#line 10855 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testGetConfigClasses", reinterpret_cast<unsigned long>(this));

	}
	~TestGetConfigClassesActorState() 
	{
		fdb_probe_actor_destroy("testGetConfigClasses", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 1;
															#line 717 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestGetConfigClassesActor, 0, Void >*>(static_cast<TestGetConfigClassesActor*>(this)));
															#line 10877 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestGetConfigClassesActorState();
		static_cast<TestGetConfigClassesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 1 });
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10902 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 2;
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGetConfigClassesActor, 1, Void >*>(static_cast<TestGetConfigClassesActor*>(this)));
															#line 10907 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 1 });
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10918 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 2;
															#line 718 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGetConfigClassesActor, 1, Void >*>(static_cast<TestGetConfigClassesActor*>(this)));
															#line 10923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetConfigClassesActor*>(this)->ActorCallback< TestGetConfigClassesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestGetConfigClassesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (doCompact)
															#line 11007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_2 = compact(env);
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11013 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 3;
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGetConfigClassesActor, 2, Void >*>(static_cast<TestGetConfigClassesActor*>(this)));
															#line 11018 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 719 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (doCompact)
															#line 11032 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_2 = compact(env);
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 3;
															#line 720 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGetConfigClassesActor, 2, Void >*>(static_cast<TestGetConfigClassesActor*>(this)));
															#line 11043 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetConfigClassesActor*>(this)->ActorCallback< TestGetConfigClassesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestGetConfigClassesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 722 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_3 = env.getConfigClasses();
															#line 722 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11134 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 4;
															#line 722 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >*>(static_cast<TestGetConfigClassesActor*>(this)));
															#line 11139 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetConfigClassesActor*>(this)->ActorCallback< TestGetConfigClassesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestGetConfigClassesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Standalone<VectorRef<KeyRef>> const& configClasses,int loopDepth) 
	{
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(matches(configClasses, { "class-A"_sr, "class-B"_sr }));
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestGetConfigClassesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGetConfigClassesActorState(); static_cast<TestGetConfigClassesActor*>(this)->destroy(); return 0; }
															#line 11237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestGetConfigClassesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGetConfigClassesActorState();
		static_cast<TestGetConfigClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Standalone<VectorRef<KeyRef>> && configClasses,int loopDepth) 
	{
															#line 723 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(matches(configClasses, { "class-A"_sr, "class-B"_sr }));
															#line 724 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestGetConfigClassesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGetConfigClassesActorState(); static_cast<TestGetConfigClassesActor*>(this)->destroy(); return 0; }
															#line 11251 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestGetConfigClassesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGetConfigClassesActorState();
		static_cast<TestGetConfigClassesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<VectorRef<KeyRef>> const& configClasses,int loopDepth) 
	{
		loopDepth = a_body1cont5(configClasses, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<VectorRef<KeyRef>> && configClasses,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(configClasses), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state > 0) static_cast<TestGetConfigClassesActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetConfigClassesActor*>(this)->ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	bool doCompact;
															#line 716 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionEnvironment env;
															#line 11340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testGetConfigClasses()
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestGetConfigClassesActor final : public Actor<Void>, public ActorCallback< TestGetConfigClassesActor, 0, Void >, public ActorCallback< TestGetConfigClassesActor, 1, Void >, public ActorCallback< TestGetConfigClassesActor, 2, Void >, public ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >, public FastAllocated<TestGetConfigClassesActor>, public TestGetConfigClassesActorState<TestGetConfigClassesActor> {
															#line 11345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestGetConfigClassesActor>::operator new;
	using FastAllocated<TestGetConfigClassesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4230620070390663936UL, 12054921381744921856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestGetConfigClassesActor, 0, Void >;
friend struct ActorCallback< TestGetConfigClassesActor, 1, Void >;
friend struct ActorCallback< TestGetConfigClassesActor, 2, Void >;
friend struct ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >;
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestGetConfigClassesActor(UnitTestParameters const& params,bool const& doCompact) 
															#line 11365 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestGetConfigClassesActorState<TestGetConfigClassesActor>(params, doCompact),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testGetConfigClasses", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5533591670701122304UL, 5927137263488159744UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetConfigClassesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testGetConfigClasses");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testGetConfigClasses", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestGetConfigClassesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestGetConfigClassesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestGetConfigClassesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestGetConfigClassesActor, 3, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testGetConfigClasses( UnitTestParameters const& params, bool const& doCompact ) {
															#line 715 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestGetConfigClassesActor(params, doCompact));
															#line 11400 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 726 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 11405 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
// This generated class is to be used only via testGetKnobs()
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class TestGetKnobsActor>
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestGetKnobsActorState {
															#line 11411 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestGetKnobsActorState(UnitTestParameters const& params,bool const& global,bool const& doCompact) 
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   global(global),
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   doCompact(doCompact),
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir()),
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   configClass()
															#line 11426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("testGetKnobs", reinterpret_cast<unsigned long>(this));

	}
	~TestGetKnobsActorState() 
	{
		fdb_probe_actor_destroy("testGetKnobs", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 730 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (!global)
															#line 11441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			{
															#line 731 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
				configClass = "class-A"_sr;
															#line 11445 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			}
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = set(env, configClass.castTo<KeyRef>(), "test_long"_sr, int64_t{ 1 });
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11451 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 1;
															#line 733 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 0, Void >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11456 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestGetKnobsActorState();
		static_cast<TestGetKnobsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, configClass.castTo<KeyRef>(), "test_int"_sr, int{ 2 });
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11481 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 2;
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 1, Void >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11486 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, configClass.castTo<KeyRef>(), "test_int"_sr, int{ 2 });
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11497 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 2;
															#line 734 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 1, Void >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11502 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state > 0) static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetKnobsActor*>(this)->ActorCallback< TestGetKnobsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestGetKnobsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = set(env, "class-B"_sr, "test_double"_sr, double{ 3.0 });
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11588 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 3;
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 2, Void >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11593 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = set(env, "class-B"_sr, "test_double"_sr, double{ 3.0 });
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 3;
															#line 735 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 2, Void >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11609 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state > 0) static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetKnobsActor*>(this)->ActorCallback< TestGetKnobsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TestGetKnobsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 736 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (doCompact)
															#line 11693 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_3 = compact(env);
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11699 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 4;
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 3, Void >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 736 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (doCompact)
															#line 11718 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		{
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_3 = compact(env);
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 4;
															#line 737 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 3, Void >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state > 0) static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetKnobsActor*>(this)->ActorCallback< TestGetKnobsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TestGetKnobsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_4 = waitOrError(env.getKnobNames(configClass.castTo<KeyRef>()), env.getError());
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 5;
															#line 739 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >*>(static_cast<TestGetKnobsActor*>(this)));
															#line 11825 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state > 0) static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetKnobsActor*>(this)->ActorCallback< TestGetKnobsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TestGetKnobsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(Standalone<VectorRef<KeyRef>> const& knobNames,int loopDepth) 
	{
															#line 741 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(matches(knobNames, { "test_long"_sr, "test_int"_sr }));
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestGetKnobsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGetKnobsActorState(); static_cast<TestGetKnobsActor*>(this)->destroy(); return 0; }
															#line 11923 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestGetKnobsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGetKnobsActorState();
		static_cast<TestGetKnobsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Standalone<VectorRef<KeyRef>> && knobNames,int loopDepth) 
	{
															#line 741 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(matches(knobNames, { "test_long"_sr, "test_int"_sr }));
															#line 742 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<TestGetKnobsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestGetKnobsActorState(); static_cast<TestGetKnobsActor*>(this)->destroy(); return 0; }
															#line 11937 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<TestGetKnobsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestGetKnobsActorState();
		static_cast<TestGetKnobsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Standalone<VectorRef<KeyRef>> const& knobNames,int loopDepth) 
	{
		loopDepth = a_body1cont7(knobNames, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Standalone<VectorRef<KeyRef>> && knobNames,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(knobNames), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TestGetKnobsActor*>(this)->actor_wait_state > 0) static_cast<TestGetKnobsActor*>(this)->actor_wait_state = 0;
		static_cast<TestGetKnobsActor*>(this)->ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	bool global;
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	bool doCompact;
															#line 728 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionEnvironment env;
															#line 729 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	Optional<Key> configClass;
															#line 12030 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via testGetKnobs()
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class TestGetKnobsActor final : public Actor<Void>, public ActorCallback< TestGetKnobsActor, 0, Void >, public ActorCallback< TestGetKnobsActor, 1, Void >, public ActorCallback< TestGetKnobsActor, 2, Void >, public ActorCallback< TestGetKnobsActor, 3, Void >, public ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >, public FastAllocated<TestGetKnobsActor>, public TestGetKnobsActorState<TestGetKnobsActor> {
															#line 12035 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<TestGetKnobsActor>::operator new;
	using FastAllocated<TestGetKnobsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12813374233417818624UL, 3279916370930651136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestGetKnobsActor, 0, Void >;
friend struct ActorCallback< TestGetKnobsActor, 1, Void >;
friend struct ActorCallback< TestGetKnobsActor, 2, Void >;
friend struct ActorCallback< TestGetKnobsActor, 3, Void >;
friend struct ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >;
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TestGetKnobsActor(UnitTestParameters const& params,bool const& global,bool const& doCompact) 
															#line 12056 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   TestGetKnobsActorState<TestGetKnobsActor>(params, global, doCompact),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testGetKnobs", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13721691855438621440UL, 4832838314609633024UL);
		ActorExecutionContextHelper __helper(static_cast<TestGetKnobsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testGetKnobs");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testGetKnobs", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestGetKnobsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TestGetKnobsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TestGetKnobsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TestGetKnobsActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TestGetKnobsActor, 4, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
[[nodiscard]] Future<Void> testGetKnobs( UnitTestParameters const& params, bool const& global, bool const& doCompact ) {
															#line 727 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new TestGetKnobsActor(params, global, doCompact));
															#line 12092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}

#line 744 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

} // namespace

															#line 12099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase747()
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase747Actor>
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase747ActorState {
															#line 12106 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase747ActorState(UnitTestParameters const& params) 
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 12113 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase747", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase747ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase747", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 748 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testSet<LocalConfigEnvironment>(params);
															#line 748 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase747Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase747Actor*>(this)->actor_wait_state = 1;
															#line 748 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase747Actor, 0, Void >*>(static_cast<FlowTestCase747Actor*>(this)));
															#line 12135 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase747ActorState();
		static_cast<FlowTestCase747Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase747Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase747ActorState(); static_cast<FlowTestCase747Actor*>(this)->destroy(); return 0; }
															#line 12158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase747Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase747ActorState();
		static_cast<FlowTestCase747Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 749 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase747Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase747ActorState(); static_cast<FlowTestCase747Actor*>(this)->destroy(); return 0; }
															#line 12170 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase747Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase747ActorState();
		static_cast<FlowTestCase747Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase747Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase747Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase747Actor*>(this)->ActorCallback< FlowTestCase747Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase747Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase747", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase747Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase747", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase747Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase747", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase747Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase747", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase747Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase747", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase747Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase747", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 12255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase747()
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase747Actor final : public Actor<Void>, public ActorCallback< FlowTestCase747Actor, 0, Void >, public FastAllocated<FlowTestCase747Actor>, public FlowTestCase747ActorState<FlowTestCase747Actor> {
															#line 12260 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase747Actor>::operator new;
	using FastAllocated<FlowTestCase747Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9097672506032689920UL, 12585184486555093504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase747Actor, 0, Void >;
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase747Actor(UnitTestParameters const& params) 
															#line 12277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase747ActorState<FlowTestCase747Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase747", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7398373504158579968UL, 9257727052614553856UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase747Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase747");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase747", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase747Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase747( UnitTestParameters const& params ) {
															#line 747 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase747Actor(params));
															#line 12310 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase747, "/fdbserver/ConfigDB/LocalConfiguration/Set")

#line 751 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 12316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase752()
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase752Actor>
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase752ActorState {
															#line 12323 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase752ActorState(UnitTestParameters const& params) 
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 12330 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase752", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase752ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase752", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testAtomicSet<LocalConfigEnvironment>(params);
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase752Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase752Actor*>(this)->actor_wait_state = 1;
															#line 753 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase752Actor, 0, Void >*>(static_cast<FlowTestCase752Actor*>(this)));
															#line 12352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase752ActorState();
		static_cast<FlowTestCase752Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase752Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase752ActorState(); static_cast<FlowTestCase752Actor*>(this)->destroy(); return 0; }
															#line 12375 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase752Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase752ActorState();
		static_cast<FlowTestCase752Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 754 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase752Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase752ActorState(); static_cast<FlowTestCase752Actor*>(this)->destroy(); return 0; }
															#line 12387 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase752Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase752ActorState();
		static_cast<FlowTestCase752Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase752Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase752Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase752Actor*>(this)->ActorCallback< FlowTestCase752Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase752Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase752", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase752Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase752", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase752Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase752", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase752Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase752", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase752Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase752", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase752Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase752", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 12472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase752()
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase752Actor final : public Actor<Void>, public ActorCallback< FlowTestCase752Actor, 0, Void >, public FastAllocated<FlowTestCase752Actor>, public FlowTestCase752ActorState<FlowTestCase752Actor> {
															#line 12477 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase752Actor>::operator new;
	using FastAllocated<FlowTestCase752Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14209125153074403328UL, 706339705312434944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase752Actor, 0, Void >;
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase752Actor(UnitTestParameters const& params) 
															#line 12494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase752ActorState<FlowTestCase752Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase752", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11006927378514130944UL, 13026646463073603840UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase752Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase752");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase752", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase752Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase752( UnitTestParameters const& params ) {
															#line 752 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase752Actor(params));
															#line 12527 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase752, "/fdbserver/ConfigDB/LocalConfiguration/AtomicSet")

#line 756 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 12533 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase757()
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase757Actor>
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase757ActorState {
															#line 12540 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase757ActorState(UnitTestParameters const& params) 
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 12547 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase757", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase757ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase757", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testRestartLocalConfig<LocalConfigEnvironment>(params);
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase757Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase757Actor*>(this)->actor_wait_state = 1;
															#line 758 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase757Actor, 0, Void >*>(static_cast<FlowTestCase757Actor*>(this)));
															#line 12569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase757ActorState();
		static_cast<FlowTestCase757Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 759 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase757Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase757ActorState(); static_cast<FlowTestCase757Actor*>(this)->destroy(); return 0; }
															#line 12592 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase757Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase757ActorState();
		static_cast<FlowTestCase757Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 759 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase757Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase757ActorState(); static_cast<FlowTestCase757Actor*>(this)->destroy(); return 0; }
															#line 12604 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase757Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase757ActorState();
		static_cast<FlowTestCase757Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase757Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase757Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase757Actor*>(this)->ActorCallback< FlowTestCase757Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase757Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase757", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase757Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase757", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase757Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase757", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase757Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase757", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase757Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase757", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase757Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase757", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 12689 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase757()
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase757Actor final : public Actor<Void>, public ActorCallback< FlowTestCase757Actor, 0, Void >, public FastAllocated<FlowTestCase757Actor>, public FlowTestCase757ActorState<FlowTestCase757Actor> {
															#line 12694 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase757Actor>::operator new;
	using FastAllocated<FlowTestCase757Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(575224401079809024UL, 18067677280476499968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase757Actor, 0, Void >;
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase757Actor(UnitTestParameters const& params) 
															#line 12711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase757ActorState<FlowTestCase757Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase757", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6831298534421225216UL, 11991827868289575680UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase757Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase757");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase757", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase757Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase757( UnitTestParameters const& params ) {
															#line 757 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase757Actor(params));
															#line 12744 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase757, "/fdbserver/ConfigDB/LocalConfiguration/Restart")

#line 761 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 12750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase762()
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase762Actor>
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase762ActorState {
															#line 12757 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase762ActorState(UnitTestParameters const& params) 
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 12764 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase762", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase762ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase762", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testRestartLocalConfigAndChangeClass<LocalConfigEnvironment>(params);
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase762Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase762Actor*>(this)->actor_wait_state = 1;
															#line 763 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase762Actor, 0, Void >*>(static_cast<FlowTestCase762Actor*>(this)));
															#line 12786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase762ActorState();
		static_cast<FlowTestCase762Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase762Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase762ActorState(); static_cast<FlowTestCase762Actor*>(this)->destroy(); return 0; }
															#line 12809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase762Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase762ActorState();
		static_cast<FlowTestCase762Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 764 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase762Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase762ActorState(); static_cast<FlowTestCase762Actor*>(this)->destroy(); return 0; }
															#line 12821 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase762Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase762ActorState();
		static_cast<FlowTestCase762Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase762Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase762Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase762Actor*>(this)->ActorCallback< FlowTestCase762Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase762Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase762", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase762Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase762", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase762Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase762", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase762Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase762", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase762Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase762", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase762Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase762", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 12906 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase762()
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase762Actor final : public Actor<Void>, public ActorCallback< FlowTestCase762Actor, 0, Void >, public FastAllocated<FlowTestCase762Actor>, public FlowTestCase762ActorState<FlowTestCase762Actor> {
															#line 12911 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase762Actor>::operator new;
	using FastAllocated<FlowTestCase762Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15084268900115466752UL, 8735221760977495552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase762Actor, 0, Void >;
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase762Actor(UnitTestParameters const& params) 
															#line 12928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase762ActorState<FlowTestCase762Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase762", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17018378336429648640UL, 3204161422519132672UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase762Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase762");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase762", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase762Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase762( UnitTestParameters const& params ) {
															#line 762 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase762Actor(params));
															#line 12961 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase762, "/fdbserver/ConfigDB/LocalConfiguration/RestartFresh")

#line 766 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 12967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase767()
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase767Actor>
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase767ActorState {
															#line 12974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase767ActorState(UnitTestParameters const& params) 
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 12981 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase767", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase767ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase767", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 768 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testClear<LocalConfigEnvironment>(params);
															#line 768 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase767Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase767Actor*>(this)->actor_wait_state = 1;
															#line 768 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase767Actor, 0, Void >*>(static_cast<FlowTestCase767Actor*>(this)));
															#line 13003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase767ActorState();
		static_cast<FlowTestCase767Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 769 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase767Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase767ActorState(); static_cast<FlowTestCase767Actor*>(this)->destroy(); return 0; }
															#line 13026 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase767Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase767ActorState();
		static_cast<FlowTestCase767Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 769 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase767Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase767ActorState(); static_cast<FlowTestCase767Actor*>(this)->destroy(); return 0; }
															#line 13038 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase767Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase767ActorState();
		static_cast<FlowTestCase767Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase767Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase767Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase767Actor*>(this)->ActorCallback< FlowTestCase767Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase767Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase767", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase767Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase767", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase767Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase767", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase767Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase767", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase767Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase767", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase767Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase767", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 13123 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase767()
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase767Actor final : public Actor<Void>, public ActorCallback< FlowTestCase767Actor, 0, Void >, public FastAllocated<FlowTestCase767Actor>, public FlowTestCase767ActorState<FlowTestCase767Actor> {
															#line 13128 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase767Actor>::operator new;
	using FastAllocated<FlowTestCase767Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13309058001992335360UL, 11796465842467257088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase767Actor, 0, Void >;
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase767Actor(UnitTestParameters const& params) 
															#line 13145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase767ActorState<FlowTestCase767Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase767", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18231450268876123904UL, 6519666288237989888UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase767Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase767");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase767", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase767Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase767( UnitTestParameters const& params ) {
															#line 767 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase767Actor(params));
															#line 13178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase767, "/fdbserver/ConfigDB/LocalConfiguration/Clear")

#line 771 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 13184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase772()
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase772Actor>
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase772ActorState {
															#line 13191 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase772ActorState(UnitTestParameters const& params) 
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 13198 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase772", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase772ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase772", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 773 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testAtomicClear<LocalConfigEnvironment>(params);
															#line 773 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase772Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase772Actor*>(this)->actor_wait_state = 1;
															#line 773 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase772Actor, 0, Void >*>(static_cast<FlowTestCase772Actor*>(this)));
															#line 13220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase772ActorState();
		static_cast<FlowTestCase772Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 774 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase772Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase772ActorState(); static_cast<FlowTestCase772Actor*>(this)->destroy(); return 0; }
															#line 13243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase772Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase772ActorState();
		static_cast<FlowTestCase772Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 774 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase772Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase772ActorState(); static_cast<FlowTestCase772Actor*>(this)->destroy(); return 0; }
															#line 13255 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase772Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase772ActorState();
		static_cast<FlowTestCase772Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase772Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase772Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase772Actor*>(this)->ActorCallback< FlowTestCase772Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase772Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase772", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase772Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase772", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase772Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase772", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase772Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase772", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase772Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase772", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase772Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase772", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 13340 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase772()
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase772Actor final : public Actor<Void>, public ActorCallback< FlowTestCase772Actor, 0, Void >, public FastAllocated<FlowTestCase772Actor>, public FlowTestCase772ActorState<FlowTestCase772Actor> {
															#line 13345 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase772Actor>::operator new;
	using FastAllocated<FlowTestCase772Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11972945962994924544UL, 5388631467676029952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase772Actor, 0, Void >;
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase772Actor(UnitTestParameters const& params) 
															#line 13362 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase772ActorState<FlowTestCase772Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase772", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16895822603116443648UL, 1449014843031460864UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase772Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase772");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase772", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase772Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase772( UnitTestParameters const& params ) {
															#line 772 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase772Actor(params));
															#line 13395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase772, "/fdbserver/ConfigDB/LocalConfiguration/AtomicClear")

#line 776 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 13401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase777()
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase777Actor>
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase777ActorState {
															#line 13408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase777ActorState(UnitTestParameters const& params) 
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 13415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase777", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase777ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase777", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 778 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testGlobalSet<LocalConfigEnvironment>(params);
															#line 778 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase777Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13432 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase777Actor*>(this)->actor_wait_state = 1;
															#line 778 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase777Actor, 0, Void >*>(static_cast<FlowTestCase777Actor*>(this)));
															#line 13437 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase777ActorState();
		static_cast<FlowTestCase777Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 779 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase777Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase777ActorState(); static_cast<FlowTestCase777Actor*>(this)->destroy(); return 0; }
															#line 13460 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase777Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase777ActorState();
		static_cast<FlowTestCase777Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 779 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase777Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase777ActorState(); static_cast<FlowTestCase777Actor*>(this)->destroy(); return 0; }
															#line 13472 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase777Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase777ActorState();
		static_cast<FlowTestCase777Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase777Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase777Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase777Actor*>(this)->ActorCallback< FlowTestCase777Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase777Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase777", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase777Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase777", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase777Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase777", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase777Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase777", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase777Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase777", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase777Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase777", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 13557 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase777()
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase777Actor final : public Actor<Void>, public ActorCallback< FlowTestCase777Actor, 0, Void >, public FastAllocated<FlowTestCase777Actor>, public FlowTestCase777ActorState<FlowTestCase777Actor> {
															#line 13562 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase777Actor>::operator new;
	using FastAllocated<FlowTestCase777Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9350270341735868160UL, 11570459551584606464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase777Actor, 0, Void >;
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase777Actor(UnitTestParameters const& params) 
															#line 13579 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase777ActorState<FlowTestCase777Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase777", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18242124149915043840UL, 12944090212235094528UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase777Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase777");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase777", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase777Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase777( UnitTestParameters const& params ) {
															#line 777 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase777Actor(params));
															#line 13612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase777, "/fdbserver/ConfigDB/LocalConfiguration/GlobalSet")

#line 781 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 13618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase782()
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase782Actor>
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase782ActorState {
															#line 13625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase782ActorState(UnitTestParameters const& params) 
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A/class-B", {})
															#line 13634 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase782", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase782ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase782", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr, "class-B"_sr }));
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13651 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 1;
															#line 784 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase782Actor, 0, Void >*>(static_cast<FlowTestCase782Actor*>(this)));
															#line 13656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase782ActorState();
		static_cast<FlowTestCase782Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13681 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 2;
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase782Actor, 1, Void >*>(static_cast<FlowTestCase782Actor*>(this)));
															#line 13686 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 2;
															#line 785 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase782Actor, 1, Void >*>(static_cast<FlowTestCase782Actor*>(this)));
															#line 13702 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase782Actor*>(this)->ActorCallback< FlowTestCase782Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase782Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase782Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase782Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 10 });
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13788 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 3;
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase782Actor, 2, Void >*>(static_cast<FlowTestCase782Actor*>(this)));
															#line 13793 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = set(env, "class-B"_sr, "test_long"_sr, int64_t{ 10 });
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 3;
															#line 786 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase782Actor, 2, Void >*>(static_cast<FlowTestCase782Actor*>(this)));
															#line 13809 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase782Actor*>(this)->ActorCallback< FlowTestCase782Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase782Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase782Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase782Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 787 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.check(&TestKnobs::TEST_LONG, Optional<int64_t>{ 10 });
															#line 788 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase782Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase782ActorState(); static_cast<FlowTestCase782Actor*>(this)->destroy(); return 0; }
															#line 13895 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase782Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase782ActorState();
		static_cast<FlowTestCase782Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 787 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.check(&TestKnobs::TEST_LONG, Optional<int64_t>{ 10 });
															#line 788 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase782Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase782ActorState(); static_cast<FlowTestCase782Actor*>(this)->destroy(); return 0; }
															#line 13909 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase782Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase782ActorState();
		static_cast<FlowTestCase782Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase782Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase782Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase782Actor*>(this)->ActorCallback< FlowTestCase782Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase782Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase782Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase782Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 783 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	LocalConfigEnvironment env;
															#line 13996 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase782()
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase782Actor final : public Actor<Void>, public ActorCallback< FlowTestCase782Actor, 0, Void >, public ActorCallback< FlowTestCase782Actor, 1, Void >, public ActorCallback< FlowTestCase782Actor, 2, Void >, public FastAllocated<FlowTestCase782Actor>, public FlowTestCase782ActorState<FlowTestCase782Actor> {
															#line 14001 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase782Actor>::operator new;
	using FastAllocated<FlowTestCase782Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2644080971960111872UL, 7550916882043881472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase782Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase782Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase782Actor, 2, Void >;
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase782Actor(UnitTestParameters const& params) 
															#line 14020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase782ActorState<FlowTestCase782Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase782", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4906213447740594688UL, 1152581318116959744UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase782Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase782");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase782", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase782Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase782Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase782Actor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase782( UnitTestParameters const& params ) {
															#line 782 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase782Actor(params));
															#line 14055 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase782, "/fdbserver/ConfigDB/LocalConfiguration/ConflictingOverrides")

#line 790 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 14061 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase791()
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase791Actor>
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase791ActorState {
															#line 14068 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase791ActorState(UnitTestParameters const& params) 
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A", { { "test_long", "1000" } })
															#line 14077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase791", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase791ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase791", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 793 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 793 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase791Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14094 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase791Actor*>(this)->actor_wait_state = 1;
															#line 793 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase791Actor, 0, Void >*>(static_cast<FlowTestCase791Actor*>(this)));
															#line 14099 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase791ActorState();
		static_cast<FlowTestCase791Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase791Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14124 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase791Actor*>(this)->actor_wait_state = 2;
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase791Actor, 1, Void >*>(static_cast<FlowTestCase791Actor*>(this)));
															#line 14129 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase791Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14140 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase791Actor*>(this)->actor_wait_state = 2;
															#line 794 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase791Actor, 1, Void >*>(static_cast<FlowTestCase791Actor*>(this)));
															#line 14145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase791Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase791Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase791Actor*>(this)->ActorCallback< FlowTestCase791Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase791Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase791", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase791Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase791", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase791Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase791", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase791Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase791", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase791Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase791", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase791Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase791", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.check(&TestKnobs::TEST_LONG, Optional<int64_t>{ 1000 });
															#line 796 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase791Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase791ActorState(); static_cast<FlowTestCase791Actor*>(this)->destroy(); return 0; }
															#line 14231 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase791Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase791ActorState();
		static_cast<FlowTestCase791Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 795 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.check(&TestKnobs::TEST_LONG, Optional<int64_t>{ 1000 });
															#line 796 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase791Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase791ActorState(); static_cast<FlowTestCase791Actor*>(this)->destroy(); return 0; }
															#line 14245 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase791Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase791ActorState();
		static_cast<FlowTestCase791Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase791Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase791Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase791Actor*>(this)->ActorCallback< FlowTestCase791Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase791Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase791", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase791Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase791", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase791Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase791", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase791Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase791", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase791Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase791", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase791Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase791", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 792 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	LocalConfigEnvironment env;
															#line 14332 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase791()
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase791Actor final : public Actor<Void>, public ActorCallback< FlowTestCase791Actor, 0, Void >, public ActorCallback< FlowTestCase791Actor, 1, Void >, public FastAllocated<FlowTestCase791Actor>, public FlowTestCase791ActorState<FlowTestCase791Actor> {
															#line 14337 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase791Actor>::operator new;
	using FastAllocated<FlowTestCase791Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1643521248866867456UL, 3651485878589185792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase791Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase791Actor, 1, Void >;
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase791Actor(UnitTestParameters const& params) 
															#line 14355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase791ActorState<FlowTestCase791Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase791", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2371028010060527616UL, 10283755369829652480UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase791Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase791");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase791", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase791Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase791Actor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase791( UnitTestParameters const& params ) {
															#line 791 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase791Actor(params));
															#line 14389 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase791, "/fdbserver/ConfigDB/LocalConfiguration/Manual")

#line 798 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 14395 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase799()
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase799Actor>
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase799ActorState {
															#line 14402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase799ActorState(UnitTestParameters const& params) 
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 14409 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase799", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase799ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase799", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 800 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testSet<BroadcasterToLocalConfigEnvironment>(params);
															#line 800 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase799Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14426 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase799Actor*>(this)->actor_wait_state = 1;
															#line 800 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase799Actor, 0, Void >*>(static_cast<FlowTestCase799Actor*>(this)));
															#line 14431 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase799ActorState();
		static_cast<FlowTestCase799Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 801 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase799Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase799ActorState(); static_cast<FlowTestCase799Actor*>(this)->destroy(); return 0; }
															#line 14454 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase799Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase799ActorState();
		static_cast<FlowTestCase799Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 801 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase799Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase799ActorState(); static_cast<FlowTestCase799Actor*>(this)->destroy(); return 0; }
															#line 14466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase799Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase799ActorState();
		static_cast<FlowTestCase799Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase799Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase799Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase799Actor*>(this)->ActorCallback< FlowTestCase799Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase799Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase799", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase799Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase799", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase799Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase799", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase799Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase799", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase799Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase799", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase799Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase799", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 14551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase799()
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase799Actor final : public Actor<Void>, public ActorCallback< FlowTestCase799Actor, 0, Void >, public FastAllocated<FlowTestCase799Actor>, public FlowTestCase799ActorState<FlowTestCase799Actor> {
															#line 14556 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase799Actor>::operator new;
	using FastAllocated<FlowTestCase799Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8065228106213553664UL, 15040762135603011328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase799Actor, 0, Void >;
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase799Actor(UnitTestParameters const& params) 
															#line 14573 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase799ActorState<FlowTestCase799Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase799", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6884708122001271552UL, 1784450062992275968UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase799Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase799");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase799", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase799Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase799( UnitTestParameters const& params ) {
															#line 799 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase799Actor(params));
															#line 14606 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase799, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/Set")

#line 803 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 14612 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase804()
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase804Actor>
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase804ActorState {
															#line 14619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase804ActorState(UnitTestParameters const& params) 
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 14626 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase804", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase804ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase804", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 805 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testClear<BroadcasterToLocalConfigEnvironment>(params);
															#line 805 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase804Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14643 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase804Actor*>(this)->actor_wait_state = 1;
															#line 805 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase804Actor, 0, Void >*>(static_cast<FlowTestCase804Actor*>(this)));
															#line 14648 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase804ActorState();
		static_cast<FlowTestCase804Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 806 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase804Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase804ActorState(); static_cast<FlowTestCase804Actor*>(this)->destroy(); return 0; }
															#line 14671 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase804Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase804ActorState();
		static_cast<FlowTestCase804Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 806 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase804Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase804ActorState(); static_cast<FlowTestCase804Actor*>(this)->destroy(); return 0; }
															#line 14683 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase804Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase804ActorState();
		static_cast<FlowTestCase804Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase804Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase804Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase804Actor*>(this)->ActorCallback< FlowTestCase804Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase804Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase804", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase804Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase804", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase804Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase804", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase804Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase804", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase804Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase804", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase804Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase804", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 14768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase804()
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase804Actor final : public Actor<Void>, public ActorCallback< FlowTestCase804Actor, 0, Void >, public FastAllocated<FlowTestCase804Actor>, public FlowTestCase804ActorState<FlowTestCase804Actor> {
															#line 14773 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase804Actor>::operator new;
	using FastAllocated<FlowTestCase804Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16066288220571868672UL, 18156614781012269568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase804Actor, 0, Void >;
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase804Actor(UnitTestParameters const& params) 
															#line 14790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase804ActorState<FlowTestCase804Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase804", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3862436700962537472UL, 18189525332794863872UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase804Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase804");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase804", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase804Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase804( UnitTestParameters const& params ) {
															#line 804 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase804Actor(params));
															#line 14823 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase804, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/Clear")

#line 808 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 14829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase809()
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase809Actor>
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase809ActorState {
															#line 14836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase809ActorState(UnitTestParameters const& params) 
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 14843 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase809", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase809ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase809", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 810 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testIgnore<BroadcasterToLocalConfigEnvironment>(params);
															#line 810 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase809Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 14860 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase809Actor*>(this)->actor_wait_state = 1;
															#line 810 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase809Actor, 0, Void >*>(static_cast<FlowTestCase809Actor*>(this)));
															#line 14865 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase809ActorState();
		static_cast<FlowTestCase809Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 811 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase809Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase809ActorState(); static_cast<FlowTestCase809Actor*>(this)->destroy(); return 0; }
															#line 14888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase809Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase809ActorState();
		static_cast<FlowTestCase809Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 811 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase809Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase809ActorState(); static_cast<FlowTestCase809Actor*>(this)->destroy(); return 0; }
															#line 14900 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase809Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase809ActorState();
		static_cast<FlowTestCase809Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase809Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase809Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase809Actor*>(this)->ActorCallback< FlowTestCase809Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase809Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase809", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase809Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase809", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase809Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase809", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase809Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase809", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase809Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase809", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase809Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase809", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 14985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase809()
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase809Actor final : public Actor<Void>, public ActorCallback< FlowTestCase809Actor, 0, Void >, public FastAllocated<FlowTestCase809Actor>, public FlowTestCase809ActorState<FlowTestCase809Actor> {
															#line 14990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase809Actor>::operator new;
	using FastAllocated<FlowTestCase809Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14877067202370850560UL, 7137801243232497152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase809Actor, 0, Void >;
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase809Actor(UnitTestParameters const& params) 
															#line 15007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase809ActorState<FlowTestCase809Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase809", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13616089986071807744UL, 10214954890626679296UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase809Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase809");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase809", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase809Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase809( UnitTestParameters const& params ) {
															#line 809 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase809Actor(params));
															#line 15040 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase809, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/Ignore")

#line 813 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 15046 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase814()
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase814Actor>
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase814ActorState {
															#line 15053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase814ActorState(UnitTestParameters const& params) 
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 15060 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase814", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase814ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase814", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testGlobalSet<BroadcasterToLocalConfigEnvironment>(params);
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase814Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15077 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase814Actor*>(this)->actor_wait_state = 1;
															#line 815 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase814Actor, 0, Void >*>(static_cast<FlowTestCase814Actor*>(this)));
															#line 15082 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase814ActorState();
		static_cast<FlowTestCase814Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 816 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase814Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase814ActorState(); static_cast<FlowTestCase814Actor*>(this)->destroy(); return 0; }
															#line 15105 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase814Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase814ActorState();
		static_cast<FlowTestCase814Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 816 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase814Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase814ActorState(); static_cast<FlowTestCase814Actor*>(this)->destroy(); return 0; }
															#line 15117 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase814Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase814ActorState();
		static_cast<FlowTestCase814Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase814Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase814Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase814Actor*>(this)->ActorCallback< FlowTestCase814Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase814Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase814", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase814Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase814", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase814Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase814", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase814Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase814", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase814Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase814", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase814Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase814", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 15202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase814()
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase814Actor final : public Actor<Void>, public ActorCallback< FlowTestCase814Actor, 0, Void >, public FastAllocated<FlowTestCase814Actor>, public FlowTestCase814ActorState<FlowTestCase814Actor> {
															#line 15207 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase814Actor>::operator new;
	using FastAllocated<FlowTestCase814Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14009304449708175616UL, 10128282317356935168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase814Actor, 0, Void >;
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase814Actor(UnitTestParameters const& params) 
															#line 15224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase814ActorState<FlowTestCase814Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase814", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(521958722407560192UL, 9662297343416479488UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase814Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase814");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase814", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase814Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase814( UnitTestParameters const& params ) {
															#line 814 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase814Actor(params));
															#line 15257 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase814, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/GlobalSet")

#line 818 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 15263 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase819()
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase819Actor>
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase819ActorState {
															#line 15270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase819ActorState(UnitTestParameters const& params) 
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 15277 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase819", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase819ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase819", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testChangeBroadcaster<BroadcasterToLocalConfigEnvironment>(params);
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase819Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15294 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase819Actor*>(this)->actor_wait_state = 1;
															#line 820 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase819Actor, 0, Void >*>(static_cast<FlowTestCase819Actor*>(this)));
															#line 15299 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase819ActorState();
		static_cast<FlowTestCase819Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 821 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase819Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase819ActorState(); static_cast<FlowTestCase819Actor*>(this)->destroy(); return 0; }
															#line 15322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase819Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase819ActorState();
		static_cast<FlowTestCase819Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 821 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase819Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase819ActorState(); static_cast<FlowTestCase819Actor*>(this)->destroy(); return 0; }
															#line 15334 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase819Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase819ActorState();
		static_cast<FlowTestCase819Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase819Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase819Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase819Actor*>(this)->ActorCallback< FlowTestCase819Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase819Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase819", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase819Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase819", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase819Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase819", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase819Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase819", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase819Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase819", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase819Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase819", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 15419 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase819()
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase819Actor final : public Actor<Void>, public ActorCallback< FlowTestCase819Actor, 0, Void >, public FastAllocated<FlowTestCase819Actor>, public FlowTestCase819ActorState<FlowTestCase819Actor> {
															#line 15424 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase819Actor>::operator new;
	using FastAllocated<FlowTestCase819Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7740717550329364480UL, 17101926286229231104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase819Actor, 0, Void >;
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase819Actor(UnitTestParameters const& params) 
															#line 15441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase819ActorState<FlowTestCase819Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase819", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14117879735483337984UL, 2931431795118776832UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase819Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase819");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase819", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase819Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase819( UnitTestParameters const& params ) {
															#line 819 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase819Actor(params));
															#line 15474 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase819, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/ChangeBroadcaster")

#line 823 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 15480 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase824()
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase824Actor>
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase824ActorState {
															#line 15487 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase824ActorState(UnitTestParameters const& params) 
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 15494 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase824", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase824ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase824", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testRestartLocalConfig<BroadcasterToLocalConfigEnvironment>(params);
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase824Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15511 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase824Actor*>(this)->actor_wait_state = 1;
															#line 825 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase824Actor, 0, Void >*>(static_cast<FlowTestCase824Actor*>(this)));
															#line 15516 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase824ActorState();
		static_cast<FlowTestCase824Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 826 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase824Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase824ActorState(); static_cast<FlowTestCase824Actor*>(this)->destroy(); return 0; }
															#line 15539 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase824Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase824ActorState();
		static_cast<FlowTestCase824Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 826 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase824Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase824ActorState(); static_cast<FlowTestCase824Actor*>(this)->destroy(); return 0; }
															#line 15551 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase824Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase824ActorState();
		static_cast<FlowTestCase824Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase824Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase824Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase824Actor*>(this)->ActorCallback< FlowTestCase824Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase824Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase824", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase824Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase824", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase824Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase824", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase824Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase824", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase824Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase824", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase824Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase824", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 15636 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase824()
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase824Actor final : public Actor<Void>, public ActorCallback< FlowTestCase824Actor, 0, Void >, public FastAllocated<FlowTestCase824Actor>, public FlowTestCase824ActorState<FlowTestCase824Actor> {
															#line 15641 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase824Actor>::operator new;
	using FastAllocated<FlowTestCase824Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2459034831393436928UL, 2608901303580135936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase824Actor, 0, Void >;
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase824Actor(UnitTestParameters const& params) 
															#line 15658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase824ActorState<FlowTestCase824Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase824", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10781417912220723456UL, 1708651621433870848UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase824Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase824");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase824", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase824Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase824( UnitTestParameters const& params ) {
															#line 824 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase824Actor(params));
															#line 15691 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase824, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/RestartLocalConfig")

#line 828 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 15697 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase829()
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase829Actor>
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase829ActorState {
															#line 15704 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase829ActorState(UnitTestParameters const& params) 
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 15711 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase829", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase829ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase829", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testRestartLocalConfigAndChangeClass<BroadcasterToLocalConfigEnvironment>(params);
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase829Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15728 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase829Actor*>(this)->actor_wait_state = 1;
															#line 830 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase829Actor, 0, Void >*>(static_cast<FlowTestCase829Actor*>(this)));
															#line 15733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase829ActorState();
		static_cast<FlowTestCase829Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 831 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase829Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase829ActorState(); static_cast<FlowTestCase829Actor*>(this)->destroy(); return 0; }
															#line 15756 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase829Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase829ActorState();
		static_cast<FlowTestCase829Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 831 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase829Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase829ActorState(); static_cast<FlowTestCase829Actor*>(this)->destroy(); return 0; }
															#line 15768 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase829Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase829ActorState();
		static_cast<FlowTestCase829Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase829Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase829Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase829Actor*>(this)->ActorCallback< FlowTestCase829Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase829Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase829", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase829Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase829", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase829Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase829", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase829Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase829", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase829Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase829", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase829Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase829", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 15853 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase829()
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase829Actor final : public Actor<Void>, public ActorCallback< FlowTestCase829Actor, 0, Void >, public FastAllocated<FlowTestCase829Actor>, public FlowTestCase829ActorState<FlowTestCase829Actor> {
															#line 15858 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase829Actor>::operator new;
	using FastAllocated<FlowTestCase829Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17416388303841436672UL, 9072431536185175808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase829Actor, 0, Void >;
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase829Actor(UnitTestParameters const& params) 
															#line 15875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase829ActorState<FlowTestCase829Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase829", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6821780616658211840UL, 3970267137474583040UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase829Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase829");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase829", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase829Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase829( UnitTestParameters const& params ) {
															#line 829 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase829Actor(params));
															#line 15908 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase829, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/RestartLocalConfigAndChangeClass")

#line 833 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 15914 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase834()
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase834Actor>
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase834ActorState {
															#line 15921 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase834ActorState(UnitTestParameters const& params) 
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 15928 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase834", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase834ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase834", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testCompact<BroadcasterToLocalConfigEnvironment>(params);
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase834Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15945 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase834Actor*>(this)->actor_wait_state = 1;
															#line 835 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase834Actor, 0, Void >*>(static_cast<FlowTestCase834Actor*>(this)));
															#line 15950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase834ActorState();
		static_cast<FlowTestCase834Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase834Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase834ActorState(); static_cast<FlowTestCase834Actor*>(this)->destroy(); return 0; }
															#line 15973 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase834Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase834ActorState();
		static_cast<FlowTestCase834Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 836 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase834Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase834ActorState(); static_cast<FlowTestCase834Actor*>(this)->destroy(); return 0; }
															#line 15985 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase834Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase834ActorState();
		static_cast<FlowTestCase834Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase834Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase834Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase834Actor*>(this)->ActorCallback< FlowTestCase834Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase834Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase834", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase834Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase834", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase834Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase834", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase834Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase834", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase834Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase834", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase834Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase834", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 16070 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase834()
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase834Actor final : public Actor<Void>, public ActorCallback< FlowTestCase834Actor, 0, Void >, public FastAllocated<FlowTestCase834Actor>, public FlowTestCase834ActorState<FlowTestCase834Actor> {
															#line 16075 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase834Actor>::operator new;
	using FastAllocated<FlowTestCase834Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6617017162654243584UL, 12217955261125233152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase834Actor, 0, Void >;
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase834Actor(UnitTestParameters const& params) 
															#line 16092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase834ActorState<FlowTestCase834Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase834", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1345484310959859712UL, 16323488030012064000UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase834Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase834");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase834", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase834Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase834( UnitTestParameters const& params ) {
															#line 834 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase834Actor(params));
															#line 16125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase834, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/Compact")

#line 838 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 16131 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase839()
															#line 839 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase839Actor>
															#line 839 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase839ActorState {
															#line 16138 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 839 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase839ActorState(UnitTestParameters const& params) 
															#line 839 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 839 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 16145 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase839", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase839ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase839", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 840 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<std::string> __when_expr_0 = testNewLocalConfigAfterCompaction<BroadcasterToLocalConfigEnvironment>(params);
															#line 840 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase839Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16162 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase839Actor*>(this)->actor_wait_state = 1;
															#line 840 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase839Actor, 0, std::string >*>(static_cast<FlowTestCase839Actor*>(this)));
															#line 16167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase839ActorState();
		static_cast<FlowTestCase839Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::string const& statusStr,int loopDepth) 
	{
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		json_spirit::mValue status;
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(json_spirit::read_string(statusStr, status));
															#line 843 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(status.type() == json_spirit::obj_type);
															#line 844 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto lastCompacted = status.get_obj().at("last_compacted_version").get_int64();
															#line 845 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(lastCompacted, 1);
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto mostRecent = status.get_obj().at("most_recent_version").get_int64();
															#line 847 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(mostRecent, 2);
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto commits = status.get_obj().at("commits");
															#line 851 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(commits.get_array().size(), 0);
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto mutations = status.get_obj().at("mutations");
															#line 853 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(mutations.get_array().size(), 1);
															#line 854 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto snapshot = status.get_obj().at("snapshot");
															#line 855 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto classA = snapshot.get_obj().at("class-A");
															#line 856 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto value = classA.get_obj().at("test_long").get_str();
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(value == "int64_t:2");
															#line 858 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase839Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase839ActorState(); static_cast<FlowTestCase839Actor*>(this)->destroy(); return 0; }
															#line 16220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase839Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase839ActorState();
		static_cast<FlowTestCase839Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::string && statusStr,int loopDepth) 
	{
															#line 841 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		json_spirit::mValue status;
															#line 842 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(json_spirit::read_string(statusStr, status));
															#line 843 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(status.type() == json_spirit::obj_type);
															#line 844 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto lastCompacted = status.get_obj().at("last_compacted_version").get_int64();
															#line 845 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(lastCompacted, 1);
															#line 846 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto mostRecent = status.get_obj().at("most_recent_version").get_int64();
															#line 847 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(mostRecent, 2);
															#line 848 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto commits = status.get_obj().at("commits");
															#line 851 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(commits.get_array().size(), 0);
															#line 852 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto mutations = status.get_obj().at("mutations");
															#line 853 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT_EQ(mutations.get_array().size(), 1);
															#line 854 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto snapshot = status.get_obj().at("snapshot");
															#line 855 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto classA = snapshot.get_obj().at("class-A");
															#line 856 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		auto value = classA.get_obj().at("test_long").get_str();
															#line 857 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		ASSERT(value == "int64_t:2");
															#line 858 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase839Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase839ActorState(); static_cast<FlowTestCase839Actor*>(this)->destroy(); return 0; }
															#line 16262 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase839Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase839ActorState();
		static_cast<FlowTestCase839Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::string const& statusStr,int loopDepth) 
	{
		loopDepth = a_body1cont1(statusStr, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::string && statusStr,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(statusStr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase839Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase839Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase839Actor*>(this)->ActorCallback< FlowTestCase839Actor, 0, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase839Actor, 0, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("flowTestCase839", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase839Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase839", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase839Actor, 0, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("flowTestCase839", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase839Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase839", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase839Actor, 0, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase839", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase839Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase839", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 839 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 16347 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase839()
															#line 839 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase839Actor final : public Actor<Void>, public ActorCallback< FlowTestCase839Actor, 0, std::string >, public FastAllocated<FlowTestCase839Actor>, public FlowTestCase839ActorState<FlowTestCase839Actor> {
															#line 16352 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase839Actor>::operator new;
	using FastAllocated<FlowTestCase839Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5677854256288169472UL, 1710270859638166272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase839Actor, 0, std::string >;
															#line 839 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase839Actor(UnitTestParameters const& params) 
															#line 16369 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase839ActorState<FlowTestCase839Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase839", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4627828986397525248UL, 16945378095993561600UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase839Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase839");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase839", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase839Actor, 0, std::string >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 839 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase839( UnitTestParameters const& params ) {
															#line 839 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase839Actor(params));
															#line 16402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase839, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/RestartLocalConfigurationAfterCompaction")

#line 860 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 16408 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase861()
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase861Actor>
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase861ActorState {
															#line 16415 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase861ActorState(UnitTestParameters const& params) 
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 16422 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase861", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase861ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase861", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 862 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testKillWorker<BroadcasterToLocalConfigEnvironment>(params);
															#line 862 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase861Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16439 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase861Actor*>(this)->actor_wait_state = 1;
															#line 862 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase861Actor, 0, Void >*>(static_cast<FlowTestCase861Actor*>(this)));
															#line 16444 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase861ActorState();
		static_cast<FlowTestCase861Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 863 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase861Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase861ActorState(); static_cast<FlowTestCase861Actor*>(this)->destroy(); return 0; }
															#line 16467 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase861Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase861ActorState();
		static_cast<FlowTestCase861Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 863 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase861Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase861ActorState(); static_cast<FlowTestCase861Actor*>(this)->destroy(); return 0; }
															#line 16479 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase861Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase861ActorState();
		static_cast<FlowTestCase861Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase861Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase861Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase861Actor*>(this)->ActorCallback< FlowTestCase861Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase861Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase861", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase861Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase861", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase861Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase861", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase861Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase861", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase861Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase861", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase861Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase861", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 16564 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase861()
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase861Actor final : public Actor<Void>, public ActorCallback< FlowTestCase861Actor, 0, Void >, public FastAllocated<FlowTestCase861Actor>, public FlowTestCase861ActorState<FlowTestCase861Actor> {
															#line 16569 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase861Actor>::operator new;
	using FastAllocated<FlowTestCase861Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8893105104260664832UL, 18062150710186490368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase861Actor, 0, Void >;
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase861Actor(UnitTestParameters const& params) 
															#line 16586 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase861ActorState<FlowTestCase861Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase861", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6169393718029663744UL, 10388673295265566720UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase861Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase861");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase861", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase861Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase861( UnitTestParameters const& params ) {
															#line 861 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase861Actor(params));
															#line 16619 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase861, "/fdbserver/ConfigDB/BroadcasterToLocalConfig/KillWorker")

#line 865 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 16625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase866()
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase866Actor>
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase866ActorState {
															#line 16632 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase866ActorState(UnitTestParameters const& params) 
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 16639 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase866", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase866ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase866", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 867 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testSet<TransactionToLocalConfigEnvironment>(params);
															#line 867 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase866Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16656 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase866Actor*>(this)->actor_wait_state = 1;
															#line 867 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase866Actor, 0, Void >*>(static_cast<FlowTestCase866Actor*>(this)));
															#line 16661 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase866ActorState();
		static_cast<FlowTestCase866Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase866Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase866ActorState(); static_cast<FlowTestCase866Actor*>(this)->destroy(); return 0; }
															#line 16684 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase866Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase866ActorState();
		static_cast<FlowTestCase866Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 868 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase866Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase866ActorState(); static_cast<FlowTestCase866Actor*>(this)->destroy(); return 0; }
															#line 16696 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase866Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase866ActorState();
		static_cast<FlowTestCase866Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase866Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase866Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase866Actor*>(this)->ActorCallback< FlowTestCase866Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase866Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase866", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase866Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase866", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase866Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase866", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase866Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase866", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase866Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase866", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase866Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase866", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 16781 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase866()
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase866Actor final : public Actor<Void>, public ActorCallback< FlowTestCase866Actor, 0, Void >, public FastAllocated<FlowTestCase866Actor>, public FlowTestCase866ActorState<FlowTestCase866Actor> {
															#line 16786 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase866Actor>::operator new;
	using FastAllocated<FlowTestCase866Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7810180888720599552UL, 12044397105977773568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase866Actor, 0, Void >;
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase866Actor(UnitTestParameters const& params) 
															#line 16803 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase866ActorState<FlowTestCase866Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase866", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17925566989010165760UL, 9035790778770947072UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase866Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase866");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase866", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase866Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase866( UnitTestParameters const& params ) {
															#line 866 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase866Actor(params));
															#line 16836 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase866, "/fdbserver/ConfigDB/TransactionToLocalConfig/Set")

#line 870 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 16842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase871()
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase871Actor>
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase871ActorState {
															#line 16849 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase871ActorState(UnitTestParameters const& params) 
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 16856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase871", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase871ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase871", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testClear<TransactionToLocalConfigEnvironment>(params);
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase871Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 16873 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase871Actor*>(this)->actor_wait_state = 1;
															#line 872 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase871Actor, 0, Void >*>(static_cast<FlowTestCase871Actor*>(this)));
															#line 16878 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase871ActorState();
		static_cast<FlowTestCase871Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 873 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase871Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase871ActorState(); static_cast<FlowTestCase871Actor*>(this)->destroy(); return 0; }
															#line 16901 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase871Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase871ActorState();
		static_cast<FlowTestCase871Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 873 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase871Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase871ActorState(); static_cast<FlowTestCase871Actor*>(this)->destroy(); return 0; }
															#line 16913 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase871Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase871ActorState();
		static_cast<FlowTestCase871Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase871Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase871Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase871Actor*>(this)->ActorCallback< FlowTestCase871Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase871Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase871", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase871Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase871", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase871Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase871", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase871Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase871", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase871Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase871", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase871Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase871", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 16998 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase871()
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase871Actor final : public Actor<Void>, public ActorCallback< FlowTestCase871Actor, 0, Void >, public FastAllocated<FlowTestCase871Actor>, public FlowTestCase871ActorState<FlowTestCase871Actor> {
															#line 17003 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase871Actor>::operator new;
	using FastAllocated<FlowTestCase871Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15862875448863675392UL, 13776268282158994944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase871Actor, 0, Void >;
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase871Actor(UnitTestParameters const& params) 
															#line 17020 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase871ActorState<FlowTestCase871Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase871", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17853841182963421440UL, 2484044399659509760UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase871Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase871");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase871", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase871Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase871( UnitTestParameters const& params ) {
															#line 871 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase871Actor(params));
															#line 17053 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase871, "/fdbserver/ConfigDB/TransactionToLocalConfig/Clear")

#line 875 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 17059 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase876()
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase876Actor>
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase876ActorState {
															#line 17066 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase876ActorState(UnitTestParameters const& params) 
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 17073 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase876", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase876ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase876", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 877 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testGlobalSet<TransactionToLocalConfigEnvironment>(params);
															#line 877 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase876Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17090 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase876Actor*>(this)->actor_wait_state = 1;
															#line 877 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase876Actor, 0, Void >*>(static_cast<FlowTestCase876Actor*>(this)));
															#line 17095 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase876ActorState();
		static_cast<FlowTestCase876Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 878 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase876Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase876ActorState(); static_cast<FlowTestCase876Actor*>(this)->destroy(); return 0; }
															#line 17118 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase876Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase876ActorState();
		static_cast<FlowTestCase876Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 878 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase876Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase876ActorState(); static_cast<FlowTestCase876Actor*>(this)->destroy(); return 0; }
															#line 17130 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase876Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase876ActorState();
		static_cast<FlowTestCase876Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase876Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase876Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase876Actor*>(this)->ActorCallback< FlowTestCase876Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase876Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase876", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase876Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase876", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase876Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase876", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase876Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase876", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase876Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase876", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase876Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase876", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 17215 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase876()
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase876Actor final : public Actor<Void>, public ActorCallback< FlowTestCase876Actor, 0, Void >, public FastAllocated<FlowTestCase876Actor>, public FlowTestCase876ActorState<FlowTestCase876Actor> {
															#line 17220 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase876Actor>::operator new;
	using FastAllocated<FlowTestCase876Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9100691785421614336UL, 8437782127646171648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase876Actor, 0, Void >;
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase876Actor(UnitTestParameters const& params) 
															#line 17237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase876ActorState<FlowTestCase876Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase876", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11189247337515972352UL, 3506640124560926208UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase876Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase876");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase876", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase876Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase876( UnitTestParameters const& params ) {
															#line 876 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase876Actor(params));
															#line 17270 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase876, "/fdbserver/ConfigDB/TransactionToLocalConfig/GlobalSet")

#line 880 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 17276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase881()
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase881Actor>
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase881ActorState {
															#line 17283 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase881ActorState(UnitTestParameters const& params) 
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 882 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir(), "class-A")
															#line 17292 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase881", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase881ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase881", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 883 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup(ConfigClassSet({ "class-A"_sr }));
															#line 883 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 1;
															#line 883 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase881Actor, 0, Void >*>(static_cast<FlowTestCase881Actor*>(this)));
															#line 17314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase881ActorState();
		static_cast<FlowTestCase881Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17339 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 2;
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase881Actor, 1, Void >*>(static_cast<FlowTestCase881Actor*>(this)));
															#line 17344 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17355 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 2;
															#line 884 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase881Actor, 1, Void >*>(static_cast<FlowTestCase881Actor*>(this)));
															#line 17360 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase881Actor*>(this)->ActorCallback< FlowTestCase881Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase881Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase881Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase881Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 885 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.restartNode();
															#line 886 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 886 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17448 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 3;
															#line 886 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase881Actor, 2, Void >*>(static_cast<FlowTestCase881Actor*>(this)));
															#line 17453 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 885 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.restartNode();
															#line 886 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, &TestKnobs::TEST_LONG, Optional<int64_t>{ 1 });
															#line 886 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17466 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 3;
															#line 886 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase881Actor, 2, Void >*>(static_cast<FlowTestCase881Actor*>(this)));
															#line 17471 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase881Actor*>(this)->ActorCallback< FlowTestCase881Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase881Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase881Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase881Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 887 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase881Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase881ActorState(); static_cast<FlowTestCase881Actor*>(this)->destroy(); return 0; }
															#line 17555 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase881Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase881ActorState();
		static_cast<FlowTestCase881Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 887 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase881Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase881ActorState(); static_cast<FlowTestCase881Actor*>(this)->destroy(); return 0; }
															#line 17567 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase881Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase881ActorState();
		static_cast<FlowTestCase881Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase881Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase881Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase881Actor*>(this)->ActorCallback< FlowTestCase881Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase881Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase881Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase881Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 882 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionToLocalConfigEnvironment env;
															#line 17654 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase881()
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase881Actor final : public Actor<Void>, public ActorCallback< FlowTestCase881Actor, 0, Void >, public ActorCallback< FlowTestCase881Actor, 1, Void >, public ActorCallback< FlowTestCase881Actor, 2, Void >, public FastAllocated<FlowTestCase881Actor>, public FlowTestCase881ActorState<FlowTestCase881Actor> {
															#line 17659 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase881Actor>::operator new;
	using FastAllocated<FlowTestCase881Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(621480673189409280UL, 9376641444988730112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase881Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase881Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase881Actor, 2, Void >;
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase881Actor(UnitTestParameters const& params) 
															#line 17678 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase881ActorState<FlowTestCase881Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase881", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14122163549893164288UL, 17159159028816462080UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase881Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase881");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase881", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase881Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase881Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase881Actor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase881( UnitTestParameters const& params ) {
															#line 881 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase881Actor(params));
															#line 17713 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase881, "/fdbserver/ConfigDB/TransactionToLocalConfig/RestartNode")

#line 889 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 17719 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase890()
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase890Actor>
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase890ActorState {
															#line 17726 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase890ActorState(UnitTestParameters const& params) 
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 17733 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase890", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase890ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase890", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 891 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testChangeBroadcaster<TransactionToLocalConfigEnvironment>(params);
															#line 891 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase890Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17750 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase890Actor*>(this)->actor_wait_state = 1;
															#line 891 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase890Actor, 0, Void >*>(static_cast<FlowTestCase890Actor*>(this)));
															#line 17755 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase890ActorState();
		static_cast<FlowTestCase890Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 892 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase890Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase890ActorState(); static_cast<FlowTestCase890Actor*>(this)->destroy(); return 0; }
															#line 17778 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase890Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase890ActorState();
		static_cast<FlowTestCase890Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 892 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase890Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase890ActorState(); static_cast<FlowTestCase890Actor*>(this)->destroy(); return 0; }
															#line 17790 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase890Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase890ActorState();
		static_cast<FlowTestCase890Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase890Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase890Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase890Actor*>(this)->ActorCallback< FlowTestCase890Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase890Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase890", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase890Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase890", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase890Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase890", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase890Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase890", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase890Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase890", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase890Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase890", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 17875 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase890()
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase890Actor final : public Actor<Void>, public ActorCallback< FlowTestCase890Actor, 0, Void >, public FastAllocated<FlowTestCase890Actor>, public FlowTestCase890ActorState<FlowTestCase890Actor> {
															#line 17880 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase890Actor>::operator new;
	using FastAllocated<FlowTestCase890Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12505074432207032320UL, 5730252713671103744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase890Actor, 0, Void >;
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase890Actor(UnitTestParameters const& params) 
															#line 17897 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase890ActorState<FlowTestCase890Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase890", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2639671460562912000UL, 2843599151296800768UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase890Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase890");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase890", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase890Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase890( UnitTestParameters const& params ) {
															#line 890 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase890Actor(params));
															#line 17930 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase890, "/fdbserver/ConfigDB/TransactionToLocalConfig/ChangeBroadcaster")

#line 894 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 17936 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase895()
															#line 895 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase895Actor>
															#line 895 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase895ActorState {
															#line 17943 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 895 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase895ActorState(UnitTestParameters const& params) 
															#line 895 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 895 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 17950 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase895", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase895ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase895", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 896 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testRestartLocalConfigAndChangeClass<TransactionToLocalConfigEnvironment>(params);
															#line 896 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase895Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 17967 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase895Actor*>(this)->actor_wait_state = 1;
															#line 896 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase895Actor, 0, Void >*>(static_cast<FlowTestCase895Actor*>(this)));
															#line 17972 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase895ActorState();
		static_cast<FlowTestCase895Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 897 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase895Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase895ActorState(); static_cast<FlowTestCase895Actor*>(this)->destroy(); return 0; }
															#line 17995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase895Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase895ActorState();
		static_cast<FlowTestCase895Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 897 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase895Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase895ActorState(); static_cast<FlowTestCase895Actor*>(this)->destroy(); return 0; }
															#line 18007 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase895Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase895ActorState();
		static_cast<FlowTestCase895Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase895Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase895Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase895Actor*>(this)->ActorCallback< FlowTestCase895Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase895Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase895", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase895Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase895", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase895Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase895", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase895Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase895", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase895Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase895", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase895Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase895", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 895 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 18092 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase895()
															#line 895 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase895Actor final : public Actor<Void>, public ActorCallback< FlowTestCase895Actor, 0, Void >, public FastAllocated<FlowTestCase895Actor>, public FlowTestCase895ActorState<FlowTestCase895Actor> {
															#line 18097 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase895Actor>::operator new;
	using FastAllocated<FlowTestCase895Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15664059789412814848UL, 9318686660080828160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase895Actor, 0, Void >;
															#line 895 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase895Actor(UnitTestParameters const& params) 
															#line 18114 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase895ActorState<FlowTestCase895Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase895", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17593559860383894272UL, 8807135508474283776UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase895Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase895");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase895", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase895Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 895 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase895( UnitTestParameters const& params ) {
															#line 895 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase895Actor(params));
															#line 18147 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase895, "/fdbserver/ConfigDB/TransactionToLocalConfig/RestartLocalConfigAndChangeClass")

#line 899 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 18153 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase900()
															#line 900 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase900Actor>
															#line 900 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase900ActorState {
															#line 18160 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 900 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase900ActorState(UnitTestParameters const& params) 
															#line 900 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 900 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 18167 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase900", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase900ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase900", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 901 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testCompact<TransactionToLocalConfigEnvironment>(params);
															#line 901 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase900Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18184 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase900Actor*>(this)->actor_wait_state = 1;
															#line 901 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase900Actor, 0, Void >*>(static_cast<FlowTestCase900Actor*>(this)));
															#line 18189 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase900ActorState();
		static_cast<FlowTestCase900Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 902 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase900Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase900ActorState(); static_cast<FlowTestCase900Actor*>(this)->destroy(); return 0; }
															#line 18212 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase900Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase900ActorState();
		static_cast<FlowTestCase900Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 902 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase900Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase900ActorState(); static_cast<FlowTestCase900Actor*>(this)->destroy(); return 0; }
															#line 18224 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase900Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase900ActorState();
		static_cast<FlowTestCase900Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase900Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase900Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase900Actor*>(this)->ActorCallback< FlowTestCase900Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase900Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase900", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase900Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase900", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase900Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase900", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase900Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase900", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase900Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase900", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase900Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase900", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 900 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 18309 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase900()
															#line 900 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase900Actor final : public Actor<Void>, public ActorCallback< FlowTestCase900Actor, 0, Void >, public FastAllocated<FlowTestCase900Actor>, public FlowTestCase900ActorState<FlowTestCase900Actor> {
															#line 18314 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase900Actor>::operator new;
	using FastAllocated<FlowTestCase900Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15996247092611620352UL, 1779056827622504192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase900Actor, 0, Void >;
															#line 900 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase900Actor(UnitTestParameters const& params) 
															#line 18331 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase900ActorState<FlowTestCase900Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase900", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11655958738668928512UL, 9549210905419656960UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase900Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase900");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase900", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase900Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 900 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase900( UnitTestParameters const& params ) {
															#line 900 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase900Actor(params));
															#line 18364 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase900, "/fdbserver/ConfigDB/TransactionToLocalConfig/CompactNode")

#line 904 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 18370 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase905()
															#line 905 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase905Actor>
															#line 905 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase905ActorState {
															#line 18377 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 905 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase905ActorState(UnitTestParameters const& params) 
															#line 905 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 905 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 18384 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase905", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase905ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase905", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(testNewLocalConfigAfterCompaction<TransactionToLocalConfigEnvironment>(params));
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase905Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18401 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase905Actor*>(this)->actor_wait_state = 1;
															#line 909 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase905Actor, 0, Void >*>(static_cast<FlowTestCase905Actor*>(this)));
															#line 18406 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase905ActorState();
		static_cast<FlowTestCase905Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 910 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase905Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase905ActorState(); static_cast<FlowTestCase905Actor*>(this)->destroy(); return 0; }
															#line 18429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase905Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase905ActorState();
		static_cast<FlowTestCase905Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 910 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase905Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase905ActorState(); static_cast<FlowTestCase905Actor*>(this)->destroy(); return 0; }
															#line 18441 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase905Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase905ActorState();
		static_cast<FlowTestCase905Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase905Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase905Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase905Actor*>(this)->ActorCallback< FlowTestCase905Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase905Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase905", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase905Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase905", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase905Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase905", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase905Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase905", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase905Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase905", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase905Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase905", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 905 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 18526 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase905()
															#line 905 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase905Actor final : public Actor<Void>, public ActorCallback< FlowTestCase905Actor, 0, Void >, public FastAllocated<FlowTestCase905Actor>, public FlowTestCase905ActorState<FlowTestCase905Actor> {
															#line 18531 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase905Actor>::operator new;
	using FastAllocated<FlowTestCase905Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15972060200472569344UL, 16581279740699224576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase905Actor, 0, Void >;
															#line 905 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase905Actor(UnitTestParameters const& params) 
															#line 18548 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase905ActorState<FlowTestCase905Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase905", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3588969626550065152UL, 3877870623034724096UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase905Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase905");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase905", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase905Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 905 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase905( UnitTestParameters const& params ) {
															#line 905 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase905Actor(params));
															#line 18581 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase905, "/fdbserver/ConfigDB/TransactionToLocalConfig/RestartLocalConfigurationAfterCompaction")

#line 912 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 18587 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase913()
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase913Actor>
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase913ActorState {
															#line 18594 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase913ActorState(UnitTestParameters const& params) 
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params)
															#line 18601 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase913", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase913ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase913", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = testKillWorker<TransactionToLocalConfigEnvironment>(params);
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase913Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18618 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase913Actor*>(this)->actor_wait_state = 1;
															#line 914 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase913Actor, 0, Void >*>(static_cast<FlowTestCase913Actor*>(this)));
															#line 18623 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase913ActorState();
		static_cast<FlowTestCase913Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 915 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase913Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase913ActorState(); static_cast<FlowTestCase913Actor*>(this)->destroy(); return 0; }
															#line 18646 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase913Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase913ActorState();
		static_cast<FlowTestCase913Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 915 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase913Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase913ActorState(); static_cast<FlowTestCase913Actor*>(this)->destroy(); return 0; }
															#line 18658 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase913Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase913ActorState();
		static_cast<FlowTestCase913Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase913Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase913Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase913Actor*>(this)->ActorCallback< FlowTestCase913Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase913Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase913", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase913Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase913", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase913Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase913", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase913Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase913", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase913Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase913", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase913Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase913", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 18743 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase913()
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase913Actor final : public Actor<Void>, public ActorCallback< FlowTestCase913Actor, 0, Void >, public FastAllocated<FlowTestCase913Actor>, public FlowTestCase913ActorState<FlowTestCase913Actor> {
															#line 18748 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase913Actor>::operator new;
	using FastAllocated<FlowTestCase913Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(638272332255820032UL, 9587965493934612992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase913Actor, 0, Void >;
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase913Actor(UnitTestParameters const& params) 
															#line 18765 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase913ActorState<FlowTestCase913Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase913", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11454068281034455296UL, 15261284531602196480UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase913Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase913");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase913", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase913Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase913( UnitTestParameters const& params ) {
															#line 913 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase913Actor(params));
															#line 18798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase913, "/fdbserver/ConfigDB/TransactionToLocalConfig/KillWorker")

#line 917 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 18804 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase918()
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase918Actor>
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase918ActorState {
															#line 18811 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase918ActorState(UnitTestParameters const& params) 
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir())
															#line 18820 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase918", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase918ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase918", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 920 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup();
															#line 920 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase918Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18837 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase918Actor*>(this)->actor_wait_state = 1;
															#line 920 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase918Actor, 0, Void >*>(static_cast<FlowTestCase918Actor*>(this)));
															#line 18842 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase918ActorState();
		static_cast<FlowTestCase918Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase918Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18867 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase918Actor*>(this)->actor_wait_state = 2;
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase918Actor, 1, Void >*>(static_cast<FlowTestCase918Actor*>(this)));
															#line 18872 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase918Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18883 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase918Actor*>(this)->actor_wait_state = 2;
															#line 921 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase918Actor, 1, Void >*>(static_cast<FlowTestCase918Actor*>(this)));
															#line 18888 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase918Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase918Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase918Actor*>(this)->ActorCallback< FlowTestCase918Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase918Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase918", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase918Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase918", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase918Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase918", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase918Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase918", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase918Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase918", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase918Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase918", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, "class-A"_sr, "test_long"_sr, Optional<int64_t>{ 1 });
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase918Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18974 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase918Actor*>(this)->actor_wait_state = 3;
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase918Actor, 2, Void >*>(static_cast<FlowTestCase918Actor*>(this)));
															#line 18979 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, "class-A"_sr, "test_long"_sr, Optional<int64_t>{ 1 });
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase918Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 18990 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase918Actor*>(this)->actor_wait_state = 3;
															#line 922 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase918Actor, 2, Void >*>(static_cast<FlowTestCase918Actor*>(this)));
															#line 18995 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase918Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase918Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase918Actor*>(this)->ActorCallback< FlowTestCase918Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase918Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase918", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase918Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase918", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase918Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase918", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase918Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase918", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase918Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase918", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase918Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase918", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 923 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase918Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase918ActorState(); static_cast<FlowTestCase918Actor*>(this)->destroy(); return 0; }
															#line 19079 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase918Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase918ActorState();
		static_cast<FlowTestCase918Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 923 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase918Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase918ActorState(); static_cast<FlowTestCase918Actor*>(this)->destroy(); return 0; }
															#line 19091 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase918Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase918ActorState();
		static_cast<FlowTestCase918Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase918Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase918Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase918Actor*>(this)->ActorCallback< FlowTestCase918Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase918Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase918", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase918Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase918", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase918Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase918", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase918Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase918", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase918Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase918", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase918Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase918", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 919 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionEnvironment env;
															#line 19178 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase918()
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase918Actor final : public Actor<Void>, public ActorCallback< FlowTestCase918Actor, 0, Void >, public ActorCallback< FlowTestCase918Actor, 1, Void >, public ActorCallback< FlowTestCase918Actor, 2, Void >, public FastAllocated<FlowTestCase918Actor>, public FlowTestCase918ActorState<FlowTestCase918Actor> {
															#line 19183 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase918Actor>::operator new;
	using FastAllocated<FlowTestCase918Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11406519094465590272UL, 629912252856289536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase918Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase918Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase918Actor, 2, Void >;
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase918Actor(UnitTestParameters const& params) 
															#line 19202 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase918ActorState<FlowTestCase918Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase918", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2639630458079073024UL, 7597953579899244800UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase918Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase918");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase918", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase918Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase918Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase918Actor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase918( UnitTestParameters const& params ) {
															#line 918 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase918Actor(params));
															#line 19237 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase918, "/fdbserver/ConfigDB/Transaction/Set")

#line 925 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 19243 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase926()
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase926Actor>
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase926ActorState {
															#line 19250 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase926ActorState(UnitTestParameters const& params) 
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 927 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir())
															#line 19259 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase926", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase926ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase926", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 928 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = env.setup();
															#line 928 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase926Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19276 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase926Actor*>(this)->actor_wait_state = 1;
															#line 928 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase926Actor, 0, Void >*>(static_cast<FlowTestCase926Actor*>(this)));
															#line 19281 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase926ActorState();
		static_cast<FlowTestCase926Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase926Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19306 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase926Actor*>(this)->actor_wait_state = 2;
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase926Actor, 1, Void >*>(static_cast<FlowTestCase926Actor*>(this)));
															#line 19311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase926Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19322 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase926Actor*>(this)->actor_wait_state = 2;
															#line 929 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase926Actor, 1, Void >*>(static_cast<FlowTestCase926Actor*>(this)));
															#line 19327 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase926Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase926Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase926Actor*>(this)->ActorCallback< FlowTestCase926Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase926Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase926", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase926Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase926", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase926Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase926", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase926Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase926", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase926Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase926", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase926Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase926", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = clear(env, "class-A"_sr, "test_long"_sr);
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase926Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19413 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase926Actor*>(this)->actor_wait_state = 3;
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase926Actor, 2, Void >*>(static_cast<FlowTestCase926Actor*>(this)));
															#line 19418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = clear(env, "class-A"_sr, "test_long"_sr);
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase926Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19429 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase926Actor*>(this)->actor_wait_state = 3;
															#line 930 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase926Actor, 2, Void >*>(static_cast<FlowTestCase926Actor*>(this)));
															#line 19434 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase926Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase926Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase926Actor*>(this)->ActorCallback< FlowTestCase926Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase926Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase926", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase926Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase926", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase926Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase926", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase926Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase926", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase926Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase926", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase926Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase926", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 931 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, "class-A"_sr, "test_long"_sr, Optional<int64_t>{});
															#line 931 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase926Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19520 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase926Actor*>(this)->actor_wait_state = 4;
															#line 931 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase926Actor, 3, Void >*>(static_cast<FlowTestCase926Actor*>(this)));
															#line 19525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 931 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = check(env, "class-A"_sr, "test_long"_sr, Optional<int64_t>{});
															#line 931 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase926Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19536 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase926Actor*>(this)->actor_wait_state = 4;
															#line 931 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase926Actor, 3, Void >*>(static_cast<FlowTestCase926Actor*>(this)));
															#line 19541 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase926Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase926Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase926Actor*>(this)->ActorCallback< FlowTestCase926Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase926Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase926", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase926Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase926", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase926Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase926", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase926Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase926", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase926Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase926", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase926Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase926", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 932 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase926Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase926ActorState(); static_cast<FlowTestCase926Actor*>(this)->destroy(); return 0; }
															#line 19625 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase926Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase926ActorState();
		static_cast<FlowTestCase926Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 932 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase926Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase926ActorState(); static_cast<FlowTestCase926Actor*>(this)->destroy(); return 0; }
															#line 19637 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase926Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase926ActorState();
		static_cast<FlowTestCase926Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase926Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase926Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase926Actor*>(this)->ActorCallback< FlowTestCase926Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase926Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase926", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase926Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase926", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase926Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase926", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase926Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase926", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase926Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase926", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase926Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase926", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 927 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionEnvironment env;
															#line 19724 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase926()
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase926Actor final : public Actor<Void>, public ActorCallback< FlowTestCase926Actor, 0, Void >, public ActorCallback< FlowTestCase926Actor, 1, Void >, public ActorCallback< FlowTestCase926Actor, 2, Void >, public ActorCallback< FlowTestCase926Actor, 3, Void >, public FastAllocated<FlowTestCase926Actor>, public FlowTestCase926ActorState<FlowTestCase926Actor> {
															#line 19729 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase926Actor>::operator new;
	using FastAllocated<FlowTestCase926Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10716532690282207744UL, 9182532755533716992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase926Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase926Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase926Actor, 2, Void >;
friend struct ActorCallback< FlowTestCase926Actor, 3, Void >;
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase926Actor(UnitTestParameters const& params) 
															#line 19749 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase926ActorState<FlowTestCase926Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase926", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4970240051483620608UL, 18089835065209977344UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase926Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase926");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase926", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase926Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase926Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase926Actor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase926Actor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase926( UnitTestParameters const& params ) {
															#line 926 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase926Actor(params));
															#line 19785 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase926, "/fdbserver/ConfigDB/Transaction/Clear")

#line 934 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 19791 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase935()
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase935Actor>
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase935ActorState {
															#line 19798 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase935ActorState(UnitTestParameters const& params) 
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir())
															#line 19807 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase935", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase935ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase935", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase935Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19824 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase935Actor*>(this)->actor_wait_state = 1;
															#line 937 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase935Actor, 0, Void >*>(static_cast<FlowTestCase935Actor*>(this)));
															#line 19829 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase935ActorState();
		static_cast<FlowTestCase935Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 938 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.restartNode();
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = check(env, "class-A"_sr, "test_long"_sr, Optional<int64_t>{ 1 });
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase935Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19856 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase935Actor*>(this)->actor_wait_state = 2;
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase935Actor, 1, Void >*>(static_cast<FlowTestCase935Actor*>(this)));
															#line 19861 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 938 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		env.restartNode();
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = check(env, "class-A"_sr, "test_long"_sr, Optional<int64_t>{ 1 });
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase935Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 19874 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase935Actor*>(this)->actor_wait_state = 2;
															#line 939 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase935Actor, 1, Void >*>(static_cast<FlowTestCase935Actor*>(this)));
															#line 19879 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase935Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase935Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase935Actor*>(this)->ActorCallback< FlowTestCase935Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase935Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase935", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase935Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase935", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase935Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase935", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase935Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase935", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase935Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase935", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase935Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase935", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 940 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase935Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase935ActorState(); static_cast<FlowTestCase935Actor*>(this)->destroy(); return 0; }
															#line 19963 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase935Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase935ActorState();
		static_cast<FlowTestCase935Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 940 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (!static_cast<FlowTestCase935Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase935ActorState(); static_cast<FlowTestCase935Actor*>(this)->destroy(); return 0; }
															#line 19975 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase935Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase935ActorState();
		static_cast<FlowTestCase935Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase935Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase935Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase935Actor*>(this)->ActorCallback< FlowTestCase935Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase935Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase935", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase935Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase935", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase935Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase935", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase935Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase935", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase935Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase935", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase935Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase935", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	UnitTestParameters params;
															#line 936 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	TransactionEnvironment env;
															#line 20062 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase935()
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase935Actor final : public Actor<Void>, public ActorCallback< FlowTestCase935Actor, 0, Void >, public ActorCallback< FlowTestCase935Actor, 1, Void >, public FastAllocated<FlowTestCase935Actor>, public FlowTestCase935ActorState<FlowTestCase935Actor> {
															#line 20067 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase935Actor>::operator new;
	using FastAllocated<FlowTestCase935Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11356427776584934400UL, 11697625270223228672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase935Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase935Actor, 1, Void >;
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase935Actor(UnitTestParameters const& params) 
															#line 20085 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase935ActorState<FlowTestCase935Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase935", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9611596119505011968UL, 16020517894938966272UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase935Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase935");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase935", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase935Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase935Actor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
static Future<Void> flowTestCase935( UnitTestParameters const& params ) {
															#line 935 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase935Actor(params));
															#line 20119 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase935, "/fdbserver/ConfigDB/Transaction/Restart")

#line 942 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"

															#line 20125 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase943()
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
template <class FlowTestCase943Actor>
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
class FlowTestCase943ActorState {
															#line 20132 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
public:
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
	FlowTestCase943ActorState(UnitTestParameters const& params) 
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
															#line 943 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		 : params(params),
															#line 944 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		   env(params.getDataDir())
															#line 20141 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase943", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase943ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase943", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 945 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 1 });
															#line 945 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			if (static_cast<FlowTestCase943Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 20158 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase943Actor*>(this)->actor_wait_state = 1;
															#line 945 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase943Actor, 0, Void >*>(static_cast<FlowTestCase943Actor*>(this)));
															#line 20163 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase943ActorState();
		static_cast<FlowTestCase943Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = compact(env);
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase943Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 20188 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase943Actor*>(this)->actor_wait_state = 2;
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase943Actor, 1, Void >*>(static_cast<FlowTestCase943Actor*>(this)));
															#line 20193 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_1 = compact(env);
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase943Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 20204 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase943Actor*>(this)->actor_wait_state = 2;
															#line 946 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase943Actor, 1, Void >*>(static_cast<FlowTestCase943Actor*>(this)));
															#line 20209 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase943Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase943Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase943Actor*>(this)->ActorCallback< FlowTestCase943Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase943Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase943", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase943Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase943", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase943Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase943", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase943Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase943", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase943Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase943", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase943Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase943", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 947 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, "class-A"_sr, "test_long"_sr, Optional<int64_t>{ 1 });
															#line 947 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase943Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 20295 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase943Actor*>(this)->actor_wait_state = 3;
															#line 947 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase943Actor, 2, Void >*>(static_cast<FlowTestCase943Actor*>(this)));
															#line 20300 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 947 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_2 = check(env, "class-A"_sr, "test_long"_sr, Optional<int64_t>{ 1 });
															#line 947 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase943Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 20311 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlowTestCase943Actor*>(this)->actor_wait_state = 3;
															#line 947 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase943Actor, 2, Void >*>(static_cast<FlowTestCase943Actor*>(this)));
															#line 20316 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase943Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase943Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase943Actor*>(this)->ActorCallback< FlowTestCase943Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase943Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase943", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase943Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase943", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase943Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase943", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase943Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase943", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase943Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase943", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase943Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase943", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 2 });
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase943Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 20402 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase943Actor*>(this)->actor_wait_state = 4;
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase943Actor, 3, Void >*>(static_cast<FlowTestCase943Actor*>(this)));
															#line 20407 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_3 = set(env, "class-A"_sr, "test_long"_sr, int64_t{ 2 });
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase943Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 20418 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase943Actor*>(this)->actor_wait_state = 4;
															#line 948 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase943Actor, 3, Void >*>(static_cast<FlowTestCase943Actor*>(this)));
															#line 20423 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase943Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase943Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase943Actor*>(this)->ActorCallback< FlowTestCase943Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase943Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase943", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase943Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase943", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase943Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase943", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase943Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase943", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase943Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase943", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase943Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase943", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, "class-A"_sr, "test_long"_sr, Optional<int64_t>{ 2 });
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase943Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 20509 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase943Actor*>(this)->actor_wait_state = 5;
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase943Actor, 4, Void >*>(static_cast<FlowTestCase943Actor*>(this)));
															#line 20514 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		StrictFuture<Void> __when_expr_4 = check(env, "class-A"_sr, "test_long"_sr, Optional<int64_t>{ 2 });
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		if (static_cast<FlowTestCase943Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 20525 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase943Actor*>(this)->actor_wait_state = 5;
															#line 949 "/Users/ec2-user/foundationdb/fdbserver/ConfigDatabaseUnitTests.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase943Actor, 4, Void >*>(static_cast<FlowTestCase943Actor*>(this)));
															#line 20530 "/Users/ec2-user/foundationdb_build_output_macos_arm64/fdbserver/ConfigDatabaseUnitTests.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase943Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase943Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase943Actor*>(this)->ActorCallback< FlowTestCase943Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase943Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase943", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase943Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase943", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase943Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase943", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase943Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& erro